// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon DevOps Guru
///
/// Client for invoking operations on Amazon DevOps Guru. Each operation on Amazon DevOps Guru is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_devopsguru::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_devopsguru::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_devopsguru::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddNotificationChannel` operation.
    ///
    /// See [`AddNotificationChannel`](crate::client::fluent_builders::AddNotificationChannel) for more information about the
    /// operation and its arguments.
    pub fn add_notification_channel(&self) -> fluent_builders::AddNotificationChannel<C, M, R> {
        fluent_builders::AddNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountHealth` operation.
    ///
    /// See [`DescribeAccountHealth`](crate::client::fluent_builders::DescribeAccountHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_account_health(&self) -> fluent_builders::DescribeAccountHealth<C, M, R> {
        fluent_builders::DescribeAccountHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountOverview` operation.
    ///
    /// See [`DescribeAccountOverview`](crate::client::fluent_builders::DescribeAccountOverview) for more information about the
    /// operation and its arguments.
    pub fn describe_account_overview(&self) -> fluent_builders::DescribeAccountOverview<C, M, R> {
        fluent_builders::DescribeAccountOverview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAnomaly` operation.
    ///
    /// See [`DescribeAnomaly`](crate::client::fluent_builders::DescribeAnomaly) for more information about the
    /// operation and its arguments.
    pub fn describe_anomaly(&self) -> fluent_builders::DescribeAnomaly<C, M, R> {
        fluent_builders::DescribeAnomaly::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFeedback` operation.
    ///
    /// See [`DescribeFeedback`](crate::client::fluent_builders::DescribeFeedback) for more information about the
    /// operation and its arguments.
    pub fn describe_feedback(&self) -> fluent_builders::DescribeFeedback<C, M, R> {
        fluent_builders::DescribeFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInsight` operation.
    ///
    /// See [`DescribeInsight`](crate::client::fluent_builders::DescribeInsight) for more information about the
    /// operation and its arguments.
    pub fn describe_insight(&self) -> fluent_builders::DescribeInsight<C, M, R> {
        fluent_builders::DescribeInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationHealth` operation.
    ///
    /// See [`DescribeOrganizationHealth`](crate::client::fluent_builders::DescribeOrganizationHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_organization_health(
        &self,
    ) -> fluent_builders::DescribeOrganizationHealth<C, M, R> {
        fluent_builders::DescribeOrganizationHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationOverview` operation.
    ///
    /// See [`DescribeOrganizationOverview`](crate::client::fluent_builders::DescribeOrganizationOverview) for more information about the
    /// operation and its arguments.
    pub fn describe_organization_overview(
        &self,
    ) -> fluent_builders::DescribeOrganizationOverview<C, M, R> {
        fluent_builders::DescribeOrganizationOverview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationResourceCollectionHealth` operation.
    ///
    /// See [`DescribeOrganizationResourceCollectionHealth`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_organization_resource_collection_health(
        &self,
    ) -> fluent_builders::DescribeOrganizationResourceCollectionHealth<C, M, R> {
        fluent_builders::DescribeOrganizationResourceCollectionHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResourceCollectionHealth` operation.
    ///
    /// See [`DescribeResourceCollectionHealth`](crate::client::fluent_builders::DescribeResourceCollectionHealth) for more information about the
    /// operation and its arguments.
    pub fn describe_resource_collection_health(
        &self,
    ) -> fluent_builders::DescribeResourceCollectionHealth<C, M, R> {
        fluent_builders::DescribeResourceCollectionHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeServiceIntegration` operation.
    ///
    /// See [`DescribeServiceIntegration`](crate::client::fluent_builders::DescribeServiceIntegration) for more information about the
    /// operation and its arguments.
    pub fn describe_service_integration(
        &self,
    ) -> fluent_builders::DescribeServiceIntegration<C, M, R> {
        fluent_builders::DescribeServiceIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCostEstimation` operation.
    ///
    /// See [`GetCostEstimation`](crate::client::fluent_builders::GetCostEstimation) for more information about the
    /// operation and its arguments.
    pub fn get_cost_estimation(&self) -> fluent_builders::GetCostEstimation<C, M, R> {
        fluent_builders::GetCostEstimation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceCollection` operation.
    ///
    /// See [`GetResourceCollection`](crate::client::fluent_builders::GetResourceCollection) for more information about the
    /// operation and its arguments.
    pub fn get_resource_collection(&self) -> fluent_builders::GetResourceCollection<C, M, R> {
        fluent_builders::GetResourceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnomaliesForInsight` operation.
    ///
    /// See [`ListAnomaliesForInsight`](crate::client::fluent_builders::ListAnomaliesForInsight) for more information about the
    /// operation and its arguments.
    pub fn list_anomalies_for_insight(&self) -> fluent_builders::ListAnomaliesForInsight<C, M, R> {
        fluent_builders::ListAnomaliesForInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEvents` operation.
    ///
    /// See [`ListEvents`](crate::client::fluent_builders::ListEvents) for more information about the
    /// operation and its arguments.
    pub fn list_events(&self) -> fluent_builders::ListEvents<C, M, R> {
        fluent_builders::ListEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInsights` operation.
    ///
    /// See [`ListInsights`](crate::client::fluent_builders::ListInsights) for more information about the
    /// operation and its arguments.
    pub fn list_insights(&self) -> fluent_builders::ListInsights<C, M, R> {
        fluent_builders::ListInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotificationChannels` operation.
    ///
    /// See [`ListNotificationChannels`](crate::client::fluent_builders::ListNotificationChannels) for more information about the
    /// operation and its arguments.
    pub fn list_notification_channels(&self) -> fluent_builders::ListNotificationChannels<C, M, R> {
        fluent_builders::ListNotificationChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOrganizationInsights` operation.
    ///
    /// See [`ListOrganizationInsights`](crate::client::fluent_builders::ListOrganizationInsights) for more information about the
    /// operation and its arguments.
    pub fn list_organization_insights(&self) -> fluent_builders::ListOrganizationInsights<C, M, R> {
        fluent_builders::ListOrganizationInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecommendations` operation.
    ///
    /// See [`ListRecommendations`](crate::client::fluent_builders::ListRecommendations) for more information about the
    /// operation and its arguments.
    pub fn list_recommendations(&self) -> fluent_builders::ListRecommendations<C, M, R> {
        fluent_builders::ListRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFeedback` operation.
    ///
    /// See [`PutFeedback`](crate::client::fluent_builders::PutFeedback) for more information about the
    /// operation and its arguments.
    pub fn put_feedback(&self) -> fluent_builders::PutFeedback<C, M, R> {
        fluent_builders::PutFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveNotificationChannel` operation.
    ///
    /// See [`RemoveNotificationChannel`](crate::client::fluent_builders::RemoveNotificationChannel) for more information about the
    /// operation and its arguments.
    pub fn remove_notification_channel(
        &self,
    ) -> fluent_builders::RemoveNotificationChannel<C, M, R> {
        fluent_builders::RemoveNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchInsights` operation.
    ///
    /// See [`SearchInsights`](crate::client::fluent_builders::SearchInsights) for more information about the
    /// operation and its arguments.
    pub fn search_insights(&self) -> fluent_builders::SearchInsights<C, M, R> {
        fluent_builders::SearchInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchOrganizationInsights` operation.
    ///
    /// See [`SearchOrganizationInsights`](crate::client::fluent_builders::SearchOrganizationInsights) for more information about the
    /// operation and its arguments.
    pub fn search_organization_insights(
        &self,
    ) -> fluent_builders::SearchOrganizationInsights<C, M, R> {
        fluent_builders::SearchOrganizationInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCostEstimation` operation.
    ///
    /// See [`StartCostEstimation`](crate::client::fluent_builders::StartCostEstimation) for more information about the
    /// operation and its arguments.
    pub fn start_cost_estimation(&self) -> fluent_builders::StartCostEstimation<C, M, R> {
        fluent_builders::StartCostEstimation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResourceCollection` operation.
    ///
    /// See [`UpdateResourceCollection`](crate::client::fluent_builders::UpdateResourceCollection) for more information about the
    /// operation and its arguments.
    pub fn update_resource_collection(&self) -> fluent_builders::UpdateResourceCollection<C, M, R> {
        fluent_builders::UpdateResourceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceIntegration` operation.
    ///
    /// See [`UpdateServiceIntegration`](crate::client::fluent_builders::UpdateServiceIntegration) for more information about the
    /// operation and its arguments.
    pub fn update_service_integration(&self) -> fluent_builders::UpdateServiceIntegration<C, M, R> {
        fluent_builders::UpdateServiceIntegration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddNotificationChannel`.
    ///
    /// <p> Adds a notification channel to DevOps Guru. A notification channel is used to notify you
    /// about important DevOps Guru events, such as when an insight is generated. </p>
    /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
    /// to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account.
    /// For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions
    /// for cross account Amazon SNS topics</a>.</p>
    /// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions
    /// to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
    /// Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddNotificationChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_notification_channel_input::Builder,
    }
    impl<C, M, R> AddNotificationChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::AddNotificationChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddNotificationChannelInputOperationOutputAlias,
                crate::output::AddNotificationChannelOutput,
                crate::error::AddNotificationChannelError,
                crate::input::AddNotificationChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of
        /// notification channel to add. The one
        /// supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
        pub fn config(mut self, inp: crate::model::NotificationChannelConfig) -> Self {
            self.inner = self.inner.config(inp);
            self
        }
        /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of
        /// notification channel to add. The one
        /// supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::NotificationChannelConfig>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountHealth`.
    ///
    /// <p> Returns the number of open reactive insights, the number of open proactive insights,
    /// and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the
    /// health of operations in your Amazon Web Services account. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_health_input::Builder,
    }
    impl<C, M, R> DescribeAccountHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountHealthInputOperationOutputAlias,
                crate::output::DescribeAccountHealthOutput,
                crate::error::DescribeAccountHealthError,
                crate::input::DescribeAccountHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountOverview`.
    ///
    /// <p> For the time range passed in, returns the number of open reactive insight that were
    /// created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all
    /// closed reactive insights. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountOverview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_overview_input::Builder,
    }
    impl<C, M, R> DescribeAccountOverview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountOverview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountOverviewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountOverviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountOverviewInputOperationOutputAlias,
                crate::output::DescribeAccountOverviewOutput,
                crate::error::DescribeAccountOverviewError,
                crate::input::DescribeAccountOverviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day
        /// level. The floor of the start time is used. Returned information occurred after this
        /// day. </p>
        pub fn from_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.from_time(inp);
            self
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day
        /// level. The floor of the start time is used. Returned information occurred after this
        /// day. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_from_time(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level.
        /// The floor of the start time is used. Returned information occurred before this day. If
        /// this is not specified, then the current day is used. </p>
        pub fn to_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.to_time(inp);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level.
        /// The floor of the start time is used. Returned information occurred before this day. If
        /// this is not specified, then the current day is used. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_to_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnomaly`.
    ///
    /// <p> Returns details about an anomaly that you specify using its ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAnomaly<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_anomaly_input::Builder,
    }
    impl<C, M, R> DescribeAnomaly<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnomaly`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnomalyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnomalyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnomalyInputOperationOutputAlias,
                crate::output::DescribeAnomalyOutput,
                crate::error::DescribeAnomalyError,
                crate::input::DescribeAnomalyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the anomaly. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p> The ID of the anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFeedback`.
    ///
    /// <p> Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_feedback_input::Builder,
    }
    impl<C, M, R> DescribeFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFeedbackInputOperationOutputAlias,
                crate::output::DescribeFeedbackOutput,
                crate::error::DescribeFeedbackError,
                crate::input::DescribeFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the insight for which the feedback was provided. </p>
        pub fn insight_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(inp);
            self
        }
        /// <p> The ID of the insight for which the feedback was provided. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInsight`.
    ///
    /// <p> Returns details about an insight that you specify using its ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInsight<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_insight_input::Builder,
    }
    impl<C, M, R> DescribeInsight<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInsightError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInsightInputOperationOutputAlias,
                crate::output::DescribeInsightOutput,
                crate::error::DescribeInsightError,
                crate::input::DescribeInsightInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the insight. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p> The ID of the insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the member account in the organization.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The ID of the member account in the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationHealth`.
    ///
    /// <p>Returns active insights, predictive insights, and resource hours analyzed in last
    /// hour.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganizationHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_health_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationHealthInputOperationOutputAlias,
                crate::output::DescribeOrganizationHealthOutput,
                crate::error::DescribeOrganizationHealthError,
                crate::input::DescribeOrganizationHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(inp);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationOverview`.
    ///
    /// <p>Returns an overview of your organization's history based on the specified time range.
    /// The overview includes the total reactive and proactive insights.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganizationOverview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_overview_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationOverview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationOverview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationOverviewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationOverviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationOverviewInputOperationOutputAlias,
                crate::output::DescribeOrganizationOverviewOutput,
                crate::error::DescribeOrganizationOverviewError,
                crate::input::DescribeOrganizationOverviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day
        /// level. The floor of the start time is used. Returned information occurred after this
        /// day. </p>
        pub fn from_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.from_time(inp);
            self
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day
        /// level. The floor of the start time is used. Returned information occurred after this
        /// day. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_from_time(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level.
        /// The floor of the start time is used. Returned information occurred before this day. If
        /// this is not specified, then the current day is used. </p>
        pub fn to_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.to_time(inp);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level.
        /// The floor of the start time is used. Returned information occurred before this day. If
        /// this is not specified, then the current day is used. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_to_time(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(inp);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationResourceCollectionHealth`.
    ///
    /// <p>Provides an overview of your system's health. If additional member accounts are part
    /// of your organization, you can filter those accounts using the <code>AccountIds</code>
    /// field.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganizationResourceCollectionHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_resource_collection_health_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationResourceCollectionHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationResourceCollectionHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationResourceCollectionHealthOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrganizationResourceCollectionHealthError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationResourceCollectionHealthInputOperationOutputAlias,
                crate::output::DescribeOrganizationResourceCollectionHealthOutput,
                crate::error::DescribeOrganizationResourceCollectionHealthError,
                crate::input::DescribeOrganizationResourceCollectionHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
        /// are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
        /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
        /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn organization_resource_collection_type(
            mut self,
            inp: crate::model::OrganizationResourceCollectionType,
        ) -> Self {
            self.inner = self.inner.organization_resource_collection_type(inp);
            self
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
        /// are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
        /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
        /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_organization_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_organization_resource_collection_type(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(inp);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourceCollectionHealth`.
    ///
    /// <p> Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR)
    /// for all closed insights in resource collections in your account. You specify the type of
    /// Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
    /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
    /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResourceCollectionHealth<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_collection_health_input::Builder,
    }
    impl<C, M, R> DescribeResourceCollectionHealth<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResourceCollectionHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceCollectionHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceCollectionHealthError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourceCollectionHealthInputOperationOutputAlias,
                crate::output::DescribeResourceCollectionHealthOutput,
                crate::error::DescribeResourceCollectionHealthError,
                crate::input::DescribeResourceCollectionHealthInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
        /// are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
        /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
        /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection_type(
            mut self,
            inp: crate::model::ResourceCollectionType,
        ) -> Self {
            self.inner = self.inner.resource_collection_type(inp);
            self
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
        /// are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
        /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
        /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection_type(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceIntegration`.
    ///
    /// <p> Returns the integration status of services that are integrated with DevOps Guru.
    /// The one service that can be integrated with DevOps Guru
    /// is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeServiceIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_service_integration_input::Builder,
    }
    impl<C, M, R> DescribeServiceIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeServiceIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServiceIntegrationInputOperationOutputAlias,
                crate::output::DescribeServiceIntegrationOutput,
                crate::error::DescribeServiceIntegrationError,
                crate::input::DescribeServiceIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetCostEstimation`.
    ///
    /// <p>Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources.
    /// For more information,
    /// see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
    /// Amazon DevOps Guru costs</a> and
    /// <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCostEstimation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cost_estimation_input::Builder,
    }
    impl<C, M, R> GetCostEstimation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCostEstimation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCostEstimationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCostEstimationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCostEstimationInputOperationOutputAlias,
                crate::output::GetCostEstimationOutput,
                crate::error::GetCostEstimationError,
                crate::input::GetCostEstimationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceCollection`.
    ///
    /// <p> Returns lists Amazon Web Services resources that are of the specified resource collection type.
    /// The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
    /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
    /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_collection_input::Builder,
    }
    impl<C, M, R> GetResourceCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceCollectionInputOperationOutputAlias,
                crate::output::GetResourceCollectionOutput,
                crate::error::GetResourceCollectionError,
                crate::input::GetResourceCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The type of Amazon Web Services resource collections to return. The one valid value is
        /// <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection_type(
            mut self,
            inp: crate::model::ResourceCollectionType,
        ) -> Self {
            self.inner = self.inner.resource_collection_type(inp);
            self
        }
        /// <p> The type of Amazon Web Services resource collections to return. The one valid value is
        /// <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection_type(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnomaliesForInsight`.
    ///
    /// <p> Returns a list of the anomalies that belong to an insight that you specify using its
    /// ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnomaliesForInsight<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_anomalies_for_insight_input::Builder,
    }
    impl<C, M, R> ListAnomaliesForInsight<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnomaliesForInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnomaliesForInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnomaliesForInsightError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnomaliesForInsightInputOperationOutputAlias,
                crate::output::ListAnomaliesForInsightOutput,
                crate::error::ListAnomaliesForInsightError,
                crate::input::ListAnomaliesForInsightInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
        pub fn insight_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(inp);
            self
        }
        /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p> A time range used to specify when the requested anomalies started. All returned
        /// anomalies started during this time range. </p>
        pub fn start_time_range(mut self, inp: crate::model::StartTimeRange) -> Self {
            self.inner = self.inner.start_time_range(inp);
            self
        }
        /// <p> A time range used to specify when the requested anomalies started. All returned
        /// anomalies started during this time range. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_range(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEvents`.
    ///
    /// <p> Returns a list of the events emitted by the resources that are evaluated by DevOps Guru.
    /// You can use filters to specify which events are returned. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_events_input::Builder,
    }
    impl<C, M, R> ListEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventsInputOperationOutputAlias,
                crate::output::ListEventsOutput,
                crate::error::ListEventsError,
                crate::input::ListEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A <code>ListEventsFilters</code> object used to specify which events to return.
        /// </p>
        pub fn filters(mut self, inp: crate::model::ListEventsFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p> A <code>ListEventsFilters</code> object used to specify which events to return.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListEventsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInsights`.
    ///
    /// <p> Returns a list of insights in your Amazon Web Services account. You can specify which insights are
    /// returned by their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or
    /// <code>ANY</code>). </p>
    #[derive(std::fmt::Debug)]
    pub struct ListInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_insights_input::Builder,
    }
    impl<C, M, R> ListInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInsightsInputOperationOutputAlias,
                crate::output::ListInsightsOutput,
                crate::error::ListInsightsError,
                crate::input::ListInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A filter used to filter the returned insights by their status. You can specify one
        /// status filter. </p>
        pub fn status_filter(mut self, inp: crate::model::ListInsightsStatusFilter) -> Self {
            self.inner = self.inner.status_filter(inp);
            self
        }
        /// <p> A filter used to filter the returned insights by their status. You can specify one
        /// status filter. </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ListInsightsStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotificationChannels`.
    ///
    /// <p> Returns a list of notification channels configured for DevOps Guru. Each notification
    /// channel is used to notify you when DevOps Guru generates an insight that contains information
    /// about how to improve your operations. The one
    /// supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
    #[derive(std::fmt::Debug)]
    pub struct ListNotificationChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_notification_channels_input::Builder,
    }
    impl<C, M, R> ListNotificationChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNotificationChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNotificationChannelsInputOperationOutputAlias,
                crate::output::ListNotificationChannelsOutput,
                crate::error::ListNotificationChannelsError,
                crate::input::ListNotificationChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationInsights`.
    ///
    /// <p>Returns a list of insights associated with the account or OU Id.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOrganizationInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organization_insights_input::Builder,
    }
    impl<C, M, R> ListOrganizationInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationInsightsInputOperationOutputAlias,
                crate::output::ListOrganizationInsightsOutput,
                crate::error::ListOrganizationInsightsError,
                crate::input::ListOrganizationInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A filter used by <code>ListInsights</code> to specify which insights to return.
        /// </p>
        pub fn status_filter(mut self, inp: crate::model::ListInsightsStatusFilter) -> Self {
            self.inner = self.inner.status_filter(inp);
            self
        }
        /// <p> A filter used by <code>ListInsights</code> to specify which insights to return.
        /// </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ListInsightsStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(inp);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendations`.
    ///
    /// <p> Returns a list of a specified insight's recommendations. Each recommendation includes
    /// a list of related metrics and a list of related events. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recommendations_input::Builder,
    }
    impl<C, M, R> ListRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecommendationsInputOperationOutputAlias,
                crate::output::ListRecommendationsOutput,
                crate::error::ListRecommendationsError,
                crate::input::ListRecommendationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the requested insight. </p>
        pub fn insight_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(inp);
            self
        }
        /// <p> The ID of the requested insight. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A locale that specifies the language to use for recommendations.</p>
        pub fn locale(mut self, inp: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>A locale that specifies the language to use for recommendations.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFeedback`.
    ///
    /// <p> Collects customer feedback about the specified insight. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_feedback_input::Builder,
    }
    impl<C, M, R> PutFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFeedbackInputOperationOutputAlias,
                crate::output::PutFeedbackOutput,
                crate::error::PutFeedbackError,
                crate::input::PutFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The feedback from customers is about the recommendations in this insight. </p>
        pub fn insight_feedback(mut self, inp: crate::model::InsightFeedback) -> Self {
            self.inner = self.inner.insight_feedback(inp);
            self
        }
        /// <p> The feedback from customers is about the recommendations in this insight. </p>
        pub fn set_insight_feedback(
            mut self,
            input: std::option::Option<crate::model::InsightFeedback>,
        ) -> Self {
            self.inner = self.inner.set_insight_feedback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveNotificationChannel`.
    ///
    /// <p> Removes a notification channel from DevOps Guru. A notification channel is used to notify
    /// you when DevOps Guru generates an insight that contains information about how to improve your
    /// operations. </p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveNotificationChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_notification_channel_input::Builder,
    }
    impl<C, M, R> RemoveNotificationChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveNotificationChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveNotificationChannelInputOperationOutputAlias,
                crate::output::RemoveNotificationChannelOutput,
                crate::error::RemoveNotificationChannelError,
                crate::input::RemoveNotificationChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the notification channel to be removed. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p> The ID of the notification channel to be removed. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchInsights`.
    ///
    /// <p> Returns a list of insights in your Amazon Web Services account. You can specify which insights are
    /// returned by their start time, one or more statuses (<code>ONGOING</code>,
    /// <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
    /// (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type
    /// (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    /// <p> Use the <code>Filters</code> parameter to specify status and severity search
    /// parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or
    /// <code>PROACTIVE</code> in your search. </p>
    #[derive(std::fmt::Debug)]
    pub struct SearchInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_insights_input::Builder,
    }
    impl<C, M, R> SearchInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchInsightsInputOperationOutputAlias,
                crate::output::SearchInsightsOutput,
                crate::error::SearchInsightsError,
                crate::input::SearchInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The start of the time range passed in. Returned insights occurred after this time.
        /// </p>
        pub fn start_time_range(mut self, inp: crate::model::StartTimeRange) -> Self {
            self.inner = self.inner.start_time_range(inp);
            self
        }
        /// <p> The start of the time range passed in. Returned insights occurred after this time.
        /// </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_range(input);
            self
        }
        /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and
        /// status filters on your insight search. </p>
        pub fn filters(mut self, inp: crate::model::SearchInsightsFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and
        /// status filters on your insight search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::SearchInsightsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or
        /// <code>PROACTIVE</code>). </p>
        pub fn r#type(mut self, inp: crate::model::InsightType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or
        /// <code>PROACTIVE</code>). </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchOrganizationInsights`.
    ///
    /// <p> Returns a list of insights in your organization. You can specify which insights are
    /// returned by their start time, one or more statuses (<code>ONGOING</code>,
    /// <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
    /// (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type
    /// (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    /// <p> Use the <code>Filters</code> parameter to specify status and severity search
    /// parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or
    /// <code>PROACTIVE</code> in your search. </p>
    #[derive(std::fmt::Debug)]
    pub struct SearchOrganizationInsights<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_organization_insights_input::Builder,
    }
    impl<C, M, R> SearchOrganizationInsights<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchOrganizationInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchOrganizationInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchOrganizationInsightsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchOrganizationInsightsInputOperationOutputAlias,
                crate::output::SearchOrganizationInsightsOutput,
                crate::error::SearchOrganizationInsightsError,
                crate::input::SearchOrganizationInsightsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p> A time range used to specify when the behavior of an insight or anomaly started.
        /// </p>
        pub fn start_time_range(mut self, inp: crate::model::StartTimeRange) -> Self {
            self.inner = self.inner.start_time_range(inp);
            self
        }
        /// <p> A time range used to specify when the behavior of an insight or anomaly started.
        /// </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_range(input);
            self
        }
        /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the
        /// severity and status filters on your insight search. </p>
        pub fn filters(mut self, inp: crate::model::SearchOrganizationInsightsFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the
        /// severity and status filters on your insight search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::SearchOrganizationInsightsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve
        /// the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or
        /// <code>PROACTIVE</code>). </p>
        pub fn r#type(mut self, inp: crate::model::InsightType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or
        /// <code>PROACTIVE</code>). </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCostEstimation`.
    ///
    /// <p>Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services
    /// resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCostEstimation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_cost_estimation_input::Builder,
    }
    impl<C, M, R> StartCostEstimation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCostEstimation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCostEstimationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCostEstimationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCostEstimationInputOperationOutputAlias,
                crate::output::StartCostEstimationOutput,
                crate::error::StartCostEstimationError,
                crate::input::StartCostEstimationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
        pub fn resource_collection(
            mut self,
            inp: crate::model::CostEstimationResourceCollectionFilter,
        ) -> Self {
            self.inner = self.inner.resource_collection(inp);
            self
        }
        /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::CostEstimationResourceCollectionFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection(input);
            self
        }
        /// <p>The idempotency token used to identify each cost estimate request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to identify each cost estimate request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceCollection`.
    ///
    /// <p> Updates the collection of resources that DevOps Guru analyzes.
    /// The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and
    /// Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze
    /// the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for
    /// you to use DevOps Guru. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResourceCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_collection_input::Builder,
    }
    impl<C, M, R> UpdateResourceCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceCollectionInputOperationOutputAlias,
                crate::output::UpdateResourceCollectionOutput,
                crate::error::UpdateResourceCollectionError,
                crate::input::UpdateResourceCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specifies if the resource collection in the request is added or deleted to the
        /// resource collection. </p>
        pub fn action(mut self, inp: crate::model::UpdateResourceCollectionAction) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p> Specifies if the resource collection in the request is added or deleted to the
        /// resource collection. </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::UpdateResourceCollectionAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
        pub fn resource_collection(
            mut self,
            inp: crate::model::UpdateResourceCollectionFilter,
        ) -> Self {
            self.inner = self.inner.resource_collection(inp);
            self
        }
        /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::UpdateResourceCollectionFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceIntegration`.
    ///
    /// <p> Enables or disables integration with a service that can be integrated with DevOps Guru. The
    /// one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create
    /// an OpsItem for each generated insight. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_integration_input::Builder,
    }
    impl<C, M, R> UpdateServiceIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceIntegrationInputOperationOutputAlias,
                crate::output::UpdateServiceIntegrationOutput,
                crate::error::UpdateServiceIntegrationError,
                crate::input::UpdateServiceIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service
        /// you want to update, and whether you want to update it to enabled or disabled. </p>
        pub fn service_integration(
            mut self,
            inp: crate::model::UpdateServiceIntegrationConfig,
        ) -> Self {
            self.inner = self.inner.service_integration(inp);
            self
        }
        /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service
        /// you want to update, and whether you want to update it to enabled or disabled. </p>
        pub fn set_service_integration(
            mut self,
            input: std::option::Option<crate::model::UpdateServiceIntegrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_service_integration(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
