// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon DevOps Guru
///
/// Client for invoking operations on Amazon DevOps Guru. Each operation on Amazon DevOps Guru is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_devopsguru::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_devopsguru::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_devopsguru::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddNotificationChannel`](crate::client::fluent_builders::AddNotificationChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config(NotificationChannelConfig)`](crate::client::fluent_builders::AddNotificationChannel::config) / [`set_config(Option<NotificationChannelConfig>)`](crate::client::fluent_builders::AddNotificationChannel::set_config): <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
    /// - On success, responds with [`AddNotificationChannelOutput`](crate::output::AddNotificationChannelOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::AddNotificationChannelOutput::id): <p> The ID of the added notification channel. </p>
    /// - On failure, responds with [`SdkError<AddNotificationChannelError>`](crate::error::AddNotificationChannelError)
    pub fn add_notification_channel(&self) -> fluent_builders::AddNotificationChannel {
        fluent_builders::AddNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInsight`](crate::client::fluent_builders::DeleteInsight) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteInsight::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteInsight::set_id): <p>The ID of the insight.</p>
    /// - On success, responds with [`DeleteInsightOutput`](crate::output::DeleteInsightOutput)

    /// - On failure, responds with [`SdkError<DeleteInsightError>`](crate::error::DeleteInsightError)
    pub fn delete_insight(&self) -> fluent_builders::DeleteInsight {
        fluent_builders::DeleteInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountHealth`](crate::client::fluent_builders::DescribeAccountHealth) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAccountHealth::send) it.

    /// - On success, responds with [`DescribeAccountHealthOutput`](crate::output::DescribeAccountHealthOutput) with field(s):
    ///   - [`open_reactive_insights(i32)`](crate::output::DescribeAccountHealthOutput::open_reactive_insights): <p> An integer that specifies the number of open reactive insights in your Amazon Web Services account. </p>
    ///   - [`open_proactive_insights(i32)`](crate::output::DescribeAccountHealthOutput::open_proactive_insights): <p> An integer that specifies the number of open proactive insights in your Amazon Web Services account. </p>
    ///   - [`metrics_analyzed(i32)`](crate::output::DescribeAccountHealthOutput::metrics_analyzed): <p> An integer that specifies the number of metrics that have been analyzed in your Amazon Web Services account. </p>
    ///   - [`resource_hours(Option<i64>)`](crate::output::DescribeAccountHealthOutput::resource_hours): <p>The number of Amazon DevOps Guru resource analysis hours billed to the current Amazon Web Services account in the last hour. </p>
    /// - On failure, responds with [`SdkError<DescribeAccountHealthError>`](crate::error::DescribeAccountHealthError)
    pub fn describe_account_health(&self) -> fluent_builders::DescribeAccountHealth {
        fluent_builders::DescribeAccountHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountOverview`](crate::client::fluent_builders::DescribeAccountOverview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`from_time(DateTime)`](crate::client::fluent_builders::DescribeAccountOverview::from_time) / [`set_from_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeAccountOverview::set_from_time): <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
    ///   - [`to_time(DateTime)`](crate::client::fluent_builders::DescribeAccountOverview::to_time) / [`set_to_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeAccountOverview::set_to_time): <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
    /// - On success, responds with [`DescribeAccountOverviewOutput`](crate::output::DescribeAccountOverviewOutput) with field(s):
    ///   - [`reactive_insights(i32)`](crate::output::DescribeAccountOverviewOutput::reactive_insights): <p> An integer that specifies the number of open reactive insights in your Amazon Web Services account that were created during the time range passed in. </p>
    ///   - [`proactive_insights(i32)`](crate::output::DescribeAccountOverviewOutput::proactive_insights): <p> An integer that specifies the number of open proactive insights in your Amazon Web Services account that were created during the time range passed in. </p>
    ///   - [`mean_time_to_recover_in_milliseconds(Option<i64>)`](crate::output::DescribeAccountOverviewOutput::mean_time_to_recover_in_milliseconds): <p> The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed in. </p>
    /// - On failure, responds with [`SdkError<DescribeAccountOverviewError>`](crate::error::DescribeAccountOverviewError)
    pub fn describe_account_overview(&self) -> fluent_builders::DescribeAccountOverview {
        fluent_builders::DescribeAccountOverview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAnomaly`](crate::client::fluent_builders::DescribeAnomaly) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeAnomaly::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeAnomaly::set_id): <p> The ID of the anomaly. </p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAnomaly::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeAnomaly::set_account_id): <p>The ID of the member account.</p>
    /// - On success, responds with [`DescribeAnomalyOutput`](crate::output::DescribeAnomalyOutput) with field(s):
    ///   - [`proactive_anomaly(Option<ProactiveAnomaly>)`](crate::output::DescribeAnomalyOutput::proactive_anomaly): <p> A <code>ProactiveAnomaly</code> object that represents the requested anomaly. </p>
    ///   - [`reactive_anomaly(Option<ReactiveAnomaly>)`](crate::output::DescribeAnomalyOutput::reactive_anomaly): <p> A <code>ReactiveAnomaly</code> object that represents the requested anomaly. </p>
    /// - On failure, responds with [`SdkError<DescribeAnomalyError>`](crate::error::DescribeAnomalyError)
    pub fn describe_anomaly(&self) -> fluent_builders::DescribeAnomaly {
        fluent_builders::DescribeAnomaly::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventSourcesConfig`](crate::client::fluent_builders::DescribeEventSourcesConfig) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeEventSourcesConfig::send) it.

    /// - On success, responds with [`DescribeEventSourcesConfigOutput`](crate::output::DescribeEventSourcesConfigOutput) with field(s):
    ///   - [`event_sources(Option<EventSourcesConfig>)`](crate::output::DescribeEventSourcesConfigOutput::event_sources): <p>Lists the event sources in the configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeEventSourcesConfigError>`](crate::error::DescribeEventSourcesConfigError)
    pub fn describe_event_sources_config(&self) -> fluent_builders::DescribeEventSourcesConfig {
        fluent_builders::DescribeEventSourcesConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFeedback`](crate::client::fluent_builders::DescribeFeedback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFeedback::insight_id) / [`set_insight_id(Option<String>)`](crate::client::fluent_builders::DescribeFeedback::set_insight_id): <p> The ID of the insight for which the feedback was provided. </p>
    /// - On success, responds with [`DescribeFeedbackOutput`](crate::output::DescribeFeedbackOutput) with field(s):
    ///   - [`insight_feedback(Option<InsightFeedback>)`](crate::output::DescribeFeedbackOutput::insight_feedback): <p> Information about insight feedback received from a customer. </p>
    /// - On failure, responds with [`SdkError<DescribeFeedbackError>`](crate::error::DescribeFeedbackError)
    pub fn describe_feedback(&self) -> fluent_builders::DescribeFeedback {
        fluent_builders::DescribeFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInsight`](crate::client::fluent_builders::DescribeInsight) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeInsight::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeInsight::set_id): <p> The ID of the insight. </p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInsight::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeInsight::set_account_id): <p>The ID of the member account in the organization.</p>
    /// - On success, responds with [`DescribeInsightOutput`](crate::output::DescribeInsightOutput) with field(s):
    ///   - [`proactive_insight(Option<ProactiveInsight>)`](crate::output::DescribeInsightOutput::proactive_insight): <p> A <code>ProactiveInsight</code> object that represents the requested insight. </p>
    ///   - [`reactive_insight(Option<ReactiveInsight>)`](crate::output::DescribeInsightOutput::reactive_insight): <p> A <code>ReactiveInsight</code> object that represents the requested insight. </p>
    /// - On failure, responds with [`SdkError<DescribeInsightError>`](crate::error::DescribeInsightError)
    pub fn describe_insight(&self) -> fluent_builders::DescribeInsight {
        fluent_builders::DescribeInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationHealth`](crate::client::fluent_builders::DescribeOrganizationHealth) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DescribeOrganizationHealth::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOrganizationHealth::set_account_ids): <p>The ID of the Amazon Web Services account.</p>
    ///   - [`organizational_unit_ids(Vec<String>)`](crate::client::fluent_builders::DescribeOrganizationHealth::organizational_unit_ids) / [`set_organizational_unit_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOrganizationHealth::set_organizational_unit_ids): <p>The ID of the organizational unit.</p>
    /// - On success, responds with [`DescribeOrganizationHealthOutput`](crate::output::DescribeOrganizationHealthOutput) with field(s):
    ///   - [`open_reactive_insights(i32)`](crate::output::DescribeOrganizationHealthOutput::open_reactive_insights): <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
    ///   - [`open_proactive_insights(i32)`](crate::output::DescribeOrganizationHealthOutput::open_proactive_insights): <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
    ///   - [`metrics_analyzed(i32)`](crate::output::DescribeOrganizationHealthOutput::metrics_analyzed): <p>An integer that specifies the number of metrics that have been analyzed in your organization.</p>
    ///   - [`resource_hours(Option<i64>)`](crate::output::DescribeOrganizationHealthOutput::resource_hours): <p>The number of Amazon DevOps Guru resource analysis hours billed to the current Amazon Web Services account in the last hour. </p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationHealthError>`](crate::error::DescribeOrganizationHealthError)
    pub fn describe_organization_health(&self) -> fluent_builders::DescribeOrganizationHealth {
        fluent_builders::DescribeOrganizationHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationOverview`](crate::client::fluent_builders::DescribeOrganizationOverview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`from_time(DateTime)`](crate::client::fluent_builders::DescribeOrganizationOverview::from_time) / [`set_from_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeOrganizationOverview::set_from_time): <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
    ///   - [`to_time(DateTime)`](crate::client::fluent_builders::DescribeOrganizationOverview::to_time) / [`set_to_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeOrganizationOverview::set_to_time): <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DescribeOrganizationOverview::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOrganizationOverview::set_account_ids): <p>The ID of the Amazon Web Services account.</p>
    ///   - [`organizational_unit_ids(Vec<String>)`](crate::client::fluent_builders::DescribeOrganizationOverview::organizational_unit_ids) / [`set_organizational_unit_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOrganizationOverview::set_organizational_unit_ids): <p>The ID of the organizational unit.</p>
    /// - On success, responds with [`DescribeOrganizationOverviewOutput`](crate::output::DescribeOrganizationOverviewOutput) with field(s):
    ///   - [`reactive_insights(i32)`](crate::output::DescribeOrganizationOverviewOutput::reactive_insights): <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
    ///   - [`proactive_insights(i32)`](crate::output::DescribeOrganizationOverviewOutput::proactive_insights): <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationOverviewError>`](crate::error::DescribeOrganizationOverviewError)
    pub fn describe_organization_overview(&self) -> fluent_builders::DescribeOrganizationOverview {
        fluent_builders::DescribeOrganizationOverview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationResourceCollectionHealth`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_resource_collection_type(OrganizationResourceCollectionType)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::organization_resource_collection_type) / [`set_organization_resource_collection_type(Option<OrganizationResourceCollectionType>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::set_organization_resource_collection_type): <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::set_account_ids): <p>The ID of the Amazon Web Services account.</p>
    ///   - [`organizational_unit_ids(Vec<String>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::organizational_unit_ids) / [`set_organizational_unit_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::set_organizational_unit_ids): <p>The ID of the organizational unit.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeOrganizationResourceCollectionHealth::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeOrganizationResourceCollectionHealthOutput`](crate::output::DescribeOrganizationResourceCollectionHealthOutput) with field(s):
    ///   - [`cloud_formation(Option<Vec<CloudFormationHealth>>)`](crate::output::DescribeOrganizationResourceCollectionHealthOutput::cloud_formation): <p>The returned <code>CloudFormationHealthOverview</code> object that contains an <code>InsightHealthOverview</code> object with the requested system health information.</p>
    ///   - [`service(Option<Vec<ServiceHealth>>)`](crate::output::DescribeOrganizationResourceCollectionHealthOutput::service): <p>An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services associated with the resources in the collection.</p>
    ///   - [`account(Option<Vec<AccountHealth>>)`](crate::output::DescribeOrganizationResourceCollectionHealthOutput::account): <p>The name of the organization's account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeOrganizationResourceCollectionHealthOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    ///   - [`tags(Option<Vec<TagHealth>>)`](crate::output::DescribeOrganizationResourceCollectionHealthOutput::tags): <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>  <p>Each Amazon Web Services tag has two parts. </p>  <ul>   <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>   <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>  </ul>  <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>   <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>  </important>
    /// - On failure, responds with [`SdkError<DescribeOrganizationResourceCollectionHealthError>`](crate::error::DescribeOrganizationResourceCollectionHealthError)
    pub fn describe_organization_resource_collection_health(
        &self,
    ) -> fluent_builders::DescribeOrganizationResourceCollectionHealth {
        fluent_builders::DescribeOrganizationResourceCollectionHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourceCollectionHealth`](crate::client::fluent_builders::DescribeResourceCollectionHealth) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeResourceCollectionHealth::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_collection_type(ResourceCollectionType)`](crate::client::fluent_builders::DescribeResourceCollectionHealth::resource_collection_type) / [`set_resource_collection_type(Option<ResourceCollectionType>)`](crate::client::fluent_builders::DescribeResourceCollectionHealth::set_resource_collection_type): <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeResourceCollectionHealth::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeResourceCollectionHealth::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeResourceCollectionHealthOutput`](crate::output::DescribeResourceCollectionHealthOutput) with field(s):
    ///   - [`cloud_formation(Option<Vec<CloudFormationHealth>>)`](crate::output::DescribeResourceCollectionHealthOutput::cloud_formation): <p> The returned <code>CloudFormationHealthOverview</code> object that contains an <code>InsightHealthOverview</code> object with the requested system health information. </p>
    ///   - [`service(Option<Vec<ServiceHealth>>)`](crate::output::DescribeResourceCollectionHealthOutput::service): <p>An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services associated with the resources in the collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeResourceCollectionHealthOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    ///   - [`tags(Option<Vec<TagHealth>>)`](crate::output::DescribeResourceCollectionHealthOutput::tags): <p>The Amazon Web Services tags that are used by resources in the resource collection.</p>  <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p>  <p>Each Amazon Web Services tag has two parts. </p>  <ul>   <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li>   <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li>  </ul>  <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important>   <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don't matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p>  </important>
    /// - On failure, responds with [`SdkError<DescribeResourceCollectionHealthError>`](crate::error::DescribeResourceCollectionHealthError)
    pub fn describe_resource_collection_health(
        &self,
    ) -> fluent_builders::DescribeResourceCollectionHealth {
        fluent_builders::DescribeResourceCollectionHealth::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServiceIntegration`](crate::client::fluent_builders::DescribeServiceIntegration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeServiceIntegration::send) it.

    /// - On success, responds with [`DescribeServiceIntegrationOutput`](crate::output::DescribeServiceIntegrationOutput) with field(s):
    ///   - [`service_integration(Option<ServiceIntegrationConfig>)`](crate::output::DescribeServiceIntegrationOutput::service_integration): <p> Information about the integration of DevOps Guru with another Amazon Web Services service, such as Amazon Web Services Systems Manager. </p>
    /// - On failure, responds with [`SdkError<DescribeServiceIntegrationError>`](crate::error::DescribeServiceIntegrationError)
    pub fn describe_service_integration(&self) -> fluent_builders::DescribeServiceIntegration {
        fluent_builders::DescribeServiceIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCostEstimation`](crate::client::fluent_builders::GetCostEstimation) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCostEstimation::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCostEstimation::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCostEstimation::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`GetCostEstimationOutput`](crate::output::GetCostEstimationOutput) with field(s):
    ///   - [`resource_collection(Option<CostEstimationResourceCollectionFilter>)`](crate::output::GetCostEstimationOutput::resource_collection): <p>The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost estimate.</p>
    ///   - [`status(Option<CostEstimationStatus>)`](crate::output::GetCostEstimationOutput::status): <p>The status of creating this cost estimate. If it's still in progress, the status <code>ONGOING</code> is returned. If it is finished, the status <code>COMPLETED</code> is returned.</p>
    ///   - [`costs(Option<Vec<ServiceResourceCost>>)`](crate::output::GetCostEstimationOutput::costs): <p>An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to analyze one of your Amazon Web Services resources.</p>
    ///   - [`time_range(Option<CostEstimationTimeRange>)`](crate::output::GetCostEstimationOutput::time_range): <p>The start and end time of the cost estimation.</p>
    ///   - [`total_cost(f64)`](crate::output::GetCostEstimationOutput::total_cost): <p>The estimated monthly cost to analyze the Amazon Web Services resources. This value is the sum of the estimated costs to analyze each resource in the <code>Costs</code> object in this response.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCostEstimationOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<GetCostEstimationError>`](crate::error::GetCostEstimationError)
    pub fn get_cost_estimation(&self) -> fluent_builders::GetCostEstimation {
        fluent_builders::GetCostEstimation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceCollection`](crate::client::fluent_builders::GetResourceCollection) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetResourceCollection::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_collection_type(ResourceCollectionType)`](crate::client::fluent_builders::GetResourceCollection::resource_collection_type) / [`set_resource_collection_type(Option<ResourceCollectionType>)`](crate::client::fluent_builders::GetResourceCollection::set_resource_collection_type): <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetResourceCollection::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetResourceCollection::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`GetResourceCollectionOutput`](crate::output::GetResourceCollectionOutput) with field(s):
    ///   - [`resource_collection(Option<ResourceCollectionFilter>)`](crate::output::GetResourceCollectionOutput::resource_collection): <p> The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetResourceCollectionOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<GetResourceCollectionError>`](crate::error::GetResourceCollectionError)
    pub fn get_resource_collection(&self) -> fluent_builders::GetResourceCollection {
        fluent_builders::GetResourceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAnomaliesForInsight`](crate::client::fluent_builders::ListAnomaliesForInsight) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAnomaliesForInsight::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_id(impl Into<String>)`](crate::client::fluent_builders::ListAnomaliesForInsight::insight_id) / [`set_insight_id(Option<String>)`](crate::client::fluent_builders::ListAnomaliesForInsight::set_insight_id): <p> The ID of the insight. The returned anomalies belong to this insight. </p>
    ///   - [`start_time_range(StartTimeRange)`](crate::client::fluent_builders::ListAnomaliesForInsight::start_time_range) / [`set_start_time_range(Option<StartTimeRange>)`](crate::client::fluent_builders::ListAnomaliesForInsight::set_start_time_range): <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAnomaliesForInsight::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAnomaliesForInsight::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAnomaliesForInsight::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAnomaliesForInsight::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListAnomaliesForInsight::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListAnomaliesForInsight::set_account_id): <p>The ID of the Amazon Web Services account. </p>
    /// - On success, responds with [`ListAnomaliesForInsightOutput`](crate::output::ListAnomaliesForInsightOutput) with field(s):
    ///   - [`proactive_anomalies(Option<Vec<ProactiveAnomalySummary>>)`](crate::output::ListAnomaliesForInsightOutput::proactive_anomalies): <p> An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies </p>
    ///   - [`reactive_anomalies(Option<Vec<ReactiveAnomalySummary>>)`](crate::output::ListAnomaliesForInsightOutput::reactive_anomalies): <p> An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAnomaliesForInsightOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListAnomaliesForInsightError>`](crate::error::ListAnomaliesForInsightError)
    pub fn list_anomalies_for_insight(&self) -> fluent_builders::ListAnomaliesForInsight {
        fluent_builders::ListAnomaliesForInsight::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEvents`](crate::client::fluent_builders::ListEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(ListEventsFilters)`](crate::client::fluent_builders::ListEvents::filters) / [`set_filters(Option<ListEventsFilters>)`](crate::client::fluent_builders::ListEvents::set_filters): <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEvents::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEvents::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListEvents::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListEvents::set_account_id): <p>The ID of the Amazon Web Services account. </p>
    /// - On success, responds with [`ListEventsOutput`](crate::output::ListEventsOutput) with field(s):
    ///   - [`events(Option<Vec<Event>>)`](crate::output::ListEventsOutput::events): <p> A list of the requested events. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListEventsError>`](crate::error::ListEventsError)
    pub fn list_events(&self) -> fluent_builders::ListEvents {
        fluent_builders::ListEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInsights`](crate::client::fluent_builders::ListInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status_filter(ListInsightsStatusFilter)`](crate::client::fluent_builders::ListInsights::status_filter) / [`set_status_filter(Option<ListInsightsStatusFilter>)`](crate::client::fluent_builders::ListInsights::set_status_filter): <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInsights::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInsights::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInsights::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`ListInsightsOutput`](crate::output::ListInsightsOutput) with field(s):
    ///   - [`proactive_insights(Option<Vec<ProactiveInsightSummary>>)`](crate::output::ListInsightsOutput::proactive_insights): <p> The returned list of proactive insights. </p>
    ///   - [`reactive_insights(Option<Vec<ReactiveInsightSummary>>)`](crate::output::ListInsightsOutput::reactive_insights): <p> The returned list of reactive insights. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInsightsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListInsightsError>`](crate::error::ListInsightsError)
    pub fn list_insights(&self) -> fluent_builders::ListInsights {
        fluent_builders::ListInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNotificationChannels`](crate::client::fluent_builders::ListNotificationChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNotificationChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNotificationChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNotificationChannels::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`ListNotificationChannelsOutput`](crate::output::ListNotificationChannelsOutput) with field(s):
    ///   - [`channels(Option<Vec<NotificationChannel>>)`](crate::output::ListNotificationChannelsOutput::channels): <p> An array that contains the requested notification channels. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNotificationChannelsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListNotificationChannelsError>`](crate::error::ListNotificationChannelsError)
    pub fn list_notification_channels(&self) -> fluent_builders::ListNotificationChannels {
        fluent_builders::ListNotificationChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizationInsights`](crate::client::fluent_builders::ListOrganizationInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizationInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status_filter(ListInsightsStatusFilter)`](crate::client::fluent_builders::ListOrganizationInsights::status_filter) / [`set_status_filter(Option<ListInsightsStatusFilter>)`](crate::client::fluent_builders::ListOrganizationInsights::set_status_filter): <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrganizationInsights::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOrganizationInsights::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::ListOrganizationInsights::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListOrganizationInsights::set_account_ids): <p>The ID of the Amazon Web Services account. </p>
    ///   - [`organizational_unit_ids(Vec<String>)`](crate::client::fluent_builders::ListOrganizationInsights::organizational_unit_ids) / [`set_organizational_unit_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListOrganizationInsights::set_organizational_unit_ids): <p>The ID of the organizational unit.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrganizationInsights::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`ListOrganizationInsightsOutput`](crate::output::ListOrganizationInsightsOutput) with field(s):
    ///   - [`proactive_insights(Option<Vec<ProactiveOrganizationInsightSummary>>)`](crate::output::ListOrganizationInsightsOutput::proactive_insights): <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
    ///   - [`reactive_insights(Option<Vec<ReactiveOrganizationInsightSummary>>)`](crate::output::ListOrganizationInsightsOutput::reactive_insights): <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrganizationInsightsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationInsightsError>`](crate::error::ListOrganizationInsightsError)
    pub fn list_organization_insights(&self) -> fluent_builders::ListOrganizationInsights {
        fluent_builders::ListOrganizationInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecommendations`](crate::client::fluent_builders::ListRecommendations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecommendations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_id(impl Into<String>)`](crate::client::fluent_builders::ListRecommendations::insight_id) / [`set_insight_id(Option<String>)`](crate::client::fluent_builders::ListRecommendations::set_insight_id): <p> The ID of the requested insight. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecommendations::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`locale(Locale)`](crate::client::fluent_builders::ListRecommendations::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::ListRecommendations::set_locale): <p>A locale that specifies the language to use for recommendations.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListRecommendations::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListRecommendations::set_account_id): <p>The ID of the Amazon Web Services account. </p>
    /// - On success, responds with [`ListRecommendationsOutput`](crate::output::ListRecommendationsOutput) with field(s):
    ///   - [`recommendations(Option<Vec<Recommendation>>)`](crate::output::ListRecommendationsOutput::recommendations): <p> An array of the requested recommendations. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRecommendationsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListRecommendationsError>`](crate::error::ListRecommendationsError)
    pub fn list_recommendations(&self) -> fluent_builders::ListRecommendations {
        fluent_builders::ListRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFeedback`](crate::client::fluent_builders::PutFeedback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`insight_feedback(InsightFeedback)`](crate::client::fluent_builders::PutFeedback::insight_feedback) / [`set_insight_feedback(Option<InsightFeedback>)`](crate::client::fluent_builders::PutFeedback::set_insight_feedback): <p> The feedback from customers is about the recommendations in this insight. </p>
    /// - On success, responds with [`PutFeedbackOutput`](crate::output::PutFeedbackOutput)

    /// - On failure, responds with [`SdkError<PutFeedbackError>`](crate::error::PutFeedbackError)
    pub fn put_feedback(&self) -> fluent_builders::PutFeedback {
        fluent_builders::PutFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveNotificationChannel`](crate::client::fluent_builders::RemoveNotificationChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::RemoveNotificationChannel::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::RemoveNotificationChannel::set_id): <p> The ID of the notification channel to be removed. </p>
    /// - On success, responds with [`RemoveNotificationChannelOutput`](crate::output::RemoveNotificationChannelOutput)

    /// - On failure, responds with [`SdkError<RemoveNotificationChannelError>`](crate::error::RemoveNotificationChannelError)
    pub fn remove_notification_channel(&self) -> fluent_builders::RemoveNotificationChannel {
        fluent_builders::RemoveNotificationChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchInsights`](crate::client::fluent_builders::SearchInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time_range(StartTimeRange)`](crate::client::fluent_builders::SearchInsights::start_time_range) / [`set_start_time_range(Option<StartTimeRange>)`](crate::client::fluent_builders::SearchInsights::set_start_time_range): <p> The start of the time range passed in. Returned insights occurred after this time. </p>
    ///   - [`filters(SearchInsightsFilters)`](crate::client::fluent_builders::SearchInsights::filters) / [`set_filters(Option<SearchInsightsFilters>)`](crate::client::fluent_builders::SearchInsights::set_filters): <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchInsights::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchInsights::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchInsights::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`r#type(InsightType)`](crate::client::fluent_builders::SearchInsights::type) / [`set_type(Option<InsightType>)`](crate::client::fluent_builders::SearchInsights::set_type): <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    /// - On success, responds with [`SearchInsightsOutput`](crate::output::SearchInsightsOutput) with field(s):
    ///   - [`proactive_insights(Option<Vec<ProactiveInsightSummary>>)`](crate::output::SearchInsightsOutput::proactive_insights): <p> The returned proactive insights. </p>
    ///   - [`reactive_insights(Option<Vec<ReactiveInsightSummary>>)`](crate::output::SearchInsightsOutput::reactive_insights): <p> The returned reactive insights. </p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchInsightsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<SearchInsightsError>`](crate::error::SearchInsightsError)
    pub fn search_insights(&self) -> fluent_builders::SearchInsights {
        fluent_builders::SearchInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchOrganizationInsights`](crate::client::fluent_builders::SearchOrganizationInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchOrganizationInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::SearchOrganizationInsights::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::SearchOrganizationInsights::set_account_ids): <p>The ID of the Amazon Web Services account. </p>
    ///   - [`start_time_range(StartTimeRange)`](crate::client::fluent_builders::SearchOrganizationInsights::start_time_range) / [`set_start_time_range(Option<StartTimeRange>)`](crate::client::fluent_builders::SearchOrganizationInsights::set_start_time_range): <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
    ///   - [`filters(SearchOrganizationInsightsFilters)`](crate::client::fluent_builders::SearchOrganizationInsights::filters) / [`set_filters(Option<SearchOrganizationInsightsFilters>)`](crate::client::fluent_builders::SearchOrganizationInsights::set_filters): <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchOrganizationInsights::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchOrganizationInsights::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchOrganizationInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchOrganizationInsights::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`r#type(InsightType)`](crate::client::fluent_builders::SearchOrganizationInsights::type) / [`set_type(Option<InsightType>)`](crate::client::fluent_builders::SearchOrganizationInsights::set_type): <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    /// - On success, responds with [`SearchOrganizationInsightsOutput`](crate::output::SearchOrganizationInsightsOutput) with field(s):
    ///   - [`proactive_insights(Option<Vec<ProactiveInsightSummary>>)`](crate::output::SearchOrganizationInsightsOutput::proactive_insights): <p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>
    ///   - [`reactive_insights(Option<Vec<ReactiveInsightSummary>>)`](crate::output::SearchOrganizationInsightsOutput::reactive_insights): <p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchOrganizationInsightsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<SearchOrganizationInsightsError>`](crate::error::SearchOrganizationInsightsError)
    pub fn search_organization_insights(&self) -> fluent_builders::SearchOrganizationInsights {
        fluent_builders::SearchOrganizationInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartCostEstimation`](crate::client::fluent_builders::StartCostEstimation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_collection(CostEstimationResourceCollectionFilter)`](crate::client::fluent_builders::StartCostEstimation::resource_collection) / [`set_resource_collection(Option<CostEstimationResourceCollectionFilter>)`](crate::client::fluent_builders::StartCostEstimation::set_resource_collection): <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartCostEstimation::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartCostEstimation::set_client_token): <p>The idempotency token used to identify each cost estimate request.</p>
    /// - On success, responds with [`StartCostEstimationOutput`](crate::output::StartCostEstimationOutput)

    /// - On failure, responds with [`SdkError<StartCostEstimationError>`](crate::error::StartCostEstimationError)
    pub fn start_cost_estimation(&self) -> fluent_builders::StartCostEstimation {
        fluent_builders::StartCostEstimation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventSourcesConfig`](crate::client::fluent_builders::UpdateEventSourcesConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_sources(EventSourcesConfig)`](crate::client::fluent_builders::UpdateEventSourcesConfig::event_sources) / [`set_event_sources(Option<EventSourcesConfig>)`](crate::client::fluent_builders::UpdateEventSourcesConfig::set_event_sources): <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
    /// - On success, responds with [`UpdateEventSourcesConfigOutput`](crate::output::UpdateEventSourcesConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateEventSourcesConfigError>`](crate::error::UpdateEventSourcesConfigError)
    pub fn update_event_sources_config(&self) -> fluent_builders::UpdateEventSourcesConfig {
        fluent_builders::UpdateEventSourcesConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceCollection`](crate::client::fluent_builders::UpdateResourceCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(UpdateResourceCollectionAction)`](crate::client::fluent_builders::UpdateResourceCollection::action) / [`set_action(Option<UpdateResourceCollectionAction>)`](crate::client::fluent_builders::UpdateResourceCollection::set_action): <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
    ///   - [`resource_collection(UpdateResourceCollectionFilter)`](crate::client::fluent_builders::UpdateResourceCollection::resource_collection) / [`set_resource_collection(Option<UpdateResourceCollectionFilter>)`](crate::client::fluent_builders::UpdateResourceCollection::set_resource_collection): <p> Contains information used to update a collection of Amazon Web Services resources. </p>
    /// - On success, responds with [`UpdateResourceCollectionOutput`](crate::output::UpdateResourceCollectionOutput)

    /// - On failure, responds with [`SdkError<UpdateResourceCollectionError>`](crate::error::UpdateResourceCollectionError)
    pub fn update_resource_collection(&self) -> fluent_builders::UpdateResourceCollection {
        fluent_builders::UpdateResourceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServiceIntegration`](crate::client::fluent_builders::UpdateServiceIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_integration(UpdateServiceIntegrationConfig)`](crate::client::fluent_builders::UpdateServiceIntegration::service_integration) / [`set_service_integration(Option<UpdateServiceIntegrationConfig>)`](crate::client::fluent_builders::UpdateServiceIntegration::set_service_integration): <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
    /// - On success, responds with [`UpdateServiceIntegrationOutput`](crate::output::UpdateServiceIntegrationOutput)

    /// - On failure, responds with [`SdkError<UpdateServiceIntegrationError>`](crate::error::UpdateServiceIntegrationError)
    pub fn update_service_integration(&self) -> fluent_builders::UpdateServiceIntegration {
        fluent_builders::UpdateServiceIntegration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddNotificationChannel`.
    ///
    /// <p> Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated. </p>
    /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p>
    /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.</p>
    /// <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddNotificationChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_notification_channel_input::Builder,
    }
    impl AddNotificationChannel {
        /// Creates a new `AddNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::AddNotificationChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
        pub fn config(mut self, input: crate::model::NotificationChannelConfig) -> Self {
            self.inner = self.inner.config(input);
            self
        }
        /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::NotificationChannelConfig>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInsight`.
    ///
    /// <p>Deletes the insight along with the associated anomalies, events and recommendations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInsight {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_insight_input::Builder,
    }
    impl DeleteInsight {
        /// Creates a new `DeleteInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInsightError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the insight.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the insight.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountHealth`.
    ///
    /// <p> Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_health_input::Builder,
    }
    impl DescribeAccountHealth {
        /// Creates a new `DescribeAccountHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountHealthError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountOverview`.
    ///
    /// <p> For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountOverview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_overview_input::Builder,
    }
    impl DescribeAccountOverview {
        /// Creates a new `DescribeAccountOverview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountOverviewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountOverviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.from_time(input);
            self
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_from_time(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.to_time(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_to_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnomaly`.
    ///
    /// <p> Returns details about an anomaly that you specify using its ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAnomaly {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_anomaly_input::Builder,
    }
    impl DescribeAnomaly {
        /// Creates a new `DescribeAnomaly`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnomalyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnomalyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the anomaly. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p> The ID of the anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSourcesConfig`.
    ///
    /// <p>Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventSourcesConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_sources_config_input::Builder,
    }
    impl DescribeEventSourcesConfig {
        /// Creates a new `DescribeEventSourcesConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSourcesConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSourcesConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeFeedback`.
    ///
    /// <p> Returns the most recent feedback submitted in the current Amazon Web Services account and Region. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFeedback {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_feedback_input::Builder,
    }
    impl DescribeFeedback {
        /// Creates a new `DescribeFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFeedbackError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the insight for which the feedback was provided. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(input.into());
            self
        }
        /// <p> The ID of the insight for which the feedback was provided. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInsight`.
    ///
    /// <p> Returns details about an insight that you specify using its ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInsight {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_insight_input::Builder,
    }
    impl DescribeInsight {
        /// Creates a new `DescribeInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInsightError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p> The ID of the insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the member account in the organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The ID of the member account in the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationHealth`.
    ///
    /// <p>Returns active insights, predictive insights, and resource hours analyzed in last hour.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_health_input::Builder,
    }
    impl DescribeOrganizationHealth {
        /// Creates a new `DescribeOrganizationHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationHealthError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(input.into());
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationOverview`.
    ///
    /// <p>Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationOverview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_overview_input::Builder,
    }
    impl DescribeOrganizationOverview {
        /// Creates a new `DescribeOrganizationOverview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationOverviewOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationOverviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.from_time(input);
            self
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_from_time(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.to_time(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_to_time(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(input.into());
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationResourceCollectionHealth`.
    ///
    /// <p>Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the <code>AccountIds</code> field.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationResourceCollectionHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_resource_collection_health_input::Builder,
    }
    impl DescribeOrganizationResourceCollectionHealth {
        /// Creates a new `DescribeOrganizationResourceCollectionHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationResourceCollectionHealthOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrganizationResourceCollectionHealthError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrganizationResourceCollectionHealthPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrganizationResourceCollectionHealthPaginator {
            crate::paginator::DescribeOrganizationResourceCollectionHealthPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn organization_resource_collection_type(
            mut self,
            input: crate::model::OrganizationResourceCollectionType,
        ) -> Self {
            self.inner = self.inner.organization_resource_collection_type(input);
            self
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_organization_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_organization_resource_collection_type(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(input.into());
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourceCollectionHealth`.
    ///
    /// <p> Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourceCollectionHealth {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_collection_health_input::Builder,
    }
    impl DescribeResourceCollectionHealth {
        /// Creates a new `DescribeResourceCollectionHealth`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceCollectionHealthOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceCollectionHealthError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeResourceCollectionHealthPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeResourceCollectionHealthPaginator {
            crate::paginator::DescribeResourceCollectionHealthPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection_type(
            mut self,
            input: crate::model::ResourceCollectionType,
        ) -> Self {
            self.inner = self.inner.resource_collection_type(input);
            self
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection_type(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceIntegration`.
    ///
    /// <p> Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServiceIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_service_integration_input::Builder,
    }
    impl DescribeServiceIntegration {
        /// Creates a new `DescribeServiceIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetCostEstimation`.
    ///
    /// <p>Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCostEstimation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cost_estimation_input::Builder,
    }
    impl GetCostEstimation {
        /// Creates a new `GetCostEstimation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCostEstimationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCostEstimationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCostEstimationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCostEstimationPaginator {
            crate::paginator::GetCostEstimationPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceCollection`.
    ///
    /// <p> Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_collection_input::Builder,
    }
    impl GetResourceCollection {
        /// Creates a new `GetResourceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourceCollectionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetResourceCollectionPaginator {
            crate::paginator::GetResourceCollectionPaginator::new(self.handle, self.inner)
        }
        /// <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection_type(
            mut self,
            input: crate::model::ResourceCollectionType,
        ) -> Self {
            self.inner = self.inner.resource_collection_type(input);
            self
        }
        /// <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection_type(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnomaliesForInsight`.
    ///
    /// <p> Returns a list of the anomalies that belong to an insight that you specify using its ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAnomaliesForInsight {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_anomalies_for_insight_input::Builder,
    }
    impl ListAnomaliesForInsight {
        /// Creates a new `ListAnomaliesForInsight`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnomaliesForInsightOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnomaliesForInsightError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAnomaliesForInsightPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAnomaliesForInsightPaginator {
            crate::paginator::ListAnomaliesForInsightPaginator::new(self.handle, self.inner)
        }
        /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(input.into());
            self
        }
        /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.inner = self.inner.start_time_range(input);
            self
        }
        /// <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_range(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEvents`.
    ///
    /// <p> Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_events_input::Builder,
    }
    impl ListEvents {
        /// Creates a new `ListEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventsPaginator {
            crate::paginator::ListEventsPaginator::new(self.handle, self.inner)
        }
        /// <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
        pub fn filters(mut self, input: crate::model::ListEventsFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListEventsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInsights`.
    ///
    /// <p> Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_insights_input::Builder,
    }
    impl ListInsights {
        /// Creates a new `ListInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInsightsPaginator {
            crate::paginator::ListInsightsPaginator::new(self.handle, self.inner)
        }
        /// <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
        pub fn status_filter(mut self, input: crate::model::ListInsightsStatusFilter) -> Self {
            self.inner = self.inner.status_filter(input);
            self
        }
        /// <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ListInsightsStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotificationChannels`.
    ///
    /// <p> Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNotificationChannels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_notification_channels_input::Builder,
    }
    impl ListNotificationChannels {
        /// Creates a new `ListNotificationChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationChannelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNotificationChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNotificationChannelsPaginator {
            crate::paginator::ListNotificationChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationInsights`.
    ///
    /// <p>Returns a list of insights associated with the account or OU Id.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizationInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_organization_insights_input::Builder,
    }
    impl ListOrganizationInsights {
        /// Creates a new `ListOrganizationInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOrganizationInsightsPaginator {
            crate::paginator::ListOrganizationInsightsPaginator::new(self.handle, self.inner)
        }
        /// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
        pub fn status_filter(mut self, input: crate::model::ListInsightsStatusFilter) -> Self {
            self.inner = self.inner.status_filter(input);
            self
        }
        /// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ListInsightsStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `OrganizationalUnitIds`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizational_unit_ids(input.into());
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_organizational_unit_ids(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendations`.
    ///
    /// <p> Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_recommendations_input::Builder,
    }
    impl ListRecommendations {
        /// Creates a new `ListRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecommendationsPaginator {
            crate::paginator::ListRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p> The ID of the requested insight. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.insight_id(input.into());
            self
        }
        /// <p> The ID of the requested insight. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_insight_id(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A locale that specifies the language to use for recommendations.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>A locale that specifies the language to use for recommendations.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFeedback`.
    ///
    /// <p> Collects customer feedback about the specified insight. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFeedback {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_feedback_input::Builder,
    }
    impl PutFeedback {
        /// Creates a new `PutFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFeedbackError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The feedback from customers is about the recommendations in this insight. </p>
        pub fn insight_feedback(mut self, input: crate::model::InsightFeedback) -> Self {
            self.inner = self.inner.insight_feedback(input);
            self
        }
        /// <p> The feedback from customers is about the recommendations in this insight. </p>
        pub fn set_insight_feedback(
            mut self,
            input: std::option::Option<crate::model::InsightFeedback>,
        ) -> Self {
            self.inner = self.inner.set_insight_feedback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveNotificationChannel`.
    ///
    /// <p> Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveNotificationChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_notification_channel_input::Builder,
    }
    impl RemoveNotificationChannel {
        /// Creates a new `RemoveNotificationChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveNotificationChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveNotificationChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of the notification channel to be removed. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p> The ID of the notification channel to be removed. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchInsights`.
    ///
    /// <p> Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    /// <p> Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_insights_input::Builder,
    }
    impl SearchInsights {
        /// Creates a new `SearchInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchInsightsPaginator {
            crate::paginator::SearchInsightsPaginator::new(self.handle, self.inner)
        }
        /// <p> The start of the time range passed in. Returned insights occurred after this time. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.inner = self.inner.start_time_range(input);
            self
        }
        /// <p> The start of the time range passed in. Returned insights occurred after this time. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_range(input);
            self
        }
        /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn filters(mut self, input: crate::model::SearchInsightsFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::SearchInsightsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchOrganizationInsights`.
    ///
    /// <p> Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    /// <p> Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchOrganizationInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_organization_insights_input::Builder,
    }
    impl SearchOrganizationInsights {
        /// Creates a new `SearchOrganizationInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchOrganizationInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchOrganizationInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchOrganizationInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchOrganizationInsightsPaginator {
            crate::paginator::SearchOrganizationInsightsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.inner = self.inner.start_time_range(input);
            self
        }
        /// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_range(input);
            self
        }
        /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn filters(mut self, input: crate::model::SearchOrganizationInsightsFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::SearchOrganizationInsightsFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCostEstimation`.
    ///
    /// <p>Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartCostEstimation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_cost_estimation_input::Builder,
    }
    impl StartCostEstimation {
        /// Creates a new `StartCostEstimation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCostEstimationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCostEstimationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
        pub fn resource_collection(
            mut self,
            input: crate::model::CostEstimationResourceCollectionFilter,
        ) -> Self {
            self.inner = self.inner.resource_collection(input);
            self
        }
        /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::CostEstimationResourceCollectionFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection(input);
            self
        }
        /// <p>The idempotency token used to identify each cost estimate request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token used to identify each cost estimate request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventSourcesConfig`.
    ///
    /// <p>Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventSourcesConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_event_sources_config_input::Builder,
    }
    impl UpdateEventSourcesConfig {
        /// Creates a new `UpdateEventSourcesConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventSourcesConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventSourcesConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
        pub fn event_sources(mut self, input: crate::model::EventSourcesConfig) -> Self {
            self.inner = self.inner.event_sources(input);
            self
        }
        /// <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
        pub fn set_event_sources(
            mut self,
            input: std::option::Option<crate::model::EventSourcesConfig>,
        ) -> Self {
            self.inner = self.inner.set_event_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceCollection`.
    ///
    /// <p> Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourceCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resource_collection_input::Builder,
    }
    impl UpdateResourceCollection {
        /// Creates a new `UpdateResourceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
        pub fn action(mut self, input: crate::model::UpdateResourceCollectionAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::UpdateResourceCollectionAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
        pub fn resource_collection(
            mut self,
            input: crate::model::UpdateResourceCollectionFilter,
        ) -> Self {
            self.inner = self.inner.resource_collection(input);
            self
        }
        /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::UpdateResourceCollectionFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_collection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceIntegration`.
    ///
    /// <p> Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateServiceIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_service_integration_input::Builder,
    }
    impl UpdateServiceIntegration {
        /// Creates a new `UpdateServiceIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
        pub fn service_integration(
            mut self,
            input: crate::model::UpdateServiceIntegrationConfig,
        ) -> Self {
            self.inner = self.inner.service_integration(input);
            self
        }
        /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
        pub fn set_service_integration(
            mut self,
            input: std::option::Option<crate::model::UpdateServiceIntegrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_service_integration(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
