// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddNotificationChannelInput`](crate::input::AddNotificationChannelInput)
pub mod add_notification_channel_input {
    /// A builder for [`AddNotificationChannelInput`](crate::input::AddNotificationChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config: std::option::Option<crate::model::NotificationChannelConfig>,
    }
    impl Builder {
        /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
        pub fn config(mut self, input: crate::model::NotificationChannelConfig) -> Self {
            self.config = Some(input);
            self
        }
        /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::NotificationChannelConfig>,
        ) -> Self {
            self.config = input;
            self
        }
        /// Consumes the builder and constructs a [`AddNotificationChannelInput`](crate::input::AddNotificationChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddNotificationChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddNotificationChannelInput {
                config: self.config,
            })
        }
    }
}
#[doc(hidden)]
pub type AddNotificationChannelInputOperationOutputAlias = crate::operation::AddNotificationChannel;
#[doc(hidden)]
pub type AddNotificationChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddNotificationChannelInput {
    /// Consumes the builder and constructs an Operation<[`AddNotificationChannel`](crate::operation::AddNotificationChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddNotificationChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddNotificationChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/channels").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddNotificationChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_notification_channel(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddNotificationChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddNotificationChannel",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddNotificationChannelInput`](crate::input::AddNotificationChannelInput)
    pub fn builder() -> crate::input::add_notification_channel_input::Builder {
        crate::input::add_notification_channel_input::Builder::default()
    }
}

/// See [`DeleteInsightInput`](crate::input::DeleteInsightInput)
pub mod delete_insight_input {
    /// A builder for [`DeleteInsightInput`](crate::input::DeleteInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the insight.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the insight.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInsightInput`](crate::input::DeleteInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInsightInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteInsightInputOperationOutputAlias = crate::operation::DeleteInsight;
#[doc(hidden)]
pub type DeleteInsightInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInsightInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInsight`](crate::operation::DeleteInsight)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInsight,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInsightInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_1, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/insights/{Id}", Id = id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInsightInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInsight",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInsightInput`](crate::input::DeleteInsightInput)
    pub fn builder() -> crate::input::delete_insight_input::Builder {
        crate::input::delete_insight_input::Builder::default()
    }
}

/// See [`DescribeAccountHealthInput`](crate::input::DescribeAccountHealthInput)
pub mod describe_account_health_input {
    /// A builder for [`DescribeAccountHealthInput`](crate::input::DescribeAccountHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountHealthInput`](crate::input::DescribeAccountHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountHealthInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountHealthInputOperationOutputAlias = crate::operation::DescribeAccountHealth;
#[doc(hidden)]
pub type DescribeAccountHealthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountHealth`](crate::operation::DescribeAccountHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/accounts/health").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountHealth",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountHealthInput`](crate::input::DescribeAccountHealthInput)
    pub fn builder() -> crate::input::describe_account_health_input::Builder {
        crate::input::describe_account_health_input::Builder::default()
    }
}

/// See [`DescribeAccountOverviewInput`](crate::input::DescribeAccountOverviewInput)
pub mod describe_account_overview_input {
    /// A builder for [`DescribeAccountOverviewInput`](crate::input::DescribeAccountOverviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountOverviewInput`](crate::input::DescribeAccountOverviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountOverviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountOverviewInput {
                from_time: self.from_time,
                to_time: self.to_time,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountOverviewInputOperationOutputAlias =
    crate::operation::DescribeAccountOverview;
#[doc(hidden)]
pub type DescribeAccountOverviewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountOverviewInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountOverview`](crate::operation::DescribeAccountOverview)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountOverview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountOverviewInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/accounts/overview").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountOverviewInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_overview(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountOverview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountOverview",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountOverviewInput`](crate::input::DescribeAccountOverviewInput)
    pub fn builder() -> crate::input::describe_account_overview_input::Builder {
        crate::input::describe_account_overview_input::Builder::default()
    }
}

/// See [`DescribeAnomalyInput`](crate::input::DescribeAnomalyInput)
pub mod describe_anomaly_input {
    /// A builder for [`DescribeAnomalyInput`](crate::input::DescribeAnomalyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the anomaly. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnomalyInput`](crate::input::DescribeAnomalyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAnomalyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAnomalyInput {
                id: self.id,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAnomalyInputOperationOutputAlias = crate::operation::DescribeAnomaly;
#[doc(hidden)]
pub type DescribeAnomalyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAnomalyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAnomaly`](crate::operation::DescribeAnomaly)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAnomaly,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAnomalyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_2, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/anomalies/{Id}", Id = id).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeAnomalyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_3) = &_input.account_id {
                    query.push_kv("AccountId", &aws_smithy_http::query::fmt_string(&inner_3));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAnomalyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAnomaly::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAnomaly",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyInput`](crate::input::DescribeAnomalyInput)
    pub fn builder() -> crate::input::describe_anomaly_input::Builder {
        crate::input::describe_anomaly_input::Builder::default()
    }
}

/// See [`DescribeEventSourcesConfigInput`](crate::input::DescribeEventSourcesConfigInput)
pub mod describe_event_sources_config_input {
    /// A builder for [`DescribeEventSourcesConfigInput`](crate::input::DescribeEventSourcesConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeEventSourcesConfigInput`](crate::input::DescribeEventSourcesConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSourcesConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSourcesConfigInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSourcesConfigInputOperationOutputAlias =
    crate::operation::DescribeEventSourcesConfig;
#[doc(hidden)]
pub type DescribeEventSourcesConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventSourcesConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSourcesConfig`](crate::operation::DescribeEventSourcesConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSourcesConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEventSourcesConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/event-sources").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEventSourcesConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSourcesConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSourcesConfig",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSourcesConfigInput`](crate::input::DescribeEventSourcesConfigInput)
    pub fn builder() -> crate::input::describe_event_sources_config_input::Builder {
        crate::input::describe_event_sources_config_input::Builder::default()
    }
}

/// See [`DescribeFeedbackInput`](crate::input::DescribeFeedbackInput)
pub mod describe_feedback_input {
    /// A builder for [`DescribeFeedbackInput`](crate::input::DescribeFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the insight for which the feedback was provided. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the insight for which the feedback was provided. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFeedbackInput`](crate::input::DescribeFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFeedbackInput {
                insight_id: self.insight_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFeedbackInputOperationOutputAlias = crate::operation::DescribeFeedback;
#[doc(hidden)]
pub type DescribeFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFeedback`](crate::operation::DescribeFeedback)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeFeedbackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/feedback").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeFeedbackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_feedback(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFeedback",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeFeedbackInput`](crate::input::DescribeFeedbackInput)
    pub fn builder() -> crate::input::describe_feedback_input::Builder {
        crate::input::describe_feedback_input::Builder::default()
    }
}

/// See [`DescribeInsightInput`](crate::input::DescribeInsightInput)
pub mod describe_insight_input {
    /// A builder for [`DescribeInsightInput`](crate::input::DescribeInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the member account in the organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the member account in the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInsightInput`](crate::input::DescribeInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInsightInput {
                id: self.id,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInsightInputOperationOutputAlias = crate::operation::DescribeInsight;
#[doc(hidden)]
pub type DescribeInsightInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInsightInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInsight`](crate::operation::DescribeInsight)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInsight,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInsightInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_4, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/insights/{Id}", Id = id).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeInsightInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_5) = &_input.account_id {
                    query.push_kv("AccountId", &aws_smithy_http::query::fmt_string(&inner_5));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInsightInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInsight",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInsightInput`](crate::input::DescribeInsightInput)
    pub fn builder() -> crate::input::describe_insight_input::Builder {
        crate::input::describe_insight_input::Builder::default()
    }
}

/// See [`DescribeOrganizationHealthInput`](crate::input::DescribeOrganizationHealthInput)
pub mod describe_organization_health_input {
    /// A builder for [`DescribeOrganizationHealthInput`](crate::input::DescribeOrganizationHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `organizational_unit_ids`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_unit_ids.unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_ids = Some(v);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationHealthInput`](crate::input::DescribeOrganizationHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationHealthInput {
                account_ids: self.account_ids,
                organizational_unit_ids: self.organizational_unit_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationHealthInputOperationOutputAlias =
    crate::operation::DescribeOrganizationHealth;
#[doc(hidden)]
pub type DescribeOrganizationHealthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationHealth`](crate::operation::DescribeOrganizationHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/organization/health").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_health(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationHealth",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationHealthInput`](crate::input::DescribeOrganizationHealthInput)
    pub fn builder() -> crate::input::describe_organization_health_input::Builder {
        crate::input::describe_organization_health_input::Builder::default()
    }
}

/// See [`DescribeOrganizationOverviewInput`](crate::input::DescribeOrganizationOverviewInput)
pub mod describe_organization_overview_input {
    /// A builder for [`DescribeOrganizationOverviewInput`](crate::input::DescribeOrganizationOverviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn from_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn to_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `organizational_unit_ids`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_unit_ids.unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_ids = Some(v);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationOverviewInput`](crate::input::DescribeOrganizationOverviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationOverviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationOverviewInput {
                from_time: self.from_time,
                to_time: self.to_time,
                account_ids: self.account_ids,
                organizational_unit_ids: self.organizational_unit_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationOverviewInputOperationOutputAlias =
    crate::operation::DescribeOrganizationOverview;
#[doc(hidden)]
pub type DescribeOrganizationOverviewInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationOverviewInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationOverview`](crate::operation::DescribeOrganizationOverview)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationOverview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationOverviewInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/organization/overview").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationOverviewInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_overview(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationOverview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationOverview",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationOverviewInput`](crate::input::DescribeOrganizationOverviewInput)
    pub fn builder() -> crate::input::describe_organization_overview_input::Builder {
        crate::input::describe_organization_overview_input::Builder::default()
    }
}

/// See [`DescribeOrganizationResourceCollectionHealthInput`](crate::input::DescribeOrganizationResourceCollectionHealthInput)
pub mod describe_organization_resource_collection_health_input {
    /// A builder for [`DescribeOrganizationResourceCollectionHealthInput`](crate::input::DescribeOrganizationResourceCollectionHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_resource_collection_type:
            std::option::Option<crate::model::OrganizationResourceCollectionType>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn organization_resource_collection_type(
            mut self,
            input: crate::model::OrganizationResourceCollectionType,
        ) -> Self {
            self.organization_resource_collection_type = Some(input);
            self
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_organization_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::OrganizationResourceCollectionType>,
        ) -> Self {
            self.organization_resource_collection_type = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `organizational_unit_ids`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_unit_ids.unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_ids = Some(v);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_ids = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationResourceCollectionHealthInput`](crate::input::DescribeOrganizationResourceCollectionHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationResourceCollectionHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeOrganizationResourceCollectionHealthInput {
                    organization_resource_collection_type: self
                        .organization_resource_collection_type,
                    account_ids: self.account_ids,
                    organizational_unit_ids: self.organizational_unit_ids,
                    next_token: self.next_token,
                    max_results: self.max_results,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationResourceCollectionHealthInputOperationOutputAlias =
    crate::operation::DescribeOrganizationResourceCollectionHealth;
#[doc(hidden)]
pub type DescribeOrganizationResourceCollectionHealthInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationResourceCollectionHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationResourceCollectionHealth`](crate::operation::DescribeOrganizationResourceCollectionHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationResourceCollectionHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeOrganizationResourceCollectionHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/organization/health/resource-collection")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeOrganizationResourceCollectionHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_organization_resource_collection_health(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationResourceCollectionHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationResourceCollectionHealth",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationResourceCollectionHealthInput`](crate::input::DescribeOrganizationResourceCollectionHealthInput)
    pub fn builder() -> crate::input::describe_organization_resource_collection_health_input::Builder
    {
        crate::input::describe_organization_resource_collection_health_input::Builder::default()
    }
}

/// See [`DescribeResourceCollectionHealthInput`](crate::input::DescribeResourceCollectionHealthInput)
pub mod describe_resource_collection_health_input {
    /// A builder for [`DescribeResourceCollectionHealthInput`](crate::input::DescribeResourceCollectionHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_collection_type:
            std::option::Option<crate::model::ResourceCollectionType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection_type(
            mut self,
            input: crate::model::ResourceCollectionType,
        ) -> Self {
            self.resource_collection_type = Some(input);
            self
        }
        /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.resource_collection_type = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourceCollectionHealthInput`](crate::input::DescribeResourceCollectionHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourceCollectionHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourceCollectionHealthInput {
                resource_collection_type: self.resource_collection_type,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourceCollectionHealthInputOperationOutputAlias =
    crate::operation::DescribeResourceCollectionHealth;
#[doc(hidden)]
pub type DescribeResourceCollectionHealthInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeResourceCollectionHealthInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResourceCollectionHealth`](crate::operation::DescribeResourceCollectionHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResourceCollectionHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeResourceCollectionHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.resource_collection_type;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_collection_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_collection_type = aws_smithy_http::label::fmt_string(input_6, false);
                if resource_collection_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_collection_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/accounts/health/resource-collection/{ResourceCollectionType}",
                    ResourceCollectionType = resource_collection_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeResourceCollectionHealthInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_7) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_7));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeResourceCollectionHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResourceCollectionHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResourceCollectionHealth",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourceCollectionHealthInput`](crate::input::DescribeResourceCollectionHealthInput)
    pub fn builder() -> crate::input::describe_resource_collection_health_input::Builder {
        crate::input::describe_resource_collection_health_input::Builder::default()
    }
}

/// See [`DescribeServiceIntegrationInput`](crate::input::DescribeServiceIntegrationInput)
pub mod describe_service_integration_input {
    /// A builder for [`DescribeServiceIntegrationInput`](crate::input::DescribeServiceIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeServiceIntegrationInput`](crate::input::DescribeServiceIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServiceIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServiceIntegrationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeServiceIntegrationInputOperationOutputAlias =
    crate::operation::DescribeServiceIntegration;
#[doc(hidden)]
pub type DescribeServiceIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeServiceIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServiceIntegration`](crate::operation::DescribeServiceIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServiceIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeServiceIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/service-integrations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeServiceIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServiceIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServiceIntegration",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeServiceIntegrationInput`](crate::input::DescribeServiceIntegrationInput)
    pub fn builder() -> crate::input::describe_service_integration_input::Builder {
        crate::input::describe_service_integration_input::Builder::default()
    }
}

/// See [`GetCostEstimationInput`](crate::input::GetCostEstimationInput)
pub mod get_cost_estimation_input {
    /// A builder for [`GetCostEstimationInput`](crate::input::GetCostEstimationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostEstimationInput`](crate::input::GetCostEstimationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCostEstimationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCostEstimationInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCostEstimationInputOperationOutputAlias = crate::operation::GetCostEstimation;
#[doc(hidden)]
pub type GetCostEstimationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCostEstimationInput {
    /// Consumes the builder and constructs an Operation<[`GetCostEstimation`](crate::operation::GetCostEstimation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCostEstimation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCostEstimationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cost-estimation").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetCostEstimationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCostEstimationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCostEstimation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCostEstimation",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCostEstimationInput`](crate::input::GetCostEstimationInput)
    pub fn builder() -> crate::input::get_cost_estimation_input::Builder {
        crate::input::get_cost_estimation_input::Builder::default()
    }
}

/// See [`GetResourceCollectionInput`](crate::input::GetResourceCollectionInput)
pub mod get_resource_collection_input {
    /// A builder for [`GetResourceCollectionInput`](crate::input::GetResourceCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_collection_type:
            std::option::Option<crate::model::ResourceCollectionType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
        pub fn resource_collection_type(
            mut self,
            input: crate::model::ResourceCollectionType,
        ) -> Self {
            self.resource_collection_type = Some(input);
            self
        }
        /// <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
        pub fn set_resource_collection_type(
            mut self,
            input: std::option::Option<crate::model::ResourceCollectionType>,
        ) -> Self {
            self.resource_collection_type = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceCollectionInput`](crate::input::GetResourceCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceCollectionInput {
                resource_collection_type: self.resource_collection_type,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceCollectionInputOperationOutputAlias = crate::operation::GetResourceCollection;
#[doc(hidden)]
pub type GetResourceCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourceCollectionInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceCollection`](crate::operation::GetResourceCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetResourceCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.resource_collection_type;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_collection_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_collection_type = aws_smithy_http::label::fmt_string(input_9, false);
                if resource_collection_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_collection_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/resource-collections/{ResourceCollectionType}",
                    ResourceCollectionType = resource_collection_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetResourceCollectionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_10) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_10));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetResourceCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceCollection",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetResourceCollectionInput`](crate::input::GetResourceCollectionInput)
    pub fn builder() -> crate::input::get_resource_collection_input::Builder {
        crate::input::get_resource_collection_input::Builder::default()
    }
}

/// See [`ListAnomaliesForInsightInput`](crate::input::ListAnomaliesForInsightInput)
pub mod list_anomalies_for_insight_input {
    /// A builder for [`ListAnomaliesForInsightInput`](crate::input::ListAnomaliesForInsightInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) start_time_range: std::option::Option<crate::model::StartTimeRange>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.start_time_range = Some(input);
            self
        }
        /// <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.start_time_range = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomaliesForInsightInput`](crate::input::ListAnomaliesForInsightInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnomaliesForInsightInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnomaliesForInsightInput {
                insight_id: self.insight_id,
                start_time_range: self.start_time_range,
                max_results: self.max_results,
                next_token: self.next_token,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnomaliesForInsightInputOperationOutputAlias =
    crate::operation::ListAnomaliesForInsight;
#[doc(hidden)]
pub type ListAnomaliesForInsightInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnomaliesForInsightInput {
    /// Consumes the builder and constructs an Operation<[`ListAnomaliesForInsight`](crate::operation::ListAnomaliesForInsight)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnomaliesForInsight,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAnomaliesForInsightInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.insight_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "insight_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let insight_id = aws_smithy_http::label::fmt_string(input_11, false);
                if insight_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "insight_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/anomalies/insight/{InsightId}",
                    InsightId = insight_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAnomaliesForInsightInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_anomalies_for_insight(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnomaliesForInsight::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnomaliesForInsight",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAnomaliesForInsightInput`](crate::input::ListAnomaliesForInsightInput)
    pub fn builder() -> crate::input::list_anomalies_for_insight_input::Builder {
        crate::input::list_anomalies_for_insight_input::Builder::default()
    }
}

/// See [`ListEventsInput`](crate::input::ListEventsInput)
pub mod list_events_input {
    /// A builder for [`ListEventsInput`](crate::input::ListEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<crate::model::ListEventsFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
        pub fn filters(mut self, input: crate::model::ListEventsFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::ListEventsFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventsInput`](crate::input::ListEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventsInputOperationOutputAlias = crate::operation::ListEvents;
#[doc(hidden)]
pub type ListEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEventsInput {
    /// Consumes the builder and constructs an Operation<[`ListEvents`](crate::operation::ListEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/events").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_events(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEvents",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEventsInput`](crate::input::ListEventsInput)
    pub fn builder() -> crate::input::list_events_input::Builder {
        crate::input::list_events_input::Builder::default()
    }
}

/// See [`ListInsightsInput`](crate::input::ListInsightsInput)
pub mod list_insights_input {
    /// A builder for [`ListInsightsInput`](crate::input::ListInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_filter: std::option::Option<crate::model::ListInsightsStatusFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
        pub fn status_filter(mut self, input: crate::model::ListInsightsStatusFilter) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ListInsightsStatusFilter>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsInput`](crate::input::ListInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInsightsInput {
                status_filter: self.status_filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInsightsInputOperationOutputAlias = crate::operation::ListInsights;
#[doc(hidden)]
pub type ListInsightsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInsightsInput {
    /// Consumes the builder and constructs an Operation<[`ListInsights`](crate::operation::ListInsights)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInsights,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListInsightsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/insights").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListInsightsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_insights(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInsights",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListInsightsInput`](crate::input::ListInsightsInput)
    pub fn builder() -> crate::input::list_insights_input::Builder {
        crate::input::list_insights_input::Builder::default()
    }
}

/// See [`ListNotificationChannelsInput`](crate::input::ListNotificationChannelsInput)
pub mod list_notification_channels_input {
    /// A builder for [`ListNotificationChannelsInput`](crate::input::ListNotificationChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationChannelsInput`](crate::input::ListNotificationChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNotificationChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNotificationChannelsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNotificationChannelsInputOperationOutputAlias =
    crate::operation::ListNotificationChannels;
#[doc(hidden)]
pub type ListNotificationChannelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListNotificationChannelsInput {
    /// Consumes the builder and constructs an Operation<[`ListNotificationChannels`](crate::operation::ListNotificationChannels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNotificationChannels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListNotificationChannelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/channels").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListNotificationChannelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_notification_channels(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNotificationChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNotificationChannels",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListNotificationChannelsInput`](crate::input::ListNotificationChannelsInput)
    pub fn builder() -> crate::input::list_notification_channels_input::Builder {
        crate::input::list_notification_channels_input::Builder::default()
    }
}

/// See [`ListOrganizationInsightsInput`](crate::input::ListOrganizationInsightsInput)
pub mod list_organization_insights_input {
    /// A builder for [`ListOrganizationInsightsInput`](crate::input::ListOrganizationInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_filter: std::option::Option<crate::model::ListInsightsStatusFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
        pub fn status_filter(mut self, input: crate::model::ListInsightsStatusFilter) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ListInsightsStatusFilter>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `organizational_unit_ids`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The ID of the organizational unit.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_unit_ids.unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_ids = Some(v);
            self
        }
        /// <p>The ID of the organizational unit.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_ids = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationInsightsInput`](crate::input::ListOrganizationInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationInsightsInput {
                status_filter: self.status_filter,
                max_results: self.max_results,
                account_ids: self.account_ids,
                organizational_unit_ids: self.organizational_unit_ids,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationInsightsInputOperationOutputAlias =
    crate::operation::ListOrganizationInsights;
#[doc(hidden)]
pub type ListOrganizationInsightsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOrganizationInsightsInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizationInsights`](crate::operation::ListOrganizationInsights)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizationInsights,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListOrganizationInsightsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/organization/insights").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListOrganizationInsightsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_organization_insights(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizationInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizationInsights",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationInsightsInput`](crate::input::ListOrganizationInsightsInput)
    pub fn builder() -> crate::input::list_organization_insights_input::Builder {
        crate::input::list_organization_insights_input::Builder::default()
    }
}

/// See [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
pub mod list_recommendations_input {
    /// A builder for [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the requested insight. </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p> The ID of the requested insight. </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A locale that specifies the language to use for recommendations.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>A locale that specifies the language to use for recommendations.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecommendationsInput {
                insight_id: self.insight_id,
                next_token: self.next_token,
                locale: self.locale,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecommendationsInputOperationOutputAlias = crate::operation::ListRecommendations;
#[doc(hidden)]
pub type ListRecommendationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListRecommendations`](crate::operation::ListRecommendations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecommendations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRecommendationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/recommendations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRecommendationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_recommendations(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecommendations",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRecommendationsInput`](crate::input::ListRecommendationsInput)
    pub fn builder() -> crate::input::list_recommendations_input::Builder {
        crate::input::list_recommendations_input::Builder::default()
    }
}

/// See [`PutFeedbackInput`](crate::input::PutFeedbackInput)
pub mod put_feedback_input {
    /// A builder for [`PutFeedbackInput`](crate::input::PutFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_feedback: std::option::Option<crate::model::InsightFeedback>,
    }
    impl Builder {
        /// <p> The feedback from customers is about the recommendations in this insight. </p>
        pub fn insight_feedback(mut self, input: crate::model::InsightFeedback) -> Self {
            self.insight_feedback = Some(input);
            self
        }
        /// <p> The feedback from customers is about the recommendations in this insight. </p>
        pub fn set_insight_feedback(
            mut self,
            input: std::option::Option<crate::model::InsightFeedback>,
        ) -> Self {
            self.insight_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFeedbackInput`](crate::input::PutFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFeedbackInput {
                insight_feedback: self.insight_feedback,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFeedbackInputOperationOutputAlias = crate::operation::PutFeedback;
#[doc(hidden)]
pub type PutFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`PutFeedback`](crate::operation::PutFeedback)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutFeedbackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/feedback").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutFeedbackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_feedback(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFeedback",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutFeedbackInput`](crate::input::PutFeedbackInput)
    pub fn builder() -> crate::input::put_feedback_input::Builder {
        crate::input::put_feedback_input::Builder::default()
    }
}

/// See [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
pub mod remove_notification_channel_input {
    /// A builder for [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the notification channel to be removed. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The ID of the notification channel to be removed. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveNotificationChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveNotificationChannelInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type RemoveNotificationChannelInputOperationOutputAlias =
    crate::operation::RemoveNotificationChannel;
#[doc(hidden)]
pub type RemoveNotificationChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveNotificationChannelInput {
    /// Consumes the builder and constructs an Operation<[`RemoveNotificationChannel`](crate::operation::RemoveNotificationChannel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveNotificationChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveNotificationChannelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_12, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/channels/{Id}", Id = id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveNotificationChannelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveNotificationChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveNotificationChannel",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveNotificationChannelInput`](crate::input::RemoveNotificationChannelInput)
    pub fn builder() -> crate::input::remove_notification_channel_input::Builder {
        crate::input::remove_notification_channel_input::Builder::default()
    }
}

/// See [`SearchInsightsInput`](crate::input::SearchInsightsInput)
pub mod search_insights_input {
    /// A builder for [`SearchInsightsInput`](crate::input::SearchInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time_range: std::option::Option<crate::model::StartTimeRange>,
        pub(crate) filters: std::option::Option<crate::model::SearchInsightsFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
    }
    impl Builder {
        /// <p> The start of the time range passed in. Returned insights occurred after this time. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.start_time_range = Some(input);
            self
        }
        /// <p> The start of the time range passed in. Returned insights occurred after this time. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.start_time_range = input;
            self
        }
        /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn filters(mut self, input: crate::model::SearchInsightsFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::SearchInsightsFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchInsightsInput`](crate::input::SearchInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchInsightsInput {
                start_time_range: self.start_time_range,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchInsightsInputOperationOutputAlias = crate::operation::SearchInsights;
#[doc(hidden)]
pub type SearchInsightsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchInsightsInput {
    /// Consumes the builder and constructs an Operation<[`SearchInsights`](crate::operation::SearchInsights)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchInsights,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SearchInsightsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/insights/search").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SearchInsightsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_insights(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchInsights",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SearchInsightsInput`](crate::input::SearchInsightsInput)
    pub fn builder() -> crate::input::search_insights_input::Builder {
        crate::input::search_insights_input::Builder::default()
    }
}

/// See [`SearchOrganizationInsightsInput`](crate::input::SearchOrganizationInsightsInput)
pub mod search_organization_insights_input {
    /// A builder for [`SearchOrganizationInsightsInput`](crate::input::SearchOrganizationInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) start_time_range: std::option::Option<crate::model::StartTimeRange>,
        pub(crate) filters: std::option::Option<crate::model::SearchOrganizationInsightsFilters>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The ID of the Amazon Web Services account. </p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.start_time_range = Some(input);
            self
        }
        /// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.start_time_range = input;
            self
        }
        /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn filters(mut self, input: crate::model::SearchOrganizationInsightsFilters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::SearchOrganizationInsightsFilters>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchOrganizationInsightsInput`](crate::input::SearchOrganizationInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchOrganizationInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchOrganizationInsightsInput {
                account_ids: self.account_ids,
                start_time_range: self.start_time_range,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchOrganizationInsightsInputOperationOutputAlias =
    crate::operation::SearchOrganizationInsights;
#[doc(hidden)]
pub type SearchOrganizationInsightsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchOrganizationInsightsInput {
    /// Consumes the builder and constructs an Operation<[`SearchOrganizationInsights`](crate::operation::SearchOrganizationInsights)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchOrganizationInsights,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SearchOrganizationInsightsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/organization/insights/search").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SearchOrganizationInsightsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_organization_insights(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchOrganizationInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchOrganizationInsights",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SearchOrganizationInsightsInput`](crate::input::SearchOrganizationInsightsInput)
    pub fn builder() -> crate::input::search_organization_insights_input::Builder {
        crate::input::search_organization_insights_input::Builder::default()
    }
}

/// See [`StartCostEstimationInput`](crate::input::StartCostEstimationInput)
pub mod start_cost_estimation_input {
    /// A builder for [`StartCostEstimationInput`](crate::input::StartCostEstimationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_collection:
            std::option::Option<crate::model::CostEstimationResourceCollectionFilter>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
        pub fn resource_collection(
            mut self,
            input: crate::model::CostEstimationResourceCollectionFilter,
        ) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::CostEstimationResourceCollectionFilter>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>The idempotency token used to identify each cost estimate request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to identify each cost estimate request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartCostEstimationInput`](crate::input::StartCostEstimationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartCostEstimationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartCostEstimationInput {
                resource_collection: self.resource_collection,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartCostEstimationInputOperationOutputAlias = crate::operation::StartCostEstimation;
#[doc(hidden)]
pub type StartCostEstimationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartCostEstimationInput {
    /// Consumes the builder and constructs an Operation<[`StartCostEstimation`](crate::operation::StartCostEstimation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartCostEstimation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartCostEstimationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cost-estimation").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartCostEstimationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_cost_estimation(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartCostEstimation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartCostEstimation",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartCostEstimationInput`](crate::input::StartCostEstimationInput)
    pub fn builder() -> crate::input::start_cost_estimation_input::Builder {
        crate::input::start_cost_estimation_input::Builder::default()
    }
}

/// See [`UpdateEventSourcesConfigInput`](crate::input::UpdateEventSourcesConfigInput)
pub mod update_event_sources_config_input {
    /// A builder for [`UpdateEventSourcesConfigInput`](crate::input::UpdateEventSourcesConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_sources: std::option::Option<crate::model::EventSourcesConfig>,
    }
    impl Builder {
        /// <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
        pub fn event_sources(mut self, input: crate::model::EventSourcesConfig) -> Self {
            self.event_sources = Some(input);
            self
        }
        /// <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
        pub fn set_event_sources(
            mut self,
            input: std::option::Option<crate::model::EventSourcesConfig>,
        ) -> Self {
            self.event_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventSourcesConfigInput`](crate::input::UpdateEventSourcesConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEventSourcesConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEventSourcesConfigInput {
                event_sources: self.event_sources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEventSourcesConfigInputOperationOutputAlias =
    crate::operation::UpdateEventSourcesConfig;
#[doc(hidden)]
pub type UpdateEventSourcesConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEventSourcesConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEventSourcesConfig`](crate::operation::UpdateEventSourcesConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEventSourcesConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEventSourcesConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/event-sources").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEventSourcesConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_event_sources_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEventSourcesConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEventSourcesConfig",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEventSourcesConfigInput`](crate::input::UpdateEventSourcesConfigInput)
    pub fn builder() -> crate::input::update_event_sources_config_input::Builder {
        crate::input::update_event_sources_config_input::Builder::default()
    }
}

/// See [`UpdateResourceCollectionInput`](crate::input::UpdateResourceCollectionInput)
pub mod update_resource_collection_input {
    /// A builder for [`UpdateResourceCollectionInput`](crate::input::UpdateResourceCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::UpdateResourceCollectionAction>,
        pub(crate) resource_collection:
            std::option::Option<crate::model::UpdateResourceCollectionFilter>,
    }
    impl Builder {
        /// <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
        pub fn action(mut self, input: crate::model::UpdateResourceCollectionAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::UpdateResourceCollectionAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
        pub fn resource_collection(
            mut self,
            input: crate::model::UpdateResourceCollectionFilter,
        ) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::UpdateResourceCollectionFilter>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceCollectionInput`](crate::input::UpdateResourceCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceCollectionInput {
                action: self.action,
                resource_collection: self.resource_collection,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceCollectionInputOperationOutputAlias =
    crate::operation::UpdateResourceCollection;
#[doc(hidden)]
pub type UpdateResourceCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResourceCollectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourceCollection`](crate::operation::UpdateResourceCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourceCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateResourceCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/resource-collections").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateResourceCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_resource_collection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourceCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourceCollection",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceCollectionInput`](crate::input::UpdateResourceCollectionInput)
    pub fn builder() -> crate::input::update_resource_collection_input::Builder {
        crate::input::update_resource_collection_input::Builder::default()
    }
}

/// See [`UpdateServiceIntegrationInput`](crate::input::UpdateServiceIntegrationInput)
pub mod update_service_integration_input {
    /// A builder for [`UpdateServiceIntegrationInput`](crate::input::UpdateServiceIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_integration:
            std::option::Option<crate::model::UpdateServiceIntegrationConfig>,
    }
    impl Builder {
        /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
        pub fn service_integration(
            mut self,
            input: crate::model::UpdateServiceIntegrationConfig,
        ) -> Self {
            self.service_integration = Some(input);
            self
        }
        /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
        pub fn set_service_integration(
            mut self,
            input: std::option::Option<crate::model::UpdateServiceIntegrationConfig>,
        ) -> Self {
            self.service_integration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceIntegrationInput`](crate::input::UpdateServiceIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceIntegrationInput {
                service_integration: self.service_integration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceIntegrationInputOperationOutputAlias =
    crate::operation::UpdateServiceIntegration;
#[doc(hidden)]
pub type UpdateServiceIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateServiceIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServiceIntegration`](crate::operation::UpdateServiceIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServiceIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateServiceIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/service-integrations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateServiceIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_service_integration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServiceIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServiceIntegration",
            "devopsguru",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceIntegrationInput`](crate::input::UpdateServiceIntegrationInput)
    pub fn builder() -> crate::input::update_service_integration_input::Builder {
        crate::input::update_service_integration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceIntegrationInput {
    /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
    pub service_integration: std::option::Option<crate::model::UpdateServiceIntegrationConfig>,
}
impl UpdateServiceIntegrationInput {
    /// <p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>
    pub fn service_integration(
        &self,
    ) -> std::option::Option<&crate::model::UpdateServiceIntegrationConfig> {
        self.service_integration.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceIntegrationInput");
        formatter.field("service_integration", &self.service_integration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceCollectionInput {
    /// <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
    pub action: std::option::Option<crate::model::UpdateResourceCollectionAction>,
    /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
    pub resource_collection: std::option::Option<crate::model::UpdateResourceCollectionFilter>,
}
impl UpdateResourceCollectionInput {
    /// <p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::UpdateResourceCollectionAction> {
        self.action.as_ref()
    }
    /// <p> Contains information used to update a collection of Amazon Web Services resources. </p>
    pub fn resource_collection(
        &self,
    ) -> std::option::Option<&crate::model::UpdateResourceCollectionFilter> {
        self.resource_collection.as_ref()
    }
}
impl std::fmt::Debug for UpdateResourceCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceCollectionInput");
        formatter.field("action", &self.action);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventSourcesConfigInput {
    /// <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
    pub event_sources: std::option::Option<crate::model::EventSourcesConfig>,
}
impl UpdateEventSourcesConfigInput {
    /// <p>Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service.</p>
    pub fn event_sources(&self) -> std::option::Option<&crate::model::EventSourcesConfig> {
        self.event_sources.as_ref()
    }
}
impl std::fmt::Debug for UpdateEventSourcesConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventSourcesConfigInput");
        formatter.field("event_sources", &self.event_sources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCostEstimationInput {
    /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
    pub resource_collection:
        std::option::Option<crate::model::CostEstimationResourceCollectionFilter>,
    /// <p>The idempotency token used to identify each cost estimate request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartCostEstimationInput {
    /// <p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>
    pub fn resource_collection(
        &self,
    ) -> std::option::Option<&crate::model::CostEstimationResourceCollectionFilter> {
        self.resource_collection.as_ref()
    }
    /// <p>The idempotency token used to identify each cost estimate request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartCostEstimationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCostEstimationInput");
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchOrganizationInsightsInput {
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
    pub start_time_range: std::option::Option<crate::model::StartTimeRange>,
    /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
    pub filters: std::option::Option<crate::model::SearchOrganizationInsightsFilters>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
}
impl SearchOrganizationInsightsInput {
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p> A time range used to specify when the behavior of an insight or anomaly started. </p>
    pub fn start_time_range(&self) -> std::option::Option<&crate::model::StartTimeRange> {
        self.start_time_range.as_ref()
    }
    /// <p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::SearchOrganizationInsightsFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InsightType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for SearchOrganizationInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchOrganizationInsightsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("start_time_range", &self.start_time_range);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchInsightsInput {
    /// <p> The start of the time range passed in. Returned insights occurred after this time. </p>
    pub start_time_range: std::option::Option<crate::model::StartTimeRange>,
    /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
    pub filters: std::option::Option<crate::model::SearchInsightsFilters>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
}
impl SearchInsightsInput {
    /// <p> The start of the time range passed in. Returned insights occurred after this time. </p>
    pub fn start_time_range(&self) -> std::option::Option<&crate::model::StartTimeRange> {
        self.start_time_range.as_ref()
    }
    /// <p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::SearchInsightsFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InsightType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for SearchInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchInsightsInput");
        formatter.field("start_time_range", &self.start_time_range);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveNotificationChannelInput {
    /// <p> The ID of the notification channel to be removed. </p>
    pub id: std::option::Option<std::string::String>,
}
impl RemoveNotificationChannelInput {
    /// <p> The ID of the notification channel to be removed. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for RemoveNotificationChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveNotificationChannelInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFeedbackInput {
    /// <p> The feedback from customers is about the recommendations in this insight. </p>
    pub insight_feedback: std::option::Option<crate::model::InsightFeedback>,
}
impl PutFeedbackInput {
    /// <p> The feedback from customers is about the recommendations in this insight. </p>
    pub fn insight_feedback(&self) -> std::option::Option<&crate::model::InsightFeedback> {
        self.insight_feedback.as_ref()
    }
}
impl std::fmt::Debug for PutFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFeedbackInput");
        formatter.field("insight_feedback", &self.insight_feedback);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendationsInput {
    /// <p> The ID of the requested insight. </p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A locale that specifies the language to use for recommendations.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl ListRecommendationsInput {
    /// <p> The ID of the requested insight. </p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A locale that specifies the language to use for recommendations.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for ListRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendationsInput");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("locale", &self.locale);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationInsightsInput {
    /// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
    pub status_filter: std::option::Option<crate::model::ListInsightsStatusFilter>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the organizational unit.</p>
    pub organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOrganizationInsightsInput {
    /// <p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>
    pub fn status_filter(&self) -> std::option::Option<&crate::model::ListInsightsStatusFilter> {
        self.status_filter.as_ref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>The ID of the organizational unit.</p>
    pub fn organizational_unit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_ids.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOrganizationInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationInsightsInput");
        formatter.field("status_filter", &self.status_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("organizational_unit_ids", &self.organizational_unit_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationChannelsInput {
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNotificationChannelsInput {
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNotificationChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationChannelsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsInput {
    /// <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
    pub status_filter: std::option::Option<crate::model::ListInsightsStatusFilter>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInsightsInput {
    /// <p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>
    pub fn status_filter(&self) -> std::option::Option<&crate::model::ListInsightsStatusFilter> {
        self.status_filter.as_ref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsInput");
        formatter.field("status_filter", &self.status_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventsInput {
    /// <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
    pub filters: std::option::Option<crate::model::ListEventsFilters>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl ListEventsInput {
    /// <p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>
    pub fn filters(&self) -> std::option::Option<&crate::model::ListEventsFilters> {
        self.filters.as_ref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for ListEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomaliesForInsightInput {
    /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
    pub start_time_range: std::option::Option<crate::model::StartTimeRange>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl ListAnomaliesForInsightInput {
    /// <p> The ID of the insight. The returned anomalies belong to this insight. </p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
    /// <p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>
    pub fn start_time_range(&self) -> std::option::Option<&crate::model::StartTimeRange> {
        self.start_time_range.as_ref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for ListAnomaliesForInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomaliesForInsightInput");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("start_time_range", &self.start_time_range);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceCollectionInput {
    /// <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection_type: std::option::Option<crate::model::ResourceCollectionType>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceCollectionInput {
    /// <p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection_type(
        &self,
    ) -> std::option::Option<&crate::model::ResourceCollectionType> {
        self.resource_collection_type.as_ref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceCollectionInput");
        formatter.field("resource_collection_type", &self.resource_collection_type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostEstimationInput {
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetCostEstimationInput {
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetCostEstimationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostEstimationInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceIntegrationInput {}
impl std::fmt::Debug for DescribeServiceIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceIntegrationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourceCollectionHealthInput {
    /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub resource_collection_type: std::option::Option<crate::model::ResourceCollectionType>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeResourceCollectionHealthInput {
    /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn resource_collection_type(
        &self,
    ) -> std::option::Option<&crate::model::ResourceCollectionType> {
        self.resource_collection_type.as_ref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourceCollectionHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourceCollectionHealthInput");
        formatter.field("resource_collection_type", &self.resource_collection_type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationResourceCollectionHealthInput {
    /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub organization_resource_collection_type:
        std::option::Option<crate::model::OrganizationResourceCollectionType>,
    /// <p>The ID of the Amazon Web Services account.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the organizational unit.</p>
    pub organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeOrganizationResourceCollectionHealthInput {
    /// <p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>
    pub fn organization_resource_collection_type(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationResourceCollectionType> {
        self.organization_resource_collection_type.as_ref()
    }
    /// <p>The ID of the Amazon Web Services account.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>The ID of the organizational unit.</p>
    pub fn organizational_unit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_ids.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeOrganizationResourceCollectionHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationResourceCollectionHealthInput");
        formatter.field(
            "organization_resource_collection_type",
            &self.organization_resource_collection_type,
        );
        formatter.field("account_ids", &self.account_ids);
        formatter.field("organizational_unit_ids", &self.organizational_unit_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationOverviewInput {
    /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
    pub from_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
    pub to_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ID of the Amazon Web Services account.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the organizational unit.</p>
    pub organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeOrganizationOverviewInput {
    /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
    pub fn from_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.from_time.as_ref()
    }
    /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
    pub fn to_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.to_time.as_ref()
    }
    /// <p>The ID of the Amazon Web Services account.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>The ID of the organizational unit.</p>
    pub fn organizational_unit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationOverviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationOverviewInput");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("organizational_unit_ids", &self.organizational_unit_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationHealthInput {
    /// <p>The ID of the Amazon Web Services account.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the organizational unit.</p>
    pub organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeOrganizationHealthInput {
    /// <p>The ID of the Amazon Web Services account.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>The ID of the organizational unit.</p>
    pub fn organizational_unit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_ids.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationHealthInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("organizational_unit_ids", &self.organizational_unit_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInsightInput {
    /// <p> The ID of the insight. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the member account in the organization.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DescribeInsightInput {
    /// <p> The ID of the insight. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the member account in the organization.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInsightInput");
        formatter.field("id", &self.id);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFeedbackInput {
    /// <p> The ID of the insight for which the feedback was provided. </p>
    pub insight_id: std::option::Option<std::string::String>,
}
impl DescribeFeedbackInput {
    /// <p> The ID of the insight for which the feedback was provided. </p>
    pub fn insight_id(&self) -> std::option::Option<&str> {
        self.insight_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFeedbackInput");
        formatter.field("insight_id", &self.insight_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSourcesConfigInput {}
impl std::fmt::Debug for DescribeEventSourcesConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSourcesConfigInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnomalyInput {
    /// <p> The ID of the anomaly. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the member account.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DescribeAnomalyInput {
    /// <p> The ID of the anomaly. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the member account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnomalyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnomalyInput");
        formatter.field("id", &self.id);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountOverviewInput {
    /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
    pub from_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
    pub to_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeAccountOverviewInput {
    /// <p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>
    pub fn from_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.from_time.as_ref()
    }
    /// <p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>
    pub fn to_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.to_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeAccountOverviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountOverviewInput");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountHealthInput {}
impl std::fmt::Debug for DescribeAccountHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountHealthInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInsightInput {
    /// <p>The ID of the insight.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteInsightInput {
    /// <p>The ID of the insight.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteInsightInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInsightInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddNotificationChannelInput {
    /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
    pub config: std::option::Option<crate::model::NotificationChannelConfig>,
}
impl AddNotificationChannelInput {
    /// <p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>
    pub fn config(&self) -> std::option::Option<&crate::model::NotificationChannelConfig> {
        self.config.as_ref()
    }
}
impl std::fmt::Debug for AddNotificationChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddNotificationChannelInput");
        formatter.field("config", &self.config);
        formatter.finish()
    }
}
