// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddNotificationChannelError {
    /// Kind of error that occurred.
    pub kind: AddNotificationChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddNotificationChannelErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// An exception that is thrown when a conflict occurs.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request contains a value that exceeds a maximum quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddNotificationChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddNotificationChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AddNotificationChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddNotificationChannelError {
    fn code(&self) -> Option<&str> {
        AddNotificationChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddNotificationChannelError {
    /// Creates a new `AddNotificationChannelError`.
    pub fn new(kind: AddNotificationChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddNotificationChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddNotificationChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddNotificationChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddNotificationChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AddNotificationChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddNotificationChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AddNotificationChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddNotificationChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::ConflictException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::ValidationException(_inner) => Some(_inner),
            AddNotificationChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountHealthError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountHealthErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountHealthErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountHealthErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAccountHealthErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccountHealthErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAccountHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountHealthError {
    fn code(&self) -> Option<&str> {
        DescribeAccountHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountHealthError {
    /// Creates a new `DescribeAccountHealthError`.
    pub fn new(kind: DescribeAccountHealthErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountHealthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountHealthErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountHealthErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountHealthErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountHealthErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountHealthErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountHealthErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountHealthErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountHealthErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAccountHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountHealthErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountHealthErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAccountHealthErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountHealthErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAccountHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountOverview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountOverviewError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountOverviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountOverview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountOverviewErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountOverviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountOverviewErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountOverviewErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAccountOverviewErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccountOverviewErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAccountOverviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountOverviewError {
    fn code(&self) -> Option<&str> {
        DescribeAccountOverviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountOverviewError {
    /// Creates a new `DescribeAccountOverviewError`.
    pub fn new(kind: DescribeAccountOverviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountOverviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountOverviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountOverviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountOverviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountOverviewErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountOverviewErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountOverviewErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountOverviewErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountOverviewErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountOverviewErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountOverviewErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountOverviewErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAccountOverviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountOverviewErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountOverviewErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAccountOverviewErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountOverviewErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAccountOverviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnomaly` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnomalyError {
    /// Kind of error that occurred.
    pub kind: DescribeAnomalyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnomaly` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnomalyErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnomalyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnomalyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAnomalyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAnomalyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAnomalyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAnomalyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAnomalyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnomalyError {
    fn code(&self) -> Option<&str> {
        DescribeAnomalyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnomalyError {
    /// Creates a new `DescribeAnomalyError`.
    pub fn new(kind: DescribeAnomalyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnomalyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnomalyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnomalyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnomalyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAnomalyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeAnomalyErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeAnomalyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeAnomalyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeAnomalyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnomalyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAnomalyErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAnomalyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAnomalyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAnomalyErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAnomalyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFeedbackError {
    /// Kind of error that occurred.
    pub kind: DescribeFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFeedbackErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFeedbackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeFeedbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFeedbackErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFeedbackErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFeedbackError {
    fn code(&self) -> Option<&str> {
        DescribeFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFeedbackError {
    /// Creates a new `DescribeFeedbackError`.
    pub fn new(kind: DescribeFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFeedbackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeedbackErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFeedbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeedbackErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFeedbackErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeedbackErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFeedbackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFeedbackErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFeedbackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeFeedbackErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFeedbackErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFeedbackErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInsight` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInsightError {
    /// Kind of error that occurred.
    pub kind: DescribeInsightErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInsight` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInsightErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInsightError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInsightErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeInsightErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeInsightErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeInsightErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeInsightErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeInsightErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInsightError {
    fn code(&self) -> Option<&str> {
        DescribeInsightError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInsightError {
    /// Creates a new `DescribeInsightError`.
    pub fn new(kind: DescribeInsightErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInsightError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInsightErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInsightError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInsightErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInsightErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInsightErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInsightErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInsightErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInsightErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInsightErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInsightErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeInsightErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeInsightErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeInsightErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeInsightError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInsightErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeInsightErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeInsightErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeInsightErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeInsightErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeInsightErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourceCollectionHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourceCollectionHealthError {
    /// Kind of error that occurred.
    pub kind: DescribeResourceCollectionHealthErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourceCollectionHealth` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourceCollectionHealthErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourceCollectionHealthError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourceCollectionHealthErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeResourceCollectionHealthErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeResourceCollectionHealthErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeResourceCollectionHealthErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeResourceCollectionHealthErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourceCollectionHealthError {
    fn code(&self) -> Option<&str> {
        DescribeResourceCollectionHealthError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourceCollectionHealthError {
    /// Creates a new `DescribeResourceCollectionHealthError`.
    pub fn new(
        kind: DescribeResourceCollectionHealthErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourceCollectionHealthError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourceCollectionHealthErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourceCollectionHealthError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourceCollectionHealthErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourceCollectionHealthErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceCollectionHealthErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceCollectionHealthErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceCollectionHealthErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceCollectionHealthErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceCollectionHealthErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceCollectionHealthErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceCollectionHealthErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeResourceCollectionHealthError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourceCollectionHealthErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeResourceCollectionHealthErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeResourceCollectionHealthErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeResourceCollectionHealthErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeResourceCollectionHealthErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServiceIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServiceIntegrationError {
    /// Kind of error that occurred.
    pub kind: DescribeServiceIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServiceIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServiceIntegrationErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServiceIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServiceIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeServiceIntegrationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeServiceIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeServiceIntegrationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeServiceIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServiceIntegrationError {
    fn code(&self) -> Option<&str> {
        DescribeServiceIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServiceIntegrationError {
    /// Creates a new `DescribeServiceIntegrationError`.
    pub fn new(kind: DescribeServiceIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServiceIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServiceIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServiceIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServiceIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeServiceIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServiceIntegrationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceIntegrationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServiceIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceIntegrationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServiceIntegrationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceIntegrationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeServiceIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServiceIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeServiceIntegrationErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeServiceIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeServiceIntegrationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeServiceIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCostEstimation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCostEstimationError {
    /// Kind of error that occurred.
    pub kind: GetCostEstimationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCostEstimation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCostEstimationErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCostEstimationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCostEstimationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCostEstimationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCostEstimationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCostEstimationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCostEstimationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCostEstimationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCostEstimationError {
    fn code(&self) -> Option<&str> {
        GetCostEstimationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCostEstimationError {
    /// Creates a new `GetCostEstimationError`.
    pub fn new(kind: GetCostEstimationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCostEstimationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCostEstimationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCostEstimationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCostEstimationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCostEstimationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostEstimationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostEstimationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostEstimationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostEstimationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostEstimationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostEstimationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostEstimationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostEstimationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostEstimationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCostEstimationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCostEstimationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCostEstimationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCostEstimationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCostEstimationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCostEstimationErrorKind::ValidationException(_inner) => Some(_inner),
            GetCostEstimationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceCollectionError {
    /// Kind of error that occurred.
    pub kind: GetResourceCollectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceCollectionErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceCollectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceCollectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourceCollectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResourceCollectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourceCollectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourceCollectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourceCollectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceCollectionError {
    fn code(&self) -> Option<&str> {
        GetResourceCollectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceCollectionError {
    /// Creates a new `GetResourceCollectionError`.
    pub fn new(kind: GetResourceCollectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceCollectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceCollectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceCollectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceCollectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceCollectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceCollectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceCollectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceCollectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceCollectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceCollectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceCollectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceCollectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceCollectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceCollectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourceCollectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceCollectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourceCollectionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourceCollectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourceCollectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourceCollectionErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourceCollectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnomaliesForInsight` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnomaliesForInsightError {
    /// Kind of error that occurred.
    pub kind: ListAnomaliesForInsightErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnomaliesForInsight` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnomaliesForInsightErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnomaliesForInsightError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnomaliesForInsightErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAnomaliesForInsightErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAnomaliesForInsightErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAnomaliesForInsightErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAnomaliesForInsightErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAnomaliesForInsightErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnomaliesForInsightError {
    fn code(&self) -> Option<&str> {
        ListAnomaliesForInsightError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnomaliesForInsightError {
    /// Creates a new `ListAnomaliesForInsightError`.
    pub fn new(kind: ListAnomaliesForInsightErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnomaliesForInsightError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnomaliesForInsightErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnomaliesForInsightError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnomaliesForInsightErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAnomaliesForInsightErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomaliesForInsightErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomaliesForInsightErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomaliesForInsightErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomaliesForInsightErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomaliesForInsightErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomaliesForInsightErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomaliesForInsightErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomaliesForInsightErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomaliesForInsightErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAnomaliesForInsightError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnomaliesForInsightErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAnomaliesForInsightErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAnomaliesForInsightErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAnomaliesForInsightErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAnomaliesForInsightErrorKind::ValidationException(_inner) => Some(_inner),
            ListAnomaliesForInsightErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventsError {
    /// Kind of error that occurred.
    pub kind: ListEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventsErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEventsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEventsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEventsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventsError {
    fn code(&self) -> Option<&str> {
        ListEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventsError {
    /// Creates a new `ListEventsError`.
    pub fn new(kind: ListEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListEventsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListEventsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListEventsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListEventsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListEventsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListEventsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEventsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEventsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEventsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInsightsError {
    /// Kind of error that occurred.
    pub kind: ListInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInsightsErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInsightsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListInsightsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInsightsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInsightsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInsightsError {
    fn code(&self) -> Option<&str> {
        ListInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInsightsError {
    /// Creates a new `ListInsightsError`.
    pub fn new(kind: ListInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInsightsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInsightsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListInsightsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListInsightsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInsightsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInsightsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListInsightsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListInsightsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListInsightsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInsightsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListInsightsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInsightsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInsightsErrorKind::ValidationException(_inner) => Some(_inner),
            ListInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNotificationChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNotificationChannelsError {
    /// Kind of error that occurred.
    pub kind: ListNotificationChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNotificationChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNotificationChannelsErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNotificationChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNotificationChannelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNotificationChannelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNotificationChannelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNotificationChannelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListNotificationChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNotificationChannelsError {
    fn code(&self) -> Option<&str> {
        ListNotificationChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNotificationChannelsError {
    /// Creates a new `ListNotificationChannelsError`.
    pub fn new(kind: ListNotificationChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNotificationChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNotificationChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNotificationChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNotificationChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNotificationChannelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationChannelsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNotificationChannelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationChannelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNotificationChannelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationChannelsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNotificationChannelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationChannelsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListNotificationChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNotificationChannelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNotificationChannelsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNotificationChannelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNotificationChannelsErrorKind::ValidationException(_inner) => Some(_inner),
            ListNotificationChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecommendations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecommendationsError {
    /// Kind of error that occurred.
    pub kind: ListRecommendationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecommendations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecommendationsErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecommendationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecommendationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRecommendationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRecommendationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRecommendationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRecommendationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRecommendationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecommendationsError {
    fn code(&self) -> Option<&str> {
        ListRecommendationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecommendationsError {
    /// Creates a new `ListRecommendationsError`.
    pub fn new(kind: ListRecommendationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecommendationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecommendationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecommendationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecommendationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRecommendationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecommendationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecommendationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecommendationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecommendationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecommendationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRecommendationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecommendationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRecommendationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRecommendationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRecommendationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRecommendationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRecommendationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFeedbackError {
    /// Kind of error that occurred.
    pub kind: PutFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFeedbackErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// An exception that is thrown when a conflict occurs.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFeedbackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFeedbackError {
    fn code(&self) -> Option<&str> {
        PutFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFeedbackError {
    /// Creates a new `PutFeedbackError`.
    pub fn new(kind: PutFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFeedbackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutFeedbackErrorKind::ConflictException(_inner) => Some(_inner),
            PutFeedbackErrorKind::InternalServerException(_inner) => Some(_inner),
            PutFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutFeedbackErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutFeedbackErrorKind::ValidationException(_inner) => Some(_inner),
            PutFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveNotificationChannelError {
    /// Kind of error that occurred.
    pub kind: RemoveNotificationChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveNotificationChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveNotificationChannelErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// An exception that is thrown when a conflict occurs.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveNotificationChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveNotificationChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RemoveNotificationChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveNotificationChannelError {
    fn code(&self) -> Option<&str> {
        RemoveNotificationChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveNotificationChannelError {
    /// Creates a new `RemoveNotificationChannelError`.
    pub fn new(kind: RemoveNotificationChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveNotificationChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveNotificationChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveNotificationChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveNotificationChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveNotificationChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveNotificationChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RemoveNotificationChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveNotificationChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ConflictException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::ValidationException(_inner) => Some(_inner),
            RemoveNotificationChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchInsightsError {
    /// Kind of error that occurred.
    pub kind: SearchInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchInsightsErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchInsightsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SearchInsightsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SearchInsightsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SearchInsightsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SearchInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchInsightsError {
    fn code(&self) -> Option<&str> {
        SearchInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchInsightsError {
    /// Creates a new `SearchInsightsError`.
    pub fn new(kind: SearchInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchInsightsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchInsightsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchInsightsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchInsightsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchInsightsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchInsightsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SearchInsightsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SearchInsightsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, SearchInsightsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for SearchInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchInsightsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SearchInsightsErrorKind::InternalServerException(_inner) => Some(_inner),
            SearchInsightsErrorKind::ThrottlingException(_inner) => Some(_inner),
            SearchInsightsErrorKind::ValidationException(_inner) => Some(_inner),
            SearchInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartCostEstimation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartCostEstimationError {
    /// Kind of error that occurred.
    pub kind: StartCostEstimationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartCostEstimation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartCostEstimationErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// An exception that is thrown when a conflict occurs.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A requested resource could not be found</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartCostEstimationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartCostEstimationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartCostEstimationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartCostEstimationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartCostEstimationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartCostEstimationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartCostEstimationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartCostEstimationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartCostEstimationError {
    fn code(&self) -> Option<&str> {
        StartCostEstimationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartCostEstimationError {
    /// Creates a new `StartCostEstimationError`.
    pub fn new(kind: StartCostEstimationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartCostEstimationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartCostEstimationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartCostEstimationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartCostEstimationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartCostEstimationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCostEstimationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCostEstimationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCostEstimationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCostEstimationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCostEstimationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCostEstimationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCostEstimationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCostEstimationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCostEstimationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCostEstimationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCostEstimationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartCostEstimationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartCostEstimationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartCostEstimationErrorKind::ConflictException(_inner) => Some(_inner),
            StartCostEstimationErrorKind::InternalServerException(_inner) => Some(_inner),
            StartCostEstimationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartCostEstimationErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartCostEstimationErrorKind::ValidationException(_inner) => Some(_inner),
            StartCostEstimationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourceCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceCollectionError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceCollectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourceCollection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceCollectionErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// An exception that is thrown when a conflict occurs.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceCollectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceCollectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateResourceCollectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateResourceCollectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateResourceCollectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateResourceCollectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateResourceCollectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceCollectionError {
    fn code(&self) -> Option<&str> {
        UpdateResourceCollectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceCollectionError {
    /// Creates a new `UpdateResourceCollectionError`.
    pub fn new(kind: UpdateResourceCollectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceCollectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceCollectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceCollectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceCollectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceCollectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceCollectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceCollectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceCollectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceCollectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceCollectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceCollectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceCollectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceCollectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceCollectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateResourceCollectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceCollectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateResourceCollectionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateResourceCollectionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateResourceCollectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateResourceCollectionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateResourceCollectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceIntegrationError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceIntegrationErrorKind {
    /// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
    /// least one IAM permissions policy attached that grants the required permissions. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>
    /// An exception that is thrown when a conflict occurs.
    /// </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure in an Amazon service occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to a request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>
    /// Contains information about data passed in to a field during a request that is not valid.
    /// </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceIntegrationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServiceIntegrationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServiceIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServiceIntegrationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServiceIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceIntegrationError {
    fn code(&self) -> Option<&str> {
        UpdateServiceIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceIntegrationError {
    /// Creates a new `UpdateServiceIntegrationError`.
    pub fn new(kind: UpdateServiceIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceIntegrationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceIntegrationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceIntegrationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceIntegrationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceIntegrationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceIntegrationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceIntegrationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServiceIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceIntegrationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServiceIntegrationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServiceIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServiceIntegrationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServiceIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>
/// Contains information about data passed in to a field during a request that is not valid.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>
    /// A message that describes the validation exception.
    /// </p>
    pub message: std::option::Option<std::string::String>,
    /// <p>
    /// The reason the validation exception was thrown.
    /// </p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>
    /// An array of fields that are associated with the validation exception.
    /// </p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>
    /// The reason the validation exception was thrown.
    /// </p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>
    /// An array of fields that are associated with the validation exception.
    /// </p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        /// <p>
        /// A message that describes the validation exception.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// A message that describes the validation exception.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>
        /// The reason the validation exception was thrown.
        /// </p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>
        /// The reason the validation exception was thrown.
        /// </p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>
        /// An array of fields that are associated with the validation exception.
        /// </p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>
        /// An array of fields that are associated with the validation exception.
        /// </p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to a request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>
    /// The code of the quota that was exceeded, causing the throttling exception.
    /// </p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>
    /// The code of the service that caused the throttling exception.
    /// </p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>
    /// The number of seconds after which the action that caused the throttling
    /// exception can be retried.
    /// </p>
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// <p>
    /// The code of the quota that was exceeded, causing the throttling exception.
    /// </p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>
    /// The code of the service that caused the throttling exception.
    /// </p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>
    /// The number of seconds after which the action that caused the throttling
    /// exception can be retried.
    /// </p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>
        /// The code of the quota that was exceeded, causing the throttling exception.
        /// </p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>
        /// The code of the quota that was exceeded, causing the throttling exception.
        /// </p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>
        /// The code of the service that caused the throttling exception.
        /// </p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>
        /// The code of the service that caused the throttling exception.
        /// </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>
        /// The number of seconds after which the action that caused the throttling
        /// exception can be retried.
        /// </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>
        /// The number of seconds after which the action that caused the throttling
        /// exception can be retried.
        /// </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                quota_code: self.quota_code,
                service_code: self.service_code,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>An internal failure in an Amazon service occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>
    /// The number of seconds after which the action that caused the internal server
    /// exception can be retried.
    /// </p>
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// <p>
    /// The number of seconds after which the action that caused the internal server
    /// exception can be retried.
    /// </p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>
        /// The number of seconds after which the action that caused the internal server
        /// exception can be retried.
        /// </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>
        /// The number of seconds after which the action that caused the internal server
        /// exception can be retried.
        /// </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>
/// An exception that is thrown when a conflict occurs.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>
    /// The ID of the AWS resource in which a conflict occurred.
    /// </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>
    /// The type of the AWS resource in which a conflict occurred.
    /// </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>
    /// The ID of the AWS resource in which a conflict occurred.
    /// </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>
    /// The type of the AWS resource in which a conflict occurred.
    /// </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>
        /// The ID of the AWS resource in which a conflict occurred.
        /// </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the AWS resource in which a conflict occurred.
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>
        /// The type of the AWS resource in which a conflict occurred.
        /// </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>
        /// The type of the AWS resource in which a conflict occurred.
        /// </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p> You don't have permissions to perform the requested operation. The user or role that is making the request must have at
/// least one IAM permissions policy attached that grants the required permissions. For more information, see
/// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A requested resource could not be found</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>
    /// The ID of the AWS resource that could not be found.
    /// </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>
    /// The type of the AWS resource that could not be found.
    /// </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>
    /// The ID of the AWS resource that could not be found.
    /// </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>
    /// The type of the AWS resource that could not be found.
    /// </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>
        /// The ID of the AWS resource that could not be found.
        /// </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the AWS resource that could not be found.
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>
        /// The type of the AWS resource that could not be found.
        /// </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>
        /// The type of the AWS resource that could not be found.
        /// </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request contains a value that exceeds a maximum quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
