// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>
/// The field associated with the validation exception.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>
    /// The name of the field.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The message associated with the validation exception with information to help
    /// determine its cause.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the field.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the field.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The message associated with the validation exception with information to help
        /// determine its cause.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The message associated with the validation exception with information to help
        /// determine its cause.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about updating the integration status of an AWS service, such as AWS Systems Manager, with DevOps Guru.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceIntegrationConfig {
    /// <p>
    /// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
    /// </p>
    pub ops_center: std::option::Option<crate::model::OpsCenterIntegrationConfig>,
}
impl std::fmt::Debug for UpdateServiceIntegrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceIntegrationConfig");
        formatter.field("ops_center", &self.ops_center);
        formatter.finish()
    }
}
/// See [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
pub mod update_service_integration_config {
    /// A builder for [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_center: std::option::Option<crate::model::OpsCenterIntegrationConfig>,
    }
    impl Builder {
        /// <p>
        /// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
        /// </p>
        pub fn ops_center(mut self, input: crate::model::OpsCenterIntegrationConfig) -> Self {
            self.ops_center = Some(input);
            self
        }
        /// <p>
        /// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
        /// </p>
        pub fn set_ops_center(
            mut self,
            input: std::option::Option<crate::model::OpsCenterIntegrationConfig>,
        ) -> Self {
            self.ops_center = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
        pub fn build(self) -> crate::model::UpdateServiceIntegrationConfig {
            crate::model::UpdateServiceIntegrationConfig {
                ops_center: self.ops_center,
            }
        }
    }
}
impl UpdateServiceIntegrationConfig {
    /// Creates a new builder-style object to manufacture [`UpdateServiceIntegrationConfig`](crate::model::UpdateServiceIntegrationConfig)
    pub fn builder() -> crate::model::update_service_integration_config::Builder {
        crate::model::update_service_integration_config::Builder::default()
    }
}

/// <p>
/// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsCenterIntegrationConfig {
    /// <p>
    /// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
    /// </p>
    pub opt_in_status: std::option::Option<crate::model::OptInStatus>,
}
impl std::fmt::Debug for OpsCenterIntegrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsCenterIntegrationConfig");
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.finish()
    }
}
/// See [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
pub mod ops_center_integration_config {
    /// A builder for [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_in_status: std::option::Option<crate::model::OptInStatus>,
    }
    impl Builder {
        /// <p>
        /// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
        /// </p>
        pub fn opt_in_status(mut self, input: crate::model::OptInStatus) -> Self {
            self.opt_in_status = Some(input);
            self
        }
        /// <p>
        /// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
        /// </p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<crate::model::OptInStatus>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
        pub fn build(self) -> crate::model::OpsCenterIntegrationConfig {
            crate::model::OpsCenterIntegrationConfig {
                opt_in_status: self.opt_in_status,
            }
        }
    }
}
impl OpsCenterIntegrationConfig {
    /// Creates a new builder-style object to manufacture [`OpsCenterIntegrationConfig`](crate::model::OpsCenterIntegrationConfig)
    pub fn builder() -> crate::model::ops_center_integration_config::Builder {
        crate::model::ops_center_integration_config::Builder::default()
    }
}

/// <p>
/// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
/// </p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptInStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptInStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => OptInStatus::Disabled,
            "ENABLED" => OptInStatus::Enabled,
            other => OptInStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptInStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptInStatus::from(s))
    }
}
impl OptInStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptInStatus::Disabled => "DISABLED",
            OptInStatus::Enabled => "ENABLED",
            OptInStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for OptInStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains information used to update a collection of AWS resources.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceCollectionFilter {
    /// <p>
    /// An collection of AWS CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub cloud_formation: std::option::Option<crate::model::UpdateCloudFormationCollectionFilter>,
}
impl std::fmt::Debug for UpdateResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceCollectionFilter");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.finish()
    }
}
/// See [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
pub mod update_resource_collection_filter {
    /// A builder for [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation:
            std::option::Option<crate::model::UpdateCloudFormationCollectionFilter>,
    }
    impl Builder {
        /// <p>
        /// An collection of AWS CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn cloud_formation(
            mut self,
            input: crate::model::UpdateCloudFormationCollectionFilter,
        ) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p>
        /// An collection of AWS CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<crate::model::UpdateCloudFormationCollectionFilter>,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
        pub fn build(self) -> crate::model::UpdateResourceCollectionFilter {
            crate::model::UpdateResourceCollectionFilter {
                cloud_formation: self.cloud_formation,
            }
        }
    }
}
impl UpdateResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`UpdateResourceCollectionFilter`](crate::model::UpdateResourceCollectionFilter)
    pub fn builder() -> crate::model::update_resource_collection_filter::Builder {
        crate::model::update_resource_collection_filter::Builder::default()
    }
}

/// <p> Contains the names of AWS CloudFormation stacks used to update a collection of stacks. You can specify up to 500 AWS CloudFormation stacks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCloudFormationCollectionFilter {
    /// <p>
    /// An array of the names of the AWS CloudFormation stacks to update. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateCloudFormationCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCloudFormationCollectionFilter");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
pub mod update_cloud_formation_collection_filter {
    /// A builder for [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p>
        /// An array of the names of the AWS CloudFormation stacks to update. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p>
        /// An array of the names of the AWS CloudFormation stacks to update. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
        pub fn build(self) -> crate::model::UpdateCloudFormationCollectionFilter {
            crate::model::UpdateCloudFormationCollectionFilter {
                stack_names: self.stack_names,
            }
        }
    }
}
impl UpdateCloudFormationCollectionFilter {
    /// Creates a new builder-style object to manufacture [`UpdateCloudFormationCollectionFilter`](crate::model::UpdateCloudFormationCollectionFilter)
    pub fn builder() -> crate::model::update_cloud_formation_collection_filter::Builder {
        crate::model::update_cloud_formation_collection_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateResourceCollectionAction {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateResourceCollectionAction {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => UpdateResourceCollectionAction::Add,
            "REMOVE" => UpdateResourceCollectionAction::Remove,
            other => UpdateResourceCollectionAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateResourceCollectionAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateResourceCollectionAction::from(s))
    }
}
impl UpdateResourceCollectionAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateResourceCollectionAction::Add => "ADD",
            UpdateResourceCollectionAction::Remove => "REMOVE",
            UpdateResourceCollectionAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "REMOVE"]
    }
}
impl AsRef<str> for UpdateResourceCollectionAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a filter used to specify which AWS resources are analyzed to create
/// a monthly DevOps Guru cost estimate. For more information,
/// see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
/// Amazon DevOps Guru costs</a> and
/// <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostEstimationResourceCollectionFilter {
    /// <p>An object that specifies the CloudFormation stack that defines the AWS resources
    /// used to create a monthly estimate for DevOps Guru.</p>
    pub cloud_formation:
        std::option::Option<crate::model::CloudFormationCostEstimationResourceCollectionFilter>,
}
impl std::fmt::Debug for CostEstimationResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostEstimationResourceCollectionFilter");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.finish()
    }
}
/// See [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
pub mod cost_estimation_resource_collection_filter {
    /// A builder for [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation:
            std::option::Option<crate::model::CloudFormationCostEstimationResourceCollectionFilter>,
    }
    impl Builder {
        /// <p>An object that specifies the CloudFormation stack that defines the AWS resources
        /// used to create a monthly estimate for DevOps Guru.</p>
        pub fn cloud_formation(
            mut self,
            input: crate::model::CloudFormationCostEstimationResourceCollectionFilter,
        ) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p>An object that specifies the CloudFormation stack that defines the AWS resources
        /// used to create a monthly estimate for DevOps Guru.</p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<
                crate::model::CloudFormationCostEstimationResourceCollectionFilter,
            >,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Consumes the builder and constructs a [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
        pub fn build(self) -> crate::model::CostEstimationResourceCollectionFilter {
            crate::model::CostEstimationResourceCollectionFilter {
                cloud_formation: self.cloud_formation,
            }
        }
    }
}
impl CostEstimationResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`CostEstimationResourceCollectionFilter`](crate::model::CostEstimationResourceCollectionFilter)
    pub fn builder() -> crate::model::cost_estimation_resource_collection_filter::Builder {
        crate::model::cost_estimation_resource_collection_filter::Builder::default()
    }
}

/// <p>Information about an AWS CloudFormation stack used to create a monthly cost estimate for DevOps Guru to analyze
/// AWS resources. The maximum number of stacks you can specify for a cost estimate is one. The estimate created is for the cost
/// to analyze the AWS resources defined by the stack. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a>
/// in the <i>AWS CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationCostEstimationResourceCollectionFilter {
    /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CloudFormationCostEstimationResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationCostEstimationResourceCollectionFilter");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
pub mod cloud_formation_cost_estimation_resource_collection_filter {
    /// A builder for [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
        pub fn build(self) -> crate::model::CloudFormationCostEstimationResourceCollectionFilter {
            crate::model::CloudFormationCostEstimationResourceCollectionFilter {
                stack_names: self.stack_names,
            }
        }
    }
}
impl CloudFormationCostEstimationResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`CloudFormationCostEstimationResourceCollectionFilter`](crate::model::CloudFormationCostEstimationResourceCollectionFilter)
    pub fn builder(
    ) -> crate::model::cloud_formation_cost_estimation_resource_collection_filter::Builder {
        crate::model::cloud_formation_cost_estimation_resource_collection_filter::Builder::default()
    }
}

/// <p> Information about a reactive insight. This object is returned by
/// <code>DescribeInsight.</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveInsightSummary {
    /// <p>
    /// The ID of a reactive summary.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// The name of a reactive insight.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The severity of a reactive insight.
    /// </p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p>
    /// The status of a reactive insight.
    /// </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and
    /// ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of AWS services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl std::fmt::Debug for ReactiveInsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveInsightSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
pub mod reactive_insight_summary {
    /// A builder for [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// <p>
        /// The ID of a reactive summary.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of a reactive summary.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// The name of a reactive insight.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of a reactive insight.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The severity of a reactive insight.
        /// </p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>
        /// The severity of a reactive insight.
        /// </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>
        /// The status of a reactive insight.
        /// </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of a reactive insight.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of AWS services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of AWS services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
        pub fn build(self) -> crate::model::ReactiveInsightSummary {
            crate::model::ReactiveInsightSummary {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl ReactiveInsightSummary {
    /// Creates a new builder-style object to manufacture [`ReactiveInsightSummary`](crate::model::ReactiveInsightSummary)
    pub fn builder() -> crate::model::reactive_insight_summary::Builder {
        crate::model::reactive_insight_summary::Builder::default()
    }
}

/// <p>A collection of the names of AWS services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceCollection {
    /// <p>An array of strings that each specifies the name of an AWS service.</p>
    pub service_names: std::option::Option<std::vec::Vec<crate::model::ServiceName>>,
}
impl std::fmt::Debug for ServiceCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceCollection");
        formatter.field("service_names", &self.service_names);
        formatter.finish()
    }
}
/// See [`ServiceCollection`](crate::model::ServiceCollection)
pub mod service_collection {
    /// A builder for [`ServiceCollection`](crate::model::ServiceCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_names: std::option::Option<std::vec::Vec<crate::model::ServiceName>>,
    }
    impl Builder {
        /// Appends an item to `service_names`.
        ///
        /// To override the contents of this collection use [`set_service_names`](Self::set_service_names).
        ///
        /// <p>An array of strings that each specifies the name of an AWS service.</p>
        pub fn service_names(mut self, input: impl Into<crate::model::ServiceName>) -> Self {
            let mut v = self.service_names.unwrap_or_default();
            v.push(input.into());
            self.service_names = Some(v);
            self
        }
        /// <p>An array of strings that each specifies the name of an AWS service.</p>
        pub fn set_service_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceName>>,
        ) -> Self {
            self.service_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceCollection`](crate::model::ServiceCollection)
        pub fn build(self) -> crate::model::ServiceCollection {
            crate::model::ServiceCollection {
                service_names: self.service_names,
            }
        }
    }
}
impl ServiceCollection {
    /// Creates a new builder-style object to manufacture [`ServiceCollection`](crate::model::ServiceCollection)
    pub fn builder() -> crate::model::service_collection::Builder {
        crate::model::service_collection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceName {
    #[allow(missing_docs)] // documentation missing in model
    ApiGateway,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationElb,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    CloudFront,
    #[allow(missing_docs)] // documentation missing in model
    DynamoDb,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecs,
    #[allow(missing_docs)] // documentation missing in model
    Eks,
    #[allow(missing_docs)] // documentation missing in model
    ElasticBeanstalk,
    #[allow(missing_docs)] // documentation missing in model
    ElastiCache,
    #[allow(missing_docs)] // documentation missing in model
    Elb,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Kinesis,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    NatGateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkElb,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    #[allow(missing_docs)] // documentation missing in model
    Redshift,
    #[allow(missing_docs)] // documentation missing in model
    Route53,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    SageMaker,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    #[allow(missing_docs)] // documentation missing in model
    Sqs,
    #[allow(missing_docs)] // documentation missing in model
    StepFunctions,
    #[allow(missing_docs)] // documentation missing in model
    Swf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceName {
    fn from(s: &str) -> Self {
        match s {
            "API_GATEWAY" => ServiceName::ApiGateway,
            "APPLICATION_ELB" => ServiceName::ApplicationElb,
            "AUTO_SCALING_GROUP" => ServiceName::AutoScalingGroup,
            "CLOUD_FRONT" => ServiceName::CloudFront,
            "DYNAMO_DB" => ServiceName::DynamoDb,
            "EC2" => ServiceName::Ec2,
            "ECS" => ServiceName::Ecs,
            "EKS" => ServiceName::Eks,
            "ELASTIC_BEANSTALK" => ServiceName::ElasticBeanstalk,
            "ELASTI_CACHE" => ServiceName::ElastiCache,
            "ELB" => ServiceName::Elb,
            "ES" => ServiceName::Es,
            "KINESIS" => ServiceName::Kinesis,
            "LAMBDA" => ServiceName::Lambda,
            "NAT_GATEWAY" => ServiceName::NatGateway,
            "NETWORK_ELB" => ServiceName::NetworkElb,
            "RDS" => ServiceName::Rds,
            "REDSHIFT" => ServiceName::Redshift,
            "ROUTE_53" => ServiceName::Route53,
            "S3" => ServiceName::S3,
            "SAGE_MAKER" => ServiceName::SageMaker,
            "SNS" => ServiceName::Sns,
            "SQS" => ServiceName::Sqs,
            "STEP_FUNCTIONS" => ServiceName::StepFunctions,
            "SWF" => ServiceName::Swf,
            other => ServiceName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceName::from(s))
    }
}
impl ServiceName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceName::ApiGateway => "API_GATEWAY",
            ServiceName::ApplicationElb => "APPLICATION_ELB",
            ServiceName::AutoScalingGroup => "AUTO_SCALING_GROUP",
            ServiceName::CloudFront => "CLOUD_FRONT",
            ServiceName::DynamoDb => "DYNAMO_DB",
            ServiceName::Ec2 => "EC2",
            ServiceName::Ecs => "ECS",
            ServiceName::Eks => "EKS",
            ServiceName::ElasticBeanstalk => "ELASTIC_BEANSTALK",
            ServiceName::ElastiCache => "ELASTI_CACHE",
            ServiceName::Elb => "ELB",
            ServiceName::Es => "ES",
            ServiceName::Kinesis => "KINESIS",
            ServiceName::Lambda => "LAMBDA",
            ServiceName::NatGateway => "NAT_GATEWAY",
            ServiceName::NetworkElb => "NETWORK_ELB",
            ServiceName::Rds => "RDS",
            ServiceName::Redshift => "REDSHIFT",
            ServiceName::Route53 => "ROUTE_53",
            ServiceName::S3 => "S3",
            ServiceName::SageMaker => "SAGE_MAKER",
            ServiceName::Sns => "SNS",
            ServiceName::Sqs => "SQS",
            ServiceName::StepFunctions => "STEP_FUNCTIONS",
            ServiceName::Swf => "SWF",
            ServiceName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "API_GATEWAY",
            "APPLICATION_ELB",
            "AUTO_SCALING_GROUP",
            "CLOUD_FRONT",
            "DYNAMO_DB",
            "EC2",
            "ECS",
            "EKS",
            "ELASTIC_BEANSTALK",
            "ELASTI_CACHE",
            "ELB",
            "ES",
            "KINESIS",
            "LAMBDA",
            "NAT_GATEWAY",
            "NETWORK_ELB",
            "RDS",
            "REDSHIFT",
            "ROUTE_53",
            "S3",
            "SAGE_MAKER",
            "SNS",
            "SQS",
            "STEP_FUNCTIONS",
            "SWF",
        ]
    }
}
impl AsRef<str> for ServiceName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
/// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCollection {
    /// <p> An array of the names of AWS CloudFormation stacks. The stacks define AWS resources
    /// that DevOps Guru analyzes. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub cloud_formation: std::option::Option<crate::model::CloudFormationCollection>,
}
impl std::fmt::Debug for ResourceCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCollection");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.finish()
    }
}
/// See [`ResourceCollection`](crate::model::ResourceCollection)
pub mod resource_collection {
    /// A builder for [`ResourceCollection`](crate::model::ResourceCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation: std::option::Option<crate::model::CloudFormationCollection>,
    }
    impl Builder {
        /// <p> An array of the names of AWS CloudFormation stacks. The stacks define AWS resources
        /// that DevOps Guru analyzes. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn cloud_formation(mut self, input: crate::model::CloudFormationCollection) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p> An array of the names of AWS CloudFormation stacks. The stacks define AWS resources
        /// that DevOps Guru analyzes. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<crate::model::CloudFormationCollection>,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCollection`](crate::model::ResourceCollection)
        pub fn build(self) -> crate::model::ResourceCollection {
            crate::model::ResourceCollection {
                cloud_formation: self.cloud_formation,
            }
        }
    }
}
impl ResourceCollection {
    /// Creates a new builder-style object to manufacture [`ResourceCollection`](crate::model::ResourceCollection)
    pub fn builder() -> crate::model::resource_collection::Builder {
        crate::model::resource_collection::Builder::default()
    }
}

/// <p>
/// Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze.
/// For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a>
/// in the <i>AWS CloudFormation User Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationCollection {
    /// <p>
    /// An array of CloudFormation stack names.
    /// </p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CloudFormationCollection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationCollection");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`CloudFormationCollection`](crate::model::CloudFormationCollection)
pub mod cloud_formation_collection {
    /// A builder for [`CloudFormationCollection`](crate::model::CloudFormationCollection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p>
        /// An array of CloudFormation stack names.
        /// </p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p>
        /// An array of CloudFormation stack names.
        /// </p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationCollection`](crate::model::CloudFormationCollection)
        pub fn build(self) -> crate::model::CloudFormationCollection {
            crate::model::CloudFormationCollection {
                stack_names: self.stack_names,
            }
        }
    }
}
impl CloudFormationCollection {
    /// Creates a new builder-style object to manufacture [`CloudFormationCollection`](crate::model::CloudFormationCollection)
    pub fn builder() -> crate::model::cloud_formation_collection::Builder {
        crate::model::cloud_formation_collection::Builder::default()
    }
}

/// <p> A time ranged that specifies when the observed behavior in an insight started and
/// ended. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightTimeRange {
    /// <p>
    /// The time when the behavior described in an insight started.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time when the behavior described in an insight ended.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for InsightTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`InsightTimeRange`](crate::model::InsightTimeRange)
pub mod insight_time_range {
    /// A builder for [`InsightTimeRange`](crate::model::InsightTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The time when the behavior described in an insight started.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The time when the behavior described in an insight started.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The time when the behavior described in an insight ended.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The time when the behavior described in an insight ended.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightTimeRange`](crate::model::InsightTimeRange)
        pub fn build(self) -> crate::model::InsightTimeRange {
            crate::model::InsightTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl InsightTimeRange {
    /// Creates a new builder-style object to manufacture [`InsightTimeRange`](crate::model::InsightTimeRange)
    pub fn builder() -> crate::model::insight_time_range::Builder {
        crate::model::insight_time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightStatus {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightStatus {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => InsightStatus::Closed,
            "ONGOING" => InsightStatus::Ongoing,
            other => InsightStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightStatus::from(s))
    }
}
impl InsightStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightStatus::Closed => "CLOSED",
            InsightStatus::Ongoing => "ONGOING",
            InsightStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "ONGOING"]
    }
}
impl AsRef<str> for InsightStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightSeverity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightSeverity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => InsightSeverity::High,
            "LOW" => InsightSeverity::Low,
            "MEDIUM" => InsightSeverity::Medium,
            other => InsightSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightSeverity::from(s))
    }
}
impl InsightSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightSeverity::High => "HIGH",
            InsightSeverity::Low => "LOW",
            InsightSeverity::Medium => "MEDIUM",
            InsightSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for InsightSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a proactive insight. This object is returned by
/// <code>DescribeInsight.</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveInsightSummary {
    /// <p>The ID of the proactive insight. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the proactive insight. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The severity of the proactive insight. </p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p>The status of the proactive insight. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and
    /// ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p>
    /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
    /// </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of AWS services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl std::fmt::Debug for ProactiveInsightSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveInsightSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
pub mod proactive_insight_summary {
    /// A builder for [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// <p>The ID of the proactive insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the proactive insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The severity of the proactive insight. </p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the proactive insight. </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of AWS services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of AWS services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
        pub fn build(self) -> crate::model::ProactiveInsightSummary {
            crate::model::ProactiveInsightSummary {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                prediction_time_range: self.prediction_time_range,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl ProactiveInsightSummary {
    /// Creates a new builder-style object to manufacture [`ProactiveInsightSummary`](crate::model::ProactiveInsightSummary)
    pub fn builder() -> crate::model::proactive_insight_summary::Builder {
        crate::model::proactive_insight_summary::Builder::default()
    }
}

/// <p>
/// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictionTimeRange {
    /// <p>
    /// The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time when the behavior in a proactive insight is expected to end.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for PredictionTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictionTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`PredictionTimeRange`](crate::model::PredictionTimeRange)
pub mod prediction_time_range {
    /// A builder for [`PredictionTimeRange`](crate::model::PredictionTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The time when the behavior in a proactive insight is expected to end.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The time when the behavior in a proactive insight is expected to end.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictionTimeRange`](crate::model::PredictionTimeRange)
        pub fn build(self) -> crate::model::PredictionTimeRange {
            crate::model::PredictionTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl PredictionTimeRange {
    /// Creates a new builder-style object to manufacture [`PredictionTimeRange`](crate::model::PredictionTimeRange)
    pub fn builder() -> crate::model::prediction_time_range::Builder {
        crate::model::prediction_time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightType {
    #[allow(missing_docs)] // documentation missing in model
    Proactive,
    #[allow(missing_docs)] // documentation missing in model
    Reactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightType {
    fn from(s: &str) -> Self {
        match s {
            "PROACTIVE" => InsightType::Proactive,
            "REACTIVE" => InsightType::Reactive,
            other => InsightType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightType::from(s))
    }
}
impl InsightType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightType::Proactive => "PROACTIVE",
            InsightType::Reactive => "REACTIVE",
            InsightType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROACTIVE", "REACTIVE"]
    }
}
impl AsRef<str> for InsightType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Specifies one or more severity values and one or more status values that are used to search
/// for insights.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchInsightsFilters {
    /// <p>
    /// An array of severity values used to search for insights.
    /// </p>
    pub severities: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
    /// <p>
    /// An array of status values used to search for insights.
    /// </p>
    pub statuses: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>A collection of the names of AWS services.</p>
    pub service_collection: std::option::Option<crate::model::ServiceCollection>,
}
impl std::fmt::Debug for SearchInsightsFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchInsightsFilters");
        formatter.field("severities", &self.severities);
        formatter.field("statuses", &self.statuses);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("service_collection", &self.service_collection);
        formatter.finish()
    }
}
/// See [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
pub mod search_insights_filters {
    /// A builder for [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) severities: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
        pub(crate) statuses: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) service_collection: std::option::Option<crate::model::ServiceCollection>,
    }
    impl Builder {
        /// Appends an item to `severities`.
        ///
        /// To override the contents of this collection use [`set_severities`](Self::set_severities).
        ///
        /// <p>
        /// An array of severity values used to search for insights.
        /// </p>
        pub fn severities(mut self, input: impl Into<crate::model::InsightSeverity>) -> Self {
            let mut v = self.severities.unwrap_or_default();
            v.push(input.into());
            self.severities = Some(v);
            self
        }
        /// <p>
        /// An array of severity values used to search for insights.
        /// </p>
        pub fn set_severities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSeverity>>,
        ) -> Self {
            self.severities = input;
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>
        /// An array of status values used to search for insights.
        /// </p>
        pub fn statuses(mut self, input: impl Into<crate::model::InsightStatus>) -> Self {
            let mut v = self.statuses.unwrap_or_default();
            v.push(input.into());
            self.statuses = Some(v);
            self
        }
        /// <p>
        /// An array of status values used to search for insights.
        /// </p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightStatus>>,
        ) -> Self {
            self.statuses = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>A collection of the names of AWS services.</p>
        pub fn service_collection(mut self, input: crate::model::ServiceCollection) -> Self {
            self.service_collection = Some(input);
            self
        }
        /// <p>A collection of the names of AWS services.</p>
        pub fn set_service_collection(
            mut self,
            input: std::option::Option<crate::model::ServiceCollection>,
        ) -> Self {
            self.service_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
        pub fn build(self) -> crate::model::SearchInsightsFilters {
            crate::model::SearchInsightsFilters {
                severities: self.severities,
                statuses: self.statuses,
                resource_collection: self.resource_collection,
                service_collection: self.service_collection,
            }
        }
    }
}
impl SearchInsightsFilters {
    /// Creates a new builder-style object to manufacture [`SearchInsightsFilters`](crate::model::SearchInsightsFilters)
    pub fn builder() -> crate::model::search_insights_filters::Builder {
        crate::model::search_insights_filters::Builder::default()
    }
}

/// <p>
/// A time range used to specify when the behavior of an insight or anomaly started.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTimeRange {
    /// <p>
    /// The start time of the time range.
    /// </p>
    pub from_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The end time of the time range.
    /// </p>
    pub to_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StartTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTimeRange");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}
/// See [`StartTimeRange`](crate::model::StartTimeRange)
pub mod start_time_range {
    /// A builder for [`StartTimeRange`](crate::model::StartTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The start time of the time range.
        /// </p>
        pub fn from_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p>
        /// The start time of the time range.
        /// </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p>
        /// The end time of the time range.
        /// </p>
        pub fn to_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p>
        /// The end time of the time range.
        /// </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTimeRange`](crate::model::StartTimeRange)
        pub fn build(self) -> crate::model::StartTimeRange {
            crate::model::StartTimeRange {
                from_time: self.from_time,
                to_time: self.to_time,
            }
        }
    }
}
impl StartTimeRange {
    /// Creates a new builder-style object to manufacture [`StartTimeRange`](crate::model::StartTimeRange)
    pub fn builder() -> crate::model::start_time_range::Builder {
        crate::model::start_time_range::Builder::default()
    }
}

/// <p>
/// Information about insight feedback received from a customer.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightFeedback {
    /// <p>
    /// The insight feedback ID.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// The feedback provided by the customer.
    /// </p>
    pub feedback: std::option::Option<crate::model::InsightFeedbackOption>,
}
impl std::fmt::Debug for InsightFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightFeedback");
        formatter.field("id", &self.id);
        formatter.field("feedback", &self.feedback);
        formatter.finish()
    }
}
/// See [`InsightFeedback`](crate::model::InsightFeedback)
pub mod insight_feedback {
    /// A builder for [`InsightFeedback`](crate::model::InsightFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) feedback: std::option::Option<crate::model::InsightFeedbackOption>,
    }
    impl Builder {
        /// <p>
        /// The insight feedback ID.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The insight feedback ID.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// The feedback provided by the customer.
        /// </p>
        pub fn feedback(mut self, input: crate::model::InsightFeedbackOption) -> Self {
            self.feedback = Some(input);
            self
        }
        /// <p>
        /// The feedback provided by the customer.
        /// </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::InsightFeedbackOption>,
        ) -> Self {
            self.feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightFeedback`](crate::model::InsightFeedback)
        pub fn build(self) -> crate::model::InsightFeedback {
            crate::model::InsightFeedback {
                id: self.id,
                feedback: self.feedback,
            }
        }
    }
}
impl InsightFeedback {
    /// Creates a new builder-style object to manufacture [`InsightFeedback`](crate::model::InsightFeedback)
    pub fn builder() -> crate::model::insight_feedback::Builder {
        crate::model::insight_feedback::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightFeedbackOption {
    #[allow(missing_docs)] // documentation missing in model
    AlertTooSensitive,
    #[allow(missing_docs)] // documentation missing in model
    DataIncorrect,
    #[allow(missing_docs)] // documentation missing in model
    DataNoisyAnomaly,
    #[allow(missing_docs)] // documentation missing in model
    RecommendationUseful,
    #[allow(missing_docs)] // documentation missing in model
    ValidCollection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightFeedbackOption {
    fn from(s: &str) -> Self {
        match s {
            "ALERT_TOO_SENSITIVE" => InsightFeedbackOption::AlertTooSensitive,
            "DATA_INCORRECT" => InsightFeedbackOption::DataIncorrect,
            "DATA_NOISY_ANOMALY" => InsightFeedbackOption::DataNoisyAnomaly,
            "RECOMMENDATION_USEFUL" => InsightFeedbackOption::RecommendationUseful,
            "VALID_COLLECTION" => InsightFeedbackOption::ValidCollection,
            other => InsightFeedbackOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightFeedbackOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightFeedbackOption::from(s))
    }
}
impl InsightFeedbackOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightFeedbackOption::AlertTooSensitive => "ALERT_TOO_SENSITIVE",
            InsightFeedbackOption::DataIncorrect => "DATA_INCORRECT",
            InsightFeedbackOption::DataNoisyAnomaly => "DATA_NOISY_ANOMALY",
            InsightFeedbackOption::RecommendationUseful => "RECOMMENDATION_USEFUL",
            InsightFeedbackOption::ValidCollection => "VALID_COLLECTION",
            InsightFeedbackOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALERT_TOO_SENSITIVE",
            "DATA_INCORRECT",
            "DATA_NOISY_ANOMALY",
            "RECOMMENDATION_USEFUL",
            "VALID_COLLECTION",
        ]
    }
}
impl AsRef<str> for InsightFeedbackOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Recommendation information to help you remediate detected anomalous behavior that
/// generated an insight. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recommendation {
    /// <p>
    /// A description of the problem.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// A hyperlink to information to help you address the problem.
    /// </p>
    pub link: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the recommendation.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The reason DevOps Guru flagged the anomalous behavior as a problem.
    /// </p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>
    /// Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue.
    /// </p>
    pub related_events:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEvent>>,
    /// <p>
    /// Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue.
    /// </p>
    pub related_anomalies:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomaly>>,
}
impl std::fmt::Debug for Recommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recommendation");
        formatter.field("description", &self.description);
        formatter.field("link", &self.link);
        formatter.field("name", &self.name);
        formatter.field("reason", &self.reason);
        formatter.field("related_events", &self.related_events);
        formatter.field("related_anomalies", &self.related_anomalies);
        formatter.finish()
    }
}
/// See [`Recommendation`](crate::model::Recommendation)
pub mod recommendation {
    /// A builder for [`Recommendation`](crate::model::Recommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) link: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) related_events:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEvent>>,
        pub(crate) related_anomalies:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomaly>>,
    }
    impl Builder {
        /// <p>
        /// A description of the problem.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A description of the problem.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>
        /// A hyperlink to information to help you address the problem.
        /// </p>
        pub fn link(mut self, input: impl Into<std::string::String>) -> Self {
            self.link = Some(input.into());
            self
        }
        /// <p>
        /// A hyperlink to information to help you address the problem.
        /// </p>
        pub fn set_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link = input;
            self
        }
        /// <p>
        /// The name of the recommendation.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the recommendation.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The reason DevOps Guru flagged the anomalous behavior as a problem.
        /// </p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>
        /// The reason DevOps Guru flagged the anomalous behavior as a problem.
        /// </p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `related_events`.
        ///
        /// To override the contents of this collection use [`set_related_events`](Self::set_related_events).
        ///
        /// <p>
        /// Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue.
        /// </p>
        pub fn related_events(
            mut self,
            input: impl Into<crate::model::RecommendationRelatedEvent>,
        ) -> Self {
            let mut v = self.related_events.unwrap_or_default();
            v.push(input.into());
            self.related_events = Some(v);
            self
        }
        /// <p>
        /// Events that are related to the problem. Use these events to learn more about what's happening and to help address the issue.
        /// </p>
        pub fn set_related_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEvent>>,
        ) -> Self {
            self.related_events = input;
            self
        }
        /// Appends an item to `related_anomalies`.
        ///
        /// To override the contents of this collection use [`set_related_anomalies`](Self::set_related_anomalies).
        ///
        /// <p>
        /// Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue.
        /// </p>
        pub fn related_anomalies(
            mut self,
            input: impl Into<crate::model::RecommendationRelatedAnomaly>,
        ) -> Self {
            let mut v = self.related_anomalies.unwrap_or_default();
            v.push(input.into());
            self.related_anomalies = Some(v);
            self
        }
        /// <p>
        /// Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help address the issue.
        /// </p>
        pub fn set_related_anomalies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomaly>>,
        ) -> Self {
            self.related_anomalies = input;
            self
        }
        /// Consumes the builder and constructs a [`Recommendation`](crate::model::Recommendation)
        pub fn build(self) -> crate::model::Recommendation {
            crate::model::Recommendation {
                description: self.description,
                link: self.link,
                name: self.name,
                reason: self.reason,
                related_events: self.related_events,
                related_anomalies: self.related_anomalies,
            }
        }
    }
}
impl Recommendation {
    /// Creates a new builder-style object to manufacture [`Recommendation`](crate::model::Recommendation)
    pub fn builder() -> crate::model::recommendation::Builder {
        crate::model::recommendation::Builder::default()
    }
}

/// <p>
/// Information about an anomaly that is related to a recommendation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedAnomaly {
    /// <p>
    /// An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name
    /// and type of the resource.
    /// </p>
    pub resources:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomalyResource>>,
    /// <p>
    /// Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics.
    /// </p>
    pub source_details:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomalySourceDetail>>,
}
impl std::fmt::Debug for RecommendationRelatedAnomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedAnomaly");
        formatter.field("resources", &self.resources);
        formatter.field("source_details", &self.source_details);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
pub mod recommendation_related_anomaly {
    /// A builder for [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedAnomalyResource>>,
        pub(crate) source_details: std::option::Option<
            std::vec::Vec<crate::model::RecommendationRelatedAnomalySourceDetail>,
        >,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>
        /// An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name
        /// and type of the resource.
        /// </p>
        pub fn resources(
            mut self,
            input: impl Into<crate::model::RecommendationRelatedAnomalyResource>,
        ) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>
        /// An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name
        /// and type of the resource.
        /// </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedAnomalyResource>,
            >,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `source_details`.
        ///
        /// To override the contents of this collection use [`set_source_details`](Self::set_source_details).
        ///
        /// <p>
        /// Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics.
        /// </p>
        pub fn source_details(
            mut self,
            input: impl Into<crate::model::RecommendationRelatedAnomalySourceDetail>,
        ) -> Self {
            let mut v = self.source_details.unwrap_or_default();
            v.push(input.into());
            self.source_details = Some(v);
            self
        }
        /// <p>
        /// Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics.
        /// </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedAnomalySourceDetail>,
            >,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
        pub fn build(self) -> crate::model::RecommendationRelatedAnomaly {
            crate::model::RecommendationRelatedAnomaly {
                resources: self.resources,
                source_details: self.source_details,
            }
        }
    }
}
impl RecommendationRelatedAnomaly {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedAnomaly`](crate::model::RecommendationRelatedAnomaly)
    pub fn builder() -> crate::model::recommendation_related_anomaly::Builder {
        crate::model::recommendation_related_anomaly::Builder::default()
    }
}

/// <p>
/// Contains an array of <code>RecommendationRelatedCloudWatchMetricsSourceDetail</code> objects that contain the name
/// and namespace of an Amazon CloudWatch metric.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedAnomalySourceDetail {
    /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information
    /// about the analyzed metrics that displayed anomalous behavior. </p>
    pub cloud_watch_metrics: std::option::Option<
        std::vec::Vec<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
    >,
}
impl std::fmt::Debug for RecommendationRelatedAnomalySourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedAnomalySourceDetail");
        formatter.field("cloud_watch_metrics", &self.cloud_watch_metrics);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
pub mod recommendation_related_anomaly_source_detail {
    /// A builder for [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_metrics: std::option::Option<
            std::vec::Vec<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
        >,
    }
    impl Builder {
        /// Appends an item to `cloud_watch_metrics`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_metrics`](Self::set_cloud_watch_metrics).
        ///
        /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information
        /// about the analyzed metrics that displayed anomalous behavior. </p>
        pub fn cloud_watch_metrics(
            mut self,
            input: impl Into<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
        ) -> Self {
            let mut v = self.cloud_watch_metrics.unwrap_or_default();
            v.push(input.into());
            self.cloud_watch_metrics = Some(v);
            self
        }
        /// <p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information
        /// about the analyzed metrics that displayed anomalous behavior. </p>
        pub fn set_cloud_watch_metrics(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail>,
            >,
        ) -> Self {
            self.cloud_watch_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
        pub fn build(self) -> crate::model::RecommendationRelatedAnomalySourceDetail {
            crate::model::RecommendationRelatedAnomalySourceDetail {
                cloud_watch_metrics: self.cloud_watch_metrics,
            }
        }
    }
}
impl RecommendationRelatedAnomalySourceDetail {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedAnomalySourceDetail`](crate::model::RecommendationRelatedAnomalySourceDetail)
    pub fn builder() -> crate::model::recommendation_related_anomaly_source_detail::Builder {
        crate::model::recommendation_related_anomaly_source_detail::Builder::default()
    }
}

/// <p>
/// Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru. It is one of many analyzed metrics
/// that are used to generate insights.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedCloudWatchMetricsSourceDetail {
    /// <p>The name of the CloudWatch metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecommendationRelatedCloudWatchMetricsSourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedCloudWatchMetricsSourceDetail");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
pub mod recommendation_related_cloud_watch_metrics_source_detail {
    /// A builder for [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
        pub fn build(self) -> crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail {
            crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail {
                metric_name: self.metric_name,
                namespace: self.namespace,
            }
        }
    }
}
impl RecommendationRelatedCloudWatchMetricsSourceDetail {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedCloudWatchMetricsSourceDetail`](crate::model::RecommendationRelatedCloudWatchMetricsSourceDetail)
    pub fn builder(
    ) -> crate::model::recommendation_related_cloud_watch_metrics_source_detail::Builder {
        crate::model::recommendation_related_cloud_watch_metrics_source_detail::Builder::default()
    }
}

/// <p>
/// Information about a resource in which DevOps Guru detected anomalous behavior.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedAnomalyResource {
    /// <p>
    /// The name of the resource.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The type of the resource.
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecommendationRelatedAnomalyResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedAnomalyResource");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
pub mod recommendation_related_anomaly_resource {
    /// A builder for [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the resource.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the resource.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The type of the resource.
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>
        /// The type of the resource.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
        pub fn build(self) -> crate::model::RecommendationRelatedAnomalyResource {
            crate::model::RecommendationRelatedAnomalyResource {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl RecommendationRelatedAnomalyResource {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedAnomalyResource`](crate::model::RecommendationRelatedAnomalyResource)
    pub fn builder() -> crate::model::recommendation_related_anomaly_resource::Builder {
        crate::model::recommendation_related_anomaly_resource::Builder::default()
    }
}

/// <p>
/// Information about an event that is related to a recommendation.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedEvent {
    /// <p>
    /// The name of the event. This corresponds to the <code>Name</code> field in an
    /// <code>Event</code> object.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// A <code>ResourceCollection</code> object that contains arrays of the names of AWS
    /// CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resources:
        std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEventResource>>,
}
impl std::fmt::Debug for RecommendationRelatedEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedEvent");
        formatter.field("name", &self.name);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
pub mod recommendation_related_event {
    /// A builder for [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resources:
            std::option::Option<std::vec::Vec<crate::model::RecommendationRelatedEventResource>>,
    }
    impl Builder {
        /// <p>
        /// The name of the event. This corresponds to the <code>Name</code> field in an
        /// <code>Event</code> object.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the event. This corresponds to the <code>Name</code> field in an
        /// <code>Event</code> object.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>
        /// A <code>ResourceCollection</code> object that contains arrays of the names of AWS
        /// CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resources(
            mut self,
            input: impl Into<crate::model::RecommendationRelatedEventResource>,
        ) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>
        /// A <code>ResourceCollection</code> object that contains arrays of the names of AWS
        /// CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RecommendationRelatedEventResource>,
            >,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
        pub fn build(self) -> crate::model::RecommendationRelatedEvent {
            crate::model::RecommendationRelatedEvent {
                name: self.name,
                resources: self.resources,
            }
        }
    }
}
impl RecommendationRelatedEvent {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedEvent`](crate::model::RecommendationRelatedEvent)
    pub fn builder() -> crate::model::recommendation_related_event::Builder {
        crate::model::recommendation_related_event::Builder::default()
    }
}

/// <p>
/// Information about an AWS resource that emitted and event that is related to a recommendation in an insight.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationRelatedEventResource {
    /// <p>
    /// The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an
    /// <code>EventResource</code> object.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an
    /// <code>EventResource</code> object.
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecommendationRelatedEventResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationRelatedEventResource");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
pub mod recommendation_related_event_resource {
    /// A builder for [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an
        /// <code>EventResource</code> object.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an
        /// <code>EventResource</code> object.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an
        /// <code>EventResource</code> object.
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>
        /// The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an
        /// <code>EventResource</code> object.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
        pub fn build(self) -> crate::model::RecommendationRelatedEventResource {
            crate::model::RecommendationRelatedEventResource {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl RecommendationRelatedEventResource {
    /// Creates a new builder-style object to manufacture [`RecommendationRelatedEventResource`](crate::model::RecommendationRelatedEventResource)
    pub fn builder() -> crate::model::recommendation_related_event_resource::Builder {
        crate::model::recommendation_related_event_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Locale {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    EsEs,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JaJp,
    #[allow(missing_docs)] // documentation missing in model
    KoKr,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    #[allow(missing_docs)] // documentation missing in model
    ZhTw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Locale {
    fn from(s: &str) -> Self {
        match s {
            "DE_DE" => Locale::DeDe,
            "EN_GB" => Locale::EnGb,
            "EN_US" => Locale::EnUs,
            "ES_ES" => Locale::EsEs,
            "FR_FR" => Locale::FrFr,
            "IT_IT" => Locale::ItIt,
            "JA_JP" => Locale::JaJp,
            "KO_KR" => Locale::KoKr,
            "PT_BR" => Locale::PtBr,
            "ZH_CN" => Locale::ZhCn,
            "ZH_TW" => Locale::ZhTw,
            other => Locale::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Locale {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Locale::from(s))
    }
}
impl Locale {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Locale::DeDe => "DE_DE",
            Locale::EnGb => "EN_GB",
            Locale::EnUs => "EN_US",
            Locale::EsEs => "ES_ES",
            Locale::FrFr => "FR_FR",
            Locale::ItIt => "IT_IT",
            Locale::JaJp => "JA_JP",
            Locale::KoKr => "KO_KR",
            Locale::PtBr => "PT_BR",
            Locale::ZhCn => "ZH_CN",
            Locale::ZhTw => "ZH_TW",
            Locale::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DE_DE", "EN_GB", "EN_US", "ES_ES", "FR_FR", "IT_IT", "JA_JP", "KO_KR", "PT_BR",
            "ZH_CN", "ZH_TW",
        ]
    }
}
impl AsRef<str> for Locale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about a notification channel. A notification channel is used to notify you when DevOps Guru creates an insight.
/// The one
/// supported notification channel is Amazon Simple Notification Service (Amazon SNS).
/// </p>
///
/// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
/// to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account.
/// For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions
/// for cross account Amazon SNS topics</a>.</p>
/// <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions
/// to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
/// AWS KMS–encrypted Amazon SNS topics</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationChannel {
    /// <p>
    /// The ID of a notification channel.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// A <code>NotificationChannelConfig</code> object that contains information about configured notification channels.
    /// </p>
    pub config: std::option::Option<crate::model::NotificationChannelConfig>,
}
impl std::fmt::Debug for NotificationChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationChannel");
        formatter.field("id", &self.id);
        formatter.field("config", &self.config);
        formatter.finish()
    }
}
/// See [`NotificationChannel`](crate::model::NotificationChannel)
pub mod notification_channel {
    /// A builder for [`NotificationChannel`](crate::model::NotificationChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<crate::model::NotificationChannelConfig>,
    }
    impl Builder {
        /// <p>
        /// The ID of a notification channel.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of a notification channel.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// A <code>NotificationChannelConfig</code> object that contains information about configured notification channels.
        /// </p>
        pub fn config(mut self, input: crate::model::NotificationChannelConfig) -> Self {
            self.config = Some(input);
            self
        }
        /// <p>
        /// A <code>NotificationChannelConfig</code> object that contains information about configured notification channels.
        /// </p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::NotificationChannelConfig>,
        ) -> Self {
            self.config = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationChannel`](crate::model::NotificationChannel)
        pub fn build(self) -> crate::model::NotificationChannel {
            crate::model::NotificationChannel {
                id: self.id,
                config: self.config,
            }
        }
    }
}
impl NotificationChannel {
    /// Creates a new builder-style object to manufacture [`NotificationChannel`](crate::model::NotificationChannel)
    pub fn builder() -> crate::model::notification_channel::Builder {
        crate::model::notification_channel::Builder::default()
    }
}

/// <p> Information about notification channels you have configured with DevOps Guru.
/// The one
/// supported notification channel is Amazon Simple Notification Service (Amazon SNS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationChannelConfig {
    /// <p>
    /// Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
    /// </p>
    ///
    /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
    /// to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account.
    /// For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions
    /// for cross account Amazon SNS topics</a>.</p>
    /// <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions
    /// to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
    /// AWS KMS–encrypted Amazon SNS topics</a>.</p>
    pub sns: std::option::Option<crate::model::SnsChannelConfig>,
}
impl std::fmt::Debug for NotificationChannelConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationChannelConfig");
        formatter.field("sns", &self.sns);
        formatter.finish()
    }
}
/// See [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
pub mod notification_channel_config {
    /// A builder for [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns: std::option::Option<crate::model::SnsChannelConfig>,
    }
    impl Builder {
        /// <p>
        /// Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
        /// </p>
        ///
        /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
        /// to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account.
        /// For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions
        /// for cross account Amazon SNS topics</a>.</p>
        /// <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions
        /// to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
        /// AWS KMS–encrypted Amazon SNS topics</a>.</p>
        pub fn sns(mut self, input: crate::model::SnsChannelConfig) -> Self {
            self.sns = Some(input);
            self
        }
        /// <p>
        /// Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
        /// </p>
        ///
        /// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
        /// to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account.
        /// For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions
        /// for cross account Amazon SNS topics</a>.</p>
        /// <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions
        /// to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
        /// AWS KMS–encrypted Amazon SNS topics</a>.</p>
        pub fn set_sns(
            mut self,
            input: std::option::Option<crate::model::SnsChannelConfig>,
        ) -> Self {
            self.sns = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
        pub fn build(self) -> crate::model::NotificationChannelConfig {
            crate::model::NotificationChannelConfig { sns: self.sns }
        }
    }
}
impl NotificationChannelConfig {
    /// Creates a new builder-style object to manufacture [`NotificationChannelConfig`](crate::model::NotificationChannelConfig)
    pub fn builder() -> crate::model::notification_channel_config::Builder {
        crate::model::notification_channel_config::Builder::default()
    }
}

/// <p> Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
///
/// <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission
/// to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account.
/// For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions
/// for cross account Amazon SNS topics</a>.</p>
/// <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions
/// to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
/// AWS KMS–encrypted Amazon SNS topics</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsChannelConfig {
    /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsChannelConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsChannelConfig");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`SnsChannelConfig`](crate::model::SnsChannelConfig)
pub mod sns_channel_config {
    /// A builder for [`SnsChannelConfig`](crate::model::SnsChannelConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsChannelConfig`](crate::model::SnsChannelConfig)
        pub fn build(self) -> crate::model::SnsChannelConfig {
            crate::model::SnsChannelConfig {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl SnsChannelConfig {
    /// Creates a new builder-style object to manufacture [`SnsChannelConfig`](crate::model::SnsChannelConfig)
    pub fn builder() -> crate::model::sns_channel_config::Builder {
        crate::model::sns_channel_config::Builder::default()
    }
}

/// <p>
/// A filter used by <code>ListInsights</code> to specify which insights to return.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsStatusFilter {
    /// <p>
    /// A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights
    /// that are either <code>REACTIVE</code> or <code>PROACTIVE</code>.
    /// </p>
    pub ongoing: std::option::Option<crate::model::ListInsightsOngoingStatusFilter>,
    /// <p>
    /// A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are
    /// either <code>REACTIVE</code> or <code>PROACTIVE</code>.
    /// </p>
    pub closed: std::option::Option<crate::model::ListInsightsClosedStatusFilter>,
    /// <p>
    /// A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status
    /// that are either <code>REACTIVE</code> or <code>PROACTIVE</code>.
    /// </p>
    pub any: std::option::Option<crate::model::ListInsightsAnyStatusFilter>,
}
impl std::fmt::Debug for ListInsightsStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsStatusFilter");
        formatter.field("ongoing", &self.ongoing);
        formatter.field("closed", &self.closed);
        formatter.field("any", &self.any);
        formatter.finish()
    }
}
/// See [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
pub mod list_insights_status_filter {
    /// A builder for [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ongoing: std::option::Option<crate::model::ListInsightsOngoingStatusFilter>,
        pub(crate) closed: std::option::Option<crate::model::ListInsightsClosedStatusFilter>,
        pub(crate) any: std::option::Option<crate::model::ListInsightsAnyStatusFilter>,
    }
    impl Builder {
        /// <p>
        /// A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights
        /// that are either <code>REACTIVE</code> or <code>PROACTIVE</code>.
        /// </p>
        pub fn ongoing(mut self, input: crate::model::ListInsightsOngoingStatusFilter) -> Self {
            self.ongoing = Some(input);
            self
        }
        /// <p>
        /// A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights
        /// that are either <code>REACTIVE</code> or <code>PROACTIVE</code>.
        /// </p>
        pub fn set_ongoing(
            mut self,
            input: std::option::Option<crate::model::ListInsightsOngoingStatusFilter>,
        ) -> Self {
            self.ongoing = input;
            self
        }
        /// <p>
        /// A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are
        /// either <code>REACTIVE</code> or <code>PROACTIVE</code>.
        /// </p>
        pub fn closed(mut self, input: crate::model::ListInsightsClosedStatusFilter) -> Self {
            self.closed = Some(input);
            self
        }
        /// <p>
        /// A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are
        /// either <code>REACTIVE</code> or <code>PROACTIVE</code>.
        /// </p>
        pub fn set_closed(
            mut self,
            input: std::option::Option<crate::model::ListInsightsClosedStatusFilter>,
        ) -> Self {
            self.closed = input;
            self
        }
        /// <p>
        /// A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status
        /// that are either <code>REACTIVE</code> or <code>PROACTIVE</code>.
        /// </p>
        pub fn any(mut self, input: crate::model::ListInsightsAnyStatusFilter) -> Self {
            self.any = Some(input);
            self
        }
        /// <p>
        /// A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status
        /// that are either <code>REACTIVE</code> or <code>PROACTIVE</code>.
        /// </p>
        pub fn set_any(
            mut self,
            input: std::option::Option<crate::model::ListInsightsAnyStatusFilter>,
        ) -> Self {
            self.any = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsStatusFilter {
            crate::model::ListInsightsStatusFilter {
                ongoing: self.ongoing,
                closed: self.closed,
                any: self.any,
            }
        }
    }
}
impl ListInsightsStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsStatusFilter`](crate::model::ListInsightsStatusFilter)
    pub fn builder() -> crate::model::list_insights_status_filter::Builder {
        crate::model::list_insights_status_filter::Builder::default()
    }
}

/// <p>
/// Used to filter for insights that have any status.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsAnyStatusFilter {
    /// <p>
    /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
    /// </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
    /// <p>
    /// A time range used to specify when the behavior of the filtered insights started.
    /// </p>
    pub start_time_range: std::option::Option<crate::model::StartTimeRange>,
}
impl std::fmt::Debug for ListInsightsAnyStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsAnyStatusFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("start_time_range", &self.start_time_range);
        formatter.finish()
    }
}
/// See [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
pub mod list_insights_any_status_filter {
    /// A builder for [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
        pub(crate) start_time_range: std::option::Option<crate::model::StartTimeRange>,
    }
    impl Builder {
        /// <p>
        /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
        /// </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// A time range used to specify when the behavior of the filtered insights started.
        /// </p>
        pub fn start_time_range(mut self, input: crate::model::StartTimeRange) -> Self {
            self.start_time_range = Some(input);
            self
        }
        /// <p>
        /// A time range used to specify when the behavior of the filtered insights started.
        /// </p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::StartTimeRange>,
        ) -> Self {
            self.start_time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsAnyStatusFilter {
            crate::model::ListInsightsAnyStatusFilter {
                r#type: self.r#type,
                start_time_range: self.start_time_range,
            }
        }
    }
}
impl ListInsightsAnyStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsAnyStatusFilter`](crate::model::ListInsightsAnyStatusFilter)
    pub fn builder() -> crate::model::list_insights_any_status_filter::Builder {
        crate::model::list_insights_any_status_filter::Builder::default()
    }
}

/// <p>
/// Used to filter for insights that have the status <code>CLOSED</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsClosedStatusFilter {
    /// <p>
    /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
    /// </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
    /// <p>
    /// A time range used to specify when the behavior of the filtered insights ended.
    /// </p>
    pub end_time_range: std::option::Option<crate::model::EndTimeRange>,
}
impl std::fmt::Debug for ListInsightsClosedStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsClosedStatusFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("end_time_range", &self.end_time_range);
        formatter.finish()
    }
}
/// See [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
pub mod list_insights_closed_status_filter {
    /// A builder for [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
        pub(crate) end_time_range: std::option::Option<crate::model::EndTimeRange>,
    }
    impl Builder {
        /// <p>
        /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
        /// </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// A time range used to specify when the behavior of the filtered insights ended.
        /// </p>
        pub fn end_time_range(mut self, input: crate::model::EndTimeRange) -> Self {
            self.end_time_range = Some(input);
            self
        }
        /// <p>
        /// A time range used to specify when the behavior of the filtered insights ended.
        /// </p>
        pub fn set_end_time_range(
            mut self,
            input: std::option::Option<crate::model::EndTimeRange>,
        ) -> Self {
            self.end_time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsClosedStatusFilter {
            crate::model::ListInsightsClosedStatusFilter {
                r#type: self.r#type,
                end_time_range: self.end_time_range,
            }
        }
    }
}
impl ListInsightsClosedStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsClosedStatusFilter`](crate::model::ListInsightsClosedStatusFilter)
    pub fn builder() -> crate::model::list_insights_closed_status_filter::Builder {
        crate::model::list_insights_closed_status_filter::Builder::default()
    }
}

/// <p>
/// A range of time that specifies when anomalous behavior in an anomaly or insight ended.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndTimeRange {
    /// <p>
    /// The earliest end time in the time range.
    /// </p>
    pub from_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The latest end time in the time range.
    /// </p>
    pub to_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for EndTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndTimeRange");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}
/// See [`EndTimeRange`](crate::model::EndTimeRange)
pub mod end_time_range {
    /// A builder for [`EndTimeRange`](crate::model::EndTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The earliest end time in the time range.
        /// </p>
        pub fn from_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p>
        /// The earliest end time in the time range.
        /// </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p>
        /// The latest end time in the time range.
        /// </p>
        pub fn to_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p>
        /// The latest end time in the time range.
        /// </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EndTimeRange`](crate::model::EndTimeRange)
        pub fn build(self) -> crate::model::EndTimeRange {
            crate::model::EndTimeRange {
                from_time: self.from_time,
                to_time: self.to_time,
            }
        }
    }
}
impl EndTimeRange {
    /// Creates a new builder-style object to manufacture [`EndTimeRange`](crate::model::EndTimeRange)
    pub fn builder() -> crate::model::end_time_range::Builder {
        crate::model::end_time_range::Builder::default()
    }
}

/// <p>
/// Used to filter for insights that have the status <code>ONGOING</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInsightsOngoingStatusFilter {
    /// <p>
    /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
    /// </p>
    pub r#type: std::option::Option<crate::model::InsightType>,
}
impl std::fmt::Debug for ListInsightsOngoingStatusFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInsightsOngoingStatusFilter");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
pub mod list_insights_ongoing_status_filter {
    /// A builder for [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::InsightType>,
    }
    impl Builder {
        /// <p>
        /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
        /// </p>
        pub fn r#type(mut self, input: crate::model::InsightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::InsightType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
        pub fn build(self) -> crate::model::ListInsightsOngoingStatusFilter {
            crate::model::ListInsightsOngoingStatusFilter {
                r#type: self.r#type,
            }
        }
    }
}
impl ListInsightsOngoingStatusFilter {
    /// Creates a new builder-style object to manufacture [`ListInsightsOngoingStatusFilter`](crate::model::ListInsightsOngoingStatusFilter)
    pub fn builder() -> crate::model::list_insights_ongoing_status_filter::Builder {
        crate::model::list_insights_ongoing_status_filter::Builder::default()
    }
}

/// <p>
/// An AWS resource event. AWS resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and
/// provide recommendations to improve your operational solutions.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>
    /// The ID of the event.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
    pub time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The AWS source that emitted the event.
    /// </p>
    pub event_source: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the event.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event.
    /// </p>
    pub data_source: std::option::Option<crate::model::EventDataSource>,
    /// <p>
    /// The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change.
    /// </p>
    pub event_class: std::option::Option<crate::model::EventClass>,
    /// <p>
    /// An <code>EventResource</code> object that contains information about the resource that emitted the event.
    /// </p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::EventResource>>,
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("id", &self.id);
        formatter.field("time", &self.time);
        formatter.field("event_source", &self.event_source);
        formatter.field("name", &self.name);
        formatter.field("data_source", &self.data_source);
        formatter.field("event_class", &self.event_class);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_source: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::EventDataSource>,
        pub(crate) event_class: std::option::Option<crate::model::EventClass>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::EventResource>>,
    }
    impl Builder {
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>
        /// The ID of the event.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the event.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
        pub fn time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.time = Some(input);
            self
        }
        /// <p> A <code>Timestamp</code> that specifies the time the event occurred. </p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.time = input;
            self
        }
        /// <p>
        /// The AWS source that emitted the event.
        /// </p>
        pub fn event_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source = Some(input.into());
            self
        }
        /// <p>
        /// The AWS source that emitted the event.
        /// </p>
        pub fn set_event_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_source = input;
            self
        }
        /// <p>
        /// The name of the event.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the event.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event.
        /// </p>
        pub fn data_source(mut self, input: crate::model::EventDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>
        /// The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event.
        /// </p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::EventDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>
        /// The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change.
        /// </p>
        pub fn event_class(mut self, input: crate::model::EventClass) -> Self {
            self.event_class = Some(input);
            self
        }
        /// <p>
        /// The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change.
        /// </p>
        pub fn set_event_class(
            mut self,
            input: std::option::Option<crate::model::EventClass>,
        ) -> Self {
            self.event_class = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>
        /// An <code>EventResource</code> object that contains information about the resource that emitted the event.
        /// </p>
        pub fn resources(mut self, input: impl Into<crate::model::EventResource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>
        /// An <code>EventResource</code> object that contains information about the resource that emitted the event.
        /// </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventResource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                resource_collection: self.resource_collection,
                id: self.id,
                time: self.time,
                event_source: self.event_source,
                name: self.name,
                data_source: self.data_source,
                event_class: self.event_class,
                resources: self.resources,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p>
/// The AWS resource that emitted an event. AWS resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and
/// provide recommendations to improve your operational solutions.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventResource {
    /// <p>
    /// The type of resource that emitted an event.
    /// </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the resource that emitted an event.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The Amazon Resource Name (ARN) of the resource that emitted an event.
    /// </p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventResource");
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`EventResource`](crate::model::EventResource)
pub mod event_resource {
    /// A builder for [`EventResource`](crate::model::EventResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The type of resource that emitted an event.
        /// </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>
        /// The type of resource that emitted an event.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>
        /// The name of the resource that emitted an event.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the resource that emitted an event.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that emitted an event.
        /// </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the resource that emitted an event.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventResource`](crate::model::EventResource)
        pub fn build(self) -> crate::model::EventResource {
            crate::model::EventResource {
                r#type: self.r#type,
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl EventResource {
    /// Creates a new builder-style object to manufacture [`EventResource`](crate::model::EventResource)
    pub fn builder() -> crate::model::event_resource::Builder {
        crate::model::event_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventClass {
    #[allow(missing_docs)] // documentation missing in model
    ConfigChange,
    #[allow(missing_docs)] // documentation missing in model
    Deployment,
    #[allow(missing_docs)] // documentation missing in model
    Infrastructure,
    #[allow(missing_docs)] // documentation missing in model
    SchemaChange,
    #[allow(missing_docs)] // documentation missing in model
    SecurityChange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventClass {
    fn from(s: &str) -> Self {
        match s {
            "CONFIG_CHANGE" => EventClass::ConfigChange,
            "DEPLOYMENT" => EventClass::Deployment,
            "INFRASTRUCTURE" => EventClass::Infrastructure,
            "SCHEMA_CHANGE" => EventClass::SchemaChange,
            "SECURITY_CHANGE" => EventClass::SecurityChange,
            other => EventClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventClass::from(s))
    }
}
impl EventClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventClass::ConfigChange => "CONFIG_CHANGE",
            EventClass::Deployment => "DEPLOYMENT",
            EventClass::Infrastructure => "INFRASTRUCTURE",
            EventClass::SchemaChange => "SCHEMA_CHANGE",
            EventClass::SecurityChange => "SECURITY_CHANGE",
            EventClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIG_CHANGE",
            "DEPLOYMENT",
            "INFRASTRUCTURE",
            "SCHEMA_CHANGE",
            "SECURITY_CHANGE",
        ]
    }
}
impl AsRef<str> for EventClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventDataSource {
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudTrail,
    #[allow(missing_docs)] // documentation missing in model
    AwsCodeDeploy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventDataSource {
    fn from(s: &str) -> Self {
        match s {
            "AWS_CLOUD_TRAIL" => EventDataSource::AwsCloudTrail,
            "AWS_CODE_DEPLOY" => EventDataSource::AwsCodeDeploy,
            other => EventDataSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventDataSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventDataSource::from(s))
    }
}
impl EventDataSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventDataSource::AwsCloudTrail => "AWS_CLOUD_TRAIL",
            EventDataSource::AwsCodeDeploy => "AWS_CODE_DEPLOY",
            EventDataSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_CLOUD_TRAIL", "AWS_CODE_DEPLOY"]
    }
}
impl AsRef<str> for EventDataSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Filters you can use to specify which events are returned when <code>ListEvents</code> is called.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventsFilters {
    /// <p>
    /// An ID of an insight that is related to the events you want to filter for.
    /// </p>
    pub insight_id: std::option::Option<std::string::String>,
    /// <p> A time range during which you want the filtered events to have occurred. </p>
    pub event_time_range: std::option::Option<crate::model::EventTimeRange>,
    /// <p>
    /// The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change.        
    /// </p>
    pub event_class: std::option::Option<crate::model::EventClass>,
    /// <p>
    /// The AWS source that emitted the events you want to filter for.
    /// </p>
    pub event_source: std::option::Option<std::string::String>,
    /// <p>
    /// The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
    /// </p>
    pub data_source: std::option::Option<crate::model::EventDataSource>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
}
impl std::fmt::Debug for ListEventsFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventsFilters");
        formatter.field("insight_id", &self.insight_id);
        formatter.field("event_time_range", &self.event_time_range);
        formatter.field("event_class", &self.event_class);
        formatter.field("event_source", &self.event_source);
        formatter.field("data_source", &self.data_source);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.finish()
    }
}
/// See [`ListEventsFilters`](crate::model::ListEventsFilters)
pub mod list_events_filters {
    /// A builder for [`ListEventsFilters`](crate::model::ListEventsFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_id: std::option::Option<std::string::String>,
        pub(crate) event_time_range: std::option::Option<crate::model::EventTimeRange>,
        pub(crate) event_class: std::option::Option<crate::model::EventClass>,
        pub(crate) event_source: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::EventDataSource>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
    }
    impl Builder {
        /// <p>
        /// An ID of an insight that is related to the events you want to filter for.
        /// </p>
        pub fn insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.insight_id = Some(input.into());
            self
        }
        /// <p>
        /// An ID of an insight that is related to the events you want to filter for.
        /// </p>
        pub fn set_insight_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.insight_id = input;
            self
        }
        /// <p> A time range during which you want the filtered events to have occurred. </p>
        pub fn event_time_range(mut self, input: crate::model::EventTimeRange) -> Self {
            self.event_time_range = Some(input);
            self
        }
        /// <p> A time range during which you want the filtered events to have occurred. </p>
        pub fn set_event_time_range(
            mut self,
            input: std::option::Option<crate::model::EventTimeRange>,
        ) -> Self {
            self.event_time_range = input;
            self
        }
        /// <p>
        /// The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change.        
        /// </p>
        pub fn event_class(mut self, input: crate::model::EventClass) -> Self {
            self.event_class = Some(input);
            self
        }
        /// <p>
        /// The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change.        
        /// </p>
        pub fn set_event_class(
            mut self,
            input: std::option::Option<crate::model::EventClass>,
        ) -> Self {
            self.event_class = input;
            self
        }
        /// <p>
        /// The AWS source that emitted the events you want to filter for.
        /// </p>
        pub fn event_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source = Some(input.into());
            self
        }
        /// <p>
        /// The AWS source that emitted the events you want to filter for.
        /// </p>
        pub fn set_event_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_source = input;
            self
        }
        /// <p>
        /// The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
        /// </p>
        pub fn data_source(mut self, input: crate::model::EventDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>
        /// The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned.
        /// </p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::EventDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventsFilters`](crate::model::ListEventsFilters)
        pub fn build(self) -> crate::model::ListEventsFilters {
            crate::model::ListEventsFilters {
                insight_id: self.insight_id,
                event_time_range: self.event_time_range,
                event_class: self.event_class,
                event_source: self.event_source,
                data_source: self.data_source,
                resource_collection: self.resource_collection,
            }
        }
    }
}
impl ListEventsFilters {
    /// Creates a new builder-style object to manufacture [`ListEventsFilters`](crate::model::ListEventsFilters)
    pub fn builder() -> crate::model::list_events_filters::Builder {
        crate::model::list_events_filters::Builder::default()
    }
}

/// <p>
/// The time range during which an AWS event occurred. AWS resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and
/// provide recommendations to improve your operational solutions.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTimeRange {
    /// <p>
    /// The time when the event started.
    /// </p>
    pub from_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time when the event ended.
    /// </p>
    pub to_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for EventTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTimeRange");
        formatter.field("from_time", &self.from_time);
        formatter.field("to_time", &self.to_time);
        formatter.finish()
    }
}
/// See [`EventTimeRange`](crate::model::EventTimeRange)
pub mod event_time_range {
    /// A builder for [`EventTimeRange`](crate::model::EventTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) to_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The time when the event started.
        /// </p>
        pub fn from_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.from_time = Some(input);
            self
        }
        /// <p>
        /// The time when the event started.
        /// </p>
        pub fn set_from_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.from_time = input;
            self
        }
        /// <p>
        /// The time when the event ended.
        /// </p>
        pub fn to_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.to_time = Some(input);
            self
        }
        /// <p>
        /// The time when the event ended.
        /// </p>
        pub fn set_to_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.to_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTimeRange`](crate::model::EventTimeRange)
        pub fn build(self) -> crate::model::EventTimeRange {
            crate::model::EventTimeRange {
                from_time: self.from_time,
                to_time: self.to_time,
            }
        }
    }
}
impl EventTimeRange {
    /// Creates a new builder-style object to manufacture [`EventTimeRange`](crate::model::EventTimeRange)
    pub fn builder() -> crate::model::event_time_range::Builder {
        crate::model::event_time_range::Builder::default()
    }
}

/// <p>Details about a reactive anomaly. This object is returned by
/// <code>DescribeAnomaly.</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveAnomalySummary {
    /// <p>
    /// The ID of the reactive anomaly.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// The severity of the reactive anomaly.      
    /// </p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p>
    /// The status of the reactive anomaly.
    /// </p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p>
    /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
    /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
    /// an anomaly.
    /// </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p>
    /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
    /// </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p>
    /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
    /// </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p>
    /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
    /// </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
}
impl std::fmt::Debug for ReactiveAnomalySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveAnomalySummary");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.finish()
    }
}
/// See [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
pub mod reactive_anomaly_summary {
    /// A builder for [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
    }
    impl Builder {
        /// <p>
        /// The ID of the reactive anomaly.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the reactive anomaly.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// The severity of the reactive anomaly.      
        /// </p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>
        /// The severity of the reactive anomaly.      
        /// </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>
        /// The status of the reactive anomaly.
        /// </p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of the reactive anomaly.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
        pub fn build(self) -> crate::model::ReactiveAnomalySummary {
            crate::model::ReactiveAnomalySummary {
                id: self.id,
                severity: self.severity,
                status: self.status,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
            }
        }
    }
}
impl ReactiveAnomalySummary {
    /// Creates a new builder-style object to manufacture [`ReactiveAnomalySummary`](crate::model::ReactiveAnomalySummary)
    pub fn builder() -> crate::model::reactive_anomaly_summary::Builder {
        crate::model::reactive_anomaly_summary::Builder::default()
    }
}

/// <p> Details about the source of the anomalous operational data that triggered the anomaly. The
/// one supported source is Amazon CloudWatch metrics. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalySourceDetails {
    /// <p> An array of <code>CloudWatchMetricsDetail</code> object that contains information
    /// about the analyzed metrics that displayed anomalous behavior. </p>
    pub cloud_watch_metrics:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDetail>>,
}
impl std::fmt::Debug for AnomalySourceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalySourceDetails");
        formatter.field("cloud_watch_metrics", &self.cloud_watch_metrics);
        formatter.finish()
    }
}
/// See [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
pub mod anomaly_source_details {
    /// A builder for [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_metrics:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDetail>>,
    }
    impl Builder {
        /// Appends an item to `cloud_watch_metrics`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_metrics`](Self::set_cloud_watch_metrics).
        ///
        /// <p> An array of <code>CloudWatchMetricsDetail</code> object that contains information
        /// about the analyzed metrics that displayed anomalous behavior. </p>
        pub fn cloud_watch_metrics(
            mut self,
            input: impl Into<crate::model::CloudWatchMetricsDetail>,
        ) -> Self {
            let mut v = self.cloud_watch_metrics.unwrap_or_default();
            v.push(input.into());
            self.cloud_watch_metrics = Some(v);
            self
        }
        /// <p> An array of <code>CloudWatchMetricsDetail</code> object that contains information
        /// about the analyzed metrics that displayed anomalous behavior. </p>
        pub fn set_cloud_watch_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDetail>>,
        ) -> Self {
            self.cloud_watch_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
        pub fn build(self) -> crate::model::AnomalySourceDetails {
            crate::model::AnomalySourceDetails {
                cloud_watch_metrics: self.cloud_watch_metrics,
            }
        }
    }
}
impl AnomalySourceDetails {
    /// Creates a new builder-style object to manufacture [`AnomalySourceDetails`](crate::model::AnomalySourceDetails)
    pub fn builder() -> crate::model::anomaly_source_details::Builder {
        crate::model::anomaly_source_details::Builder::default()
    }
}

/// <p>
/// Information about an Amazon CloudWatch metric.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMetricsDetail {
    /// <p>
    /// The name of the CloudWatch metric.
    /// </p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>
    /// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
    /// </p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// An array of CloudWatch dimensions associated with
    /// </p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDimension>>,
    /// <p>
    /// The type of statistic associated with the CloudWatch metric. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the
    /// <i>Amazon CloudWatch User Guide</i>.
    /// </p>
    pub stat: std::option::Option<crate::model::CloudWatchMetricsStat>,
    /// <p>
    /// The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>,
    /// <code>Count</code>, and <code>Percent</code>.
    /// </p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>
    /// The length of time associated with the CloudWatch metric in number of seconds.
    /// </p>
    pub period: i32,
}
impl std::fmt::Debug for CloudWatchMetricsDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMetricsDetail");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("stat", &self.stat);
        formatter.field("unit", &self.unit);
        formatter.field("period", &self.period);
        formatter.finish()
    }
}
/// See [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
pub mod cloud_watch_metrics_detail {
    /// A builder for [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) dimensions:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDimension>>,
        pub(crate) stat: std::option::Option<crate::model::CloudWatchMetricsStat>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>
        /// The name of the CloudWatch metric.
        /// </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the CloudWatch metric.
        /// </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>
        /// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
        /// </p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
        /// </p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>
        /// An array of CloudWatch dimensions associated with
        /// </p>
        pub fn dimensions(
            mut self,
            input: impl Into<crate::model::CloudWatchMetricsDimension>,
        ) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>
        /// An array of CloudWatch dimensions associated with
        /// </p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchMetricsDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>
        /// The type of statistic associated with the CloudWatch metric. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the
        /// <i>Amazon CloudWatch User Guide</i>.
        /// </p>
        pub fn stat(mut self, input: crate::model::CloudWatchMetricsStat) -> Self {
            self.stat = Some(input);
            self
        }
        /// <p>
        /// The type of statistic associated with the CloudWatch metric. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the
        /// <i>Amazon CloudWatch User Guide</i>.
        /// </p>
        pub fn set_stat(
            mut self,
            input: std::option::Option<crate::model::CloudWatchMetricsStat>,
        ) -> Self {
            self.stat = input;
            self
        }
        /// <p>
        /// The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>,
        /// <code>Count</code>, and <code>Percent</code>.
        /// </p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>
        /// The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>,
        /// <code>Count</code>, and <code>Percent</code>.
        /// </p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>
        /// The length of time associated with the CloudWatch metric in number of seconds.
        /// </p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>
        /// The length of time associated with the CloudWatch metric in number of seconds.
        /// </p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
        pub fn build(self) -> crate::model::CloudWatchMetricsDetail {
            crate::model::CloudWatchMetricsDetail {
                metric_name: self.metric_name,
                namespace: self.namespace,
                dimensions: self.dimensions,
                stat: self.stat,
                unit: self.unit,
                period: self.period.unwrap_or_default(),
            }
        }
    }
}
impl CloudWatchMetricsDetail {
    /// Creates a new builder-style object to manufacture [`CloudWatchMetricsDetail`](crate::model::CloudWatchMetricsDetail)
    pub fn builder() -> crate::model::cloud_watch_metrics_detail::Builder {
        crate::model::cloud_watch_metrics_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchMetricsStat {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    #[allow(missing_docs)] // documentation missing in model
    P50,
    #[allow(missing_docs)] // documentation missing in model
    P90,
    #[allow(missing_docs)] // documentation missing in model
    P99,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchMetricsStat {
    fn from(s: &str) -> Self {
        match s {
            "Average" => CloudWatchMetricsStat::Average,
            "Maximum" => CloudWatchMetricsStat::Maximum,
            "Minimum" => CloudWatchMetricsStat::Minimum,
            "SampleCount" => CloudWatchMetricsStat::SampleCount,
            "Sum" => CloudWatchMetricsStat::Sum,
            "p50" => CloudWatchMetricsStat::P50,
            "p90" => CloudWatchMetricsStat::P90,
            "p99" => CloudWatchMetricsStat::P99,
            other => CloudWatchMetricsStat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchMetricsStat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchMetricsStat::from(s))
    }
}
impl CloudWatchMetricsStat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchMetricsStat::Average => "Average",
            CloudWatchMetricsStat::Maximum => "Maximum",
            CloudWatchMetricsStat::Minimum => "Minimum",
            CloudWatchMetricsStat::SampleCount => "SampleCount",
            CloudWatchMetricsStat::Sum => "Sum",
            CloudWatchMetricsStat::P50 => "p50",
            CloudWatchMetricsStat::P90 => "p90",
            CloudWatchMetricsStat::P99 => "p99",
            CloudWatchMetricsStat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Average",
            "Maximum",
            "Minimum",
            "SampleCount",
            "Sum",
            "p50",
            "p90",
            "p99",
        ]
    }
}
impl AsRef<str> for CloudWatchMetricsStat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The dimension of a Amazon CloudWatch metric that is used when DevOps Guru analyzes the resources in your
/// account for operational problems and anomalous behavior. A dimension is a name/value pair
/// that is part of the identity of a metric. A metric can have up to 10 dimensions. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> in the <i>Amazon CloudWatch User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMetricsDimension {
    /// <p>
    /// The name of the CloudWatch dimension.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The value of the CloudWatch dimension.
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchMetricsDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMetricsDimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
pub mod cloud_watch_metrics_dimension {
    /// A builder for [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the CloudWatch dimension.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the CloudWatch dimension.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The value of the CloudWatch dimension.
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>
        /// The value of the CloudWatch dimension.
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
        pub fn build(self) -> crate::model::CloudWatchMetricsDimension {
            crate::model::CloudWatchMetricsDimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl CloudWatchMetricsDimension {
    /// Creates a new builder-style object to manufacture [`CloudWatchMetricsDimension`](crate::model::CloudWatchMetricsDimension)
    pub fn builder() -> crate::model::cloud_watch_metrics_dimension::Builder {
        crate::model::cloud_watch_metrics_dimension::Builder::default()
    }
}

/// <p>
/// A time range that specifies when DevOps Guru opens and then closes an anomaly. This is different from
/// <code>AnomalyTimeRange</code>, which specifies the time range when DevOps Guru actually observes
/// the anomalous behavior.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyReportedTimeRange {
    /// <p>
    /// The time when an anomaly is opened.
    /// </p>
    pub open_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The time when an anomaly is closed.
    /// </p>
    pub close_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AnomalyReportedTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyReportedTimeRange");
        formatter.field("open_time", &self.open_time);
        formatter.field("close_time", &self.close_time);
        formatter.finish()
    }
}
/// See [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
pub mod anomaly_reported_time_range {
    /// A builder for [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) close_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The time when an anomaly is opened.
        /// </p>
        pub fn open_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.open_time = Some(input);
            self
        }
        /// <p>
        /// The time when an anomaly is opened.
        /// </p>
        pub fn set_open_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.open_time = input;
            self
        }
        /// <p>
        /// The time when an anomaly is closed.
        /// </p>
        pub fn close_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.close_time = Some(input);
            self
        }
        /// <p>
        /// The time when an anomaly is closed.
        /// </p>
        pub fn set_close_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.close_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
        pub fn build(self) -> crate::model::AnomalyReportedTimeRange {
            crate::model::AnomalyReportedTimeRange {
                open_time: self.open_time,
                close_time: self.close_time,
            }
        }
    }
}
impl AnomalyReportedTimeRange {
    /// Creates a new builder-style object to manufacture [`AnomalyReportedTimeRange`](crate::model::AnomalyReportedTimeRange)
    pub fn builder() -> crate::model::anomaly_reported_time_range::Builder {
        crate::model::anomaly_reported_time_range::Builder::default()
    }
}

/// <p>
/// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
/// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
/// an anomaly.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyTimeRange {
    /// <p>
    /// The time when the anomalous behavior started.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The time when the anomalous behavior ended. </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AnomalyTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
pub mod anomaly_time_range {
    /// A builder for [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The time when the anomalous behavior started.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The time when the anomalous behavior started.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The time when the anomalous behavior ended. </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p> The time when the anomalous behavior ended. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
        pub fn build(self) -> crate::model::AnomalyTimeRange {
            crate::model::AnomalyTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl AnomalyTimeRange {
    /// Creates a new builder-style object to manufacture [`AnomalyTimeRange`](crate::model::AnomalyTimeRange)
    pub fn builder() -> crate::model::anomaly_time_range::Builder {
        crate::model::anomaly_time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyStatus {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyStatus {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => AnomalyStatus::Closed,
            "ONGOING" => AnomalyStatus::Ongoing,
            other => AnomalyStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyStatus::from(s))
    }
}
impl AnomalyStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyStatus::Closed => "CLOSED",
            AnomalyStatus::Ongoing => "ONGOING",
            AnomalyStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "ONGOING"]
    }
}
impl AsRef<str> for AnomalyStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalySeverity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalySeverity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => AnomalySeverity::High,
            "LOW" => AnomalySeverity::Low,
            "MEDIUM" => AnomalySeverity::Medium,
            other => AnomalySeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalySeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalySeverity::from(s))
    }
}
impl AnomalySeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalySeverity::High => "HIGH",
            AnomalySeverity::Low => "LOW",
            AnomalySeverity::Medium => "MEDIUM",
            AnomalySeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for AnomalySeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a proactive anomaly. This object is returned by
/// <code>DescribeAnomaly.</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveAnomalySummary {
    /// <p>The ID of the anomaly.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The severity of the anomaly.</p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p>The status of the anomaly.</p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p>
    /// The time of the anomaly's most recent update.
    /// </p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
    /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
    /// an anomaly.
    /// </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p>
    /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
    /// </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p>
    /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
    /// </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p>
    /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
    /// </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p>
    /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
    /// </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>
    /// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
    /// threshold is related to the anomalous behavior that generated this anomaly.
    /// </p>
    pub limit: std::option::Option<f64>,
}
impl std::fmt::Debug for ProactiveAnomalySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveAnomalySummary");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
/// See [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
pub mod proactive_anomaly_summary {
    /// A builder for [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) limit: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The ID of the anomaly.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The severity of the anomaly.</p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the anomaly.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the anomaly.</p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the anomaly.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// The time of the anomaly's most recent update.
        /// </p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>
        /// The time of the anomaly's most recent update.
        /// </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>
        /// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
        /// threshold is related to the anomalous behavior that generated this anomaly.
        /// </p>
        pub fn limit(mut self, input: f64) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>
        /// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
        /// threshold is related to the anomalous behavior that generated this anomaly.
        /// </p>
        pub fn set_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
        pub fn build(self) -> crate::model::ProactiveAnomalySummary {
            crate::model::ProactiveAnomalySummary {
                id: self.id,
                severity: self.severity,
                status: self.status,
                update_time: self.update_time,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                prediction_time_range: self.prediction_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
                limit: self.limit,
            }
        }
    }
}
impl ProactiveAnomalySummary {
    /// Creates a new builder-style object to manufacture [`ProactiveAnomalySummary`](crate::model::ProactiveAnomalySummary)
    pub fn builder() -> crate::model::proactive_anomaly_summary::Builder {
        crate::model::proactive_anomaly_summary::Builder::default()
    }
}

/// <p>
/// Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCollectionFilter {
    /// <p>
    /// Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a>
    /// in the <i>AWS CloudFormation User Guide</i>.
    /// </p>
    pub cloud_formation: std::option::Option<crate::model::CloudFormationCollectionFilter>,
}
impl std::fmt::Debug for ResourceCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCollectionFilter");
        formatter.field("cloud_formation", &self.cloud_formation);
        formatter.finish()
    }
}
/// See [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
pub mod resource_collection_filter {
    /// A builder for [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_formation:
            std::option::Option<crate::model::CloudFormationCollectionFilter>,
    }
    impl Builder {
        /// <p>
        /// Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a>
        /// in the <i>AWS CloudFormation User Guide</i>.
        /// </p>
        pub fn cloud_formation(
            mut self,
            input: crate::model::CloudFormationCollectionFilter,
        ) -> Self {
            self.cloud_formation = Some(input);
            self
        }
        /// <p>
        /// Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a>
        /// in the <i>AWS CloudFormation User Guide</i>.
        /// </p>
        pub fn set_cloud_formation(
            mut self,
            input: std::option::Option<crate::model::CloudFormationCollectionFilter>,
        ) -> Self {
            self.cloud_formation = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
        pub fn build(self) -> crate::model::ResourceCollectionFilter {
            crate::model::ResourceCollectionFilter {
                cloud_formation: self.cloud_formation,
            }
        }
    }
}
impl ResourceCollectionFilter {
    /// Creates a new builder-style object to manufacture [`ResourceCollectionFilter`](crate::model::ResourceCollectionFilter)
    pub fn builder() -> crate::model::resource_collection_filter::Builder {
        crate::model::resource_collection_filter::Builder::default()
    }
}

/// <p>
/// Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze.
/// For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a>
/// in the <i>AWS CloudFormation User Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationCollectionFilter {
    /// <p>
    /// An array of CloudFormation stack names.
    /// </p>
    pub stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CloudFormationCollectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationCollectionFilter");
        formatter.field("stack_names", &self.stack_names);
        formatter.finish()
    }
}
/// See [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
pub mod cloud_formation_collection_filter {
    /// A builder for [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `stack_names`.
        ///
        /// To override the contents of this collection use [`set_stack_names`](Self::set_stack_names).
        ///
        /// <p>
        /// An array of CloudFormation stack names.
        /// </p>
        pub fn stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stack_names.unwrap_or_default();
            v.push(input.into());
            self.stack_names = Some(v);
            self
        }
        /// <p>
        /// An array of CloudFormation stack names.
        /// </p>
        pub fn set_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stack_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
        pub fn build(self) -> crate::model::CloudFormationCollectionFilter {
            crate::model::CloudFormationCollectionFilter {
                stack_names: self.stack_names,
            }
        }
    }
}
impl CloudFormationCollectionFilter {
    /// Creates a new builder-style object to manufacture [`CloudFormationCollectionFilter`](crate::model::CloudFormationCollectionFilter)
    pub fn builder() -> crate::model::cloud_formation_collection_filter::Builder {
        crate::model::cloud_formation_collection_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceCollectionType {
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudFormation,
    #[allow(missing_docs)] // documentation missing in model
    AwsService,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceCollectionType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_CLOUD_FORMATION" => ResourceCollectionType::AwsCloudFormation,
            "AWS_SERVICE" => ResourceCollectionType::AwsService,
            other => ResourceCollectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceCollectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceCollectionType::from(s))
    }
}
impl ResourceCollectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceCollectionType::AwsCloudFormation => "AWS_CLOUD_FORMATION",
            ResourceCollectionType::AwsService => "AWS_SERVICE",
            ResourceCollectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_CLOUD_FORMATION", "AWS_SERVICE"]
    }
}
impl AsRef<str> for ResourceCollectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The time range of a cost estimation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostEstimationTimeRange {
    /// <p>The start time of the cost estimation.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time of the cost estimation.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for CostEstimationTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostEstimationTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
pub mod cost_estimation_time_range {
    /// A builder for [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The start time of the cost estimation.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the cost estimation.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the cost estimation.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the cost estimation.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
        pub fn build(self) -> crate::model::CostEstimationTimeRange {
            crate::model::CostEstimationTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl CostEstimationTimeRange {
    /// Creates a new builder-style object to manufacture [`CostEstimationTimeRange`](crate::model::CostEstimationTimeRange)
    pub fn builder() -> crate::model::cost_estimation_time_range::Builder {
        crate::model::cost_estimation_time_range::Builder::default()
    }
}

/// <p>An object that contains information about the estimated monthly cost to
/// analyze an AWS resource. For more information,
/// see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
/// Amazon DevOps Guru costs</a> and
/// <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceResourceCost {
    /// <p>The type of the AWS resource.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics,
    /// events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for
    /// the number of active AWS resource hours analyzed for each resource. Inactive resources are
    /// not charged.
    /// </p>
    pub state: std::option::Option<crate::model::CostEstimationServiceResourceState>,
    /// <p>The number of active resources analyzed for this service to create a monthly cost
    /// estimate.</p>
    pub count: i32,
    /// <p>The price per hour to analyze the resources in the service.
    /// For more information,
    /// see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
    /// Amazon DevOps Guru costs</a> and
    /// <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
    pub unit_cost: f64,
    /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
    pub cost: f64,
}
impl std::fmt::Debug for ServiceResourceCost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceResourceCost");
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("count", &self.count);
        formatter.field("unit_cost", &self.unit_cost);
        formatter.field("cost", &self.cost);
        formatter.finish()
    }
}
/// See [`ServiceResourceCost`](crate::model::ServiceResourceCost)
pub mod service_resource_cost {
    /// A builder for [`ServiceResourceCost`](crate::model::ServiceResourceCost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::CostEstimationServiceResourceState>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) unit_cost: std::option::Option<f64>,
        pub(crate) cost: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The type of the AWS resource.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the AWS resource.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics,
        /// events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for
        /// the number of active AWS resource hours analyzed for each resource. Inactive resources are
        /// not charged.
        /// </p>
        pub fn state(mut self, input: crate::model::CostEstimationServiceResourceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics,
        /// events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for
        /// the number of active AWS resource hours analyzed for each resource. Inactive resources are
        /// not charged.
        /// </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CostEstimationServiceResourceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The number of active resources analyzed for this service to create a monthly cost
        /// estimate.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of active resources analyzed for this service to create a monthly cost
        /// estimate.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The price per hour to analyze the resources in the service.
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
        /// Amazon DevOps Guru costs</a> and
        /// <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
        pub fn unit_cost(mut self, input: f64) -> Self {
            self.unit_cost = Some(input);
            self
        }
        /// <p>The price per hour to analyze the resources in the service.
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your
        /// Amazon DevOps Guru costs</a> and
        /// <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>
        pub fn set_unit_cost(mut self, input: std::option::Option<f64>) -> Self {
            self.unit_cost = input;
            self
        }
        /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
        pub fn cost(mut self, input: f64) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The total estimated monthly cost to analyze the active resources for this resource.</p>
        pub fn set_cost(mut self, input: std::option::Option<f64>) -> Self {
            self.cost = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceResourceCost`](crate::model::ServiceResourceCost)
        pub fn build(self) -> crate::model::ServiceResourceCost {
            crate::model::ServiceResourceCost {
                r#type: self.r#type,
                state: self.state,
                count: self.count.unwrap_or_default(),
                unit_cost: self.unit_cost.unwrap_or_default(),
                cost: self.cost.unwrap_or_default(),
            }
        }
    }
}
impl ServiceResourceCost {
    /// Creates a new builder-style object to manufacture [`ServiceResourceCost`](crate::model::ServiceResourceCost)
    pub fn builder() -> crate::model::service_resource_cost::Builder {
        crate::model::service_resource_cost::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostEstimationServiceResourceState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostEstimationServiceResourceState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CostEstimationServiceResourceState::Active,
            "INACTIVE" => CostEstimationServiceResourceState::Inactive,
            other => CostEstimationServiceResourceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostEstimationServiceResourceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostEstimationServiceResourceState::from(s))
    }
}
impl CostEstimationServiceResourceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostEstimationServiceResourceState::Active => "ACTIVE",
            CostEstimationServiceResourceState::Inactive => "INACTIVE",
            CostEstimationServiceResourceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for CostEstimationServiceResourceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostEstimationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostEstimationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => CostEstimationStatus::Completed,
            "ONGOING" => CostEstimationStatus::Ongoing,
            other => CostEstimationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostEstimationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostEstimationStatus::from(s))
    }
}
impl CostEstimationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostEstimationStatus::Completed => "COMPLETED",
            CostEstimationStatus::Ongoing => "ONGOING",
            CostEstimationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "ONGOING"]
    }
}
impl AsRef<str> for CostEstimationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about the integration of DevOps Guru with another AWS service, such as AWS Systems Manager.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceIntegrationConfig {
    /// <p>
    /// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
    /// </p>
    pub ops_center: std::option::Option<crate::model::OpsCenterIntegration>,
}
impl std::fmt::Debug for ServiceIntegrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceIntegrationConfig");
        formatter.field("ops_center", &self.ops_center);
        formatter.finish()
    }
}
/// See [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
pub mod service_integration_config {
    /// A builder for [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_center: std::option::Option<crate::model::OpsCenterIntegration>,
    }
    impl Builder {
        /// <p>
        /// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
        /// </p>
        pub fn ops_center(mut self, input: crate::model::OpsCenterIntegration) -> Self {
            self.ops_center = Some(input);
            self
        }
        /// <p>
        /// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
        /// </p>
        pub fn set_ops_center(
            mut self,
            input: std::option::Option<crate::model::OpsCenterIntegration>,
        ) -> Self {
            self.ops_center = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
        pub fn build(self) -> crate::model::ServiceIntegrationConfig {
            crate::model::ServiceIntegrationConfig {
                ops_center: self.ops_center,
            }
        }
    }
}
impl ServiceIntegrationConfig {
    /// Creates a new builder-style object to manufacture [`ServiceIntegrationConfig`](crate::model::ServiceIntegrationConfig)
    pub fn builder() -> crate::model::service_integration_config::Builder {
        crate::model::service_integration_config::Builder::default()
    }
}

/// <p>
/// Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsCenterIntegration {
    /// <p>
    /// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
    /// </p>
    pub opt_in_status: std::option::Option<crate::model::OptInStatus>,
}
impl std::fmt::Debug for OpsCenterIntegration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsCenterIntegration");
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.finish()
    }
}
/// See [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
pub mod ops_center_integration {
    /// A builder for [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) opt_in_status: std::option::Option<crate::model::OptInStatus>,
    }
    impl Builder {
        /// <p>
        /// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
        /// </p>
        pub fn opt_in_status(mut self, input: crate::model::OptInStatus) -> Self {
            self.opt_in_status = Some(input);
            self
        }
        /// <p>
        /// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight.
        /// </p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<crate::model::OptInStatus>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
        pub fn build(self) -> crate::model::OpsCenterIntegration {
            crate::model::OpsCenterIntegration {
                opt_in_status: self.opt_in_status,
            }
        }
    }
}
impl OpsCenterIntegration {
    /// Creates a new builder-style object to manufacture [`OpsCenterIntegration`](crate::model::OpsCenterIntegration)
    pub fn builder() -> crate::model::ops_center_integration::Builder {
        crate::model::ops_center_integration::Builder::default()
    }
}

/// <p>Represents the health of an AWS service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceHealth {
    /// <p>The name of the AWS service.</p>
    pub service_name: std::option::Option<crate::model::ServiceName>,
    /// <p>Represents the health of an AWS service. This is a <code>ServiceInsightHealth</code> that
    /// contains the number of open proactive and reactive insights for this service.</p>
    pub insight: std::option::Option<crate::model::ServiceInsightHealth>,
}
impl std::fmt::Debug for ServiceHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceHealth");
        formatter.field("service_name", &self.service_name);
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`ServiceHealth`](crate::model::ServiceHealth)
pub mod service_health {
    /// A builder for [`ServiceHealth`](crate::model::ServiceHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<crate::model::ServiceName>,
        pub(crate) insight: std::option::Option<crate::model::ServiceInsightHealth>,
    }
    impl Builder {
        /// <p>The name of the AWS service.</p>
        pub fn service_name(mut self, input: crate::model::ServiceName) -> Self {
            self.service_name = Some(input);
            self
        }
        /// <p>The name of the AWS service.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::ServiceName>,
        ) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Represents the health of an AWS service. This is a <code>ServiceInsightHealth</code> that
        /// contains the number of open proactive and reactive insights for this service.</p>
        pub fn insight(mut self, input: crate::model::ServiceInsightHealth) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p>Represents the health of an AWS service. This is a <code>ServiceInsightHealth</code> that
        /// contains the number of open proactive and reactive insights for this service.</p>
        pub fn set_insight(
            mut self,
            input: std::option::Option<crate::model::ServiceInsightHealth>,
        ) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceHealth`](crate::model::ServiceHealth)
        pub fn build(self) -> crate::model::ServiceHealth {
            crate::model::ServiceHealth {
                service_name: self.service_name,
                insight: self.insight,
            }
        }
    }
}
impl ServiceHealth {
    /// Creates a new builder-style object to manufacture [`ServiceHealth`](crate::model::ServiceHealth)
    pub fn builder() -> crate::model::service_health::Builder {
        crate::model::service_health::Builder::default()
    }
}

/// <p>Contains the number of open proactive and reactive insights in an analyzed AWS service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceInsightHealth {
    /// <p>The number of open proactive insights in the AWS service</p>
    pub open_proactive_insights: i32,
    /// <p>The number of open reactive insights in the AWS service</p>
    pub open_reactive_insights: i32,
}
impl std::fmt::Debug for ServiceInsightHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceInsightHealth");
        formatter.field("open_proactive_insights", &self.open_proactive_insights);
        formatter.field("open_reactive_insights", &self.open_reactive_insights);
        formatter.finish()
    }
}
/// See [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
pub mod service_insight_health {
    /// A builder for [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_proactive_insights: std::option::Option<i32>,
        pub(crate) open_reactive_insights: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of open proactive insights in the AWS service</p>
        pub fn open_proactive_insights(mut self, input: i32) -> Self {
            self.open_proactive_insights = Some(input);
            self
        }
        /// <p>The number of open proactive insights in the AWS service</p>
        pub fn set_open_proactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_proactive_insights = input;
            self
        }
        /// <p>The number of open reactive insights in the AWS service</p>
        pub fn open_reactive_insights(mut self, input: i32) -> Self {
            self.open_reactive_insights = Some(input);
            self
        }
        /// <p>The number of open reactive insights in the AWS service</p>
        pub fn set_open_reactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_reactive_insights = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
        pub fn build(self) -> crate::model::ServiceInsightHealth {
            crate::model::ServiceInsightHealth {
                open_proactive_insights: self.open_proactive_insights.unwrap_or_default(),
                open_reactive_insights: self.open_reactive_insights.unwrap_or_default(),
            }
        }
    }
}
impl ServiceInsightHealth {
    /// Creates a new builder-style object to manufacture [`ServiceInsightHealth`](crate::model::ServiceInsightHealth)
    pub fn builder() -> crate::model::service_insight_health::Builder {
        crate::model::service_insight_health::Builder::default()
    }
}

/// <p>
/// Information about the health of AWS resources in your account that are specified by an AWS CloudFormation stack.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationHealth {
    /// <p>
    /// The name of the CloudFormation stack.
    /// </p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>
    /// Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation stack, including
    /// the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
    /// </p>
    pub insight: std::option::Option<crate::model::InsightHealth>,
}
impl std::fmt::Debug for CloudFormationHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationHealth");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("insight", &self.insight);
        formatter.finish()
    }
}
/// See [`CloudFormationHealth`](crate::model::CloudFormationHealth)
pub mod cloud_formation_health {
    /// A builder for [`CloudFormationHealth`](crate::model::CloudFormationHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) insight: std::option::Option<crate::model::InsightHealth>,
    }
    impl Builder {
        /// <p>
        /// The name of the CloudFormation stack.
        /// </p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the CloudFormation stack.
        /// </p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>
        /// Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation stack, including
        /// the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
        /// </p>
        pub fn insight(mut self, input: crate::model::InsightHealth) -> Self {
            self.insight = Some(input);
            self
        }
        /// <p>
        /// Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation stack, including
        /// the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
        /// </p>
        pub fn set_insight(
            mut self,
            input: std::option::Option<crate::model::InsightHealth>,
        ) -> Self {
            self.insight = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationHealth`](crate::model::CloudFormationHealth)
        pub fn build(self) -> crate::model::CloudFormationHealth {
            crate::model::CloudFormationHealth {
                stack_name: self.stack_name,
                insight: self.insight,
            }
        }
    }
}
impl CloudFormationHealth {
    /// Creates a new builder-style object to manufacture [`CloudFormationHealth`](crate::model::CloudFormationHealth)
    pub fn builder() -> crate::model::cloud_formation_health::Builder {
        crate::model::cloud_formation_health::Builder::default()
    }
}

/// <p>
/// Information about the number of open reactive and proactive insights that can be
/// used to gauge the health of your system.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightHealth {
    /// <p>
    /// The number of open proactive insights.
    /// </p>
    pub open_proactive_insights: i32,
    /// <p>
    /// The number of open reactive insights.
    /// </p>
    pub open_reactive_insights: i32,
    /// <p>
    /// The Meant Time to Recover (MTTR) for the insight.  
    /// </p>
    pub mean_time_to_recover_in_milliseconds: std::option::Option<i64>,
}
impl std::fmt::Debug for InsightHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightHealth");
        formatter.field("open_proactive_insights", &self.open_proactive_insights);
        formatter.field("open_reactive_insights", &self.open_reactive_insights);
        formatter.field(
            "mean_time_to_recover_in_milliseconds",
            &self.mean_time_to_recover_in_milliseconds,
        );
        formatter.finish()
    }
}
/// See [`InsightHealth`](crate::model::InsightHealth)
pub mod insight_health {
    /// A builder for [`InsightHealth`](crate::model::InsightHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_proactive_insights: std::option::Option<i32>,
        pub(crate) open_reactive_insights: std::option::Option<i32>,
        pub(crate) mean_time_to_recover_in_milliseconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>
        /// The number of open proactive insights.
        /// </p>
        pub fn open_proactive_insights(mut self, input: i32) -> Self {
            self.open_proactive_insights = Some(input);
            self
        }
        /// <p>
        /// The number of open proactive insights.
        /// </p>
        pub fn set_open_proactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_proactive_insights = input;
            self
        }
        /// <p>
        /// The number of open reactive insights.
        /// </p>
        pub fn open_reactive_insights(mut self, input: i32) -> Self {
            self.open_reactive_insights = Some(input);
            self
        }
        /// <p>
        /// The number of open reactive insights.
        /// </p>
        pub fn set_open_reactive_insights(mut self, input: std::option::Option<i32>) -> Self {
            self.open_reactive_insights = input;
            self
        }
        /// <p>
        /// The Meant Time to Recover (MTTR) for the insight.  
        /// </p>
        pub fn mean_time_to_recover_in_milliseconds(mut self, input: i64) -> Self {
            self.mean_time_to_recover_in_milliseconds = Some(input);
            self
        }
        /// <p>
        /// The Meant Time to Recover (MTTR) for the insight.  
        /// </p>
        pub fn set_mean_time_to_recover_in_milliseconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.mean_time_to_recover_in_milliseconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightHealth`](crate::model::InsightHealth)
        pub fn build(self) -> crate::model::InsightHealth {
            crate::model::InsightHealth {
                open_proactive_insights: self.open_proactive_insights.unwrap_or_default(),
                open_reactive_insights: self.open_reactive_insights.unwrap_or_default(),
                mean_time_to_recover_in_milliseconds: self.mean_time_to_recover_in_milliseconds,
            }
        }
    }
}
impl InsightHealth {
    /// Creates a new builder-style object to manufacture [`InsightHealth`](crate::model::InsightHealth)
    pub fn builder() -> crate::model::insight_health::Builder {
        crate::model::insight_health::Builder::default()
    }
}

/// <p>
/// Information about a reactive insight. This object is returned by <code>ListInsights</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveInsight {
    /// <p>
    /// The ID of a reactive insight.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// The name of a reactive insight.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The severity of a reactive insight.
    /// </p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p>
    /// The status of a reactive insight.
    /// </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and
    /// ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>
    /// The ID of the AWS System Manager OpsItem created for this insight. You must enable
    /// the creation of OpstItems insights before they are created for each insight.
    /// </p>
    pub ssm_ops_item_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReactiveInsight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveInsight");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("ssm_ops_item_id", &self.ssm_ops_item_id);
        formatter.finish()
    }
}
/// See [`ReactiveInsight`](crate::model::ReactiveInsight)
pub mod reactive_insight {
    /// A builder for [`ReactiveInsight`](crate::model::ReactiveInsight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) ssm_ops_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ID of a reactive insight.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of a reactive insight.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// The name of a reactive insight.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of a reactive insight.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The severity of a reactive insight.
        /// </p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>
        /// The severity of a reactive insight.
        /// </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>
        /// The status of a reactive insight.
        /// </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of a reactive insight.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>
        /// The ID of the AWS System Manager OpsItem created for this insight. You must enable
        /// the creation of OpstItems insights before they are created for each insight.
        /// </p>
        pub fn ssm_ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssm_ops_item_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the AWS System Manager OpsItem created for this insight. You must enable
        /// the creation of OpstItems insights before they are created for each insight.
        /// </p>
        pub fn set_ssm_ops_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssm_ops_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveInsight`](crate::model::ReactiveInsight)
        pub fn build(self) -> crate::model::ReactiveInsight {
            crate::model::ReactiveInsight {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                resource_collection: self.resource_collection,
                ssm_ops_item_id: self.ssm_ops_item_id,
            }
        }
    }
}
impl ReactiveInsight {
    /// Creates a new builder-style object to manufacture [`ReactiveInsight`](crate::model::ReactiveInsight)
    pub fn builder() -> crate::model::reactive_insight::Builder {
        crate::model::reactive_insight::Builder::default()
    }
}

/// <p>Details about a proactive insight. This object is returned by <code>ListInsights</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveInsight {
    /// <p>The ID of the proactive insight. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the proactive insight. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The severity of the proactive insight. </p>
    pub severity: std::option::Option<crate::model::InsightSeverity>,
    /// <p>The status of the proactive insight. </p>
    pub status: std::option::Option<crate::model::InsightStatus>,
    /// <p> A time ranged that specifies when the observed behavior in an insight started and
    /// ended. </p>
    pub insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
    /// <p>
    /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
    /// </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>
    /// The ID of the AWS System Manager OpsItem created for this insight. You must enable
    /// the creation of OpstItems insights before they are created for each insight.
    /// </p>
    pub ssm_ops_item_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProactiveInsight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveInsight");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("insight_time_range", &self.insight_time_range);
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("ssm_ops_item_id", &self.ssm_ops_item_id);
        formatter.finish()
    }
}
/// See [`ProactiveInsight`](crate::model::ProactiveInsight)
pub mod proactive_insight {
    /// A builder for [`ProactiveInsight`](crate::model::ProactiveInsight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::InsightSeverity>,
        pub(crate) status: std::option::Option<crate::model::InsightStatus>,
        pub(crate) insight_time_range: std::option::Option<crate::model::InsightTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) ssm_ops_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the proactive insight. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the proactive insight. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the proactive insight. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The severity of the proactive insight. </p>
        pub fn severity(mut self, input: crate::model::InsightSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the proactive insight. </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::InsightSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn status(mut self, input: crate::model::InsightStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proactive insight. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InsightStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn insight_time_range(mut self, input: crate::model::InsightTimeRange) -> Self {
            self.insight_time_range = Some(input);
            self
        }
        /// <p> A time ranged that specifies when the observed behavior in an insight started and
        /// ended. </p>
        pub fn set_insight_time_range(
            mut self,
            input: std::option::Option<crate::model::InsightTimeRange>,
        ) -> Self {
            self.insight_time_range = input;
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>
        /// The ID of the AWS System Manager OpsItem created for this insight. You must enable
        /// the creation of OpstItems insights before they are created for each insight.
        /// </p>
        pub fn ssm_ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssm_ops_item_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the AWS System Manager OpsItem created for this insight. You must enable
        /// the creation of OpstItems insights before they are created for each insight.
        /// </p>
        pub fn set_ssm_ops_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssm_ops_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveInsight`](crate::model::ProactiveInsight)
        pub fn build(self) -> crate::model::ProactiveInsight {
            crate::model::ProactiveInsight {
                id: self.id,
                name: self.name,
                severity: self.severity,
                status: self.status,
                insight_time_range: self.insight_time_range,
                prediction_time_range: self.prediction_time_range,
                resource_collection: self.resource_collection,
                ssm_ops_item_id: self.ssm_ops_item_id,
            }
        }
    }
}
impl ProactiveInsight {
    /// Creates a new builder-style object to manufacture [`ProactiveInsight`](crate::model::ProactiveInsight)
    pub fn builder() -> crate::model::proactive_insight::Builder {
        crate::model::proactive_insight::Builder::default()
    }
}

/// <p>Details about a reactive anomaly.  This object is returned by <code>ListAnomalies</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactiveAnomaly {
    /// <p>The ID of the reactive anomaly. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The severity of the anomaly. </p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p>
    /// The status of the anomaly.
    /// </p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p>
    /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
    /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
    /// an anomaly.
    /// </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p>
    /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
    /// </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p>
    /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
    /// </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p>
    /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
    /// </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
}
impl std::fmt::Debug for ReactiveAnomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactiveAnomaly");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.finish()
    }
}
/// See [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
pub mod reactive_anomaly {
    /// A builder for [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
    }
    impl Builder {
        /// <p>The ID of the reactive anomaly. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the reactive anomaly. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The severity of the anomaly. </p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the anomaly. </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>
        /// The status of the anomaly.
        /// </p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of the anomaly.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
        pub fn build(self) -> crate::model::ReactiveAnomaly {
            crate::model::ReactiveAnomaly {
                id: self.id,
                severity: self.severity,
                status: self.status,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
            }
        }
    }
}
impl ReactiveAnomaly {
    /// Creates a new builder-style object to manufacture [`ReactiveAnomaly`](crate::model::ReactiveAnomaly)
    pub fn builder() -> crate::model::reactive_anomaly::Builder {
        crate::model::reactive_anomaly::Builder::default()
    }
}

/// <p>Information about an anomaly. This object is returned by <code>ListAnomalies</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProactiveAnomaly {
    /// <p>
    /// The ID of a proactive anomaly.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>
    /// The severity of a proactive anomaly.
    /// </p>
    pub severity: std::option::Option<crate::model::AnomalySeverity>,
    /// <p>
    /// The status of a proactive anomaly.
    /// </p>
    pub status: std::option::Option<crate::model::AnomalyStatus>,
    /// <p>
    /// The time of the anomaly's most recent update.
    /// </p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
    /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
    /// an anomaly.
    /// </p>
    pub anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
    /// <p>
    /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
    /// </p>
    pub anomaly_reported_time_range: std::option::Option<crate::model::AnomalyReportedTimeRange>,
    /// <p>
    /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
    /// </p>
    pub prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
    /// <p>
    /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
    /// </p>
    pub source_details: std::option::Option<crate::model::AnomalySourceDetails>,
    /// <p>
    /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
    /// </p>
    pub associated_insight_id: std::option::Option<std::string::String>,
    /// <p>
    /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
    /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
    /// </p>
    pub resource_collection: std::option::Option<crate::model::ResourceCollection>,
    /// <p>
    /// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
    /// threshold is related to the anomalous behavior that generated this anomaly.
    /// </p>
    pub limit: std::option::Option<f64>,
}
impl std::fmt::Debug for ProactiveAnomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProactiveAnomaly");
        formatter.field("id", &self.id);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("update_time", &self.update_time);
        formatter.field("anomaly_time_range", &self.anomaly_time_range);
        formatter.field(
            "anomaly_reported_time_range",
            &self.anomaly_reported_time_range,
        );
        formatter.field("prediction_time_range", &self.prediction_time_range);
        formatter.field("source_details", &self.source_details);
        formatter.field("associated_insight_id", &self.associated_insight_id);
        formatter.field("resource_collection", &self.resource_collection);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
/// See [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
pub mod proactive_anomaly {
    /// A builder for [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::AnomalySeverity>,
        pub(crate) status: std::option::Option<crate::model::AnomalyStatus>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) anomaly_time_range: std::option::Option<crate::model::AnomalyTimeRange>,
        pub(crate) anomaly_reported_time_range:
            std::option::Option<crate::model::AnomalyReportedTimeRange>,
        pub(crate) prediction_time_range: std::option::Option<crate::model::PredictionTimeRange>,
        pub(crate) source_details: std::option::Option<crate::model::AnomalySourceDetails>,
        pub(crate) associated_insight_id: std::option::Option<std::string::String>,
        pub(crate) resource_collection: std::option::Option<crate::model::ResourceCollection>,
        pub(crate) limit: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>
        /// The ID of a proactive anomaly.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of a proactive anomaly.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>
        /// The severity of a proactive anomaly.
        /// </p>
        pub fn severity(mut self, input: crate::model::AnomalySeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>
        /// The severity of a proactive anomaly.
        /// </p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AnomalySeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>
        /// The status of a proactive anomaly.
        /// </p>
        pub fn status(mut self, input: crate::model::AnomalyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of a proactive anomaly.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// The time of the anomaly's most recent update.
        /// </p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>
        /// The time of the anomaly's most recent update.
        /// </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn anomaly_time_range(mut self, input: crate::model::AnomalyTimeRange) -> Self {
            self.anomaly_time_range = Some(input);
            self
        }
        /// <p>
        /// A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from
        /// <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes
        /// an anomaly.
        /// </p>
        pub fn set_anomaly_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyTimeRange>,
        ) -> Self {
            self.anomaly_time_range = input;
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn anomaly_reported_time_range(
            mut self,
            input: crate::model::AnomalyReportedTimeRange,
        ) -> Self {
            self.anomaly_reported_time_range = Some(input);
            self
        }
        /// <p>
        /// A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed.
        /// </p>
        pub fn set_anomaly_reported_time_range(
            mut self,
            input: std::option::Option<crate::model::AnomalyReportedTimeRange>,
        ) -> Self {
            self.anomaly_reported_time_range = input;
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.prediction_time_range = Some(input);
            self
        }
        /// <p>
        /// The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
        /// </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.prediction_time_range = input;
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn source_details(mut self, input: crate::model::AnomalySourceDetails) -> Self {
            self.source_details = Some(input);
            self
        }
        /// <p>
        /// Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
        /// </p>
        pub fn set_source_details(
            mut self,
            input: std::option::Option<crate::model::AnomalySourceDetails>,
        ) -> Self {
            self.source_details = input;
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn associated_insight_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_insight_id = Some(input.into());
            self
        }
        /// <p>
        /// The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
        /// </p>
        pub fn set_associated_insight_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_insight_id = input;
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn resource_collection(mut self, input: crate::model::ResourceCollection) -> Self {
            self.resource_collection = Some(input);
            self
        }
        /// <p>
        /// A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze
        /// only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.
        /// </p>
        pub fn set_resource_collection(
            mut self,
            input: std::option::Option<crate::model::ResourceCollection>,
        ) -> Self {
            self.resource_collection = input;
            self
        }
        /// <p>
        /// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
        /// threshold is related to the anomalous behavior that generated this anomaly.
        /// </p>
        pub fn limit(mut self, input: f64) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>
        /// A threshold that was exceeded by behavior in analyzed resources. Exceeding this
        /// threshold is related to the anomalous behavior that generated this anomaly.
        /// </p>
        pub fn set_limit(mut self, input: std::option::Option<f64>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
        pub fn build(self) -> crate::model::ProactiveAnomaly {
            crate::model::ProactiveAnomaly {
                id: self.id,
                severity: self.severity,
                status: self.status,
                update_time: self.update_time,
                anomaly_time_range: self.anomaly_time_range,
                anomaly_reported_time_range: self.anomaly_reported_time_range,
                prediction_time_range: self.prediction_time_range,
                source_details: self.source_details,
                associated_insight_id: self.associated_insight_id,
                resource_collection: self.resource_collection,
                limit: self.limit,
            }
        }
    }
}
impl ProactiveAnomaly {
    /// Creates a new builder-style object to manufacture [`ProactiveAnomaly`](crate::model::ProactiveAnomaly)
    pub fn builder() -> crate::model::proactive_anomaly::Builder {
        crate::model::proactive_anomaly::Builder::default()
    }
}
