// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateDevicePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device_pool`](crate::client::Client::create_device_pool).
///
/// See [`crate::client::fluent_builders::CreateDevicePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDevicePool {
    _private: (),
}
impl CreateDevicePool {
    /// Creates a new builder-style object to manufacture [`CreateDevicePoolInput`](crate::input::CreateDevicePoolInput)
    pub fn builder() -> crate::input::create_device_pool_input::Builder {
        crate::input::create_device_pool_input::Builder::default()
    }
    /// Creates a new `CreateDevicePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDevicePool {
    type Output = std::result::Result<
        crate::output::CreateDevicePoolOutput,
        crate::error::CreateDevicePoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_device_pool_error(response)
        } else {
            crate::operation_deser::parse_create_device_pool_response(response)
        }
    }
}

/// Operation shape for `CreateInstanceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance_profile`](crate::client::Client::create_instance_profile).
///
/// See [`crate::client::fluent_builders::CreateInstanceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstanceProfile {
    _private: (),
}
impl CreateInstanceProfile {
    /// Creates a new builder-style object to manufacture [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
    pub fn builder() -> crate::input::create_instance_profile_input::Builder {
        crate::input::create_instance_profile_input::Builder::default()
    }
    /// Creates a new `CreateInstanceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstanceProfile {
    type Output = std::result::Result<
        crate::output::CreateInstanceProfileOutput,
        crate::error::CreateInstanceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_profile_error(response)
        } else {
            crate::operation_deser::parse_create_instance_profile_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_profile`](crate::client::Client::create_network_profile).
///
/// See [`crate::client::fluent_builders::CreateNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkProfile {
    _private: (),
}
impl CreateNetworkProfile {
    /// Creates a new builder-style object to manufacture [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
    pub fn builder() -> crate::input::create_network_profile_input::Builder {
        crate::input::create_network_profile_input::Builder::default()
    }
    /// Creates a new `CreateNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkProfile {
    type Output = std::result::Result<
        crate::output::CreateNetworkProfileOutput,
        crate::error::CreateNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_profile_error(response)
        } else {
            crate::operation_deser::parse_create_network_profile_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `CreateRemoteAccessSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_remote_access_session`](crate::client::Client::create_remote_access_session).
///
/// See [`crate::client::fluent_builders::CreateRemoteAccessSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRemoteAccessSession {
    _private: (),
}
impl CreateRemoteAccessSession {
    /// Creates a new builder-style object to manufacture [`CreateRemoteAccessSessionInput`](crate::input::CreateRemoteAccessSessionInput)
    pub fn builder() -> crate::input::create_remote_access_session_input::Builder {
        crate::input::create_remote_access_session_input::Builder::default()
    }
    /// Creates a new `CreateRemoteAccessSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRemoteAccessSession {
    type Output = std::result::Result<
        crate::output::CreateRemoteAccessSessionOutput,
        crate::error::CreateRemoteAccessSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_remote_access_session_error(response)
        } else {
            crate::operation_deser::parse_create_remote_access_session_response(response)
        }
    }
}

/// Operation shape for `CreateTestGridProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_test_grid_project`](crate::client::Client::create_test_grid_project).
///
/// See [`crate::client::fluent_builders::CreateTestGridProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTestGridProject {
    _private: (),
}
impl CreateTestGridProject {
    /// Creates a new builder-style object to manufacture [`CreateTestGridProjectInput`](crate::input::CreateTestGridProjectInput)
    pub fn builder() -> crate::input::create_test_grid_project_input::Builder {
        crate::input::create_test_grid_project_input::Builder::default()
    }
    /// Creates a new `CreateTestGridProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTestGridProject {
    type Output = std::result::Result<
        crate::output::CreateTestGridProjectOutput,
        crate::error::CreateTestGridProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_test_grid_project_error(response)
        } else {
            crate::operation_deser::parse_create_test_grid_project_response(response)
        }
    }
}

/// Operation shape for `CreateTestGridUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_test_grid_url`](crate::client::Client::create_test_grid_url).
///
/// See [`crate::client::fluent_builders::CreateTestGridUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTestGridUrl {
    _private: (),
}
impl CreateTestGridUrl {
    /// Creates a new builder-style object to manufacture [`CreateTestGridUrlInput`](crate::input::CreateTestGridUrlInput)
    pub fn builder() -> crate::input::create_test_grid_url_input::Builder {
        crate::input::create_test_grid_url_input::Builder::default()
    }
    /// Creates a new `CreateTestGridUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTestGridUrl {
    type Output = std::result::Result<
        crate::output::CreateTestGridUrlOutput,
        crate::error::CreateTestGridUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_test_grid_url_error(response)
        } else {
            crate::operation_deser::parse_create_test_grid_url_response(response)
        }
    }
}

/// Operation shape for `CreateUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_upload`](crate::client::Client::create_upload).
///
/// See [`crate::client::fluent_builders::CreateUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUpload {
    _private: (),
}
impl CreateUpload {
    /// Creates a new builder-style object to manufacture [`CreateUploadInput`](crate::input::CreateUploadInput)
    pub fn builder() -> crate::input::create_upload_input::Builder {
        crate::input::create_upload_input::Builder::default()
    }
    /// Creates a new `CreateUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUpload {
    type Output =
        std::result::Result<crate::output::CreateUploadOutput, crate::error::CreateUploadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_upload_error(response)
        } else {
            crate::operation_deser::parse_create_upload_response(response)
        }
    }
}

/// Operation shape for `CreateVPCEConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpce_configuration`](crate::client::Client::create_vpce_configuration).
///
/// See [`crate::client::fluent_builders::CreateVPCEConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVPCEConfiguration {
    _private: (),
}
impl CreateVPCEConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateVpceConfigurationInput`](crate::input::CreateVpceConfigurationInput)
    pub fn builder() -> crate::input::create_vpce_configuration_input::Builder {
        crate::input::create_vpce_configuration_input::Builder::default()
    }
    /// Creates a new `CreateVPCEConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVPCEConfiguration {
    type Output = std::result::Result<
        crate::output::CreateVpceConfigurationOutput,
        crate::error::CreateVPCEConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpce_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_vpce_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteDevicePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device_pool`](crate::client::Client::delete_device_pool).
///
/// See [`crate::client::fluent_builders::DeleteDevicePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDevicePool {
    _private: (),
}
impl DeleteDevicePool {
    /// Creates a new builder-style object to manufacture [`DeleteDevicePoolInput`](crate::input::DeleteDevicePoolInput)
    pub fn builder() -> crate::input::delete_device_pool_input::Builder {
        crate::input::delete_device_pool_input::Builder::default()
    }
    /// Creates a new `DeleteDevicePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDevicePool {
    type Output = std::result::Result<
        crate::output::DeleteDevicePoolOutput,
        crate::error::DeleteDevicePoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_device_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteInstanceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance_profile`](crate::client::Client::delete_instance_profile).
///
/// See [`crate::client::fluent_builders::DeleteInstanceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstanceProfile {
    _private: (),
}
impl DeleteInstanceProfile {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
    pub fn builder() -> crate::input::delete_instance_profile_input::Builder {
        crate::input::delete_instance_profile_input::Builder::default()
    }
    /// Creates a new `DeleteInstanceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstanceProfile {
    type Output = std::result::Result<
        crate::output::DeleteInstanceProfileOutput,
        crate::error::DeleteInstanceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_profile`](crate::client::Client::delete_network_profile).
///
/// See [`crate::client::fluent_builders::DeleteNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkProfile {
    _private: (),
}
impl DeleteNetworkProfile {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
    pub fn builder() -> crate::input::delete_network_profile_input::Builder {
        crate::input::delete_network_profile_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkProfile {
    type Output = std::result::Result<
        crate::output::DeleteNetworkProfileOutput,
        crate::error::DeleteNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_network_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DeleteRemoteAccessSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_remote_access_session`](crate::client::Client::delete_remote_access_session).
///
/// See [`crate::client::fluent_builders::DeleteRemoteAccessSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRemoteAccessSession {
    _private: (),
}
impl DeleteRemoteAccessSession {
    /// Creates a new builder-style object to manufacture [`DeleteRemoteAccessSessionInput`](crate::input::DeleteRemoteAccessSessionInput)
    pub fn builder() -> crate::input::delete_remote_access_session_input::Builder {
        crate::input::delete_remote_access_session_input::Builder::default()
    }
    /// Creates a new `DeleteRemoteAccessSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRemoteAccessSession {
    type Output = std::result::Result<
        crate::output::DeleteRemoteAccessSessionOutput,
        crate::error::DeleteRemoteAccessSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_remote_access_session_error(response)
        } else {
            crate::operation_deser::parse_delete_remote_access_session_response(response)
        }
    }
}

/// Operation shape for `DeleteRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_run`](crate::client::Client::delete_run).
///
/// See [`crate::client::fluent_builders::DeleteRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRun {
    _private: (),
}
impl DeleteRun {
    /// Creates a new builder-style object to manufacture [`DeleteRunInput`](crate::input::DeleteRunInput)
    pub fn builder() -> crate::input::delete_run_input::Builder {
        crate::input::delete_run_input::Builder::default()
    }
    /// Creates a new `DeleteRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRun {
    type Output = std::result::Result<crate::output::DeleteRunOutput, crate::error::DeleteRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_run_error(response)
        } else {
            crate::operation_deser::parse_delete_run_response(response)
        }
    }
}

/// Operation shape for `DeleteTestGridProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_test_grid_project`](crate::client::Client::delete_test_grid_project).
///
/// See [`crate::client::fluent_builders::DeleteTestGridProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTestGridProject {
    _private: (),
}
impl DeleteTestGridProject {
    /// Creates a new builder-style object to manufacture [`DeleteTestGridProjectInput`](crate::input::DeleteTestGridProjectInput)
    pub fn builder() -> crate::input::delete_test_grid_project_input::Builder {
        crate::input::delete_test_grid_project_input::Builder::default()
    }
    /// Creates a new `DeleteTestGridProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTestGridProject {
    type Output = std::result::Result<
        crate::output::DeleteTestGridProjectOutput,
        crate::error::DeleteTestGridProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_test_grid_project_error(response)
        } else {
            crate::operation_deser::parse_delete_test_grid_project_response(response)
        }
    }
}

/// Operation shape for `DeleteUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_upload`](crate::client::Client::delete_upload).
///
/// See [`crate::client::fluent_builders::DeleteUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUpload {
    _private: (),
}
impl DeleteUpload {
    /// Creates a new builder-style object to manufacture [`DeleteUploadInput`](crate::input::DeleteUploadInput)
    pub fn builder() -> crate::input::delete_upload_input::Builder {
        crate::input::delete_upload_input::Builder::default()
    }
    /// Creates a new `DeleteUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUpload {
    type Output =
        std::result::Result<crate::output::DeleteUploadOutput, crate::error::DeleteUploadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_upload_error(response)
        } else {
            crate::operation_deser::parse_delete_upload_response(response)
        }
    }
}

/// Operation shape for `DeleteVPCEConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpce_configuration`](crate::client::Client::delete_vpce_configuration).
///
/// See [`crate::client::fluent_builders::DeleteVPCEConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVPCEConfiguration {
    _private: (),
}
impl DeleteVPCEConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteVpceConfigurationInput`](crate::input::DeleteVpceConfigurationInput)
    pub fn builder() -> crate::input::delete_vpce_configuration_input::Builder {
        crate::input::delete_vpce_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteVPCEConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVPCEConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteVpceConfigurationOutput,
        crate::error::DeleteVPCEConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpce_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_vpce_configuration_response(response)
        }
    }
}

/// Operation shape for `GetAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_settings`](crate::client::Client::get_account_settings).
///
/// See [`crate::client::fluent_builders::GetAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountSettings {
    _private: (),
}
impl GetAccountSettings {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
    /// Creates a new `GetAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountSettings {
    type Output = std::result::Result<
        crate::output::GetAccountSettingsOutput,
        crate::error::GetAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_settings_error(response)
        } else {
            crate::operation_deser::parse_get_account_settings_response(response)
        }
    }
}

/// Operation shape for `GetDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device`](crate::client::Client::get_device).
///
/// See [`crate::client::fluent_builders::GetDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevice {
    _private: (),
}
impl GetDevice {
    /// Creates a new builder-style object to manufacture [`GetDeviceInput`](crate::input::GetDeviceInput)
    pub fn builder() -> crate::input::get_device_input::Builder {
        crate::input::get_device_input::Builder::default()
    }
    /// Creates a new `GetDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevice {
    type Output = std::result::Result<crate::output::GetDeviceOutput, crate::error::GetDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_error(response)
        } else {
            crate::operation_deser::parse_get_device_response(response)
        }
    }
}

/// Operation shape for `GetDeviceInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_instance`](crate::client::Client::get_device_instance).
///
/// See [`crate::client::fluent_builders::GetDeviceInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceInstance {
    _private: (),
}
impl GetDeviceInstance {
    /// Creates a new builder-style object to manufacture [`GetDeviceInstanceInput`](crate::input::GetDeviceInstanceInput)
    pub fn builder() -> crate::input::get_device_instance_input::Builder {
        crate::input::get_device_instance_input::Builder::default()
    }
    /// Creates a new `GetDeviceInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceInstance {
    type Output = std::result::Result<
        crate::output::GetDeviceInstanceOutput,
        crate::error::GetDeviceInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_instance_error(response)
        } else {
            crate::operation_deser::parse_get_device_instance_response(response)
        }
    }
}

/// Operation shape for `GetDevicePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_pool`](crate::client::Client::get_device_pool).
///
/// See [`crate::client::fluent_builders::GetDevicePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevicePool {
    _private: (),
}
impl GetDevicePool {
    /// Creates a new builder-style object to manufacture [`GetDevicePoolInput`](crate::input::GetDevicePoolInput)
    pub fn builder() -> crate::input::get_device_pool_input::Builder {
        crate::input::get_device_pool_input::Builder::default()
    }
    /// Creates a new `GetDevicePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevicePool {
    type Output =
        std::result::Result<crate::output::GetDevicePoolOutput, crate::error::GetDevicePoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_pool_error(response)
        } else {
            crate::operation_deser::parse_get_device_pool_response(response)
        }
    }
}

/// Operation shape for `GetDevicePoolCompatibility`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_pool_compatibility`](crate::client::Client::get_device_pool_compatibility).
///
/// See [`crate::client::fluent_builders::GetDevicePoolCompatibility`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevicePoolCompatibility {
    _private: (),
}
impl GetDevicePoolCompatibility {
    /// Creates a new builder-style object to manufacture [`GetDevicePoolCompatibilityInput`](crate::input::GetDevicePoolCompatibilityInput)
    pub fn builder() -> crate::input::get_device_pool_compatibility_input::Builder {
        crate::input::get_device_pool_compatibility_input::Builder::default()
    }
    /// Creates a new `GetDevicePoolCompatibility` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevicePoolCompatibility {
    type Output = std::result::Result<
        crate::output::GetDevicePoolCompatibilityOutput,
        crate::error::GetDevicePoolCompatibilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_pool_compatibility_error(response)
        } else {
            crate::operation_deser::parse_get_device_pool_compatibility_response(response)
        }
    }
}

/// Operation shape for `GetInstanceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_profile`](crate::client::Client::get_instance_profile).
///
/// See [`crate::client::fluent_builders::GetInstanceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceProfile {
    _private: (),
}
impl GetInstanceProfile {
    /// Creates a new builder-style object to manufacture [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
    pub fn builder() -> crate::input::get_instance_profile_input::Builder {
        crate::input::get_instance_profile_input::Builder::default()
    }
    /// Creates a new `GetInstanceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceProfile {
    type Output = std::result::Result<
        crate::output::GetInstanceProfileOutput,
        crate::error::GetInstanceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_profile_error(response)
        } else {
            crate::operation_deser::parse_get_instance_profile_response(response)
        }
    }
}

/// Operation shape for `GetJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job`](crate::client::Client::get_job).
///
/// See [`crate::client::fluent_builders::GetJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJob {
    _private: (),
}
impl GetJob {
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
    /// Creates a new `GetJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJob {
    type Output = std::result::Result<crate::output::GetJobOutput, crate::error::GetJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_error(response)
        } else {
            crate::operation_deser::parse_get_job_response(response)
        }
    }
}

/// Operation shape for `GetNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_profile`](crate::client::Client::get_network_profile).
///
/// See [`crate::client::fluent_builders::GetNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkProfile {
    _private: (),
}
impl GetNetworkProfile {
    /// Creates a new builder-style object to manufacture [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
    pub fn builder() -> crate::input::get_network_profile_input::Builder {
        crate::input::get_network_profile_input::Builder::default()
    }
    /// Creates a new `GetNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkProfile {
    type Output = std::result::Result<
        crate::output::GetNetworkProfileOutput,
        crate::error::GetNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_profile_error(response)
        } else {
            crate::operation_deser::parse_get_network_profile_response(response)
        }
    }
}

/// Operation shape for `GetOfferingStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_offering_status`](crate::client::Client::get_offering_status).
///
/// See [`crate::client::fluent_builders::GetOfferingStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOfferingStatus {
    _private: (),
}
impl GetOfferingStatus {
    /// Creates a new builder-style object to manufacture [`GetOfferingStatusInput`](crate::input::GetOfferingStatusInput)
    pub fn builder() -> crate::input::get_offering_status_input::Builder {
        crate::input::get_offering_status_input::Builder::default()
    }
    /// Creates a new `GetOfferingStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOfferingStatus {
    type Output = std::result::Result<
        crate::output::GetOfferingStatusOutput,
        crate::error::GetOfferingStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_offering_status_error(response)
        } else {
            crate::operation_deser::parse_get_offering_status_response(response)
        }
    }
}

/// Operation shape for `GetProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_project`](crate::client::Client::get_project).
///
/// See [`crate::client::fluent_builders::GetProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProject {
    _private: (),
}
impl GetProject {
    /// Creates a new builder-style object to manufacture [`GetProjectInput`](crate::input::GetProjectInput)
    pub fn builder() -> crate::input::get_project_input::Builder {
        crate::input::get_project_input::Builder::default()
    }
    /// Creates a new `GetProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProject {
    type Output =
        std::result::Result<crate::output::GetProjectOutput, crate::error::GetProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_project_error(response)
        } else {
            crate::operation_deser::parse_get_project_response(response)
        }
    }
}

/// Operation shape for `GetRemoteAccessSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_remote_access_session`](crate::client::Client::get_remote_access_session).
///
/// See [`crate::client::fluent_builders::GetRemoteAccessSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRemoteAccessSession {
    _private: (),
}
impl GetRemoteAccessSession {
    /// Creates a new builder-style object to manufacture [`GetRemoteAccessSessionInput`](crate::input::GetRemoteAccessSessionInput)
    pub fn builder() -> crate::input::get_remote_access_session_input::Builder {
        crate::input::get_remote_access_session_input::Builder::default()
    }
    /// Creates a new `GetRemoteAccessSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRemoteAccessSession {
    type Output = std::result::Result<
        crate::output::GetRemoteAccessSessionOutput,
        crate::error::GetRemoteAccessSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_remote_access_session_error(response)
        } else {
            crate::operation_deser::parse_get_remote_access_session_response(response)
        }
    }
}

/// Operation shape for `GetRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_run`](crate::client::Client::get_run).
///
/// See [`crate::client::fluent_builders::GetRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRun {
    _private: (),
}
impl GetRun {
    /// Creates a new builder-style object to manufacture [`GetRunInput`](crate::input::GetRunInput)
    pub fn builder() -> crate::input::get_run_input::Builder {
        crate::input::get_run_input::Builder::default()
    }
    /// Creates a new `GetRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRun {
    type Output = std::result::Result<crate::output::GetRunOutput, crate::error::GetRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_run_error(response)
        } else {
            crate::operation_deser::parse_get_run_response(response)
        }
    }
}

/// Operation shape for `GetSuite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_suite`](crate::client::Client::get_suite).
///
/// See [`crate::client::fluent_builders::GetSuite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSuite {
    _private: (),
}
impl GetSuite {
    /// Creates a new builder-style object to manufacture [`GetSuiteInput`](crate::input::GetSuiteInput)
    pub fn builder() -> crate::input::get_suite_input::Builder {
        crate::input::get_suite_input::Builder::default()
    }
    /// Creates a new `GetSuite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSuite {
    type Output = std::result::Result<crate::output::GetSuiteOutput, crate::error::GetSuiteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_suite_error(response)
        } else {
            crate::operation_deser::parse_get_suite_response(response)
        }
    }
}

/// Operation shape for `GetTest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_test`](crate::client::Client::get_test).
///
/// See [`crate::client::fluent_builders::GetTest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTest {
    _private: (),
}
impl GetTest {
    /// Creates a new builder-style object to manufacture [`GetTestInput`](crate::input::GetTestInput)
    pub fn builder() -> crate::input::get_test_input::Builder {
        crate::input::get_test_input::Builder::default()
    }
    /// Creates a new `GetTest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTest {
    type Output = std::result::Result<crate::output::GetTestOutput, crate::error::GetTestError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_test_error(response)
        } else {
            crate::operation_deser::parse_get_test_response(response)
        }
    }
}

/// Operation shape for `GetTestGridProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_test_grid_project`](crate::client::Client::get_test_grid_project).
///
/// See [`crate::client::fluent_builders::GetTestGridProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTestGridProject {
    _private: (),
}
impl GetTestGridProject {
    /// Creates a new builder-style object to manufacture [`GetTestGridProjectInput`](crate::input::GetTestGridProjectInput)
    pub fn builder() -> crate::input::get_test_grid_project_input::Builder {
        crate::input::get_test_grid_project_input::Builder::default()
    }
    /// Creates a new `GetTestGridProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTestGridProject {
    type Output = std::result::Result<
        crate::output::GetTestGridProjectOutput,
        crate::error::GetTestGridProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_test_grid_project_error(response)
        } else {
            crate::operation_deser::parse_get_test_grid_project_response(response)
        }
    }
}

/// Operation shape for `GetTestGridSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_test_grid_session`](crate::client::Client::get_test_grid_session).
///
/// See [`crate::client::fluent_builders::GetTestGridSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTestGridSession {
    _private: (),
}
impl GetTestGridSession {
    /// Creates a new builder-style object to manufacture [`GetTestGridSessionInput`](crate::input::GetTestGridSessionInput)
    pub fn builder() -> crate::input::get_test_grid_session_input::Builder {
        crate::input::get_test_grid_session_input::Builder::default()
    }
    /// Creates a new `GetTestGridSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTestGridSession {
    type Output = std::result::Result<
        crate::output::GetTestGridSessionOutput,
        crate::error::GetTestGridSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_test_grid_session_error(response)
        } else {
            crate::operation_deser::parse_get_test_grid_session_response(response)
        }
    }
}

/// Operation shape for `GetUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_upload`](crate::client::Client::get_upload).
///
/// See [`crate::client::fluent_builders::GetUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUpload {
    _private: (),
}
impl GetUpload {
    /// Creates a new builder-style object to manufacture [`GetUploadInput`](crate::input::GetUploadInput)
    pub fn builder() -> crate::input::get_upload_input::Builder {
        crate::input::get_upload_input::Builder::default()
    }
    /// Creates a new `GetUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUpload {
    type Output = std::result::Result<crate::output::GetUploadOutput, crate::error::GetUploadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_upload_error(response)
        } else {
            crate::operation_deser::parse_get_upload_response(response)
        }
    }
}

/// Operation shape for `GetVPCEConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpce_configuration`](crate::client::Client::get_vpce_configuration).
///
/// See [`crate::client::fluent_builders::GetVPCEConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVPCEConfiguration {
    _private: (),
}
impl GetVPCEConfiguration {
    /// Creates a new builder-style object to manufacture [`GetVpceConfigurationInput`](crate::input::GetVpceConfigurationInput)
    pub fn builder() -> crate::input::get_vpce_configuration_input::Builder {
        crate::input::get_vpce_configuration_input::Builder::default()
    }
    /// Creates a new `GetVPCEConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVPCEConfiguration {
    type Output = std::result::Result<
        crate::output::GetVpceConfigurationOutput,
        crate::error::GetVPCEConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpce_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_vpce_configuration_response(response)
        }
    }
}

/// Operation shape for `InstallToRemoteAccessSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`install_to_remote_access_session`](crate::client::Client::install_to_remote_access_session).
///
/// See [`crate::client::fluent_builders::InstallToRemoteAccessSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InstallToRemoteAccessSession {
    _private: (),
}
impl InstallToRemoteAccessSession {
    /// Creates a new builder-style object to manufacture [`InstallToRemoteAccessSessionInput`](crate::input::InstallToRemoteAccessSessionInput)
    pub fn builder() -> crate::input::install_to_remote_access_session_input::Builder {
        crate::input::install_to_remote_access_session_input::Builder::default()
    }
    /// Creates a new `InstallToRemoteAccessSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InstallToRemoteAccessSession {
    type Output = std::result::Result<
        crate::output::InstallToRemoteAccessSessionOutput,
        crate::error::InstallToRemoteAccessSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_install_to_remote_access_session_error(response)
        } else {
            crate::operation_deser::parse_install_to_remote_access_session_response(response)
        }
    }
}

/// Operation shape for `ListArtifacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_artifacts`](crate::client::Client::list_artifacts).
///
/// See [`crate::client::fluent_builders::ListArtifacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListArtifacts {
    _private: (),
}
impl ListArtifacts {
    /// Creates a new builder-style object to manufacture [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    pub fn builder() -> crate::input::list_artifacts_input::Builder {
        crate::input::list_artifacts_input::Builder::default()
    }
    /// Creates a new `ListArtifacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListArtifacts {
    type Output =
        std::result::Result<crate::output::ListArtifactsOutput, crate::error::ListArtifactsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_artifacts_error(response)
        } else {
            crate::operation_deser::parse_list_artifacts_response(response)
        }
    }
}

/// Operation shape for `ListDeviceInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_instances`](crate::client::Client::list_device_instances).
///
/// See [`crate::client::fluent_builders::ListDeviceInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceInstances {
    _private: (),
}
impl ListDeviceInstances {
    /// Creates a new builder-style object to manufacture [`ListDeviceInstancesInput`](crate::input::ListDeviceInstancesInput)
    pub fn builder() -> crate::input::list_device_instances_input::Builder {
        crate::input::list_device_instances_input::Builder::default()
    }
    /// Creates a new `ListDeviceInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceInstances {
    type Output = std::result::Result<
        crate::output::ListDeviceInstancesOutput,
        crate::error::ListDeviceInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_instances_error(response)
        } else {
            crate::operation_deser::parse_list_device_instances_response(response)
        }
    }
}

/// Operation shape for `ListDevicePools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_pools`](crate::client::Client::list_device_pools).
///
/// See [`crate::client::fluent_builders::ListDevicePools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevicePools {
    _private: (),
}
impl ListDevicePools {
    /// Creates a new builder-style object to manufacture [`ListDevicePoolsInput`](crate::input::ListDevicePoolsInput)
    pub fn builder() -> crate::input::list_device_pools_input::Builder {
        crate::input::list_device_pools_input::Builder::default()
    }
    /// Creates a new `ListDevicePools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevicePools {
    type Output = std::result::Result<
        crate::output::ListDevicePoolsOutput,
        crate::error::ListDevicePoolsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_pools_error(response)
        } else {
            crate::operation_deser::parse_list_device_pools_response(response)
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListInstanceProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_instance_profiles`](crate::client::Client::list_instance_profiles).
///
/// See [`crate::client::fluent_builders::ListInstanceProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInstanceProfiles {
    _private: (),
}
impl ListInstanceProfiles {
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
    pub fn builder() -> crate::input::list_instance_profiles_input::Builder {
        crate::input::list_instance_profiles_input::Builder::default()
    }
    /// Creates a new `ListInstanceProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInstanceProfiles {
    type Output = std::result::Result<
        crate::output::ListInstanceProfilesOutput,
        crate::error::ListInstanceProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_instance_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_instance_profiles_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListNetworkProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_network_profiles`](crate::client::Client::list_network_profiles).
///
/// See [`crate::client::fluent_builders::ListNetworkProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNetworkProfiles {
    _private: (),
}
impl ListNetworkProfiles {
    /// Creates a new builder-style object to manufacture [`ListNetworkProfilesInput`](crate::input::ListNetworkProfilesInput)
    pub fn builder() -> crate::input::list_network_profiles_input::Builder {
        crate::input::list_network_profiles_input::Builder::default()
    }
    /// Creates a new `ListNetworkProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNetworkProfiles {
    type Output = std::result::Result<
        crate::output::ListNetworkProfilesOutput,
        crate::error::ListNetworkProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_network_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_network_profiles_response(response)
        }
    }
}

/// Operation shape for `ListOfferingPromotions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_offering_promotions`](crate::client::Client::list_offering_promotions).
///
/// See [`crate::client::fluent_builders::ListOfferingPromotions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOfferingPromotions {
    _private: (),
}
impl ListOfferingPromotions {
    /// Creates a new builder-style object to manufacture [`ListOfferingPromotionsInput`](crate::input::ListOfferingPromotionsInput)
    pub fn builder() -> crate::input::list_offering_promotions_input::Builder {
        crate::input::list_offering_promotions_input::Builder::default()
    }
    /// Creates a new `ListOfferingPromotions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOfferingPromotions {
    type Output = std::result::Result<
        crate::output::ListOfferingPromotionsOutput,
        crate::error::ListOfferingPromotionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_offering_promotions_error(response)
        } else {
            crate::operation_deser::parse_list_offering_promotions_response(response)
        }
    }
}

/// Operation shape for `ListOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_offerings`](crate::client::Client::list_offerings).
///
/// See [`crate::client::fluent_builders::ListOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOfferings {
    _private: (),
}
impl ListOfferings {
    /// Creates a new builder-style object to manufacture [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    pub fn builder() -> crate::input::list_offerings_input::Builder {
        crate::input::list_offerings_input::Builder::default()
    }
    /// Creates a new `ListOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOfferings {
    type Output =
        std::result::Result<crate::output::ListOfferingsOutput, crate::error::ListOfferingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_offerings_error(response)
        } else {
            crate::operation_deser::parse_list_offerings_response(response)
        }
    }
}

/// Operation shape for `ListOfferingTransactions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_offering_transactions`](crate::client::Client::list_offering_transactions).
///
/// See [`crate::client::fluent_builders::ListOfferingTransactions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOfferingTransactions {
    _private: (),
}
impl ListOfferingTransactions {
    /// Creates a new builder-style object to manufacture [`ListOfferingTransactionsInput`](crate::input::ListOfferingTransactionsInput)
    pub fn builder() -> crate::input::list_offering_transactions_input::Builder {
        crate::input::list_offering_transactions_input::Builder::default()
    }
    /// Creates a new `ListOfferingTransactions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOfferingTransactions {
    type Output = std::result::Result<
        crate::output::ListOfferingTransactionsOutput,
        crate::error::ListOfferingTransactionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_offering_transactions_error(response)
        } else {
            crate::operation_deser::parse_list_offering_transactions_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListRemoteAccessSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_remote_access_sessions`](crate::client::Client::list_remote_access_sessions).
///
/// See [`crate::client::fluent_builders::ListRemoteAccessSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRemoteAccessSessions {
    _private: (),
}
impl ListRemoteAccessSessions {
    /// Creates a new builder-style object to manufacture [`ListRemoteAccessSessionsInput`](crate::input::ListRemoteAccessSessionsInput)
    pub fn builder() -> crate::input::list_remote_access_sessions_input::Builder {
        crate::input::list_remote_access_sessions_input::Builder::default()
    }
    /// Creates a new `ListRemoteAccessSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRemoteAccessSessions {
    type Output = std::result::Result<
        crate::output::ListRemoteAccessSessionsOutput,
        crate::error::ListRemoteAccessSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_remote_access_sessions_error(response)
        } else {
            crate::operation_deser::parse_list_remote_access_sessions_response(response)
        }
    }
}

/// Operation shape for `ListRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_runs`](crate::client::Client::list_runs).
///
/// See [`crate::client::fluent_builders::ListRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRuns {
    _private: (),
}
impl ListRuns {
    /// Creates a new builder-style object to manufacture [`ListRunsInput`](crate::input::ListRunsInput)
    pub fn builder() -> crate::input::list_runs_input::Builder {
        crate::input::list_runs_input::Builder::default()
    }
    /// Creates a new `ListRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRuns {
    type Output = std::result::Result<crate::output::ListRunsOutput, crate::error::ListRunsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_runs_error(response)
        } else {
            crate::operation_deser::parse_list_runs_response(response)
        }
    }
}

/// Operation shape for `ListSamples`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_samples`](crate::client::Client::list_samples).
///
/// See [`crate::client::fluent_builders::ListSamples`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSamples {
    _private: (),
}
impl ListSamples {
    /// Creates a new builder-style object to manufacture [`ListSamplesInput`](crate::input::ListSamplesInput)
    pub fn builder() -> crate::input::list_samples_input::Builder {
        crate::input::list_samples_input::Builder::default()
    }
    /// Creates a new `ListSamples` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSamples {
    type Output =
        std::result::Result<crate::output::ListSamplesOutput, crate::error::ListSamplesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_samples_error(response)
        } else {
            crate::operation_deser::parse_list_samples_response(response)
        }
    }
}

/// Operation shape for `ListSuites`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_suites`](crate::client::Client::list_suites).
///
/// See [`crate::client::fluent_builders::ListSuites`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSuites {
    _private: (),
}
impl ListSuites {
    /// Creates a new builder-style object to manufacture [`ListSuitesInput`](crate::input::ListSuitesInput)
    pub fn builder() -> crate::input::list_suites_input::Builder {
        crate::input::list_suites_input::Builder::default()
    }
    /// Creates a new `ListSuites` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSuites {
    type Output =
        std::result::Result<crate::output::ListSuitesOutput, crate::error::ListSuitesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_suites_error(response)
        } else {
            crate::operation_deser::parse_list_suites_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTestGridProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_test_grid_projects`](crate::client::Client::list_test_grid_projects).
///
/// See [`crate::client::fluent_builders::ListTestGridProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTestGridProjects {
    _private: (),
}
impl ListTestGridProjects {
    /// Creates a new builder-style object to manufacture [`ListTestGridProjectsInput`](crate::input::ListTestGridProjectsInput)
    pub fn builder() -> crate::input::list_test_grid_projects_input::Builder {
        crate::input::list_test_grid_projects_input::Builder::default()
    }
    /// Creates a new `ListTestGridProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTestGridProjects {
    type Output = std::result::Result<
        crate::output::ListTestGridProjectsOutput,
        crate::error::ListTestGridProjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_test_grid_projects_error(response)
        } else {
            crate::operation_deser::parse_list_test_grid_projects_response(response)
        }
    }
}

/// Operation shape for `ListTestGridSessionActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_test_grid_session_actions`](crate::client::Client::list_test_grid_session_actions).
///
/// See [`crate::client::fluent_builders::ListTestGridSessionActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTestGridSessionActions {
    _private: (),
}
impl ListTestGridSessionActions {
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionActionsInput`](crate::input::ListTestGridSessionActionsInput)
    pub fn builder() -> crate::input::list_test_grid_session_actions_input::Builder {
        crate::input::list_test_grid_session_actions_input::Builder::default()
    }
    /// Creates a new `ListTestGridSessionActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTestGridSessionActions {
    type Output = std::result::Result<
        crate::output::ListTestGridSessionActionsOutput,
        crate::error::ListTestGridSessionActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_test_grid_session_actions_error(response)
        } else {
            crate::operation_deser::parse_list_test_grid_session_actions_response(response)
        }
    }
}

/// Operation shape for `ListTestGridSessionArtifacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_test_grid_session_artifacts`](crate::client::Client::list_test_grid_session_artifacts).
///
/// See [`crate::client::fluent_builders::ListTestGridSessionArtifacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTestGridSessionArtifacts {
    _private: (),
}
impl ListTestGridSessionArtifacts {
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionArtifactsInput`](crate::input::ListTestGridSessionArtifactsInput)
    pub fn builder() -> crate::input::list_test_grid_session_artifacts_input::Builder {
        crate::input::list_test_grid_session_artifacts_input::Builder::default()
    }
    /// Creates a new `ListTestGridSessionArtifacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTestGridSessionArtifacts {
    type Output = std::result::Result<
        crate::output::ListTestGridSessionArtifactsOutput,
        crate::error::ListTestGridSessionArtifactsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_test_grid_session_artifacts_error(response)
        } else {
            crate::operation_deser::parse_list_test_grid_session_artifacts_response(response)
        }
    }
}

/// Operation shape for `ListTestGridSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_test_grid_sessions`](crate::client::Client::list_test_grid_sessions).
///
/// See [`crate::client::fluent_builders::ListTestGridSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTestGridSessions {
    _private: (),
}
impl ListTestGridSessions {
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionsInput`](crate::input::ListTestGridSessionsInput)
    pub fn builder() -> crate::input::list_test_grid_sessions_input::Builder {
        crate::input::list_test_grid_sessions_input::Builder::default()
    }
    /// Creates a new `ListTestGridSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTestGridSessions {
    type Output = std::result::Result<
        crate::output::ListTestGridSessionsOutput,
        crate::error::ListTestGridSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_test_grid_sessions_error(response)
        } else {
            crate::operation_deser::parse_list_test_grid_sessions_response(response)
        }
    }
}

/// Operation shape for `ListTests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tests`](crate::client::Client::list_tests).
///
/// See [`crate::client::fluent_builders::ListTests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTests {
    _private: (),
}
impl ListTests {
    /// Creates a new builder-style object to manufacture [`ListTestsInput`](crate::input::ListTestsInput)
    pub fn builder() -> crate::input::list_tests_input::Builder {
        crate::input::list_tests_input::Builder::default()
    }
    /// Creates a new `ListTests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTests {
    type Output = std::result::Result<crate::output::ListTestsOutput, crate::error::ListTestsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tests_error(response)
        } else {
            crate::operation_deser::parse_list_tests_response(response)
        }
    }
}

/// Operation shape for `ListUniqueProblems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_unique_problems`](crate::client::Client::list_unique_problems).
///
/// See [`crate::client::fluent_builders::ListUniqueProblems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUniqueProblems {
    _private: (),
}
impl ListUniqueProblems {
    /// Creates a new builder-style object to manufacture [`ListUniqueProblemsInput`](crate::input::ListUniqueProblemsInput)
    pub fn builder() -> crate::input::list_unique_problems_input::Builder {
        crate::input::list_unique_problems_input::Builder::default()
    }
    /// Creates a new `ListUniqueProblems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUniqueProblems {
    type Output = std::result::Result<
        crate::output::ListUniqueProblemsOutput,
        crate::error::ListUniqueProblemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_unique_problems_error(response)
        } else {
            crate::operation_deser::parse_list_unique_problems_response(response)
        }
    }
}

/// Operation shape for `ListUploads`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_uploads`](crate::client::Client::list_uploads).
///
/// See [`crate::client::fluent_builders::ListUploads`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUploads {
    _private: (),
}
impl ListUploads {
    /// Creates a new builder-style object to manufacture [`ListUploadsInput`](crate::input::ListUploadsInput)
    pub fn builder() -> crate::input::list_uploads_input::Builder {
        crate::input::list_uploads_input::Builder::default()
    }
    /// Creates a new `ListUploads` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUploads {
    type Output =
        std::result::Result<crate::output::ListUploadsOutput, crate::error::ListUploadsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_uploads_error(response)
        } else {
            crate::operation_deser::parse_list_uploads_response(response)
        }
    }
}

/// Operation shape for `ListVPCEConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_vpce_configurations`](crate::client::Client::list_vpce_configurations).
///
/// See [`crate::client::fluent_builders::ListVPCEConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVPCEConfigurations {
    _private: (),
}
impl ListVPCEConfigurations {
    /// Creates a new builder-style object to manufacture [`ListVpceConfigurationsInput`](crate::input::ListVpceConfigurationsInput)
    pub fn builder() -> crate::input::list_vpce_configurations_input::Builder {
        crate::input::list_vpce_configurations_input::Builder::default()
    }
    /// Creates a new `ListVPCEConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVPCEConfigurations {
    type Output = std::result::Result<
        crate::output::ListVpceConfigurationsOutput,
        crate::error::ListVPCEConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_vpce_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_vpce_configurations_response(response)
        }
    }
}

/// Operation shape for `PurchaseOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_offering`](crate::client::Client::purchase_offering).
///
/// See [`crate::client::fluent_builders::PurchaseOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseOffering {
    _private: (),
}
impl PurchaseOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    pub fn builder() -> crate::input::purchase_offering_input::Builder {
        crate::input::purchase_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseOffering {
    type Output = std::result::Result<
        crate::output::PurchaseOfferingOutput,
        crate::error::PurchaseOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_offering_response(response)
        }
    }
}

/// Operation shape for `RenewOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`renew_offering`](crate::client::Client::renew_offering).
///
/// See [`crate::client::fluent_builders::RenewOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RenewOffering {
    _private: (),
}
impl RenewOffering {
    /// Creates a new builder-style object to manufacture [`RenewOfferingInput`](crate::input::RenewOfferingInput)
    pub fn builder() -> crate::input::renew_offering_input::Builder {
        crate::input::renew_offering_input::Builder::default()
    }
    /// Creates a new `RenewOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RenewOffering {
    type Output =
        std::result::Result<crate::output::RenewOfferingOutput, crate::error::RenewOfferingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_renew_offering_error(response)
        } else {
            crate::operation_deser::parse_renew_offering_response(response)
        }
    }
}

/// Operation shape for `ScheduleRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`schedule_run`](crate::client::Client::schedule_run).
///
/// See [`crate::client::fluent_builders::ScheduleRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ScheduleRun {
    _private: (),
}
impl ScheduleRun {
    /// Creates a new builder-style object to manufacture [`ScheduleRunInput`](crate::input::ScheduleRunInput)
    pub fn builder() -> crate::input::schedule_run_input::Builder {
        crate::input::schedule_run_input::Builder::default()
    }
    /// Creates a new `ScheduleRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ScheduleRun {
    type Output =
        std::result::Result<crate::output::ScheduleRunOutput, crate::error::ScheduleRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_schedule_run_error(response)
        } else {
            crate::operation_deser::parse_schedule_run_response(response)
        }
    }
}

/// Operation shape for `StopJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_job`](crate::client::Client::stop_job).
///
/// See [`crate::client::fluent_builders::StopJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopJob {
    _private: (),
}
impl StopJob {
    /// Creates a new builder-style object to manufacture [`StopJobInput`](crate::input::StopJobInput)
    pub fn builder() -> crate::input::stop_job_input::Builder {
        crate::input::stop_job_input::Builder::default()
    }
    /// Creates a new `StopJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopJob {
    type Output = std::result::Result<crate::output::StopJobOutput, crate::error::StopJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_job_error(response)
        } else {
            crate::operation_deser::parse_stop_job_response(response)
        }
    }
}

/// Operation shape for `StopRemoteAccessSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_remote_access_session`](crate::client::Client::stop_remote_access_session).
///
/// See [`crate::client::fluent_builders::StopRemoteAccessSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopRemoteAccessSession {
    _private: (),
}
impl StopRemoteAccessSession {
    /// Creates a new builder-style object to manufacture [`StopRemoteAccessSessionInput`](crate::input::StopRemoteAccessSessionInput)
    pub fn builder() -> crate::input::stop_remote_access_session_input::Builder {
        crate::input::stop_remote_access_session_input::Builder::default()
    }
    /// Creates a new `StopRemoteAccessSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopRemoteAccessSession {
    type Output = std::result::Result<
        crate::output::StopRemoteAccessSessionOutput,
        crate::error::StopRemoteAccessSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_remote_access_session_error(response)
        } else {
            crate::operation_deser::parse_stop_remote_access_session_response(response)
        }
    }
}

/// Operation shape for `StopRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_run`](crate::client::Client::stop_run).
///
/// See [`crate::client::fluent_builders::StopRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopRun {
    _private: (),
}
impl StopRun {
    /// Creates a new builder-style object to manufacture [`StopRunInput`](crate::input::StopRunInput)
    pub fn builder() -> crate::input::stop_run_input::Builder {
        crate::input::stop_run_input::Builder::default()
    }
    /// Creates a new `StopRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopRun {
    type Output = std::result::Result<crate::output::StopRunOutput, crate::error::StopRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_run_error(response)
        } else {
            crate::operation_deser::parse_stop_run_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDeviceInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_instance`](crate::client::Client::update_device_instance).
///
/// See [`crate::client::fluent_builders::UpdateDeviceInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeviceInstance {
    _private: (),
}
impl UpdateDeviceInstance {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInstanceInput`](crate::input::UpdateDeviceInstanceInput)
    pub fn builder() -> crate::input::update_device_instance_input::Builder {
        crate::input::update_device_instance_input::Builder::default()
    }
    /// Creates a new `UpdateDeviceInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeviceInstance {
    type Output = std::result::Result<
        crate::output::UpdateDeviceInstanceOutput,
        crate::error::UpdateDeviceInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_instance_error(response)
        } else {
            crate::operation_deser::parse_update_device_instance_response(response)
        }
    }
}

/// Operation shape for `UpdateDevicePool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_pool`](crate::client::Client::update_device_pool).
///
/// See [`crate::client::fluent_builders::UpdateDevicePool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevicePool {
    _private: (),
}
impl UpdateDevicePool {
    /// Creates a new builder-style object to manufacture [`UpdateDevicePoolInput`](crate::input::UpdateDevicePoolInput)
    pub fn builder() -> crate::input::update_device_pool_input::Builder {
        crate::input::update_device_pool_input::Builder::default()
    }
    /// Creates a new `UpdateDevicePool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevicePool {
    type Output = std::result::Result<
        crate::output::UpdateDevicePoolOutput,
        crate::error::UpdateDevicePoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_pool_error(response)
        } else {
            crate::operation_deser::parse_update_device_pool_response(response)
        }
    }
}

/// Operation shape for `UpdateInstanceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_instance_profile`](crate::client::Client::update_instance_profile).
///
/// See [`crate::client::fluent_builders::UpdateInstanceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInstanceProfile {
    _private: (),
}
impl UpdateInstanceProfile {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceProfileInput`](crate::input::UpdateInstanceProfileInput)
    pub fn builder() -> crate::input::update_instance_profile_input::Builder {
        crate::input::update_instance_profile_input::Builder::default()
    }
    /// Creates a new `UpdateInstanceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInstanceProfile {
    type Output = std::result::Result<
        crate::output::UpdateInstanceProfileOutput,
        crate::error::UpdateInstanceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_instance_profile_error(response)
        } else {
            crate::operation_deser::parse_update_instance_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateNetworkProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_network_profile`](crate::client::Client::update_network_profile).
///
/// See [`crate::client::fluent_builders::UpdateNetworkProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNetworkProfile {
    _private: (),
}
impl UpdateNetworkProfile {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
    pub fn builder() -> crate::input::update_network_profile_input::Builder {
        crate::input::update_network_profile_input::Builder::default()
    }
    /// Creates a new `UpdateNetworkProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNetworkProfile {
    type Output = std::result::Result<
        crate::output::UpdateNetworkProfileOutput,
        crate::error::UpdateNetworkProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_network_profile_error(response)
        } else {
            crate::operation_deser::parse_update_network_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project`](crate::client::Client::update_project).
///
/// See [`crate::client::fluent_builders::UpdateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProject {
    _private: (),
}
impl UpdateProject {
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
    /// Creates a new `UpdateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProject {
    type Output =
        std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_error(response)
        } else {
            crate::operation_deser::parse_update_project_response(response)
        }
    }
}

/// Operation shape for `UpdateTestGridProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_test_grid_project`](crate::client::Client::update_test_grid_project).
///
/// See [`crate::client::fluent_builders::UpdateTestGridProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTestGridProject {
    _private: (),
}
impl UpdateTestGridProject {
    /// Creates a new builder-style object to manufacture [`UpdateTestGridProjectInput`](crate::input::UpdateTestGridProjectInput)
    pub fn builder() -> crate::input::update_test_grid_project_input::Builder {
        crate::input::update_test_grid_project_input::Builder::default()
    }
    /// Creates a new `UpdateTestGridProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTestGridProject {
    type Output = std::result::Result<
        crate::output::UpdateTestGridProjectOutput,
        crate::error::UpdateTestGridProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_test_grid_project_error(response)
        } else {
            crate::operation_deser::parse_update_test_grid_project_response(response)
        }
    }
}

/// Operation shape for `UpdateUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_upload`](crate::client::Client::update_upload).
///
/// See [`crate::client::fluent_builders::UpdateUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUpload {
    _private: (),
}
impl UpdateUpload {
    /// Creates a new builder-style object to manufacture [`UpdateUploadInput`](crate::input::UpdateUploadInput)
    pub fn builder() -> crate::input::update_upload_input::Builder {
        crate::input::update_upload_input::Builder::default()
    }
    /// Creates a new `UpdateUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUpload {
    type Output =
        std::result::Result<crate::output::UpdateUploadOutput, crate::error::UpdateUploadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_upload_error(response)
        } else {
            crate::operation_deser::parse_update_upload_response(response)
        }
    }
}

/// Operation shape for `UpdateVPCEConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_vpce_configuration`](crate::client::Client::update_vpce_configuration).
///
/// See [`crate::client::fluent_builders::UpdateVPCEConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVPCEConfiguration {
    _private: (),
}
impl UpdateVPCEConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateVpceConfigurationInput`](crate::input::UpdateVpceConfigurationInput)
    pub fn builder() -> crate::input::update_vpce_configuration_input::Builder {
        crate::input::update_vpce_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateVPCEConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVPCEConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateVpceConfigurationOutput,
        crate::error::UpdateVPCEConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_vpce_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_vpce_configuration_response(response)
        }
    }
}
