// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateDevicePoolInput`](crate::input::CreateDevicePoolInput)
pub mod create_device_pool_input {
    /// A builder for [`CreateDevicePoolInput`](crate::input::CreateDevicePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) max_devices: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the project for the device pool.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the project for the device pool.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The device pool's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The device pool's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The device pool's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The device pool's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The device pool's rules.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The device pool's rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
        pub fn max_devices(mut self, input: i32) -> Self {
            self.max_devices = Some(input);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.max_devices = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDevicePoolInput`](crate::input::CreateDevicePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDevicePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDevicePoolInput {
                project_arn: self.project_arn,
                name: self.name,
                description: self.description,
                rules: self.rules,
                max_devices: self.max_devices,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDevicePoolInputOperationOutputAlias = crate::operation::CreateDevicePool;
#[doc(hidden)]
pub type CreateDevicePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDevicePoolInput {
    /// Consumes the builder and constructs an Operation<[`CreateDevicePool`](crate::operation::CreateDevicePool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDevicePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDevicePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDevicePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDevicePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateDevicePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_device_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDevicePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDevicePool",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDevicePoolInput`](crate::input::CreateDevicePoolInput)
    pub fn builder() -> crate::input::create_device_pool_input::Builder {
        crate::input::create_device_pool_input::Builder::default()
    }
}

/// See [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
pub mod create_instance_profile_input {
    /// A builder for [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) package_cleanup: std::option::Option<bool>,
        pub(crate) exclude_app_packages_from_cleanup:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reboot_after_use: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of your instance profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of your instance profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of your instance profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of your instance profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is <code>false</code> for private devices.</p>
        pub fn package_cleanup(mut self, input: bool) -> Self {
            self.package_cleanup = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is <code>false</code> for private devices.</p>
        pub fn set_package_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.package_cleanup = input;
            self
        }
        /// Appends an item to `exclude_app_packages_from_cleanup`.
        ///
        /// To override the contents of this collection use [`set_exclude_app_packages_from_cleanup`](Self::set_exclude_app_packages_from_cleanup).
        ///
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.</p>
        /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to <code>true</code>.</p>
        pub fn exclude_app_packages_from_cleanup(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_app_packages_from_cleanup.unwrap_or_default();
            v.push(input.into());
            self.exclude_app_packages_from_cleanup = Some(v);
            self
        }
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.</p>
        /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to <code>true</code>.</p>
        pub fn set_exclude_app_packages_from_cleanup(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_app_packages_from_cleanup = input;
            self
        }
        /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is <code>true</code>.</p>
        pub fn reboot_after_use(mut self, input: bool) -> Self {
            self.reboot_after_use = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is <code>true</code>.</p>
        pub fn set_reboot_after_use(mut self, input: std::option::Option<bool>) -> Self {
            self.reboot_after_use = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceProfileInput {
                name: self.name,
                description: self.description,
                package_cleanup: self.package_cleanup,
                exclude_app_packages_from_cleanup: self.exclude_app_packages_from_cleanup,
                reboot_after_use: self.reboot_after_use,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceProfileInputOperationOutputAlias = crate::operation::CreateInstanceProfile;
#[doc(hidden)]
pub type CreateInstanceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstanceProfile`](crate::operation::CreateInstanceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstanceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateInstanceProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instance_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstanceProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
    pub fn builder() -> crate::input::create_instance_profile_input::Builder {
        crate::input::create_instance_profile_input::Builder::default()
    }
}

/// See [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
pub mod create_network_profile_input {
    /// A builder for [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::NetworkProfileType>,
        pub(crate) uplink_bandwidth_bits: std::option::Option<i64>,
        pub(crate) downlink_bandwidth_bits: std::option::Option<i64>,
        pub(crate) uplink_delay_ms: std::option::Option<i64>,
        pub(crate) downlink_delay_ms: std::option::Option<i64>,
        pub(crate) uplink_jitter_ms: std::option::Option<i64>,
        pub(crate) downlink_jitter_ms: std::option::Option<i64>,
        pub(crate) uplink_loss_percent: std::option::Option<i32>,
        pub(crate) downlink_loss_percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a network profile.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a network profile.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The name for the new network profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new network profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the network profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of network profile to create. Valid values are listed here.</p>
        pub fn r#type(mut self, input: crate::model::NetworkProfileType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of network profile to create. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn uplink_bandwidth_bits(mut self, input: i64) -> Self {
            self.uplink_bandwidth_bits = Some(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn set_uplink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_bandwidth_bits = input;
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn downlink_bandwidth_bits(mut self, input: i64) -> Self {
            self.downlink_bandwidth_bits = Some(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn set_downlink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_bandwidth_bits = input;
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn uplink_delay_ms(mut self, input: i64) -> Self {
            self.uplink_delay_ms = Some(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_uplink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_delay_ms = input;
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn downlink_delay_ms(mut self, input: i64) -> Self {
            self.downlink_delay_ms = Some(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_downlink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_delay_ms = input;
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn uplink_jitter_ms(mut self, input: i64) -> Self {
            self.uplink_jitter_ms = Some(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_uplink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_jitter_ms = input;
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn downlink_jitter_ms(mut self, input: i64) -> Self {
            self.downlink_jitter_ms = Some(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_downlink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_jitter_ms = input;
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
        pub fn uplink_loss_percent(mut self, input: i32) -> Self {
            self.uplink_loss_percent = Some(input);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_uplink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.uplink_loss_percent = input;
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn downlink_loss_percent(mut self, input: i32) -> Self {
            self.downlink_loss_percent = Some(input);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_downlink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.downlink_loss_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkProfileInput {
                project_arn: self.project_arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                uplink_bandwidth_bits: self.uplink_bandwidth_bits,
                downlink_bandwidth_bits: self.downlink_bandwidth_bits,
                uplink_delay_ms: self.uplink_delay_ms,
                downlink_delay_ms: self.downlink_delay_ms,
                uplink_jitter_ms: self.uplink_jitter_ms,
                downlink_jitter_ms: self.downlink_jitter_ms,
                uplink_loss_percent: self.uplink_loss_percent.unwrap_or_default(),
                downlink_loss_percent: self.downlink_loss_percent.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkProfileInputOperationOutputAlias = crate::operation::CreateNetworkProfile;
#[doc(hidden)]
pub type CreateNetworkProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkProfile`](crate::operation::CreateNetworkProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkProfileInput`](crate::input::CreateNetworkProfileInput)
    pub fn builder() -> crate::input::create_network_profile_input::Builder {
        crate::input::create_network_profile_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_job_timeout_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The project's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The project's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Sets the execution timeout value (in minutes) for a project. All test runs in this project use the specified execution timeout value unless overridden when scheduling a run.</p>
        pub fn default_job_timeout_minutes(mut self, input: i32) -> Self {
            self.default_job_timeout_minutes = Some(input);
            self
        }
        /// <p>Sets the execution timeout value (in minutes) for a project. All test runs in this project use the specified execution timeout value unless overridden when scheduling a run.</p>
        pub fn set_default_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.default_job_timeout_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                name: self.name,
                default_job_timeout_minutes: self.default_job_timeout_minutes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`CreateRemoteAccessSessionInput`](crate::input::CreateRemoteAccessSessionInput)
pub mod create_remote_access_session_input {
    /// A builder for [`CreateRemoteAccessSessionInput`](crate::input::CreateRemoteAccessSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) remote_debug_enabled: std::option::Option<bool>,
        pub(crate) remote_record_enabled: std::option::Option<bool>,
        pub(crate) remote_record_app_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) configuration:
            std::option::Option<crate::model::CreateRemoteAccessSessionConfiguration>,
        pub(crate) interaction_mode: std::option::Option<crate::model::InteractionMode>,
        pub(crate) skip_app_resign: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The ARN of the device for which you want to create a remote access session.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device for which you want to create a remote access session.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
        pub fn remote_debug_enabled(mut self, input: bool) -> Self {
            self.remote_debug_enabled = Some(input);
            self
        }
        /// <p>Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
        pub fn set_remote_debug_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_debug_enabled = input;
            self
        }
        /// <p>Set to <code>true</code> to enable remote recording for the remote access session.</p>
        pub fn remote_record_enabled(mut self, input: bool) -> Self {
            self.remote_record_enabled = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to enable remote recording for the remote access session.</p>
        pub fn set_remote_record_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_record_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.</p>
        pub fn remote_record_app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_record_app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.</p>
        pub fn set_remote_record_app_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_record_app_arn = input;
            self
        }
        /// <p>The name of the remote access session to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the remote access session to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The configuration information for the remote access session request.</p>
        pub fn configuration(
            mut self,
            input: crate::model::CreateRemoteAccessSessionConfiguration,
        ) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration information for the remote access session request.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateRemoteAccessSessionConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The interaction mode of the remote access session. Valid values are:</p>
        /// <ul>
        /// <li> <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.</p> </li>
        /// <li> <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.</p> </li>
        /// <li> <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.</p> </li>
        /// </ul>
        pub fn interaction_mode(mut self, input: crate::model::InteractionMode) -> Self {
            self.interaction_mode = Some(input);
            self
        }
        /// <p>The interaction mode of the remote access session. Valid values are:</p>
        /// <ul>
        /// <li> <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.</p> </li>
        /// <li> <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.</p> </li>
        /// <li> <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.</p> </li>
        /// </ul>
        pub fn set_interaction_mode(
            mut self,
            input: std::option::Option<crate::model::InteractionMode>,
        ) -> Self {
            self.interaction_mode = input;
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.</p>
        /// <p>For more information on how Device Farm modifies your uploads during tests, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> </p>
        pub fn skip_app_resign(mut self, input: bool) -> Self {
            self.skip_app_resign = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.</p>
        /// <p>For more information on how Device Farm modifies your uploads during tests, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> </p>
        pub fn set_skip_app_resign(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_app_resign = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRemoteAccessSessionInput`](crate::input::CreateRemoteAccessSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRemoteAccessSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRemoteAccessSessionInput {
                project_arn: self.project_arn,
                device_arn: self.device_arn,
                instance_arn: self.instance_arn,
                ssh_public_key: self.ssh_public_key,
                remote_debug_enabled: self.remote_debug_enabled,
                remote_record_enabled: self.remote_record_enabled,
                remote_record_app_arn: self.remote_record_app_arn,
                name: self.name,
                client_id: self.client_id,
                configuration: self.configuration,
                interaction_mode: self.interaction_mode,
                skip_app_resign: self.skip_app_resign,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRemoteAccessSessionInputOperationOutputAlias =
    crate::operation::CreateRemoteAccessSession;
#[doc(hidden)]
pub type CreateRemoteAccessSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRemoteAccessSessionInput {
    /// Consumes the builder and constructs an Operation<[`CreateRemoteAccessSession`](crate::operation::CreateRemoteAccessSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRemoteAccessSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRemoteAccessSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRemoteAccessSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRemoteAccessSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateRemoteAccessSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_remote_access_session(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRemoteAccessSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRemoteAccessSession",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRemoteAccessSessionInput`](crate::input::CreateRemoteAccessSessionInput)
    pub fn builder() -> crate::input::create_remote_access_session_input::Builder {
        crate::input::create_remote_access_session_input::Builder::default()
    }
}

/// See [`CreateTestGridProjectInput`](crate::input::CreateTestGridProjectInput)
pub mod create_test_grid_project_input {
    /// A builder for [`CreateTestGridProjectInput`](crate::input::CreateTestGridProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::TestGridVpcConfig>,
    }
    impl Builder {
        /// <p>Human-readable name of the Selenium testing project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Human-readable name of the Selenium testing project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Human-readable description of the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Human-readable description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn vpc_config(mut self, input: crate::model::TestGridVpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::TestGridVpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTestGridProjectInput`](crate::input::CreateTestGridProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTestGridProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTestGridProjectInput {
                name: self.name,
                description: self.description,
                vpc_config: self.vpc_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTestGridProjectInputOperationOutputAlias = crate::operation::CreateTestGridProject;
#[doc(hidden)]
pub type CreateTestGridProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTestGridProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateTestGridProject`](crate::operation::CreateTestGridProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTestGridProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTestGridProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTestGridProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTestGridProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateTestGridProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_test_grid_project(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTestGridProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTestGridProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTestGridProjectInput`](crate::input::CreateTestGridProjectInput)
    pub fn builder() -> crate::input::create_test_grid_project_input::Builder {
        crate::input::create_test_grid_project_input::Builder::default()
    }
}

/// See [`CreateTestGridUrlInput`](crate::input::CreateTestGridUrlInput)
pub mod create_test_grid_url_input {
    /// A builder for [`CreateTestGridUrlInput`](crate::input::CreateTestGridUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) expires_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>ARN (from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>) to associate with the short-term URL. </p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>ARN (from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>) to associate with the short-term URL. </p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>Lifetime, in seconds, of the URL.</p>
        pub fn expires_in_seconds(mut self, input: i32) -> Self {
            self.expires_in_seconds = Some(input);
            self
        }
        /// <p>Lifetime, in seconds, of the URL.</p>
        pub fn set_expires_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.expires_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTestGridUrlInput`](crate::input::CreateTestGridUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTestGridUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTestGridUrlInput {
                project_arn: self.project_arn,
                expires_in_seconds: self.expires_in_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTestGridUrlInputOperationOutputAlias = crate::operation::CreateTestGridUrl;
#[doc(hidden)]
pub type CreateTestGridUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTestGridUrlInput {
    /// Consumes the builder and constructs an Operation<[`CreateTestGridUrl`](crate::operation::CreateTestGridUrl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTestGridUrl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTestGridUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTestGridUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTestGridUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateTestGridUrl",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_test_grid_url(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTestGridUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTestGridUrl",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTestGridUrlInput`](crate::input::CreateTestGridUrlInput)
    pub fn builder() -> crate::input::create_test_grid_url_input::Builder {
        crate::input::create_test_grid_url_input::Builder::default()
    }
}

/// See [`CreateUploadInput`](crate::input::CreateUploadInput)
pub mod create_upload_input {
    /// A builder for [`CreateUploadInput`](crate::input::CreateUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UploadType>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the project for the upload.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the project for the upload.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The upload's file name. The name should not contain any forward slashes (<code>/</code>). If you are uploading an iOS app, the file name must end with the <code>.ipa</code> extension. If you are uploading an Android app, the file name must end with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The upload's file name. The name should not contain any forward slashes (<code>/</code>). If you are uploading an iOS app, the file name must end with the <code>.ipa</code> extension. If you are uploading an Android app, the file name must end with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The upload's upload type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li> <p>ANDROID_APP</p> </li>
        /// <li> <p>IOS_APP</p> </li>
        /// <li> <p>WEB_APP</p> </li>
        /// <li> <p>EXTERNAL_DATA</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
        /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
        /// </ul>
        /// <p> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an <code>ArgumentException</code> error.</p>
        pub fn r#type(mut self, input: crate::model::UploadType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The upload's upload type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li> <p>ANDROID_APP</p> </li>
        /// <li> <p>IOS_APP</p> </li>
        /// <li> <p>WEB_APP</p> </li>
        /// <li> <p>EXTERNAL_DATA</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
        /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
        /// </ul>
        /// <p> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an <code>ArgumentException</code> error.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UploadType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUploadInput`](crate::input::CreateUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUploadInput {
                project_arn: self.project_arn,
                name: self.name,
                r#type: self.r#type,
                content_type: self.content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUploadInputOperationOutputAlias = crate::operation::CreateUpload;
#[doc(hidden)]
pub type CreateUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUploadInput {
    /// Consumes the builder and constructs an Operation<[`CreateUpload`](crate::operation::CreateUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_upload(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUpload",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUploadInput`](crate::input::CreateUploadInput)
    pub fn builder() -> crate::input::create_upload_input::Builder {
        crate::input::create_upload_input::Builder::default()
    }
}

/// See [`CreateVpceConfigurationInput`](crate::input::CreateVpceConfigurationInput)
pub mod create_vpce_configuration_input {
    /// A builder for [`CreateVpceConfigurationInput`](crate::input::CreateVpceConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpce_configuration_name: std::option::Option<std::string::String>,
        pub(crate) vpce_service_name: std::option::Option<std::string::String>,
        pub(crate) service_dns_name: std::option::Option<std::string::String>,
        pub(crate) vpce_configuration_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.</p>
        pub fn vpce_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_configuration_name = Some(input.into());
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.</p>
        pub fn set_vpce_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_configuration_name = input;
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn vpce_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_service_name = Some(input.into());
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn set_vpce_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_service_name = input;
            self
        }
        /// <p>The DNS name of the service running in your VPC that you want Device Farm to test.</p>
        pub fn service_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the service running in your VPC that you want Device Farm to test.</p>
        pub fn set_service_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_dns_name = input;
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn vpce_configuration_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.vpce_configuration_description = Some(input.into());
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_configuration_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpceConfigurationInput`](crate::input::CreateVpceConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVpceConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVpceConfigurationInput {
                vpce_configuration_name: self.vpce_configuration_name,
                vpce_service_name: self.vpce_service_name,
                service_dns_name: self.service_dns_name,
                vpce_configuration_description: self.vpce_configuration_description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVpceConfigurationInputOperationOutputAlias =
    crate::operation::CreateVPCEConfiguration;
#[doc(hidden)]
pub type CreateVpceConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVpceConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateVPCEConfiguration`](crate::operation::CreateVPCEConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVPCEConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVpceConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVpceConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVpceConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.CreateVPCEConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_vpce_configuration(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVPCEConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVPCEConfiguration",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVpceConfigurationInput`](crate::input::CreateVpceConfigurationInput)
    pub fn builder() -> crate::input::create_vpce_configuration_input::Builder {
        crate::input::create_vpce_configuration_input::Builder::default()
    }
}

/// See [`DeleteDevicePoolInput`](crate::input::DeleteDevicePoolInput)
pub mod delete_device_pool_input {
    /// A builder for [`DeleteDevicePoolInput`](crate::input::DeleteDevicePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDevicePoolInput`](crate::input::DeleteDevicePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDevicePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDevicePoolInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteDevicePoolInputOperationOutputAlias = crate::operation::DeleteDevicePool;
#[doc(hidden)]
pub type DeleteDevicePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDevicePoolInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDevicePool`](crate::operation::DeleteDevicePool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDevicePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDevicePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDevicePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDevicePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteDevicePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_device_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDevicePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDevicePool",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDevicePoolInput`](crate::input::DeleteDevicePoolInput)
    pub fn builder() -> crate::input::delete_device_pool_input::Builder {
        crate::input::delete_device_pool_input::Builder::default()
    }
}

/// See [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
pub mod delete_instance_profile_input {
    /// A builder for [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instance profile you are requesting to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile you are requesting to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInstanceProfileInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceProfileInputOperationOutputAlias = crate::operation::DeleteInstanceProfile;
#[doc(hidden)]
pub type DeleteInstanceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstanceProfile`](crate::operation::DeleteInstanceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstanceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteInstanceProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_instance_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstanceProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
    pub fn builder() -> crate::input::delete_instance_profile_input::Builder {
        crate::input::delete_instance_profile_input::Builder::default()
    }
}

/// See [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
pub mod delete_network_profile_input {
    /// A builder for [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network profile to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNetworkProfileInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteNetworkProfileInputOperationOutputAlias = crate::operation::DeleteNetworkProfile;
#[doc(hidden)]
pub type DeleteNetworkProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNetworkProfile`](crate::operation::DeleteNetworkProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNetworkProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_network_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNetworkProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNetworkProfileInput`](crate::input::DeleteNetworkProfileInput)
    pub fn builder() -> crate::input::delete_network_profile_input::Builder {
        crate::input::delete_network_profile_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DeleteRemoteAccessSessionInput`](crate::input::DeleteRemoteAccessSessionInput)
pub mod delete_remote_access_session_input {
    /// A builder for [`DeleteRemoteAccessSessionInput`](crate::input::DeleteRemoteAccessSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the session for which you want to delete remote access.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session for which you want to delete remote access.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRemoteAccessSessionInput`](crate::input::DeleteRemoteAccessSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRemoteAccessSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRemoteAccessSessionInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteRemoteAccessSessionInputOperationOutputAlias =
    crate::operation::DeleteRemoteAccessSession;
#[doc(hidden)]
pub type DeleteRemoteAccessSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRemoteAccessSessionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRemoteAccessSession`](crate::operation::DeleteRemoteAccessSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRemoteAccessSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRemoteAccessSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRemoteAccessSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRemoteAccessSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteRemoteAccessSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_remote_access_session(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRemoteAccessSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRemoteAccessSession",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRemoteAccessSessionInput`](crate::input::DeleteRemoteAccessSessionInput)
    pub fn builder() -> crate::input::delete_remote_access_session_input::Builder {
        crate::input::delete_remote_access_session_input::Builder::default()
    }
}

/// See [`DeleteRunInput`](crate::input::DeleteRunInput)
pub mod delete_run_input {
    /// A builder for [`DeleteRunInput`](crate::input::DeleteRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the run to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the run to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRunInput`](crate::input::DeleteRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteRunInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteRunInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteRunInputOperationOutputAlias = crate::operation::DeleteRun;
#[doc(hidden)]
pub type DeleteRunInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRunInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRun`](crate::operation::DeleteRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRun,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_run(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteRun::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteRun",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRunInput`](crate::input::DeleteRunInput)
    pub fn builder() -> crate::input::delete_run_input::Builder {
        crate::input::delete_run_input::Builder::default()
    }
}

/// See [`DeleteTestGridProjectInput`](crate::input::DeleteTestGridProjectInput)
pub mod delete_test_grid_project_input {
    /// A builder for [`DeleteTestGridProjectInput`](crate::input::DeleteTestGridProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the project to delete, from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the project to delete, from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTestGridProjectInput`](crate::input::DeleteTestGridProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTestGridProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTestGridProjectInput {
                project_arn: self.project_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTestGridProjectInputOperationOutputAlias = crate::operation::DeleteTestGridProject;
#[doc(hidden)]
pub type DeleteTestGridProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTestGridProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTestGridProject`](crate::operation::DeleteTestGridProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTestGridProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTestGridProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTestGridProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTestGridProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteTestGridProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_test_grid_project(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTestGridProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTestGridProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTestGridProjectInput`](crate::input::DeleteTestGridProjectInput)
    pub fn builder() -> crate::input::delete_test_grid_project_input::Builder {
        crate::input::delete_test_grid_project_input::Builder::default()
    }
}

/// See [`DeleteUploadInput`](crate::input::DeleteUploadInput)
pub mod delete_upload_input {
    /// A builder for [`DeleteUploadInput`](crate::input::DeleteUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUploadInput`](crate::input::DeleteUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUploadInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteUploadInputOperationOutputAlias = crate::operation::DeleteUpload;
#[doc(hidden)]
pub type DeleteUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUploadInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUpload`](crate::operation::DeleteUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_upload(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUpload",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUploadInput`](crate::input::DeleteUploadInput)
    pub fn builder() -> crate::input::delete_upload_input::Builder {
        crate::input::delete_upload_input::Builder::default()
    }
}

/// See [`DeleteVpceConfigurationInput`](crate::input::DeleteVpceConfigurationInput)
pub mod delete_vpce_configuration_input {
    /// A builder for [`DeleteVpceConfigurationInput`](crate::input::DeleteVpceConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVpceConfigurationInput`](crate::input::DeleteVpceConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVpceConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVpceConfigurationInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteVpceConfigurationInputOperationOutputAlias =
    crate::operation::DeleteVPCEConfiguration;
#[doc(hidden)]
pub type DeleteVpceConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVpceConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVPCEConfiguration`](crate::operation::DeleteVPCEConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVPCEConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVpceConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVpceConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVpceConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.DeleteVPCEConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_vpce_configuration(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVPCEConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVPCEConfiguration",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVpceConfigurationInput`](crate::input::DeleteVpceConfigurationInput)
    pub fn builder() -> crate::input::delete_vpce_configuration_input::Builder {
        crate::input::delete_vpce_configuration_input::Builder::default()
    }
}

/// See [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
pub mod get_account_settings_input {
    /// A builder for [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountSettingsInputOperationOutputAlias = crate::operation::GetAccountSettings;
#[doc(hidden)]
pub type GetAccountSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountSettings`](crate::operation::GetAccountSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetAccountSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_account_settings(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountSettings",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
}

/// See [`GetDeviceInput`](crate::input::GetDeviceInput)
pub mod get_device_input {
    /// A builder for [`GetDeviceInput`](crate::input::GetDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device type's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The device type's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceInput`](crate::input::GetDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDeviceInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDeviceInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceInputOperationOutputAlias = crate::operation::GetDevice;
#[doc(hidden)]
pub type GetDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeviceInput {
    /// Consumes the builder and constructs an Operation<[`GetDevice`](crate::operation::GetDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_device(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDevice::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDevice",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceInput`](crate::input::GetDeviceInput)
    pub fn builder() -> crate::input::get_device_input::Builder {
        crate::input::get_device_input::Builder::default()
    }
}

/// See [`GetDeviceInstanceInput`](crate::input::GetDeviceInstanceInput)
pub mod get_device_instance_input {
    /// A builder for [`GetDeviceInstanceInput`](crate::input::GetDeviceInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instance you're requesting information about.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance you're requesting information about.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceInstanceInput`](crate::input::GetDeviceInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeviceInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeviceInstanceInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceInstanceInputOperationOutputAlias = crate::operation::GetDeviceInstance;
#[doc(hidden)]
pub type GetDeviceInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeviceInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetDeviceInstance`](crate::operation::GetDeviceInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeviceInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetDeviceInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_device_instance(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeviceInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeviceInstance",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceInstanceInput`](crate::input::GetDeviceInstanceInput)
    pub fn builder() -> crate::input::get_device_instance_input::Builder {
        crate::input::get_device_instance_input::Builder::default()
    }
}

/// See [`GetDevicePoolInput`](crate::input::GetDevicePoolInput)
pub mod get_device_pool_input {
    /// A builder for [`GetDevicePoolInput`](crate::input::GetDevicePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device pool's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The device pool's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePoolInput`](crate::input::GetDevicePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDevicePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDevicePoolInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetDevicePoolInputOperationOutputAlias = crate::operation::GetDevicePool;
#[doc(hidden)]
pub type GetDevicePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDevicePoolInput {
    /// Consumes the builder and constructs an Operation<[`GetDevicePool`](crate::operation::GetDevicePool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevicePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDevicePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDevicePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDevicePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetDevicePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_device_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDevicePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDevicePool",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDevicePoolInput`](crate::input::GetDevicePoolInput)
    pub fn builder() -> crate::input::get_device_pool_input::Builder {
        crate::input::get_device_pool_input::Builder::default()
    }
}

/// See [`GetDevicePoolCompatibilityInput`](crate::input::GetDevicePoolCompatibilityInput)
pub mod get_device_pool_compatibility_input {
    /// A builder for [`GetDevicePoolCompatibilityInput`](crate::input::GetDevicePoolCompatibilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_pool_arn: std::option::Option<std::string::String>,
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) test_type: std::option::Option<crate::model::TestType>,
        pub(crate) test: std::option::Option<crate::model::ScheduleRunTest>,
        pub(crate) configuration: std::option::Option<crate::model::ScheduleRunConfiguration>,
    }
    impl Builder {
        /// <p>The device pool's ARN.</p>
        pub fn device_pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_pool_arn = Some(input.into());
            self
        }
        /// <p>The device pool's ARN.</p>
        pub fn set_device_pool_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_pool_arn = input;
            self
        }
        /// <p>The ARN of the app that is associated with the specified device pool.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the app that is associated with the specified device pool.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The test type for the specified device pool.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li> <p>BUILTIN_FUZZ.</p> </li>
        /// <li> <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT.</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG.</p> </li>
        /// <li> <p>APPIUM_PYTHON.</p> </li>
        /// <li> <p>APPIUM_NODE.</p> </li>
        /// <li> <p>APPIUM_RUBY.</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT.</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG.</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON.</p> </li>
        /// <li> <p>APPIUM_WEB_NODE.</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY.</p> </li>
        /// <li> <p>CALABASH.</p> </li>
        /// <li> <p>INSTRUMENTATION.</p> </li>
        /// <li> <p>UIAUTOMATION.</p> </li>
        /// <li> <p>UIAUTOMATOR.</p> </li>
        /// <li> <p>XCTEST.</p> </li>
        /// <li> <p>XCTEST_UI.</p> </li>
        /// </ul>
        pub fn test_type(mut self, input: crate::model::TestType) -> Self {
            self.test_type = Some(input);
            self
        }
        /// <p>The test type for the specified device pool.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li> <p>BUILTIN_FUZZ.</p> </li>
        /// <li> <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT.</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG.</p> </li>
        /// <li> <p>APPIUM_PYTHON.</p> </li>
        /// <li> <p>APPIUM_NODE.</p> </li>
        /// <li> <p>APPIUM_RUBY.</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT.</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG.</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON.</p> </li>
        /// <li> <p>APPIUM_WEB_NODE.</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY.</p> </li>
        /// <li> <p>CALABASH.</p> </li>
        /// <li> <p>INSTRUMENTATION.</p> </li>
        /// <li> <p>UIAUTOMATION.</p> </li>
        /// <li> <p>UIAUTOMATOR.</p> </li>
        /// <li> <p>XCTEST.</p> </li>
        /// <li> <p>XCTEST_UI.</p> </li>
        /// </ul>
        pub fn set_test_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.test_type = input;
            self
        }
        /// <p>Information about the uploaded test to be run against the device pool.</p>
        pub fn test(mut self, input: crate::model::ScheduleRunTest) -> Self {
            self.test = Some(input);
            self
        }
        /// <p>Information about the uploaded test to be run against the device pool.</p>
        pub fn set_test(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunTest>,
        ) -> Self {
            self.test = input;
            self
        }
        /// <p>An object that contains information about the settings for a run.</p>
        pub fn configuration(mut self, input: crate::model::ScheduleRunConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>An object that contains information about the settings for a run.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePoolCompatibilityInput`](crate::input::GetDevicePoolCompatibilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDevicePoolCompatibilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDevicePoolCompatibilityInput {
                device_pool_arn: self.device_pool_arn,
                app_arn: self.app_arn,
                test_type: self.test_type,
                test: self.test,
                configuration: self.configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDevicePoolCompatibilityInputOperationOutputAlias =
    crate::operation::GetDevicePoolCompatibility;
#[doc(hidden)]
pub type GetDevicePoolCompatibilityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDevicePoolCompatibilityInput {
    /// Consumes the builder and constructs an Operation<[`GetDevicePoolCompatibility`](crate::operation::GetDevicePoolCompatibility)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevicePoolCompatibility,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDevicePoolCompatibilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDevicePoolCompatibilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDevicePoolCompatibilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetDevicePoolCompatibility",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_device_pool_compatibility(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDevicePoolCompatibility::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDevicePoolCompatibility",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDevicePoolCompatibilityInput`](crate::input::GetDevicePoolCompatibilityInput)
    pub fn builder() -> crate::input::get_device_pool_compatibility_input::Builder {
        crate::input::get_device_pool_compatibility_input::Builder::default()
    }
}

/// See [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
pub mod get_instance_profile_input {
    /// A builder for [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an instance profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceProfileInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceProfileInputOperationOutputAlias = crate::operation::GetInstanceProfile;
#[doc(hidden)]
pub type GetInstanceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceProfile`](crate::operation::GetInstanceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetInstanceProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_profile(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
    pub fn builder() -> crate::input::get_instance_profile_input::Builder {
        crate::input::get_instance_profile_input::Builder::default()
    }
}

/// See [`GetJobInput`](crate::input::GetJobInput)
pub mod get_job_input {
    /// A builder for [`GetJobInput`](crate::input::GetJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The job's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobInput`](crate::input::GetJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetJobInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetJobInputOperationOutputAlias = crate::operation::GetJob;
#[doc(hidden)]
pub type GetJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobInput {
    /// Consumes the builder and constructs an Operation<[`GetJob`](crate::operation::GetJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetJob",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
}

/// See [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
pub mod get_network_profile_input {
    /// A builder for [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the network profile to return information about.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the network profile to return information about.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNetworkProfileInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetNetworkProfileInputOperationOutputAlias = crate::operation::GetNetworkProfile;
#[doc(hidden)]
pub type GetNetworkProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetNetworkProfile`](crate::operation::GetNetworkProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNetworkProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_network_profile(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNetworkProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNetworkProfileInput`](crate::input::GetNetworkProfileInput)
    pub fn builder() -> crate::input::get_network_profile_input::Builder {
        crate::input::get_network_profile_input::Builder::default()
    }
}

/// See [`GetOfferingStatusInput`](crate::input::GetOfferingStatusInput)
pub mod get_offering_status_input {
    /// A builder for [`GetOfferingStatusInput`](crate::input::GetOfferingStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOfferingStatusInput`](crate::input::GetOfferingStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOfferingStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOfferingStatusInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOfferingStatusInputOperationOutputAlias = crate::operation::GetOfferingStatus;
#[doc(hidden)]
pub type GetOfferingStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOfferingStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetOfferingStatus`](crate::operation::GetOfferingStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOfferingStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOfferingStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOfferingStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOfferingStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetOfferingStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_offering_status(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOfferingStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOfferingStatus",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOfferingStatusInput`](crate::input::GetOfferingStatusInput)
    pub fn builder() -> crate::input::get_offering_status_input::Builder {
        crate::input::get_offering_status_input::Builder::default()
    }
}

/// See [`GetProjectInput`](crate::input::GetProjectInput)
pub mod get_project_input {
    /// A builder for [`GetProjectInput`](crate::input::GetProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The project's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The project's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProjectInput`](crate::input::GetProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProjectInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetProjectInputOperationOutputAlias = crate::operation::GetProject;
#[doc(hidden)]
pub type GetProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetProjectInput {
    /// Consumes the builder and constructs an Operation<[`GetProject`](crate::operation::GetProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetProjectInput`](crate::input::GetProjectInput)
    pub fn builder() -> crate::input::get_project_input::Builder {
        crate::input::get_project_input::Builder::default()
    }
}

/// See [`GetRemoteAccessSessionInput`](crate::input::GetRemoteAccessSessionInput)
pub mod get_remote_access_session_input {
    /// A builder for [`GetRemoteAccessSessionInput`](crate::input::GetRemoteAccessSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you want to get session information.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you want to get session information.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRemoteAccessSessionInput`](crate::input::GetRemoteAccessSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRemoteAccessSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRemoteAccessSessionInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetRemoteAccessSessionInputOperationOutputAlias = crate::operation::GetRemoteAccessSession;
#[doc(hidden)]
pub type GetRemoteAccessSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRemoteAccessSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetRemoteAccessSession`](crate::operation::GetRemoteAccessSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRemoteAccessSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRemoteAccessSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRemoteAccessSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRemoteAccessSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetRemoteAccessSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_remote_access_session(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRemoteAccessSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRemoteAccessSession",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRemoteAccessSessionInput`](crate::input::GetRemoteAccessSessionInput)
    pub fn builder() -> crate::input::get_remote_access_session_input::Builder {
        crate::input::get_remote_access_session_input::Builder::default()
    }
}

/// See [`GetRunInput`](crate::input::GetRunInput)
pub mod get_run_input {
    /// A builder for [`GetRunInput`](crate::input::GetRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The run's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The run's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRunInput`](crate::input::GetRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRunInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRunInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetRunInputOperationOutputAlias = crate::operation::GetRun;
#[doc(hidden)]
pub type GetRunInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRunInput {
    /// Consumes the builder and constructs an Operation<[`GetRun`](crate::operation::GetRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRun,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_run(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRun::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRun",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRunInput`](crate::input::GetRunInput)
    pub fn builder() -> crate::input::get_run_input::Builder {
        crate::input::get_run_input::Builder::default()
    }
}

/// See [`GetSuiteInput`](crate::input::GetSuiteInput)
pub mod get_suite_input {
    /// A builder for [`GetSuiteInput`](crate::input::GetSuiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The suite's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The suite's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteInput`](crate::input::GetSuiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetSuiteInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetSuiteInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetSuiteInputOperationOutputAlias = crate::operation::GetSuite;
#[doc(hidden)]
pub type GetSuiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSuiteInput {
    /// Consumes the builder and constructs an Operation<[`GetSuite`](crate::operation::GetSuite)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSuite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSuiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSuiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSuiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetSuite",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_suite(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetSuite::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetSuite",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSuiteInput`](crate::input::GetSuiteInput)
    pub fn builder() -> crate::input::get_suite_input::Builder {
        crate::input::get_suite_input::Builder::default()
    }
}

/// See [`GetTestInput`](crate::input::GetTestInput)
pub mod get_test_input {
    /// A builder for [`GetTestInput`](crate::input::GetTestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The test's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The test's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTestInput`](crate::input::GetTestInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTestInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTestInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetTestInputOperationOutputAlias = crate::operation::GetTest;
#[doc(hidden)]
pub type GetTestInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTestInput {
    /// Consumes the builder and constructs an Operation<[`GetTest`](crate::operation::GetTest)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetTest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_test(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTest::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTest",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTestInput`](crate::input::GetTestInput)
    pub fn builder() -> crate::input::get_test_input::Builder {
        crate::input::get_test_input::Builder::default()
    }
}

/// See [`GetTestGridProjectInput`](crate::input::GetTestGridProjectInput)
pub mod get_test_grid_project_input {
    /// A builder for [`GetTestGridProjectInput`](crate::input::GetTestGridProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Selenium testing project, from either <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Selenium testing project, from either <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTestGridProjectInput`](crate::input::GetTestGridProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTestGridProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTestGridProjectInput {
                project_arn: self.project_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTestGridProjectInputOperationOutputAlias = crate::operation::GetTestGridProject;
#[doc(hidden)]
pub type GetTestGridProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTestGridProjectInput {
    /// Consumes the builder and constructs an Operation<[`GetTestGridProject`](crate::operation::GetTestGridProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTestGridProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTestGridProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTestGridProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTestGridProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetTestGridProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_test_grid_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTestGridProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTestGridProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTestGridProjectInput`](crate::input::GetTestGridProjectInput)
    pub fn builder() -> crate::input::get_test_grid_project_input::Builder {
        crate::input::get_test_grid_project_input::Builder::default()
    }
}

/// See [`GetTestGridSessionInput`](crate::input::GetTestGridSessionInput)
pub mod get_test_grid_session_input {
    /// A builder for [`GetTestGridSessionInput`](crate::input::GetTestGridSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) session_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the project that this session belongs to. See <code>CreateTestGridProject</code> and <code>ListTestGridProjects</code>.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the project that this session belongs to. See <code>CreateTestGridProject</code> and <code>ListTestGridProjects</code>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>An ID associated with this session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>An ID associated with this session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>An ARN that uniquely identifies a <code>TestGridSession</code>.</p>
        pub fn session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_arn = Some(input.into());
            self
        }
        /// <p>An ARN that uniquely identifies a <code>TestGridSession</code>.</p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTestGridSessionInput`](crate::input::GetTestGridSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTestGridSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTestGridSessionInput {
                project_arn: self.project_arn,
                session_id: self.session_id,
                session_arn: self.session_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTestGridSessionInputOperationOutputAlias = crate::operation::GetTestGridSession;
#[doc(hidden)]
pub type GetTestGridSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTestGridSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetTestGridSession`](crate::operation::GetTestGridSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTestGridSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTestGridSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTestGridSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTestGridSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetTestGridSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_test_grid_session(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTestGridSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTestGridSession",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTestGridSessionInput`](crate::input::GetTestGridSessionInput)
    pub fn builder() -> crate::input::get_test_grid_session_input::Builder {
        crate::input::get_test_grid_session_input::Builder::default()
    }
}

/// See [`GetUploadInput`](crate::input::GetUploadInput)
pub mod get_upload_input {
    /// A builder for [`GetUploadInput`](crate::input::GetUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The upload's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The upload's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUploadInput`](crate::input::GetUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetUploadInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetUploadInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetUploadInputOperationOutputAlias = crate::operation::GetUpload;
#[doc(hidden)]
pub type GetUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUploadInput {
    /// Consumes the builder and constructs an Operation<[`GetUpload`](crate::operation::GetUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_upload(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetUpload::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetUpload",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUploadInput`](crate::input::GetUploadInput)
    pub fn builder() -> crate::input::get_upload_input::Builder {
        crate::input::get_upload_input::Builder::default()
    }
}

/// See [`GetVpceConfigurationInput`](crate::input::GetVpceConfigurationInput)
pub mod get_vpce_configuration_input {
    /// A builder for [`GetVpceConfigurationInput`](crate::input::GetVpceConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to describe.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to describe.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpceConfigurationInput`](crate::input::GetVpceConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVpceConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVpceConfigurationInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetVpceConfigurationInputOperationOutputAlias = crate::operation::GetVPCEConfiguration;
#[doc(hidden)]
pub type GetVpceConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetVpceConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetVPCEConfiguration`](crate::operation::GetVPCEConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVPCEConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVpceConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVpceConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVpceConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.GetVPCEConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_vpce_configuration(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVPCEConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVPCEConfiguration",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVpceConfigurationInput`](crate::input::GetVpceConfigurationInput)
    pub fn builder() -> crate::input::get_vpce_configuration_input::Builder {
        crate::input::get_vpce_configuration_input::Builder::default()
    }
}

/// See [`InstallToRemoteAccessSessionInput`](crate::input::InstallToRemoteAccessSessionInput)
pub mod install_to_remote_access_session_input {
    /// A builder for [`InstallToRemoteAccessSessionInput`](crate::input::InstallToRemoteAccessSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remote_access_session_arn: std::option::Option<std::string::String>,
        pub(crate) app_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.</p>
        pub fn remote_access_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_access_session_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.</p>
        pub fn set_remote_access_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_access_session_arn = input;
            self
        }
        /// <p>The ARN of the app about which you are requesting information.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the app about which you are requesting information.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`InstallToRemoteAccessSessionInput`](crate::input::InstallToRemoteAccessSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InstallToRemoteAccessSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InstallToRemoteAccessSessionInput {
                remote_access_session_arn: self.remote_access_session_arn,
                app_arn: self.app_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type InstallToRemoteAccessSessionInputOperationOutputAlias =
    crate::operation::InstallToRemoteAccessSession;
#[doc(hidden)]
pub type InstallToRemoteAccessSessionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl InstallToRemoteAccessSessionInput {
    /// Consumes the builder and constructs an Operation<[`InstallToRemoteAccessSession`](crate::operation::InstallToRemoteAccessSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InstallToRemoteAccessSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InstallToRemoteAccessSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InstallToRemoteAccessSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InstallToRemoteAccessSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.InstallToRemoteAccessSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_install_to_remote_access_session(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InstallToRemoteAccessSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InstallToRemoteAccessSession",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InstallToRemoteAccessSessionInput`](crate::input::InstallToRemoteAccessSessionInput)
    pub fn builder() -> crate::input::install_to_remote_access_session_input::Builder {
        crate::input::install_to_remote_access_session_input::Builder::default()
    }
}

/// See [`ListArtifactsInput`](crate::input::ListArtifactsInput)
pub mod list_artifacts_input {
    /// A builder for [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ArtifactCategory>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The run, job, suite, or test ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The run, job, suite, or test ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The artifacts' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li> <p>FILE</p> </li>
        /// <li> <p>LOG</p> </li>
        /// <li> <p>SCREENSHOT</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ArtifactCategory) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The artifacts' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li> <p>FILE</p> </li>
        /// <li> <p>LOG</p> </li>
        /// <li> <p>SCREENSHOT</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ArtifactCategory>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArtifactsInput`](crate::input::ListArtifactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListArtifactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListArtifactsInput {
                arn: self.arn,
                r#type: self.r#type,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListArtifactsInputOperationOutputAlias = crate::operation::ListArtifacts;
#[doc(hidden)]
pub type ListArtifactsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListArtifactsInput {
    /// Consumes the builder and constructs an Operation<[`ListArtifacts`](crate::operation::ListArtifacts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListArtifacts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListArtifactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListArtifactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListArtifactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListArtifacts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_artifacts(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListArtifacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListArtifacts",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    pub fn builder() -> crate::input::list_artifacts_input::Builder {
        crate::input::list_artifacts_input::Builder::default()
    }
}

/// See [`ListDeviceInstancesInput`](crate::input::ListDeviceInstancesInput)
pub mod list_device_instances_input {
    /// A builder for [`ListDeviceInstancesInput`](crate::input::ListDeviceInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceInstancesInput`](crate::input::ListDeviceInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeviceInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeviceInstancesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeviceInstancesInputOperationOutputAlias = crate::operation::ListDeviceInstances;
#[doc(hidden)]
pub type ListDeviceInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeviceInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListDeviceInstances`](crate::operation::ListDeviceInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeviceInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeviceInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeviceInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeviceInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListDeviceInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_device_instances(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeviceInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeviceInstances",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeviceInstancesInput`](crate::input::ListDeviceInstancesInput)
    pub fn builder() -> crate::input::list_device_instances_input::Builder {
        crate::input::list_device_instances_input::Builder::default()
    }
}

/// See [`ListDevicePoolsInput`](crate::input::ListDevicePoolsInput)
pub mod list_device_pools_input {
    /// A builder for [`ListDevicePoolsInput`](crate::input::ListDevicePoolsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DevicePoolType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The project ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The project ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The device pools' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li> <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p> </li>
        /// <li> <p>PRIVATE: A device pool that is created and managed by the device pool developer.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::DevicePoolType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The device pools' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li> <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p> </li>
        /// <li> <p>PRIVATE: A device pool that is created and managed by the device pool developer.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DevicePoolType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicePoolsInput`](crate::input::ListDevicePoolsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicePoolsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicePoolsInput {
                arn: self.arn,
                r#type: self.r#type,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicePoolsInputOperationOutputAlias = crate::operation::ListDevicePools;
#[doc(hidden)]
pub type ListDevicePoolsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDevicePoolsInput {
    /// Consumes the builder and constructs an Operation<[`ListDevicePools`](crate::operation::ListDevicePools)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevicePools,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevicePoolsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevicePoolsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevicePoolsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListDevicePools",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_device_pools(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevicePools::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevicePools",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevicePoolsInput`](crate::input::ListDevicePoolsInput)
    pub fn builder() -> crate::input::list_device_pools_input::Builder {
        crate::input::list_device_pools_input::Builder::default()
    }
}

/// See [`ListDevicesInput`](crate::input::ListDevicesInput)
pub mod list_devices_input {
    /// A builder for [`ListDevicesInput`](crate::input::ListDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.</p>
        /// <ul>
        /// <li> <p>Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.</p> <p>Allowed values include:</p>
        /// <ul>
        /// <li> <p>ARN: The Amazon Resource Name (ARN) of the device (for example, <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p> </li>
        /// <li> <p>PLATFORM: The device platform. Valid values are ANDROID or IOS.</p> </li>
        /// <li> <p>OS_VERSION: The operating system version (for example, 10.3.2).</p> </li>
        /// <li> <p>MODEL: The device model (for example, iPad 5th Gen).</p> </li>
        /// <li> <p>AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
        /// <li> <p>FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.</p> </li>
        /// <li> <p>MANUFACTURER: The device manufacturer (for example, Apple).</p> </li>
        /// <li> <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.</p> </li>
        /// <li> <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>, this attribute is ignored.</p> </li>
        /// <li> <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.</p> </li>
        /// <li> <p>INSTANCE_LABELS: The label of the device instance.</p> </li>
        /// <li> <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p> </li>
        /// </ul> </li>
        /// <li> <p>Operator: The filter operator.</p>
        /// <ul>
        /// <li> <p>The EQUALS operator is available for every attribute except INSTANCE_LABELS.</p> </li>
        /// <li> <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.</p> </li>
        /// <li> <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p> </li>
        /// <li> <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION attribute.</p> </li>
        /// </ul> </li>
        /// <li> <p>Values: An array of one or more filter values.</p>
        /// <ul>
        /// <li> <p>The IN and NOT_IN operators take a values array that has one or more elements.</p> </li>
        /// <li> <p>The other operators require an array with a single element.</p> </li>
        /// <li> <p>In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::DeviceFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.</p>
        /// <ul>
        /// <li> <p>Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.</p> <p>Allowed values include:</p>
        /// <ul>
        /// <li> <p>ARN: The Amazon Resource Name (ARN) of the device (for example, <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p> </li>
        /// <li> <p>PLATFORM: The device platform. Valid values are ANDROID or IOS.</p> </li>
        /// <li> <p>OS_VERSION: The operating system version (for example, 10.3.2).</p> </li>
        /// <li> <p>MODEL: The device model (for example, iPad 5th Gen).</p> </li>
        /// <li> <p>AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
        /// <li> <p>FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.</p> </li>
        /// <li> <p>MANUFACTURER: The device manufacturer (for example, Apple).</p> </li>
        /// <li> <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.</p> </li>
        /// <li> <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>, this attribute is ignored.</p> </li>
        /// <li> <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.</p> </li>
        /// <li> <p>INSTANCE_LABELS: The label of the device instance.</p> </li>
        /// <li> <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p> </li>
        /// </ul> </li>
        /// <li> <p>Operator: The filter operator.</p>
        /// <ul>
        /// <li> <p>The EQUALS operator is available for every attribute except INSTANCE_LABELS.</p> </li>
        /// <li> <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.</p> </li>
        /// <li> <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p> </li>
        /// <li> <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION attribute.</p> </li>
        /// </ul> </li>
        /// <li> <p>Values: An array of one or more filter values.</p>
        /// <ul>
        /// <li> <p>The IN and NOT_IN operators take a values array that has one or more elements.</p> </li>
        /// <li> <p>The other operators require an array with a single element.</p> </li>
        /// <li> <p>In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesInput`](crate::input::ListDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicesInput {
                arn: self.arn,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicesInputOperationOutputAlias = crate::operation::ListDevices;
#[doc(hidden)]
pub type ListDevicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListDevices`](crate::operation::ListDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListDevices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_devices(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevices",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
}

/// See [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
pub mod list_instance_profiles_input {
    /// A builder for [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceProfilesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceProfilesInputOperationOutputAlias = crate::operation::ListInstanceProfiles;
#[doc(hidden)]
pub type ListInstanceProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInstanceProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceProfiles`](crate::operation::ListInstanceProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListInstanceProfiles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_instance_profiles(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceProfiles",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
    pub fn builder() -> crate::input::list_instance_profiles_input::Builder {
        crate::input::list_instance_profiles_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The run's Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The run's Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_jobs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListNetworkProfilesInput`](crate::input::ListNetworkProfilesInput)
pub mod list_network_profiles_input {
    /// A builder for [`ListNetworkProfilesInput`](crate::input::ListNetworkProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::NetworkProfileType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list network profiles.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list network profiles.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn r#type(mut self, input: crate::model::NetworkProfileType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNetworkProfilesInput`](crate::input::ListNetworkProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNetworkProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNetworkProfilesInput {
                arn: self.arn,
                r#type: self.r#type,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNetworkProfilesInputOperationOutputAlias = crate::operation::ListNetworkProfiles;
#[doc(hidden)]
pub type ListNetworkProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListNetworkProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListNetworkProfiles`](crate::operation::ListNetworkProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNetworkProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNetworkProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNetworkProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNetworkProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListNetworkProfiles",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_network_profiles(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNetworkProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNetworkProfiles",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNetworkProfilesInput`](crate::input::ListNetworkProfilesInput)
    pub fn builder() -> crate::input::list_network_profiles_input::Builder {
        crate::input::list_network_profiles_input::Builder::default()
    }
}

/// See [`ListOfferingPromotionsInput`](crate::input::ListOfferingPromotionsInput)
pub mod list_offering_promotions_input {
    /// A builder for [`ListOfferingPromotionsInput`](crate::input::ListOfferingPromotionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingPromotionsInput`](crate::input::ListOfferingPromotionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOfferingPromotionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOfferingPromotionsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOfferingPromotionsInputOperationOutputAlias = crate::operation::ListOfferingPromotions;
#[doc(hidden)]
pub type ListOfferingPromotionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOfferingPromotionsInput {
    /// Consumes the builder and constructs an Operation<[`ListOfferingPromotions`](crate::operation::ListOfferingPromotions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOfferingPromotions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOfferingPromotionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOfferingPromotionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOfferingPromotionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListOfferingPromotions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_offering_promotions(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOfferingPromotions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOfferingPromotions",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOfferingPromotionsInput`](crate::input::ListOfferingPromotionsInput)
    pub fn builder() -> crate::input::list_offering_promotions_input::Builder {
        crate::input::list_offering_promotions_input::Builder::default()
    }
}

/// See [`ListOfferingsInput`](crate::input::ListOfferingsInput)
pub mod list_offerings_input {
    /// A builder for [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingsInput`](crate::input::ListOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOfferingsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOfferingsInputOperationOutputAlias = crate::operation::ListOfferings;
#[doc(hidden)]
pub type ListOfferingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`ListOfferings`](crate::operation::ListOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOfferings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListOfferings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_offerings(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOfferings",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    pub fn builder() -> crate::input::list_offerings_input::Builder {
        crate::input::list_offerings_input::Builder::default()
    }
}

/// See [`ListOfferingTransactionsInput`](crate::input::ListOfferingTransactionsInput)
pub mod list_offering_transactions_input {
    /// A builder for [`ListOfferingTransactionsInput`](crate::input::ListOfferingTransactionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingTransactionsInput`](crate::input::ListOfferingTransactionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOfferingTransactionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOfferingTransactionsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOfferingTransactionsInputOperationOutputAlias =
    crate::operation::ListOfferingTransactions;
#[doc(hidden)]
pub type ListOfferingTransactionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOfferingTransactionsInput {
    /// Consumes the builder and constructs an Operation<[`ListOfferingTransactions`](crate::operation::ListOfferingTransactions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOfferingTransactions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOfferingTransactionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOfferingTransactionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOfferingTransactionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListOfferingTransactions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_offering_transactions(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOfferingTransactions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOfferingTransactions",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOfferingTransactionsInput`](crate::input::ListOfferingTransactionsInput)
    pub fn builder() -> crate::input::list_offering_transactions_input::Builder {
        crate::input::list_offering_transactions_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm returns a list of all projects for the AWS account. You can also specify a project ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm returns a list of all projects for the AWS account. You can also specify a project ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListProjects",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_projects(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`ListRemoteAccessSessionsInput`](crate::input::ListRemoteAccessSessionsInput)
pub mod list_remote_access_sessions_input {
    /// A builder for [`ListRemoteAccessSessionsInput`](crate::input::ListRemoteAccessSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project about which you are requesting information.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project about which you are requesting information.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRemoteAccessSessionsInput`](crate::input::ListRemoteAccessSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRemoteAccessSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRemoteAccessSessionsInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRemoteAccessSessionsInputOperationOutputAlias =
    crate::operation::ListRemoteAccessSessions;
#[doc(hidden)]
pub type ListRemoteAccessSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRemoteAccessSessionsInput {
    /// Consumes the builder and constructs an Operation<[`ListRemoteAccessSessions`](crate::operation::ListRemoteAccessSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRemoteAccessSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRemoteAccessSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRemoteAccessSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRemoteAccessSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListRemoteAccessSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_remote_access_sessions(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRemoteAccessSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRemoteAccessSessions",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRemoteAccessSessionsInput`](crate::input::ListRemoteAccessSessionsInput)
    pub fn builder() -> crate::input::list_remote_access_sessions_input::Builder {
        crate::input::list_remote_access_sessions_input::Builder::default()
    }
}

/// See [`ListRunsInput`](crate::input::ListRunsInput)
pub mod list_runs_input {
    /// A builder for [`ListRunsInput`](crate::input::ListRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list runs.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list runs.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRunsInput`](crate::input::ListRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListRunsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListRunsInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRunsInputOperationOutputAlias = crate::operation::ListRuns;
#[doc(hidden)]
pub type ListRunsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRunsInput {
    /// Consumes the builder and constructs an Operation<[`ListRuns`](crate::operation::ListRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRuns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListRuns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_runs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListRuns::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListRuns",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRunsInput`](crate::input::ListRunsInput)
    pub fn builder() -> crate::input::list_runs_input::Builder {
        crate::input::list_runs_input::Builder::default()
    }
}

/// See [`ListSamplesInput`](crate::input::ListSamplesInput)
pub mod list_samples_input {
    /// A builder for [`ListSamplesInput`](crate::input::ListSamplesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the job used to list samples.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the job used to list samples.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSamplesInput`](crate::input::ListSamplesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSamplesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSamplesInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSamplesInputOperationOutputAlias = crate::operation::ListSamples;
#[doc(hidden)]
pub type ListSamplesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSamplesInput {
    /// Consumes the builder and constructs an Operation<[`ListSamples`](crate::operation::ListSamples)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSamples,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSamplesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSamplesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSamplesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListSamples",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_samples(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSamples::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSamples",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSamplesInput`](crate::input::ListSamplesInput)
    pub fn builder() -> crate::input::list_samples_input::Builder {
        crate::input::list_samples_input::Builder::default()
    }
}

/// See [`ListSuitesInput`](crate::input::ListSuitesInput)
pub mod list_suites_input {
    /// A builder for [`ListSuitesInput`](crate::input::ListSuitesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job's Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The job's Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuitesInput`](crate::input::ListSuitesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSuitesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSuitesInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSuitesInputOperationOutputAlias = crate::operation::ListSuites;
#[doc(hidden)]
pub type ListSuitesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSuitesInput {
    /// Consumes the builder and constructs an Operation<[`ListSuites`](crate::operation::ListSuites)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSuites,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSuitesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSuitesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSuitesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListSuites",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_suites(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSuites::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSuites",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSuitesInput`](crate::input::ListSuitesInput)
    pub fn builder() -> crate::input::list_suites_input::Builder {
        crate::input::list_suites_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource or resources for which to list tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources for which to list tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTestGridProjectsInput`](crate::input::ListTestGridProjectsInput)
pub mod list_test_grid_projects_input {
    /// A builder for [`ListTestGridProjectsInput`](crate::input::ListTestGridProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_result: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return no more than this number of results.</p>
        pub fn max_result(mut self, input: i32) -> Self {
            self.max_result = Some(input);
            self
        }
        /// <p>Return no more than this number of results.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.max_result = input;
            self
        }
        /// <p>From a response, used to continue a paginated listing. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>From a response, used to continue a paginated listing. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridProjectsInput`](crate::input::ListTestGridProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTestGridProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTestGridProjectsInput {
                max_result: self.max_result,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTestGridProjectsInputOperationOutputAlias = crate::operation::ListTestGridProjects;
#[doc(hidden)]
pub type ListTestGridProjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTestGridProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListTestGridProjects`](crate::operation::ListTestGridProjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTestGridProjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTestGridProjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTestGridProjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTestGridProjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListTestGridProjects",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_test_grid_projects(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTestGridProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTestGridProjects",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTestGridProjectsInput`](crate::input::ListTestGridProjectsInput)
    pub fn builder() -> crate::input::list_test_grid_projects_input::Builder {
        crate::input::list_test_grid_projects_input::Builder::default()
    }
}

/// See [`ListTestGridSessionActionsInput`](crate::input::ListTestGridSessionActionsInput)
pub mod list_test_grid_session_actions_input {
    /// A builder for [`ListTestGridSessionActionsInput`](crate::input::ListTestGridSessionActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_arn: std::option::Option<std::string::String>,
        pub(crate) max_result: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the session to retrieve.</p>
        pub fn session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the session to retrieve.</p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_arn = input;
            self
        }
        /// <p>The maximum number of sessions to return per response.</p>
        pub fn max_result(mut self, input: i32) -> Self {
            self.max_result = Some(input);
            self
        }
        /// <p>The maximum number of sessions to return per response.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.max_result = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridSessionActionsInput`](crate::input::ListTestGridSessionActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTestGridSessionActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTestGridSessionActionsInput {
                session_arn: self.session_arn,
                max_result: self.max_result,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTestGridSessionActionsInputOperationOutputAlias =
    crate::operation::ListTestGridSessionActions;
#[doc(hidden)]
pub type ListTestGridSessionActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTestGridSessionActionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTestGridSessionActions`](crate::operation::ListTestGridSessionActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTestGridSessionActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTestGridSessionActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTestGridSessionActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTestGridSessionActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListTestGridSessionActions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_test_grid_session_actions(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTestGridSessionActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTestGridSessionActions",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionActionsInput`](crate::input::ListTestGridSessionActionsInput)
    pub fn builder() -> crate::input::list_test_grid_session_actions_input::Builder {
        crate::input::list_test_grid_session_actions_input::Builder::default()
    }
}

/// See [`ListTestGridSessionArtifactsInput`](crate::input::ListTestGridSessionArtifactsInput)
pub mod list_test_grid_session_artifacts_input {
    /// A builder for [`ListTestGridSessionArtifactsInput`](crate::input::ListTestGridSessionArtifactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TestGridSessionArtifactCategory>,
        pub(crate) max_result: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a <code>TestGridSession</code>. </p>
        pub fn session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a <code>TestGridSession</code>. </p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_arn = input;
            self
        }
        /// <p>Limit results to a specified type of artifact.</p>
        pub fn r#type(mut self, input: crate::model::TestGridSessionArtifactCategory) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Limit results to a specified type of artifact.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TestGridSessionArtifactCategory>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The maximum number of results to be returned by a request.</p>
        pub fn max_result(mut self, input: i32) -> Self {
            self.max_result = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned by a request.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.max_result = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridSessionArtifactsInput`](crate::input::ListTestGridSessionArtifactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTestGridSessionArtifactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTestGridSessionArtifactsInput {
                session_arn: self.session_arn,
                r#type: self.r#type,
                max_result: self.max_result,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTestGridSessionArtifactsInputOperationOutputAlias =
    crate::operation::ListTestGridSessionArtifacts;
#[doc(hidden)]
pub type ListTestGridSessionArtifactsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListTestGridSessionArtifactsInput {
    /// Consumes the builder and constructs an Operation<[`ListTestGridSessionArtifacts`](crate::operation::ListTestGridSessionArtifacts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTestGridSessionArtifacts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTestGridSessionArtifactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTestGridSessionArtifactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTestGridSessionArtifactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListTestGridSessionArtifacts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_test_grid_session_artifacts(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTestGridSessionArtifacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTestGridSessionArtifacts",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionArtifactsInput`](crate::input::ListTestGridSessionArtifactsInput)
    pub fn builder() -> crate::input::list_test_grid_session_artifacts_input::Builder {
        crate::input::list_test_grid_session_artifacts_input::Builder::default()
    }
}

/// See [`ListTestGridSessionsInput`](crate::input::ListTestGridSessionsInput)
pub mod list_test_grid_sessions_input {
    /// A builder for [`ListTestGridSessionsInput`](crate::input::ListTestGridSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TestGridSessionStatus>,
        pub(crate) creation_time_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_result: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of a <code>TestGridProject</code>.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>ARN of a <code>TestGridProject</code>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>Return only sessions in this state.</p>
        pub fn status(mut self, input: crate::model::TestGridSessionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Return only sessions in this state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TestGridSessionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Return only sessions created after this time.</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time_after = Some(input);
            self
        }
        /// <p>Return only sessions created after this time.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time_after = input;
            self
        }
        /// <p>Return only sessions created before this time.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time_before = Some(input);
            self
        }
        /// <p>Return only sessions created before this time.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time_before = input;
            self
        }
        /// <p>Return only sessions that ended after this time.</p>
        pub fn end_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time_after = Some(input);
            self
        }
        /// <p>Return only sessions that ended after this time.</p>
        pub fn set_end_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time_after = input;
            self
        }
        /// <p>Return only sessions that ended before this time.</p>
        pub fn end_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time_before = Some(input);
            self
        }
        /// <p>Return only sessions that ended before this time.</p>
        pub fn set_end_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time_before = input;
            self
        }
        /// <p>Return only this many results at a time.</p>
        pub fn max_result(mut self, input: i32) -> Self {
            self.max_result = Some(input);
            self
        }
        /// <p>Return only this many results at a time.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.max_result = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridSessionsInput`](crate::input::ListTestGridSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTestGridSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTestGridSessionsInput {
                project_arn: self.project_arn,
                status: self.status,
                creation_time_after: self.creation_time_after,
                creation_time_before: self.creation_time_before,
                end_time_after: self.end_time_after,
                end_time_before: self.end_time_before,
                max_result: self.max_result,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTestGridSessionsInputOperationOutputAlias = crate::operation::ListTestGridSessions;
#[doc(hidden)]
pub type ListTestGridSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTestGridSessionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTestGridSessions`](crate::operation::ListTestGridSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTestGridSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTestGridSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTestGridSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTestGridSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListTestGridSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_test_grid_sessions(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTestGridSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTestGridSessions",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionsInput`](crate::input::ListTestGridSessionsInput)
    pub fn builder() -> crate::input::list_test_grid_sessions_input::Builder {
        crate::input::list_test_grid_sessions_input::Builder::default()
    }
}

/// See [`ListTestsInput`](crate::input::ListTestsInput)
pub mod list_tests_input {
    /// A builder for [`ListTestsInput`](crate::input::ListTestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The test suite's Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The test suite's Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestsInput`](crate::input::ListTestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTestsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTestsInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTestsInputOperationOutputAlias = crate::operation::ListTests;
#[doc(hidden)]
pub type ListTestsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTestsInput {
    /// Consumes the builder and constructs an Operation<[`ListTests`](crate::operation::ListTests)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTests,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTestsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTestsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTestsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListTests",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tests(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTests::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTests",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTestsInput`](crate::input::ListTestsInput)
    pub fn builder() -> crate::input::list_tests_input::Builder {
        crate::input::list_tests_input::Builder::default()
    }
}

/// See [`ListUniqueProblemsInput`](crate::input::ListUniqueProblemsInput)
pub mod list_unique_problems_input {
    /// A builder for [`ListUniqueProblemsInput`](crate::input::ListUniqueProblemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique problems' ARNs.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The unique problems' ARNs.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUniqueProblemsInput`](crate::input::ListUniqueProblemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUniqueProblemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUniqueProblemsInput {
                arn: self.arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUniqueProblemsInputOperationOutputAlias = crate::operation::ListUniqueProblems;
#[doc(hidden)]
pub type ListUniqueProblemsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUniqueProblemsInput {
    /// Consumes the builder and constructs an Operation<[`ListUniqueProblems`](crate::operation::ListUniqueProblems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUniqueProblems,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUniqueProblemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUniqueProblemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUniqueProblemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListUniqueProblems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_unique_problems(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUniqueProblems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUniqueProblems",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUniqueProblemsInput`](crate::input::ListUniqueProblemsInput)
    pub fn builder() -> crate::input::list_unique_problems_input::Builder {
        crate::input::list_unique_problems_input::Builder::default()
    }
}

/// See [`ListUploadsInput`](crate::input::ListUploadsInput)
pub mod list_uploads_input {
    /// A builder for [`ListUploadsInput`](crate::input::ListUploadsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UploadType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list uploads.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list uploads.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of upload.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li> <p>ANDROID_APP</p> </li>
        /// <li> <p>IOS_APP</p> </li>
        /// <li> <p>WEB_APP</p> </li>
        /// <li> <p>EXTERNAL_DATA</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
        /// <li> <p> APPIUM_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
        /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::UploadType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of upload.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li> <p>ANDROID_APP</p> </li>
        /// <li> <p>IOS_APP</p> </li>
        /// <li> <p>WEB_APP</p> </li>
        /// <li> <p>EXTERNAL_DATA</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
        /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
        /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
        /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
        /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
        /// <li> <p> APPIUM_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
        /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
        /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
        /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UploadType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUploadsInput`](crate::input::ListUploadsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUploadsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUploadsInput {
                arn: self.arn,
                r#type: self.r#type,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUploadsInputOperationOutputAlias = crate::operation::ListUploads;
#[doc(hidden)]
pub type ListUploadsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUploadsInput {
    /// Consumes the builder and constructs an Operation<[`ListUploads`](crate::operation::ListUploads)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUploads,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUploadsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUploadsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUploadsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListUploads",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_uploads(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUploads::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUploads",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUploadsInput`](crate::input::ListUploadsInput)
    pub fn builder() -> crate::input::list_uploads_input::Builder {
        crate::input::list_uploads_input::Builder::default()
    }
}

/// See [`ListVpceConfigurationsInput`](crate::input::ListVpceConfigurationsInput)
pub mod list_vpce_configurations_input {
    /// A builder for [`ListVpceConfigurationsInput`](crate::input::ListVpceConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVpceConfigurationsInput`](crate::input::ListVpceConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVpceConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVpceConfigurationsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVpceConfigurationsInputOperationOutputAlias = crate::operation::ListVPCEConfigurations;
#[doc(hidden)]
pub type ListVpceConfigurationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVpceConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListVPCEConfigurations`](crate::operation::ListVPCEConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVPCEConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVpceConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVpceConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVpceConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ListVPCEConfigurations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_vpce_configurations(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVPCEConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVPCEConfigurations",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVpceConfigurationsInput`](crate::input::ListVpceConfigurationsInput)
    pub fn builder() -> crate::input::list_vpce_configurations_input::Builder {
        crate::input::list_vpce_configurations_input::Builder::default()
    }
}

/// See [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
pub mod purchase_offering_input {
    /// A builder for [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) offering_promotion_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the offering.</p>
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// <p>The number of device slots to purchase in an offering request.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of device slots to purchase in an offering request.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// <p>The ID of the offering promotion to be applied to the purchase.</p>
        pub fn offering_promotion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_promotion_id = Some(input.into());
            self
        }
        /// <p>The ID of the offering promotion to be applied to the purchase.</p>
        pub fn set_offering_promotion_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_promotion_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PurchaseOfferingInput {
                offering_id: self.offering_id,
                quantity: self.quantity,
                offering_promotion_id: self.offering_promotion_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PurchaseOfferingInputOperationOutputAlias = crate::operation::PurchaseOffering;
#[doc(hidden)]
pub type PurchaseOfferingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PurchaseOfferingInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseOffering`](crate::operation::PurchaseOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PurchaseOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PurchaseOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PurchaseOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.PurchaseOffering",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_purchase_offering(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseOffering",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    pub fn builder() -> crate::input::purchase_offering_input::Builder {
        crate::input::purchase_offering_input::Builder::default()
    }
}

/// See [`RenewOfferingInput`](crate::input::RenewOfferingInput)
pub mod renew_offering_input {
    /// A builder for [`RenewOfferingInput`](crate::input::RenewOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of a request to renew an offering.</p>
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// <p>The ID of a request to renew an offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// <p>The quantity requested in an offering renewal.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The quantity requested in an offering renewal.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Consumes the builder and constructs a [`RenewOfferingInput`](crate::input::RenewOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RenewOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RenewOfferingInput {
                offering_id: self.offering_id,
                quantity: self.quantity,
            })
        }
    }
}
#[doc(hidden)]
pub type RenewOfferingInputOperationOutputAlias = crate::operation::RenewOffering;
#[doc(hidden)]
pub type RenewOfferingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RenewOfferingInput {
    /// Consumes the builder and constructs an Operation<[`RenewOffering`](crate::operation::RenewOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RenewOffering,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RenewOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RenewOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RenewOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.RenewOffering",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_renew_offering(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RenewOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RenewOffering",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RenewOfferingInput`](crate::input::RenewOfferingInput)
    pub fn builder() -> crate::input::renew_offering_input::Builder {
        crate::input::renew_offering_input::Builder::default()
    }
}

/// See [`ScheduleRunInput`](crate::input::ScheduleRunInput)
pub mod schedule_run_input {
    /// A builder for [`ScheduleRunInput`](crate::input::ScheduleRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) device_pool_arn: std::option::Option<std::string::String>,
        pub(crate) device_selection_configuration:
            std::option::Option<crate::model::DeviceSelectionConfiguration>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) test: std::option::Option<crate::model::ScheduleRunTest>,
        pub(crate) configuration: std::option::Option<crate::model::ScheduleRunConfiguration>,
        pub(crate) execution_configuration:
            std::option::Option<crate::model::ExecutionConfiguration>,
    }
    impl Builder {
        /// <p>The ARN of the project for the run to be scheduled.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the project for the run to be scheduled.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The ARN of an application package to run tests against, created with <code>CreateUpload</code>. See <code>ListUploads</code>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an application package to run tests against, created with <code>CreateUpload</code>. See <code>ListUploads</code>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The ARN of the device pool for the run to be scheduled.</p>
        pub fn device_pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_pool_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device pool for the run to be scheduled.</p>
        pub fn set_device_pool_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_pool_arn = input;
            self
        }
        /// <p>The filter criteria used to dynamically select a set of devices for a test run and the maximum number of devices to be included in the run.</p>
        /// <p>Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required in a request.</p>
        pub fn device_selection_configuration(
            mut self,
            input: crate::model::DeviceSelectionConfiguration,
        ) -> Self {
            self.device_selection_configuration = Some(input);
            self
        }
        /// <p>The filter criteria used to dynamically select a set of devices for a test run and the maximum number of devices to be included in the run.</p>
        /// <p>Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required in a request.</p>
        pub fn set_device_selection_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceSelectionConfiguration>,
        ) -> Self {
            self.device_selection_configuration = input;
            self
        }
        /// <p>The name for the run to be scheduled.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the run to be scheduled.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Information about the test for the run to be scheduled.</p>
        pub fn test(mut self, input: crate::model::ScheduleRunTest) -> Self {
            self.test = Some(input);
            self
        }
        /// <p>Information about the test for the run to be scheduled.</p>
        pub fn set_test(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunTest>,
        ) -> Self {
            self.test = input;
            self
        }
        /// <p>Information about the settings for the run to be scheduled.</p>
        pub fn configuration(mut self, input: crate::model::ScheduleRunConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Information about the settings for the run to be scheduled.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>Specifies configuration information about a test run, such as the execution timeout (in minutes).</p>
        pub fn execution_configuration(
            mut self,
            input: crate::model::ExecutionConfiguration,
        ) -> Self {
            self.execution_configuration = Some(input);
            self
        }
        /// <p>Specifies configuration information about a test run, such as the execution timeout (in minutes).</p>
        pub fn set_execution_configuration(
            mut self,
            input: std::option::Option<crate::model::ExecutionConfiguration>,
        ) -> Self {
            self.execution_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleRunInput`](crate::input::ScheduleRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ScheduleRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ScheduleRunInput {
                project_arn: self.project_arn,
                app_arn: self.app_arn,
                device_pool_arn: self.device_pool_arn,
                device_selection_configuration: self.device_selection_configuration,
                name: self.name,
                test: self.test,
                configuration: self.configuration,
                execution_configuration: self.execution_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type ScheduleRunInputOperationOutputAlias = crate::operation::ScheduleRun;
#[doc(hidden)]
pub type ScheduleRunInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ScheduleRunInput {
    /// Consumes the builder and constructs an Operation<[`ScheduleRun`](crate::operation::ScheduleRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ScheduleRun,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ScheduleRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ScheduleRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ScheduleRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.ScheduleRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_schedule_run(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ScheduleRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ScheduleRun",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ScheduleRunInput`](crate::input::ScheduleRunInput)
    pub fn builder() -> crate::input::schedule_run_input::Builder {
        crate::input::schedule_run_input::Builder::default()
    }
}

/// See [`StopJobInput`](crate::input::StopJobInput)
pub mod stop_job_input {
    /// A builder for [`StopJobInput`](crate::input::StopJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopJobInput`](crate::input::StopJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopJobInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type StopJobInputOperationOutputAlias = crate::operation::StopJob;
#[doc(hidden)]
pub type StopJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopJobInput {
    /// Consumes the builder and constructs an Operation<[`StopJob`](crate::operation::StopJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.StopJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopJob",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopJobInput`](crate::input::StopJobInput)
    pub fn builder() -> crate::input::stop_job_input::Builder {
        crate::input::stop_job_input::Builder::default()
    }
}

/// See [`StopRemoteAccessSessionInput`](crate::input::StopRemoteAccessSessionInput)
pub mod stop_remote_access_session_input {
    /// A builder for [`StopRemoteAccessSessionInput`](crate::input::StopRemoteAccessSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the remote access session to stop.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session to stop.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopRemoteAccessSessionInput`](crate::input::StopRemoteAccessSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopRemoteAccessSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopRemoteAccessSessionInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type StopRemoteAccessSessionInputOperationOutputAlias =
    crate::operation::StopRemoteAccessSession;
#[doc(hidden)]
pub type StopRemoteAccessSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopRemoteAccessSessionInput {
    /// Consumes the builder and constructs an Operation<[`StopRemoteAccessSession`](crate::operation::StopRemoteAccessSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopRemoteAccessSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopRemoteAccessSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopRemoteAccessSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopRemoteAccessSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.StopRemoteAccessSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_remote_access_session(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopRemoteAccessSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopRemoteAccessSession",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopRemoteAccessSessionInput`](crate::input::StopRemoteAccessSessionInput)
    pub fn builder() -> crate::input::stop_remote_access_session_input::Builder {
        crate::input::stop_remote_access_session_input::Builder::default()
    }
}

/// See [`StopRunInput`](crate::input::StopRunInput)
pub mod stop_run_input {
    /// A builder for [`StopRunInput`](crate::input::StopRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopRunInput`](crate::input::StopRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopRunInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopRunInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type StopRunInputOperationOutputAlias = crate::operation::StopRun;
#[doc(hidden)]
pub type StopRunInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopRunInput {
    /// Consumes the builder and constructs an Operation<[`StopRun`](crate::operation::StopRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopRun,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.StopRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_run(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopRun::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopRun",
                    "devicefarm",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopRunInput`](crate::input::StopRunInput)
    pub fn builder() -> crate::input::stop_run_input::Builder {
        crate::input::stop_run_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource or resources to which to add tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources to which to add tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource or resources from which to delete tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources from which to delete tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDeviceInstanceInput`](crate::input::UpdateDeviceInstanceInput)
pub mod update_device_instance_input {
    /// A builder for [`UpdateDeviceInstanceInput`](crate::input::UpdateDeviceInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) profile_arn: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the profile that you want to associate with the device instance.</p>
        pub fn profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the profile that you want to associate with the device instance.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_arn = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>An array of strings that you want to associate with the device instance.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>An array of strings that you want to associate with the device instance.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceInstanceInput`](crate::input::UpdateDeviceInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceInstanceInput {
                arn: self.arn,
                profile_arn: self.profile_arn,
                labels: self.labels,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceInstanceInputOperationOutputAlias = crate::operation::UpdateDeviceInstance;
#[doc(hidden)]
pub type UpdateDeviceInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDeviceInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeviceInstance`](crate::operation::UpdateDeviceInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeviceInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateDeviceInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_device_instance(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeviceInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeviceInstance",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInstanceInput`](crate::input::UpdateDeviceInstanceInput)
    pub fn builder() -> crate::input::update_device_instance_input::Builder {
        crate::input::update_device_instance_input::Builder::default()
    }
}

/// See [`UpdateDevicePoolInput`](crate::input::UpdateDevicePoolInput)
pub mod update_device_pool_input {
    /// A builder for [`UpdateDevicePoolInput`](crate::input::UpdateDevicePoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) max_devices: std::option::Option<i32>,
        pub(crate) clear_max_devices: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Device Farm device pool to update.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Device Farm device pool to update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A string that represents the name of the device pool to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A string that represents the name of the device pool to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the device pool to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the device pool to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
        /// <p>If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in the same request.</p>
        pub fn max_devices(mut self, input: i32) -> Self {
            self.max_devices = Some(input);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
        /// <p>If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in the same request.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.max_devices = input;
            self
        }
        /// <p>Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the <code>rules</code> parameter.</p>
        /// <p>If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the same request.</p>
        pub fn clear_max_devices(mut self, input: bool) -> Self {
            self.clear_max_devices = Some(input);
            self
        }
        /// <p>Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the <code>rules</code> parameter.</p>
        /// <p>If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the same request.</p>
        pub fn set_clear_max_devices(mut self, input: std::option::Option<bool>) -> Self {
            self.clear_max_devices = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDevicePoolInput`](crate::input::UpdateDevicePoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDevicePoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDevicePoolInput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                rules: self.rules,
                max_devices: self.max_devices,
                clear_max_devices: self.clear_max_devices,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDevicePoolInputOperationOutputAlias = crate::operation::UpdateDevicePool;
#[doc(hidden)]
pub type UpdateDevicePoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDevicePoolInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDevicePool`](crate::operation::UpdateDevicePool)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDevicePool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDevicePoolInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDevicePoolInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDevicePoolInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateDevicePool",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_device_pool(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDevicePool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDevicePool",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDevicePoolInput`](crate::input::UpdateDevicePoolInput)
    pub fn builder() -> crate::input::update_device_pool_input::Builder {
        crate::input::update_device_pool_input::Builder::default()
    }
}

/// See [`UpdateInstanceProfileInput`](crate::input::UpdateInstanceProfileInput)
pub mod update_instance_profile_input {
    /// A builder for [`UpdateInstanceProfileInput`](crate::input::UpdateInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) package_cleanup: std::option::Option<bool>,
        pub(crate) exclude_app_packages_from_cleanup:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reboot_after_use: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The updated name for your instance profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name for your instance profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description for your instance profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description for your instance profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated choice for whether you want to specify package cleanup. The default value is <code>false</code> for private devices.</p>
        pub fn package_cleanup(mut self, input: bool) -> Self {
            self.package_cleanup = Some(input);
            self
        }
        /// <p>The updated choice for whether you want to specify package cleanup. The default value is <code>false</code> for private devices.</p>
        pub fn set_package_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.package_cleanup = input;
            self
        }
        /// Appends an item to `exclude_app_packages_from_cleanup`.
        ///
        /// To override the contents of this collection use [`set_exclude_app_packages_from_cleanup`](Self::set_exclude_app_packages_from_cleanup).
        ///
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run is over.</p>
        /// <p>The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.</p>
        pub fn exclude_app_packages_from_cleanup(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_app_packages_from_cleanup.unwrap_or_default();
            v.push(input.into());
            self.exclude_app_packages_from_cleanup = Some(v);
            self
        }
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run is over.</p>
        /// <p>The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.</p>
        pub fn set_exclude_app_packages_from_cleanup(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_app_packages_from_cleanup = input;
            self
        }
        /// <p>The updated choice for whether you want to reboot the device after use. The default value is <code>true</code>.</p>
        pub fn reboot_after_use(mut self, input: bool) -> Self {
            self.reboot_after_use = Some(input);
            self
        }
        /// <p>The updated choice for whether you want to reboot the device after use. The default value is <code>true</code>.</p>
        pub fn set_reboot_after_use(mut self, input: std::option::Option<bool>) -> Self {
            self.reboot_after_use = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInstanceProfileInput`](crate::input::UpdateInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInstanceProfileInput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                package_cleanup: self.package_cleanup,
                exclude_app_packages_from_cleanup: self.exclude_app_packages_from_cleanup,
                reboot_after_use: self.reboot_after_use,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInstanceProfileInputOperationOutputAlias = crate::operation::UpdateInstanceProfile;
#[doc(hidden)]
pub type UpdateInstanceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInstanceProfile`](crate::operation::UpdateInstanceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInstanceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateInstanceProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_instance_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInstanceProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInstanceProfileInput`](crate::input::UpdateInstanceProfileInput)
    pub fn builder() -> crate::input::update_instance_profile_input::Builder {
        crate::input::update_instance_profile_input::Builder::default()
    }
}

/// See [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
pub mod update_network_profile_input {
    /// A builder for [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::NetworkProfileType>,
        pub(crate) uplink_bandwidth_bits: std::option::Option<i64>,
        pub(crate) downlink_bandwidth_bits: std::option::Option<i64>,
        pub(crate) uplink_delay_ms: std::option::Option<i64>,
        pub(crate) downlink_delay_ms: std::option::Option<i64>,
        pub(crate) uplink_jitter_ms: std::option::Option<i64>,
        pub(crate) downlink_jitter_ms: std::option::Option<i64>,
        pub(crate) uplink_loss_percent: std::option::Option<i32>,
        pub(crate) downlink_loss_percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to update network profile settings.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to update network profile settings.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the network profile about which you are returning information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the network profile about which you are returning information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the network profile about which you are returning information.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the network profile about which you are returning information.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn r#type(mut self, input: crate::model::NetworkProfileType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn uplink_bandwidth_bits(mut self, input: i64) -> Self {
            self.uplink_bandwidth_bits = Some(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn set_uplink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_bandwidth_bits = input;
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn downlink_bandwidth_bits(mut self, input: i64) -> Self {
            self.downlink_bandwidth_bits = Some(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
        pub fn set_downlink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_bandwidth_bits = input;
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn uplink_delay_ms(mut self, input: i64) -> Self {
            self.uplink_delay_ms = Some(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_uplink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_delay_ms = input;
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn downlink_delay_ms(mut self, input: i64) -> Self {
            self.downlink_delay_ms = Some(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_downlink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_delay_ms = input;
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn uplink_jitter_ms(mut self, input: i64) -> Self {
            self.uplink_jitter_ms = Some(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_uplink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_jitter_ms = input;
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn downlink_jitter_ms(mut self, input: i64) -> Self {
            self.downlink_jitter_ms = Some(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
        pub fn set_downlink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_jitter_ms = input;
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
        pub fn uplink_loss_percent(mut self, input: i32) -> Self {
            self.uplink_loss_percent = Some(input);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_uplink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.uplink_loss_percent = input;
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn downlink_loss_percent(mut self, input: i32) -> Self {
            self.downlink_loss_percent = Some(input);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_downlink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.downlink_loss_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNetworkProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNetworkProfileInput {
                arn: self.arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                uplink_bandwidth_bits: self.uplink_bandwidth_bits,
                downlink_bandwidth_bits: self.downlink_bandwidth_bits,
                uplink_delay_ms: self.uplink_delay_ms,
                downlink_delay_ms: self.downlink_delay_ms,
                uplink_jitter_ms: self.uplink_jitter_ms,
                downlink_jitter_ms: self.downlink_jitter_ms,
                uplink_loss_percent: self.uplink_loss_percent.unwrap_or_default(),
                downlink_loss_percent: self.downlink_loss_percent.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNetworkProfileInputOperationOutputAlias = crate::operation::UpdateNetworkProfile;
#[doc(hidden)]
pub type UpdateNetworkProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateNetworkProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNetworkProfile`](crate::operation::UpdateNetworkProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNetworkProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNetworkProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNetworkProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNetworkProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateNetworkProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_network_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNetworkProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNetworkProfile",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNetworkProfileInput`](crate::input::UpdateNetworkProfileInput)
    pub fn builder() -> crate::input::update_network_profile_input::Builder {
        crate::input::update_network_profile_input::Builder::default()
    }
}

/// See [`UpdateProjectInput`](crate::input::UpdateProjectInput)
pub mod update_project_input {
    /// A builder for [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_job_timeout_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project whose name to update.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project whose name to update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A string that represents the new name of the project that you are updating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A string that represents the new name of the project that you are updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of minutes a test run in the project executes before it times out.</p>
        pub fn default_job_timeout_minutes(mut self, input: i32) -> Self {
            self.default_job_timeout_minutes = Some(input);
            self
        }
        /// <p>The number of minutes a test run in the project executes before it times out.</p>
        pub fn set_default_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.default_job_timeout_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectInput`](crate::input::UpdateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectInput {
                arn: self.arn,
                name: self.name,
                default_job_timeout_minutes: self.default_job_timeout_minutes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectInputOperationOutputAlias = crate::operation::UpdateProject;
#[doc(hidden)]
pub type UpdateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProject`](crate::operation::UpdateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
}

/// See [`UpdateTestGridProjectInput`](crate::input::UpdateTestGridProjectInput)
pub mod update_test_grid_project_input {
    /// A builder for [`UpdateTestGridProjectInput`](crate::input::UpdateTestGridProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::TestGridVpcConfig>,
    }
    impl Builder {
        /// <p>ARN of the project to update.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>ARN of the project to update.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>Human-readable name for the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Human-readable name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Human-readable description for the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Human-readable description for the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn vpc_config(mut self, input: crate::model::TestGridVpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::TestGridVpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTestGridProjectInput`](crate::input::UpdateTestGridProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTestGridProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTestGridProjectInput {
                project_arn: self.project_arn,
                name: self.name,
                description: self.description,
                vpc_config: self.vpc_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTestGridProjectInputOperationOutputAlias = crate::operation::UpdateTestGridProject;
#[doc(hidden)]
pub type UpdateTestGridProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTestGridProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTestGridProject`](crate::operation::UpdateTestGridProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTestGridProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTestGridProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTestGridProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTestGridProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateTestGridProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_test_grid_project(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTestGridProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTestGridProject",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTestGridProjectInput`](crate::input::UpdateTestGridProjectInput)
    pub fn builder() -> crate::input::update_test_grid_project_input::Builder {
        crate::input::update_test_grid_project_input::Builder::default()
    }
}

/// See [`UpdateUploadInput`](crate::input::UpdateUploadInput)
pub mod update_upload_input {
    /// A builder for [`UpdateUploadInput`](crate::input::UpdateUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) edit_content: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the uploaded test spec.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the uploaded test spec.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file name must end with the <code>.yaml</code> or <code>.yml</code> file extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file name must end with the <code>.yaml</code> or <code>.yml</code> file extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The upload's content type (for example, <code>application/x-yaml</code>).</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The upload's content type (for example, <code>application/x-yaml</code>).</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>Set to true if the YAML file has changed and must be updated. Otherwise, set to false.</p>
        pub fn edit_content(mut self, input: bool) -> Self {
            self.edit_content = Some(input);
            self
        }
        /// <p>Set to true if the YAML file has changed and must be updated. Otherwise, set to false.</p>
        pub fn set_edit_content(mut self, input: std::option::Option<bool>) -> Self {
            self.edit_content = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUploadInput`](crate::input::UpdateUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUploadInput {
                arn: self.arn,
                name: self.name,
                content_type: self.content_type,
                edit_content: self.edit_content,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUploadInputOperationOutputAlias = crate::operation::UpdateUpload;
#[doc(hidden)]
pub type UpdateUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateUploadInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUpload`](crate::operation::UpdateUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_upload(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUpload",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUploadInput`](crate::input::UpdateUploadInput)
    pub fn builder() -> crate::input::update_upload_input::Builder {
        crate::input::update_upload_input::Builder::default()
    }
}

/// See [`UpdateVpceConfigurationInput`](crate::input::UpdateVpceConfigurationInput)
pub mod update_vpce_configuration_input {
    /// A builder for [`UpdateVpceConfigurationInput`](crate::input::UpdateVpceConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) vpce_configuration_name: std::option::Option<std::string::String>,
        pub(crate) vpce_service_name: std::option::Option<std::string::String>,
        pub(crate) service_dns_name: std::option::Option<std::string::String>,
        pub(crate) vpce_configuration_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to update.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.</p>
        pub fn vpce_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_configuration_name = Some(input.into());
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.</p>
        pub fn set_vpce_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_configuration_name = input;
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn vpce_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_service_name = Some(input.into());
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn set_vpce_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_service_name = input;
            self
        }
        /// <p>The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already be in use on the internet.</p>
        pub fn service_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_dns_name = Some(input.into());
            self
        }
        /// <p>The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already be in use on the internet.</p>
        pub fn set_service_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_dns_name = input;
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn vpce_configuration_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.vpce_configuration_description = Some(input.into());
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_configuration_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVpceConfigurationInput`](crate::input::UpdateVpceConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVpceConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVpceConfigurationInput {
                arn: self.arn,
                vpce_configuration_name: self.vpce_configuration_name,
                vpce_service_name: self.vpce_service_name,
                service_dns_name: self.service_dns_name,
                vpce_configuration_description: self.vpce_configuration_description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVpceConfigurationInputOperationOutputAlias =
    crate::operation::UpdateVPCEConfiguration;
#[doc(hidden)]
pub type UpdateVpceConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVpceConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVPCEConfiguration`](crate::operation::UpdateVPCEConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVPCEConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateVpceConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateVpceConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateVpceConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DeviceFarm_20150623.UpdateVPCEConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_vpce_configuration(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVPCEConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVPCEConfiguration",
            "devicefarm",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateVpceConfigurationInput`](crate::input::UpdateVpceConfigurationInput)
    pub fn builder() -> crate::input::update_vpce_configuration_input::Builder {
        crate::input::update_vpce_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVpceConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to update.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.</p>
    pub vpce_configuration_name: std::option::Option<std::string::String>,
    /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
    pub vpce_service_name: std::option::Option<std::string::String>,
    /// <p>The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already be in use on the internet.</p>
    pub service_dns_name: std::option::Option<std::string::String>,
    /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
    pub vpce_configuration_description: std::option::Option<std::string::String>,
}
impl UpdateVpceConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to update.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.</p>
    pub fn vpce_configuration_name(&self) -> std::option::Option<&str> {
        self.vpce_configuration_name.as_deref()
    }
    /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
    pub fn vpce_service_name(&self) -> std::option::Option<&str> {
        self.vpce_service_name.as_deref()
    }
    /// <p>The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already be in use on the internet.</p>
    pub fn service_dns_name(&self) -> std::option::Option<&str> {
        self.service_dns_name.as_deref()
    }
    /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
    pub fn vpce_configuration_description(&self) -> std::option::Option<&str> {
        self.vpce_configuration_description.as_deref()
    }
}
impl std::fmt::Debug for UpdateVpceConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVpceConfigurationInput");
        formatter.field("arn", &self.arn);
        formatter.field("vpce_configuration_name", &self.vpce_configuration_name);
        formatter.field("vpce_service_name", &self.vpce_service_name);
        formatter.field("service_dns_name", &self.service_dns_name);
        formatter.field(
            "vpce_configuration_description",
            &self.vpce_configuration_description,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUploadInput {
    /// <p>The Amazon Resource Name (ARN) of the uploaded test spec.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file name must end with the <code>.yaml</code> or <code>.yml</code> file extension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The upload's content type (for example, <code>application/x-yaml</code>).</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>Set to true if the YAML file has changed and must be updated. Otherwise, set to false.</p>
    pub edit_content: std::option::Option<bool>,
}
impl UpdateUploadInput {
    /// <p>The Amazon Resource Name (ARN) of the uploaded test spec.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file name must end with the <code>.yaml</code> or <code>.yml</code> file extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The upload's content type (for example, <code>application/x-yaml</code>).</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>Set to true if the YAML file has changed and must be updated. Otherwise, set to false.</p>
    pub fn edit_content(&self) -> std::option::Option<bool> {
        self.edit_content
    }
}
impl std::fmt::Debug for UpdateUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUploadInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("content_type", &self.content_type);
        formatter.field("edit_content", &self.edit_content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTestGridProjectInput {
    /// <p>ARN of the project to update.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>Human-readable name for the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Human-readable description for the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The VPC security groups and subnets that are attached to a project.</p>
    pub vpc_config: std::option::Option<crate::model::TestGridVpcConfig>,
}
impl UpdateTestGridProjectInput {
    /// <p>ARN of the project to update.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>Human-readable name for the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Human-readable description for the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The VPC security groups and subnets that are attached to a project.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::TestGridVpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateTestGridProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTestGridProjectInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}

/// <p>Represents a request to the update project operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectInput {
    /// <p>The Amazon Resource Name (ARN) of the project whose name to update.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A string that represents the new name of the project that you are updating.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The number of minutes a test run in the project executes before it times out.</p>
    pub default_job_timeout_minutes: std::option::Option<i32>,
}
impl UpdateProjectInput {
    /// <p>The Amazon Resource Name (ARN) of the project whose name to update.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A string that represents the new name of the project that you are updating.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The number of minutes a test run in the project executes before it times out.</p>
    pub fn default_job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.default_job_timeout_minutes
    }
}
impl std::fmt::Debug for UpdateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field(
            "default_job_timeout_minutes",
            &self.default_job_timeout_minutes,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to update network profile settings.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the network profile about which you are returning information.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the network profile about which you are returning information.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of network profile to return information about. Valid values are listed here.</p>
    pub r#type: std::option::Option<crate::model::NetworkProfileType>,
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub uplink_bandwidth_bits: std::option::Option<i64>,
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub downlink_bandwidth_bits: std::option::Option<i64>,
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub uplink_delay_ms: std::option::Option<i64>,
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub downlink_delay_ms: std::option::Option<i64>,
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub uplink_jitter_ms: std::option::Option<i64>,
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub downlink_jitter_ms: std::option::Option<i64>,
    /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
    pub uplink_loss_percent: i32,
    /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
    pub downlink_loss_percent: i32,
}
impl UpdateNetworkProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to update network profile settings.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the network profile about which you are returning information.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the network profile about which you are returning information.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of network profile to return information about. Valid values are listed here.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NetworkProfileType> {
        self.r#type.as_ref()
    }
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub fn uplink_bandwidth_bits(&self) -> std::option::Option<i64> {
        self.uplink_bandwidth_bits
    }
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub fn downlink_bandwidth_bits(&self) -> std::option::Option<i64> {
        self.downlink_bandwidth_bits
    }
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub fn uplink_delay_ms(&self) -> std::option::Option<i64> {
        self.uplink_delay_ms
    }
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub fn downlink_delay_ms(&self) -> std::option::Option<i64> {
        self.downlink_delay_ms
    }
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub fn uplink_jitter_ms(&self) -> std::option::Option<i64> {
        self.uplink_jitter_ms
    }
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub fn downlink_jitter_ms(&self) -> std::option::Option<i64> {
        self.downlink_jitter_ms
    }
    /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
    pub fn uplink_loss_percent(&self) -> i32 {
        self.uplink_loss_percent
    }
    /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
    pub fn downlink_loss_percent(&self) -> i32 {
        self.downlink_loss_percent
    }
}
impl std::fmt::Debug for UpdateNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkProfileInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("uplink_bandwidth_bits", &self.uplink_bandwidth_bits);
        formatter.field("downlink_bandwidth_bits", &self.downlink_bandwidth_bits);
        formatter.field("uplink_delay_ms", &self.uplink_delay_ms);
        formatter.field("downlink_delay_ms", &self.downlink_delay_ms);
        formatter.field("uplink_jitter_ms", &self.uplink_jitter_ms);
        formatter.field("downlink_jitter_ms", &self.downlink_jitter_ms);
        formatter.field("uplink_loss_percent", &self.uplink_loss_percent);
        formatter.field("downlink_loss_percent", &self.downlink_loss_percent);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstanceProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The updated name for your instance profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description for your instance profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated choice for whether you want to specify package cleanup. The default value is <code>false</code> for private devices.</p>
    pub package_cleanup: std::option::Option<bool>,
    /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run is over.</p>
    /// <p>The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.</p>
    pub exclude_app_packages_from_cleanup: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The updated choice for whether you want to reboot the device after use. The default value is <code>true</code>.</p>
    pub reboot_after_use: std::option::Option<bool>,
}
impl UpdateInstanceProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The updated name for your instance profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated description for your instance profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated choice for whether you want to specify package cleanup. The default value is <code>false</code> for private devices.</p>
    pub fn package_cleanup(&self) -> std::option::Option<bool> {
        self.package_cleanup
    }
    /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run is over.</p>
    /// <p>The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.</p>
    pub fn exclude_app_packages_from_cleanup(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_app_packages_from_cleanup.as_deref()
    }
    /// <p>The updated choice for whether you want to reboot the device after use. The default value is <code>true</code>.</p>
    pub fn reboot_after_use(&self) -> std::option::Option<bool> {
        self.reboot_after_use
    }
}
impl std::fmt::Debug for UpdateInstanceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInstanceProfileInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("package_cleanup", &self.package_cleanup);
        formatter.field(
            "exclude_app_packages_from_cleanup",
            &self.exclude_app_packages_from_cleanup,
        );
        formatter.field("reboot_after_use", &self.reboot_after_use);
        formatter.finish()
    }
}

/// <p>Represents a request to the update device pool operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDevicePoolInput {
    /// <p>The Amazon Resource Name (ARN) of the Device Farm device pool to update.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A string that represents the name of the device pool to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the device pool to update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
    /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
    /// <p>If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in the same request.</p>
    pub max_devices: std::option::Option<i32>,
    /// <p>Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the <code>rules</code> parameter.</p>
    /// <p>If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the same request.</p>
    pub clear_max_devices: std::option::Option<bool>,
}
impl UpdateDevicePoolInput {
    /// <p>The Amazon Resource Name (ARN) of the Device Farm device pool to update.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A string that represents the name of the device pool to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the device pool to update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
    /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
    /// <p>If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in the same request.</p>
    pub fn max_devices(&self) -> std::option::Option<i32> {
        self.max_devices
    }
    /// <p>Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the <code>rules</code> parameter.</p>
    /// <p>If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the same request.</p>
    pub fn clear_max_devices(&self) -> std::option::Option<bool> {
        self.clear_max_devices
    }
}
impl std::fmt::Debug for UpdateDevicePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDevicePoolInput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("rules", &self.rules);
        formatter.field("max_devices", &self.max_devices);
        formatter.field("clear_max_devices", &self.clear_max_devices);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the profile that you want to associate with the device instance.</p>
    pub profile_arn: std::option::Option<std::string::String>,
    /// <p>An array of strings that you want to associate with the device instance.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateDeviceInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the profile that you want to associate with the device instance.</p>
    pub fn profile_arn(&self) -> std::option::Option<&str> {
        self.profile_arn.as_deref()
    }
    /// <p>An array of strings that you want to associate with the device instance.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
}
impl std::fmt::Debug for UpdateDeviceInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceInstanceInput");
        formatter.field("arn", &self.arn);
        formatter.field("profile_arn", &self.profile_arn);
        formatter.field("labels", &self.labels);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource or resources from which to delete tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource or resources from which to delete tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource or resources to which to add tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource or resources to which to add tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the request to stop a specific run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopRunInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl StopRunInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for StopRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopRunInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents the request to stop the remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the remote access session to stop.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl StopRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the remote access session to stop.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for StopRemoteAccessSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopRemoteAccessSessionInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopJobInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl StopJobInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for StopJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopJobInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the schedule run operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleRunInput {
    /// <p>The ARN of the project for the run to be scheduled.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of an application package to run tests against, created with <code>CreateUpload</code>. See <code>ListUploads</code>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the device pool for the run to be scheduled.</p>
    pub device_pool_arn: std::option::Option<std::string::String>,
    /// <p>The filter criteria used to dynamically select a set of devices for a test run and the maximum number of devices to be included in the run.</p>
    /// <p>Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required in a request.</p>
    pub device_selection_configuration:
        std::option::Option<crate::model::DeviceSelectionConfiguration>,
    /// <p>The name for the run to be scheduled.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Information about the test for the run to be scheduled.</p>
    pub test: std::option::Option<crate::model::ScheduleRunTest>,
    /// <p>Information about the settings for the run to be scheduled.</p>
    pub configuration: std::option::Option<crate::model::ScheduleRunConfiguration>,
    /// <p>Specifies configuration information about a test run, such as the execution timeout (in minutes).</p>
    pub execution_configuration: std::option::Option<crate::model::ExecutionConfiguration>,
}
impl ScheduleRunInput {
    /// <p>The ARN of the project for the run to be scheduled.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The ARN of an application package to run tests against, created with <code>CreateUpload</code>. See <code>ListUploads</code>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The ARN of the device pool for the run to be scheduled.</p>
    pub fn device_pool_arn(&self) -> std::option::Option<&str> {
        self.device_pool_arn.as_deref()
    }
    /// <p>The filter criteria used to dynamically select a set of devices for a test run and the maximum number of devices to be included in the run.</p>
    /// <p>Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required in a request.</p>
    pub fn device_selection_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeviceSelectionConfiguration> {
        self.device_selection_configuration.as_ref()
    }
    /// <p>The name for the run to be scheduled.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Information about the test for the run to be scheduled.</p>
    pub fn test(&self) -> std::option::Option<&crate::model::ScheduleRunTest> {
        self.test.as_ref()
    }
    /// <p>Information about the settings for the run to be scheduled.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ScheduleRunConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>Specifies configuration information about a test run, such as the execution timeout (in minutes).</p>
    pub fn execution_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionConfiguration> {
        self.execution_configuration.as_ref()
    }
}
impl std::fmt::Debug for ScheduleRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleRunInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("app_arn", &self.app_arn);
        formatter.field("device_pool_arn", &self.device_pool_arn);
        formatter.field(
            "device_selection_configuration",
            &self.device_selection_configuration,
        );
        formatter.field("name", &self.name);
        formatter.field("test", &self.test);
        formatter.field("configuration", &self.configuration);
        formatter.field("execution_configuration", &self.execution_configuration);
        formatter.finish()
    }
}

/// <p>A request that represents an offering renewal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenewOfferingInput {
    /// <p>The ID of a request to renew an offering.</p>
    pub offering_id: std::option::Option<std::string::String>,
    /// <p>The quantity requested in an offering renewal.</p>
    pub quantity: std::option::Option<i32>,
}
impl RenewOfferingInput {
    /// <p>The ID of a request to renew an offering.</p>
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
    /// <p>The quantity requested in an offering renewal.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
}
impl std::fmt::Debug for RenewOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenewOfferingInput");
        formatter.field("offering_id", &self.offering_id);
        formatter.field("quantity", &self.quantity);
        formatter.finish()
    }
}

/// <p>Represents a request for a purchase offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseOfferingInput {
    /// <p>The ID of the offering.</p>
    pub offering_id: std::option::Option<std::string::String>,
    /// <p>The number of device slots to purchase in an offering request.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The ID of the offering promotion to be applied to the purchase.</p>
    pub offering_promotion_id: std::option::Option<std::string::String>,
}
impl PurchaseOfferingInput {
    /// <p>The ID of the offering.</p>
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
    /// <p>The number of device slots to purchase in an offering request.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The ID of the offering promotion to be applied to the purchase.</p>
    pub fn offering_promotion_id(&self) -> std::option::Option<&str> {
        self.offering_promotion_id.as_deref()
    }
}
impl std::fmt::Debug for PurchaseOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseOfferingInput");
        formatter.field("offering_id", &self.offering_id);
        formatter.field("quantity", &self.quantity);
        formatter.field("offering_promotion_id", &self.offering_promotion_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVpceConfigurationsInput {
    /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVpceConfigurationsInput {
    /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVpceConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVpceConfigurationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list uploads operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUploadsInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to list uploads.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of upload.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li> <p>ANDROID_APP</p> </li>
    /// <li> <p>IOS_APP</p> </li>
    /// <li> <p>WEB_APP</p> </li>
    /// <li> <p>EXTERNAL_DATA</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
    /// <li> <p> APPIUM_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
    /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::UploadType>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUploadsInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to list uploads.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of upload.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li> <p>ANDROID_APP</p> </li>
    /// <li> <p>IOS_APP</p> </li>
    /// <li> <p>WEB_APP</p> </li>
    /// <li> <p>EXTERNAL_DATA</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
    /// <li> <p> APPIUM_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
    /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UploadType> {
        self.r#type.as_ref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUploadsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUploadsInput");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list unique problems operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUniqueProblemsInput {
    /// <p>The unique problems' ARNs.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUniqueProblemsInput {
    /// <p>The unique problems' ARNs.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUniqueProblemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUniqueProblemsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list tests operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestsInput {
    /// <p>The test suite's Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestsInput {
    /// <p>The test suite's Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridSessionsInput {
    /// <p>ARN of a <code>TestGridProject</code>.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>Return only sessions in this state.</p>
    pub status: std::option::Option<crate::model::TestGridSessionStatus>,
    /// <p>Return only sessions created after this time.</p>
    pub creation_time_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Return only sessions created before this time.</p>
    pub creation_time_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Return only sessions that ended after this time.</p>
    pub end_time_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Return only sessions that ended before this time.</p>
    pub end_time_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Return only this many results at a time.</p>
    pub max_result: std::option::Option<i32>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridSessionsInput {
    /// <p>ARN of a <code>TestGridProject</code>.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>Return only sessions in this state.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TestGridSessionStatus> {
        self.status.as_ref()
    }
    /// <p>Return only sessions created after this time.</p>
    pub fn creation_time_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time_after.as_ref()
    }
    /// <p>Return only sessions created before this time.</p>
    pub fn creation_time_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time_before.as_ref()
    }
    /// <p>Return only sessions that ended after this time.</p>
    pub fn end_time_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time_after.as_ref()
    }
    /// <p>Return only sessions that ended before this time.</p>
    pub fn end_time_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time_before.as_ref()
    }
    /// <p>Return only this many results at a time.</p>
    pub fn max_result(&self) -> std::option::Option<i32> {
        self.max_result
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridSessionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridSessionsInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_time_after", &self.creation_time_after);
        formatter.field("creation_time_before", &self.creation_time_before);
        formatter.field("end_time_after", &self.end_time_after);
        formatter.field("end_time_before", &self.end_time_before);
        formatter.field("max_result", &self.max_result);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridSessionArtifactsInput {
    /// <p>The ARN of a <code>TestGridSession</code>. </p>
    pub session_arn: std::option::Option<std::string::String>,
    /// <p>Limit results to a specified type of artifact.</p>
    pub r#type: std::option::Option<crate::model::TestGridSessionArtifactCategory>,
    /// <p>The maximum number of results to be returned by a request.</p>
    pub max_result: std::option::Option<i32>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridSessionArtifactsInput {
    /// <p>The ARN of a <code>TestGridSession</code>. </p>
    pub fn session_arn(&self) -> std::option::Option<&str> {
        self.session_arn.as_deref()
    }
    /// <p>Limit results to a specified type of artifact.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestGridSessionArtifactCategory> {
        self.r#type.as_ref()
    }
    /// <p>The maximum number of results to be returned by a request.</p>
    pub fn max_result(&self) -> std::option::Option<i32> {
        self.max_result
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridSessionArtifactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridSessionArtifactsInput");
        formatter.field("session_arn", &self.session_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("max_result", &self.max_result);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridSessionActionsInput {
    /// <p>The ARN of the session to retrieve.</p>
    pub session_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of sessions to return per response.</p>
    pub max_result: std::option::Option<i32>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridSessionActionsInput {
    /// <p>The ARN of the session to retrieve.</p>
    pub fn session_arn(&self) -> std::option::Option<&str> {
        self.session_arn.as_deref()
    }
    /// <p>The maximum number of sessions to return per response.</p>
    pub fn max_result(&self) -> std::option::Option<i32> {
        self.max_result
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridSessionActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridSessionActionsInput");
        formatter.field("session_arn", &self.session_arn);
        formatter.field("max_result", &self.max_result);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridProjectsInput {
    /// <p>Return no more than this number of results.</p>
    pub max_result: std::option::Option<i32>,
    /// <p>From a response, used to continue a paginated listing. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridProjectsInput {
    /// <p>Return no more than this number of results.</p>
    pub fn max_result(&self) -> std::option::Option<i32> {
        self.max_result
    }
    /// <p>From a response, used to continue a paginated listing. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridProjectsInput");
        formatter.field("max_result", &self.max_result);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource or resources for which to list tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource or resources for which to list tags. You can associate tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>, <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>, <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and <code>VPCE_CONFIGURATION</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the list suites operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuitesInput {
    /// <p>The job's Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuitesInput {
    /// <p>The job's Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuitesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuitesInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list samples operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSamplesInput {
    /// <p>The Amazon Resource Name (ARN) of the job used to list samples.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSamplesInput {
    /// <p>The Amazon Resource Name (ARN) of the job used to list samples.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSamplesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSamplesInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list runs operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRunsInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to list runs.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRunsInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to list runs.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRunsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the request to return information about the remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRemoteAccessSessionsInput {
    /// <p>The Amazon Resource Name (ARN) of the project about which you are requesting information.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRemoteAccessSessionsInput {
    /// <p>The Amazon Resource Name (ARN) of the project about which you are requesting information.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRemoteAccessSessionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRemoteAccessSessionsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list projects operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm returns a list of all projects for the AWS account. You can also specify a project ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsInput {
    /// <p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm returns a list of all projects for the AWS account. You can also specify a project ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the request to list the offering transaction history.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingTransactionsInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingTransactionsInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingTransactionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingTransactionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the request to list all offerings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingsInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingsInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingPromotionsInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingPromotionsInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingPromotionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingPromotionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNetworkProfilesInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to list network profiles.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of network profile to return information about. Valid values are listed here.</p>
    pub r#type: std::option::Option<crate::model::NetworkProfileType>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNetworkProfilesInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to list network profiles.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of network profile to return information about. Valid values are listed here.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NetworkProfileType> {
        self.r#type.as_ref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNetworkProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNetworkProfilesInput");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list jobs operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p>The run's Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsInput {
    /// <p>The run's Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceProfilesInput {
    /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstanceProfilesInput {
    /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceProfilesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the result of a list devices request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesInput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.</p>
    /// <ul>
    /// <li> <p>Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.</p> <p>Allowed values include:</p>
    /// <ul>
    /// <li> <p>ARN: The Amazon Resource Name (ARN) of the device (for example, <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p> </li>
    /// <li> <p>PLATFORM: The device platform. Valid values are ANDROID or IOS.</p> </li>
    /// <li> <p>OS_VERSION: The operating system version (for example, 10.3.2).</p> </li>
    /// <li> <p>MODEL: The device model (for example, iPad 5th Gen).</p> </li>
    /// <li> <p>AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
    /// <li> <p>FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.</p> </li>
    /// <li> <p>MANUFACTURER: The device manufacturer (for example, Apple).</p> </li>
    /// <li> <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.</p> </li>
    /// <li> <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>, this attribute is ignored.</p> </li>
    /// <li> <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.</p> </li>
    /// <li> <p>INSTANCE_LABELS: The label of the device instance.</p> </li>
    /// <li> <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p> </li>
    /// </ul> </li>
    /// <li> <p>Operator: The filter operator.</p>
    /// <ul>
    /// <li> <p>The EQUALS operator is available for every attribute except INSTANCE_LABELS.</p> </li>
    /// <li> <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.</p> </li>
    /// <li> <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p> </li>
    /// <li> <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION attribute.</p> </li>
    /// </ul> </li>
    /// <li> <p>Values: An array of one or more filter values.</p>
    /// <ul>
    /// <li> <p>The IN and NOT_IN operators take a values array that has one or more elements.</p> </li>
    /// <li> <p>The other operators require an array with a single element.</p> </li>
    /// <li> <p>In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
    /// </ul> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
}
impl ListDevicesInput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.</p>
    /// <ul>
    /// <li> <p>Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.</p> <p>Allowed values include:</p>
    /// <ul>
    /// <li> <p>ARN: The Amazon Resource Name (ARN) of the device (for example, <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p> </li>
    /// <li> <p>PLATFORM: The device platform. Valid values are ANDROID or IOS.</p> </li>
    /// <li> <p>OS_VERSION: The operating system version (for example, 10.3.2).</p> </li>
    /// <li> <p>MODEL: The device model (for example, iPad 5th Gen).</p> </li>
    /// <li> <p>AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
    /// <li> <p>FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.</p> </li>
    /// <li> <p>MANUFACTURER: The device manufacturer (for example, Apple).</p> </li>
    /// <li> <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.</p> </li>
    /// <li> <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>, this attribute is ignored.</p> </li>
    /// <li> <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.</p> </li>
    /// <li> <p>INSTANCE_LABELS: The label of the device instance.</p> </li>
    /// <li> <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p> </li>
    /// </ul> </li>
    /// <li> <p>Operator: The filter operator.</p>
    /// <ul>
    /// <li> <p>The EQUALS operator is available for every attribute except INSTANCE_LABELS.</p> </li>
    /// <li> <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.</p> </li>
    /// <li> <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p> </li>
    /// <li> <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION attribute.</p> </li>
    /// </ul> </li>
    /// <li> <p>Values: An array of one or more filter values.</p>
    /// <ul>
    /// <li> <p>The IN and NOT_IN operators take a values array that has one or more elements.</p> </li>
    /// <li> <p>The other operators require an array with a single element.</p> </li>
    /// <li> <p>In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::DeviceFilter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesInput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

/// <p>Represents the result of a list device pools request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicePoolsInput {
    /// <p>The project ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The device pools' type.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li> <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p> </li>
    /// <li> <p>PRIVATE: A device pool that is created and managed by the device pool developer.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::DevicePoolType>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicePoolsInput {
    /// <p>The project ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The device pools' type.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li> <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p> </li>
    /// <li> <p>PRIVATE: A device pool that is created and managed by the device pool developer.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DevicePoolType> {
        self.r#type.as_ref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicePoolsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicePoolsInput");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceInstancesInput {
    /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeviceInstancesInput {
    /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeviceInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceInstancesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to the list artifacts operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArtifactsInput {
    /// <p>The run, job, suite, or test ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The artifacts' type.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li> <p>FILE</p> </li>
    /// <li> <p>LOG</p> </li>
    /// <li> <p>SCREENSHOT</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ArtifactCategory>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListArtifactsInput {
    /// <p>The run, job, suite, or test ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The artifacts' type.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li> <p>FILE</p> </li>
    /// <li> <p>LOG</p> </li>
    /// <li> <p>SCREENSHOT</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ArtifactCategory> {
        self.r#type.as_ref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListArtifactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArtifactsInput");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa format) as part of a remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstallToRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.</p>
    pub remote_access_session_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the app about which you are requesting information.</p>
    pub app_arn: std::option::Option<std::string::String>,
}
impl InstallToRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.</p>
    pub fn remote_access_session_arn(&self) -> std::option::Option<&str> {
        self.remote_access_session_arn.as_deref()
    }
    /// <p>The ARN of the app about which you are requesting information.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
}
impl std::fmt::Debug for InstallToRemoteAccessSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstallToRemoteAccessSessionInput");
        formatter.field("remote_access_session_arn", &self.remote_access_session_arn);
        formatter.field("app_arn", &self.app_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpceConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to describe.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetVpceConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to describe.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetVpceConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpceConfigurationInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get upload operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUploadInput {
    /// <p>The upload's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetUploadInput {
    /// <p>The upload's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUploadInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTestGridSessionInput {
    /// <p>The ARN for the project that this session belongs to. See <code>CreateTestGridProject</code> and <code>ListTestGridProjects</code>.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>An ID associated with this session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>An ARN that uniquely identifies a <code>TestGridSession</code>.</p>
    pub session_arn: std::option::Option<std::string::String>,
}
impl GetTestGridSessionInput {
    /// <p>The ARN for the project that this session belongs to. See <code>CreateTestGridProject</code> and <code>ListTestGridProjects</code>.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>An ID associated with this session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>An ARN that uniquely identifies a <code>TestGridSession</code>.</p>
    pub fn session_arn(&self) -> std::option::Option<&str> {
        self.session_arn.as_deref()
    }
}
impl std::fmt::Debug for GetTestGridSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTestGridSessionInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("session_id", &self.session_id);
        formatter.field("session_arn", &self.session_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTestGridProjectInput {
    /// <p>The ARN of the Selenium testing project, from either <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl GetTestGridProjectInput {
    /// <p>The ARN of the Selenium testing project, from either <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for GetTestGridProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTestGridProjectInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get test operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTestInput {
    /// <p>The test's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetTestInput {
    /// <p>The test's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetTestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTestInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get suite operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteInput {
    /// <p>The suite's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetSuiteInput {
    /// <p>The suite's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetSuiteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get run operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRunInput {
    /// <p>The run's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetRunInput {
    /// <p>The run's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRunInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents the request to get information about the specified remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the remote access session about which you want to get session information.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the remote access session about which you want to get session information.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetRemoteAccessSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRemoteAccessSessionInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get project operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProjectInput {
    /// <p>The project's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetProjectInput {
    /// <p>The project's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProjectInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents the request to retrieve the offering status for the specified customer or account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOfferingStatusInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOfferingStatusInput {
    /// <p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOfferingStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOfferingStatusInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkProfileInput {
    /// <p>The ARN of the network profile to return information about.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetNetworkProfileInput {
    /// <p>The ARN of the network profile to return information about.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkProfileInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get job operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobInput {
    /// <p>The job's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetJobInput {
    /// <p>The job's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInstanceProfileInput {
    /// <p>The Amazon Resource Name (ARN) of an instance profile.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetInstanceProfileInput {
    /// <p>The Amazon Resource Name (ARN) of an instance profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetInstanceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInstanceProfileInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get device pool compatibility operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePoolCompatibilityInput {
    /// <p>The device pool's ARN.</p>
    pub device_pool_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the app that is associated with the specified device pool.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The test type for the specified device pool.</p>
    /// <p>Allowed values include the following:</p>
    /// <ul>
    /// <li> <p>BUILTIN_FUZZ.</p> </li>
    /// <li> <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT.</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG.</p> </li>
    /// <li> <p>APPIUM_PYTHON.</p> </li>
    /// <li> <p>APPIUM_NODE.</p> </li>
    /// <li> <p>APPIUM_RUBY.</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT.</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG.</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON.</p> </li>
    /// <li> <p>APPIUM_WEB_NODE.</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY.</p> </li>
    /// <li> <p>CALABASH.</p> </li>
    /// <li> <p>INSTRUMENTATION.</p> </li>
    /// <li> <p>UIAUTOMATION.</p> </li>
    /// <li> <p>UIAUTOMATOR.</p> </li>
    /// <li> <p>XCTEST.</p> </li>
    /// <li> <p>XCTEST_UI.</p> </li>
    /// </ul>
    pub test_type: std::option::Option<crate::model::TestType>,
    /// <p>Information about the uploaded test to be run against the device pool.</p>
    pub test: std::option::Option<crate::model::ScheduleRunTest>,
    /// <p>An object that contains information about the settings for a run.</p>
    pub configuration: std::option::Option<crate::model::ScheduleRunConfiguration>,
}
impl GetDevicePoolCompatibilityInput {
    /// <p>The device pool's ARN.</p>
    pub fn device_pool_arn(&self) -> std::option::Option<&str> {
        self.device_pool_arn.as_deref()
    }
    /// <p>The ARN of the app that is associated with the specified device pool.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The test type for the specified device pool.</p>
    /// <p>Allowed values include the following:</p>
    /// <ul>
    /// <li> <p>BUILTIN_FUZZ.</p> </li>
    /// <li> <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT.</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG.</p> </li>
    /// <li> <p>APPIUM_PYTHON.</p> </li>
    /// <li> <p>APPIUM_NODE.</p> </li>
    /// <li> <p>APPIUM_RUBY.</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT.</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG.</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON.</p> </li>
    /// <li> <p>APPIUM_WEB_NODE.</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY.</p> </li>
    /// <li> <p>CALABASH.</p> </li>
    /// <li> <p>INSTRUMENTATION.</p> </li>
    /// <li> <p>UIAUTOMATION.</p> </li>
    /// <li> <p>UIAUTOMATOR.</p> </li>
    /// <li> <p>XCTEST.</p> </li>
    /// <li> <p>XCTEST_UI.</p> </li>
    /// </ul>
    pub fn test_type(&self) -> std::option::Option<&crate::model::TestType> {
        self.test_type.as_ref()
    }
    /// <p>Information about the uploaded test to be run against the device pool.</p>
    pub fn test(&self) -> std::option::Option<&crate::model::ScheduleRunTest> {
        self.test.as_ref()
    }
    /// <p>An object that contains information about the settings for a run.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ScheduleRunConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for GetDevicePoolCompatibilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePoolCompatibilityInput");
        formatter.field("device_pool_arn", &self.device_pool_arn);
        formatter.field("app_arn", &self.app_arn);
        formatter.field("test_type", &self.test_type);
        formatter.field("test", &self.test);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}

/// <p>Represents a request to the get device pool operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePoolInput {
    /// <p>The device pool's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetDevicePoolInput {
    /// <p>The device pool's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetDevicePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePoolInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the instance you're requesting information about.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetDeviceInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the instance you're requesting information about.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetDeviceInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceInstanceInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the get device request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceInput {
    /// <p>The device type's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetDeviceInput {
    /// <p>The device type's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents the request sent to retrieve the account settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSettingsInput {}
impl std::fmt::Debug for GetAccountSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSettingsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpceConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteVpceConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteVpceConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpceConfigurationInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the delete upload operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUploadInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteUploadInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUploadInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTestGridProjectInput {
    /// <p>The ARN of the project to delete, from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl DeleteTestGridProjectInput {
    /// <p>The ARN of the project to delete, from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteTestGridProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTestGridProjectInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the delete run operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRunInput {
    /// <p>The Amazon Resource Name (ARN) for the run to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteRunInput {
    /// <p>The Amazon Resource Name (ARN) for the run to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRunInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents the request to delete the specified remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the session for which you want to delete remote access.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the session for which you want to delete remote access.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteRemoteAccessSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRemoteAccessSessionInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the delete project operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNetworkProfileInput {
    /// <p>The ARN of the network profile to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteNetworkProfileInput {
    /// <p>The ARN of the network profile to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNetworkProfileInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInstanceProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the instance profile you are requesting to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteInstanceProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the instance profile you are requesting to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteInstanceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInstanceProfileInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

/// <p>Represents a request to the delete device pool operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDevicePoolInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteDevicePoolInput {
    /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDevicePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDevicePoolInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpceConfigurationInput {
    /// <p>The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.</p>
    pub vpce_configuration_name: std::option::Option<std::string::String>,
    /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
    pub vpce_service_name: std::option::Option<std::string::String>,
    /// <p>The DNS name of the service running in your VPC that you want Device Farm to test.</p>
    pub service_dns_name: std::option::Option<std::string::String>,
    /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
    pub vpce_configuration_description: std::option::Option<std::string::String>,
}
impl CreateVpceConfigurationInput {
    /// <p>The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.</p>
    pub fn vpce_configuration_name(&self) -> std::option::Option<&str> {
        self.vpce_configuration_name.as_deref()
    }
    /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
    pub fn vpce_service_name(&self) -> std::option::Option<&str> {
        self.vpce_service_name.as_deref()
    }
    /// <p>The DNS name of the service running in your VPC that you want Device Farm to test.</p>
    pub fn service_dns_name(&self) -> std::option::Option<&str> {
        self.service_dns_name.as_deref()
    }
    /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
    pub fn vpce_configuration_description(&self) -> std::option::Option<&str> {
        self.vpce_configuration_description.as_deref()
    }
}
impl std::fmt::Debug for CreateVpceConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpceConfigurationInput");
        formatter.field("vpce_configuration_name", &self.vpce_configuration_name);
        formatter.field("vpce_service_name", &self.vpce_service_name);
        formatter.field("service_dns_name", &self.service_dns_name);
        formatter.field(
            "vpce_configuration_description",
            &self.vpce_configuration_description,
        );
        formatter.finish()
    }
}

/// <p>Represents a request to the create upload operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUploadInput {
    /// <p>The ARN of the project for the upload.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The upload's file name. The name should not contain any forward slashes (<code>/</code>). If you are uploading an iOS app, the file name must end with the <code>.ipa</code> extension. If you are uploading an Android app, the file name must end with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file extension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The upload's upload type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li> <p>ANDROID_APP</p> </li>
    /// <li> <p>IOS_APP</p> </li>
    /// <li> <p>WEB_APP</p> </li>
    /// <li> <p>EXTERNAL_DATA</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
    /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
    /// </ul>
    /// <p> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an <code>ArgumentException</code> error.</p>
    pub r#type: std::option::Option<crate::model::UploadType>,
    /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl CreateUploadInput {
    /// <p>The ARN of the project for the upload.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The upload's file name. The name should not contain any forward slashes (<code>/</code>). If you are uploading an iOS app, the file name must end with the <code>.ipa</code> extension. If you are uploading an Android app, the file name must end with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The upload's upload type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li> <p>ANDROID_APP</p> </li>
    /// <li> <p>IOS_APP</p> </li>
    /// <li> <p>WEB_APP</p> </li>
    /// <li> <p>EXTERNAL_DATA</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p> </li>
    /// <li> <p>CALABASH_TEST_PACKAGE</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATION_TEST_PACKAGE</p> </li>
    /// <li> <p>UIAUTOMATOR_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_TEST_PACKAGE</p> </li>
    /// <li> <p>XCTEST_UI_TEST_PACKAGE</p> </li>
    /// <li> <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_NODE_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_PYTHON_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_NODE_TEST_SPEC</p> </li>
    /// <li> <p>APPIUM_WEB_RUBY_TEST_SPEC</p> </li>
    /// <li> <p>INSTRUMENTATION_TEST_SPEC</p> </li>
    /// <li> <p>XCTEST_UI_TEST_SPEC</p> </li>
    /// </ul>
    /// <p> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an <code>ArgumentException</code> error.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UploadType> {
        self.r#type.as_ref()
    }
    /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for CreateUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUploadInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTestGridUrlInput {
    /// <p>ARN (from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>) to associate with the short-term URL. </p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>Lifetime, in seconds, of the URL.</p>
    pub expires_in_seconds: std::option::Option<i32>,
}
impl CreateTestGridUrlInput {
    /// <p>ARN (from <code>CreateTestGridProject</code> or <code>ListTestGridProjects</code>) to associate with the short-term URL. </p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>Lifetime, in seconds, of the URL.</p>
    pub fn expires_in_seconds(&self) -> std::option::Option<i32> {
        self.expires_in_seconds
    }
}
impl std::fmt::Debug for CreateTestGridUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTestGridUrlInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("expires_in_seconds", &self.expires_in_seconds);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTestGridProjectInput {
    /// <p>Human-readable name of the Selenium testing project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Human-readable description of the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The VPC security groups and subnets that are attached to a project.</p>
    pub vpc_config: std::option::Option<crate::model::TestGridVpcConfig>,
}
impl CreateTestGridProjectInput {
    /// <p>Human-readable name of the Selenium testing project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Human-readable description of the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The VPC security groups and subnets that are attached to a project.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::TestGridVpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for CreateTestGridProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTestGridProjectInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}

/// <p>Creates and submits a request to start a remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the device for which you want to create a remote access session.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
    pub remote_debug_enabled: std::option::Option<bool>,
    /// <p>Set to <code>true</code> to enable remote recording for the remote access session.</p>
    pub remote_record_enabled: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.</p>
    pub remote_record_app_arn: std::option::Option<std::string::String>,
    /// <p>The name of the remote access session to create.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The configuration information for the remote access session request.</p>
    pub configuration: std::option::Option<crate::model::CreateRemoteAccessSessionConfiguration>,
    /// <p>The interaction mode of the remote access session. Valid values are:</p>
    /// <ul>
    /// <li> <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.</p> </li>
    /// <li> <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.</p> </li>
    /// <li> <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.</p> </li>
    /// </ul>
    pub interaction_mode: std::option::Option<crate::model::InteractionMode>,
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.</p>
    /// <p>For more information on how Device Farm modifies your uploads during tests, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> </p>
    pub skip_app_resign: std::option::Option<bool>,
}
impl CreateRemoteAccessSessionInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The ARN of the device for which you want to create a remote access session.</p>
    pub fn device_arn(&self) -> std::option::Option<&str> {
        self.device_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the device instance for which you want to create a remote access session.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
    pub fn remote_debug_enabled(&self) -> std::option::Option<bool> {
        self.remote_debug_enabled
    }
    /// <p>Set to <code>true</code> to enable remote recording for the remote access session.</p>
    pub fn remote_record_enabled(&self) -> std::option::Option<bool> {
        self.remote_record_enabled
    }
    /// <p>The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.</p>
    pub fn remote_record_app_arn(&self) -> std::option::Option<&str> {
        self.remote_record_app_arn.as_deref()
    }
    /// <p>The name of the remote access session to create.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The configuration information for the remote access session request.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateRemoteAccessSessionConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The interaction mode of the remote access session. Valid values are:</p>
    /// <ul>
    /// <li> <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.</p> </li>
    /// <li> <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.</p> </li>
    /// <li> <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.</p> </li>
    /// </ul>
    pub fn interaction_mode(&self) -> std::option::Option<&crate::model::InteractionMode> {
        self.interaction_mode.as_ref()
    }
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.</p>
    /// <p>For more information on how Device Farm modifies your uploads during tests, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> </p>
    pub fn skip_app_resign(&self) -> std::option::Option<bool> {
        self.skip_app_resign
    }
}
impl std::fmt::Debug for CreateRemoteAccessSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRemoteAccessSessionInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("remote_debug_enabled", &self.remote_debug_enabled);
        formatter.field("remote_record_enabled", &self.remote_record_enabled);
        formatter.field("remote_record_app_arn", &self.remote_record_app_arn);
        formatter.field("name", &self.name);
        formatter.field("client_id", &self.client_id);
        formatter.field("configuration", &self.configuration);
        formatter.field("interaction_mode", &self.interaction_mode);
        formatter.field("skip_app_resign", &self.skip_app_resign);
        formatter.finish()
    }
}

/// <p>Represents a request to the create project operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>The project's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Sets the execution timeout value (in minutes) for a project. All test runs in this project use the specified execution timeout value unless overridden when scheduling a run.</p>
    pub default_job_timeout_minutes: std::option::Option<i32>,
}
impl CreateProjectInput {
    /// <p>The project's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Sets the execution timeout value (in minutes) for a project. All test runs in this project use the specified execution timeout value unless overridden when scheduling a run.</p>
    pub fn default_job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.default_job_timeout_minutes
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("name", &self.name);
        formatter.field(
            "default_job_timeout_minutes",
            &self.default_job_timeout_minutes,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNetworkProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a network profile.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The name for the new network profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the network profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of network profile to create. Valid values are listed here.</p>
    pub r#type: std::option::Option<crate::model::NetworkProfileType>,
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub uplink_bandwidth_bits: std::option::Option<i64>,
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub downlink_bandwidth_bits: std::option::Option<i64>,
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub uplink_delay_ms: std::option::Option<i64>,
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub downlink_delay_ms: std::option::Option<i64>,
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub uplink_jitter_ms: std::option::Option<i64>,
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub downlink_jitter_ms: std::option::Option<i64>,
    /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
    pub uplink_loss_percent: i32,
    /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
    pub downlink_loss_percent: i32,
}
impl CreateNetworkProfileInput {
    /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a network profile.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The name for the new network profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the network profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of network profile to create. Valid values are listed here.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NetworkProfileType> {
        self.r#type.as_ref()
    }
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub fn uplink_bandwidth_bits(&self) -> std::option::Option<i64> {
        self.uplink_bandwidth_bits
    }
    /// <p>The data throughput rate in bits per second, as an integer from 0 to 104857600.</p>
    pub fn downlink_bandwidth_bits(&self) -> std::option::Option<i64> {
        self.downlink_bandwidth_bits
    }
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub fn uplink_delay_ms(&self) -> std::option::Option<i64> {
        self.uplink_delay_ms
    }
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.</p>
    pub fn downlink_delay_ms(&self) -> std::option::Option<i64> {
        self.downlink_delay_ms
    }
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub fn uplink_jitter_ms(&self) -> std::option::Option<i64> {
        self.uplink_jitter_ms
    }
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.</p>
    pub fn downlink_jitter_ms(&self) -> std::option::Option<i64> {
        self.downlink_jitter_ms
    }
    /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100 percent.</p>
    pub fn uplink_loss_percent(&self) -> i32 {
        self.uplink_loss_percent
    }
    /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
    pub fn downlink_loss_percent(&self) -> i32 {
        self.downlink_loss_percent
    }
}
impl std::fmt::Debug for CreateNetworkProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNetworkProfileInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("uplink_bandwidth_bits", &self.uplink_bandwidth_bits);
        formatter.field("downlink_bandwidth_bits", &self.downlink_bandwidth_bits);
        formatter.field("uplink_delay_ms", &self.uplink_delay_ms);
        formatter.field("downlink_delay_ms", &self.downlink_delay_ms);
        formatter.field("uplink_jitter_ms", &self.uplink_jitter_ms);
        formatter.field("downlink_jitter_ms", &self.downlink_jitter_ms);
        formatter.field("uplink_loss_percent", &self.uplink_loss_percent);
        formatter.field("downlink_loss_percent", &self.downlink_loss_percent);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInstanceProfileInput {
    /// <p>The name of your instance profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of your instance profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is <code>false</code> for private devices.</p>
    pub package_cleanup: std::option::Option<bool>,
    /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.</p>
    /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to <code>true</code>.</p>
    pub exclude_app_packages_from_cleanup: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is <code>true</code>.</p>
    pub reboot_after_use: std::option::Option<bool>,
}
impl CreateInstanceProfileInput {
    /// <p>The name of your instance profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of your instance profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is <code>false</code> for private devices.</p>
    pub fn package_cleanup(&self) -> std::option::Option<bool> {
        self.package_cleanup
    }
    /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.</p>
    /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to <code>true</code>.</p>
    pub fn exclude_app_packages_from_cleanup(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_app_packages_from_cleanup.as_deref()
    }
    /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is <code>true</code>.</p>
    pub fn reboot_after_use(&self) -> std::option::Option<bool> {
        self.reboot_after_use
    }
}
impl std::fmt::Debug for CreateInstanceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInstanceProfileInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("package_cleanup", &self.package_cleanup);
        formatter.field(
            "exclude_app_packages_from_cleanup",
            &self.exclude_app_packages_from_cleanup,
        );
        formatter.field("reboot_after_use", &self.reboot_after_use);
        formatter.finish()
    }
}

/// <p>Represents a request to the create device pool operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDevicePoolInput {
    /// <p>The ARN of the project for the device pool.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The device pool's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The device pool's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The device pool's rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
    /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
    pub max_devices: std::option::Option<i32>,
}
impl CreateDevicePoolInput {
    /// <p>The ARN of the project for the device pool.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The device pool's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The device pool's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The device pool's rules.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.</p>
    /// <p>By specifying the maximum number of devices, you can control the costs that you incur by running tests.</p>
    pub fn max_devices(&self) -> std::option::Option<i32> {
        self.max_devices
    }
}
impl std::fmt::Debug for CreateDevicePoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDevicePoolInput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("rules", &self.rules);
        formatter.field("max_devices", &self.max_devices);
        formatter.finish()
    }
}
