// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVpceConfigurationOutput {
    /// <p>An object that contains information about your VPC endpoint configuration.</p>
    pub vpce_configuration: std::option::Option<crate::model::VpceConfiguration>,
}
impl UpdateVpceConfigurationOutput {
    /// <p>An object that contains information about your VPC endpoint configuration.</p>
    pub fn vpce_configuration(&self) -> std::option::Option<&crate::model::VpceConfiguration> {
        self.vpce_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateVpceConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVpceConfigurationOutput");
        formatter.field("vpce_configuration", &self.vpce_configuration);
        formatter.finish()
    }
}
/// See [`UpdateVpceConfigurationOutput`](crate::output::UpdateVpceConfigurationOutput)
pub mod update_vpce_configuration_output {
    /// A builder for [`UpdateVpceConfigurationOutput`](crate::output::UpdateVpceConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpce_configuration: std::option::Option<crate::model::VpceConfiguration>,
    }
    impl Builder {
        /// <p>An object that contains information about your VPC endpoint configuration.</p>
        pub fn vpce_configuration(mut self, input: crate::model::VpceConfiguration) -> Self {
            self.vpce_configuration = Some(input);
            self
        }
        /// <p>An object that contains information about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration(
            mut self,
            input: std::option::Option<crate::model::VpceConfiguration>,
        ) -> Self {
            self.vpce_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVpceConfigurationOutput`](crate::output::UpdateVpceConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateVpceConfigurationOutput {
            crate::output::UpdateVpceConfigurationOutput {
                vpce_configuration: self.vpce_configuration,
            }
        }
    }
}
impl UpdateVpceConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVpceConfigurationOutput`](crate::output::UpdateVpceConfigurationOutput)
    pub fn builder() -> crate::output::update_vpce_configuration_output::Builder {
        crate::output::update_vpce_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUploadOutput {
    /// <p>A test spec uploaded to Device Farm.</p>
    pub upload: std::option::Option<crate::model::Upload>,
}
impl UpdateUploadOutput {
    /// <p>A test spec uploaded to Device Farm.</p>
    pub fn upload(&self) -> std::option::Option<&crate::model::Upload> {
        self.upload.as_ref()
    }
}
impl std::fmt::Debug for UpdateUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUploadOutput");
        formatter.field("upload", &self.upload);
        formatter.finish()
    }
}
/// See [`UpdateUploadOutput`](crate::output::UpdateUploadOutput)
pub mod update_upload_output {
    /// A builder for [`UpdateUploadOutput`](crate::output::UpdateUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload: std::option::Option<crate::model::Upload>,
    }
    impl Builder {
        /// <p>A test spec uploaded to Device Farm.</p>
        pub fn upload(mut self, input: crate::model::Upload) -> Self {
            self.upload = Some(input);
            self
        }
        /// <p>A test spec uploaded to Device Farm.</p>
        pub fn set_upload(mut self, input: std::option::Option<crate::model::Upload>) -> Self {
            self.upload = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUploadOutput`](crate::output::UpdateUploadOutput)
        pub fn build(self) -> crate::output::UpdateUploadOutput {
            crate::output::UpdateUploadOutput {
                upload: self.upload,
            }
        }
    }
}
impl UpdateUploadOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUploadOutput`](crate::output::UpdateUploadOutput)
    pub fn builder() -> crate::output::update_upload_output::Builder {
        crate::output::update_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTestGridProjectOutput {
    /// <p>The project, including updated information.</p>
    pub test_grid_project: std::option::Option<crate::model::TestGridProject>,
}
impl UpdateTestGridProjectOutput {
    /// <p>The project, including updated information.</p>
    pub fn test_grid_project(&self) -> std::option::Option<&crate::model::TestGridProject> {
        self.test_grid_project.as_ref()
    }
}
impl std::fmt::Debug for UpdateTestGridProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTestGridProjectOutput");
        formatter.field("test_grid_project", &self.test_grid_project);
        formatter.finish()
    }
}
/// See [`UpdateTestGridProjectOutput`](crate::output::UpdateTestGridProjectOutput)
pub mod update_test_grid_project_output {
    /// A builder for [`UpdateTestGridProjectOutput`](crate::output::UpdateTestGridProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_grid_project: std::option::Option<crate::model::TestGridProject>,
    }
    impl Builder {
        /// <p>The project, including updated information.</p>
        pub fn test_grid_project(mut self, input: crate::model::TestGridProject) -> Self {
            self.test_grid_project = Some(input);
            self
        }
        /// <p>The project, including updated information.</p>
        pub fn set_test_grid_project(
            mut self,
            input: std::option::Option<crate::model::TestGridProject>,
        ) -> Self {
            self.test_grid_project = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTestGridProjectOutput`](crate::output::UpdateTestGridProjectOutput)
        pub fn build(self) -> crate::output::UpdateTestGridProjectOutput {
            crate::output::UpdateTestGridProjectOutput {
                test_grid_project: self.test_grid_project,
            }
        }
    }
}
impl UpdateTestGridProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTestGridProjectOutput`](crate::output::UpdateTestGridProjectOutput)
    pub fn builder() -> crate::output::update_test_grid_project_output::Builder {
        crate::output::update_test_grid_project_output::Builder::default()
    }
}

/// <p>Represents the result of an update project request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {
    /// <p>The project to update.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl UpdateProjectOutput {
    /// <p>The project to update.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>The project to update.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>The project to update.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {
                project: self.project,
            }
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkProfileOutput {
    /// <p>A list of the available network profiles.</p>
    pub network_profile: std::option::Option<crate::model::NetworkProfile>,
}
impl UpdateNetworkProfileOutput {
    /// <p>A list of the available network profiles.</p>
    pub fn network_profile(&self) -> std::option::Option<&crate::model::NetworkProfile> {
        self.network_profile.as_ref()
    }
}
impl std::fmt::Debug for UpdateNetworkProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkProfileOutput");
        formatter.field("network_profile", &self.network_profile);
        formatter.finish()
    }
}
/// See [`UpdateNetworkProfileOutput`](crate::output::UpdateNetworkProfileOutput)
pub mod update_network_profile_output {
    /// A builder for [`UpdateNetworkProfileOutput`](crate::output::UpdateNetworkProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile: std::option::Option<crate::model::NetworkProfile>,
    }
    impl Builder {
        /// <p>A list of the available network profiles.</p>
        pub fn network_profile(mut self, input: crate::model::NetworkProfile) -> Self {
            self.network_profile = Some(input);
            self
        }
        /// <p>A list of the available network profiles.</p>
        pub fn set_network_profile(
            mut self,
            input: std::option::Option<crate::model::NetworkProfile>,
        ) -> Self {
            self.network_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkProfileOutput`](crate::output::UpdateNetworkProfileOutput)
        pub fn build(self) -> crate::output::UpdateNetworkProfileOutput {
            crate::output::UpdateNetworkProfileOutput {
                network_profile: self.network_profile,
            }
        }
    }
}
impl UpdateNetworkProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkProfileOutput`](crate::output::UpdateNetworkProfileOutput)
    pub fn builder() -> crate::output::update_network_profile_output::Builder {
        crate::output::update_network_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstanceProfileOutput {
    /// <p>An object that contains information about your instance profile.</p>
    pub instance_profile: std::option::Option<crate::model::InstanceProfile>,
}
impl UpdateInstanceProfileOutput {
    /// <p>An object that contains information about your instance profile.</p>
    pub fn instance_profile(&self) -> std::option::Option<&crate::model::InstanceProfile> {
        self.instance_profile.as_ref()
    }
}
impl std::fmt::Debug for UpdateInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInstanceProfileOutput");
        formatter.field("instance_profile", &self.instance_profile);
        formatter.finish()
    }
}
/// See [`UpdateInstanceProfileOutput`](crate::output::UpdateInstanceProfileOutput)
pub mod update_instance_profile_output {
    /// A builder for [`UpdateInstanceProfileOutput`](crate::output::UpdateInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile: std::option::Option<crate::model::InstanceProfile>,
    }
    impl Builder {
        /// <p>An object that contains information about your instance profile.</p>
        pub fn instance_profile(mut self, input: crate::model::InstanceProfile) -> Self {
            self.instance_profile = Some(input);
            self
        }
        /// <p>An object that contains information about your instance profile.</p>
        pub fn set_instance_profile(
            mut self,
            input: std::option::Option<crate::model::InstanceProfile>,
        ) -> Self {
            self.instance_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInstanceProfileOutput`](crate::output::UpdateInstanceProfileOutput)
        pub fn build(self) -> crate::output::UpdateInstanceProfileOutput {
            crate::output::UpdateInstanceProfileOutput {
                instance_profile: self.instance_profile,
            }
        }
    }
}
impl UpdateInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInstanceProfileOutput`](crate::output::UpdateInstanceProfileOutput)
    pub fn builder() -> crate::output::update_instance_profile_output::Builder {
        crate::output::update_instance_profile_output::Builder::default()
    }
}

/// <p>Represents the result of an update device pool request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDevicePoolOutput {
    /// <p>The device pool you just updated.</p>
    pub device_pool: std::option::Option<crate::model::DevicePool>,
}
impl UpdateDevicePoolOutput {
    /// <p>The device pool you just updated.</p>
    pub fn device_pool(&self) -> std::option::Option<&crate::model::DevicePool> {
        self.device_pool.as_ref()
    }
}
impl std::fmt::Debug for UpdateDevicePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDevicePoolOutput");
        formatter.field("device_pool", &self.device_pool);
        formatter.finish()
    }
}
/// See [`UpdateDevicePoolOutput`](crate::output::UpdateDevicePoolOutput)
pub mod update_device_pool_output {
    /// A builder for [`UpdateDevicePoolOutput`](crate::output::UpdateDevicePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_pool: std::option::Option<crate::model::DevicePool>,
    }
    impl Builder {
        /// <p>The device pool you just updated.</p>
        pub fn device_pool(mut self, input: crate::model::DevicePool) -> Self {
            self.device_pool = Some(input);
            self
        }
        /// <p>The device pool you just updated.</p>
        pub fn set_device_pool(
            mut self,
            input: std::option::Option<crate::model::DevicePool>,
        ) -> Self {
            self.device_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDevicePoolOutput`](crate::output::UpdateDevicePoolOutput)
        pub fn build(self) -> crate::output::UpdateDevicePoolOutput {
            crate::output::UpdateDevicePoolOutput {
                device_pool: self.device_pool,
            }
        }
    }
}
impl UpdateDevicePoolOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDevicePoolOutput`](crate::output::UpdateDevicePoolOutput)
    pub fn builder() -> crate::output::update_device_pool_output::Builder {
        crate::output::update_device_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceInstanceOutput {
    /// <p>An object that contains information about your device instance.</p>
    pub device_instance: std::option::Option<crate::model::DeviceInstance>,
}
impl UpdateDeviceInstanceOutput {
    /// <p>An object that contains information about your device instance.</p>
    pub fn device_instance(&self) -> std::option::Option<&crate::model::DeviceInstance> {
        self.device_instance.as_ref()
    }
}
impl std::fmt::Debug for UpdateDeviceInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceInstanceOutput");
        formatter.field("device_instance", &self.device_instance);
        formatter.finish()
    }
}
/// See [`UpdateDeviceInstanceOutput`](crate::output::UpdateDeviceInstanceOutput)
pub mod update_device_instance_output {
    /// A builder for [`UpdateDeviceInstanceOutput`](crate::output::UpdateDeviceInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_instance: std::option::Option<crate::model::DeviceInstance>,
    }
    impl Builder {
        /// <p>An object that contains information about your device instance.</p>
        pub fn device_instance(mut self, input: crate::model::DeviceInstance) -> Self {
            self.device_instance = Some(input);
            self
        }
        /// <p>An object that contains information about your device instance.</p>
        pub fn set_device_instance(
            mut self,
            input: std::option::Option<crate::model::DeviceInstance>,
        ) -> Self {
            self.device_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceInstanceOutput`](crate::output::UpdateDeviceInstanceOutput)
        pub fn build(self) -> crate::output::UpdateDeviceInstanceOutput {
            crate::output::UpdateDeviceInstanceOutput {
                device_instance: self.device_instance,
            }
        }
    }
}
impl UpdateDeviceInstanceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceInstanceOutput`](crate::output::UpdateDeviceInstanceOutput)
    pub fn builder() -> crate::output::update_device_instance_output::Builder {
        crate::output::update_device_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>Represents the results of your stop run attempt.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopRunOutput {
    /// <p>The run that was stopped.</p>
    pub run: std::option::Option<crate::model::Run>,
}
impl StopRunOutput {
    /// <p>The run that was stopped.</p>
    pub fn run(&self) -> std::option::Option<&crate::model::Run> {
        self.run.as_ref()
    }
}
impl std::fmt::Debug for StopRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopRunOutput");
        formatter.field("run", &self.run);
        formatter.finish()
    }
}
/// See [`StopRunOutput`](crate::output::StopRunOutput)
pub mod stop_run_output {
    /// A builder for [`StopRunOutput`](crate::output::StopRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run: std::option::Option<crate::model::Run>,
    }
    impl Builder {
        /// <p>The run that was stopped.</p>
        pub fn run(mut self, input: crate::model::Run) -> Self {
            self.run = Some(input);
            self
        }
        /// <p>The run that was stopped.</p>
        pub fn set_run(mut self, input: std::option::Option<crate::model::Run>) -> Self {
            self.run = input;
            self
        }
        /// Consumes the builder and constructs a [`StopRunOutput`](crate::output::StopRunOutput)
        pub fn build(self) -> crate::output::StopRunOutput {
            crate::output::StopRunOutput { run: self.run }
        }
    }
}
impl StopRunOutput {
    /// Creates a new builder-style object to manufacture [`StopRunOutput`](crate::output::StopRunOutput)
    pub fn builder() -> crate::output::stop_run_output::Builder {
        crate::output::stop_run_output::Builder::default()
    }
}

/// <p>Represents the response from the server that describes the remote access session
/// when AWS Device Farm stops the session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopRemoteAccessSessionOutput {
    /// <p>A container that represents the metadata from the service about the remote access session you are
    /// stopping.</p>
    pub remote_access_session: std::option::Option<crate::model::RemoteAccessSession>,
}
impl StopRemoteAccessSessionOutput {
    /// <p>A container that represents the metadata from the service about the remote access session you are
    /// stopping.</p>
    pub fn remote_access_session(&self) -> std::option::Option<&crate::model::RemoteAccessSession> {
        self.remote_access_session.as_ref()
    }
}
impl std::fmt::Debug for StopRemoteAccessSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopRemoteAccessSessionOutput");
        formatter.field("remote_access_session", &self.remote_access_session);
        formatter.finish()
    }
}
/// See [`StopRemoteAccessSessionOutput`](crate::output::StopRemoteAccessSessionOutput)
pub mod stop_remote_access_session_output {
    /// A builder for [`StopRemoteAccessSessionOutput`](crate::output::StopRemoteAccessSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remote_access_session: std::option::Option<crate::model::RemoteAccessSession>,
    }
    impl Builder {
        /// <p>A container that represents the metadata from the service about the remote access session you are
        /// stopping.</p>
        pub fn remote_access_session(mut self, input: crate::model::RemoteAccessSession) -> Self {
            self.remote_access_session = Some(input);
            self
        }
        /// <p>A container that represents the metadata from the service about the remote access session you are
        /// stopping.</p>
        pub fn set_remote_access_session(
            mut self,
            input: std::option::Option<crate::model::RemoteAccessSession>,
        ) -> Self {
            self.remote_access_session = input;
            self
        }
        /// Consumes the builder and constructs a [`StopRemoteAccessSessionOutput`](crate::output::StopRemoteAccessSessionOutput)
        pub fn build(self) -> crate::output::StopRemoteAccessSessionOutput {
            crate::output::StopRemoteAccessSessionOutput {
                remote_access_session: self.remote_access_session,
            }
        }
    }
}
impl StopRemoteAccessSessionOutput {
    /// Creates a new builder-style object to manufacture [`StopRemoteAccessSessionOutput`](crate::output::StopRemoteAccessSessionOutput)
    pub fn builder() -> crate::output::stop_remote_access_session_output::Builder {
        crate::output::stop_remote_access_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopJobOutput {
    /// <p>The job that was stopped.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl StopJobOutput {
    /// <p>The job that was stopped.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for StopJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StopJobOutput`](crate::output::StopJobOutput)
pub mod stop_job_output {
    /// A builder for [`StopJobOutput`](crate::output::StopJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>The job that was stopped.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>The job that was stopped.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StopJobOutput`](crate::output::StopJobOutput)
        pub fn build(self) -> crate::output::StopJobOutput {
            crate::output::StopJobOutput { job: self.job }
        }
    }
}
impl StopJobOutput {
    /// Creates a new builder-style object to manufacture [`StopJobOutput`](crate::output::StopJobOutput)
    pub fn builder() -> crate::output::stop_job_output::Builder {
        crate::output::stop_job_output::Builder::default()
    }
}

/// <p>Represents the result of a schedule run request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleRunOutput {
    /// <p>Information about the scheduled run.</p>
    pub run: std::option::Option<crate::model::Run>,
}
impl ScheduleRunOutput {
    /// <p>Information about the scheduled run.</p>
    pub fn run(&self) -> std::option::Option<&crate::model::Run> {
        self.run.as_ref()
    }
}
impl std::fmt::Debug for ScheduleRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleRunOutput");
        formatter.field("run", &self.run);
        formatter.finish()
    }
}
/// See [`ScheduleRunOutput`](crate::output::ScheduleRunOutput)
pub mod schedule_run_output {
    /// A builder for [`ScheduleRunOutput`](crate::output::ScheduleRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run: std::option::Option<crate::model::Run>,
    }
    impl Builder {
        /// <p>Information about the scheduled run.</p>
        pub fn run(mut self, input: crate::model::Run) -> Self {
            self.run = Some(input);
            self
        }
        /// <p>Information about the scheduled run.</p>
        pub fn set_run(mut self, input: std::option::Option<crate::model::Run>) -> Self {
            self.run = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleRunOutput`](crate::output::ScheduleRunOutput)
        pub fn build(self) -> crate::output::ScheduleRunOutput {
            crate::output::ScheduleRunOutput { run: self.run }
        }
    }
}
impl ScheduleRunOutput {
    /// Creates a new builder-style object to manufacture [`ScheduleRunOutput`](crate::output::ScheduleRunOutput)
    pub fn builder() -> crate::output::schedule_run_output::Builder {
        crate::output::schedule_run_output::Builder::default()
    }
}

/// <p>The result of a renewal offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenewOfferingOutput {
    /// <p>Represents the status of the offering transaction for the renewal.</p>
    pub offering_transaction: std::option::Option<crate::model::OfferingTransaction>,
}
impl RenewOfferingOutput {
    /// <p>Represents the status of the offering transaction for the renewal.</p>
    pub fn offering_transaction(&self) -> std::option::Option<&crate::model::OfferingTransaction> {
        self.offering_transaction.as_ref()
    }
}
impl std::fmt::Debug for RenewOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenewOfferingOutput");
        formatter.field("offering_transaction", &self.offering_transaction);
        formatter.finish()
    }
}
/// See [`RenewOfferingOutput`](crate::output::RenewOfferingOutput)
pub mod renew_offering_output {
    /// A builder for [`RenewOfferingOutput`](crate::output::RenewOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_transaction: std::option::Option<crate::model::OfferingTransaction>,
    }
    impl Builder {
        /// <p>Represents the status of the offering transaction for the renewal.</p>
        pub fn offering_transaction(mut self, input: crate::model::OfferingTransaction) -> Self {
            self.offering_transaction = Some(input);
            self
        }
        /// <p>Represents the status of the offering transaction for the renewal.</p>
        pub fn set_offering_transaction(
            mut self,
            input: std::option::Option<crate::model::OfferingTransaction>,
        ) -> Self {
            self.offering_transaction = input;
            self
        }
        /// Consumes the builder and constructs a [`RenewOfferingOutput`](crate::output::RenewOfferingOutput)
        pub fn build(self) -> crate::output::RenewOfferingOutput {
            crate::output::RenewOfferingOutput {
                offering_transaction: self.offering_transaction,
            }
        }
    }
}
impl RenewOfferingOutput {
    /// Creates a new builder-style object to manufacture [`RenewOfferingOutput`](crate::output::RenewOfferingOutput)
    pub fn builder() -> crate::output::renew_offering_output::Builder {
        crate::output::renew_offering_output::Builder::default()
    }
}

/// <p>The result of the purchase offering (for example, success or failure).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseOfferingOutput {
    /// <p>Represents the offering transaction for the purchase result.</p>
    pub offering_transaction: std::option::Option<crate::model::OfferingTransaction>,
}
impl PurchaseOfferingOutput {
    /// <p>Represents the offering transaction for the purchase result.</p>
    pub fn offering_transaction(&self) -> std::option::Option<&crate::model::OfferingTransaction> {
        self.offering_transaction.as_ref()
    }
}
impl std::fmt::Debug for PurchaseOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseOfferingOutput");
        formatter.field("offering_transaction", &self.offering_transaction);
        formatter.finish()
    }
}
/// See [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
pub mod purchase_offering_output {
    /// A builder for [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_transaction: std::option::Option<crate::model::OfferingTransaction>,
    }
    impl Builder {
        /// <p>Represents the offering transaction for the purchase result.</p>
        pub fn offering_transaction(mut self, input: crate::model::OfferingTransaction) -> Self {
            self.offering_transaction = Some(input);
            self
        }
        /// <p>Represents the offering transaction for the purchase result.</p>
        pub fn set_offering_transaction(
            mut self,
            input: std::option::Option<crate::model::OfferingTransaction>,
        ) -> Self {
            self.offering_transaction = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseOfferingOutput {
            crate::output::PurchaseOfferingOutput {
                offering_transaction: self.offering_transaction,
            }
        }
    }
}
impl PurchaseOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
    pub fn builder() -> crate::output::purchase_offering_output::Builder {
        crate::output::purchase_offering_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVpceConfigurationsOutput {
    /// <p>An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
    /// configuration.</p>
    pub vpce_configurations: std::option::Option<std::vec::Vec<crate::model::VpceConfiguration>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListVpceConfigurationsOutput {
    /// <p>An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
    /// configuration.</p>
    pub fn vpce_configurations(&self) -> std::option::Option<&[crate::model::VpceConfiguration]> {
        self.vpce_configurations.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can be
    /// used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListVpceConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVpceConfigurationsOutput");
        formatter.field("vpce_configurations", &self.vpce_configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListVpceConfigurationsOutput`](crate::output::ListVpceConfigurationsOutput)
pub mod list_vpce_configurations_output {
    /// A builder for [`ListVpceConfigurationsOutput`](crate::output::ListVpceConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpce_configurations:
            std::option::Option<std::vec::Vec<crate::model::VpceConfiguration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `vpce_configurations`.
        ///
        /// To override the contents of this collection use [`set_vpce_configurations`](Self::set_vpce_configurations).
        ///
        /// <p>An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
        /// configuration.</p>
        pub fn vpce_configurations(
            mut self,
            input: impl Into<crate::model::VpceConfiguration>,
        ) -> Self {
            let mut v = self.vpce_configurations.unwrap_or_default();
            v.push(input.into());
            self.vpce_configurations = Some(v);
            self
        }
        /// <p>An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
        /// configuration.</p>
        pub fn set_vpce_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpceConfiguration>>,
        ) -> Self {
            self.vpce_configurations = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVpceConfigurationsOutput`](crate::output::ListVpceConfigurationsOutput)
        pub fn build(self) -> crate::output::ListVpceConfigurationsOutput {
            crate::output::ListVpceConfigurationsOutput {
                vpce_configurations: self.vpce_configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListVpceConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListVpceConfigurationsOutput`](crate::output::ListVpceConfigurationsOutput)
    pub fn builder() -> crate::output::list_vpce_configurations_output::Builder {
        crate::output::list_vpce_configurations_output::Builder::default()
    }
}

/// <p>Represents the result of a list uploads request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUploadsOutput {
    /// <p>Information about the uploads.</p>
    pub uploads: std::option::Option<std::vec::Vec<crate::model::Upload>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUploadsOutput {
    /// <p>Information about the uploads.</p>
    pub fn uploads(&self) -> std::option::Option<&[crate::model::Upload]> {
        self.uploads.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUploadsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUploadsOutput");
        formatter.field("uploads", &self.uploads);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUploadsOutput`](crate::output::ListUploadsOutput)
pub mod list_uploads_output {
    /// A builder for [`ListUploadsOutput`](crate::output::ListUploadsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uploads: std::option::Option<std::vec::Vec<crate::model::Upload>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `uploads`.
        ///
        /// To override the contents of this collection use [`set_uploads`](Self::set_uploads).
        ///
        /// <p>Information about the uploads.</p>
        pub fn uploads(mut self, input: impl Into<crate::model::Upload>) -> Self {
            let mut v = self.uploads.unwrap_or_default();
            v.push(input.into());
            self.uploads = Some(v);
            self
        }
        /// <p>Information about the uploads.</p>
        pub fn set_uploads(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Upload>>,
        ) -> Self {
            self.uploads = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUploadsOutput`](crate::output::ListUploadsOutput)
        pub fn build(self) -> crate::output::ListUploadsOutput {
            crate::output::ListUploadsOutput {
                uploads: self.uploads,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUploadsOutput {
    /// Creates a new builder-style object to manufacture [`ListUploadsOutput`](crate::output::ListUploadsOutput)
    pub fn builder() -> crate::output::list_uploads_output::Builder {
        crate::output::list_uploads_output::Builder::default()
    }
}

/// <p>Represents the result of a list unique problems request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUniqueProblemsOutput {
    /// <p>Information about the unique problems.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub unique_problems: std::option::Option<
        std::collections::HashMap<
            crate::model::ExecutionResult,
            std::vec::Vec<crate::model::UniqueProblem>,
        >,
    >,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUniqueProblemsOutput {
    /// <p>Information about the unique problems.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub fn unique_problems(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::ExecutionResult,
            std::vec::Vec<crate::model::UniqueProblem>,
        >,
    > {
        self.unique_problems.as_ref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUniqueProblemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUniqueProblemsOutput");
        formatter.field("unique_problems", &self.unique_problems);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUniqueProblemsOutput`](crate::output::ListUniqueProblemsOutput)
pub mod list_unique_problems_output {
    /// A builder for [`ListUniqueProblemsOutput`](crate::output::ListUniqueProblemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unique_problems: std::option::Option<
            std::collections::HashMap<
                crate::model::ExecutionResult,
                std::vec::Vec<crate::model::UniqueProblem>,
            >,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `unique_problems`.
        ///
        /// To override the contents of this collection use [`set_unique_problems`](Self::set_unique_problems).
        ///
        /// <p>Information about the unique problems.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn unique_problems(
            mut self,
            k: impl Into<crate::model::ExecutionResult>,
            v: impl Into<std::vec::Vec<crate::model::UniqueProblem>>,
        ) -> Self {
            let mut hash_map = self.unique_problems.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.unique_problems = Some(hash_map);
            self
        }
        /// <p>Information about the unique problems.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn set_unique_problems(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::ExecutionResult,
                    std::vec::Vec<crate::model::UniqueProblem>,
                >,
            >,
        ) -> Self {
            self.unique_problems = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUniqueProblemsOutput`](crate::output::ListUniqueProblemsOutput)
        pub fn build(self) -> crate::output::ListUniqueProblemsOutput {
            crate::output::ListUniqueProblemsOutput {
                unique_problems: self.unique_problems,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUniqueProblemsOutput {
    /// Creates a new builder-style object to manufacture [`ListUniqueProblemsOutput`](crate::output::ListUniqueProblemsOutput)
    pub fn builder() -> crate::output::list_unique_problems_output::Builder {
        crate::output::list_unique_problems_output::Builder::default()
    }
}

/// <p>Represents the result of a list tests request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestsOutput {
    /// <p>Information about the tests.</p>
    pub tests: std::option::Option<std::vec::Vec<crate::model::Test>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestsOutput {
    /// <p>Information about the tests.</p>
    pub fn tests(&self) -> std::option::Option<&[crate::model::Test]> {
        self.tests.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestsOutput");
        formatter.field("tests", &self.tests);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTestsOutput`](crate::output::ListTestsOutput)
pub mod list_tests_output {
    /// A builder for [`ListTestsOutput`](crate::output::ListTestsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tests: std::option::Option<std::vec::Vec<crate::model::Test>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tests`.
        ///
        /// To override the contents of this collection use [`set_tests`](Self::set_tests).
        ///
        /// <p>Information about the tests.</p>
        pub fn tests(mut self, input: impl Into<crate::model::Test>) -> Self {
            let mut v = self.tests.unwrap_or_default();
            v.push(input.into());
            self.tests = Some(v);
            self
        }
        /// <p>Information about the tests.</p>
        pub fn set_tests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Test>>,
        ) -> Self {
            self.tests = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestsOutput`](crate::output::ListTestsOutput)
        pub fn build(self) -> crate::output::ListTestsOutput {
            crate::output::ListTestsOutput {
                tests: self.tests,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTestsOutput {
    /// Creates a new builder-style object to manufacture [`ListTestsOutput`](crate::output::ListTestsOutput)
    pub fn builder() -> crate::output::list_tests_output::Builder {
        crate::output::list_tests_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridSessionsOutput {
    /// <p>The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>. </p>
    pub test_grid_sessions: std::option::Option<std::vec::Vec<crate::model::TestGridSession>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridSessionsOutput {
    /// <p>The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>. </p>
    pub fn test_grid_sessions(&self) -> std::option::Option<&[crate::model::TestGridSession]> {
        self.test_grid_sessions.as_deref()
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridSessionsOutput");
        formatter.field("test_grid_sessions", &self.test_grid_sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTestGridSessionsOutput`](crate::output::ListTestGridSessionsOutput)
pub mod list_test_grid_sessions_output {
    /// A builder for [`ListTestGridSessionsOutput`](crate::output::ListTestGridSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_grid_sessions:
            std::option::Option<std::vec::Vec<crate::model::TestGridSession>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `test_grid_sessions`.
        ///
        /// To override the contents of this collection use [`set_test_grid_sessions`](Self::set_test_grid_sessions).
        ///
        /// <p>The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>. </p>
        pub fn test_grid_sessions(
            mut self,
            input: impl Into<crate::model::TestGridSession>,
        ) -> Self {
            let mut v = self.test_grid_sessions.unwrap_or_default();
            v.push(input.into());
            self.test_grid_sessions = Some(v);
            self
        }
        /// <p>The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>. </p>
        pub fn set_test_grid_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestGridSession>>,
        ) -> Self {
            self.test_grid_sessions = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridSessionsOutput`](crate::output::ListTestGridSessionsOutput)
        pub fn build(self) -> crate::output::ListTestGridSessionsOutput {
            crate::output::ListTestGridSessionsOutput {
                test_grid_sessions: self.test_grid_sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTestGridSessionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionsOutput`](crate::output::ListTestGridSessionsOutput)
    pub fn builder() -> crate::output::list_test_grid_sessions_output::Builder {
        crate::output::list_test_grid_sessions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridSessionArtifactsOutput {
    /// <p>A list of test grid session artifacts for a <a>TestGridSession</a>.</p>
    pub artifacts: std::option::Option<std::vec::Vec<crate::model::TestGridSessionArtifact>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridSessionArtifactsOutput {
    /// <p>A list of test grid session artifacts for a <a>TestGridSession</a>.</p>
    pub fn artifacts(&self) -> std::option::Option<&[crate::model::TestGridSessionArtifact]> {
        self.artifacts.as_deref()
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridSessionArtifactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridSessionArtifactsOutput");
        formatter.field("artifacts", &self.artifacts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTestGridSessionArtifactsOutput`](crate::output::ListTestGridSessionArtifactsOutput)
pub mod list_test_grid_session_artifacts_output {
    /// A builder for [`ListTestGridSessionArtifactsOutput`](crate::output::ListTestGridSessionArtifactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifacts:
            std::option::Option<std::vec::Vec<crate::model::TestGridSessionArtifact>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `artifacts`.
        ///
        /// To override the contents of this collection use [`set_artifacts`](Self::set_artifacts).
        ///
        /// <p>A list of test grid session artifacts for a <a>TestGridSession</a>.</p>
        pub fn artifacts(
            mut self,
            input: impl Into<crate::model::TestGridSessionArtifact>,
        ) -> Self {
            let mut v = self.artifacts.unwrap_or_default();
            v.push(input.into());
            self.artifacts = Some(v);
            self
        }
        /// <p>A list of test grid session artifacts for a <a>TestGridSession</a>.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestGridSessionArtifact>>,
        ) -> Self {
            self.artifacts = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridSessionArtifactsOutput`](crate::output::ListTestGridSessionArtifactsOutput)
        pub fn build(self) -> crate::output::ListTestGridSessionArtifactsOutput {
            crate::output::ListTestGridSessionArtifactsOutput {
                artifacts: self.artifacts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTestGridSessionArtifactsOutput {
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionArtifactsOutput`](crate::output::ListTestGridSessionArtifactsOutput)
    pub fn builder() -> crate::output::list_test_grid_session_artifacts_output::Builder {
        crate::output::list_test_grid_session_artifacts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridSessionActionsOutput {
    /// <p>The action taken by the session.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::TestGridSessionAction>>,
    /// <p>Pagination token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridSessionActionsOutput {
    /// <p>The action taken by the session.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::TestGridSessionAction]> {
        self.actions.as_deref()
    }
    /// <p>Pagination token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridSessionActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridSessionActionsOutput");
        formatter.field("actions", &self.actions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTestGridSessionActionsOutput`](crate::output::ListTestGridSessionActionsOutput)
pub mod list_test_grid_session_actions_output {
    /// A builder for [`ListTestGridSessionActionsOutput`](crate::output::ListTestGridSessionActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::TestGridSessionAction>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The action taken by the session.</p>
        pub fn actions(mut self, input: impl Into<crate::model::TestGridSessionAction>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The action taken by the session.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestGridSessionAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridSessionActionsOutput`](crate::output::ListTestGridSessionActionsOutput)
        pub fn build(self) -> crate::output::ListTestGridSessionActionsOutput {
            crate::output::ListTestGridSessionActionsOutput {
                actions: self.actions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTestGridSessionActionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTestGridSessionActionsOutput`](crate::output::ListTestGridSessionActionsOutput)
    pub fn builder() -> crate::output::list_test_grid_session_actions_output::Builder {
        crate::output::list_test_grid_session_actions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestGridProjectsOutput {
    /// <p>The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.</p>
    pub test_grid_projects: std::option::Option<std::vec::Vec<crate::model::TestGridProject>>,
    /// <p>Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated
    /// request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTestGridProjectsOutput {
    /// <p>The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.</p>
    pub fn test_grid_projects(&self) -> std::option::Option<&[crate::model::TestGridProject]> {
        self.test_grid_projects.as_deref()
    }
    /// <p>Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated
    /// request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTestGridProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestGridProjectsOutput");
        formatter.field("test_grid_projects", &self.test_grid_projects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTestGridProjectsOutput`](crate::output::ListTestGridProjectsOutput)
pub mod list_test_grid_projects_output {
    /// A builder for [`ListTestGridProjectsOutput`](crate::output::ListTestGridProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_grid_projects:
            std::option::Option<std::vec::Vec<crate::model::TestGridProject>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `test_grid_projects`.
        ///
        /// To override the contents of this collection use [`set_test_grid_projects`](Self::set_test_grid_projects).
        ///
        /// <p>The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.</p>
        pub fn test_grid_projects(
            mut self,
            input: impl Into<crate::model::TestGridProject>,
        ) -> Self {
            let mut v = self.test_grid_projects.unwrap_or_default();
            v.push(input.into());
            self.test_grid_projects = Some(v);
            self
        }
        /// <p>The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.</p>
        pub fn set_test_grid_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestGridProject>>,
        ) -> Self {
            self.test_grid_projects = input;
            self
        }
        /// <p>Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated
        /// request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated
        /// request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestGridProjectsOutput`](crate::output::ListTestGridProjectsOutput)
        pub fn build(self) -> crate::output::ListTestGridProjectsOutput {
            crate::output::ListTestGridProjectsOutput {
                test_grid_projects: self.test_grid_projects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTestGridProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListTestGridProjectsOutput`](crate::output::ListTestGridProjectsOutput)
    pub fn builder() -> crate::output::list_test_grid_projects_output::Builder {
        crate::output::list_test_grid_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum
    /// character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum
    /// character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum
        /// character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum
        /// character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>Represents the result of a list suites request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuitesOutput {
    /// <p>Information about the suites.</p>
    pub suites: std::option::Option<std::vec::Vec<crate::model::Suite>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuitesOutput {
    /// <p>Information about the suites.</p>
    pub fn suites(&self) -> std::option::Option<&[crate::model::Suite]> {
        self.suites.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuitesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuitesOutput");
        formatter.field("suites", &self.suites);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSuitesOutput`](crate::output::ListSuitesOutput)
pub mod list_suites_output {
    /// A builder for [`ListSuitesOutput`](crate::output::ListSuitesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suites: std::option::Option<std::vec::Vec<crate::model::Suite>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `suites`.
        ///
        /// To override the contents of this collection use [`set_suites`](Self::set_suites).
        ///
        /// <p>Information about the suites.</p>
        pub fn suites(mut self, input: impl Into<crate::model::Suite>) -> Self {
            let mut v = self.suites.unwrap_or_default();
            v.push(input.into());
            self.suites = Some(v);
            self
        }
        /// <p>Information about the suites.</p>
        pub fn set_suites(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Suite>>,
        ) -> Self {
            self.suites = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuitesOutput`](crate::output::ListSuitesOutput)
        pub fn build(self) -> crate::output::ListSuitesOutput {
            crate::output::ListSuitesOutput {
                suites: self.suites,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSuitesOutput {
    /// Creates a new builder-style object to manufacture [`ListSuitesOutput`](crate::output::ListSuitesOutput)
    pub fn builder() -> crate::output::list_suites_output::Builder {
        crate::output::list_suites_output::Builder::default()
    }
}

/// <p>Represents the result of a list samples request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSamplesOutput {
    /// <p>Information about the samples.</p>
    pub samples: std::option::Option<std::vec::Vec<crate::model::Sample>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSamplesOutput {
    /// <p>Information about the samples.</p>
    pub fn samples(&self) -> std::option::Option<&[crate::model::Sample]> {
        self.samples.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSamplesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSamplesOutput");
        formatter.field("samples", &self.samples);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSamplesOutput`](crate::output::ListSamplesOutput)
pub mod list_samples_output {
    /// A builder for [`ListSamplesOutput`](crate::output::ListSamplesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) samples: std::option::Option<std::vec::Vec<crate::model::Sample>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `samples`.
        ///
        /// To override the contents of this collection use [`set_samples`](Self::set_samples).
        ///
        /// <p>Information about the samples.</p>
        pub fn samples(mut self, input: impl Into<crate::model::Sample>) -> Self {
            let mut v = self.samples.unwrap_or_default();
            v.push(input.into());
            self.samples = Some(v);
            self
        }
        /// <p>Information about the samples.</p>
        pub fn set_samples(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sample>>,
        ) -> Self {
            self.samples = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSamplesOutput`](crate::output::ListSamplesOutput)
        pub fn build(self) -> crate::output::ListSamplesOutput {
            crate::output::ListSamplesOutput {
                samples: self.samples,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSamplesOutput {
    /// Creates a new builder-style object to manufacture [`ListSamplesOutput`](crate::output::ListSamplesOutput)
    pub fn builder() -> crate::output::list_samples_output::Builder {
        crate::output::list_samples_output::Builder::default()
    }
}

/// <p>Represents the result of a list runs request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRunsOutput {
    /// <p>Information about the runs.</p>
    pub runs: std::option::Option<std::vec::Vec<crate::model::Run>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRunsOutput {
    /// <p>Information about the runs.</p>
    pub fn runs(&self) -> std::option::Option<&[crate::model::Run]> {
        self.runs.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRunsOutput");
        formatter.field("runs", &self.runs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRunsOutput`](crate::output::ListRunsOutput)
pub mod list_runs_output {
    /// A builder for [`ListRunsOutput`](crate::output::ListRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) runs: std::option::Option<std::vec::Vec<crate::model::Run>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `runs`.
        ///
        /// To override the contents of this collection use [`set_runs`](Self::set_runs).
        ///
        /// <p>Information about the runs.</p>
        pub fn runs(mut self, input: impl Into<crate::model::Run>) -> Self {
            let mut v = self.runs.unwrap_or_default();
            v.push(input.into());
            self.runs = Some(v);
            self
        }
        /// <p>Information about the runs.</p>
        pub fn set_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Run>>,
        ) -> Self {
            self.runs = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRunsOutput`](crate::output::ListRunsOutput)
        pub fn build(self) -> crate::output::ListRunsOutput {
            crate::output::ListRunsOutput {
                runs: self.runs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRunsOutput {
    /// Creates a new builder-style object to manufacture [`ListRunsOutput`](crate::output::ListRunsOutput)
    pub fn builder() -> crate::output::list_runs_output::Builder {
        crate::output::list_runs_output::Builder::default()
    }
}

/// <p>Represents the response from the server after AWS Device Farm makes a request to
/// return information about the remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRemoteAccessSessionsOutput {
    /// <p>A container that represents the metadata from the service about each remote access session you are
    /// requesting.</p>
    pub remote_access_sessions:
        std::option::Option<std::vec::Vec<crate::model::RemoteAccessSession>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRemoteAccessSessionsOutput {
    /// <p>A container that represents the metadata from the service about each remote access session you are
    /// requesting.</p>
    pub fn remote_access_sessions(
        &self,
    ) -> std::option::Option<&[crate::model::RemoteAccessSession]> {
        self.remote_access_sessions.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRemoteAccessSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRemoteAccessSessionsOutput");
        formatter.field("remote_access_sessions", &self.remote_access_sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRemoteAccessSessionsOutput`](crate::output::ListRemoteAccessSessionsOutput)
pub mod list_remote_access_sessions_output {
    /// A builder for [`ListRemoteAccessSessionsOutput`](crate::output::ListRemoteAccessSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remote_access_sessions:
            std::option::Option<std::vec::Vec<crate::model::RemoteAccessSession>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `remote_access_sessions`.
        ///
        /// To override the contents of this collection use [`set_remote_access_sessions`](Self::set_remote_access_sessions).
        ///
        /// <p>A container that represents the metadata from the service about each remote access session you are
        /// requesting.</p>
        pub fn remote_access_sessions(
            mut self,
            input: impl Into<crate::model::RemoteAccessSession>,
        ) -> Self {
            let mut v = self.remote_access_sessions.unwrap_or_default();
            v.push(input.into());
            self.remote_access_sessions = Some(v);
            self
        }
        /// <p>A container that represents the metadata from the service about each remote access session you are
        /// requesting.</p>
        pub fn set_remote_access_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemoteAccessSession>>,
        ) -> Self {
            self.remote_access_sessions = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRemoteAccessSessionsOutput`](crate::output::ListRemoteAccessSessionsOutput)
        pub fn build(self) -> crate::output::ListRemoteAccessSessionsOutput {
            crate::output::ListRemoteAccessSessionsOutput {
                remote_access_sessions: self.remote_access_sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRemoteAccessSessionsOutput {
    /// Creates a new builder-style object to manufacture [`ListRemoteAccessSessionsOutput`](crate::output::ListRemoteAccessSessionsOutput)
    pub fn builder() -> crate::output::list_remote_access_sessions_output::Builder {
        crate::output::list_remote_access_sessions_output::Builder::default()
    }
}

/// <p>Represents the result of a list projects request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>Information about the projects.</p>
    pub projects: std::option::Option<std::vec::Vec<crate::model::Project>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>Information about the projects.</p>
    pub fn projects(&self) -> std::option::Option<&[crate::model::Project]> {
        self.projects.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("projects", &self.projects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projects: std::option::Option<std::vec::Vec<crate::model::Project>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>Information about the projects.</p>
        pub fn projects(mut self, input: impl Into<crate::model::Project>) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input.into());
            self.projects = Some(v);
            self
        }
        /// <p>Information about the projects.</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Project>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                projects: self.projects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

/// <p>Returns the transaction log of the specified offerings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingTransactionsOutput {
    /// <p>The audit log of subscriptions you have purchased and modified through AWS Device
    /// Farm.</p>
    pub offering_transactions:
        std::option::Option<std::vec::Vec<crate::model::OfferingTransaction>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingTransactionsOutput {
    /// <p>The audit log of subscriptions you have purchased and modified through AWS Device
    /// Farm.</p>
    pub fn offering_transactions(
        &self,
    ) -> std::option::Option<&[crate::model::OfferingTransaction]> {
        self.offering_transactions.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingTransactionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingTransactionsOutput");
        formatter.field("offering_transactions", &self.offering_transactions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOfferingTransactionsOutput`](crate::output::ListOfferingTransactionsOutput)
pub mod list_offering_transactions_output {
    /// A builder for [`ListOfferingTransactionsOutput`](crate::output::ListOfferingTransactionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_transactions:
            std::option::Option<std::vec::Vec<crate::model::OfferingTransaction>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `offering_transactions`.
        ///
        /// To override the contents of this collection use [`set_offering_transactions`](Self::set_offering_transactions).
        ///
        /// <p>The audit log of subscriptions you have purchased and modified through AWS Device
        /// Farm.</p>
        pub fn offering_transactions(
            mut self,
            input: impl Into<crate::model::OfferingTransaction>,
        ) -> Self {
            let mut v = self.offering_transactions.unwrap_or_default();
            v.push(input.into());
            self.offering_transactions = Some(v);
            self
        }
        /// <p>The audit log of subscriptions you have purchased and modified through AWS Device
        /// Farm.</p>
        pub fn set_offering_transactions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OfferingTransaction>>,
        ) -> Self {
            self.offering_transactions = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingTransactionsOutput`](crate::output::ListOfferingTransactionsOutput)
        pub fn build(self) -> crate::output::ListOfferingTransactionsOutput {
            crate::output::ListOfferingTransactionsOutput {
                offering_transactions: self.offering_transactions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOfferingTransactionsOutput {
    /// Creates a new builder-style object to manufacture [`ListOfferingTransactionsOutput`](crate::output::ListOfferingTransactionsOutput)
    pub fn builder() -> crate::output::list_offering_transactions_output::Builder {
        crate::output::list_offering_transactions_output::Builder::default()
    }
}

/// <p>Represents the return values of the list of offerings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingsOutput {
    /// <p>A value that represents the list offering results.</p>
    pub offerings: std::option::Option<std::vec::Vec<crate::model::Offering>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingsOutput {
    /// <p>A value that represents the list offering results.</p>
    pub fn offerings(&self) -> std::option::Option<&[crate::model::Offering]> {
        self.offerings.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingsOutput");
        formatter.field("offerings", &self.offerings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
pub mod list_offerings_output {
    /// A builder for [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offerings: std::option::Option<std::vec::Vec<crate::model::Offering>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `offerings`.
        ///
        /// To override the contents of this collection use [`set_offerings`](Self::set_offerings).
        ///
        /// <p>A value that represents the list offering results.</p>
        pub fn offerings(mut self, input: impl Into<crate::model::Offering>) -> Self {
            let mut v = self.offerings.unwrap_or_default();
            v.push(input.into());
            self.offerings = Some(v);
            self
        }
        /// <p>A value that represents the list offering results.</p>
        pub fn set_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Offering>>,
        ) -> Self {
            self.offerings = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
        pub fn build(self) -> crate::output::ListOfferingsOutput {
            crate::output::ListOfferingsOutput {
                offerings: self.offerings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
    pub fn builder() -> crate::output::list_offerings_output::Builder {
        crate::output::list_offerings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingPromotionsOutput {
    /// <p>Information about the offering promotions.</p>
    pub offering_promotions: std::option::Option<std::vec::Vec<crate::model::OfferingPromotion>>,
    /// <p>An identifier to be used in the next call to this operation, to return the next set
    /// of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingPromotionsOutput {
    /// <p>Information about the offering promotions.</p>
    pub fn offering_promotions(&self) -> std::option::Option<&[crate::model::OfferingPromotion]> {
        self.offering_promotions.as_deref()
    }
    /// <p>An identifier to be used in the next call to this operation, to return the next set
    /// of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingPromotionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingPromotionsOutput");
        formatter.field("offering_promotions", &self.offering_promotions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOfferingPromotionsOutput`](crate::output::ListOfferingPromotionsOutput)
pub mod list_offering_promotions_output {
    /// A builder for [`ListOfferingPromotionsOutput`](crate::output::ListOfferingPromotionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_promotions:
            std::option::Option<std::vec::Vec<crate::model::OfferingPromotion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `offering_promotions`.
        ///
        /// To override the contents of this collection use [`set_offering_promotions`](Self::set_offering_promotions).
        ///
        /// <p>Information about the offering promotions.</p>
        pub fn offering_promotions(
            mut self,
            input: impl Into<crate::model::OfferingPromotion>,
        ) -> Self {
            let mut v = self.offering_promotions.unwrap_or_default();
            v.push(input.into());
            self.offering_promotions = Some(v);
            self
        }
        /// <p>Information about the offering promotions.</p>
        pub fn set_offering_promotions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OfferingPromotion>>,
        ) -> Self {
            self.offering_promotions = input;
            self
        }
        /// <p>An identifier to be used in the next call to this operation, to return the next set
        /// of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier to be used in the next call to this operation, to return the next set
        /// of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingPromotionsOutput`](crate::output::ListOfferingPromotionsOutput)
        pub fn build(self) -> crate::output::ListOfferingPromotionsOutput {
            crate::output::ListOfferingPromotionsOutput {
                offering_promotions: self.offering_promotions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOfferingPromotionsOutput {
    /// Creates a new builder-style object to manufacture [`ListOfferingPromotionsOutput`](crate::output::ListOfferingPromotionsOutput)
    pub fn builder() -> crate::output::list_offering_promotions_output::Builder {
        crate::output::list_offering_promotions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNetworkProfilesOutput {
    /// <p>A list of the available network profiles.</p>
    pub network_profiles: std::option::Option<std::vec::Vec<crate::model::NetworkProfile>>,
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNetworkProfilesOutput {
    /// <p>A list of the available network profiles.</p>
    pub fn network_profiles(&self) -> std::option::Option<&[crate::model::NetworkProfile]> {
        self.network_profiles.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNetworkProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNetworkProfilesOutput");
        formatter.field("network_profiles", &self.network_profiles);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListNetworkProfilesOutput`](crate::output::ListNetworkProfilesOutput)
pub mod list_network_profiles_output {
    /// A builder for [`ListNetworkProfilesOutput`](crate::output::ListNetworkProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profiles:
            std::option::Option<std::vec::Vec<crate::model::NetworkProfile>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `network_profiles`.
        ///
        /// To override the contents of this collection use [`set_network_profiles`](Self::set_network_profiles).
        ///
        /// <p>A list of the available network profiles.</p>
        pub fn network_profiles(mut self, input: impl Into<crate::model::NetworkProfile>) -> Self {
            let mut v = self.network_profiles.unwrap_or_default();
            v.push(input.into());
            self.network_profiles = Some(v);
            self
        }
        /// <p>A list of the available network profiles.</p>
        pub fn set_network_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkProfile>>,
        ) -> Self {
            self.network_profiles = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNetworkProfilesOutput`](crate::output::ListNetworkProfilesOutput)
        pub fn build(self) -> crate::output::ListNetworkProfilesOutput {
            crate::output::ListNetworkProfilesOutput {
                network_profiles: self.network_profiles,
                next_token: self.next_token,
            }
        }
    }
}
impl ListNetworkProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListNetworkProfilesOutput`](crate::output::ListNetworkProfilesOutput)
    pub fn builder() -> crate::output::list_network_profiles_output::Builder {
        crate::output::list_network_profiles_output::Builder::default()
    }
}

/// <p>Represents the result of a list jobs request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>Information about the jobs.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// <p>Information about the jobs.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>Information about the jobs.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>Information about the jobs.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceProfilesOutput {
    /// <p>An object that contains information about your instance profiles.</p>
    pub instance_profiles: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
    /// <p>An identifier that can be used in the next call to this operation to return the next
    /// set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstanceProfilesOutput {
    /// <p>An object that contains information about your instance profiles.</p>
    pub fn instance_profiles(&self) -> std::option::Option<&[crate::model::InstanceProfile]> {
        self.instance_profiles.as_deref()
    }
    /// <p>An identifier that can be used in the next call to this operation to return the next
    /// set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceProfilesOutput");
        formatter.field("instance_profiles", &self.instance_profiles);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
pub mod list_instance_profiles_output {
    /// A builder for [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profiles:
            std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_profiles`.
        ///
        /// To override the contents of this collection use [`set_instance_profiles`](Self::set_instance_profiles).
        ///
        /// <p>An object that contains information about your instance profiles.</p>
        pub fn instance_profiles(
            mut self,
            input: impl Into<crate::model::InstanceProfile>,
        ) -> Self {
            let mut v = self.instance_profiles.unwrap_or_default();
            v.push(input.into());
            self.instance_profiles = Some(v);
            self
        }
        /// <p>An object that contains information about your instance profiles.</p>
        pub fn set_instance_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        ) -> Self {
            self.instance_profiles = input;
            self
        }
        /// <p>An identifier that can be used in the next call to this operation to return the next
        /// set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that can be used in the next call to this operation to return the next
        /// set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
        pub fn build(self) -> crate::output::ListInstanceProfilesOutput {
            crate::output::ListInstanceProfilesOutput {
                instance_profiles: self.instance_profiles,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInstanceProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
    pub fn builder() -> crate::output::list_instance_profiles_output::Builder {
        crate::output::list_instance_profiles_output::Builder::default()
    }
}

/// <p>Represents the result of a list devices operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesOutput {
    /// <p>Information about the devices.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicesOutput {
    /// <p>Information about the devices.</p>
    pub fn devices(&self) -> std::option::Option<&[crate::model::Device]> {
        self.devices.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicesOutput`](crate::output::ListDevicesOutput)
pub mod list_devices_output {
    /// A builder for [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>Information about the devices.</p>
        pub fn devices(mut self, input: impl Into<crate::model::Device>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>Information about the devices.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesOutput`](crate::output::ListDevicesOutput)
        pub fn build(self) -> crate::output::ListDevicesOutput {
            crate::output::ListDevicesOutput {
                devices: self.devices,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    pub fn builder() -> crate::output::list_devices_output::Builder {
        crate::output::list_devices_output::Builder::default()
    }
}

/// <p>Represents the result of a list device pools request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicePoolsOutput {
    /// <p>Information about the device pools.</p>
    pub device_pools: std::option::Option<std::vec::Vec<crate::model::DevicePool>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicePoolsOutput {
    /// <p>Information about the device pools.</p>
    pub fn device_pools(&self) -> std::option::Option<&[crate::model::DevicePool]> {
        self.device_pools.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicePoolsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicePoolsOutput");
        formatter.field("device_pools", &self.device_pools);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicePoolsOutput`](crate::output::ListDevicePoolsOutput)
pub mod list_device_pools_output {
    /// A builder for [`ListDevicePoolsOutput`](crate::output::ListDevicePoolsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_pools: std::option::Option<std::vec::Vec<crate::model::DevicePool>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `device_pools`.
        ///
        /// To override the contents of this collection use [`set_device_pools`](Self::set_device_pools).
        ///
        /// <p>Information about the device pools.</p>
        pub fn device_pools(mut self, input: impl Into<crate::model::DevicePool>) -> Self {
            let mut v = self.device_pools.unwrap_or_default();
            v.push(input.into());
            self.device_pools = Some(v);
            self
        }
        /// <p>Information about the device pools.</p>
        pub fn set_device_pools(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePool>>,
        ) -> Self {
            self.device_pools = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicePoolsOutput`](crate::output::ListDevicePoolsOutput)
        pub fn build(self) -> crate::output::ListDevicePoolsOutput {
            crate::output::ListDevicePoolsOutput {
                device_pools: self.device_pools,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicePoolsOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicePoolsOutput`](crate::output::ListDevicePoolsOutput)
    pub fn builder() -> crate::output::list_device_pools_output::Builder {
        crate::output::list_device_pools_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceInstancesOutput {
    /// <p>An object that contains information about your device instances.</p>
    pub device_instances: std::option::Option<std::vec::Vec<crate::model::DeviceInstance>>,
    /// <p>An identifier that can be used in the next call to this operation to return the next
    /// set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeviceInstancesOutput {
    /// <p>An object that contains information about your device instances.</p>
    pub fn device_instances(&self) -> std::option::Option<&[crate::model::DeviceInstance]> {
        self.device_instances.as_deref()
    }
    /// <p>An identifier that can be used in the next call to this operation to return the next
    /// set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeviceInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceInstancesOutput");
        formatter.field("device_instances", &self.device_instances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeviceInstancesOutput`](crate::output::ListDeviceInstancesOutput)
pub mod list_device_instances_output {
    /// A builder for [`ListDeviceInstancesOutput`](crate::output::ListDeviceInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_instances:
            std::option::Option<std::vec::Vec<crate::model::DeviceInstance>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `device_instances`.
        ///
        /// To override the contents of this collection use [`set_device_instances`](Self::set_device_instances).
        ///
        /// <p>An object that contains information about your device instances.</p>
        pub fn device_instances(mut self, input: impl Into<crate::model::DeviceInstance>) -> Self {
            let mut v = self.device_instances.unwrap_or_default();
            v.push(input.into());
            self.device_instances = Some(v);
            self
        }
        /// <p>An object that contains information about your device instances.</p>
        pub fn set_device_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceInstance>>,
        ) -> Self {
            self.device_instances = input;
            self
        }
        /// <p>An identifier that can be used in the next call to this operation to return the next
        /// set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that can be used in the next call to this operation to return the next
        /// set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceInstancesOutput`](crate::output::ListDeviceInstancesOutput)
        pub fn build(self) -> crate::output::ListDeviceInstancesOutput {
            crate::output::ListDeviceInstancesOutput {
                device_instances: self.device_instances,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeviceInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListDeviceInstancesOutput`](crate::output::ListDeviceInstancesOutput)
    pub fn builder() -> crate::output::list_device_instances_output::Builder {
        crate::output::list_device_instances_output::Builder::default()
    }
}

/// <p>Represents the result of a list artifacts operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArtifactsOutput {
    /// <p>Information about the artifacts.</p>
    pub artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListArtifactsOutput {
    /// <p>Information about the artifacts.</p>
    pub fn artifacts(&self) -> std::option::Option<&[crate::model::Artifact]> {
        self.artifacts.as_deref()
    }
    /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
    /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
    /// list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListArtifactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArtifactsOutput");
        formatter.field("artifacts", &self.artifacts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
pub mod list_artifacts_output {
    /// A builder for [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifacts: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `artifacts`.
        ///
        /// To override the contents of this collection use [`set_artifacts`](Self::set_artifacts).
        ///
        /// <p>Information about the artifacts.</p>
        pub fn artifacts(mut self, input: impl Into<crate::model::Artifact>) -> Self {
            let mut v = self.artifacts.unwrap_or_default();
            v.push(input.into());
            self.artifacts = Some(v);
            self
        }
        /// <p>Information about the artifacts.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Artifact>>,
        ) -> Self {
            self.artifacts = input;
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the number of items that are returned is significantly large, this is an identifier that is also
        /// returned. It can be used in a subsequent call to this operation to return the next set of items in the
        /// list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
        pub fn build(self) -> crate::output::ListArtifactsOutput {
            crate::output::ListArtifactsOutput {
                artifacts: self.artifacts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListArtifactsOutput {
    /// Creates a new builder-style object to manufacture [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
    pub fn builder() -> crate::output::list_artifacts_output::Builder {
        crate::output::list_artifacts_output::Builder::default()
    }
}

/// <p>Represents the response from the server after AWS Device Farm makes a request to
/// install to a remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstallToRemoteAccessSessionOutput {
    /// <p>An app to upload or that has been uploaded.</p>
    pub app_upload: std::option::Option<crate::model::Upload>,
}
impl InstallToRemoteAccessSessionOutput {
    /// <p>An app to upload or that has been uploaded.</p>
    pub fn app_upload(&self) -> std::option::Option<&crate::model::Upload> {
        self.app_upload.as_ref()
    }
}
impl std::fmt::Debug for InstallToRemoteAccessSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstallToRemoteAccessSessionOutput");
        formatter.field("app_upload", &self.app_upload);
        formatter.finish()
    }
}
/// See [`InstallToRemoteAccessSessionOutput`](crate::output::InstallToRemoteAccessSessionOutput)
pub mod install_to_remote_access_session_output {
    /// A builder for [`InstallToRemoteAccessSessionOutput`](crate::output::InstallToRemoteAccessSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_upload: std::option::Option<crate::model::Upload>,
    }
    impl Builder {
        /// <p>An app to upload or that has been uploaded.</p>
        pub fn app_upload(mut self, input: crate::model::Upload) -> Self {
            self.app_upload = Some(input);
            self
        }
        /// <p>An app to upload or that has been uploaded.</p>
        pub fn set_app_upload(mut self, input: std::option::Option<crate::model::Upload>) -> Self {
            self.app_upload = input;
            self
        }
        /// Consumes the builder and constructs a [`InstallToRemoteAccessSessionOutput`](crate::output::InstallToRemoteAccessSessionOutput)
        pub fn build(self) -> crate::output::InstallToRemoteAccessSessionOutput {
            crate::output::InstallToRemoteAccessSessionOutput {
                app_upload: self.app_upload,
            }
        }
    }
}
impl InstallToRemoteAccessSessionOutput {
    /// Creates a new builder-style object to manufacture [`InstallToRemoteAccessSessionOutput`](crate::output::InstallToRemoteAccessSessionOutput)
    pub fn builder() -> crate::output::install_to_remote_access_session_output::Builder {
        crate::output::install_to_remote_access_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVpceConfigurationOutput {
    /// <p>An object that contains information about your VPC endpoint configuration.</p>
    pub vpce_configuration: std::option::Option<crate::model::VpceConfiguration>,
}
impl GetVpceConfigurationOutput {
    /// <p>An object that contains information about your VPC endpoint configuration.</p>
    pub fn vpce_configuration(&self) -> std::option::Option<&crate::model::VpceConfiguration> {
        self.vpce_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetVpceConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVpceConfigurationOutput");
        formatter.field("vpce_configuration", &self.vpce_configuration);
        formatter.finish()
    }
}
/// See [`GetVpceConfigurationOutput`](crate::output::GetVpceConfigurationOutput)
pub mod get_vpce_configuration_output {
    /// A builder for [`GetVpceConfigurationOutput`](crate::output::GetVpceConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpce_configuration: std::option::Option<crate::model::VpceConfiguration>,
    }
    impl Builder {
        /// <p>An object that contains information about your VPC endpoint configuration.</p>
        pub fn vpce_configuration(mut self, input: crate::model::VpceConfiguration) -> Self {
            self.vpce_configuration = Some(input);
            self
        }
        /// <p>An object that contains information about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration(
            mut self,
            input: std::option::Option<crate::model::VpceConfiguration>,
        ) -> Self {
            self.vpce_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVpceConfigurationOutput`](crate::output::GetVpceConfigurationOutput)
        pub fn build(self) -> crate::output::GetVpceConfigurationOutput {
            crate::output::GetVpceConfigurationOutput {
                vpce_configuration: self.vpce_configuration,
            }
        }
    }
}
impl GetVpceConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetVpceConfigurationOutput`](crate::output::GetVpceConfigurationOutput)
    pub fn builder() -> crate::output::get_vpce_configuration_output::Builder {
        crate::output::get_vpce_configuration_output::Builder::default()
    }
}

/// <p>Represents the result of a get upload request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUploadOutput {
    /// <p>An app or a set of one or more tests to upload or that have been
    /// uploaded.</p>
    pub upload: std::option::Option<crate::model::Upload>,
}
impl GetUploadOutput {
    /// <p>An app or a set of one or more tests to upload or that have been
    /// uploaded.</p>
    pub fn upload(&self) -> std::option::Option<&crate::model::Upload> {
        self.upload.as_ref()
    }
}
impl std::fmt::Debug for GetUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUploadOutput");
        formatter.field("upload", &self.upload);
        formatter.finish()
    }
}
/// See [`GetUploadOutput`](crate::output::GetUploadOutput)
pub mod get_upload_output {
    /// A builder for [`GetUploadOutput`](crate::output::GetUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload: std::option::Option<crate::model::Upload>,
    }
    impl Builder {
        /// <p>An app or a set of one or more tests to upload or that have been
        /// uploaded.</p>
        pub fn upload(mut self, input: crate::model::Upload) -> Self {
            self.upload = Some(input);
            self
        }
        /// <p>An app or a set of one or more tests to upload or that have been
        /// uploaded.</p>
        pub fn set_upload(mut self, input: std::option::Option<crate::model::Upload>) -> Self {
            self.upload = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUploadOutput`](crate::output::GetUploadOutput)
        pub fn build(self) -> crate::output::GetUploadOutput {
            crate::output::GetUploadOutput {
                upload: self.upload,
            }
        }
    }
}
impl GetUploadOutput {
    /// Creates a new builder-style object to manufacture [`GetUploadOutput`](crate::output::GetUploadOutput)
    pub fn builder() -> crate::output::get_upload_output::Builder {
        crate::output::get_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTestGridSessionOutput {
    /// <p>The <a>TestGridSession</a> that was requested.</p>
    pub test_grid_session: std::option::Option<crate::model::TestGridSession>,
}
impl GetTestGridSessionOutput {
    /// <p>The <a>TestGridSession</a> that was requested.</p>
    pub fn test_grid_session(&self) -> std::option::Option<&crate::model::TestGridSession> {
        self.test_grid_session.as_ref()
    }
}
impl std::fmt::Debug for GetTestGridSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTestGridSessionOutput");
        formatter.field("test_grid_session", &self.test_grid_session);
        formatter.finish()
    }
}
/// See [`GetTestGridSessionOutput`](crate::output::GetTestGridSessionOutput)
pub mod get_test_grid_session_output {
    /// A builder for [`GetTestGridSessionOutput`](crate::output::GetTestGridSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_grid_session: std::option::Option<crate::model::TestGridSession>,
    }
    impl Builder {
        /// <p>The <a>TestGridSession</a> that was requested.</p>
        pub fn test_grid_session(mut self, input: crate::model::TestGridSession) -> Self {
            self.test_grid_session = Some(input);
            self
        }
        /// <p>The <a>TestGridSession</a> that was requested.</p>
        pub fn set_test_grid_session(
            mut self,
            input: std::option::Option<crate::model::TestGridSession>,
        ) -> Self {
            self.test_grid_session = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTestGridSessionOutput`](crate::output::GetTestGridSessionOutput)
        pub fn build(self) -> crate::output::GetTestGridSessionOutput {
            crate::output::GetTestGridSessionOutput {
                test_grid_session: self.test_grid_session,
            }
        }
    }
}
impl GetTestGridSessionOutput {
    /// Creates a new builder-style object to manufacture [`GetTestGridSessionOutput`](crate::output::GetTestGridSessionOutput)
    pub fn builder() -> crate::output::get_test_grid_session_output::Builder {
        crate::output::get_test_grid_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTestGridProjectOutput {
    /// <p>A <a>TestGridProject</a>.</p>
    pub test_grid_project: std::option::Option<crate::model::TestGridProject>,
}
impl GetTestGridProjectOutput {
    /// <p>A <a>TestGridProject</a>.</p>
    pub fn test_grid_project(&self) -> std::option::Option<&crate::model::TestGridProject> {
        self.test_grid_project.as_ref()
    }
}
impl std::fmt::Debug for GetTestGridProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTestGridProjectOutput");
        formatter.field("test_grid_project", &self.test_grid_project);
        formatter.finish()
    }
}
/// See [`GetTestGridProjectOutput`](crate::output::GetTestGridProjectOutput)
pub mod get_test_grid_project_output {
    /// A builder for [`GetTestGridProjectOutput`](crate::output::GetTestGridProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_grid_project: std::option::Option<crate::model::TestGridProject>,
    }
    impl Builder {
        /// <p>A <a>TestGridProject</a>.</p>
        pub fn test_grid_project(mut self, input: crate::model::TestGridProject) -> Self {
            self.test_grid_project = Some(input);
            self
        }
        /// <p>A <a>TestGridProject</a>.</p>
        pub fn set_test_grid_project(
            mut self,
            input: std::option::Option<crate::model::TestGridProject>,
        ) -> Self {
            self.test_grid_project = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTestGridProjectOutput`](crate::output::GetTestGridProjectOutput)
        pub fn build(self) -> crate::output::GetTestGridProjectOutput {
            crate::output::GetTestGridProjectOutput {
                test_grid_project: self.test_grid_project,
            }
        }
    }
}
impl GetTestGridProjectOutput {
    /// Creates a new builder-style object to manufacture [`GetTestGridProjectOutput`](crate::output::GetTestGridProjectOutput)
    pub fn builder() -> crate::output::get_test_grid_project_output::Builder {
        crate::output::get_test_grid_project_output::Builder::default()
    }
}

/// <p>Represents the result of a get test request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTestOutput {
    /// <p>A test condition that is evaluated.</p>
    pub test: std::option::Option<crate::model::Test>,
}
impl GetTestOutput {
    /// <p>A test condition that is evaluated.</p>
    pub fn test(&self) -> std::option::Option<&crate::model::Test> {
        self.test.as_ref()
    }
}
impl std::fmt::Debug for GetTestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTestOutput");
        formatter.field("test", &self.test);
        formatter.finish()
    }
}
/// See [`GetTestOutput`](crate::output::GetTestOutput)
pub mod get_test_output {
    /// A builder for [`GetTestOutput`](crate::output::GetTestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test: std::option::Option<crate::model::Test>,
    }
    impl Builder {
        /// <p>A test condition that is evaluated.</p>
        pub fn test(mut self, input: crate::model::Test) -> Self {
            self.test = Some(input);
            self
        }
        /// <p>A test condition that is evaluated.</p>
        pub fn set_test(mut self, input: std::option::Option<crate::model::Test>) -> Self {
            self.test = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTestOutput`](crate::output::GetTestOutput)
        pub fn build(self) -> crate::output::GetTestOutput {
            crate::output::GetTestOutput { test: self.test }
        }
    }
}
impl GetTestOutput {
    /// Creates a new builder-style object to manufacture [`GetTestOutput`](crate::output::GetTestOutput)
    pub fn builder() -> crate::output::get_test_output::Builder {
        crate::output::get_test_output::Builder::default()
    }
}

/// <p>Represents the result of a get suite request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteOutput {
    /// <p>A collection of one or more tests.</p>
    pub suite: std::option::Option<crate::model::Suite>,
}
impl GetSuiteOutput {
    /// <p>A collection of one or more tests.</p>
    pub fn suite(&self) -> std::option::Option<&crate::model::Suite> {
        self.suite.as_ref()
    }
}
impl std::fmt::Debug for GetSuiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteOutput");
        formatter.field("suite", &self.suite);
        formatter.finish()
    }
}
/// See [`GetSuiteOutput`](crate::output::GetSuiteOutput)
pub mod get_suite_output {
    /// A builder for [`GetSuiteOutput`](crate::output::GetSuiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite: std::option::Option<crate::model::Suite>,
    }
    impl Builder {
        /// <p>A collection of one or more tests.</p>
        pub fn suite(mut self, input: crate::model::Suite) -> Self {
            self.suite = Some(input);
            self
        }
        /// <p>A collection of one or more tests.</p>
        pub fn set_suite(mut self, input: std::option::Option<crate::model::Suite>) -> Self {
            self.suite = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteOutput`](crate::output::GetSuiteOutput)
        pub fn build(self) -> crate::output::GetSuiteOutput {
            crate::output::GetSuiteOutput { suite: self.suite }
        }
    }
}
impl GetSuiteOutput {
    /// Creates a new builder-style object to manufacture [`GetSuiteOutput`](crate::output::GetSuiteOutput)
    pub fn builder() -> crate::output::get_suite_output::Builder {
        crate::output::get_suite_output::Builder::default()
    }
}

/// <p>Represents the result of a get run request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRunOutput {
    /// <p>The run to get results from.</p>
    pub run: std::option::Option<crate::model::Run>,
}
impl GetRunOutput {
    /// <p>The run to get results from.</p>
    pub fn run(&self) -> std::option::Option<&crate::model::Run> {
        self.run.as_ref()
    }
}
impl std::fmt::Debug for GetRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRunOutput");
        formatter.field("run", &self.run);
        formatter.finish()
    }
}
/// See [`GetRunOutput`](crate::output::GetRunOutput)
pub mod get_run_output {
    /// A builder for [`GetRunOutput`](crate::output::GetRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run: std::option::Option<crate::model::Run>,
    }
    impl Builder {
        /// <p>The run to get results from.</p>
        pub fn run(mut self, input: crate::model::Run) -> Self {
            self.run = Some(input);
            self
        }
        /// <p>The run to get results from.</p>
        pub fn set_run(mut self, input: std::option::Option<crate::model::Run>) -> Self {
            self.run = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRunOutput`](crate::output::GetRunOutput)
        pub fn build(self) -> crate::output::GetRunOutput {
            crate::output::GetRunOutput { run: self.run }
        }
    }
}
impl GetRunOutput {
    /// Creates a new builder-style object to manufacture [`GetRunOutput`](crate::output::GetRunOutput)
    pub fn builder() -> crate::output::get_run_output::Builder {
        crate::output::get_run_output::Builder::default()
    }
}

/// <p>Represents the response from the server that lists detailed information about the
/// remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRemoteAccessSessionOutput {
    /// <p>A container that lists detailed information about the remote access
    /// session.</p>
    pub remote_access_session: std::option::Option<crate::model::RemoteAccessSession>,
}
impl GetRemoteAccessSessionOutput {
    /// <p>A container that lists detailed information about the remote access
    /// session.</p>
    pub fn remote_access_session(&self) -> std::option::Option<&crate::model::RemoteAccessSession> {
        self.remote_access_session.as_ref()
    }
}
impl std::fmt::Debug for GetRemoteAccessSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRemoteAccessSessionOutput");
        formatter.field("remote_access_session", &self.remote_access_session);
        formatter.finish()
    }
}
/// See [`GetRemoteAccessSessionOutput`](crate::output::GetRemoteAccessSessionOutput)
pub mod get_remote_access_session_output {
    /// A builder for [`GetRemoteAccessSessionOutput`](crate::output::GetRemoteAccessSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remote_access_session: std::option::Option<crate::model::RemoteAccessSession>,
    }
    impl Builder {
        /// <p>A container that lists detailed information about the remote access
        /// session.</p>
        pub fn remote_access_session(mut self, input: crate::model::RemoteAccessSession) -> Self {
            self.remote_access_session = Some(input);
            self
        }
        /// <p>A container that lists detailed information about the remote access
        /// session.</p>
        pub fn set_remote_access_session(
            mut self,
            input: std::option::Option<crate::model::RemoteAccessSession>,
        ) -> Self {
            self.remote_access_session = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRemoteAccessSessionOutput`](crate::output::GetRemoteAccessSessionOutput)
        pub fn build(self) -> crate::output::GetRemoteAccessSessionOutput {
            crate::output::GetRemoteAccessSessionOutput {
                remote_access_session: self.remote_access_session,
            }
        }
    }
}
impl GetRemoteAccessSessionOutput {
    /// Creates a new builder-style object to manufacture [`GetRemoteAccessSessionOutput`](crate::output::GetRemoteAccessSessionOutput)
    pub fn builder() -> crate::output::get_remote_access_session_output::Builder {
        crate::output::get_remote_access_session_output::Builder::default()
    }
}

/// <p>Represents the result of a get project request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProjectOutput {
    /// <p>The project to get information about.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl GetProjectOutput {
    /// <p>The project to get information about.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for GetProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`GetProjectOutput`](crate::output::GetProjectOutput)
pub mod get_project_output {
    /// A builder for [`GetProjectOutput`](crate::output::GetProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>The project to get information about.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>The project to get information about.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProjectOutput`](crate::output::GetProjectOutput)
        pub fn build(self) -> crate::output::GetProjectOutput {
            crate::output::GetProjectOutput {
                project: self.project,
            }
        }
    }
}
impl GetProjectOutput {
    /// Creates a new builder-style object to manufacture [`GetProjectOutput`](crate::output::GetProjectOutput)
    pub fn builder() -> crate::output::get_project_output::Builder {
        crate::output::get_project_output::Builder::default()
    }
}

/// <p>Returns the status result for a device offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOfferingStatusOutput {
    /// <p>When specified, gets the offering status for the current period.</p>
    pub current: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
    >,
    /// <p>When specified, gets the offering status for the next period.</p>
    pub next_period: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
    >,
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOfferingStatusOutput {
    /// <p>When specified, gets the offering status for the current period.</p>
    pub fn current(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
    > {
        self.current.as_ref()
    }
    /// <p>When specified, gets the offering status for the next period.</p>
    pub fn next_period(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
    > {
        self.next_period.as_ref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which can
    /// be used to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOfferingStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOfferingStatusOutput");
        formatter.field("current", &self.current);
        formatter.field("next_period", &self.next_period);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetOfferingStatusOutput`](crate::output::GetOfferingStatusOutput)
pub mod get_offering_status_output {
    /// A builder for [`GetOfferingStatusOutput`](crate::output::GetOfferingStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
        >,
        pub(crate) next_period: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `current`.
        ///
        /// To override the contents of this collection use [`set_current`](Self::set_current).
        ///
        /// <p>When specified, gets the offering status for the current period.</p>
        pub fn current(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OfferingStatus>,
        ) -> Self {
            let mut hash_map = self.current.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.current = Some(hash_map);
            self
        }
        /// <p>When specified, gets the offering status for the current period.</p>
        pub fn set_current(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
            >,
        ) -> Self {
            self.current = input;
            self
        }
        /// Adds a key-value pair to `next_period`.
        ///
        /// To override the contents of this collection use [`set_next_period`](Self::set_next_period).
        ///
        /// <p>When specified, gets the offering status for the next period.</p>
        pub fn next_period(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OfferingStatus>,
        ) -> Self {
            let mut hash_map = self.next_period.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.next_period = Some(hash_map);
            self
        }
        /// <p>When specified, gets the offering status for the next period.</p>
        pub fn set_next_period(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OfferingStatus>,
            >,
        ) -> Self {
            self.next_period = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOfferingStatusOutput`](crate::output::GetOfferingStatusOutput)
        pub fn build(self) -> crate::output::GetOfferingStatusOutput {
            crate::output::GetOfferingStatusOutput {
                current: self.current,
                next_period: self.next_period,
                next_token: self.next_token,
            }
        }
    }
}
impl GetOfferingStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetOfferingStatusOutput`](crate::output::GetOfferingStatusOutput)
    pub fn builder() -> crate::output::get_offering_status_output::Builder {
        crate::output::get_offering_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkProfileOutput {
    /// <p>The network profile.</p>
    pub network_profile: std::option::Option<crate::model::NetworkProfile>,
}
impl GetNetworkProfileOutput {
    /// <p>The network profile.</p>
    pub fn network_profile(&self) -> std::option::Option<&crate::model::NetworkProfile> {
        self.network_profile.as_ref()
    }
}
impl std::fmt::Debug for GetNetworkProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkProfileOutput");
        formatter.field("network_profile", &self.network_profile);
        formatter.finish()
    }
}
/// See [`GetNetworkProfileOutput`](crate::output::GetNetworkProfileOutput)
pub mod get_network_profile_output {
    /// A builder for [`GetNetworkProfileOutput`](crate::output::GetNetworkProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile: std::option::Option<crate::model::NetworkProfile>,
    }
    impl Builder {
        /// <p>The network profile.</p>
        pub fn network_profile(mut self, input: crate::model::NetworkProfile) -> Self {
            self.network_profile = Some(input);
            self
        }
        /// <p>The network profile.</p>
        pub fn set_network_profile(
            mut self,
            input: std::option::Option<crate::model::NetworkProfile>,
        ) -> Self {
            self.network_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkProfileOutput`](crate::output::GetNetworkProfileOutput)
        pub fn build(self) -> crate::output::GetNetworkProfileOutput {
            crate::output::GetNetworkProfileOutput {
                network_profile: self.network_profile,
            }
        }
    }
}
impl GetNetworkProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetNetworkProfileOutput`](crate::output::GetNetworkProfileOutput)
    pub fn builder() -> crate::output::get_network_profile_output::Builder {
        crate::output::get_network_profile_output::Builder::default()
    }
}

/// <p>Represents the result of a get job request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobOutput {
    /// <p>An object that contains information about the requested job.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl GetJobOutput {
    /// <p>An object that contains information about the requested job.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for GetJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`GetJobOutput`](crate::output::GetJobOutput)
pub mod get_job_output {
    /// A builder for [`GetJobOutput`](crate::output::GetJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>An object that contains information about the requested job.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>An object that contains information about the requested job.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutput`](crate::output::GetJobOutput)
        pub fn build(self) -> crate::output::GetJobOutput {
            crate::output::GetJobOutput { job: self.job }
        }
    }
}
impl GetJobOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutput`](crate::output::GetJobOutput)
    pub fn builder() -> crate::output::get_job_output::Builder {
        crate::output::get_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInstanceProfileOutput {
    /// <p>An object that contains information about an instance profile.</p>
    pub instance_profile: std::option::Option<crate::model::InstanceProfile>,
}
impl GetInstanceProfileOutput {
    /// <p>An object that contains information about an instance profile.</p>
    pub fn instance_profile(&self) -> std::option::Option<&crate::model::InstanceProfile> {
        self.instance_profile.as_ref()
    }
}
impl std::fmt::Debug for GetInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInstanceProfileOutput");
        formatter.field("instance_profile", &self.instance_profile);
        formatter.finish()
    }
}
/// See [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
pub mod get_instance_profile_output {
    /// A builder for [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile: std::option::Option<crate::model::InstanceProfile>,
    }
    impl Builder {
        /// <p>An object that contains information about an instance profile.</p>
        pub fn instance_profile(mut self, input: crate::model::InstanceProfile) -> Self {
            self.instance_profile = Some(input);
            self
        }
        /// <p>An object that contains information about an instance profile.</p>
        pub fn set_instance_profile(
            mut self,
            input: std::option::Option<crate::model::InstanceProfile>,
        ) -> Self {
            self.instance_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
        pub fn build(self) -> crate::output::GetInstanceProfileOutput {
            crate::output::GetInstanceProfileOutput {
                instance_profile: self.instance_profile,
            }
        }
    }
}
impl GetInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
    pub fn builder() -> crate::output::get_instance_profile_output::Builder {
        crate::output::get_instance_profile_output::Builder::default()
    }
}

/// <p>Represents the result of describe device pool compatibility request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePoolCompatibilityOutput {
    /// <p>Information about compatible devices.</p>
    pub compatible_devices:
        std::option::Option<std::vec::Vec<crate::model::DevicePoolCompatibilityResult>>,
    /// <p>Information about incompatible devices.</p>
    pub incompatible_devices:
        std::option::Option<std::vec::Vec<crate::model::DevicePoolCompatibilityResult>>,
}
impl GetDevicePoolCompatibilityOutput {
    /// <p>Information about compatible devices.</p>
    pub fn compatible_devices(
        &self,
    ) -> std::option::Option<&[crate::model::DevicePoolCompatibilityResult]> {
        self.compatible_devices.as_deref()
    }
    /// <p>Information about incompatible devices.</p>
    pub fn incompatible_devices(
        &self,
    ) -> std::option::Option<&[crate::model::DevicePoolCompatibilityResult]> {
        self.incompatible_devices.as_deref()
    }
}
impl std::fmt::Debug for GetDevicePoolCompatibilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePoolCompatibilityOutput");
        formatter.field("compatible_devices", &self.compatible_devices);
        formatter.field("incompatible_devices", &self.incompatible_devices);
        formatter.finish()
    }
}
/// See [`GetDevicePoolCompatibilityOutput`](crate::output::GetDevicePoolCompatibilityOutput)
pub mod get_device_pool_compatibility_output {
    /// A builder for [`GetDevicePoolCompatibilityOutput`](crate::output::GetDevicePoolCompatibilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compatible_devices:
            std::option::Option<std::vec::Vec<crate::model::DevicePoolCompatibilityResult>>,
        pub(crate) incompatible_devices:
            std::option::Option<std::vec::Vec<crate::model::DevicePoolCompatibilityResult>>,
    }
    impl Builder {
        /// Appends an item to `compatible_devices`.
        ///
        /// To override the contents of this collection use [`set_compatible_devices`](Self::set_compatible_devices).
        ///
        /// <p>Information about compatible devices.</p>
        pub fn compatible_devices(
            mut self,
            input: impl Into<crate::model::DevicePoolCompatibilityResult>,
        ) -> Self {
            let mut v = self.compatible_devices.unwrap_or_default();
            v.push(input.into());
            self.compatible_devices = Some(v);
            self
        }
        /// <p>Information about compatible devices.</p>
        pub fn set_compatible_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePoolCompatibilityResult>>,
        ) -> Self {
            self.compatible_devices = input;
            self
        }
        /// Appends an item to `incompatible_devices`.
        ///
        /// To override the contents of this collection use [`set_incompatible_devices`](Self::set_incompatible_devices).
        ///
        /// <p>Information about incompatible devices.</p>
        pub fn incompatible_devices(
            mut self,
            input: impl Into<crate::model::DevicePoolCompatibilityResult>,
        ) -> Self {
            let mut v = self.incompatible_devices.unwrap_or_default();
            v.push(input.into());
            self.incompatible_devices = Some(v);
            self
        }
        /// <p>Information about incompatible devices.</p>
        pub fn set_incompatible_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePoolCompatibilityResult>>,
        ) -> Self {
            self.incompatible_devices = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePoolCompatibilityOutput`](crate::output::GetDevicePoolCompatibilityOutput)
        pub fn build(self) -> crate::output::GetDevicePoolCompatibilityOutput {
            crate::output::GetDevicePoolCompatibilityOutput {
                compatible_devices: self.compatible_devices,
                incompatible_devices: self.incompatible_devices,
            }
        }
    }
}
impl GetDevicePoolCompatibilityOutput {
    /// Creates a new builder-style object to manufacture [`GetDevicePoolCompatibilityOutput`](crate::output::GetDevicePoolCompatibilityOutput)
    pub fn builder() -> crate::output::get_device_pool_compatibility_output::Builder {
        crate::output::get_device_pool_compatibility_output::Builder::default()
    }
}

/// <p>Represents the result of a get device pool request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePoolOutput {
    /// <p>An object that contains information about the requested device pool.</p>
    pub device_pool: std::option::Option<crate::model::DevicePool>,
}
impl GetDevicePoolOutput {
    /// <p>An object that contains information about the requested device pool.</p>
    pub fn device_pool(&self) -> std::option::Option<&crate::model::DevicePool> {
        self.device_pool.as_ref()
    }
}
impl std::fmt::Debug for GetDevicePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePoolOutput");
        formatter.field("device_pool", &self.device_pool);
        formatter.finish()
    }
}
/// See [`GetDevicePoolOutput`](crate::output::GetDevicePoolOutput)
pub mod get_device_pool_output {
    /// A builder for [`GetDevicePoolOutput`](crate::output::GetDevicePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_pool: std::option::Option<crate::model::DevicePool>,
    }
    impl Builder {
        /// <p>An object that contains information about the requested device pool.</p>
        pub fn device_pool(mut self, input: crate::model::DevicePool) -> Self {
            self.device_pool = Some(input);
            self
        }
        /// <p>An object that contains information about the requested device pool.</p>
        pub fn set_device_pool(
            mut self,
            input: std::option::Option<crate::model::DevicePool>,
        ) -> Self {
            self.device_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePoolOutput`](crate::output::GetDevicePoolOutput)
        pub fn build(self) -> crate::output::GetDevicePoolOutput {
            crate::output::GetDevicePoolOutput {
                device_pool: self.device_pool,
            }
        }
    }
}
impl GetDevicePoolOutput {
    /// Creates a new builder-style object to manufacture [`GetDevicePoolOutput`](crate::output::GetDevicePoolOutput)
    pub fn builder() -> crate::output::get_device_pool_output::Builder {
        crate::output::get_device_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceInstanceOutput {
    /// <p>An object that contains information about your device instance.</p>
    pub device_instance: std::option::Option<crate::model::DeviceInstance>,
}
impl GetDeviceInstanceOutput {
    /// <p>An object that contains information about your device instance.</p>
    pub fn device_instance(&self) -> std::option::Option<&crate::model::DeviceInstance> {
        self.device_instance.as_ref()
    }
}
impl std::fmt::Debug for GetDeviceInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceInstanceOutput");
        formatter.field("device_instance", &self.device_instance);
        formatter.finish()
    }
}
/// See [`GetDeviceInstanceOutput`](crate::output::GetDeviceInstanceOutput)
pub mod get_device_instance_output {
    /// A builder for [`GetDeviceInstanceOutput`](crate::output::GetDeviceInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_instance: std::option::Option<crate::model::DeviceInstance>,
    }
    impl Builder {
        /// <p>An object that contains information about your device instance.</p>
        pub fn device_instance(mut self, input: crate::model::DeviceInstance) -> Self {
            self.device_instance = Some(input);
            self
        }
        /// <p>An object that contains information about your device instance.</p>
        pub fn set_device_instance(
            mut self,
            input: std::option::Option<crate::model::DeviceInstance>,
        ) -> Self {
            self.device_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceInstanceOutput`](crate::output::GetDeviceInstanceOutput)
        pub fn build(self) -> crate::output::GetDeviceInstanceOutput {
            crate::output::GetDeviceInstanceOutput {
                device_instance: self.device_instance,
            }
        }
    }
}
impl GetDeviceInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetDeviceInstanceOutput`](crate::output::GetDeviceInstanceOutput)
    pub fn builder() -> crate::output::get_device_instance_output::Builder {
        crate::output::get_device_instance_output::Builder::default()
    }
}

/// <p>Represents the result of a get device request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceOutput {
    /// <p>An object that contains information about the requested device.</p>
    pub device: std::option::Option<crate::model::Device>,
}
impl GetDeviceOutput {
    /// <p>An object that contains information about the requested device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
}
impl std::fmt::Debug for GetDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceOutput");
        formatter.field("device", &self.device);
        formatter.finish()
    }
}
/// See [`GetDeviceOutput`](crate::output::GetDeviceOutput)
pub mod get_device_output {
    /// A builder for [`GetDeviceOutput`](crate::output::GetDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
    }
    impl Builder {
        /// <p>An object that contains information about the requested device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>An object that contains information about the requested device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceOutput`](crate::output::GetDeviceOutput)
        pub fn build(self) -> crate::output::GetDeviceOutput {
            crate::output::GetDeviceOutput {
                device: self.device,
            }
        }
    }
}
impl GetDeviceOutput {
    /// Creates a new builder-style object to manufacture [`GetDeviceOutput`](crate::output::GetDeviceOutput)
    pub fn builder() -> crate::output::get_device_output::Builder {
        crate::output::get_device_output::Builder::default()
    }
}

/// <p>Represents the account settings return values from the
/// <code>GetAccountSettings</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSettingsOutput {
    /// <p>The account settings.</p>
    pub account_settings: std::option::Option<crate::model::AccountSettings>,
}
impl GetAccountSettingsOutput {
    /// <p>The account settings.</p>
    pub fn account_settings(&self) -> std::option::Option<&crate::model::AccountSettings> {
        self.account_settings.as_ref()
    }
}
impl std::fmt::Debug for GetAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSettingsOutput");
        formatter.field("account_settings", &self.account_settings);
        formatter.finish()
    }
}
/// See [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
pub mod get_account_settings_output {
    /// A builder for [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_settings: std::option::Option<crate::model::AccountSettings>,
    }
    impl Builder {
        /// <p>The account settings.</p>
        pub fn account_settings(mut self, input: crate::model::AccountSettings) -> Self {
            self.account_settings = Some(input);
            self
        }
        /// <p>The account settings.</p>
        pub fn set_account_settings(
            mut self,
            input: std::option::Option<crate::model::AccountSettings>,
        ) -> Self {
            self.account_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
        pub fn build(self) -> crate::output::GetAccountSettingsOutput {
            crate::output::GetAccountSettingsOutput {
                account_settings: self.account_settings,
            }
        }
    }
}
impl GetAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
    pub fn builder() -> crate::output::get_account_settings_output::Builder {
        crate::output::get_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpceConfigurationOutput {}
impl std::fmt::Debug for DeleteVpceConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpceConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteVpceConfigurationOutput`](crate::output::DeleteVpceConfigurationOutput)
pub mod delete_vpce_configuration_output {
    /// A builder for [`DeleteVpceConfigurationOutput`](crate::output::DeleteVpceConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVpceConfigurationOutput`](crate::output::DeleteVpceConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteVpceConfigurationOutput {
            crate::output::DeleteVpceConfigurationOutput {}
        }
    }
}
impl DeleteVpceConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVpceConfigurationOutput`](crate::output::DeleteVpceConfigurationOutput)
    pub fn builder() -> crate::output::delete_vpce_configuration_output::Builder {
        crate::output::delete_vpce_configuration_output::Builder::default()
    }
}

/// <p>Represents the result of a delete upload request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUploadOutput {}
impl std::fmt::Debug for DeleteUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUploadOutput");
        formatter.finish()
    }
}
/// See [`DeleteUploadOutput`](crate::output::DeleteUploadOutput)
pub mod delete_upload_output {
    /// A builder for [`DeleteUploadOutput`](crate::output::DeleteUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUploadOutput`](crate::output::DeleteUploadOutput)
        pub fn build(self) -> crate::output::DeleteUploadOutput {
            crate::output::DeleteUploadOutput {}
        }
    }
}
impl DeleteUploadOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUploadOutput`](crate::output::DeleteUploadOutput)
    pub fn builder() -> crate::output::delete_upload_output::Builder {
        crate::output::delete_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTestGridProjectOutput {}
impl std::fmt::Debug for DeleteTestGridProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTestGridProjectOutput");
        formatter.finish()
    }
}
/// See [`DeleteTestGridProjectOutput`](crate::output::DeleteTestGridProjectOutput)
pub mod delete_test_grid_project_output {
    /// A builder for [`DeleteTestGridProjectOutput`](crate::output::DeleteTestGridProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTestGridProjectOutput`](crate::output::DeleteTestGridProjectOutput)
        pub fn build(self) -> crate::output::DeleteTestGridProjectOutput {
            crate::output::DeleteTestGridProjectOutput {}
        }
    }
}
impl DeleteTestGridProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTestGridProjectOutput`](crate::output::DeleteTestGridProjectOutput)
    pub fn builder() -> crate::output::delete_test_grid_project_output::Builder {
        crate::output::delete_test_grid_project_output::Builder::default()
    }
}

/// <p>Represents the result of a delete run request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRunOutput {}
impl std::fmt::Debug for DeleteRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRunOutput");
        formatter.finish()
    }
}
/// See [`DeleteRunOutput`](crate::output::DeleteRunOutput)
pub mod delete_run_output {
    /// A builder for [`DeleteRunOutput`](crate::output::DeleteRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRunOutput`](crate::output::DeleteRunOutput)
        pub fn build(self) -> crate::output::DeleteRunOutput {
            crate::output::DeleteRunOutput {}
        }
    }
}
impl DeleteRunOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRunOutput`](crate::output::DeleteRunOutput)
    pub fn builder() -> crate::output::delete_run_output::Builder {
        crate::output::delete_run_output::Builder::default()
    }
}

/// <p>The response from the server when a request is made to delete the remote access
/// session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRemoteAccessSessionOutput {}
impl std::fmt::Debug for DeleteRemoteAccessSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRemoteAccessSessionOutput");
        formatter.finish()
    }
}
/// See [`DeleteRemoteAccessSessionOutput`](crate::output::DeleteRemoteAccessSessionOutput)
pub mod delete_remote_access_session_output {
    /// A builder for [`DeleteRemoteAccessSessionOutput`](crate::output::DeleteRemoteAccessSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRemoteAccessSessionOutput`](crate::output::DeleteRemoteAccessSessionOutput)
        pub fn build(self) -> crate::output::DeleteRemoteAccessSessionOutput {
            crate::output::DeleteRemoteAccessSessionOutput {}
        }
    }
}
impl DeleteRemoteAccessSessionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRemoteAccessSessionOutput`](crate::output::DeleteRemoteAccessSessionOutput)
    pub fn builder() -> crate::output::delete_remote_access_session_output::Builder {
        crate::output::delete_remote_access_session_output::Builder::default()
    }
}

/// <p>Represents the result of a delete project request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput {}
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNetworkProfileOutput {}
impl std::fmt::Debug for DeleteNetworkProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNetworkProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteNetworkProfileOutput`](crate::output::DeleteNetworkProfileOutput)
pub mod delete_network_profile_output {
    /// A builder for [`DeleteNetworkProfileOutput`](crate::output::DeleteNetworkProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteNetworkProfileOutput`](crate::output::DeleteNetworkProfileOutput)
        pub fn build(self) -> crate::output::DeleteNetworkProfileOutput {
            crate::output::DeleteNetworkProfileOutput {}
        }
    }
}
impl DeleteNetworkProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkProfileOutput`](crate::output::DeleteNetworkProfileOutput)
    pub fn builder() -> crate::output::delete_network_profile_output::Builder {
        crate::output::delete_network_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInstanceProfileOutput {}
impl std::fmt::Debug for DeleteInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInstanceProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
pub mod delete_instance_profile_output {
    /// A builder for [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
        pub fn build(self) -> crate::output::DeleteInstanceProfileOutput {
            crate::output::DeleteInstanceProfileOutput {}
        }
    }
}
impl DeleteInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
    pub fn builder() -> crate::output::delete_instance_profile_output::Builder {
        crate::output::delete_instance_profile_output::Builder::default()
    }
}

/// <p>Represents the result of a delete device pool request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDevicePoolOutput {}
impl std::fmt::Debug for DeleteDevicePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDevicePoolOutput");
        formatter.finish()
    }
}
/// See [`DeleteDevicePoolOutput`](crate::output::DeleteDevicePoolOutput)
pub mod delete_device_pool_output {
    /// A builder for [`DeleteDevicePoolOutput`](crate::output::DeleteDevicePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDevicePoolOutput`](crate::output::DeleteDevicePoolOutput)
        pub fn build(self) -> crate::output::DeleteDevicePoolOutput {
            crate::output::DeleteDevicePoolOutput {}
        }
    }
}
impl DeleteDevicePoolOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDevicePoolOutput`](crate::output::DeleteDevicePoolOutput)
    pub fn builder() -> crate::output::delete_device_pool_output::Builder {
        crate::output::delete_device_pool_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpceConfigurationOutput {
    /// <p>An object that contains information about your VPC endpoint configuration.</p>
    pub vpce_configuration: std::option::Option<crate::model::VpceConfiguration>,
}
impl CreateVpceConfigurationOutput {
    /// <p>An object that contains information about your VPC endpoint configuration.</p>
    pub fn vpce_configuration(&self) -> std::option::Option<&crate::model::VpceConfiguration> {
        self.vpce_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateVpceConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpceConfigurationOutput");
        formatter.field("vpce_configuration", &self.vpce_configuration);
        formatter.finish()
    }
}
/// See [`CreateVpceConfigurationOutput`](crate::output::CreateVpceConfigurationOutput)
pub mod create_vpce_configuration_output {
    /// A builder for [`CreateVpceConfigurationOutput`](crate::output::CreateVpceConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpce_configuration: std::option::Option<crate::model::VpceConfiguration>,
    }
    impl Builder {
        /// <p>An object that contains information about your VPC endpoint configuration.</p>
        pub fn vpce_configuration(mut self, input: crate::model::VpceConfiguration) -> Self {
            self.vpce_configuration = Some(input);
            self
        }
        /// <p>An object that contains information about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration(
            mut self,
            input: std::option::Option<crate::model::VpceConfiguration>,
        ) -> Self {
            self.vpce_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpceConfigurationOutput`](crate::output::CreateVpceConfigurationOutput)
        pub fn build(self) -> crate::output::CreateVpceConfigurationOutput {
            crate::output::CreateVpceConfigurationOutput {
                vpce_configuration: self.vpce_configuration,
            }
        }
    }
}
impl CreateVpceConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateVpceConfigurationOutput`](crate::output::CreateVpceConfigurationOutput)
    pub fn builder() -> crate::output::create_vpce_configuration_output::Builder {
        crate::output::create_vpce_configuration_output::Builder::default()
    }
}

/// <p>Represents the result of a create upload request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUploadOutput {
    /// <p>The newly created upload.</p>
    pub upload: std::option::Option<crate::model::Upload>,
}
impl CreateUploadOutput {
    /// <p>The newly created upload.</p>
    pub fn upload(&self) -> std::option::Option<&crate::model::Upload> {
        self.upload.as_ref()
    }
}
impl std::fmt::Debug for CreateUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUploadOutput");
        formatter.field("upload", &self.upload);
        formatter.finish()
    }
}
/// See [`CreateUploadOutput`](crate::output::CreateUploadOutput)
pub mod create_upload_output {
    /// A builder for [`CreateUploadOutput`](crate::output::CreateUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload: std::option::Option<crate::model::Upload>,
    }
    impl Builder {
        /// <p>The newly created upload.</p>
        pub fn upload(mut self, input: crate::model::Upload) -> Self {
            self.upload = Some(input);
            self
        }
        /// <p>The newly created upload.</p>
        pub fn set_upload(mut self, input: std::option::Option<crate::model::Upload>) -> Self {
            self.upload = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUploadOutput`](crate::output::CreateUploadOutput)
        pub fn build(self) -> crate::output::CreateUploadOutput {
            crate::output::CreateUploadOutput {
                upload: self.upload,
            }
        }
    }
}
impl CreateUploadOutput {
    /// Creates a new builder-style object to manufacture [`CreateUploadOutput`](crate::output::CreateUploadOutput)
    pub fn builder() -> crate::output::create_upload_output::Builder {
        crate::output::create_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTestGridUrlOutput {
    /// <p>A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed
    /// to a <code>RemoteWebDriver</code>. </p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.</p>
    pub expires: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateTestGridUrlOutput {
    /// <p>A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed
    /// to a <code>RemoteWebDriver</code>. </p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.</p>
    pub fn expires(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expires.as_ref()
    }
}
impl std::fmt::Debug for CreateTestGridUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTestGridUrlOutput");
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.field("expires", &self.expires);
        formatter.finish()
    }
}
/// See [`CreateTestGridUrlOutput`](crate::output::CreateTestGridUrlOutput)
pub mod create_test_grid_url_output {
    /// A builder for [`CreateTestGridUrlOutput`](crate::output::CreateTestGridUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed
        /// to a <code>RemoteWebDriver</code>. </p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>A signed URL, expiring in <a>CreateTestGridUrlRequest$expiresInSeconds</a> seconds, to be passed
        /// to a <code>RemoteWebDriver</code>. </p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.</p>
        pub fn expires(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The number of seconds the URL from <a>CreateTestGridUrlResult$url</a> stays active.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTestGridUrlOutput`](crate::output::CreateTestGridUrlOutput)
        pub fn build(self) -> crate::output::CreateTestGridUrlOutput {
            crate::output::CreateTestGridUrlOutput {
                url: self.url,
                expires: self.expires,
            }
        }
    }
}
impl CreateTestGridUrlOutput {
    /// Creates a new builder-style object to manufacture [`CreateTestGridUrlOutput`](crate::output::CreateTestGridUrlOutput)
    pub fn builder() -> crate::output::create_test_grid_url_output::Builder {
        crate::output::create_test_grid_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTestGridProjectOutput {
    /// <p>ARN of the Selenium testing project that was created.</p>
    pub test_grid_project: std::option::Option<crate::model::TestGridProject>,
}
impl CreateTestGridProjectOutput {
    /// <p>ARN of the Selenium testing project that was created.</p>
    pub fn test_grid_project(&self) -> std::option::Option<&crate::model::TestGridProject> {
        self.test_grid_project.as_ref()
    }
}
impl std::fmt::Debug for CreateTestGridProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTestGridProjectOutput");
        formatter.field("test_grid_project", &self.test_grid_project);
        formatter.finish()
    }
}
/// See [`CreateTestGridProjectOutput`](crate::output::CreateTestGridProjectOutput)
pub mod create_test_grid_project_output {
    /// A builder for [`CreateTestGridProjectOutput`](crate::output::CreateTestGridProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_grid_project: std::option::Option<crate::model::TestGridProject>,
    }
    impl Builder {
        /// <p>ARN of the Selenium testing project that was created.</p>
        pub fn test_grid_project(mut self, input: crate::model::TestGridProject) -> Self {
            self.test_grid_project = Some(input);
            self
        }
        /// <p>ARN of the Selenium testing project that was created.</p>
        pub fn set_test_grid_project(
            mut self,
            input: std::option::Option<crate::model::TestGridProject>,
        ) -> Self {
            self.test_grid_project = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTestGridProjectOutput`](crate::output::CreateTestGridProjectOutput)
        pub fn build(self) -> crate::output::CreateTestGridProjectOutput {
            crate::output::CreateTestGridProjectOutput {
                test_grid_project: self.test_grid_project,
            }
        }
    }
}
impl CreateTestGridProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateTestGridProjectOutput`](crate::output::CreateTestGridProjectOutput)
    pub fn builder() -> crate::output::create_test_grid_project_output::Builder {
        crate::output::create_test_grid_project_output::Builder::default()
    }
}

/// <p>Represents the server response from a request to create a remote access
/// session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRemoteAccessSessionOutput {
    /// <p>A container that describes the remote access session when the request to create a
    /// remote access session is sent.</p>
    pub remote_access_session: std::option::Option<crate::model::RemoteAccessSession>,
}
impl CreateRemoteAccessSessionOutput {
    /// <p>A container that describes the remote access session when the request to create a
    /// remote access session is sent.</p>
    pub fn remote_access_session(&self) -> std::option::Option<&crate::model::RemoteAccessSession> {
        self.remote_access_session.as_ref()
    }
}
impl std::fmt::Debug for CreateRemoteAccessSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRemoteAccessSessionOutput");
        formatter.field("remote_access_session", &self.remote_access_session);
        formatter.finish()
    }
}
/// See [`CreateRemoteAccessSessionOutput`](crate::output::CreateRemoteAccessSessionOutput)
pub mod create_remote_access_session_output {
    /// A builder for [`CreateRemoteAccessSessionOutput`](crate::output::CreateRemoteAccessSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) remote_access_session: std::option::Option<crate::model::RemoteAccessSession>,
    }
    impl Builder {
        /// <p>A container that describes the remote access session when the request to create a
        /// remote access session is sent.</p>
        pub fn remote_access_session(mut self, input: crate::model::RemoteAccessSession) -> Self {
            self.remote_access_session = Some(input);
            self
        }
        /// <p>A container that describes the remote access session when the request to create a
        /// remote access session is sent.</p>
        pub fn set_remote_access_session(
            mut self,
            input: std::option::Option<crate::model::RemoteAccessSession>,
        ) -> Self {
            self.remote_access_session = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRemoteAccessSessionOutput`](crate::output::CreateRemoteAccessSessionOutput)
        pub fn build(self) -> crate::output::CreateRemoteAccessSessionOutput {
            crate::output::CreateRemoteAccessSessionOutput {
                remote_access_session: self.remote_access_session,
            }
        }
    }
}
impl CreateRemoteAccessSessionOutput {
    /// Creates a new builder-style object to manufacture [`CreateRemoteAccessSessionOutput`](crate::output::CreateRemoteAccessSessionOutput)
    pub fn builder() -> crate::output::create_remote_access_session_output::Builder {
        crate::output::create_remote_access_session_output::Builder::default()
    }
}

/// <p>Represents the result of a create project request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>The newly created project.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl CreateProjectOutput {
    /// <p>The newly created project.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>The newly created project.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>The newly created project.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput {
                project: self.project,
            }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNetworkProfileOutput {
    /// <p>The network profile that is returned by the create network profile
    /// request.</p>
    pub network_profile: std::option::Option<crate::model::NetworkProfile>,
}
impl CreateNetworkProfileOutput {
    /// <p>The network profile that is returned by the create network profile
    /// request.</p>
    pub fn network_profile(&self) -> std::option::Option<&crate::model::NetworkProfile> {
        self.network_profile.as_ref()
    }
}
impl std::fmt::Debug for CreateNetworkProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNetworkProfileOutput");
        formatter.field("network_profile", &self.network_profile);
        formatter.finish()
    }
}
/// See [`CreateNetworkProfileOutput`](crate::output::CreateNetworkProfileOutput)
pub mod create_network_profile_output {
    /// A builder for [`CreateNetworkProfileOutput`](crate::output::CreateNetworkProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_profile: std::option::Option<crate::model::NetworkProfile>,
    }
    impl Builder {
        /// <p>The network profile that is returned by the create network profile
        /// request.</p>
        pub fn network_profile(mut self, input: crate::model::NetworkProfile) -> Self {
            self.network_profile = Some(input);
            self
        }
        /// <p>The network profile that is returned by the create network profile
        /// request.</p>
        pub fn set_network_profile(
            mut self,
            input: std::option::Option<crate::model::NetworkProfile>,
        ) -> Self {
            self.network_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkProfileOutput`](crate::output::CreateNetworkProfileOutput)
        pub fn build(self) -> crate::output::CreateNetworkProfileOutput {
            crate::output::CreateNetworkProfileOutput {
                network_profile: self.network_profile,
            }
        }
    }
}
impl CreateNetworkProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateNetworkProfileOutput`](crate::output::CreateNetworkProfileOutput)
    pub fn builder() -> crate::output::create_network_profile_output::Builder {
        crate::output::create_network_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInstanceProfileOutput {
    /// <p>An object that contains information about your instance profile.</p>
    pub instance_profile: std::option::Option<crate::model::InstanceProfile>,
}
impl CreateInstanceProfileOutput {
    /// <p>An object that contains information about your instance profile.</p>
    pub fn instance_profile(&self) -> std::option::Option<&crate::model::InstanceProfile> {
        self.instance_profile.as_ref()
    }
}
impl std::fmt::Debug for CreateInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInstanceProfileOutput");
        formatter.field("instance_profile", &self.instance_profile);
        formatter.finish()
    }
}
/// See [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
pub mod create_instance_profile_output {
    /// A builder for [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile: std::option::Option<crate::model::InstanceProfile>,
    }
    impl Builder {
        /// <p>An object that contains information about your instance profile.</p>
        pub fn instance_profile(mut self, input: crate::model::InstanceProfile) -> Self {
            self.instance_profile = Some(input);
            self
        }
        /// <p>An object that contains information about your instance profile.</p>
        pub fn set_instance_profile(
            mut self,
            input: std::option::Option<crate::model::InstanceProfile>,
        ) -> Self {
            self.instance_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
        pub fn build(self) -> crate::output::CreateInstanceProfileOutput {
            crate::output::CreateInstanceProfileOutput {
                instance_profile: self.instance_profile,
            }
        }
    }
}
impl CreateInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
    pub fn builder() -> crate::output::create_instance_profile_output::Builder {
        crate::output::create_instance_profile_output::Builder::default()
    }
}

/// <p>Represents the result of a create device pool request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDevicePoolOutput {
    /// <p>The newly created device pool.</p>
    pub device_pool: std::option::Option<crate::model::DevicePool>,
}
impl CreateDevicePoolOutput {
    /// <p>The newly created device pool.</p>
    pub fn device_pool(&self) -> std::option::Option<&crate::model::DevicePool> {
        self.device_pool.as_ref()
    }
}
impl std::fmt::Debug for CreateDevicePoolOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDevicePoolOutput");
        formatter.field("device_pool", &self.device_pool);
        formatter.finish()
    }
}
/// See [`CreateDevicePoolOutput`](crate::output::CreateDevicePoolOutput)
pub mod create_device_pool_output {
    /// A builder for [`CreateDevicePoolOutput`](crate::output::CreateDevicePoolOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_pool: std::option::Option<crate::model::DevicePool>,
    }
    impl Builder {
        /// <p>The newly created device pool.</p>
        pub fn device_pool(mut self, input: crate::model::DevicePool) -> Self {
            self.device_pool = Some(input);
            self
        }
        /// <p>The newly created device pool.</p>
        pub fn set_device_pool(
            mut self,
            input: std::option::Option<crate::model::DevicePool>,
        ) -> Self {
            self.device_pool = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDevicePoolOutput`](crate::output::CreateDevicePoolOutput)
        pub fn build(self) -> crate::output::CreateDevicePoolOutput {
            crate::output::CreateDevicePoolOutput {
                device_pool: self.device_pool,
            }
        }
    }
}
impl CreateDevicePoolOutput {
    /// Creates a new builder-style object to manufacture [`CreateDevicePoolOutput`](crate::output::CreateDevicePoolOutput)
    pub fn builder() -> crate::output::create_device_pool_output::Builder {
        crate::output::create_device_pool_output::Builder::default()
    }
}
