// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpceConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more
    /// easily.</p>
    pub vpce_configuration_name: std::option::Option<std::string::String>,
    /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
    pub vpce_service_name: std::option::Option<std::string::String>,
    /// <p>The DNS name that maps to the private IP address of the service you want to
    /// access.</p>
    pub service_dns_name: std::option::Option<std::string::String>,
    /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
    pub vpce_configuration_description: std::option::Option<std::string::String>,
}
impl VpceConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more
    /// easily.</p>
    pub fn vpce_configuration_name(&self) -> std::option::Option<&str> {
        self.vpce_configuration_name.as_deref()
    }
    /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
    pub fn vpce_service_name(&self) -> std::option::Option<&str> {
        self.vpce_service_name.as_deref()
    }
    /// <p>The DNS name that maps to the private IP address of the service you want to
    /// access.</p>
    pub fn service_dns_name(&self) -> std::option::Option<&str> {
        self.service_dns_name.as_deref()
    }
    /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
    pub fn vpce_configuration_description(&self) -> std::option::Option<&str> {
        self.vpce_configuration_description.as_deref()
    }
}
impl std::fmt::Debug for VpceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpceConfiguration");
        formatter.field("arn", &self.arn);
        formatter.field("vpce_configuration_name", &self.vpce_configuration_name);
        formatter.field("vpce_service_name", &self.vpce_service_name);
        formatter.field("service_dns_name", &self.service_dns_name);
        formatter.field(
            "vpce_configuration_description",
            &self.vpce_configuration_description,
        );
        formatter.finish()
    }
}
/// See [`VpceConfiguration`](crate::model::VpceConfiguration)
pub mod vpce_configuration {
    /// A builder for [`VpceConfiguration`](crate::model::VpceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) vpce_configuration_name: std::option::Option<std::string::String>,
        pub(crate) vpce_service_name: std::option::Option<std::string::String>,
        pub(crate) service_dns_name: std::option::Option<std::string::String>,
        pub(crate) vpce_configuration_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more
        /// easily.</p>
        pub fn vpce_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_configuration_name = Some(input.into());
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more
        /// easily.</p>
        pub fn set_vpce_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_configuration_name = input;
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn vpce_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_service_name = Some(input.into());
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn set_vpce_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_service_name = input;
            self
        }
        /// <p>The DNS name that maps to the private IP address of the service you want to
        /// access.</p>
        pub fn service_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name that maps to the private IP address of the service you want to
        /// access.</p>
        pub fn set_service_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_dns_name = input;
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn vpce_configuration_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.vpce_configuration_description = Some(input.into());
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpce_configuration_description = input;
            self
        }
        /// Consumes the builder and constructs a [`VpceConfiguration`](crate::model::VpceConfiguration)
        pub fn build(self) -> crate::model::VpceConfiguration {
            crate::model::VpceConfiguration {
                arn: self.arn,
                vpce_configuration_name: self.vpce_configuration_name,
                vpce_service_name: self.vpce_service_name,
                service_dns_name: self.service_dns_name,
                vpce_configuration_description: self.vpce_configuration_description,
            }
        }
    }
}
impl VpceConfiguration {
    /// Creates a new builder-style object to manufacture [`VpceConfiguration`](crate::model::VpceConfiguration)
    pub fn builder() -> crate::model::vpce_configuration::Builder {
        crate::model::vpce_configuration::Builder::default()
    }
}

/// <p>An app or a set of one or more tests to upload or that have been
/// uploaded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Upload {
    /// <p>The upload's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The upload's file name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>When the upload was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The upload's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>ANDROID_APP</p>
    /// </li>
    /// <li>
    /// <p>IOS_APP</p>
    /// </li>
    /// <li>
    /// <p>WEB_APP</p>
    /// </li>
    /// <li>
    /// <p>EXTERNAL_DATA</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI_TEST_SPEC</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::UploadType>,
    /// <p>The upload's status.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>INITIALIZED</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SUCCEEDED</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::UploadStatus>,
    /// <p>The presigned Amazon S3 URL that was used to store a file using a PUT request.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The upload's metadata. For example, for Android, this contains information that is
    /// parsed from the manifest and is displayed in the AWS Device Farm console after the
    /// associated app is uploaded.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>A message about the upload's result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The upload's category. Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>CURATED: An upload managed by AWS Device Farm.</p>
    /// </li>
    /// <li>
    /// <p>PRIVATE: An upload managed by the AWS Device Farm customer.</p>
    /// </li>
    /// </ul>
    pub category: std::option::Option<crate::model::UploadCategory>,
}
impl Upload {
    /// <p>The upload's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The upload's file name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>When the upload was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The upload's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>ANDROID_APP</p>
    /// </li>
    /// <li>
    /// <p>IOS_APP</p>
    /// </li>
    /// <li>
    /// <p>WEB_APP</p>
    /// </li>
    /// <li>
    /// <p>EXTERNAL_DATA</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI_TEST_PACKAGE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION_TEST_SPEC</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI_TEST_SPEC</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UploadType> {
        self.r#type.as_ref()
    }
    /// <p>The upload's status.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>INITIALIZED</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SUCCEEDED</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::UploadStatus> {
        self.status.as_ref()
    }
    /// <p>The presigned Amazon S3 URL that was used to store a file using a PUT request.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The upload's metadata. For example, for Android, this contains information that is
    /// parsed from the manifest and is displayed in the AWS Device Farm console after the
    /// associated app is uploaded.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>A message about the upload's result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The upload's category. Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>CURATED: An upload managed by AWS Device Farm.</p>
    /// </li>
    /// <li>
    /// <p>PRIVATE: An upload managed by the AWS Device Farm customer.</p>
    /// </li>
    /// </ul>
    pub fn category(&self) -> std::option::Option<&crate::model::UploadCategory> {
        self.category.as_ref()
    }
}
impl std::fmt::Debug for Upload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Upload");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("created", &self.created);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.field("metadata", &self.metadata);
        formatter.field("content_type", &self.content_type);
        formatter.field("message", &self.message);
        formatter.field("category", &self.category);
        formatter.finish()
    }
}
/// See [`Upload`](crate::model::Upload)
pub mod upload {
    /// A builder for [`Upload`](crate::model::Upload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) r#type: std::option::Option<crate::model::UploadType>,
        pub(crate) status: std::option::Option<crate::model::UploadStatus>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<crate::model::UploadCategory>,
    }
    impl Builder {
        /// <p>The upload's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The upload's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The upload's file name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The upload's file name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>When the upload was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the upload was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The upload's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID_APP</p>
        /// </li>
        /// <li>
        /// <p>IOS_APP</p>
        /// </li>
        /// <li>
        /// <p>WEB_APP</p>
        /// </li>
        /// <li>
        /// <p>EXTERNAL_DATA</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_SPEC</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::UploadType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The upload's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID_APP</p>
        /// </li>
        /// <li>
        /// <p>IOS_APP</p>
        /// </li>
        /// <li>
        /// <p>WEB_APP</p>
        /// </li>
        /// <li>
        /// <p>EXTERNAL_DATA</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_SPEC</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UploadType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The upload's status.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>INITIALIZED</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SUCCEEDED</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::UploadStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The upload's status.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>INITIALIZED</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SUCCEEDED</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UploadStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The presigned Amazon S3 URL that was used to store a file using a PUT request.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The presigned Amazon S3 URL that was used to store a file using a PUT request.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The upload's metadata. For example, for Android, this contains information that is
        /// parsed from the manifest and is displayed in the AWS Device Farm console after the
        /// associated app is uploaded.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The upload's metadata. For example, for Android, this contains information that is
        /// parsed from the manifest and is displayed in the AWS Device Farm console after the
        /// associated app is uploaded.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>A message about the upload's result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the upload's result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The upload's category. Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>CURATED: An upload managed by AWS Device Farm.</p>
        /// </li>
        /// <li>
        /// <p>PRIVATE: An upload managed by the AWS Device Farm customer.</p>
        /// </li>
        /// </ul>
        pub fn category(mut self, input: crate::model::UploadCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The upload's category. Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>CURATED: An upload managed by AWS Device Farm.</p>
        /// </li>
        /// <li>
        /// <p>PRIVATE: An upload managed by the AWS Device Farm customer.</p>
        /// </li>
        /// </ul>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::UploadCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// Consumes the builder and constructs a [`Upload`](crate::model::Upload)
        pub fn build(self) -> crate::model::Upload {
            crate::model::Upload {
                arn: self.arn,
                name: self.name,
                created: self.created,
                r#type: self.r#type,
                status: self.status,
                url: self.url,
                metadata: self.metadata,
                content_type: self.content_type,
                message: self.message,
                category: self.category,
            }
        }
    }
}
impl Upload {
    /// Creates a new builder-style object to manufacture [`Upload`](crate::model::Upload)
    pub fn builder() -> crate::model::upload::Builder {
        crate::model::upload::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UploadCategory {
    #[allow(missing_docs)] // documentation missing in model
    Curated,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UploadCategory {
    fn from(s: &str) -> Self {
        match s {
            "CURATED" => UploadCategory::Curated,
            "PRIVATE" => UploadCategory::Private,
            other => UploadCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UploadCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UploadCategory::from(s))
    }
}
impl UploadCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UploadCategory::Curated => "CURATED",
            UploadCategory::Private => "PRIVATE",
            UploadCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURATED", "PRIVATE"]
    }
}
impl AsRef<str> for UploadCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UploadStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initialized,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UploadStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => UploadStatus::Failed,
            "INITIALIZED" => UploadStatus::Initialized,
            "PROCESSING" => UploadStatus::Processing,
            "SUCCEEDED" => UploadStatus::Succeeded,
            other => UploadStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UploadStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UploadStatus::from(s))
    }
}
impl UploadStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UploadStatus::Failed => "FAILED",
            UploadStatus::Initialized => "INITIALIZED",
            UploadStatus::Processing => "PROCESSING",
            UploadStatus::Succeeded => "SUCCEEDED",
            UploadStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "INITIALIZED", "PROCESSING", "SUCCEEDED"]
    }
}
impl AsRef<str> for UploadStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UploadType {
    #[allow(missing_docs)] // documentation missing in model
    AndroidApp,
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaJunitTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaJunitTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaTestngTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaTestngTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumNodeTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumNodeTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumPythonTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumPythonTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumRubyTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumRubyTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebJavaJunitTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebJavaJunitTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebJavaTestngTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebJavaTestngTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebNodeTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebNodeTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebPythonTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebPythonTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebRubyTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebRubyTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    CalabashTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    ExternalData,
    #[allow(missing_docs)] // documentation missing in model
    InstrumentationTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    InstrumentationTestSpec,
    #[allow(missing_docs)] // documentation missing in model
    IosApp,
    #[allow(missing_docs)] // documentation missing in model
    UiautomationTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    UiautomatorTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    WebApp,
    #[allow(missing_docs)] // documentation missing in model
    XctestTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    XctestUiTestPackage,
    #[allow(missing_docs)] // documentation missing in model
    XctestUiTestSpec,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UploadType {
    fn from(s: &str) -> Self {
        match s {
            "ANDROID_APP" => UploadType::AndroidApp,
            "APPIUM_JAVA_JUNIT_TEST_PACKAGE" => UploadType::AppiumJavaJunitTestPackage,
            "APPIUM_JAVA_JUNIT_TEST_SPEC" => UploadType::AppiumJavaJunitTestSpec,
            "APPIUM_JAVA_TESTNG_TEST_PACKAGE" => UploadType::AppiumJavaTestngTestPackage,
            "APPIUM_JAVA_TESTNG_TEST_SPEC" => UploadType::AppiumJavaTestngTestSpec,
            "APPIUM_NODE_TEST_PACKAGE" => UploadType::AppiumNodeTestPackage,
            "APPIUM_NODE_TEST_SPEC" => UploadType::AppiumNodeTestSpec,
            "APPIUM_PYTHON_TEST_PACKAGE" => UploadType::AppiumPythonTestPackage,
            "APPIUM_PYTHON_TEST_SPEC" => UploadType::AppiumPythonTestSpec,
            "APPIUM_RUBY_TEST_PACKAGE" => UploadType::AppiumRubyTestPackage,
            "APPIUM_RUBY_TEST_SPEC" => UploadType::AppiumRubyTestSpec,
            "APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE" => UploadType::AppiumWebJavaJunitTestPackage,
            "APPIUM_WEB_JAVA_JUNIT_TEST_SPEC" => UploadType::AppiumWebJavaJunitTestSpec,
            "APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE" => UploadType::AppiumWebJavaTestngTestPackage,
            "APPIUM_WEB_JAVA_TESTNG_TEST_SPEC" => UploadType::AppiumWebJavaTestngTestSpec,
            "APPIUM_WEB_NODE_TEST_PACKAGE" => UploadType::AppiumWebNodeTestPackage,
            "APPIUM_WEB_NODE_TEST_SPEC" => UploadType::AppiumWebNodeTestSpec,
            "APPIUM_WEB_PYTHON_TEST_PACKAGE" => UploadType::AppiumWebPythonTestPackage,
            "APPIUM_WEB_PYTHON_TEST_SPEC" => UploadType::AppiumWebPythonTestSpec,
            "APPIUM_WEB_RUBY_TEST_PACKAGE" => UploadType::AppiumWebRubyTestPackage,
            "APPIUM_WEB_RUBY_TEST_SPEC" => UploadType::AppiumWebRubyTestSpec,
            "CALABASH_TEST_PACKAGE" => UploadType::CalabashTestPackage,
            "EXTERNAL_DATA" => UploadType::ExternalData,
            "INSTRUMENTATION_TEST_PACKAGE" => UploadType::InstrumentationTestPackage,
            "INSTRUMENTATION_TEST_SPEC" => UploadType::InstrumentationTestSpec,
            "IOS_APP" => UploadType::IosApp,
            "UIAUTOMATION_TEST_PACKAGE" => UploadType::UiautomationTestPackage,
            "UIAUTOMATOR_TEST_PACKAGE" => UploadType::UiautomatorTestPackage,
            "WEB_APP" => UploadType::WebApp,
            "XCTEST_TEST_PACKAGE" => UploadType::XctestTestPackage,
            "XCTEST_UI_TEST_PACKAGE" => UploadType::XctestUiTestPackage,
            "XCTEST_UI_TEST_SPEC" => UploadType::XctestUiTestSpec,
            other => UploadType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UploadType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UploadType::from(s))
    }
}
impl UploadType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UploadType::AndroidApp => "ANDROID_APP",
            UploadType::AppiumJavaJunitTestPackage => "APPIUM_JAVA_JUNIT_TEST_PACKAGE",
            UploadType::AppiumJavaJunitTestSpec => "APPIUM_JAVA_JUNIT_TEST_SPEC",
            UploadType::AppiumJavaTestngTestPackage => "APPIUM_JAVA_TESTNG_TEST_PACKAGE",
            UploadType::AppiumJavaTestngTestSpec => "APPIUM_JAVA_TESTNG_TEST_SPEC",
            UploadType::AppiumNodeTestPackage => "APPIUM_NODE_TEST_PACKAGE",
            UploadType::AppiumNodeTestSpec => "APPIUM_NODE_TEST_SPEC",
            UploadType::AppiumPythonTestPackage => "APPIUM_PYTHON_TEST_PACKAGE",
            UploadType::AppiumPythonTestSpec => "APPIUM_PYTHON_TEST_SPEC",
            UploadType::AppiumRubyTestPackage => "APPIUM_RUBY_TEST_PACKAGE",
            UploadType::AppiumRubyTestSpec => "APPIUM_RUBY_TEST_SPEC",
            UploadType::AppiumWebJavaJunitTestPackage => "APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE",
            UploadType::AppiumWebJavaJunitTestSpec => "APPIUM_WEB_JAVA_JUNIT_TEST_SPEC",
            UploadType::AppiumWebJavaTestngTestPackage => "APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE",
            UploadType::AppiumWebJavaTestngTestSpec => "APPIUM_WEB_JAVA_TESTNG_TEST_SPEC",
            UploadType::AppiumWebNodeTestPackage => "APPIUM_WEB_NODE_TEST_PACKAGE",
            UploadType::AppiumWebNodeTestSpec => "APPIUM_WEB_NODE_TEST_SPEC",
            UploadType::AppiumWebPythonTestPackage => "APPIUM_WEB_PYTHON_TEST_PACKAGE",
            UploadType::AppiumWebPythonTestSpec => "APPIUM_WEB_PYTHON_TEST_SPEC",
            UploadType::AppiumWebRubyTestPackage => "APPIUM_WEB_RUBY_TEST_PACKAGE",
            UploadType::AppiumWebRubyTestSpec => "APPIUM_WEB_RUBY_TEST_SPEC",
            UploadType::CalabashTestPackage => "CALABASH_TEST_PACKAGE",
            UploadType::ExternalData => "EXTERNAL_DATA",
            UploadType::InstrumentationTestPackage => "INSTRUMENTATION_TEST_PACKAGE",
            UploadType::InstrumentationTestSpec => "INSTRUMENTATION_TEST_SPEC",
            UploadType::IosApp => "IOS_APP",
            UploadType::UiautomationTestPackage => "UIAUTOMATION_TEST_PACKAGE",
            UploadType::UiautomatorTestPackage => "UIAUTOMATOR_TEST_PACKAGE",
            UploadType::WebApp => "WEB_APP",
            UploadType::XctestTestPackage => "XCTEST_TEST_PACKAGE",
            UploadType::XctestUiTestPackage => "XCTEST_UI_TEST_PACKAGE",
            UploadType::XctestUiTestSpec => "XCTEST_UI_TEST_SPEC",
            UploadType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANDROID_APP",
            "APPIUM_JAVA_JUNIT_TEST_PACKAGE",
            "APPIUM_JAVA_JUNIT_TEST_SPEC",
            "APPIUM_JAVA_TESTNG_TEST_PACKAGE",
            "APPIUM_JAVA_TESTNG_TEST_SPEC",
            "APPIUM_NODE_TEST_PACKAGE",
            "APPIUM_NODE_TEST_SPEC",
            "APPIUM_PYTHON_TEST_PACKAGE",
            "APPIUM_PYTHON_TEST_SPEC",
            "APPIUM_RUBY_TEST_PACKAGE",
            "APPIUM_RUBY_TEST_SPEC",
            "APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE",
            "APPIUM_WEB_JAVA_JUNIT_TEST_SPEC",
            "APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE",
            "APPIUM_WEB_JAVA_TESTNG_TEST_SPEC",
            "APPIUM_WEB_NODE_TEST_PACKAGE",
            "APPIUM_WEB_NODE_TEST_SPEC",
            "APPIUM_WEB_PYTHON_TEST_PACKAGE",
            "APPIUM_WEB_PYTHON_TEST_SPEC",
            "APPIUM_WEB_RUBY_TEST_PACKAGE",
            "APPIUM_WEB_RUBY_TEST_SPEC",
            "CALABASH_TEST_PACKAGE",
            "EXTERNAL_DATA",
            "INSTRUMENTATION_TEST_PACKAGE",
            "INSTRUMENTATION_TEST_SPEC",
            "IOS_APP",
            "UIAUTOMATION_TEST_PACKAGE",
            "UIAUTOMATOR_TEST_PACKAGE",
            "WEB_APP",
            "XCTEST_TEST_PACKAGE",
            "XCTEST_UI_TEST_PACKAGE",
            "XCTEST_UI_TEST_SPEC",
        ]
    }
}
impl AsRef<str> for UploadType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A Selenium testing project. Projects are used to collect and collate sessions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestGridProject {
    /// <p>The ARN for the project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A human-readable name for the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A human-readable description for the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The VPC security groups and subnets that are attached to a project.</p>
    pub vpc_config: std::option::Option<crate::model::TestGridVpcConfig>,
    /// <p>When the project was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
}
impl TestGridProject {
    /// <p>The ARN for the project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A human-readable name for the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A human-readable description for the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The VPC security groups and subnets that are attached to a project.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::TestGridVpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>When the project was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
}
impl std::fmt::Debug for TestGridProject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestGridProject");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("created", &self.created);
        formatter.finish()
    }
}
/// See [`TestGridProject`](crate::model::TestGridProject)
pub mod test_grid_project {
    /// A builder for [`TestGridProject`](crate::model::TestGridProject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::TestGridVpcConfig>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN for the project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A human-readable name for the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A human-readable name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A human-readable description for the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description for the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn vpc_config(mut self, input: crate::model::TestGridVpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::TestGridVpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>When the project was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the project was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// Consumes the builder and constructs a [`TestGridProject`](crate::model::TestGridProject)
        pub fn build(self) -> crate::model::TestGridProject {
            crate::model::TestGridProject {
                arn: self.arn,
                name: self.name,
                description: self.description,
                vpc_config: self.vpc_config,
                created: self.created,
            }
        }
    }
}
impl TestGridProject {
    /// Creates a new builder-style object to manufacture [`TestGridProject`](crate::model::TestGridProject)
    pub fn builder() -> crate::model::test_grid_project::Builder {
        crate::model::test_grid_project::Builder::default()
    }
}

/// <p>The VPC security groups and subnets that are attached to a project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestGridVpcConfig {
    /// <p>A list of VPC security group IDs in your Amazon VPC.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of VPC subnet IDs in your Amazon VPC.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the Amazon VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl TestGridVpcConfig {
    /// <p>A list of VPC security group IDs in your Amazon VPC.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>A list of VPC subnet IDs in your Amazon VPC.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The ID of the Amazon VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for TestGridVpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestGridVpcConfig");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`TestGridVpcConfig`](crate::model::TestGridVpcConfig)
pub mod test_grid_vpc_config {
    /// A builder for [`TestGridVpcConfig`](crate::model::TestGridVpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of VPC security group IDs in your Amazon VPC.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security group IDs in your Amazon VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs in your Amazon VPC.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of VPC subnet IDs in your Amazon VPC.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The ID of the Amazon VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TestGridVpcConfig`](crate::model::TestGridVpcConfig)
        pub fn build(self) -> crate::model::TestGridVpcConfig {
            crate::model::TestGridVpcConfig {
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl TestGridVpcConfig {
    /// Creates a new builder-style object to manufacture [`TestGridVpcConfig`](crate::model::TestGridVpcConfig)
    pub fn builder() -> crate::model::test_grid_vpc_config::Builder {
        crate::model::test_grid_vpc_config::Builder::default()
    }
}

/// <p>Represents an operating-system neutral workspace for running and managing
/// tests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Project {
    /// <p>The project's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The project's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The default number of minutes (at the project level) a test run executes before it times out. The
    /// default value is 150 minutes.</p>
    pub default_job_timeout_minutes: std::option::Option<i32>,
    /// <p>When the project was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
}
impl Project {
    /// <p>The project's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The project's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The default number of minutes (at the project level) a test run executes before it times out. The
    /// default value is 150 minutes.</p>
    pub fn default_job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.default_job_timeout_minutes
    }
    /// <p>When the project was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
}
impl std::fmt::Debug for Project {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Project");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field(
            "default_job_timeout_minutes",
            &self.default_job_timeout_minutes,
        );
        formatter.field("created", &self.created);
        formatter.finish()
    }
}
/// See [`Project`](crate::model::Project)
pub mod project {
    /// A builder for [`Project`](crate::model::Project)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_job_timeout_minutes: std::option::Option<i32>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The project's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The project's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The project's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The project's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The default number of minutes (at the project level) a test run executes before it times out. The
        /// default value is 150 minutes.</p>
        pub fn default_job_timeout_minutes(mut self, input: i32) -> Self {
            self.default_job_timeout_minutes = Some(input);
            self
        }
        /// <p>The default number of minutes (at the project level) a test run executes before it times out. The
        /// default value is 150 minutes.</p>
        pub fn set_default_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.default_job_timeout_minutes = input;
            self
        }
        /// <p>When the project was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the project was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// Consumes the builder and constructs a [`Project`](crate::model::Project)
        pub fn build(self) -> crate::model::Project {
            crate::model::Project {
                arn: self.arn,
                name: self.name,
                default_job_timeout_minutes: self.default_job_timeout_minutes,
                created: self.created,
            }
        }
    }
}
impl Project {
    /// Creates a new builder-style object to manufacture [`Project`](crate::model::Project)
    pub fn builder() -> crate::model::project::Builder {
        crate::model::project::Builder::default()
    }
}

/// <p>An array of settings that describes characteristics of a network profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkProfile {
    /// <p>The Amazon Resource Name (ARN) of the network profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the network profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the network profile.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of network profile. Valid values are listed here.</p>
    pub r#type: std::option::Option<crate::model::NetworkProfileType>,
    /// <p>The data throughput rate in bits per second, as an integer from 0 to
    /// 104857600.</p>
    pub uplink_bandwidth_bits: std::option::Option<i64>,
    /// <p>The data throughput rate in bits per second, as an integer from 0 to
    /// 104857600.</p>
    pub downlink_bandwidth_bits: std::option::Option<i64>,
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
    /// 2000.</p>
    pub uplink_delay_ms: std::option::Option<i64>,
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
    /// 2000.</p>
    pub downlink_delay_ms: std::option::Option<i64>,
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from
    /// 0 to 2000.</p>
    pub uplink_jitter_ms: std::option::Option<i64>,
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from
    /// 0 to 2000.</p>
    pub downlink_jitter_ms: std::option::Option<i64>,
    /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
    /// percent.</p>
    pub uplink_loss_percent: i32,
    /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
    pub downlink_loss_percent: i32,
}
impl NetworkProfile {
    /// <p>The Amazon Resource Name (ARN) of the network profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the network profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the network profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of network profile. Valid values are listed here.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NetworkProfileType> {
        self.r#type.as_ref()
    }
    /// <p>The data throughput rate in bits per second, as an integer from 0 to
    /// 104857600.</p>
    pub fn uplink_bandwidth_bits(&self) -> std::option::Option<i64> {
        self.uplink_bandwidth_bits
    }
    /// <p>The data throughput rate in bits per second, as an integer from 0 to
    /// 104857600.</p>
    pub fn downlink_bandwidth_bits(&self) -> std::option::Option<i64> {
        self.downlink_bandwidth_bits
    }
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
    /// 2000.</p>
    pub fn uplink_delay_ms(&self) -> std::option::Option<i64> {
        self.uplink_delay_ms
    }
    /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
    /// 2000.</p>
    pub fn downlink_delay_ms(&self) -> std::option::Option<i64> {
        self.downlink_delay_ms
    }
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from
    /// 0 to 2000.</p>
    pub fn uplink_jitter_ms(&self) -> std::option::Option<i64> {
        self.uplink_jitter_ms
    }
    /// <p>Time variation in the delay of received packets in milliseconds as an integer from
    /// 0 to 2000.</p>
    pub fn downlink_jitter_ms(&self) -> std::option::Option<i64> {
        self.downlink_jitter_ms
    }
    /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
    /// percent.</p>
    pub fn uplink_loss_percent(&self) -> i32 {
        self.uplink_loss_percent
    }
    /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
    pub fn downlink_loss_percent(&self) -> i32 {
        self.downlink_loss_percent
    }
}
impl std::fmt::Debug for NetworkProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkProfile");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("uplink_bandwidth_bits", &self.uplink_bandwidth_bits);
        formatter.field("downlink_bandwidth_bits", &self.downlink_bandwidth_bits);
        formatter.field("uplink_delay_ms", &self.uplink_delay_ms);
        formatter.field("downlink_delay_ms", &self.downlink_delay_ms);
        formatter.field("uplink_jitter_ms", &self.uplink_jitter_ms);
        formatter.field("downlink_jitter_ms", &self.downlink_jitter_ms);
        formatter.field("uplink_loss_percent", &self.uplink_loss_percent);
        formatter.field("downlink_loss_percent", &self.downlink_loss_percent);
        formatter.finish()
    }
}
/// See [`NetworkProfile`](crate::model::NetworkProfile)
pub mod network_profile {
    /// A builder for [`NetworkProfile`](crate::model::NetworkProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::NetworkProfileType>,
        pub(crate) uplink_bandwidth_bits: std::option::Option<i64>,
        pub(crate) downlink_bandwidth_bits: std::option::Option<i64>,
        pub(crate) uplink_delay_ms: std::option::Option<i64>,
        pub(crate) downlink_delay_ms: std::option::Option<i64>,
        pub(crate) uplink_jitter_ms: std::option::Option<i64>,
        pub(crate) downlink_jitter_ms: std::option::Option<i64>,
        pub(crate) uplink_loss_percent: std::option::Option<i32>,
        pub(crate) downlink_loss_percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the network profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the network profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the network profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the network profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of network profile. Valid values are listed here.</p>
        pub fn r#type(mut self, input: crate::model::NetworkProfileType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of network profile. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn uplink_bandwidth_bits(mut self, input: i64) -> Self {
            self.uplink_bandwidth_bits = Some(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn set_uplink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_bandwidth_bits = input;
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn downlink_bandwidth_bits(mut self, input: i64) -> Self {
            self.downlink_bandwidth_bits = Some(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn set_downlink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_bandwidth_bits = input;
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn uplink_delay_ms(mut self, input: i64) -> Self {
            self.uplink_delay_ms = Some(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn set_uplink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_delay_ms = input;
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn downlink_delay_ms(mut self, input: i64) -> Self {
            self.downlink_delay_ms = Some(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn set_downlink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_delay_ms = input;
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn uplink_jitter_ms(mut self, input: i64) -> Self {
            self.uplink_jitter_ms = Some(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn set_uplink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.uplink_jitter_ms = input;
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn downlink_jitter_ms(mut self, input: i64) -> Self {
            self.downlink_jitter_ms = Some(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn set_downlink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.downlink_jitter_ms = input;
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
        /// percent.</p>
        pub fn uplink_loss_percent(mut self, input: i32) -> Self {
            self.uplink_loss_percent = Some(input);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
        /// percent.</p>
        pub fn set_uplink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.uplink_loss_percent = input;
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn downlink_loss_percent(mut self, input: i32) -> Self {
            self.downlink_loss_percent = Some(input);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_downlink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.downlink_loss_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkProfile`](crate::model::NetworkProfile)
        pub fn build(self) -> crate::model::NetworkProfile {
            crate::model::NetworkProfile {
                arn: self.arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                uplink_bandwidth_bits: self.uplink_bandwidth_bits,
                downlink_bandwidth_bits: self.downlink_bandwidth_bits,
                uplink_delay_ms: self.uplink_delay_ms,
                downlink_delay_ms: self.downlink_delay_ms,
                uplink_jitter_ms: self.uplink_jitter_ms,
                downlink_jitter_ms: self.downlink_jitter_ms,
                uplink_loss_percent: self.uplink_loss_percent.unwrap_or_default(),
                downlink_loss_percent: self.downlink_loss_percent.unwrap_or_default(),
            }
        }
    }
}
impl NetworkProfile {
    /// Creates a new builder-style object to manufacture [`NetworkProfile`](crate::model::NetworkProfile)
    pub fn builder() -> crate::model::network_profile::Builder {
        crate::model::network_profile::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkProfileType {
    #[allow(missing_docs)] // documentation missing in model
    Curated,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkProfileType {
    fn from(s: &str) -> Self {
        match s {
            "CURATED" => NetworkProfileType::Curated,
            "PRIVATE" => NetworkProfileType::Private,
            other => NetworkProfileType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkProfileType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkProfileType::from(s))
    }
}
impl NetworkProfileType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkProfileType::Curated => "CURATED",
            NetworkProfileType::Private => "PRIVATE",
            NetworkProfileType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURATED", "PRIVATE"]
    }
}
impl AsRef<str> for NetworkProfileType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the instance profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceProfile {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is
    /// <code>false</code> for private devices.</p>
    pub package_cleanup: std::option::Option<bool>,
    /// <p>An array of strings containing the list of app packages that should not be cleaned up from the device
    /// after a test run completes.</p>
    /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to
    /// <code>true</code>.</p>
    pub exclude_app_packages_from_cleanup: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is
    /// <code>true</code>.</p>
    pub reboot_after_use: std::option::Option<bool>,
    /// <p>The name of the instance profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the instance profile.</p>
    pub description: std::option::Option<std::string::String>,
}
impl InstanceProfile {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is
    /// <code>false</code> for private devices.</p>
    pub fn package_cleanup(&self) -> std::option::Option<bool> {
        self.package_cleanup
    }
    /// <p>An array of strings containing the list of app packages that should not be cleaned up from the device
    /// after a test run completes.</p>
    /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to
    /// <code>true</code>.</p>
    pub fn exclude_app_packages_from_cleanup(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_app_packages_from_cleanup.as_deref()
    }
    /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is
    /// <code>true</code>.</p>
    pub fn reboot_after_use(&self) -> std::option::Option<bool> {
        self.reboot_after_use
    }
    /// <p>The name of the instance profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the instance profile.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for InstanceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceProfile");
        formatter.field("arn", &self.arn);
        formatter.field("package_cleanup", &self.package_cleanup);
        formatter.field(
            "exclude_app_packages_from_cleanup",
            &self.exclude_app_packages_from_cleanup,
        );
        formatter.field("reboot_after_use", &self.reboot_after_use);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`InstanceProfile`](crate::model::InstanceProfile)
pub mod instance_profile {
    /// A builder for [`InstanceProfile`](crate::model::InstanceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) package_cleanup: std::option::Option<bool>,
        pub(crate) exclude_app_packages_from_cleanup:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reboot_after_use: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is
        /// <code>false</code> for private devices.</p>
        pub fn package_cleanup(mut self, input: bool) -> Self {
            self.package_cleanup = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is
        /// <code>false</code> for private devices.</p>
        pub fn set_package_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.package_cleanup = input;
            self
        }
        /// Appends an item to `exclude_app_packages_from_cleanup`.
        ///
        /// To override the contents of this collection use [`set_exclude_app_packages_from_cleanup`](Self::set_exclude_app_packages_from_cleanup).
        ///
        /// <p>An array of strings containing the list of app packages that should not be cleaned up from the device
        /// after a test run completes.</p>
        /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to
        /// <code>true</code>.</p>
        pub fn exclude_app_packages_from_cleanup(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_app_packages_from_cleanup.unwrap_or_default();
            v.push(input.into());
            self.exclude_app_packages_from_cleanup = Some(v);
            self
        }
        /// <p>An array of strings containing the list of app packages that should not be cleaned up from the device
        /// after a test run completes.</p>
        /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to
        /// <code>true</code>.</p>
        pub fn set_exclude_app_packages_from_cleanup(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_app_packages_from_cleanup = input;
            self
        }
        /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is
        /// <code>true</code>.</p>
        pub fn reboot_after_use(mut self, input: bool) -> Self {
            self.reboot_after_use = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is
        /// <code>true</code>.</p>
        pub fn set_reboot_after_use(mut self, input: std::option::Option<bool>) -> Self {
            self.reboot_after_use = input;
            self
        }
        /// <p>The name of the instance profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the instance profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the instance profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the instance profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceProfile`](crate::model::InstanceProfile)
        pub fn build(self) -> crate::model::InstanceProfile {
            crate::model::InstanceProfile {
                arn: self.arn,
                package_cleanup: self.package_cleanup,
                exclude_app_packages_from_cleanup: self.exclude_app_packages_from_cleanup,
                reboot_after_use: self.reboot_after_use,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl InstanceProfile {
    /// Creates a new builder-style object to manufacture [`InstanceProfile`](crate::model::InstanceProfile)
    pub fn builder() -> crate::model::instance_profile::Builder {
        crate::model::instance_profile::Builder::default()
    }
}

/// <p>Represents a collection of device types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DevicePool {
    /// <p>The device pool's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The device pool's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The device pool's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The device pool's type.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>CURATED: A device pool that is created and managed by AWS Device
    /// Farm.</p>
    /// </li>
    /// <li>
    /// <p>PRIVATE: A device pool that is created and managed by the device pool
    /// developer.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::DevicePoolType>,
    /// <p>Information about the device pool's rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
    /// available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many
    /// devices meet these constraints, your device pool might contain fewer devices than the value for this
    /// parameter.</p>
    /// <p>By specifying the maximum number of devices, you can control the costs that you incur
    /// by running tests.</p>
    pub max_devices: std::option::Option<i32>,
}
impl DevicePool {
    /// <p>The device pool's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The device pool's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The device pool's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The device pool's type.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>CURATED: A device pool that is created and managed by AWS Device
    /// Farm.</p>
    /// </li>
    /// <li>
    /// <p>PRIVATE: A device pool that is created and managed by the device pool
    /// developer.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DevicePoolType> {
        self.r#type.as_ref()
    }
    /// <p>Information about the device pool's rules.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
    /// available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many
    /// devices meet these constraints, your device pool might contain fewer devices than the value for this
    /// parameter.</p>
    /// <p>By specifying the maximum number of devices, you can control the costs that you incur
    /// by running tests.</p>
    pub fn max_devices(&self) -> std::option::Option<i32> {
        self.max_devices
    }
}
impl std::fmt::Debug for DevicePool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DevicePool");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("rules", &self.rules);
        formatter.field("max_devices", &self.max_devices);
        formatter.finish()
    }
}
/// See [`DevicePool`](crate::model::DevicePool)
pub mod device_pool {
    /// A builder for [`DevicePool`](crate::model::DevicePool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DevicePoolType>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) max_devices: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The device pool's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The device pool's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The device pool's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The device pool's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The device pool's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The device pool's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The device pool's type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>CURATED: A device pool that is created and managed by AWS Device
        /// Farm.</p>
        /// </li>
        /// <li>
        /// <p>PRIVATE: A device pool that is created and managed by the device pool
        /// developer.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::DevicePoolType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The device pool's type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>CURATED: A device pool that is created and managed by AWS Device
        /// Farm.</p>
        /// </li>
        /// <li>
        /// <p>PRIVATE: A device pool that is created and managed by the device pool
        /// developer.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DevicePoolType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Information about the device pool's rules.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Information about the device pool's rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
        /// available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many
        /// devices meet these constraints, your device pool might contain fewer devices than the value for this
        /// parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur
        /// by running tests.</p>
        pub fn max_devices(mut self, input: i32) -> Self {
            self.max_devices = Some(input);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
        /// available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many
        /// devices meet these constraints, your device pool might contain fewer devices than the value for this
        /// parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur
        /// by running tests.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.max_devices = input;
            self
        }
        /// Consumes the builder and constructs a [`DevicePool`](crate::model::DevicePool)
        pub fn build(self) -> crate::model::DevicePool {
            crate::model::DevicePool {
                arn: self.arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                rules: self.rules,
                max_devices: self.max_devices,
            }
        }
    }
}
impl DevicePool {
    /// Creates a new builder-style object to manufacture [`DevicePool`](crate::model::DevicePool)
    pub fn builder() -> crate::model::device_pool::Builder {
        crate::model::device_pool::Builder::default()
    }
}

/// <p>Represents a condition for a device pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rule {
    /// <p>The rule's stringified attribute. For example, specify the value as
    /// <code>"\"abc\""</code>.</p>
    /// <p>The supported operators for each attribute are provided in the following
    /// list.</p>
    /// <dl>
    /// <dt>APPIUM_VERSION</dt>
    /// <dd>
    /// <p>The Appium version for the test.</p>
    /// <p>Supported operators: <code>CONTAINS</code>
    /// </p>
    /// </dd>
    /// <dt>ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device (for example,
    /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>AVAILABILITY</dt>
    /// <dd>
    /// <p>The current availability of the device. Valid values are AVAILABLE,
    /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>FLEET_TYPE</dt>
    /// <dd>
    /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>FORM_FACTOR</dt>
    /// <dd>
    /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>INSTANCE_ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    /// <p>Supported operators: <code>IN</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>INSTANCE_LABELS</dt>
    /// <dd>
    /// <p>The label of the device instance.</p>
    /// <p>Supported operators: <code>CONTAINS</code>
    /// </p>
    /// </dd>
    /// <dt>MANUFACTURER</dt>
    /// <dd>
    /// <p>The device manufacturer (for example, Apple).</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>MODEL</dt>
    /// <dd>
    /// <p>The device model, such as Apple iPad Air 2 or Google Pixel.</p>
    /// <p>Supported operators: <code>CONTAINS</code>,
    /// <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>OS_VERSION</dt>
    /// <dd>
    /// <p>The operating system version (for example, 10.3.2).</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
    /// <code>IN</code>, <code>LESS_THAN</code>,
    /// <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>PLATFORM</dt>
    /// <dd>
    /// <p>The device platform. Valid values are ANDROID or IOS.</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_ACCESS_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote access. Valid values are TRUE
    /// or FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_DEBUG_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote debugging. Valid values are
    /// TRUE or FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
    /// supported</a>, this filter is ignored.</p>
    /// </dd>
    /// </dl>
    pub attribute: std::option::Option<crate::model::DeviceAttribute>,
    /// <p>Specifies how Device Farm compares the rule's attribute to the value. For the
    /// operators that are supported by each attribute, see the attribute
    /// descriptions.</p>
    pub operator: std::option::Option<crate::model::RuleOperator>,
    /// <p>The rule's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Rule {
    /// <p>The rule's stringified attribute. For example, specify the value as
    /// <code>"\"abc\""</code>.</p>
    /// <p>The supported operators for each attribute are provided in the following
    /// list.</p>
    /// <dl>
    /// <dt>APPIUM_VERSION</dt>
    /// <dd>
    /// <p>The Appium version for the test.</p>
    /// <p>Supported operators: <code>CONTAINS</code>
    /// </p>
    /// </dd>
    /// <dt>ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device (for example,
    /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>AVAILABILITY</dt>
    /// <dd>
    /// <p>The current availability of the device. Valid values are AVAILABLE,
    /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>FLEET_TYPE</dt>
    /// <dd>
    /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>FORM_FACTOR</dt>
    /// <dd>
    /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>INSTANCE_ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    /// <p>Supported operators: <code>IN</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>INSTANCE_LABELS</dt>
    /// <dd>
    /// <p>The label of the device instance.</p>
    /// <p>Supported operators: <code>CONTAINS</code>
    /// </p>
    /// </dd>
    /// <dt>MANUFACTURER</dt>
    /// <dd>
    /// <p>The device manufacturer (for example, Apple).</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>MODEL</dt>
    /// <dd>
    /// <p>The device model, such as Apple iPad Air 2 or Google Pixel.</p>
    /// <p>Supported operators: <code>CONTAINS</code>,
    /// <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>OS_VERSION</dt>
    /// <dd>
    /// <p>The operating system version (for example, 10.3.2).</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
    /// <code>IN</code>, <code>LESS_THAN</code>,
    /// <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>PLATFORM</dt>
    /// <dd>
    /// <p>The device platform. Valid values are ANDROID or IOS.</p>
    /// <p>Supported operators: <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_ACCESS_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote access. Valid values are TRUE
    /// or FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_DEBUG_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote debugging. Valid values are
    /// TRUE or FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
    /// supported</a>, this filter is ignored.</p>
    /// </dd>
    /// </dl>
    pub fn attribute(&self) -> std::option::Option<&crate::model::DeviceAttribute> {
        self.attribute.as_ref()
    }
    /// <p>Specifies how Device Farm compares the rule's attribute to the value. For the
    /// operators that are supported by each attribute, see the attribute
    /// descriptions.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::RuleOperator> {
        self.operator.as_ref()
    }
    /// <p>The rule's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Rule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rule");
        formatter.field("attribute", &self.attribute);
        formatter.field("operator", &self.operator);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Rule`](crate::model::Rule)
pub mod rule {
    /// A builder for [`Rule`](crate::model::Rule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::DeviceAttribute>,
        pub(crate) operator: std::option::Option<crate::model::RuleOperator>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The rule's stringified attribute. For example, specify the value as
        /// <code>"\"abc\""</code>.</p>
        /// <p>The supported operators for each attribute are provided in the following
        /// list.</p>
        /// <dl>
        /// <dt>APPIUM_VERSION</dt>
        /// <dd>
        /// <p>The Appium version for the test.</p>
        /// <p>Supported operators: <code>CONTAINS</code>
        /// </p>
        /// </dd>
        /// <dt>ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>AVAILABILITY</dt>
        /// <dd>
        /// <p>The current availability of the device. Valid values are AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>FLEET_TYPE</dt>
        /// <dd>
        /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>FORM_FACTOR</dt>
        /// <dd>
        /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>INSTANCE_ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        /// <p>Supported operators: <code>IN</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>INSTANCE_LABELS</dt>
        /// <dd>
        /// <p>The label of the device instance.</p>
        /// <p>Supported operators: <code>CONTAINS</code>
        /// </p>
        /// </dd>
        /// <dt>MANUFACTURER</dt>
        /// <dd>
        /// <p>The device manufacturer (for example, Apple).</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>MODEL</dt>
        /// <dd>
        /// <p>The device model, such as Apple iPad Air 2 or Google Pixel.</p>
        /// <p>Supported operators: <code>CONTAINS</code>,
        /// <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>OS_VERSION</dt>
        /// <dd>
        /// <p>The operating system version (for example, 10.3.2).</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
        /// <code>IN</code>, <code>LESS_THAN</code>,
        /// <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>PLATFORM</dt>
        /// <dd>
        /// <p>The device platform. Valid values are ANDROID or IOS.</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_ACCESS_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote access. Valid values are TRUE
        /// or FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_DEBUG_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote debugging. Valid values are
        /// TRUE or FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
        /// supported</a>, this filter is ignored.</p>
        /// </dd>
        /// </dl>
        pub fn attribute(mut self, input: crate::model::DeviceAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The rule's stringified attribute. For example, specify the value as
        /// <code>"\"abc\""</code>.</p>
        /// <p>The supported operators for each attribute are provided in the following
        /// list.</p>
        /// <dl>
        /// <dt>APPIUM_VERSION</dt>
        /// <dd>
        /// <p>The Appium version for the test.</p>
        /// <p>Supported operators: <code>CONTAINS</code>
        /// </p>
        /// </dd>
        /// <dt>ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>AVAILABILITY</dt>
        /// <dd>
        /// <p>The current availability of the device. Valid values are AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>FLEET_TYPE</dt>
        /// <dd>
        /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>FORM_FACTOR</dt>
        /// <dd>
        /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>INSTANCE_ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        /// <p>Supported operators: <code>IN</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>INSTANCE_LABELS</dt>
        /// <dd>
        /// <p>The label of the device instance.</p>
        /// <p>Supported operators: <code>CONTAINS</code>
        /// </p>
        /// </dd>
        /// <dt>MANUFACTURER</dt>
        /// <dd>
        /// <p>The device manufacturer (for example, Apple).</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>MODEL</dt>
        /// <dd>
        /// <p>The device model, such as Apple iPad Air 2 or Google Pixel.</p>
        /// <p>Supported operators: <code>CONTAINS</code>,
        /// <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>OS_VERSION</dt>
        /// <dd>
        /// <p>The operating system version (for example, 10.3.2).</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
        /// <code>IN</code>, <code>LESS_THAN</code>,
        /// <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>PLATFORM</dt>
        /// <dd>
        /// <p>The device platform. Valid values are ANDROID or IOS.</p>
        /// <p>Supported operators: <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_ACCESS_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote access. Valid values are TRUE
        /// or FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_DEBUG_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote debugging. Valid values are
        /// TRUE or FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
        /// supported</a>, this filter is ignored.</p>
        /// </dd>
        /// </dl>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::DeviceAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>Specifies how Device Farm compares the rule's attribute to the value. For the
        /// operators that are supported by each attribute, see the attribute
        /// descriptions.</p>
        pub fn operator(mut self, input: crate::model::RuleOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>Specifies how Device Farm compares the rule's attribute to the value. For the
        /// operators that are supported by each attribute, see the attribute
        /// descriptions.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::RuleOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// <p>The rule's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The rule's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Rule`](crate::model::Rule)
        pub fn build(self) -> crate::model::Rule {
            crate::model::Rule {
                attribute: self.attribute,
                operator: self.operator,
                value: self.value,
            }
        }
    }
}
impl Rule {
    /// Creates a new builder-style object to manufacture [`Rule`](crate::model::Rule)
    pub fn builder() -> crate::model::rule::Builder {
        crate::model::rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEquals,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEquals,
    #[allow(missing_docs)] // documentation missing in model
    NotIn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleOperator {
    fn from(s: &str) -> Self {
        match s {
            "CONTAINS" => RuleOperator::Contains,
            "EQUALS" => RuleOperator::Equals,
            "GREATER_THAN" => RuleOperator::GreaterThan,
            "GREATER_THAN_OR_EQUALS" => RuleOperator::GreaterThanOrEquals,
            "IN" => RuleOperator::In,
            "LESS_THAN" => RuleOperator::LessThan,
            "LESS_THAN_OR_EQUALS" => RuleOperator::LessThanOrEquals,
            "NOT_IN" => RuleOperator::NotIn,
            other => RuleOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleOperator::from(s))
    }
}
impl RuleOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleOperator::Contains => "CONTAINS",
            RuleOperator::Equals => "EQUALS",
            RuleOperator::GreaterThan => "GREATER_THAN",
            RuleOperator::GreaterThanOrEquals => "GREATER_THAN_OR_EQUALS",
            RuleOperator::In => "IN",
            RuleOperator::LessThan => "LESS_THAN",
            RuleOperator::LessThanOrEquals => "LESS_THAN_OR_EQUALS",
            RuleOperator::NotIn => "NOT_IN",
            RuleOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONTAINS",
            "EQUALS",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUALS",
            "IN",
            "LESS_THAN",
            "LESS_THAN_OR_EQUALS",
            "NOT_IN",
        ]
    }
}
impl AsRef<str> for RuleOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceAttribute {
    #[allow(missing_docs)] // documentation missing in model
    AppiumVersion,
    #[allow(missing_docs)] // documentation missing in model
    Arn,
    #[allow(missing_docs)] // documentation missing in model
    Availability,
    #[allow(missing_docs)] // documentation missing in model
    FleetType,
    #[allow(missing_docs)] // documentation missing in model
    FormFactor,
    #[allow(missing_docs)] // documentation missing in model
    InstanceArn,
    #[allow(missing_docs)] // documentation missing in model
    InstanceLabels,
    #[allow(missing_docs)] // documentation missing in model
    Manufacturer,
    #[allow(missing_docs)] // documentation missing in model
    Model,
    #[allow(missing_docs)] // documentation missing in model
    OsVersion,
    #[allow(missing_docs)] // documentation missing in model
    Platform,
    #[allow(missing_docs)] // documentation missing in model
    RemoteAccessEnabled,
    #[allow(missing_docs)] // documentation missing in model
    RemoteDebugEnabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceAttribute {
    fn from(s: &str) -> Self {
        match s {
            "APPIUM_VERSION" => DeviceAttribute::AppiumVersion,
            "ARN" => DeviceAttribute::Arn,
            "AVAILABILITY" => DeviceAttribute::Availability,
            "FLEET_TYPE" => DeviceAttribute::FleetType,
            "FORM_FACTOR" => DeviceAttribute::FormFactor,
            "INSTANCE_ARN" => DeviceAttribute::InstanceArn,
            "INSTANCE_LABELS" => DeviceAttribute::InstanceLabels,
            "MANUFACTURER" => DeviceAttribute::Manufacturer,
            "MODEL" => DeviceAttribute::Model,
            "OS_VERSION" => DeviceAttribute::OsVersion,
            "PLATFORM" => DeviceAttribute::Platform,
            "REMOTE_ACCESS_ENABLED" => DeviceAttribute::RemoteAccessEnabled,
            "REMOTE_DEBUG_ENABLED" => DeviceAttribute::RemoteDebugEnabled,
            other => DeviceAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceAttribute::from(s))
    }
}
impl DeviceAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceAttribute::AppiumVersion => "APPIUM_VERSION",
            DeviceAttribute::Arn => "ARN",
            DeviceAttribute::Availability => "AVAILABILITY",
            DeviceAttribute::FleetType => "FLEET_TYPE",
            DeviceAttribute::FormFactor => "FORM_FACTOR",
            DeviceAttribute::InstanceArn => "INSTANCE_ARN",
            DeviceAttribute::InstanceLabels => "INSTANCE_LABELS",
            DeviceAttribute::Manufacturer => "MANUFACTURER",
            DeviceAttribute::Model => "MODEL",
            DeviceAttribute::OsVersion => "OS_VERSION",
            DeviceAttribute::Platform => "PLATFORM",
            DeviceAttribute::RemoteAccessEnabled => "REMOTE_ACCESS_ENABLED",
            DeviceAttribute::RemoteDebugEnabled => "REMOTE_DEBUG_ENABLED",
            DeviceAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPIUM_VERSION",
            "ARN",
            "AVAILABILITY",
            "FLEET_TYPE",
            "FORM_FACTOR",
            "INSTANCE_ARN",
            "INSTANCE_LABELS",
            "MANUFACTURER",
            "MODEL",
            "OS_VERSION",
            "PLATFORM",
            "REMOTE_ACCESS_ENABLED",
            "REMOTE_DEBUG_ENABLED",
        ]
    }
}
impl AsRef<str> for DeviceAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DevicePoolType {
    #[allow(missing_docs)] // documentation missing in model
    Curated,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DevicePoolType {
    fn from(s: &str) -> Self {
        match s {
            "CURATED" => DevicePoolType::Curated,
            "PRIVATE" => DevicePoolType::Private,
            other => DevicePoolType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DevicePoolType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DevicePoolType::from(s))
    }
}
impl DevicePoolType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DevicePoolType::Curated => "CURATED",
            DevicePoolType::Private => "PRIVATE",
            DevicePoolType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURATED", "PRIVATE"]
    }
}
impl AsRef<str> for DevicePoolType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the device instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceInstance {
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the device.</p>
    pub device_arn: std::option::Option<std::string::String>,
    /// <p>An array of strings that describe the device instance.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the device instance. Valid values are listed here.</p>
    pub status: std::option::Option<crate::model::InstanceStatus>,
    /// <p>Unique device identifier for the device instance.</p>
    pub udid: std::option::Option<std::string::String>,
    /// <p>A object that contains information about the instance profile.</p>
    pub instance_profile: std::option::Option<crate::model::InstanceProfile>,
}
impl DeviceInstance {
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the device.</p>
    pub fn device_arn(&self) -> std::option::Option<&str> {
        self.device_arn.as_deref()
    }
    /// <p>An array of strings that describe the device instance.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>The status of the device instance. Valid values are listed here.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::InstanceStatus> {
        self.status.as_ref()
    }
    /// <p>Unique device identifier for the device instance.</p>
    pub fn udid(&self) -> std::option::Option<&str> {
        self.udid.as_deref()
    }
    /// <p>A object that contains information about the instance profile.</p>
    pub fn instance_profile(&self) -> std::option::Option<&crate::model::InstanceProfile> {
        self.instance_profile.as_ref()
    }
}
impl std::fmt::Debug for DeviceInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceInstance");
        formatter.field("arn", &self.arn);
        formatter.field("device_arn", &self.device_arn);
        formatter.field("labels", &self.labels);
        formatter.field("status", &self.status);
        formatter.field("udid", &self.udid);
        formatter.field("instance_profile", &self.instance_profile);
        formatter.finish()
    }
}
/// See [`DeviceInstance`](crate::model::DeviceInstance)
pub mod device_instance {
    /// A builder for [`DeviceInstance`](crate::model::DeviceInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) device_arn: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::InstanceStatus>,
        pub(crate) udid: std::option::Option<std::string::String>,
        pub(crate) instance_profile: std::option::Option<crate::model::InstanceProfile>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the device.</p>
        pub fn device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_arn = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>An array of strings that describe the device instance.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>An array of strings that describe the device instance.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>The status of the device instance. Valid values are listed here.</p>
        pub fn status(mut self, input: crate::model::InstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the device instance. Valid values are listed here.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Unique device identifier for the device instance.</p>
        pub fn udid(mut self, input: impl Into<std::string::String>) -> Self {
            self.udid = Some(input.into());
            self
        }
        /// <p>Unique device identifier for the device instance.</p>
        pub fn set_udid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.udid = input;
            self
        }
        /// <p>A object that contains information about the instance profile.</p>
        pub fn instance_profile(mut self, input: crate::model::InstanceProfile) -> Self {
            self.instance_profile = Some(input);
            self
        }
        /// <p>A object that contains information about the instance profile.</p>
        pub fn set_instance_profile(
            mut self,
            input: std::option::Option<crate::model::InstanceProfile>,
        ) -> Self {
            self.instance_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceInstance`](crate::model::DeviceInstance)
        pub fn build(self) -> crate::model::DeviceInstance {
            crate::model::DeviceInstance {
                arn: self.arn,
                device_arn: self.device_arn,
                labels: self.labels,
                status: self.status,
                udid: self.udid,
                instance_profile: self.instance_profile,
            }
        }
    }
}
impl DeviceInstance {
    /// Creates a new builder-style object to manufacture [`DeviceInstance`](crate::model::DeviceInstance)
    pub fn builder() -> crate::model::device_instance::Builder {
        crate::model::device_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    InUse,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => InstanceStatus::Available,
            "IN_USE" => InstanceStatus::InUse,
            "NOT_AVAILABLE" => InstanceStatus::NotAvailable,
            "PREPARING" => InstanceStatus::Preparing,
            other => InstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStatus::from(s))
    }
}
impl InstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStatus::Available => "AVAILABLE",
            InstanceStatus::InUse => "IN_USE",
            InstanceStatus::NotAvailable => "NOT_AVAILABLE",
            InstanceStatus::Preparing => "PREPARING",
            InstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "IN_USE", "NOT_AVAILABLE", "PREPARING"]
    }
}
impl AsRef<str> for InstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The metadata that you apply to a resource to help you categorize and organize it. Each tag consists of a
/// key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
/// characters. Tag values can have a maximum length of 256 characters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a
    /// category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor in a
    /// tag category (key).</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a
    /// category for more specific tag values.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor in a
    /// tag category (key).</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a
        /// category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a
        /// category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor in a
        /// tag category (key).</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor in a
        /// tag category (key).</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Represents a test run on a set of devices with a given app package, test parameters, and so
/// on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Run {
    /// <p>The run's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The run's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The run's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER</p>
    /// <note>
    /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
    /// screenshots at the same time.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TestType>,
    /// <p>The run's platform.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ANDROID</p>
    /// </li>
    /// <li>
    /// <p>IOS</p>
    /// </li>
    /// </ul>
    pub platform: std::option::Option<crate::model::DevicePlatform>,
    /// <p>When the run was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The run's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The run's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub result: std::option::Option<crate::model::ExecutionResult>,
    /// <p>The run's start time.</p>
    pub started: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The run's stop time.</p>
    pub stopped: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The run's result counters.</p>
    pub counters: std::option::Option<crate::model::Counters>,
    /// <p>A message about the run's result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The total number of jobs for the run.</p>
    pub total_jobs: std::option::Option<i32>,
    /// <p>The total number of completed jobs.</p>
    pub completed_jobs: std::option::Option<i32>,
    /// <p>Specifies the billing method for a test run: <code>metered</code> or
    /// <code>unmetered</code>. If the parameter is not specified, the default value is
    /// <code>metered</code>.</p>
    /// <note>
    /// <p>If you have unmetered device slots, you must set this to <code>unmetered</code> to use them.
    /// Otherwise, the run is counted toward metered device minutes.</p>
    /// </note>
    pub billing_method: std::option::Option<crate::model::BillingMethod>,
    /// <p>Represents the total (metered or unmetered) minutes used by the test run.</p>
    pub device_minutes: std::option::Option<crate::model::DeviceMinutes>,
    /// <p>The network profile being used for a test run.</p>
    pub network_profile: std::option::Option<crate::model::NetworkProfile>,
    /// <p>Read-only URL for an object in an S3 bucket where you can get the parsing results of the test package.
    /// If the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points
    /// to.</p>
    pub parsing_result_url: std::option::Option<std::string::String>,
    /// <p>Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
    /// <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.</p>
    pub result_code: std::option::Option<crate::model::ExecutionResultCode>,
    /// <p>For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same
    /// seed value between tests ensures identical event sequences.</p>
    pub seed: std::option::Option<i32>,
    /// <p>An app to upload or that has been uploaded.</p>
    pub app_upload: std::option::Option<std::string::String>,
    /// <p>For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz
    /// test should perform.</p>
    pub event_count: std::option::Option<i32>,
    /// <p>The number of minutes the job executes before it times out.</p>
    pub job_timeout_minutes: std::option::Option<i32>,
    /// <p>The ARN of the device pool for the run.</p>
    pub device_pool_arn: std::option::Option<std::string::String>,
    /// <p>Information about the locale that is used for the run.</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>Information about the radio states for the run.</p>
    pub radios: std::option::Option<crate::model::Radios>,
    /// <p>Information about the location that is used for the run.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>Output <code>CustomerArtifactPaths</code> object for the test run.</p>
    pub customer_artifact_paths: std::option::Option<crate::model::CustomerArtifactPaths>,
    /// <p>The Device Farm console URL for the recording of the run.</p>
    pub web_url: std::option::Option<std::string::String>,
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub skip_app_resign: std::option::Option<bool>,
    /// <p>The ARN of the YAML-formatted test specification for the run.</p>
    pub test_spec_arn: std::option::Option<std::string::String>,
    /// <p>The results of a device filter used to select the devices for a test run.</p>
    pub device_selection_result: std::option::Option<crate::model::DeviceSelectionResult>,
}
impl Run {
    /// <p>The run's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The run's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The run's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER</p>
    /// <note>
    /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
    /// screenshots at the same time.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestType> {
        self.r#type.as_ref()
    }
    /// <p>The run's platform.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ANDROID</p>
    /// </li>
    /// <li>
    /// <p>IOS</p>
    /// </li>
    /// </ul>
    pub fn platform(&self) -> std::option::Option<&crate::model::DevicePlatform> {
        self.platform.as_ref()
    }
    /// <p>When the run was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The run's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The run's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub fn result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.result.as_ref()
    }
    /// <p>The run's start time.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started.as_ref()
    }
    /// <p>The run's stop time.</p>
    pub fn stopped(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stopped.as_ref()
    }
    /// <p>The run's result counters.</p>
    pub fn counters(&self) -> std::option::Option<&crate::model::Counters> {
        self.counters.as_ref()
    }
    /// <p>A message about the run's result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The total number of jobs for the run.</p>
    pub fn total_jobs(&self) -> std::option::Option<i32> {
        self.total_jobs
    }
    /// <p>The total number of completed jobs.</p>
    pub fn completed_jobs(&self) -> std::option::Option<i32> {
        self.completed_jobs
    }
    /// <p>Specifies the billing method for a test run: <code>metered</code> or
    /// <code>unmetered</code>. If the parameter is not specified, the default value is
    /// <code>metered</code>.</p>
    /// <note>
    /// <p>If you have unmetered device slots, you must set this to <code>unmetered</code> to use them.
    /// Otherwise, the run is counted toward metered device minutes.</p>
    /// </note>
    pub fn billing_method(&self) -> std::option::Option<&crate::model::BillingMethod> {
        self.billing_method.as_ref()
    }
    /// <p>Represents the total (metered or unmetered) minutes used by the test run.</p>
    pub fn device_minutes(&self) -> std::option::Option<&crate::model::DeviceMinutes> {
        self.device_minutes.as_ref()
    }
    /// <p>The network profile being used for a test run.</p>
    pub fn network_profile(&self) -> std::option::Option<&crate::model::NetworkProfile> {
        self.network_profile.as_ref()
    }
    /// <p>Read-only URL for an object in an S3 bucket where you can get the parsing results of the test package.
    /// If the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points
    /// to.</p>
    pub fn parsing_result_url(&self) -> std::option::Option<&str> {
        self.parsing_result_url.as_deref()
    }
    /// <p>Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
    /// <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.</p>
    pub fn result_code(&self) -> std::option::Option<&crate::model::ExecutionResultCode> {
        self.result_code.as_ref()
    }
    /// <p>For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same
    /// seed value between tests ensures identical event sequences.</p>
    pub fn seed(&self) -> std::option::Option<i32> {
        self.seed
    }
    /// <p>An app to upload or that has been uploaded.</p>
    pub fn app_upload(&self) -> std::option::Option<&str> {
        self.app_upload.as_deref()
    }
    /// <p>For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz
    /// test should perform.</p>
    pub fn event_count(&self) -> std::option::Option<i32> {
        self.event_count
    }
    /// <p>The number of minutes the job executes before it times out.</p>
    pub fn job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.job_timeout_minutes
    }
    /// <p>The ARN of the device pool for the run.</p>
    pub fn device_pool_arn(&self) -> std::option::Option<&str> {
        self.device_pool_arn.as_deref()
    }
    /// <p>Information about the locale that is used for the run.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
    /// <p>Information about the radio states for the run.</p>
    pub fn radios(&self) -> std::option::Option<&crate::model::Radios> {
        self.radios.as_ref()
    }
    /// <p>Information about the location that is used for the run.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>Output <code>CustomerArtifactPaths</code> object for the test run.</p>
    pub fn customer_artifact_paths(
        &self,
    ) -> std::option::Option<&crate::model::CustomerArtifactPaths> {
        self.customer_artifact_paths.as_ref()
    }
    /// <p>The Device Farm console URL for the recording of the run.</p>
    pub fn web_url(&self) -> std::option::Option<&str> {
        self.web_url.as_deref()
    }
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub fn skip_app_resign(&self) -> std::option::Option<bool> {
        self.skip_app_resign
    }
    /// <p>The ARN of the YAML-formatted test specification for the run.</p>
    pub fn test_spec_arn(&self) -> std::option::Option<&str> {
        self.test_spec_arn.as_deref()
    }
    /// <p>The results of a device filter used to select the devices for a test run.</p>
    pub fn device_selection_result(
        &self,
    ) -> std::option::Option<&crate::model::DeviceSelectionResult> {
        self.device_selection_result.as_ref()
    }
}
impl std::fmt::Debug for Run {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Run");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("platform", &self.platform);
        formatter.field("created", &self.created);
        formatter.field("status", &self.status);
        formatter.field("result", &self.result);
        formatter.field("started", &self.started);
        formatter.field("stopped", &self.stopped);
        formatter.field("counters", &self.counters);
        formatter.field("message", &self.message);
        formatter.field("total_jobs", &self.total_jobs);
        formatter.field("completed_jobs", &self.completed_jobs);
        formatter.field("billing_method", &self.billing_method);
        formatter.field("device_minutes", &self.device_minutes);
        formatter.field("network_profile", &self.network_profile);
        formatter.field("parsing_result_url", &self.parsing_result_url);
        formatter.field("result_code", &self.result_code);
        formatter.field("seed", &self.seed);
        formatter.field("app_upload", &self.app_upload);
        formatter.field("event_count", &self.event_count);
        formatter.field("job_timeout_minutes", &self.job_timeout_minutes);
        formatter.field("device_pool_arn", &self.device_pool_arn);
        formatter.field("locale", &self.locale);
        formatter.field("radios", &self.radios);
        formatter.field("location", &self.location);
        formatter.field("customer_artifact_paths", &self.customer_artifact_paths);
        formatter.field("web_url", &self.web_url);
        formatter.field("skip_app_resign", &self.skip_app_resign);
        formatter.field("test_spec_arn", &self.test_spec_arn);
        formatter.field("device_selection_result", &self.device_selection_result);
        formatter.finish()
    }
}
/// See [`Run`](crate::model::Run)
pub mod run {
    /// A builder for [`Run`](crate::model::Run)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TestType>,
        pub(crate) platform: std::option::Option<crate::model::DevicePlatform>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) started: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) counters: std::option::Option<crate::model::Counters>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) total_jobs: std::option::Option<i32>,
        pub(crate) completed_jobs: std::option::Option<i32>,
        pub(crate) billing_method: std::option::Option<crate::model::BillingMethod>,
        pub(crate) device_minutes: std::option::Option<crate::model::DeviceMinutes>,
        pub(crate) network_profile: std::option::Option<crate::model::NetworkProfile>,
        pub(crate) parsing_result_url: std::option::Option<std::string::String>,
        pub(crate) result_code: std::option::Option<crate::model::ExecutionResultCode>,
        pub(crate) seed: std::option::Option<i32>,
        pub(crate) app_upload: std::option::Option<std::string::String>,
        pub(crate) event_count: std::option::Option<i32>,
        pub(crate) job_timeout_minutes: std::option::Option<i32>,
        pub(crate) device_pool_arn: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) radios: std::option::Option<crate::model::Radios>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) customer_artifact_paths:
            std::option::Option<crate::model::CustomerArtifactPaths>,
        pub(crate) web_url: std::option::Option<std::string::String>,
        pub(crate) skip_app_resign: std::option::Option<bool>,
        pub(crate) test_spec_arn: std::option::Option<std::string::String>,
        pub(crate) device_selection_result:
            std::option::Option<crate::model::DeviceSelectionResult>,
    }
    impl Builder {
        /// <p>The run's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The run's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The run's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The run's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The run's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER</p>
        /// <note>
        /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
        /// screenshots at the same time.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The run's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER</p>
        /// <note>
        /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
        /// screenshots at the same time.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The run's platform.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID</p>
        /// </li>
        /// <li>
        /// <p>IOS</p>
        /// </li>
        /// </ul>
        pub fn platform(mut self, input: crate::model::DevicePlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The run's platform.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID</p>
        /// </li>
        /// <li>
        /// <p>IOS</p>
        /// </li>
        /// </ul>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::DevicePlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>When the run was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the run was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The run's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The run's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The run's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The run's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>The run's start time.</p>
        pub fn started(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The run's start time.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The run's stop time.</p>
        pub fn stopped(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The run's stop time.</p>
        pub fn set_stopped(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The run's result counters.</p>
        pub fn counters(mut self, input: crate::model::Counters) -> Self {
            self.counters = Some(input);
            self
        }
        /// <p>The run's result counters.</p>
        pub fn set_counters(mut self, input: std::option::Option<crate::model::Counters>) -> Self {
            self.counters = input;
            self
        }
        /// <p>A message about the run's result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the run's result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The total number of jobs for the run.</p>
        pub fn total_jobs(mut self, input: i32) -> Self {
            self.total_jobs = Some(input);
            self
        }
        /// <p>The total number of jobs for the run.</p>
        pub fn set_total_jobs(mut self, input: std::option::Option<i32>) -> Self {
            self.total_jobs = input;
            self
        }
        /// <p>The total number of completed jobs.</p>
        pub fn completed_jobs(mut self, input: i32) -> Self {
            self.completed_jobs = Some(input);
            self
        }
        /// <p>The total number of completed jobs.</p>
        pub fn set_completed_jobs(mut self, input: std::option::Option<i32>) -> Self {
            self.completed_jobs = input;
            self
        }
        /// <p>Specifies the billing method for a test run: <code>metered</code> or
        /// <code>unmetered</code>. If the parameter is not specified, the default value is
        /// <code>metered</code>.</p>
        /// <note>
        /// <p>If you have unmetered device slots, you must set this to <code>unmetered</code> to use them.
        /// Otherwise, the run is counted toward metered device minutes.</p>
        /// </note>
        pub fn billing_method(mut self, input: crate::model::BillingMethod) -> Self {
            self.billing_method = Some(input);
            self
        }
        /// <p>Specifies the billing method for a test run: <code>metered</code> or
        /// <code>unmetered</code>. If the parameter is not specified, the default value is
        /// <code>metered</code>.</p>
        /// <note>
        /// <p>If you have unmetered device slots, you must set this to <code>unmetered</code> to use them.
        /// Otherwise, the run is counted toward metered device minutes.</p>
        /// </note>
        pub fn set_billing_method(
            mut self,
            input: std::option::Option<crate::model::BillingMethod>,
        ) -> Self {
            self.billing_method = input;
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the test run.</p>
        pub fn device_minutes(mut self, input: crate::model::DeviceMinutes) -> Self {
            self.device_minutes = Some(input);
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the test run.</p>
        pub fn set_device_minutes(
            mut self,
            input: std::option::Option<crate::model::DeviceMinutes>,
        ) -> Self {
            self.device_minutes = input;
            self
        }
        /// <p>The network profile being used for a test run.</p>
        pub fn network_profile(mut self, input: crate::model::NetworkProfile) -> Self {
            self.network_profile = Some(input);
            self
        }
        /// <p>The network profile being used for a test run.</p>
        pub fn set_network_profile(
            mut self,
            input: std::option::Option<crate::model::NetworkProfile>,
        ) -> Self {
            self.network_profile = input;
            self
        }
        /// <p>Read-only URL for an object in an S3 bucket where you can get the parsing results of the test package.
        /// If the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points
        /// to.</p>
        pub fn parsing_result_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.parsing_result_url = Some(input.into());
            self
        }
        /// <p>Read-only URL for an object in an S3 bucket where you can get the parsing results of the test package.
        /// If the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points
        /// to.</p>
        pub fn set_parsing_result_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parsing_result_url = input;
            self
        }
        /// <p>Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
        /// <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.</p>
        pub fn result_code(mut self, input: crate::model::ExecutionResultCode) -> Self {
            self.result_code = Some(input);
            self
        }
        /// <p>Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
        /// <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.</p>
        pub fn set_result_code(
            mut self,
            input: std::option::Option<crate::model::ExecutionResultCode>,
        ) -> Self {
            self.result_code = input;
            self
        }
        /// <p>For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same
        /// seed value between tests ensures identical event sequences.</p>
        pub fn seed(mut self, input: i32) -> Self {
            self.seed = Some(input);
            self
        }
        /// <p>For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same
        /// seed value between tests ensures identical event sequences.</p>
        pub fn set_seed(mut self, input: std::option::Option<i32>) -> Self {
            self.seed = input;
            self
        }
        /// <p>An app to upload or that has been uploaded.</p>
        pub fn app_upload(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_upload = Some(input.into());
            self
        }
        /// <p>An app to upload or that has been uploaded.</p>
        pub fn set_app_upload(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_upload = input;
            self
        }
        /// <p>For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz
        /// test should perform.</p>
        pub fn event_count(mut self, input: i32) -> Self {
            self.event_count = Some(input);
            self
        }
        /// <p>For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz
        /// test should perform.</p>
        pub fn set_event_count(mut self, input: std::option::Option<i32>) -> Self {
            self.event_count = input;
            self
        }
        /// <p>The number of minutes the job executes before it times out.</p>
        pub fn job_timeout_minutes(mut self, input: i32) -> Self {
            self.job_timeout_minutes = Some(input);
            self
        }
        /// <p>The number of minutes the job executes before it times out.</p>
        pub fn set_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.job_timeout_minutes = input;
            self
        }
        /// <p>The ARN of the device pool for the run.</p>
        pub fn device_pool_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_pool_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device pool for the run.</p>
        pub fn set_device_pool_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_pool_arn = input;
            self
        }
        /// <p>Information about the locale that is used for the run.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>Information about the locale that is used for the run.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Information about the radio states for the run.</p>
        pub fn radios(mut self, input: crate::model::Radios) -> Self {
            self.radios = Some(input);
            self
        }
        /// <p>Information about the radio states for the run.</p>
        pub fn set_radios(mut self, input: std::option::Option<crate::model::Radios>) -> Self {
            self.radios = input;
            self
        }
        /// <p>Information about the location that is used for the run.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Information about the location that is used for the run.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>Output <code>CustomerArtifactPaths</code> object for the test run.</p>
        pub fn customer_artifact_paths(
            mut self,
            input: crate::model::CustomerArtifactPaths,
        ) -> Self {
            self.customer_artifact_paths = Some(input);
            self
        }
        /// <p>Output <code>CustomerArtifactPaths</code> object for the test run.</p>
        pub fn set_customer_artifact_paths(
            mut self,
            input: std::option::Option<crate::model::CustomerArtifactPaths>,
        ) -> Self {
            self.customer_artifact_paths = input;
            self
        }
        /// <p>The Device Farm console URL for the recording of the run.</p>
        pub fn web_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_url = Some(input.into());
            self
        }
        /// <p>The Device Farm console URL for the recording of the run.</p>
        pub fn set_web_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_url = input;
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn skip_app_resign(mut self, input: bool) -> Self {
            self.skip_app_resign = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn set_skip_app_resign(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_app_resign = input;
            self
        }
        /// <p>The ARN of the YAML-formatted test specification for the run.</p>
        pub fn test_spec_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_spec_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the YAML-formatted test specification for the run.</p>
        pub fn set_test_spec_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_spec_arn = input;
            self
        }
        /// <p>The results of a device filter used to select the devices for a test run.</p>
        pub fn device_selection_result(
            mut self,
            input: crate::model::DeviceSelectionResult,
        ) -> Self {
            self.device_selection_result = Some(input);
            self
        }
        /// <p>The results of a device filter used to select the devices for a test run.</p>
        pub fn set_device_selection_result(
            mut self,
            input: std::option::Option<crate::model::DeviceSelectionResult>,
        ) -> Self {
            self.device_selection_result = input;
            self
        }
        /// Consumes the builder and constructs a [`Run`](crate::model::Run)
        pub fn build(self) -> crate::model::Run {
            crate::model::Run {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                platform: self.platform,
                created: self.created,
                status: self.status,
                result: self.result,
                started: self.started,
                stopped: self.stopped,
                counters: self.counters,
                message: self.message,
                total_jobs: self.total_jobs,
                completed_jobs: self.completed_jobs,
                billing_method: self.billing_method,
                device_minutes: self.device_minutes,
                network_profile: self.network_profile,
                parsing_result_url: self.parsing_result_url,
                result_code: self.result_code,
                seed: self.seed,
                app_upload: self.app_upload,
                event_count: self.event_count,
                job_timeout_minutes: self.job_timeout_minutes,
                device_pool_arn: self.device_pool_arn,
                locale: self.locale,
                radios: self.radios,
                location: self.location,
                customer_artifact_paths: self.customer_artifact_paths,
                web_url: self.web_url,
                skip_app_resign: self.skip_app_resign,
                test_spec_arn: self.test_spec_arn,
                device_selection_result: self.device_selection_result,
            }
        }
    }
}
impl Run {
    /// Creates a new builder-style object to manufacture [`Run`](crate::model::Run)
    pub fn builder() -> crate::model::run::Builder {
        crate::model::run::Builder::default()
    }
}

/// <p>Contains the run results requested by the device selection configuration and how many devices were
/// returned. For an example of the JSON response syntax, see <a>ScheduleRun</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceSelectionResult {
    /// <p>The filters in a device selection result.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
    /// <p>The number of devices that matched the device filter selection criteria.</p>
    pub matched_devices_count: std::option::Option<i32>,
    /// <p>The maximum number of devices to be selected by a device filter and included in a test
    /// run.</p>
    pub max_devices: std::option::Option<i32>,
}
impl DeviceSelectionResult {
    /// <p>The filters in a device selection result.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::DeviceFilter]> {
        self.filters.as_deref()
    }
    /// <p>The number of devices that matched the device filter selection criteria.</p>
    pub fn matched_devices_count(&self) -> std::option::Option<i32> {
        self.matched_devices_count
    }
    /// <p>The maximum number of devices to be selected by a device filter and included in a test
    /// run.</p>
    pub fn max_devices(&self) -> std::option::Option<i32> {
        self.max_devices
    }
}
impl std::fmt::Debug for DeviceSelectionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceSelectionResult");
        formatter.field("filters", &self.filters);
        formatter.field("matched_devices_count", &self.matched_devices_count);
        formatter.field("max_devices", &self.max_devices);
        formatter.finish()
    }
}
/// See [`DeviceSelectionResult`](crate::model::DeviceSelectionResult)
pub mod device_selection_result {
    /// A builder for [`DeviceSelectionResult`](crate::model::DeviceSelectionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
        pub(crate) matched_devices_count: std::option::Option<i32>,
        pub(crate) max_devices: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters in a device selection result.</p>
        pub fn filters(mut self, input: impl Into<crate::model::DeviceFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters in a device selection result.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The number of devices that matched the device filter selection criteria.</p>
        pub fn matched_devices_count(mut self, input: i32) -> Self {
            self.matched_devices_count = Some(input);
            self
        }
        /// <p>The number of devices that matched the device filter selection criteria.</p>
        pub fn set_matched_devices_count(mut self, input: std::option::Option<i32>) -> Self {
            self.matched_devices_count = input;
            self
        }
        /// <p>The maximum number of devices to be selected by a device filter and included in a test
        /// run.</p>
        pub fn max_devices(mut self, input: i32) -> Self {
            self.max_devices = Some(input);
            self
        }
        /// <p>The maximum number of devices to be selected by a device filter and included in a test
        /// run.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.max_devices = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceSelectionResult`](crate::model::DeviceSelectionResult)
        pub fn build(self) -> crate::model::DeviceSelectionResult {
            crate::model::DeviceSelectionResult {
                filters: self.filters,
                matched_devices_count: self.matched_devices_count,
                max_devices: self.max_devices,
            }
        }
    }
}
impl DeviceSelectionResult {
    /// Creates a new builder-style object to manufacture [`DeviceSelectionResult`](crate::model::DeviceSelectionResult)
    pub fn builder() -> crate::model::device_selection_result::Builder {
        crate::model::device_selection_result::Builder::default()
    }
}

/// <p>Represents a device filter used to select a set of devices to be included in a test
/// run. This data structure is passed in as the <code>deviceSelectionConfiguration</code>
/// parameter to <code>ScheduleRun</code>. For an example of the JSON request syntax, see
/// <a>ScheduleRun</a>.</p>
/// <p>It is also passed in as the <code>filters</code> parameter to
/// <code>ListDevices</code>. For an example of the JSON request syntax, see <a>ListDevices</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceFilter {
    /// <p>The aspect of a device such as platform or model used as the selection criteria in a
    /// device filter.</p>
    /// <p>The supported operators for each attribute are provided in the following list.</p>
    /// <dl>
    /// <dt>ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device (for example,
    /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>PLATFORM</dt>
    /// <dd>
    /// <p>The device platform. Valid values are ANDROID or IOS.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>OS_VERSION</dt>
    /// <dd>
    /// <p>The operating system version (for example, 10.3.2).</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>,
    /// <code>GREATER_THAN_OR_EQUALS</code>, <code>IN</code>,
    /// <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>MODEL</dt>
    /// <dd>
    /// <p>The device model (for example, iPad 5th Gen).</p>
    /// <p>Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>AVAILABILITY</dt>
    /// <dd>
    /// <p>The current availability of the device. Valid values are AVAILABLE,
    /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>FORM_FACTOR</dt>
    /// <dd>
    /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>MANUFACTURER</dt>
    /// <dd>
    /// <p>The device manufacturer (for example, Apple).</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_ACCESS_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote access. Valid values are TRUE or
    /// FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_DEBUG_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
    /// supported</a>, this filter is ignored.</p>
    /// </dd>
    /// <dt>INSTANCE_ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>INSTANCE_LABELS</dt>
    /// <dd>
    /// <p>The label of the device instance.</p>
    /// <p>Supported operators: <code>CONTAINS</code>
    /// </p>
    /// </dd>
    /// <dt>FLEET_TYPE</dt>
    /// <dd>
    /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// </dl>
    pub attribute: std::option::Option<crate::model::DeviceFilterAttribute>,
    /// <p>Specifies how Device Farm compares the filter's attribute to the value. See the attribute
    /// descriptions.</p>
    pub operator: std::option::Option<crate::model::RuleOperator>,
    /// <p>An array of one or more filter values used in a device filter.</p>
    /// <p class="title">
    /// <b>Operator Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The IN and NOT_IN operators can take a values array that has more than one
    /// element.</p>
    /// </li>
    /// <li>
    /// <p>The other operators require an array with a single element.</p>
    /// </li>
    /// </ul>
    /// <p class="title">
    /// <b>Attribute Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
    /// </li>
    /// <li>
    /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
    /// TEMPORARY_NOT_AVAILABLE.</p>
    /// </li>
    /// <li>
    /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
    /// </li>
    /// <li>
    /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeviceFilter {
    /// <p>The aspect of a device such as platform or model used as the selection criteria in a
    /// device filter.</p>
    /// <p>The supported operators for each attribute are provided in the following list.</p>
    /// <dl>
    /// <dt>ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device (for example,
    /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>PLATFORM</dt>
    /// <dd>
    /// <p>The device platform. Valid values are ANDROID or IOS.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>OS_VERSION</dt>
    /// <dd>
    /// <p>The operating system version (for example, 10.3.2).</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>,
    /// <code>GREATER_THAN_OR_EQUALS</code>, <code>IN</code>,
    /// <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>MODEL</dt>
    /// <dd>
    /// <p>The device model (for example, iPad 5th Gen).</p>
    /// <p>Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>,
    /// <code>IN</code>, <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>AVAILABILITY</dt>
    /// <dd>
    /// <p>The current availability of the device. Valid values are AVAILABLE,
    /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>FORM_FACTOR</dt>
    /// <dd>
    /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>MANUFACTURER</dt>
    /// <dd>
    /// <p>The device manufacturer (for example, Apple).</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_ACCESS_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote access. Valid values are TRUE or
    /// FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// <dt>REMOTE_DEBUG_ENABLED</dt>
    /// <dd>
    /// <p>Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
    /// supported</a>, this filter is ignored.</p>
    /// </dd>
    /// <dt>INSTANCE_ARN</dt>
    /// <dd>
    /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
    /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
    /// <code>NOT_IN</code>
    /// </p>
    /// </dd>
    /// <dt>INSTANCE_LABELS</dt>
    /// <dd>
    /// <p>The label of the device instance.</p>
    /// <p>Supported operators: <code>CONTAINS</code>
    /// </p>
    /// </dd>
    /// <dt>FLEET_TYPE</dt>
    /// <dd>
    /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
    /// <p>Supported operators: <code>EQUALS</code>
    /// </p>
    /// </dd>
    /// </dl>
    pub fn attribute(&self) -> std::option::Option<&crate::model::DeviceFilterAttribute> {
        self.attribute.as_ref()
    }
    /// <p>Specifies how Device Farm compares the filter's attribute to the value. See the attribute
    /// descriptions.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::RuleOperator> {
        self.operator.as_ref()
    }
    /// <p>An array of one or more filter values used in a device filter.</p>
    /// <p class="title">
    /// <b>Operator Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The IN and NOT_IN operators can take a values array that has more than one
    /// element.</p>
    /// </li>
    /// <li>
    /// <p>The other operators require an array with a single element.</p>
    /// </li>
    /// </ul>
    /// <p class="title">
    /// <b>Attribute Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
    /// </li>
    /// <li>
    /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
    /// TEMPORARY_NOT_AVAILABLE.</p>
    /// </li>
    /// <li>
    /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
    /// </li>
    /// <li>
    /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
    /// </li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for DeviceFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceFilter");
        formatter.field("attribute", &self.attribute);
        formatter.field("operator", &self.operator);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`DeviceFilter`](crate::model::DeviceFilter)
pub mod device_filter {
    /// A builder for [`DeviceFilter`](crate::model::DeviceFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::DeviceFilterAttribute>,
        pub(crate) operator: std::option::Option<crate::model::RuleOperator>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The aspect of a device such as platform or model used as the selection criteria in a
        /// device filter.</p>
        /// <p>The supported operators for each attribute are provided in the following list.</p>
        /// <dl>
        /// <dt>ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>PLATFORM</dt>
        /// <dd>
        /// <p>The device platform. Valid values are ANDROID or IOS.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>OS_VERSION</dt>
        /// <dd>
        /// <p>The operating system version (for example, 10.3.2).</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>,
        /// <code>GREATER_THAN_OR_EQUALS</code>, <code>IN</code>,
        /// <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>MODEL</dt>
        /// <dd>
        /// <p>The device model (for example, iPad 5th Gen).</p>
        /// <p>Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>AVAILABILITY</dt>
        /// <dd>
        /// <p>The current availability of the device. Valid values are AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>FORM_FACTOR</dt>
        /// <dd>
        /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>MANUFACTURER</dt>
        /// <dd>
        /// <p>The device manufacturer (for example, Apple).</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_ACCESS_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote access. Valid values are TRUE or
        /// FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_DEBUG_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
        /// supported</a>, this filter is ignored.</p>
        /// </dd>
        /// <dt>INSTANCE_ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>INSTANCE_LABELS</dt>
        /// <dd>
        /// <p>The label of the device instance.</p>
        /// <p>Supported operators: <code>CONTAINS</code>
        /// </p>
        /// </dd>
        /// <dt>FLEET_TYPE</dt>
        /// <dd>
        /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// </dl>
        pub fn attribute(mut self, input: crate::model::DeviceFilterAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The aspect of a device such as platform or model used as the selection criteria in a
        /// device filter.</p>
        /// <p>The supported operators for each attribute are provided in the following list.</p>
        /// <dl>
        /// <dt>ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>PLATFORM</dt>
        /// <dd>
        /// <p>The device platform. Valid values are ANDROID or IOS.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>OS_VERSION</dt>
        /// <dd>
        /// <p>The operating system version (for example, 10.3.2).</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>,
        /// <code>GREATER_THAN_OR_EQUALS</code>, <code>IN</code>,
        /// <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>MODEL</dt>
        /// <dd>
        /// <p>The device model (for example, iPad 5th Gen).</p>
        /// <p>Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>,
        /// <code>IN</code>, <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>AVAILABILITY</dt>
        /// <dd>
        /// <p>The current availability of the device. Valid values are AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>FORM_FACTOR</dt>
        /// <dd>
        /// <p>The device form factor. Valid values are PHONE or TABLET.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>MANUFACTURER</dt>
        /// <dd>
        /// <p>The device manufacturer (for example, Apple).</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_ACCESS_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote access. Valid values are TRUE or
        /// FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// <dt>REMOTE_DEBUG_ENABLED</dt>
        /// <dd>
        /// <p>Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// <p>Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
        /// supported</a>, this filter is ignored.</p>
        /// </dd>
        /// <dt>INSTANCE_ARN</dt>
        /// <dd>
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        /// <p>Supported operators: <code>EQUALS</code>, <code>IN</code>,
        /// <code>NOT_IN</code>
        /// </p>
        /// </dd>
        /// <dt>INSTANCE_LABELS</dt>
        /// <dd>
        /// <p>The label of the device instance.</p>
        /// <p>Supported operators: <code>CONTAINS</code>
        /// </p>
        /// </dd>
        /// <dt>FLEET_TYPE</dt>
        /// <dd>
        /// <p>The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// <p>Supported operators: <code>EQUALS</code>
        /// </p>
        /// </dd>
        /// </dl>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::DeviceFilterAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>Specifies how Device Farm compares the filter's attribute to the value. See the attribute
        /// descriptions.</p>
        pub fn operator(mut self, input: crate::model::RuleOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>Specifies how Device Farm compares the filter's attribute to the value. See the attribute
        /// descriptions.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::RuleOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array of one or more filter values used in a device filter.</p>
        /// <p class="title">
        /// <b>Operator Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The IN and NOT_IN operators can take a values array that has more than one
        /// element.</p>
        /// </li>
        /// <li>
        /// <p>The other operators require an array with a single element.</p>
        /// </li>
        /// </ul>
        /// <p class="title">
        /// <b>Attribute Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
        /// </li>
        /// <li>
        /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
        /// TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
        /// </li>
        /// <li>
        /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array of one or more filter values used in a device filter.</p>
        /// <p class="title">
        /// <b>Operator Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The IN and NOT_IN operators can take a values array that has more than one
        /// element.</p>
        /// </li>
        /// <li>
        /// <p>The other operators require an array with a single element.</p>
        /// </li>
        /// </ul>
        /// <p class="title">
        /// <b>Attribute Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
        /// </li>
        /// <li>
        /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
        /// TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
        /// </li>
        /// <li>
        /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceFilter`](crate::model::DeviceFilter)
        pub fn build(self) -> crate::model::DeviceFilter {
            crate::model::DeviceFilter {
                attribute: self.attribute,
                operator: self.operator,
                values: self.values,
            }
        }
    }
}
impl DeviceFilter {
    /// Creates a new builder-style object to manufacture [`DeviceFilter`](crate::model::DeviceFilter)
    pub fn builder() -> crate::model::device_filter::Builder {
        crate::model::device_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceFilterAttribute {
    #[allow(missing_docs)] // documentation missing in model
    Arn,
    #[allow(missing_docs)] // documentation missing in model
    Availability,
    #[allow(missing_docs)] // documentation missing in model
    FleetType,
    #[allow(missing_docs)] // documentation missing in model
    FormFactor,
    #[allow(missing_docs)] // documentation missing in model
    InstanceArn,
    #[allow(missing_docs)] // documentation missing in model
    InstanceLabels,
    #[allow(missing_docs)] // documentation missing in model
    Manufacturer,
    #[allow(missing_docs)] // documentation missing in model
    Model,
    #[allow(missing_docs)] // documentation missing in model
    OsVersion,
    #[allow(missing_docs)] // documentation missing in model
    Platform,
    #[allow(missing_docs)] // documentation missing in model
    RemoteAccessEnabled,
    #[allow(missing_docs)] // documentation missing in model
    RemoteDebugEnabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceFilterAttribute {
    fn from(s: &str) -> Self {
        match s {
            "ARN" => DeviceFilterAttribute::Arn,
            "AVAILABILITY" => DeviceFilterAttribute::Availability,
            "FLEET_TYPE" => DeviceFilterAttribute::FleetType,
            "FORM_FACTOR" => DeviceFilterAttribute::FormFactor,
            "INSTANCE_ARN" => DeviceFilterAttribute::InstanceArn,
            "INSTANCE_LABELS" => DeviceFilterAttribute::InstanceLabels,
            "MANUFACTURER" => DeviceFilterAttribute::Manufacturer,
            "MODEL" => DeviceFilterAttribute::Model,
            "OS_VERSION" => DeviceFilterAttribute::OsVersion,
            "PLATFORM" => DeviceFilterAttribute::Platform,
            "REMOTE_ACCESS_ENABLED" => DeviceFilterAttribute::RemoteAccessEnabled,
            "REMOTE_DEBUG_ENABLED" => DeviceFilterAttribute::RemoteDebugEnabled,
            other => DeviceFilterAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceFilterAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceFilterAttribute::from(s))
    }
}
impl DeviceFilterAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceFilterAttribute::Arn => "ARN",
            DeviceFilterAttribute::Availability => "AVAILABILITY",
            DeviceFilterAttribute::FleetType => "FLEET_TYPE",
            DeviceFilterAttribute::FormFactor => "FORM_FACTOR",
            DeviceFilterAttribute::InstanceArn => "INSTANCE_ARN",
            DeviceFilterAttribute::InstanceLabels => "INSTANCE_LABELS",
            DeviceFilterAttribute::Manufacturer => "MANUFACTURER",
            DeviceFilterAttribute::Model => "MODEL",
            DeviceFilterAttribute::OsVersion => "OS_VERSION",
            DeviceFilterAttribute::Platform => "PLATFORM",
            DeviceFilterAttribute::RemoteAccessEnabled => "REMOTE_ACCESS_ENABLED",
            DeviceFilterAttribute::RemoteDebugEnabled => "REMOTE_DEBUG_ENABLED",
            DeviceFilterAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ARN",
            "AVAILABILITY",
            "FLEET_TYPE",
            "FORM_FACTOR",
            "INSTANCE_ARN",
            "INSTANCE_LABELS",
            "MANUFACTURER",
            "MODEL",
            "OS_VERSION",
            "PLATFORM",
            "REMOTE_ACCESS_ENABLED",
            "REMOTE_DEBUG_ENABLED",
        ]
    }
}
impl AsRef<str> for DeviceFilterAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A JSON object that specifies the paths where the artifacts generated by the customer's tests, on the
/// device or in the test environment, are pulled from.</p>
/// <p>Specify <code>deviceHostPaths</code> and optionally specify either
/// <code>iosPaths</code> or <code>androidPaths</code>.</p>
/// <p>For web app tests, you can specify both <code>iosPaths</code> and
/// <code>androidPaths</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerArtifactPaths {
    /// <p>Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
    /// are pulled from.</p>
    pub ios_paths: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Comma-separated list of paths on the Android device where the artifacts generated by the customer's
    /// tests are pulled from.</p>
    pub android_paths: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Comma-separated list of paths in the test execution environment where the artifacts generated by the
    /// customer's tests are pulled from.</p>
    pub device_host_paths: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CustomerArtifactPaths {
    /// <p>Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
    /// are pulled from.</p>
    pub fn ios_paths(&self) -> std::option::Option<&[std::string::String]> {
        self.ios_paths.as_deref()
    }
    /// <p>Comma-separated list of paths on the Android device where the artifacts generated by the customer's
    /// tests are pulled from.</p>
    pub fn android_paths(&self) -> std::option::Option<&[std::string::String]> {
        self.android_paths.as_deref()
    }
    /// <p>Comma-separated list of paths in the test execution environment where the artifacts generated by the
    /// customer's tests are pulled from.</p>
    pub fn device_host_paths(&self) -> std::option::Option<&[std::string::String]> {
        self.device_host_paths.as_deref()
    }
}
impl std::fmt::Debug for CustomerArtifactPaths {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerArtifactPaths");
        formatter.field("ios_paths", &self.ios_paths);
        formatter.field("android_paths", &self.android_paths);
        formatter.field("device_host_paths", &self.device_host_paths);
        formatter.finish()
    }
}
/// See [`CustomerArtifactPaths`](crate::model::CustomerArtifactPaths)
pub mod customer_artifact_paths {
    /// A builder for [`CustomerArtifactPaths`](crate::model::CustomerArtifactPaths)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ios_paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) android_paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) device_host_paths: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ios_paths`.
        ///
        /// To override the contents of this collection use [`set_ios_paths`](Self::set_ios_paths).
        ///
        /// <p>Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
        /// are pulled from.</p>
        pub fn ios_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ios_paths.unwrap_or_default();
            v.push(input.into());
            self.ios_paths = Some(v);
            self
        }
        /// <p>Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
        /// are pulled from.</p>
        pub fn set_ios_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ios_paths = input;
            self
        }
        /// Appends an item to `android_paths`.
        ///
        /// To override the contents of this collection use [`set_android_paths`](Self::set_android_paths).
        ///
        /// <p>Comma-separated list of paths on the Android device where the artifacts generated by the customer's
        /// tests are pulled from.</p>
        pub fn android_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.android_paths.unwrap_or_default();
            v.push(input.into());
            self.android_paths = Some(v);
            self
        }
        /// <p>Comma-separated list of paths on the Android device where the artifacts generated by the customer's
        /// tests are pulled from.</p>
        pub fn set_android_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.android_paths = input;
            self
        }
        /// Appends an item to `device_host_paths`.
        ///
        /// To override the contents of this collection use [`set_device_host_paths`](Self::set_device_host_paths).
        ///
        /// <p>Comma-separated list of paths in the test execution environment where the artifacts generated by the
        /// customer's tests are pulled from.</p>
        pub fn device_host_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_host_paths.unwrap_or_default();
            v.push(input.into());
            self.device_host_paths = Some(v);
            self
        }
        /// <p>Comma-separated list of paths in the test execution environment where the artifacts generated by the
        /// customer's tests are pulled from.</p>
        pub fn set_device_host_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_host_paths = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerArtifactPaths`](crate::model::CustomerArtifactPaths)
        pub fn build(self) -> crate::model::CustomerArtifactPaths {
            crate::model::CustomerArtifactPaths {
                ios_paths: self.ios_paths,
                android_paths: self.android_paths,
                device_host_paths: self.device_host_paths,
            }
        }
    }
}
impl CustomerArtifactPaths {
    /// Creates a new builder-style object to manufacture [`CustomerArtifactPaths`](crate::model::CustomerArtifactPaths)
    pub fn builder() -> crate::model::customer_artifact_paths::Builder {
        crate::model::customer_artifact_paths::Builder::default()
    }
}

/// <p>Represents a latitude and longitude pair, expressed in geographic coordinate system degrees (for
/// example, 47.6204, -122.3491).</p>
/// <p>Elevation is currently not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>The latitude.</p>
    pub latitude: std::option::Option<f64>,
    /// <p>The longitude.</p>
    pub longitude: std::option::Option<f64>,
}
impl Location {
    /// <p>The latitude.</p>
    pub fn latitude(&self) -> std::option::Option<f64> {
        self.latitude
    }
    /// <p>The longitude.</p>
    pub fn longitude(&self) -> std::option::Option<f64> {
        self.longitude
    }
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("latitude", &self.latitude);
        formatter.field("longitude", &self.longitude);
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) latitude: std::option::Option<f64>,
        pub(crate) longitude: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The latitude.</p>
        pub fn latitude(mut self, input: f64) -> Self {
            self.latitude = Some(input);
            self
        }
        /// <p>The latitude.</p>
        pub fn set_latitude(mut self, input: std::option::Option<f64>) -> Self {
            self.latitude = input;
            self
        }
        /// <p>The longitude.</p>
        pub fn longitude(mut self, input: f64) -> Self {
            self.longitude = Some(input);
            self
        }
        /// <p>The longitude.</p>
        pub fn set_longitude(mut self, input: std::option::Option<f64>) -> Self {
            self.longitude = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                latitude: self.latitude,
                longitude: self.longitude,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

/// <p>Represents the set of radios and their states on a device. Examples of radios
/// include Wi-Fi, GPS, Bluetooth, and NFC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Radios {
    /// <p>True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.</p>
    pub wifi: std::option::Option<bool>,
    /// <p>True if Bluetooth is enabled at the beginning of the test. Otherwise, false.</p>
    pub bluetooth: std::option::Option<bool>,
    /// <p>True if NFC is enabled at the beginning of the test. Otherwise, false.</p>
    pub nfc: std::option::Option<bool>,
    /// <p>True if GPS is enabled at the beginning of the test. Otherwise, false.</p>
    pub gps: std::option::Option<bool>,
}
impl Radios {
    /// <p>True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.</p>
    pub fn wifi(&self) -> std::option::Option<bool> {
        self.wifi
    }
    /// <p>True if Bluetooth is enabled at the beginning of the test. Otherwise, false.</p>
    pub fn bluetooth(&self) -> std::option::Option<bool> {
        self.bluetooth
    }
    /// <p>True if NFC is enabled at the beginning of the test. Otherwise, false.</p>
    pub fn nfc(&self) -> std::option::Option<bool> {
        self.nfc
    }
    /// <p>True if GPS is enabled at the beginning of the test. Otherwise, false.</p>
    pub fn gps(&self) -> std::option::Option<bool> {
        self.gps
    }
}
impl std::fmt::Debug for Radios {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Radios");
        formatter.field("wifi", &self.wifi);
        formatter.field("bluetooth", &self.bluetooth);
        formatter.field("nfc", &self.nfc);
        formatter.field("gps", &self.gps);
        formatter.finish()
    }
}
/// See [`Radios`](crate::model::Radios)
pub mod radios {
    /// A builder for [`Radios`](crate::model::Radios)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) wifi: std::option::Option<bool>,
        pub(crate) bluetooth: std::option::Option<bool>,
        pub(crate) nfc: std::option::Option<bool>,
        pub(crate) gps: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn wifi(mut self, input: bool) -> Self {
            self.wifi = Some(input);
            self
        }
        /// <p>True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn set_wifi(mut self, input: std::option::Option<bool>) -> Self {
            self.wifi = input;
            self
        }
        /// <p>True if Bluetooth is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn bluetooth(mut self, input: bool) -> Self {
            self.bluetooth = Some(input);
            self
        }
        /// <p>True if Bluetooth is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn set_bluetooth(mut self, input: std::option::Option<bool>) -> Self {
            self.bluetooth = input;
            self
        }
        /// <p>True if NFC is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn nfc(mut self, input: bool) -> Self {
            self.nfc = Some(input);
            self
        }
        /// <p>True if NFC is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn set_nfc(mut self, input: std::option::Option<bool>) -> Self {
            self.nfc = input;
            self
        }
        /// <p>True if GPS is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn gps(mut self, input: bool) -> Self {
            self.gps = Some(input);
            self
        }
        /// <p>True if GPS is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn set_gps(mut self, input: std::option::Option<bool>) -> Self {
            self.gps = input;
            self
        }
        /// Consumes the builder and constructs a [`Radios`](crate::model::Radios)
        pub fn build(self) -> crate::model::Radios {
            crate::model::Radios {
                wifi: self.wifi,
                bluetooth: self.bluetooth,
                nfc: self.nfc,
                gps: self.gps,
            }
        }
    }
}
impl Radios {
    /// Creates a new builder-style object to manufacture [`Radios`](crate::model::Radios)
    pub fn builder() -> crate::model::radios::Builder {
        crate::model::radios::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionResultCode {
    #[allow(missing_docs)] // documentation missing in model
    ParsingFailed,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpointSetupFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionResultCode {
    fn from(s: &str) -> Self {
        match s {
            "PARSING_FAILED" => ExecutionResultCode::ParsingFailed,
            "VPC_ENDPOINT_SETUP_FAILED" => ExecutionResultCode::VpcEndpointSetupFailed,
            other => ExecutionResultCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionResultCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionResultCode::from(s))
    }
}
impl ExecutionResultCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionResultCode::ParsingFailed => "PARSING_FAILED",
            ExecutionResultCode::VpcEndpointSetupFailed => "VPC_ENDPOINT_SETUP_FAILED",
            ExecutionResultCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PARSING_FAILED", "VPC_ENDPOINT_SETUP_FAILED"]
    }
}
impl AsRef<str> for ExecutionResultCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the total (metered or unmetered) minutes used by the resource to run
/// tests. Contains the sum of minutes consumed by all children.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceMinutes {
    /// <p>When specified, represents the total minutes used by the resource to run
    /// tests.</p>
    pub total: std::option::Option<f64>,
    /// <p>When specified, represents only the sum of metered minutes used by the resource to
    /// run tests.</p>
    pub metered: std::option::Option<f64>,
    /// <p>When specified, represents only the sum of unmetered minutes used by the resource
    /// to run tests.</p>
    pub unmetered: std::option::Option<f64>,
}
impl DeviceMinutes {
    /// <p>When specified, represents the total minutes used by the resource to run
    /// tests.</p>
    pub fn total(&self) -> std::option::Option<f64> {
        self.total
    }
    /// <p>When specified, represents only the sum of metered minutes used by the resource to
    /// run tests.</p>
    pub fn metered(&self) -> std::option::Option<f64> {
        self.metered
    }
    /// <p>When specified, represents only the sum of unmetered minutes used by the resource
    /// to run tests.</p>
    pub fn unmetered(&self) -> std::option::Option<f64> {
        self.unmetered
    }
}
impl std::fmt::Debug for DeviceMinutes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceMinutes");
        formatter.field("total", &self.total);
        formatter.field("metered", &self.metered);
        formatter.field("unmetered", &self.unmetered);
        formatter.finish()
    }
}
/// See [`DeviceMinutes`](crate::model::DeviceMinutes)
pub mod device_minutes {
    /// A builder for [`DeviceMinutes`](crate::model::DeviceMinutes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<f64>,
        pub(crate) metered: std::option::Option<f64>,
        pub(crate) unmetered: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>When specified, represents the total minutes used by the resource to run
        /// tests.</p>
        pub fn total(mut self, input: f64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>When specified, represents the total minutes used by the resource to run
        /// tests.</p>
        pub fn set_total(mut self, input: std::option::Option<f64>) -> Self {
            self.total = input;
            self
        }
        /// <p>When specified, represents only the sum of metered minutes used by the resource to
        /// run tests.</p>
        pub fn metered(mut self, input: f64) -> Self {
            self.metered = Some(input);
            self
        }
        /// <p>When specified, represents only the sum of metered minutes used by the resource to
        /// run tests.</p>
        pub fn set_metered(mut self, input: std::option::Option<f64>) -> Self {
            self.metered = input;
            self
        }
        /// <p>When specified, represents only the sum of unmetered minutes used by the resource
        /// to run tests.</p>
        pub fn unmetered(mut self, input: f64) -> Self {
            self.unmetered = Some(input);
            self
        }
        /// <p>When specified, represents only the sum of unmetered minutes used by the resource
        /// to run tests.</p>
        pub fn set_unmetered(mut self, input: std::option::Option<f64>) -> Self {
            self.unmetered = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceMinutes`](crate::model::DeviceMinutes)
        pub fn build(self) -> crate::model::DeviceMinutes {
            crate::model::DeviceMinutes {
                total: self.total,
                metered: self.metered,
                unmetered: self.unmetered,
            }
        }
    }
}
impl DeviceMinutes {
    /// Creates a new builder-style object to manufacture [`DeviceMinutes`](crate::model::DeviceMinutes)
    pub fn builder() -> crate::model::device_minutes::Builder {
        crate::model::device_minutes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BillingMethod {
    #[allow(missing_docs)] // documentation missing in model
    Metered,
    #[allow(missing_docs)] // documentation missing in model
    Unmetered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BillingMethod {
    fn from(s: &str) -> Self {
        match s {
            "METERED" => BillingMethod::Metered,
            "UNMETERED" => BillingMethod::Unmetered,
            other => BillingMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BillingMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BillingMethod::from(s))
    }
}
impl BillingMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BillingMethod::Metered => "METERED",
            BillingMethod::Unmetered => "UNMETERED",
            BillingMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["METERED", "UNMETERED"]
    }
}
impl AsRef<str> for BillingMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents entity counters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Counters {
    /// <p>The total number of entities.</p>
    pub total: std::option::Option<i32>,
    /// <p>The number of passed entities.</p>
    pub passed: std::option::Option<i32>,
    /// <p>The number of failed entities.</p>
    pub failed: std::option::Option<i32>,
    /// <p>The number of warned entities.</p>
    pub warned: std::option::Option<i32>,
    /// <p>The number of errored entities.</p>
    pub errored: std::option::Option<i32>,
    /// <p>The number of stopped entities.</p>
    pub stopped: std::option::Option<i32>,
    /// <p>The number of skipped entities.</p>
    pub skipped: std::option::Option<i32>,
}
impl Counters {
    /// <p>The total number of entities.</p>
    pub fn total(&self) -> std::option::Option<i32> {
        self.total
    }
    /// <p>The number of passed entities.</p>
    pub fn passed(&self) -> std::option::Option<i32> {
        self.passed
    }
    /// <p>The number of failed entities.</p>
    pub fn failed(&self) -> std::option::Option<i32> {
        self.failed
    }
    /// <p>The number of warned entities.</p>
    pub fn warned(&self) -> std::option::Option<i32> {
        self.warned
    }
    /// <p>The number of errored entities.</p>
    pub fn errored(&self) -> std::option::Option<i32> {
        self.errored
    }
    /// <p>The number of stopped entities.</p>
    pub fn stopped(&self) -> std::option::Option<i32> {
        self.stopped
    }
    /// <p>The number of skipped entities.</p>
    pub fn skipped(&self) -> std::option::Option<i32> {
        self.skipped
    }
}
impl std::fmt::Debug for Counters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Counters");
        formatter.field("total", &self.total);
        formatter.field("passed", &self.passed);
        formatter.field("failed", &self.failed);
        formatter.field("warned", &self.warned);
        formatter.field("errored", &self.errored);
        formatter.field("stopped", &self.stopped);
        formatter.field("skipped", &self.skipped);
        formatter.finish()
    }
}
/// See [`Counters`](crate::model::Counters)
pub mod counters {
    /// A builder for [`Counters`](crate::model::Counters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<i32>,
        pub(crate) passed: std::option::Option<i32>,
        pub(crate) failed: std::option::Option<i32>,
        pub(crate) warned: std::option::Option<i32>,
        pub(crate) errored: std::option::Option<i32>,
        pub(crate) stopped: std::option::Option<i32>,
        pub(crate) skipped: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total number of entities.</p>
        pub fn total(mut self, input: i32) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total number of entities.</p>
        pub fn set_total(mut self, input: std::option::Option<i32>) -> Self {
            self.total = input;
            self
        }
        /// <p>The number of passed entities.</p>
        pub fn passed(mut self, input: i32) -> Self {
            self.passed = Some(input);
            self
        }
        /// <p>The number of passed entities.</p>
        pub fn set_passed(mut self, input: std::option::Option<i32>) -> Self {
            self.passed = input;
            self
        }
        /// <p>The number of failed entities.</p>
        pub fn failed(mut self, input: i32) -> Self {
            self.failed = Some(input);
            self
        }
        /// <p>The number of failed entities.</p>
        pub fn set_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.failed = input;
            self
        }
        /// <p>The number of warned entities.</p>
        pub fn warned(mut self, input: i32) -> Self {
            self.warned = Some(input);
            self
        }
        /// <p>The number of warned entities.</p>
        pub fn set_warned(mut self, input: std::option::Option<i32>) -> Self {
            self.warned = input;
            self
        }
        /// <p>The number of errored entities.</p>
        pub fn errored(mut self, input: i32) -> Self {
            self.errored = Some(input);
            self
        }
        /// <p>The number of errored entities.</p>
        pub fn set_errored(mut self, input: std::option::Option<i32>) -> Self {
            self.errored = input;
            self
        }
        /// <p>The number of stopped entities.</p>
        pub fn stopped(mut self, input: i32) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The number of stopped entities.</p>
        pub fn set_stopped(mut self, input: std::option::Option<i32>) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The number of skipped entities.</p>
        pub fn skipped(mut self, input: i32) -> Self {
            self.skipped = Some(input);
            self
        }
        /// <p>The number of skipped entities.</p>
        pub fn set_skipped(mut self, input: std::option::Option<i32>) -> Self {
            self.skipped = input;
            self
        }
        /// Consumes the builder and constructs a [`Counters`](crate::model::Counters)
        pub fn build(self) -> crate::model::Counters {
            crate::model::Counters {
                total: self.total,
                passed: self.passed,
                failed: self.failed,
                warned: self.warned,
                errored: self.errored,
                stopped: self.stopped,
                skipped: self.skipped,
            }
        }
    }
}
impl Counters {
    /// Creates a new builder-style object to manufacture [`Counters`](crate::model::Counters)
    pub fn builder() -> crate::model::counters::Builder {
        crate::model::counters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionResult {
    #[allow(missing_docs)] // documentation missing in model
    Errored,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Passed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Warned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionResult {
    fn from(s: &str) -> Self {
        match s {
            "ERRORED" => ExecutionResult::Errored,
            "FAILED" => ExecutionResult::Failed,
            "PASSED" => ExecutionResult::Passed,
            "PENDING" => ExecutionResult::Pending,
            "SKIPPED" => ExecutionResult::Skipped,
            "STOPPED" => ExecutionResult::Stopped,
            "WARNED" => ExecutionResult::Warned,
            other => ExecutionResult::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionResult {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionResult::from(s))
    }
}
impl ExecutionResult {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionResult::Errored => "ERRORED",
            ExecutionResult::Failed => "FAILED",
            ExecutionResult::Passed => "PASSED",
            ExecutionResult::Pending => "PENDING",
            ExecutionResult::Skipped => "SKIPPED",
            ExecutionResult::Stopped => "STOPPED",
            ExecutionResult::Warned => "WARNED",
            ExecutionResult::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ERRORED", "FAILED", "PASSED", "PENDING", "SKIPPED", "STOPPED", "WARNED",
        ]
    }
}
impl AsRef<str> for ExecutionResult {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingConcurrnecy,
    #[allow(missing_docs)] // documentation missing in model
    PendingDevice,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Scheduling,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => ExecutionStatus::Completed,
            "PENDING" => ExecutionStatus::Pending,
            "PENDING_CONCURRENCY" => ExecutionStatus::PendingConcurrnecy,
            "PENDING_DEVICE" => ExecutionStatus::PendingDevice,
            "PREPARING" => ExecutionStatus::Preparing,
            "PROCESSING" => ExecutionStatus::Processing,
            "RUNNING" => ExecutionStatus::Running,
            "SCHEDULING" => ExecutionStatus::Scheduling,
            "STOPPING" => ExecutionStatus::Stopping,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Completed => "COMPLETED",
            ExecutionStatus::Pending => "PENDING",
            ExecutionStatus::PendingConcurrnecy => "PENDING_CONCURRENCY",
            ExecutionStatus::PendingDevice => "PENDING_DEVICE",
            ExecutionStatus::Preparing => "PREPARING",
            ExecutionStatus::Processing => "PROCESSING",
            ExecutionStatus::Running => "RUNNING",
            ExecutionStatus::Scheduling => "SCHEDULING",
            ExecutionStatus::Stopping => "STOPPING",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "PENDING",
            "PENDING_CONCURRENCY",
            "PENDING_DEVICE",
            "PREPARING",
            "PROCESSING",
            "RUNNING",
            "SCHEDULING",
            "STOPPING",
        ]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DevicePlatform {
    #[allow(missing_docs)] // documentation missing in model
    Android,
    #[allow(missing_docs)] // documentation missing in model
    Ios,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DevicePlatform {
    fn from(s: &str) -> Self {
        match s {
            "ANDROID" => DevicePlatform::Android,
            "IOS" => DevicePlatform::Ios,
            other => DevicePlatform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DevicePlatform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DevicePlatform::from(s))
    }
}
impl DevicePlatform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DevicePlatform::Android => "ANDROID",
            DevicePlatform::Ios => "IOS",
            DevicePlatform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANDROID", "IOS"]
    }
}
impl AsRef<str> for DevicePlatform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TestType {
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaJunit,
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaTestng,
    #[allow(missing_docs)] // documentation missing in model
    AppiumNode,
    #[allow(missing_docs)] // documentation missing in model
    AppiumPython,
    #[allow(missing_docs)] // documentation missing in model
    AppiumRuby,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebJavaJunit,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebJavaTestng,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebNode,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebPython,
    #[allow(missing_docs)] // documentation missing in model
    AppiumWebRuby,
    #[allow(missing_docs)] // documentation missing in model
    BuiltinExplorer,
    #[allow(missing_docs)] // documentation missing in model
    BuiltinFuzz,
    #[allow(missing_docs)] // documentation missing in model
    Calabash,
    #[allow(missing_docs)] // documentation missing in model
    Instrumentation,
    #[allow(missing_docs)] // documentation missing in model
    RemoteAccessRecord,
    #[allow(missing_docs)] // documentation missing in model
    RemoteAccessReplay,
    #[allow(missing_docs)] // documentation missing in model
    Uiautomation,
    #[allow(missing_docs)] // documentation missing in model
    Uiautomator,
    #[allow(missing_docs)] // documentation missing in model
    WebPerformanceProfile,
    #[allow(missing_docs)] // documentation missing in model
    Xctest,
    #[allow(missing_docs)] // documentation missing in model
    XctestUi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TestType {
    fn from(s: &str) -> Self {
        match s {
            "APPIUM_JAVA_JUNIT" => TestType::AppiumJavaJunit,
            "APPIUM_JAVA_TESTNG" => TestType::AppiumJavaTestng,
            "APPIUM_NODE" => TestType::AppiumNode,
            "APPIUM_PYTHON" => TestType::AppiumPython,
            "APPIUM_RUBY" => TestType::AppiumRuby,
            "APPIUM_WEB_JAVA_JUNIT" => TestType::AppiumWebJavaJunit,
            "APPIUM_WEB_JAVA_TESTNG" => TestType::AppiumWebJavaTestng,
            "APPIUM_WEB_NODE" => TestType::AppiumWebNode,
            "APPIUM_WEB_PYTHON" => TestType::AppiumWebPython,
            "APPIUM_WEB_RUBY" => TestType::AppiumWebRuby,
            "BUILTIN_EXPLORER" => TestType::BuiltinExplorer,
            "BUILTIN_FUZZ" => TestType::BuiltinFuzz,
            "CALABASH" => TestType::Calabash,
            "INSTRUMENTATION" => TestType::Instrumentation,
            "REMOTE_ACCESS_RECORD" => TestType::RemoteAccessRecord,
            "REMOTE_ACCESS_REPLAY" => TestType::RemoteAccessReplay,
            "UIAUTOMATION" => TestType::Uiautomation,
            "UIAUTOMATOR" => TestType::Uiautomator,
            "WEB_PERFORMANCE_PROFILE" => TestType::WebPerformanceProfile,
            "XCTEST" => TestType::Xctest,
            "XCTEST_UI" => TestType::XctestUi,
            other => TestType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TestType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TestType::from(s))
    }
}
impl TestType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TestType::AppiumJavaJunit => "APPIUM_JAVA_JUNIT",
            TestType::AppiumJavaTestng => "APPIUM_JAVA_TESTNG",
            TestType::AppiumNode => "APPIUM_NODE",
            TestType::AppiumPython => "APPIUM_PYTHON",
            TestType::AppiumRuby => "APPIUM_RUBY",
            TestType::AppiumWebJavaJunit => "APPIUM_WEB_JAVA_JUNIT",
            TestType::AppiumWebJavaTestng => "APPIUM_WEB_JAVA_TESTNG",
            TestType::AppiumWebNode => "APPIUM_WEB_NODE",
            TestType::AppiumWebPython => "APPIUM_WEB_PYTHON",
            TestType::AppiumWebRuby => "APPIUM_WEB_RUBY",
            TestType::BuiltinExplorer => "BUILTIN_EXPLORER",
            TestType::BuiltinFuzz => "BUILTIN_FUZZ",
            TestType::Calabash => "CALABASH",
            TestType::Instrumentation => "INSTRUMENTATION",
            TestType::RemoteAccessRecord => "REMOTE_ACCESS_RECORD",
            TestType::RemoteAccessReplay => "REMOTE_ACCESS_REPLAY",
            TestType::Uiautomation => "UIAUTOMATION",
            TestType::Uiautomator => "UIAUTOMATOR",
            TestType::WebPerformanceProfile => "WEB_PERFORMANCE_PROFILE",
            TestType::Xctest => "XCTEST",
            TestType::XctestUi => "XCTEST_UI",
            TestType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPIUM_JAVA_JUNIT",
            "APPIUM_JAVA_TESTNG",
            "APPIUM_NODE",
            "APPIUM_PYTHON",
            "APPIUM_RUBY",
            "APPIUM_WEB_JAVA_JUNIT",
            "APPIUM_WEB_JAVA_TESTNG",
            "APPIUM_WEB_NODE",
            "APPIUM_WEB_PYTHON",
            "APPIUM_WEB_RUBY",
            "BUILTIN_EXPLORER",
            "BUILTIN_FUZZ",
            "CALABASH",
            "INSTRUMENTATION",
            "REMOTE_ACCESS_RECORD",
            "REMOTE_ACCESS_REPLAY",
            "UIAUTOMATION",
            "UIAUTOMATOR",
            "WEB_PERFORMANCE_PROFILE",
            "XCTEST",
            "XCTEST_UI",
        ]
    }
}
impl AsRef<str> for TestType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about the remote access session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoteAccessSession {
    /// <p>The Amazon Resource Name (ARN) of the remote access session.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the remote access session.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date and time the remote access session was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the remote access session. Can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING.</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY.</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE.</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING.</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING.</p>
    /// </li>
    /// <li>
    /// <p>PREPARING.</p>
    /// </li>
    /// <li>
    /// <p>RUNNING.</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED.</p>
    /// </li>
    /// <li>
    /// <p>STOPPING.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The result of the remote access session. Can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING.</p>
    /// </li>
    /// <li>
    /// <p>PASSED.</p>
    /// </li>
    /// <li>
    /// <p>WARNED.</p>
    /// </li>
    /// <li>
    /// <p>FAILED.</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED.</p>
    /// </li>
    /// <li>
    /// <p>ERRORED.</p>
    /// </li>
    /// <li>
    /// <p>STOPPED.</p>
    /// </li>
    /// </ul>
    pub result: std::option::Option<crate::model::ExecutionResult>,
    /// <p>A message about the remote access session.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The date and time the remote access session was started.</p>
    pub started: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time the remote access session was stopped.</p>
    pub stopped: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The device (phone or tablet) used in the remote access session.</p>
    pub device: std::option::Option<crate::model::Device>,
    /// <p>The ARN of the instance.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the remote
    /// access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub remote_debug_enabled: std::option::Option<bool>,
    /// <p>This flag is set to <code>true</code> if remote recording is enabled for the remote
    /// access session.</p>
    pub remote_record_enabled: std::option::Option<bool>,
    /// <p>The ARN for the app to be recorded in the remote access session.</p>
    pub remote_record_app_arn: std::option::Option<std::string::String>,
    /// <p>IP address of the EC2 host where you need to connect to remotely debug devices.
    /// Only returned if remote debugging is enabled for the remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub host_address: std::option::Option<std::string::String>,
    /// <p>Unique identifier of your client for the remote access session. Only returned if
    /// remote debugging is enabled for the remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The billing method of the remote access session. Possible values include <code>METERED</code> or
    /// <code>UNMETERED</code>. For more information about metered devices, see <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device Farm
    /// terminology</a>.</p>
    pub billing_method: std::option::Option<crate::model::BillingMethod>,
    /// <p>The number of minutes a device is used in a remote access session (including setup
    /// and teardown minutes).</p>
    pub device_minutes: std::option::Option<crate::model::DeviceMinutes>,
    /// <p>The endpoint for the remote access sesssion.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>Unique device identifier for the remote device. Only returned if remote debugging
    /// is enabled for the remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub device_udid: std::option::Option<std::string::String>,
    /// <p>The interaction mode of the remote access session. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and
    /// rotating the screen. You cannot run XCUITest framework-based tests in this
    /// mode.</p>
    /// </li>
    /// <li>
    /// <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This
    /// mode has the fastest test execution speed. You can run XCUITest framework-based tests in this
    /// mode.</p>
    /// </li>
    /// <li>
    /// <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
    /// framework-based tests and watch the screen in this mode.</p>
    /// </li>
    /// </ul>
    pub interaction_mode: std::option::Option<crate::model::InteractionMode>,
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub skip_app_resign: std::option::Option<bool>,
}
impl RemoteAccessSession {
    /// <p>The Amazon Resource Name (ARN) of the remote access session.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the remote access session.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date and time the remote access session was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The status of the remote access session. Can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING.</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY.</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE.</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING.</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING.</p>
    /// </li>
    /// <li>
    /// <p>PREPARING.</p>
    /// </li>
    /// <li>
    /// <p>RUNNING.</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED.</p>
    /// </li>
    /// <li>
    /// <p>STOPPING.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The result of the remote access session. Can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING.</p>
    /// </li>
    /// <li>
    /// <p>PASSED.</p>
    /// </li>
    /// <li>
    /// <p>WARNED.</p>
    /// </li>
    /// <li>
    /// <p>FAILED.</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED.</p>
    /// </li>
    /// <li>
    /// <p>ERRORED.</p>
    /// </li>
    /// <li>
    /// <p>STOPPED.</p>
    /// </li>
    /// </ul>
    pub fn result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.result.as_ref()
    }
    /// <p>A message about the remote access session.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The date and time the remote access session was started.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started.as_ref()
    }
    /// <p>The date and time the remote access session was stopped.</p>
    pub fn stopped(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stopped.as_ref()
    }
    /// <p>The device (phone or tablet) used in the remote access session.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
    /// <p>The ARN of the instance.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the remote
    /// access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub fn remote_debug_enabled(&self) -> std::option::Option<bool> {
        self.remote_debug_enabled
    }
    /// <p>This flag is set to <code>true</code> if remote recording is enabled for the remote
    /// access session.</p>
    pub fn remote_record_enabled(&self) -> std::option::Option<bool> {
        self.remote_record_enabled
    }
    /// <p>The ARN for the app to be recorded in the remote access session.</p>
    pub fn remote_record_app_arn(&self) -> std::option::Option<&str> {
        self.remote_record_app_arn.as_deref()
    }
    /// <p>IP address of the EC2 host where you need to connect to remotely debug devices.
    /// Only returned if remote debugging is enabled for the remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub fn host_address(&self) -> std::option::Option<&str> {
        self.host_address.as_deref()
    }
    /// <p>Unique identifier of your client for the remote access session. Only returned if
    /// remote debugging is enabled for the remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The billing method of the remote access session. Possible values include <code>METERED</code> or
    /// <code>UNMETERED</code>. For more information about metered devices, see <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device Farm
    /// terminology</a>.</p>
    pub fn billing_method(&self) -> std::option::Option<&crate::model::BillingMethod> {
        self.billing_method.as_ref()
    }
    /// <p>The number of minutes a device is used in a remote access session (including setup
    /// and teardown minutes).</p>
    pub fn device_minutes(&self) -> std::option::Option<&crate::model::DeviceMinutes> {
        self.device_minutes.as_ref()
    }
    /// <p>The endpoint for the remote access sesssion.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>Unique device identifier for the remote device. Only returned if remote debugging
    /// is enabled for the remote access session.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub fn device_udid(&self) -> std::option::Option<&str> {
        self.device_udid.as_deref()
    }
    /// <p>The interaction mode of the remote access session. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and
    /// rotating the screen. You cannot run XCUITest framework-based tests in this
    /// mode.</p>
    /// </li>
    /// <li>
    /// <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This
    /// mode has the fastest test execution speed. You can run XCUITest framework-based tests in this
    /// mode.</p>
    /// </li>
    /// <li>
    /// <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
    /// framework-based tests and watch the screen in this mode.</p>
    /// </li>
    /// </ul>
    pub fn interaction_mode(&self) -> std::option::Option<&crate::model::InteractionMode> {
        self.interaction_mode.as_ref()
    }
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub fn skip_app_resign(&self) -> std::option::Option<bool> {
        self.skip_app_resign
    }
}
impl std::fmt::Debug for RemoteAccessSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoteAccessSession");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("created", &self.created);
        formatter.field("status", &self.status);
        formatter.field("result", &self.result);
        formatter.field("message", &self.message);
        formatter.field("started", &self.started);
        formatter.field("stopped", &self.stopped);
        formatter.field("device", &self.device);
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("remote_debug_enabled", &self.remote_debug_enabled);
        formatter.field("remote_record_enabled", &self.remote_record_enabled);
        formatter.field("remote_record_app_arn", &self.remote_record_app_arn);
        formatter.field("host_address", &self.host_address);
        formatter.field("client_id", &self.client_id);
        formatter.field("billing_method", &self.billing_method);
        formatter.field("device_minutes", &self.device_minutes);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("device_udid", &self.device_udid);
        formatter.field("interaction_mode", &self.interaction_mode);
        formatter.field("skip_app_resign", &self.skip_app_resign);
        formatter.finish()
    }
}
/// See [`RemoteAccessSession`](crate::model::RemoteAccessSession)
pub mod remote_access_session {
    /// A builder for [`RemoteAccessSession`](crate::model::RemoteAccessSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) started: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) device: std::option::Option<crate::model::Device>,
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) remote_debug_enabled: std::option::Option<bool>,
        pub(crate) remote_record_enabled: std::option::Option<bool>,
        pub(crate) remote_record_app_arn: std::option::Option<std::string::String>,
        pub(crate) host_address: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) billing_method: std::option::Option<crate::model::BillingMethod>,
        pub(crate) device_minutes: std::option::Option<crate::model::DeviceMinutes>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) device_udid: std::option::Option<std::string::String>,
        pub(crate) interaction_mode: std::option::Option<crate::model::InteractionMode>,
        pub(crate) skip_app_resign: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the remote access session.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the remote access session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the remote access session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date and time the remote access session was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time the remote access session was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The status of the remote access session. Can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING.</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY.</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE.</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING.</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING.</p>
        /// </li>
        /// <li>
        /// <p>PREPARING.</p>
        /// </li>
        /// <li>
        /// <p>RUNNING.</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED.</p>
        /// </li>
        /// <li>
        /// <p>STOPPING.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the remote access session. Can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING.</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY.</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE.</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING.</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING.</p>
        /// </li>
        /// <li>
        /// <p>PREPARING.</p>
        /// </li>
        /// <li>
        /// <p>RUNNING.</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED.</p>
        /// </li>
        /// <li>
        /// <p>STOPPING.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The result of the remote access session. Can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING.</p>
        /// </li>
        /// <li>
        /// <p>PASSED.</p>
        /// </li>
        /// <li>
        /// <p>WARNED.</p>
        /// </li>
        /// <li>
        /// <p>FAILED.</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED.</p>
        /// </li>
        /// <li>
        /// <p>ERRORED.</p>
        /// </li>
        /// <li>
        /// <p>STOPPED.</p>
        /// </li>
        /// </ul>
        pub fn result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The result of the remote access session. Can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING.</p>
        /// </li>
        /// <li>
        /// <p>PASSED.</p>
        /// </li>
        /// <li>
        /// <p>WARNED.</p>
        /// </li>
        /// <li>
        /// <p>FAILED.</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED.</p>
        /// </li>
        /// <li>
        /// <p>ERRORED.</p>
        /// </li>
        /// <li>
        /// <p>STOPPED.</p>
        /// </li>
        /// </ul>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>A message about the remote access session.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the remote access session.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The date and time the remote access session was started.</p>
        pub fn started(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The date and time the remote access session was started.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The date and time the remote access session was stopped.</p>
        pub fn stopped(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The date and time the remote access session was stopped.</p>
        pub fn set_stopped(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The device (phone or tablet) used in the remote access session.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>The device (phone or tablet) used in the remote access session.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// <p>The ARN of the instance.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the instance.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the remote
        /// access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn remote_debug_enabled(mut self, input: bool) -> Self {
            self.remote_debug_enabled = Some(input);
            self
        }
        /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the remote
        /// access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_remote_debug_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_debug_enabled = input;
            self
        }
        /// <p>This flag is set to <code>true</code> if remote recording is enabled for the remote
        /// access session.</p>
        pub fn remote_record_enabled(mut self, input: bool) -> Self {
            self.remote_record_enabled = Some(input);
            self
        }
        /// <p>This flag is set to <code>true</code> if remote recording is enabled for the remote
        /// access session.</p>
        pub fn set_remote_record_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_record_enabled = input;
            self
        }
        /// <p>The ARN for the app to be recorded in the remote access session.</p>
        pub fn remote_record_app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_record_app_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the app to be recorded in the remote access session.</p>
        pub fn set_remote_record_app_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_record_app_arn = input;
            self
        }
        /// <p>IP address of the EC2 host where you need to connect to remotely debug devices.
        /// Only returned if remote debugging is enabled for the remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn host_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_address = Some(input.into());
            self
        }
        /// <p>IP address of the EC2 host where you need to connect to remotely debug devices.
        /// Only returned if remote debugging is enabled for the remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_host_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_address = input;
            self
        }
        /// <p>Unique identifier of your client for the remote access session. Only returned if
        /// remote debugging is enabled for the remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of your client for the remote access session. Only returned if
        /// remote debugging is enabled for the remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The billing method of the remote access session. Possible values include <code>METERED</code> or
        /// <code>UNMETERED</code>. For more information about metered devices, see <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device Farm
        /// terminology</a>.</p>
        pub fn billing_method(mut self, input: crate::model::BillingMethod) -> Self {
            self.billing_method = Some(input);
            self
        }
        /// <p>The billing method of the remote access session. Possible values include <code>METERED</code> or
        /// <code>UNMETERED</code>. For more information about metered devices, see <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device Farm
        /// terminology</a>.</p>
        pub fn set_billing_method(
            mut self,
            input: std::option::Option<crate::model::BillingMethod>,
        ) -> Self {
            self.billing_method = input;
            self
        }
        /// <p>The number of minutes a device is used in a remote access session (including setup
        /// and teardown minutes).</p>
        pub fn device_minutes(mut self, input: crate::model::DeviceMinutes) -> Self {
            self.device_minutes = Some(input);
            self
        }
        /// <p>The number of minutes a device is used in a remote access session (including setup
        /// and teardown minutes).</p>
        pub fn set_device_minutes(
            mut self,
            input: std::option::Option<crate::model::DeviceMinutes>,
        ) -> Self {
            self.device_minutes = input;
            self
        }
        /// <p>The endpoint for the remote access sesssion.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint for the remote access sesssion.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>Unique device identifier for the remote device. Only returned if remote debugging
        /// is enabled for the remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn device_udid(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_udid = Some(input.into());
            self
        }
        /// <p>Unique device identifier for the remote device. Only returned if remote debugging
        /// is enabled for the remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_device_udid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_udid = input;
            self
        }
        /// <p>The interaction mode of the remote access session. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and
        /// rotating the screen. You cannot run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This
        /// mode has the fastest test execution speed. You can run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
        /// framework-based tests and watch the screen in this mode.</p>
        /// </li>
        /// </ul>
        pub fn interaction_mode(mut self, input: crate::model::InteractionMode) -> Self {
            self.interaction_mode = Some(input);
            self
        }
        /// <p>The interaction mode of the remote access session. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and
        /// rotating the screen. You cannot run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This
        /// mode has the fastest test execution speed. You can run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
        /// framework-based tests and watch the screen in this mode.</p>
        /// </li>
        /// </ul>
        pub fn set_interaction_mode(
            mut self,
            input: std::option::Option<crate::model::InteractionMode>,
        ) -> Self {
            self.interaction_mode = input;
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn skip_app_resign(mut self, input: bool) -> Self {
            self.skip_app_resign = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn set_skip_app_resign(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_app_resign = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoteAccessSession`](crate::model::RemoteAccessSession)
        pub fn build(self) -> crate::model::RemoteAccessSession {
            crate::model::RemoteAccessSession {
                arn: self.arn,
                name: self.name,
                created: self.created,
                status: self.status,
                result: self.result,
                message: self.message,
                started: self.started,
                stopped: self.stopped,
                device: self.device,
                instance_arn: self.instance_arn,
                remote_debug_enabled: self.remote_debug_enabled,
                remote_record_enabled: self.remote_record_enabled,
                remote_record_app_arn: self.remote_record_app_arn,
                host_address: self.host_address,
                client_id: self.client_id,
                billing_method: self.billing_method,
                device_minutes: self.device_minutes,
                endpoint: self.endpoint,
                device_udid: self.device_udid,
                interaction_mode: self.interaction_mode,
                skip_app_resign: self.skip_app_resign,
            }
        }
    }
}
impl RemoteAccessSession {
    /// Creates a new builder-style object to manufacture [`RemoteAccessSession`](crate::model::RemoteAccessSession)
    pub fn builder() -> crate::model::remote_access_session::Builder {
        crate::model::remote_access_session::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InteractionMode {
    #[allow(missing_docs)] // documentation missing in model
    Interactive,
    #[allow(missing_docs)] // documentation missing in model
    NoVideo,
    #[allow(missing_docs)] // documentation missing in model
    VideoOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InteractionMode {
    fn from(s: &str) -> Self {
        match s {
            "INTERACTIVE" => InteractionMode::Interactive,
            "NO_VIDEO" => InteractionMode::NoVideo,
            "VIDEO_ONLY" => InteractionMode::VideoOnly,
            other => InteractionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InteractionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InteractionMode::from(s))
    }
}
impl InteractionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InteractionMode::Interactive => "INTERACTIVE",
            InteractionMode::NoVideo => "NO_VIDEO",
            InteractionMode::VideoOnly => "VIDEO_ONLY",
            InteractionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERACTIVE", "NO_VIDEO", "VIDEO_ONLY"]
    }
}
impl AsRef<str> for InteractionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a device type that an app is tested against.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The device's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The device's display name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The device's manufacturer name.</p>
    pub manufacturer: std::option::Option<std::string::String>,
    /// <p>The device's model name.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The device's model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The device's form factor.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PHONE</p>
    /// </li>
    /// <li>
    /// <p>TABLET</p>
    /// </li>
    /// </ul>
    pub form_factor: std::option::Option<crate::model::DeviceFormFactor>,
    /// <p>The device's platform.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ANDROID</p>
    /// </li>
    /// <li>
    /// <p>IOS</p>
    /// </li>
    /// </ul>
    pub platform: std::option::Option<crate::model::DevicePlatform>,
    /// <p>The device's operating system type.</p>
    pub os: std::option::Option<std::string::String>,
    /// <p>Information about the device's CPU.</p>
    pub cpu: std::option::Option<crate::model::Cpu>,
    /// <p>The resolution of the device.</p>
    pub resolution: std::option::Option<crate::model::Resolution>,
    /// <p>The device's heap size, expressed in bytes.</p>
    pub heap_size: std::option::Option<i64>,
    /// <p>The device's total memory size, expressed in bytes.</p>
    pub memory: std::option::Option<i64>,
    /// <p>The device's image name.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>The device's carrier.</p>
    pub carrier: std::option::Option<std::string::String>,
    /// <p>The device's radio.</p>
    pub radio: std::option::Option<std::string::String>,
    /// <p>Specifies whether remote access has been enabled for the specified
    /// device.</p>
    pub remote_access_enabled: std::option::Option<bool>,
    /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the
    /// device.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub remote_debug_enabled: std::option::Option<bool>,
    /// <p>The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.</p>
    pub fleet_type: std::option::Option<std::string::String>,
    /// <p>The name of the fleet to which this device belongs.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The instances that belong to this device.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::DeviceInstance>>,
    /// <p>Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and GetDevice API methods.</p>
    pub availability: std::option::Option<crate::model::DeviceAvailability>,
}
impl Device {
    /// <p>The device's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The device's display name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The device's manufacturer name.</p>
    pub fn manufacturer(&self) -> std::option::Option<&str> {
        self.manufacturer.as_deref()
    }
    /// <p>The device's model name.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The device's model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The device's form factor.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PHONE</p>
    /// </li>
    /// <li>
    /// <p>TABLET</p>
    /// </li>
    /// </ul>
    pub fn form_factor(&self) -> std::option::Option<&crate::model::DeviceFormFactor> {
        self.form_factor.as_ref()
    }
    /// <p>The device's platform.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ANDROID</p>
    /// </li>
    /// <li>
    /// <p>IOS</p>
    /// </li>
    /// </ul>
    pub fn platform(&self) -> std::option::Option<&crate::model::DevicePlatform> {
        self.platform.as_ref()
    }
    /// <p>The device's operating system type.</p>
    pub fn os(&self) -> std::option::Option<&str> {
        self.os.as_deref()
    }
    /// <p>Information about the device's CPU.</p>
    pub fn cpu(&self) -> std::option::Option<&crate::model::Cpu> {
        self.cpu.as_ref()
    }
    /// <p>The resolution of the device.</p>
    pub fn resolution(&self) -> std::option::Option<&crate::model::Resolution> {
        self.resolution.as_ref()
    }
    /// <p>The device's heap size, expressed in bytes.</p>
    pub fn heap_size(&self) -> std::option::Option<i64> {
        self.heap_size
    }
    /// <p>The device's total memory size, expressed in bytes.</p>
    pub fn memory(&self) -> std::option::Option<i64> {
        self.memory
    }
    /// <p>The device's image name.</p>
    pub fn image(&self) -> std::option::Option<&str> {
        self.image.as_deref()
    }
    /// <p>The device's carrier.</p>
    pub fn carrier(&self) -> std::option::Option<&str> {
        self.carrier.as_deref()
    }
    /// <p>The device's radio.</p>
    pub fn radio(&self) -> std::option::Option<&str> {
        self.radio.as_deref()
    }
    /// <p>Specifies whether remote access has been enabled for the specified
    /// device.</p>
    pub fn remote_access_enabled(&self) -> std::option::Option<bool> {
        self.remote_access_enabled
    }
    /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the
    /// device.</p>
    /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>.</p>
    pub fn remote_debug_enabled(&self) -> std::option::Option<bool> {
        self.remote_debug_enabled
    }
    /// <p>The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.</p>
    pub fn fleet_type(&self) -> std::option::Option<&str> {
        self.fleet_type.as_deref()
    }
    /// <p>The name of the fleet to which this device belongs.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The instances that belong to this device.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::DeviceInstance]> {
        self.instances.as_deref()
    }
    /// <p>Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and GetDevice API methods.</p>
    pub fn availability(&self) -> std::option::Option<&crate::model::DeviceAvailability> {
        self.availability.as_ref()
    }
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("manufacturer", &self.manufacturer);
        formatter.field("model", &self.model);
        formatter.field("model_id", &self.model_id);
        formatter.field("form_factor", &self.form_factor);
        formatter.field("platform", &self.platform);
        formatter.field("os", &self.os);
        formatter.field("cpu", &self.cpu);
        formatter.field("resolution", &self.resolution);
        formatter.field("heap_size", &self.heap_size);
        formatter.field("memory", &self.memory);
        formatter.field("image", &self.image);
        formatter.field("carrier", &self.carrier);
        formatter.field("radio", &self.radio);
        formatter.field("remote_access_enabled", &self.remote_access_enabled);
        formatter.field("remote_debug_enabled", &self.remote_debug_enabled);
        formatter.field("fleet_type", &self.fleet_type);
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("instances", &self.instances);
        formatter.field("availability", &self.availability);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) manufacturer: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) form_factor: std::option::Option<crate::model::DeviceFormFactor>,
        pub(crate) platform: std::option::Option<crate::model::DevicePlatform>,
        pub(crate) os: std::option::Option<std::string::String>,
        pub(crate) cpu: std::option::Option<crate::model::Cpu>,
        pub(crate) resolution: std::option::Option<crate::model::Resolution>,
        pub(crate) heap_size: std::option::Option<i64>,
        pub(crate) memory: std::option::Option<i64>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) carrier: std::option::Option<std::string::String>,
        pub(crate) radio: std::option::Option<std::string::String>,
        pub(crate) remote_access_enabled: std::option::Option<bool>,
        pub(crate) remote_debug_enabled: std::option::Option<bool>,
        pub(crate) fleet_type: std::option::Option<std::string::String>,
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::DeviceInstance>>,
        pub(crate) availability: std::option::Option<crate::model::DeviceAvailability>,
    }
    impl Builder {
        /// <p>The device's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The device's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The device's display name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The device's display name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The device's manufacturer name.</p>
        pub fn manufacturer(mut self, input: impl Into<std::string::String>) -> Self {
            self.manufacturer = Some(input.into());
            self
        }
        /// <p>The device's manufacturer name.</p>
        pub fn set_manufacturer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.manufacturer = input;
            self
        }
        /// <p>The device's model name.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The device's model name.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The device's model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The device's model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The device's form factor.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PHONE</p>
        /// </li>
        /// <li>
        /// <p>TABLET</p>
        /// </li>
        /// </ul>
        pub fn form_factor(mut self, input: crate::model::DeviceFormFactor) -> Self {
            self.form_factor = Some(input);
            self
        }
        /// <p>The device's form factor.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PHONE</p>
        /// </li>
        /// <li>
        /// <p>TABLET</p>
        /// </li>
        /// </ul>
        pub fn set_form_factor(
            mut self,
            input: std::option::Option<crate::model::DeviceFormFactor>,
        ) -> Self {
            self.form_factor = input;
            self
        }
        /// <p>The device's platform.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID</p>
        /// </li>
        /// <li>
        /// <p>IOS</p>
        /// </li>
        /// </ul>
        pub fn platform(mut self, input: crate::model::DevicePlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The device's platform.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID</p>
        /// </li>
        /// <li>
        /// <p>IOS</p>
        /// </li>
        /// </ul>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::DevicePlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>The device's operating system type.</p>
        pub fn os(mut self, input: impl Into<std::string::String>) -> Self {
            self.os = Some(input.into());
            self
        }
        /// <p>The device's operating system type.</p>
        pub fn set_os(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os = input;
            self
        }
        /// <p>Information about the device's CPU.</p>
        pub fn cpu(mut self, input: crate::model::Cpu) -> Self {
            self.cpu = Some(input);
            self
        }
        /// <p>Information about the device's CPU.</p>
        pub fn set_cpu(mut self, input: std::option::Option<crate::model::Cpu>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The resolution of the device.</p>
        pub fn resolution(mut self, input: crate::model::Resolution) -> Self {
            self.resolution = Some(input);
            self
        }
        /// <p>The resolution of the device.</p>
        pub fn set_resolution(
            mut self,
            input: std::option::Option<crate::model::Resolution>,
        ) -> Self {
            self.resolution = input;
            self
        }
        /// <p>The device's heap size, expressed in bytes.</p>
        pub fn heap_size(mut self, input: i64) -> Self {
            self.heap_size = Some(input);
            self
        }
        /// <p>The device's heap size, expressed in bytes.</p>
        pub fn set_heap_size(mut self, input: std::option::Option<i64>) -> Self {
            self.heap_size = input;
            self
        }
        /// <p>The device's total memory size, expressed in bytes.</p>
        pub fn memory(mut self, input: i64) -> Self {
            self.memory = Some(input);
            self
        }
        /// <p>The device's total memory size, expressed in bytes.</p>
        pub fn set_memory(mut self, input: std::option::Option<i64>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The device's image name.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The device's image name.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>The device's carrier.</p>
        pub fn carrier(mut self, input: impl Into<std::string::String>) -> Self {
            self.carrier = Some(input.into());
            self
        }
        /// <p>The device's carrier.</p>
        pub fn set_carrier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.carrier = input;
            self
        }
        /// <p>The device's radio.</p>
        pub fn radio(mut self, input: impl Into<std::string::String>) -> Self {
            self.radio = Some(input.into());
            self
        }
        /// <p>The device's radio.</p>
        pub fn set_radio(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.radio = input;
            self
        }
        /// <p>Specifies whether remote access has been enabled for the specified
        /// device.</p>
        pub fn remote_access_enabled(mut self, input: bool) -> Self {
            self.remote_access_enabled = Some(input);
            self
        }
        /// <p>Specifies whether remote access has been enabled for the specified
        /// device.</p>
        pub fn set_remote_access_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_access_enabled = input;
            self
        }
        /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the
        /// device.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn remote_debug_enabled(mut self, input: bool) -> Self {
            self.remote_debug_enabled = Some(input);
            self
        }
        /// <p>This flag is set to <code>true</code> if remote debugging is enabled for the
        /// device.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_remote_debug_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.remote_debug_enabled = input;
            self
        }
        /// <p>The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.</p>
        pub fn fleet_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_type = Some(input.into());
            self
        }
        /// <p>The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.</p>
        pub fn set_fleet_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_type = input;
            self
        }
        /// <p>The name of the fleet to which this device belongs.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet to which this device belongs.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The instances that belong to this device.</p>
        pub fn instances(mut self, input: impl Into<crate::model::DeviceInstance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The instances that belong to this device.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceInstance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// <p>Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and GetDevice API methods.</p>
        pub fn availability(mut self, input: crate::model::DeviceAvailability) -> Self {
            self.availability = Some(input);
            self
        }
        /// <p>Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and GetDevice API methods.</p>
        pub fn set_availability(
            mut self,
            input: std::option::Option<crate::model::DeviceAvailability>,
        ) -> Self {
            self.availability = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                arn: self.arn,
                name: self.name,
                manufacturer: self.manufacturer,
                model: self.model,
                model_id: self.model_id,
                form_factor: self.form_factor,
                platform: self.platform,
                os: self.os,
                cpu: self.cpu,
                resolution: self.resolution,
                heap_size: self.heap_size,
                memory: self.memory,
                image: self.image,
                carrier: self.carrier,
                radio: self.radio,
                remote_access_enabled: self.remote_access_enabled,
                remote_debug_enabled: self.remote_debug_enabled,
                fleet_type: self.fleet_type,
                fleet_name: self.fleet_name,
                instances: self.instances,
                availability: self.availability,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceAvailability {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Busy,
    #[allow(missing_docs)] // documentation missing in model
    HighlyAvailable,
    #[allow(missing_docs)] // documentation missing in model
    TemporaryNotAvailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceAvailability {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DeviceAvailability::Available,
            "BUSY" => DeviceAvailability::Busy,
            "HIGHLY_AVAILABLE" => DeviceAvailability::HighlyAvailable,
            "TEMPORARY_NOT_AVAILABLE" => DeviceAvailability::TemporaryNotAvailable,
            other => DeviceAvailability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceAvailability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceAvailability::from(s))
    }
}
impl DeviceAvailability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceAvailability::Available => "AVAILABLE",
            DeviceAvailability::Busy => "BUSY",
            DeviceAvailability::HighlyAvailable => "HIGHLY_AVAILABLE",
            DeviceAvailability::TemporaryNotAvailable => "TEMPORARY_NOT_AVAILABLE",
            DeviceAvailability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "BUSY",
            "HIGHLY_AVAILABLE",
            "TEMPORARY_NOT_AVAILABLE",
        ]
    }
}
impl AsRef<str> for DeviceAvailability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the screen resolution of a device in height and width, expressed in
/// pixels.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resolution {
    /// <p>The screen resolution's width, expressed in pixels.</p>
    pub width: std::option::Option<i32>,
    /// <p>The screen resolution's height, expressed in pixels.</p>
    pub height: std::option::Option<i32>,
}
impl Resolution {
    /// <p>The screen resolution's width, expressed in pixels.</p>
    pub fn width(&self) -> std::option::Option<i32> {
        self.width
    }
    /// <p>The screen resolution's height, expressed in pixels.</p>
    pub fn height(&self) -> std::option::Option<i32> {
        self.height
    }
}
impl std::fmt::Debug for Resolution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resolution");
        formatter.field("width", &self.width);
        formatter.field("height", &self.height);
        formatter.finish()
    }
}
/// See [`Resolution`](crate::model::Resolution)
pub mod resolution {
    /// A builder for [`Resolution`](crate::model::Resolution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) width: std::option::Option<i32>,
        pub(crate) height: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The screen resolution's width, expressed in pixels.</p>
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// <p>The screen resolution's width, expressed in pixels.</p>
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// <p>The screen resolution's height, expressed in pixels.</p>
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// <p>The screen resolution's height, expressed in pixels.</p>
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// Consumes the builder and constructs a [`Resolution`](crate::model::Resolution)
        pub fn build(self) -> crate::model::Resolution {
            crate::model::Resolution {
                width: self.width,
                height: self.height,
            }
        }
    }
}
impl Resolution {
    /// Creates a new builder-style object to manufacture [`Resolution`](crate::model::Resolution)
    pub fn builder() -> crate::model::resolution::Builder {
        crate::model::resolution::Builder::default()
    }
}

/// <p>Represents the amount of CPU that an app is using on a physical device. Does not represent system-wide
/// CPU usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cpu {
    /// <p>The CPU's frequency.</p>
    pub frequency: std::option::Option<std::string::String>,
    /// <p>The CPU's architecture (for example, x86 or ARM).</p>
    pub architecture: std::option::Option<std::string::String>,
    /// <p>The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2
    /// GHz CPU is expressed as 1200000000.</p>
    pub clock: std::option::Option<f64>,
}
impl Cpu {
    /// <p>The CPU's frequency.</p>
    pub fn frequency(&self) -> std::option::Option<&str> {
        self.frequency.as_deref()
    }
    /// <p>The CPU's architecture (for example, x86 or ARM).</p>
    pub fn architecture(&self) -> std::option::Option<&str> {
        self.architecture.as_deref()
    }
    /// <p>The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2
    /// GHz CPU is expressed as 1200000000.</p>
    pub fn clock(&self) -> std::option::Option<f64> {
        self.clock
    }
}
impl std::fmt::Debug for Cpu {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cpu");
        formatter.field("frequency", &self.frequency);
        formatter.field("architecture", &self.architecture);
        formatter.field("clock", &self.clock);
        formatter.finish()
    }
}
/// See [`Cpu`](crate::model::Cpu)
pub mod cpu {
    /// A builder for [`Cpu`](crate::model::Cpu)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frequency: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::string::String>,
        pub(crate) clock: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The CPU's frequency.</p>
        pub fn frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.frequency = Some(input.into());
            self
        }
        /// <p>The CPU's frequency.</p>
        pub fn set_frequency(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The CPU's architecture (for example, x86 or ARM).</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.architecture = Some(input.into());
            self
        }
        /// <p>The CPU's architecture (for example, x86 or ARM).</p>
        pub fn set_architecture(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2
        /// GHz CPU is expressed as 1200000000.</p>
        pub fn clock(mut self, input: f64) -> Self {
            self.clock = Some(input);
            self
        }
        /// <p>The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2
        /// GHz CPU is expressed as 1200000000.</p>
        pub fn set_clock(mut self, input: std::option::Option<f64>) -> Self {
            self.clock = input;
            self
        }
        /// Consumes the builder and constructs a [`Cpu`](crate::model::Cpu)
        pub fn build(self) -> crate::model::Cpu {
            crate::model::Cpu {
                frequency: self.frequency,
                architecture: self.architecture,
                clock: self.clock,
            }
        }
    }
}
impl Cpu {
    /// Creates a new builder-style object to manufacture [`Cpu`](crate::model::Cpu)
    pub fn builder() -> crate::model::cpu::Builder {
        crate::model::cpu::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceFormFactor {
    #[allow(missing_docs)] // documentation missing in model
    Phone,
    #[allow(missing_docs)] // documentation missing in model
    Tablet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceFormFactor {
    fn from(s: &str) -> Self {
        match s {
            "PHONE" => DeviceFormFactor::Phone,
            "TABLET" => DeviceFormFactor::Tablet,
            other => DeviceFormFactor::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceFormFactor {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceFormFactor::from(s))
    }
}
impl DeviceFormFactor {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceFormFactor::Phone => "PHONE",
            DeviceFormFactor::Tablet => "TABLET",
            DeviceFormFactor::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PHONE", "TABLET"]
    }
}
impl AsRef<str> for DeviceFormFactor {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The job's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The job's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The job's type.</p>
    /// <p>Allowed values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with
    /// it and capturing screenshots at the same time.</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TestType>,
    /// <p>When the job was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The job's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The job's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub result: std::option::Option<crate::model::ExecutionResult>,
    /// <p>The job's start time.</p>
    pub started: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The job's stop time.</p>
    pub stopped: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The job's result counters.</p>
    pub counters: std::option::Option<crate::model::Counters>,
    /// <p>A message about the job's result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The device (phone or tablet).</p>
    pub device: std::option::Option<crate::model::Device>,
    /// <p>The ARN of the instance.</p>
    pub instance_arn: std::option::Option<std::string::String>,
    /// <p>Represents the total (metered or unmetered) minutes used by the job.</p>
    pub device_minutes: std::option::Option<crate::model::DeviceMinutes>,
    /// <p>The endpoint for streaming device video.</p>
    pub video_endpoint: std::option::Option<std::string::String>,
    /// <p>This value is set to true if video capture is enabled. Otherwise, it is set to false.</p>
    pub video_capture: std::option::Option<bool>,
}
impl Job {
    /// <p>The job's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The job's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The job's type.</p>
    /// <p>Allowed values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with
    /// it and capturing screenshots at the same time.</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestType> {
        self.r#type.as_ref()
    }
    /// <p>When the job was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The job's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The job's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub fn result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.result.as_ref()
    }
    /// <p>The job's start time.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started.as_ref()
    }
    /// <p>The job's stop time.</p>
    pub fn stopped(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stopped.as_ref()
    }
    /// <p>The job's result counters.</p>
    pub fn counters(&self) -> std::option::Option<&crate::model::Counters> {
        self.counters.as_ref()
    }
    /// <p>A message about the job's result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The device (phone or tablet).</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
    /// <p>The ARN of the instance.</p>
    pub fn instance_arn(&self) -> std::option::Option<&str> {
        self.instance_arn.as_deref()
    }
    /// <p>Represents the total (metered or unmetered) minutes used by the job.</p>
    pub fn device_minutes(&self) -> std::option::Option<&crate::model::DeviceMinutes> {
        self.device_minutes.as_ref()
    }
    /// <p>The endpoint for streaming device video.</p>
    pub fn video_endpoint(&self) -> std::option::Option<&str> {
        self.video_endpoint.as_deref()
    }
    /// <p>This value is set to true if video capture is enabled. Otherwise, it is set to false.</p>
    pub fn video_capture(&self) -> std::option::Option<bool> {
        self.video_capture
    }
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("created", &self.created);
        formatter.field("status", &self.status);
        formatter.field("result", &self.result);
        formatter.field("started", &self.started);
        formatter.field("stopped", &self.stopped);
        formatter.field("counters", &self.counters);
        formatter.field("message", &self.message);
        formatter.field("device", &self.device);
        formatter.field("instance_arn", &self.instance_arn);
        formatter.field("device_minutes", &self.device_minutes);
        formatter.field("video_endpoint", &self.video_endpoint);
        formatter.field("video_capture", &self.video_capture);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TestType>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) started: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) counters: std::option::Option<crate::model::Counters>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) device: std::option::Option<crate::model::Device>,
        pub(crate) instance_arn: std::option::Option<std::string::String>,
        pub(crate) device_minutes: std::option::Option<crate::model::DeviceMinutes>,
        pub(crate) video_endpoint: std::option::Option<std::string::String>,
        pub(crate) video_capture: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The job's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The job's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The job's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The job's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The job's type.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with
        /// it and capturing screenshots at the same time.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The job's type.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with
        /// it and capturing screenshots at the same time.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>When the job was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the job was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The job's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The job's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The job's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>The job's start time.</p>
        pub fn started(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The job's start time.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The job's stop time.</p>
        pub fn stopped(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The job's stop time.</p>
        pub fn set_stopped(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The job's result counters.</p>
        pub fn counters(mut self, input: crate::model::Counters) -> Self {
            self.counters = Some(input);
            self
        }
        /// <p>The job's result counters.</p>
        pub fn set_counters(mut self, input: std::option::Option<crate::model::Counters>) -> Self {
            self.counters = input;
            self
        }
        /// <p>A message about the job's result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the job's result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The device (phone or tablet).</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>The device (phone or tablet).</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// <p>The ARN of the instance.</p>
        pub fn instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the instance.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_arn = input;
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the job.</p>
        pub fn device_minutes(mut self, input: crate::model::DeviceMinutes) -> Self {
            self.device_minutes = Some(input);
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the job.</p>
        pub fn set_device_minutes(
            mut self,
            input: std::option::Option<crate::model::DeviceMinutes>,
        ) -> Self {
            self.device_minutes = input;
            self
        }
        /// <p>The endpoint for streaming device video.</p>
        pub fn video_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint for streaming device video.</p>
        pub fn set_video_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.video_endpoint = input;
            self
        }
        /// <p>This value is set to true if video capture is enabled. Otherwise, it is set to false.</p>
        pub fn video_capture(mut self, input: bool) -> Self {
            self.video_capture = Some(input);
            self
        }
        /// <p>This value is set to true if video capture is enabled. Otherwise, it is set to false.</p>
        pub fn set_video_capture(mut self, input: std::option::Option<bool>) -> Self {
            self.video_capture = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                created: self.created,
                status: self.status,
                result: self.result,
                started: self.started,
                stopped: self.stopped,
                counters: self.counters,
                message: self.message,
                device: self.device,
                instance_arn: self.instance_arn,
                device_minutes: self.device_minutes,
                video_endpoint: self.video_endpoint,
                video_capture: self.video_capture,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>Represents configuration information about a test run, such as the execution
/// timeout (in minutes).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionConfiguration {
    /// <p>The number of minutes a test run executes before it times out.</p>
    pub job_timeout_minutes: std::option::Option<i32>,
    /// <p>True if account cleanup is enabled at the beginning of the test. Otherwise, false.</p>
    pub accounts_cleanup: std::option::Option<bool>,
    /// <p>True if app package cleanup is enabled at the beginning of the test. Otherwise, false.</p>
    pub app_packages_cleanup: std::option::Option<bool>,
    /// <p>Set to true to enable video capture. Otherwise, set to false. The default is true.</p>
    pub video_capture: std::option::Option<bool>,
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub skip_app_resign: std::option::Option<bool>,
}
impl ExecutionConfiguration {
    /// <p>The number of minutes a test run executes before it times out.</p>
    pub fn job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.job_timeout_minutes
    }
    /// <p>True if account cleanup is enabled at the beginning of the test. Otherwise, false.</p>
    pub fn accounts_cleanup(&self) -> std::option::Option<bool> {
        self.accounts_cleanup
    }
    /// <p>True if app package cleanup is enabled at the beginning of the test. Otherwise, false.</p>
    pub fn app_packages_cleanup(&self) -> std::option::Option<bool> {
        self.app_packages_cleanup
    }
    /// <p>Set to true to enable video capture. Otherwise, set to false. The default is true.</p>
    pub fn video_capture(&self) -> std::option::Option<bool> {
        self.video_capture
    }
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub fn skip_app_resign(&self) -> std::option::Option<bool> {
        self.skip_app_resign
    }
}
impl std::fmt::Debug for ExecutionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionConfiguration");
        formatter.field("job_timeout_minutes", &self.job_timeout_minutes);
        formatter.field("accounts_cleanup", &self.accounts_cleanup);
        formatter.field("app_packages_cleanup", &self.app_packages_cleanup);
        formatter.field("video_capture", &self.video_capture);
        formatter.field("skip_app_resign", &self.skip_app_resign);
        formatter.finish()
    }
}
/// See [`ExecutionConfiguration`](crate::model::ExecutionConfiguration)
pub mod execution_configuration {
    /// A builder for [`ExecutionConfiguration`](crate::model::ExecutionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_timeout_minutes: std::option::Option<i32>,
        pub(crate) accounts_cleanup: std::option::Option<bool>,
        pub(crate) app_packages_cleanup: std::option::Option<bool>,
        pub(crate) video_capture: std::option::Option<bool>,
        pub(crate) skip_app_resign: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The number of minutes a test run executes before it times out.</p>
        pub fn job_timeout_minutes(mut self, input: i32) -> Self {
            self.job_timeout_minutes = Some(input);
            self
        }
        /// <p>The number of minutes a test run executes before it times out.</p>
        pub fn set_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.job_timeout_minutes = input;
            self
        }
        /// <p>True if account cleanup is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn accounts_cleanup(mut self, input: bool) -> Self {
            self.accounts_cleanup = Some(input);
            self
        }
        /// <p>True if account cleanup is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn set_accounts_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.accounts_cleanup = input;
            self
        }
        /// <p>True if app package cleanup is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn app_packages_cleanup(mut self, input: bool) -> Self {
            self.app_packages_cleanup = Some(input);
            self
        }
        /// <p>True if app package cleanup is enabled at the beginning of the test. Otherwise, false.</p>
        pub fn set_app_packages_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.app_packages_cleanup = input;
            self
        }
        /// <p>Set to true to enable video capture. Otherwise, set to false. The default is true.</p>
        pub fn video_capture(mut self, input: bool) -> Self {
            self.video_capture = Some(input);
            self
        }
        /// <p>Set to true to enable video capture. Otherwise, set to false. The default is true.</p>
        pub fn set_video_capture(mut self, input: std::option::Option<bool>) -> Self {
            self.video_capture = input;
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn skip_app_resign(mut self, input: bool) -> Self {
            self.skip_app_resign = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn set_skip_app_resign(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_app_resign = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionConfiguration`](crate::model::ExecutionConfiguration)
        pub fn build(self) -> crate::model::ExecutionConfiguration {
            crate::model::ExecutionConfiguration {
                job_timeout_minutes: self.job_timeout_minutes,
                accounts_cleanup: self.accounts_cleanup,
                app_packages_cleanup: self.app_packages_cleanup,
                video_capture: self.video_capture,
                skip_app_resign: self.skip_app_resign,
            }
        }
    }
}
impl ExecutionConfiguration {
    /// Creates a new builder-style object to manufacture [`ExecutionConfiguration`](crate::model::ExecutionConfiguration)
    pub fn builder() -> crate::model::execution_configuration::Builder {
        crate::model::execution_configuration::Builder::default()
    }
}

/// <p>Represents the settings for a run. Includes things like location, radio states,
/// auxiliary apps, and network profiles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleRunConfiguration {
    /// <p>The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
    /// external data for Android or the app's sandbox for iOS.</p>
    pub extra_data_package_arn: std::option::Option<std::string::String>,
    /// <p>Reserved for internal use.</p>
    pub network_profile_arn: std::option::Option<std::string::String>,
    /// <p>Information about the locale that is used for the run.</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>Information about the location that is used for the run.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>An array of ARNs for your VPC endpoint configurations.</p>
    pub vpce_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Input <code>CustomerArtifactPaths</code> object for the scheduled run
    /// configuration.</p>
    pub customer_artifact_paths: std::option::Option<crate::model::CustomerArtifactPaths>,
    /// <p>Information about the radio states for the run.</p>
    pub radios: std::option::Option<crate::model::Radios>,
    /// <p>A list of upload ARNs for app packages to be installed with your app.</p>
    pub auxiliary_apps: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the billing method for a test run: <code>metered</code> or
    /// <code>unmetered</code>. If the parameter is not specified, the default value is
    /// <code>metered</code>.</p>
    /// <note>
    /// <p>If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
    /// make use of them. Otherwise, your run counts against your metered time.</p>
    /// </note>
    pub billing_method: std::option::Option<crate::model::BillingMethod>,
}
impl ScheduleRunConfiguration {
    /// <p>The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
    /// external data for Android or the app's sandbox for iOS.</p>
    pub fn extra_data_package_arn(&self) -> std::option::Option<&str> {
        self.extra_data_package_arn.as_deref()
    }
    /// <p>Reserved for internal use.</p>
    pub fn network_profile_arn(&self) -> std::option::Option<&str> {
        self.network_profile_arn.as_deref()
    }
    /// <p>Information about the locale that is used for the run.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
    /// <p>Information about the location that is used for the run.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>An array of ARNs for your VPC endpoint configurations.</p>
    pub fn vpce_configuration_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.vpce_configuration_arns.as_deref()
    }
    /// <p>Input <code>CustomerArtifactPaths</code> object for the scheduled run
    /// configuration.</p>
    pub fn customer_artifact_paths(
        &self,
    ) -> std::option::Option<&crate::model::CustomerArtifactPaths> {
        self.customer_artifact_paths.as_ref()
    }
    /// <p>Information about the radio states for the run.</p>
    pub fn radios(&self) -> std::option::Option<&crate::model::Radios> {
        self.radios.as_ref()
    }
    /// <p>A list of upload ARNs for app packages to be installed with your app.</p>
    pub fn auxiliary_apps(&self) -> std::option::Option<&[std::string::String]> {
        self.auxiliary_apps.as_deref()
    }
    /// <p>Specifies the billing method for a test run: <code>metered</code> or
    /// <code>unmetered</code>. If the parameter is not specified, the default value is
    /// <code>metered</code>.</p>
    /// <note>
    /// <p>If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
    /// make use of them. Otherwise, your run counts against your metered time.</p>
    /// </note>
    pub fn billing_method(&self) -> std::option::Option<&crate::model::BillingMethod> {
        self.billing_method.as_ref()
    }
}
impl std::fmt::Debug for ScheduleRunConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleRunConfiguration");
        formatter.field("extra_data_package_arn", &self.extra_data_package_arn);
        formatter.field("network_profile_arn", &self.network_profile_arn);
        formatter.field("locale", &self.locale);
        formatter.field("location", &self.location);
        formatter.field("vpce_configuration_arns", &self.vpce_configuration_arns);
        formatter.field("customer_artifact_paths", &self.customer_artifact_paths);
        formatter.field("radios", &self.radios);
        formatter.field("auxiliary_apps", &self.auxiliary_apps);
        formatter.field("billing_method", &self.billing_method);
        formatter.finish()
    }
}
/// See [`ScheduleRunConfiguration`](crate::model::ScheduleRunConfiguration)
pub mod schedule_run_configuration {
    /// A builder for [`ScheduleRunConfiguration`](crate::model::ScheduleRunConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extra_data_package_arn: std::option::Option<std::string::String>,
        pub(crate) network_profile_arn: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) vpce_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) customer_artifact_paths:
            std::option::Option<crate::model::CustomerArtifactPaths>,
        pub(crate) radios: std::option::Option<crate::model::Radios>,
        pub(crate) auxiliary_apps: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) billing_method: std::option::Option<crate::model::BillingMethod>,
    }
    impl Builder {
        /// <p>The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
        /// external data for Android or the app's sandbox for iOS.</p>
        pub fn extra_data_package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_data_package_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
        /// external data for Android or the app's sandbox for iOS.</p>
        pub fn set_extra_data_package_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_data_package_arn = input;
            self
        }
        /// <p>Reserved for internal use.</p>
        pub fn network_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_profile_arn = Some(input.into());
            self
        }
        /// <p>Reserved for internal use.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_profile_arn = input;
            self
        }
        /// <p>Information about the locale that is used for the run.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>Information about the locale that is used for the run.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Information about the location that is used for the run.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Information about the location that is used for the run.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// Appends an item to `vpce_configuration_arns`.
        ///
        /// To override the contents of this collection use [`set_vpce_configuration_arns`](Self::set_vpce_configuration_arns).
        ///
        /// <p>An array of ARNs for your VPC endpoint configurations.</p>
        pub fn vpce_configuration_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpce_configuration_arns.unwrap_or_default();
            v.push(input.into());
            self.vpce_configuration_arns = Some(v);
            self
        }
        /// <p>An array of ARNs for your VPC endpoint configurations.</p>
        pub fn set_vpce_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpce_configuration_arns = input;
            self
        }
        /// <p>Input <code>CustomerArtifactPaths</code> object for the scheduled run
        /// configuration.</p>
        pub fn customer_artifact_paths(
            mut self,
            input: crate::model::CustomerArtifactPaths,
        ) -> Self {
            self.customer_artifact_paths = Some(input);
            self
        }
        /// <p>Input <code>CustomerArtifactPaths</code> object for the scheduled run
        /// configuration.</p>
        pub fn set_customer_artifact_paths(
            mut self,
            input: std::option::Option<crate::model::CustomerArtifactPaths>,
        ) -> Self {
            self.customer_artifact_paths = input;
            self
        }
        /// <p>Information about the radio states for the run.</p>
        pub fn radios(mut self, input: crate::model::Radios) -> Self {
            self.radios = Some(input);
            self
        }
        /// <p>Information about the radio states for the run.</p>
        pub fn set_radios(mut self, input: std::option::Option<crate::model::Radios>) -> Self {
            self.radios = input;
            self
        }
        /// Appends an item to `auxiliary_apps`.
        ///
        /// To override the contents of this collection use [`set_auxiliary_apps`](Self::set_auxiliary_apps).
        ///
        /// <p>A list of upload ARNs for app packages to be installed with your app.</p>
        pub fn auxiliary_apps(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auxiliary_apps.unwrap_or_default();
            v.push(input.into());
            self.auxiliary_apps = Some(v);
            self
        }
        /// <p>A list of upload ARNs for app packages to be installed with your app.</p>
        pub fn set_auxiliary_apps(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auxiliary_apps = input;
            self
        }
        /// <p>Specifies the billing method for a test run: <code>metered</code> or
        /// <code>unmetered</code>. If the parameter is not specified, the default value is
        /// <code>metered</code>.</p>
        /// <note>
        /// <p>If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
        /// make use of them. Otherwise, your run counts against your metered time.</p>
        /// </note>
        pub fn billing_method(mut self, input: crate::model::BillingMethod) -> Self {
            self.billing_method = Some(input);
            self
        }
        /// <p>Specifies the billing method for a test run: <code>metered</code> or
        /// <code>unmetered</code>. If the parameter is not specified, the default value is
        /// <code>metered</code>.</p>
        /// <note>
        /// <p>If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
        /// make use of them. Otherwise, your run counts against your metered time.</p>
        /// </note>
        pub fn set_billing_method(
            mut self,
            input: std::option::Option<crate::model::BillingMethod>,
        ) -> Self {
            self.billing_method = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleRunConfiguration`](crate::model::ScheduleRunConfiguration)
        pub fn build(self) -> crate::model::ScheduleRunConfiguration {
            crate::model::ScheduleRunConfiguration {
                extra_data_package_arn: self.extra_data_package_arn,
                network_profile_arn: self.network_profile_arn,
                locale: self.locale,
                location: self.location,
                vpce_configuration_arns: self.vpce_configuration_arns,
                customer_artifact_paths: self.customer_artifact_paths,
                radios: self.radios,
                auxiliary_apps: self.auxiliary_apps,
                billing_method: self.billing_method,
            }
        }
    }
}
impl ScheduleRunConfiguration {
    /// Creates a new builder-style object to manufacture [`ScheduleRunConfiguration`](crate::model::ScheduleRunConfiguration)
    pub fn builder() -> crate::model::schedule_run_configuration::Builder {
        crate::model::schedule_run_configuration::Builder::default()
    }
}

/// <p>Represents test settings. This data structure is passed in as the test parameter to ScheduleRun. For an
/// example of the JSON request syntax, see <a>ScheduleRun</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleRunTest {
    /// <p>The test's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an
    /// Android app, interacting with it and capturing screenshots at the same
    /// time.</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TestType>,
    /// <p>The ARN of the uploaded test to be run.</p>
    pub test_package_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the YAML-formatted test specification.</p>
    pub test_spec_arn: std::option::Option<std::string::String>,
    /// <p>The test's filter.</p>
    pub filter: std::option::Option<std::string::String>,
    /// <p>The test's parameters, such as test framework parameters and fixture settings.
    /// Parameters are represented by name-value pairs of strings.</p>
    /// <p>For all tests:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>app_performance_monitoring</code>: Performance monitoring is enabled by default.
    /// Set this parameter to false to disable it.</p>
    /// </li>
    /// </ul>
    /// <p>For Calabash tests:</p>
    /// <ul>
    /// <li>
    /// <p>profile: A cucumber profile (for example, <code>my_profile_name</code>).</p>
    /// </li>
    /// <li>
    /// <p>tags: You can limit execution to features or scenarios that have (or don't
    /// have) certain tags (for example, @smoke or @smoke,~@wip).</p>
    /// </li>
    /// </ul>
    /// <p>For Appium tests (all types):</p>
    /// <ul>
    /// <li>
    /// <p>appium_version: The Appium version. Currently supported values are 1.6.5
    /// (and later), latest, and default.</p>
    /// <ul>
    /// <li>
    ///
    /// <p>latest runs the latest Appium version supported by Device
    /// Farm (1.9.1).</p>
    /// </li>
    /// <li>
    /// <p>For default, Device Farm selects a compatible version of
    /// Appium for the device. The current behavior is to run 1.7.2 on Android
    /// devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.</p>
    /// </li>
    /// <li>
    /// <p>This behavior is subject to change.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For fuzz tests (Android only):</p>
    /// <ul>
    /// <li>
    /// <p>event_count: The number of events, between 1 and 10000, that the UI fuzz
    /// test should perform.</p>
    /// </li>
    /// <li>
    /// <p>throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should
    /// wait between events.</p>
    /// </li>
    /// <li>
    /// <p>seed: A seed to use for randomizing the UI fuzz test. Using the same seed
    /// value between tests ensures identical event sequences.</p>
    /// </li>
    /// </ul>
    /// <p>For Explorer tests:</p>
    /// <ul>
    /// <li>
    /// <p>username: A user name to use if the Explorer encounters a login form. If not supplied, no user
    /// name is inserted.</p>
    /// </li>
    /// <li>
    /// <p>password: A password to use if the Explorer encounters a login form. If not supplied, no
    /// password is inserted.</p>
    /// </li>
    /// </ul>
    /// <p>For Instrumentation:</p>
    /// <ul>
    /// <li>
    /// <p>filter: A test filter string. Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Running a single test case: <code>com.android.abc.Test1</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running multiple tests:
    /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For XCTest and XCTestUI:</p>
    /// <ul>
    /// <li>
    /// <p>filter: A test filter string. Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Running a single test class: <code>LoginTests</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a multiple test classes: <code>LoginTests,SmokeTests</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a single test: <code>LoginTests/testValid</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running multiple tests:
    /// <code>LoginTests/testValid,LoginTests/testInvalid</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For UIAutomator:</p>
    /// <ul>
    /// <li>
    /// <p>filter: A test filter string. Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Running a single test case: <code>com.android.abc.Test1</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running multiple tests:
    /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ScheduleRunTest {
    /// <p>The test's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an
    /// Android app, interacting with it and capturing screenshots at the same
    /// time.</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestType> {
        self.r#type.as_ref()
    }
    /// <p>The ARN of the uploaded test to be run.</p>
    pub fn test_package_arn(&self) -> std::option::Option<&str> {
        self.test_package_arn.as_deref()
    }
    /// <p>The ARN of the YAML-formatted test specification.</p>
    pub fn test_spec_arn(&self) -> std::option::Option<&str> {
        self.test_spec_arn.as_deref()
    }
    /// <p>The test's filter.</p>
    pub fn filter(&self) -> std::option::Option<&str> {
        self.filter.as_deref()
    }
    /// <p>The test's parameters, such as test framework parameters and fixture settings.
    /// Parameters are represented by name-value pairs of strings.</p>
    /// <p>For all tests:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>app_performance_monitoring</code>: Performance monitoring is enabled by default.
    /// Set this parameter to false to disable it.</p>
    /// </li>
    /// </ul>
    /// <p>For Calabash tests:</p>
    /// <ul>
    /// <li>
    /// <p>profile: A cucumber profile (for example, <code>my_profile_name</code>).</p>
    /// </li>
    /// <li>
    /// <p>tags: You can limit execution to features or scenarios that have (or don't
    /// have) certain tags (for example, @smoke or @smoke,~@wip).</p>
    /// </li>
    /// </ul>
    /// <p>For Appium tests (all types):</p>
    /// <ul>
    /// <li>
    /// <p>appium_version: The Appium version. Currently supported values are 1.6.5
    /// (and later), latest, and default.</p>
    /// <ul>
    /// <li>
    ///
    /// <p>latest runs the latest Appium version supported by Device
    /// Farm (1.9.1).</p>
    /// </li>
    /// <li>
    /// <p>For default, Device Farm selects a compatible version of
    /// Appium for the device. The current behavior is to run 1.7.2 on Android
    /// devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.</p>
    /// </li>
    /// <li>
    /// <p>This behavior is subject to change.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For fuzz tests (Android only):</p>
    /// <ul>
    /// <li>
    /// <p>event_count: The number of events, between 1 and 10000, that the UI fuzz
    /// test should perform.</p>
    /// </li>
    /// <li>
    /// <p>throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should
    /// wait between events.</p>
    /// </li>
    /// <li>
    /// <p>seed: A seed to use for randomizing the UI fuzz test. Using the same seed
    /// value between tests ensures identical event sequences.</p>
    /// </li>
    /// </ul>
    /// <p>For Explorer tests:</p>
    /// <ul>
    /// <li>
    /// <p>username: A user name to use if the Explorer encounters a login form. If not supplied, no user
    /// name is inserted.</p>
    /// </li>
    /// <li>
    /// <p>password: A password to use if the Explorer encounters a login form. If not supplied, no
    /// password is inserted.</p>
    /// </li>
    /// </ul>
    /// <p>For Instrumentation:</p>
    /// <ul>
    /// <li>
    /// <p>filter: A test filter string. Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Running a single test case: <code>com.android.abc.Test1</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running multiple tests:
    /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For XCTest and XCTestUI:</p>
    /// <ul>
    /// <li>
    /// <p>filter: A test filter string. Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Running a single test class: <code>LoginTests</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a multiple test classes: <code>LoginTests,SmokeTests</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a single test: <code>LoginTests/testValid</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running multiple tests:
    /// <code>LoginTests/testValid,LoginTests/testInvalid</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For UIAutomator:</p>
    /// <ul>
    /// <li>
    /// <p>filter: A test filter string. Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Running a single test case: <code>com.android.abc.Test1</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Running multiple tests:
    /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
}
impl std::fmt::Debug for ScheduleRunTest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleRunTest");
        formatter.field("r#type", &self.r#type);
        formatter.field("test_package_arn", &self.test_package_arn);
        formatter.field("test_spec_arn", &self.test_spec_arn);
        formatter.field("filter", &self.filter);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`ScheduleRunTest`](crate::model::ScheduleRunTest)
pub mod schedule_run_test {
    /// A builder for [`ScheduleRunTest`](crate::model::ScheduleRunTest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::TestType>,
        pub(crate) test_package_arn: std::option::Option<std::string::String>,
        pub(crate) test_spec_arn: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The test's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an
        /// Android app, interacting with it and capturing screenshots at the same
        /// time.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The test's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an
        /// Android app, interacting with it and capturing screenshots at the same
        /// time.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ARN of the uploaded test to be run.</p>
        pub fn test_package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_package_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the uploaded test to be run.</p>
        pub fn set_test_package_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_package_arn = input;
            self
        }
        /// <p>The ARN of the YAML-formatted test specification.</p>
        pub fn test_spec_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_spec_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the YAML-formatted test specification.</p>
        pub fn set_test_spec_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_spec_arn = input;
            self
        }
        /// <p>The test's filter.</p>
        pub fn filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter = Some(input.into());
            self
        }
        /// <p>The test's filter.</p>
        pub fn set_filter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The test's parameters, such as test framework parameters and fixture settings.
        /// Parameters are represented by name-value pairs of strings.</p>
        /// <p>For all tests:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>app_performance_monitoring</code>: Performance monitoring is enabled by default.
        /// Set this parameter to false to disable it.</p>
        /// </li>
        /// </ul>
        /// <p>For Calabash tests:</p>
        /// <ul>
        /// <li>
        /// <p>profile: A cucumber profile (for example, <code>my_profile_name</code>).</p>
        /// </li>
        /// <li>
        /// <p>tags: You can limit execution to features or scenarios that have (or don't
        /// have) certain tags (for example, @smoke or @smoke,~@wip).</p>
        /// </li>
        /// </ul>
        /// <p>For Appium tests (all types):</p>
        /// <ul>
        /// <li>
        /// <p>appium_version: The Appium version. Currently supported values are 1.6.5
        /// (and later), latest, and default.</p>
        /// <ul>
        /// <li>
        ///
        /// <p>latest runs the latest Appium version supported by Device
        /// Farm (1.9.1).</p>
        /// </li>
        /// <li>
        /// <p>For default, Device Farm selects a compatible version of
        /// Appium for the device. The current behavior is to run 1.7.2 on Android
        /// devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.</p>
        /// </li>
        /// <li>
        /// <p>This behavior is subject to change.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For fuzz tests (Android only):</p>
        /// <ul>
        /// <li>
        /// <p>event_count: The number of events, between 1 and 10000, that the UI fuzz
        /// test should perform.</p>
        /// </li>
        /// <li>
        /// <p>throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should
        /// wait between events.</p>
        /// </li>
        /// <li>
        /// <p>seed: A seed to use for randomizing the UI fuzz test. Using the same seed
        /// value between tests ensures identical event sequences.</p>
        /// </li>
        /// </ul>
        /// <p>For Explorer tests:</p>
        /// <ul>
        /// <li>
        /// <p>username: A user name to use if the Explorer encounters a login form. If not supplied, no user
        /// name is inserted.</p>
        /// </li>
        /// <li>
        /// <p>password: A password to use if the Explorer encounters a login form. If not supplied, no
        /// password is inserted.</p>
        /// </li>
        /// </ul>
        /// <p>For Instrumentation:</p>
        /// <ul>
        /// <li>
        /// <p>filter: A test filter string. Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Running a single test case: <code>com.android.abc.Test1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running multiple tests:
        /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For XCTest and XCTestUI:</p>
        /// <ul>
        /// <li>
        /// <p>filter: A test filter string. Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Running a single test class: <code>LoginTests</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a multiple test classes: <code>LoginTests,SmokeTests</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a single test: <code>LoginTests/testValid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running multiple tests:
        /// <code>LoginTests/testValid,LoginTests/testInvalid</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For UIAutomator:</p>
        /// <ul>
        /// <li>
        /// <p>filter: A test filter string. Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Running a single test case: <code>com.android.abc.Test1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running multiple tests:
        /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The test's parameters, such as test framework parameters and fixture settings.
        /// Parameters are represented by name-value pairs of strings.</p>
        /// <p>For all tests:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>app_performance_monitoring</code>: Performance monitoring is enabled by default.
        /// Set this parameter to false to disable it.</p>
        /// </li>
        /// </ul>
        /// <p>For Calabash tests:</p>
        /// <ul>
        /// <li>
        /// <p>profile: A cucumber profile (for example, <code>my_profile_name</code>).</p>
        /// </li>
        /// <li>
        /// <p>tags: You can limit execution to features or scenarios that have (or don't
        /// have) certain tags (for example, @smoke or @smoke,~@wip).</p>
        /// </li>
        /// </ul>
        /// <p>For Appium tests (all types):</p>
        /// <ul>
        /// <li>
        /// <p>appium_version: The Appium version. Currently supported values are 1.6.5
        /// (and later), latest, and default.</p>
        /// <ul>
        /// <li>
        ///
        /// <p>latest runs the latest Appium version supported by Device
        /// Farm (1.9.1).</p>
        /// </li>
        /// <li>
        /// <p>For default, Device Farm selects a compatible version of
        /// Appium for the device. The current behavior is to run 1.7.2 on Android
        /// devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.</p>
        /// </li>
        /// <li>
        /// <p>This behavior is subject to change.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For fuzz tests (Android only):</p>
        /// <ul>
        /// <li>
        /// <p>event_count: The number of events, between 1 and 10000, that the UI fuzz
        /// test should perform.</p>
        /// </li>
        /// <li>
        /// <p>throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should
        /// wait between events.</p>
        /// </li>
        /// <li>
        /// <p>seed: A seed to use for randomizing the UI fuzz test. Using the same seed
        /// value between tests ensures identical event sequences.</p>
        /// </li>
        /// </ul>
        /// <p>For Explorer tests:</p>
        /// <ul>
        /// <li>
        /// <p>username: A user name to use if the Explorer encounters a login form. If not supplied, no user
        /// name is inserted.</p>
        /// </li>
        /// <li>
        /// <p>password: A password to use if the Explorer encounters a login form. If not supplied, no
        /// password is inserted.</p>
        /// </li>
        /// </ul>
        /// <p>For Instrumentation:</p>
        /// <ul>
        /// <li>
        /// <p>filter: A test filter string. Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Running a single test case: <code>com.android.abc.Test1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running multiple tests:
        /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For XCTest and XCTestUI:</p>
        /// <ul>
        /// <li>
        /// <p>filter: A test filter string. Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Running a single test class: <code>LoginTests</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a multiple test classes: <code>LoginTests,SmokeTests</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a single test: <code>LoginTests/testValid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running multiple tests:
        /// <code>LoginTests/testValid,LoginTests/testInvalid</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For UIAutomator:</p>
        /// <ul>
        /// <li>
        /// <p>filter: A test filter string. Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Running a single test case: <code>com.android.abc.Test1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running a single test: <code>com.android.abc.Test1#smoke</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Running multiple tests:
        /// <code>com.android.abc.Test1,com.android.abc.Test2</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleRunTest`](crate::model::ScheduleRunTest)
        pub fn build(self) -> crate::model::ScheduleRunTest {
            crate::model::ScheduleRunTest {
                r#type: self.r#type,
                test_package_arn: self.test_package_arn,
                test_spec_arn: self.test_spec_arn,
                filter: self.filter,
                parameters: self.parameters,
            }
        }
    }
}
impl ScheduleRunTest {
    /// Creates a new builder-style object to manufacture [`ScheduleRunTest`](crate::model::ScheduleRunTest)
    pub fn builder() -> crate::model::schedule_run_test::Builder {
        crate::model::schedule_run_test::Builder::default()
    }
}

/// <p>Represents the device filters used in a test run and the maximum number of devices to be included in the
/// run. It is passed in as the <code>deviceSelectionConfiguration</code> request parameter in <a>ScheduleRun</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceSelectionConfiguration {
    /// <p>Used to dynamically select a set of devices for a test run. A filter is made up of an
    /// attribute, an operator, and one or more values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Attribute</b>
    /// </p>
    /// <p>The aspect of a device such as platform or model used as the selection
    /// criteria in a device filter.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ARN: The Amazon Resource Name (ARN) of the device (for example,
    /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
    /// </li>
    /// <li>
    /// <p>PLATFORM: The device platform. Valid values are ANDROID or
    /// IOS.</p>
    /// </li>
    /// <li>
    /// <p>OS_VERSION: The operating system version (for example,
    /// 10.3.2).</p>
    /// </li>
    /// <li>
    /// <p>MODEL: The device model (for example, iPad 5th Gen).</p>
    /// </li>
    /// <li>
    /// <p>AVAILABILITY: The current availability of the device. Valid values
    /// are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
    /// TEMPORARY_NOT_AVAILABLE.</p>
    /// </li>
    /// <li>
    /// <p>FORM_FACTOR: The device form factor. Valid values are PHONE or
    /// TABLET.</p>
    /// </li>
    /// <li>
    /// <p>MANUFACTURER: The device manufacturer (for example,
    /// Apple).</p>
    /// </li>
    /// <li>
    /// <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
    /// access. Valid values are TRUE or FALSE.</p>
    /// </li>
    /// <li>
    /// <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values
    /// are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>, this filter is ignored.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
    /// instance.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_LABELS: The label of the device instance.</p>
    /// </li>
    /// <li>
    /// <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Operator</b>
    /// </p>
    /// <p>The filter operator.</p>
    /// <ul>
    /// <li>
    /// <p>The EQUALS operator is available for every attribute except
    /// INSTANCE_LABELS.</p>
    /// </li>
    /// <li>
    /// <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
    /// attributes.</p>
    /// </li>
    /// <li>
    /// <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION,
    /// MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p>
    /// </li>
    /// <li>
    /// <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
    /// GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
    /// attribute.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Values</b>
    /// </p>
    /// <p>An array of one or more filter values.</p>
    /// <p class="title">
    /// <b>Operator Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The IN and NOT_IN operators can take a values array that has more than
    /// one element.</p>
    /// </li>
    /// <li>
    /// <p>The other operators require an array with a single element.</p>
    /// </li>
    /// </ul>
    /// <p class="title">
    /// <b>Attribute Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
    /// </li>
    /// <li>
    /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
    /// TEMPORARY_NOT_AVAILABLE.</p>
    /// </li>
    /// <li>
    /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
    /// </li>
    /// <li>
    /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
    /// <p>The maximum number of devices to be included in a test run.</p>
    pub max_devices: std::option::Option<i32>,
}
impl DeviceSelectionConfiguration {
    /// <p>Used to dynamically select a set of devices for a test run. A filter is made up of an
    /// attribute, an operator, and one or more values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Attribute</b>
    /// </p>
    /// <p>The aspect of a device such as platform or model used as the selection
    /// criteria in a device filter.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ARN: The Amazon Resource Name (ARN) of the device (for example,
    /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
    /// </li>
    /// <li>
    /// <p>PLATFORM: The device platform. Valid values are ANDROID or
    /// IOS.</p>
    /// </li>
    /// <li>
    /// <p>OS_VERSION: The operating system version (for example,
    /// 10.3.2).</p>
    /// </li>
    /// <li>
    /// <p>MODEL: The device model (for example, iPad 5th Gen).</p>
    /// </li>
    /// <li>
    /// <p>AVAILABILITY: The current availability of the device. Valid values
    /// are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
    /// TEMPORARY_NOT_AVAILABLE.</p>
    /// </li>
    /// <li>
    /// <p>FORM_FACTOR: The device form factor. Valid values are PHONE or
    /// TABLET.</p>
    /// </li>
    /// <li>
    /// <p>MANUFACTURER: The device manufacturer (for example,
    /// Apple).</p>
    /// </li>
    /// <li>
    /// <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
    /// access. Valid values are TRUE or FALSE.</p>
    /// </li>
    /// <li>
    /// <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values
    /// are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
    /// longer supported</a>, this filter is ignored.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
    /// instance.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_LABELS: The label of the device instance.</p>
    /// </li>
    /// <li>
    /// <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Operator</b>
    /// </p>
    /// <p>The filter operator.</p>
    /// <ul>
    /// <li>
    /// <p>The EQUALS operator is available for every attribute except
    /// INSTANCE_LABELS.</p>
    /// </li>
    /// <li>
    /// <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
    /// attributes.</p>
    /// </li>
    /// <li>
    /// <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION,
    /// MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p>
    /// </li>
    /// <li>
    /// <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
    /// GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
    /// attribute.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Values</b>
    /// </p>
    /// <p>An array of one or more filter values.</p>
    /// <p class="title">
    /// <b>Operator Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The IN and NOT_IN operators can take a values array that has more than
    /// one element.</p>
    /// </li>
    /// <li>
    /// <p>The other operators require an array with a single element.</p>
    /// </li>
    /// </ul>
    /// <p class="title">
    /// <b>Attribute Values</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
    /// </li>
    /// <li>
    /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
    /// TEMPORARY_NOT_AVAILABLE.</p>
    /// </li>
    /// <li>
    /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
    /// </li>
    /// <li>
    /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::DeviceFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of devices to be included in a test run.</p>
    pub fn max_devices(&self) -> std::option::Option<i32> {
        self.max_devices
    }
}
impl std::fmt::Debug for DeviceSelectionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceSelectionConfiguration");
        formatter.field("filters", &self.filters);
        formatter.field("max_devices", &self.max_devices);
        formatter.finish()
    }
}
/// See [`DeviceSelectionConfiguration`](crate::model::DeviceSelectionConfiguration)
pub mod device_selection_configuration {
    /// A builder for [`DeviceSelectionConfiguration`](crate::model::DeviceSelectionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
        pub(crate) max_devices: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Used to dynamically select a set of devices for a test run. A filter is made up of an
        /// attribute, an operator, and one or more values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Attribute</b>
        /// </p>
        /// <p>The aspect of a device such as platform or model used as the selection
        /// criteria in a device filter.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ARN: The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM: The device platform. Valid values are ANDROID or
        /// IOS.</p>
        /// </li>
        /// <li>
        /// <p>OS_VERSION: The operating system version (for example,
        /// 10.3.2).</p>
        /// </li>
        /// <li>
        /// <p>MODEL: The device model (for example, iPad 5th Gen).</p>
        /// </li>
        /// <li>
        /// <p>AVAILABILITY: The current availability of the device. Valid values
        /// are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
        /// TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>FORM_FACTOR: The device form factor. Valid values are PHONE or
        /// TABLET.</p>
        /// </li>
        /// <li>
        /// <p>MANUFACTURER: The device manufacturer (for example,
        /// Apple).</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
        /// access. Valid values are TRUE or FALSE.</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values
        /// are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>, this filter is ignored.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
        /// instance.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_LABELS: The label of the device instance.</p>
        /// </li>
        /// <li>
        /// <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Operator</b>
        /// </p>
        /// <p>The filter operator.</p>
        /// <ul>
        /// <li>
        /// <p>The EQUALS operator is available for every attribute except
        /// INSTANCE_LABELS.</p>
        /// </li>
        /// <li>
        /// <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
        /// attributes.</p>
        /// </li>
        /// <li>
        /// <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION,
        /// MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p>
        /// </li>
        /// <li>
        /// <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
        /// GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
        /// attribute.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Values</b>
        /// </p>
        /// <p>An array of one or more filter values.</p>
        /// <p class="title">
        /// <b>Operator Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The IN and NOT_IN operators can take a values array that has more than
        /// one element.</p>
        /// </li>
        /// <li>
        /// <p>The other operators require an array with a single element.</p>
        /// </li>
        /// </ul>
        /// <p class="title">
        /// <b>Attribute Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
        /// </li>
        /// <li>
        /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
        /// TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
        /// </li>
        /// <li>
        /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::DeviceFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Used to dynamically select a set of devices for a test run. A filter is made up of an
        /// attribute, an operator, and one or more values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Attribute</b>
        /// </p>
        /// <p>The aspect of a device such as platform or model used as the selection
        /// criteria in a device filter.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ARN: The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM: The device platform. Valid values are ANDROID or
        /// IOS.</p>
        /// </li>
        /// <li>
        /// <p>OS_VERSION: The operating system version (for example,
        /// 10.3.2).</p>
        /// </li>
        /// <li>
        /// <p>MODEL: The device model (for example, iPad 5th Gen).</p>
        /// </li>
        /// <li>
        /// <p>AVAILABILITY: The current availability of the device. Valid values
        /// are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
        /// TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>FORM_FACTOR: The device form factor. Valid values are PHONE or
        /// TABLET.</p>
        /// </li>
        /// <li>
        /// <p>MANUFACTURER: The device manufacturer (for example,
        /// Apple).</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
        /// access. Valid values are TRUE or FALSE.</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values
        /// are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>, this filter is ignored.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
        /// instance.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_LABELS: The label of the device instance.</p>
        /// </li>
        /// <li>
        /// <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Operator</b>
        /// </p>
        /// <p>The filter operator.</p>
        /// <ul>
        /// <li>
        /// <p>The EQUALS operator is available for every attribute except
        /// INSTANCE_LABELS.</p>
        /// </li>
        /// <li>
        /// <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
        /// attributes.</p>
        /// </li>
        /// <li>
        /// <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION,
        /// MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p>
        /// </li>
        /// <li>
        /// <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
        /// GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
        /// attribute.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Values</b>
        /// </p>
        /// <p>An array of one or more filter values.</p>
        /// <p class="title">
        /// <b>Operator Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The IN and NOT_IN operators can take a values array that has more than
        /// one element.</p>
        /// </li>
        /// <li>
        /// <p>The other operators require an array with a single element.</p>
        /// </li>
        /// </ul>
        /// <p class="title">
        /// <b>Attribute Values</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The PLATFORM attribute can be set to ANDROID or IOS.</p>
        /// </li>
        /// <li>
        /// <p>The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
        /// TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>The FORM_FACTOR attribute can be set to PHONE or TABLET.</p>
        /// </li>
        /// <li>
        /// <p>The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of devices to be included in a test run.</p>
        pub fn max_devices(mut self, input: i32) -> Self {
            self.max_devices = Some(input);
            self
        }
        /// <p>The maximum number of devices to be included in a test run.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.max_devices = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceSelectionConfiguration`](crate::model::DeviceSelectionConfiguration)
        pub fn build(self) -> crate::model::DeviceSelectionConfiguration {
            crate::model::DeviceSelectionConfiguration {
                filters: self.filters,
                max_devices: self.max_devices,
            }
        }
    }
}
impl DeviceSelectionConfiguration {
    /// Creates a new builder-style object to manufacture [`DeviceSelectionConfiguration`](crate::model::DeviceSelectionConfiguration)
    pub fn builder() -> crate::model::device_selection_configuration::Builder {
        crate::model::device_selection_configuration::Builder::default()
    }
}

/// <p>Represents the metadata of an offering transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OfferingTransaction {
    /// <p>The status of an offering transaction.</p>
    pub offering_status: std::option::Option<crate::model::OfferingStatus>,
    /// <p>The transaction ID of the offering transaction.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>The ID that corresponds to a device offering promotion.</p>
    pub offering_promotion_id: std::option::Option<std::string::String>,
    /// <p>The date on which an offering transaction was created.</p>
    pub created_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The cost of an offering transaction.</p>
    pub cost: std::option::Option<crate::model::MonetaryAmount>,
}
impl OfferingTransaction {
    /// <p>The status of an offering transaction.</p>
    pub fn offering_status(&self) -> std::option::Option<&crate::model::OfferingStatus> {
        self.offering_status.as_ref()
    }
    /// <p>The transaction ID of the offering transaction.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>The ID that corresponds to a device offering promotion.</p>
    pub fn offering_promotion_id(&self) -> std::option::Option<&str> {
        self.offering_promotion_id.as_deref()
    }
    /// <p>The date on which an offering transaction was created.</p>
    pub fn created_on(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_on.as_ref()
    }
    /// <p>The cost of an offering transaction.</p>
    pub fn cost(&self) -> std::option::Option<&crate::model::MonetaryAmount> {
        self.cost.as_ref()
    }
}
impl std::fmt::Debug for OfferingTransaction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OfferingTransaction");
        formatter.field("offering_status", &self.offering_status);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("offering_promotion_id", &self.offering_promotion_id);
        formatter.field("created_on", &self.created_on);
        formatter.field("cost", &self.cost);
        formatter.finish()
    }
}
/// See [`OfferingTransaction`](crate::model::OfferingTransaction)
pub mod offering_transaction {
    /// A builder for [`OfferingTransaction`](crate::model::OfferingTransaction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_status: std::option::Option<crate::model::OfferingStatus>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) offering_promotion_id: std::option::Option<std::string::String>,
        pub(crate) created_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cost: std::option::Option<crate::model::MonetaryAmount>,
    }
    impl Builder {
        /// <p>The status of an offering transaction.</p>
        pub fn offering_status(mut self, input: crate::model::OfferingStatus) -> Self {
            self.offering_status = Some(input);
            self
        }
        /// <p>The status of an offering transaction.</p>
        pub fn set_offering_status(
            mut self,
            input: std::option::Option<crate::model::OfferingStatus>,
        ) -> Self {
            self.offering_status = input;
            self
        }
        /// <p>The transaction ID of the offering transaction.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction ID of the offering transaction.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>The ID that corresponds to a device offering promotion.</p>
        pub fn offering_promotion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_promotion_id = Some(input.into());
            self
        }
        /// <p>The ID that corresponds to a device offering promotion.</p>
        pub fn set_offering_promotion_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_promotion_id = input;
            self
        }
        /// <p>The date on which an offering transaction was created.</p>
        pub fn created_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_on = Some(input);
            self
        }
        /// <p>The date on which an offering transaction was created.</p>
        pub fn set_created_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_on = input;
            self
        }
        /// <p>The cost of an offering transaction.</p>
        pub fn cost(mut self, input: crate::model::MonetaryAmount) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The cost of an offering transaction.</p>
        pub fn set_cost(
            mut self,
            input: std::option::Option<crate::model::MonetaryAmount>,
        ) -> Self {
            self.cost = input;
            self
        }
        /// Consumes the builder and constructs a [`OfferingTransaction`](crate::model::OfferingTransaction)
        pub fn build(self) -> crate::model::OfferingTransaction {
            crate::model::OfferingTransaction {
                offering_status: self.offering_status,
                transaction_id: self.transaction_id,
                offering_promotion_id: self.offering_promotion_id,
                created_on: self.created_on,
                cost: self.cost,
            }
        }
    }
}
impl OfferingTransaction {
    /// Creates a new builder-style object to manufacture [`OfferingTransaction`](crate::model::OfferingTransaction)
    pub fn builder() -> crate::model::offering_transaction::Builder {
        crate::model::offering_transaction::Builder::default()
    }
}

/// <p>A number that represents the monetary amount for an offering or transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonetaryAmount {
    /// <p>The numerical amount of an offering or transaction.</p>
    pub amount: std::option::Option<f64>,
    /// <p>The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.</p>
    pub currency_code: std::option::Option<crate::model::CurrencyCode>,
}
impl MonetaryAmount {
    /// <p>The numerical amount of an offering or transaction.</p>
    pub fn amount(&self) -> std::option::Option<f64> {
        self.amount
    }
    /// <p>The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.</p>
    pub fn currency_code(&self) -> std::option::Option<&crate::model::CurrencyCode> {
        self.currency_code.as_ref()
    }
}
impl std::fmt::Debug for MonetaryAmount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonetaryAmount");
        formatter.field("amount", &self.amount);
        formatter.field("currency_code", &self.currency_code);
        formatter.finish()
    }
}
/// See [`MonetaryAmount`](crate::model::MonetaryAmount)
pub mod monetary_amount {
    /// A builder for [`MonetaryAmount`](crate::model::MonetaryAmount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amount: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<crate::model::CurrencyCode>,
    }
    impl Builder {
        /// <p>The numerical amount of an offering or transaction.</p>
        pub fn amount(mut self, input: f64) -> Self {
            self.amount = Some(input);
            self
        }
        /// <p>The numerical amount of an offering or transaction.</p>
        pub fn set_amount(mut self, input: std::option::Option<f64>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.</p>
        pub fn currency_code(mut self, input: crate::model::CurrencyCode) -> Self {
            self.currency_code = Some(input);
            self
        }
        /// <p>The currency code of a monetary amount. For example, <code>USD</code> means U.S. dollars.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<crate::model::CurrencyCode>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Consumes the builder and constructs a [`MonetaryAmount`](crate::model::MonetaryAmount)
        pub fn build(self) -> crate::model::MonetaryAmount {
            crate::model::MonetaryAmount {
                amount: self.amount,
                currency_code: self.currency_code,
            }
        }
    }
}
impl MonetaryAmount {
    /// Creates a new builder-style object to manufacture [`MonetaryAmount`](crate::model::MonetaryAmount)
    pub fn builder() -> crate::model::monetary_amount::Builder {
        crate::model::monetary_amount::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CurrencyCode {
    #[allow(missing_docs)] // documentation missing in model
    Usd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CurrencyCode {
    fn from(s: &str) -> Self {
        match s {
            "USD" => CurrencyCode::Usd,
            other => CurrencyCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CurrencyCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CurrencyCode::from(s))
    }
}
impl CurrencyCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CurrencyCode::Usd => "USD",
            CurrencyCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USD"]
    }
}
impl AsRef<str> for CurrencyCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OfferingStatus {
    /// <p>The type specified for the offering status.</p>
    pub r#type: std::option::Option<crate::model::OfferingTransactionType>,
    /// <p>Represents the metadata of an offering status.</p>
    pub offering: std::option::Option<crate::model::Offering>,
    /// <p>The number of available devices in the offering.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The date on which the offering is effective.</p>
    pub effective_on: std::option::Option<aws_smithy_types::Instant>,
}
impl OfferingStatus {
    /// <p>The type specified for the offering status.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OfferingTransactionType> {
        self.r#type.as_ref()
    }
    /// <p>Represents the metadata of an offering status.</p>
    pub fn offering(&self) -> std::option::Option<&crate::model::Offering> {
        self.offering.as_ref()
    }
    /// <p>The number of available devices in the offering.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The date on which the offering is effective.</p>
    pub fn effective_on(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.effective_on.as_ref()
    }
}
impl std::fmt::Debug for OfferingStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OfferingStatus");
        formatter.field("r#type", &self.r#type);
        formatter.field("offering", &self.offering);
        formatter.field("quantity", &self.quantity);
        formatter.field("effective_on", &self.effective_on);
        formatter.finish()
    }
}
/// See [`OfferingStatus`](crate::model::OfferingStatus)
pub mod offering_status {
    /// A builder for [`OfferingStatus`](crate::model::OfferingStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::OfferingTransactionType>,
        pub(crate) offering: std::option::Option<crate::model::Offering>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) effective_on: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type specified for the offering status.</p>
        pub fn r#type(mut self, input: crate::model::OfferingTransactionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type specified for the offering status.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OfferingTransactionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Represents the metadata of an offering status.</p>
        pub fn offering(mut self, input: crate::model::Offering) -> Self {
            self.offering = Some(input);
            self
        }
        /// <p>Represents the metadata of an offering status.</p>
        pub fn set_offering(mut self, input: std::option::Option<crate::model::Offering>) -> Self {
            self.offering = input;
            self
        }
        /// <p>The number of available devices in the offering.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of available devices in the offering.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// <p>The date on which the offering is effective.</p>
        pub fn effective_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.effective_on = Some(input);
            self
        }
        /// <p>The date on which the offering is effective.</p>
        pub fn set_effective_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.effective_on = input;
            self
        }
        /// Consumes the builder and constructs a [`OfferingStatus`](crate::model::OfferingStatus)
        pub fn build(self) -> crate::model::OfferingStatus {
            crate::model::OfferingStatus {
                r#type: self.r#type,
                offering: self.offering,
                quantity: self.quantity,
                effective_on: self.effective_on,
            }
        }
    }
}
impl OfferingStatus {
    /// Creates a new builder-style object to manufacture [`OfferingStatus`](crate::model::OfferingStatus)
    pub fn builder() -> crate::model::offering_status::Builder {
        crate::model::offering_status::Builder::default()
    }
}

/// <p>Represents the metadata of a device offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Offering {
    /// <p>The ID that corresponds to a device offering.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A string that describes the offering.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of offering (for example, <code>RECURRING</code>) for a device.</p>
    pub r#type: std::option::Option<crate::model::OfferingType>,
    /// <p>The platform of the device (for example, <code>ANDROID</code> or <code>IOS</code>).</p>
    pub platform: std::option::Option<crate::model::DevicePlatform>,
    /// <p>Specifies whether there are recurring charges for the offering.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
}
impl Offering {
    /// <p>The ID that corresponds to a device offering.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A string that describes the offering.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of offering (for example, <code>RECURRING</code>) for a device.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OfferingType> {
        self.r#type.as_ref()
    }
    /// <p>The platform of the device (for example, <code>ANDROID</code> or <code>IOS</code>).</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::DevicePlatform> {
        self.platform.as_ref()
    }
    /// <p>Specifies whether there are recurring charges for the offering.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
}
impl std::fmt::Debug for Offering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Offering");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("platform", &self.platform);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.finish()
    }
}
/// See [`Offering`](crate::model::Offering)
pub mod offering {
    /// A builder for [`Offering`](crate::model::Offering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::OfferingType>,
        pub(crate) platform: std::option::Option<crate::model::DevicePlatform>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    }
    impl Builder {
        /// <p>The ID that corresponds to a device offering.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that corresponds to a device offering.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A string that describes the offering.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string that describes the offering.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of offering (for example, <code>RECURRING</code>) for a device.</p>
        pub fn r#type(mut self, input: crate::model::OfferingType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of offering (for example, <code>RECURRING</code>) for a device.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OfferingType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The platform of the device (for example, <code>ANDROID</code> or <code>IOS</code>).</p>
        pub fn platform(mut self, input: crate::model::DevicePlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the device (for example, <code>ANDROID</code> or <code>IOS</code>).</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::DevicePlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>Specifies whether there are recurring charges for the offering.</p>
        pub fn recurring_charges(
            mut self,
            input: impl Into<crate::model::RecurringCharge>,
        ) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input.into());
            self.recurring_charges = Some(v);
            self
        }
        /// <p>Specifies whether there are recurring charges for the offering.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// Consumes the builder and constructs a [`Offering`](crate::model::Offering)
        pub fn build(self) -> crate::model::Offering {
            crate::model::Offering {
                id: self.id,
                description: self.description,
                r#type: self.r#type,
                platform: self.platform,
                recurring_charges: self.recurring_charges,
            }
        }
    }
}
impl Offering {
    /// Creates a new builder-style object to manufacture [`Offering`](crate::model::Offering)
    pub fn builder() -> crate::model::offering::Builder {
        crate::model::offering::Builder::default()
    }
}

/// <p>Specifies whether charges for devices are recurring.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecurringCharge {
    /// <p>The cost of the recurring charge.</p>
    pub cost: std::option::Option<crate::model::MonetaryAmount>,
    /// <p>The frequency in which charges recur.</p>
    pub frequency: std::option::Option<crate::model::RecurringChargeFrequency>,
}
impl RecurringCharge {
    /// <p>The cost of the recurring charge.</p>
    pub fn cost(&self) -> std::option::Option<&crate::model::MonetaryAmount> {
        self.cost.as_ref()
    }
    /// <p>The frequency in which charges recur.</p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::RecurringChargeFrequency> {
        self.frequency.as_ref()
    }
}
impl std::fmt::Debug for RecurringCharge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecurringCharge");
        formatter.field("cost", &self.cost);
        formatter.field("frequency", &self.frequency);
        formatter.finish()
    }
}
/// See [`RecurringCharge`](crate::model::RecurringCharge)
pub mod recurring_charge {
    /// A builder for [`RecurringCharge`](crate::model::RecurringCharge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost: std::option::Option<crate::model::MonetaryAmount>,
        pub(crate) frequency: std::option::Option<crate::model::RecurringChargeFrequency>,
    }
    impl Builder {
        /// <p>The cost of the recurring charge.</p>
        pub fn cost(mut self, input: crate::model::MonetaryAmount) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The cost of the recurring charge.</p>
        pub fn set_cost(
            mut self,
            input: std::option::Option<crate::model::MonetaryAmount>,
        ) -> Self {
            self.cost = input;
            self
        }
        /// <p>The frequency in which charges recur.</p>
        pub fn frequency(mut self, input: crate::model::RecurringChargeFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The frequency in which charges recur.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::RecurringChargeFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`RecurringCharge`](crate::model::RecurringCharge)
        pub fn build(self) -> crate::model::RecurringCharge {
            crate::model::RecurringCharge {
                cost: self.cost,
                frequency: self.frequency,
            }
        }
    }
}
impl RecurringCharge {
    /// Creates a new builder-style object to manufacture [`RecurringCharge`](crate::model::RecurringCharge)
    pub fn builder() -> crate::model::recurring_charge::Builder {
        crate::model::recurring_charge::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecurringChargeFrequency {
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecurringChargeFrequency {
    fn from(s: &str) -> Self {
        match s {
            "MONTHLY" => RecurringChargeFrequency::Monthly,
            other => RecurringChargeFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecurringChargeFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecurringChargeFrequency::from(s))
    }
}
impl RecurringChargeFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecurringChargeFrequency::Monthly => "MONTHLY",
            RecurringChargeFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MONTHLY"]
    }
}
impl AsRef<str> for RecurringChargeFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OfferingType {
    #[allow(missing_docs)] // documentation missing in model
    Recurring,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OfferingType {
    fn from(s: &str) -> Self {
        match s {
            "RECURRING" => OfferingType::Recurring,
            other => OfferingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OfferingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OfferingType::from(s))
    }
}
impl OfferingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OfferingType::Recurring => "RECURRING",
            OfferingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RECURRING"]
    }
}
impl AsRef<str> for OfferingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OfferingTransactionType {
    #[allow(missing_docs)] // documentation missing in model
    Purchase,
    #[allow(missing_docs)] // documentation missing in model
    Renew,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OfferingTransactionType {
    fn from(s: &str) -> Self {
        match s {
            "PURCHASE" => OfferingTransactionType::Purchase,
            "RENEW" => OfferingTransactionType::Renew,
            "SYSTEM" => OfferingTransactionType::System,
            other => OfferingTransactionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OfferingTransactionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OfferingTransactionType::from(s))
    }
}
impl OfferingTransactionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OfferingTransactionType::Purchase => "PURCHASE",
            OfferingTransactionType::Renew => "RENEW",
            OfferingTransactionType::System => "SYSTEM",
            OfferingTransactionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PURCHASE", "RENEW", "SYSTEM"]
    }
}
impl AsRef<str> for OfferingTransactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A collection of one or more problems, grouped by their result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UniqueProblem {
    /// <p>A message about the unique problems' result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Information about the problems.</p>
    pub problems: std::option::Option<std::vec::Vec<crate::model::Problem>>,
}
impl UniqueProblem {
    /// <p>A message about the unique problems' result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Information about the problems.</p>
    pub fn problems(&self) -> std::option::Option<&[crate::model::Problem]> {
        self.problems.as_deref()
    }
}
impl std::fmt::Debug for UniqueProblem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UniqueProblem");
        formatter.field("message", &self.message);
        formatter.field("problems", &self.problems);
        formatter.finish()
    }
}
/// See [`UniqueProblem`](crate::model::UniqueProblem)
pub mod unique_problem {
    /// A builder for [`UniqueProblem`](crate::model::UniqueProblem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) problems: std::option::Option<std::vec::Vec<crate::model::Problem>>,
    }
    impl Builder {
        /// <p>A message about the unique problems' result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the unique problems' result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `problems`.
        ///
        /// To override the contents of this collection use [`set_problems`](Self::set_problems).
        ///
        /// <p>Information about the problems.</p>
        pub fn problems(mut self, input: impl Into<crate::model::Problem>) -> Self {
            let mut v = self.problems.unwrap_or_default();
            v.push(input.into());
            self.problems = Some(v);
            self
        }
        /// <p>Information about the problems.</p>
        pub fn set_problems(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Problem>>,
        ) -> Self {
            self.problems = input;
            self
        }
        /// Consumes the builder and constructs a [`UniqueProblem`](crate::model::UniqueProblem)
        pub fn build(self) -> crate::model::UniqueProblem {
            crate::model::UniqueProblem {
                message: self.message,
                problems: self.problems,
            }
        }
    }
}
impl UniqueProblem {
    /// Creates a new builder-style object to manufacture [`UniqueProblem`](crate::model::UniqueProblem)
    pub fn builder() -> crate::model::unique_problem::Builder {
        crate::model::unique_problem::Builder::default()
    }
}

/// <p>Represents a specific warning or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Problem {
    /// <p>Information about the associated run.</p>
    pub run: std::option::Option<crate::model::ProblemDetail>,
    /// <p>Information about the associated job.</p>
    pub job: std::option::Option<crate::model::ProblemDetail>,
    /// <p>Information about the associated suite.</p>
    pub suite: std::option::Option<crate::model::ProblemDetail>,
    /// <p>Information about the associated test.</p>
    pub test: std::option::Option<crate::model::ProblemDetail>,
    /// <p>Information about the associated device.</p>
    pub device: std::option::Option<crate::model::Device>,
    /// <p>The problem's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub result: std::option::Option<crate::model::ExecutionResult>,
    /// <p>A message about the problem's result.</p>
    pub message: std::option::Option<std::string::String>,
}
impl Problem {
    /// <p>Information about the associated run.</p>
    pub fn run(&self) -> std::option::Option<&crate::model::ProblemDetail> {
        self.run.as_ref()
    }
    /// <p>Information about the associated job.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::ProblemDetail> {
        self.job.as_ref()
    }
    /// <p>Information about the associated suite.</p>
    pub fn suite(&self) -> std::option::Option<&crate::model::ProblemDetail> {
        self.suite.as_ref()
    }
    /// <p>Information about the associated test.</p>
    pub fn test(&self) -> std::option::Option<&crate::model::ProblemDetail> {
        self.test.as_ref()
    }
    /// <p>Information about the associated device.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
    /// <p>The problem's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub fn result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.result.as_ref()
    }
    /// <p>A message about the problem's result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for Problem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Problem");
        formatter.field("run", &self.run);
        formatter.field("job", &self.job);
        formatter.field("suite", &self.suite);
        formatter.field("test", &self.test);
        formatter.field("device", &self.device);
        formatter.field("result", &self.result);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`Problem`](crate::model::Problem)
pub mod problem {
    /// A builder for [`Problem`](crate::model::Problem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run: std::option::Option<crate::model::ProblemDetail>,
        pub(crate) job: std::option::Option<crate::model::ProblemDetail>,
        pub(crate) suite: std::option::Option<crate::model::ProblemDetail>,
        pub(crate) test: std::option::Option<crate::model::ProblemDetail>,
        pub(crate) device: std::option::Option<crate::model::Device>,
        pub(crate) result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the associated run.</p>
        pub fn run(mut self, input: crate::model::ProblemDetail) -> Self {
            self.run = Some(input);
            self
        }
        /// <p>Information about the associated run.</p>
        pub fn set_run(mut self, input: std::option::Option<crate::model::ProblemDetail>) -> Self {
            self.run = input;
            self
        }
        /// <p>Information about the associated job.</p>
        pub fn job(mut self, input: crate::model::ProblemDetail) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Information about the associated job.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::ProblemDetail>) -> Self {
            self.job = input;
            self
        }
        /// <p>Information about the associated suite.</p>
        pub fn suite(mut self, input: crate::model::ProblemDetail) -> Self {
            self.suite = Some(input);
            self
        }
        /// <p>Information about the associated suite.</p>
        pub fn set_suite(
            mut self,
            input: std::option::Option<crate::model::ProblemDetail>,
        ) -> Self {
            self.suite = input;
            self
        }
        /// <p>Information about the associated test.</p>
        pub fn test(mut self, input: crate::model::ProblemDetail) -> Self {
            self.test = Some(input);
            self
        }
        /// <p>Information about the associated test.</p>
        pub fn set_test(mut self, input: std::option::Option<crate::model::ProblemDetail>) -> Self {
            self.test = input;
            self
        }
        /// <p>Information about the associated device.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>Information about the associated device.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// <p>The problem's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The problem's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>A message about the problem's result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the problem's result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Problem`](crate::model::Problem)
        pub fn build(self) -> crate::model::Problem {
            crate::model::Problem {
                run: self.run,
                job: self.job,
                suite: self.suite,
                test: self.test,
                device: self.device,
                result: self.result,
                message: self.message,
            }
        }
    }
}
impl Problem {
    /// Creates a new builder-style object to manufacture [`Problem`](crate::model::Problem)
    pub fn builder() -> crate::model::problem::Builder {
        crate::model::problem::Builder::default()
    }
}

/// <p>Information about a problem detail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProblemDetail {
    /// <p>The problem detail's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The problem detail's name.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ProblemDetail {
    /// <p>The problem detail's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The problem detail's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ProblemDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProblemDetail");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ProblemDetail`](crate::model::ProblemDetail)
pub mod problem_detail {
    /// A builder for [`ProblemDetail`](crate::model::ProblemDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The problem detail's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The problem detail's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The problem detail's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The problem detail's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ProblemDetail`](crate::model::ProblemDetail)
        pub fn build(self) -> crate::model::ProblemDetail {
            crate::model::ProblemDetail {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl ProblemDetail {
    /// Creates a new builder-style object to manufacture [`ProblemDetail`](crate::model::ProblemDetail)
    pub fn builder() -> crate::model::problem_detail::Builder {
        crate::model::problem_detail::Builder::default()
    }
}

/// <p>Represents a condition that is evaluated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Test {
    /// <p>The test's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The test's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The test's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER</p>
    /// <note>
    /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
    /// screenshots at the same time.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TestType>,
    /// <p>When the test was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The test's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The test's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub result: std::option::Option<crate::model::ExecutionResult>,
    /// <p>The test's start time.</p>
    pub started: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The test's stop time.</p>
    pub stopped: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The test's result counters.</p>
    pub counters: std::option::Option<crate::model::Counters>,
    /// <p>A message about the test's result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Represents the total (metered or unmetered) minutes used by the test.</p>
    pub device_minutes: std::option::Option<crate::model::DeviceMinutes>,
}
impl Test {
    /// <p>The test's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The test's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The test's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER</p>
    /// <note>
    /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
    /// screenshots at the same time.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestType> {
        self.r#type.as_ref()
    }
    /// <p>When the test was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The test's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The test's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub fn result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.result.as_ref()
    }
    /// <p>The test's start time.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started.as_ref()
    }
    /// <p>The test's stop time.</p>
    pub fn stopped(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stopped.as_ref()
    }
    /// <p>The test's result counters.</p>
    pub fn counters(&self) -> std::option::Option<&crate::model::Counters> {
        self.counters.as_ref()
    }
    /// <p>A message about the test's result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Represents the total (metered or unmetered) minutes used by the test.</p>
    pub fn device_minutes(&self) -> std::option::Option<&crate::model::DeviceMinutes> {
        self.device_minutes.as_ref()
    }
}
impl std::fmt::Debug for Test {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Test");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("created", &self.created);
        formatter.field("status", &self.status);
        formatter.field("result", &self.result);
        formatter.field("started", &self.started);
        formatter.field("stopped", &self.stopped);
        formatter.field("counters", &self.counters);
        formatter.field("message", &self.message);
        formatter.field("device_minutes", &self.device_minutes);
        formatter.finish()
    }
}
/// See [`Test`](crate::model::Test)
pub mod test {
    /// A builder for [`Test`](crate::model::Test)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TestType>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) started: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) counters: std::option::Option<crate::model::Counters>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) device_minutes: std::option::Option<crate::model::DeviceMinutes>,
    }
    impl Builder {
        /// <p>The test's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The test's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The test's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The test's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The test's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER</p>
        /// <note>
        /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
        /// screenshots at the same time.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The test's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER</p>
        /// <note>
        /// <p>For Android, an app explorer that traverses an Android app, interacting with it and capturing
        /// screenshots at the same time.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>When the test was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the test was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The test's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The test's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The test's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The test's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>The test's start time.</p>
        pub fn started(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The test's start time.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The test's stop time.</p>
        pub fn stopped(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The test's stop time.</p>
        pub fn set_stopped(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The test's result counters.</p>
        pub fn counters(mut self, input: crate::model::Counters) -> Self {
            self.counters = Some(input);
            self
        }
        /// <p>The test's result counters.</p>
        pub fn set_counters(mut self, input: std::option::Option<crate::model::Counters>) -> Self {
            self.counters = input;
            self
        }
        /// <p>A message about the test's result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the test's result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the test.</p>
        pub fn device_minutes(mut self, input: crate::model::DeviceMinutes) -> Self {
            self.device_minutes = Some(input);
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the test.</p>
        pub fn set_device_minutes(
            mut self,
            input: std::option::Option<crate::model::DeviceMinutes>,
        ) -> Self {
            self.device_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`Test`](crate::model::Test)
        pub fn build(self) -> crate::model::Test {
            crate::model::Test {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                created: self.created,
                status: self.status,
                result: self.result,
                started: self.started,
                stopped: self.stopped,
                counters: self.counters,
                message: self.message,
                device_minutes: self.device_minutes,
            }
        }
    }
}
impl Test {
    /// Creates a new builder-style object to manufacture [`Test`](crate::model::Test)
    pub fn builder() -> crate::model::test::Builder {
        crate::model::test::Builder::default()
    }
}

/// <p>A <a>TestGridSession</a> is a single instance of a browser launched from the URL provided by a
/// call to <a>CreateTestGridUrl</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestGridSession {
    /// <p>The ARN of the session.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The state of the session.</p>
    pub status: std::option::Option<crate::model::TestGridSessionStatus>,
    /// <p>The time that the session was started.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the session ended.</p>
    pub ended: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of billed minutes that were used for this session. </p>
    pub billing_minutes: std::option::Option<f64>,
    /// <p>A JSON object of options and parameters passed to the Selenium WebDriver.</p>
    pub selenium_properties: std::option::Option<std::string::String>,
}
impl TestGridSession {
    /// <p>The ARN of the session.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The state of the session.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TestGridSessionStatus> {
        self.status.as_ref()
    }
    /// <p>The time that the session was started.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The time the session ended.</p>
    pub fn ended(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.ended.as_ref()
    }
    /// <p>The number of billed minutes that were used for this session. </p>
    pub fn billing_minutes(&self) -> std::option::Option<f64> {
        self.billing_minutes
    }
    /// <p>A JSON object of options and parameters passed to the Selenium WebDriver.</p>
    pub fn selenium_properties(&self) -> std::option::Option<&str> {
        self.selenium_properties.as_deref()
    }
}
impl std::fmt::Debug for TestGridSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestGridSession");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created", &self.created);
        formatter.field("ended", &self.ended);
        formatter.field("billing_minutes", &self.billing_minutes);
        formatter.field("selenium_properties", &self.selenium_properties);
        formatter.finish()
    }
}
/// See [`TestGridSession`](crate::model::TestGridSession)
pub mod test_grid_session {
    /// A builder for [`TestGridSession`](crate::model::TestGridSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TestGridSessionStatus>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) billing_minutes: std::option::Option<f64>,
        pub(crate) selenium_properties: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the session.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the session.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The state of the session.</p>
        pub fn status(mut self, input: crate::model::TestGridSessionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the session.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TestGridSessionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time that the session was started.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The time that the session was started.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The time the session ended.</p>
        pub fn ended(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended = Some(input);
            self
        }
        /// <p>The time the session ended.</p>
        pub fn set_ended(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.ended = input;
            self
        }
        /// <p>The number of billed minutes that were used for this session. </p>
        pub fn billing_minutes(mut self, input: f64) -> Self {
            self.billing_minutes = Some(input);
            self
        }
        /// <p>The number of billed minutes that were used for this session. </p>
        pub fn set_billing_minutes(mut self, input: std::option::Option<f64>) -> Self {
            self.billing_minutes = input;
            self
        }
        /// <p>A JSON object of options and parameters passed to the Selenium WebDriver.</p>
        pub fn selenium_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.selenium_properties = Some(input.into());
            self
        }
        /// <p>A JSON object of options and parameters passed to the Selenium WebDriver.</p>
        pub fn set_selenium_properties(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selenium_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`TestGridSession`](crate::model::TestGridSession)
        pub fn build(self) -> crate::model::TestGridSession {
            crate::model::TestGridSession {
                arn: self.arn,
                status: self.status,
                created: self.created,
                ended: self.ended,
                billing_minutes: self.billing_minutes,
                selenium_properties: self.selenium_properties,
            }
        }
    }
}
impl TestGridSession {
    /// Creates a new builder-style object to manufacture [`TestGridSession`](crate::model::TestGridSession)
    pub fn builder() -> crate::model::test_grid_session::Builder {
        crate::model::test_grid_session::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TestGridSessionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Errored,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TestGridSessionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => TestGridSessionStatus::Active,
            "CLOSED" => TestGridSessionStatus::Closed,
            "ERRORED" => TestGridSessionStatus::Errored,
            other => TestGridSessionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TestGridSessionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TestGridSessionStatus::from(s))
    }
}
impl TestGridSessionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TestGridSessionStatus::Active => "ACTIVE",
            TestGridSessionStatus::Closed => "CLOSED",
            TestGridSessionStatus::Errored => "ERRORED",
            TestGridSessionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CLOSED", "ERRORED"]
    }
}
impl AsRef<str> for TestGridSessionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Artifacts are video and other files that are produced in the process of running a browser in an automated
/// context. </p>
/// <note>
/// <p>Video elements might be broken up into multiple artifacts as they grow in size during creation. </p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestGridSessionArtifact {
    /// <p>The file name of the artifact.</p>
    pub filename: std::option::Option<std::string::String>,
    /// <p>The kind of artifact.</p>
    pub r#type: std::option::Option<crate::model::TestGridSessionArtifactType>,
    /// <p>A semi-stable URL to the content of the object.</p>
    pub url: std::option::Option<std::string::String>,
}
impl TestGridSessionArtifact {
    /// <p>The file name of the artifact.</p>
    pub fn filename(&self) -> std::option::Option<&str> {
        self.filename.as_deref()
    }
    /// <p>The kind of artifact.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestGridSessionArtifactType> {
        self.r#type.as_ref()
    }
    /// <p>A semi-stable URL to the content of the object.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for TestGridSessionArtifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestGridSessionArtifact");
        formatter.field("filename", &self.filename);
        formatter.field("r#type", &self.r#type);
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`TestGridSessionArtifact`](crate::model::TestGridSessionArtifact)
pub mod test_grid_session_artifact {
    /// A builder for [`TestGridSessionArtifact`](crate::model::TestGridSessionArtifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filename: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TestGridSessionArtifactType>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The file name of the artifact.</p>
        pub fn filename(mut self, input: impl Into<std::string::String>) -> Self {
            self.filename = Some(input.into());
            self
        }
        /// <p>The file name of the artifact.</p>
        pub fn set_filename(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filename = input;
            self
        }
        /// <p>The kind of artifact.</p>
        pub fn r#type(mut self, input: crate::model::TestGridSessionArtifactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of artifact.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TestGridSessionArtifactType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A semi-stable URL to the content of the object.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>A semi-stable URL to the content of the object.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`TestGridSessionArtifact`](crate::model::TestGridSessionArtifact)
        pub fn build(self) -> crate::model::TestGridSessionArtifact {
            crate::model::TestGridSessionArtifact {
                filename: self.filename,
                r#type: self.r#type,
                url: self.url,
            }
        }
    }
}
impl TestGridSessionArtifact {
    /// Creates a new builder-style object to manufacture [`TestGridSessionArtifact`](crate::model::TestGridSessionArtifact)
    pub fn builder() -> crate::model::test_grid_session_artifact::Builder {
        crate::model::test_grid_session_artifact::Builder::default()
    }
}

/// _Note: `TestGridSessionArtifactType::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TestGridSessionArtifactType {
    #[allow(missing_docs)] // documentation missing in model
    SeleniumLog,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Video,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TestGridSessionArtifactType {
    fn from(s: &str) -> Self {
        match s {
            "SELENIUM_LOG" => TestGridSessionArtifactType::SeleniumLog,
            "UNKNOWN" => TestGridSessionArtifactType::UnknownValue,
            "VIDEO" => TestGridSessionArtifactType::Video,
            other => TestGridSessionArtifactType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TestGridSessionArtifactType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TestGridSessionArtifactType::from(s))
    }
}
impl TestGridSessionArtifactType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TestGridSessionArtifactType::SeleniumLog => "SELENIUM_LOG",
            TestGridSessionArtifactType::UnknownValue => "UNKNOWN",
            TestGridSessionArtifactType::Video => "VIDEO",
            TestGridSessionArtifactType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SELENIUM_LOG", "UNKNOWN", "VIDEO"]
    }
}
impl AsRef<str> for TestGridSessionArtifactType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TestGridSessionArtifactCategory {
    #[allow(missing_docs)] // documentation missing in model
    Log,
    #[allow(missing_docs)] // documentation missing in model
    Video,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TestGridSessionArtifactCategory {
    fn from(s: &str) -> Self {
        match s {
            "LOG" => TestGridSessionArtifactCategory::Log,
            "VIDEO" => TestGridSessionArtifactCategory::Video,
            other => TestGridSessionArtifactCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TestGridSessionArtifactCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TestGridSessionArtifactCategory::from(s))
    }
}
impl TestGridSessionArtifactCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TestGridSessionArtifactCategory::Log => "LOG",
            TestGridSessionArtifactCategory::Video => "VIDEO",
            TestGridSessionArtifactCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOG", "VIDEO"]
    }
}
impl AsRef<str> for TestGridSessionArtifactCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An action taken by a <a>TestGridSession</a> browser instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestGridSessionAction {
    /// <p>The action taken by the session.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The time that the session invoked the action.</p>
    pub started: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in milliseconds, that the action took to complete in the browser.</p>
    pub duration: std::option::Option<i64>,
    /// <p>HTTP status code returned to the browser when the action was taken.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>HTTP method that the browser used to make the request.</p>
    pub request_method: std::option::Option<std::string::String>,
}
impl TestGridSessionAction {
    /// <p>The action taken by the session.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The time that the session invoked the action.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started.as_ref()
    }
    /// <p>The time, in milliseconds, that the action took to complete in the browser.</p>
    pub fn duration(&self) -> std::option::Option<i64> {
        self.duration
    }
    /// <p>HTTP status code returned to the browser when the action was taken.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>HTTP method that the browser used to make the request.</p>
    pub fn request_method(&self) -> std::option::Option<&str> {
        self.request_method.as_deref()
    }
}
impl std::fmt::Debug for TestGridSessionAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestGridSessionAction");
        formatter.field("action", &self.action);
        formatter.field("started", &self.started);
        formatter.field("duration", &self.duration);
        formatter.field("status_code", &self.status_code);
        formatter.field("request_method", &self.request_method);
        formatter.finish()
    }
}
/// See [`TestGridSessionAction`](crate::model::TestGridSessionAction)
pub mod test_grid_session_action {
    /// A builder for [`TestGridSessionAction`](crate::model::TestGridSessionAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) started: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) duration: std::option::Option<i64>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) request_method: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action taken by the session.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The action taken by the session.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The time that the session invoked the action.</p>
        pub fn started(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The time that the session invoked the action.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The time, in milliseconds, that the action took to complete in the browser.</p>
        pub fn duration(mut self, input: i64) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The time, in milliseconds, that the action took to complete in the browser.</p>
        pub fn set_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.duration = input;
            self
        }
        /// <p>HTTP status code returned to the browser when the action was taken.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>HTTP status code returned to the browser when the action was taken.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>HTTP method that the browser used to make the request.</p>
        pub fn request_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_method = Some(input.into());
            self
        }
        /// <p>HTTP method that the browser used to make the request.</p>
        pub fn set_request_method(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_method = input;
            self
        }
        /// Consumes the builder and constructs a [`TestGridSessionAction`](crate::model::TestGridSessionAction)
        pub fn build(self) -> crate::model::TestGridSessionAction {
            crate::model::TestGridSessionAction {
                action: self.action,
                started: self.started,
                duration: self.duration,
                status_code: self.status_code,
                request_method: self.request_method,
            }
        }
    }
}
impl TestGridSessionAction {
    /// Creates a new builder-style object to manufacture [`TestGridSessionAction`](crate::model::TestGridSessionAction)
    pub fn builder() -> crate::model::test_grid_session_action::Builder {
        crate::model::test_grid_session_action::Builder::default()
    }
}

/// <p>Represents a collection of one or more tests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Suite {
    /// <p>The suite's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The suite's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The suite's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER </p>
    /// <note>
    /// <p>Only available for Android; an app explorer that traverses an Android app, interacting with it
    /// and capturing screenshots at the same time.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TestType>,
    /// <p>When the suite was created.</p>
    pub created: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The suite's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The suite's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub result: std::option::Option<crate::model::ExecutionResult>,
    /// <p>The suite's start time.</p>
    pub started: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The suite's stop time.</p>
    pub stopped: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The suite's result counters.</p>
    pub counters: std::option::Option<crate::model::Counters>,
    /// <p>A message about the suite's result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Represents the total (metered or unmetered) minutes used by the test
    /// suite.</p>
    pub device_minutes: std::option::Option<crate::model::DeviceMinutes>,
}
impl Suite {
    /// <p>The suite's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The suite's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The suite's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>BUILTIN_FUZZ</p>
    /// </li>
    /// <li>
    /// <p>BUILTIN_EXPLORER </p>
    /// <note>
    /// <p>Only available for Android; an app explorer that traverses an Android app, interacting with it
    /// and capturing screenshots at the same time.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_RUBY</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_JUNIT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_JAVA_TESTNG</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_PYTHON</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_NODE</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_WEB_RUBY</p>
    /// </li>
    /// <li>
    /// <p>CALABASH</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATION</p>
    /// </li>
    /// <li>
    /// <p>UIAUTOMATOR</p>
    /// </li>
    /// <li>
    /// <p>XCTEST</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_UI</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestType> {
        self.r#type.as_ref()
    }
    /// <p>When the suite was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created.as_ref()
    }
    /// <p>The suite's status.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PENDING_CONCURRENCY</p>
    /// </li>
    /// <li>
    /// <p>PENDING_DEVICE</p>
    /// </li>
    /// <li>
    /// <p>PROCESSING</p>
    /// </li>
    /// <li>
    /// <p>SCHEDULING</p>
    /// </li>
    /// <li>
    /// <p>PREPARING</p>
    /// </li>
    /// <li>
    /// <p>RUNNING</p>
    /// </li>
    /// <li>
    /// <p>COMPLETED</p>
    /// </li>
    /// <li>
    /// <p>STOPPING</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The suite's result.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>PENDING</p>
    /// </li>
    /// <li>
    /// <p>PASSED</p>
    /// </li>
    /// <li>
    /// <p>WARNED</p>
    /// </li>
    /// <li>
    /// <p>FAILED</p>
    /// </li>
    /// <li>
    /// <p>SKIPPED</p>
    /// </li>
    /// <li>
    /// <p>ERRORED</p>
    /// </li>
    /// <li>
    /// <p>STOPPED</p>
    /// </li>
    /// </ul>
    pub fn result(&self) -> std::option::Option<&crate::model::ExecutionResult> {
        self.result.as_ref()
    }
    /// <p>The suite's start time.</p>
    pub fn started(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started.as_ref()
    }
    /// <p>The suite's stop time.</p>
    pub fn stopped(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stopped.as_ref()
    }
    /// <p>The suite's result counters.</p>
    pub fn counters(&self) -> std::option::Option<&crate::model::Counters> {
        self.counters.as_ref()
    }
    /// <p>A message about the suite's result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Represents the total (metered or unmetered) minutes used by the test
    /// suite.</p>
    pub fn device_minutes(&self) -> std::option::Option<&crate::model::DeviceMinutes> {
        self.device_minutes.as_ref()
    }
}
impl std::fmt::Debug for Suite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Suite");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("created", &self.created);
        formatter.field("status", &self.status);
        formatter.field("result", &self.result);
        formatter.field("started", &self.started);
        formatter.field("stopped", &self.stopped);
        formatter.field("counters", &self.counters);
        formatter.field("message", &self.message);
        formatter.field("device_minutes", &self.device_minutes);
        formatter.finish()
    }
}
/// See [`Suite`](crate::model::Suite)
pub mod suite {
    /// A builder for [`Suite`](crate::model::Suite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TestType>,
        pub(crate) created: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) result: std::option::Option<crate::model::ExecutionResult>,
        pub(crate) started: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) counters: std::option::Option<crate::model::Counters>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) device_minutes: std::option::Option<crate::model::DeviceMinutes>,
    }
    impl Builder {
        /// <p>The suite's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The suite's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The suite's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The suite's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The suite's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER </p>
        /// <note>
        /// <p>Only available for Android; an app explorer that traverses an Android app, interacting with it
        /// and capturing screenshots at the same time.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The suite's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER </p>
        /// <note>
        /// <p>Only available for Android; an app explorer that traverses an Android app, interacting with it
        /// and capturing screenshots at the same time.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY</p>
        /// </li>
        /// <li>
        /// <p>CALABASH</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR</p>
        /// </li>
        /// <li>
        /// <p>XCTEST</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>When the suite was created.</p>
        pub fn created(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the suite was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The suite's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The suite's status.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PENDING_CONCURRENCY</p>
        /// </li>
        /// <li>
        /// <p>PENDING_DEVICE</p>
        /// </li>
        /// <li>
        /// <p>PROCESSING</p>
        /// </li>
        /// <li>
        /// <p>SCHEDULING</p>
        /// </li>
        /// <li>
        /// <p>PREPARING</p>
        /// </li>
        /// <li>
        /// <p>RUNNING</p>
        /// </li>
        /// <li>
        /// <p>COMPLETED</p>
        /// </li>
        /// <li>
        /// <p>STOPPING</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The suite's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn result(mut self, input: crate::model::ExecutionResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The suite's result.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>PENDING</p>
        /// </li>
        /// <li>
        /// <p>PASSED</p>
        /// </li>
        /// <li>
        /// <p>WARNED</p>
        /// </li>
        /// <li>
        /// <p>FAILED</p>
        /// </li>
        /// <li>
        /// <p>SKIPPED</p>
        /// </li>
        /// <li>
        /// <p>ERRORED</p>
        /// </li>
        /// <li>
        /// <p>STOPPED</p>
        /// </li>
        /// </ul>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ExecutionResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// <p>The suite's start time.</p>
        pub fn started(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started = Some(input);
            self
        }
        /// <p>The suite's start time.</p>
        pub fn set_started(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started = input;
            self
        }
        /// <p>The suite's stop time.</p>
        pub fn stopped(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped = Some(input);
            self
        }
        /// <p>The suite's stop time.</p>
        pub fn set_stopped(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped = input;
            self
        }
        /// <p>The suite's result counters.</p>
        pub fn counters(mut self, input: crate::model::Counters) -> Self {
            self.counters = Some(input);
            self
        }
        /// <p>The suite's result counters.</p>
        pub fn set_counters(mut self, input: std::option::Option<crate::model::Counters>) -> Self {
            self.counters = input;
            self
        }
        /// <p>A message about the suite's result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the suite's result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the test
        /// suite.</p>
        pub fn device_minutes(mut self, input: crate::model::DeviceMinutes) -> Self {
            self.device_minutes = Some(input);
            self
        }
        /// <p>Represents the total (metered or unmetered) minutes used by the test
        /// suite.</p>
        pub fn set_device_minutes(
            mut self,
            input: std::option::Option<crate::model::DeviceMinutes>,
        ) -> Self {
            self.device_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`Suite`](crate::model::Suite)
        pub fn build(self) -> crate::model::Suite {
            crate::model::Suite {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                created: self.created,
                status: self.status,
                result: self.result,
                started: self.started,
                stopped: self.stopped,
                counters: self.counters,
                message: self.message,
                device_minutes: self.device_minutes,
            }
        }
    }
}
impl Suite {
    /// Creates a new builder-style object to manufacture [`Suite`](crate::model::Suite)
    pub fn builder() -> crate::model::suite::Builder {
        crate::model::suite::Builder::default()
    }
}

/// <p>Represents a sample of performance data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sample {
    /// <p>The sample's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The sample's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>CPU: A CPU sample type. This is expressed as the app processing CPU time
    /// (including child processes) as reported by process, as a percentage.</p>
    /// </li>
    /// <li>
    /// <p>MEMORY: A memory usage sample type. This is expressed as the total
    /// proportional set size of an app process, in kilobytes.</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_AVG_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_FPS</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_FRAMES</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_MAX_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_MIN_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_AVG_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_FPS</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_FRAMES</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_MAX_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_MIN_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>RX</p>
    /// </li>
    /// <li>
    /// <p>RX_RATE: The total number of bytes per second (TCP and UDP) that are sent,
    /// by app process.</p>
    /// </li>
    /// <li>
    /// <p>THREADS: A threads sample type. This is expressed as the total number of
    /// threads per app process.</p>
    /// </li>
    /// <li>
    /// <p>TX</p>
    /// </li>
    /// <li>
    /// <p>TX_RATE: The total number of bytes per second (TCP and UDP) that are
    /// received, by app process.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::SampleType>,
    /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the sample's
    /// file.</p>
    pub url: std::option::Option<std::string::String>,
}
impl Sample {
    /// <p>The sample's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The sample's type.</p>
    /// <p>Must be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>CPU: A CPU sample type. This is expressed as the app processing CPU time
    /// (including child processes) as reported by process, as a percentage.</p>
    /// </li>
    /// <li>
    /// <p>MEMORY: A memory usage sample type. This is expressed as the total
    /// proportional set size of an app process, in kilobytes.</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_AVG_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_FPS</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_FRAMES</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_MAX_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>NATIVE_MIN_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_AVG_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_FPS</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_FRAMES</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_MAX_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>OPENGL_MIN_DRAWTIME</p>
    /// </li>
    /// <li>
    /// <p>RX</p>
    /// </li>
    /// <li>
    /// <p>RX_RATE: The total number of bytes per second (TCP and UDP) that are sent,
    /// by app process.</p>
    /// </li>
    /// <li>
    /// <p>THREADS: A threads sample type. This is expressed as the total number of
    /// threads per app process.</p>
    /// </li>
    /// <li>
    /// <p>TX</p>
    /// </li>
    /// <li>
    /// <p>TX_RATE: The total number of bytes per second (TCP and UDP) that are
    /// received, by app process.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SampleType> {
        self.r#type.as_ref()
    }
    /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the sample's
    /// file.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for Sample {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sample");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Sample`](crate::model::Sample)
pub mod sample {
    /// A builder for [`Sample`](crate::model::Sample)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::SampleType>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The sample's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The sample's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The sample's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>CPU: A CPU sample type. This is expressed as the app processing CPU time
        /// (including child processes) as reported by process, as a percentage.</p>
        /// </li>
        /// <li>
        /// <p>MEMORY: A memory usage sample type. This is expressed as the total
        /// proportional set size of an app process, in kilobytes.</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_AVG_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_FPS</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_FRAMES</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_MAX_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_MIN_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_AVG_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_FPS</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_FRAMES</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_MAX_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_MIN_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>RX</p>
        /// </li>
        /// <li>
        /// <p>RX_RATE: The total number of bytes per second (TCP and UDP) that are sent,
        /// by app process.</p>
        /// </li>
        /// <li>
        /// <p>THREADS: A threads sample type. This is expressed as the total number of
        /// threads per app process.</p>
        /// </li>
        /// <li>
        /// <p>TX</p>
        /// </li>
        /// <li>
        /// <p>TX_RATE: The total number of bytes per second (TCP and UDP) that are
        /// received, by app process.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::SampleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The sample's type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>CPU: A CPU sample type. This is expressed as the app processing CPU time
        /// (including child processes) as reported by process, as a percentage.</p>
        /// </li>
        /// <li>
        /// <p>MEMORY: A memory usage sample type. This is expressed as the total
        /// proportional set size of an app process, in kilobytes.</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_AVG_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_FPS</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_FRAMES</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_MAX_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>NATIVE_MIN_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_AVG_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_FPS</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_FRAMES</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_MAX_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>OPENGL_MIN_DRAWTIME</p>
        /// </li>
        /// <li>
        /// <p>RX</p>
        /// </li>
        /// <li>
        /// <p>RX_RATE: The total number of bytes per second (TCP and UDP) that are sent,
        /// by app process.</p>
        /// </li>
        /// <li>
        /// <p>THREADS: A threads sample type. This is expressed as the total number of
        /// threads per app process.</p>
        /// </li>
        /// <li>
        /// <p>TX</p>
        /// </li>
        /// <li>
        /// <p>TX_RATE: The total number of bytes per second (TCP and UDP) that are
        /// received, by app process.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SampleType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the sample's
        /// file.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the sample's
        /// file.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Sample`](crate::model::Sample)
        pub fn build(self) -> crate::model::Sample {
            crate::model::Sample {
                arn: self.arn,
                r#type: self.r#type,
                url: self.url,
            }
        }
    }
}
impl Sample {
    /// Creates a new builder-style object to manufacture [`Sample`](crate::model::Sample)
    pub fn builder() -> crate::model::sample::Builder {
        crate::model::sample::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SampleType {
    #[allow(missing_docs)] // documentation missing in model
    Cpu,
    #[allow(missing_docs)] // documentation missing in model
    Memory,
    #[allow(missing_docs)] // documentation missing in model
    NativeAvgDrawtime,
    #[allow(missing_docs)] // documentation missing in model
    NativeFps,
    #[allow(missing_docs)] // documentation missing in model
    NativeFrames,
    #[allow(missing_docs)] // documentation missing in model
    NativeMaxDrawtime,
    #[allow(missing_docs)] // documentation missing in model
    NativeMinDrawtime,
    #[allow(missing_docs)] // documentation missing in model
    OpenglAvgDrawtime,
    #[allow(missing_docs)] // documentation missing in model
    OpenglFps,
    #[allow(missing_docs)] // documentation missing in model
    OpenglFrames,
    #[allow(missing_docs)] // documentation missing in model
    OpenglMaxDrawtime,
    #[allow(missing_docs)] // documentation missing in model
    OpenglMinDrawtime,
    #[allow(missing_docs)] // documentation missing in model
    Rx,
    #[allow(missing_docs)] // documentation missing in model
    RxRate,
    #[allow(missing_docs)] // documentation missing in model
    Threads,
    #[allow(missing_docs)] // documentation missing in model
    Tx,
    #[allow(missing_docs)] // documentation missing in model
    TxRate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SampleType {
    fn from(s: &str) -> Self {
        match s {
            "CPU" => SampleType::Cpu,
            "MEMORY" => SampleType::Memory,
            "NATIVE_AVG_DRAWTIME" => SampleType::NativeAvgDrawtime,
            "NATIVE_FPS" => SampleType::NativeFps,
            "NATIVE_FRAMES" => SampleType::NativeFrames,
            "NATIVE_MAX_DRAWTIME" => SampleType::NativeMaxDrawtime,
            "NATIVE_MIN_DRAWTIME" => SampleType::NativeMinDrawtime,
            "OPENGL_AVG_DRAWTIME" => SampleType::OpenglAvgDrawtime,
            "OPENGL_FPS" => SampleType::OpenglFps,
            "OPENGL_FRAMES" => SampleType::OpenglFrames,
            "OPENGL_MAX_DRAWTIME" => SampleType::OpenglMaxDrawtime,
            "OPENGL_MIN_DRAWTIME" => SampleType::OpenglMinDrawtime,
            "RX" => SampleType::Rx,
            "RX_RATE" => SampleType::RxRate,
            "THREADS" => SampleType::Threads,
            "TX" => SampleType::Tx,
            "TX_RATE" => SampleType::TxRate,
            other => SampleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SampleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SampleType::from(s))
    }
}
impl SampleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SampleType::Cpu => "CPU",
            SampleType::Memory => "MEMORY",
            SampleType::NativeAvgDrawtime => "NATIVE_AVG_DRAWTIME",
            SampleType::NativeFps => "NATIVE_FPS",
            SampleType::NativeFrames => "NATIVE_FRAMES",
            SampleType::NativeMaxDrawtime => "NATIVE_MAX_DRAWTIME",
            SampleType::NativeMinDrawtime => "NATIVE_MIN_DRAWTIME",
            SampleType::OpenglAvgDrawtime => "OPENGL_AVG_DRAWTIME",
            SampleType::OpenglFps => "OPENGL_FPS",
            SampleType::OpenglFrames => "OPENGL_FRAMES",
            SampleType::OpenglMaxDrawtime => "OPENGL_MAX_DRAWTIME",
            SampleType::OpenglMinDrawtime => "OPENGL_MIN_DRAWTIME",
            SampleType::Rx => "RX",
            SampleType::RxRate => "RX_RATE",
            SampleType::Threads => "THREADS",
            SampleType::Tx => "TX",
            SampleType::TxRate => "TX_RATE",
            SampleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CPU",
            "MEMORY",
            "NATIVE_AVG_DRAWTIME",
            "NATIVE_FPS",
            "NATIVE_FRAMES",
            "NATIVE_MAX_DRAWTIME",
            "NATIVE_MIN_DRAWTIME",
            "OPENGL_AVG_DRAWTIME",
            "OPENGL_FPS",
            "OPENGL_FRAMES",
            "OPENGL_MAX_DRAWTIME",
            "OPENGL_MIN_DRAWTIME",
            "RX",
            "RX_RATE",
            "THREADS",
            "TX",
            "TX_RATE",
        ]
    }
}
impl AsRef<str> for SampleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information about an offering promotion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OfferingPromotion {
    /// <p>The ID of the offering promotion.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A string that describes the offering promotion.</p>
    pub description: std::option::Option<std::string::String>,
}
impl OfferingPromotion {
    /// <p>The ID of the offering promotion.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A string that describes the offering promotion.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for OfferingPromotion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OfferingPromotion");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`OfferingPromotion`](crate::model::OfferingPromotion)
pub mod offering_promotion {
    /// A builder for [`OfferingPromotion`](crate::model::OfferingPromotion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the offering promotion.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the offering promotion.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A string that describes the offering promotion.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string that describes the offering promotion.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`OfferingPromotion`](crate::model::OfferingPromotion)
        pub fn build(self) -> crate::model::OfferingPromotion {
            crate::model::OfferingPromotion {
                id: self.id,
                description: self.description,
            }
        }
    }
}
impl OfferingPromotion {
    /// Creates a new builder-style object to manufacture [`OfferingPromotion`](crate::model::OfferingPromotion)
    pub fn builder() -> crate::model::offering_promotion::Builder {
        crate::model::offering_promotion::Builder::default()
    }
}

/// <p>Represents the output of a test. Examples of artifacts include logs and
/// screenshots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Artifact {
    /// <p>The artifact's ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The artifact's name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The artifact's type.</p>
    /// <p>Allowed values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>UNKNOWN</p>
    /// </li>
    /// <li>
    /// <p>SCREENSHOT</p>
    /// </li>
    /// <li>
    /// <p>DEVICE_LOG</p>
    /// </li>
    /// <li>
    /// <p>MESSAGE_LOG</p>
    /// </li>
    /// <li>
    /// <p>VIDEO_LOG</p>
    /// </li>
    /// <li>
    /// <p>RESULT_LOG</p>
    /// </li>
    /// <li>
    /// <p>SERVICE_LOG</p>
    /// </li>
    /// <li>
    /// <p>WEBKIT_LOG</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_JSON_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_PRETTY_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_STANDARD_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_JAVA_XML_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>AUTOMATION_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_SERVER_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_XML_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_XML_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>EXPLORER_EVENT_LOG</p>
    /// </li>
    /// <li>
    /// <p>EXPLORER_SUMMARY_LOG</p>
    /// </li>
    /// <li>
    /// <p>APPLICATION_CRASH_REPORT</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_LOG</p>
    /// </li>
    /// <li>
    /// <p>VIDEO</p>
    /// </li>
    /// <li>
    /// <p>CUSTOMER_ARTIFACT</p>
    /// </li>
    /// <li>
    /// <p>CUSTOMER_ARTIFACT_LOG</p>
    /// </li>
    /// <li>
    /// <p>TESTSPEC_OUTPUT</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ArtifactType>,
    /// <p>The artifact's file extension.</p>
    pub extension: std::option::Option<std::string::String>,
    /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the artifact's
    /// file.</p>
    pub url: std::option::Option<std::string::String>,
}
impl Artifact {
    /// <p>The artifact's ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The artifact's name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The artifact's type.</p>
    /// <p>Allowed values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>UNKNOWN</p>
    /// </li>
    /// <li>
    /// <p>SCREENSHOT</p>
    /// </li>
    /// <li>
    /// <p>DEVICE_LOG</p>
    /// </li>
    /// <li>
    /// <p>MESSAGE_LOG</p>
    /// </li>
    /// <li>
    /// <p>VIDEO_LOG</p>
    /// </li>
    /// <li>
    /// <p>RESULT_LOG</p>
    /// </li>
    /// <li>
    /// <p>SERVICE_LOG</p>
    /// </li>
    /// <li>
    /// <p>WEBKIT_LOG</p>
    /// </li>
    /// <li>
    /// <p>INSTRUMENTATION_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_JSON_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_PRETTY_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_STANDARD_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>CALABASH_JAVA_XML_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>AUTOMATION_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_SERVER_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_JAVA_XML_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_PYTHON_XML_OUTPUT</p>
    /// </li>
    /// <li>
    /// <p>EXPLORER_EVENT_LOG</p>
    /// </li>
    /// <li>
    /// <p>EXPLORER_SUMMARY_LOG</p>
    /// </li>
    /// <li>
    /// <p>APPLICATION_CRASH_REPORT</p>
    /// </li>
    /// <li>
    /// <p>XCTEST_LOG</p>
    /// </li>
    /// <li>
    /// <p>VIDEO</p>
    /// </li>
    /// <li>
    /// <p>CUSTOMER_ARTIFACT</p>
    /// </li>
    /// <li>
    /// <p>CUSTOMER_ARTIFACT_LOG</p>
    /// </li>
    /// <li>
    /// <p>TESTSPEC_OUTPUT</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ArtifactType> {
        self.r#type.as_ref()
    }
    /// <p>The artifact's file extension.</p>
    pub fn extension(&self) -> std::option::Option<&str> {
        self.extension.as_deref()
    }
    /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the artifact's
    /// file.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for Artifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Artifact");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("extension", &self.extension);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Artifact`](crate::model::Artifact)
pub mod artifact {
    /// A builder for [`Artifact`](crate::model::Artifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ArtifactType>,
        pub(crate) extension: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The artifact's ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The artifact's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The artifact's name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The artifact's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The artifact's type.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>UNKNOWN</p>
        /// </li>
        /// <li>
        /// <p>SCREENSHOT</p>
        /// </li>
        /// <li>
        /// <p>DEVICE_LOG</p>
        /// </li>
        /// <li>
        /// <p>MESSAGE_LOG</p>
        /// </li>
        /// <li>
        /// <p>VIDEO_LOG</p>
        /// </li>
        /// <li>
        /// <p>RESULT_LOG</p>
        /// </li>
        /// <li>
        /// <p>SERVICE_LOG</p>
        /// </li>
        /// <li>
        /// <p>WEBKIT_LOG</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_JSON_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_PRETTY_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_STANDARD_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_JAVA_XML_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>AUTOMATION_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_SERVER_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_XML_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_XML_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>EXPLORER_EVENT_LOG</p>
        /// </li>
        /// <li>
        /// <p>EXPLORER_SUMMARY_LOG</p>
        /// </li>
        /// <li>
        /// <p>APPLICATION_CRASH_REPORT</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_LOG</p>
        /// </li>
        /// <li>
        /// <p>VIDEO</p>
        /// </li>
        /// <li>
        /// <p>CUSTOMER_ARTIFACT</p>
        /// </li>
        /// <li>
        /// <p>CUSTOMER_ARTIFACT_LOG</p>
        /// </li>
        /// <li>
        /// <p>TESTSPEC_OUTPUT</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ArtifactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The artifact's type.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>UNKNOWN</p>
        /// </li>
        /// <li>
        /// <p>SCREENSHOT</p>
        /// </li>
        /// <li>
        /// <p>DEVICE_LOG</p>
        /// </li>
        /// <li>
        /// <p>MESSAGE_LOG</p>
        /// </li>
        /// <li>
        /// <p>VIDEO_LOG</p>
        /// </li>
        /// <li>
        /// <p>RESULT_LOG</p>
        /// </li>
        /// <li>
        /// <p>SERVICE_LOG</p>
        /// </li>
        /// <li>
        /// <p>WEBKIT_LOG</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_JSON_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_PRETTY_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_STANDARD_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_JAVA_XML_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>AUTOMATION_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_SERVER_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_XML_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_XML_OUTPUT</p>
        /// </li>
        /// <li>
        /// <p>EXPLORER_EVENT_LOG</p>
        /// </li>
        /// <li>
        /// <p>EXPLORER_SUMMARY_LOG</p>
        /// </li>
        /// <li>
        /// <p>APPLICATION_CRASH_REPORT</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_LOG</p>
        /// </li>
        /// <li>
        /// <p>VIDEO</p>
        /// </li>
        /// <li>
        /// <p>CUSTOMER_ARTIFACT</p>
        /// </li>
        /// <li>
        /// <p>CUSTOMER_ARTIFACT_LOG</p>
        /// </li>
        /// <li>
        /// <p>TESTSPEC_OUTPUT</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ArtifactType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The artifact's file extension.</p>
        pub fn extension(mut self, input: impl Into<std::string::String>) -> Self {
            self.extension = Some(input.into());
            self
        }
        /// <p>The artifact's file extension.</p>
        pub fn set_extension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.extension = input;
            self
        }
        /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the artifact's
        /// file.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The presigned Amazon S3 URL that can be used with a GET request to download the artifact's
        /// file.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Artifact`](crate::model::Artifact)
        pub fn build(self) -> crate::model::Artifact {
            crate::model::Artifact {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                extension: self.extension,
                url: self.url,
            }
        }
    }
}
impl Artifact {
    /// Creates a new builder-style object to manufacture [`Artifact`](crate::model::Artifact)
    pub fn builder() -> crate::model::artifact::Builder {
        crate::model::artifact::Builder::default()
    }
}

/// _Note: `ArtifactType::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactType {
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaOutput,
    #[allow(missing_docs)] // documentation missing in model
    AppiumJavaXmlOutput,
    #[allow(missing_docs)] // documentation missing in model
    AppiumPythonOutput,
    #[allow(missing_docs)] // documentation missing in model
    AppiumPythonXmlOutput,
    #[allow(missing_docs)] // documentation missing in model
    AppiumServerOutput,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationCrashReport,
    #[allow(missing_docs)] // documentation missing in model
    AutomationOutput,
    #[allow(missing_docs)] // documentation missing in model
    CalabashJavaXmlOutput,
    #[allow(missing_docs)] // documentation missing in model
    CalabashJsonOutput,
    #[allow(missing_docs)] // documentation missing in model
    CalabashPrettyOutput,
    #[allow(missing_docs)] // documentation missing in model
    CalabashStandardOutput,
    #[allow(missing_docs)] // documentation missing in model
    CustomerArtifact,
    #[allow(missing_docs)] // documentation missing in model
    CustomerArtifactLog,
    #[allow(missing_docs)] // documentation missing in model
    DeviceLog,
    #[allow(missing_docs)] // documentation missing in model
    ExerciserMonkeyOutput,
    #[allow(missing_docs)] // documentation missing in model
    ExplorerEventLog,
    #[allow(missing_docs)] // documentation missing in model
    ExplorerSummaryLog,
    #[allow(missing_docs)] // documentation missing in model
    InstrumentationOutput,
    #[allow(missing_docs)] // documentation missing in model
    MessageLog,
    #[allow(missing_docs)] // documentation missing in model
    ResultLog,
    #[allow(missing_docs)] // documentation missing in model
    Screenshot,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLog,
    #[allow(missing_docs)] // documentation missing in model
    TestspecOutput,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Video,
    #[allow(missing_docs)] // documentation missing in model
    VideoLog,
    #[allow(missing_docs)] // documentation missing in model
    WebkitLog,
    #[allow(missing_docs)] // documentation missing in model
    XctestLog,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactType {
    fn from(s: &str) -> Self {
        match s {
            "APPIUM_JAVA_OUTPUT" => ArtifactType::AppiumJavaOutput,
            "APPIUM_JAVA_XML_OUTPUT" => ArtifactType::AppiumJavaXmlOutput,
            "APPIUM_PYTHON_OUTPUT" => ArtifactType::AppiumPythonOutput,
            "APPIUM_PYTHON_XML_OUTPUT" => ArtifactType::AppiumPythonXmlOutput,
            "APPIUM_SERVER_OUTPUT" => ArtifactType::AppiumServerOutput,
            "APPLICATION_CRASH_REPORT" => ArtifactType::ApplicationCrashReport,
            "AUTOMATION_OUTPUT" => ArtifactType::AutomationOutput,
            "CALABASH_JAVA_XML_OUTPUT" => ArtifactType::CalabashJavaXmlOutput,
            "CALABASH_JSON_OUTPUT" => ArtifactType::CalabashJsonOutput,
            "CALABASH_PRETTY_OUTPUT" => ArtifactType::CalabashPrettyOutput,
            "CALABASH_STANDARD_OUTPUT" => ArtifactType::CalabashStandardOutput,
            "CUSTOMER_ARTIFACT" => ArtifactType::CustomerArtifact,
            "CUSTOMER_ARTIFACT_LOG" => ArtifactType::CustomerArtifactLog,
            "DEVICE_LOG" => ArtifactType::DeviceLog,
            "EXERCISER_MONKEY_OUTPUT" => ArtifactType::ExerciserMonkeyOutput,
            "EXPLORER_EVENT_LOG" => ArtifactType::ExplorerEventLog,
            "EXPLORER_SUMMARY_LOG" => ArtifactType::ExplorerSummaryLog,
            "INSTRUMENTATION_OUTPUT" => ArtifactType::InstrumentationOutput,
            "MESSAGE_LOG" => ArtifactType::MessageLog,
            "RESULT_LOG" => ArtifactType::ResultLog,
            "SCREENSHOT" => ArtifactType::Screenshot,
            "SERVICE_LOG" => ArtifactType::ServiceLog,
            "TESTSPEC_OUTPUT" => ArtifactType::TestspecOutput,
            "UNKNOWN" => ArtifactType::UnknownValue,
            "VIDEO" => ArtifactType::Video,
            "VIDEO_LOG" => ArtifactType::VideoLog,
            "WEBKIT_LOG" => ArtifactType::WebkitLog,
            "XCTEST_LOG" => ArtifactType::XctestLog,
            other => ArtifactType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactType::from(s))
    }
}
impl ArtifactType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactType::AppiumJavaOutput => "APPIUM_JAVA_OUTPUT",
            ArtifactType::AppiumJavaXmlOutput => "APPIUM_JAVA_XML_OUTPUT",
            ArtifactType::AppiumPythonOutput => "APPIUM_PYTHON_OUTPUT",
            ArtifactType::AppiumPythonXmlOutput => "APPIUM_PYTHON_XML_OUTPUT",
            ArtifactType::AppiumServerOutput => "APPIUM_SERVER_OUTPUT",
            ArtifactType::ApplicationCrashReport => "APPLICATION_CRASH_REPORT",
            ArtifactType::AutomationOutput => "AUTOMATION_OUTPUT",
            ArtifactType::CalabashJavaXmlOutput => "CALABASH_JAVA_XML_OUTPUT",
            ArtifactType::CalabashJsonOutput => "CALABASH_JSON_OUTPUT",
            ArtifactType::CalabashPrettyOutput => "CALABASH_PRETTY_OUTPUT",
            ArtifactType::CalabashStandardOutput => "CALABASH_STANDARD_OUTPUT",
            ArtifactType::CustomerArtifact => "CUSTOMER_ARTIFACT",
            ArtifactType::CustomerArtifactLog => "CUSTOMER_ARTIFACT_LOG",
            ArtifactType::DeviceLog => "DEVICE_LOG",
            ArtifactType::ExerciserMonkeyOutput => "EXERCISER_MONKEY_OUTPUT",
            ArtifactType::ExplorerEventLog => "EXPLORER_EVENT_LOG",
            ArtifactType::ExplorerSummaryLog => "EXPLORER_SUMMARY_LOG",
            ArtifactType::InstrumentationOutput => "INSTRUMENTATION_OUTPUT",
            ArtifactType::MessageLog => "MESSAGE_LOG",
            ArtifactType::ResultLog => "RESULT_LOG",
            ArtifactType::Screenshot => "SCREENSHOT",
            ArtifactType::ServiceLog => "SERVICE_LOG",
            ArtifactType::TestspecOutput => "TESTSPEC_OUTPUT",
            ArtifactType::UnknownValue => "UNKNOWN",
            ArtifactType::Video => "VIDEO",
            ArtifactType::VideoLog => "VIDEO_LOG",
            ArtifactType::WebkitLog => "WEBKIT_LOG",
            ArtifactType::XctestLog => "XCTEST_LOG",
            ArtifactType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPIUM_JAVA_OUTPUT",
            "APPIUM_JAVA_XML_OUTPUT",
            "APPIUM_PYTHON_OUTPUT",
            "APPIUM_PYTHON_XML_OUTPUT",
            "APPIUM_SERVER_OUTPUT",
            "APPLICATION_CRASH_REPORT",
            "AUTOMATION_OUTPUT",
            "CALABASH_JAVA_XML_OUTPUT",
            "CALABASH_JSON_OUTPUT",
            "CALABASH_PRETTY_OUTPUT",
            "CALABASH_STANDARD_OUTPUT",
            "CUSTOMER_ARTIFACT",
            "CUSTOMER_ARTIFACT_LOG",
            "DEVICE_LOG",
            "EXERCISER_MONKEY_OUTPUT",
            "EXPLORER_EVENT_LOG",
            "EXPLORER_SUMMARY_LOG",
            "INSTRUMENTATION_OUTPUT",
            "MESSAGE_LOG",
            "RESULT_LOG",
            "SCREENSHOT",
            "SERVICE_LOG",
            "TESTSPEC_OUTPUT",
            "UNKNOWN",
            "VIDEO",
            "VIDEO_LOG",
            "WEBKIT_LOG",
            "XCTEST_LOG",
        ]
    }
}
impl AsRef<str> for ArtifactType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactCategory {
    #[allow(missing_docs)] // documentation missing in model
    File,
    #[allow(missing_docs)] // documentation missing in model
    Log,
    #[allow(missing_docs)] // documentation missing in model
    Screenshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactCategory {
    fn from(s: &str) -> Self {
        match s {
            "FILE" => ArtifactCategory::File,
            "LOG" => ArtifactCategory::Log,
            "SCREENSHOT" => ArtifactCategory::Screenshot,
            other => ArtifactCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactCategory::from(s))
    }
}
impl ArtifactCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactCategory::File => "FILE",
            ArtifactCategory::Log => "LOG",
            ArtifactCategory::Screenshot => "SCREENSHOT",
            ArtifactCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FILE", "LOG", "SCREENSHOT"]
    }
}
impl AsRef<str> for ArtifactCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a device pool compatibility result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DevicePoolCompatibilityResult {
    /// <p>The device (phone or tablet) to return information about.</p>
    pub device: std::option::Option<crate::model::Device>,
    /// <p>Whether the result was compatible with the device pool.</p>
    pub compatible: std::option::Option<bool>,
    /// <p>Information about the compatibility.</p>
    pub incompatibility_messages:
        std::option::Option<std::vec::Vec<crate::model::IncompatibilityMessage>>,
}
impl DevicePoolCompatibilityResult {
    /// <p>The device (phone or tablet) to return information about.</p>
    pub fn device(&self) -> std::option::Option<&crate::model::Device> {
        self.device.as_ref()
    }
    /// <p>Whether the result was compatible with the device pool.</p>
    pub fn compatible(&self) -> std::option::Option<bool> {
        self.compatible
    }
    /// <p>Information about the compatibility.</p>
    pub fn incompatibility_messages(
        &self,
    ) -> std::option::Option<&[crate::model::IncompatibilityMessage]> {
        self.incompatibility_messages.as_deref()
    }
}
impl std::fmt::Debug for DevicePoolCompatibilityResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DevicePoolCompatibilityResult");
        formatter.field("device", &self.device);
        formatter.field("compatible", &self.compatible);
        formatter.field("incompatibility_messages", &self.incompatibility_messages);
        formatter.finish()
    }
}
/// See [`DevicePoolCompatibilityResult`](crate::model::DevicePoolCompatibilityResult)
pub mod device_pool_compatibility_result {
    /// A builder for [`DevicePoolCompatibilityResult`](crate::model::DevicePoolCompatibilityResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
        pub(crate) compatible: std::option::Option<bool>,
        pub(crate) incompatibility_messages:
            std::option::Option<std::vec::Vec<crate::model::IncompatibilityMessage>>,
    }
    impl Builder {
        /// <p>The device (phone or tablet) to return information about.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>The device (phone or tablet) to return information about.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// <p>Whether the result was compatible with the device pool.</p>
        pub fn compatible(mut self, input: bool) -> Self {
            self.compatible = Some(input);
            self
        }
        /// <p>Whether the result was compatible with the device pool.</p>
        pub fn set_compatible(mut self, input: std::option::Option<bool>) -> Self {
            self.compatible = input;
            self
        }
        /// Appends an item to `incompatibility_messages`.
        ///
        /// To override the contents of this collection use [`set_incompatibility_messages`](Self::set_incompatibility_messages).
        ///
        /// <p>Information about the compatibility.</p>
        pub fn incompatibility_messages(
            mut self,
            input: impl Into<crate::model::IncompatibilityMessage>,
        ) -> Self {
            let mut v = self.incompatibility_messages.unwrap_or_default();
            v.push(input.into());
            self.incompatibility_messages = Some(v);
            self
        }
        /// <p>Information about the compatibility.</p>
        pub fn set_incompatibility_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IncompatibilityMessage>>,
        ) -> Self {
            self.incompatibility_messages = input;
            self
        }
        /// Consumes the builder and constructs a [`DevicePoolCompatibilityResult`](crate::model::DevicePoolCompatibilityResult)
        pub fn build(self) -> crate::model::DevicePoolCompatibilityResult {
            crate::model::DevicePoolCompatibilityResult {
                device: self.device,
                compatible: self.compatible,
                incompatibility_messages: self.incompatibility_messages,
            }
        }
    }
}
impl DevicePoolCompatibilityResult {
    /// Creates a new builder-style object to manufacture [`DevicePoolCompatibilityResult`](crate::model::DevicePoolCompatibilityResult)
    pub fn builder() -> crate::model::device_pool_compatibility_result::Builder {
        crate::model::device_pool_compatibility_result::Builder::default()
    }
}

/// <p>Represents information about incompatibility.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibilityMessage {
    /// <p>A message about the incompatibility.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of incompatibility.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ARN</p>
    /// </li>
    /// <li>
    /// <p>FORM_FACTOR (for example, phone or tablet)</p>
    /// </li>
    /// <li>
    /// <p>MANUFACTURER</p>
    /// </li>
    /// <li>
    /// <p>PLATFORM (for example, Android or iOS)</p>
    /// </li>
    /// <li>
    /// <p>REMOTE_ACCESS_ENABLED</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_VERSION</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::DeviceAttribute>,
}
impl IncompatibilityMessage {
    /// <p>A message about the incompatibility.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The type of incompatibility.</p>
    /// <p>Allowed values include:</p>
    /// <ul>
    /// <li>
    /// <p>ARN</p>
    /// </li>
    /// <li>
    /// <p>FORM_FACTOR (for example, phone or tablet)</p>
    /// </li>
    /// <li>
    /// <p>MANUFACTURER</p>
    /// </li>
    /// <li>
    /// <p>PLATFORM (for example, Android or iOS)</p>
    /// </li>
    /// <li>
    /// <p>REMOTE_ACCESS_ENABLED</p>
    /// </li>
    /// <li>
    /// <p>APPIUM_VERSION</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DeviceAttribute> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for IncompatibilityMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibilityMessage");
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`IncompatibilityMessage`](crate::model::IncompatibilityMessage)
pub mod incompatibility_message {
    /// A builder for [`IncompatibilityMessage`](crate::model::IncompatibilityMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DeviceAttribute>,
    }
    impl Builder {
        /// <p>A message about the incompatibility.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the incompatibility.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of incompatibility.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ARN</p>
        /// </li>
        /// <li>
        /// <p>FORM_FACTOR (for example, phone or tablet)</p>
        /// </li>
        /// <li>
        /// <p>MANUFACTURER</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM (for example, Android or iOS)</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_ACCESS_ENABLED</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_VERSION</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::DeviceAttribute) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of incompatibility.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ARN</p>
        /// </li>
        /// <li>
        /// <p>FORM_FACTOR (for example, phone or tablet)</p>
        /// </li>
        /// <li>
        /// <p>MANUFACTURER</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM (for example, Android or iOS)</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_ACCESS_ENABLED</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_VERSION</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DeviceAttribute>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibilityMessage`](crate::model::IncompatibilityMessage)
        pub fn build(self) -> crate::model::IncompatibilityMessage {
            crate::model::IncompatibilityMessage {
                message: self.message,
                r#type: self.r#type,
            }
        }
    }
}
impl IncompatibilityMessage {
    /// Creates a new builder-style object to manufacture [`IncompatibilityMessage`](crate::model::IncompatibilityMessage)
    pub fn builder() -> crate::model::incompatibility_message::Builder {
        crate::model::incompatibility_message::Builder::default()
    }
}

/// <p>A container for account-level settings in AWS Device Farm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountSettings {
    /// <p>The AWS account number specified in the <code>AccountSettings</code>
    /// container.</p>
    pub aws_account_number: std::option::Option<std::string::String>,
    /// <p>Returns the unmetered devices you have purchased or want to purchase.</p>
    pub unmetered_devices:
        std::option::Option<std::collections::HashMap<crate::model::DevicePlatform, i32>>,
    /// <p>Returns the unmetered remote access devices you have purchased or want to
    /// purchase.</p>
    pub unmetered_remote_access_devices:
        std::option::Option<std::collections::HashMap<crate::model::DevicePlatform, i32>>,
    /// <p>The maximum number of minutes a test run executes before it times out.</p>
    pub max_job_timeout_minutes: std::option::Option<i32>,
    /// <p>Information about an AWS account's usage of free trial device minutes.</p>
    pub trial_minutes: std::option::Option<crate::model::TrialMinutes>,
    /// <p>The maximum number of device slots that the AWS account can purchase. Each maximum
    /// is expressed as an <code>offering-id:number</code> pair, where the
    /// <code>offering-id</code> represents one of the IDs returned by the
    /// <code>ListOfferings</code> command.</p>
    pub max_slots: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    /// <p>The default number of minutes (at the account level) a test run executes before it times out. The
    /// default value is 150 minutes.</p>
    pub default_job_timeout_minutes: std::option::Option<i32>,
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub skip_app_resign: std::option::Option<bool>,
}
impl AccountSettings {
    /// <p>The AWS account number specified in the <code>AccountSettings</code>
    /// container.</p>
    pub fn aws_account_number(&self) -> std::option::Option<&str> {
        self.aws_account_number.as_deref()
    }
    /// <p>Returns the unmetered devices you have purchased or want to purchase.</p>
    pub fn unmetered_devices(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::DevicePlatform, i32>> {
        self.unmetered_devices.as_ref()
    }
    /// <p>Returns the unmetered remote access devices you have purchased or want to
    /// purchase.</p>
    pub fn unmetered_remote_access_devices(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::DevicePlatform, i32>> {
        self.unmetered_remote_access_devices.as_ref()
    }
    /// <p>The maximum number of minutes a test run executes before it times out.</p>
    pub fn max_job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.max_job_timeout_minutes
    }
    /// <p>Information about an AWS account's usage of free trial device minutes.</p>
    pub fn trial_minutes(&self) -> std::option::Option<&crate::model::TrialMinutes> {
        self.trial_minutes.as_ref()
    }
    /// <p>The maximum number of device slots that the AWS account can purchase. Each maximum
    /// is expressed as an <code>offering-id:number</code> pair, where the
    /// <code>offering-id</code> represents one of the IDs returned by the
    /// <code>ListOfferings</code> command.</p>
    pub fn max_slots(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i32>> {
        self.max_slots.as_ref()
    }
    /// <p>The default number of minutes (at the account level) a test run executes before it times out. The
    /// default value is 150 minutes.</p>
    pub fn default_job_timeout_minutes(&self) -> std::option::Option<i32> {
        self.default_job_timeout_minutes
    }
    /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
    /// devices, Device Farm always signs your apps again.</p>
    /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
    /// Farm FAQs</i>.</p>
    pub fn skip_app_resign(&self) -> std::option::Option<bool> {
        self.skip_app_resign
    }
}
impl std::fmt::Debug for AccountSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountSettings");
        formatter.field("aws_account_number", &self.aws_account_number);
        formatter.field("unmetered_devices", &self.unmetered_devices);
        formatter.field(
            "unmetered_remote_access_devices",
            &self.unmetered_remote_access_devices,
        );
        formatter.field("max_job_timeout_minutes", &self.max_job_timeout_minutes);
        formatter.field("trial_minutes", &self.trial_minutes);
        formatter.field("max_slots", &self.max_slots);
        formatter.field(
            "default_job_timeout_minutes",
            &self.default_job_timeout_minutes,
        );
        formatter.field("skip_app_resign", &self.skip_app_resign);
        formatter.finish()
    }
}
/// See [`AccountSettings`](crate::model::AccountSettings)
pub mod account_settings {
    /// A builder for [`AccountSettings`](crate::model::AccountSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_number: std::option::Option<std::string::String>,
        pub(crate) unmetered_devices:
            std::option::Option<std::collections::HashMap<crate::model::DevicePlatform, i32>>,
        pub(crate) unmetered_remote_access_devices:
            std::option::Option<std::collections::HashMap<crate::model::DevicePlatform, i32>>,
        pub(crate) max_job_timeout_minutes: std::option::Option<i32>,
        pub(crate) trial_minutes: std::option::Option<crate::model::TrialMinutes>,
        pub(crate) max_slots:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        pub(crate) default_job_timeout_minutes: std::option::Option<i32>,
        pub(crate) skip_app_resign: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The AWS account number specified in the <code>AccountSettings</code>
        /// container.</p>
        pub fn aws_account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_number = Some(input.into());
            self
        }
        /// <p>The AWS account number specified in the <code>AccountSettings</code>
        /// container.</p>
        pub fn set_aws_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_number = input;
            self
        }
        /// Adds a key-value pair to `unmetered_devices`.
        ///
        /// To override the contents of this collection use [`set_unmetered_devices`](Self::set_unmetered_devices).
        ///
        /// <p>Returns the unmetered devices you have purchased or want to purchase.</p>
        pub fn unmetered_devices(
            mut self,
            k: impl Into<crate::model::DevicePlatform>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.unmetered_devices.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.unmetered_devices = Some(hash_map);
            self
        }
        /// <p>Returns the unmetered devices you have purchased or want to purchase.</p>
        pub fn set_unmetered_devices(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DevicePlatform, i32>,
            >,
        ) -> Self {
            self.unmetered_devices = input;
            self
        }
        /// Adds a key-value pair to `unmetered_remote_access_devices`.
        ///
        /// To override the contents of this collection use [`set_unmetered_remote_access_devices`](Self::set_unmetered_remote_access_devices).
        ///
        /// <p>Returns the unmetered remote access devices you have purchased or want to
        /// purchase.</p>
        pub fn unmetered_remote_access_devices(
            mut self,
            k: impl Into<crate::model::DevicePlatform>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.unmetered_remote_access_devices.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.unmetered_remote_access_devices = Some(hash_map);
            self
        }
        /// <p>Returns the unmetered remote access devices you have purchased or want to
        /// purchase.</p>
        pub fn set_unmetered_remote_access_devices(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DevicePlatform, i32>,
            >,
        ) -> Self {
            self.unmetered_remote_access_devices = input;
            self
        }
        /// <p>The maximum number of minutes a test run executes before it times out.</p>
        pub fn max_job_timeout_minutes(mut self, input: i32) -> Self {
            self.max_job_timeout_minutes = Some(input);
            self
        }
        /// <p>The maximum number of minutes a test run executes before it times out.</p>
        pub fn set_max_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.max_job_timeout_minutes = input;
            self
        }
        /// <p>Information about an AWS account's usage of free trial device minutes.</p>
        pub fn trial_minutes(mut self, input: crate::model::TrialMinutes) -> Self {
            self.trial_minutes = Some(input);
            self
        }
        /// <p>Information about an AWS account's usage of free trial device minutes.</p>
        pub fn set_trial_minutes(
            mut self,
            input: std::option::Option<crate::model::TrialMinutes>,
        ) -> Self {
            self.trial_minutes = input;
            self
        }
        /// Adds a key-value pair to `max_slots`.
        ///
        /// To override the contents of this collection use [`set_max_slots`](Self::set_max_slots).
        ///
        /// <p>The maximum number of device slots that the AWS account can purchase. Each maximum
        /// is expressed as an <code>offering-id:number</code> pair, where the
        /// <code>offering-id</code> represents one of the IDs returned by the
        /// <code>ListOfferings</code> command.</p>
        pub fn max_slots(mut self, k: impl Into<std::string::String>, v: impl Into<i32>) -> Self {
            let mut hash_map = self.max_slots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.max_slots = Some(hash_map);
            self
        }
        /// <p>The maximum number of device slots that the AWS account can purchase. Each maximum
        /// is expressed as an <code>offering-id:number</code> pair, where the
        /// <code>offering-id</code> represents one of the IDs returned by the
        /// <code>ListOfferings</code> command.</p>
        pub fn set_max_slots(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.max_slots = input;
            self
        }
        /// <p>The default number of minutes (at the account level) a test run executes before it times out. The
        /// default value is 150 minutes.</p>
        pub fn default_job_timeout_minutes(mut self, input: i32) -> Self {
            self.default_job_timeout_minutes = Some(input);
            self
        }
        /// <p>The default number of minutes (at the account level) a test run executes before it times out. The
        /// default value is 150 minutes.</p>
        pub fn set_default_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.default_job_timeout_minutes = input;
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn skip_app_resign(mut self, input: bool) -> Self {
            self.skip_app_resign = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information about how Device Farm re-signs your apps, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device
        /// Farm FAQs</i>.</p>
        pub fn set_skip_app_resign(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_app_resign = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountSettings`](crate::model::AccountSettings)
        pub fn build(self) -> crate::model::AccountSettings {
            crate::model::AccountSettings {
                aws_account_number: self.aws_account_number,
                unmetered_devices: self.unmetered_devices,
                unmetered_remote_access_devices: self.unmetered_remote_access_devices,
                max_job_timeout_minutes: self.max_job_timeout_minutes,
                trial_minutes: self.trial_minutes,
                max_slots: self.max_slots,
                default_job_timeout_minutes: self.default_job_timeout_minutes,
                skip_app_resign: self.skip_app_resign,
            }
        }
    }
}
impl AccountSettings {
    /// Creates a new builder-style object to manufacture [`AccountSettings`](crate::model::AccountSettings)
    pub fn builder() -> crate::model::account_settings::Builder {
        crate::model::account_settings::Builder::default()
    }
}

/// <p>Represents information about free trial device minutes for an AWS
/// account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrialMinutes {
    /// <p>The total number of free trial minutes that the account started with.</p>
    pub total: std::option::Option<f64>,
    /// <p>The number of free trial minutes remaining in the account.</p>
    pub remaining: std::option::Option<f64>,
}
impl TrialMinutes {
    /// <p>The total number of free trial minutes that the account started with.</p>
    pub fn total(&self) -> std::option::Option<f64> {
        self.total
    }
    /// <p>The number of free trial minutes remaining in the account.</p>
    pub fn remaining(&self) -> std::option::Option<f64> {
        self.remaining
    }
}
impl std::fmt::Debug for TrialMinutes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrialMinutes");
        formatter.field("total", &self.total);
        formatter.field("remaining", &self.remaining);
        formatter.finish()
    }
}
/// See [`TrialMinutes`](crate::model::TrialMinutes)
pub mod trial_minutes {
    /// A builder for [`TrialMinutes`](crate::model::TrialMinutes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<f64>,
        pub(crate) remaining: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The total number of free trial minutes that the account started with.</p>
        pub fn total(mut self, input: f64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total number of free trial minutes that the account started with.</p>
        pub fn set_total(mut self, input: std::option::Option<f64>) -> Self {
            self.total = input;
            self
        }
        /// <p>The number of free trial minutes remaining in the account.</p>
        pub fn remaining(mut self, input: f64) -> Self {
            self.remaining = Some(input);
            self
        }
        /// <p>The number of free trial minutes remaining in the account.</p>
        pub fn set_remaining(mut self, input: std::option::Option<f64>) -> Self {
            self.remaining = input;
            self
        }
        /// Consumes the builder and constructs a [`TrialMinutes`](crate::model::TrialMinutes)
        pub fn build(self) -> crate::model::TrialMinutes {
            crate::model::TrialMinutes {
                total: self.total,
                remaining: self.remaining,
            }
        }
    }
}
impl TrialMinutes {
    /// Creates a new builder-style object to manufacture [`TrialMinutes`](crate::model::TrialMinutes)
    pub fn builder() -> crate::model::trial_minutes::Builder {
        crate::model::trial_minutes::Builder::default()
    }
}

/// <p>Configuration settings for a remote access session, including billing
/// method.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRemoteAccessSessionConfiguration {
    /// <p>The billing method for the remote access session.</p>
    pub billing_method: std::option::Option<crate::model::BillingMethod>,
    /// <p>An array of ARNs included in the VPC endpoint configuration.</p>
    pub vpce_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateRemoteAccessSessionConfiguration {
    /// <p>The billing method for the remote access session.</p>
    pub fn billing_method(&self) -> std::option::Option<&crate::model::BillingMethod> {
        self.billing_method.as_ref()
    }
    /// <p>An array of ARNs included in the VPC endpoint configuration.</p>
    pub fn vpce_configuration_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.vpce_configuration_arns.as_deref()
    }
}
impl std::fmt::Debug for CreateRemoteAccessSessionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRemoteAccessSessionConfiguration");
        formatter.field("billing_method", &self.billing_method);
        formatter.field("vpce_configuration_arns", &self.vpce_configuration_arns);
        formatter.finish()
    }
}
/// See [`CreateRemoteAccessSessionConfiguration`](crate::model::CreateRemoteAccessSessionConfiguration)
pub mod create_remote_access_session_configuration {
    /// A builder for [`CreateRemoteAccessSessionConfiguration`](crate::model::CreateRemoteAccessSessionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_method: std::option::Option<crate::model::BillingMethod>,
        pub(crate) vpce_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The billing method for the remote access session.</p>
        pub fn billing_method(mut self, input: crate::model::BillingMethod) -> Self {
            self.billing_method = Some(input);
            self
        }
        /// <p>The billing method for the remote access session.</p>
        pub fn set_billing_method(
            mut self,
            input: std::option::Option<crate::model::BillingMethod>,
        ) -> Self {
            self.billing_method = input;
            self
        }
        /// Appends an item to `vpce_configuration_arns`.
        ///
        /// To override the contents of this collection use [`set_vpce_configuration_arns`](Self::set_vpce_configuration_arns).
        ///
        /// <p>An array of ARNs included in the VPC endpoint configuration.</p>
        pub fn vpce_configuration_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpce_configuration_arns.unwrap_or_default();
            v.push(input.into());
            self.vpce_configuration_arns = Some(v);
            self
        }
        /// <p>An array of ARNs included in the VPC endpoint configuration.</p>
        pub fn set_vpce_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpce_configuration_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRemoteAccessSessionConfiguration`](crate::model::CreateRemoteAccessSessionConfiguration)
        pub fn build(self) -> crate::model::CreateRemoteAccessSessionConfiguration {
            crate::model::CreateRemoteAccessSessionConfiguration {
                billing_method: self.billing_method,
                vpce_configuration_arns: self.vpce_configuration_arns,
            }
        }
    }
}
impl CreateRemoteAccessSessionConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateRemoteAccessSessionConfiguration`](crate::model::CreateRemoteAccessSessionConfiguration)
    pub fn builder() -> crate::model::create_remote_access_session_configuration::Builder {
        crate::model::create_remote_access_session_configuration::Builder::default()
    }
}
