// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `DeviceFarm_20150623`.
///
/// This client allows ergonomic access to a `DeviceFarm_20150623`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateDevicePool` operation.
    ///
    /// See [`CreateDevicePool`](crate::client::fluent_builders::CreateDevicePool) for more information about the
    /// operation and its arguments.
    pub fn create_device_pool(&self) -> fluent_builders::CreateDevicePool<C, M, R> {
        fluent_builders::CreateDevicePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstanceProfile` operation.
    ///
    /// See [`CreateInstanceProfile`](crate::client::fluent_builders::CreateInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn create_instance_profile(&self) -> fluent_builders::CreateInstanceProfile<C, M, R> {
        fluent_builders::CreateInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkProfile` operation.
    ///
    /// See [`CreateNetworkProfile`](crate::client::fluent_builders::CreateNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn create_network_profile(&self) -> fluent_builders::CreateNetworkProfile<C, M, R> {
        fluent_builders::CreateNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRemoteAccessSession` operation.
    ///
    /// See [`CreateRemoteAccessSession`](crate::client::fluent_builders::CreateRemoteAccessSession) for more information about the
    /// operation and its arguments.
    pub fn create_remote_access_session(
        &self,
    ) -> fluent_builders::CreateRemoteAccessSession<C, M, R> {
        fluent_builders::CreateRemoteAccessSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTestGridProject` operation.
    ///
    /// See [`CreateTestGridProject`](crate::client::fluent_builders::CreateTestGridProject) for more information about the
    /// operation and its arguments.
    pub fn create_test_grid_project(&self) -> fluent_builders::CreateTestGridProject<C, M, R> {
        fluent_builders::CreateTestGridProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTestGridUrl` operation.
    ///
    /// See [`CreateTestGridUrl`](crate::client::fluent_builders::CreateTestGridUrl) for more information about the
    /// operation and its arguments.
    pub fn create_test_grid_url(&self) -> fluent_builders::CreateTestGridUrl<C, M, R> {
        fluent_builders::CreateTestGridUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUpload` operation.
    ///
    /// See [`CreateUpload`](crate::client::fluent_builders::CreateUpload) for more information about the
    /// operation and its arguments.
    pub fn create_upload(&self) -> fluent_builders::CreateUpload<C, M, R> {
        fluent_builders::CreateUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVPCEConfiguration` operation.
    ///
    /// See [`CreateVPCEConfiguration`](crate::client::fluent_builders::CreateVPCEConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_vpce_configuration(&self) -> fluent_builders::CreateVPCEConfiguration<C, M, R> {
        fluent_builders::CreateVPCEConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDevicePool` operation.
    ///
    /// See [`DeleteDevicePool`](crate::client::fluent_builders::DeleteDevicePool) for more information about the
    /// operation and its arguments.
    pub fn delete_device_pool(&self) -> fluent_builders::DeleteDevicePool<C, M, R> {
        fluent_builders::DeleteDevicePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstanceProfile` operation.
    ///
    /// See [`DeleteInstanceProfile`](crate::client::fluent_builders::DeleteInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_instance_profile(&self) -> fluent_builders::DeleteInstanceProfile<C, M, R> {
        fluent_builders::DeleteInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkProfile` operation.
    ///
    /// See [`DeleteNetworkProfile`](crate::client::fluent_builders::DeleteNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_network_profile(&self) -> fluent_builders::DeleteNetworkProfile<C, M, R> {
        fluent_builders::DeleteNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRemoteAccessSession` operation.
    ///
    /// See [`DeleteRemoteAccessSession`](crate::client::fluent_builders::DeleteRemoteAccessSession) for more information about the
    /// operation and its arguments.
    pub fn delete_remote_access_session(
        &self,
    ) -> fluent_builders::DeleteRemoteAccessSession<C, M, R> {
        fluent_builders::DeleteRemoteAccessSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRun` operation.
    ///
    /// See [`DeleteRun`](crate::client::fluent_builders::DeleteRun) for more information about the
    /// operation and its arguments.
    pub fn delete_run(&self) -> fluent_builders::DeleteRun<C, M, R> {
        fluent_builders::DeleteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTestGridProject` operation.
    ///
    /// See [`DeleteTestGridProject`](crate::client::fluent_builders::DeleteTestGridProject) for more information about the
    /// operation and its arguments.
    pub fn delete_test_grid_project(&self) -> fluent_builders::DeleteTestGridProject<C, M, R> {
        fluent_builders::DeleteTestGridProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUpload` operation.
    ///
    /// See [`DeleteUpload`](crate::client::fluent_builders::DeleteUpload) for more information about the
    /// operation and its arguments.
    pub fn delete_upload(&self) -> fluent_builders::DeleteUpload<C, M, R> {
        fluent_builders::DeleteUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVPCEConfiguration` operation.
    ///
    /// See [`DeleteVPCEConfiguration`](crate::client::fluent_builders::DeleteVPCEConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_vpce_configuration(&self) -> fluent_builders::DeleteVPCEConfiguration<C, M, R> {
        fluent_builders::DeleteVPCEConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountSettings` operation.
    ///
    /// See [`GetAccountSettings`](crate::client::fluent_builders::GetAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn get_account_settings(&self) -> fluent_builders::GetAccountSettings<C, M, R> {
        fluent_builders::GetAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevice` operation.
    ///
    /// See [`GetDevice`](crate::client::fluent_builders::GetDevice) for more information about the
    /// operation and its arguments.
    pub fn get_device(&self) -> fluent_builders::GetDevice<C, M, R> {
        fluent_builders::GetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeviceInstance` operation.
    ///
    /// See [`GetDeviceInstance`](crate::client::fluent_builders::GetDeviceInstance) for more information about the
    /// operation and its arguments.
    pub fn get_device_instance(&self) -> fluent_builders::GetDeviceInstance<C, M, R> {
        fluent_builders::GetDeviceInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevicePool` operation.
    ///
    /// See [`GetDevicePool`](crate::client::fluent_builders::GetDevicePool) for more information about the
    /// operation and its arguments.
    pub fn get_device_pool(&self) -> fluent_builders::GetDevicePool<C, M, R> {
        fluent_builders::GetDevicePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevicePoolCompatibility` operation.
    ///
    /// See [`GetDevicePoolCompatibility`](crate::client::fluent_builders::GetDevicePoolCompatibility) for more information about the
    /// operation and its arguments.
    pub fn get_device_pool_compatibility(
        &self,
    ) -> fluent_builders::GetDevicePoolCompatibility<C, M, R> {
        fluent_builders::GetDevicePoolCompatibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceProfile` operation.
    ///
    /// See [`GetInstanceProfile`](crate::client::fluent_builders::GetInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn get_instance_profile(&self) -> fluent_builders::GetInstanceProfile<C, M, R> {
        fluent_builders::GetInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJob` operation.
    ///
    /// See [`GetJob`](crate::client::fluent_builders::GetJob) for more information about the
    /// operation and its arguments.
    pub fn get_job(&self) -> fluent_builders::GetJob<C, M, R> {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkProfile` operation.
    ///
    /// See [`GetNetworkProfile`](crate::client::fluent_builders::GetNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn get_network_profile(&self) -> fluent_builders::GetNetworkProfile<C, M, R> {
        fluent_builders::GetNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOfferingStatus` operation.
    ///
    /// See [`GetOfferingStatus`](crate::client::fluent_builders::GetOfferingStatus) for more information about the
    /// operation and its arguments.
    pub fn get_offering_status(&self) -> fluent_builders::GetOfferingStatus<C, M, R> {
        fluent_builders::GetOfferingStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProject` operation.
    ///
    /// See [`GetProject`](crate::client::fluent_builders::GetProject) for more information about the
    /// operation and its arguments.
    pub fn get_project(&self) -> fluent_builders::GetProject<C, M, R> {
        fluent_builders::GetProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRemoteAccessSession` operation.
    ///
    /// See [`GetRemoteAccessSession`](crate::client::fluent_builders::GetRemoteAccessSession) for more information about the
    /// operation and its arguments.
    pub fn get_remote_access_session(&self) -> fluent_builders::GetRemoteAccessSession<C, M, R> {
        fluent_builders::GetRemoteAccessSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRun` operation.
    ///
    /// See [`GetRun`](crate::client::fluent_builders::GetRun) for more information about the
    /// operation and its arguments.
    pub fn get_run(&self) -> fluent_builders::GetRun<C, M, R> {
        fluent_builders::GetRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSuite` operation.
    ///
    /// See [`GetSuite`](crate::client::fluent_builders::GetSuite) for more information about the
    /// operation and its arguments.
    pub fn get_suite(&self) -> fluent_builders::GetSuite<C, M, R> {
        fluent_builders::GetSuite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTest` operation.
    ///
    /// See [`GetTest`](crate::client::fluent_builders::GetTest) for more information about the
    /// operation and its arguments.
    pub fn get_test(&self) -> fluent_builders::GetTest<C, M, R> {
        fluent_builders::GetTest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTestGridProject` operation.
    ///
    /// See [`GetTestGridProject`](crate::client::fluent_builders::GetTestGridProject) for more information about the
    /// operation and its arguments.
    pub fn get_test_grid_project(&self) -> fluent_builders::GetTestGridProject<C, M, R> {
        fluent_builders::GetTestGridProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTestGridSession` operation.
    ///
    /// See [`GetTestGridSession`](crate::client::fluent_builders::GetTestGridSession) for more information about the
    /// operation and its arguments.
    pub fn get_test_grid_session(&self) -> fluent_builders::GetTestGridSession<C, M, R> {
        fluent_builders::GetTestGridSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUpload` operation.
    ///
    /// See [`GetUpload`](crate::client::fluent_builders::GetUpload) for more information about the
    /// operation and its arguments.
    pub fn get_upload(&self) -> fluent_builders::GetUpload<C, M, R> {
        fluent_builders::GetUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVPCEConfiguration` operation.
    ///
    /// See [`GetVPCEConfiguration`](crate::client::fluent_builders::GetVPCEConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_vpce_configuration(&self) -> fluent_builders::GetVPCEConfiguration<C, M, R> {
        fluent_builders::GetVPCEConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InstallToRemoteAccessSession` operation.
    ///
    /// See [`InstallToRemoteAccessSession`](crate::client::fluent_builders::InstallToRemoteAccessSession) for more information about the
    /// operation and its arguments.
    pub fn install_to_remote_access_session(
        &self,
    ) -> fluent_builders::InstallToRemoteAccessSession<C, M, R> {
        fluent_builders::InstallToRemoteAccessSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListArtifacts` operation.
    ///
    /// See [`ListArtifacts`](crate::client::fluent_builders::ListArtifacts) for more information about the
    /// operation and its arguments.
    pub fn list_artifacts(&self) -> fluent_builders::ListArtifacts<C, M, R> {
        fluent_builders::ListArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeviceInstances` operation.
    ///
    /// See [`ListDeviceInstances`](crate::client::fluent_builders::ListDeviceInstances) for more information about the
    /// operation and its arguments.
    pub fn list_device_instances(&self) -> fluent_builders::ListDeviceInstances<C, M, R> {
        fluent_builders::ListDeviceInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevicePools` operation.
    ///
    /// See [`ListDevicePools`](crate::client::fluent_builders::ListDevicePools) for more information about the
    /// operation and its arguments.
    pub fn list_device_pools(&self) -> fluent_builders::ListDevicePools<C, M, R> {
        fluent_builders::ListDevicePools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevices` operation.
    ///
    /// See [`ListDevices`](crate::client::fluent_builders::ListDevices) for more information about the
    /// operation and its arguments.
    pub fn list_devices(&self) -> fluent_builders::ListDevices<C, M, R> {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceProfiles` operation.
    ///
    /// See [`ListInstanceProfiles`](crate::client::fluent_builders::ListInstanceProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_instance_profiles(&self) -> fluent_builders::ListInstanceProfiles<C, M, R> {
        fluent_builders::ListInstanceProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNetworkProfiles` operation.
    ///
    /// See [`ListNetworkProfiles`](crate::client::fluent_builders::ListNetworkProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_network_profiles(&self) -> fluent_builders::ListNetworkProfiles<C, M, R> {
        fluent_builders::ListNetworkProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOfferingPromotions` operation.
    ///
    /// See [`ListOfferingPromotions`](crate::client::fluent_builders::ListOfferingPromotions) for more information about the
    /// operation and its arguments.
    pub fn list_offering_promotions(&self) -> fluent_builders::ListOfferingPromotions<C, M, R> {
        fluent_builders::ListOfferingPromotions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOfferings` operation.
    ///
    /// See [`ListOfferings`](crate::client::fluent_builders::ListOfferings) for more information about the
    /// operation and its arguments.
    pub fn list_offerings(&self) -> fluent_builders::ListOfferings<C, M, R> {
        fluent_builders::ListOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOfferingTransactions` operation.
    ///
    /// See [`ListOfferingTransactions`](crate::client::fluent_builders::ListOfferingTransactions) for more information about the
    /// operation and its arguments.
    pub fn list_offering_transactions(&self) -> fluent_builders::ListOfferingTransactions<C, M, R> {
        fluent_builders::ListOfferingTransactions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRemoteAccessSessions` operation.
    ///
    /// See [`ListRemoteAccessSessions`](crate::client::fluent_builders::ListRemoteAccessSessions) for more information about the
    /// operation and its arguments.
    pub fn list_remote_access_sessions(
        &self,
    ) -> fluent_builders::ListRemoteAccessSessions<C, M, R> {
        fluent_builders::ListRemoteAccessSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRuns` operation.
    ///
    /// See [`ListRuns`](crate::client::fluent_builders::ListRuns) for more information about the
    /// operation and its arguments.
    pub fn list_runs(&self) -> fluent_builders::ListRuns<C, M, R> {
        fluent_builders::ListRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSamples` operation.
    ///
    /// See [`ListSamples`](crate::client::fluent_builders::ListSamples) for more information about the
    /// operation and its arguments.
    pub fn list_samples(&self) -> fluent_builders::ListSamples<C, M, R> {
        fluent_builders::ListSamples::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSuites` operation.
    ///
    /// See [`ListSuites`](crate::client::fluent_builders::ListSuites) for more information about the
    /// operation and its arguments.
    pub fn list_suites(&self) -> fluent_builders::ListSuites<C, M, R> {
        fluent_builders::ListSuites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTestGridProjects` operation.
    ///
    /// See [`ListTestGridProjects`](crate::client::fluent_builders::ListTestGridProjects) for more information about the
    /// operation and its arguments.
    pub fn list_test_grid_projects(&self) -> fluent_builders::ListTestGridProjects<C, M, R> {
        fluent_builders::ListTestGridProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTestGridSessionActions` operation.
    ///
    /// See [`ListTestGridSessionActions`](crate::client::fluent_builders::ListTestGridSessionActions) for more information about the
    /// operation and its arguments.
    pub fn list_test_grid_session_actions(
        &self,
    ) -> fluent_builders::ListTestGridSessionActions<C, M, R> {
        fluent_builders::ListTestGridSessionActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTestGridSessionArtifacts` operation.
    ///
    /// See [`ListTestGridSessionArtifacts`](crate::client::fluent_builders::ListTestGridSessionArtifacts) for more information about the
    /// operation and its arguments.
    pub fn list_test_grid_session_artifacts(
        &self,
    ) -> fluent_builders::ListTestGridSessionArtifacts<C, M, R> {
        fluent_builders::ListTestGridSessionArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTestGridSessions` operation.
    ///
    /// See [`ListTestGridSessions`](crate::client::fluent_builders::ListTestGridSessions) for more information about the
    /// operation and its arguments.
    pub fn list_test_grid_sessions(&self) -> fluent_builders::ListTestGridSessions<C, M, R> {
        fluent_builders::ListTestGridSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTests` operation.
    ///
    /// See [`ListTests`](crate::client::fluent_builders::ListTests) for more information about the
    /// operation and its arguments.
    pub fn list_tests(&self) -> fluent_builders::ListTests<C, M, R> {
        fluent_builders::ListTests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUniqueProblems` operation.
    ///
    /// See [`ListUniqueProblems`](crate::client::fluent_builders::ListUniqueProblems) for more information about the
    /// operation and its arguments.
    pub fn list_unique_problems(&self) -> fluent_builders::ListUniqueProblems<C, M, R> {
        fluent_builders::ListUniqueProblems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUploads` operation.
    ///
    /// See [`ListUploads`](crate::client::fluent_builders::ListUploads) for more information about the
    /// operation and its arguments.
    pub fn list_uploads(&self) -> fluent_builders::ListUploads<C, M, R> {
        fluent_builders::ListUploads::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVPCEConfigurations` operation.
    ///
    /// See [`ListVPCEConfigurations`](crate::client::fluent_builders::ListVPCEConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_vpce_configurations(&self) -> fluent_builders::ListVPCEConfigurations<C, M, R> {
        fluent_builders::ListVPCEConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseOffering` operation.
    ///
    /// See [`PurchaseOffering`](crate::client::fluent_builders::PurchaseOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_offering(&self) -> fluent_builders::PurchaseOffering<C, M, R> {
        fluent_builders::PurchaseOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RenewOffering` operation.
    ///
    /// See [`RenewOffering`](crate::client::fluent_builders::RenewOffering) for more information about the
    /// operation and its arguments.
    pub fn renew_offering(&self) -> fluent_builders::RenewOffering<C, M, R> {
        fluent_builders::RenewOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ScheduleRun` operation.
    ///
    /// See [`ScheduleRun`](crate::client::fluent_builders::ScheduleRun) for more information about the
    /// operation and its arguments.
    pub fn schedule_run(&self) -> fluent_builders::ScheduleRun<C, M, R> {
        fluent_builders::ScheduleRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopJob` operation.
    ///
    /// See [`StopJob`](crate::client::fluent_builders::StopJob) for more information about the
    /// operation and its arguments.
    pub fn stop_job(&self) -> fluent_builders::StopJob<C, M, R> {
        fluent_builders::StopJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopRemoteAccessSession` operation.
    ///
    /// See [`StopRemoteAccessSession`](crate::client::fluent_builders::StopRemoteAccessSession) for more information about the
    /// operation and its arguments.
    pub fn stop_remote_access_session(&self) -> fluent_builders::StopRemoteAccessSession<C, M, R> {
        fluent_builders::StopRemoteAccessSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopRun` operation.
    ///
    /// See [`StopRun`](crate::client::fluent_builders::StopRun) for more information about the
    /// operation and its arguments.
    pub fn stop_run(&self) -> fluent_builders::StopRun<C, M, R> {
        fluent_builders::StopRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeviceInstance` operation.
    ///
    /// See [`UpdateDeviceInstance`](crate::client::fluent_builders::UpdateDeviceInstance) for more information about the
    /// operation and its arguments.
    pub fn update_device_instance(&self) -> fluent_builders::UpdateDeviceInstance<C, M, R> {
        fluent_builders::UpdateDeviceInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDevicePool` operation.
    ///
    /// See [`UpdateDevicePool`](crate::client::fluent_builders::UpdateDevicePool) for more information about the
    /// operation and its arguments.
    pub fn update_device_pool(&self) -> fluent_builders::UpdateDevicePool<C, M, R> {
        fluent_builders::UpdateDevicePool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInstanceProfile` operation.
    ///
    /// See [`UpdateInstanceProfile`](crate::client::fluent_builders::UpdateInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn update_instance_profile(&self) -> fluent_builders::UpdateInstanceProfile<C, M, R> {
        fluent_builders::UpdateInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNetworkProfile` operation.
    ///
    /// See [`UpdateNetworkProfile`](crate::client::fluent_builders::UpdateNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn update_network_profile(&self) -> fluent_builders::UpdateNetworkProfile<C, M, R> {
        fluent_builders::UpdateNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTestGridProject` operation.
    ///
    /// See [`UpdateTestGridProject`](crate::client::fluent_builders::UpdateTestGridProject) for more information about the
    /// operation and its arguments.
    pub fn update_test_grid_project(&self) -> fluent_builders::UpdateTestGridProject<C, M, R> {
        fluent_builders::UpdateTestGridProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUpload` operation.
    ///
    /// See [`UpdateUpload`](crate::client::fluent_builders::UpdateUpload) for more information about the
    /// operation and its arguments.
    pub fn update_upload(&self) -> fluent_builders::UpdateUpload<C, M, R> {
        fluent_builders::UpdateUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVPCEConfiguration` operation.
    ///
    /// See [`UpdateVPCEConfiguration`](crate::client::fluent_builders::UpdateVPCEConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_vpce_configuration(&self) -> fluent_builders::UpdateVPCEConfiguration<C, M, R> {
        fluent_builders::UpdateVPCEConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDevicePool`.
    ///
    /// <p>Creates a device pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDevicePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_pool_input::Builder,
    }
    impl<C, M, R> CreateDevicePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDevicePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDevicePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDevicePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDevicePoolInputOperationOutputAlias,
                crate::output::CreateDevicePoolOutput,
                crate::error::CreateDevicePoolError,
                crate::input::CreateDevicePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the project for the device pool.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN of the project for the device pool.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>The device pool's name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The device pool's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The device pool's description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The device pool's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The device pool's rules.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::Rule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>The device pool's rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
        /// available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many
        /// devices meet these constraints, your device pool might contain fewer devices than the value for this
        /// parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur
        /// by running tests.</p>
        pub fn max_devices(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_devices(inp);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
        /// available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many
        /// devices meet these constraints, your device pool might contain fewer devices than the value for this
        /// parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur
        /// by running tests.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_devices(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceProfile`.
    ///
    /// <p>Creates a profile that can be applied to one or more private fleet device
    /// instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_profile_input::Builder,
    }
    impl<C, M, R> CreateInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceProfileInputOperationOutputAlias,
                crate::output::CreateInstanceProfileOutput,
                crate::error::CreateInstanceProfileError,
                crate::input::CreateInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your instance profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of your instance profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of your instance profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of your instance profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is
        /// <code>false</code> for private devices.</p>
        pub fn package_cleanup(mut self, inp: bool) -> Self {
            self.inner = self.inner.package_cleanup(inp);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm removes app packages after a test run. The default value is
        /// <code>false</code> for private devices.</p>
        pub fn set_package_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_package_cleanup(input);
            self
        }
        /// Appends an item to `excludeAppPackagesFromCleanup`.
        ///
        /// To override the contents of this collection use [`set_exclude_app_packages_from_cleanup`](Self::set_exclude_app_packages_from_cleanup).
        ///
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device
        /// after a test run.</p>
        /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to
        /// <code>true</code>.</p>
        pub fn exclude_app_packages_from_cleanup(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.exclude_app_packages_from_cleanup(inp);
            self
        }
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device
        /// after a test run.</p>
        /// <p>The list of packages is considered only if you set <code>packageCleanup</code> to
        /// <code>true</code>.</p>
        pub fn set_exclude_app_packages_from_cleanup(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exclude_app_packages_from_cleanup(input);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is
        /// <code>true</code>.</p>
        pub fn reboot_after_use(mut self, inp: bool) -> Self {
            self.inner = self.inner.reboot_after_use(inp);
            self
        }
        /// <p>When set to <code>true</code>, Device Farm reboots the instance after a test run. The default value is
        /// <code>true</code>.</p>
        pub fn set_reboot_after_use(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reboot_after_use(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkProfile`.
    ///
    /// <p>Creates a network profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_profile_input::Builder,
    }
    impl<C, M, R> CreateNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkProfileInputOperationOutputAlias,
                crate::output::CreateNetworkProfileOutput,
                crate::error::CreateNetworkProfileError,
                crate::input::CreateNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a
        /// network profile.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a
        /// network profile.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>The name for the new network profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the new network profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the network profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of network profile to create. Valid values are listed here.</p>
        pub fn r#type(mut self, inp: crate::model::NetworkProfileType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of network profile to create. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn uplink_bandwidth_bits(mut self, inp: i64) -> Self {
            self.inner = self.inner.uplink_bandwidth_bits(inp);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn set_uplink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_uplink_bandwidth_bits(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn downlink_bandwidth_bits(mut self, inp: i64) -> Self {
            self.inner = self.inner.downlink_bandwidth_bits(inp);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn set_downlink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_downlink_bandwidth_bits(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn uplink_delay_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.uplink_delay_ms(inp);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn set_uplink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_uplink_delay_ms(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn downlink_delay_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.downlink_delay_ms(inp);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn set_downlink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_downlink_delay_ms(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn uplink_jitter_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.uplink_jitter_ms(inp);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn set_uplink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_uplink_jitter_ms(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn downlink_jitter_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.downlink_jitter_ms(inp);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn set_downlink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_downlink_jitter_ms(input);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
        /// percent.</p>
        pub fn uplink_loss_percent(mut self, inp: i32) -> Self {
            self.inner = self.inner.uplink_loss_percent(inp);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
        /// percent.</p>
        pub fn set_uplink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_uplink_loss_percent(input);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn downlink_loss_percent(mut self, inp: i32) -> Self {
            self.inner = self.inner.downlink_loss_percent(inp);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_downlink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_downlink_loss_percent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The project's name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The project's name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Sets the execution timeout value (in minutes) for a project. All test runs in this project use the
        /// specified execution timeout value unless overridden when scheduling a run.</p>
        pub fn default_job_timeout_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.default_job_timeout_minutes(inp);
            self
        }
        /// <p>Sets the execution timeout value (in minutes) for a project. All test runs in this project use the
        /// specified execution timeout value unless overridden when scheduling a run.</p>
        pub fn set_default_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_job_timeout_minutes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRemoteAccessSession`.
    ///
    /// <p>Specifies and starts a remote access session.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRemoteAccessSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_remote_access_session_input::Builder,
    }
    impl<C, M, R> CreateRemoteAccessSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRemoteAccessSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRemoteAccessSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRemoteAccessSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRemoteAccessSessionInputOperationOutputAlias,
                crate::output::CreateRemoteAccessSessionOutput,
                crate::error::CreateRemoteAccessSessionError,
                crate::input::CreateRemoteAccessSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a remote
        /// access session.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to create a remote
        /// access session.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>The ARN of the device for which you want to create a remote access session.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device for which you want to create a remote access session.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance for which you want to create a
        /// remote access session.</p>
        pub fn instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance for which you want to create a
        /// remote access session.</p>
        pub fn set_instance_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_arn(input);
            self
        }
        /// <p>Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote
        /// devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is
        /// set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn ssh_public_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key(inp);
            self
        }
        /// <p>Ignored. The public key of the <code>ssh</code> key pair you want to use for connecting to remote
        /// devices in your remote debugging session. This key is required only if <code>remoteDebugEnabled</code> is
        /// set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key(input);
            self
        }
        /// <p>Set to <code>true</code> if you want to access devices remotely for debugging in
        /// your remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn remote_debug_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.remote_debug_enabled(inp);
            self
        }
        /// <p>Set to <code>true</code> if you want to access devices remotely for debugging in
        /// your remote access session.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_remote_debug_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remote_debug_enabled(input);
            self
        }
        /// <p>Set to <code>true</code> to enable remote recording for the remote access
        /// session.</p>
        pub fn remote_record_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.remote_record_enabled(inp);
            self
        }
        /// <p>Set to <code>true</code> to enable remote recording for the remote access
        /// session.</p>
        pub fn set_remote_record_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remote_record_enabled(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the app to be recorded in the remote access
        /// session.</p>
        pub fn remote_record_app_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_record_app_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the app to be recorded in the remote access
        /// session.</p>
        pub fn set_remote_record_app_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_record_app_arn(input);
            self
        }
        /// <p>The name of the remote access session to create.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the remote access session to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Unique identifier for the client. If you want access to multiple devices on the same client, you should
        /// pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This
        /// identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn client_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(inp);
            self
        }
        /// <p>Unique identifier for the client. If you want access to multiple devices on the same client, you should
        /// pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This
        /// identifier is required only if <code>remoteDebugEnabled</code> is set to <code>true</code>.</p>
        /// <p>Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The configuration information for the remote access session request.</p>
        pub fn configuration(
            mut self,
            inp: crate::model::CreateRemoteAccessSessionConfiguration,
        ) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The configuration information for the remote access session request.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateRemoteAccessSessionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The interaction mode of the remote access session. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and
        /// rotating the screen. You cannot run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This
        /// mode has the fastest test execution speed. You can run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
        /// framework-based tests and watch the screen in this mode.</p>
        /// </li>
        /// </ul>
        pub fn interaction_mode(mut self, inp: crate::model::InteractionMode) -> Self {
            self.inner = self.inner.interaction_mode(inp);
            self
        }
        /// <p>The interaction mode of the remote access session. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>INTERACTIVE: You can interact with the iOS device by viewing, touching, and
        /// rotating the screen. You cannot run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This
        /// mode has the fastest test execution speed. You can run XCUITest framework-based tests in this
        /// mode.</p>
        /// </li>
        /// <li>
        /// <p>VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest
        /// framework-based tests and watch the screen in this mode.</p>
        /// </li>
        /// </ul>
        pub fn set_interaction_mode(
            mut self,
            input: std::option::Option<crate::model::InteractionMode>,
        ) -> Self {
            self.inner = self.inner.set_interaction_mode(input);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information on how Device Farm modifies your uploads during tests, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a>
        /// </p>
        pub fn skip_app_resign(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_app_resign(inp);
            self
        }
        /// <p>When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
        /// devices, Device Farm always signs your apps again.</p>
        /// <p>For more information on how Device Farm modifies your uploads during tests, see <a href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a>
        /// </p>
        pub fn set_skip_app_resign(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_app_resign(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTestGridProject`.
    ///
    /// <p>Creates a Selenium testing project. Projects are used to track <a>TestGridSession</a>
    /// instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTestGridProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_test_grid_project_input::Builder,
    }
    impl<C, M, R> CreateTestGridProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTestGridProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTestGridProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTestGridProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTestGridProjectInputOperationOutputAlias,
                crate::output::CreateTestGridProjectOutput,
                crate::error::CreateTestGridProjectError,
                crate::input::CreateTestGridProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Human-readable name of the Selenium testing project.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Human-readable name of the Selenium testing project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Human-readable description of the project.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Human-readable description of the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn vpc_config(mut self, inp: crate::model::TestGridVpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::TestGridVpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTestGridUrl`.
    ///
    /// <p>Creates a signed, short-term URL that can be passed to a Selenium <code>RemoteWebDriver</code>
    /// constructor.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTestGridUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_test_grid_url_input::Builder,
    }
    impl<C, M, R> CreateTestGridUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTestGridUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTestGridUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTestGridUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTestGridUrlInputOperationOutputAlias,
                crate::output::CreateTestGridUrlOutput,
                crate::error::CreateTestGridUrlError,
                crate::input::CreateTestGridUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN (from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>) to associate
        /// with the short-term URL. </p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>ARN (from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>) to associate
        /// with the short-term URL. </p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>Lifetime, in seconds, of the URL.</p>
        pub fn expires_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.expires_in_seconds(inp);
            self
        }
        /// <p>Lifetime, in seconds, of the URL.</p>
        pub fn set_expires_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expires_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUpload`.
    ///
    /// <p>Uploads an app or test scripts.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_upload_input::Builder,
    }
    impl<C, M, R> CreateUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUploadInputOperationOutputAlias,
                crate::output::CreateUploadOutput,
                crate::error::CreateUploadError,
                crate::input::CreateUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the project for the upload.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN of the project for the upload.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>The upload's file name. The name should not contain any forward slashes (<code>/</code>). If you are
        /// uploading an iOS app, the file name must end with the <code>.ipa</code> extension. If you are uploading an
        /// Android app, the file name must end with the <code>.apk</code> extension. For all others, the file name must
        /// end with the <code>.zip</code> file extension.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The upload's file name. The name should not contain any forward slashes (<code>/</code>). If you are
        /// uploading an iOS app, the file name must end with the <code>.ipa</code> extension. If you are uploading an
        /// Android app, the file name must end with the <code>.apk</code> extension. For all others, the file name must
        /// end with the <code>.zip</code> file extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The upload's upload type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID_APP</p>
        /// </li>
        /// <li>
        /// <p>IOS_APP</p>
        /// </li>
        /// <li>
        /// <p>WEB_APP</p>
        /// </li>
        /// <li>
        /// <p>EXTERNAL_DATA</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_SPEC</p>
        /// </li>
        /// </ul>
        /// <p> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS
        /// Device Farm throws an <code>ArgumentException</code> error.</p>
        pub fn r#type(mut self, inp: crate::model::UploadType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The upload's upload type.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID_APP</p>
        /// </li>
        /// <li>
        /// <p>IOS_APP</p>
        /// </li>
        /// <li>
        /// <p>WEB_APP</p>
        /// </li>
        /// <li>
        /// <p>EXTERNAL_DATA</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_SPEC</p>
        /// </li>
        /// </ul>
        /// <p> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS
        /// Device Farm throws an <code>ArgumentException</code> error.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UploadType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>The upload's content type (for example, <code>application/octet-stream</code>).</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVPCEConfiguration`.
    ///
    /// <p>Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud
    /// (VPC) endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVPCEConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vpce_configuration_input::Builder,
    }
    impl<C, M, R> CreateVPCEConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVPCEConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpceConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVPCEConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVpceConfigurationInputOperationOutputAlias,
                crate::output::CreateVpceConfigurationOutput,
                crate::error::CreateVPCEConfigurationError,
                crate::input::CreateVpceConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The friendly name you give to your VPC endpoint configuration, to manage your
        /// configurations more easily.</p>
        pub fn vpce_configuration_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpce_configuration_name(inp);
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration, to manage your
        /// configurations more easily.</p>
        pub fn set_vpce_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpce_configuration_name(input);
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn vpce_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpce_service_name(inp);
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn set_vpce_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpce_service_name(input);
            self
        }
        /// <p>The DNS name of the service running in your VPC that you want Device Farm to
        /// test.</p>
        pub fn service_dns_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_dns_name(inp);
            self
        }
        /// <p>The DNS name of the service running in your VPC that you want Device Farm to
        /// test.</p>
        pub fn set_service_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_dns_name(input);
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn vpce_configuration_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.vpce_configuration_description(inp);
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpce_configuration_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDevicePool`.
    ///
    /// <p>Deletes a device pool given the pool ARN. Does not allow deletion of curated pools
    /// owned by the system.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDevicePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_pool_input::Builder,
    }
    impl<C, M, R> DeleteDevicePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDevicePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDevicePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDevicePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDevicePoolInputOperationOutputAlias,
                crate::output::DeleteDevicePoolOutput,
                crate::error::DeleteDevicePoolError,
                crate::input::DeleteDevicePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm device pool to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstanceProfile`.
    ///
    /// <p>Deletes a profile that can be applied to one or more private device instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_profile_input::Builder,
    }
    impl<C, M, R> DeleteInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstanceProfileInputOperationOutputAlias,
                crate::output::DeleteInstanceProfileOutput,
                crate::error::DeleteInstanceProfileError,
                crate::input::DeleteInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile you are requesting to
        /// delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile you are requesting to
        /// delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNetworkProfile`.
    ///
    /// <p>Deletes a network profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_network_profile_input::Builder,
    }
    impl<C, M, R> DeleteNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNetworkProfileInputOperationOutputAlias,
                crate::output::DeleteNetworkProfileOutput,
                crate::error::DeleteNetworkProfileError,
                crate::input::DeleteNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network profile to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the network profile to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an AWS Device Farm project, given the project ARN.</p>
    /// <p> Deleting this resource does not stop an in-progress run.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRemoteAccessSession`.
    ///
    /// <p>Deletes a completed remote access session and its results.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRemoteAccessSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_remote_access_session_input::Builder,
    }
    impl<C, M, R> DeleteRemoteAccessSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRemoteAccessSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRemoteAccessSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRemoteAccessSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRemoteAccessSessionInputOperationOutputAlias,
                crate::output::DeleteRemoteAccessSessionOutput,
                crate::error::DeleteRemoteAccessSessionError,
                crate::input::DeleteRemoteAccessSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the session for which you want to delete remote
        /// access.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session for which you want to delete remote
        /// access.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRun`.
    ///
    /// <p>Deletes the run, given the run ARN.</p>
    /// <p> Deleting this resource does not stop an in-progress run.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_run_input::Builder,
    }
    impl<C, M, R> DeleteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRunInputOperationOutputAlias,
                crate::output::DeleteRunOutput,
                crate::error::DeleteRunError,
                crate::input::DeleteRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the run to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the run to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTestGridProject`.
    ///
    /// <p> Deletes a Selenium testing project and all content generated under it. </p>
    /// <important>
    /// <p>You cannot undo this operation.</p>
    /// </important>
    /// <note>
    /// <p>You cannot delete a project if it has active sessions.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTestGridProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_test_grid_project_input::Builder,
    }
    impl<C, M, R> DeleteTestGridProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTestGridProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTestGridProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTestGridProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTestGridProjectInputOperationOutputAlias,
                crate::output::DeleteTestGridProjectOutput,
                crate::error::DeleteTestGridProjectError,
                crate::input::DeleteTestGridProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUpload`.
    ///
    /// <p>Deletes an upload given the upload ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_upload_input::Builder,
    }
    impl<C, M, R> DeleteUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUploadInputOperationOutputAlias,
                crate::output::DeleteUploadOutput,
                crate::error::DeleteUploadError,
                crate::input::DeleteUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVPCEConfiguration`.
    ///
    /// <p>Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVPCEConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_vpce_configuration_input::Builder,
    }
    impl<C, M, R> DeleteVPCEConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVPCEConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpceConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVPCEConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVpceConfigurationInputOperationOutputAlias,
                crate::output::DeleteVpceConfigurationOutput,
                crate::error::DeleteVPCEConfigurationError,
                crate::input::DeleteVpceConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
        /// delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
        /// delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSettings`.
    ///
    /// <p>Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_settings_input::Builder,
    }
    impl<C, M, R> GetAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSettingsInputOperationOutputAlias,
                crate::output::GetAccountSettingsOutput,
                crate::error::GetAccountSettingsError,
                crate::input::GetAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDevice`.
    ///
    /// <p>Gets information about a unique device type.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_input::Builder,
    }
    impl<C, M, R> GetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceInputOperationOutputAlias,
                crate::output::GetDeviceOutput,
                crate::error::GetDeviceError,
                crate::input::GetDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device type's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The device type's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeviceInstance`.
    ///
    /// <p>Returns information about a device instance that belongs to a private device fleet.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeviceInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_instance_input::Builder,
    }
    impl<C, M, R> GetDeviceInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceInstanceInputOperationOutputAlias,
                crate::output::GetDeviceInstanceOutput,
                crate::error::GetDeviceInstanceError,
                crate::input::GetDeviceInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the instance you're requesting information
        /// about.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance you're requesting information
        /// about.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevicePool`.
    ///
    /// <p>Gets information about a device pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDevicePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_pool_input::Builder,
    }
    impl<C, M, R> GetDevicePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevicePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevicePoolInputOperationOutputAlias,
                crate::output::GetDevicePoolOutput,
                crate::error::GetDevicePoolError,
                crate::input::GetDevicePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device pool's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The device pool's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevicePoolCompatibility`.
    ///
    /// <p>Gets information about compatibility with a device pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDevicePoolCompatibility<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_pool_compatibility_input::Builder,
    }
    impl<C, M, R> GetDevicePoolCompatibility<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevicePoolCompatibility`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicePoolCompatibilityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicePoolCompatibilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevicePoolCompatibilityInputOperationOutputAlias,
                crate::output::GetDevicePoolCompatibilityOutput,
                crate::error::GetDevicePoolCompatibilityError,
                crate::input::GetDevicePoolCompatibilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device pool's ARN.</p>
        pub fn device_pool_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_pool_arn(inp);
            self
        }
        /// <p>The device pool's ARN.</p>
        pub fn set_device_pool_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_pool_arn(input);
            self
        }
        /// <p>The ARN of the app that is associated with the specified device pool.</p>
        pub fn app_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(inp);
            self
        }
        /// <p>The ARN of the app that is associated with the specified device pool.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The test type for the specified device pool.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ.</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with
        /// it and capturing screenshots at the same time.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY.</p>
        /// </li>
        /// <li>
        /// <p>CALABASH.</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION.</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION.</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR.</p>
        /// </li>
        /// <li>
        /// <p>XCTEST.</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI.</p>
        /// </li>
        /// </ul>
        pub fn test_type(mut self, inp: crate::model::TestType) -> Self {
            self.inner = self.inner.test_type(inp);
            self
        }
        /// <p>The test type for the specified device pool.</p>
        /// <p>Allowed values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>BUILTIN_FUZZ.</p>
        /// </li>
        /// <li>
        /// <p>BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with
        /// it and capturing screenshots at the same time.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE.</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY.</p>
        /// </li>
        /// <li>
        /// <p>CALABASH.</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION.</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION.</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR.</p>
        /// </li>
        /// <li>
        /// <p>XCTEST.</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI.</p>
        /// </li>
        /// </ul>
        pub fn set_test_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.inner = self.inner.set_test_type(input);
            self
        }
        /// <p>Information about the uploaded test to be run against the device pool.</p>
        pub fn test(mut self, inp: crate::model::ScheduleRunTest) -> Self {
            self.inner = self.inner.test(inp);
            self
        }
        /// <p>Information about the uploaded test to be run against the device pool.</p>
        pub fn set_test(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunTest>,
        ) -> Self {
            self.inner = self.inner.set_test(input);
            self
        }
        /// <p>An object that contains information about the settings for a run.</p>
        pub fn configuration(mut self, inp: crate::model::ScheduleRunConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>An object that contains information about the settings for a run.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceProfile`.
    ///
    /// <p>Returns information about the specified instance profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_profile_input::Builder,
    }
    impl<C, M, R> GetInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceProfileInputOperationOutputAlias,
                crate::output::GetInstanceProfileOutput,
                crate::error::GetInstanceProfileError,
                crate::input::GetInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an instance profile.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p>Gets information about a job.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_input::Builder,
    }
    impl<C, M, R> GetJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobInputOperationOutputAlias,
                crate::output::GetJobOutput,
                crate::error::GetJobError,
                crate::input::GetJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The job's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkProfile`.
    ///
    /// <p>Returns information about a network profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_profile_input::Builder,
    }
    impl<C, M, R> GetNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkProfileInputOperationOutputAlias,
                crate::output::GetNetworkProfileOutput,
                crate::error::GetNetworkProfileError,
                crate::input::GetNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network profile to return information about.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the network profile to return information about.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOfferingStatus`.
    ///
    /// <p>Gets the current status and future status of all offerings purchased by an AWS account. The response
    /// indicates how many offerings are currently available and the offerings that will be available in the next
    /// period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
    /// operation. If you must be able to invoke this operation, contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOfferingStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_offering_status_input::Builder,
    }
    impl<C, M, R> GetOfferingStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOfferingStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOfferingStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOfferingStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOfferingStatusInputOperationOutputAlias,
                crate::output::GetOfferingStatusOutput,
                crate::error::GetOfferingStatusError,
                crate::input::GetOfferingStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProject`.
    ///
    /// <p>Gets information about a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_project_input::Builder,
    }
    impl<C, M, R> GetProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProjectInputOperationOutputAlias,
                crate::output::GetProjectOutput,
                crate::error::GetProjectError,
                crate::input::GetProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The project's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The project's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRemoteAccessSession`.
    ///
    /// <p>Returns a link to a currently running remote access session.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRemoteAccessSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_remote_access_session_input::Builder,
    }
    impl<C, M, R> GetRemoteAccessSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRemoteAccessSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRemoteAccessSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRemoteAccessSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRemoteAccessSessionInputOperationOutputAlias,
                crate::output::GetRemoteAccessSessionOutput,
                crate::error::GetRemoteAccessSessionError,
                crate::input::GetRemoteAccessSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you want to
        /// get session information.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you want to
        /// get session information.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRun`.
    ///
    /// <p>Gets information about a run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_run_input::Builder,
    }
    impl<C, M, R> GetRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRunInputOperationOutputAlias,
                crate::output::GetRunOutput,
                crate::error::GetRunError,
                crate::input::GetRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The run's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The run's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuite`.
    ///
    /// <p>Gets information about a suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSuite<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_input::Builder,
    }
    impl<C, M, R> GetSuite<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteInputOperationOutputAlias,
                crate::output::GetSuiteOutput,
                crate::error::GetSuiteError,
                crate::input::GetSuiteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The suite's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The suite's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTest`.
    ///
    /// <p>Gets information about a test.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTest<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_test_input::Builder,
    }
    impl<C, M, R> GetTest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTestInputOperationOutputAlias,
                crate::output::GetTestOutput,
                crate::error::GetTestError,
                crate::input::GetTestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The test's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The test's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTestGridProject`.
    ///
    /// <p>Retrieves information about a Selenium testing project.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTestGridProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_test_grid_project_input::Builder,
    }
    impl<C, M, R> GetTestGridProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTestGridProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTestGridProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTestGridProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTestGridProjectInputOperationOutputAlias,
                crate::output::GetTestGridProjectOutput,
                crate::error::GetTestGridProjectError,
                crate::input::GetTestGridProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Selenium testing project, from either <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN of the Selenium testing project, from either <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTestGridSession`.
    ///
    /// <p>A session is an instance of a browser created through a <code>RemoteWebDriver</code> with the URL from <a>CreateTestGridUrlResult$url</a>. You can use the following to look up sessions:</p>
    /// <ul>
    /// <li>
    /// <p>The session ARN (<a>GetTestGridSessionRequest$sessionArn</a>).</p>
    /// </li>
    /// <li>
    /// <p>The project ARN and a session ID (<a>GetTestGridSessionRequest$projectArn</a> and <a>GetTestGridSessionRequest$sessionId</a>).</p>
    /// </li>
    /// </ul>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct GetTestGridSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_test_grid_session_input::Builder,
    }
    impl<C, M, R> GetTestGridSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTestGridSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTestGridSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTestGridSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTestGridSessionInputOperationOutputAlias,
                crate::output::GetTestGridSessionOutput,
                crate::error::GetTestGridSessionError,
                crate::input::GetTestGridSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the project that this session belongs to. See <a>CreateTestGridProject</a> and <a>ListTestGridProjects</a>.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN for the project that this session belongs to. See <a>CreateTestGridProject</a> and <a>ListTestGridProjects</a>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>An ID associated with this session.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>An ID associated with this session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>An ARN that uniquely identifies a <a>TestGridSession</a>.</p>
        pub fn session_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_arn(inp);
            self
        }
        /// <p>An ARN that uniquely identifies a <a>TestGridSession</a>.</p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUpload`.
    ///
    /// <p>Gets information about an upload.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_upload_input::Builder,
    }
    impl<C, M, R> GetUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUploadInputOperationOutputAlias,
                crate::output::GetUploadOutput,
                crate::error::GetUploadError,
                crate::input::GetUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The upload's ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The upload's ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVPCEConfiguration`.
    ///
    /// <p>Returns information about the configuration settings for your Amazon Virtual Private
    /// Cloud (VPC) endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetVPCEConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_vpce_configuration_input::Builder,
    }
    impl<C, M, R> GetVPCEConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVPCEConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVpceConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVPCEConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVpceConfigurationInputOperationOutputAlias,
                crate::output::GetVpceConfigurationOutput,
                crate::error::GetVPCEConfigurationError,
                crate::input::GetVpceConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
        /// describe.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
        /// describe.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InstallToRemoteAccessSession`.
    ///
    /// <p>Installs an application to the device in a remote access session. For Android
    /// applications, the file must be in .apk format. For iOS applications, the file must be in
    /// .ipa format.</p>
    #[derive(std::fmt::Debug)]
    pub struct InstallToRemoteAccessSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::install_to_remote_access_session_input::Builder,
    }
    impl<C, M, R> InstallToRemoteAccessSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InstallToRemoteAccessSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InstallToRemoteAccessSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::InstallToRemoteAccessSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InstallToRemoteAccessSessionInputOperationOutputAlias,
                crate::output::InstallToRemoteAccessSessionOutput,
                crate::error::InstallToRemoteAccessSessionError,
                crate::input::InstallToRemoteAccessSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you are
        /// requesting information.</p>
        pub fn remote_access_session_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_access_session_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session about which you are
        /// requesting information.</p>
        pub fn set_remote_access_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_remote_access_session_arn(input);
            self
        }
        /// <p>The ARN of the app about which you are requesting information.</p>
        pub fn app_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(inp);
            self
        }
        /// <p>The ARN of the app about which you are requesting information.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArtifacts`.
    ///
    /// <p>Gets information about artifacts.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListArtifacts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_artifacts_input::Builder,
    }
    impl<C, M, R> ListArtifacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArtifactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListArtifactsInputOperationOutputAlias,
                crate::output::ListArtifactsOutput,
                crate::error::ListArtifactsError,
                crate::input::ListArtifactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The run, job, suite, or test ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The run, job, suite, or test ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The artifacts' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>FILE</p>
        /// </li>
        /// <li>
        /// <p>LOG</p>
        /// </li>
        /// <li>
        /// <p>SCREENSHOT</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ArtifactCategory) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The artifacts' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>FILE</p>
        /// </li>
        /// <li>
        /// <p>LOG</p>
        /// </li>
        /// <li>
        /// <p>SCREENSHOT</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ArtifactCategory>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceInstances`.
    ///
    /// <p>Returns information about the private device instances associated with one or more AWS
    /// accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeviceInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_instances_input::Builder,
    }
    impl<C, M, R> ListDeviceInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceInstancesInputOperationOutputAlias,
                crate::output::ListDeviceInstancesOutput,
                crate::error::ListDeviceInstancesError,
                crate::input::ListDeviceInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevicePools`.
    ///
    /// <p>Gets information about device pools.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDevicePools<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_pools_input::Builder,
    }
    impl<C, M, R> ListDevicePools<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevicePools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicePoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicePoolsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicePoolsInputOperationOutputAlias,
                crate::output::ListDevicePoolsOutput,
                crate::error::ListDevicePoolsError,
                crate::input::ListDevicePoolsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The project ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The project ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The device pools' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>CURATED: A device pool that is created and managed by AWS Device
        /// Farm.</p>
        /// </li>
        /// <li>
        /// <p>PRIVATE: A device pool that is created and managed by the device pool
        /// developer.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::DevicePoolType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The device pools' type.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>CURATED: A device pool that is created and managed by AWS Device
        /// Farm.</p>
        /// </li>
        /// <li>
        /// <p>PRIVATE: A device pool that is created and managed by the device pool
        /// developer.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DevicePoolType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevices`.
    ///
    /// <p>Gets information about unique device types.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_devices_input::Builder,
    }
    impl<C, M, R> ListDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicesInputOperationOutputAlias,
                crate::output::ListDevicesOutput,
                crate::error::ListDevicesError,
                crate::input::ListDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Used to select a set of devices. A filter is made up of an attribute, an operator, and
        /// one or more values.</p>
        /// <ul>
        /// <li>
        /// <p>Attribute: The aspect of a device such as platform or model used as the
        /// selection criteria in a device filter.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ARN: The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM: The device platform. Valid values are ANDROID or IOS.</p>
        /// </li>
        /// <li>
        /// <p>OS_VERSION: The operating system version (for example, 10.3.2).</p>
        /// </li>
        /// <li>
        /// <p>MODEL: The device model (for example, iPad 5th Gen).</p>
        /// </li>
        /// <li>
        /// <p>AVAILABILITY: The current availability of the device. Valid values are AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.</p>
        /// </li>
        /// <li>
        /// <p>MANUFACTURER: The device manufacturer (for example, Apple).</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values
        /// are TRUE or FALSE.</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values
        /// are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>, this attribute is ignored.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
        /// instance.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_LABELS: The label of the device instance.</p>
        /// </li>
        /// <li>
        /// <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Operator: The filter operator.</p>
        /// <ul>
        /// <li>
        /// <p>The EQUALS operator is available for every attribute except
        /// INSTANCE_LABELS.</p>
        /// </li>
        /// <li>
        /// <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
        /// attributes.</p>
        /// </li>
        /// <li>
        /// <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION,
        /// MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p>
        /// </li>
        /// <li>
        /// <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
        /// GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
        /// attribute.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Values: An array of one or more filter values.</p>
        /// <ul>
        /// <li>
        /// <p>The IN and NOT_IN operators take a values array that has one or more
        /// elements.</p>
        /// </li>
        /// <li>
        /// <p>The other operators require an array with a single element.</p>
        /// </li>
        /// <li>
        /// <p>In a request, the AVAILABILITY attribute takes the following values: AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::DeviceFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Used to select a set of devices. A filter is made up of an attribute, an operator, and
        /// one or more values.</p>
        /// <ul>
        /// <li>
        /// <p>Attribute: The aspect of a device such as platform or model used as the
        /// selection criteria in a device filter.</p>
        /// <p>Allowed values include:</p>
        /// <ul>
        /// <li>
        /// <p>ARN: The Amazon Resource Name (ARN) of the device (for example,
        /// <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM: The device platform. Valid values are ANDROID or IOS.</p>
        /// </li>
        /// <li>
        /// <p>OS_VERSION: The operating system version (for example, 10.3.2).</p>
        /// </li>
        /// <li>
        /// <p>MODEL: The device model (for example, iPad 5th Gen).</p>
        /// </li>
        /// <li>
        /// <p>AVAILABILITY: The current availability of the device. Valid values are AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// <li>
        /// <p>FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.</p>
        /// </li>
        /// <li>
        /// <p>MANUFACTURER: The device manufacturer (for example, Apple).</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values
        /// are TRUE or FALSE.</p>
        /// </li>
        /// <li>
        /// <p>REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values
        /// are TRUE or FALSE. Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
        /// longer supported</a>, this attribute is ignored.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_ARN: The Amazon Resource Name (ARN) of the device
        /// instance.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_LABELS: The label of the device instance.</p>
        /// </li>
        /// <li>
        /// <p>FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Operator: The filter operator.</p>
        /// <ul>
        /// <li>
        /// <p>The EQUALS operator is available for every attribute except
        /// INSTANCE_LABELS.</p>
        /// </li>
        /// <li>
        /// <p>The CONTAINS operator is available for the INSTANCE_LABELS and MODEL
        /// attributes.</p>
        /// </li>
        /// <li>
        /// <p>The IN and NOT_IN operators are available for the ARN, OS_VERSION,
        /// MODEL, MANUFACTURER, and INSTANCE_ARN attributes.</p>
        /// </li>
        /// <li>
        /// <p>The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and
        /// GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION
        /// attribute.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Values: An array of one or more filter values.</p>
        /// <ul>
        /// <li>
        /// <p>The IN and NOT_IN operators take a values array that has one or more
        /// elements.</p>
        /// </li>
        /// <li>
        /// <p>The other operators require an array with a single element.</p>
        /// </li>
        /// <li>
        /// <p>In a request, the AVAILABILITY attribute takes the following values: AVAILABLE,
        /// HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceProfiles`.
    ///
    /// <p>Returns information about all the instance profiles in an AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_profiles_input::Builder,
    }
    impl<C, M, R> ListInstanceProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceProfilesInputOperationOutputAlias,
                crate::output::ListInstanceProfilesOutput,
                crate::error::ListInstanceProfilesError,
                crate::input::ListInstanceProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Gets information about jobs for a given test run.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The run's Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The run's Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNetworkProfiles`.
    ///
    /// <p>Returns the list of available network profiles.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNetworkProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_network_profiles_input::Builder,
    }
    impl<C, M, R> ListNetworkProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNetworkProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNetworkProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNetworkProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNetworkProfilesInputOperationOutputAlias,
                crate::output::ListNetworkProfilesOutput,
                crate::error::ListNetworkProfilesError,
                crate::input::ListNetworkProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list network
        /// profiles.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list network
        /// profiles.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn r#type(mut self, inp: crate::model::NetworkProfileType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOfferingPromotions`.
    ///
    /// <p>Returns a list of offering promotions. Each offering promotion record contains the ID and description
    /// of the promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke
    /// the operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you must be able to invoke this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOfferingPromotions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_offering_promotions_input::Builder,
    }
    impl<C, M, R> ListOfferingPromotions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOfferingPromotions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOfferingPromotionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOfferingPromotionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOfferingPromotionsInputOperationOutputAlias,
                crate::output::ListOfferingPromotionsOutput,
                crate::error::ListOfferingPromotionsError,
                crate::input::ListOfferingPromotionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOfferings`.
    ///
    /// <p>Returns a list of products or offerings that the user can manage through the API. Each offering record
    /// indicates the recurring price per unit and the frequency for that offering. The API returns a
    /// <code>NotEligible</code> error if the user is not permitted to invoke the operation.  If you must be
    /// able to invoke this operation, contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_offerings_input::Builder,
    }
    impl<C, M, R> ListOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOfferingsInputOperationOutputAlias,
                crate::output::ListOfferingsOutput,
                crate::error::ListOfferingsError,
                crate::input::ListOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOfferingTransactions`.
    ///
    /// <p>Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS
    /// account. The list is paginated and ordered by a descending timestamp (most recent transactions are first).
    /// The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. If
    /// you must be able to invoke this operation, contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOfferingTransactions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_offering_transactions_input::Builder,
    }
    impl<C, M, R> ListOfferingTransactions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOfferingTransactions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOfferingTransactionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOfferingTransactionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOfferingTransactionsInputOperationOutputAlias,
                crate::output::ListOfferingTransactionsOutput,
                crate::error::ListOfferingTransactionsError,
                crate::input::ListOfferingTransactionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Gets information about projects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm
        /// returns a list of all projects for the AWS account. You can also specify a project
        /// ARN.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device Farm
        /// returns a list of all projects for the AWS account. You can also specify a project
        /// ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRemoteAccessSessions`.
    ///
    /// <p>Returns a list of all currently running remote access sessions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRemoteAccessSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_remote_access_sessions_input::Builder,
    }
    impl<C, M, R> ListRemoteAccessSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRemoteAccessSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRemoteAccessSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRemoteAccessSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRemoteAccessSessionsInputOperationOutputAlias,
                crate::output::ListRemoteAccessSessionsOutput,
                crate::error::ListRemoteAccessSessionsError,
                crate::input::ListRemoteAccessSessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project about which you are requesting
        /// information.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project about which you are requesting
        /// information.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuns`.
    ///
    /// <p>Gets information about runs, given an AWS Device Farm project ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_runs_input::Builder,
    }
    impl<C, M, R> ListRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRunsInputOperationOutputAlias,
                crate::output::ListRunsOutput,
                crate::error::ListRunsError,
                crate::input::ListRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list
        /// runs.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list
        /// runs.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSamples`.
    ///
    /// <p>Gets information about samples, given an AWS Device Farm job ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSamples<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_samples_input::Builder,
    }
    impl<C, M, R> ListSamples<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSamples`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSamplesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSamplesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSamplesInputOperationOutputAlias,
                crate::output::ListSamplesOutput,
                crate::error::ListSamplesError,
                crate::input::ListSamplesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the job used to list samples.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the job used to list samples.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuites`.
    ///
    /// <p>Gets information about test suites for a given job.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSuites<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suites_input::Builder,
    }
    impl<C, M, R> ListSuites<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuitesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuitesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuitesInputOperationOutputAlias,
                crate::output::ListSuitesOutput,
                crate::error::ListSuitesError,
                crate::input::ListSuitesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job's Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The job's Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an AWS Device Farm resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources for which to list tags. You can associate tags
        /// with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>,
        /// <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>,
        /// <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and
        /// <code>VPCE_CONFIGURATION</code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources for which to list tags. You can associate tags
        /// with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>,
        /// <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>,
        /// <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and
        /// <code>VPCE_CONFIGURATION</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTestGridProjects`.
    ///
    /// <p>Gets a list of all Selenium testing projects in your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTestGridProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_test_grid_projects_input::Builder,
    }
    impl<C, M, R> ListTestGridProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTestGridProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestGridProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestGridProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTestGridProjectsInputOperationOutputAlias,
                crate::output::ListTestGridProjectsOutput,
                crate::error::ListTestGridProjectsError,
                crate::input::ListTestGridProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Return no more than this number of results.</p>
        pub fn max_result(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_result(inp);
            self
        }
        /// <p>Return no more than this number of results.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_result(input);
            self
        }
        /// <p>From a response, used to continue a paginated listing. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>From a response, used to continue a paginated listing. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTestGridSessionActions`.
    ///
    /// <p>Returns a list of the actions taken in a <a>TestGridSession</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTestGridSessionActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_test_grid_session_actions_input::Builder,
    }
    impl<C, M, R> ListTestGridSessionActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTestGridSessionActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestGridSessionActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestGridSessionActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTestGridSessionActionsInputOperationOutputAlias,
                crate::output::ListTestGridSessionActionsOutput,
                crate::error::ListTestGridSessionActionsError,
                crate::input::ListTestGridSessionActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the session to retrieve.</p>
        pub fn session_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_arn(inp);
            self
        }
        /// <p>The ARN of the session to retrieve.</p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_arn(input);
            self
        }
        /// <p>The maximum number of sessions to return per response.</p>
        pub fn max_result(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_result(inp);
            self
        }
        /// <p>The maximum number of sessions to return per response.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_result(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTestGridSessionArtifacts`.
    ///
    /// <p>Retrieves a list of artifacts created during the session.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTestGridSessionArtifacts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_test_grid_session_artifacts_input::Builder,
    }
    impl<C, M, R> ListTestGridSessionArtifacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTestGridSessionArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestGridSessionArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestGridSessionArtifactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTestGridSessionArtifactsInputOperationOutputAlias,
                crate::output::ListTestGridSessionArtifactsOutput,
                crate::error::ListTestGridSessionArtifactsError,
                crate::input::ListTestGridSessionArtifactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a <a>TestGridSession</a>. </p>
        pub fn session_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_arn(inp);
            self
        }
        /// <p>The ARN of a <a>TestGridSession</a>. </p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_arn(input);
            self
        }
        /// <p>Limit results to a specified type of artifact.</p>
        pub fn r#type(mut self, inp: crate::model::TestGridSessionArtifactCategory) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Limit results to a specified type of artifact.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TestGridSessionArtifactCategory>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The maximum number of results to be returned by a request.</p>
        pub fn max_result(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_result(inp);
            self
        }
        /// <p>The maximum number of results to be returned by a request.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_result(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTestGridSessions`.
    ///
    /// <p>Retrieves a list of sessions for a <a>TestGridProject</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTestGridSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_test_grid_sessions_input::Builder,
    }
    impl<C, M, R> ListTestGridSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTestGridSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestGridSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestGridSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTestGridSessionsInputOperationOutputAlias,
                crate::output::ListTestGridSessionsOutput,
                crate::error::ListTestGridSessionsError,
                crate::input::ListTestGridSessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a <a>TestGridProject</a>.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>ARN of a <a>TestGridProject</a>.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>Return only sessions in this state.</p>
        pub fn status(mut self, inp: crate::model::TestGridSessionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>Return only sessions in this state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TestGridSessionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Return only sessions created after this time.</p>
        pub fn creation_time_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.creation_time_after(inp);
            self
        }
        /// <p>Return only sessions created after this time.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_after(input);
            self
        }
        /// <p>Return only  sessions created before this time.</p>
        pub fn creation_time_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.creation_time_before(inp);
            self
        }
        /// <p>Return only  sessions created before this time.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_before(input);
            self
        }
        /// <p>Return only sessions that ended after this time.</p>
        pub fn end_time_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time_after(inp);
            self
        }
        /// <p>Return only sessions that ended after this time.</p>
        pub fn set_end_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time_after(input);
            self
        }
        /// <p>Return only sessions that ended before this time.</p>
        pub fn end_time_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time_before(inp);
            self
        }
        /// <p>Return only sessions that ended before this time.</p>
        pub fn set_end_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time_before(input);
            self
        }
        /// <p>Return only this many results at a time.</p>
        pub fn max_result(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_result(inp);
            self
        }
        /// <p>Return only this many results at a time.</p>
        pub fn set_max_result(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_result(input);
            self
        }
        /// <p>Pagination token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTests`.
    ///
    /// <p>Gets information about tests in a given test suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTests<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tests_input::Builder,
    }
    impl<C, M, R> ListTests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTestsInputOperationOutputAlias,
                crate::output::ListTestsOutput,
                crate::error::ListTestsError,
                crate::input::ListTestsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The test suite's Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The test suite's Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUniqueProblems`.
    ///
    /// <p>Gets information about unique problems, such as exceptions or crashes.</p>
    /// <p>Unique problems are defined as a single instance of an error across a run, job, or suite. For example,
    /// if a call in your application consistently raises an exception (<code>OutOfBoundsException in
    /// MyActivity.java:386</code>), <code>ListUniqueProblems</code> returns a single entry instead of many
    /// individual entries for that exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUniqueProblems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_unique_problems_input::Builder,
    }
    impl<C, M, R> ListUniqueProblems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUniqueProblems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUniqueProblemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUniqueProblemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUniqueProblemsInputOperationOutputAlias,
                crate::output::ListUniqueProblemsOutput,
                crate::error::ListUniqueProblemsError,
                crate::input::ListUniqueProblemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique problems' ARNs.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The unique problems' ARNs.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUploads`.
    ///
    /// <p>Gets information about uploads, given an AWS Device Farm project ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUploads<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_uploads_input::Builder,
    }
    impl<C, M, R> ListUploads<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUploads`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUploadsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUploadsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUploadsInputOperationOutputAlias,
                crate::output::ListUploadsOutput,
                crate::error::ListUploadsError,
                crate::input::ListUploadsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list
        /// uploads.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to list
        /// uploads.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The type of upload.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID_APP</p>
        /// </li>
        /// <li>
        /// <p>IOS_APP</p>
        /// </li>
        /// <li>
        /// <p>WEB_APP</p>
        /// </li>
        /// <li>
        /// <p>EXTERNAL_DATA</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p> APPIUM_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_SPEC</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::UploadType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of upload.</p>
        /// <p>Must be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>ANDROID_APP</p>
        /// </li>
        /// <li>
        /// <p>IOS_APP</p>
        /// </li>
        /// <li>
        /// <p>WEB_APP</p>
        /// </li>
        /// <li>
        /// <p>EXTERNAL_DATA</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>CALABASH_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATION_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>UIAUTOMATOR_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_PACKAGE</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p> APPIUM_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_JUNIT_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_JAVA_TESTNG_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_PYTHON_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_NODE_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>APPIUM_WEB_RUBY_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>INSTRUMENTATION_TEST_SPEC</p>
        /// </li>
        /// <li>
        /// <p>XCTEST_UI_TEST_SPEC</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UploadType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can
        /// be used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVPCEConfigurations`.
    ///
    /// <p>Returns information about all Amazon Virtual Private Cloud (VPC) endpoint
    /// configurations in the AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVPCEConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_vpce_configurations_input::Builder,
    }
    impl<C, M, R> ListVPCEConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVPCEConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVpceConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVPCEConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVpceConfigurationsInputOperationOutputAlias,
                crate::output::ListVpceConfigurationsOutput,
                crate::error::ListVPCEConfigurationsError,
                crate::input::ListVpceConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An integer that specifies the maximum number of items you want to return in the API response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseOffering`.
    ///
    /// <p>Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased
    /// quantity for an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code>
    /// error if the user is not permitted to invoke the operation. If you must be able to invoke this operation,
    /// contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PurchaseOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purchase_offering_input::Builder,
    }
    impl<C, M, R> PurchaseOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurchaseOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PurchaseOfferingInputOperationOutputAlias,
                crate::output::PurchaseOfferingOutput,
                crate::error::PurchaseOfferingError,
                crate::input::PurchaseOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the offering.</p>
        pub fn offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_id(inp);
            self
        }
        /// <p>The ID of the offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_id(input);
            self
        }
        /// <p>The number of device slots to purchase in an offering request.</p>
        pub fn quantity(mut self, inp: i32) -> Self {
            self.inner = self.inner.quantity(inp);
            self
        }
        /// <p>The number of device slots to purchase in an offering request.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_quantity(input);
            self
        }
        /// <p>The ID of the offering promotion to be applied to the purchase.</p>
        pub fn offering_promotion_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_promotion_id(inp);
            self
        }
        /// <p>The ID of the offering promotion to be applied to the purchase.</p>
        pub fn set_offering_promotion_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_offering_promotion_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RenewOffering`.
    ///
    /// <p>Explicitly sets the quantity of devices to renew for an offering, starting from the
    /// <code>effectiveDate</code> of the next period. The API returns a <code>NotEligible</code> error if the
    /// user is not permitted to invoke the operation. If you must be able to invoke this operation, contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RenewOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::renew_offering_input::Builder,
    }
    impl<C, M, R> RenewOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RenewOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RenewOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::RenewOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RenewOfferingInputOperationOutputAlias,
                crate::output::RenewOfferingOutput,
                crate::error::RenewOfferingError,
                crate::input::RenewOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a request to renew an offering.</p>
        pub fn offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_id(inp);
            self
        }
        /// <p>The ID of a request to renew an offering.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_id(input);
            self
        }
        /// <p>The quantity requested in an offering renewal.</p>
        pub fn quantity(mut self, inp: i32) -> Self {
            self.inner = self.inner.quantity(inp);
            self
        }
        /// <p>The quantity requested in an offering renewal.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_quantity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ScheduleRun`.
    ///
    /// <p>Schedules a run.</p>
    #[derive(std::fmt::Debug)]
    pub struct ScheduleRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::schedule_run_input::Builder,
    }
    impl<C, M, R> ScheduleRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ScheduleRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ScheduleRunOutput,
            aws_smithy_http::result::SdkError<crate::error::ScheduleRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ScheduleRunInputOperationOutputAlias,
                crate::output::ScheduleRunOutput,
                crate::error::ScheduleRunError,
                crate::input::ScheduleRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the project for the run to be scheduled.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN of the project for the run to be scheduled.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>The ARN of an application package to run tests against, created with <a>CreateUpload</a>.
        /// See <a>ListUploads</a>.</p>
        pub fn app_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(inp);
            self
        }
        /// <p>The ARN of an application package to run tests against, created with <a>CreateUpload</a>.
        /// See <a>ListUploads</a>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The ARN of the device pool for the run to be scheduled.</p>
        pub fn device_pool_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_pool_arn(inp);
            self
        }
        /// <p>The ARN of the device pool for the run to be scheduled.</p>
        pub fn set_device_pool_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_pool_arn(input);
            self
        }
        /// <p>The filter criteria used to dynamically select a set of devices for a test run and the maximum number of
        /// devices to be included in the run.</p>
        /// <p>Either <b>
        /// <code>devicePoolArn</code>
        /// </b> or <b>
        /// <code>deviceSelectionConfiguration</code>
        /// </b> is required in a
        /// request.</p>
        pub fn device_selection_configuration(
            mut self,
            inp: crate::model::DeviceSelectionConfiguration,
        ) -> Self {
            self.inner = self.inner.device_selection_configuration(inp);
            self
        }
        /// <p>The filter criteria used to dynamically select a set of devices for a test run and the maximum number of
        /// devices to be included in the run.</p>
        /// <p>Either <b>
        /// <code>devicePoolArn</code>
        /// </b> or <b>
        /// <code>deviceSelectionConfiguration</code>
        /// </b> is required in a
        /// request.</p>
        pub fn set_device_selection_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceSelectionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_device_selection_configuration(input);
            self
        }
        /// <p>The name for the run to be scheduled.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the run to be scheduled.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Information about the test for the run to be scheduled.</p>
        pub fn test(mut self, inp: crate::model::ScheduleRunTest) -> Self {
            self.inner = self.inner.test(inp);
            self
        }
        /// <p>Information about the test for the run to be scheduled.</p>
        pub fn set_test(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunTest>,
        ) -> Self {
            self.inner = self.inner.set_test(input);
            self
        }
        /// <p>Information about the settings for the run to be scheduled.</p>
        pub fn configuration(mut self, inp: crate::model::ScheduleRunConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Information about the settings for the run to be scheduled.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ScheduleRunConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>Specifies configuration information about a test run, such as the execution timeout
        /// (in minutes).</p>
        pub fn execution_configuration(
            mut self,
            inp: crate::model::ExecutionConfiguration,
        ) -> Self {
            self.inner = self.inner.execution_configuration(inp);
            self
        }
        /// <p>Specifies configuration information about a test run, such as the execution timeout
        /// (in minutes).</p>
        pub fn set_execution_configuration(
            mut self,
            input: std::option::Option<crate::model::ExecutionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_execution_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopJob`.
    ///
    /// <p>Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device
    /// where tests have not started. You are not billed for this device. On the device where tests have started,
    /// setup suite and teardown suite tests run to completion on the device. You are billed for setup, teardown,
    /// and any tests that were in progress or already completed.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_job_input::Builder,
    }
    impl<C, M, R> StopJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopJobInputOperationOutputAlias,
                crate::output::StopJobOutput,
                crate::error::StopJobError,
                crate::input::StopJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopRemoteAccessSession`.
    ///
    /// <p>Ends a specified remote access session.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopRemoteAccessSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_remote_access_session_input::Builder,
    }
    impl<C, M, R> StopRemoteAccessSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopRemoteAccessSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopRemoteAccessSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopRemoteAccessSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopRemoteAccessSessionInputOperationOutputAlias,
                crate::output::StopRemoteAccessSessionOutput,
                crate::error::StopRemoteAccessSessionError,
                crate::input::StopRemoteAccessSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session to stop.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the remote access session to stop.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopRun`.
    ///
    /// <p>Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices
    /// where tests have not started. You are not billed for these devices. On devices where tests have started
    /// executing, setup suite and teardown suite tests run to completion on those devices. You are billed for
    /// setup, teardown, and any tests that were in progress or already completed.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_run_input::Builder,
    }
    impl<C, M, R> StopRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopRunInputOperationOutputAlias,
                crate::output::StopRunOutput,
                crate::error::StopRunError,
                crate::input::StopRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags
    /// on a resource are not specified in the request parameters, they are not changed. When a resource is deleted,
    /// the tags associated with that resource are also deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources to which to add tags. You can associate tags
        /// with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>,
        /// <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>,
        /// <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and
        /// <code>VPCE_CONFIGURATION</code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources to which to add tags. You can associate tags
        /// with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>,
        /// <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>,
        /// <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and
        /// <code>VPCE_CONFIGURATION</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum
        /// character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum
        /// character length of 128 characters. Tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources from which to delete tags. You can associate
        /// tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>,
        /// <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>,
        /// <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and
        /// <code>VPCE_CONFIGURATION</code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource or resources from which to delete tags. You can associate
        /// tags with the following Device Farm resources: <code>PROJECT</code>, <code>RUN</code>,
        /// <code>NETWORK_PROFILE</code>, <code>INSTANCE_PROFILE</code>, <code>DEVICE_INSTANCE</code>,
        /// <code>SESSION</code>, <code>DEVICE_POOL</code>, <code>DEVICE</code>, and
        /// <code>VPCE_CONFIGURATION</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeviceInstance`.
    ///
    /// <p>Updates information about a private device instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDeviceInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_instance_input::Builder,
    }
    impl<C, M, R> UpdateDeviceInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeviceInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeviceInstanceInputOperationOutputAlias,
                crate::output::UpdateDeviceInstanceOutput,
                crate::error::UpdateDeviceInstanceError,
                crate::input::UpdateDeviceInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The ARN of the profile that you want to associate with the device instance.</p>
        pub fn profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_arn(inp);
            self
        }
        /// <p>The ARN of the profile that you want to associate with the device instance.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_arn(input);
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>An array of strings that you want to associate with the device instance.</p>
        pub fn labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(inp);
            self
        }
        /// <p>An array of strings that you want to associate with the device instance.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevicePool`.
    ///
    /// <p>Modifies the name, description, and rules in a device pool given the attributes and
    /// the pool ARN. Rule updates are all-or-nothing, meaning they can only be updated as a
    /// whole (or not at all).</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDevicePool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_pool_input::Builder,
    }
    impl<C, M, R> UpdateDevicePool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDevicePool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDevicePoolOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDevicePoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDevicePoolInputOperationOutputAlias,
                crate::output::UpdateDevicePoolOutput,
                crate::error::UpdateDevicePoolError,
                crate::input::UpdateDevicePoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Device Farm device pool to update.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Device Farm device pool to update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>A string that represents the name of the device pool to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A string that represents the name of the device pool to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the device pool to update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the device pool to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for
        /// your request, the update replaces the existing rules.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::Rule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for
        /// your request, the update replaces the existing rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds
        /// devices that are available and that meet the criteria that you assign for the
        /// <code>rules</code> parameter. Depending on how many devices meet these constraints,
        /// your device pool might contain fewer devices than the value for this parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur
        /// by running tests.</p>
        /// <p>If you use this parameter in your request, you cannot use the
        /// <code>clearMaxDevices</code> parameter in the same request.</p>
        pub fn max_devices(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_devices(inp);
            self
        }
        /// <p>The number of devices that Device Farm can add to your device pool. Device Farm adds
        /// devices that are available and that meet the criteria that you assign for the
        /// <code>rules</code> parameter. Depending on how many devices meet these constraints,
        /// your device pool might contain fewer devices than the value for this parameter.</p>
        /// <p>By specifying the maximum number of devices, you can control the costs that you incur
        /// by running tests.</p>
        /// <p>If you use this parameter in your request, you cannot use the
        /// <code>clearMaxDevices</code> parameter in the same request.</p>
        pub fn set_max_devices(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_devices(input);
            self
        }
        /// <p>Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter
        /// to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit
        /// the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices
        /// that meet the criteria specified in the <code>rules</code> parameter.</p>
        /// <p>If you use this parameter in your request, you cannot use the <code>maxDevices</code>
        /// parameter in the same request.</p>
        pub fn clear_max_devices(mut self, inp: bool) -> Self {
            self.inner = self.inner.clear_max_devices(inp);
            self
        }
        /// <p>Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter
        /// to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit
        /// the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices
        /// that meet the criteria specified in the <code>rules</code> parameter.</p>
        /// <p>If you use this parameter in your request, you cannot use the <code>maxDevices</code>
        /// parameter in the same request.</p>
        pub fn set_clear_max_devices(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_clear_max_devices(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceProfile`.
    ///
    /// <p>Updates information about an existing private device instance profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_instance_profile_input::Builder,
    }
    impl<C, M, R> UpdateInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInstanceProfileInputOperationOutputAlias,
                crate::output::UpdateInstanceProfileOutput,
                crate::error::UpdateInstanceProfileError,
                crate::input::UpdateInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The updated name for your instance profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated name for your instance profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description for your instance profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description for your instance profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated choice for whether you want to specify package cleanup. The default value
        /// is <code>false</code> for private devices.</p>
        pub fn package_cleanup(mut self, inp: bool) -> Self {
            self.inner = self.inner.package_cleanup(inp);
            self
        }
        /// <p>The updated choice for whether you want to specify package cleanup. The default value
        /// is <code>false</code> for private devices.</p>
        pub fn set_package_cleanup(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_package_cleanup(input);
            self
        }
        /// Appends an item to `excludeAppPackagesFromCleanup`.
        ///
        /// To override the contents of this collection use [`set_exclude_app_packages_from_cleanup`](Self::set_exclude_app_packages_from_cleanup).
        ///
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device
        /// after a test run is over.</p>
        /// <p>The list of packages is only considered if you set <code>packageCleanup</code> to
        /// <code>true</code>.</p>
        pub fn exclude_app_packages_from_cleanup(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.exclude_app_packages_from_cleanup(inp);
            self
        }
        /// <p>An array of strings that specifies the list of app packages that should not be cleaned up from the device
        /// after a test run is over.</p>
        /// <p>The list of packages is only considered if you set <code>packageCleanup</code> to
        /// <code>true</code>.</p>
        pub fn set_exclude_app_packages_from_cleanup(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exclude_app_packages_from_cleanup(input);
            self
        }
        /// <p>The updated choice for whether you want to reboot the device after use. The default
        /// value is <code>true</code>.</p>
        pub fn reboot_after_use(mut self, inp: bool) -> Self {
            self.inner = self.inner.reboot_after_use(inp);
            self
        }
        /// <p>The updated choice for whether you want to reboot the device after use. The default
        /// value is <code>true</code>.</p>
        pub fn set_reboot_after_use(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reboot_after_use(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkProfile`.
    ///
    /// <p>Updates the network profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_network_profile_input::Builder,
    }
    impl<C, M, R> UpdateNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNetworkProfileInputOperationOutputAlias,
                crate::output::UpdateNetworkProfileOutput,
                crate::error::UpdateNetworkProfileError,
                crate::input::UpdateNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to update network
        /// profile settings.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project for which you want to update network
        /// profile settings.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the network profile about which you are returning
        /// information.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the network profile about which you are returning
        /// information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the network profile about which you are returning
        /// information.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the network profile about which you are returning
        /// information.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn r#type(mut self, inp: crate::model::NetworkProfileType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of network profile to return information about. Valid values are listed here.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NetworkProfileType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn uplink_bandwidth_bits(mut self, inp: i64) -> Self {
            self.inner = self.inner.uplink_bandwidth_bits(inp);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn set_uplink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_uplink_bandwidth_bits(input);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn downlink_bandwidth_bits(mut self, inp: i64) -> Self {
            self.inner = self.inner.downlink_bandwidth_bits(inp);
            self
        }
        /// <p>The data throughput rate in bits per second, as an integer from 0 to
        /// 104857600.</p>
        pub fn set_downlink_bandwidth_bits(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_downlink_bandwidth_bits(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn uplink_delay_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.uplink_delay_ms(inp);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn set_uplink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_uplink_delay_ms(input);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn downlink_delay_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.downlink_delay_ms(inp);
            self
        }
        /// <p>Delay time for all packets to destination in milliseconds as an integer from 0 to
        /// 2000.</p>
        pub fn set_downlink_delay_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_downlink_delay_ms(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn uplink_jitter_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.uplink_jitter_ms(inp);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn set_uplink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_uplink_jitter_ms(input);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn downlink_jitter_ms(mut self, inp: i64) -> Self {
            self.inner = self.inner.downlink_jitter_ms(inp);
            self
        }
        /// <p>Time variation in the delay of received packets in milliseconds as an integer from
        /// 0 to 2000.</p>
        pub fn set_downlink_jitter_ms(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_downlink_jitter_ms(input);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
        /// percent.</p>
        pub fn uplink_loss_percent(mut self, inp: i32) -> Self {
            self.inner = self.inner.uplink_loss_percent(inp);
            self
        }
        /// <p>Proportion of transmitted packets that fail to arrive from 0 to 100
        /// percent.</p>
        pub fn set_uplink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_uplink_loss_percent(input);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn downlink_loss_percent(mut self, inp: i32) -> Self {
            self.inner = self.inner.downlink_loss_percent(inp);
            self
        }
        /// <p>Proportion of received packets that fail to arrive from 0 to 100 percent.</p>
        pub fn set_downlink_loss_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_downlink_loss_percent(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Modifies the specified project name, given the project ARN and a new
    /// name.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project whose name to update.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project whose name to update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>A string that represents the new name of the project that you are updating.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A string that represents the new name of the project that you are updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The number of minutes a test run in the project executes before it times out.</p>
        pub fn default_job_timeout_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.default_job_timeout_minutes(inp);
            self
        }
        /// <p>The number of minutes a test run in the project executes before it times out.</p>
        pub fn set_default_job_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_job_timeout_minutes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTestGridProject`.
    ///
    /// <p>Change details of a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTestGridProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_test_grid_project_input::Builder,
    }
    impl<C, M, R> UpdateTestGridProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTestGridProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTestGridProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTestGridProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTestGridProjectInputOperationOutputAlias,
                crate::output::UpdateTestGridProjectOutput,
                crate::error::UpdateTestGridProjectError,
                crate::input::UpdateTestGridProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the project to update.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>ARN of the project to update.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>Human-readable name for the project.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Human-readable name for the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Human-readable description for the project.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Human-readable description for the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn vpc_config(mut self, inp: crate::model::TestGridVpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>The VPC security groups and subnets that are attached to a project.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::TestGridVpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUpload`.
    ///
    /// <p>Updates an uploaded test spec.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_upload_input::Builder,
    }
    impl<C, M, R> UpdateUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUploadInputOperationOutputAlias,
                crate::output::UpdateUploadOutput,
                crate::error::UpdateUploadError,
                crate::input::UpdateUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the uploaded test spec.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the uploaded test spec.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file
        /// name must end with the <code>.yaml</code> or <code>.yml</code> file extension.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The upload's test spec file name. The name must not contain any forward slashes (/). The test spec file
        /// name must end with the <code>.yaml</code> or <code>.yml</code> file extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The upload's content type (for example, <code>application/x-yaml</code>).</p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>The upload's content type (for example, <code>application/x-yaml</code>).</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>Set to true if the YAML file has changed and must be updated. Otherwise, set to false.</p>
        pub fn edit_content(mut self, inp: bool) -> Self {
            self.inner = self.inner.edit_content(inp);
            self
        }
        /// <p>Set to true if the YAML file has changed and must be updated. Otherwise, set to false.</p>
        pub fn set_edit_content(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_edit_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVPCEConfiguration`.
    ///
    /// <p>Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVPCEConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_vpce_configuration_input::Builder,
    }
    impl<C, M, R> UpdateVPCEConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVPCEConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVpceConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVPCEConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVpceConfigurationInputOperationOutputAlias,
                crate::output::UpdateVpceConfigurationOutput,
                crate::error::UpdateVPCEConfigurationError,
                crate::input::UpdateVpceConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
        /// update.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the VPC endpoint configuration you want to
        /// update.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more
        /// easily.</p>
        pub fn vpce_configuration_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpce_configuration_name(inp);
            self
        }
        /// <p>The friendly name you give to your VPC endpoint configuration to manage your configurations more
        /// easily.</p>
        pub fn set_vpce_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpce_configuration_name(input);
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn vpce_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpce_service_name(inp);
            self
        }
        /// <p>The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.</p>
        pub fn set_vpce_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpce_service_name(input);
            self
        }
        /// <p>The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already
        /// be in use on the internet.</p>
        pub fn service_dns_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_dns_name(inp);
            self
        }
        /// <p>The DNS (domain) name used to connect to your private service in your VPC. The DNS name must not already
        /// be in use on the internet.</p>
        pub fn set_service_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_dns_name(input);
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn vpce_configuration_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.vpce_configuration_description(inp);
            self
        }
        /// <p>An optional description that provides details about your VPC endpoint configuration.</p>
        pub fn set_vpce_configuration_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpce_configuration_description(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
