// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDevicePoolError {
    /// Kind of error that occurred.
    pub kind: CreateDevicePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDevicePoolErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDevicePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDevicePoolErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateDevicePoolErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDevicePoolErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDevicePoolErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateDevicePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDevicePoolError {
    fn code(&self) -> Option<&str> {
        CreateDevicePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDevicePoolError {
    /// Creates a new `CreateDevicePoolError`.
    pub fn new(kind: CreateDevicePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDevicePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDevicePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDevicePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDevicePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDevicePoolErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, CreateDevicePoolErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `CreateDevicePoolErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevicePoolErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDevicePoolErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDevicePoolErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateDevicePoolErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevicePoolErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for CreateDevicePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDevicePoolErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateDevicePoolErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDevicePoolErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDevicePoolErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateDevicePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: CreateInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstanceProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstanceProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInstanceProfileError {
    fn code(&self) -> Option<&str> {
        CreateInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstanceProfileError {
    /// Creates a new `CreateInstanceProfileError`.
    pub fn new(kind: CreateInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateInstanceProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateInstanceProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateInstanceProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for CreateInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstanceProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: CreateNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNetworkProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNetworkProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNetworkProfileError {
    fn code(&self) -> Option<&str> {
        CreateNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNetworkProfileError {
    /// Creates a new `CreateNetworkProfileError`.
    pub fn new(kind: CreateNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for CreateNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNetworkProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// <p>The operation was not successful. Try again.</p>
    TagOperationException(crate::error::TagOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::TagOperationException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ServiceAccountException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::TagOperationException`.
    pub fn is_tag_operation_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::TagOperationException(_))
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateProjectErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateProjectErrorKind::TagOperationException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRemoteAccessSessionError {
    /// Kind of error that occurred.
    pub kind: CreateRemoteAccessSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRemoteAccessSessionErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRemoteAccessSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRemoteAccessSessionErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateRemoteAccessSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRemoteAccessSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateRemoteAccessSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRemoteAccessSessionError {
    fn code(&self) -> Option<&str> {
        CreateRemoteAccessSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRemoteAccessSessionError {
    /// Creates a new `CreateRemoteAccessSessionError`.
    pub fn new(kind: CreateRemoteAccessSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRemoteAccessSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRemoteAccessSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRemoteAccessSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRemoteAccessSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRemoteAccessSessionErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRemoteAccessSessionErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateRemoteAccessSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRemoteAccessSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateRemoteAccessSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRemoteAccessSessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateRemoteAccessSessionErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRemoteAccessSessionErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for CreateRemoteAccessSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRemoteAccessSessionErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateRemoteAccessSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRemoteAccessSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateRemoteAccessSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTestGridProjectError {
    /// Kind of error that occurred.
    pub kind: CreateTestGridProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTestGridProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTestGridProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTestGridProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateTestGridProjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateTestGridProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTestGridProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTestGridProjectError {
    fn code(&self) -> Option<&str> {
        CreateTestGridProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTestGridProjectError {
    /// Creates a new `CreateTestGridProjectError`.
    pub fn new(kind: CreateTestGridProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTestGridProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTestGridProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTestGridProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTestGridProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTestGridProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTestGridProjectErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateTestGridProjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTestGridProjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateTestGridProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTestGridProjectErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateTestGridProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTestGridProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateTestGridProjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateTestGridProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTestGridProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTestGridUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTestGridUrlError {
    /// Kind of error that occurred.
    pub kind: CreateTestGridUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTestGridUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTestGridUrlErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTestGridUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTestGridUrlErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateTestGridUrlErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateTestGridUrlErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateTestGridUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTestGridUrlError {
    fn code(&self) -> Option<&str> {
        CreateTestGridUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTestGridUrlError {
    /// Creates a new `CreateTestGridUrlError`.
    pub fn new(kind: CreateTestGridUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTestGridUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTestGridUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTestGridUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTestGridUrlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTestGridUrlErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, CreateTestGridUrlErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `CreateTestGridUrlErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTestGridUrlErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateTestGridUrlErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTestGridUrlErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateTestGridUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTestGridUrlErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateTestGridUrlErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateTestGridUrlErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateTestGridUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUploadError {
    /// Kind of error that occurred.
    pub kind: CreateUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUploadErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUploadErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateUploadErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUploadErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateUploadErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUploadError {
    fn code(&self) -> Option<&str> {
        CreateUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUploadError {
    /// Creates a new `CreateUploadError`.
    pub fn new(kind: CreateUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateUploadErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, CreateUploadErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `CreateUploadErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUploadErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateUploadErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateUploadErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateUploadErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUploadErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for CreateUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUploadErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateUploadErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUploadErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateUploadErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVPCEConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateVPCEConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVPCEConfigurationErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVPCEConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVPCEConfigurationErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            CreateVPCEConfigurationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVPCEConfigurationErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            CreateVPCEConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVPCEConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateVPCEConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVPCEConfigurationError {
    /// Creates a new `CreateVPCEConfigurationError`.
    pub fn new(kind: CreateVPCEConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVPCEConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVPCEConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVPCEConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVPCEConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateVPCEConfigurationErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCEConfigurationErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateVPCEConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCEConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateVPCEConfigurationErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCEConfigurationErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for CreateVPCEConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVPCEConfigurationErrorKind::ArgumentException(_inner) => Some(_inner),
            CreateVPCEConfigurationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVPCEConfigurationErrorKind::ServiceAccountException(_inner) => Some(_inner),
            CreateVPCEConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDevicePoolError {
    /// Kind of error that occurred.
    pub kind: DeleteDevicePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDevicePoolErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDevicePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDevicePoolErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteDevicePoolErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteDevicePoolErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDevicePoolErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteDevicePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDevicePoolError {
    fn code(&self) -> Option<&str> {
        DeleteDevicePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDevicePoolError {
    /// Creates a new `DeleteDevicePoolError`.
    pub fn new(kind: DeleteDevicePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDevicePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDevicePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDevicePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDevicePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDevicePoolErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, DeleteDevicePoolErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `DeleteDevicePoolErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDevicePoolErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDevicePoolErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDevicePoolErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDevicePoolErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDevicePoolErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteDevicePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDevicePoolErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteDevicePoolErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteDevicePoolErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDevicePoolErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteDevicePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstanceProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstanceProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInstanceProfileError {
    fn code(&self) -> Option<&str> {
        DeleteInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstanceProfileError {
    /// Creates a new `DeleteInstanceProfileError`.
    pub fn new(kind: DeleteInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteInstanceProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteInstanceProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteInstanceProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstanceProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNetworkProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNetworkProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNetworkProfileError {
    fn code(&self) -> Option<&str> {
        DeleteNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNetworkProfileError {
    /// Creates a new `DeleteNetworkProfileError`.
    pub fn new(kind: DeleteNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNetworkProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRemoteAccessSessionError {
    /// Kind of error that occurred.
    pub kind: DeleteRemoteAccessSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRemoteAccessSessionErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRemoteAccessSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRemoteAccessSessionErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteRemoteAccessSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteRemoteAccessSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteRemoteAccessSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRemoteAccessSessionError {
    fn code(&self) -> Option<&str> {
        DeleteRemoteAccessSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRemoteAccessSessionError {
    /// Creates a new `DeleteRemoteAccessSessionError`.
    pub fn new(kind: DeleteRemoteAccessSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRemoteAccessSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRemoteAccessSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRemoteAccessSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRemoteAccessSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRemoteAccessSessionErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemoteAccessSessionErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRemoteAccessSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemoteAccessSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRemoteAccessSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemoteAccessSessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRemoteAccessSessionErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRemoteAccessSessionErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteRemoteAccessSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRemoteAccessSessionErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteRemoteAccessSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteRemoteAccessSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteRemoteAccessSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRunError {
    /// Kind of error that occurred.
    pub kind: DeleteRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRunErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRunErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteRunErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteRunErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRunErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRunError {
    fn code(&self) -> Option<&str> {
        DeleteRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRunError {
    /// Creates a new `DeleteRunError`.
    pub fn new(kind: DeleteRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRunErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, DeleteRunErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `DeleteRunErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteRunErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DeleteRunErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRunErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteRunErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, DeleteRunErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for DeleteRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRunErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteRunErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteRunErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRunErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTestGridProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteTestGridProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTestGridProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>The requested object could not be deleted.</p>
    CannotDeleteException(crate::error::CannotDeleteException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTestGridProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTestGridProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteTestGridProjectErrorKind::CannotDeleteException(_inner) => _inner.fmt(f),
            DeleteTestGridProjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteTestGridProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteTestGridProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTestGridProjectError {
    fn code(&self) -> Option<&str> {
        DeleteTestGridProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTestGridProjectError {
    /// Creates a new `DeleteTestGridProjectError`.
    pub fn new(kind: DeleteTestGridProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTestGridProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTestGridProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTestGridProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTestGridProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTestGridProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTestGridProjectErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTestGridProjectErrorKind::CannotDeleteException`.
    pub fn is_cannot_delete_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTestGridProjectErrorKind::CannotDeleteException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTestGridProjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTestGridProjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTestGridProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTestGridProjectErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteTestGridProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTestGridProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteTestGridProjectErrorKind::CannotDeleteException(_inner) => Some(_inner),
            DeleteTestGridProjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteTestGridProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteTestGridProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUploadError {
    /// Kind of error that occurred.
    pub kind: DeleteUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUploadErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUploadErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteUploadErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteUploadErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUploadErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUploadError {
    fn code(&self) -> Option<&str> {
        DeleteUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUploadError {
    /// Creates a new `DeleteUploadError`.
    pub fn new(kind: DeleteUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteUploadErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, DeleteUploadErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `DeleteUploadErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteUploadErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `DeleteUploadErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteUploadErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteUploadErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUploadErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUploadErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteUploadErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteUploadErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUploadErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVPCEConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteVPCEConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVPCEConfigurationErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>There was an error with the update request, or you do not have sufficient permissions
    /// to update this VPC endpoint configuration.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVPCEConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVPCEConfigurationErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            DeleteVPCEConfigurationErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteVPCEConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVPCEConfigurationErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            DeleteVPCEConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVPCEConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteVPCEConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVPCEConfigurationError {
    /// Creates a new `DeleteVPCEConfigurationError`.
    pub fn new(kind: DeleteVPCEConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVPCEConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVPCEConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVPCEConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVPCEConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteVPCEConfigurationErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCEConfigurationErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVPCEConfigurationErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCEConfigurationErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVPCEConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCEConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVPCEConfigurationErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCEConfigurationErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for DeleteVPCEConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVPCEConfigurationErrorKind::ArgumentException(_inner) => Some(_inner),
            DeleteVPCEConfigurationErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteVPCEConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVPCEConfigurationErrorKind::ServiceAccountException(_inner) => Some(_inner),
            DeleteVPCEConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: GetAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountSettingsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountSettingsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountSettingsError {
    fn code(&self) -> Option<&str> {
        GetAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountSettingsError {
    /// Creates a new `GetAccountSettingsError`.
    pub fn new(kind: GetAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAccountSettingsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetAccountSettingsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetAccountSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetAccountSettingsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountSettingsErrorKind::ArgumentException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeviceError {
    /// Kind of error that occurred.
    pub kind: GetDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeviceErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeviceErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeviceError {
    fn code(&self) -> Option<&str> {
        GetDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeviceError {
    /// Creates a new `GetDeviceError`.
    pub fn new(kind: GetDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeviceErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetDeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDeviceErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeviceErrorKind::ArgumentException(_inner) => Some(_inner),
            GetDeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeviceErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeviceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeviceInstanceError {
    /// Kind of error that occurred.
    pub kind: GetDeviceInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeviceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeviceInstanceErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeviceInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeviceInstanceErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetDeviceInstanceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetDeviceInstanceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeviceInstanceErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetDeviceInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeviceInstanceError {
    fn code(&self) -> Option<&str> {
        GetDeviceInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeviceInstanceError {
    /// Creates a new `GetDeviceInstanceError`.
    pub fn new(kind: GetDeviceInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeviceInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeviceInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeviceInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeviceInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeviceInstanceErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceInstanceErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetDeviceInstanceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceInstanceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetDeviceInstanceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceInstanceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDeviceInstanceErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceInstanceErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetDeviceInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeviceInstanceErrorKind::ArgumentException(_inner) => Some(_inner),
            GetDeviceInstanceErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetDeviceInstanceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeviceInstanceErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetDeviceInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDevicePoolError {
    /// Kind of error that occurred.
    pub kind: GetDevicePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDevicePoolErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDevicePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDevicePoolErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetDevicePoolErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetDevicePoolErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDevicePoolErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetDevicePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDevicePoolError {
    fn code(&self) -> Option<&str> {
        GetDevicePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDevicePoolError {
    /// Creates a new `GetDevicePoolError`.
    pub fn new(kind: GetDevicePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDevicePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDevicePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDevicePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDevicePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDevicePoolErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetDevicePoolErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetDevicePoolErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicePoolErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetDevicePoolErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDevicePoolErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDevicePoolErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicePoolErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetDevicePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDevicePoolErrorKind::ArgumentException(_inner) => Some(_inner),
            GetDevicePoolErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetDevicePoolErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDevicePoolErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetDevicePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevicePoolCompatibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDevicePoolCompatibilityError {
    /// Kind of error that occurred.
    pub kind: GetDevicePoolCompatibilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevicePoolCompatibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDevicePoolCompatibilityErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDevicePoolCompatibilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDevicePoolCompatibilityErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetDevicePoolCompatibilityErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetDevicePoolCompatibilityErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDevicePoolCompatibilityErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetDevicePoolCompatibilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDevicePoolCompatibilityError {
    fn code(&self) -> Option<&str> {
        GetDevicePoolCompatibilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDevicePoolCompatibilityError {
    /// Creates a new `GetDevicePoolCompatibilityError`.
    pub fn new(kind: GetDevicePoolCompatibilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDevicePoolCompatibilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDevicePoolCompatibilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDevicePoolCompatibilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDevicePoolCompatibilityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDevicePoolCompatibilityErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicePoolCompatibilityErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetDevicePoolCompatibilityErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicePoolCompatibilityErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetDevicePoolCompatibilityErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicePoolCompatibilityErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDevicePoolCompatibilityErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevicePoolCompatibilityErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetDevicePoolCompatibilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDevicePoolCompatibilityErrorKind::ArgumentException(_inner) => Some(_inner),
            GetDevicePoolCompatibilityErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetDevicePoolCompatibilityErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDevicePoolCompatibilityErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetDevicePoolCompatibilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: GetInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetInstanceProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceProfileError {
    fn code(&self) -> Option<&str> {
        GetInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceProfileError {
    /// Creates a new `GetInstanceProfileError`.
    pub fn new(kind: GetInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetInstanceProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetInstanceProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetInstanceProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            GetInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetInstanceProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobError {
    /// Kind of error that occurred.
    pub kind: GetJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJobErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobError {
    fn code(&self) -> Option<&str> {
        GetJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobError {
    /// Creates a new `GetJobError`.
    pub fn new(kind: GetJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetJobErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetJobErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobErrorKind::ArgumentException(_inner) => Some(_inner),
            GetJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetJobErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJobErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: GetNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetNetworkProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetNetworkProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkProfileError {
    fn code(&self) -> Option<&str> {
        GetNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkProfileError {
    /// Creates a new `GetNetworkProfileError`.
    pub fn new(kind: GetNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetNetworkProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetNetworkProfileErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetNetworkProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetNetworkProfileErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetNetworkProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            GetNetworkProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            GetNetworkProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOfferingStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOfferingStatusError {
    /// Kind of error that occurred.
    pub kind: GetOfferingStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOfferingStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOfferingStatusErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Exception gets thrown when a user is not eligible to perform the specified
    /// transaction.</p>
    NotEligibleException(crate::error::NotEligibleException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOfferingStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOfferingStatusErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetOfferingStatusErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetOfferingStatusErrorKind::NotEligibleException(_inner) => _inner.fmt(f),
            GetOfferingStatusErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetOfferingStatusErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetOfferingStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOfferingStatusError {
    fn code(&self) -> Option<&str> {
        GetOfferingStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOfferingStatusError {
    /// Creates a new `GetOfferingStatusError`.
    pub fn new(kind: GetOfferingStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOfferingStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOfferingStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOfferingStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOfferingStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetOfferingStatusErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetOfferingStatusErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetOfferingStatusErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOfferingStatusErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetOfferingStatusErrorKind::NotEligibleException`.
    pub fn is_not_eligible_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOfferingStatusErrorKind::NotEligibleException(_)
        )
    }
    /// Returns true if the error kind is `GetOfferingStatusErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetOfferingStatusErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetOfferingStatusErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOfferingStatusErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetOfferingStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOfferingStatusErrorKind::ArgumentException(_inner) => Some(_inner),
            GetOfferingStatusErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetOfferingStatusErrorKind::NotEligibleException(_inner) => Some(_inner),
            GetOfferingStatusErrorKind::NotFoundException(_inner) => Some(_inner),
            GetOfferingStatusErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetOfferingStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProjectError {
    /// Kind of error that occurred.
    pub kind: GetProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProjectError {
    fn code(&self) -> Option<&str> {
        GetProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProjectError {
    /// Creates a new `GetProjectError`.
    pub fn new(kind: GetProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetProjectErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetProjectErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            GetProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            GetProjectErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRemoteAccessSessionError {
    /// Kind of error that occurred.
    pub kind: GetRemoteAccessSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRemoteAccessSessionErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRemoteAccessSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRemoteAccessSessionErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetRemoteAccessSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetRemoteAccessSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetRemoteAccessSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRemoteAccessSessionError {
    fn code(&self) -> Option<&str> {
        GetRemoteAccessSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRemoteAccessSessionError {
    /// Creates a new `GetRemoteAccessSessionError`.
    pub fn new(kind: GetRemoteAccessSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRemoteAccessSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRemoteAccessSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRemoteAccessSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRemoteAccessSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRemoteAccessSessionErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRemoteAccessSessionErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetRemoteAccessSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRemoteAccessSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `GetRemoteAccessSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRemoteAccessSessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetRemoteAccessSessionErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRemoteAccessSessionErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetRemoteAccessSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRemoteAccessSessionErrorKind::ArgumentException(_inner) => Some(_inner),
            GetRemoteAccessSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetRemoteAccessSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetRemoteAccessSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRunError {
    /// Kind of error that occurred.
    pub kind: GetRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRunErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRunErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetRunErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetRunErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRunErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRunError {
    fn code(&self) -> Option<&str> {
        GetRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRunError {
    /// Creates a new `GetRunError`.
    pub fn new(kind: GetRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRunErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetRunErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetRunErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetRunErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetRunErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRunErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetRunErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetRunErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRunErrorKind::ArgumentException(_inner) => Some(_inner),
            GetRunErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetRunErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRunErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSuite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSuiteError {
    /// Kind of error that occurred.
    pub kind: GetSuiteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSuite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSuiteErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSuiteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSuiteErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetSuiteErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSuiteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSuiteErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetSuiteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSuiteError {
    fn code(&self) -> Option<&str> {
        GetSuiteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSuiteError {
    /// Creates a new `GetSuiteError`.
    pub fn new(kind: GetSuiteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSuiteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSuiteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSuiteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSuiteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSuiteErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetSuiteErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetSuiteErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetSuiteErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetSuiteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSuiteErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetSuiteErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetSuiteErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetSuiteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSuiteErrorKind::ArgumentException(_inner) => Some(_inner),
            GetSuiteErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSuiteErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSuiteErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetSuiteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTestError {
    /// Kind of error that occurred.
    pub kind: GetTestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTestErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTestErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetTestErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetTestErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTestErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetTestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTestError {
    fn code(&self) -> Option<&str> {
        GetTestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTestError {
    /// Creates a new `GetTestError`.
    pub fn new(kind: GetTestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTestErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetTestErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetTestErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetTestErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetTestErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTestErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetTestErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetTestErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetTestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTestErrorKind::ArgumentException(_inner) => Some(_inner),
            GetTestErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetTestErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTestErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetTestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTestGridProjectError {
    /// Kind of error that occurred.
    pub kind: GetTestGridProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTestGridProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTestGridProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTestGridProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetTestGridProjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTestGridProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTestGridProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTestGridProjectError {
    fn code(&self) -> Option<&str> {
        GetTestGridProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTestGridProjectError {
    /// Creates a new `GetTestGridProjectError`.
    pub fn new(kind: GetTestGridProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTestGridProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTestGridProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTestGridProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTestGridProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTestGridProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTestGridProjectErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetTestGridProjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTestGridProjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetTestGridProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTestGridProjectErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetTestGridProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTestGridProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            GetTestGridProjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTestGridProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTestGridProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTestGridSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTestGridSessionError {
    /// Kind of error that occurred.
    pub kind: GetTestGridSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTestGridSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTestGridSessionErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTestGridSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTestGridSessionErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetTestGridSessionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTestGridSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTestGridSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTestGridSessionError {
    fn code(&self) -> Option<&str> {
        GetTestGridSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTestGridSessionError {
    /// Creates a new `GetTestGridSessionError`.
    pub fn new(kind: GetTestGridSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTestGridSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTestGridSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTestGridSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTestGridSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTestGridSessionErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTestGridSessionErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetTestGridSessionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTestGridSessionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetTestGridSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTestGridSessionErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetTestGridSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTestGridSessionErrorKind::ArgumentException(_inner) => Some(_inner),
            GetTestGridSessionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTestGridSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTestGridSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUploadError {
    /// Kind of error that occurred.
    pub kind: GetUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUploadErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUploadErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetUploadErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetUploadErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetUploadErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUploadError {
    fn code(&self) -> Option<&str> {
        GetUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUploadError {
    /// Creates a new `GetUploadError`.
    pub fn new(kind: GetUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetUploadErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, GetUploadErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `GetUploadErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetUploadErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetUploadErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetUploadErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetUploadErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, GetUploadErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for GetUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUploadErrorKind::ArgumentException(_inner) => Some(_inner),
            GetUploadErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetUploadErrorKind::NotFoundException(_inner) => Some(_inner),
            GetUploadErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVPCEConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetVPCEConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVPCEConfigurationErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVPCEConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVPCEConfigurationErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            GetVPCEConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetVPCEConfigurationErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            GetVPCEConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVPCEConfigurationError {
    fn code(&self) -> Option<&str> {
        GetVPCEConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVPCEConfigurationError {
    /// Creates a new `GetVPCEConfigurationError`.
    pub fn new(kind: GetVPCEConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVPCEConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVPCEConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVPCEConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVPCEConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetVPCEConfigurationErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVPCEConfigurationErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `GetVPCEConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVPCEConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetVPCEConfigurationErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVPCEConfigurationErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for GetVPCEConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVPCEConfigurationErrorKind::ArgumentException(_inner) => Some(_inner),
            GetVPCEConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetVPCEConfigurationErrorKind::ServiceAccountException(_inner) => Some(_inner),
            GetVPCEConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InstallToRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InstallToRemoteAccessSessionError {
    /// Kind of error that occurred.
    pub kind: InstallToRemoteAccessSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InstallToRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InstallToRemoteAccessSessionErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InstallToRemoteAccessSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InstallToRemoteAccessSessionErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            InstallToRemoteAccessSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            InstallToRemoteAccessSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            InstallToRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            InstallToRemoteAccessSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InstallToRemoteAccessSessionError {
    fn code(&self) -> Option<&str> {
        InstallToRemoteAccessSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InstallToRemoteAccessSessionError {
    /// Creates a new `InstallToRemoteAccessSessionError`.
    pub fn new(kind: InstallToRemoteAccessSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InstallToRemoteAccessSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InstallToRemoteAccessSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InstallToRemoteAccessSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InstallToRemoteAccessSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `InstallToRemoteAccessSessionErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            InstallToRemoteAccessSessionErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `InstallToRemoteAccessSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            InstallToRemoteAccessSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `InstallToRemoteAccessSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InstallToRemoteAccessSessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `InstallToRemoteAccessSessionErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            InstallToRemoteAccessSessionErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for InstallToRemoteAccessSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InstallToRemoteAccessSessionErrorKind::ArgumentException(_inner) => Some(_inner),
            InstallToRemoteAccessSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            InstallToRemoteAccessSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            InstallToRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => Some(_inner),
            InstallToRemoteAccessSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListArtifactsError {
    /// Kind of error that occurred.
    pub kind: ListArtifactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListArtifactsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListArtifactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListArtifactsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListArtifactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListArtifactsError {
    fn code(&self) -> Option<&str> {
        ListArtifactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListArtifactsError {
    /// Creates a new `ListArtifactsError`.
    pub fn new(kind: ListArtifactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListArtifactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListArtifactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListArtifactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListArtifactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListArtifactsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListArtifactsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListArtifactsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListArtifactsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListArtifactsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListArtifactsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListArtifactsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListArtifactsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListArtifactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListArtifactsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListArtifactsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListArtifactsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListArtifactsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListArtifactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeviceInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeviceInstancesError {
    /// Kind of error that occurred.
    pub kind: ListDeviceInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeviceInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeviceInstancesErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeviceInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeviceInstancesErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListDeviceInstancesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListDeviceInstancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDeviceInstancesErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListDeviceInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeviceInstancesError {
    fn code(&self) -> Option<&str> {
        ListDeviceInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeviceInstancesError {
    /// Creates a new `ListDeviceInstancesError`.
    pub fn new(kind: ListDeviceInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeviceInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeviceInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeviceInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeviceInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDeviceInstancesErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceInstancesErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListDeviceInstancesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceInstancesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListDeviceInstancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceInstancesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListDeviceInstancesErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceInstancesErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListDeviceInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeviceInstancesErrorKind::ArgumentException(_inner) => Some(_inner),
            ListDeviceInstancesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListDeviceInstancesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDeviceInstancesErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListDeviceInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevicePools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicePoolsError {
    /// Kind of error that occurred.
    pub kind: ListDevicePoolsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevicePools` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicePoolsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicePoolsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicePoolsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListDevicePoolsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListDevicePoolsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDevicePoolsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListDevicePoolsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicePoolsError {
    fn code(&self) -> Option<&str> {
        ListDevicePoolsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicePoolsError {
    /// Creates a new `ListDevicePoolsError`.
    pub fn new(kind: ListDevicePoolsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicePoolsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicePoolsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicePoolsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicePoolsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDevicePoolsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListDevicePoolsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListDevicePoolsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicePoolsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListDevicePoolsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListDevicePoolsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListDevicePoolsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicePoolsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListDevicePoolsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicePoolsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListDevicePoolsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListDevicePoolsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDevicePoolsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListDevicePoolsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicesError {
    /// Kind of error that occurred.
    pub kind: ListDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicesErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicesErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicesError {
    fn code(&self) -> Option<&str> {
        ListDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicesError {
    /// Creates a new `ListDevicesError`.
    pub fn new(kind: ListDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDevicesErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListDevicesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListDevicesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListDevicesErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicesErrorKind::ArgumentException(_inner) => Some(_inner),
            ListDevicesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListDevicesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDevicesErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceProfilesError {
    /// Kind of error that occurred.
    pub kind: ListInstanceProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceProfilesErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceProfilesErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListInstanceProfilesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListInstanceProfilesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListInstanceProfilesErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListInstanceProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceProfilesError {
    fn code(&self) -> Option<&str> {
        ListInstanceProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceProfilesError {
    /// Creates a new `ListInstanceProfilesError`.
    pub fn new(kind: ListInstanceProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListInstanceProfilesErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListInstanceProfilesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListInstanceProfilesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListInstanceProfilesErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListInstanceProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceProfilesErrorKind::ArgumentException(_inner) => Some(_inner),
            ListInstanceProfilesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListInstanceProfilesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListInstanceProfilesErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListInstanceProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListJobsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListJobsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListJobsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListJobsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListJobsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNetworkProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNetworkProfilesError {
    /// Kind of error that occurred.
    pub kind: ListNetworkProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNetworkProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNetworkProfilesErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNetworkProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNetworkProfilesErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListNetworkProfilesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListNetworkProfilesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListNetworkProfilesErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListNetworkProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNetworkProfilesError {
    fn code(&self) -> Option<&str> {
        ListNetworkProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNetworkProfilesError {
    /// Creates a new `ListNetworkProfilesError`.
    pub fn new(kind: ListNetworkProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNetworkProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNetworkProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNetworkProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNetworkProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListNetworkProfilesErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkProfilesErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListNetworkProfilesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkProfilesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListNetworkProfilesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkProfilesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListNetworkProfilesErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkProfilesErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListNetworkProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNetworkProfilesErrorKind::ArgumentException(_inner) => Some(_inner),
            ListNetworkProfilesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListNetworkProfilesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListNetworkProfilesErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListNetworkProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOfferingPromotions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOfferingPromotionsError {
    /// Kind of error that occurred.
    pub kind: ListOfferingPromotionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOfferingPromotions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOfferingPromotionsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Exception gets thrown when a user is not eligible to perform the specified
    /// transaction.</p>
    NotEligibleException(crate::error::NotEligibleException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOfferingPromotionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOfferingPromotionsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListOfferingPromotionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListOfferingPromotionsErrorKind::NotEligibleException(_inner) => _inner.fmt(f),
            ListOfferingPromotionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListOfferingPromotionsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListOfferingPromotionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOfferingPromotionsError {
    fn code(&self) -> Option<&str> {
        ListOfferingPromotionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOfferingPromotionsError {
    /// Creates a new `ListOfferingPromotionsError`.
    pub fn new(kind: ListOfferingPromotionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOfferingPromotionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOfferingPromotionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOfferingPromotionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOfferingPromotionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOfferingPromotionsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingPromotionsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingPromotionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingPromotionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingPromotionsErrorKind::NotEligibleException`.
    pub fn is_not_eligible_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingPromotionsErrorKind::NotEligibleException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingPromotionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingPromotionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingPromotionsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingPromotionsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListOfferingPromotionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOfferingPromotionsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListOfferingPromotionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListOfferingPromotionsErrorKind::NotEligibleException(_inner) => Some(_inner),
            ListOfferingPromotionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListOfferingPromotionsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListOfferingPromotionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOfferingsError {
    /// Kind of error that occurred.
    pub kind: ListOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOfferingsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Exception gets thrown when a user is not eligible to perform the specified
    /// transaction.</p>
    NotEligibleException(crate::error::NotEligibleException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOfferingsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::NotEligibleException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOfferingsError {
    fn code(&self) -> Option<&str> {
        ListOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOfferingsError {
    /// Creates a new `ListOfferingsError`.
    pub fn new(kind: ListOfferingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOfferingsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListOfferingsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingsErrorKind::NotEligibleException`.
    pub fn is_not_eligible_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::NotEligibleException(_))
    }
    /// Returns true if the error kind is `ListOfferingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListOfferingsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOfferingsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListOfferingsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListOfferingsErrorKind::NotEligibleException(_inner) => Some(_inner),
            ListOfferingsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListOfferingsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListOfferingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOfferingTransactions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOfferingTransactionsError {
    /// Kind of error that occurred.
    pub kind: ListOfferingTransactionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOfferingTransactions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOfferingTransactionsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Exception gets thrown when a user is not eligible to perform the specified
    /// transaction.</p>
    NotEligibleException(crate::error::NotEligibleException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOfferingTransactionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOfferingTransactionsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListOfferingTransactionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListOfferingTransactionsErrorKind::NotEligibleException(_inner) => _inner.fmt(f),
            ListOfferingTransactionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListOfferingTransactionsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListOfferingTransactionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOfferingTransactionsError {
    fn code(&self) -> Option<&str> {
        ListOfferingTransactionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOfferingTransactionsError {
    /// Creates a new `ListOfferingTransactionsError`.
    pub fn new(kind: ListOfferingTransactionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOfferingTransactionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOfferingTransactionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOfferingTransactionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOfferingTransactionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOfferingTransactionsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingTransactionsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingTransactionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingTransactionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingTransactionsErrorKind::NotEligibleException`.
    pub fn is_not_eligible_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingTransactionsErrorKind::NotEligibleException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingTransactionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingTransactionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListOfferingTransactionsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingTransactionsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListOfferingTransactionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOfferingTransactionsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListOfferingTransactionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListOfferingTransactionsErrorKind::NotEligibleException(_inner) => Some(_inner),
            ListOfferingTransactionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListOfferingTransactionsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListOfferingTransactionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListProjectsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListProjectsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListProjectsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRemoteAccessSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRemoteAccessSessionsError {
    /// Kind of error that occurred.
    pub kind: ListRemoteAccessSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRemoteAccessSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRemoteAccessSessionsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRemoteAccessSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRemoteAccessSessionsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListRemoteAccessSessionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListRemoteAccessSessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListRemoteAccessSessionsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListRemoteAccessSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRemoteAccessSessionsError {
    fn code(&self) -> Option<&str> {
        ListRemoteAccessSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRemoteAccessSessionsError {
    /// Creates a new `ListRemoteAccessSessionsError`.
    pub fn new(kind: ListRemoteAccessSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRemoteAccessSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRemoteAccessSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRemoteAccessSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRemoteAccessSessionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListRemoteAccessSessionsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRemoteAccessSessionsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListRemoteAccessSessionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRemoteAccessSessionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListRemoteAccessSessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRemoteAccessSessionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListRemoteAccessSessionsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRemoteAccessSessionsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListRemoteAccessSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRemoteAccessSessionsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListRemoteAccessSessionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListRemoteAccessSessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListRemoteAccessSessionsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListRemoteAccessSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRunsError {
    /// Kind of error that occurred.
    pub kind: ListRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRunsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRunsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListRunsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListRunsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListRunsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRunsError {
    fn code(&self) -> Option<&str> {
        ListRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRunsError {
    /// Creates a new `ListRunsError`.
    pub fn new(kind: ListRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRunsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListRunsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListRunsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListRunsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListRunsErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListRunsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListRunsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListRunsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListRunsErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRunsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListRunsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListRunsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListRunsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSamples` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSamplesError {
    /// Kind of error that occurred.
    pub kind: ListSamplesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSamples` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSamplesErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSamplesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSamplesErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListSamplesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListSamplesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListSamplesErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListSamplesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSamplesError {
    fn code(&self) -> Option<&str> {
        ListSamplesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSamplesError {
    /// Creates a new `ListSamplesError`.
    pub fn new(kind: ListSamplesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSamplesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSamplesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSamplesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSamplesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSamplesErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListSamplesErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListSamplesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListSamplesErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListSamplesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListSamplesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListSamplesErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListSamplesErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListSamplesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSamplesErrorKind::ArgumentException(_inner) => Some(_inner),
            ListSamplesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListSamplesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListSamplesErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListSamplesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSuites` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSuitesError {
    /// Kind of error that occurred.
    pub kind: ListSuitesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSuites` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSuitesErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSuitesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSuitesErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListSuitesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListSuitesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListSuitesErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListSuitesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSuitesError {
    fn code(&self) -> Option<&str> {
        ListSuitesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSuitesError {
    /// Creates a new `ListSuitesError`.
    pub fn new(kind: ListSuitesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSuitesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSuitesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSuitesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSuitesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSuitesErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListSuitesErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListSuitesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListSuitesErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListSuitesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListSuitesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListSuitesErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListSuitesErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListSuitesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSuitesErrorKind::ArgumentException(_inner) => Some(_inner),
            ListSuitesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListSuitesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListSuitesErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListSuitesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The operation was not successful. Try again.</p>
    TagOperationException(crate::error::TagOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TagOperationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::TagOperationException`.
    pub fn is_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TagOperationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ArgumentException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TagOperationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTestGridProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTestGridProjectsError {
    /// Kind of error that occurred.
    pub kind: ListTestGridProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTestGridProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTestGridProjectsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTestGridProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTestGridProjectsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListTestGridProjectsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTestGridProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTestGridProjectsError {
    fn code(&self) -> Option<&str> {
        ListTestGridProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTestGridProjectsError {
    /// Creates a new `ListTestGridProjectsError`.
    pub fn new(kind: ListTestGridProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTestGridProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTestGridProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTestGridProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTestGridProjectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTestGridProjectsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridProjectsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridProjectsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridProjectsErrorKind::InternalServiceException(_)
        )
    }
}
impl std::error::Error for ListTestGridProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTestGridProjectsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListTestGridProjectsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTestGridProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTestGridSessionActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTestGridSessionActionsError {
    /// Kind of error that occurred.
    pub kind: ListTestGridSessionActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTestGridSessionActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTestGridSessionActionsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTestGridSessionActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTestGridSessionActionsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListTestGridSessionActionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTestGridSessionActionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTestGridSessionActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTestGridSessionActionsError {
    fn code(&self) -> Option<&str> {
        ListTestGridSessionActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTestGridSessionActionsError {
    /// Creates a new `ListTestGridSessionActionsError`.
    pub fn new(kind: ListTestGridSessionActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTestGridSessionActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTestGridSessionActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTestGridSessionActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTestGridSessionActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTestGridSessionActionsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionActionsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridSessionActionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionActionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridSessionActionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionActionsErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTestGridSessionActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTestGridSessionActionsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListTestGridSessionActionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTestGridSessionActionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTestGridSessionActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTestGridSessionArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTestGridSessionArtifactsError {
    /// Kind of error that occurred.
    pub kind: ListTestGridSessionArtifactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTestGridSessionArtifacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTestGridSessionArtifactsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTestGridSessionArtifactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTestGridSessionArtifactsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListTestGridSessionArtifactsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            ListTestGridSessionArtifactsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTestGridSessionArtifactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTestGridSessionArtifactsError {
    fn code(&self) -> Option<&str> {
        ListTestGridSessionArtifactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTestGridSessionArtifactsError {
    /// Creates a new `ListTestGridSessionArtifactsError`.
    pub fn new(kind: ListTestGridSessionArtifactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTestGridSessionArtifactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTestGridSessionArtifactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTestGridSessionArtifactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTestGridSessionArtifactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTestGridSessionArtifactsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionArtifactsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridSessionArtifactsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionArtifactsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridSessionArtifactsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionArtifactsErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTestGridSessionArtifactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTestGridSessionArtifactsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListTestGridSessionArtifactsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTestGridSessionArtifactsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTestGridSessionArtifactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTestGridSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTestGridSessionsError {
    /// Kind of error that occurred.
    pub kind: ListTestGridSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTestGridSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTestGridSessionsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTestGridSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTestGridSessionsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListTestGridSessionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTestGridSessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTestGridSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTestGridSessionsError {
    fn code(&self) -> Option<&str> {
        ListTestGridSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTestGridSessionsError {
    /// Creates a new `ListTestGridSessionsError`.
    pub fn new(kind: ListTestGridSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTestGridSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTestGridSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTestGridSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTestGridSessionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTestGridSessionsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridSessionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListTestGridSessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTestGridSessionsErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTestGridSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTestGridSessionsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListTestGridSessionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTestGridSessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTestGridSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTestsError {
    /// Kind of error that occurred.
    pub kind: ListTestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTestsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTestsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListTestsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTestsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTestsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListTestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTestsError {
    fn code(&self) -> Option<&str> {
        ListTestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTestsError {
    /// Creates a new `ListTestsError`.
    pub fn new(kind: ListTestsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTestsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTestsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListTestsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListTestsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListTestsErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListTestsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTestsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListTestsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListTestsErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListTestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTestsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListTestsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTestsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTestsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListTestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUniqueProblems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUniqueProblemsError {
    /// Kind of error that occurred.
    pub kind: ListUniqueProblemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUniqueProblems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUniqueProblemsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUniqueProblemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUniqueProblemsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListUniqueProblemsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListUniqueProblemsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListUniqueProblemsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListUniqueProblemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUniqueProblemsError {
    fn code(&self) -> Option<&str> {
        ListUniqueProblemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUniqueProblemsError {
    /// Creates a new `ListUniqueProblemsError`.
    pub fn new(kind: ListUniqueProblemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUniqueProblemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUniqueProblemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUniqueProblemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUniqueProblemsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListUniqueProblemsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUniqueProblemsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListUniqueProblemsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUniqueProblemsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListUniqueProblemsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUniqueProblemsErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListUniqueProblemsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUniqueProblemsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListUniqueProblemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUniqueProblemsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListUniqueProblemsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListUniqueProblemsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListUniqueProblemsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListUniqueProblemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUploads` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUploadsError {
    /// Kind of error that occurred.
    pub kind: ListUploadsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUploads` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUploadsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUploadsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUploadsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListUploadsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListUploadsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListUploadsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListUploadsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUploadsError {
    fn code(&self) -> Option<&str> {
        ListUploadsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUploadsError {
    /// Creates a new `ListUploadsError`.
    pub fn new(kind: ListUploadsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUploadsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUploadsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUploadsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUploadsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListUploadsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ListUploadsErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ListUploadsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListUploadsErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ListUploadsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUploadsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListUploadsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ListUploadsErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ListUploadsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUploadsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListUploadsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListUploadsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListUploadsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListUploadsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVPCEConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVPCEConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListVPCEConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVPCEConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVPCEConfigurationsErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVPCEConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVPCEConfigurationsErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ListVPCEConfigurationsErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ListVPCEConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVPCEConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListVPCEConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVPCEConfigurationsError {
    /// Creates a new `ListVPCEConfigurationsError`.
    pub fn new(kind: ListVPCEConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVPCEConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVPCEConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVPCEConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVPCEConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListVPCEConfigurationsErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVPCEConfigurationsErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListVPCEConfigurationsErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVPCEConfigurationsErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for ListVPCEConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVPCEConfigurationsErrorKind::ArgumentException(_inner) => Some(_inner),
            ListVPCEConfigurationsErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ListVPCEConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseOfferingErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Exception gets thrown when a user is not eligible to perform the specified
    /// transaction.</p>
    NotEligibleException(crate::error::NotEligibleException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseOfferingErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::NotEligibleException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseOfferingError {
    fn code(&self) -> Option<&str> {
        PurchaseOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseOfferingError {
    /// Creates a new `PurchaseOfferingError`.
    pub fn new(kind: PurchaseOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseOfferingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PurchaseOfferingErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `PurchaseOfferingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseOfferingErrorKind::NotEligibleException`.
    pub fn is_not_eligible_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::NotEligibleException(_)
        )
    }
    /// Returns true if the error kind is `PurchaseOfferingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PurchaseOfferingErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for PurchaseOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseOfferingErrorKind::ArgumentException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::LimitExceededException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::NotEligibleException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::NotFoundException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::ServiceAccountException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RenewOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RenewOfferingError {
    /// Kind of error that occurred.
    pub kind: RenewOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RenewOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RenewOfferingErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Exception gets thrown when a user is not eligible to perform the specified
    /// transaction.</p>
    NotEligibleException(crate::error::NotEligibleException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RenewOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RenewOfferingErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            RenewOfferingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RenewOfferingErrorKind::NotEligibleException(_inner) => _inner.fmt(f),
            RenewOfferingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RenewOfferingErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            RenewOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RenewOfferingError {
    fn code(&self) -> Option<&str> {
        RenewOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RenewOfferingError {
    /// Creates a new `RenewOfferingError`.
    pub fn new(kind: RenewOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RenewOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RenewOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RenewOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RenewOfferingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RenewOfferingErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, RenewOfferingErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `RenewOfferingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RenewOfferingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `RenewOfferingErrorKind::NotEligibleException`.
    pub fn is_not_eligible_exception(&self) -> bool {
        matches!(&self.kind, RenewOfferingErrorKind::NotEligibleException(_))
    }
    /// Returns true if the error kind is `RenewOfferingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RenewOfferingErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `RenewOfferingErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            RenewOfferingErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for RenewOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RenewOfferingErrorKind::ArgumentException(_inner) => Some(_inner),
            RenewOfferingErrorKind::LimitExceededException(_inner) => Some(_inner),
            RenewOfferingErrorKind::NotEligibleException(_inner) => Some(_inner),
            RenewOfferingErrorKind::NotFoundException(_inner) => Some(_inner),
            RenewOfferingErrorKind::ServiceAccountException(_inner) => Some(_inner),
            RenewOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ScheduleRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ScheduleRunError {
    /// Kind of error that occurred.
    pub kind: ScheduleRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ScheduleRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ScheduleRunErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An entity with the same name already exists.</p>
    IdempotencyException(crate::error::IdempotencyException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ScheduleRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ScheduleRunErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            ScheduleRunErrorKind::IdempotencyException(_inner) => _inner.fmt(f),
            ScheduleRunErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ScheduleRunErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ScheduleRunErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            ScheduleRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ScheduleRunError {
    fn code(&self) -> Option<&str> {
        ScheduleRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ScheduleRunError {
    /// Creates a new `ScheduleRunError`.
    pub fn new(kind: ScheduleRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ScheduleRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ScheduleRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ScheduleRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ScheduleRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ScheduleRunErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, ScheduleRunErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `ScheduleRunErrorKind::IdempotencyException`.
    pub fn is_idempotency_exception(&self) -> bool {
        matches!(&self.kind, ScheduleRunErrorKind::IdempotencyException(_))
    }
    /// Returns true if the error kind is `ScheduleRunErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ScheduleRunErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ScheduleRunErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ScheduleRunErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ScheduleRunErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, ScheduleRunErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for ScheduleRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ScheduleRunErrorKind::ArgumentException(_inner) => Some(_inner),
            ScheduleRunErrorKind::IdempotencyException(_inner) => Some(_inner),
            ScheduleRunErrorKind::LimitExceededException(_inner) => Some(_inner),
            ScheduleRunErrorKind::NotFoundException(_inner) => Some(_inner),
            ScheduleRunErrorKind::ServiceAccountException(_inner) => Some(_inner),
            ScheduleRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopJobError {
    /// Kind of error that occurred.
    pub kind: StopJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopJobErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopJobErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            StopJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopJobErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            StopJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopJobError {
    fn code(&self) -> Option<&str> {
        StopJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopJobError {
    /// Creates a new `StopJobError`.
    pub fn new(kind: StopJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopJobErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `StopJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `StopJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `StopJobErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, StopJobErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for StopJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopJobErrorKind::ArgumentException(_inner) => Some(_inner),
            StopJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopJobErrorKind::NotFoundException(_inner) => Some(_inner),
            StopJobErrorKind::ServiceAccountException(_inner) => Some(_inner),
            StopJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopRemoteAccessSessionError {
    /// Kind of error that occurred.
    pub kind: StopRemoteAccessSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopRemoteAccessSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopRemoteAccessSessionErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopRemoteAccessSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopRemoteAccessSessionErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            StopRemoteAccessSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopRemoteAccessSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            StopRemoteAccessSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopRemoteAccessSessionError {
    fn code(&self) -> Option<&str> {
        StopRemoteAccessSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopRemoteAccessSessionError {
    /// Creates a new `StopRemoteAccessSessionError`.
    pub fn new(kind: StopRemoteAccessSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopRemoteAccessSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopRemoteAccessSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopRemoteAccessSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopRemoteAccessSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopRemoteAccessSessionErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRemoteAccessSessionErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `StopRemoteAccessSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRemoteAccessSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `StopRemoteAccessSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRemoteAccessSessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StopRemoteAccessSessionErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopRemoteAccessSessionErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for StopRemoteAccessSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopRemoteAccessSessionErrorKind::ArgumentException(_inner) => Some(_inner),
            StopRemoteAccessSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopRemoteAccessSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            StopRemoteAccessSessionErrorKind::ServiceAccountException(_inner) => Some(_inner),
            StopRemoteAccessSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopRunError {
    /// Kind of error that occurred.
    pub kind: StopRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopRunErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopRunErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            StopRunErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopRunErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopRunErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            StopRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopRunError {
    fn code(&self) -> Option<&str> {
        StopRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopRunError {
    /// Creates a new `StopRunError`.
    pub fn new(kind: StopRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopRunErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, StopRunErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `StopRunErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StopRunErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `StopRunErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopRunErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `StopRunErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(&self.kind, StopRunErrorKind::ServiceAccountException(_))
    }
}
impl std::error::Error for StopRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopRunErrorKind::ArgumentException(_inner) => Some(_inner),
            StopRunErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopRunErrorKind::NotFoundException(_inner) => Some(_inner),
            StopRunErrorKind::ServiceAccountException(_inner) => Some(_inner),
            StopRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The operation was not successful. Try again.</p>
    TagOperationException(crate::error::TagOperationException),
    /// <p>The request doesn't comply with the AWS Identity and Access Management (IAM) tag
    /// policy. Correct your request and then retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that
    /// can be applied to a repository is 50. </p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagOperationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TagOperationException`.
    pub fn is_tag_operation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TagOperationException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TagPolicyException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ArgumentException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TagOperationException(_inner) => Some(_inner),
            TagResourceErrorKind::TagPolicyException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The operation was not successful. Try again.</p>
    TagOperationException(crate::error::TagOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagOperationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::TagOperationException`.
    pub fn is_tag_operation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TagOperationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ArgumentException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TagOperationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeviceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeviceInstanceError {
    /// Kind of error that occurred.
    pub kind: UpdateDeviceInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeviceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeviceInstanceErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeviceInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeviceInstanceErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateDeviceInstanceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDeviceInstanceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceInstanceErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateDeviceInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeviceInstanceError {
    fn code(&self) -> Option<&str> {
        UpdateDeviceInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeviceInstanceError {
    /// Creates a new `UpdateDeviceInstanceError`.
    pub fn new(kind: UpdateDeviceInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeviceInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeviceInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeviceInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeviceInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDeviceInstanceErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceInstanceErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeviceInstanceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceInstanceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeviceInstanceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceInstanceErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeviceInstanceErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceInstanceErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateDeviceInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeviceInstanceErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateDeviceInstanceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDeviceInstanceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDeviceInstanceErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateDeviceInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDevicePoolError {
    /// Kind of error that occurred.
    pub kind: UpdateDevicePoolErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDevicePool` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDevicePoolErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDevicePoolError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDevicePoolErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateDevicePoolErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDevicePoolErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDevicePoolErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateDevicePoolErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDevicePoolError {
    fn code(&self) -> Option<&str> {
        UpdateDevicePoolError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDevicePoolError {
    /// Creates a new `UpdateDevicePoolError`.
    pub fn new(kind: UpdateDevicePoolErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDevicePoolError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDevicePoolErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDevicePoolError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDevicePoolErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDevicePoolErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, UpdateDevicePoolErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `UpdateDevicePoolErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePoolErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDevicePoolErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDevicePoolErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDevicePoolErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevicePoolErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateDevicePoolError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDevicePoolErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateDevicePoolErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDevicePoolErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDevicePoolErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateDevicePoolErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInstanceProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInstanceProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateInstanceProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateInstanceProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInstanceProfileError {
    fn code(&self) -> Option<&str> {
        UpdateInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInstanceProfileError {
    /// Creates a new `UpdateInstanceProfileError`.
    pub fn new(kind: UpdateInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateInstanceProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateInstanceProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateInstanceProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInstanceProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateInstanceProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateInstanceProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNetworkProfileErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNetworkProfileErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNetworkProfileError {
    fn code(&self) -> Option<&str> {
        UpdateNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNetworkProfileError {
    /// Creates a new `UpdateNetworkProfileError`.
    pub fn new(kind: UpdateNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNetworkProfileErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectError {
    fn code(&self) -> Option<&str> {
        UpdateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectError {
    /// Creates a new `UpdateProjectError`.
    pub fn new(kind: UpdateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTestGridProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateTestGridProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTestGridProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTestGridProjectErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
    /// error. </p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTestGridProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTestGridProjectErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateTestGridProjectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateTestGridProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTestGridProjectErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateTestGridProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTestGridProjectError {
    fn code(&self) -> Option<&str> {
        UpdateTestGridProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTestGridProjectError {
    /// Creates a new `UpdateTestGridProjectError`.
    pub fn new(kind: UpdateTestGridProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTestGridProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTestGridProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTestGridProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTestGridProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateTestGridProjectErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTestGridProjectErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTestGridProjectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTestGridProjectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTestGridProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTestGridProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTestGridProjectErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTestGridProjectErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateTestGridProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTestGridProjectErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateTestGridProjectErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateTestGridProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTestGridProjectErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateTestGridProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUploadError {
    /// Kind of error that occurred.
    pub kind: UpdateUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUploadErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>A limit was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUploadErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateUploadErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateUploadErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateUploadErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUploadError {
    fn code(&self) -> Option<&str> {
        UpdateUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUploadError {
    /// Creates a new `UpdateUploadError`.
    pub fn new(kind: UpdateUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateUploadErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(&self.kind, UpdateUploadErrorKind::ArgumentException(_))
    }
    /// Returns true if the error kind is `UpdateUploadErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateUploadErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateUploadErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateUploadErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateUploadErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUploadErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUploadErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateUploadErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateUploadErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateUploadErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVPCEConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateVPCEConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVPCEConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVPCEConfigurationErrorKind {
    /// <p>An invalid argument was specified.</p>
    ArgumentException(crate::error::ArgumentException),
    /// <p>There was an error with the update request, or you do not have sufficient permissions
    /// to update this VPC endpoint configuration.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified entity was not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>There was a problem with the service account.</p>
    ServiceAccountException(crate::error::ServiceAccountException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVPCEConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVPCEConfigurationErrorKind::ArgumentException(_inner) => _inner.fmt(f),
            UpdateVPCEConfigurationErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            UpdateVPCEConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVPCEConfigurationErrorKind::ServiceAccountException(_inner) => _inner.fmt(f),
            UpdateVPCEConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVPCEConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateVPCEConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVPCEConfigurationError {
    /// Creates a new `UpdateVPCEConfigurationError`.
    pub fn new(kind: UpdateVPCEConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVPCEConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVPCEConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVPCEConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVPCEConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateVPCEConfigurationErrorKind::ArgumentException`.
    pub fn is_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVPCEConfigurationErrorKind::ArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVPCEConfigurationErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVPCEConfigurationErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVPCEConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVPCEConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVPCEConfigurationErrorKind::ServiceAccountException`.
    pub fn is_service_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVPCEConfigurationErrorKind::ServiceAccountException(_)
        )
    }
}
impl std::error::Error for UpdateVPCEConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVPCEConfigurationErrorKind::ArgumentException(_inner) => Some(_inner),
            UpdateVPCEConfigurationErrorKind::InvalidOperationException(_inner) => Some(_inner),
            UpdateVPCEConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVPCEConfigurationErrorKind::ServiceAccountException(_inner) => Some(_inner),
            UpdateVPCEConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>There was a problem with the service account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceAccountException {
    /// <p>Any additional information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceAccountException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceAccountException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceAccountException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceAccountException {}
/// See [`ServiceAccountException`](crate::error::ServiceAccountException)
pub mod service_account_exception {
    /// A builder for [`ServiceAccountException`](crate::error::ServiceAccountException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Any additional information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Any additional information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceAccountException`](crate::error::ServiceAccountException)
        pub fn build(self) -> crate::error::ServiceAccountException {
            crate::error::ServiceAccountException {
                message: self.message,
            }
        }
    }
}
impl ServiceAccountException {
    /// Creates a new builder-style object to manufacture [`ServiceAccountException`](crate::error::ServiceAccountException)
    pub fn builder() -> crate::error::service_account_exception::Builder {
        crate::error::service_account_exception::Builder::default()
    }
}

/// <p>The specified entity was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>Any additional information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Any additional information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Any additional information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>There was an error with the update request, or you do not have sufficient permissions
/// to update this VPC endpoint configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOperationException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOperationException {}
/// See [`InvalidOperationException`](crate::error::InvalidOperationException)
pub mod invalid_operation_exception {
    /// A builder for [`InvalidOperationException`](crate::error::InvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOperationException`](crate::error::InvalidOperationException)
        pub fn build(self) -> crate::error::InvalidOperationException {
            crate::error::InvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl InvalidOperationException {
    /// Creates a new builder-style object to manufacture [`InvalidOperationException`](crate::error::InvalidOperationException)
    pub fn builder() -> crate::error::invalid_operation_exception::Builder {
        crate::error::invalid_operation_exception::Builder::default()
    }
}

/// <p>An invalid argument was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArgumentException {
    /// <p>Any additional information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ArgumentException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ArgumentException {}
/// See [`ArgumentException`](crate::error::ArgumentException)
pub mod argument_exception {
    /// A builder for [`ArgumentException`](crate::error::ArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Any additional information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Any additional information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ArgumentException`](crate::error::ArgumentException)
        pub fn build(self) -> crate::error::ArgumentException {
            crate::error::ArgumentException {
                message: self.message,
            }
        }
    }
}
impl ArgumentException {
    /// Creates a new builder-style object to manufacture [`ArgumentException`](crate::error::ArgumentException)
    pub fn builder() -> crate::error::argument_exception::Builder {
        crate::error::argument_exception::Builder::default()
    }
}

/// <p>A limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>Any additional information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Any additional information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Any additional information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>An internal exception was raised in the service. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
/// error. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>The operation was not successful. Try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagOperationException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TagOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagOperationException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagOperationException {}
/// See [`TagOperationException`](crate::error::TagOperationException)
pub mod tag_operation_exception {
    /// A builder for [`TagOperationException`](crate::error::TagOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TagOperationException`](crate::error::TagOperationException)
        pub fn build(self) -> crate::error::TagOperationException {
            crate::error::TagOperationException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TagOperationException {
    /// Creates a new builder-style object to manufacture [`TagOperationException`](crate::error::TagOperationException)
    pub fn builder() -> crate::error::tag_operation_exception::Builder {
        crate::error::tag_operation_exception::Builder::default()
    }
}

/// <p>The list of tags on the repository is over the limit. The maximum number of tags that
/// can be applied to a repository is 50. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The request doesn't comply with the AWS Identity and Access Management (IAM) tag
/// policy. Correct your request and then retry it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagPolicyException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TagPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagPolicyException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagPolicyException {}
/// See [`TagPolicyException`](crate::error::TagPolicyException)
pub mod tag_policy_exception {
    /// A builder for [`TagPolicyException`](crate::error::TagPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TagPolicyException`](crate::error::TagPolicyException)
        pub fn build(self) -> crate::error::TagPolicyException {
            crate::error::TagPolicyException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TagPolicyException {
    /// Creates a new builder-style object to manufacture [`TagPolicyException`](crate::error::TagPolicyException)
    pub fn builder() -> crate::error::tag_policy_exception::Builder {
        crate::error::tag_policy_exception::Builder::default()
    }
}

/// <p>An entity with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotencyException {
    /// <p>Any additional information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdempotencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotencyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdempotencyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotencyException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotencyException {}
/// See [`IdempotencyException`](crate::error::IdempotencyException)
pub mod idempotency_exception {
    /// A builder for [`IdempotencyException`](crate::error::IdempotencyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Any additional information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Any additional information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotencyException`](crate::error::IdempotencyException)
        pub fn build(self) -> crate::error::IdempotencyException {
            crate::error::IdempotencyException {
                message: self.message,
            }
        }
    }
}
impl IdempotencyException {
    /// Creates a new builder-style object to manufacture [`IdempotencyException`](crate::error::IdempotencyException)
    pub fn builder() -> crate::error::idempotency_exception::Builder {
        crate::error::idempotency_exception::Builder::default()
    }
}

/// <p>Exception gets thrown when a user is not eligible to perform the specified
/// transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotEligibleException {
    /// <p>The HTTP response code of a Not Eligible exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotEligibleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotEligibleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotEligibleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotEligibleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotEligibleException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotEligibleException {}
/// See [`NotEligibleException`](crate::error::NotEligibleException)
pub mod not_eligible_exception {
    /// A builder for [`NotEligibleException`](crate::error::NotEligibleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP response code of a Not Eligible exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The HTTP response code of a Not Eligible exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotEligibleException`](crate::error::NotEligibleException)
        pub fn build(self) -> crate::error::NotEligibleException {
            crate::error::NotEligibleException {
                message: self.message,
            }
        }
    }
}
impl NotEligibleException {
    /// Creates a new builder-style object to manufacture [`NotEligibleException`](crate::error::NotEligibleException)
    pub fn builder() -> crate::error::not_eligible_exception::Builder {
        crate::error::not_eligible_exception::Builder::default()
    }
}

/// <p>The requested object could not be deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CannotDeleteException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CannotDeleteException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CannotDeleteException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CannotDeleteException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CannotDeleteException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CannotDeleteException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for CannotDeleteException {}
/// See [`CannotDeleteException`](crate::error::CannotDeleteException)
pub mod cannot_delete_exception {
    /// A builder for [`CannotDeleteException`](crate::error::CannotDeleteException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CannotDeleteException`](crate::error::CannotDeleteException)
        pub fn build(self) -> crate::error::CannotDeleteException {
            crate::error::CannotDeleteException {
                message: self.message,
            }
        }
    }
}
impl CannotDeleteException {
    /// Creates a new builder-style object to manufacture [`CannotDeleteException`](crate::error::CannotDeleteException)
    pub fn builder() -> crate::error::cannot_delete_exception::Builder {
        crate::error::cannot_delete_exception::Builder::default()
    }
}
