// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_invitation`](crate::client::Client::accept_invitation).
///
/// See [`crate::client::fluent_builders::AcceptInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInvitation {
    _private: (),
}
impl AcceptInvitation {
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
    /// Creates a new `AcceptInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInvitation {
    type Output = std::result::Result<
        crate::output::AcceptInvitationOutput,
        crate::error::AcceptInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_invitation_error(response)
        } else {
            crate::operation_deser::parse_accept_invitation_response(response)
        }
    }
}

/// Operation shape for `CreateGraph`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_graph`](crate::client::Client::create_graph).
///
/// See [`crate::client::fluent_builders::CreateGraph`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGraph {
    _private: (),
}
impl CreateGraph {
    /// Creates a new builder-style object to manufacture [`CreateGraphInput`](crate::input::CreateGraphInput)
    pub fn builder() -> crate::input::create_graph_input::Builder {
        crate::input::create_graph_input::Builder::default()
    }
    /// Creates a new `CreateGraph` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGraph {
    type Output =
        std::result::Result<crate::output::CreateGraphOutput, crate::error::CreateGraphError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_graph_error(response)
        } else {
            crate::operation_deser::parse_create_graph_response(response)
        }
    }
}

/// Operation shape for `CreateMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_members`](crate::client::Client::create_members).
///
/// See [`crate::client::fluent_builders::CreateMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMembers {
    _private: (),
}
impl CreateMembers {
    /// Creates a new builder-style object to manufacture [`CreateMembersInput`](crate::input::CreateMembersInput)
    pub fn builder() -> crate::input::create_members_input::Builder {
        crate::input::create_members_input::Builder::default()
    }
    /// Creates a new `CreateMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMembers {
    type Output =
        std::result::Result<crate::output::CreateMembersOutput, crate::error::CreateMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_members_error(response)
        } else {
            crate::operation_deser::parse_create_members_response(response)
        }
    }
}

/// Operation shape for `DeleteGraph`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_graph`](crate::client::Client::delete_graph).
///
/// See [`crate::client::fluent_builders::DeleteGraph`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGraph {
    _private: (),
}
impl DeleteGraph {
    /// Creates a new builder-style object to manufacture [`DeleteGraphInput`](crate::input::DeleteGraphInput)
    pub fn builder() -> crate::input::delete_graph_input::Builder {
        crate::input::delete_graph_input::Builder::default()
    }
    /// Creates a new `DeleteGraph` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGraph {
    type Output =
        std::result::Result<crate::output::DeleteGraphOutput, crate::error::DeleteGraphError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_graph_error(response)
        } else {
            crate::operation_deser::parse_delete_graph_response(response)
        }
    }
}

/// Operation shape for `DeleteMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_members`](crate::client::Client::delete_members).
///
/// See [`crate::client::fluent_builders::DeleteMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMembers {
    _private: (),
}
impl DeleteMembers {
    /// Creates a new builder-style object to manufacture [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    pub fn builder() -> crate::input::delete_members_input::Builder {
        crate::input::delete_members_input::Builder::default()
    }
    /// Creates a new `DeleteMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMembers {
    type Output =
        std::result::Result<crate::output::DeleteMembersOutput, crate::error::DeleteMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_members_error(response)
        } else {
            crate::operation_deser::parse_delete_members_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_configuration`](crate::client::Client::describe_organization_configuration).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfiguration {
    _private: (),
}
impl DescribeOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigurationOutput,
        crate::error::DescribeOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `DisableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_organization_admin_account`](crate::client::Client::disable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::DisableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableOrganizationAdminAccount {
    _private: (),
}
impl DisableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `DisableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::DisableOrganizationAdminAccountOutput,
        crate::error::DisableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_membership`](crate::client::Client::disassociate_membership).
///
/// See [`crate::client::fluent_builders::DisassociateMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMembership {
    _private: (),
}
impl DisassociateMembership {
    /// Creates a new builder-style object to manufacture [`DisassociateMembershipInput`](crate::input::DisassociateMembershipInput)
    pub fn builder() -> crate::input::disassociate_membership_input::Builder {
        crate::input::disassociate_membership_input::Builder::default()
    }
    /// Creates a new `DisassociateMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMembership {
    type Output = std::result::Result<
        crate::output::DisassociateMembershipOutput,
        crate::error::DisassociateMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_membership_error(response)
        } else {
            crate::operation_deser::parse_disassociate_membership_response(response)
        }
    }
}

/// Operation shape for `EnableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_organization_admin_account`](crate::client::Client::enable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::EnableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableOrganizationAdminAccount {
    _private: (),
}
impl EnableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `EnableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::EnableOrganizationAdminAccountOutput,
        crate::error::EnableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_enable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_members`](crate::client::Client::get_members).
///
/// See [`crate::client::fluent_builders::GetMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMembers {
    _private: (),
}
impl GetMembers {
    /// Creates a new builder-style object to manufacture [`GetMembersInput`](crate::input::GetMembersInput)
    pub fn builder() -> crate::input::get_members_input::Builder {
        crate::input::get_members_input::Builder::default()
    }
    /// Creates a new `GetMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMembers {
    type Output =
        std::result::Result<crate::output::GetMembersOutput, crate::error::GetMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_members_error(response)
        } else {
            crate::operation_deser::parse_get_members_response(response)
        }
    }
}

/// Operation shape for `ListGraphs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_graphs`](crate::client::Client::list_graphs).
///
/// See [`crate::client::fluent_builders::ListGraphs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGraphs {
    _private: (),
}
impl ListGraphs {
    /// Creates a new builder-style object to manufacture [`ListGraphsInput`](crate::input::ListGraphsInput)
    pub fn builder() -> crate::input::list_graphs_input::Builder {
        crate::input::list_graphs_input::Builder::default()
    }
    /// Creates a new `ListGraphs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGraphs {
    type Output =
        std::result::Result<crate::output::ListGraphsOutput, crate::error::ListGraphsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_graphs_error(response)
        } else {
            crate::operation_deser::parse_list_graphs_response(response)
        }
    }
}

/// Operation shape for `ListInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_invitations`](crate::client::Client::list_invitations).
///
/// See [`crate::client::fluent_builders::ListInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInvitations {
    _private: (),
}
impl ListInvitations {
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
    /// Creates a new `ListInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInvitations {
    type Output = std::result::Result<
        crate::output::ListInvitationsOutput,
        crate::error::ListInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_invitations_error(response)
        } else {
            crate::operation_deser::parse_list_invitations_response(response)
        }
    }
}

/// Operation shape for `ListMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_members`](crate::client::Client::list_members).
///
/// See [`crate::client::fluent_builders::ListMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMembers {
    _private: (),
}
impl ListMembers {
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
    /// Creates a new `ListMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMembers {
    type Output =
        std::result::Result<crate::output::ListMembersOutput, crate::error::ListMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_members_error(response)
        } else {
            crate::operation_deser::parse_list_members_response(response)
        }
    }
}

/// Operation shape for `ListOrganizationAdminAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organization_admin_accounts`](crate::client::Client::list_organization_admin_accounts).
///
/// See [`crate::client::fluent_builders::ListOrganizationAdminAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizationAdminAccounts {
    _private: (),
}
impl ListOrganizationAdminAccounts {
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
    /// Creates a new `ListOrganizationAdminAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizationAdminAccounts {
    type Output = std::result::Result<
        crate::output::ListOrganizationAdminAccountsOutput,
        crate::error::ListOrganizationAdminAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organization_admin_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_organization_admin_accounts_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RejectInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_invitation`](crate::client::Client::reject_invitation).
///
/// See [`crate::client::fluent_builders::RejectInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectInvitation {
    _private: (),
}
impl RejectInvitation {
    /// Creates a new builder-style object to manufacture [`RejectInvitationInput`](crate::input::RejectInvitationInput)
    pub fn builder() -> crate::input::reject_invitation_input::Builder {
        crate::input::reject_invitation_input::Builder::default()
    }
    /// Creates a new `RejectInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectInvitation {
    type Output = std::result::Result<
        crate::output::RejectInvitationOutput,
        crate::error::RejectInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_invitation_error(response)
        } else {
            crate::operation_deser::parse_reject_invitation_response(response)
        }
    }
}

/// Operation shape for `StartMonitoringMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_monitoring_member`](crate::client::Client::start_monitoring_member).
///
/// See [`crate::client::fluent_builders::StartMonitoringMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMonitoringMember {
    _private: (),
}
impl StartMonitoringMember {
    /// Creates a new builder-style object to manufacture [`StartMonitoringMemberInput`](crate::input::StartMonitoringMemberInput)
    pub fn builder() -> crate::input::start_monitoring_member_input::Builder {
        crate::input::start_monitoring_member_input::Builder::default()
    }
    /// Creates a new `StartMonitoringMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMonitoringMember {
    type Output = std::result::Result<
        crate::output::StartMonitoringMemberOutput,
        crate::error::StartMonitoringMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_monitoring_member_error(response)
        } else {
            crate::operation_deser::parse_start_monitoring_member_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_organization_configuration`](crate::client::Client::update_organization_configuration).
///
/// See [`crate::client::fluent_builders::UpdateOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOrganizationConfiguration {
    _private: (),
}
impl UpdateOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateOrganizationConfigurationOutput,
        crate::error::UpdateOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_organization_configuration_response(response)
        }
    }
}
