// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Detective
///
/// Client for invoking operations on Amazon Detective. Each operation on Amazon Detective is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_detective::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_detective::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_detective::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptInvitation`](crate::client::fluent_builders::AcceptInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::AcceptInvitation::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::AcceptInvitation::set_graph_arn): <p>The ARN of the behavior graph that the member account is accepting the invitation for.</p>  <p>The member account status in the behavior graph must be <code>INVITED</code>.</p>
    /// - On success, responds with [`AcceptInvitationOutput`](crate::output::AcceptInvitationOutput)

    /// - On failure, responds with [`SdkError<AcceptInvitationError>`](crate::error::AcceptInvitationError)
    pub fn accept_invitation(&self) -> fluent_builders::AcceptInvitation {
        fluent_builders::AcceptInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGraph`](crate::client::fluent_builders::CreateGraph) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateGraph::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateGraph::set_tags): <p>The tags to assign to the new behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>
    /// - On success, responds with [`CreateGraphOutput`](crate::output::CreateGraphOutput) with field(s):
    ///   - [`graph_arn(Option<String>)`](crate::output::CreateGraphOutput::graph_arn): <p>The ARN of the new behavior graph.</p>
    /// - On failure, responds with [`SdkError<CreateGraphError>`](crate::error::CreateGraphError)
    pub fn create_graph(&self) -> fluent_builders::CreateGraph {
        fluent_builders::CreateGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMembers`](crate::client::fluent_builders::CreateMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::CreateMembers::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::CreateMembers::set_graph_arn): <p>The ARN of the behavior graph.</p>
    ///   - [`message(impl Into<String>)`](crate::client::fluent_builders::CreateMembers::message) / [`set_message(Option<String>)`](crate::client::fluent_builders::CreateMembers::set_message): <p>Customized message text to include in the invitation email message to the invited member accounts.</p>
    ///   - [`disable_email_notification(bool)`](crate::client::fluent_builders::CreateMembers::disable_email_notification) / [`set_disable_email_notification(bool)`](crate::client::fluent_builders::CreateMembers::set_disable_email_notification): <p>if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is set to <code>false</code>, and the invited accounts receive email notifications.</p>  <p>Organization accounts in the organization behavior graph do not receive email notifications.</p>
    ///   - [`accounts(Vec<Account>)`](crate::client::fluent_builders::CreateMembers::accounts) / [`set_accounts(Option<Vec<Account>>)`](crate::client::fluent_builders::CreateMembers::set_accounts): <p>The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a time. For each invited account, the account list contains the account identifier and the Amazon Web Services account root user email address. For organization accounts in the organization behavior graph, the email address is not required.</p>
    /// - On success, responds with [`CreateMembersOutput`](crate::output::CreateMembersOutput) with field(s):
    ///   - [`members(Option<Vec<MemberDetail>>)`](crate::output::CreateMembersOutput::members): <p>The set of member account invitation or enablement requests that Detective was able to process. This includes accounts that are being verified, that failed verification, and that passed verification and are being sent an invitation or are being enabled.</p>
    ///   - [`unprocessed_accounts(Option<Vec<UnprocessedAccount>>)`](crate::output::CreateMembersOutput::unprocessed_accounts): <p>The list of accounts for which Detective was unable to process the invitation or enablement request. For each account, the list provides the reason why the request could not be processed. The list includes accounts that are already member accounts in the behavior graph.</p>
    /// - On failure, responds with [`SdkError<CreateMembersError>`](crate::error::CreateMembersError)
    pub fn create_members(&self) -> fluent_builders::CreateMembers {
        fluent_builders::CreateMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGraph`](crate::client::fluent_builders::DeleteGraph) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteGraph::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::DeleteGraph::set_graph_arn): <p>The ARN of the behavior graph to disable.</p>
    /// - On success, responds with [`DeleteGraphOutput`](crate::output::DeleteGraphOutput)

    /// - On failure, responds with [`SdkError<DeleteGraphError>`](crate::error::DeleteGraphError)
    pub fn delete_graph(&self) -> fluent_builders::DeleteGraph {
        fluent_builders::DeleteGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMembers`](crate::client::fluent_builders::DeleteMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteMembers::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::DeleteMembers::set_graph_arn): <p>The ARN of the behavior graph to remove members from.</p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DeleteMembers::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteMembers::set_account_ids): <p>The list of Amazon Web Services account identifiers for the member accounts to remove from the behavior graph. You can remove up to 50 member accounts at a time.</p>
    /// - On success, responds with [`DeleteMembersOutput`](crate::output::DeleteMembersOutput) with field(s):
    ///   - [`account_ids(Option<Vec<String>>)`](crate::output::DeleteMembersOutput::account_ids): <p>The list of Amazon Web Services account identifiers for the member accounts that Detective successfully removed from the behavior graph.</p>
    ///   - [`unprocessed_accounts(Option<Vec<UnprocessedAccount>>)`](crate::output::DeleteMembersOutput::unprocessed_accounts): <p>The list of member accounts that Detective was not able to remove from the behavior graph. For each member account, provides the reason that the deletion could not be processed.</p>
    /// - On failure, responds with [`SdkError<DeleteMembersError>`](crate::error::DeleteMembersError)
    pub fn delete_members(&self) -> fluent_builders::DeleteMembers {
        fluent_builders::DeleteMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeOrganizationConfiguration::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::DescribeOrganizationConfiguration::set_graph_arn): <p>The ARN of the organization behavior graph.</p>
    /// - On success, responds with [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput) with field(s):
    ///   - [`auto_enable(bool)`](crate::output::DescribeOrganizationConfigurationOutput::auto_enable): <p>Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationConfigurationError>`](crate::error::DescribeOrganizationConfigurationError)
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableOrganizationAdminAccount`](crate::client::fluent_builders::DisableOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisableOrganizationAdminAccount::send) it.

    /// - On success, responds with [`DisableOrganizationAdminAccountOutput`](crate::output::DisableOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<DisableOrganizationAdminAccountError>`](crate::error::DisableOrganizationAdminAccountError)
    pub fn disable_organization_admin_account(
        &self,
    ) -> fluent_builders::DisableOrganizationAdminAccount {
        fluent_builders::DisableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMembership`](crate::client::fluent_builders::DisassociateMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateMembership::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::DisassociateMembership::set_graph_arn): <p>The ARN of the behavior graph to remove the member account from.</p>  <p>The member account's member status in the behavior graph must be <code>ENABLED</code>.</p>
    /// - On success, responds with [`DisassociateMembershipOutput`](crate::output::DisassociateMembershipOutput)

    /// - On failure, responds with [`SdkError<DisassociateMembershipError>`](crate::error::DisassociateMembershipError)
    pub fn disassociate_membership(&self) -> fluent_builders::DisassociateMembership {
        fluent_builders::DisassociateMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableOrganizationAdminAccount`](crate::client::fluent_builders::EnableOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::set_account_id): <p>The Amazon Web Services account identifier of the account to designate as the Detective administrator account for the organization.</p>
    /// - On success, responds with [`EnableOrganizationAdminAccountOutput`](crate::output::EnableOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<EnableOrganizationAdminAccountError>`](crate::error::EnableOrganizationAdminAccountError)
    pub fn enable_organization_admin_account(
        &self,
    ) -> fluent_builders::EnableOrganizationAdminAccount {
        fluent_builders::EnableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMembers`](crate::client::fluent_builders::GetMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::GetMembers::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::GetMembers::set_graph_arn): <p>The ARN of the behavior graph for which to request the member details.</p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::GetMembers::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetMembers::set_account_ids): <p>The list of Amazon Web Services account identifiers for the member account for which to return member details. You can request details for up to 50 member accounts at a time.</p>  <p>You cannot use <code>GetMembers</code> to retrieve information about member accounts that were removed from the behavior graph.</p>
    /// - On success, responds with [`GetMembersOutput`](crate::output::GetMembersOutput) with field(s):
    ///   - [`member_details(Option<Vec<MemberDetail>>)`](crate::output::GetMembersOutput::member_details): <p>The member account details that Detective is returning in response to the request.</p>
    ///   - [`unprocessed_accounts(Option<Vec<UnprocessedAccount>>)`](crate::output::GetMembersOutput::unprocessed_accounts): <p>The requested member accounts for which Detective was unable to return member details.</p>  <p>For each account, provides the reason why the request could not be processed.</p>
    /// - On failure, responds with [`SdkError<GetMembersError>`](crate::error::GetMembersError)
    pub fn get_members(&self) -> fluent_builders::GetMembers {
        fluent_builders::GetMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGraphs`](crate::client::fluent_builders::ListGraphs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGraphs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGraphs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGraphs::set_next_token): <p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGraphs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGraphs::set_max_results): <p>The maximum number of graphs to return at a time. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
    /// - On success, responds with [`ListGraphsOutput`](crate::output::ListGraphsOutput) with field(s):
    ///   - [`graph_list(Option<Vec<Graph>>)`](crate::output::ListGraphsOutput::graph_list): <p>A list of behavior graphs that the account is an administrator account for.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGraphsOutput::next_token): <p>If there are more behavior graphs remaining in the results, then this is the pagination token to use to request the next page of behavior graphs.</p>
    /// - On failure, responds with [`SdkError<ListGraphsError>`](crate::error::ListGraphsError)
    pub fn list_graphs(&self) -> fluent_builders::ListGraphs {
        fluent_builders::ListGraphs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInvitations`](crate::client::fluent_builders::ListInvitations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInvitations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInvitations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInvitations::set_next_token): <p>For requests to retrieve the next page of results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInvitations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInvitations::set_max_results): <p>The maximum number of behavior graph invitations to return in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
    /// - On success, responds with [`ListInvitationsOutput`](crate::output::ListInvitationsOutput) with field(s):
    ///   - [`invitations(Option<Vec<MemberDetail>>)`](crate::output::ListInvitationsOutput::invitations): <p>The list of behavior graphs for which the member account has open or accepted invitations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInvitationsOutput::next_token): <p>If there are more behavior graphs remaining in the results, then this is the pagination token to use to request the next page of behavior graphs.</p>
    /// - On failure, responds with [`SdkError<ListInvitationsError>`](crate::error::ListInvitationsError)
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMembers`](crate::client::fluent_builders::ListMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::ListMembers::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::ListMembers::set_graph_arn): <p>The ARN of the behavior graph for which to retrieve the list of member accounts.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMembers::set_next_token): <p>For requests to retrieve the next page of member account results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMembers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMembers::set_max_results): <p>The maximum number of member accounts to include in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
    /// - On success, responds with [`ListMembersOutput`](crate::output::ListMembersOutput) with field(s):
    ///   - [`member_details(Option<Vec<MemberDetail>>)`](crate::output::ListMembersOutput::member_details): <p>The list of member accounts in the behavior graph.</p>  <p>For invited accounts, the results include member accounts that did not pass verification and member accounts that have not yet accepted the invitation to the behavior graph. The results do not include member accounts that were removed from the behavior graph.</p>  <p>For the organization behavior graph, the results do not include organization accounts that the Detective administrator account has not enabled as member accounts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMembersOutput::next_token): <p>If there are more member accounts remaining in the results, then use this pagination token to request the next page of member accounts.</p>
    /// - On failure, responds with [`SdkError<ListMembersError>`](crate::error::ListMembersError)
    pub fn list_members(&self) -> fluent_builders::ListMembers {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizationAdminAccounts`](crate::client::fluent_builders::ListOrganizationAdminAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizationAdminAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::set_next_token): <p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListOrganizationAdminAccountsOutput`](crate::output::ListOrganizationAdminAccountsOutput) with field(s):
    ///   - [`administrators(Option<Vec<Administrator>>)`](crate::output::ListOrganizationAdminAccountsOutput::administrators): <p>The list of delegated administrator accounts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrganizationAdminAccountsOutput::next_token): <p>If there are more accounts remaining in the results, then this is the pagination token to use to request the next page of accounts.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationAdminAccountsError>`](crate::error::ListOrganizationAdminAccountsError)
    pub fn list_organization_admin_accounts(
        &self,
    ) -> fluent_builders::ListOrganizationAdminAccounts {
        fluent_builders::ListOrganizationAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the behavior graph for which to retrieve the tag values.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tag values that are assigned to the behavior graph. The request returns up to 50 tag values.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectInvitation`](crate::client::fluent_builders::RejectInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::RejectInvitation::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::RejectInvitation::set_graph_arn): <p>The ARN of the behavior graph to reject the invitation to.</p>  <p>The member account's current member status in the behavior graph must be <code>INVITED</code>.</p>
    /// - On success, responds with [`RejectInvitationOutput`](crate::output::RejectInvitationOutput)

    /// - On failure, responds with [`SdkError<RejectInvitationError>`](crate::error::RejectInvitationError)
    pub fn reject_invitation(&self) -> fluent_builders::RejectInvitation {
        fluent_builders::RejectInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMonitoringMember`](crate::client::fluent_builders::StartMonitoringMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::StartMonitoringMember::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::StartMonitoringMember::set_graph_arn): <p>The ARN of the behavior graph.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::StartMonitoringMember::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::StartMonitoringMember::set_account_id): <p>The account ID of the member account to try to enable.</p>  <p>The account must be an invited member account with a status of <code>ACCEPTED_BUT_DISABLED</code>. </p>
    /// - On success, responds with [`StartMonitoringMemberOutput`](crate::output::StartMonitoringMemberOutput)

    /// - On failure, responds with [`SdkError<StartMonitoringMemberError>`](crate::error::StartMonitoringMemberError)
    pub fn start_monitoring_member(&self) -> fluent_builders::StartMonitoringMember {
        fluent_builders::StartMonitoringMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the behavior graph to assign the tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to assign to the behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the behavior graph to remove the tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys of the tags to remove from the behavior graph. You can remove up to 50 tags at a time.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`graph_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::graph_arn) / [`set_graph_arn(Option<String>)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::set_graph_arn): <p>The ARN of the organization behavior graph.</p>
    ///   - [`auto_enable(bool)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::auto_enable) / [`set_auto_enable(bool)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::set_auto_enable): <p>Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p>
    /// - On success, responds with [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateOrganizationConfigurationError>`](crate::error::UpdateOrganizationConfigurationError)
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInvitation`.
    ///
    /// <p>Accepts an invitation for the member account to contribute data to a behavior graph. This operation can only be called by an invited member account. </p>
    /// <p>The request provides the ARN of behavior graph.</p>
    /// <p>The member account status in the graph must be <code>INVITED</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptInvitation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_invitation_input::Builder,
    }
    impl AcceptInvitation {
        /// Creates a new `AcceptInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInvitationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph that the member account is accepting the invitation for.</p>
        /// <p>The member account status in the behavior graph must be <code>INVITED</code>.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph that the member account is accepting the invitation for.</p>
        /// <p>The member account status in the behavior graph must be <code>INVITED</code>.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGraph`.
    ///
    /// <p>Creates a new behavior graph for the calling account, and sets that account as the administrator account. This operation is called by the account that is enabling Detective.</p>
    /// <p>Before you try to enable Detective, make sure that your account has been enrolled in Amazon GuardDuty for at least 48 hours. If you do not meet this requirement, you cannot enable Detective. If you do meet the GuardDuty prerequisite, then when you make the request to enable Detective, it checks whether your data volume is within the Detective quota. If it exceeds the quota, then you cannot enable Detective. </p>
    /// <p>The operation also enables Detective for the calling account in the currently selected Region. It returns the ARN of the new behavior graph.</p>
    /// <p> <code>CreateGraph</code> triggers a process to create the corresponding data tables for the new behavior graph.</p>
    /// <p>An account can only be the administrator account for one behavior graph within a Region. If the same account calls <code>CreateGraph</code> with the same administrator account, it always returns the same behavior graph ARN. It does not create a new behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGraph {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_graph_input::Builder,
    }
    impl CreateGraph {
        /// Creates a new `CreateGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGraphError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the new behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the new behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMembers`.
    ///
    /// <p> <code>CreateMembers</code> is used to send invitations to accounts. For the organization behavior graph, the Detective administrator account uses <code>CreateMembers</code> to enable organization accounts as member accounts.</p>
    /// <p>For invited accounts, <code>CreateMembers</code> sends a request to invite the specified Amazon Web Services accounts to be member accounts in the behavior graph. This operation can only be called by the administrator account for a behavior graph. </p>
    /// <p> <code>CreateMembers</code> verifies the accounts and then invites the verified accounts. The administrator can optionally specify to not send invitation emails to the member accounts. This would be used when the administrator manages their member accounts centrally.</p>
    /// <p>For organization accounts in the organization behavior graph, <code>CreateMembers</code> attempts to enable the accounts. The organization accounts do not receive invitations.</p>
    /// <p>The request provides the behavior graph ARN and the list of accounts to invite or to enable.</p>
    /// <p>The response separates the requested accounts into two lists:</p>
    /// <ul>
    /// <li> <p>The accounts that <code>CreateMembers</code> was able to process. For invited accounts, includes member accounts that are being verified, that have passed verification and are to be invited, and that have failed verification. For organization accounts in the organization behavior graph, includes accounts that can be enabled and that cannot be enabled.</p> </li>
    /// <li> <p>The accounts that <code>CreateMembers</code> was unable to process. This list includes accounts that were already invited to be member accounts in the behavior graph.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_members_input::Builder,
    }
    impl CreateMembers {
        /// Creates a new `CreateMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
        /// <p>Customized message text to include in the invitation email message to the invited member accounts.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message(input.into());
            self
        }
        /// <p>Customized message text to include in the invitation email message to the invited member accounts.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
        /// <p>if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is set to <code>false</code>, and the invited accounts receive email notifications.</p>
        /// <p>Organization accounts in the organization behavior graph do not receive email notifications.</p>
        pub fn disable_email_notification(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_email_notification(input);
            self
        }
        /// <p>if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is set to <code>false</code>, and the invited accounts receive email notifications.</p>
        /// <p>Organization accounts in the organization behavior graph do not receive email notifications.</p>
        pub fn set_disable_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_email_notification(input);
            self
        }
        /// Appends an item to `Accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a time. For each invited account, the account list contains the account identifier and the Amazon Web Services account root user email address. For organization accounts in the organization behavior graph, the email address is not required.</p>
        pub fn accounts(mut self, input: crate::model::Account) -> Self {
            self.inner = self.inner.accounts(input);
            self
        }
        /// <p>The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a time. For each invited account, the account list contains the account identifier and the Amazon Web Services account root user email address. For organization accounts in the organization behavior graph, the email address is not required.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Account>>,
        ) -> Self {
            self.inner = self.inner.set_accounts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGraph`.
    ///
    /// <p>Disables the specified behavior graph and queues it to be deleted. This operation removes the behavior graph from each member account's list of behavior graphs.</p>
    /// <p> <code>DeleteGraph</code> can only be called by the administrator account for a behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGraph {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_graph_input::Builder,
    }
    impl DeleteGraph {
        /// Creates a new `DeleteGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGraphError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph to disable.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph to disable.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMembers`.
    ///
    /// <p>Removes the specified member accounts from the behavior graph. The removed accounts no longer contribute data to the behavior graph. This operation can only be called by the administrator account for the behavior graph.</p>
    /// <p>For invited accounts, the removed accounts are deleted from the list of accounts in the behavior graph. To restore the account, the administrator account must send another invitation.</p>
    /// <p>For organization accounts in the organization behavior graph, the Detective administrator account can always enable the organization account again. Organization accounts that are not enabled as member accounts are not included in the <code>ListMembers</code> results for the organization behavior graph.</p>
    /// <p>An administrator account cannot use <code>DeleteMembers</code> to remove their own account from the behavior graph. To disable a behavior graph, the administrator account uses the <code>DeleteGraph</code> API method.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_members_input::Builder,
    }
    impl DeleteMembers {
        /// Creates a new `DeleteMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph to remove members from.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph to remove members from.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account identifiers for the member accounts to remove from the behavior graph. You can remove up to 50 member accounts at a time.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of Amazon Web Services account identifiers for the member accounts to remove from the behavior graph. You can remove up to 50 member accounts at a time.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Returns information about the configuration for the organization behavior graph. Currently indicates whether to automatically enable new organization accounts as member accounts.</p>
    /// <p>Can only be called by the Detective administrator account for the organization. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl DescribeOrganizationConfiguration {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the organization behavior graph.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the organization behavior graph.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableOrganizationAdminAccount`.
    ///
    /// <p>Removes the Detective administrator account for the organization in the current Region. Deletes the behavior graph for that account.</p>
    /// <p>Can only be called by the organization management account. Before you can select a different Detective administrator account, you must remove the Detective administrator account in all Regions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableOrganizationAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_organization_admin_account_input::Builder,
    }
    impl DisableOrganizationAdminAccount {
        /// Creates a new `DisableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableOrganizationAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateMembership`.
    ///
    /// <p>Removes the member account from the specified behavior graph. This operation can only be called by an invited member account that has the <code>ENABLED</code> status.</p>
    /// <p> <code>DisassociateMembership</code> cannot be called by an organization account in the organization behavior graph. For the organization behavior graph, the Detective administrator account determines which organization accounts to enable or disable as member accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMembership {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_membership_input::Builder,
    }
    impl DisassociateMembership {
        /// Creates a new `DisassociateMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMembershipError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph to remove the member account from.</p>
        /// <p>The member account's member status in the behavior graph must be <code>ENABLED</code>.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph to remove the member account from.</p>
        /// <p>The member account's member status in the behavior graph must be <code>ENABLED</code>.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableOrganizationAdminAccount`.
    ///
    /// <p>Designates the Detective administrator account for the organization in the current Region.</p>
    /// <p>If the account does not have Detective enabled, then enables Detective for that account and creates a new behavior graph.</p>
    /// <p>Can only be called by the organization management account.</p>
    /// <p>The Detective administrator account for an organization must be the same in all Regions. If you already designated a Detective administrator account in another Region, then you must designate the same account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableOrganizationAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_organization_admin_account_input::Builder,
    }
    impl EnableOrganizationAdminAccount {
        /// Creates a new `EnableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableOrganizationAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account identifier of the account to designate as the Detective administrator account for the organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the account to designate as the Detective administrator account for the organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMembers`.
    ///
    /// <p>Returns the membership details for specified member accounts for a behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_members_input::Builder,
    }
    impl GetMembers {
        /// Creates a new `GetMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph for which to request the member details.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph for which to request the member details.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account identifiers for the member account for which to return member details. You can request details for up to 50 member accounts at a time.</p>
        /// <p>You cannot use <code>GetMembers</code> to retrieve information about member accounts that were removed from the behavior graph.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of Amazon Web Services account identifiers for the member account for which to return member details. You can request details for up to 50 member accounts at a time.</p>
        /// <p>You cannot use <code>GetMembers</code> to retrieve information about member accounts that were removed from the behavior graph.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGraphs`.
    ///
    /// <p>Returns the list of behavior graphs that the calling account is an administrator account of. This operation can only be called by an administrator account.</p>
    /// <p>Because an account can currently only be the administrator of one behavior graph within a Region, the results always contain a single behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGraphs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_graphs_input::Builder,
    }
    impl ListGraphs {
        /// Creates a new `ListGraphs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGraphsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGraphsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGraphsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGraphsPaginator {
            crate::paginator::ListGraphsPaginator::new(self.handle, self.inner)
        }
        /// <p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of graphs to return at a time. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of graphs to return at a time. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Retrieves the list of open and accepted behavior graph invitations for the member account. This operation can only be called by an invited member account.</p>
    /// <p>Open invitations are invitations that the member account has not responded to.</p>
    /// <p>The results do not include behavior graphs for which the member account declined the invitation. The results also do not include behavior graphs that the member account resigned from or was removed from.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInvitations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl ListInvitations {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInvitationsPaginator {
            crate::paginator::ListInvitationsPaginator::new(self.handle, self.inner)
        }
        /// <p>For requests to retrieve the next page of results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For requests to retrieve the next page of results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of behavior graph invitations to return in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of behavior graph invitations to return in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Retrieves the list of member accounts for a behavior graph.</p>
    /// <p>For invited accounts, the results do not include member accounts that were removed from the behavior graph.</p>
    /// <p>For the organization behavior graph, the results do not include organization accounts that the Detective administrator account has not enabled as member accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_members_input::Builder,
    }
    impl ListMembers {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMembersPaginator {
            crate::paginator::ListMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the behavior graph for which to retrieve the list of member accounts.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph for which to retrieve the list of member accounts.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
        /// <p>For requests to retrieve the next page of member account results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For requests to retrieve the next page of member account results, the pagination token that was returned with the previous page of results. The initial request does not include a pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of member accounts to include in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of member accounts to include in the response. The total must be less than the overall limit on the number of results to return, which is currently 200.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationAdminAccounts`.
    ///
    /// <p>Returns information about the Detective administrator account for an organization. Can only be called by the organization management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizationAdminAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_organization_admin_accounts_input::Builder,
    }
    impl ListOrganizationAdminAccounts {
        /// Creates a new `ListOrganizationAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationAdminAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationAdminAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOrganizationAdminAccountsPaginator {
            crate::paginator::ListOrganizationAdminAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For requests to get the next page of results, the pagination token that was returned with the previous set of results. The initial request does not include a pagination token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns the tag values that are assigned to a behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph for which to retrieve the tag values.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph for which to retrieve the tag values.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInvitation`.
    ///
    /// <p>Rejects an invitation to contribute the account data to a behavior graph. This operation must be called by an invited member account that has the <code>INVITED</code> status.</p>
    /// <p> <code>RejectInvitation</code> cannot be called by an organization account in the organization behavior graph. In the organization behavior graph, organization accounts do not receive an invitation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectInvitation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_invitation_input::Builder,
    }
    impl RejectInvitation {
        /// Creates a new `RejectInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectInvitationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph to reject the invitation to.</p>
        /// <p>The member account's current member status in the behavior graph must be <code>INVITED</code>.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph to reject the invitation to.</p>
        /// <p>The member account's current member status in the behavior graph must be <code>INVITED</code>.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMonitoringMember`.
    ///
    /// <p>Sends a request to enable data ingest for a member account that has a status of <code>ACCEPTED_BUT_DISABLED</code>.</p>
    /// <p>For valid member accounts, the status is updated as follows.</p>
    /// <ul>
    /// <li> <p>If Detective enabled the member account, then the new status is <code>ENABLED</code>.</p> </li>
    /// <li> <p>If Detective cannot enable the member account, the status remains <code>ACCEPTED_BUT_DISABLED</code>. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMonitoringMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_monitoring_member_input::Builder,
    }
    impl StartMonitoringMember {
        /// Creates a new `StartMonitoringMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMonitoringMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMonitoringMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
        /// <p>The account ID of the member account to try to enable.</p>
        /// <p>The account must be an invited member account with a status of <code>ACCEPTED_BUT_DISABLED</code>. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the member account to try to enable.</p>
        /// <p>The account must be an invited member account with a status of <code>ACCEPTED_BUT_DISABLED</code>. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies tag values to a behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph to assign the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph to assign the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the behavior graph. You can add up to 50 tags. For each tag, you provide the tag key and the tag value. Each tag key can contain up to 128 characters. Each tag value can contain up to 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a behavior graph.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the behavior graph to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the behavior graph to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the tags to remove from the behavior graph. You can remove up to 50 tags at a time.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys of the tags to remove from the behavior graph. You can remove up to 50 tags at a time.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Updates the configuration for the Organizations integration in the current Region. Can only be called by the Detective administrator account for the organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl UpdateOrganizationConfiguration {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the organization behavior graph.</p>
        pub fn graph_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.graph_arn(input.into());
            self
        }
        /// <p>The ARN of the organization behavior graph.</p>
        pub fn set_graph_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_graph_arn(input);
            self
        }
        /// <p>Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_enable(input);
            self
        }
        /// <p>Indicates whether to automatically enable new organization accounts as member accounts in the organization behavior graph.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
