// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the output of one of the following actions:</p>
/// <ul>
/// <li> <p> <i>CreateSubnetGroup</i> </p> </li>
/// <li> <p> <i>ModifySubnetGroup</i> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroup {
    /// <p>The name of the subnet group.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description of the subnet group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of subnets associated with the subnet group. </p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
}
impl SubnetGroup {
    /// <p>The name of the subnet group.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>The description of the subnet group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of subnets associated with the subnet group. </p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for SubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroup");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("description", &self.description);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`SubnetGroup`](crate::model::SubnetGroup)
pub mod subnet_group {
    /// A builder for [`SubnetGroup`](crate::model::SubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    }
    impl Builder {
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The description of the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of subnets associated with the subnet group. </p>
        pub fn subnets(mut self, input: crate::model::Subnet) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input);
            self.subnets = Some(v);
            self
        }
        /// <p>A list of subnets associated with the subnet group. </p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroup`](crate::model::SubnetGroup)
        pub fn build(self) -> crate::model::SubnetGroup {
            crate::model::SubnetGroup {
                subnet_group_name: self.subnet_group_name,
                description: self.description,
                vpc_id: self.vpc_id,
                subnets: self.subnets,
            }
        }
    }
}
impl SubnetGroup {
    /// Creates a new builder-style object to manufacture [`SubnetGroup`](crate::model::SubnetGroup)
    pub fn builder() -> crate::model::subnet_group::Builder {
        crate::model::subnet_group::Builder::default()
    }
}

/// <p>Represents the subnet associated with a DAX cluster. This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with DAX.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>The system-assigned identifier for the subnet.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p>The Availability Zone (AZ) for the subnet.</p>
    pub subnet_availability_zone: std::option::Option<std::string::String>,
}
impl Subnet {
    /// <p>The system-assigned identifier for the subnet.</p>
    pub fn subnet_identifier(&self) -> std::option::Option<&str> {
        self.subnet_identifier.as_deref()
    }
    /// <p>The Availability Zone (AZ) for the subnet.</p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&str> {
        self.subnet_availability_zone.as_deref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-assigned identifier for the subnet.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>The system-assigned identifier for the subnet.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p>The Availability Zone (AZ) for the subnet.</p>
        pub fn subnet_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone (AZ) for the subnet.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>A named set of parameters that are applied to all of the nodes in a DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroup {
    /// <p>The name of the parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the parameter group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ParameterGroup {
    /// <p>The name of the parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>A description of the parameter group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroup");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ParameterGroup`](crate::model::ParameterGroup)
pub mod parameter_group {
    /// A builder for [`ParameterGroup`](crate::model::ParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroup`](crate::model::ParameterGroup)
        pub fn build(self) -> crate::model::ParameterGroup {
            crate::model::ParameterGroup {
                parameter_group_name: self.parameter_group_name,
                description: self.description,
            }
        }
    }
}
impl ParameterGroup {
    /// Creates a new builder-style object to manufacture [`ParameterGroup`](crate::model::ParameterGroup)
    pub fn builder() -> crate::model::parameter_group::Builder {
        crate::model::parameter_group::Builder::default()
    }
}

/// <p>An individual DAX parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterNameValue {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl ParameterNameValue {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The value of the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
}
impl std::fmt::Debug for ParameterNameValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterNameValue");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`ParameterNameValue`](crate::model::ParameterNameValue)
pub mod parameter_name_value {
    /// A builder for [`ParameterNameValue`](crate::model::ParameterNameValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterNameValue`](crate::model::ParameterNameValue)
        pub fn build(self) -> crate::model::ParameterNameValue {
            crate::model::ParameterNameValue {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl ParameterNameValue {
    /// Creates a new builder-style object to manufacture [`ParameterNameValue`](crate::model::ParameterNameValue)
    pub fn builder() -> crate::model::parameter_name_value::Builder {
        crate::model::parameter_name_value::Builder::default()
    }
}

/// <p>Contains all of the attributes of a specific DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The name of the DAX cluster.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The description of the cluster.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster. </p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The total number of nodes in the cluster.</p>
    pub total_nodes: std::option::Option<i32>,
    /// <p>The number of nodes in the cluster that are active (i.e., capable of serving requests).</p>
    pub active_nodes: std::option::Option<i32>,
    /// <p>The node type for the nodes in the cluster. (All nodes in a DAX cluster are of the same type.)</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The current status of the cluster.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The endpoint for this DAX cluster, consisting of a DNS name, a port number, and a URL. Applications should use the URL to configure the DAX client to find their cluster.</p>
    pub cluster_discovery_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>A list of nodes to be removed from the cluster.</p>
    pub node_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of nodes that are currently in the cluster.</p>
    pub nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
    /// <p>A range of time when maintenance of DAX cluster software will be performed. For example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).</p>
    pub notification_configuration: std::option::Option<crate::model::NotificationConfiguration>,
    /// <p>The subnet group where the DAX cluster is running.</p>
    pub subnet_group: std::option::Option<std::string::String>,
    /// <p>A list of security groups, and the status of each, for the nodes in the cluster.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
    /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The parameter group being used by nodes in the cluster.</p>
    pub parameter_group: std::option::Option<crate::model::ParameterGroupStatus>,
    /// <p>The description of the server-side encryption status on the specified DAX cluster.</p>
    pub sse_description: std::option::Option<crate::model::SseDescription>,
    /// <p>The type of encryption supported by the cluster's endpoint. Values are:</p>
    /// <ul>
    /// <li> <p> <code>NONE</code> for no encryption</p> <p> <code>TLS</code> for Transport Layer Security</p> </li>
    /// </ul>
    pub cluster_endpoint_encryption_type:
        std::option::Option<crate::model::ClusterEndpointEncryptionType>,
}
impl Cluster {
    /// <p>The name of the DAX cluster.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The description of the cluster.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster. </p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
    /// <p>The total number of nodes in the cluster.</p>
    pub fn total_nodes(&self) -> std::option::Option<i32> {
        self.total_nodes
    }
    /// <p>The number of nodes in the cluster that are active (i.e., capable of serving requests).</p>
    pub fn active_nodes(&self) -> std::option::Option<i32> {
        self.active_nodes
    }
    /// <p>The node type for the nodes in the cluster. (All nodes in a DAX cluster are of the same type.)</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The current status of the cluster.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The endpoint for this DAX cluster, consisting of a DNS name, a port number, and a URL. Applications should use the URL to configure the DAX client to find their cluster.</p>
    pub fn cluster_discovery_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.cluster_discovery_endpoint.as_ref()
    }
    /// <p>A list of nodes to be removed from the cluster.</p>
    pub fn node_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.node_ids_to_remove.as_deref()
    }
    /// <p>A list of nodes that are currently in the cluster.</p>
    pub fn nodes(&self) -> std::option::Option<&[crate::model::Node]> {
        self.nodes.as_deref()
    }
    /// <p>A range of time when maintenance of DAX cluster software will be performed. For example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).</p>
    pub fn notification_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationConfiguration> {
        self.notification_configuration.as_ref()
    }
    /// <p>The subnet group where the DAX cluster is running.</p>
    pub fn subnet_group(&self) -> std::option::Option<&str> {
        self.subnet_group.as_deref()
    }
    /// <p>A list of security groups, and the status of each, for the nodes in the cluster.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::SecurityGroupMembership]> {
        self.security_groups.as_deref()
    }
    /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The parameter group being used by nodes in the cluster.</p>
    pub fn parameter_group(&self) -> std::option::Option<&crate::model::ParameterGroupStatus> {
        self.parameter_group.as_ref()
    }
    /// <p>The description of the server-side encryption status on the specified DAX cluster.</p>
    pub fn sse_description(&self) -> std::option::Option<&crate::model::SseDescription> {
        self.sse_description.as_ref()
    }
    /// <p>The type of encryption supported by the cluster's endpoint. Values are:</p>
    /// <ul>
    /// <li> <p> <code>NONE</code> for no encryption</p> <p> <code>TLS</code> for Transport Layer Security</p> </li>
    /// </ul>
    pub fn cluster_endpoint_encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::ClusterEndpointEncryptionType> {
        self.cluster_endpoint_encryption_type.as_ref()
    }
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("description", &self.description);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("total_nodes", &self.total_nodes);
        formatter.field("active_nodes", &self.active_nodes);
        formatter.field("node_type", &self.node_type);
        formatter.field("status", &self.status);
        formatter.field(
            "cluster_discovery_endpoint",
            &self.cluster_discovery_endpoint,
        );
        formatter.field("node_ids_to_remove", &self.node_ids_to_remove);
        formatter.field("nodes", &self.nodes);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "notification_configuration",
            &self.notification_configuration,
        );
        formatter.field("subnet_group", &self.subnet_group);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("parameter_group", &self.parameter_group);
        formatter.field("sse_description", &self.sse_description);
        formatter.field(
            "cluster_endpoint_encryption_type",
            &self.cluster_endpoint_encryption_type,
        );
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) total_nodes: std::option::Option<i32>,
        pub(crate) active_nodes: std::option::Option<i32>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) cluster_discovery_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) node_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
        pub(crate) subnet_group: std::option::Option<std::string::String>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) parameter_group: std::option::Option<crate::model::ParameterGroupStatus>,
        pub(crate) sse_description: std::option::Option<crate::model::SseDescription>,
        pub(crate) cluster_endpoint_encryption_type:
            std::option::Option<crate::model::ClusterEndpointEncryptionType>,
    }
    impl Builder {
        /// <p>The name of the DAX cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The description of the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster. </p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster. </p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The total number of nodes in the cluster.</p>
        pub fn total_nodes(mut self, input: i32) -> Self {
            self.total_nodes = Some(input);
            self
        }
        /// <p>The total number of nodes in the cluster.</p>
        pub fn set_total_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.total_nodes = input;
            self
        }
        /// <p>The number of nodes in the cluster that are active (i.e., capable of serving requests).</p>
        pub fn active_nodes(mut self, input: i32) -> Self {
            self.active_nodes = Some(input);
            self
        }
        /// <p>The number of nodes in the cluster that are active (i.e., capable of serving requests).</p>
        pub fn set_active_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.active_nodes = input;
            self
        }
        /// <p>The node type for the nodes in the cluster. (All nodes in a DAX cluster are of the same type.)</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type for the nodes in the cluster. (All nodes in a DAX cluster are of the same type.)</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The current status of the cluster.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the cluster.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The endpoint for this DAX cluster, consisting of a DNS name, a port number, and a URL. Applications should use the URL to configure the DAX client to find their cluster.</p>
        pub fn cluster_discovery_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.cluster_discovery_endpoint = Some(input);
            self
        }
        /// <p>The endpoint for this DAX cluster, consisting of a DNS name, a port number, and a URL. Applications should use the URL to configure the DAX client to find their cluster.</p>
        pub fn set_cluster_discovery_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.cluster_discovery_endpoint = input;
            self
        }
        /// Appends an item to `node_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_node_ids_to_remove`](Self::set_node_ids_to_remove).
        ///
        /// <p>A list of nodes to be removed from the cluster.</p>
        pub fn node_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.node_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.node_ids_to_remove = Some(v);
            self
        }
        /// <p>A list of nodes to be removed from the cluster.</p>
        pub fn set_node_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.node_ids_to_remove = input;
            self
        }
        /// Appends an item to `nodes`.
        ///
        /// To override the contents of this collection use [`set_nodes`](Self::set_nodes).
        ///
        /// <p>A list of nodes that are currently in the cluster.</p>
        pub fn nodes(mut self, input: crate::model::Node) -> Self {
            let mut v = self.nodes.unwrap_or_default();
            v.push(input);
            self.nodes = Some(v);
            self
        }
        /// <p>A list of nodes that are currently in the cluster.</p>
        pub fn set_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Node>>,
        ) -> Self {
            self.nodes = input;
            self
        }
        /// <p>A range of time when maintenance of DAX cluster software will be performed. For example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>A range of time when maintenance of DAX cluster software will be performed. For example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// <p>The subnet group where the DAX cluster is running.</p>
        pub fn subnet_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group = Some(input.into());
            self
        }
        /// <p>The subnet group where the DAX cluster is running.</p>
        pub fn set_subnet_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_group = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of security groups, and the status of each, for the nodes in the cluster.</p>
        pub fn security_groups(mut self, input: crate::model::SecurityGroupMembership) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input);
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of security groups, and the status of each, for the nodes in the cluster.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroupMembership>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The parameter group being used by nodes in the cluster.</p>
        pub fn parameter_group(mut self, input: crate::model::ParameterGroupStatus) -> Self {
            self.parameter_group = Some(input);
            self
        }
        /// <p>The parameter group being used by nodes in the cluster.</p>
        pub fn set_parameter_group(
            mut self,
            input: std::option::Option<crate::model::ParameterGroupStatus>,
        ) -> Self {
            self.parameter_group = input;
            self
        }
        /// <p>The description of the server-side encryption status on the specified DAX cluster.</p>
        pub fn sse_description(mut self, input: crate::model::SseDescription) -> Self {
            self.sse_description = Some(input);
            self
        }
        /// <p>The description of the server-side encryption status on the specified DAX cluster.</p>
        pub fn set_sse_description(
            mut self,
            input: std::option::Option<crate::model::SseDescription>,
        ) -> Self {
            self.sse_description = input;
            self
        }
        /// <p>The type of encryption supported by the cluster's endpoint. Values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> for no encryption</p> <p> <code>TLS</code> for Transport Layer Security</p> </li>
        /// </ul>
        pub fn cluster_endpoint_encryption_type(
            mut self,
            input: crate::model::ClusterEndpointEncryptionType,
        ) -> Self {
            self.cluster_endpoint_encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption supported by the cluster's endpoint. Values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> for no encryption</p> <p> <code>TLS</code> for Transport Layer Security</p> </li>
        /// </ul>
        pub fn set_cluster_endpoint_encryption_type(
            mut self,
            input: std::option::Option<crate::model::ClusterEndpointEncryptionType>,
        ) -> Self {
            self.cluster_endpoint_encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                cluster_name: self.cluster_name,
                description: self.description,
                cluster_arn: self.cluster_arn,
                total_nodes: self.total_nodes,
                active_nodes: self.active_nodes,
                node_type: self.node_type,
                status: self.status,
                cluster_discovery_endpoint: self.cluster_discovery_endpoint,
                node_ids_to_remove: self.node_ids_to_remove,
                nodes: self.nodes,
                preferred_maintenance_window: self.preferred_maintenance_window,
                notification_configuration: self.notification_configuration,
                subnet_group: self.subnet_group,
                security_groups: self.security_groups,
                iam_role_arn: self.iam_role_arn,
                parameter_group: self.parameter_group,
                sse_description: self.sse_description,
                cluster_endpoint_encryption_type: self.cluster_endpoint_encryption_type,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterEndpointEncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Tls,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterEndpointEncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ClusterEndpointEncryptionType::None,
            "TLS" => ClusterEndpointEncryptionType::Tls,
            other => ClusterEndpointEncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterEndpointEncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterEndpointEncryptionType::from(s))
    }
}
impl ClusterEndpointEncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterEndpointEncryptionType::None => "NONE",
            ClusterEndpointEncryptionType::Tls => "TLS",
            ClusterEndpointEncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "TLS"]
    }
}
impl AsRef<str> for ClusterEndpointEncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The description of the server-side encryption status on the specified DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SseDescription {
    /// <p>The current state of server-side encryption:</p>
    /// <ul>
    /// <li> <p> <code>ENABLING</code> - Server-side encryption is being enabled.</p> </li>
    /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
    /// <li> <p> <code>DISABLING</code> - Server-side encryption is being disabled.</p> </li>
    /// <li> <p> <code>DISABLED</code> - Server-side encryption is disabled.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::SseStatus>,
}
impl SseDescription {
    /// <p>The current state of server-side encryption:</p>
    /// <ul>
    /// <li> <p> <code>ENABLING</code> - Server-side encryption is being enabled.</p> </li>
    /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
    /// <li> <p> <code>DISABLING</code> - Server-side encryption is being disabled.</p> </li>
    /// <li> <p> <code>DISABLED</code> - Server-side encryption is disabled.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::SseStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SseDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SseDescription");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SseDescription`](crate::model::SseDescription)
pub mod sse_description {
    /// A builder for [`SseDescription`](crate::model::SseDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::SseStatus>,
    }
    impl Builder {
        /// <p>The current state of server-side encryption:</p>
        /// <ul>
        /// <li> <p> <code>ENABLING</code> - Server-side encryption is being enabled.</p> </li>
        /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
        /// <li> <p> <code>DISABLING</code> - Server-side encryption is being disabled.</p> </li>
        /// <li> <p> <code>DISABLED</code> - Server-side encryption is disabled.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::SseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of server-side encryption:</p>
        /// <ul>
        /// <li> <p> <code>ENABLING</code> - Server-side encryption is being enabled.</p> </li>
        /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
        /// <li> <p> <code>DISABLING</code> - Server-side encryption is being disabled.</p> </li>
        /// <li> <p> <code>DISABLED</code> - Server-side encryption is disabled.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::SseStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SseDescription`](crate::model::SseDescription)
        pub fn build(self) -> crate::model::SseDescription {
            crate::model::SseDescription {
                status: self.status,
            }
        }
    }
}
impl SseDescription {
    /// Creates a new builder-style object to manufacture [`SseDescription`](crate::model::SseDescription)
    pub fn builder() -> crate::model::sse_description::Builder {
        crate::model::sse_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SseStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => SseStatus::Disabled,
            "DISABLING" => SseStatus::Disabling,
            "ENABLED" => SseStatus::Enabled,
            "ENABLING" => SseStatus::Enabling,
            other => SseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SseStatus::from(s))
    }
}
impl SseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SseStatus::Disabled => "DISABLED",
            SseStatus::Disabling => "DISABLING",
            SseStatus::Enabled => "ENABLED",
            SseStatus::Enabling => "ENABLING",
            SseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DISABLING", "ENABLED", "ENABLING"]
    }
}
impl AsRef<str> for SseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of a parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupStatus {
    /// <p>The name of the parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of parameter updates. </p>
    pub parameter_apply_status: std::option::Option<std::string::String>,
    /// <p>The node IDs of one or more nodes to be rebooted.</p>
    pub node_ids_to_reboot: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ParameterGroupStatus {
    /// <p>The name of the parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The status of parameter updates. </p>
    pub fn parameter_apply_status(&self) -> std::option::Option<&str> {
        self.parameter_apply_status.as_deref()
    }
    /// <p>The node IDs of one or more nodes to be rebooted.</p>
    pub fn node_ids_to_reboot(&self) -> std::option::Option<&[std::string::String]> {
        self.node_ids_to_reboot.as_deref()
    }
}
impl std::fmt::Debug for ParameterGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupStatus");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.field("node_ids_to_reboot", &self.node_ids_to_reboot);
        formatter.finish()
    }
}
/// See [`ParameterGroupStatus`](crate::model::ParameterGroupStatus)
pub mod parameter_group_status {
    /// A builder for [`ParameterGroupStatus`](crate::model::ParameterGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
        pub(crate) node_ids_to_reboot: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The status of parameter updates. </p>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of parameter updates. </p>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// Appends an item to `node_ids_to_reboot`.
        ///
        /// To override the contents of this collection use [`set_node_ids_to_reboot`](Self::set_node_ids_to_reboot).
        ///
        /// <p>The node IDs of one or more nodes to be rebooted.</p>
        pub fn node_ids_to_reboot(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.node_ids_to_reboot.unwrap_or_default();
            v.push(input.into());
            self.node_ids_to_reboot = Some(v);
            self
        }
        /// <p>The node IDs of one or more nodes to be rebooted.</p>
        pub fn set_node_ids_to_reboot(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.node_ids_to_reboot = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupStatus`](crate::model::ParameterGroupStatus)
        pub fn build(self) -> crate::model::ParameterGroupStatus {
            crate::model::ParameterGroupStatus {
                parameter_group_name: self.parameter_group_name,
                parameter_apply_status: self.parameter_apply_status,
                node_ids_to_reboot: self.node_ids_to_reboot,
            }
        }
    }
}
impl ParameterGroupStatus {
    /// Creates a new builder-style object to manufacture [`ParameterGroupStatus`](crate::model::ParameterGroupStatus)
    pub fn builder() -> crate::model::parameter_group_status::Builder {
        crate::model::parameter_group_status::Builder::default()
    }
}

/// <p>An individual VPC security group and its status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupMembership {
    /// <p>The unique ID for this security group.</p>
    pub security_group_identifier: std::option::Option<std::string::String>,
    /// <p>The status of this security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl SecurityGroupMembership {
    /// <p>The unique ID for this security group.</p>
    pub fn security_group_identifier(&self) -> std::option::Option<&str> {
        self.security_group_identifier.as_deref()
    }
    /// <p>The status of this security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupMembership");
        formatter.field("security_group_identifier", &self.security_group_identifier);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
pub mod security_group_membership {
    /// A builder for [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_identifier: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID for this security group.</p>
        pub fn security_group_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_identifier = Some(input.into());
            self
        }
        /// <p>The unique ID for this security group.</p>
        pub fn set_security_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_identifier = input;
            self
        }
        /// <p>The status of this security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of this security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
        pub fn build(self) -> crate::model::SecurityGroupMembership {
            crate::model::SecurityGroupMembership {
                security_group_identifier: self.security_group_identifier,
                status: self.status,
            }
        }
    }
}
impl SecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`SecurityGroupMembership`](crate::model::SecurityGroupMembership)
    pub fn builder() -> crate::model::security_group_membership::Builder {
        crate::model::security_group_membership::Builder::default()
    }
}

/// <p>Describes a notification topic and its status. Notification topics are used for publishing DAX events to subscribers using Amazon Simple Notification Service (SNS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfiguration {
    /// <p>The Amazon Resource Name (ARN) that identifies the topic. </p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.</p>
    pub topic_status: std::option::Option<std::string::String>,
}
impl NotificationConfiguration {
    /// <p>The Amazon Resource Name (ARN) that identifies the topic. </p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.</p>
    pub fn topic_status(&self) -> std::option::Option<&str> {
        self.topic_status.as_deref()
    }
}
impl std::fmt::Debug for NotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfiguration");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("topic_status", &self.topic_status);
        formatter.finish()
    }
}
/// See [`NotificationConfiguration`](crate::model::NotificationConfiguration)
pub mod notification_configuration {
    /// A builder for [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) topic_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the topic. </p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the topic. </p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.</p>
        pub fn topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_status = Some(input.into());
            self
        }
        /// <p>The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.</p>
        pub fn set_topic_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_status = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::model::NotificationConfiguration)
        pub fn build(self) -> crate::model::NotificationConfiguration {
            crate::model::NotificationConfiguration {
                topic_arn: self.topic_arn,
                topic_status: self.topic_status,
            }
        }
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    pub fn builder() -> crate::model::notification_configuration::Builder {
        crate::model::notification_configuration::Builder::default()
    }
}

/// <p>Represents an individual node within a DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Node {
    /// <p>A system-generated identifier for the node.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests and responses to nodes in the DAX cluster.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The date and time (in UNIX epoch format) when the node was launched.</p>
    pub node_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Availability Zone (AZ) in which the node has been deployed.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The current status of the node. For example: <code>available</code>.</p>
    pub node_status: std::option::Option<std::string::String>,
    /// <p>The status of the parameter group associated with this node. For example, <code>in-sync</code>.</p>
    pub parameter_group_status: std::option::Option<std::string::String>,
}
impl Node {
    /// <p>A system-generated identifier for the node.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests and responses to nodes in the DAX cluster.</p>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
    /// <p>The date and time (in UNIX epoch format) when the node was launched.</p>
    pub fn node_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.node_create_time.as_ref()
    }
    /// <p>The Availability Zone (AZ) in which the node has been deployed.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The current status of the node. For example: <code>available</code>.</p>
    pub fn node_status(&self) -> std::option::Option<&str> {
        self.node_status.as_deref()
    }
    /// <p>The status of the parameter group associated with this node. For example, <code>in-sync</code>.</p>
    pub fn parameter_group_status(&self) -> std::option::Option<&str> {
        self.parameter_group_status.as_deref()
    }
}
impl std::fmt::Debug for Node {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Node");
        formatter.field("node_id", &self.node_id);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("node_create_time", &self.node_create_time);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("node_status", &self.node_status);
        formatter.field("parameter_group_status", &self.parameter_group_status);
        formatter.finish()
    }
}
/// See [`Node`](crate::model::Node)
pub mod node {
    /// A builder for [`Node`](crate::model::Node)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) node_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) node_status: std::option::Option<std::string::String>,
        pub(crate) parameter_group_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-generated identifier for the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>A system-generated identifier for the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// <p>The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests and responses to nodes in the DAX cluster.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>The endpoint for the node, consisting of a DNS name and a port number. Client applications can connect directly to a node endpoint, if desired (as an alternative to allowing DAX client software to intelligently route requests and responses to nodes in the DAX cluster.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The date and time (in UNIX epoch format) when the node was launched.</p>
        pub fn node_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.node_create_time = Some(input);
            self
        }
        /// <p>The date and time (in UNIX epoch format) when the node was launched.</p>
        pub fn set_node_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.node_create_time = input;
            self
        }
        /// <p>The Availability Zone (AZ) in which the node has been deployed.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone (AZ) in which the node has been deployed.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The current status of the node. For example: <code>available</code>.</p>
        pub fn node_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_status = Some(input.into());
            self
        }
        /// <p>The current status of the node. For example: <code>available</code>.</p>
        pub fn set_node_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_status = input;
            self
        }
        /// <p>The status of the parameter group associated with this node. For example, <code>in-sync</code>.</p>
        pub fn parameter_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_status = Some(input.into());
            self
        }
        /// <p>The status of the parameter group associated with this node. For example, <code>in-sync</code>.</p>
        pub fn set_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Node`](crate::model::Node)
        pub fn build(self) -> crate::model::Node {
            crate::model::Node {
                node_id: self.node_id,
                endpoint: self.endpoint,
                node_create_time: self.node_create_time,
                availability_zone: self.availability_zone,
                node_status: self.node_status,
                parameter_group_status: self.parameter_group_status,
            }
        }
    }
}
impl Node {
    /// Creates a new builder-style object to manufacture [`Node`](crate::model::Node)
    pub fn builder() -> crate::model::node::Builder {
        crate::model::node::Builder::default()
    }
}

/// <p>Represents the information required for client programs to connect to the endpoint for a DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The DNS hostname of the endpoint.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The port number that applications should use to connect to the endpoint.</p>
    pub port: i32,
    /// <p>The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.</p>
    pub url: std::option::Option<std::string::String>,
}
impl Endpoint {
    /// <p>The DNS hostname of the endpoint.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The port number that applications should use to connect to the endpoint.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DNS hostname of the endpoint.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS hostname of the endpoint.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The port number that applications should use to connect to the endpoint.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number that applications should use to connect to the endpoint.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
                url: self.url,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>A description of a tag. Every tag is a key-value pair. You can add up to 50 tags to a single DAX cluster.</p>
/// <p>AWS-assigned tag names and values are automatically assigned the <code>aws:</code> prefix, which the user cannot assign. AWS-assigned tag names do not count towards the tag limit of 50. User-assigned tag names have the prefix <code>user:</code>.</p>
/// <p>You cannot backdate the application of a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key for the tag. Tag keys are case sensitive. Every DAX cluster can only have one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag. Tag values are case-sensitive and can be null. </p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key for the tag. Tag keys are case sensitive. Every DAX cluster can only have one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag. Tag values are case-sensitive and can be null. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag. Tag keys are case sensitive. Every DAX cluster can only have one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag. Tag keys are case sensitive. Every DAX cluster can only have one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag. Tag values are case-sensitive and can be null. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag. Tag values are case-sensitive and can be null. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes an individual setting that controls some aspect of DAX behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.</p>
    pub parameter_type: std::option::Option<crate::model::ParameterType>,
    /// <p>The value for the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>A list of node types, and specific parameter values for each node.</p>
    pub node_type_specific_values:
        std::option::Option<std::vec::Vec<crate::model::NodeTypeSpecificValue>>,
    /// <p>A description of the parameter</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The data type of the parameter. For example, <code>integer</code>:</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>A range of values within which the parameter can be set.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>Whether the customer is allowed to modify the parameter.</p>
    pub is_modifiable: std::option::Option<crate::model::IsModifiable>,
    /// <p>The conditions under which changes to this parameter can be applied. For example, <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a node is rebooted.</p>
    pub change_type: std::option::Option<crate::model::ChangeType>,
}
impl Parameter {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.</p>
    pub fn parameter_type(&self) -> std::option::Option<&crate::model::ParameterType> {
        self.parameter_type.as_ref()
    }
    /// <p>The value for the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
    /// <p>A list of node types, and specific parameter values for each node.</p>
    pub fn node_type_specific_values(
        &self,
    ) -> std::option::Option<&[crate::model::NodeTypeSpecificValue]> {
        self.node_type_specific_values.as_deref()
    }
    /// <p>A description of the parameter</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The data type of the parameter. For example, <code>integer</code>:</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>A range of values within which the parameter can be set.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>Whether the customer is allowed to modify the parameter.</p>
    pub fn is_modifiable(&self) -> std::option::Option<&crate::model::IsModifiable> {
        self.is_modifiable.as_ref()
    }
    /// <p>The conditions under which changes to this parameter can be applied. For example, <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a node is rebooted.</p>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.change_type.as_ref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_type", &self.parameter_type);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("node_type_specific_values", &self.node_type_specific_values);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("change_type", &self.change_type);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_type: std::option::Option<crate::model::ParameterType>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) node_type_specific_values:
            std::option::Option<std::vec::Vec<crate::model::NodeTypeSpecificValue>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<crate::model::IsModifiable>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeType>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.</p>
        pub fn parameter_type(mut self, input: crate::model::ParameterType) -> Self {
            self.parameter_type = Some(input);
            self
        }
        /// <p>Determines whether the parameter can be applied to any nodes, or only nodes of a particular type.</p>
        pub fn set_parameter_type(
            mut self,
            input: std::option::Option<crate::model::ParameterType>,
        ) -> Self {
            self.parameter_type = input;
            self
        }
        /// <p>The value for the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value for the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Appends an item to `node_type_specific_values`.
        ///
        /// To override the contents of this collection use [`set_node_type_specific_values`](Self::set_node_type_specific_values).
        ///
        /// <p>A list of node types, and specific parameter values for each node.</p>
        pub fn node_type_specific_values(
            mut self,
            input: crate::model::NodeTypeSpecificValue,
        ) -> Self {
            let mut v = self.node_type_specific_values.unwrap_or_default();
            v.push(input);
            self.node_type_specific_values = Some(v);
            self
        }
        /// <p>A list of node types, and specific parameter values for each node.</p>
        pub fn set_node_type_specific_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeTypeSpecificValue>>,
        ) -> Self {
            self.node_type_specific_values = input;
            self
        }
        /// <p>A description of the parameter</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The data type of the parameter. For example, <code>integer</code>:</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the parameter. For example, <code>integer</code>:</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>A range of values within which the parameter can be set.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>A range of values within which the parameter can be set.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>Whether the customer is allowed to modify the parameter.</p>
        pub fn is_modifiable(mut self, input: crate::model::IsModifiable) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>Whether the customer is allowed to modify the parameter.</p>
        pub fn set_is_modifiable(
            mut self,
            input: std::option::Option<crate::model::IsModifiable>,
        ) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The conditions under which changes to this parameter can be applied. For example, <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a node is rebooted.</p>
        pub fn change_type(mut self, input: crate::model::ChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>The conditions under which changes to this parameter can be applied. For example, <code>requires-reboot</code> indicates that a new value for this parameter will only take effect if a node is rebooted.</p>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_name: self.parameter_name,
                parameter_type: self.parameter_type,
                parameter_value: self.parameter_value,
                node_type_specific_values: self.node_type_specific_values,
                description: self.description,
                source: self.source,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable,
                change_type: self.change_type,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Immediate,
    #[allow(missing_docs)] // documentation missing in model
    RequiresReboot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "IMMEDIATE" => ChangeType::Immediate,
            "REQUIRES_REBOOT" => ChangeType::RequiresReboot,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::Immediate => "IMMEDIATE",
            ChangeType::RequiresReboot => "REQUIRES_REBOOT",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IMMEDIATE", "REQUIRES_REBOOT"]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IsModifiable {
    #[allow(missing_docs)] // documentation missing in model
    Conditional,
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IsModifiable {
    fn from(s: &str) -> Self {
        match s {
            "CONDITIONAL" => IsModifiable::Conditional,
            "FALSE" => IsModifiable::False,
            "TRUE" => IsModifiable::True,
            other => IsModifiable::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IsModifiable {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IsModifiable::from(s))
    }
}
impl IsModifiable {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IsModifiable::Conditional => "CONDITIONAL",
            IsModifiable::False => "FALSE",
            IsModifiable::True => "TRUE",
            IsModifiable::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONDITIONAL", "FALSE", "TRUE"]
    }
}
impl AsRef<str> for IsModifiable {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a parameter value that is applicable to a particular node type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeTypeSpecificValue {
    /// <p>A node type to which the parameter value applies.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The parameter value for this node type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl NodeTypeSpecificValue {
    /// <p>A node type to which the parameter value applies.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The parameter value for this node type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for NodeTypeSpecificValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeTypeSpecificValue");
        formatter.field("node_type", &self.node_type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`NodeTypeSpecificValue`](crate::model::NodeTypeSpecificValue)
pub mod node_type_specific_value {
    /// A builder for [`NodeTypeSpecificValue`](crate::model::NodeTypeSpecificValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A node type to which the parameter value applies.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>A node type to which the parameter value applies.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The parameter value for this node type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The parameter value for this node type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeTypeSpecificValue`](crate::model::NodeTypeSpecificValue)
        pub fn build(self) -> crate::model::NodeTypeSpecificValue {
            crate::model::NodeTypeSpecificValue {
                node_type: self.node_type,
                value: self.value,
            }
        }
    }
}
impl NodeTypeSpecificValue {
    /// Creates a new builder-style object to manufacture [`NodeTypeSpecificValue`](crate::model::NodeTypeSpecificValue)
    pub fn builder() -> crate::model::node_type_specific_value::Builder {
        crate::model::node_type_specific_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterType {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    NodeTypeSpecific,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterType {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => ParameterType::Default,
            "NODE_TYPE_SPECIFIC" => ParameterType::NodeTypeSpecific,
            other => ParameterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterType::from(s))
    }
}
impl ParameterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterType::Default => "DEFAULT",
            ParameterType::NodeTypeSpecific => "NODE_TYPE_SPECIFIC",
            ParameterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "NODE_TYPE_SPECIFIC"]
    }
}
impl AsRef<str> for ParameterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a single occurrence of something interesting within the system. Some examples of events are creating a DAX cluster, adding or removing a node, or rebooting a node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The source of the event. For example, if the event occurred at the node level, the source would be the node ID.</p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p>Specifies the origin of this event - a cluster, a parameter group, a node ID, etc.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>A user-defined message associated with the event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The date and time when the event occurred.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Event {
    /// <p>The source of the event. For example, if the event occurred at the node level, the source would be the node ID.</p>
    pub fn source_name(&self) -> std::option::Option<&str> {
        self.source_name.as_deref()
    }
    /// <p>Specifies the origin of this event - a cluster, a parameter group, a node ID, etc.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>A user-defined message associated with the event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The date and time when the event occurred.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_name", &self.source_name);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("date", &self.date);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The source of the event. For example, if the event occurred at the node level, the source would be the node ID.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p>The source of the event. For example, if the event occurred at the node level, the source would be the node ID.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p>Specifies the origin of this event - a cluster, a parameter group, a node ID, etc.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies the origin of this event - a cluster, a parameter group, a node ID, etc.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>A user-defined message associated with the event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A user-defined message associated with the event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date and time when the event occurred.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_name: self.source_name,
                source_type: self.source_type,
                message: self.message,
                date: self.date,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Cluster,
    #[allow(missing_docs)] // documentation missing in model
    ParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    SubnetGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER" => SourceType::Cluster,
            "PARAMETER_GROUP" => SourceType::ParameterGroup,
            "SUBNET_GROUP" => SourceType::SubnetGroup,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Cluster => "CLUSTER",
            SourceType::ParameterGroup => "PARAMETER_GROUP",
            SourceType::SubnetGroup => "SUBNET_GROUP",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLUSTER", "PARAMETER_GROUP", "SUBNET_GROUP"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the settings used to enable server-side encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SseSpecification {
    /// <p>Indicates whether server-side encryption is enabled (true) or disabled (false) on the cluster.</p>
    pub enabled: std::option::Option<bool>,
}
impl SseSpecification {
    /// <p>Indicates whether server-side encryption is enabled (true) or disabled (false) on the cluster.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for SseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SseSpecification");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`SseSpecification`](crate::model::SseSpecification)
pub mod sse_specification {
    /// A builder for [`SseSpecification`](crate::model::SseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether server-side encryption is enabled (true) or disabled (false) on the cluster.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether server-side encryption is enabled (true) or disabled (false) on the cluster.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SseSpecification`](crate::model::SseSpecification)
        pub fn build(self) -> crate::model::SseSpecification {
            crate::model::SseSpecification {
                enabled: self.enabled,
            }
        }
    }
}
impl SseSpecification {
    /// Creates a new builder-style object to manufacture [`SseSpecification`](crate::model::SseSpecification)
    pub fn builder() -> crate::model::sse_specification::Builder {
        crate::model::sse_specification::Builder::default()
    }
}
