// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You already have a DAX cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>You have attempted to exceed the maximum number of DAX clusters for your AWS account.</p>
    ClusterQuotaForCustomerExceededFault(crate::error::ClusterQuotaForCustomerExceededFault),
    /// <p>There are not enough system resources to create the cluster you requested (or to resize an already-existing cluster). </p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The Amazon Resource Name (ARN) supplied in the request is not valid.</p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>One or more parameters in a parameter group are in an invalid state.</p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An invalid subnet identifier was specified.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The VPC network is in an invalid state.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>None of the nodes in the cluster have the given node ID.</p>
    NodeNotFoundFault(crate::error::NodeNotFoundFault),
    /// <p>You have attempted to exceed the maximum number of nodes for a DAX cluster.</p>
    NodeQuotaForClusterExceededFault(crate::error::NodeQuotaForClusterExceededFault),
    /// <p>You have attempted to exceed the maximum number of nodes for your AWS account.</p>
    NodeQuotaForCustomerExceededFault(crate::error::NodeQuotaForCustomerExceededFault),
    /// <p>The specified parameter group already exists.</p>
    ParameterGroupAlreadyExistsFault(crate::error::ParameterGroupAlreadyExistsFault),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>You have attempted to exceed the maximum number of parameter groups.</p>
    ParameterGroupQuotaExceededFault(crate::error::ParameterGroupQuotaExceededFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>You have reached the maximum number of x509 certificates that can be created for encrypted clusters in a 30 day period. Contact AWS customer support to discuss options for continuing to create encrypted clusters.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The specified subnet group already exists.</p>
    SubnetGroupAlreadyExistsFault(crate::error::SubnetGroupAlreadyExistsFault),
    /// <p>The specified subnet group is currently in use.</p>
    SubnetGroupInUseFault(crate::error::SubnetGroupInUseFault),
    /// <p>The requested subnet group name does not refer to an existing subnet group.</p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
    SubnetGroupQuotaExceededFault(crate::error::SubnetGroupQuotaExceededFault),
    /// <p>The requested subnet is being used by another subnet group.</p>
    SubnetInUse(crate::error::SubnetInUse),
    /// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
    SubnetQuotaExceededFault(crate::error::SubnetQuotaExceededFault),
    /// <p>The tag does not exist.</p>
    TagNotFoundFault(crate::error::TagNotFoundFault),
    /// <p>You have exceeded the maximum number of tags for this DAX cluster.</p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ClusterNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterQuotaForCustomerExceededFault(inner) => inner.fmt(f),
            Error::InsufficientClusterCapacityFault(inner) => inner.fmt(f),
            Error::InvalidArnFault(inner) => inner.fmt(f),
            Error::InvalidClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidParameterCombinationException(inner) => inner.fmt(f),
            Error::InvalidParameterGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::InvalidVpcNetworkStateFault(inner) => inner.fmt(f),
            Error::NodeNotFoundFault(inner) => inner.fmt(f),
            Error::NodeQuotaForClusterExceededFault(inner) => inner.fmt(f),
            Error::NodeQuotaForCustomerExceededFault(inner) => inner.fmt(f),
            Error::ParameterGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::ParameterGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::ServiceLinkedRoleNotFoundFault(inner) => inner.fmt(f),
            Error::ServiceQuotaExceededException(inner) => inner.fmt(f),
            Error::SubnetGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::SubnetGroupInUseFault(inner) => inner.fmt(f),
            Error::SubnetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::SubnetGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::SubnetInUse(inner) => inner.fmt(f),
            Error::SubnetQuotaExceededFault(inner) => inner.fmt(f),
            Error::TagNotFoundFault(inner) => inner.fmt(f),
            Error::TagQuotaPerResourceExceeded(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateClusterErrorKind::ClusterAlreadyExistsFault(inner) => {
                    Error::ClusterAlreadyExistsFault(inner)
                }
                crate::error::CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(
                    inner,
                ) => Error::ClusterQuotaForCustomerExceededFault(inner),
                crate::error::CreateClusterErrorKind::InsufficientClusterCapacityFault(inner) => {
                    Error::InsufficientClusterCapacityFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateClusterErrorKind::InvalidParameterGroupStateFault(inner) => {
                    Error::InvalidParameterGroupStateFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateClusterErrorKind::NodeQuotaForClusterExceededFault(inner) => {
                    Error::NodeQuotaForClusterExceededFault(inner)
                }
                crate::error::CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(inner) => {
                    Error::NodeQuotaForCustomerExceededFault(inner)
                }
                crate::error::CreateClusterErrorKind::ParameterGroupNotFoundFault(inner) => {
                    Error::ParameterGroupNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::CreateClusterErrorKind::SubnetGroupNotFoundFault(inner) => {
                    Error::SubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::CreateClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(inner) => Error::InvalidParameterGroupStateFault(inner),
                crate::error::CreateParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(inner) => Error::ParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(inner) => Error::ParameterGroupQuotaExceededFault(inner),
                crate::error::CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::CreateParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(inner) => {
                    Error::SubnetGroupAlreadyExistsFault(inner)
                }
                crate::error::CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(inner) => {
                    Error::SubnetGroupQuotaExceededFault(inner)
                }
                crate::error::CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(inner) => {
                    Error::SubnetQuotaExceededFault(inner)
                }
                crate::error::CreateSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DecreaseReplicationFactorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DecreaseReplicationFactorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DecreaseReplicationFactorErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::DecreaseReplicationFactorErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::DecreaseReplicationFactorErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DecreaseReplicationFactorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DecreaseReplicationFactorErrorKind::NodeNotFoundFault(inner) => Error::NodeNotFoundFault(inner),
                crate::error::DecreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DecreaseReplicationFactorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DeleteClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::DeleteClusterErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteClusterErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::DeleteClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(inner) => Error::InvalidParameterGroupStateFault(inner),
                crate::error::DeleteParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(inner) => Error::ParameterGroupNotFoundFault(inner),
                crate::error::DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DeleteParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(inner) => {
                    Error::SubnetGroupInUseFault(inner)
                }
                crate::error::DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(inner) => {
                    Error::SubnetGroupNotFoundFault(inner)
                }
                crate::error::DeleteSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClustersErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeClustersErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeClustersErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::DescribeClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDefaultParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDefaultParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDefaultParametersErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeDefaultParametersErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeDefaultParametersErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DescribeDefaultParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeEventsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeParameterGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeParameterGroupsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(inner) => Error::ParameterGroupNotFoundFault(inner),
                crate::error::DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DescribeParameterGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeParametersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeParametersErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeParametersErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeParametersErrorKind::ParameterGroupNotFoundFault(inner) => {
                    Error::ParameterGroupNotFoundFault(inner)
                }
                crate::error::DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(
                    inner,
                ) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DescribeParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSubnetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(
                    inner,
                ) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(inner) => {
                    Error::SubnetGroupNotFoundFault(inner)
                }
                crate::error::DescribeSubnetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::IncreaseReplicationFactorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::IncreaseReplicationFactorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::IncreaseReplicationFactorErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::InsufficientClusterCapacityFault(inner) => Error::InsufficientClusterCapacityFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::IncreaseReplicationFactorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::IncreaseReplicationFactorErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::NodeQuotaForClusterExceededFault(inner) => Error::NodeQuotaForClusterExceededFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::IncreaseReplicationFactorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ListTagsErrorKind::InvalidArnFault(inner) => {
                    Error::InvalidArnFault(inner)
                }
                crate::error::ListTagsErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ListTagsErrorKind::InvalidParameterCombinationException(inner) => {
                    Error::InvalidParameterCombinationException(inner)
                }
                crate::error::ListTagsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::ListTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootNodeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RebootNodeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootNodeErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::RebootNodeErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::RebootNodeErrorKind::InvalidParameterCombinationException(inner) => {
                    Error::InvalidParameterCombinationException(inner)
                }
                crate::error::RebootNodeErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::RebootNodeErrorKind::NodeNotFoundFault(inner) => {
                    Error::NodeNotFoundFault(inner)
                }
                crate::error::RebootNodeErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::RebootNodeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::TagResourceErrorKind::InvalidArnFault(inner) => {
                    Error::InvalidArnFault(inner)
                }
                crate::error::TagResourceErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterCombinationException(inner) => {
                    Error::InvalidParameterCombinationException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::TagResourceErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidArnFault(inner) => {
                    Error::InvalidArnFault(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::UntagResourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::UntagResourceErrorKind::TagNotFoundFault(inner) => {
                    Error::TagNotFoundFault(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::UpdateClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::UpdateClusterErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::UpdateClusterErrorKind::InvalidParameterGroupStateFault(inner) => {
                    Error::InvalidParameterGroupStateFault(inner)
                }
                crate::error::UpdateClusterErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateClusterErrorKind::ParameterGroupNotFoundFault(inner) => {
                    Error::ParameterGroupNotFoundFault(inner)
                }
                crate::error::UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::UpdateClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(inner) => Error::InvalidParameterGroupStateFault(inner),
                crate::error::UpdateParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(inner) => Error::ParameterGroupNotFoundFault(inner),
                crate::error::UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::UpdateParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => {
                    Error::ServiceLinkedRoleNotFoundFault(inner)
                }
                crate::error::UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(inner) => {
                    Error::SubnetGroupNotFoundFault(inner)
                }
                crate::error::UpdateSubnetGroupErrorKind::SubnetInUse(inner) => {
                    Error::SubnetInUse(inner)
                }
                crate::error::UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(inner) => {
                    Error::SubnetQuotaExceededFault(inner)
                }
                crate::error::UpdateSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
