// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p>You already have a DAX cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p>You have attempted to exceed the maximum number of DAX clusters for your AWS account.</p>
    ClusterQuotaForCustomerExceededFault(crate::error::ClusterQuotaForCustomerExceededFault),
    /// <p>There are not enough system resources to create the cluster you requested (or to resize an already-existing cluster). </p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>One or more parameters in a parameter group are in an invalid state.</p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The VPC network is in an invalid state.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>You have attempted to exceed the maximum number of nodes for a DAX cluster.</p>
    NodeQuotaForClusterExceededFault(crate::error::NodeQuotaForClusterExceededFault),
    /// <p>You have attempted to exceed the maximum number of nodes for your AWS account.</p>
    NodeQuotaForCustomerExceededFault(crate::error::NodeQuotaForCustomerExceededFault),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>You have reached the maximum number of x509 certificates that can be created for encrypted clusters in a 30 day period. Contact AWS customer support to discuss options for continuing to create encrypted clusters.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The requested subnet group name does not refer to an existing subnet group.</p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p>You have exceeded the maximum number of tags for this DAX cluster.</p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::NodeQuotaForClusterExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterAlreadyExistsFault`.
    pub fn is_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault`.
    pub fn is_cluster_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::NodeQuotaForClusterExceededFault`.
    pub fn is_node_quota_for_cluster_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::NodeQuotaForClusterExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::NodeQuotaForCustomerExceededFault`.
    pub fn is_node_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterQuotaForCustomerExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::NodeQuotaForClusterExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::NodeQuotaForCustomerExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateClusterErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateParameterGroupErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>One or more parameters in a parameter group are in an invalid state.</p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified parameter group already exists.</p>
    ParameterGroupAlreadyExistsFault(crate::error::ParameterGroupAlreadyExistsFault),
    /// <p>You have attempted to exceed the maximum number of parameter groups.</p>
    ParameterGroupQuotaExceededFault(crate::error::ParameterGroupQuotaExceededFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateParameterGroupError {
    /// Creates a new `CreateParameterGroupError`.
    pub fn new(kind: CreateParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault`.
    pub fn is_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault`.
    pub fn is_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for CreateParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            CreateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::ParameterGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::ParameterGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSubnetGroupErrorKind {
    /// <p>An invalid subnet identifier was specified.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>The specified subnet group already exists.</p>
    SubnetGroupAlreadyExistsFault(crate::error::SubnetGroupAlreadyExistsFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
    SubnetGroupQuotaExceededFault(crate::error::SubnetGroupQuotaExceededFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
    SubnetQuotaExceededFault(crate::error::SubnetQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSubnetGroupError {
    fn code(&self) -> Option<&str> {
        CreateSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSubnetGroupError {
    /// Creates a new `CreateSubnetGroupError`.
    pub fn new(kind: CreateSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateSubnetGroupErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault`.
    pub fn is_subnet_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault`.
    pub fn is_subnet_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubnetGroupErrorKind::SubnetQuotaExceededFault`.
    pub fn is_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => Some(_inner),
            CreateSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DecreaseReplicationFactor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DecreaseReplicationFactorError {
    /// Kind of error that occurred.
    pub kind: DecreaseReplicationFactorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DecreaseReplicationFactor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DecreaseReplicationFactorErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>None of the nodes in the cluster have the given node ID.</p>
    NodeNotFoundFault(crate::error::NodeNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DecreaseReplicationFactorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DecreaseReplicationFactorErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DecreaseReplicationFactorErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DecreaseReplicationFactorErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DecreaseReplicationFactorErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DecreaseReplicationFactorErrorKind::NodeNotFoundFault(_inner) => _inner.fmt(f),
            DecreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DecreaseReplicationFactorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DecreaseReplicationFactorError {
    fn code(&self) -> Option<&str> {
        DecreaseReplicationFactorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DecreaseReplicationFactorError {
    /// Creates a new `DecreaseReplicationFactorError`.
    pub fn new(kind: DecreaseReplicationFactorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DecreaseReplicationFactorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DecreaseReplicationFactorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DecreaseReplicationFactorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DecreaseReplicationFactorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DecreaseReplicationFactorErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseReplicationFactorErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseReplicationFactorErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseReplicationFactorErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseReplicationFactorErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseReplicationFactorErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseReplicationFactorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseReplicationFactorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseReplicationFactorErrorKind::NodeNotFoundFault`.
    pub fn is_node_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseReplicationFactorErrorKind::NodeNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DecreaseReplicationFactorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DecreaseReplicationFactorErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DecreaseReplicationFactorErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DecreaseReplicationFactorErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DecreaseReplicationFactorErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DecreaseReplicationFactorErrorKind::NodeNotFoundFault(_inner) => Some(_inner),
            DecreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                Some(_inner)
            }
            DecreaseReplicationFactorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterError {
    fn code(&self) -> Option<&str> {
        DeleteClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterError {
    /// Creates a new `DeleteClusterError`.
    pub fn new(kind: DeleteClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteParameterGroupErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>One or more parameters in a parameter group are in an invalid state.</p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteParameterGroupError {
    /// Creates a new `DeleteParameterGroupError`.
    pub fn new(kind: DeleteParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DeleteParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSubnetGroupErrorKind {
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>The specified subnet group is currently in use.</p>
    SubnetGroupInUseFault(crate::error::SubnetGroupInUseFault),
    /// <p>The requested subnet group name does not refer to an existing subnet group.</p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(_inner) => _inner.fmt(f),
            DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSubnetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSubnetGroupError {
    /// Creates a new `DeleteSubnetGroupError`.
    pub fn new(kind: DeleteSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubnetGroupErrorKind::SubnetGroupInUseFault`.
    pub fn is_subnet_group_in_use_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DeleteSubnetGroupErrorKind::SubnetGroupInUseFault(_inner) => Some(_inner),
            DeleteSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            DeleteSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClustersErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClustersErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClustersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClustersError {
    fn code(&self) -> Option<&str> {
        DescribeClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClustersError {
    /// Creates a new `DescribeClustersError`.
    pub fn new(kind: DescribeClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClustersErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeClustersErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeClustersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeClustersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDefaultParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDefaultParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeDefaultParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDefaultParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDefaultParametersErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDefaultParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDefaultParametersErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultParametersErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultParametersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDefaultParametersError {
    fn code(&self) -> Option<&str> {
        DescribeDefaultParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDefaultParametersError {
    /// Creates a new `DescribeDefaultParametersError`.
    pub fn new(kind: DescribeDefaultParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDefaultParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDefaultParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDefaultParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDefaultParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDefaultParametersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultParametersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultParametersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultParametersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultParametersErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultParametersErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDefaultParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDefaultParametersErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeDefaultParametersErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeDefaultParametersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDefaultParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeEventsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeEventsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeParameterGroupsErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeParameterGroupsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeParameterGroupsError {
    /// Creates a new `DescribeParameterGroupsError`.
    pub fn new(kind: DescribeParameterGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeParameterGroupsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParameterGroupsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeParameterGroupsErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeParameterGroupsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeParameterGroupsErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            DescribeParameterGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeParametersErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeParametersErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeParametersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeParametersError {
    fn code(&self) -> Option<&str> {
        DescribeParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeParametersError {
    /// Creates a new `DescribeParametersError`.
    pub fn new(kind: DescribeParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeParametersErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeParametersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeParametersErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            DescribeParametersErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSubnetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeSubnetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSubnetGroupsErrorKind {
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>The requested subnet group name does not refer to an existing subnet group.</p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSubnetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSubnetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSubnetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeSubnetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSubnetGroupsError {
    /// Creates a new `DescribeSubnetGroupsError`.
    pub fn new(kind: DescribeSubnetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSubnetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSubnetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSubnetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSubnetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeSubnetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSubnetGroupsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            DescribeSubnetGroupsErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            DescribeSubnetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `IncreaseReplicationFactor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct IncreaseReplicationFactorError {
    /// Kind of error that occurred.
    pub kind: IncreaseReplicationFactorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `IncreaseReplicationFactor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum IncreaseReplicationFactorErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>There are not enough system resources to create the cluster you requested (or to resize an already-existing cluster). </p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The VPC network is in an invalid state.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>You have attempted to exceed the maximum number of nodes for a DAX cluster.</p>
    NodeQuotaForClusterExceededFault(crate::error::NodeQuotaForClusterExceededFault),
    /// <p>You have attempted to exceed the maximum number of nodes for your AWS account.</p>
    NodeQuotaForCustomerExceededFault(crate::error::NodeQuotaForCustomerExceededFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for IncreaseReplicationFactorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            IncreaseReplicationFactorErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            IncreaseReplicationFactorErrorKind::InsufficientClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            IncreaseReplicationFactorErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::NodeQuotaForClusterExceededFault(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::NodeQuotaForCustomerExceededFault(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            IncreaseReplicationFactorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for IncreaseReplicationFactorError {
    fn code(&self) -> Option<&str> {
        IncreaseReplicationFactorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl IncreaseReplicationFactorError {
    /// Creates a new `IncreaseReplicationFactorError`.
    pub fn new(kind: IncreaseReplicationFactorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `IncreaseReplicationFactorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: IncreaseReplicationFactorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `IncreaseReplicationFactorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: IncreaseReplicationFactorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::NodeQuotaForClusterExceededFault`.
    pub fn is_node_quota_for_cluster_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::NodeQuotaForClusterExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::NodeQuotaForCustomerExceededFault`.
    pub fn is_node_quota_for_customer_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::NodeQuotaForCustomerExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for IncreaseReplicationFactorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            IncreaseReplicationFactorErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            IncreaseReplicationFactorErrorKind::InsufficientClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            IncreaseReplicationFactorErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            IncreaseReplicationFactorErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            IncreaseReplicationFactorErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            IncreaseReplicationFactorErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            IncreaseReplicationFactorErrorKind::NodeQuotaForClusterExceededFault(_inner) => {
                Some(_inner)
            }
            IncreaseReplicationFactorErrorKind::NodeQuotaForCustomerExceededFault(_inner) => {
                Some(_inner)
            }
            IncreaseReplicationFactorErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => {
                Some(_inner)
            }
            IncreaseReplicationFactorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The Amazon Resource Name (ARN) supplied in the request is not valid.</p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidArnFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidArnFault`.
    pub fn is_invalid_arn_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidArnFault(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidClusterStateFault(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidArnFault(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootNodeError {
    /// Kind of error that occurred.
    pub kind: RebootNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootNodeErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>None of the nodes in the cluster have the given node ID.</p>
    NodeNotFoundFault(crate::error::NodeNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootNodeErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            RebootNodeErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            RebootNodeErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            RebootNodeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            RebootNodeErrorKind::NodeNotFoundFault(_inner) => _inner.fmt(f),
            RebootNodeErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            RebootNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootNodeError {
    fn code(&self) -> Option<&str> {
        RebootNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootNodeError {
    /// Creates a new `RebootNodeError`.
    pub fn new(kind: RebootNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootNodeErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, RebootNodeErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `RebootNodeErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(&self.kind, RebootNodeErrorKind::InvalidClusterStateFault(_))
    }
    /// Returns `true` if the error kind is `RebootNodeErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootNodeErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootNodeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootNodeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootNodeErrorKind::NodeNotFoundFault`.
    pub fn is_node_not_found_fault(&self) -> bool {
        matches!(&self.kind, RebootNodeErrorKind::NodeNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `RebootNodeErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootNodeErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for RebootNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootNodeErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            RebootNodeErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            RebootNodeErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            RebootNodeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            RebootNodeErrorKind::NodeNotFoundFault(_inner) => Some(_inner),
            RebootNodeErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            RebootNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The Amazon Resource Name (ARN) supplied in the request is not valid.</p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>You have exceeded the maximum number of tags for this DAX cluster.</p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArnFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagQuotaPerResourceExceeded(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidArnFault`.
    pub fn is_invalid_arn_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArnFault(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagQuotaPerResourceExceeded`.
    pub fn is_tag_quota_per_resource_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagQuotaPerResourceExceeded(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArnFault(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            TagResourceErrorKind::TagQuotaPerResourceExceeded(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The Amazon Resource Name (ARN) supplied in the request is not valid.</p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>The tag does not exist.</p>
    TagNotFoundFault(crate::error::TagNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArnFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagNotFoundFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidArnFault`.
    pub fn is_invalid_arn_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArnFault(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TagNotFoundFault`.
    pub fn is_tag_not_found_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TagNotFoundFault(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArnFault(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::TagNotFoundFault(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterErrorKind {
    /// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>One or more parameters in a parameter group are in an invalid state.</p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterError {
    fn code(&self) -> Option<&str> {
        UpdateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterError {
    /// Creates a new `UpdateClusterError`.
    pub fn new(kind: UpdateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for UpdateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateClusterErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UpdateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateParameterGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateParameterGroupErrorKind {
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>One or more parameters in a parameter group are in an invalid state.</p>
    InvalidParameterGroupStateFault(crate::error::InvalidParameterGroupStateFault),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified parameter group does not exist.</p>
    ParameterGroupNotFoundFault(crate::error::ParameterGroupNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UpdateParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateParameterGroupError {
    fn code(&self) -> Option<&str> {
        UpdateParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateParameterGroupError {
    /// Creates a new `UpdateParameterGroupError`.
    pub fn new(kind: UpdateParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateParameterGroupErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault`.
    pub fn is_invalid_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParameterGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault`.
    pub fn is_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
}
impl std::error::Error for UpdateParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateParameterGroupErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            UpdateParameterGroupErrorKind::InvalidParameterGroupStateFault(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::ParameterGroupNotFoundFault(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UpdateParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSubnetGroupErrorKind {
    /// <p>An invalid subnet identifier was specified.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>The requested subnet group name does not refer to an existing subnet group.</p>
    SubnetGroupNotFoundFault(crate::error::SubnetGroupNotFoundFault),
    /// <p>The requested subnet is being used by another subnet group.</p>
    SubnetInUse(crate::error::SubnetInUse),
    /// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
    SubnetQuotaExceededFault(crate::error::SubnetQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetInUse(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            UpdateSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSubnetGroupError {
    fn code(&self) -> Option<&str> {
        UpdateSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSubnetGroupError {
    /// Creates a new `UpdateSubnetGroupError`.
    pub fn new(kind: UpdateSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, UpdateSubnetGroupErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault`.
    pub fn is_service_linked_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault`.
    pub fn is_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubnetGroupErrorKind::SubnetInUse`.
    pub fn is_subnet_in_use(&self) -> bool {
        matches!(&self.kind, UpdateSubnetGroupErrorKind::SubnetInUse(_))
    }
    /// Returns `true` if the error kind is `UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault`.
    pub fn is_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for UpdateSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::ServiceLinkedRoleNotFoundFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetGroupNotFoundFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetInUse(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::SubnetQuotaExceededFault(_inner) => Some(_inner),
            UpdateSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetQuotaExceededFault")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetQuotaExceededFault {}
/// See [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
pub mod subnet_quota_exceeded_fault {
    /// A builder for [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
        pub fn build(self) -> crate::error::SubnetQuotaExceededFault {
            crate::error::SubnetQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SubnetQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SubnetQuotaExceededFault`](crate::error::SubnetQuotaExceededFault)
    pub fn builder() -> crate::error::subnet_quota_exceeded_fault::Builder {
        crate::error::subnet_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The requested subnet is being used by another subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetInUse")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetInUse {}
/// See [`SubnetInUse`](crate::error::SubnetInUse)
pub mod subnet_in_use {
    /// A builder for [`SubnetInUse`](crate::error::SubnetInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetInUse`](crate::error::SubnetInUse)
        pub fn build(self) -> crate::error::SubnetInUse {
            crate::error::SubnetInUse {
                message: self.message,
            }
        }
    }
}
impl SubnetInUse {
    /// Creates a new builder-style object to manufacture [`SubnetInUse`](crate::error::SubnetInUse)
    pub fn builder() -> crate::error::subnet_in_use::Builder {
        crate::error::subnet_in_use::Builder::default()
    }
}

/// <p>The requested subnet group name does not refer to an existing subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupNotFoundFault")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupNotFoundFault {}
/// See [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
pub mod subnet_group_not_found_fault {
    /// A builder for [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
        pub fn build(self) -> crate::error::SubnetGroupNotFoundFault {
            crate::error::SubnetGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupNotFoundFault`](crate::error::SubnetGroupNotFoundFault)
    pub fn builder() -> crate::error::subnet_group_not_found_fault::Builder {
        crate::error::subnet_group_not_found_fault::Builder::default()
    }
}

/// <p>The specified service linked role (SLR) was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLinkedRoleNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceLinkedRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLinkedRoleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLinkedRoleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLinkedRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLinkedRoleNotFoundFault")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLinkedRoleNotFoundFault {}
/// See [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
pub mod service_linked_role_not_found_fault {
    /// A builder for [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
        pub fn build(self) -> crate::error::ServiceLinkedRoleNotFoundFault {
            crate::error::ServiceLinkedRoleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ServiceLinkedRoleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ServiceLinkedRoleNotFoundFault`](crate::error::ServiceLinkedRoleNotFoundFault)
    pub fn builder() -> crate::error::service_linked_role_not_found_fault::Builder {
        crate::error::service_linked_role_not_found_fault::Builder::default()
    }
}

/// <p>An invalid subnet identifier was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnet {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnet")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnet {}
/// See [`InvalidSubnet`](crate::error::InvalidSubnet)
pub mod invalid_subnet {
    /// A builder for [`InvalidSubnet`](crate::error::InvalidSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnet`](crate::error::InvalidSubnet)
        pub fn build(self) -> crate::error::InvalidSubnet {
            crate::error::InvalidSubnet {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnet {
    /// Creates a new builder-style object to manufacture [`InvalidSubnet`](crate::error::InvalidSubnet)
    pub fn builder() -> crate::error::invalid_subnet::Builder {
        crate::error::invalid_subnet::Builder::default()
    }
}

/// <p>The specified parameter group does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterGroupNotFoundFault")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterGroupNotFoundFault {}
/// See [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
pub mod parameter_group_not_found_fault {
    /// A builder for [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::ParameterGroupNotFoundFault {
            crate::error::ParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ParameterGroupNotFoundFault`](crate::error::ParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::parameter_group_not_found_fault::Builder {
        crate::error::parameter_group_not_found_fault::Builder::default()
    }
}

/// <p>The value for a parameter is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>One or more parameters in a parameter group are in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterGroupStateFault")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterGroupStateFault {}
/// See [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
pub mod invalid_parameter_group_state_fault {
    /// A builder for [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
        pub fn build(self) -> crate::error::InvalidParameterGroupStateFault {
            crate::error::InvalidParameterGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidParameterGroupStateFault`](crate::error::InvalidParameterGroupStateFault)
    pub fn builder() -> crate::error::invalid_parameter_group_state_fault::Builder {
        crate::error::invalid_parameter_group_state_fault::Builder::default()
    }
}

/// <p>Two or more incompatible parameters were specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterCombinationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterCombinationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterCombinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterCombinationException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterCombinationException {}
/// See [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
pub mod invalid_parameter_combination_exception {
    /// A builder for [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
        pub fn build(self) -> crate::error::InvalidParameterCombinationException {
            crate::error::InvalidParameterCombinationException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterCombinationException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    pub fn builder() -> crate::error::invalid_parameter_combination_exception::Builder {
        crate::error::invalid_parameter_combination_exception::Builder::default()
    }
}

/// <p>The requested DAX cluster is not in the <i>available</i> state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterStateFault")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterStateFault {}
/// See [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
pub mod invalid_cluster_state_fault {
    /// A builder for [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
        pub fn build(self) -> crate::error::InvalidClusterStateFault {
            crate::error::InvalidClusterStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
    pub fn builder() -> crate::error::invalid_cluster_state_fault::Builder {
        crate::error::invalid_cluster_state_fault::Builder::default()
    }
}

/// <p>The requested cluster ID does not refer to an existing DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterNotFoundFault")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterNotFoundFault {}
/// See [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
pub mod cluster_not_found_fault {
    /// A builder for [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
        pub fn build(self) -> crate::error::ClusterNotFoundFault {
            crate::error::ClusterNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
    pub fn builder() -> crate::error::cluster_not_found_fault::Builder {
        crate::error::cluster_not_found_fault::Builder::default()
    }
}

/// <p>The tag does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagNotFoundFault")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagNotFoundFault {}
/// See [`TagNotFoundFault`](crate::error::TagNotFoundFault)
pub mod tag_not_found_fault {
    /// A builder for [`TagNotFoundFault`](crate::error::TagNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagNotFoundFault`](crate::error::TagNotFoundFault)
        pub fn build(self) -> crate::error::TagNotFoundFault {
            crate::error::TagNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl TagNotFoundFault {
    /// Creates a new builder-style object to manufacture [`TagNotFoundFault`](crate::error::TagNotFoundFault)
    pub fn builder() -> crate::error::tag_not_found_fault::Builder {
        crate::error::tag_not_found_fault::Builder::default()
    }
}

/// <p>The Amazon Resource Name (ARN) supplied in the request is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnFault [InvalidARNFault]")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnFault {}
/// See [`InvalidArnFault`](crate::error::InvalidArnFault)
pub mod invalid_arn_fault {
    /// A builder for [`InvalidArnFault`](crate::error::InvalidArnFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnFault`](crate::error::InvalidArnFault)
        pub fn build(self) -> crate::error::InvalidArnFault {
            crate::error::InvalidArnFault {
                message: self.message,
            }
        }
    }
}
impl InvalidArnFault {
    /// Creates a new builder-style object to manufacture [`InvalidArnFault`](crate::error::InvalidArnFault)
    pub fn builder() -> crate::error::invalid_arn_fault::Builder {
        crate::error::invalid_arn_fault::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of tags for this DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagQuotaPerResourceExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagQuotaPerResourceExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagQuotaPerResourceExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagQuotaPerResourceExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagQuotaPerResourceExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagQuotaPerResourceExceeded")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagQuotaPerResourceExceeded {}
/// See [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
pub mod tag_quota_per_resource_exceeded {
    /// A builder for [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
        pub fn build(self) -> crate::error::TagQuotaPerResourceExceeded {
            crate::error::TagQuotaPerResourceExceeded {
                message: self.message,
            }
        }
    }
}
impl TagQuotaPerResourceExceeded {
    /// Creates a new builder-style object to manufacture [`TagQuotaPerResourceExceeded`](crate::error::TagQuotaPerResourceExceeded)
    pub fn builder() -> crate::error::tag_quota_per_resource_exceeded::Builder {
        crate::error::tag_quota_per_resource_exceeded::Builder::default()
    }
}

/// <p>None of the nodes in the cluster have the given node ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NodeNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NodeNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NodeNotFoundFault")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for NodeNotFoundFault {}
/// See [`NodeNotFoundFault`](crate::error::NodeNotFoundFault)
pub mod node_not_found_fault {
    /// A builder for [`NodeNotFoundFault`](crate::error::NodeNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeNotFoundFault`](crate::error::NodeNotFoundFault)
        pub fn build(self) -> crate::error::NodeNotFoundFault {
            crate::error::NodeNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl NodeNotFoundFault {
    /// Creates a new builder-style object to manufacture [`NodeNotFoundFault`](crate::error::NodeNotFoundFault)
    pub fn builder() -> crate::error::node_not_found_fault::Builder {
        crate::error::node_not_found_fault::Builder::default()
    }
}

/// <p>You have attempted to exceed the maximum number of nodes for your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeQuotaForCustomerExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeQuotaForCustomerExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NodeQuotaForCustomerExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NodeQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NodeQuotaForCustomerExceededFault")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for NodeQuotaForCustomerExceededFault {}
/// See [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
pub mod node_quota_for_customer_exceeded_fault {
    /// A builder for [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
        pub fn build(self) -> crate::error::NodeQuotaForCustomerExceededFault {
            crate::error::NodeQuotaForCustomerExceededFault {
                message: self.message,
            }
        }
    }
}
impl NodeQuotaForCustomerExceededFault {
    /// Creates a new builder-style object to manufacture [`NodeQuotaForCustomerExceededFault`](crate::error::NodeQuotaForCustomerExceededFault)
    pub fn builder() -> crate::error::node_quota_for_customer_exceeded_fault::Builder {
        crate::error::node_quota_for_customer_exceeded_fault::Builder::default()
    }
}

/// <p>You have attempted to exceed the maximum number of nodes for a DAX cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeQuotaForClusterExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeQuotaForClusterExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeQuotaForClusterExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NodeQuotaForClusterExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NodeQuotaForClusterExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NodeQuotaForClusterExceededFault")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for NodeQuotaForClusterExceededFault {}
/// See [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
pub mod node_quota_for_cluster_exceeded_fault {
    /// A builder for [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
        pub fn build(self) -> crate::error::NodeQuotaForClusterExceededFault {
            crate::error::NodeQuotaForClusterExceededFault {
                message: self.message,
            }
        }
    }
}
impl NodeQuotaForClusterExceededFault {
    /// Creates a new builder-style object to manufacture [`NodeQuotaForClusterExceededFault`](crate::error::NodeQuotaForClusterExceededFault)
    pub fn builder() -> crate::error::node_quota_for_cluster_exceeded_fault::Builder {
        crate::error::node_quota_for_cluster_exceeded_fault::Builder::default()
    }
}

/// <p>The VPC network is in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidVpcNetworkStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidVpcNetworkStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidVpcNetworkStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidVpcNetworkStateFault [InvalidVPCNetworkStateFault]"
        )?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidVpcNetworkStateFault {}
/// See [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
pub mod invalid_vpc_network_state_fault {
    /// A builder for [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
        pub fn build(self) -> crate::error::InvalidVpcNetworkStateFault {
            crate::error::InvalidVpcNetworkStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidVpcNetworkStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    pub fn builder() -> crate::error::invalid_vpc_network_state_fault::Builder {
        crate::error::invalid_vpc_network_state_fault::Builder::default()
    }
}

/// <p>There are not enough system resources to create the cluster you requested (or to resize an already-existing cluster). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientClusterCapacityFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientClusterCapacityFault")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientClusterCapacityFault {}
/// See [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
pub mod insufficient_cluster_capacity_fault {
    /// A builder for [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientClusterCapacityFault {
            crate::error::InsufficientClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_cluster_capacity_fault::Builder {
        crate::error::insufficient_cluster_capacity_fault::Builder::default()
    }
}

/// <p>The specified subnet group is currently in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupInUseFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupInUseFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupInUseFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupInUseFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupInUseFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupInUseFault")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupInUseFault {}
/// See [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
pub mod subnet_group_in_use_fault {
    /// A builder for [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
        pub fn build(self) -> crate::error::SubnetGroupInUseFault {
            crate::error::SubnetGroupInUseFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupInUseFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupInUseFault`](crate::error::SubnetGroupInUseFault)
    pub fn builder() -> crate::error::subnet_group_in_use_fault::Builder {
        crate::error::subnet_group_in_use_fault::Builder::default()
    }
}

/// <p>The request cannot be processed because it would exceed the allowed number of subnets in a subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupQuotaExceededFault")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupQuotaExceededFault {}
/// See [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
pub mod subnet_group_quota_exceeded_fault {
    /// A builder for [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::SubnetGroupQuotaExceededFault {
            crate::error::SubnetGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupQuotaExceededFault`](crate::error::SubnetGroupQuotaExceededFault)
    pub fn builder() -> crate::error::subnet_group_quota_exceeded_fault::Builder {
        crate::error::subnet_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The specified subnet group already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetGroupAlreadyExistsFault")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetGroupAlreadyExistsFault {}
/// See [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
pub mod subnet_group_already_exists_fault {
    /// A builder for [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::SubnetGroupAlreadyExistsFault {
            crate::error::SubnetGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl SubnetGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`SubnetGroupAlreadyExistsFault`](crate::error::SubnetGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::subnet_group_already_exists_fault::Builder {
        crate::error::subnet_group_already_exists_fault::Builder::default()
    }
}

/// <p>You have attempted to exceed the maximum number of parameter groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterGroupQuotaExceededFault")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterGroupQuotaExceededFault {}
/// See [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
pub mod parameter_group_quota_exceeded_fault {
    /// A builder for [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::ParameterGroupQuotaExceededFault {
            crate::error::ParameterGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ParameterGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ParameterGroupQuotaExceededFault`](crate::error::ParameterGroupQuotaExceededFault)
    pub fn builder() -> crate::error::parameter_group_quota_exceeded_fault::Builder {
        crate::error::parameter_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The specified parameter group already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterGroupAlreadyExistsFault")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterGroupAlreadyExistsFault {}
/// See [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
pub mod parameter_group_already_exists_fault {
    /// A builder for [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::ParameterGroupAlreadyExistsFault {
            crate::error::ParameterGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ParameterGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ParameterGroupAlreadyExistsFault`](crate::error::ParameterGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::parameter_group_already_exists_fault::Builder {
        crate::error::parameter_group_already_exists_fault::Builder::default()
    }
}

/// <p>You have reached the maximum number of x509 certificates that can be created for encrypted clusters in a 30 day period. Contact AWS customer support to discuss options for continuing to create encrypted clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>You have attempted to exceed the maximum number of DAX clusters for your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterQuotaForCustomerExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterQuotaForCustomerExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterQuotaForCustomerExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterQuotaForCustomerExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterQuotaForCustomerExceededFault")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterQuotaForCustomerExceededFault {}
/// See [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
pub mod cluster_quota_for_customer_exceeded_fault {
    /// A builder for [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
        pub fn build(self) -> crate::error::ClusterQuotaForCustomerExceededFault {
            crate::error::ClusterQuotaForCustomerExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterQuotaForCustomerExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterQuotaForCustomerExceededFault`](crate::error::ClusterQuotaForCustomerExceededFault)
    pub fn builder() -> crate::error::cluster_quota_for_customer_exceeded_fault::Builder {
        crate::error::cluster_quota_for_customer_exceeded_fault::Builder::default()
    }
}

/// <p>You already have a DAX cluster with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterAlreadyExistsFault")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterAlreadyExistsFault {}
/// See [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
pub mod cluster_already_exists_fault {
    /// A builder for [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterAlreadyExistsFault {
            crate::error::ClusterAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_already_exists_fault::Builder {
        crate::error::cluster_already_exists_fault::Builder::default()
    }
}
