// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon DynamoDB Accelerator (DAX)
///
/// Client for invoking operations on Amazon DynamoDB Accelerator (DAX). Each operation on Amazon DynamoDB Accelerator (DAX) is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_dax::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_dax::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_dax::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateCluster` operation.
    ///
    /// See [`CreateCluster`](crate::client::fluent_builders::CreateCluster) for more information about the
    /// operation and its arguments.
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster<C, M, R> {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateParameterGroup` operation.
    ///
    /// See [`CreateParameterGroup`](crate::client::fluent_builders::CreateParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_parameter_group(&self) -> fluent_builders::CreateParameterGroup<C, M, R> {
        fluent_builders::CreateParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubnetGroup` operation.
    ///
    /// See [`CreateSubnetGroup`](crate::client::fluent_builders::CreateSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_subnet_group(&self) -> fluent_builders::CreateSubnetGroup<C, M, R> {
        fluent_builders::CreateSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DecreaseReplicationFactor` operation.
    ///
    /// See [`DecreaseReplicationFactor`](crate::client::fluent_builders::DecreaseReplicationFactor) for more information about the
    /// operation and its arguments.
    pub fn decrease_replication_factor(
        &self,
    ) -> fluent_builders::DecreaseReplicationFactor<C, M, R> {
        fluent_builders::DecreaseReplicationFactor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCluster` operation.
    ///
    /// See [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster<C, M, R> {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteParameterGroup` operation.
    ///
    /// See [`DeleteParameterGroup`](crate::client::fluent_builders::DeleteParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_parameter_group(&self) -> fluent_builders::DeleteParameterGroup<C, M, R> {
        fluent_builders::DeleteParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubnetGroup` operation.
    ///
    /// See [`DeleteSubnetGroup`](crate::client::fluent_builders::DeleteSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_subnet_group(&self) -> fluent_builders::DeleteSubnetGroup<C, M, R> {
        fluent_builders::DeleteSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusters` operation.
    ///
    /// See [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters<C, M, R> {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDefaultParameters` operation.
    ///
    /// See [`DescribeDefaultParameters`](crate::client::fluent_builders::DescribeDefaultParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_default_parameters(
        &self,
    ) -> fluent_builders::DescribeDefaultParameters<C, M, R> {
        fluent_builders::DescribeDefaultParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeParameterGroups` operation.
    ///
    /// See [`DescribeParameterGroups`](crate::client::fluent_builders::DescribeParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_parameter_groups(&self) -> fluent_builders::DescribeParameterGroups<C, M, R> {
        fluent_builders::DescribeParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeParameters` operation.
    ///
    /// See [`DescribeParameters`](crate::client::fluent_builders::DescribeParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_parameters(&self) -> fluent_builders::DescribeParameters<C, M, R> {
        fluent_builders::DescribeParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSubnetGroups` operation.
    ///
    /// See [`DescribeSubnetGroups`](crate::client::fluent_builders::DescribeSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_subnet_groups(&self) -> fluent_builders::DescribeSubnetGroups<C, M, R> {
        fluent_builders::DescribeSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `IncreaseReplicationFactor` operation.
    ///
    /// See [`IncreaseReplicationFactor`](crate::client::fluent_builders::IncreaseReplicationFactor) for more information about the
    /// operation and its arguments.
    pub fn increase_replication_factor(
        &self,
    ) -> fluent_builders::IncreaseReplicationFactor<C, M, R> {
        fluent_builders::IncreaseReplicationFactor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootNode` operation.
    ///
    /// See [`RebootNode`](crate::client::fluent_builders::RebootNode) for more information about the
    /// operation and its arguments.
    pub fn reboot_node(&self) -> fluent_builders::RebootNode<C, M, R> {
        fluent_builders::RebootNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCluster` operation.
    ///
    /// See [`UpdateCluster`](crate::client::fluent_builders::UpdateCluster) for more information about the
    /// operation and its arguments.
    pub fn update_cluster(&self) -> fluent_builders::UpdateCluster<C, M, R> {
        fluent_builders::UpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateParameterGroup` operation.
    ///
    /// See [`UpdateParameterGroup`](crate::client::fluent_builders::UpdateParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn update_parameter_group(&self) -> fluent_builders::UpdateParameterGroup<C, M, R> {
        fluent_builders::UpdateParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSubnetGroup` operation.
    ///
    /// See [`UpdateSubnetGroup`](crate::client::fluent_builders::UpdateSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn update_subnet_group(&self) -> fluent_builders::UpdateSubnetGroup<C, M, R> {
        fluent_builders::UpdateSubnetGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a DAX cluster. All nodes in the cluster run the same DAX caching software.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl<C, M, R> CreateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterInputOperationOutputAlias,
                crate::output::CreateClusterOutput,
                crate::error::CreateClusterError,
                crate::input::CreateClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p> <b>Constraints:</b> </p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 20 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p> <b>Constraints:</b> </p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 20 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>A description of the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without any read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more read replicas. To do this, set <code>ReplicationFactor</code> to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas). <code>If the AvailabilityZones</code> parameter is provided, its length must equal the <code>ReplicationFactor</code>.</p> <note>
        /// <p>AWS recommends that you have at least two read replicas per cluster.</p>
        /// </note>
        pub fn replication_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.replication_factor(input);
            self
        }
        /// <p>The number of nodes in the DAX cluster. A replication factor of 1 will create a single-node cluster, without any read replicas. For additional fault tolerance, you can create a multiple node cluster with one or more read replicas. To do this, set <code>ReplicationFactor</code> to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas). <code>If the AvailabilityZones</code> parameter is provided, its length must equal the <code>ReplicationFactor</code>.</p> <note>
        /// <p>AWS recommends that you have at least two read replicas per cluster.</p>
        /// </note>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_replication_factor(input);
            self
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>The Availability Zones (AZs) in which the cluster nodes will reside after the cluster has been created or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter. If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The name of the subnet group to be used for the replication group.</p> <important>
        /// <p>DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group must exist in the same VPC.</p>
        /// </important>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to be used for the replication group.</p> <important>
        /// <p>DAX clusters can only run in an Amazon VPC environment. All of the subnets that you specify in a subnet group must exist in the same VPC.</p>
        /// </important>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID is system-generated.)</p>
        /// <p>If this parameter is not specified, DAX assigns the default VPC security group to each node.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the security group ID is system-generated.)</p>
        /// <p>If this parameter is not specified, DAX assigns the default VPC security group to each node.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:05:00-sun:09:00</code> </p> <note>
        /// <p>If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day of the week.</p>
        /// </note>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the DAX cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:05:00-sun:09:00</code> </p> <note>
        /// <p>If you don't specify a preferred maintenance window when you create or modify a cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day of the week.</p>
        /// </note>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the DAX cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will be sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the DAX cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_arn(input);
            self
        }
        /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX will assume this role and use the role's permissions to access DynamoDB on your behalf.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The parameter group to be associated with the DAX cluster.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The parameter group to be associated with the DAX cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to associate with the DAX cluster. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of tags to associate with the DAX cluster. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption on the cluster.</p>
        pub fn sse_specification(mut self, input: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption on the cluster.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification(input);
            self
        }
        /// <p>The type of encryption the cluster's endpoint should support. Values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> for no encryption</p> </li>
        /// <li> <p> <code>TLS</code> for Transport Layer Security</p> </li>
        /// </ul>
        pub fn cluster_endpoint_encryption_type(
            mut self,
            input: crate::model::ClusterEndpointEncryptionType,
        ) -> Self {
            self.inner = self.inner.cluster_endpoint_encryption_type(input);
            self
        }
        /// <p>The type of encryption the cluster's endpoint should support. Values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> for no encryption</p> </li>
        /// <li> <p> <code>TLS</code> for Transport Layer Security</p> </li>
        /// </ul>
        pub fn set_cluster_endpoint_encryption_type(
            mut self,
            input: std::option::Option<crate::model::ClusterEndpointEncryptionType>,
        ) -> Self {
            self.inner = self.inner.set_cluster_endpoint_encryption_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateParameterGroup`.
    ///
    /// <p>Creates a new parameter group. A parameter group is a collection of parameters that you apply to all of the nodes in a DAX cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateParameterGroupInputOperationOutputAlias,
                crate::output::CreateParameterGroupOutput,
                crate::error::CreateParameterGroupError,
                crate::input::CreateParameterGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to apply to all of the clusters in this replication group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to apply to all of the clusters in this replication group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubnetGroup`.
    ///
    /// <p>Creates a new subnet group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubnetGroupInputOperationOutputAlias,
                crate::output::CreateSubnetGroupOutput,
                crate::error::CreateSubnetGroupError,
                crate::input::CreateSubnetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the subnet group. This value is stored as a lowercase string. </p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>A name for the subnet group. This value is stored as a lowercase string. </p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>A description for the subnet group</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the subnet group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DecreaseReplicationFactor`.
    ///
    /// <p>Removes one or more nodes from a DAX cluster.</p> <note>
    /// <p>You cannot use <code>DecreaseReplicationFactor</code> to remove the last node in a DAX cluster. If you need to do this, use <code>DeleteCluster</code> instead.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DecreaseReplicationFactor<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::decrease_replication_factor_input::Builder,
    }
    impl<C, M, R> DecreaseReplicationFactor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DecreaseReplicationFactor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DecreaseReplicationFactorOutput,
            aws_smithy_http::result::SdkError<crate::error::DecreaseReplicationFactorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DecreaseReplicationFactorInputOperationOutputAlias,
                crate::output::DecreaseReplicationFactorOutput,
                crate::error::DecreaseReplicationFactorError,
                crate::input::DecreaseReplicationFactorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX cluster from which you want to remove nodes.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the DAX cluster from which you want to remove nodes.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn new_replication_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.new_replication_factor(input);
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn set_new_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_new_replication_factor(input);
            self
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zone(s) from which to remove nodes.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>The Availability Zone(s) from which to remove nodes.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// Appends an item to `NodeIdsToRemove`.
        ///
        /// To override the contents of this collection use [`set_node_ids_to_remove`](Self::set_node_ids_to_remove).
        ///
        /// <p>The unique identifiers of the nodes to be removed from the cluster.</p>
        pub fn node_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_ids_to_remove(input.into());
            self
        }
        /// <p>The unique identifiers of the nodes to be removed from the cluster.</p>
        pub fn set_node_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_node_ids_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes a previously provisioned DAX cluster. <i>DeleteCluster</i> deletes all associated nodes, node endpoints and the DAX cluster itself. When you receive a successful response from this action, DAX immediately begins deleting the cluster; you cannot cancel or revert this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl<C, M, R> DeleteCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterInputOperationOutputAlias,
                crate::output::DeleteClusterOutput,
                crate::error::DeleteClusterError,
                crate::input::DeleteClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to be deleted.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to be deleted.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameterGroup`.
    ///
    /// <p>Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any DAX clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteParameterGroupInputOperationOutputAlias,
                crate::output::DeleteParameterGroupOutput,
                crate::error::DeleteParameterGroupError,
                crate::input::DeleteParameterGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubnetGroup`.
    ///
    /// <p>Deletes a subnet group.</p> <note>
    /// <p>You cannot delete a subnet group if it is associated with any DAX clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteSubnetGroupOutput,
                crate::error::DeleteSubnetGroupError,
                crate::input::DeleteSubnetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to delete.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to delete.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Returns information about all provisioned DAX clusters if no cluster identifier is specified, or about a specific DAX cluster if a cluster identifier is supplied.</p>
    /// <p>If the cluster is in the CREATING state, only cluster level information will be displayed until all of the nodes are successfully provisioned.</p>
    /// <p>If the cluster is in the DELETING state, only cluster level information will be displayed.</p>
    /// <p>If nodes are currently being added to the DAX cluster, node endpoint information and creation time for the additional nodes will not be displayed until they are completely provisioned. When the DAX cluster state is <i>available</i>, the cluster is ready for use.</p>
    /// <p>If nodes are currently being removed from the DAX cluster, no endpoint information for the removed nodes is displayed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl<C, M, R> DescribeClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClustersInputOperationOutputAlias,
                crate::output::DescribeClustersOutput,
                crate::error::DescribeClustersError,
                crate::input::DescribeClustersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ClusterNames`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The names of the DAX clusters being described.</p>
        pub fn cluster_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_names(input.into());
            self
        }
        /// <p>The names of the DAX clusters being described.</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_names(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultParameters`.
    ///
    /// <p>Returns the default system parameter information for the DAX caching software.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDefaultParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_default_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDefaultParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDefaultParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDefaultParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDefaultParametersInputOperationOutputAlias,
                crate::output::DescribeDefaultParametersOutput,
                crate::error::DescribeDefaultParametersError,
                crate::input::DescribeDefaultParametersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to DAX clusters and parameter groups. You can obtain events specific to a particular DAX cluster or parameter group by providing the name as a parameter.</p>
    /// <p>By default, only the events occurring within the last 24 hours are returned; however, you can retrieve up to 14 days' worth of events if necessary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events will be returned. If not specified, then all sources are included in the response.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_name(input.into());
            self
        }
        /// <p>The identifier of the event source for which events will be returned. If not specified, then all sources are included in the response.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_name(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes' worth of events to retrieve.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The number of minutes' worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameterGroups`.
    ///
    /// <p>Returns a list of parameter group descriptions. If a parameter group name is specified, the list will contain only the descriptions for that group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeParameterGroupsOutput,
                crate::error::DescribeParameterGroupsError,
                crate::input::DescribeParameterGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ParameterGroupNames`.
        ///
        /// To override the contents of this collection use [`set_parameter_group_names`](Self::set_parameter_group_names).
        ///
        /// <p>The names of the parameter groups.</p>
        pub fn parameter_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_names(input.into());
            self
        }
        /// <p>The names of the parameter groups.</p>
        pub fn set_parameter_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_names(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_parameters_input::Builder,
    }
    impl<C, M, R> DescribeParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeParametersInputOperationOutputAlias,
                crate::output::DescribeParametersOutput,
                crate::error::DescribeParametersError,
                crate::input::DescribeParametersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>How the parameter is defined. For example, <code>system</code> denotes a system-defined parameter.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubnetGroups`.
    ///
    /// <p>Returns a list of subnet group descriptions. If a subnet group name is specified, the list will contain only the description of that group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeSubnetGroupsOutput,
                crate::error::DescribeSubnetGroupsError,
                crate::input::DescribeSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SubnetGroupNames`.
        ///
        /// To override the contents of this collection use [`set_subnet_group_names`](Self::set_subnet_group_names).
        ///
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_names(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_names(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IncreaseReplicationFactor`.
    ///
    /// <p>Adds one or more nodes to a DAX cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct IncreaseReplicationFactor<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::increase_replication_factor_input::Builder,
    }
    impl<C, M, R> IncreaseReplicationFactor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `IncreaseReplicationFactor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IncreaseReplicationFactorOutput,
            aws_smithy_http::result::SdkError<crate::error::IncreaseReplicationFactorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::IncreaseReplicationFactorInputOperationOutputAlias,
                crate::output::IncreaseReplicationFactorOutput,
                crate::error::IncreaseReplicationFactorError,
                crate::input::IncreaseReplicationFactorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX cluster that will receive additional nodes.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the DAX cluster that will receive additional nodes.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn new_replication_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.new_replication_factor(input);
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn set_new_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_new_replication_factor(input);
            self
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the cluster are placed in these Availability Zones. Use this parameter if you want to distribute the nodes across multiple AZs.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>The Availability Zones (AZs) in which the cluster nodes will be created. All nodes belonging to the cluster are placed in these Availability Zones. Use this parameter if you want to distribute the nodes across multiple AZs.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>List all of the tags for a DAX cluster. You can call <code>ListTags</code> up to 10 times per second, per account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX resource to which the tags belong.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the DAX resource to which the tags belong.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootNode`.
    ///
    /// <p>Reboots a single node of a DAX cluster. The reboot action takes place as soon as possible. During the reboot, the node status is set to REBOOTING.</p> <note>
    /// <p> <code>RebootNode</code> restarts the DAX engine process and does not remove the contents of the cache. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootNode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_node_input::Builder,
    }
    impl<C, M, R> RebootNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootNodeInputOperationOutputAlias,
                crate::output::RebootNodeOutput,
                crate::error::RebootNodeError,
                crate::input::RebootNodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX cluster containing the node to be rebooted.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the DAX cluster containing the node to be rebooted.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The system-assigned ID of the node to be rebooted.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>The system-assigned ID of the node to be rebooted.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a set of tags with a DAX resource. You can call <code>TagResource</code> up to 5 times per second, per account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX resource to which tags should be added.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the DAX resource to which tags should be added.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DAX resource. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the DAX resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association of tags from a DAX resource. You can call <code>UntagResource</code> up to 5 times per second, per account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX resource from which the tags should be removed.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The name of the DAX resource from which the tags should be removed.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCluster`.
    ///
    /// <p>Modifies the settings for a DAX cluster. You can use this action to change one or more cluster configuration parameters by specifying the parameters and the new values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cluster_input::Builder,
    }
    impl<C, M, R> UpdateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClusterInputOperationOutputAlias,
                crate::output::UpdateClusterOutput,
                crate::error::UpdateClusterError,
                crate::input::UpdateClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DAX cluster to be modified.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the DAX cluster to be modified.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>A description of the changes being made to the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the changes being made to the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A range of time when maintenance of DAX cluster software will be performed. For example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>A range of time when maintenance of DAX cluster software will be performed. For example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than 30 minutes, and is performed automatically within the maintenance window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_arn(input);
            self
        }
        /// <p>The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.</p>
        pub fn notification_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_status(input.into());
            self
        }
        /// <p>The current state of the topic. A value of “active” means that notifications will be sent to the topic. A value of “inactive” means that notifications will not be sent to the topic.</p>
        pub fn set_notification_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_status(input);
            self
        }
        /// <p>The name of a parameter group for this cluster.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of a parameter group for this cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter is not specified, DAX assigns the default VPC security group to each node.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of user-specified security group IDs to be assigned to each node in the DAX cluster. If this parameter is not specified, DAX assigns the default VPC security group to each node.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateParameterGroup`.
    ///
    /// <p>Modifies the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_parameter_group_input::Builder,
    }
    impl<C, M, R> UpdateParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateParameterGroupInputOperationOutputAlias,
                crate::output::UpdateParameterGroupOutput,
                crate::error::UpdateParameterGroupError,
                crate::input::UpdateParameterGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `ParameterNameValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of name-value pairs for the parameters in the group. Each element in the array represents a single parameter.</p> <note>
        /// <p> <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more details, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl">Configuring TTL Settings</a>.</p>
        /// </note>
        pub fn parameter_name_values(mut self, input: crate::model::ParameterNameValue) -> Self {
            self.inner = self.inner.parameter_name_values(input);
            self
        }
        /// <p>An array of name-value pairs for the parameters in the group. Each element in the array represents a single parameter.</p> <note>
        /// <p> <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more details, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl">Configuring TTL Settings</a>.</p>
        /// </note>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_name_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubnetGroup`.
    ///
    /// <p>Modifies an existing subnet group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_subnet_group_input::Builder,
    }
    impl<C, M, R> UpdateSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSubnetGroupInputOperationOutputAlias,
                crate::output::UpdateSubnetGroupOutput,
                crate::error::UpdateSubnetGroupError,
                crate::input::UpdateSubnetGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// <p>A description of the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs in the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of subnet IDs in the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
