// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateClusterInput`](crate::input::CreateClusterInput)
pub mod create_cluster_input {
    /// A builder for [`CreateClusterInput`](crate::input::CreateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) replication_factor: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) sse_specification: std::option::Option<crate::model::SseSpecification>,
        pub(crate) cluster_endpoint_encryption_type:
            std::option::Option<crate::model::ClusterEndpointEncryptionType>,
    }
    impl Builder {
        /// <p>The cluster identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>
        /// <b>Constraints:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>A name must contain from 1 to 20 alphanumeric characters or
        /// hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>A name cannot end with a hyphen or contain two consecutive
        /// hyphens.</p>
        /// </li>
        /// </ul>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>
        /// <b>Constraints:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>A name must contain from 1 to 20 alphanumeric characters or
        /// hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>A name cannot end with a hyphen or contain two consecutive
        /// hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>A description of the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of nodes in the DAX cluster. A replication factor of 1 will
        /// create a single-node cluster, without any read replicas. For additional fault tolerance,
        /// you can create a multiple node cluster with one or more read replicas. To do this, set
        /// <code>ReplicationFactor</code> to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas).
        /// <code>If the AvailabilityZones</code> parameter is provided, its length must equal the <code>ReplicationFactor</code>.</p>
        /// <note>
        /// <p>AWS recommends that you have at least two read replicas per cluster.</p>
        /// </note>
        pub fn replication_factor(mut self, input: i32) -> Self {
            self.replication_factor = Some(input);
            self
        }
        /// <p>The number of nodes in the DAX cluster. A replication factor of 1 will
        /// create a single-node cluster, without any read replicas. For additional fault tolerance,
        /// you can create a multiple node cluster with one or more read replicas. To do this, set
        /// <code>ReplicationFactor</code> to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas).
        /// <code>If the AvailabilityZones</code> parameter is provided, its length must equal the <code>ReplicationFactor</code>.</p>
        /// <note>
        /// <p>AWS recommends that you have at least two read replicas per cluster.</p>
        /// </note>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.replication_factor = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones (AZs) in which the cluster nodes will reside after the cluster
        /// has been created or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter.
        /// If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones (AZs) in which the cluster nodes will reside after the cluster
        /// has been created or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter.
        /// If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The name of the subnet group to be used for the replication group.</p>
        /// <important>
        /// <p>DAX clusters can only run in an Amazon VPC environment. All of the subnets
        /// that you specify in a subnet group must exist in the same VPC.</p>
        /// </important>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to be used for the replication group.</p>
        /// <important>
        /// <p>DAX clusters can only run in an Amazon VPC environment. All of the subnets
        /// that you specify in a subnet group must exist in the same VPC.</p>
        /// </important>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the
        /// security group ID is system-generated.)</p>
        /// <p>If this parameter is not specified, DAX assigns the default VPC security group to
        /// each node.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the
        /// security group ID is system-generated.)</p>
        /// <p>If this parameter is not specified, DAX assigns the default VPC security group to
        /// each node.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the DAX cluster is
        /// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock
        /// UTC). The minimum maintenance window is a 60 minute period. Valid values for
        /// <code>ddd</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sun</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tue</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>wed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>thu</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fri</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sat</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>sun:05:00-sun:09:00</code>
        /// </p>
        /// <note>
        /// <p>If you don't specify a preferred maintenance window when you create or modify a
        /// cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day
        /// of the week.</p>
        /// </note>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the DAX cluster is
        /// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock
        /// UTC). The minimum maintenance window is a 60 minute period. Valid values for
        /// <code>ddd</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sun</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tue</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>wed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>thu</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>fri</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sat</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>sun:05:00-sun:09:00</code>
        /// </p>
        /// <note>
        /// <p>If you don't specify a preferred maintenance window when you create or modify a
        /// cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day
        /// of the week.</p>
        /// </note>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will
        /// be sent.</p>
        /// <note>
        /// <p>The Amazon SNS topic owner must be same as the DAX cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will
        /// be sent.</p>
        /// <note>
        /// <p>The Amazon SNS topic owner must be same as the DAX cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX
        /// will assume this role and use the role's permissions to access DynamoDB on your
        /// behalf.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX
        /// will assume this role and use the role's permissions to access DynamoDB on your
        /// behalf.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The parameter group to be associated with the DAX cluster.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The parameter group to be associated with the DAX cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to associate with the DAX cluster.  </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A set of tags to associate with the DAX cluster.  </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Represents the settings used to enable server-side encryption on the cluster.</p>
        pub fn sse_specification(mut self, input: crate::model::SseSpecification) -> Self {
            self.sse_specification = Some(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption on the cluster.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.sse_specification = input;
            self
        }
        /// <p>The type of encryption the cluster's endpoint should support. Values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> for no encryption</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TLS</code> for Transport Layer Security</p>
        /// </li>
        /// </ul>
        pub fn cluster_endpoint_encryption_type(
            mut self,
            input: crate::model::ClusterEndpointEncryptionType,
        ) -> Self {
            self.cluster_endpoint_encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption the cluster's endpoint should support. Values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> for no encryption</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TLS</code> for Transport Layer Security</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_endpoint_encryption_type(
            mut self,
            input: std::option::Option<crate::model::ClusterEndpointEncryptionType>,
        ) -> Self {
            self.cluster_endpoint_encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterInput`](crate::input::CreateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterInput {
                cluster_name: self.cluster_name,
                node_type: self.node_type,
                description: self.description,
                replication_factor: self.replication_factor.unwrap_or_default(),
                availability_zones: self.availability_zones,
                subnet_group_name: self.subnet_group_name,
                security_group_ids: self.security_group_ids,
                preferred_maintenance_window: self.preferred_maintenance_window,
                notification_topic_arn: self.notification_topic_arn,
                iam_role_arn: self.iam_role_arn,
                parameter_group_name: self.parameter_group_name,
                tags: self.tags,
                sse_specification: self.sse_specification,
                cluster_endpoint_encryption_type: self.cluster_endpoint_encryption_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterInputOperationOutputAlias = crate::operation::CreateCluster;
#[doc(hidden)]
pub type CreateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCluster`](crate::operation::CreateCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.CreateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCluster",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
}

/// See [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
pub mod create_parameter_group_input {
    /// A builder for [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group to apply to all of the clusters in this replication
        /// group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to apply to all of the clusters in this replication
        /// group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateParameterGroupInputOperationOutputAlias = crate::operation::CreateParameterGroup;
#[doc(hidden)]
pub type CreateParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateParameterGroup`](crate::operation::CreateParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.CreateParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_parameter_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateParameterGroup",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateParameterGroupInput`](crate::input::CreateParameterGroupInput)
    pub fn builder() -> crate::input::create_parameter_group_input::Builder {
        crate::input::create_parameter_group_input::Builder::default()
    }
}

/// See [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
pub mod create_subnet_group_input {
    /// A builder for [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A name for the subnet group. This value is stored as a lowercase string. </p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>A name for the subnet group. This value is stored as a lowercase string. </p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>A description for the subnet group</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the subnet group</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of VPC subnet IDs for the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSubnetGroupInput {
                subnet_group_name: self.subnet_group_name,
                description: self.description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSubnetGroupInputOperationOutputAlias = crate::operation::CreateSubnetGroup;
#[doc(hidden)]
pub type CreateSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateSubnetGroup`](crate::operation::CreateSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.CreateSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_subnet_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSubnetGroup",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSubnetGroupInput`](crate::input::CreateSubnetGroupInput)
    pub fn builder() -> crate::input::create_subnet_group_input::Builder {
        crate::input::create_subnet_group_input::Builder::default()
    }
}

/// See [`DecreaseReplicationFactorInput`](crate::input::DecreaseReplicationFactorInput)
pub mod decrease_replication_factor_input {
    /// A builder for [`DecreaseReplicationFactorInput`](crate::input::DecreaseReplicationFactorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) new_replication_factor: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) node_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the DAX cluster from which you want to remove nodes.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX cluster from which you want to remove nodes.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn new_replication_factor(mut self, input: i32) -> Self {
            self.new_replication_factor = Some(input);
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn set_new_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.new_replication_factor = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zone(s) from which to remove nodes.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zone(s) from which to remove nodes.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `node_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_node_ids_to_remove`](Self::set_node_ids_to_remove).
        ///
        /// <p>The unique identifiers of the nodes to be removed from the cluster.</p>
        pub fn node_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.node_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.node_ids_to_remove = Some(v);
            self
        }
        /// <p>The unique identifiers of the nodes to be removed from the cluster.</p>
        pub fn set_node_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.node_ids_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`DecreaseReplicationFactorInput`](crate::input::DecreaseReplicationFactorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DecreaseReplicationFactorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DecreaseReplicationFactorInput {
                cluster_name: self.cluster_name,
                new_replication_factor: self.new_replication_factor.unwrap_or_default(),
                availability_zones: self.availability_zones,
                node_ids_to_remove: self.node_ids_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type DecreaseReplicationFactorInputOperationOutputAlias =
    crate::operation::DecreaseReplicationFactor;
#[doc(hidden)]
pub type DecreaseReplicationFactorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DecreaseReplicationFactorInput {
    /// Consumes the builder and constructs an Operation<[`DecreaseReplicationFactor`](crate::operation::DecreaseReplicationFactor)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DecreaseReplicationFactor,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DecreaseReplicationFactorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DecreaseReplicationFactorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DecreaseReplicationFactorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DecreaseReplicationFactor",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_decrease_replication_factor(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DecreaseReplicationFactor::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DecreaseReplicationFactor",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DecreaseReplicationFactorInput`](crate::input::DecreaseReplicationFactorInput)
    pub fn builder() -> crate::input::decrease_replication_factor_input::Builder {
        crate::input::decrease_replication_factor_input::Builder::default()
    }
}

/// See [`DeleteClusterInput`](crate::input::DeleteClusterInput)
pub mod delete_cluster_input {
    /// A builder for [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster to be deleted.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster to be deleted.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterInput`](crate::input::DeleteClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterInput {
                cluster_name: self.cluster_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterInputOperationOutputAlias = crate::operation::DeleteCluster;
#[doc(hidden)]
pub type DeleteClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCluster`](crate::operation::DeleteCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DeleteCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCluster",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
}

/// See [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
pub mod delete_parameter_group_input {
    /// A builder for [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group to delete.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to delete.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteParameterGroupInputOperationOutputAlias = crate::operation::DeleteParameterGroup;
#[doc(hidden)]
pub type DeleteParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteParameterGroup`](crate::operation::DeleteParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DeleteParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_parameter_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteParameterGroup",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteParameterGroupInput`](crate::input::DeleteParameterGroupInput)
    pub fn builder() -> crate::input::delete_parameter_group_input::Builder {
        crate::input::delete_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
pub mod delete_subnet_group_input {
    /// A builder for [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the subnet group to delete.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to delete.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSubnetGroupInput {
                subnet_group_name: self.subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSubnetGroupInputOperationOutputAlias = crate::operation::DeleteSubnetGroup;
#[doc(hidden)]
pub type DeleteSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSubnetGroup`](crate::operation::DeleteSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DeleteSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_subnet_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSubnetGroup",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSubnetGroupInput`](crate::input::DeleteSubnetGroupInput)
    pub fn builder() -> crate::input::delete_subnet_group_input::Builder {
        crate::input::delete_subnet_group_input::Builder::default()
    }
}

/// See [`DescribeClustersInput`](crate::input::DescribeClustersInput)
pub mod describe_clusters_input {
    /// A builder for [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cluster_names`.
        ///
        /// To override the contents of this collection use [`set_cluster_names`](Self::set_cluster_names).
        ///
        /// <p>The names of the DAX clusters being described.</p>
        pub fn cluster_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cluster_names.unwrap_or_default();
            v.push(input.into());
            self.cluster_names = Some(v);
            self
        }
        /// <p>The names of the DAX clusters being described.</p>
        pub fn set_cluster_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cluster_names = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersInput`](crate::input::DescribeClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClustersInput {
                cluster_names: self.cluster_names,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClustersInputOperationOutputAlias = crate::operation::DescribeClusters;
#[doc(hidden)]
pub type DescribeClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusters`](crate::operation::DescribeClusters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DescribeClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_clusters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusters",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
}

/// See [`DescribeDefaultParametersInput`](crate::input::DescribeDefaultParametersInput)
pub mod describe_default_parameters_input {
    /// A builder for [`DescribeDefaultParametersInput`](crate::input::DescribeDefaultParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDefaultParametersInput`](crate::input::DescribeDefaultParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDefaultParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDefaultParametersInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDefaultParametersInputOperationOutputAlias =
    crate::operation::DescribeDefaultParameters;
#[doc(hidden)]
pub type DescribeDefaultParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDefaultParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDefaultParameters`](crate::operation::DescribeDefaultParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDefaultParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDefaultParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDefaultParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDefaultParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DescribeDefaultParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_default_parameters(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDefaultParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDefaultParameters",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDefaultParametersInput`](crate::input::DescribeDefaultParametersInput)
    pub fn builder() -> crate::input::describe_default_parameters_input::Builder {
        crate::input::describe_default_parameters_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events will be returned. If not
        /// specified, then all sources are included in the response.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events will be returned. If not
        /// specified, then all sources are included in the response.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
        /// format.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
        /// format.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes' worth of events to retrieve.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes' worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_name: self.source_name,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DescribeEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
pub mod describe_parameter_groups_input {
    /// A builder for [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameter_group_names`.
        ///
        /// To override the contents of this collection use [`set_parameter_group_names`](Self::set_parameter_group_names).
        ///
        /// <p>The names of the parameter groups.</p>
        pub fn parameter_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parameter_group_names.unwrap_or_default();
            v.push(input.into());
            self.parameter_group_names = Some(v);
            self
        }
        /// <p>The names of the parameter groups.</p>
        pub fn set_parameter_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parameter_group_names = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeParameterGroupsInput {
                parameter_group_names: self.parameter_group_names,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeParameterGroups;
#[doc(hidden)]
pub type DescribeParameterGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeParameterGroups`](crate::operation::DescribeParameterGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeParameterGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DescribeParameterGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_parameter_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeParameterGroups",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeParameterGroupsInput`](crate::input::DescribeParameterGroupsInput)
    pub fn builder() -> crate::input::describe_parameter_groups_input::Builder {
        crate::input::describe_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeParametersInput`](crate::input::DescribeParametersInput)
pub mod describe_parameters_input {
    /// A builder for [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>How the parameter is defined. For example, <code>system</code> denotes a
        /// system-defined parameter.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>How the parameter is defined. For example, <code>system</code> denotes a
        /// system-defined parameter.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParametersInput`](crate::input::DescribeParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeParametersInput {
                parameter_group_name: self.parameter_group_name,
                source: self.source,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeParametersInputOperationOutputAlias = crate::operation::DescribeParameters;
#[doc(hidden)]
pub type DescribeParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeParameters`](crate::operation::DescribeParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DescribeParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_parameters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeParameters",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    pub fn builder() -> crate::input::describe_parameters_input::Builder {
        crate::input::describe_parameters_input::Builder::default()
    }
}

/// See [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
pub mod describe_subnet_groups_input {
    /// A builder for [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subnet_group_names`.
        ///
        /// To override the contents of this collection use [`set_subnet_group_names`](Self::set_subnet_group_names).
        ///
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_group_names.unwrap_or_default();
            v.push(input.into());
            self.subnet_group_names = Some(v);
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_group_names = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist
        /// than the specified <code>MaxResults</code> value, a token is included in the response so
        /// that the remaining results can be retrieved.</p>
        /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by
        /// <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSubnetGroupsInput {
                subnet_group_names: self.subnet_group_names,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSubnetGroupsInputOperationOutputAlias = crate::operation::DescribeSubnetGroups;
#[doc(hidden)]
pub type DescribeSubnetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSubnetGroups`](crate::operation::DescribeSubnetGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSubnetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.DescribeSubnetGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_subnet_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSubnetGroups",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSubnetGroupsInput`](crate::input::DescribeSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_subnet_groups_input::Builder {
        crate::input::describe_subnet_groups_input::Builder::default()
    }
}

/// See [`IncreaseReplicationFactorInput`](crate::input::IncreaseReplicationFactorInput)
pub mod increase_replication_factor_input {
    /// A builder for [`IncreaseReplicationFactorInput`](crate::input::IncreaseReplicationFactorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) new_replication_factor: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the DAX cluster that will receive additional nodes.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX cluster that will receive additional nodes.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn new_replication_factor(mut self, input: i32) -> Self {
            self.new_replication_factor = Some(input);
            self
        }
        /// <p>The new number of nodes for the DAX cluster.</p>
        pub fn set_new_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.new_replication_factor = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones (AZs) in which the cluster nodes will be created. All nodes
        /// belonging to the cluster are placed in these Availability Zones. Use this parameter if you want
        /// to distribute the nodes across multiple AZs.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones (AZs) in which the cluster nodes will be created. All nodes
        /// belonging to the cluster are placed in these Availability Zones. Use this parameter if you want
        /// to distribute the nodes across multiple AZs.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`IncreaseReplicationFactorInput`](crate::input::IncreaseReplicationFactorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::IncreaseReplicationFactorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::IncreaseReplicationFactorInput {
                cluster_name: self.cluster_name,
                new_replication_factor: self.new_replication_factor.unwrap_or_default(),
                availability_zones: self.availability_zones,
            })
        }
    }
}
#[doc(hidden)]
pub type IncreaseReplicationFactorInputOperationOutputAlias =
    crate::operation::IncreaseReplicationFactor;
#[doc(hidden)]
pub type IncreaseReplicationFactorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl IncreaseReplicationFactorInput {
    /// Consumes the builder and constructs an Operation<[`IncreaseReplicationFactor`](crate::operation::IncreaseReplicationFactor)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::IncreaseReplicationFactor,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::IncreaseReplicationFactorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::IncreaseReplicationFactorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::IncreaseReplicationFactorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.IncreaseReplicationFactor",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_increase_replication_factor(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::IncreaseReplicationFactor::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "IncreaseReplicationFactor",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`IncreaseReplicationFactorInput`](crate::input::IncreaseReplicationFactorInput)
    pub fn builder() -> crate::input::increase_replication_factor_input::Builder {
        crate::input::increase_replication_factor_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DAX resource to which the tags belong.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX resource to which the tags belong.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_name: self.resource_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.ListTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("ListTags", "dax"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`RebootNodeInput`](crate::input::RebootNodeInput)
pub mod reboot_node_input {
    /// A builder for [`RebootNodeInput`](crate::input::RebootNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) node_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DAX cluster containing the node to be rebooted.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX cluster containing the node to be rebooted.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The system-assigned ID of the node to be rebooted.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The system-assigned ID of the node to be rebooted.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootNodeInput`](crate::input::RebootNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootNodeInput {
                cluster_name: self.cluster_name,
                node_id: self.node_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootNodeInputOperationOutputAlias = crate::operation::RebootNode;
#[doc(hidden)]
pub type RebootNodeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RebootNodeInput {
    /// Consumes the builder and constructs an Operation<[`RebootNode`](crate::operation::RebootNode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootNode,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootNodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootNodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootNodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.RebootNode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_reboot_node(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootNode",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootNodeInput`](crate::input::RebootNodeInput)
    pub fn builder() -> crate::input::reboot_node_input::Builder {
        crate::input::reboot_node_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DAX resource to which tags should be added.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX resource to which tags should be added.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DAX resource. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the DAX resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_name: self.resource_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the DAX resource from which the tags should be removed.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX resource from which the tags should be removed.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_name: self.resource_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateClusterInput`](crate::input::UpdateClusterInput)
pub mod update_cluster_input {
    /// A builder for [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
        pub(crate) notification_topic_status: std::option::Option<std::string::String>,
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the DAX cluster to be modified.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the DAX cluster to be modified.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>A description of the changes being made to the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the changes being made to the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A range of time when maintenance of DAX cluster software will be performed. For
        /// example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than
        /// 30 minutes, and is performed automatically within the maintenance window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>A range of time when maintenance of DAX cluster software will be performed. For
        /// example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than
        /// 30 minutes, and is performed automatically within the maintenance window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// <p>The current state of the topic. A value of “active” means that notifications will
        /// be sent to the topic. A value of “inactive” means that notifications will not be sent to the
        /// topic.</p>
        pub fn notification_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_status = Some(input.into());
            self
        }
        /// <p>The current state of the topic. A value of “active” means that notifications will
        /// be sent to the topic. A value of “inactive” means that notifications will not be sent to the
        /// topic.</p>
        pub fn set_notification_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_status = input;
            self
        }
        /// <p>The name of a parameter group for this cluster.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a parameter group for this cluster.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of user-specified security group IDs to be assigned to each node in the DAX cluster.  If this parameter is not
        /// specified, DAX assigns the default VPC security group to each node.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of user-specified security group IDs to be assigned to each node in the DAX cluster.  If this parameter is not
        /// specified, DAX assigns the default VPC security group to each node.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterInput`](crate::input::UpdateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClusterInput {
                cluster_name: self.cluster_name,
                description: self.description,
                preferred_maintenance_window: self.preferred_maintenance_window,
                notification_topic_arn: self.notification_topic_arn,
                notification_topic_status: self.notification_topic_status,
                parameter_group_name: self.parameter_group_name,
                security_group_ids: self.security_group_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClusterInputOperationOutputAlias = crate::operation::UpdateCluster;
#[doc(hidden)]
pub type UpdateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateClusterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCluster`](crate::operation::UpdateCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.UpdateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCluster",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    pub fn builder() -> crate::input::update_cluster_input::Builder {
        crate::input::update_cluster_input::Builder::default()
    }
}

/// See [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
pub mod update_parameter_group_input {
    /// A builder for [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_name_values:
            std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
    }
    impl Builder {
        /// <p>The name of the parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Appends an item to `parameter_name_values`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of name-value pairs for the parameters in the group. Each element in the
        /// array represents a single parameter.</p>
        /// <note>
        /// <p>
        /// <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more details, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl">Configuring TTL Settings</a>.</p>
        /// </note>
        pub fn parameter_name_values(
            mut self,
            input: impl Into<crate::model::ParameterNameValue>,
        ) -> Self {
            let mut v = self.parameter_name_values.unwrap_or_default();
            v.push(input.into());
            self.parameter_name_values = Some(v);
            self
        }
        /// <p>An array of name-value pairs for the parameters in the group. Each element in the
        /// array represents a single parameter.</p>
        /// <note>
        /// <p>
        /// <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more details, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl">Configuring TTL Settings</a>.</p>
        /// </note>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.parameter_name_values = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                parameter_name_values: self.parameter_name_values,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateParameterGroupInputOperationOutputAlias = crate::operation::UpdateParameterGroup;
#[doc(hidden)]
pub type UpdateParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateParameterGroup`](crate::operation::UpdateParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.UpdateParameterGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_parameter_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateParameterGroup",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateParameterGroupInput`](crate::input::UpdateParameterGroupInput)
    pub fn builder() -> crate::input::update_parameter_group_input::Builder {
        crate::input::update_parameter_group_input::Builder::default()
    }
}

/// See [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
pub mod update_subnet_group_input {
    /// A builder for [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the subnet group.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>A description of the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs in the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs in the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSubnetGroupInput {
                subnet_group_name: self.subnet_group_name,
                description: self.description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSubnetGroupInputOperationOutputAlias = crate::operation::UpdateSubnetGroup;
#[doc(hidden)]
pub type UpdateSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSubnetGroup`](crate::operation::UpdateSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDAXV3.UpdateSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_subnet_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSubnetGroup",
            "dax",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSubnetGroupInput`](crate::input::UpdateSubnetGroupInput)
    pub fn builder() -> crate::input::update_subnet_group_input::Builder {
        crate::input::update_subnet_group_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubnetGroupInput {
    /// <p>The name of the subnet group.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the subnet group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of subnet IDs in the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateSubnetGroupInput {
    /// <p>The name of the subnet group.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>A description of the subnet group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of subnet IDs in the subnet group.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
}
impl std::fmt::Debug for UpdateSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubnetGroupInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("description", &self.description);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateParameterGroupInput {
    /// <p>The name of the parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>An array of name-value pairs for the parameters in the group. Each element in the
    /// array represents a single parameter.</p>
    /// <note>
    /// <p>
    /// <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more details, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl">Configuring TTL Settings</a>.</p>
    /// </note>
    pub parameter_name_values: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
}
impl UpdateParameterGroupInput {
    /// <p>The name of the parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>An array of name-value pairs for the parameters in the group. Each element in the
    /// array represents a single parameter.</p>
    /// <note>
    /// <p>
    /// <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more details, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl">Configuring TTL Settings</a>.</p>
    /// </note>
    pub fn parameter_name_values(
        &self,
    ) -> std::option::Option<&[crate::model::ParameterNameValue]> {
        self.parameter_name_values.as_deref()
    }
}
impl std::fmt::Debug for UpdateParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_name_values", &self.parameter_name_values);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterInput {
    /// <p>The name of the DAX cluster to be modified.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>A description of the changes being made to the cluster.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A range of time when maintenance of DAX cluster software will be performed. For
    /// example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than
    /// 30 minutes, and is performed automatically within the maintenance window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
    pub notification_topic_arn: std::option::Option<std::string::String>,
    /// <p>The current state of the topic. A value of “active” means that notifications will
    /// be sent to the topic. A value of “inactive” means that notifications will not be sent to the
    /// topic.</p>
    pub notification_topic_status: std::option::Option<std::string::String>,
    /// <p>The name of a parameter group for this cluster.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A list of user-specified security group IDs to be assigned to each node in the DAX cluster.  If this parameter is not
    /// specified, DAX assigns the default VPC security group to each node.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateClusterInput {
    /// <p>The name of the DAX cluster to be modified.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>A description of the changes being made to the cluster.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A range of time when maintenance of DAX cluster software will be performed. For
    /// example: <code>sun:01:00-sun:09:00</code>. Cluster maintenance normally takes less than
    /// 30 minutes, and is performed automatically within the maintenance window.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
    pub fn notification_topic_arn(&self) -> std::option::Option<&str> {
        self.notification_topic_arn.as_deref()
    }
    /// <p>The current state of the topic. A value of “active” means that notifications will
    /// be sent to the topic. A value of “inactive” means that notifications will not be sent to the
    /// topic.</p>
    pub fn notification_topic_status(&self) -> std::option::Option<&str> {
        self.notification_topic_status.as_deref()
    }
    /// <p>The name of a parameter group for this cluster.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>A list of user-specified security group IDs to be assigned to each node in the DAX cluster.  If this parameter is not
    /// specified, DAX assigns the default VPC security group to each node.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for UpdateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("description", &self.description);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("notification_topic_arn", &self.notification_topic_arn);
        formatter.field("notification_topic_status", &self.notification_topic_status);
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The name of the DAX resource from which the tags should be removed.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The name of the DAX resource from which the tags should be removed.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>A list of tag keys. If the DAX cluster has any tags with these keys, then the tags are removed from the cluster.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The name of the DAX resource to which tags should be added.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the DAX resource. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The name of the DAX resource to which tags should be added.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The tags to be assigned to the DAX resource. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootNodeInput {
    /// <p>The name of the DAX cluster containing the node to be rebooted.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The system-assigned ID of the node to be rebooted.</p>
    pub node_id: std::option::Option<std::string::String>,
}
impl RebootNodeInput {
    /// <p>The name of the DAX cluster containing the node to be rebooted.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The system-assigned ID of the node to be rebooted.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
}
impl std::fmt::Debug for RebootNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootNodeInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("node_id", &self.node_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The name of the DAX resource to which the tags belong.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>The name of the DAX resource to which the tags belong.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseReplicationFactorInput {
    /// <p>The name of the DAX cluster that will receive additional nodes.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The new number of nodes for the DAX cluster.</p>
    pub new_replication_factor: i32,
    /// <p>The Availability Zones (AZs) in which the cluster nodes will be created. All nodes
    /// belonging to the cluster are placed in these Availability Zones. Use this parameter if you want
    /// to distribute the nodes across multiple AZs.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl IncreaseReplicationFactorInput {
    /// <p>The name of the DAX cluster that will receive additional nodes.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The new number of nodes for the DAX cluster.</p>
    pub fn new_replication_factor(&self) -> i32 {
        self.new_replication_factor
    }
    /// <p>The Availability Zones (AZs) in which the cluster nodes will be created. All nodes
    /// belonging to the cluster are placed in these Availability Zones. Use this parameter if you want
    /// to distribute the nodes across multiple AZs.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
}
impl std::fmt::Debug for IncreaseReplicationFactorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseReplicationFactorInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("new_replication_factor", &self.new_replication_factor);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSubnetGroupsInput {
    /// <p>The name of the subnet group.</p>
    pub subnet_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSubnetGroupsInput {
    /// <p>The name of the subnet group.</p>
    pub fn subnet_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_group_names.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSubnetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSubnetGroupsInput");
        formatter.field("subnet_group_names", &self.subnet_group_names);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParametersInput {
    /// <p>The name of the parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>How the parameter is defined. For example, <code>system</code> denotes a
    /// system-defined parameter.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeParametersInput {
    /// <p>The name of the parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>How the parameter is defined. For example, <code>system</code> denotes a
    /// system-defined parameter.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParametersInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("source", &self.source);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParameterGroupsInput {
    /// <p>The names of the parameter groups.</p>
    pub parameter_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeParameterGroupsInput {
    /// <p>The names of the parameter groups.</p>
    pub fn parameter_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.parameter_group_names.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeParameterGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParameterGroupsInput");
        formatter.field("parameter_group_names", &self.parameter_group_names);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>The identifier of the event source for which events will be returned. If not
    /// specified, then all sources are included in the response.</p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p>The event source to retrieve events for. If no value is specified, all events are
    /// returned.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
    /// format.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
    /// format.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of minutes' worth of events to retrieve.</p>
    pub duration: std::option::Option<i32>,
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEventsInput {
    /// <p>The identifier of the event source for which events will be returned. If not
    /// specified, then all sources are included in the response.</p>
    pub fn source_name(&self) -> std::option::Option<&str> {
        self.source_name.as_deref()
    }
    /// <p>The event source to retrieve events for. If no value is specified, all events are
    /// returned.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
    /// format.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
    /// format.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The number of minutes' worth of events to retrieve.</p>
    pub fn duration(&self) -> std::option::Option<i32> {
        self.duration
    }
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("source_name", &self.source_name);
        formatter.field("source_type", &self.source_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration", &self.duration);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDefaultParametersInput {
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDefaultParametersInput {
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDefaultParametersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDefaultParametersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClustersInput {
    /// <p>The names of the DAX clusters being described.</p>
    pub cluster_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeClustersInput {
    /// <p>The names of the DAX clusters being described.</p>
    pub fn cluster_names(&self) -> std::option::Option<&[std::string::String]> {
        self.cluster_names.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist
    /// than the specified <code>MaxResults</code> value, a token is included in the response so
    /// that the remaining results can be retrieved.</p>
    /// <p>The value for <code>MaxResults</code> must be between 20 and 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional token returned from a prior request. Use this token for pagination of
    /// results from this action. If this parameter is specified, the response includes only
    /// results beyond the token, up to the value specified by
    /// <code>MaxResults</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClustersInput");
        formatter.field("cluster_names", &self.cluster_names);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSubnetGroupInput {
    /// <p>The name of the subnet group to delete.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
}
impl DeleteSubnetGroupInput {
    /// <p>The name of the subnet group to delete.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSubnetGroupInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParameterGroupInput {
    /// <p>The name of the parameter group to delete.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
}
impl DeleteParameterGroupInput {
    /// <p>The name of the parameter group to delete.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterInput {
    /// <p>The name of the cluster to be deleted.</p>
    pub cluster_name: std::option::Option<std::string::String>,
}
impl DeleteClusterInput {
    /// <p>The name of the cluster to be deleted.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseReplicationFactorInput {
    /// <p>The name of the DAX cluster from which you want to remove nodes.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The new number of nodes for the DAX cluster.</p>
    pub new_replication_factor: i32,
    /// <p>The Availability Zone(s) from which to remove nodes.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The unique identifiers of the nodes to be removed from the cluster.</p>
    pub node_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DecreaseReplicationFactorInput {
    /// <p>The name of the DAX cluster from which you want to remove nodes.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The new number of nodes for the DAX cluster.</p>
    pub fn new_replication_factor(&self) -> i32 {
        self.new_replication_factor
    }
    /// <p>The Availability Zone(s) from which to remove nodes.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The unique identifiers of the nodes to be removed from the cluster.</p>
    pub fn node_ids_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.node_ids_to_remove.as_deref()
    }
}
impl std::fmt::Debug for DecreaseReplicationFactorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseReplicationFactorInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("new_replication_factor", &self.new_replication_factor);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("node_ids_to_remove", &self.node_ids_to_remove);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubnetGroupInput {
    /// <p>A name for the subnet group. This value is stored as a lowercase string. </p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A description for the subnet group</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of VPC subnet IDs for the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateSubnetGroupInput {
    /// <p>A name for the subnet group. This value is stored as a lowercase string. </p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>A description for the subnet group</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of VPC subnet IDs for the subnet group.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
}
impl std::fmt::Debug for CreateSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubnetGroupInput");
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("description", &self.description);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateParameterGroupInput {
    /// <p>The name of the parameter group to apply to all of the clusters in this replication
    /// group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the parameter group.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CreateParameterGroupInput {
    /// <p>The name of the parameter group to apply to all of the clusters in this replication
    /// group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>A description of the parameter group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreateParameterGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateParameterGroupInput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterInput {
    /// <p>The cluster identifier. This parameter is stored as a lowercase
    /// string.</p>
    /// <p>
    /// <b>Constraints:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>A name must contain from 1 to 20 alphanumeric characters or
    /// hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>A name cannot end with a hyphen or contain two consecutive
    /// hyphens.</p>
    /// </li>
    /// </ul>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The compute and memory capacity of the nodes in the cluster.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>A description of the cluster.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of nodes in the DAX cluster. A replication factor of 1 will
    /// create a single-node cluster, without any read replicas. For additional fault tolerance,
    /// you can create a multiple node cluster with one or more read replicas. To do this, set
    /// <code>ReplicationFactor</code> to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas).
    /// <code>If the AvailabilityZones</code> parameter is provided, its length must equal the <code>ReplicationFactor</code>.</p>
    /// <note>
    /// <p>AWS recommends that you have at least two read replicas per cluster.</p>
    /// </note>
    pub replication_factor: i32,
    /// <p>The Availability Zones (AZs) in which the cluster nodes will reside after the cluster
    /// has been created or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter.
    /// If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the subnet group to be used for the replication group.</p>
    /// <important>
    /// <p>DAX clusters can only run in an Amazon VPC environment. All of the subnets
    /// that you specify in a subnet group must exist in the same VPC.</p>
    /// </important>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the
    /// security group ID is system-generated.)</p>
    /// <p>If this parameter is not specified, DAX assigns the default VPC security group to
    /// each node.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the weekly time range during which maintenance on the DAX cluster is
    /// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock
    /// UTC). The minimum maintenance window is a 60 minute period. Valid values for
    /// <code>ddd</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sun</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>mon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tue</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>wed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>thu</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fri</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sat</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>sun:05:00-sun:09:00</code>
    /// </p>
    /// <note>
    /// <p>If you don't specify a preferred maintenance window when you create or modify a
    /// cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day
    /// of the week.</p>
    /// </note>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will
    /// be sent.</p>
    /// <note>
    /// <p>The Amazon SNS topic owner must be same as the DAX cluster owner.</p>
    /// </note>
    pub notification_topic_arn: std::option::Option<std::string::String>,
    /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX
    /// will assume this role and use the role's permissions to access DynamoDB on your
    /// behalf.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The parameter group to be associated with the DAX cluster.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>A set of tags to associate with the DAX cluster.  </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Represents the settings used to enable server-side encryption on the cluster.</p>
    pub sse_specification: std::option::Option<crate::model::SseSpecification>,
    /// <p>The type of encryption the cluster's endpoint should support. Values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> for no encryption</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TLS</code> for Transport Layer Security</p>
    /// </li>
    /// </ul>
    pub cluster_endpoint_encryption_type:
        std::option::Option<crate::model::ClusterEndpointEncryptionType>,
}
impl CreateClusterInput {
    /// <p>The cluster identifier. This parameter is stored as a lowercase
    /// string.</p>
    /// <p>
    /// <b>Constraints:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>A name must contain from 1 to 20 alphanumeric characters or
    /// hyphens.</p>
    /// </li>
    /// <li>
    /// <p>The first character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>A name cannot end with a hyphen or contain two consecutive
    /// hyphens.</p>
    /// </li>
    /// </ul>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The compute and memory capacity of the nodes in the cluster.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>A description of the cluster.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The number of nodes in the DAX cluster. A replication factor of 1 will
    /// create a single-node cluster, without any read replicas. For additional fault tolerance,
    /// you can create a multiple node cluster with one or more read replicas. To do this, set
    /// <code>ReplicationFactor</code> to a number between 3 (one primary and two read replicas) and 10 (one primary and nine read replicas).
    /// <code>If the AvailabilityZones</code> parameter is provided, its length must equal the <code>ReplicationFactor</code>.</p>
    /// <note>
    /// <p>AWS recommends that you have at least two read replicas per cluster.</p>
    /// </note>
    pub fn replication_factor(&self) -> i32 {
        self.replication_factor
    }
    /// <p>The Availability Zones (AZs) in which the cluster nodes will reside after the cluster
    /// has been created or updated. If provided, the length of this list must equal the <code>ReplicationFactor</code> parameter.
    /// If you omit this parameter, DAX will spread the nodes across Availability Zones for the highest availability.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The name of the subnet group to be used for the replication group.</p>
    /// <important>
    /// <p>DAX clusters can only run in an Amazon VPC environment. All of the subnets
    /// that you specify in a subnet group must exist in the same VPC.</p>
    /// </important>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>A list of security group IDs to be assigned to each node in the DAX cluster. (Each of the
    /// security group ID is system-generated.)</p>
    /// <p>If this parameter is not specified, DAX assigns the default VPC security group to
    /// each node.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>Specifies the weekly time range during which maintenance on the DAX cluster is
    /// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock
    /// UTC). The minimum maintenance window is a 60 minute period. Valid values for
    /// <code>ddd</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sun</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>mon</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tue</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>wed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>thu</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>fri</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sat</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>sun:05:00-sun:09:00</code>
    /// </p>
    /// <note>
    /// <p>If you don't specify a preferred maintenance window when you create or modify a
    /// cache cluster, DAX assigns a 60-minute maintenance window on a randomly selected day
    /// of the week.</p>
    /// </note>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications will
    /// be sent.</p>
    /// <note>
    /// <p>The Amazon SNS topic owner must be same as the DAX cluster owner.</p>
    /// </note>
    pub fn notification_topic_arn(&self) -> std::option::Option<&str> {
        self.notification_topic_arn.as_deref()
    }
    /// <p>A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime, DAX
    /// will assume this role and use the role's permissions to access DynamoDB on your
    /// behalf.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The parameter group to be associated with the DAX cluster.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>A set of tags to associate with the DAX cluster.  </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Represents the settings used to enable server-side encryption on the cluster.</p>
    pub fn sse_specification(&self) -> std::option::Option<&crate::model::SseSpecification> {
        self.sse_specification.as_ref()
    }
    /// <p>The type of encryption the cluster's endpoint should support. Values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> for no encryption</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TLS</code> for Transport Layer Security</p>
    /// </li>
    /// </ul>
    pub fn cluster_endpoint_encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::ClusterEndpointEncryptionType> {
        self.cluster_endpoint_encryption_type.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("node_type", &self.node_type);
        formatter.field("description", &self.description);
        formatter.field("replication_factor", &self.replication_factor);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("notification_topic_arn", &self.notification_topic_arn);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("tags", &self.tags);
        formatter.field("sse_specification", &self.sse_specification);
        formatter.field(
            "cluster_endpoint_encryption_type",
            &self.cluster_endpoint_encryption_type,
        );
        formatter.finish()
    }
}
