// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubnetGroupOutput {
    /// <p>The subnet group that has been modified.</p>
    pub subnet_group: std::option::Option<crate::model::SubnetGroup>,
}
impl std::fmt::Debug for UpdateSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubnetGroupOutput");
        formatter.field("subnet_group", &self.subnet_group);
        formatter.finish()
    }
}
/// See [`UpdateSubnetGroupOutput`](crate::output::UpdateSubnetGroupOutput)
pub mod update_subnet_group_output {
    /// A builder for [`UpdateSubnetGroupOutput`](crate::output::UpdateSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group: std::option::Option<crate::model::SubnetGroup>,
    }
    impl Builder {
        /// <p>The subnet group that has been modified.</p>
        pub fn subnet_group(mut self, input: crate::model::SubnetGroup) -> Self {
            self.subnet_group = Some(input);
            self
        }
        /// <p>The subnet group that has been modified.</p>
        pub fn set_subnet_group(
            mut self,
            input: std::option::Option<crate::model::SubnetGroup>,
        ) -> Self {
            self.subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSubnetGroupOutput`](crate::output::UpdateSubnetGroupOutput)
        pub fn build(self) -> crate::output::UpdateSubnetGroupOutput {
            crate::output::UpdateSubnetGroupOutput {
                subnet_group: self.subnet_group,
            }
        }
    }
}
impl UpdateSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSubnetGroupOutput`](crate::output::UpdateSubnetGroupOutput)
    pub fn builder() -> crate::output::update_subnet_group_output::Builder {
        crate::output::update_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateParameterGroupOutput {
    /// <p>The parameter group that has been modified.</p>
    pub parameter_group: std::option::Option<crate::model::ParameterGroup>,
}
impl std::fmt::Debug for UpdateParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateParameterGroupOutput");
        formatter.field("parameter_group", &self.parameter_group);
        formatter.finish()
    }
}
/// See [`UpdateParameterGroupOutput`](crate::output::UpdateParameterGroupOutput)
pub mod update_parameter_group_output {
    /// A builder for [`UpdateParameterGroupOutput`](crate::output::UpdateParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group: std::option::Option<crate::model::ParameterGroup>,
    }
    impl Builder {
        /// <p>The parameter group that has been modified.</p>
        pub fn parameter_group(mut self, input: crate::model::ParameterGroup) -> Self {
            self.parameter_group = Some(input);
            self
        }
        /// <p>The parameter group that has been modified.</p>
        pub fn set_parameter_group(
            mut self,
            input: std::option::Option<crate::model::ParameterGroup>,
        ) -> Self {
            self.parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateParameterGroupOutput`](crate::output::UpdateParameterGroupOutput)
        pub fn build(self) -> crate::output::UpdateParameterGroupOutput {
            crate::output::UpdateParameterGroupOutput {
                parameter_group: self.parameter_group,
            }
        }
    }
}
impl UpdateParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateParameterGroupOutput`](crate::output::UpdateParameterGroupOutput)
    pub fn builder() -> crate::output::update_parameter_group_output::Builder {
        crate::output::update_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterOutput {
    /// <p>A description of the DAX cluster, after it has been modified.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for UpdateClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
pub mod update_cluster_output {
    /// A builder for [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>A description of the DAX cluster, after it has been modified.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>A description of the DAX cluster, after it has been modified.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
        pub fn build(self) -> crate::output::UpdateClusterOutput {
            crate::output::UpdateClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl UpdateClusterOutput {
    /// Creates a new builder-style object to manufacture [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
    pub fn builder() -> crate::output::update_cluster_output::Builder {
        crate::output::update_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {
    /// <p>The tag keys that have been removed from the cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys that have been removed from the cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys that have been removed from the cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput { tags: self.tags }
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {
    /// <p>The list of tags that are associated with the DAX resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are associated with the DAX resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are associated with the DAX resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput { tags: self.tags }
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootNodeOutput {
    /// <p>A description of the DAX cluster after a node has been rebooted.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for RebootNodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootNodeOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`RebootNodeOutput`](crate::output::RebootNodeOutput)
pub mod reboot_node_output {
    /// A builder for [`RebootNodeOutput`](crate::output::RebootNodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>A description of the DAX cluster after a node has been rebooted.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>A description of the DAX cluster after a node has been rebooted.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootNodeOutput`](crate::output::RebootNodeOutput)
        pub fn build(self) -> crate::output::RebootNodeOutput {
            crate::output::RebootNodeOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl RebootNodeOutput {
    /// Creates a new builder-style object to manufacture [`RebootNodeOutput`](crate::output::RebootNodeOutput)
    pub fn builder() -> crate::output::reboot_node_output::Builder {
        crate::output::reboot_node_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>A list of tags currently associated with the DAX cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If this value is present, there are additional results to be displayed.  To retrieve them, call
    /// <code>ListTags</code> again, with <code>NextToken</code> set to this value.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags currently associated with the DAX cluster.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags currently associated with the DAX cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If this value is present, there are additional results to be displayed.  To retrieve them, call
        /// <code>ListTags</code> again, with <code>NextToken</code> set to this value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If this value is present, there are additional results to be displayed.  To retrieve them, call
        /// <code>ListTags</code> again, with <code>NextToken</code> set to this value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseReplicationFactorOutput {
    /// <p>A description of the DAX cluster. with its new replication factor.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for IncreaseReplicationFactorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseReplicationFactorOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`IncreaseReplicationFactorOutput`](crate::output::IncreaseReplicationFactorOutput)
pub mod increase_replication_factor_output {
    /// A builder for [`IncreaseReplicationFactorOutput`](crate::output::IncreaseReplicationFactorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>A description of the DAX cluster. with its new replication factor.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>A description of the DAX cluster. with its new replication factor.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`IncreaseReplicationFactorOutput`](crate::output::IncreaseReplicationFactorOutput)
        pub fn build(self) -> crate::output::IncreaseReplicationFactorOutput {
            crate::output::IncreaseReplicationFactorOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl IncreaseReplicationFactorOutput {
    /// Creates a new builder-style object to manufacture [`IncreaseReplicationFactorOutput`](crate::output::IncreaseReplicationFactorOutput)
    pub fn builder() -> crate::output::increase_replication_factor_output::Builder {
        crate::output::increase_replication_factor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSubnetGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of subnet groups.  Each element in the array represents a single subnet group.</p>
    pub subnet_groups: std::option::Option<std::vec::Vec<crate::model::SubnetGroup>>,
}
impl std::fmt::Debug for DescribeSubnetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSubnetGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("subnet_groups", &self.subnet_groups);
        formatter.finish()
    }
}
/// See [`DescribeSubnetGroupsOutput`](crate::output::DescribeSubnetGroupsOutput)
pub mod describe_subnet_groups_output {
    /// A builder for [`DescribeSubnetGroupsOutput`](crate::output::DescribeSubnetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) subnet_groups: std::option::Option<std::vec::Vec<crate::model::SubnetGroup>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `subnet_groups`.
        ///
        /// To override the contents of this collection use [`set_subnet_groups`](Self::set_subnet_groups).
        ///
        /// <p>An array of subnet groups.  Each element in the array represents a single subnet group.</p>
        pub fn subnet_groups(mut self, input: impl Into<crate::model::SubnetGroup>) -> Self {
            let mut v = self.subnet_groups.unwrap_or_default();
            v.push(input.into());
            self.subnet_groups = Some(v);
            self
        }
        /// <p>An array of subnet groups.  Each element in the array represents a single subnet group.</p>
        pub fn set_subnet_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubnetGroup>>,
        ) -> Self {
            self.subnet_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSubnetGroupsOutput`](crate::output::DescribeSubnetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeSubnetGroupsOutput {
            crate::output::DescribeSubnetGroupsOutput {
                next_token: self.next_token,
                subnet_groups: self.subnet_groups,
            }
        }
    }
}
impl DescribeSubnetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSubnetGroupsOutput`](crate::output::DescribeSubnetGroupsOutput)
    pub fn builder() -> crate::output::describe_subnet_groups_output::Builder {
        crate::output::describe_subnet_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParametersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of parameters within a parameter group.  Each element in the list represents one parameter.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for DescribeParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParametersOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
pub mod describe_parameters_output {
    /// A builder for [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters within a parameter group.  Each element in the list represents one parameter.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameters within a parameter group.  Each element in the list represents one parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
        pub fn build(self) -> crate::output::DescribeParametersOutput {
            crate::output::DescribeParametersOutput {
                next_token: self.next_token,
                parameters: self.parameters,
            }
        }
    }
}
impl DescribeParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
    pub fn builder() -> crate::output::describe_parameters_output::Builder {
        crate::output::describe_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParameterGroupsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of parameter groups.  Each element in the array represents one parameter group.</p>
    pub parameter_groups: std::option::Option<std::vec::Vec<crate::model::ParameterGroup>>,
}
impl std::fmt::Debug for DescribeParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParameterGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("parameter_groups", &self.parameter_groups);
        formatter.finish()
    }
}
/// See [`DescribeParameterGroupsOutput`](crate::output::DescribeParameterGroupsOutput)
pub mod describe_parameter_groups_output {
    /// A builder for [`DescribeParameterGroupsOutput`](crate::output::DescribeParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::ParameterGroup>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_parameter_groups`](Self::set_parameter_groups).
        ///
        /// <p>An array of parameter groups.  Each element in the array represents one parameter group.</p>
        pub fn parameter_groups(mut self, input: impl Into<crate::model::ParameterGroup>) -> Self {
            let mut v = self.parameter_groups.unwrap_or_default();
            v.push(input.into());
            self.parameter_groups = Some(v);
            self
        }
        /// <p>An array of parameter groups.  Each element in the array represents one parameter group.</p>
        pub fn set_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterGroup>>,
        ) -> Self {
            self.parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParameterGroupsOutput`](crate::output::DescribeParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeParameterGroupsOutput {
            crate::output::DescribeParameterGroupsOutput {
                next_token: self.next_token,
                parameter_groups: self.parameter_groups,
            }
        }
    }
}
impl DescribeParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeParameterGroupsOutput`](crate::output::DescribeParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_parameter_groups_output::Builder {
        crate::output::describe_parameter_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of events.  Each element in the array represents one event.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>An array of events.  Each element in the array represents one event.</p>
        pub fn events(mut self, input: impl Into<crate::model::Event>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>An array of events.  Each element in the array represents one event.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                next_token: self.next_token,
                events: self.events,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDefaultParametersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of parameters.  Each element in the list represents one parameter.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl std::fmt::Debug for DescribeDefaultParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDefaultParametersOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`DescribeDefaultParametersOutput`](crate::output::DescribeDefaultParametersOutput)
pub mod describe_default_parameters_output {
    /// A builder for [`DescribeDefaultParametersOutput`](crate::output::DescribeDefaultParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters.  Each element in the list represents one parameter.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameters.  Each element in the list represents one parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDefaultParametersOutput`](crate::output::DescribeDefaultParametersOutput)
        pub fn build(self) -> crate::output::DescribeDefaultParametersOutput {
            crate::output::DescribeDefaultParametersOutput {
                next_token: self.next_token,
                parameters: self.parameters,
            }
        }
    }
}
impl DescribeDefaultParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultParametersOutput`](crate::output::DescribeDefaultParametersOutput)
    pub fn builder() -> crate::output::describe_default_parameters_output::Builder {
        crate::output::describe_default_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClustersOutput {
    /// <p>Provides an identifier to allow retrieval of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The descriptions of your DAX clusters, in response to a
    /// <i>DescribeClusters</i> request.</p>
    pub clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
}
impl std::fmt::Debug for DescribeClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClustersOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("clusters", &self.clusters);
        formatter.finish()
    }
}
/// See [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
pub mod describe_clusters_output {
    /// A builder for [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
    }
    impl Builder {
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides an identifier to allow retrieval of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>The descriptions of your DAX clusters, in response to a
        /// <i>DescribeClusters</i> request.</p>
        pub fn clusters(mut self, input: impl Into<crate::model::Cluster>) -> Self {
            let mut v = self.clusters.unwrap_or_default();
            v.push(input.into());
            self.clusters = Some(v);
            self
        }
        /// <p>The descriptions of your DAX clusters, in response to a
        /// <i>DescribeClusters</i> request.</p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
        ) -> Self {
            self.clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
        pub fn build(self) -> crate::output::DescribeClustersOutput {
            crate::output::DescribeClustersOutput {
                next_token: self.next_token,
                clusters: self.clusters,
            }
        }
    }
}
impl DescribeClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
    pub fn builder() -> crate::output::describe_clusters_output::Builder {
        crate::output::describe_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSubnetGroupOutput {
    /// <p>A user-specified message for this action (i.e., a reason for deleting the subnet
    /// group).</p>
    pub deletion_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSubnetGroupOutput");
        formatter.field("deletion_message", &self.deletion_message);
        formatter.finish()
    }
}
/// See [`DeleteSubnetGroupOutput`](crate::output::DeleteSubnetGroupOutput)
pub mod delete_subnet_group_output {
    /// A builder for [`DeleteSubnetGroupOutput`](crate::output::DeleteSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deletion_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-specified message for this action (i.e., a reason for deleting the subnet
        /// group).</p>
        pub fn deletion_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deletion_message = Some(input.into());
            self
        }
        /// <p>A user-specified message for this action (i.e., a reason for deleting the subnet
        /// group).</p>
        pub fn set_deletion_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deletion_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSubnetGroupOutput`](crate::output::DeleteSubnetGroupOutput)
        pub fn build(self) -> crate::output::DeleteSubnetGroupOutput {
            crate::output::DeleteSubnetGroupOutput {
                deletion_message: self.deletion_message,
            }
        }
    }
}
impl DeleteSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSubnetGroupOutput`](crate::output::DeleteSubnetGroupOutput)
    pub fn builder() -> crate::output::delete_subnet_group_output::Builder {
        crate::output::delete_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParameterGroupOutput {
    /// <p>A user-specified message for this action (i.e., a reason for deleting the parameter
    /// group).</p>
    pub deletion_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParameterGroupOutput");
        formatter.field("deletion_message", &self.deletion_message);
        formatter.finish()
    }
}
/// See [`DeleteParameterGroupOutput`](crate::output::DeleteParameterGroupOutput)
pub mod delete_parameter_group_output {
    /// A builder for [`DeleteParameterGroupOutput`](crate::output::DeleteParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deletion_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-specified message for this action (i.e., a reason for deleting the parameter
        /// group).</p>
        pub fn deletion_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deletion_message = Some(input.into());
            self
        }
        /// <p>A user-specified message for this action (i.e., a reason for deleting the parameter
        /// group).</p>
        pub fn set_deletion_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deletion_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParameterGroupOutput`](crate::output::DeleteParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteParameterGroupOutput {
            crate::output::DeleteParameterGroupOutput {
                deletion_message: self.deletion_message,
            }
        }
    }
}
impl DeleteParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteParameterGroupOutput`](crate::output::DeleteParameterGroupOutput)
    pub fn builder() -> crate::output::delete_parameter_group_output::Builder {
        crate::output::delete_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterOutput {
    /// <p>A description of the DAX cluster that is being deleted.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for DeleteClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
pub mod delete_cluster_output {
    /// A builder for [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>A description of the DAX cluster that is being deleted.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>A description of the DAX cluster that is being deleted.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
        pub fn build(self) -> crate::output::DeleteClusterOutput {
            crate::output::DeleteClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl DeleteClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    pub fn builder() -> crate::output::delete_cluster_output::Builder {
        crate::output::delete_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseReplicationFactorOutput {
    /// <p>A description of the DAX cluster, after you have decreased its replication
    /// factor.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for DecreaseReplicationFactorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseReplicationFactorOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`DecreaseReplicationFactorOutput`](crate::output::DecreaseReplicationFactorOutput)
pub mod decrease_replication_factor_output {
    /// A builder for [`DecreaseReplicationFactorOutput`](crate::output::DecreaseReplicationFactorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>A description of the DAX cluster, after you have decreased its replication
        /// factor.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>A description of the DAX cluster, after you have decreased its replication
        /// factor.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DecreaseReplicationFactorOutput`](crate::output::DecreaseReplicationFactorOutput)
        pub fn build(self) -> crate::output::DecreaseReplicationFactorOutput {
            crate::output::DecreaseReplicationFactorOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl DecreaseReplicationFactorOutput {
    /// Creates a new builder-style object to manufacture [`DecreaseReplicationFactorOutput`](crate::output::DecreaseReplicationFactorOutput)
    pub fn builder() -> crate::output::decrease_replication_factor_output::Builder {
        crate::output::decrease_replication_factor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubnetGroupOutput {
    /// <p>Represents the output of a <i>CreateSubnetGroup</i>
    /// operation.</p>
    pub subnet_group: std::option::Option<crate::model::SubnetGroup>,
}
impl std::fmt::Debug for CreateSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubnetGroupOutput");
        formatter.field("subnet_group", &self.subnet_group);
        formatter.finish()
    }
}
/// See [`CreateSubnetGroupOutput`](crate::output::CreateSubnetGroupOutput)
pub mod create_subnet_group_output {
    /// A builder for [`CreateSubnetGroupOutput`](crate::output::CreateSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_group: std::option::Option<crate::model::SubnetGroup>,
    }
    impl Builder {
        /// <p>Represents the output of a <i>CreateSubnetGroup</i>
        /// operation.</p>
        pub fn subnet_group(mut self, input: crate::model::SubnetGroup) -> Self {
            self.subnet_group = Some(input);
            self
        }
        /// <p>Represents the output of a <i>CreateSubnetGroup</i>
        /// operation.</p>
        pub fn set_subnet_group(
            mut self,
            input: std::option::Option<crate::model::SubnetGroup>,
        ) -> Self {
            self.subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubnetGroupOutput`](crate::output::CreateSubnetGroupOutput)
        pub fn build(self) -> crate::output::CreateSubnetGroupOutput {
            crate::output::CreateSubnetGroupOutput {
                subnet_group: self.subnet_group,
            }
        }
    }
}
impl CreateSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateSubnetGroupOutput`](crate::output::CreateSubnetGroupOutput)
    pub fn builder() -> crate::output::create_subnet_group_output::Builder {
        crate::output::create_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateParameterGroupOutput {
    /// <p>Represents the output of a <i>CreateParameterGroup</i>
    /// action.</p>
    pub parameter_group: std::option::Option<crate::model::ParameterGroup>,
}
impl std::fmt::Debug for CreateParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateParameterGroupOutput");
        formatter.field("parameter_group", &self.parameter_group);
        formatter.finish()
    }
}
/// See [`CreateParameterGroupOutput`](crate::output::CreateParameterGroupOutput)
pub mod create_parameter_group_output {
    /// A builder for [`CreateParameterGroupOutput`](crate::output::CreateParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group: std::option::Option<crate::model::ParameterGroup>,
    }
    impl Builder {
        /// <p>Represents the output of a <i>CreateParameterGroup</i>
        /// action.</p>
        pub fn parameter_group(mut self, input: crate::model::ParameterGroup) -> Self {
            self.parameter_group = Some(input);
            self
        }
        /// <p>Represents the output of a <i>CreateParameterGroup</i>
        /// action.</p>
        pub fn set_parameter_group(
            mut self,
            input: std::option::Option<crate::model::ParameterGroup>,
        ) -> Self {
            self.parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateParameterGroupOutput`](crate::output::CreateParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateParameterGroupOutput {
            crate::output::CreateParameterGroupOutput {
                parameter_group: self.parameter_group,
            }
        }
    }
}
impl CreateParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateParameterGroupOutput`](crate::output::CreateParameterGroupOutput)
    pub fn builder() -> crate::output::create_parameter_group_output::Builder {
        crate::output::create_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterOutput {
    /// <p>A description of the DAX cluster that you have created.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for CreateClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`CreateClusterOutput`](crate::output::CreateClusterOutput)
pub mod create_cluster_output {
    /// A builder for [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>A description of the DAX cluster that you have created.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>A description of the DAX cluster that you have created.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterOutput`](crate::output::CreateClusterOutput)
        pub fn build(self) -> crate::output::CreateClusterOutput {
            crate::output::CreateClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl CreateClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    pub fn builder() -> crate::output::create_cluster_output::Builder {
        crate::output::create_cluster_output::Builder::default()
    }
}
