// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS DataSync
///
/// Client for invoking operations on AWS DataSync. Each operation on AWS DataSync is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_datasync::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_datasync::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_datasync::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelTaskExecution`](crate::client::fluent_builders::CancelTaskExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_execution_arn(impl Into<String>)`](crate::client::fluent_builders::CancelTaskExecution::task_execution_arn) / [`set_task_execution_arn(Option<String>)`](crate::client::fluent_builders::CancelTaskExecution::set_task_execution_arn): <p>The Amazon Resource Name (ARN) of the task execution to cancel.</p>
    /// - On success, responds with [`CancelTaskExecutionOutput`](crate::output::CancelTaskExecutionOutput)

    /// - On failure, responds with [`SdkError<CancelTaskExecutionError>`](crate::error::CancelTaskExecutionError)
    pub fn cancel_task_execution(&self) -> fluent_builders::CancelTaskExecution {
        fluent_builders::CancelTaskExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAgent`](crate::client::fluent_builders::CreateAgent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activation_key(impl Into<String>)`](crate::client::fluent_builders::CreateAgent::activation_key) / [`set_activation_key(Option<String>)`](crate::client::fluent_builders::CreateAgent::set_activation_key): <p>Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.</p>  <p>The redirect URL returned in the response provides you the activation key for your agent in the query string parameter <code>activationKey</code>. It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.</p>  <p>For more information, see Activating an Agent in the <i>DataSync User Guide.</i> </p>
    ///   - [`agent_name(impl Into<String>)`](crate::client::fluent_builders::CreateAgent::agent_name) / [`set_agent_name(Option<String>)`](crate::client::fluent_builders::CreateAgent::set_agent_name): <p>The name you configured for your agent. This value is a text reference that is used to identify the agent in the console.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateAgent::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateAgent::set_tags): <p>The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty string. This value helps you manage, filter, and search for your agents.</p> <note>   <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. </p>  </note>
    ///   - [`vpc_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::CreateAgent::vpc_endpoint_id) / [`set_vpc_endpoint_id(Option<String>)`](crate::client::fluent_builders::CreateAgent::set_vpc_endpoint_id): <p>The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service">Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>  <p>VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.</p>
    ///   - [`subnet_arns(Vec<String>)`](crate::client::fluent_builders::CreateAgent::subnet_arns) / [`set_subnet_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAgent::set_subnet_arns): <p>The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.</p>
    ///   - [`security_group_arns(Vec<String>)`](crate::client::fluent_builders::CreateAgent::security_group_arns) / [`set_security_group_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAgent::set_security_group_arns): <p>The ARNs of the security groups used to protect your data transfer task subnets. See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a>.</p>
    /// - On success, responds with [`CreateAgentOutput`](crate::output::CreateAgentOutput) with field(s):
    ///   - [`agent_arn(Option<String>)`](crate::output::CreateAgentOutput::agent_arn): <p>The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<CreateAgentError>`](crate::error::CreateAgentError)
    pub fn create_agent(&self) -> fluent_builders::CreateAgent {
        fluent_builders::CreateAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationEfs`](crate::client::fluent_builders::CreateLocationEfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationEfs::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationEfs::set_subdirectory): <p>A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination. By default, DataSync uses the root directory.</p> <note>   <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>  </note>
    ///   - [`efs_filesystem_arn(impl Into<String>)`](crate::client::fluent_builders::CreateLocationEfs::efs_filesystem_arn) / [`set_efs_filesystem_arn(Option<String>)`](crate::client::fluent_builders::CreateLocationEfs::set_efs_filesystem_arn): <p>The Amazon Resource Name (ARN) for the Amazon EFS file system.</p>
    ///   - [`ec2_config(Ec2Config)`](crate::client::fluent_builders::CreateLocationEfs::ec2_config) / [`set_ec2_config(Option<Ec2Config>)`](crate::client::fluent_builders::CreateLocationEfs::set_ec2_config): <p>The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified.</p>  <p>The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows: </p>  <ul>   <li> <p> Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group. </p> </li>   <li> <p>Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group.</p> <p>For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and Mount Targets in the <i>Amazon EFS User Guide.</i> </p> </li>  </ul>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationEfs::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationEfs::set_tags): <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
    /// - On success, responds with [`CreateLocationEfsOutput`](crate::output::CreateLocationEfsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationEfsOutput::location_arn): <p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that is created.</p>
    /// - On failure, responds with [`SdkError<CreateLocationEfsError>`](crate::error::CreateLocationEfsError)
    pub fn create_location_efs(&self) -> fluent_builders::CreateLocationEfs {
        fluent_builders::CreateLocationEfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationFsxLustre`](crate::client::fluent_builders::CreateLocationFsxLustre) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fsx_filesystem_arn(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxLustre::fsx_filesystem_arn) / [`set_fsx_filesystem_arn(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxLustre::set_fsx_filesystem_arn): <p>The Amazon Resource Name (ARN) for the FSx for Lustre file system.</p>
    ///   - [`security_group_arns(Vec<String>)`](crate::client::fluent_builders::CreateLocationFsxLustre::security_group_arns) / [`set_security_group_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLocationFsxLustre::set_security_group_arns): <p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file system.</p>
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxLustre::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxLustre::set_subdirectory): <p>A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to read data from the FSx for Lustre source location or write data to the FSx for Lustre destination.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationFsxLustre::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationFsxLustre::set_tags): <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
    /// - On success, responds with [`CreateLocationFsxLustreOutput`](crate::output::CreateLocationFsxLustreOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationFsxLustreOutput::location_arn): <p>The Amazon Resource Name (ARN) of the FSx for Lustre file system location that's created. </p>
    /// - On failure, responds with [`SdkError<CreateLocationFsxLustreError>`](crate::error::CreateLocationFsxLustreError)
    pub fn create_location_fsx_lustre(&self) -> fluent_builders::CreateLocationFsxLustre {
        fluent_builders::CreateLocationFsxLustre::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationFsxWindows`](crate::client::fluent_builders::CreateLocationFsxWindows) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_subdirectory): <p>A subdirectory in the location's path. This subdirectory in the Amazon FSx for Windows File Server file system is used to read data from the Amazon FSx for Windows File Server source location or write data to the FSx for Windows File Server destination.</p>
    ///   - [`fsx_filesystem_arn(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::fsx_filesystem_arn) / [`set_fsx_filesystem_arn(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_fsx_filesystem_arn): <p>The Amazon Resource Name (ARN) for the FSx for Windows File Server file system.</p>
    ///   - [`security_group_arns(Vec<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::security_group_arns) / [`set_security_group_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_security_group_arns): <p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Windows File Server file system.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationFsxWindows::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_tags): <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
    ///   - [`user(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::user) / [`set_user(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_user): <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>  <p>For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="create-fsx-location.html#FSxWuser">user</a>.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_domain): <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateLocationFsxWindows::set_password): <p>The password of the user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
    /// - On success, responds with [`CreateLocationFsxWindowsOutput`](crate::output::CreateLocationFsxWindowsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationFsxWindowsOutput::location_arn): <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server file system location that is created.</p>
    /// - On failure, responds with [`SdkError<CreateLocationFsxWindowsError>`](crate::error::CreateLocationFsxWindowsError)
    pub fn create_location_fsx_windows(&self) -> fluent_builders::CreateLocationFsxWindows {
        fluent_builders::CreateLocationFsxWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationHdfs`](crate::client::fluent_builders::CreateLocationHdfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationHdfs::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationHdfs::set_subdirectory): <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to <code>/</code>.</p>
    ///   - [`name_nodes(Vec<HdfsNameNode>)`](crate::client::fluent_builders::CreateLocationHdfs::name_nodes) / [`set_name_nodes(Option<Vec<HdfsNameNode>>)`](crate::client::fluent_builders::CreateLocationHdfs::set_name_nodes): <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>
    ///   - [`block_size(i32)`](crate::client::fluent_builders::CreateLocationHdfs::block_size) / [`set_block_size(Option<i32>)`](crate::client::fluent_builders::CreateLocationHdfs::set_block_size): <p>The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).</p>
    ///   - [`replication_factor(i32)`](crate::client::fluent_builders::CreateLocationHdfs::replication_factor) / [`set_replication_factor(Option<i32>)`](crate::client::fluent_builders::CreateLocationHdfs::set_replication_factor): <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.</p>
    ///   - [`kms_key_provider_uri(impl Into<String>)`](crate::client::fluent_builders::CreateLocationHdfs::kms_key_provider_uri) / [`set_kms_key_provider_uri(Option<String>)`](crate::client::fluent_builders::CreateLocationHdfs::set_kms_key_provider_uri): <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
    ///   - [`qop_configuration(QopConfiguration)`](crate::client::fluent_builders::CreateLocationHdfs::qop_configuration) / [`set_qop_configuration(Option<QopConfiguration>)`](crate::client::fluent_builders::CreateLocationHdfs::set_qop_configuration): <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code>. If you set <code>RpcProtection</code> or <code>DataTransferProtection</code>, the other parameter assumes the same value. </p>
    ///   - [`authentication_type(HdfsAuthenticationType)`](crate::client::fluent_builders::CreateLocationHdfs::authentication_type) / [`set_authentication_type(Option<HdfsAuthenticationType>)`](crate::client::fluent_builders::CreateLocationHdfs::set_authentication_type): <p>The type of authentication used to determine the identity of the user. </p>
    ///   - [`simple_user(impl Into<String>)`](crate::client::fluent_builders::CreateLocationHdfs::simple_user) / [`set_simple_user(Option<String>)`](crate::client::fluent_builders::CreateLocationHdfs::set_simple_user): <p>The user name used to identify the client on the host operating system. </p> <note>   <p>If <code>SIMPLE</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p>  </note>
    ///   - [`kerberos_principal(impl Into<String>)`](crate::client::fluent_builders::CreateLocationHdfs::kerberos_principal) / [`set_kerberos_principal(Option<String>)`](crate::client::fluent_builders::CreateLocationHdfs::set_kerberos_principal): <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p> <note>   <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p>  </note>
    ///   - [`kerberos_keytab(Blob)`](crate::client::fluent_builders::CreateLocationHdfs::kerberos_keytab) / [`set_kerberos_keytab(Option<Blob>)`](crate::client::fluent_builders::CreateLocationHdfs::set_kerberos_keytab): <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you're using the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note>   <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p>  </note>
    ///   - [`kerberos_krb5_conf(Blob)`](crate::client::fluent_builders::CreateLocationHdfs::kerberos_krb5_conf) / [`set_kerberos_krb5_conf(Option<Blob>)`](crate::client::fluent_builders::CreateLocationHdfs::set_kerberos_krb5_conf): <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file's address. If you're using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note>   <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p>  </note>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::CreateLocationHdfs::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLocationHdfs::set_agent_arns): <p>The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationHdfs::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationHdfs::set_tags): <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. </p>
    /// - On success, responds with [`CreateLocationHdfsOutput`](crate::output::CreateLocationHdfsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationHdfsOutput::location_arn): <p>The ARN of the source HDFS cluster location that's created. </p>
    /// - On failure, responds with [`SdkError<CreateLocationHdfsError>`](crate::error::CreateLocationHdfsError)
    pub fn create_location_hdfs(&self) -> fluent_builders::CreateLocationHdfs {
        fluent_builders::CreateLocationHdfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationNfs`](crate::client::fluent_builders::CreateLocationNfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationNfs::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationNfs::set_subdirectory): <p>The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network. </p>  <p>To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication. </p>  <p>To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure that the permissions for all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.</p>  <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>  <p>For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.</p>
    ///   - [`server_hostname(impl Into<String>)`](crate::client::fluent_builders::CreateLocationNfs::server_hostname) / [`set_server_hostname(Option<String>)`](crate::client::fluent_builders::CreateLocationNfs::set_server_hostname): <p>The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An agent that is installed on-premises uses this host name to mount the NFS server in a network. </p>  <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p> <note>   <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>  </note>
    ///   - [`on_prem_config(OnPremConfig)`](crate::client::fluent_builders::CreateLocationNfs::on_prem_config) / [`set_on_prem_config(Option<OnPremConfig>)`](crate::client::fluent_builders::CreateLocationNfs::set_on_prem_config): <p>Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server. </p>  <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
    ///   - [`mount_options(NfsMountOptions)`](crate::client::fluent_builders::CreateLocationNfs::mount_options) / [`set_mount_options(Option<NfsMountOptions>)`](crate::client::fluent_builders::CreateLocationNfs::set_mount_options): <p>The NFS mount options that DataSync can use to mount your NFS share.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationNfs::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationNfs::set_tags): <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
    /// - On success, responds with [`CreateLocationNfsOutput`](crate::output::CreateLocationNfsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationNfsOutput::location_arn): <p>The Amazon Resource Name (ARN) of the source NFS file system location that is created.</p>
    /// - On failure, responds with [`SdkError<CreateLocationNfsError>`](crate::error::CreateLocationNfsError)
    pub fn create_location_nfs(&self) -> fluent_builders::CreateLocationNfs {
        fluent_builders::CreateLocationNfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationObjectStorage`](crate::client::fluent_builders::CreateLocationObjectStorage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_hostname(impl Into<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::server_hostname) / [`set_server_hostname(Option<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_server_hostname): <p>The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network. </p>
    ///   - [`server_port(i32)`](crate::client::fluent_builders::CreateLocationObjectStorage::server_port) / [`set_server_port(Option<i32>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_server_port): <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.</p>
    ///   - [`server_protocol(ObjectStorageServerProtocol)`](crate::client::fluent_builders::CreateLocationObjectStorage::server_protocol) / [`set_server_protocol(Option<ObjectStorageServerProtocol>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_server_protocol): <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_subdirectory): <p>The subdirectory in the self-managed object storage server that is used to read data from.</p>
    ///   - [`bucket_name(impl Into<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::bucket_name) / [`set_bucket_name(Option<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_bucket_name): <p>The bucket on the self-managed object storage server that is used to read data from.</p>
    ///   - [`access_key(impl Into<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::access_key) / [`set_access_key(Option<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_access_key): <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    ///   - [`secret_key(impl Into<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::secret_key) / [`set_secret_key(Option<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_secret_key): <p>Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::CreateLocationObjectStorage::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_agent_arns): <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationObjectStorage::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationObjectStorage::set_tags): <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
    /// - On success, responds with [`CreateLocationObjectStorageOutput`](crate::output::CreateLocationObjectStorageOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationObjectStorageOutput::location_arn): <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    /// - On failure, responds with [`SdkError<CreateLocationObjectStorageError>`](crate::error::CreateLocationObjectStorageError)
    pub fn create_location_object_storage(&self) -> fluent_builders::CreateLocationObjectStorage {
        fluent_builders::CreateLocationObjectStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationS3`](crate::client::fluent_builders::CreateLocationS3) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationS3::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationS3::set_subdirectory): <p>A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.</p>
    ///   - [`s3_bucket_arn(impl Into<String>)`](crate::client::fluent_builders::CreateLocationS3::s3_bucket_arn) / [`set_s3_bucket_arn(Option<String>)`](crate::client::fluent_builders::CreateLocationS3::set_s3_bucket_arn): <p>The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an access point ARN.</p>
    ///   - [`s3_storage_class(S3StorageClass)`](crate::client::fluent_builders::CreateLocationS3::s3_storage_class) / [`set_s3_storage_class(Option<S3StorageClass>)`](crate::client::fluent_builders::CreateLocationS3::set_s3_storage_class): <p>The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard. For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.</p>  <p>For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
    ///   - [`s3_config(S3Config)`](crate::client::fluent_builders::CreateLocationS3::s3_config) / [`set_s3_config(Option<S3Config>)`](crate::client::fluent_builders::CreateLocationS3::set_s3_config): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket.</p>  <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::CreateLocationS3::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLocationS3::set_agent_arns): <p>If you are using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationS3::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationS3::set_tags): <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
    /// - On success, responds with [`CreateLocationS3Output`](crate::output::CreateLocationS3Output) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationS3Output::location_arn): <p>The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that is created.</p>
    /// - On failure, responds with [`SdkError<CreateLocationS3Error>`](crate::error::CreateLocationS3Error)
    pub fn create_location_s3(&self) -> fluent_builders::CreateLocationS3 {
        fluent_builders::CreateLocationS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocationSmb`](crate::client::fluent_builders::CreateLocationSmb) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::CreateLocationSmb::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::CreateLocationSmb::set_subdirectory): <p>The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.</p> <note>   <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>  </note>  <p>To transfer all the data in the folder you specified, DataSync needs to have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either ensure that the user/password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.</p>
    ///   - [`server_hostname(impl Into<String>)`](crate::client::fluent_builders::CreateLocationSmb::server_hostname) / [`set_server_hostname(Option<String>)`](crate::client::fluent_builders::CreateLocationSmb::set_server_hostname): <p>The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB server in a network.</p> <note>   <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>  </note>
    ///   - [`user(impl Into<String>)`](crate::client::fluent_builders::CreateLocationSmb::user) / [`set_user(Option<String>)`](crate::client::fluent_builders::CreateLocationSmb::set_user): <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>  <p>For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateLocationSmb::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateLocationSmb::set_domain): <p>The name of the Windows domain that the SMB server belongs to.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateLocationSmb::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateLocationSmb::set_password): <p>The password of the user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::CreateLocationSmb::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLocationSmb::set_agent_arns): <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location. </p>
    ///   - [`mount_options(SmbMountOptions)`](crate::client::fluent_builders::CreateLocationSmb::mount_options) / [`set_mount_options(Option<SmbMountOptions>)`](crate::client::fluent_builders::CreateLocationSmb::set_mount_options): <p>The mount options used by DataSync to access the SMB server.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateLocationSmb::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateLocationSmb::set_tags): <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
    /// - On success, responds with [`CreateLocationSmbOutput`](crate::output::CreateLocationSmbOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::CreateLocationSmbOutput::location_arn): <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
    /// - On failure, responds with [`SdkError<CreateLocationSmbError>`](crate::error::CreateLocationSmbError)
    pub fn create_location_smb(&self) -> fluent_builders::CreateLocationSmb {
        fluent_builders::CreateLocationSmb::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTask`](crate::client::fluent_builders::CreateTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_location_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTask::source_location_arn) / [`set_source_location_arn(Option<String>)`](crate::client::fluent_builders::CreateTask::set_source_location_arn): <p>The Amazon Resource Name (ARN) of the source location for the task.</p>
    ///   - [`destination_location_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTask::destination_location_arn) / [`set_destination_location_arn(Option<String>)`](crate::client::fluent_builders::CreateTask::set_destination_location_arn): <p>The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location. </p>
    ///   - [`cloud_watch_log_group_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTask::cloud_watch_log_group_arn) / [`set_cloud_watch_log_group_arn(Option<String>)`](crate::client::fluent_builders::CreateTask::set_cloud_watch_log_group_arn): <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateTask::set_name): <p>The name of a task. This value is a text reference that is used to identify the task in the console. </p>
    ///   - [`options(Options)`](crate::client::fluent_builders::CreateTask::options) / [`set_options(Option<Options>)`](crate::client::fluent_builders::CreateTask::set_options): <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.</p>  <p>For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
    ///   - [`excludes(Vec<FilterRule>)`](crate::client::fluent_builders::CreateTask::excludes) / [`set_excludes(Option<Vec<FilterRule>>)`](crate::client::fluent_builders::CreateTask::set_excludes): <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>  <p> </p>
    ///   - [`schedule(TaskSchedule)`](crate::client::fluent_builders::CreateTask::schedule) / [`set_schedule(Option<TaskSchedule>)`](crate::client::fluent_builders::CreateTask::set_schedule): <p>Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::CreateTask::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::CreateTask::set_tags): <p>The key-value pair that represents the tag that you want to add to the resource. The value can be an empty string. </p>
    ///   - [`includes(Vec<FilterRule>)`](crate::client::fluent_builders::CreateTask::includes) / [`set_includes(Option<Vec<FilterRule>>)`](crate::client::fluent_builders::CreateTask::set_includes): <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
    /// - On success, responds with [`CreateTaskOutput`](crate::output::CreateTaskOutput) with field(s):
    ///   - [`task_arn(Option<String>)`](crate::output::CreateTaskOutput::task_arn): <p>The Amazon Resource Name (ARN) of the task.</p>
    /// - On failure, responds with [`SdkError<CreateTaskError>`](crate::error::CreateTaskError)
    pub fn create_task(&self) -> fluent_builders::CreateTask {
        fluent_builders::CreateTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAgent`](crate::client::fluent_builders::DeleteAgent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agent_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAgent::agent_arn) / [`set_agent_arn(Option<String>)`](crate::client::fluent_builders::DeleteAgent::set_agent_arn): <p>The Amazon Resource Name (ARN) of the agent to delete. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
    /// - On success, responds with [`DeleteAgentOutput`](crate::output::DeleteAgentOutput)

    /// - On failure, responds with [`SdkError<DeleteAgentError>`](crate::error::DeleteAgentError)
    pub fn delete_agent(&self) -> fluent_builders::DeleteAgent {
        fluent_builders::DeleteAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLocation`](crate::client::fluent_builders::DeleteLocation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLocation::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DeleteLocation::set_location_arn): <p>The Amazon Resource Name (ARN) of the location to delete.</p>
    /// - On success, responds with [`DeleteLocationOutput`](crate::output::DeleteLocationOutput)

    /// - On failure, responds with [`SdkError<DeleteLocationError>`](crate::error::DeleteLocationError)
    pub fn delete_location(&self) -> fluent_builders::DeleteLocation {
        fluent_builders::DeleteLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTask`](crate::client::fluent_builders::DeleteTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTask::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::DeleteTask::set_task_arn): <p>The Amazon Resource Name (ARN) of the task to delete.</p>
    /// - On success, responds with [`DeleteTaskOutput`](crate::output::DeleteTaskOutput)

    /// - On failure, responds with [`SdkError<DeleteTaskError>`](crate::error::DeleteTaskError)
    pub fn delete_task(&self) -> fluent_builders::DeleteTask {
        fluent_builders::DeleteTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAgent`](crate::client::fluent_builders::DescribeAgent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agent_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAgent::agent_arn) / [`set_agent_arn(Option<String>)`](crate::client::fluent_builders::DescribeAgent::set_agent_arn): <p>The Amazon Resource Name (ARN) of the agent to describe.</p>
    /// - On success, responds with [`DescribeAgentOutput`](crate::output::DescribeAgentOutput) with field(s):
    ///   - [`agent_arn(Option<String>)`](crate::output::DescribeAgentOutput::agent_arn): <p>The Amazon Resource Name (ARN) of the agent.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeAgentOutput::name): <p>The name of the agent.</p>
    ///   - [`status(Option<AgentStatus>)`](crate::output::DescribeAgentOutput::status): <p>The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent returns to ONLINE status.</p>
    ///   - [`last_connection_time(Option<DateTime>)`](crate::output::DescribeAgentOutput::last_connection_time): <p>The time that the agent last connected to DataSync.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeAgentOutput::creation_time): <p>The time that the agent was activated (that is, created in your account).</p>
    ///   - [`endpoint_type(Option<EndpointType>)`](crate::output::DescribeAgentOutput::endpoint_type): <p>The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not accessible over the public internet. </p>
    ///   - [`private_link_config(Option<PrivateLinkConfig>)`](crate::output::DescribeAgentOutput::private_link_config): <p>The subnet and the security group that DataSync used to access a VPC endpoint.</p>
    /// - On failure, responds with [`SdkError<DescribeAgentError>`](crate::error::DescribeAgentError)
    pub fn describe_agent(&self) -> fluent_builders::DescribeAgent {
        fluent_builders::DescribeAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationEfs`](crate::client::fluent_builders::DescribeLocationEfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationEfs::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationEfs::set_location_arn): <p>The Amazon Resource Name (ARN) of the EFS location to describe.</p>
    /// - On success, responds with [`DescribeLocationEfsOutput`](crate::output::DescribeLocationEfsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationEfsOutput::location_arn): <p>The Amazon Resource Name (ARN) of the EFS location that was described.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationEfsOutput::location_uri): <p>The URL of the EFS location that was described.</p>
    ///   - [`ec2_config(Option<Ec2Config>)`](crate::output::DescribeLocationEfsOutput::ec2_config): <p>The subnet and the security group that DataSync uses to access target EFS file system. The subnet must have at least one mount target for that file system. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. </p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationEfsOutput::creation_time): <p>The time that the EFS location was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationEfsError>`](crate::error::DescribeLocationEfsError)
    pub fn describe_location_efs(&self) -> fluent_builders::DescribeLocationEfs {
        fluent_builders::DescribeLocationEfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationFsxLustre`](crate::client::fluent_builders::DescribeLocationFsxLustre) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationFsxLustre::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationFsxLustre::set_location_arn): <p>The Amazon Resource Name (ARN) of the FSx for Lustre location to describe. </p>
    /// - On success, responds with [`DescribeLocationFsxLustreOutput`](crate::output::DescribeLocationFsxLustreOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationFsxLustreOutput::location_arn): <p>The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationFsxLustreOutput::location_uri): <p>The URI of the FSx for Lustre location that was described.</p>
    ///   - [`security_group_arns(Option<Vec<String>>)`](crate::output::DescribeLocationFsxLustreOutput::security_group_arns): <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Lustre file system.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationFsxLustreOutput::creation_time): <p>The time that the FSx for Lustre location was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationFsxLustreError>`](crate::error::DescribeLocationFsxLustreError)
    pub fn describe_location_fsx_lustre(&self) -> fluent_builders::DescribeLocationFsxLustre {
        fluent_builders::DescribeLocationFsxLustre::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationFsxWindows`](crate::client::fluent_builders::DescribeLocationFsxWindows) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationFsxWindows::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationFsxWindows::set_location_arn): <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location to describe.</p>
    /// - On success, responds with [`DescribeLocationFsxWindowsOutput`](crate::output::DescribeLocationFsxWindowsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationFsxWindowsOutput::location_arn): <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location that was described.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationFsxWindowsOutput::location_uri): <p>The URL of the FSx for Windows File Server location that was described.</p>
    ///   - [`security_group_arns(Option<Vec<String>>)`](crate::output::DescribeLocationFsxWindowsOutput::security_group_arns): <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows File Server file system.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationFsxWindowsOutput::creation_time): <p>The time that the FSx for Windows File Server location was created.</p>
    ///   - [`user(Option<String>)`](crate::output::DescribeLocationFsxWindowsOutput::user): <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
    ///   - [`domain(Option<String>)`](crate::output::DescribeLocationFsxWindowsOutput::domain): <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationFsxWindowsError>`](crate::error::DescribeLocationFsxWindowsError)
    pub fn describe_location_fsx_windows(&self) -> fluent_builders::DescribeLocationFsxWindows {
        fluent_builders::DescribeLocationFsxWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationHdfs`](crate::client::fluent_builders::DescribeLocationHdfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationHdfs::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationHdfs::set_location_arn): <p>The Amazon Resource Name (ARN) of the HDFS cluster location to describe.</p>
    /// - On success, responds with [`DescribeLocationHdfsOutput`](crate::output::DescribeLocationHdfsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationHdfsOutput::location_arn): <p>The ARN of the HDFS cluster location.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationHdfsOutput::location_uri): <p>The URI of the HDFS cluster location.</p>
    ///   - [`name_nodes(Option<Vec<HdfsNameNode>>)`](crate::output::DescribeLocationHdfsOutput::name_nodes): <p>The NameNode that manage the HDFS namespace. </p>
    ///   - [`block_size(Option<i32>)`](crate::output::DescribeLocationHdfsOutput::block_size): <p>The size of the data blocks to write into the HDFS cluster. </p>
    ///   - [`replication_factor(Option<i32>)`](crate::output::DescribeLocationHdfsOutput::replication_factor): <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
    ///   - [`kms_key_provider_uri(Option<String>)`](crate::output::DescribeLocationHdfsOutput::kms_key_provider_uri): <p> The URI of the HDFS cluster's Key Management Server (KMS). </p>
    ///   - [`qop_configuration(Option<QopConfiguration>)`](crate::output::DescribeLocationHdfsOutput::qop_configuration): <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
    ///   - [`authentication_type(Option<HdfsAuthenticationType>)`](crate::output::DescribeLocationHdfsOutput::authentication_type): <p>The type of authentication used to determine the identity of the user. </p>
    ///   - [`simple_user(Option<String>)`](crate::output::DescribeLocationHdfsOutput::simple_user): <p>The user name used to identify the client on the host operating system. This parameter is used if the <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.</p>
    ///   - [`kerberos_principal(Option<String>)`](crate::output::DescribeLocationHdfsOutput::kerberos_principal): <p>The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.</p>
    ///   - [`agent_arns(Option<Vec<String>>)`](crate::output::DescribeLocationHdfsOutput::agent_arns): <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationHdfsOutput::creation_time): <p>The time that the HDFS location was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationHdfsError>`](crate::error::DescribeLocationHdfsError)
    pub fn describe_location_hdfs(&self) -> fluent_builders::DescribeLocationHdfs {
        fluent_builders::DescribeLocationHdfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationNfs`](crate::client::fluent_builders::DescribeLocationNfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationNfs::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationNfs::set_location_arn): <p>The Amazon Resource Name (ARN) of the NFS location to describe.</p>
    /// - On success, responds with [`DescribeLocationNfsOutput`](crate::output::DescribeLocationNfsOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationNfsOutput::location_arn): <p>The Amazon Resource Name (ARN) of the NFS location that was described.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationNfsOutput::location_uri): <p>The URL of the source NFS location that was described.</p>
    ///   - [`on_prem_config(Option<OnPremConfig>)`](crate::output::DescribeLocationNfsOutput::on_prem_config): <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
    ///   - [`mount_options(Option<NfsMountOptions>)`](crate::output::DescribeLocationNfsOutput::mount_options): <p>The NFS mount options that DataSync used to mount your NFS share.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationNfsOutput::creation_time): <p>The time that the NFS location was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationNfsError>`](crate::error::DescribeLocationNfsError)
    pub fn describe_location_nfs(&self) -> fluent_builders::DescribeLocationNfs {
        fluent_builders::DescribeLocationNfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationObjectStorage`](crate::client::fluent_builders::DescribeLocationObjectStorage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationObjectStorage::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationObjectStorage::set_location_arn): <p>The Amazon Resource Name (ARN) of the self-managed object storage server location that was described.</p>
    /// - On success, responds with [`DescribeLocationObjectStorageOutput`](crate::output::DescribeLocationObjectStorageOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationObjectStorageOutput::location_arn): <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to describe.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationObjectStorageOutput::location_uri): <p>The URL of the source self-managed object storage server location that was described.</p>
    ///   - [`access_key(Option<String>)`](crate::output::DescribeLocationObjectStorageOutput::access_key): <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    ///   - [`server_port(Option<i32>)`](crate::output::DescribeLocationObjectStorageOutput::server_port): <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS).</p>
    ///   - [`server_protocol(Option<ObjectStorageServerProtocol>)`](crate::output::DescribeLocationObjectStorageOutput::server_protocol): <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
    ///   - [`agent_arns(Option<Vec<String>>)`](crate::output::DescribeLocationObjectStorageOutput::agent_arns): <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationObjectStorageOutput::creation_time): <p>The time that the self-managed object storage server agent was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationObjectStorageError>`](crate::error::DescribeLocationObjectStorageError)
    pub fn describe_location_object_storage(
        &self,
    ) -> fluent_builders::DescribeLocationObjectStorage {
        fluent_builders::DescribeLocationObjectStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationS3`](crate::client::fluent_builders::DescribeLocationS3) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationS3::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationS3::set_location_arn): <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.</p>
    /// - On success, responds with [`DescribeLocationS3Output`](crate::output::DescribeLocationS3Output) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationS3Output::location_arn): <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationS3Output::location_uri): <p>The URL of the Amazon S3 location that was described.</p>
    ///   - [`s3_storage_class(Option<S3StorageClass>)`](crate::output::DescribeLocationS3Output::s3_storage_class): <p>The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
    ///   - [`s3_config(Option<S3Config>)`](crate::output::DescribeLocationS3Output::s3_config): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket.</p>  <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
    ///   - [`agent_arns(Option<Vec<String>>)`](crate::output::DescribeLocationS3Output::agent_arns): <p>If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationS3Output::creation_time): <p>The time that the Amazon S3 bucket location was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationS3Error>`](crate::error::DescribeLocationS3Error)
    pub fn describe_location_s3(&self) -> fluent_builders::DescribeLocationS3 {
        fluent_builders::DescribeLocationS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocationSmb`](crate::client::fluent_builders::DescribeLocationSmb) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLocationSmb::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::DescribeLocationSmb::set_location_arn): <p>The Amazon Resource Name (ARN) of the SMB location to describe.</p>
    /// - On success, responds with [`DescribeLocationSmbOutput`](crate::output::DescribeLocationSmbOutput) with field(s):
    ///   - [`location_arn(Option<String>)`](crate::output::DescribeLocationSmbOutput::location_arn): <p>The Amazon Resource Name (ARN) of the SMB location that was described.</p>
    ///   - [`location_uri(Option<String>)`](crate::output::DescribeLocationSmbOutput::location_uri): <p>The URL of the source SMB location that was described.</p>
    ///   - [`agent_arns(Option<Vec<String>>)`](crate::output::DescribeLocationSmbOutput::agent_arns): <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
    ///   - [`user(Option<String>)`](crate::output::DescribeLocationSmbOutput::user): <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
    ///   - [`domain(Option<String>)`](crate::output::DescribeLocationSmbOutput::domain): <p>The name of the Windows domain that the SMB server belongs to.</p>
    ///   - [`mount_options(Option<SmbMountOptions>)`](crate::output::DescribeLocationSmbOutput::mount_options): <p>The mount options that are available for DataSync to use to access an SMB location.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeLocationSmbOutput::creation_time): <p>The time that the SMB location was created.</p>
    /// - On failure, responds with [`SdkError<DescribeLocationSmbError>`](crate::error::DescribeLocationSmbError)
    pub fn describe_location_smb(&self) -> fluent_builders::DescribeLocationSmb {
        fluent_builders::DescribeLocationSmb::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTask`](crate::client::fluent_builders::DescribeTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTask::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::DescribeTask::set_task_arn): <p>The Amazon Resource Name (ARN) of the task to describe.</p>
    /// - On success, responds with [`DescribeTaskOutput`](crate::output::DescribeTaskOutput) with field(s):
    ///   - [`task_arn(Option<String>)`](crate::output::DescribeTaskOutput::task_arn): <p>The Amazon Resource Name (ARN) of the task that was described.</p>
    ///   - [`status(Option<TaskStatus>)`](crate::output::DescribeTaskOutput::status): <p>The status of the task that was described.</p>  <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide</i>.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeTaskOutput::name): <p>The name of the task that was described.</p>
    ///   - [`current_task_execution_arn(Option<String>)`](crate::output::DescribeTaskOutput::current_task_execution_arn): <p>The Amazon Resource Name (ARN) of the task execution that is syncing files.</p>
    ///   - [`source_location_arn(Option<String>)`](crate::output::DescribeTaskOutput::source_location_arn): <p>The Amazon Resource Name (ARN) of the source file system's location.</p>
    ///   - [`destination_location_arn(Option<String>)`](crate::output::DescribeTaskOutput::destination_location_arn): <p>The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.</p>
    ///   - [`cloud_watch_log_group_arn(Option<String>)`](crate::output::DescribeTaskOutput::cloud_watch_log_group_arn): <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.</p>  <p>For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch User Guide</i>.</p>
    ///   - [`source_network_interface_arns(Option<Vec<String>>)`](crate::output::DescribeTaskOutput::source_network_interface_arns): <p>The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.</p>
    ///   - [`destination_network_interface_arns(Option<Vec<String>>)`](crate::output::DescribeTaskOutput::destination_network_interface_arns): <p>The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.</p>
    ///   - [`options(Option<Options>)`](crate::output::DescribeTaskOutput::options): <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.</p>  <p>For each individual task execution, you can override these options by specifying the overriding <code>OverrideOptions</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
    ///   - [`excludes(Option<Vec<FilterRule>>)`](crate::output::DescribeTaskOutput::excludes): <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>  <p> </p>
    ///   - [`schedule(Option<TaskSchedule>)`](crate::output::DescribeTaskOutput::schedule): <p>The schedule used to periodically transfer files from a source to a destination location.</p>
    ///   - [`error_code(Option<String>)`](crate::output::DescribeTaskOutput::error_code): <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
    ///   - [`error_detail(Option<String>)`](crate::output::DescribeTaskOutput::error_detail): <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeTaskOutput::creation_time): <p>The time that the task was created.</p>
    ///   - [`includes(Option<Vec<FilterRule>>)`](crate::output::DescribeTaskOutput::includes): <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2</code>".</p>
    /// - On failure, responds with [`SdkError<DescribeTaskError>`](crate::error::DescribeTaskError)
    pub fn describe_task(&self) -> fluent_builders::DescribeTask {
        fluent_builders::DescribeTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTaskExecution`](crate::client::fluent_builders::DescribeTaskExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_execution_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTaskExecution::task_execution_arn) / [`set_task_execution_arn(Option<String>)`](crate::client::fluent_builders::DescribeTaskExecution::set_task_execution_arn): <p>The Amazon Resource Name (ARN) of the task that is being executed.</p>
    /// - On success, responds with [`DescribeTaskExecutionOutput`](crate::output::DescribeTaskExecutionOutput) with field(s):
    ///   - [`task_execution_arn(Option<String>)`](crate::output::DescribeTaskExecutionOutput::task_execution_arn): <p>The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>  <p>For example, a <code>TaskExecution</code> value with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code> executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>. </p>
    ///   - [`status(Option<TaskExecutionStatus>)`](crate::output::DescribeTaskExecutionOutput::status): <p>The status of the task execution. </p>  <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide.</i> </p>
    ///   - [`options(Option<Options>)`](crate::output::DescribeTaskExecutionOutput::options): <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>  <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
    ///   - [`excludes(Option<Vec<FilterRule>>)`](crate::output::DescribeTaskExecutionOutput::excludes): <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>  <p> </p>
    ///   - [`includes(Option<Vec<FilterRule>>)`](crate::output::DescribeTaskExecutionOutput::includes): <p>A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>  <p> </p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeTaskExecutionOutput::start_time): <p>The time that the task execution was started.</p>
    ///   - [`estimated_files_to_transfer(i64)`](crate::output::DescribeTaskExecutionOutput::estimated_files_to_transfer): <p>The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred. </p>
    ///   - [`estimated_bytes_to_transfer(i64)`](crate::output::DescribeTaskExecutionOutput::estimated_bytes_to_transfer): <p>The estimated physical number of bytes that is to be transferred over the network.</p>
    ///   - [`files_transferred(i64)`](crate::output::DescribeTaskExecutionOutput::files_transferred): <p>The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network. </p>  <p>If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.</p>
    ///   - [`bytes_written(i64)`](crate::output::DescribeTaskExecutionOutput::bytes_written): <p>The number of logical bytes written to the destination Amazon Web Services storage resource.</p>
    ///   - [`bytes_transferred(i64)`](crate::output::DescribeTaskExecutionOutput::bytes_transferred): <p>The physical number of bytes transferred over the network.</p>
    ///   - [`result(Option<TaskExecutionResultDetail>)`](crate::output::DescribeTaskExecutionOutput::result): <p>The result of the task execution.</p>
    /// - On failure, responds with [`SdkError<DescribeTaskExecutionError>`](crate::error::DescribeTaskExecutionError)
    pub fn describe_task_execution(&self) -> fluent_builders::DescribeTaskExecution {
        fluent_builders::DescribeTaskExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAgents`](crate::client::fluent_builders::ListAgents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAgents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAgents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAgents::set_max_results): <p>The maximum number of agents to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAgents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAgents::set_next_token): <p>An opaque string that indicates the position at which to begin the next list of agents.</p>
    /// - On success, responds with [`ListAgentsOutput`](crate::output::ListAgentsOutput) with field(s):
    ///   - [`agents(Option<Vec<AgentListEntry>>)`](crate::output::ListAgentsOutput::agents): <p>A list of agents in your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAgentsOutput::next_token): <p>An opaque string that indicates the position at which to begin returning the next list of agents.</p>
    /// - On failure, responds with [`SdkError<ListAgentsError>`](crate::error::ListAgentsError)
    pub fn list_agents(&self) -> fluent_builders::ListAgents {
        fluent_builders::ListAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLocations`](crate::client::fluent_builders::ListLocations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLocations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLocations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLocations::set_max_results): <p>The maximum number of locations to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLocations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLocations::set_next_token): <p>An opaque string that indicates the position at which to begin the next list of locations.</p>
    ///   - [`filters(Vec<LocationFilter>)`](crate::client::fluent_builders::ListLocations::filters) / [`set_filters(Option<Vec<LocationFilter>>)`](crate::client::fluent_builders::ListLocations::set_filters): <p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>
    /// - On success, responds with [`ListLocationsOutput`](crate::output::ListLocationsOutput) with field(s):
    ///   - [`locations(Option<Vec<LocationListEntry>>)`](crate::output::ListLocationsOutput::locations): <p>An array that contains a list of locations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLocationsOutput::next_token): <p>An opaque string that indicates the position at which to begin returning the next list of locations.</p>
    /// - On failure, responds with [`SdkError<ListLocationsError>`](crate::error::ListLocationsError)
    pub fn list_locations(&self) -> fluent_builders::ListLocations {
        fluent_builders::ListLocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The maximum number of locations to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>An opaque string that indicates the position at which to begin the next list of locations.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<TagListEntry>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Array of resource tags.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>An opaque string that indicates the position at which to begin returning the next list of resource tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTaskExecutions`](crate::client::fluent_builders::ListTaskExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTaskExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::ListTaskExecutions::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::ListTaskExecutions::set_task_arn): <p>The Amazon Resource Name (ARN) of the task whose tasks you want to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTaskExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTaskExecutions::set_max_results): <p>The maximum number of executed tasks to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTaskExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTaskExecutions::set_next_token): <p>An opaque string that indicates the position at which to begin the next list of the executed tasks.</p>
    /// - On success, responds with [`ListTaskExecutionsOutput`](crate::output::ListTaskExecutionsOutput) with field(s):
    ///   - [`task_executions(Option<Vec<TaskExecutionListEntry>>)`](crate::output::ListTaskExecutionsOutput::task_executions): <p>A list of executed tasks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTaskExecutionsOutput::next_token): <p>An opaque string that indicates the position at which to begin returning the next list of executed tasks.</p>
    /// - On failure, responds with [`SdkError<ListTaskExecutionsError>`](crate::error::ListTaskExecutionsError)
    pub fn list_task_executions(&self) -> fluent_builders::ListTaskExecutions {
        fluent_builders::ListTaskExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTasks`](crate::client::fluent_builders::ListTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTasks::set_max_results): <p>The maximum number of tasks to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTasks::set_next_token): <p>An opaque string that indicates the position at which to begin the next list of tasks.</p>
    ///   - [`filters(Vec<TaskFilter>)`](crate::client::fluent_builders::ListTasks::filters) / [`set_filters(Option<Vec<TaskFilter>>)`](crate::client::fluent_builders::ListTasks::set_filters): <p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListTasks</code> with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the location.</p>
    /// - On success, responds with [`ListTasksOutput`](crate::output::ListTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<TaskListEntry>>)`](crate::output::ListTasksOutput::tasks): <p>A list of all the tasks that are returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTasksOutput::next_token): <p>An opaque string that indicates the position at which to begin returning the next list of tasks.</p>
    /// - On failure, responds with [`SdkError<ListTasksError>`](crate::error::ListTasksError)
    pub fn list_tasks(&self) -> fluent_builders::ListTasks {
        fluent_builders::ListTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTaskExecution`](crate::client::fluent_builders::StartTaskExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::StartTaskExecution::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::StartTaskExecution::set_task_arn): <p>The Amazon Resource Name (ARN) of the task to start.</p>
    ///   - [`override_options(Options)`](crate::client::fluent_builders::StartTaskExecution::override_options) / [`set_override_options(Option<Options>)`](crate::client::fluent_builders::StartTaskExecution::set_override_options): <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>  <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
    ///   - [`includes(Vec<FilterRule>)`](crate::client::fluent_builders::StartTaskExecution::includes) / [`set_includes(Option<Vec<FilterRule>>)`](crate::client::fluent_builders::StartTaskExecution::set_includes): <p>A list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>  <p> </p>
    ///   - [`excludes(Vec<FilterRule>)`](crate::client::fluent_builders::StartTaskExecution::excludes) / [`set_excludes(Option<Vec<FilterRule>>)`](crate::client::fluent_builders::StartTaskExecution::set_excludes): <p>A list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
    /// - On success, responds with [`StartTaskExecutionOutput`](crate::output::StartTaskExecutionOutput) with field(s):
    ///   - [`task_execution_arn(Option<String>)`](crate::output::StartTaskExecutionOutput::task_execution_arn): <p>The Amazon Resource Name (ARN) of the specific task execution that was started.</p>
    /// - On failure, responds with [`SdkError<StartTaskExecutionError>`](crate::error::StartTaskExecutionError)
    pub fn start_task_execution(&self) -> fluent_builders::StartTaskExecution {
        fluent_builders::StartTaskExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to apply the tag to.</p>
    ///   - [`tags(Vec<TagListEntry>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<TagListEntry>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to apply.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to remove the tag from.</p>
    ///   - [`keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::keys) / [`set_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_keys): <p>The keys in the key-value pair in the tag to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAgent`](crate::client::fluent_builders::UpdateAgent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`agent_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAgent::agent_arn) / [`set_agent_arn(Option<String>)`](crate::client::fluent_builders::UpdateAgent::set_agent_arn): <p>The Amazon Resource Name (ARN) of the agent to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAgent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAgent::set_name): <p>The name that you want to use to configure the agent.</p>
    /// - On success, responds with [`UpdateAgentOutput`](crate::output::UpdateAgentOutput)

    /// - On failure, responds with [`SdkError<UpdateAgentError>`](crate::error::UpdateAgentError)
    pub fn update_agent(&self) -> fluent_builders::UpdateAgent {
        fluent_builders::UpdateAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLocationHdfs`](crate::client::fluent_builders::UpdateLocationHdfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_location_arn): <p>The Amazon Resource Name (ARN) of the source HDFS cluster location.</p>
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_subdirectory): <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster.</p>
    ///   - [`name_nodes(Vec<HdfsNameNode>)`](crate::client::fluent_builders::UpdateLocationHdfs::name_nodes) / [`set_name_nodes(Option<Vec<HdfsNameNode>>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_name_nodes): <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>
    ///   - [`block_size(i32)`](crate::client::fluent_builders::UpdateLocationHdfs::block_size) / [`set_block_size(Option<i32>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_block_size): <p>The size of the data blocks to write into the HDFS cluster. </p>
    ///   - [`replication_factor(i32)`](crate::client::fluent_builders::UpdateLocationHdfs::replication_factor) / [`set_replication_factor(Option<i32>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_replication_factor): <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
    ///   - [`kms_key_provider_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::kms_key_provider_uri) / [`set_kms_key_provider_uri(Option<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_kms_key_provider_uri): <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
    ///   - [`qop_configuration(QopConfiguration)`](crate::client::fluent_builders::UpdateLocationHdfs::qop_configuration) / [`set_qop_configuration(Option<QopConfiguration>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_qop_configuration): <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
    ///   - [`authentication_type(HdfsAuthenticationType)`](crate::client::fluent_builders::UpdateLocationHdfs::authentication_type) / [`set_authentication_type(Option<HdfsAuthenticationType>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_authentication_type): <p>The type of authentication used to determine the identity of the user. </p>
    ///   - [`simple_user(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::simple_user) / [`set_simple_user(Option<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_simple_user): <p>The user name used to identify the client on the host operating system.</p>
    ///   - [`kerberos_principal(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::kerberos_principal) / [`set_kerberos_principal(Option<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_kerberos_principal): <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
    ///   - [`kerberos_keytab(Blob)`](crate::client::fluent_builders::UpdateLocationHdfs::kerberos_keytab) / [`set_kerberos_keytab(Option<Blob>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_kerberos_keytab): <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you use the AWS CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text.</p>
    ///   - [`kerberos_krb5_conf(Blob)`](crate::client::fluent_builders::UpdateLocationHdfs::kerberos_krb5_conf) / [`set_kerberos_krb5_conf(Option<Blob>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_kerberos_krb5_conf): <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file's address. If you're using the AWS CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text.</p>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::UpdateLocationHdfs::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLocationHdfs::set_agent_arns): <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
    /// - On success, responds with [`UpdateLocationHdfsOutput`](crate::output::UpdateLocationHdfsOutput)

    /// - On failure, responds with [`SdkError<UpdateLocationHdfsError>`](crate::error::UpdateLocationHdfsError)
    pub fn update_location_hdfs(&self) -> fluent_builders::UpdateLocationHdfs {
        fluent_builders::UpdateLocationHdfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLocationNfs`](crate::client::fluent_builders::UpdateLocationNfs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationNfs::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::UpdateLocationNfs::set_location_arn): <p>The Amazon Resource Name (ARN) of the NFS location to update.</p>
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationNfs::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::UpdateLocationNfs::set_subdirectory): <p>The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.</p>  <p>To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication. </p>  <p>To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data. To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure that the files you want DataSync to access have permissions that allow read access for all users. Doing either option enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.</p>  <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>  <p>For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.</p>
    ///   - [`on_prem_config(OnPremConfig)`](crate::client::fluent_builders::UpdateLocationNfs::on_prem_config) / [`set_on_prem_config(Option<OnPremConfig>)`](crate::client::fluent_builders::UpdateLocationNfs::set_on_prem_config): <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
    ///   - [`mount_options(NfsMountOptions)`](crate::client::fluent_builders::UpdateLocationNfs::mount_options) / [`set_mount_options(Option<NfsMountOptions>)`](crate::client::fluent_builders::UpdateLocationNfs::set_mount_options): <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
    /// - On success, responds with [`UpdateLocationNfsOutput`](crate::output::UpdateLocationNfsOutput)

    /// - On failure, responds with [`SdkError<UpdateLocationNfsError>`](crate::error::UpdateLocationNfsError)
    pub fn update_location_nfs(&self) -> fluent_builders::UpdateLocationNfs {
        fluent_builders::UpdateLocationNfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLocationObjectStorage`](crate::client::fluent_builders::UpdateLocationObjectStorage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_location_arn): <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.</p>
    ///   - [`server_port(i32)`](crate::client::fluent_builders::UpdateLocationObjectStorage::server_port) / [`set_server_port(Option<i32>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_server_port): <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.</p>
    ///   - [`server_protocol(ObjectStorageServerProtocol)`](crate::client::fluent_builders::UpdateLocationObjectStorage::server_protocol) / [`set_server_protocol(Option<ObjectStorageServerProtocol>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_server_protocol): <p>The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or <code>HTTPS</code>.</p>
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_subdirectory): <p>The subdirectory in the self-managed object storage server that is used to read data from.</p>
    ///   - [`access_key(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::access_key) / [`set_access_key(Option<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_access_key): <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    ///   - [`secret_key(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::secret_key) / [`set_secret_key(Option<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_secret_key): <p>Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLocationObjectStorage::set_agent_arns): <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    /// - On success, responds with [`UpdateLocationObjectStorageOutput`](crate::output::UpdateLocationObjectStorageOutput)

    /// - On failure, responds with [`SdkError<UpdateLocationObjectStorageError>`](crate::error::UpdateLocationObjectStorageError)
    pub fn update_location_object_storage(&self) -> fluent_builders::UpdateLocationObjectStorage {
        fluent_builders::UpdateLocationObjectStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLocationSmb`](crate::client::fluent_builders::UpdateLocationSmb) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`location_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationSmb::location_arn) / [`set_location_arn(Option<String>)`](crate::client::fluent_builders::UpdateLocationSmb::set_location_arn): <p>The Amazon Resource Name (ARN) of the SMB location to update.</p>
    ///   - [`subdirectory(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationSmb::subdirectory) / [`set_subdirectory(Option<String>)`](crate::client::fluent_builders::UpdateLocationSmb::set_subdirectory): <p>The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.</p> <note>   <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>  </note>  <p>To transfer all the data in the folder that you specified, DataSync must have permissions to mount the SMB share and to access all the data in that share. To ensure this, do either of the following:</p>  <ul>   <li> <p>Ensure that the user/password specified belongs to the user who can mount the share and who has the appropriate permissions for all of the files and directories that you want DataSync to access.</p> </li>   <li> <p>Use credentials of a member of the Backup Operators group to mount the share. </p> </li>  </ul>  <p>Doing either of these options enables the agent to access the data. For the agent to access directories, you must also enable all execute access.</p>
    ///   - [`user(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationSmb::user) / [`set_user(Option<String>)`](crate::client::fluent_builders::UpdateLocationSmb::set_user): <p>The user who can mount the share has the permissions to access files and folders in the SMB share.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationSmb::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UpdateLocationSmb::set_domain): <p>The name of the Windows domain that the SMB server belongs to.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::UpdateLocationSmb::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::UpdateLocationSmb::set_password): <p>The password of the user who can mount the share has the permissions to access files and folders in the SMB share.</p>
    ///   - [`agent_arns(Vec<String>)`](crate::client::fluent_builders::UpdateLocationSmb::agent_arns) / [`set_agent_arns(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLocationSmb::set_agent_arns): <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.</p>
    ///   - [`mount_options(SmbMountOptions)`](crate::client::fluent_builders::UpdateLocationSmb::mount_options) / [`set_mount_options(Option<SmbMountOptions>)`](crate::client::fluent_builders::UpdateLocationSmb::set_mount_options): <p>Represents the mount options that are available for DataSync to access an SMB location.</p>
    /// - On success, responds with [`UpdateLocationSmbOutput`](crate::output::UpdateLocationSmbOutput)

    /// - On failure, responds with [`SdkError<UpdateLocationSmbError>`](crate::error::UpdateLocationSmbError)
    pub fn update_location_smb(&self) -> fluent_builders::UpdateLocationSmb {
        fluent_builders::UpdateLocationSmb::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTask`](crate::client::fluent_builders::UpdateTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTask::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::UpdateTask::set_task_arn): <p>The Amazon Resource Name (ARN) of the resource name of the task to update.</p>
    ///   - [`options(Options)`](crate::client::fluent_builders::UpdateTask::options) / [`set_options(Option<Options>)`](crate::client::fluent_builders::UpdateTask::set_options): <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>  <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
    ///   - [`excludes(Vec<FilterRule>)`](crate::client::fluent_builders::UpdateTask::excludes) / [`set_excludes(Option<Vec<FilterRule>>)`](crate::client::fluent_builders::UpdateTask::set_excludes): <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>  <p> </p>
    ///   - [`schedule(TaskSchedule)`](crate::client::fluent_builders::UpdateTask::schedule) / [`set_schedule(Option<TaskSchedule>)`](crate::client::fluent_builders::UpdateTask::set_schedule): <p>Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateTask::set_name): <p>The name of the task to update.</p>
    ///   - [`cloud_watch_log_group_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTask::cloud_watch_log_group_arn) / [`set_cloud_watch_log_group_arn(Option<String>)`](crate::client::fluent_builders::UpdateTask::set_cloud_watch_log_group_arn): <p>The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.</p>
    ///   - [`includes(Vec<FilterRule>)`](crate::client::fluent_builders::UpdateTask::includes) / [`set_includes(Option<Vec<FilterRule>>)`](crate::client::fluent_builders::UpdateTask::set_includes): <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
    /// - On success, responds with [`UpdateTaskOutput`](crate::output::UpdateTaskOutput)

    /// - On failure, responds with [`SdkError<UpdateTaskError>`](crate::error::UpdateTaskError)
    pub fn update_task(&self) -> fluent_builders::UpdateTask {
        fluent_builders::UpdateTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTaskExecution`](crate::client::fluent_builders::UpdateTaskExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_execution_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTaskExecution::task_execution_arn) / [`set_task_execution_arn(Option<String>)`](crate::client::fluent_builders::UpdateTaskExecution::set_task_execution_arn): <p>The Amazon Resource Name (ARN) of the specific task execution that is being updated. </p>
    ///   - [`options(Options)`](crate::client::fluent_builders::UpdateTaskExecution::options) / [`set_options(Option<Options>)`](crate::client::fluent_builders::UpdateTaskExecution::set_options): <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>  <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
    /// - On success, responds with [`UpdateTaskExecutionOutput`](crate::output::UpdateTaskExecutionOutput)

    /// - On failure, responds with [`SdkError<UpdateTaskExecutionError>`](crate::error::UpdateTaskExecutionError)
    pub fn update_task_execution(&self) -> fluent_builders::UpdateTaskExecution {
        fluent_builders::UpdateTaskExecution::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelTaskExecution`.
    ///
    /// <p>Cancels execution of a task. </p>
    /// <p>When you cancel a task execution, the transfer of some files is abruptly interrupted. The contents of files that are transferred to the destination might be incomplete or inconsistent with the source files. However, if you start a new task execution on the same task and you allow the task execution to complete, file content on the destination is complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully complete the transfer when you start the next task execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelTaskExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_task_execution_input::Builder,
    }
    impl CancelTaskExecution {
        /// Creates a new `CancelTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelTaskExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution to cancel.</p>
        pub fn task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution to cancel.</p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAgent`.
    ///
    /// <p>Activates an DataSync agent that you have deployed on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the Amazon Web Services Region that you want to activate the agent in. You activate the agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created in this Amazon Web Services Region.</p>
    /// <p>You can activate the agent in a VPC (virtual private cloud) or provide the agent access to a VPC endpoint so you can run tasks without going over the public internet.</p>
    /// <p>You can use an agent for more than one location. If a task uses multiple agents, all of them need to have status AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run. </p>
    /// <p>Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that ensures minimal interruption to your tasks.</p>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAgent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_agent_input::Builder,
    }
    impl CreateAgent {
        /// Creates a new `CreateAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAgentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.</p>
        /// <p>The redirect URL returned in the response provides you the activation key for your agent in the query string parameter <code>activationKey</code>. It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.</p>
        /// <p>For more information, see Activating an Agent in the <i>DataSync User Guide.</i> </p>
        pub fn activation_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_key(input.into());
            self
        }
        /// <p>Your agent activation key. You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.</p>
        /// <p>The redirect URL returned in the response provides you the activation key for your agent in the query string parameter <code>activationKey</code>. It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.</p>
        /// <p>For more information, see Activating an Agent in the <i>DataSync User Guide.</i> </p>
        pub fn set_activation_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_key(input);
            self
        }
        /// <p>The name you configured for your agent. This value is a text reference that is used to identify the agent in the console.</p>
        pub fn agent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_name(input.into());
            self
        }
        /// <p>The name you configured for your agent. This value is a text reference that is used to identify the agent in the console.</p>
        pub fn set_agent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty string. This value helps you manage, filter, and search for your agents.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. </p>
        /// </note>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to associate with the agent. The value can be an empty string. This value helps you manage, filter, and search for your agents.</p> <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service">Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>
        /// <p>VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.</p>
        pub fn vpc_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service">Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>
        /// <p>VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_id(input);
            self
        }
        /// Appends an item to `SubnetArns`.
        ///
        /// To override the contents of this collection use [`set_subnet_arns`](Self::set_subnet_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.</p>
        pub fn subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.</p>
        pub fn set_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_arns(input);
            self
        }
        /// Appends an item to `SecurityGroupArns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The ARNs of the security groups used to protect your data transfer task subnets. See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a>.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_arns(input.into());
            self
        }
        /// <p>The ARNs of the security groups used to protect your data transfer task subnets. See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a>.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationEfs`.
    ///
    /// <p>Creates an endpoint for an Amazon EFS file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationEfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_efs_input::Builder,
    }
    impl CreateLocationEfs {
        /// Creates a new `CreateLocationEfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationEfsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationEfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination. By default, DataSync uses the root directory.</p> <note>
        /// <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>
        /// </note>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>A subdirectory in the location’s path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination. By default, DataSync uses the root directory.</p> <note>
        /// <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>
        /// </note>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon EFS file system.</p>
        pub fn efs_filesystem_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.efs_filesystem_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon EFS file system.</p>
        pub fn set_efs_filesystem_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_efs_filesystem_arn(input);
            self
        }
        /// <p>The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified.</p>
        /// <p>The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows: </p>
        /// <ul>
        /// <li> <p> Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group. </p> </li>
        /// <li> <p>Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group.</p> <p>For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and Mount Targets in the <i>Amazon EFS User Guide.</i> </p> </li>
        /// </ul>
        pub fn ec2_config(mut self, input: crate::model::Ec2Config) -> Self {
            self.inner = self.inner.ec2_config(input);
            self
        }
        /// <p>The subnet and security group that the Amazon EFS file system uses. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified.</p>
        /// <p>The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows: </p>
        /// <ul>
        /// <li> <p> Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group. </p> </li>
        /// <li> <p>Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group.</p> <p>For information about security groups and mount targets, see Security Groups for Amazon EC2 Instances and Mount Targets in the <i>Amazon EFS User Guide.</i> </p> </li>
        /// </ul>
        pub fn set_ec2_config(
            mut self,
            input: std::option::Option<crate::model::Ec2Config>,
        ) -> Self {
            self.inner = self.inner.set_ec2_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationFsxLustre`.
    ///
    /// <p>Creates an endpoint for an Amazon FSx for Lustre file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationFsxLustre {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_fsx_lustre_input::Builder,
    }
    impl CreateLocationFsxLustre {
        /// Creates a new `CreateLocationFsxLustre`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationFsxLustreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationFsxLustreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the FSx for Lustre file system.</p>
        pub fn fsx_filesystem_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fsx_filesystem_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the FSx for Lustre file system.</p>
        pub fn set_fsx_filesystem_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fsx_filesystem_arn(input);
            self
        }
        /// Appends an item to `SecurityGroupArns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file system.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file system.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_arns(input);
            self
        }
        /// <p>A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to read data from the FSx for Lustre source location or write data to the FSx for Lustre destination.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>A subdirectory in the location's path. This subdirectory in the FSx for Lustre file system is used to read data from the FSx for Lustre source location or write data to the FSx for Lustre destination.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationFsxWindows`.
    ///
    /// <p>Creates an endpoint for an Amazon FSx for Windows File Server file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationFsxWindows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_fsx_windows_input::Builder,
    }
    impl CreateLocationFsxWindows {
        /// Creates a new `CreateLocationFsxWindows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationFsxWindowsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationFsxWindowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the location's path. This subdirectory in the Amazon FSx for Windows File Server file system is used to read data from the Amazon FSx for Windows File Server source location or write data to the FSx for Windows File Server destination.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>A subdirectory in the location's path. This subdirectory in the Amazon FSx for Windows File Server file system is used to read data from the Amazon FSx for Windows File Server source location or write data to the FSx for Windows File Server destination.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the FSx for Windows File Server file system.</p>
        pub fn fsx_filesystem_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fsx_filesystem_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the FSx for Windows File Server file system.</p>
        pub fn set_fsx_filesystem_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fsx_filesystem_arn(input);
            self
        }
        /// Appends an item to `SecurityGroupArns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Windows File Server file system.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Windows File Server file system.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
        /// <p>For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="create-fsx-location.html#FSxWuser">user</a>.</p>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user(input.into());
            self
        }
        /// <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
        /// <p>For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="create-fsx-location.html#FSxWuser">user</a>.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
        /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The password of the user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationHdfs`.
    ///
    /// <p>Creates an endpoint for a Hadoop Distributed File System (HDFS). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationHdfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_hdfs_input::Builder,
    }
    impl CreateLocationHdfs {
        /// Creates a new `CreateLocationHdfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationHdfsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationHdfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to <code>/</code>.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to <code>/</code>.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// Appends an item to `NameNodes`.
        ///
        /// To override the contents of this collection use [`set_name_nodes`](Self::set_name_nodes).
        ///
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn name_nodes(mut self, input: crate::model::HdfsNameNode) -> Self {
            self.inner = self.inner.name_nodes(input);
            self
        }
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn set_name_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
        ) -> Self {
            self.inner = self.inner.set_name_nodes(input);
            self
        }
        /// <p>The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).</p>
        pub fn block_size(mut self, input: i32) -> Self {
            self.inner = self.inner.block_size(input);
            self
        }
        /// <p>The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).</p>
        pub fn set_block_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_size(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.</p>
        pub fn replication_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.replication_factor(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.</p>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_replication_factor(input);
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn kms_key_provider_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_provider_uri(input.into());
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn set_kms_key_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kms_key_provider_uri(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code>. If you set <code>RpcProtection</code> or <code>DataTransferProtection</code>, the other parameter assumes the same value. </p>
        pub fn qop_configuration(mut self, input: crate::model::QopConfiguration) -> Self {
            self.inner = self.inner.qop_configuration(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code>. If you set <code>RpcProtection</code> or <code>DataTransferProtection</code>, the other parameter assumes the same value. </p>
        pub fn set_qop_configuration(
            mut self,
            input: std::option::Option<crate::model::QopConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_qop_configuration(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn authentication_type(mut self, input: crate::model::HdfsAuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::HdfsAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The user name used to identify the client on the host operating system. </p> <note>
        /// <p>If <code>SIMPLE</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p>
        /// </note>
        pub fn simple_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.simple_user(input.into());
            self
        }
        /// <p>The user name used to identify the client on the host operating system. </p> <note>
        /// <p>If <code>SIMPLE</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p>
        /// </note>
        pub fn set_simple_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_simple_user(input);
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p> <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p>
        /// </note>
        pub fn kerberos_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kerberos_principal(input.into());
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p> <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p>
        /// </note>
        pub fn set_kerberos_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_principal(input);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you're using the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p>
        /// </note>
        pub fn kerberos_keytab(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_keytab(input);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you're using the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p>
        /// </note>
        pub fn set_kerberos_keytab(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_keytab(input);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file's address. If you're using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p>
        /// </note>
        pub fn kerberos_krb5_conf(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_krb5_conf(input);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file's address. If you're using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p>
        /// </note>
        pub fn set_kerberos_krb5_conf(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_krb5_conf(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. </p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationNfs`.
    ///
    /// <p>Defines a file system on a Network File System (NFS) server that can be read from or written to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationNfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_nfs_input::Builder,
    }
    impl CreateLocationNfs {
        /// Creates a new `CreateLocationNfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationNfsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationNfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network. </p>
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure that the permissions for all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network. </p>
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure that the permissions for all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An agent that is installed on-premises uses this host name to mount the NFS server in a network. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p> <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>
        /// </note>
        pub fn server_hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_hostname(input.into());
            self
        }
        /// <p>The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An agent that is installed on-premises uses this host name to mount the NFS server in a network. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p> <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>
        /// </note>
        pub fn set_server_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_hostname(input);
            self
        }
        /// <p>Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        pub fn on_prem_config(mut self, input: crate::model::OnPremConfig) -> Self {
            self.inner = self.inner.on_prem_config(input);
            self
        }
        /// <p>Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        pub fn set_on_prem_config(
            mut self,
            input: std::option::Option<crate::model::OnPremConfig>,
        ) -> Self {
            self.inner = self.inner.set_on_prem_config(input);
            self
        }
        /// <p>The NFS mount options that DataSync can use to mount your NFS share.</p>
        pub fn mount_options(mut self, input: crate::model::NfsMountOptions) -> Self {
            self.inner = self.inner.mount_options(input);
            self
        }
        /// <p>The NFS mount options that DataSync can use to mount your NFS share.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::NfsMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationObjectStorage`.
    ///
    /// <p>Creates an endpoint for a self-managed object storage bucket. For more information about self-managed object storage locations, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a location for object storage</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationObjectStorage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_object_storage_input::Builder,
    }
    impl CreateLocationObjectStorage {
        /// Creates a new `CreateLocationObjectStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationObjectStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationObjectStorageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network. </p>
        pub fn server_hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_hostname(input.into());
            self
        }
        /// <p>The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network. </p>
        pub fn set_server_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_hostname(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.</p>
        pub fn server_port(mut self, input: i32) -> Self {
            self.inner = self.inner.server_port(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.</p>
        pub fn set_server_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_server_port(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
        pub fn server_protocol(mut self, input: crate::model::ObjectStorageServerProtocol) -> Self {
            self.inner = self.inner.server_protocol(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::ObjectStorageServerProtocol>,
        ) -> Self {
            self.inner = self.inner.set_server_protocol(input);
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used to read data from.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used to read data from.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The bucket on the self-managed object storage server that is used to read data from.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(input.into());
            self
        }
        /// <p>The bucket on the self-managed object storage server that is used to read data from.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key(input.into());
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn set_access_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_key(input);
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_key(input.into());
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_key(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationS3`.
    ///
    /// <p>Creates an endpoint for an Amazon S3 bucket.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli">Create an Amazon S3 location</a> in the <i>DataSync User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationS3 {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_s3_input::Builder,
    }
    impl CreateLocationS3 {
        /// Creates a new `CreateLocationS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationS3Output,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationS3Error>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read data from the S3 source location or write data to the S3 destination.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an access point ARN.</p>
        pub fn s3_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an access point ARN.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_arn(input);
            self
        }
        /// <p>The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard. For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.</p>
        /// <p>For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
        pub fn s3_storage_class(mut self, input: crate::model::S3StorageClass) -> Self {
            self.inner = self.inner.s3_storage_class(input);
            self
        }
        /// <p>The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard. For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.</p>
        /// <p>For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
        pub fn set_s3_storage_class(
            mut self,
            input: std::option::Option<crate::model::S3StorageClass>,
        ) -> Self {
            self.inner = self.inner.set_s3_storage_class(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket.</p>
        /// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
        pub fn s3_config(mut self, input: crate::model::S3Config) -> Self {
            self.inner = self.inner.s3_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that is used to access an Amazon S3 bucket.</p>
        /// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
        pub fn set_s3_config(mut self, input: std::option::Option<crate::model::S3Config>) -> Self {
            self.inner = self.inner.set_s3_config(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>If you are using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>If you are using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of the DataSync agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationSmb`.
    ///
    /// <p>Defines a file system on a Server Message Block (SMB) server that can be read from or written to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocationSmb {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_location_smb_input::Builder,
    }
    impl CreateLocationSmb {
        /// Creates a new `CreateLocationSmb`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationSmbOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationSmbError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.</p> <note>
        /// <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>
        /// </note>
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either ensure that the user/password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.</p> <note>
        /// <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>
        /// </note>
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either ensure that the user/password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB server in a network.</p> <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>
        /// </note>
        pub fn server_hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_hostname(input.into());
            self
        }
        /// <p>The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB server in a network.</p> <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>
        /// </note>
        pub fn set_server_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_hostname(input);
            self
        }
        /// <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
        /// <p>For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user(input.into());
            self
        }
        /// <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
        /// <p>For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The password of the user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location. </p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location. </p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// <p>The mount options used by DataSync to access the SMB server.</p>
        pub fn mount_options(mut self, input: crate::model::SmbMountOptions) -> Self {
            self.inner = self.inner.mount_options(input);
            self
        }
        /// <p>The mount options used by DataSync to access the SMB server.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::SmbMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTask`.
    ///
    /// <p>Creates a task.</p>
    /// <p>A task includes a source location and a destination location, and a configuration that specifies how data is transferred. A task always transfers data from the source location to the destination location. The configuration specifies options such as task scheduling, bandwidth limits, etc. A task is the complete definition of a data transfer.</p>
    /// <p>When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions, one of the two locations that you specify must reside in the Region where DataSync is being used. The other location must be specified in a different Region.</p>
    /// <p>You can transfer data between commercial Amazon Web Services Regions except for China, or between Amazon Web Services GovCloud (US) Regions.</p> <important>
    /// <p>When you use DataSync to copy files or objects between Amazon Web Services Regions, you pay for data transfer between Regions. This is billed as data transfer OUT from your source Region to your destination Region. For more information, see <a href="http://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer">Data Transfer pricing</a>. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_task_input::Builder,
    }
    impl CreateTask {
        /// Creates a new `CreateTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the source location for the task.</p>
        pub fn source_location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source location for the task.</p>
        pub fn set_source_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_location_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location. </p>
        pub fn destination_location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location. </p>
        pub fn set_destination_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_location_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task. </p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_log_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task. </p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_log_group_arn(input);
            self
        }
        /// <p>The name of a task. This value is a text reference that is used to identify the task in the console. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of a task. This value is a text reference that is used to identify the task in the console. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.</p>
        /// <p>For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
        pub fn options(mut self, input: crate::model::Options) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.</p>
        /// <p>For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p> </p>
        pub fn excludes(mut self, input: crate::model::FilterRule) -> Self {
            self.inner = self.inner.excludes(input);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p> </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_excludes(input);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn schedule(mut self, input: crate::model::TaskSchedule) -> Self {
            self.inner = self.inner.schedule(input);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination location. The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::TaskSchedule>,
        ) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the resource. The value can be an empty string. </p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the resource. The value can be an empty string. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn includes(mut self, input: crate::model::FilterRule) -> Self {
            self.inner = self.inner.includes(input);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_includes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAgent`.
    ///
    /// <p>Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN) of the agent in your request. The operation disassociates the agent from your Amazon Web Services account. However, it doesn't delete the agent virtual machine (VM) from your on-premises environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAgent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_agent_input::Builder,
    }
    impl DeleteAgent {
        /// Creates a new `DeleteAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAgentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to delete. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
        pub fn agent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to delete. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLocation`.
    ///
    /// <p>Deletes the configuration of a location used by DataSync. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLocation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_location_input::Builder,
    }
    impl DeleteLocation {
        /// Creates a new `DeleteLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLocationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the location to delete.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the location to delete.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTask`.
    ///
    /// <p>Deletes a task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_task_input::Builder,
    }
    impl DeleteTask {
        /// Creates a new `DeleteTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task to delete.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task to delete.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAgent`.
    ///
    /// <p>Returns metadata such as the name, the network interfaces, and the status (that is, whether the agent is running or not) for an agent. To specify which agent to describe, use the Amazon Resource Name (ARN) of the agent in your request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAgent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_agent_input::Builder,
    }
    impl DescribeAgent {
        /// Creates a new `DescribeAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAgentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to describe.</p>
        pub fn agent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to describe.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationEfs`.
    ///
    /// <p>Returns metadata, such as the path information about an Amazon EFS location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationEfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_efs_input::Builder,
    }
    impl DescribeLocationEfs {
        /// Creates a new `DescribeLocationEfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationEfsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationEfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the EFS location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the EFS location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationFsxLustre`.
    ///
    /// <p>Returns metadata, such as the path information about an Amazon FSx for Lustre location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationFsxLustre {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_fsx_lustre_input::Builder,
    }
    impl DescribeLocationFsxLustre {
        /// Creates a new `DescribeLocationFsxLustre`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationFsxLustreOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationFsxLustreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre location to describe. </p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre location to describe. </p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationFsxWindows`.
    ///
    /// <p>Returns metadata, such as the path information about an Amazon FSx for Windows File Server location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationFsxWindows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_fsx_windows_input::Builder,
    }
    impl DescribeLocationFsxWindows {
        /// Creates a new `DescribeLocationFsxWindows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationFsxWindowsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationFsxWindowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationHdfs`.
    ///
    /// <p>Returns metadata, such as the authentication information about the Hadoop Distributed File System (HDFS) location. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationHdfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_hdfs_input::Builder,
    }
    impl DescribeLocationHdfs {
        /// Creates a new `DescribeLocationHdfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationHdfsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationHdfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the HDFS cluster location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the HDFS cluster location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationNfs`.
    ///
    /// <p>Returns metadata, such as the path information, about an NFS location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationNfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_nfs_input::Builder,
    }
    impl DescribeLocationNfs {
        /// Creates a new `DescribeLocationNfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationNfsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationNfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationObjectStorage`.
    ///
    /// <p>Returns metadata about a self-managed object storage server location. For more information about self-managed object storage locations, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a location for object storage</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationObjectStorage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_object_storage_input::Builder,
    }
    impl DescribeLocationObjectStorage {
        /// Creates a new `DescribeLocationObjectStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationObjectStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationObjectStorageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationS3`.
    ///
    /// <p>Returns metadata, such as bucket name, about an Amazon S3 bucket location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationS3 {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_s3_input::Builder,
    }
    impl DescribeLocationS3 {
        /// Creates a new `DescribeLocationS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationS3Output,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationS3Error>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationSmb`.
    ///
    /// <p>Returns metadata, such as the path and user information about an SMB location.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLocationSmb {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_location_smb_input::Builder,
    }
    impl DescribeLocationSmb {
        /// Creates a new `DescribeLocationSmb`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationSmbOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationSmbError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTask`.
    ///
    /// <p>Returns metadata about a task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_task_input::Builder,
    }
    impl DescribeTask {
        /// Creates a new `DescribeTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task to describe.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task to describe.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTaskExecution`.
    ///
    /// <p>Returns detailed metadata about a task that is being executed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTaskExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_task_execution_input::Builder,
    }
    impl DescribeTaskExecution {
        /// Creates a new `DescribeTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task that is being executed.</p>
        pub fn task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that is being executed.</p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAgents`.
    ///
    /// <p>Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the request. The returned list is ordered by agent Amazon Resource Name (ARN).</p>
    /// <p>By default, this operation returns a maximum of 100 agents. This operation supports pagination that enables you to optionally reduce the number of agents returned in a response.</p>
    /// <p>If you have more agents than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a marker that you can specify in your next request to fetch the next page of agents.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAgents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_agents_input::Builder,
    }
    impl ListAgents {
        /// Creates a new `ListAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAgentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAgentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAgentsPaginator {
            crate::paginator::ListAgentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of agents to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of agents to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of agents.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of agents.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLocations`.
    ///
    /// <p>Returns a list of source and destination locations.</p>
    /// <p>If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLocations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_locations_input::Builder,
    }
    impl ListLocations {
        /// Creates a new `ListLocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLocationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLocationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLocationsPaginator {
            crate::paginator::ListLocationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of locations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of locations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>
        pub fn filters(mut self, input: crate::model::LocationFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns all the tags associated with a specified resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of locations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of locations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTaskExecutions`.
    ///
    /// <p>Returns a list of executed tasks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTaskExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_task_executions_input::Builder,
    }
    impl ListTaskExecutions {
        /// Creates a new `ListTaskExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTaskExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTaskExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTaskExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTaskExecutionsPaginator {
            crate::paginator::ListTaskExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the task whose tasks you want to list.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task whose tasks you want to list.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>The maximum number of executed tasks to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of executed tasks to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of the executed tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of the executed tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTasks`.
    ///
    /// <p>Returns a list of all the tasks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tasks_input::Builder,
    }
    impl ListTasks {
        /// Creates a new `ListTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTasksPaginator {
            crate::paginator::ListTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of tasks to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tasks to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListTasks</code> with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the location.</p>
        pub fn filters(mut self, input: crate::model::TaskFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListTasks</code> with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the location.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTaskExecution`.
    ///
    /// <p>Starts a specific invocation of a task. A <code>TaskExecution</code> value represents an individual run of a task. Each task can have at most one <code>TaskExecution</code> at a time.</p>
    /// <p> <code>TaskExecution</code> has the following transition phases: INITIALIZING | PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE. </p>
    /// <p>For detailed information, see the Task Execution section in the Components and Terminology topic in the <i>DataSync User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTaskExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_task_execution_input::Builder,
    }
    impl StartTaskExecution {
        /// Creates a new `StartTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTaskExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task to start.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task to start.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn override_options(mut self, input: crate::model::Options) -> Self {
            self.inner = self.inner.override_options(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_override_options(
            mut self,
            input: std::option::Option<crate::model::Options>,
        ) -> Self {
            self.inner = self.inner.set_override_options(input);
            self
        }
        /// Appends an item to `Includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p> </p>
        pub fn includes(mut self, input: crate::model::FilterRule) -> Self {
            self.inner = self.inner.includes(input);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p> </p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_includes(input);
            self
        }
        /// Appends an item to `Excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        pub fn excludes(mut self, input: crate::model::FilterRule) -> Self {
            self.inner = self.inner.excludes(input);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_excludes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies a key-value pair to an Amazon Web Services resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply the tag to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply the tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an Amazon Web Services resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tag from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys in the key-value pair in the tag to remove.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keys(input.into());
            self
        }
        /// <p>The keys in the key-value pair in the tag to remove.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAgent`.
    ///
    /// <p>Updates the name of an agent.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAgent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_agent_input::Builder,
    }
    impl UpdateAgent {
        /// Creates a new `UpdateAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAgentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to update.</p>
        pub fn agent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to update.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_arn(input);
            self
        }
        /// <p>The name that you want to use to configure the agent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to use to configure the agent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationHdfs`.
    ///
    /// <p>Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLocationHdfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_location_hdfs_input::Builder,
    }
    impl UpdateLocationHdfs {
        /// Creates a new `UpdateLocationHdfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationHdfsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationHdfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the source HDFS cluster location.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source HDFS cluster location.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// Appends an item to `NameNodes`.
        ///
        /// To override the contents of this collection use [`set_name_nodes`](Self::set_name_nodes).
        ///
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn name_nodes(mut self, input: crate::model::HdfsNameNode) -> Self {
            self.inner = self.inner.name_nodes(input);
            self
        }
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn set_name_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
        ) -> Self {
            self.inner = self.inner.set_name_nodes(input);
            self
        }
        /// <p>The size of the data blocks to write into the HDFS cluster. </p>
        pub fn block_size(mut self, input: i32) -> Self {
            self.inner = self.inner.block_size(input);
            self
        }
        /// <p>The size of the data blocks to write into the HDFS cluster. </p>
        pub fn set_block_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_size(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
        pub fn replication_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.replication_factor(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_replication_factor(input);
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn kms_key_provider_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_provider_uri(input.into());
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn set_kms_key_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kms_key_provider_uri(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
        pub fn qop_configuration(mut self, input: crate::model::QopConfiguration) -> Self {
            self.inner = self.inner.qop_configuration(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
        pub fn set_qop_configuration(
            mut self,
            input: std::option::Option<crate::model::QopConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_qop_configuration(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn authentication_type(mut self, input: crate::model::HdfsAuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::HdfsAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The user name used to identify the client on the host operating system.</p>
        pub fn simple_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.simple_user(input.into());
            self
        }
        /// <p>The user name used to identify the client on the host operating system.</p>
        pub fn set_simple_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_simple_user(input);
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
        pub fn kerberos_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kerberos_principal(input.into());
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
        pub fn set_kerberos_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_principal(input);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you use the AWS CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text.</p>
        pub fn kerberos_keytab(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_keytab(input);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file's address. If you use the AWS CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text.</p>
        pub fn set_kerberos_keytab(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_keytab(input);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file's address. If you're using the AWS CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text.</p>
        pub fn kerberos_krb5_conf(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_krb5_conf(input);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file's address. If you're using the AWS CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text.</p>
        pub fn set_kerberos_krb5_conf(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_krb5_conf(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationNfs`.
    ///
    /// <p>Updates some of the parameters of a previously created location for Network File System (NFS) access. For information about creating an NFS location, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Creating a location for NFS</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLocationNfs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_location_nfs_input::Builder,
    }
    impl UpdateLocationNfs {
        /// Creates a new `UpdateLocationNfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationNfsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationNfsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to update.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to update.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.</p>
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data. To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure that the files you want DataSync to access have permissions that allow read access for all users. Doing either option enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your network.</p>
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e nfs-server-name</code>" from an NFS client that has access to your server. You can specify any directory that appears in the results, and any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder that you specified, DataSync must have permissions to read all the data. To ensure this, either configure the NFS export with <code>no_root_squash</code>, or ensure that the files you want DataSync to access have permissions that allow read access for all users. Doing either option enables the agent to read the files. For the agent to access directories, you must additionally enable all execute access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
        pub fn on_prem_config(mut self, input: crate::model::OnPremConfig) -> Self {
            self.inner = self.inner.on_prem_config(input);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
        pub fn set_on_prem_config(
            mut self,
            input: std::option::Option<crate::model::OnPremConfig>,
        ) -> Self {
            self.inner = self.inner.set_on_prem_config(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
        pub fn mount_options(mut self, input: crate::model::NfsMountOptions) -> Self {
            self.inner = self.inner.mount_options(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::NfsMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationObjectStorage`.
    ///
    /// <p>Updates some of the parameters of a previously created location for self-managed object storage server access. For information about creating a self-managed object storage location, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a location for object storage</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLocationObjectStorage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_location_object_storage_input::Builder,
    }
    impl UpdateLocationObjectStorage {
        /// Creates a new `UpdateLocationObjectStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationObjectStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationObjectStorageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.</p>
        pub fn server_port(mut self, input: i32) -> Self {
            self.inner = self.inner.server_port(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can specify a custom port if your self-managed object storage server requires one.</p>
        pub fn set_server_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_server_port(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or <code>HTTPS</code>.</p>
        pub fn server_protocol(mut self, input: crate::model::ObjectStorageServerProtocol) -> Self {
            self.inner = self.inner.server_protocol(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are <code>HTTP</code> or <code>HTTPS</code>.</p>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::ObjectStorageServerProtocol>,
        ) -> Self {
            self.inner = self.inner.set_server_protocol(input);
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used to read data from.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used to read data from.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key(input.into());
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn set_access_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_key(input);
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn secret_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_key(input.into());
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_key(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationSmb`.
    ///
    /// <p>Updates some of the parameters of a previously created location for Server Message Block (SMB) file system access. For information about creating an SMB location, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html">Creating a location for SMB</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLocationSmb {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_location_smb_input::Builder,
    }
    impl UpdateLocationSmb {
        /// Creates a new `UpdateLocationSmb`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationSmbOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationSmbError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to update.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to update.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.</p> <note>
        /// <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>
        /// </note>
        /// <p>To transfer all the data in the folder that you specified, DataSync must have permissions to mount the SMB share and to access all the data in that share. To ensure this, do either of the following:</p>
        /// <ul>
        /// <li> <p>Ensure that the user/password specified belongs to the user who can mount the share and who has the appropriate permissions for all of the files and directories that you want DataSync to access.</p> </li>
        /// <li> <p>Use credentials of a member of the Backup Operators group to mount the share. </p> </li>
        /// </ul>
        /// <p>Doing either of these options enables the agent to access the data. For the agent to access directories, you must also enable all execute access.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(input.into());
            self
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.</p> <note>
        /// <p> <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code>.</p>
        /// </note>
        /// <p>To transfer all the data in the folder that you specified, DataSync must have permissions to mount the SMB share and to access all the data in that share. To ensure this, do either of the following:</p>
        /// <ul>
        /// <li> <p>Ensure that the user/password specified belongs to the user who can mount the share and who has the appropriate permissions for all of the files and directories that you want DataSync to access.</p> </li>
        /// <li> <p>Use credentials of a member of the Backup Operators group to mount the share. </p> </li>
        /// </ul>
        /// <p>Doing either of these options enables the agent to access the data. For the agent to access directories, you must also enable all execute access.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The user who can mount the share has the permissions to access files and folders in the SMB share.</p>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user(input.into());
            self
        }
        /// <p>The user who can mount the share has the permissions to access files and folders in the SMB share.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The password of the user who can mount the share has the permissions to access files and folders in the SMB share.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password of the user who can mount the share has the permissions to access files and folders in the SMB share.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an SMB location.</p>
        pub fn mount_options(mut self, input: crate::model::SmbMountOptions) -> Self {
            self.inner = self.inner.mount_options(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an SMB location.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::SmbMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTask`.
    ///
    /// <p>Updates the metadata associated with a task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_task_input::Builder,
    }
    impl UpdateTask {
        /// Creates a new `UpdateTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the task to update.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the task to update.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn options(mut self, input: crate::model::Options) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        /// <p> </p>
        pub fn excludes(mut self, input: crate::model::FilterRule) -> Self {
            self.inner = self.inner.excludes(input);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        /// <p> </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_excludes(input);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn schedule(mut self, input: crate::model::TaskSchedule) -> Self {
            self.inner = self.inner.schedule(input);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::TaskSchedule>,
        ) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The name of the task to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the task to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.</p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_log_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.</p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_log_group_arn(input);
            self
        }
        /// Appends an item to `Includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn includes(mut self, input: crate::model::FilterRule) -> Self {
            self.inner = self.inner.includes(input);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_includes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTaskExecution`.
    ///
    /// <p>Updates execution of a task.</p>
    /// <p>You can modify bandwidth throttling for a task execution that is running or queued. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling">Adjusting Bandwidth Throttling for a Task Execution</a>.</p> <note>
    /// <p>The only <code>Option</code> that can be modified by <code>UpdateTaskExecution</code> is <code> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> </code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTaskExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_task_execution_input::Builder,
    }
    impl UpdateTaskExecution {
        /// Creates a new `UpdateTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTaskExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the specific task execution that is being updated. </p>
        pub fn task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specific task execution that is being updated. </p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_execution_arn(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn options(mut self, input: crate::model::Options) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
