// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_task_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelTaskExecutionOutput,
    crate::error::CancelTaskExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelTaskExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelTaskExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CancelTaskExecutionError {
                meta: generic,
                kind: crate::error::CancelTaskExecutionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelTaskExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CancelTaskExecutionError {
            meta: generic,
            kind: crate::error::CancelTaskExecutionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelTaskExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelTaskExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_task_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelTaskExecutionOutput,
    crate::error::CancelTaskExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_task_execution_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_agent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAgentOutput, crate::error::CreateAgentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAgentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAgentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateAgentError {
                meta: generic,
                kind: crate::error::CreateAgentErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAgentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateAgentError {
            meta: generic,
            kind: crate::error::CreateAgentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAgentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_agent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAgentOutput, crate::error::CreateAgentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_agent_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_agent(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAgentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_efs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationEfsOutput, crate::error::CreateLocationEfsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationEfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLocationEfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationEfsError {
                meta: generic,
                kind: crate::error::CreateLocationEfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationEfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationEfsError {
            meta: generic,
            kind: crate::error::CreateLocationEfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationEfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationEfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_efs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationEfsOutput, crate::error::CreateLocationEfsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_efs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_efs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationEfsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_fsx_windows_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLocationFsxWindowsOutput,
    crate::error::CreateLocationFsxWindowsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationFsxWindowsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateLocationFsxWindowsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationFsxWindowsError {
                meta: generic,
                kind: crate::error::CreateLocationFsxWindowsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationFsxWindowsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationFsxWindowsError {
            meta: generic,
            kind: crate::error::CreateLocationFsxWindowsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationFsxWindowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationFsxWindowsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_fsx_windows_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLocationFsxWindowsOutput,
    crate::error::CreateLocationFsxWindowsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_fsx_windows_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_fsx_windows(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationFsxWindowsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_hdfs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLocationHdfsOutput,
    crate::error::CreateLocationHdfsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationHdfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLocationHdfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationHdfsError {
                meta: generic,
                kind: crate::error::CreateLocationHdfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationHdfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationHdfsError {
            meta: generic,
            kind: crate::error::CreateLocationHdfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationHdfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationHdfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_hdfs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLocationHdfsOutput,
    crate::error::CreateLocationHdfsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_hdfs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_hdfs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationHdfsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_nfs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationNfsOutput, crate::error::CreateLocationNfsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationNfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLocationNfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationNfsError {
                meta: generic,
                kind: crate::error::CreateLocationNfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationNfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationNfsError {
            meta: generic,
            kind: crate::error::CreateLocationNfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationNfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationNfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_nfs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationNfsOutput, crate::error::CreateLocationNfsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_nfs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_nfs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationNfsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_object_storage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLocationObjectStorageOutput,
    crate::error::CreateLocationObjectStorageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationObjectStorageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateLocationObjectStorageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationObjectStorageError {
                meta: generic,
                kind: crate::error::CreateLocationObjectStorageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationObjectStorageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationObjectStorageError {
            meta: generic,
            kind: crate::error::CreateLocationObjectStorageErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationObjectStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationObjectStorageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_object_storage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLocationObjectStorageOutput,
    crate::error::CreateLocationObjectStorageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_object_storage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_object_storage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationObjectStorageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_s3_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationS3Output, crate::error::CreateLocationS3Error>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationS3Error::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLocationS3Error::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationS3Error {
                meta: generic,
                kind: crate::error::CreateLocationS3ErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationS3Error::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationS3Error {
            meta: generic,
            kind: crate::error::CreateLocationS3ErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationS3Error::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_s3_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationS3Output, crate::error::CreateLocationS3Error>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_s3_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_s3(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationS3Error::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_smb_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationSmbOutput, crate::error::CreateLocationSmbError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLocationSmbError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLocationSmbError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateLocationSmbError {
                meta: generic,
                kind: crate::error::CreateLocationSmbErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationSmbError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateLocationSmbError {
            meta: generic,
            kind: crate::error::CreateLocationSmbErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLocationSmbError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLocationSmbError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_location_smb_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateLocationSmbOutput, crate::error::CreateLocationSmbError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_location_smb_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_location_smb(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLocationSmbError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTaskOutput, crate::error::CreateTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::CreateTaskError {
                meta: generic,
                kind: crate::error::CreateTaskErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::CreateTaskError {
            meta: generic,
            kind: crate::error::CreateTaskErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTaskOutput, crate::error::CreateTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_agent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAgentOutput, crate::error::DeleteAgentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAgentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAgentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DeleteAgentError {
                meta: generic,
                kind: crate::error::DeleteAgentErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAgentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DeleteAgentError {
            meta: generic,
            kind: crate::error::DeleteAgentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAgentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_agent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAgentOutput, crate::error::DeleteAgentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_agent_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_location_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteLocationOutput, crate::error::DeleteLocationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLocationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLocationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DeleteLocationError {
                meta: generic,
                kind: crate::error::DeleteLocationErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLocationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DeleteLocationError {
            meta: generic,
            kind: crate::error::DeleteLocationErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLocationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLocationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_location_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteLocationOutput, crate::error::DeleteLocationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_location_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTaskOutput, crate::error::DeleteTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DeleteTaskError {
                meta: generic,
                kind: crate::error::DeleteTaskErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DeleteTaskError {
            meta: generic,
            kind: crate::error::DeleteTaskErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTaskOutput, crate::error::DeleteTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_task_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_agent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAgentOutput, crate::error::DescribeAgentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAgentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAgentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeAgentError {
                meta: generic,
                kind: crate::error::DescribeAgentErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeAgentError {
            meta: generic,
            kind: crate::error::DescribeAgentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAgentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_agent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAgentOutput, crate::error::DescribeAgentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_agent_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_agent(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAgentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_efs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationEfsOutput,
    crate::error::DescribeLocationEfsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationEfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLocationEfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationEfsError {
                meta: generic,
                kind: crate::error::DescribeLocationEfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationEfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationEfsError {
            meta: generic,
            kind: crate::error::DescribeLocationEfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationEfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationEfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_efs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationEfsOutput,
    crate::error::DescribeLocationEfsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_efs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_location_efs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLocationEfsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_fsx_windows_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationFsxWindowsOutput,
    crate::error::DescribeLocationFsxWindowsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationFsxWindowsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLocationFsxWindowsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationFsxWindowsError {
                meta: generic,
                kind: crate::error::DescribeLocationFsxWindowsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationFsxWindowsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationFsxWindowsError {
            meta: generic,
            kind: crate::error::DescribeLocationFsxWindowsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationFsxWindowsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationFsxWindowsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_fsx_windows_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationFsxWindowsOutput,
    crate::error::DescribeLocationFsxWindowsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_fsx_windows_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_location_fsx_windows(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLocationFsxWindowsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_hdfs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationHdfsOutput,
    crate::error::DescribeLocationHdfsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationHdfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLocationHdfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationHdfsError {
                meta: generic,
                kind: crate::error::DescribeLocationHdfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationHdfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationHdfsError {
            meta: generic,
            kind: crate::error::DescribeLocationHdfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationHdfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationHdfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_hdfs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationHdfsOutput,
    crate::error::DescribeLocationHdfsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_hdfs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_location_hdfs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLocationHdfsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_nfs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationNfsOutput,
    crate::error::DescribeLocationNfsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationNfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLocationNfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationNfsError {
                meta: generic,
                kind: crate::error::DescribeLocationNfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationNfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationNfsError {
            meta: generic,
            kind: crate::error::DescribeLocationNfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationNfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationNfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_nfs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationNfsOutput,
    crate::error::DescribeLocationNfsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_nfs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_location_nfs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLocationNfsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_object_storage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationObjectStorageOutput,
    crate::error::DescribeLocationObjectStorageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationObjectStorageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeLocationObjectStorageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationObjectStorageError {
                meta: generic,
                kind: crate::error::DescribeLocationObjectStorageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationObjectStorageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationObjectStorageError {
            meta: generic,
            kind: crate::error::DescribeLocationObjectStorageErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationObjectStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationObjectStorageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_object_storage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationObjectStorageOutput,
    crate::error::DescribeLocationObjectStorageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_object_storage_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_location_object_storage(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeLocationObjectStorageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_s3_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationS3Output,
    crate::error::DescribeLocationS3Error,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationS3Error::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLocationS3Error::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationS3Error {
                meta: generic,
                kind: crate::error::DescribeLocationS3ErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationS3Error::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationS3Error {
            meta: generic,
            kind: crate::error::DescribeLocationS3ErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationS3Error::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_s3_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationS3Output,
    crate::error::DescribeLocationS3Error,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_s3_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_location_s3(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLocationS3Error::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_smb_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationSmbOutput,
    crate::error::DescribeLocationSmbError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLocationSmbError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLocationSmbError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeLocationSmbError {
                meta: generic,
                kind: crate::error::DescribeLocationSmbErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationSmbError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeLocationSmbError {
            meta: generic,
            kind: crate::error::DescribeLocationSmbErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLocationSmbError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLocationSmbError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_location_smb_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLocationSmbOutput,
    crate::error::DescribeLocationSmbError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_location_smb_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_location_smb(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLocationSmbError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTaskOutput, crate::error::DescribeTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeTaskError {
                meta: generic,
                kind: crate::error::DescribeTaskErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeTaskError {
            meta: generic,
            kind: crate::error::DescribeTaskErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTaskOutput, crate::error::DescribeTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTaskExecutionOutput,
    crate::error::DescribeTaskExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTaskExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTaskExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::DescribeTaskExecutionError {
                meta: generic,
                kind: crate::error::DescribeTaskExecutionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::DescribeTaskExecutionError {
            meta: generic,
            kind: crate::error::DescribeTaskExecutionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTaskExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTaskExecutionOutput,
    crate::error::DescribeTaskExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_task_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_task_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTaskExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_agents_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAgentsOutput, crate::error::ListAgentsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAgentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAgentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::ListAgentsError {
                meta: generic,
                kind: crate::error::ListAgentsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAgentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::ListAgentsError {
            meta: generic,
            kind: crate::error::ListAgentsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAgentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAgentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_agents_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAgentsOutput, crate::error::ListAgentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_agents_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_agents(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAgentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_locations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLocationsOutput, crate::error::ListLocationsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLocationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLocationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::ListLocationsError {
                meta: generic,
                kind: crate::error::ListLocationsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLocationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::ListLocationsError {
            meta: generic,
            kind: crate::error::ListLocationsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLocationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLocationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_locations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLocationsOutput, crate::error::ListLocationsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_locations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_locations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLocationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_task_executions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTaskExecutionsOutput,
    crate::error::ListTaskExecutionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTaskExecutionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTaskExecutionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::ListTaskExecutionsError {
                meta: generic,
                kind: crate::error::ListTaskExecutionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskExecutionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::ListTaskExecutionsError {
            meta: generic,
            kind: crate::error::ListTaskExecutionsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTaskExecutionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_task_executions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTaskExecutionsOutput,
    crate::error::ListTaskExecutionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_task_executions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_task_executions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTaskExecutionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTasksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::ListTasksError {
                meta: generic,
                kind: crate::error::ListTasksErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::ListTasksError {
            meta: generic,
            kind: crate::error::ListTasksErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_task_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartTaskExecutionOutput,
    crate::error::StartTaskExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartTaskExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartTaskExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::StartTaskExecutionError {
                meta: generic,
                kind: crate::error::StartTaskExecutionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTaskExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::StartTaskExecutionError {
            meta: generic,
            kind: crate::error::StartTaskExecutionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTaskExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartTaskExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_task_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartTaskExecutionOutput,
    crate::error::StartTaskExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_task_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_task_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartTaskExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_agent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAgentOutput, crate::error::UpdateAgentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAgentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAgentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateAgentError {
                meta: generic,
                kind: crate::error::UpdateAgentErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAgentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateAgentError {
            meta: generic,
            kind: crate::error::UpdateAgentErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAgentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_agent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAgentOutput, crate::error::UpdateAgentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_agent_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_hdfs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLocationHdfsOutput,
    crate::error::UpdateLocationHdfsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateLocationHdfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateLocationHdfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateLocationHdfsError {
                meta: generic,
                kind: crate::error::UpdateLocationHdfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationHdfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateLocationHdfsError {
            meta: generic,
            kind: crate::error::UpdateLocationHdfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationHdfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateLocationHdfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_hdfs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLocationHdfsOutput,
    crate::error::UpdateLocationHdfsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_location_hdfs_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_nfs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateLocationNfsOutput, crate::error::UpdateLocationNfsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateLocationNfsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateLocationNfsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateLocationNfsError {
                meta: generic,
                kind: crate::error::UpdateLocationNfsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationNfsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateLocationNfsError {
            meta: generic,
            kind: crate::error::UpdateLocationNfsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationNfsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateLocationNfsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_nfs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateLocationNfsOutput, crate::error::UpdateLocationNfsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_location_nfs_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_object_storage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLocationObjectStorageOutput,
    crate::error::UpdateLocationObjectStorageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateLocationObjectStorageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateLocationObjectStorageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateLocationObjectStorageError {
                meta: generic,
                kind: crate::error::UpdateLocationObjectStorageErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationObjectStorageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateLocationObjectStorageError {
            meta: generic,
            kind: crate::error::UpdateLocationObjectStorageErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationObjectStorageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateLocationObjectStorageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_object_storage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLocationObjectStorageOutput,
    crate::error::UpdateLocationObjectStorageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_location_object_storage_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_smb_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateLocationSmbOutput, crate::error::UpdateLocationSmbError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateLocationSmbError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateLocationSmbError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateLocationSmbError {
                meta: generic,
                kind: crate::error::UpdateLocationSmbErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationSmbError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateLocationSmbError {
            meta: generic,
            kind: crate::error::UpdateLocationSmbErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLocationSmbError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateLocationSmbError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_location_smb_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateLocationSmbOutput, crate::error::UpdateLocationSmbError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_location_smb_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTaskOutput, crate::error::UpdateTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateTaskError {
                meta: generic,
                kind: crate::error::UpdateTaskErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateTaskError {
            meta: generic,
            kind: crate::error::UpdateTaskErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTaskOutput, crate::error::UpdateTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_task_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_task_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTaskExecutionOutput,
    crate::error::UpdateTaskExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTaskExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTaskExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalException" => {
            crate::error::UpdateTaskExecutionError {
                meta: generic,
                kind: crate::error::UpdateTaskExecutionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskExecutionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidRequestException" => crate::error::UpdateTaskExecutionError {
            meta: generic,
            kind: crate::error::UpdateTaskExecutionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTaskExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_task_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTaskExecutionOutput,
    crate::error::UpdateTaskExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_task_execution_output::Builder::default();
        let _ = response;
        output.build()
    })
}
