// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS DataSync
///
/// Client for invoking operations on AWS DataSync. Each operation on AWS DataSync is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_datasync::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_datasync::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_datasync::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelTaskExecution` operation.
    ///
    /// See [`CancelTaskExecution`](crate::client::fluent_builders::CancelTaskExecution) for more information about the
    /// operation and its arguments.
    pub fn cancel_task_execution(&self) -> fluent_builders::CancelTaskExecution<C, M, R> {
        fluent_builders::CancelTaskExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAgent` operation.
    ///
    /// See [`CreateAgent`](crate::client::fluent_builders::CreateAgent) for more information about the
    /// operation and its arguments.
    pub fn create_agent(&self) -> fluent_builders::CreateAgent<C, M, R> {
        fluent_builders::CreateAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationEfs` operation.
    ///
    /// See [`CreateLocationEfs`](crate::client::fluent_builders::CreateLocationEfs) for more information about the
    /// operation and its arguments.
    pub fn create_location_efs(&self) -> fluent_builders::CreateLocationEfs<C, M, R> {
        fluent_builders::CreateLocationEfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationFsxWindows` operation.
    ///
    /// See [`CreateLocationFsxWindows`](crate::client::fluent_builders::CreateLocationFsxWindows) for more information about the
    /// operation and its arguments.
    pub fn create_location_fsx_windows(
        &self,
    ) -> fluent_builders::CreateLocationFsxWindows<C, M, R> {
        fluent_builders::CreateLocationFsxWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationHdfs` operation.
    ///
    /// See [`CreateLocationHdfs`](crate::client::fluent_builders::CreateLocationHdfs) for more information about the
    /// operation and its arguments.
    pub fn create_location_hdfs(&self) -> fluent_builders::CreateLocationHdfs<C, M, R> {
        fluent_builders::CreateLocationHdfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationNfs` operation.
    ///
    /// See [`CreateLocationNfs`](crate::client::fluent_builders::CreateLocationNfs) for more information about the
    /// operation and its arguments.
    pub fn create_location_nfs(&self) -> fluent_builders::CreateLocationNfs<C, M, R> {
        fluent_builders::CreateLocationNfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationObjectStorage` operation.
    ///
    /// See [`CreateLocationObjectStorage`](crate::client::fluent_builders::CreateLocationObjectStorage) for more information about the
    /// operation and its arguments.
    pub fn create_location_object_storage(
        &self,
    ) -> fluent_builders::CreateLocationObjectStorage<C, M, R> {
        fluent_builders::CreateLocationObjectStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationS3` operation.
    ///
    /// See [`CreateLocationS3`](crate::client::fluent_builders::CreateLocationS3) for more information about the
    /// operation and its arguments.
    pub fn create_location_s3(&self) -> fluent_builders::CreateLocationS3<C, M, R> {
        fluent_builders::CreateLocationS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocationSmb` operation.
    ///
    /// See [`CreateLocationSmb`](crate::client::fluent_builders::CreateLocationSmb) for more information about the
    /// operation and its arguments.
    pub fn create_location_smb(&self) -> fluent_builders::CreateLocationSmb<C, M, R> {
        fluent_builders::CreateLocationSmb::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTask` operation.
    ///
    /// See [`CreateTask`](crate::client::fluent_builders::CreateTask) for more information about the
    /// operation and its arguments.
    pub fn create_task(&self) -> fluent_builders::CreateTask<C, M, R> {
        fluent_builders::CreateTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAgent` operation.
    ///
    /// See [`DeleteAgent`](crate::client::fluent_builders::DeleteAgent) for more information about the
    /// operation and its arguments.
    pub fn delete_agent(&self) -> fluent_builders::DeleteAgent<C, M, R> {
        fluent_builders::DeleteAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLocation` operation.
    ///
    /// See [`DeleteLocation`](crate::client::fluent_builders::DeleteLocation) for more information about the
    /// operation and its arguments.
    pub fn delete_location(&self) -> fluent_builders::DeleteLocation<C, M, R> {
        fluent_builders::DeleteLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTask` operation.
    ///
    /// See [`DeleteTask`](crate::client::fluent_builders::DeleteTask) for more information about the
    /// operation and its arguments.
    pub fn delete_task(&self) -> fluent_builders::DeleteTask<C, M, R> {
        fluent_builders::DeleteTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAgent` operation.
    ///
    /// See [`DescribeAgent`](crate::client::fluent_builders::DescribeAgent) for more information about the
    /// operation and its arguments.
    pub fn describe_agent(&self) -> fluent_builders::DescribeAgent<C, M, R> {
        fluent_builders::DescribeAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationEfs` operation.
    ///
    /// See [`DescribeLocationEfs`](crate::client::fluent_builders::DescribeLocationEfs) for more information about the
    /// operation and its arguments.
    pub fn describe_location_efs(&self) -> fluent_builders::DescribeLocationEfs<C, M, R> {
        fluent_builders::DescribeLocationEfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationFsxWindows` operation.
    ///
    /// See [`DescribeLocationFsxWindows`](crate::client::fluent_builders::DescribeLocationFsxWindows) for more information about the
    /// operation and its arguments.
    pub fn describe_location_fsx_windows(
        &self,
    ) -> fluent_builders::DescribeLocationFsxWindows<C, M, R> {
        fluent_builders::DescribeLocationFsxWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationHdfs` operation.
    ///
    /// See [`DescribeLocationHdfs`](crate::client::fluent_builders::DescribeLocationHdfs) for more information about the
    /// operation and its arguments.
    pub fn describe_location_hdfs(&self) -> fluent_builders::DescribeLocationHdfs<C, M, R> {
        fluent_builders::DescribeLocationHdfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationNfs` operation.
    ///
    /// See [`DescribeLocationNfs`](crate::client::fluent_builders::DescribeLocationNfs) for more information about the
    /// operation and its arguments.
    pub fn describe_location_nfs(&self) -> fluent_builders::DescribeLocationNfs<C, M, R> {
        fluent_builders::DescribeLocationNfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationObjectStorage` operation.
    ///
    /// See [`DescribeLocationObjectStorage`](crate::client::fluent_builders::DescribeLocationObjectStorage) for more information about the
    /// operation and its arguments.
    pub fn describe_location_object_storage(
        &self,
    ) -> fluent_builders::DescribeLocationObjectStorage<C, M, R> {
        fluent_builders::DescribeLocationObjectStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationS3` operation.
    ///
    /// See [`DescribeLocationS3`](crate::client::fluent_builders::DescribeLocationS3) for more information about the
    /// operation and its arguments.
    pub fn describe_location_s3(&self) -> fluent_builders::DescribeLocationS3<C, M, R> {
        fluent_builders::DescribeLocationS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocationSmb` operation.
    ///
    /// See [`DescribeLocationSmb`](crate::client::fluent_builders::DescribeLocationSmb) for more information about the
    /// operation and its arguments.
    pub fn describe_location_smb(&self) -> fluent_builders::DescribeLocationSmb<C, M, R> {
        fluent_builders::DescribeLocationSmb::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTask` operation.
    ///
    /// See [`DescribeTask`](crate::client::fluent_builders::DescribeTask) for more information about the
    /// operation and its arguments.
    pub fn describe_task(&self) -> fluent_builders::DescribeTask<C, M, R> {
        fluent_builders::DescribeTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTaskExecution` operation.
    ///
    /// See [`DescribeTaskExecution`](crate::client::fluent_builders::DescribeTaskExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_task_execution(&self) -> fluent_builders::DescribeTaskExecution<C, M, R> {
        fluent_builders::DescribeTaskExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAgents` operation.
    ///
    /// See [`ListAgents`](crate::client::fluent_builders::ListAgents) for more information about the
    /// operation and its arguments.
    pub fn list_agents(&self) -> fluent_builders::ListAgents<C, M, R> {
        fluent_builders::ListAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLocations` operation.
    ///
    /// See [`ListLocations`](crate::client::fluent_builders::ListLocations) for more information about the
    /// operation and its arguments.
    pub fn list_locations(&self) -> fluent_builders::ListLocations<C, M, R> {
        fluent_builders::ListLocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTaskExecutions` operation.
    ///
    /// See [`ListTaskExecutions`](crate::client::fluent_builders::ListTaskExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_task_executions(&self) -> fluent_builders::ListTaskExecutions<C, M, R> {
        fluent_builders::ListTaskExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTasks` operation.
    ///
    /// See [`ListTasks`](crate::client::fluent_builders::ListTasks) for more information about the
    /// operation and its arguments.
    pub fn list_tasks(&self) -> fluent_builders::ListTasks<C, M, R> {
        fluent_builders::ListTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTaskExecution` operation.
    ///
    /// See [`StartTaskExecution`](crate::client::fluent_builders::StartTaskExecution) for more information about the
    /// operation and its arguments.
    pub fn start_task_execution(&self) -> fluent_builders::StartTaskExecution<C, M, R> {
        fluent_builders::StartTaskExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAgent` operation.
    ///
    /// See [`UpdateAgent`](crate::client::fluent_builders::UpdateAgent) for more information about the
    /// operation and its arguments.
    pub fn update_agent(&self) -> fluent_builders::UpdateAgent<C, M, R> {
        fluent_builders::UpdateAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLocationHdfs` operation.
    ///
    /// See [`UpdateLocationHdfs`](crate::client::fluent_builders::UpdateLocationHdfs) for more information about the
    /// operation and its arguments.
    pub fn update_location_hdfs(&self) -> fluent_builders::UpdateLocationHdfs<C, M, R> {
        fluent_builders::UpdateLocationHdfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLocationNfs` operation.
    ///
    /// See [`UpdateLocationNfs`](crate::client::fluent_builders::UpdateLocationNfs) for more information about the
    /// operation and its arguments.
    pub fn update_location_nfs(&self) -> fluent_builders::UpdateLocationNfs<C, M, R> {
        fluent_builders::UpdateLocationNfs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLocationObjectStorage` operation.
    ///
    /// See [`UpdateLocationObjectStorage`](crate::client::fluent_builders::UpdateLocationObjectStorage) for more information about the
    /// operation and its arguments.
    pub fn update_location_object_storage(
        &self,
    ) -> fluent_builders::UpdateLocationObjectStorage<C, M, R> {
        fluent_builders::UpdateLocationObjectStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLocationSmb` operation.
    ///
    /// See [`UpdateLocationSmb`](crate::client::fluent_builders::UpdateLocationSmb) for more information about the
    /// operation and its arguments.
    pub fn update_location_smb(&self) -> fluent_builders::UpdateLocationSmb<C, M, R> {
        fluent_builders::UpdateLocationSmb::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTask` operation.
    ///
    /// See [`UpdateTask`](crate::client::fluent_builders::UpdateTask) for more information about the
    /// operation and its arguments.
    pub fn update_task(&self) -> fluent_builders::UpdateTask<C, M, R> {
        fluent_builders::UpdateTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTaskExecution` operation.
    ///
    /// See [`UpdateTaskExecution`](crate::client::fluent_builders::UpdateTaskExecution) for more information about the
    /// operation and its arguments.
    pub fn update_task_execution(&self) -> fluent_builders::UpdateTaskExecution<C, M, R> {
        fluent_builders::UpdateTaskExecution::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelTaskExecution`.
    ///
    /// <p>Cancels execution of a task. </p>
    /// <p>When you cancel a task execution, the transfer of some files is abruptly interrupted.
    /// The contents of files that are transferred to the destination might be incomplete or
    /// inconsistent with the source files. However, if you start a new task execution on the same
    /// task and you allow the task execution to complete, file content on the destination is complete
    /// and consistent. This applies to other unexpected failures that interrupt a task execution. In
    /// all of these cases, DataSync successfully complete the transfer when you start the next
    /// task execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelTaskExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_task_execution_input::Builder,
    }
    impl<C, M, R> CancelTaskExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelTaskExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelTaskExecutionInputOperationOutputAlias,
                crate::output::CancelTaskExecutionOutput,
                crate::error::CancelTaskExecutionError,
                crate::input::CancelTaskExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution to cancel.</p>
        pub fn task_execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution to cancel.</p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAgent`.
    ///
    /// <p>Activates an DataSync agent that you have deployed on your host. The activation
    /// process associates your agent with your account. In the activation process, you specify
    /// information such as the Amazon Web Services Region that you want to activate the agent in. You activate the
    /// agent in the Amazon Web Services Region where your target locations (in Amazon S3 or Amazon EFS) reside. Your
    /// tasks are created in this Amazon Web Services Region.</p>
    /// <p>You can activate the agent in a VPC (virtual private cloud) or provide the agent access to
    /// a VPC endpoint so you can run tasks without going over the public internet.</p>
    /// <p>You can use an agent for more than one location. If a task uses multiple agents, all of
    /// them need to have status AVAILABLE for the task to run. If you use multiple agents for a
    /// source location, the status of all the agents must be AVAILABLE for the task to run. </p>
    ///
    ///
    /// <p>Agents are automatically updated by Amazon Web Services on a regular basis, using a mechanism that
    /// ensures minimal interruption to your tasks.</p>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAgent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_agent_input::Builder,
    }
    impl<C, M, R> CreateAgent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAgentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAgentInputOperationOutputAlias,
                crate::output::CreateAgentOutput,
                crate::error::CreateAgentError,
                crate::input::CreateAgentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Your agent activation key. You can get the activation key either by sending an HTTP GET
        /// request with redirects that enable you to get the agent IP address (port 80). Alternatively,
        /// you can get it from the DataSync console.</p>
        /// <p>The redirect URL returned in the response provides you the activation key for your
        /// agent in the query string parameter <code>activationKey</code>. It might also include other
        /// activation-related parameters; however, these are merely defaults. The arguments you pass to
        /// this API call determine the actual configuration of your agent.</p>
        ///
        ///
        /// <p>For more information, see Activating an Agent in the <i>DataSync
        /// User Guide.</i>
        /// </p>
        pub fn activation_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_key(inp);
            self
        }
        /// <p>Your agent activation key. You can get the activation key either by sending an HTTP GET
        /// request with redirects that enable you to get the agent IP address (port 80). Alternatively,
        /// you can get it from the DataSync console.</p>
        /// <p>The redirect URL returned in the response provides you the activation key for your
        /// agent in the query string parameter <code>activationKey</code>. It might also include other
        /// activation-related parameters; however, these are merely defaults. The arguments you pass to
        /// this API call determine the actual configuration of your agent.</p>
        ///
        ///
        /// <p>For more information, see Activating an Agent in the <i>DataSync
        /// User Guide.</i>
        /// </p>
        pub fn set_activation_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_key(input);
            self
        }
        /// <p>The name you configured for your agent. This value is a text reference that is used to
        /// identify the agent in the console.</p>
        pub fn agent_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_name(inp);
            self
        }
        /// <p>The name you configured for your agent. This value is a text reference that is used to
        /// identify the agent in the console.</p>
        pub fn set_agent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to associate with the agent.
        /// The value can be an empty string. This value helps you manage, filter, and search for your
        /// agents.</p>
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. </p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to associate with the agent.
        /// The value can be an empty string. This value helps you manage, filter, and search for your
        /// agents.</p>
        /// <note>
        /// <p>Valid characters for key and value are letters, spaces, and numbers representable in
        /// UTF-8 format, and the following special characters: + - = . _ : / @. </p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is
        /// the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC
        /// endpoint, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service">Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>
        /// <p>VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.</p>
        pub fn vpc_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_id(inp);
            self
        }
        /// <p>The ID of the VPC (virtual private cloud) endpoint that the agent has access to. This is
        /// the client-side VPC endpoint, also called a PrivateLink. If you don't have a PrivateLink VPC
        /// endpoint, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service">Creating a VPC Endpoint Service Configuration</a> in the Amazon VPC User Guide.</p>
        /// <p>VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code>.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_id(input);
            self
        }
        /// Appends an item to `SubnetArns`.
        ///
        /// To override the contents of this collection use [`set_subnet_arns`](Self::set_subnet_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic
        /// network interfaces for each data transfer task. The agent that runs a task must be private.
        /// When you start a task that is associated with an agent created in a VPC, or one that has
        /// access to an IP address in a VPC, then the task is also private. In this case, DataSync
        /// creates four network interfaces for each task in your subnet. For a data transfer to work, the
        /// agent must be able to route to all these four network interfaces.</p>
        pub fn subnet_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic
        /// network interfaces for each data transfer task. The agent that runs a task must be private.
        /// When you start a task that is associated with an agent created in a VPC, or one that has
        /// access to an IP address in a VPC, then the task is also private. In this case, DataSync
        /// creates four network interfaces for each task in your subnet. For a data transfer to work, the
        /// agent must be able to route to all these four network interfaces.</p>
        pub fn set_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_arns(input);
            self
        }
        /// Appends an item to `SecurityGroupArns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The ARNs of the security groups used to protect your data transfer task subnets. See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a>.</p>
        pub fn security_group_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_arns(inp);
            self
        }
        /// <p>The ARNs of the security groups used to protect your data transfer task subnets. See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a>.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationEfs`.
    ///
    /// <p>Creates an endpoint for an Amazon EFS file system.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationEfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_efs_input::Builder,
    }
    impl<C, M, R> CreateLocationEfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationEfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationEfsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationEfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationEfsInputOperationOutputAlias,
                crate::output::CreateLocationEfsOutput,
                crate::error::CreateLocationEfsError,
                crate::input::CreateLocationEfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the location’s path. This subdirectory in the EFS file system is used
        /// to read data from the EFS source location or write data to the EFS destination. By default,
        /// DataSync uses the root directory.</p>
        /// <note>
        /// <p>
        /// <code>Subdirectory</code> must be specified with forward slashes. For example,
        /// <code>/path/to/folder</code>.</p>
        /// </note>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A subdirectory in the location’s path. This subdirectory in the EFS file system is used
        /// to read data from the EFS source location or write data to the EFS destination. By default,
        /// DataSync uses the root directory.</p>
        /// <note>
        /// <p>
        /// <code>Subdirectory</code> must be specified with forward slashes. For example,
        /// <code>/path/to/folder</code>.</p>
        /// </note>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon EFS file system.</p>
        pub fn efs_filesystem_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.efs_filesystem_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon EFS file system.</p>
        pub fn set_efs_filesystem_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_efs_filesystem_arn(input);
            self
        }
        /// <p>The subnet and security group that the Amazon EFS file system uses. The security group
        /// that you provide needs to be able to communicate with the security group on the mount target
        /// in the subnet specified.</p>
        /// <p>The exact relationship between security group M (of the mount target) and security
        /// group S (which you provide for DataSync to use at this stage) is as follows: </p>
        /// <ul>
        /// <li>
        /// <p> Security group M (which you associate with the mount target) must allow inbound
        /// access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security
        /// group S. You can enable inbound connections either by IP address (CIDR range) or security
        /// group. </p>
        /// </li>
        /// <li>
        /// <p>Security group S (provided to DataSync to access EFS) should have a rule that
        /// enables outbound connections to the NFS port on one of the file system’s mount targets.
        /// You can enable outbound connections either by IP address (CIDR range) or security
        /// group.</p>
        ///
        /// <p>For information about security groups and mount targets, see Security
        /// Groups for Amazon EC2 Instances and Mount Targets in the <i>Amazon EFS User
        /// Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        pub fn ec2_config(mut self, inp: crate::model::Ec2Config) -> Self {
            self.inner = self.inner.ec2_config(inp);
            self
        }
        /// <p>The subnet and security group that the Amazon EFS file system uses. The security group
        /// that you provide needs to be able to communicate with the security group on the mount target
        /// in the subnet specified.</p>
        /// <p>The exact relationship between security group M (of the mount target) and security
        /// group S (which you provide for DataSync to use at this stage) is as follows: </p>
        /// <ul>
        /// <li>
        /// <p> Security group M (which you associate with the mount target) must allow inbound
        /// access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security
        /// group S. You can enable inbound connections either by IP address (CIDR range) or security
        /// group. </p>
        /// </li>
        /// <li>
        /// <p>Security group S (provided to DataSync to access EFS) should have a rule that
        /// enables outbound connections to the NFS port on one of the file system’s mount targets.
        /// You can enable outbound connections either by IP address (CIDR range) or security
        /// group.</p>
        ///
        /// <p>For information about security groups and mount targets, see Security
        /// Groups for Amazon EC2 Instances and Mount Targets in the <i>Amazon EFS User
        /// Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_ec2_config(
            mut self,
            input: std::option::Option<crate::model::Ec2Config>,
        ) -> Self {
            self.inner = self.inner.set_ec2_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The
        /// value can be an empty string. This value helps you manage, filter, and search for your
        /// resources. We recommend that you create a name tag for your location.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The
        /// value can be an empty string. This value helps you manage, filter, and search for your
        /// resources. We recommend that you create a name tag for your location.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationFsxWindows`.
    ///
    /// <p>Creates an endpoint for an Amazon FSx for Windows File Server file system.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationFsxWindows<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_fsx_windows_input::Builder,
    }
    impl<C, M, R> CreateLocationFsxWindows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationFsxWindows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationFsxWindowsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationFsxWindowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationFsxWindowsInputOperationOutputAlias,
                crate::output::CreateLocationFsxWindowsOutput,
                crate::error::CreateLocationFsxWindowsError,
                crate::input::CreateLocationFsxWindowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the location’s path. This subdirectory in the Amazon FSx for Windows
        /// File Server file system is used to read data from the Amazon FSx for Windows File Server
        /// source location or write data to the FSx for Windows File Server destination.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A subdirectory in the location’s path. This subdirectory in the Amazon FSx for Windows
        /// File Server file system is used to read data from the Amazon FSx for Windows File Server
        /// source location or write data to the FSx for Windows File Server destination.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the FSx for Windows File Server file system.</p>
        pub fn fsx_filesystem_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fsx_filesystem_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the FSx for Windows File Server file system.</p>
        pub fn set_fsx_filesystem_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fsx_filesystem_arn(input);
            self
        }
        /// Appends an item to `SecurityGroupArns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are to use to configure the
        /// FSx for Windows File Server file system.</p>
        pub fn security_group_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are to use to configure the
        /// FSx for Windows File Server file system.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The
        /// value can be an empty string. This value helps you manage, filter, and search for your
        /// resources. We recommend that you create a name tag for your location.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents a tag that you want to add to the resource. The
        /// value can be an empty string. This value helps you manage, filter, and search for your
        /// resources. We recommend that you create a name tag for your location.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The user who has the permissions to access files and folders in the FSx for Windows File
        /// Server file system.</p>
        /// <p>For information about choosing a user name that ensures sufficient permissions to files,
        /// folders, and metadata, see <a href="create-fsx-location.html#FSxWuser">user</a>.</p>
        pub fn user(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user(inp);
            self
        }
        /// <p>The user who has the permissions to access files and folders in the FSx for Windows File
        /// Server file system.</p>
        /// <p>For information about choosing a user name that ensures sufficient permissions to files,
        /// folders, and metadata, see <a href="create-fsx-location.html#FSxWuser">user</a>.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
        /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The password of the user who has the permissions to access files and folders in the FSx
        /// for Windows File Server file system.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of the user who has the permissions to access files and folders in the FSx
        /// for Windows File Server file system.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationHdfs`.
    ///
    /// <p>Creates an endpoint for a Hadoop Distributed File System (HDFS). </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationHdfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_hdfs_input::Builder,
    }
    impl<C, M, R> CreateLocationHdfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationHdfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationHdfsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationHdfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationHdfsInputOperationOutputAlias,
                crate::output::CreateLocationHdfsOutput,
                crate::error::CreateLocationHdfsError,
                crate::input::CreateLocationHdfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write
        /// data to the HDFS cluster. If the subdirectory isn't specified, it will default to
        /// <code>/</code>.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write
        /// data to the HDFS cluster. If the subdirectory isn't specified, it will default to
        /// <code>/</code>.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// Appends an item to `NameNodes`.
        ///
        /// To override the contents of this collection use [`set_name_nodes`](Self::set_name_nodes).
        ///
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as
        /// opening, closing, and renaming files and directories. The NameNode contains the information to
        /// map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn name_nodes(mut self, inp: impl Into<crate::model::HdfsNameNode>) -> Self {
            self.inner = self.inner.name_nodes(inp);
            self
        }
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as
        /// opening, closing, and renaming files and directories. The NameNode contains the information to
        /// map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn set_name_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
        ) -> Self {
            self.inner = self.inner.set_name_nodes(input);
            self
        }
        /// <p>The size of data blocks to write into the HDFS cluster. The block size must be a multiple
        /// of 512 bytes. The default block size is 128 mebibytes (MiB).</p>
        pub fn block_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.block_size(inp);
            self
        }
        /// <p>The size of data blocks to write into the HDFS cluster. The block size must be a multiple
        /// of 512 bytes. The default block size is 128 mebibytes (MiB).</p>
        pub fn set_block_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_size(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. By
        /// default, data is replicated to three DataNodes.</p>
        pub fn replication_factor(mut self, inp: i32) -> Self {
            self.inner = self.inner.replication_factor(inp);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. By
        /// default, data is replicated to three DataNodes.</p>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_replication_factor(input);
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn kms_key_provider_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_provider_uri(inp);
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn set_kms_key_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kms_key_provider_uri(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC)
        /// and data transfer protection settings configured on the Hadoop Distributed File System (HDFS)
        /// cluster. If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and
        /// <code>DataTransferProtection</code> default to <code>PRIVACY</code>. If you set
        /// <code>RpcProtection</code> or <code>DataTransferProtection</code>, the other parameter
        /// assumes the same value. </p>
        pub fn qop_configuration(mut self, inp: crate::model::QopConfiguration) -> Self {
            self.inner = self.inner.qop_configuration(inp);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC)
        /// and data transfer protection settings configured on the Hadoop Distributed File System (HDFS)
        /// cluster. If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and
        /// <code>DataTransferProtection</code> default to <code>PRIVACY</code>. If you set
        /// <code>RpcProtection</code> or <code>DataTransferProtection</code>, the other parameter
        /// assumes the same value. </p>
        pub fn set_qop_configuration(
            mut self,
            input: std::option::Option<crate::model::QopConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_qop_configuration(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn authentication_type(mut self, inp: crate::model::HdfsAuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::HdfsAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The user name used to identify the client on the host operating system. </p>
        /// <note>
        /// <p>If <code>SIMPLE</code> is specified for <code>AuthenticationType</code>, this parameter
        /// is required. </p>
        /// </note>
        pub fn simple_user(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.simple_user(inp);
            self
        }
        /// <p>The user name used to identify the client on the host operating system. </p>
        /// <note>
        /// <p>If <code>SIMPLE</code> is specified for <code>AuthenticationType</code>, this parameter
        /// is required. </p>
        /// </note>
        pub fn set_simple_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_simple_user(input);
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
        /// <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this
        /// parameter is required.</p>
        /// </note>
        pub fn kerberos_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kerberos_principal(inp);
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
        /// <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this
        /// parameter is required.</p>
        /// </note>
        pub fn set_kerberos_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_principal(input);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos
        /// principal and the encrypted keys. You can load the keytab from a file by providing the file's
        /// address. If you're using the CLI, it performs base64 encoding for you.
        /// Otherwise, provide the base64-encoded text. </p>
        /// <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this
        /// parameter is required. </p>
        /// </note>
        pub fn kerberos_keytab(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_keytab(inp);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos
        /// principal and the encrypted keys. You can load the keytab from a file by providing the file's
        /// address. If you're using the CLI, it performs base64 encoding for you.
        /// Otherwise, provide the base64-encoded text. </p>
        /// <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this
        /// parameter is required. </p>
        /// </note>
        pub fn set_kerberos_keytab(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_keytab(input);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You
        /// can load the <code>krb5.conf</code> file by providing the file's address. If you're using the
        /// CLI, it performs the base64 encoding for you. Otherwise, provide the
        /// base64-encoded text. </p>
        /// <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this
        /// parameter is required.</p>
        /// </note>
        pub fn kerberos_krb5_conf(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_krb5_conf(inp);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You
        /// can load the <code>krb5.conf</code> file by providing the file's address. If you're using the
        /// CLI, it performs the base64 encoding for you. Otherwise, provide the
        /// base64-encoded text. </p>
        /// <note>
        /// <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this
        /// parameter is required.</p>
        /// </note>
        pub fn set_kerberos_krb5_conf(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_krb5_conf(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS
        /// cluster.</p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS
        /// cluster.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value
        /// can be an empty string. We recommend using tags to name your resources. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value
        /// can be an empty string. We recommend using tags to name your resources. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationNfs`.
    ///
    /// <p>Defines a file system on a Network File System (NFS) server that can be read from or
    /// written to.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationNfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_nfs_input::Builder,
    }
    impl<C, M, R> CreateLocationNfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationNfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationNfsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationNfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationNfsInputOperationOutputAlias,
                crate::output::CreateLocationNfsOutput,
                crate::error::CreateLocationNfsError,
                crate::input::CreateLocationNfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source
        /// location or write data to the NFS destination. The NFS path should be a path that's
        /// exported by the NFS server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other NFS clients in your network. </p>
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e
        /// nfs-server-name</code>" from an NFS client that has access to your server. You can specify
        /// any directory that appears in the results, and any subdirectory of that directory. Ensure that
        /// the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have
        /// permissions to read all the data. To ensure this, either configure the NFS export with
        /// <code>no_root_squash,</code> or ensure that the permissions for all of the files that you
        /// want DataSync allow read access for all users. Doing either enables the agent to read the
        /// files. For the agent to access directories, you must additionally enable all execute
        /// access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        ///
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports
        /// Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source
        /// location or write data to the NFS destination. The NFS path should be a path that's
        /// exported by the NFS server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other NFS clients in your network. </p>
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e
        /// nfs-server-name</code>" from an NFS client that has access to your server. You can specify
        /// any directory that appears in the results, and any subdirectory of that directory. Ensure that
        /// the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have
        /// permissions to read all the data. To ensure this, either configure the NFS export with
        /// <code>no_root_squash,</code> or ensure that the permissions for all of the files that you
        /// want DataSync allow read access for all users. Doing either enables the agent to read the
        /// files. For the agent to access directories, you must additionally enable all execute
        /// access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        ///
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports
        /// Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The name of the NFS server. This value is the IP address or Domain Name Service (DNS)
        /// name of the NFS server. An agent that is installed on-premises uses this host name to mount
        /// the NFS server in a network. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        /// <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4)
        /// address.</p>
        /// </note>
        pub fn server_hostname(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_hostname(inp);
            self
        }
        /// <p>The name of the NFS server. This value is the IP address or Domain Name Service (DNS)
        /// name of the NFS server. An agent that is installed on-premises uses this host name to mount
        /// the NFS server in a network. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        /// <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4)
        /// address.</p>
        /// </note>
        pub fn set_server_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_hostname(input);
            self
        }
        /// <p>Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to
        /// an NFS server. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        pub fn on_prem_config(mut self, inp: crate::model::OnPremConfig) -> Self {
            self.inner = self.inner.on_prem_config(inp);
            self
        }
        /// <p>Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to
        /// an NFS server. </p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        pub fn set_on_prem_config(
            mut self,
            input: std::option::Option<crate::model::OnPremConfig>,
        ) -> Self {
            self.inner = self.inner.set_on_prem_config(input);
            self
        }
        /// <p>The NFS mount options that DataSync can use to mount your NFS share.</p>
        pub fn mount_options(mut self, inp: crate::model::NfsMountOptions) -> Self {
            self.inner = self.inner.mount_options(inp);
            self
        }
        /// <p>The NFS mount options that DataSync can use to mount your NFS share.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::NfsMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The
        /// value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The
        /// value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationObjectStorage`.
    ///
    /// <p>Creates an endpoint for a self-managed object storage bucket. For more information
    /// about self-managed object storage locations, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a location for object storage</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationObjectStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_object_storage_input::Builder,
    }
    impl<C, M, R> CreateLocationObjectStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationObjectStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationObjectStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationObjectStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationObjectStorageInputOperationOutputAlias,
                crate::output::CreateLocationObjectStorageOutput,
                crate::error::CreateLocationObjectStorageError,
                crate::input::CreateLocationObjectStorageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the self-managed object storage server. This value is the
        /// IP address or Domain Name Service (DNS) name of the object storage server.
        /// An agent uses this host name to mount the object storage server in a network. </p>
        pub fn server_hostname(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_hostname(inp);
            self
        }
        /// <p>The name of the self-managed object storage server. This value is the
        /// IP address or Domain Name Service (DNS) name of the object storage server.
        /// An agent uses this host name to mount the object storage server in a network. </p>
        pub fn set_server_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_hostname(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on.
        /// The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can
        /// specify a custom port if your self-managed object storage server requires one.</p>
        pub fn server_port(mut self, inp: i32) -> Self {
            self.inner = self.inner.server_port(inp);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on.
        /// The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can
        /// specify a custom port if your self-managed object storage server requires one.</p>
        pub fn set_server_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_server_port(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate.
        /// Valid values are HTTP or HTTPS.</p>
        pub fn server_protocol(mut self, inp: crate::model::ObjectStorageServerProtocol) -> Self {
            self.inner = self.inner.server_protocol(inp);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate.
        /// Valid values are HTTP or HTTPS.</p>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::ObjectStorageServerProtocol>,
        ) -> Self {
            self.inner = self.inner.set_server_protocol(input);
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used
        /// to read data from.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used
        /// to read data from.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The bucket on the self-managed object storage server that is used
        /// to read data from.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The bucket on the self-managed object storage server that is used
        /// to read data from.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn access_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key(inp);
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn set_access_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_key(input);
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn secret_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_key(inp);
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_key(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the
        /// self-managed object storage server location.</p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the
        /// self-managed object storage server location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The
        /// value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The
        /// value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationS3`.
    ///
    /// <p>Creates an endpoint for an Amazon S3 bucket.</p>
    ///
    ///
    /// <p>For
    /// more information, see
    /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli">Create an Amazon S3 location</a>
    /// in the <i>DataSync User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationS3<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_s3_input::Builder,
    }
    impl<C, M, R> CreateLocationS3<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationS3Output,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationS3Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationS3InputOperationOutputAlias,
                crate::output::CreateLocationS3Output,
                crate::error::CreateLocationS3Error,
                crate::input::CreateLocationS3InputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read
        /// data from the S3 source location or write data to the S3 destination.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is used to read
        /// data from the S3 source location or write data to the S3 destination.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an
        /// access point ARN.</p>
        pub fn s3_bucket_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_arn(inp);
            self
        }
        /// <p>The ARN of the Amazon S3 bucket. If the bucket is on an Amazon Web Services Outpost, this must be an
        /// access point ARN.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_arn(input);
            self
        }
        /// <p>The Amazon S3 storage class that you want to store your files in when this location is
        /// used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard.
        /// For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.</p>
        ///
        /// <p>For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that
        /// can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
        pub fn s3_storage_class(mut self, inp: crate::model::S3StorageClass) -> Self {
            self.inner = self.inner.s3_storage_class(inp);
            self
        }
        /// <p>The Amazon S3 storage class that you want to store your files in when this location is
        /// used as a task destination. For buckets in Amazon Web Services Regions, the storage class defaults to Standard.
        /// For buckets on Outposts, the storage class defaults to Amazon Web Services S3 Outposts.</p>
        ///
        /// <p>For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that
        /// can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
        pub fn set_s3_storage_class(
            mut self,
            input: std::option::Option<crate::model::S3StorageClass>,
        ) -> Self {
            self.inner = self.inner.set_s3_storage_class(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
        /// that is used to access an Amazon S3 bucket.</p>
        ///
        /// <p>For detailed information about using such a role, see Creating a Location for
        /// Amazon S3 in the <i>DataSync User Guide</i>.</p>
        pub fn s3_config(mut self, inp: crate::model::S3Config) -> Self {
            self.inner = self.inner.s3_config(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
        /// that is used to access an Amazon S3 bucket.</p>
        ///
        /// <p>For detailed information about using such a role, see Creating a Location for
        /// Amazon S3 in the <i>DataSync User Guide</i>.</p>
        pub fn set_s3_config(mut self, input: std::option::Option<crate::model::S3Config>) -> Self {
            self.inner = self.inner.set_s3_config(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>If you are using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of
        /// the DataSync agents deployed on your Outpost. For more information about launching a DataSync
        /// agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>If you are using DataSync on an Amazon Web Services Outpost, specify the Amazon Resource Names (ARNs) of
        /// the DataSync agents deployed on your Outpost. For more information about launching a DataSync
        /// agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The
        /// value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The
        /// value can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocationSmb`.
    ///
    /// <p>Defines a file system on a Server Message Block (SMB) server that can be read from or
    /// written to.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLocationSmb<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_location_smb_input::Builder,
    }
    impl<C, M, R> CreateLocationSmb<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocationSmb`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocationSmbOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocationSmbError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocationSmbInputOperationOutputAlias,
                crate::output::CreateLocationSmbOutput,
                crate::error::CreateLocationSmbError,
                crate::input::CreateLocationSmbInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source
        /// location or write data to the SMB destination. The SMB path should be a path that's
        /// exported by the SMB server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other SMB clients in your network.</p>
        /// <note>
        /// <p>
        /// <code>Subdirectory</code> must be specified with forward slashes. For example,
        /// <code>/path/to/folder</code>.</p>
        /// </note>
        ///
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have permissions
        /// to mount the SMB share, as well as to access all the data in that share. To ensure this,
        /// either ensure that the user/password specified belongs to the user who can mount the share,
        /// and who has the appropriate permissions for all of the files and directories that you want
        /// DataSync to access, or use credentials of a member of the Backup Operators group to mount
        /// the share. Doing either enables the agent to access the data. For the agent to access
        /// directories, you must additionally enable all execute access.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source
        /// location or write data to the SMB destination. The SMB path should be a path that's
        /// exported by the SMB server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other SMB clients in your network.</p>
        /// <note>
        /// <p>
        /// <code>Subdirectory</code> must be specified with forward slashes. For example,
        /// <code>/path/to/folder</code>.</p>
        /// </note>
        ///
        /// <p>To transfer all the data in the folder you specified, DataSync needs to have permissions
        /// to mount the SMB share, as well as to access all the data in that share. To ensure this,
        /// either ensure that the user/password specified belongs to the user who can mount the share,
        /// and who has the appropriate permissions for all of the files and directories that you want
        /// DataSync to access, or use credentials of a member of the Backup Operators group to mount
        /// the share. Doing either enables the agent to access the data. For the agent to access
        /// directories, you must additionally enable all execute access.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name
        /// of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB
        /// server in a network.</p>
        /// <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>
        /// </note>
        pub fn server_hostname(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_hostname(inp);
            self
        }
        /// <p>The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name
        /// of the SMB server. An agent that is installed on-premises uses this hostname to mount the SMB
        /// server in a network.</p>
        /// <note>
        /// <p>This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.</p>
        /// </note>
        pub fn set_server_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_hostname(input);
            self
        }
        /// <p>The user who can mount the share, has the permissions to access files and folders in the
        /// SMB share.</p>
        ///
        /// <p>For information about choosing a user name that ensures sufficient permissions to files,
        /// folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
        pub fn user(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user(inp);
            self
        }
        /// <p>The user who can mount the share, has the permissions to access files and folders in the
        /// SMB share.</p>
        ///
        /// <p>For information about choosing a user name that ensures sufficient permissions to files,
        /// folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The password of the user who can mount the share, has the permissions to access files and
        /// folders in the SMB share.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of the user who can mount the share, has the permissions to access files and
        /// folders in the SMB share.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB)
        /// location. </p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB)
        /// location. </p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// <p>The mount options used by DataSync to access the SMB server.</p>
        pub fn mount_options(mut self, inp: crate::model::SmbMountOptions) -> Self {
            self.inner = self.inner.mount_options(inp);
            self
        }
        /// <p>The mount options used by DataSync to access the SMB server.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::SmbMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value
        /// can be an empty string. We recommend using tags to name your resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the location. The value
        /// can be an empty string. We recommend using tags to name your resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTask`.
    ///
    /// <p>Creates a task.</p>
    /// <p>A task includes a source location and a destination location, and a configuration
    /// that specifies how data is transferred. A task always transfers data from the source
    /// location to the destination location. The configuration specifies options such as
    /// task scheduling, bandwidth limits, etc. A task is the complete definition of a data
    /// transfer.</p>
    /// <p>When you create a task that transfers data between Amazon Web Services services in different Amazon Web Services Regions,
    /// one of the two locations that you specify must reside in the Region where DataSync is being
    /// used. The other location must be specified in a different Region.</p>
    /// <p>You can transfer data between commercial Amazon Web Services Regions except for China, or between
    /// Amazon Web Services GovCloud (US) Regions.</p>
    ///
    /// <important>
    /// <p>When you use DataSync to copy files or objects between Amazon Web Services Regions,
    /// you pay for data transfer between Regions. This is billed as data transfer OUT
    /// from your source Region to your destination Region. For more information,
    /// see <a href="http://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer">Data Transfer pricing</a>.
    /// </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_task_input::Builder,
    }
    impl<C, M, R> CreateTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTaskInputOperationOutputAlias,
                crate::output::CreateTaskOutput,
                crate::error::CreateTaskError,
                crate::input::CreateTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the source location for the task.</p>
        pub fn source_location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source location for the task.</p>
        pub fn set_source_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_location_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location. </p>
        pub fn destination_location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's location. </p>
        pub fn set_destination_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_location_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to
        /// monitor and log events in the task. </p>
        pub fn cloud_watch_log_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_log_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to
        /// monitor and log events in the task. </p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_log_group_arn(input);
            self
        }
        /// <p>The name of a task. This value is a text reference that is used to identify the task in
        /// the console. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a task. This value is a text reference that is used to identify the task in
        /// the console. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The set of configuration options that control the behavior of a single execution of the
        /// task that occurs when you call <code>StartTaskExecution</code>. You can configure these
        /// options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data
        /// integrity verification, and so on.</p>
        /// <p>For each individual task execution, you can override these options by specifying the
        /// <code>OverrideOptions</code> before starting the task execution. For more information, see
        /// the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
        pub fn options(mut self, inp: crate::model::Options) -> Self {
            self.inner = self.inner.options(inp);
            self
        }
        /// <p>The set of configuration options that control the behavior of a single execution of the
        /// task that occurs when you call <code>StartTaskExecution</code>. You can configure these
        /// options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data
        /// integrity verification, and so on.</p>
        /// <p>For each individual task execution, you can override these options by specifying the
        /// <code>OverrideOptions</code> before starting the task execution. For more information, see
        /// the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should
        /// contain a single filter string that consists of the patterns to exclude. The patterns are
        /// delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p>
        /// </p>
        pub fn excludes(mut self, inp: impl Into<crate::model::FilterRule>) -> Self {
            self.inner = self.inner.excludes(inp);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should
        /// contain a single filter string that consists of the patterns to exclude. The patterns are
        /// delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p>
        /// </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_excludes(input);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination
        /// location. The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn schedule(mut self, inp: crate::model::TaskSchedule) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination
        /// location. The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::TaskSchedule>,
        ) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair that represents the tag that you want to add to the resource. The
        /// value can be an empty string. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pair that represents the tag that you want to add to the resource. The
        /// value can be an empty string. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The
        /// pattern contains a single filter string that consists of the patterns to include. The patterns
        /// are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn includes(mut self, inp: impl Into<crate::model::FilterRule>) -> Self {
            self.inner = self.inner.includes(inp);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The
        /// pattern contains a single filter string that consists of the patterns to include. The patterns
        /// are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_includes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAgent`.
    ///
    /// <p>Deletes an agent. To specify which agent to delete, use the Amazon Resource Name (ARN)
    /// of the agent in your request. The operation disassociates the agent from your Amazon Web Services account.
    /// However, it doesn't delete the agent virtual machine (VM) from your on-premises
    /// environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAgent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_agent_input::Builder,
    }
    impl<C, M, R> DeleteAgent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAgentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAgentInputOperationOutputAlias,
                crate::output::DeleteAgentOutput,
                crate::error::DeleteAgentError,
                crate::input::DeleteAgentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to delete. Use the <code>ListAgents</code>
        /// operation to return a list of agents for your account and Amazon Web Services Region.</p>
        pub fn agent_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to delete. Use the <code>ListAgents</code>
        /// operation to return a list of agents for your account and Amazon Web Services Region.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLocation`.
    ///
    /// <p>Deletes the configuration of a location used by DataSync. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLocation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_location_input::Builder,
    }
    impl<C, M, R> DeleteLocation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLocationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLocationInputOperationOutputAlias,
                crate::output::DeleteLocationOutput,
                crate::error::DeleteLocationError,
                crate::input::DeleteLocationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the location to delete.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the location to delete.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTask`.
    ///
    /// <p>Deletes a task.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_task_input::Builder,
    }
    impl<C, M, R> DeleteTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTaskInputOperationOutputAlias,
                crate::output::DeleteTaskOutput,
                crate::error::DeleteTaskError,
                crate::input::DeleteTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task to delete.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task to delete.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAgent`.
    ///
    /// <p>Returns metadata such as the name, the network interfaces, and the status (that is,
    /// whether the agent is running or not) for an agent. To specify which agent to describe, use the
    /// Amazon Resource Name (ARN) of the agent in your request. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAgent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_agent_input::Builder,
    }
    impl<C, M, R> DescribeAgent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAgentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAgentInputOperationOutputAlias,
                crate::output::DescribeAgentOutput,
                crate::error::DescribeAgentError,
                crate::input::DescribeAgentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to describe.</p>
        pub fn agent_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to describe.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationEfs`.
    ///
    /// <p>Returns metadata, such as the path information about an Amazon EFS location.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationEfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_efs_input::Builder,
    }
    impl<C, M, R> DescribeLocationEfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationEfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationEfsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationEfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationEfsInputOperationOutputAlias,
                crate::output::DescribeLocationEfsOutput,
                crate::error::DescribeLocationEfsError,
                crate::input::DescribeLocationEfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the EFS location to describe.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the EFS location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationFsxWindows`.
    ///
    /// <p>Returns metadata, such as the path information about an Amazon FSx for Windows File Server
    /// location.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationFsxWindows<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_fsx_windows_input::Builder,
    }
    impl<C, M, R> DescribeLocationFsxWindows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationFsxWindows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationFsxWindowsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationFsxWindowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationFsxWindowsInputOperationOutputAlias,
                crate::output::DescribeLocationFsxWindowsOutput,
                crate::error::DescribeLocationFsxWindowsError,
                crate::input::DescribeLocationFsxWindowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location to
        /// describe.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location to
        /// describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationHdfs`.
    ///
    /// <p>Returns metadata, such as the authentication information about the Hadoop Distributed File
    /// System (HDFS) location. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationHdfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_hdfs_input::Builder,
    }
    impl<C, M, R> DescribeLocationHdfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationHdfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationHdfsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationHdfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationHdfsInputOperationOutputAlias,
                crate::output::DescribeLocationHdfsOutput,
                crate::error::DescribeLocationHdfsError,
                crate::input::DescribeLocationHdfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the HDFS cluster location to describe.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the HDFS cluster location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationNfs`.
    ///
    /// <p>Returns metadata, such as the path information, about an NFS location.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationNfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_nfs_input::Builder,
    }
    impl<C, M, R> DescribeLocationNfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationNfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationNfsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationNfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationNfsInputOperationOutputAlias,
                crate::output::DescribeLocationNfsOutput,
                crate::error::DescribeLocationNfsError,
                crate::input::DescribeLocationNfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to describe.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationObjectStorage`.
    ///
    /// <p>Returns metadata about a self-managed object storage server location. For more information
    /// about self-managed object storage locations, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a location for object storage</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationObjectStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_object_storage_input::Builder,
    }
    impl<C, M, R> DescribeLocationObjectStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationObjectStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationObjectStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationObjectStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationObjectStorageInputOperationOutputAlias,
                crate::output::DescribeLocationObjectStorageOutput,
                crate::error::DescribeLocationObjectStorageError,
                crate::input::DescribeLocationObjectStorageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location that was described.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationS3`.
    ///
    /// <p>Returns metadata, such as bucket name, about an Amazon S3 bucket location.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationS3<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_s3_input::Builder,
    }
    impl<C, M, R> DescribeLocationS3<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationS3Output,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationS3Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationS3InputOperationOutputAlias,
                crate::output::DescribeLocationS3Output,
                crate::error::DescribeLocationS3Error,
                crate::input::DescribeLocationS3InputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLocationSmb`.
    ///
    /// <p>Returns metadata, such as the path and user information about an SMB location.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLocationSmb<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_location_smb_input::Builder,
    }
    impl<C, M, R> DescribeLocationSmb<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLocationSmb`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLocationSmbOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLocationSmbError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLocationSmbInputOperationOutputAlias,
                crate::output::DescribeLocationSmbOutput,
                crate::error::DescribeLocationSmbError,
                crate::input::DescribeLocationSmbInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to describe.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTask`.
    ///
    /// <p>Returns metadata about a task.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_task_input::Builder,
    }
    impl<C, M, R> DescribeTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTaskInputOperationOutputAlias,
                crate::output::DescribeTaskOutput,
                crate::error::DescribeTaskError,
                crate::input::DescribeTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task to describe.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task to describe.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTaskExecution`.
    ///
    /// <p>Returns detailed metadata about a task that is being executed.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTaskExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_task_execution_input::Builder,
    }
    impl<C, M, R> DescribeTaskExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTaskExecutionInputOperationOutputAlias,
                crate::output::DescribeTaskExecutionOutput,
                crate::error::DescribeTaskExecutionError,
                crate::input::DescribeTaskExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task that is being executed.</p>
        pub fn task_execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that is being executed.</p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAgents`.
    ///
    /// <p>Returns a list of agents owned by an Amazon Web Services account in the Amazon Web Services Region specified in the
    /// request. The returned list is ordered by agent Amazon Resource Name (ARN).</p>
    /// <p>By default, this operation returns a maximum of 100 agents. This operation supports
    /// pagination that enables you to optionally reduce the number of agents returned in a
    /// response.</p>
    /// <p>If you have more agents than are returned in a response (that is, the response returns
    /// only a truncated list of your agents), the response contains a marker that you can specify in
    /// your next request to fetch the next page of agents.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAgents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_agents_input::Builder,
    }
    impl<C, M, R> ListAgents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAgentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAgentsInputOperationOutputAlias,
                crate::output::ListAgentsOutput,
                crate::error::ListAgentsError,
                crate::input::ListAgentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of agents to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of agents to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// agents.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// agents.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLocations`.
    ///
    /// <p>Returns a list of source and destination locations.</p>
    /// <p>If you have more locations than are returned in a response (that is, the response
    /// returns only a truncated list of your agents), the response contains a token that you can
    /// specify in your next request to fetch the next page of locations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLocations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_locations_input::Builder,
    }
    impl<C, M, R> ListLocations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLocationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLocationsInputOperationOutputAlias,
                crate::output::ListLocationsOutput,
                crate::error::ListLocationsError,
                crate::input::ListLocationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// locations.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// locations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>.
        /// For example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code>
        /// with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::LocationFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>.
        /// For example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code>
        /// with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns all the tags associated with a specified resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags to list.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of locations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// locations.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// locations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTaskExecutions`.
    ///
    /// <p>Returns a list of executed tasks.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTaskExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_task_executions_input::Builder,
    }
    impl<C, M, R> ListTaskExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTaskExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTaskExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTaskExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTaskExecutionsInputOperationOutputAlias,
                crate::output::ListTaskExecutionsOutput,
                crate::error::ListTaskExecutionsError,
                crate::input::ListTaskExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task whose tasks you want to list.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task whose tasks you want to list.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>The maximum number of executed tasks to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of executed tasks to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of the
        /// executed tasks.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of the
        /// executed tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTasks`.
    ///
    /// <p>Returns a list of all the tasks.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tasks_input::Builder,
    }
    impl<C, M, R> ListTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTasksInputOperationOutputAlias,
                crate::output::ListTasksOutput,
                crate::error::ListTasksError,
                crate::input::ListTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of tasks to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tasks to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// tasks.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An opaque string that indicates the position at which to begin the next list of
        /// tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>.
        /// For example, to retrieve all tasks on a specific source location, you can use <code>ListTasks</code>
        /// with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the
        /// location.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::TaskFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>.
        /// For example, to retrieve all tasks on a specific source location, you can use <code>ListTasks</code>
        /// with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the
        /// location.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTaskExecution`.
    ///
    /// <p>Starts a specific invocation of a task. A <code>TaskExecution</code> value represents
    /// an individual run of a task. Each task can have at most one <code>TaskExecution</code> at a
    /// time.</p>
    /// <p>
    /// <code>TaskExecution</code> has the following transition phases: INITIALIZING |
    /// PREPARING | TRANSFERRING | VERIFYING | SUCCESS/FAILURE. </p>
    ///
    /// <p>For detailed information, see the Task Execution section in the Components and
    /// Terminology topic in the <i>DataSync User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartTaskExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_task_execution_input::Builder,
    }
    impl<C, M, R> StartTaskExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTaskExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTaskExecutionInputOperationOutputAlias,
                crate::output::StartTaskExecutionOutput,
                crate::error::StartTaskExecutionError,
                crate::input::StartTaskExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task to start.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task to start.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a
        /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
        /// operation. Behavior includes preserving metadata such as user
        /// ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination,
        /// data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option
        /// in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
        /// the default value is used. You can override the
        /// defaults options on each task execution by specifying an overriding <code>Options</code> value
        /// to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn override_options(mut self, inp: crate::model::Options) -> Self {
            self.inner = self.inner.override_options(inp);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a
        /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
        /// operation. Behavior includes preserving metadata such as user
        /// ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination,
        /// data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option
        /// in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
        /// the default value is used. You can override the
        /// defaults options on each task execution by specifying an overriding <code>Options</code> value
        /// to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_override_options(
            mut self,
            input: std::option::Option<crate::model::Options>,
        ) -> Self {
            self.inner = self.inner.set_override_options(input);
            self
        }
        /// Appends an item to `Includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The
        /// pattern should contain a single filter string that consists of the patterns to include. The
        /// patterns are delimited by "|" (that is, a pipe), for example,
        /// <code>"/folder1|/folder2"</code>. </p>
        ///
        /// <p>
        /// </p>
        pub fn includes(mut self, inp: impl Into<crate::model::FilterRule>) -> Self {
            self.inner = self.inner.includes(inp);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The
        /// pattern should contain a single filter string that consists of the patterns to include. The
        /// patterns are delimited by "|" (that is, a pipe), for example,
        /// <code>"/folder1|/folder2"</code>. </p>
        ///
        /// <p>
        /// </p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_includes(input);
            self
        }
        /// Appends an item to `Excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list
        /// contains a single filter string that consists of the patterns to exclude. The patterns are
        /// delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        pub fn excludes(mut self, inp: impl Into<crate::model::FilterRule>) -> Self {
            self.inner = self.inner.excludes(inp);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list
        /// contains a single filter string that consists of the patterns to exclude. The patterns are
        /// delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_excludes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies a key-value pair to an Amazon Web Services resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply the tag to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply the tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::TagListEntry>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to apply.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an Amazon Web Services resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tag from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys in the key-value pair in the tag to remove.</p>
        pub fn keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keys(inp);
            self
        }
        /// <p>The keys in the key-value pair in the tag to remove.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAgent`.
    ///
    /// <p>Updates the name of an agent.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAgent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_agent_input::Builder,
    }
    impl<C, M, R> UpdateAgent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAgentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAgentInputOperationOutputAlias,
                crate::output::UpdateAgentOutput,
                crate::error::UpdateAgentError,
                crate::input::UpdateAgentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to update.</p>
        pub fn agent_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent to update.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_agent_arn(input);
            self
        }
        /// <p>The name that you want to use to configure the agent.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name that you want to use to configure the agent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationHdfs`.
    ///
    /// <p>Updates some parameters of a previously created location for a Hadoop Distributed File
    /// System cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLocationHdfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_location_hdfs_input::Builder,
    }
    impl<C, M, R> UpdateLocationHdfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLocationHdfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationHdfsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationHdfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLocationHdfsInputOperationOutputAlias,
                crate::output::UpdateLocationHdfsOutput,
                crate::error::UpdateLocationHdfsError,
                crate::input::UpdateLocationHdfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the source HDFS cluster location.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source HDFS cluster location.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write
        /// data to the HDFS cluster.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write
        /// data to the HDFS cluster.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// Appends an item to `NameNodes`.
        ///
        /// To override the contents of this collection use [`set_name_nodes`](Self::set_name_nodes).
        ///
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as
        /// opening, closing, and renaming files and directories. The NameNode contains the information to
        /// map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn name_nodes(mut self, inp: impl Into<crate::model::HdfsNameNode>) -> Self {
            self.inner = self.inner.name_nodes(inp);
            self
        }
        /// <p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as
        /// opening, closing, and renaming files and directories. The NameNode contains the information to
        /// map blocks of data to the DataNodes. You can use only one NameNode.</p>
        pub fn set_name_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
        ) -> Self {
            self.inner = self.inner.set_name_nodes(input);
            self
        }
        /// <p>The size of the data blocks to write into the HDFS cluster. </p>
        pub fn block_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.block_size(inp);
            self
        }
        /// <p>The size of the data blocks to write into the HDFS cluster. </p>
        pub fn set_block_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_size(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
        pub fn replication_factor(mut self, inp: i32) -> Self {
            self.inner = self.inner.replication_factor(inp);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_replication_factor(input);
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn kms_key_provider_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_provider_uri(inp);
            self
        }
        /// <p>The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn set_kms_key_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kms_key_provider_uri(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC)
        /// and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS)
        /// cluster. </p>
        pub fn qop_configuration(mut self, inp: crate::model::QopConfiguration) -> Self {
            self.inner = self.inner.qop_configuration(inp);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC)
        /// and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS)
        /// cluster. </p>
        pub fn set_qop_configuration(
            mut self,
            input: std::option::Option<crate::model::QopConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_qop_configuration(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn authentication_type(mut self, inp: crate::model::HdfsAuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::HdfsAuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The user name used to identify the client on the host operating system.</p>
        pub fn simple_user(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.simple_user(inp);
            self
        }
        /// <p>The user name used to identify the client on the host operating system.</p>
        pub fn set_simple_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_simple_user(input);
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
        pub fn kerberos_principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kerberos_principal(inp);
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>
        pub fn set_kerberos_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_principal(input);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos
        /// principal and the encrypted keys. You can load the keytab from a file by providing the file's
        /// address. If you use the AWS CLI, it performs base64 encoding for you. Otherwise, provide the
        /// base64-encoded text.</p>
        pub fn kerberos_keytab(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_keytab(inp);
            self
        }
        /// <p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos
        /// principal and the encrypted keys. You can load the keytab from a file by providing the file's
        /// address. If you use the AWS CLI, it performs base64 encoding for you. Otherwise, provide the
        /// base64-encoded text.</p>
        pub fn set_kerberos_keytab(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_keytab(input);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You
        /// can load the <code>krb5.conf</code> file by providing the file's address. If you're using the
        /// AWS CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded
        /// text.</p>
        pub fn kerberos_krb5_conf(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.kerberos_krb5_conf(inp);
            self
        }
        /// <p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You
        /// can load the <code>krb5.conf</code> file by providing the file's address. If you're using the
        /// AWS CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded
        /// text.</p>
        pub fn set_kerberos_krb5_conf(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_kerberos_krb5_conf(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationNfs`.
    ///
    /// <p>Updates some of the parameters of a previously created location for Network File System (NFS) access.
    /// For information about creating an NFS location, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Creating a location for NFS</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLocationNfs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_location_nfs_input::Builder,
    }
    impl<C, M, R> UpdateLocationNfs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLocationNfs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationNfsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationNfsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLocationNfsInputOperationOutputAlias,
                crate::output::UpdateLocationNfsOutput,
                crate::error::UpdateLocationNfsError,
                crate::input::UpdateLocationNfsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to update.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location to update.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source
        /// location or write data to the NFS destination. The NFS path should be a path that's
        /// exported by the NFS server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other NFS clients in your network.</p>
        ///
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e
        /// nfs-server-name</code>" from an NFS client that has access to your server. You can specify
        /// any directory that appears in the results, and any subdirectory of that directory. Ensure that
        /// the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder that you specified, DataSync must have
        /// permissions to read all the data. To ensure this, either configure the NFS export with
        /// <code>no_root_squash</code>, or ensure that the files you want DataSync to
        /// access have permissions that allow read access for all users. Doing either option enables the
        /// agent to read the files. For the agent to access directories, you must additionally enable all
        /// execute access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        ///
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports
        /// Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>The subdirectory in the NFS file system that is used to read data from the NFS source
        /// location or write data to the NFS destination. The NFS path should be a path that's
        /// exported by the NFS server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other NFS clients in your network.</p>
        ///
        /// <p>To see all the paths exported by your NFS server, run "<code>showmount -e
        /// nfs-server-name</code>" from an NFS client that has access to your server. You can specify
        /// any directory that appears in the results, and any subdirectory of that directory. Ensure that
        /// the NFS export is accessible without Kerberos authentication. </p>
        /// <p>To transfer all the data in the folder that you specified, DataSync must have
        /// permissions to read all the data. To ensure this, either configure the NFS export with
        /// <code>no_root_squash</code>, or ensure that the files you want DataSync to
        /// access have permissions that allow read access for all users. Doing either option enables the
        /// agent to read the files. For the agent to access directories, you must additionally enable all
        /// execute access.</p>
        /// <p>If you are copying data to or from your Snowcone device, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone">NFS Server on Snowcone</a> for more information.</p>
        ///
        /// <p>For information about NFS export configuration, see 18.7. The /etc/exports
        /// Configuration File in the Red Hat Enterprise Linux documentation.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS)
        /// location.</p>
        pub fn on_prem_config(mut self, inp: crate::model::OnPremConfig) -> Self {
            self.inner = self.inner.on_prem_config(inp);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS)
        /// location.</p>
        pub fn set_on_prem_config(
            mut self,
            input: std::option::Option<crate::model::OnPremConfig>,
        ) -> Self {
            self.inner = self.inner.set_on_prem_config(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an NFS
        /// location.</p>
        pub fn mount_options(mut self, inp: crate::model::NfsMountOptions) -> Self {
            self.inner = self.inner.mount_options(inp);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an NFS
        /// location.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::NfsMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationObjectStorage`.
    ///
    /// <p>Updates some of the parameters of a previously created location for self-managed object
    /// storage server access. For information about creating a self-managed object storage location,
    /// see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a location for object storage</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLocationObjectStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_location_object_storage_input::Builder,
    }
    impl<C, M, R> UpdateLocationObjectStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLocationObjectStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationObjectStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationObjectStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLocationObjectStorageInputOperationOutputAlias,
                crate::output::UpdateLocationObjectStorageOutput,
                crate::error::UpdateLocationObjectStorageError,
                crate::input::UpdateLocationObjectStorageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to be updated.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on.
        /// The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can
        /// specify a custom port if your self-managed object storage server requires one.</p>
        pub fn server_port(mut self, inp: i32) -> Self {
            self.inner = self.inner.server_port(inp);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on.
        /// The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS). You can
        /// specify a custom port if your self-managed object storage server requires one.</p>
        pub fn set_server_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_server_port(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are
        /// <code>HTTP</code> or <code>HTTPS</code>.</p>
        pub fn server_protocol(mut self, inp: crate::model::ObjectStorageServerProtocol) -> Self {
            self.inner = self.inner.server_protocol(inp);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are
        /// <code>HTTP</code> or <code>HTTPS</code>.</p>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::ObjectStorageServerProtocol>,
        ) -> Self {
            self.inner = self.inner.set_server_protocol(input);
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used
        /// to read data from.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>The subdirectory in the self-managed object storage server that is used
        /// to read data from.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn access_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key(inp);
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn set_access_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_access_key(input);
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn secret_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_key(inp);
            self
        }
        /// <p>Optional. The secret key is used if credentials are required to access the self-managed
        /// object storage server. If your object storage requires a user name and password to
        /// authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name
        /// and password, respectively.</p>
        pub fn set_secret_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_key(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the
        /// self-managed object storage server location.</p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the
        /// self-managed object storage server location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLocationSmb`.
    ///
    /// <p>Updates some of the parameters of a previously created location for Server Message Block
    /// (SMB) file system access. For information about creating an SMB location, see
    /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html">Creating a location for SMB</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLocationSmb<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_location_smb_input::Builder,
    }
    impl<C, M, R> UpdateLocationSmb<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLocationSmb`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLocationSmbOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLocationSmbError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLocationSmbInputOperationOutputAlias,
                crate::output::UpdateLocationSmbOutput,
                crate::error::UpdateLocationSmbError,
                crate::input::UpdateLocationSmbInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to update.</p>
        pub fn location_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location to update.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location_arn(input);
            self
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source
        /// location or write data to the SMB destination. The SMB path should be a path that's
        /// exported by the SMB server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other SMB clients in your network.</p>
        /// <note>
        /// <p>
        /// <code>Subdirectory</code> must be specified with forward slashes. For example,
        /// <code>/path/to/folder</code>.</p>
        /// </note>
        ///
        /// <p>To transfer all the data in the folder that you specified, DataSync must have
        /// permissions to mount the SMB share and to access all the data in that share. To ensure this,
        /// do either of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Ensure that the user/password specified belongs to the user who can mount the share
        /// and who has the appropriate permissions for all of the files and directories that you want
        /// DataSync to access.</p>
        /// </li>
        /// <li>
        /// <p>Use credentials of a member of the Backup Operators group to mount the share. </p>
        /// </li>
        /// </ul>
        /// <p>Doing either of these options enables the agent to access the data. For the agent to
        /// access directories, you must also enable all execute access.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>The subdirectory in the SMB file system that is used to read data from the SMB source
        /// location or write data to the SMB destination. The SMB path should be a path that's
        /// exported by the SMB server, or a subdirectory of that path. The path should be such that it
        /// can be mounted by other SMB clients in your network.</p>
        /// <note>
        /// <p>
        /// <code>Subdirectory</code> must be specified with forward slashes. For example,
        /// <code>/path/to/folder</code>.</p>
        /// </note>
        ///
        /// <p>To transfer all the data in the folder that you specified, DataSync must have
        /// permissions to mount the SMB share and to access all the data in that share. To ensure this,
        /// do either of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Ensure that the user/password specified belongs to the user who can mount the share
        /// and who has the appropriate permissions for all of the files and directories that you want
        /// DataSync to access.</p>
        /// </li>
        /// <li>
        /// <p>Use credentials of a member of the Backup Operators group to mount the share. </p>
        /// </li>
        /// </ul>
        /// <p>Doing either of these options enables the agent to access the data. For the agent to
        /// access directories, you must also enable all execute access.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
        /// <p>The user who can mount the share has the permissions to access files and folders in the
        /// SMB share.</p>
        pub fn user(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user(inp);
            self
        }
        /// <p>The user who can mount the share has the permissions to access files and folders in the
        /// SMB share.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user(input);
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The password of the user who can mount the share has the permissions to access files and
        /// folders in the SMB share.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password of the user who can mount the share has the permissions to access files and
        /// folders in the SMB share.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// Appends an item to `AgentArns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB)
        /// location.</p>
        pub fn agent_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB)
        /// location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_agent_arns(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an SMB
        /// location.</p>
        pub fn mount_options(mut self, inp: crate::model::SmbMountOptions) -> Self {
            self.inner = self.inner.mount_options(inp);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an SMB
        /// location.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::SmbMountOptions>,
        ) -> Self {
            self.inner = self.inner.set_mount_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTask`.
    ///
    /// <p>Updates the metadata associated with a task.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_task_input::Builder,
    }
    impl<C, M, R> UpdateTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTaskInputOperationOutputAlias,
                crate::output::UpdateTaskOutput,
                crate::error::UpdateTaskError,
                crate::input::UpdateTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the task to update.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the task to update.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a
        /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
        /// operation. Behavior includes preserving metadata such as user
        /// ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination,
        /// data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option
        /// in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
        /// the default value is used. You can override the
        /// defaults options on each task execution by specifying an overriding <code>Options</code> value
        /// to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn options(mut self, inp: crate::model::Options) -> Self {
            self.inner = self.inner.options(inp);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a
        /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
        /// operation. Behavior includes preserving metadata such as user
        /// ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination,
        /// data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option
        /// in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
        /// the default value is used. You can override the
        /// defaults options on each task execution by specifying an overriding <code>Options</code> value
        /// to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
        /// Appends an item to `Excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should
        /// contain a single filter string that consists of the patterns to exclude. The patterns are
        /// delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        /// <p>
        /// </p>
        pub fn excludes(mut self, inp: impl Into<crate::model::FilterRule>) -> Self {
            self.inner = self.inner.excludes(inp);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should
        /// contain a single filter string that consists of the patterns to exclude. The patterns are
        /// delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        /// <p>
        /// </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_excludes(input);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination
        /// location. You can configure your task to execute hourly, daily, weekly or on specific days of
        /// the week. You control when in the day or hour you want the task to execute. The time you
        /// specify is UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn schedule(mut self, inp: crate::model::TaskSchedule) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>Specifies a schedule used to periodically transfer files from a source to a destination
        /// location. You can configure your task to execute hourly, daily, weekly or on specific days of
        /// the week. You control when in the day or hour you want the task to execute. The time you
        /// specify is UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::TaskSchedule>,
        ) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The name of the task to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the task to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log
        /// group.</p>
        pub fn cloud_watch_log_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_log_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log
        /// group.</p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_log_group_arn(input);
            self
        }
        /// Appends an item to `Includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The
        /// pattern contains a single filter string that consists of the patterns to include. The patterns
        /// are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn includes(mut self, inp: impl Into<crate::model::FilterRule>) -> Self {
            self.inner = self.inner.includes(inp);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The
        /// pattern contains a single filter string that consists of the patterns to include. The patterns
        /// are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.inner = self.inner.set_includes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTaskExecution`.
    ///
    /// <p>Updates execution of a task.</p>
    /// <p>You can modify bandwidth throttling for a task execution that is running or queued.
    /// For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#adjust-bandwidth-throttling">Adjusting Bandwidth Throttling for a Task Execution</a>.</p>
    ///
    /// <note>
    /// <p>The only <code>Option</code> that can be modified by <code>UpdateTaskExecution</code>
    /// is <code>
    /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a>
    /// </code>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTaskExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_task_execution_input::Builder,
    }
    impl<C, M, R> UpdateTaskExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTaskExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTaskExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTaskExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTaskExecutionInputOperationOutputAlias,
                crate::output::UpdateTaskExecutionOutput,
                crate::error::UpdateTaskExecutionError,
                crate::input::UpdateTaskExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the specific task execution that is being updated. </p>
        pub fn task_execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specific task execution that is being updated. </p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_execution_arn(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a
        /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
        /// operation. Behavior includes preserving metadata such as user
        /// ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination,
        /// data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option
        /// in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
        /// the default value is used. You can override the
        /// defaults options on each task execution by specifying an overriding <code>Options</code> value
        /// to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn options(mut self, inp: crate::model::Options) -> Self {
            self.inner = self.inner.options(inp);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a
        /// <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
        /// operation. Behavior includes preserving metadata such as user
        /// ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination,
        /// data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option
        /// in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
        /// the default value is used. You can override the
        /// defaults options on each task execution by specifying an overriding <code>Options</code> value
        /// to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
