// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTaskExecutionOutput {}
impl std::fmt::Debug for UpdateTaskExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTaskExecutionOutput");
        formatter.finish()
    }
}
/// See [`UpdateTaskExecutionOutput`](crate::output::UpdateTaskExecutionOutput)
pub mod update_task_execution_output {
    /// A builder for [`UpdateTaskExecutionOutput`](crate::output::UpdateTaskExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTaskExecutionOutput`](crate::output::UpdateTaskExecutionOutput)
        pub fn build(self) -> crate::output::UpdateTaskExecutionOutput {
            crate::output::UpdateTaskExecutionOutput {}
        }
    }
}
impl UpdateTaskExecutionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTaskExecutionOutput`](crate::output::UpdateTaskExecutionOutput)
    pub fn builder() -> crate::output::update_task_execution_output::Builder {
        crate::output::update_task_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTaskOutput {}
impl std::fmt::Debug for UpdateTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTaskOutput");
        formatter.finish()
    }
}
/// See [`UpdateTaskOutput`](crate::output::UpdateTaskOutput)
pub mod update_task_output {
    /// A builder for [`UpdateTaskOutput`](crate::output::UpdateTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTaskOutput`](crate::output::UpdateTaskOutput)
        pub fn build(self) -> crate::output::UpdateTaskOutput {
            crate::output::UpdateTaskOutput {}
        }
    }
}
impl UpdateTaskOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTaskOutput`](crate::output::UpdateTaskOutput)
    pub fn builder() -> crate::output::update_task_output::Builder {
        crate::output::update_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLocationSmbOutput {}
impl std::fmt::Debug for UpdateLocationSmbOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLocationSmbOutput");
        formatter.finish()
    }
}
/// See [`UpdateLocationSmbOutput`](crate::output::UpdateLocationSmbOutput)
pub mod update_location_smb_output {
    /// A builder for [`UpdateLocationSmbOutput`](crate::output::UpdateLocationSmbOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateLocationSmbOutput`](crate::output::UpdateLocationSmbOutput)
        pub fn build(self) -> crate::output::UpdateLocationSmbOutput {
            crate::output::UpdateLocationSmbOutput {}
        }
    }
}
impl UpdateLocationSmbOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLocationSmbOutput`](crate::output::UpdateLocationSmbOutput)
    pub fn builder() -> crate::output::update_location_smb_output::Builder {
        crate::output::update_location_smb_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLocationObjectStorageOutput {}
impl std::fmt::Debug for UpdateLocationObjectStorageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLocationObjectStorageOutput");
        formatter.finish()
    }
}
/// See [`UpdateLocationObjectStorageOutput`](crate::output::UpdateLocationObjectStorageOutput)
pub mod update_location_object_storage_output {
    /// A builder for [`UpdateLocationObjectStorageOutput`](crate::output::UpdateLocationObjectStorageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateLocationObjectStorageOutput`](crate::output::UpdateLocationObjectStorageOutput)
        pub fn build(self) -> crate::output::UpdateLocationObjectStorageOutput {
            crate::output::UpdateLocationObjectStorageOutput {}
        }
    }
}
impl UpdateLocationObjectStorageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLocationObjectStorageOutput`](crate::output::UpdateLocationObjectStorageOutput)
    pub fn builder() -> crate::output::update_location_object_storage_output::Builder {
        crate::output::update_location_object_storage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLocationNfsOutput {}
impl std::fmt::Debug for UpdateLocationNfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLocationNfsOutput");
        formatter.finish()
    }
}
/// See [`UpdateLocationNfsOutput`](crate::output::UpdateLocationNfsOutput)
pub mod update_location_nfs_output {
    /// A builder for [`UpdateLocationNfsOutput`](crate::output::UpdateLocationNfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateLocationNfsOutput`](crate::output::UpdateLocationNfsOutput)
        pub fn build(self) -> crate::output::UpdateLocationNfsOutput {
            crate::output::UpdateLocationNfsOutput {}
        }
    }
}
impl UpdateLocationNfsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLocationNfsOutput`](crate::output::UpdateLocationNfsOutput)
    pub fn builder() -> crate::output::update_location_nfs_output::Builder {
        crate::output::update_location_nfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLocationHdfsOutput {}
impl std::fmt::Debug for UpdateLocationHdfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLocationHdfsOutput");
        formatter.finish()
    }
}
/// See [`UpdateLocationHdfsOutput`](crate::output::UpdateLocationHdfsOutput)
pub mod update_location_hdfs_output {
    /// A builder for [`UpdateLocationHdfsOutput`](crate::output::UpdateLocationHdfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateLocationHdfsOutput`](crate::output::UpdateLocationHdfsOutput)
        pub fn build(self) -> crate::output::UpdateLocationHdfsOutput {
            crate::output::UpdateLocationHdfsOutput {}
        }
    }
}
impl UpdateLocationHdfsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLocationHdfsOutput`](crate::output::UpdateLocationHdfsOutput)
    pub fn builder() -> crate::output::update_location_hdfs_output::Builder {
        crate::output::update_location_hdfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAgentOutput {}
impl std::fmt::Debug for UpdateAgentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAgentOutput");
        formatter.finish()
    }
}
/// See [`UpdateAgentOutput`](crate::output::UpdateAgentOutput)
pub mod update_agent_output {
    /// A builder for [`UpdateAgentOutput`](crate::output::UpdateAgentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAgentOutput`](crate::output::UpdateAgentOutput)
        pub fn build(self) -> crate::output::UpdateAgentOutput {
            crate::output::UpdateAgentOutput {}
        }
    }
}
impl UpdateAgentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAgentOutput`](crate::output::UpdateAgentOutput)
    pub fn builder() -> crate::output::update_agent_output::Builder {
        crate::output::update_agent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>StartTaskExecutionResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTaskExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the specific task execution that was started.</p>
    pub task_execution_arn: std::option::Option<std::string::String>,
}
impl StartTaskExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the specific task execution that was started.</p>
    pub fn task_execution_arn(&self) -> std::option::Option<&str> {
        self.task_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for StartTaskExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTaskExecutionOutput");
        formatter.field("task_execution_arn", &self.task_execution_arn);
        formatter.finish()
    }
}
/// See [`StartTaskExecutionOutput`](crate::output::StartTaskExecutionOutput)
pub mod start_task_execution_output {
    /// A builder for [`StartTaskExecutionOutput`](crate::output::StartTaskExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the specific task execution that was started.</p>
        pub fn task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specific task execution that was started.</p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTaskExecutionOutput`](crate::output::StartTaskExecutionOutput)
        pub fn build(self) -> crate::output::StartTaskExecutionOutput {
            crate::output::StartTaskExecutionOutput {
                task_execution_arn: self.task_execution_arn,
            }
        }
    }
}
impl StartTaskExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartTaskExecutionOutput`](crate::output::StartTaskExecutionOutput)
    pub fn builder() -> crate::output::start_task_execution_output::Builder {
        crate::output::start_task_execution_output::Builder::default()
    }
}

/// <p>ListTasksResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTasksOutput {
    /// <p>A list of all the tasks that are returned.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::TaskListEntry>>,
    /// <p>An opaque string that indicates the position at which to begin returning the next list of tasks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTasksOutput {
    /// <p>A list of all the tasks that are returned.</p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::TaskListEntry]> {
        self.tasks.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin returning the next list of tasks.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTasksOutput`](crate::output::ListTasksOutput)
pub mod list_tasks_output {
    /// A builder for [`ListTasksOutput`](crate::output::ListTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::TaskListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A list of all the tasks that are returned.</p>
        pub fn tasks(mut self, input: crate::model::TaskListEntry) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>A list of all the tasks that are returned.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskListEntry>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTasksOutput`](crate::output::ListTasksOutput)
        pub fn build(self) -> crate::output::ListTasksOutput {
            crate::output::ListTasksOutput {
                tasks: self.tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListTasksOutput`](crate::output::ListTasksOutput)
    pub fn builder() -> crate::output::list_tasks_output::Builder {
        crate::output::list_tasks_output::Builder::default()
    }
}

/// <p>ListTaskExecutionsResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTaskExecutionsOutput {
    /// <p>A list of executed tasks.</p>
    pub task_executions: std::option::Option<std::vec::Vec<crate::model::TaskExecutionListEntry>>,
    /// <p>An opaque string that indicates the position at which to begin returning the next list of executed tasks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTaskExecutionsOutput {
    /// <p>A list of executed tasks.</p>
    pub fn task_executions(&self) -> std::option::Option<&[crate::model::TaskExecutionListEntry]> {
        self.task_executions.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin returning the next list of executed tasks.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTaskExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTaskExecutionsOutput");
        formatter.field("task_executions", &self.task_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTaskExecutionsOutput`](crate::output::ListTaskExecutionsOutput)
pub mod list_task_executions_output {
    /// A builder for [`ListTaskExecutionsOutput`](crate::output::ListTaskExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_executions:
            std::option::Option<std::vec::Vec<crate::model::TaskExecutionListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `task_executions`.
        ///
        /// To override the contents of this collection use [`set_task_executions`](Self::set_task_executions).
        ///
        /// <p>A list of executed tasks.</p>
        pub fn task_executions(mut self, input: crate::model::TaskExecutionListEntry) -> Self {
            let mut v = self.task_executions.unwrap_or_default();
            v.push(input);
            self.task_executions = Some(v);
            self
        }
        /// <p>A list of executed tasks.</p>
        pub fn set_task_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskExecutionListEntry>>,
        ) -> Self {
            self.task_executions = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of executed tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of executed tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTaskExecutionsOutput`](crate::output::ListTaskExecutionsOutput)
        pub fn build(self) -> crate::output::ListTaskExecutionsOutput {
            crate::output::ListTaskExecutionsOutput {
                task_executions: self.task_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTaskExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTaskExecutionsOutput`](crate::output::ListTaskExecutionsOutput)
    pub fn builder() -> crate::output::list_task_executions_output::Builder {
        crate::output::list_task_executions_output::Builder::default()
    }
}

/// <p>ListTagsForResourceResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Array of resource tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
    /// <p>An opaque string that indicates the position at which to begin returning the next list of resource tags.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>Array of resource tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagListEntry]> {
        self.tags.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin returning the next list of resource tags.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of resource tags.</p>
        pub fn tags(mut self, input: crate::model::TagListEntry) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Array of resource tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagListEntry>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of resource tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of resource tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>ListLocationsResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLocationsOutput {
    /// <p>An array that contains a list of locations.</p>
    pub locations: std::option::Option<std::vec::Vec<crate::model::LocationListEntry>>,
    /// <p>An opaque string that indicates the position at which to begin returning the next list of locations.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLocationsOutput {
    /// <p>An array that contains a list of locations.</p>
    pub fn locations(&self) -> std::option::Option<&[crate::model::LocationListEntry]> {
        self.locations.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin returning the next list of locations.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLocationsOutput");
        formatter.field("locations", &self.locations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLocationsOutput`](crate::output::ListLocationsOutput)
pub mod list_locations_output {
    /// A builder for [`ListLocationsOutput`](crate::output::ListLocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locations: std::option::Option<std::vec::Vec<crate::model::LocationListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>An array that contains a list of locations.</p>
        pub fn locations(mut self, input: crate::model::LocationListEntry) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input);
            self.locations = Some(v);
            self
        }
        /// <p>An array that contains a list of locations.</p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationListEntry>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of locations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of locations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLocationsOutput`](crate::output::ListLocationsOutput)
        pub fn build(self) -> crate::output::ListLocationsOutput {
            crate::output::ListLocationsOutput {
                locations: self.locations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLocationsOutput {
    /// Creates a new builder-style object to manufacture [`ListLocationsOutput`](crate::output::ListLocationsOutput)
    pub fn builder() -> crate::output::list_locations_output::Builder {
        crate::output::list_locations_output::Builder::default()
    }
}

/// <p>ListAgentsResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAgentsOutput {
    /// <p>A list of agents in your account.</p>
    pub agents: std::option::Option<std::vec::Vec<crate::model::AgentListEntry>>,
    /// <p>An opaque string that indicates the position at which to begin returning the next list of agents.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAgentsOutput {
    /// <p>A list of agents in your account.</p>
    pub fn agents(&self) -> std::option::Option<&[crate::model::AgentListEntry]> {
        self.agents.as_deref()
    }
    /// <p>An opaque string that indicates the position at which to begin returning the next list of agents.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAgentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAgentsOutput");
        formatter.field("agents", &self.agents);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAgentsOutput`](crate::output::ListAgentsOutput)
pub mod list_agents_output {
    /// A builder for [`ListAgentsOutput`](crate::output::ListAgentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agents: std::option::Option<std::vec::Vec<crate::model::AgentListEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `agents`.
        ///
        /// To override the contents of this collection use [`set_agents`](Self::set_agents).
        ///
        /// <p>A list of agents in your account.</p>
        pub fn agents(mut self, input: crate::model::AgentListEntry) -> Self {
            let mut v = self.agents.unwrap_or_default();
            v.push(input);
            self.agents = Some(v);
            self
        }
        /// <p>A list of agents in your account.</p>
        pub fn set_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentListEntry>>,
        ) -> Self {
            self.agents = input;
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of agents.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An opaque string that indicates the position at which to begin returning the next list of agents.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAgentsOutput`](crate::output::ListAgentsOutput)
        pub fn build(self) -> crate::output::ListAgentsOutput {
            crate::output::ListAgentsOutput {
                agents: self.agents,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAgentsOutput {
    /// Creates a new builder-style object to manufacture [`ListAgentsOutput`](crate::output::ListAgentsOutput)
    pub fn builder() -> crate::output::list_agents_output::Builder {
        crate::output::list_agents_output::Builder::default()
    }
}

/// <p>DescribeTaskExecutionResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
    /// <p>For example, a <code>TaskExecution</code> value with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code> executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>. </p>
    pub task_execution_arn: std::option::Option<std::string::String>,
    /// <p>The status of the task execution. </p>
    /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide.</i> </p>
    pub status: std::option::Option<crate::model::TaskExecutionStatus>,
    /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
    /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
    pub options: std::option::Option<crate::model::Options>,
    /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
    /// <p> </p>
    pub excludes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
    /// <p>A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
    /// <p> </p>
    pub includes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
    /// <p>The time that the task execution was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred. </p>
    pub estimated_files_to_transfer: i64,
    /// <p>The estimated physical number of bytes that is to be transferred over the network.</p>
    pub estimated_bytes_to_transfer: i64,
    /// <p>The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network. </p>
    /// <p>If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.</p>
    pub files_transferred: i64,
    /// <p>The number of logical bytes written to the destination Amazon Web Services storage resource.</p>
    pub bytes_written: i64,
    /// <p>The physical number of bytes transferred over the network.</p>
    pub bytes_transferred: i64,
    /// <p>The result of the task execution.</p>
    pub result: std::option::Option<crate::model::TaskExecutionResultDetail>,
}
impl DescribeTaskExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
    /// <p>For example, a <code>TaskExecution</code> value with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code> executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>. </p>
    pub fn task_execution_arn(&self) -> std::option::Option<&str> {
        self.task_execution_arn.as_deref()
    }
    /// <p>The status of the task execution. </p>
    /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide.</i> </p>
    pub fn status(&self) -> std::option::Option<&crate::model::TaskExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
    /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::Options> {
        self.options.as_ref()
    }
    /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
    /// <p> </p>
    pub fn excludes(&self) -> std::option::Option<&[crate::model::FilterRule]> {
        self.excludes.as_deref()
    }
    /// <p>A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
    /// <p> </p>
    pub fn includes(&self) -> std::option::Option<&[crate::model::FilterRule]> {
        self.includes.as_deref()
    }
    /// <p>The time that the task execution was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred. </p>
    pub fn estimated_files_to_transfer(&self) -> i64 {
        self.estimated_files_to_transfer
    }
    /// <p>The estimated physical number of bytes that is to be transferred over the network.</p>
    pub fn estimated_bytes_to_transfer(&self) -> i64 {
        self.estimated_bytes_to_transfer
    }
    /// <p>The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network. </p>
    /// <p>If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.</p>
    pub fn files_transferred(&self) -> i64 {
        self.files_transferred
    }
    /// <p>The number of logical bytes written to the destination Amazon Web Services storage resource.</p>
    pub fn bytes_written(&self) -> i64 {
        self.bytes_written
    }
    /// <p>The physical number of bytes transferred over the network.</p>
    pub fn bytes_transferred(&self) -> i64 {
        self.bytes_transferred
    }
    /// <p>The result of the task execution.</p>
    pub fn result(&self) -> std::option::Option<&crate::model::TaskExecutionResultDetail> {
        self.result.as_ref()
    }
}
impl std::fmt::Debug for DescribeTaskExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskExecutionOutput");
        formatter.field("task_execution_arn", &self.task_execution_arn);
        formatter.field("status", &self.status);
        formatter.field("options", &self.options);
        formatter.field("excludes", &self.excludes);
        formatter.field("includes", &self.includes);
        formatter.field("start_time", &self.start_time);
        formatter.field(
            "estimated_files_to_transfer",
            &self.estimated_files_to_transfer,
        );
        formatter.field(
            "estimated_bytes_to_transfer",
            &self.estimated_bytes_to_transfer,
        );
        formatter.field("files_transferred", &self.files_transferred);
        formatter.field("bytes_written", &self.bytes_written);
        formatter.field("bytes_transferred", &self.bytes_transferred);
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`DescribeTaskExecutionOutput`](crate::output::DescribeTaskExecutionOutput)
pub mod describe_task_execution_output {
    /// A builder for [`DescribeTaskExecutionOutput`](crate::output::DescribeTaskExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_execution_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskExecutionStatus>,
        pub(crate) options: std::option::Option<crate::model::Options>,
        pub(crate) excludes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        pub(crate) includes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) estimated_files_to_transfer: std::option::Option<i64>,
        pub(crate) estimated_bytes_to_transfer: std::option::Option<i64>,
        pub(crate) files_transferred: std::option::Option<i64>,
        pub(crate) bytes_written: std::option::Option<i64>,
        pub(crate) bytes_transferred: std::option::Option<i64>,
        pub(crate) result: std::option::Option<crate::model::TaskExecutionResultDetail>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
        /// <p>For example, a <code>TaskExecution</code> value with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code> executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>. </p>
        pub fn task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution that was described. <code>TaskExecutionArn</code> is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p>
        /// <p>For example, a <code>TaskExecution</code> value with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code> executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>. </p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_execution_arn = input;
            self
        }
        /// <p>The status of the task execution. </p>
        /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide.</i> </p>
        pub fn status(mut self, input: crate::model::TaskExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the task execution. </p>
        /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide.</i> </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn options(mut self, input: crate::model::Options) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
        /// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.options = input;
            self
        }
        /// Appends an item to `excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
        /// <p> </p>
        pub fn excludes(mut self, input: crate::model::FilterRule) -> Self {
            let mut v = self.excludes.unwrap_or_default();
            v.push(input);
            self.excludes = Some(v);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
        /// <p> </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.excludes = input;
            self
        }
        /// Appends an item to `includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
        /// <p> </p>
        pub fn includes(mut self, input: crate::model::FilterRule) -> Self {
            let mut v = self.includes.unwrap_or_default();
            v.push(input);
            self.includes = Some(v);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The list should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: <code>"/folder1|/folder2"</code> </p>
        /// <p> </p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.includes = input;
            self
        }
        /// <p>The time that the task execution was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that the task execution was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred. </p>
        pub fn estimated_files_to_transfer(mut self, input: i64) -> Self {
            self.estimated_files_to_transfer = Some(input);
            self
        }
        /// <p>The expected number of files that is to be transferred over the network. This value is calculated during the PREPARING phase, before the TRANSFERRING phase. This value is the expected number of files to be transferred. It's calculated based on comparing the content of the source and destination locations and finding the delta that needs to be transferred. </p>
        pub fn set_estimated_files_to_transfer(mut self, input: std::option::Option<i64>) -> Self {
            self.estimated_files_to_transfer = input;
            self
        }
        /// <p>The estimated physical number of bytes that is to be transferred over the network.</p>
        pub fn estimated_bytes_to_transfer(mut self, input: i64) -> Self {
            self.estimated_bytes_to_transfer = Some(input);
            self
        }
        /// <p>The estimated physical number of bytes that is to be transferred over the network.</p>
        pub fn set_estimated_bytes_to_transfer(mut self, input: std::option::Option<i64>) -> Self {
            self.estimated_bytes_to_transfer = input;
            self
        }
        /// <p>The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network. </p>
        /// <p>If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.</p>
        pub fn files_transferred(mut self, input: i64) -> Self {
            self.files_transferred = Some(input);
            self
        }
        /// <p>The actual number of files that was transferred over the network. This value is calculated and updated on an ongoing basis during the TRANSFERRING phase. It's updated periodically when each file is read from the source and sent over the network. </p>
        /// <p>If failures occur during a transfer, this value can be less than <code>EstimatedFilesToTransfer</code>. This value can also be greater than <code>EstimatedFilesTransferred</code> in some cases. This element is implementation-specific for some location types, so don't use it as an indicator for a correct file number or to monitor your task execution.</p>
        pub fn set_files_transferred(mut self, input: std::option::Option<i64>) -> Self {
            self.files_transferred = input;
            self
        }
        /// <p>The number of logical bytes written to the destination Amazon Web Services storage resource.</p>
        pub fn bytes_written(mut self, input: i64) -> Self {
            self.bytes_written = Some(input);
            self
        }
        /// <p>The number of logical bytes written to the destination Amazon Web Services storage resource.</p>
        pub fn set_bytes_written(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_written = input;
            self
        }
        /// <p>The physical number of bytes transferred over the network.</p>
        pub fn bytes_transferred(mut self, input: i64) -> Self {
            self.bytes_transferred = Some(input);
            self
        }
        /// <p>The physical number of bytes transferred over the network.</p>
        pub fn set_bytes_transferred(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_transferred = input;
            self
        }
        /// <p>The result of the task execution.</p>
        pub fn result(mut self, input: crate::model::TaskExecutionResultDetail) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The result of the task execution.</p>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::TaskExecutionResultDetail>,
        ) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskExecutionOutput`](crate::output::DescribeTaskExecutionOutput)
        pub fn build(self) -> crate::output::DescribeTaskExecutionOutput {
            crate::output::DescribeTaskExecutionOutput {
                task_execution_arn: self.task_execution_arn,
                status: self.status,
                options: self.options,
                excludes: self.excludes,
                includes: self.includes,
                start_time: self.start_time,
                estimated_files_to_transfer: self.estimated_files_to_transfer.unwrap_or_default(),
                estimated_bytes_to_transfer: self.estimated_bytes_to_transfer.unwrap_or_default(),
                files_transferred: self.files_transferred.unwrap_or_default(),
                bytes_written: self.bytes_written.unwrap_or_default(),
                bytes_transferred: self.bytes_transferred.unwrap_or_default(),
                result: self.result,
            }
        }
    }
}
impl DescribeTaskExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTaskExecutionOutput`](crate::output::DescribeTaskExecutionOutput)
    pub fn builder() -> crate::output::describe_task_execution_output::Builder {
        crate::output::describe_task_execution_output::Builder::default()
    }
}

/// <p>DescribeTaskResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskOutput {
    /// <p>The Amazon Resource Name (ARN) of the task that was described.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The status of the task that was described.</p>
    /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide</i>.</p>
    pub status: std::option::Option<crate::model::TaskStatus>,
    /// <p>The name of the task that was described.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task execution that is syncing files.</p>
    pub current_task_execution_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source file system's location.</p>
    pub source_location_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.</p>
    pub destination_location_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.</p>
    /// <p>For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch User Guide</i>.</p>
    pub cloud_watch_log_group_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.</p>
    pub source_network_interface_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.</p>
    pub destination_network_interface_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.</p>
    /// <p>For each individual task execution, you can override these options by specifying the overriding <code>OverrideOptions</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
    pub options: std::option::Option<crate::model::Options>,
    /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
    /// <p> </p>
    pub excludes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
    /// <p>The schedule used to periodically transfer files from a source to a destination location.</p>
    pub schedule: std::option::Option<crate::model::TaskSchedule>,
    /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
    pub error_detail: std::option::Option<std::string::String>,
    /// <p>The time that the task was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2</code>".</p>
    pub includes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
}
impl DescribeTaskOutput {
    /// <p>The Amazon Resource Name (ARN) of the task that was described.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
    /// <p>The status of the task that was described.</p>
    /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide</i>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TaskStatus> {
        self.status.as_ref()
    }
    /// <p>The name of the task that was described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the task execution that is syncing files.</p>
    pub fn current_task_execution_arn(&self) -> std::option::Option<&str> {
        self.current_task_execution_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source file system's location.</p>
    pub fn source_location_arn(&self) -> std::option::Option<&str> {
        self.source_location_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.</p>
    pub fn destination_location_arn(&self) -> std::option::Option<&str> {
        self.destination_location_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.</p>
    /// <p>For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch User Guide</i>.</p>
    pub fn cloud_watch_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_log_group_arn.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.</p>
    pub fn source_network_interface_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.source_network_interface_arns.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.</p>
    pub fn destination_network_interface_arns(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.destination_network_interface_arns.as_deref()
    }
    /// <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.</p>
    /// <p>For each individual task execution, you can override these options by specifying the overriding <code>OverrideOptions</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
    pub fn options(&self) -> std::option::Option<&crate::model::Options> {
        self.options.as_ref()
    }
    /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
    /// <p> </p>
    pub fn excludes(&self) -> std::option::Option<&[crate::model::FilterRule]> {
        self.excludes.as_deref()
    }
    /// <p>The schedule used to periodically transfer files from a source to a destination location.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::TaskSchedule> {
        self.schedule.as_ref()
    }
    /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
    pub fn error_detail(&self) -> std::option::Option<&str> {
        self.error_detail.as_deref()
    }
    /// <p>The time that the task was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2</code>".</p>
    pub fn includes(&self) -> std::option::Option<&[crate::model::FilterRule]> {
        self.includes.as_deref()
    }
}
impl std::fmt::Debug for DescribeTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskOutput");
        formatter.field("task_arn", &self.task_arn);
        formatter.field("status", &self.status);
        formatter.field("name", &self.name);
        formatter.field(
            "current_task_execution_arn",
            &self.current_task_execution_arn,
        );
        formatter.field("source_location_arn", &self.source_location_arn);
        formatter.field("destination_location_arn", &self.destination_location_arn);
        formatter.field("cloud_watch_log_group_arn", &self.cloud_watch_log_group_arn);
        formatter.field(
            "source_network_interface_arns",
            &self.source_network_interface_arns,
        );
        formatter.field(
            "destination_network_interface_arns",
            &self.destination_network_interface_arns,
        );
        formatter.field("options", &self.options);
        formatter.field("excludes", &self.excludes);
        formatter.field("schedule", &self.schedule);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_detail", &self.error_detail);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("includes", &self.includes);
        formatter.finish()
    }
}
/// See [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
pub mod describe_task_output {
    /// A builder for [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) current_task_execution_arn: std::option::Option<std::string::String>,
        pub(crate) source_location_arn: std::option::Option<std::string::String>,
        pub(crate) destination_location_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) source_network_interface_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destination_network_interface_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) options: std::option::Option<crate::model::Options>,
        pub(crate) excludes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        pub(crate) schedule: std::option::Option<crate::model::TaskSchedule>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_detail: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) includes: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the task that was described.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that was described.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The status of the task that was described.</p>
        /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide</i>.</p>
        pub fn status(mut self, input: crate::model::TaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the task that was described.</p>
        /// <p>For detailed information about task execution statuses, see Understanding Task Statuses in the <i>DataSync User Guide</i>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TaskStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the task that was described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the task that was described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution that is syncing files.</p>
        pub fn current_task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_task_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution that is syncing files.</p>
        pub fn set_current_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_task_execution_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source file system's location.</p>
        pub fn source_location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source file system's location.</p>
        pub fn set_source_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_location_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.</p>
        pub fn destination_location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.</p>
        pub fn set_destination_location_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_location_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.</p>
        /// <p>For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch User Guide</i>.</p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.</p>
        /// <p>For more information on these groups, see Working with Log Groups and Log Streams in the <i>Amazon CloudWatch User Guide</i>.</p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_arn = input;
            self
        }
        /// Appends an item to `source_network_interface_arns`.
        ///
        /// To override the contents of this collection use [`set_source_network_interface_arns`](Self::set_source_network_interface_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.</p>
        pub fn source_network_interface_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.source_network_interface_arns.unwrap_or_default();
            v.push(input.into());
            self.source_network_interface_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the source elastic network interfaces (ENIs) that were created for your subnet.</p>
        pub fn set_source_network_interface_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_network_interface_arns = input;
            self
        }
        /// Appends an item to `destination_network_interface_arns`.
        ///
        /// To override the contents of this collection use [`set_destination_network_interface_arns`](Self::set_destination_network_interface_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.</p>
        pub fn destination_network_interface_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.destination_network_interface_arns.unwrap_or_default();
            v.push(input.into());
            self.destination_network_interface_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the destination elastic network interfaces (ENIs) that were created for your subnet.</p>
        pub fn set_destination_network_interface_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.destination_network_interface_arns = input;
            self
        }
        /// <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.</p>
        /// <p>For each individual task execution, you can override these options by specifying the overriding <code>OverrideOptions</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
        pub fn options(mut self, input: crate::model::Options) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>The set of configuration options that control the behavior of a single execution of the task that occurs when you call <code>StartTaskExecution</code>. You can configure these options to preserve metadata such as user ID (UID) and group (GID), file permissions, data integrity verification, and so on.</p>
        /// <p>For each individual task execution, you can override these options by specifying the overriding <code>OverrideOptions</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. </p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Options>) -> Self {
            self.options = input;
            self
        }
        /// Appends an item to `excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p> </p>
        pub fn excludes(mut self, input: crate::model::FilterRule) -> Self {
            let mut v = self.excludes.unwrap_or_default();
            v.push(input);
            self.excludes = Some(v);
            self
        }
        /// <p>A list of filter rules that determines which files to exclude from a task. The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>
        /// <p> </p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.excludes = input;
            self
        }
        /// <p>The schedule used to periodically transfer files from a source to a destination location.</p>
        pub fn schedule(mut self, input: crate::model::TaskSchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule used to periodically transfer files from a source to a destination location.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::TaskSchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
        pub fn error_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_detail = Some(input.into());
            self
        }
        /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
        pub fn set_error_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_detail = input;
            self
        }
        /// <p>The time that the task was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the task was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Appends an item to `includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2</code>".</p>
        pub fn includes(mut self, input: crate::model::FilterRule) -> Self {
            let mut v = self.includes.unwrap_or_default();
            v.push(input);
            self.includes = Some(v);
            self
        }
        /// <p>A list of filter rules that determines which files to include when running a task. The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2</code>".</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.includes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
        pub fn build(self) -> crate::output::DescribeTaskOutput {
            crate::output::DescribeTaskOutput {
                task_arn: self.task_arn,
                status: self.status,
                name: self.name,
                current_task_execution_arn: self.current_task_execution_arn,
                source_location_arn: self.source_location_arn,
                destination_location_arn: self.destination_location_arn,
                cloud_watch_log_group_arn: self.cloud_watch_log_group_arn,
                source_network_interface_arns: self.source_network_interface_arns,
                destination_network_interface_arns: self.destination_network_interface_arns,
                options: self.options,
                excludes: self.excludes,
                schedule: self.schedule,
                error_code: self.error_code,
                error_detail: self.error_detail,
                creation_time: self.creation_time,
                includes: self.includes,
            }
        }
    }
}
impl DescribeTaskOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
    pub fn builder() -> crate::output::describe_task_output::Builder {
        crate::output::describe_task_output::Builder::default()
    }
}

/// <p>DescribeLocationSmbResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationSmbOutput {
    /// <p>The Amazon Resource Name (ARN) of the SMB location that was described.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the source SMB location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
    pub agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
    pub user: std::option::Option<std::string::String>,
    /// <p>The name of the Windows domain that the SMB server belongs to.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The mount options that are available for DataSync to use to access an SMB location.</p>
    pub mount_options: std::option::Option<crate::model::SmbMountOptions>,
    /// <p>The time that the SMB location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationSmbOutput {
    /// <p>The Amazon Resource Name (ARN) of the SMB location that was described.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URL of the source SMB location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
    pub fn agent_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.agent_arns.as_deref()
    }
    /// <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
    pub fn user(&self) -> std::option::Option<&str> {
        self.user.as_deref()
    }
    /// <p>The name of the Windows domain that the SMB server belongs to.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The mount options that are available for DataSync to use to access an SMB location.</p>
    pub fn mount_options(&self) -> std::option::Option<&crate::model::SmbMountOptions> {
        self.mount_options.as_ref()
    }
    /// <p>The time that the SMB location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationSmbOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationSmbOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("agent_arns", &self.agent_arns);
        formatter.field("user", &self.user);
        formatter.field("domain", &self.domain);
        formatter.field("mount_options", &self.mount_options);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationSmbOutput`](crate::output::DescribeLocationSmbOutput)
pub mod describe_location_smb_output {
    /// A builder for [`DescribeLocationSmbOutput`](crate::output::DescribeLocationSmbOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) mount_options: std::option::Option<crate::model::SmbMountOptions>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SMB location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SMB location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URL of the source SMB location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URL of the source SMB location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Appends an item to `agent_arns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.agent_arns.unwrap_or_default();
            v.push(input.into());
            self.agent_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.agent_arns = input;
            self
        }
        /// <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.user = Some(input.into());
            self
        }
        /// <p>The user who can mount the share, has the permissions to access files and folders in the SMB share.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user = input;
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the Windows domain that the SMB server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The mount options that are available for DataSync to use to access an SMB location.</p>
        pub fn mount_options(mut self, input: crate::model::SmbMountOptions) -> Self {
            self.mount_options = Some(input);
            self
        }
        /// <p>The mount options that are available for DataSync to use to access an SMB location.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::SmbMountOptions>,
        ) -> Self {
            self.mount_options = input;
            self
        }
        /// <p>The time that the SMB location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the SMB location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationSmbOutput`](crate::output::DescribeLocationSmbOutput)
        pub fn build(self) -> crate::output::DescribeLocationSmbOutput {
            crate::output::DescribeLocationSmbOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                agent_arns: self.agent_arns,
                user: self.user,
                domain: self.domain,
                mount_options: self.mount_options,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationSmbOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationSmbOutput`](crate::output::DescribeLocationSmbOutput)
    pub fn builder() -> crate::output::describe_location_smb_output::Builder {
        crate::output::describe_location_smb_output::Builder::default()
    }
}

/// <p>DescribeLocationS3Response</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationS3Output {
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the Amazon S3 location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
    pub s3_storage_class: std::option::Option<crate::model::S3StorageClass>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.</p>
    /// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
    pub s3_config: std::option::Option<crate::model::S3Config>,
    /// <p>If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
    pub agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the Amazon S3 bucket location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationS3Output {
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URL of the Amazon S3 location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
    pub fn s3_storage_class(&self) -> std::option::Option<&crate::model::S3StorageClass> {
        self.s3_storage_class.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.</p>
    /// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
    pub fn s3_config(&self) -> std::option::Option<&crate::model::S3Config> {
        self.s3_config.as_ref()
    }
    /// <p>If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
    pub fn agent_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.agent_arns.as_deref()
    }
    /// <p>The time that the Amazon S3 bucket location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationS3Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationS3Output");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("s3_storage_class", &self.s3_storage_class);
        formatter.field("s3_config", &self.s3_config);
        formatter.field("agent_arns", &self.agent_arns);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationS3Output`](crate::output::DescribeLocationS3Output)
pub mod describe_location_s3_output {
    /// A builder for [`DescribeLocationS3Output`](crate::output::DescribeLocationS3Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) s3_storage_class: std::option::Option<crate::model::S3StorageClass>,
        pub(crate) s3_config: std::option::Option<crate::model::S3Config>,
        pub(crate) agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URL of the Amazon S3 location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URL of the Amazon S3 location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
        pub fn s3_storage_class(mut self, input: crate::model::S3StorageClass) -> Self {
            self.s3_storage_class = Some(input);
            self
        }
        /// <p>The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see <a href="http://aws.amazon.com/s3/storage-classes/">Amazon S3 Storage Classes</a>. Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with S3 storage classes in DataSync</a>.</p>
        pub fn set_s3_storage_class(
            mut self,
            input: std::option::Option<crate::model::S3StorageClass>,
        ) -> Self {
            self.s3_storage_class = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.</p>
        /// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
        pub fn s3_config(mut self, input: crate::model::S3Config) -> Self {
            self.s3_config = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.</p>
        /// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
        pub fn set_s3_config(mut self, input: std::option::Option<crate::model::S3Config>) -> Self {
            self.s3_config = input;
            self
        }
        /// Appends an item to `agent_arns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.agent_arns.unwrap_or_default();
            v.push(input.into());
            self.agent_arns = Some(v);
            self
        }
        /// <p>If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.agent_arns = input;
            self
        }
        /// <p>The time that the Amazon S3 bucket location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the Amazon S3 bucket location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationS3Output`](crate::output::DescribeLocationS3Output)
        pub fn build(self) -> crate::output::DescribeLocationS3Output {
            crate::output::DescribeLocationS3Output {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                s3_storage_class: self.s3_storage_class,
                s3_config: self.s3_config,
                agent_arns: self.agent_arns,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationS3Output {
    /// Creates a new builder-style object to manufacture [`DescribeLocationS3Output`](crate::output::DescribeLocationS3Output)
    pub fn builder() -> crate::output::describe_location_s3_output::Builder {
        crate::output::describe_location_s3_output::Builder::default()
    }
}

/// <p>DescribeLocationObjectStorageResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationObjectStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to describe.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the source self-managed object storage server location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    pub access_key: std::option::Option<std::string::String>,
    /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS).</p>
    pub server_port: std::option::Option<i32>,
    /// <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
    pub server_protocol: std::option::Option<crate::model::ObjectStorageServerProtocol>,
    /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    pub agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the self-managed object storage server agent was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationObjectStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to describe.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URL of the source self-managed object storage server location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
    pub fn access_key(&self) -> std::option::Option<&str> {
        self.access_key.as_deref()
    }
    /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS).</p>
    pub fn server_port(&self) -> std::option::Option<i32> {
        self.server_port
    }
    /// <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
    pub fn server_protocol(
        &self,
    ) -> std::option::Option<&crate::model::ObjectStorageServerProtocol> {
        self.server_protocol.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    pub fn agent_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.agent_arns.as_deref()
    }
    /// <p>The time that the self-managed object storage server agent was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationObjectStorageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationObjectStorageOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("access_key", &self.access_key);
        formatter.field("server_port", &self.server_port);
        formatter.field("server_protocol", &self.server_protocol);
        formatter.field("agent_arns", &self.agent_arns);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationObjectStorageOutput`](crate::output::DescribeLocationObjectStorageOutput)
pub mod describe_location_object_storage_output {
    /// A builder for [`DescribeLocationObjectStorageOutput`](crate::output::DescribeLocationObjectStorageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) access_key: std::option::Option<std::string::String>,
        pub(crate) server_port: std::option::Option<i32>,
        pub(crate) server_protocol: std::option::Option<crate::model::ObjectStorageServerProtocol>,
        pub(crate) agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to describe.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the self-managed object storage server location to describe.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URL of the source self-managed object storage server location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URL of the source self-managed object storage server location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key = Some(input.into());
            self
        }
        /// <p>Optional. The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use <code>AccessKey</code> and <code>SecretKey</code> to provide the user name and password, respectively.</p>
        pub fn set_access_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_key = input;
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS).</p>
        pub fn server_port(mut self, input: i32) -> Self {
            self.server_port = Some(input);
            self
        }
        /// <p>The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443 (HTTPS).</p>
        pub fn set_server_port(mut self, input: std::option::Option<i32>) -> Self {
            self.server_port = input;
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
        pub fn server_protocol(mut self, input: crate::model::ObjectStorageServerProtocol) -> Self {
            self.server_protocol = Some(input);
            self
        }
        /// <p>The protocol that the object storage server uses to communicate. Valid values are HTTP or HTTPS.</p>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::ObjectStorageServerProtocol>,
        ) -> Self {
            self.server_protocol = input;
            self
        }
        /// Appends an item to `agent_arns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.agent_arns.unwrap_or_default();
            v.push(input.into());
            self.agent_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.agent_arns = input;
            self
        }
        /// <p>The time that the self-managed object storage server agent was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the self-managed object storage server agent was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationObjectStorageOutput`](crate::output::DescribeLocationObjectStorageOutput)
        pub fn build(self) -> crate::output::DescribeLocationObjectStorageOutput {
            crate::output::DescribeLocationObjectStorageOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                access_key: self.access_key,
                server_port: self.server_port,
                server_protocol: self.server_protocol,
                agent_arns: self.agent_arns,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationObjectStorageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationObjectStorageOutput`](crate::output::DescribeLocationObjectStorageOutput)
    pub fn builder() -> crate::output::describe_location_object_storage_output::Builder {
        crate::output::describe_location_object_storage_output::Builder::default()
    }
}

/// <p>DescribeLocationNfsResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationNfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the NFS location that was described.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the source NFS location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
    pub on_prem_config: std::option::Option<crate::model::OnPremConfig>,
    /// <p>The NFS mount options that DataSync used to mount your NFS share.</p>
    pub mount_options: std::option::Option<crate::model::NfsMountOptions>,
    /// <p>The time that the NFS location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationNfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the NFS location that was described.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URL of the source NFS location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
    pub fn on_prem_config(&self) -> std::option::Option<&crate::model::OnPremConfig> {
        self.on_prem_config.as_ref()
    }
    /// <p>The NFS mount options that DataSync used to mount your NFS share.</p>
    pub fn mount_options(&self) -> std::option::Option<&crate::model::NfsMountOptions> {
        self.mount_options.as_ref()
    }
    /// <p>The time that the NFS location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationNfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationNfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("on_prem_config", &self.on_prem_config);
        formatter.field("mount_options", &self.mount_options);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationNfsOutput`](crate::output::DescribeLocationNfsOutput)
pub mod describe_location_nfs_output {
    /// A builder for [`DescribeLocationNfsOutput`](crate::output::DescribeLocationNfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) on_prem_config: std::option::Option<crate::model::OnPremConfig>,
        pub(crate) mount_options: std::option::Option<crate::model::NfsMountOptions>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the NFS location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the NFS location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URL of the source NFS location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URL of the source NFS location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
        pub fn on_prem_config(mut self, input: crate::model::OnPremConfig) -> Self {
            self.on_prem_config = Some(input);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
        pub fn set_on_prem_config(
            mut self,
            input: std::option::Option<crate::model::OnPremConfig>,
        ) -> Self {
            self.on_prem_config = input;
            self
        }
        /// <p>The NFS mount options that DataSync used to mount your NFS share.</p>
        pub fn mount_options(mut self, input: crate::model::NfsMountOptions) -> Self {
            self.mount_options = Some(input);
            self
        }
        /// <p>The NFS mount options that DataSync used to mount your NFS share.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::NfsMountOptions>,
        ) -> Self {
            self.mount_options = input;
            self
        }
        /// <p>The time that the NFS location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the NFS location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationNfsOutput`](crate::output::DescribeLocationNfsOutput)
        pub fn build(self) -> crate::output::DescribeLocationNfsOutput {
            crate::output::DescribeLocationNfsOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                on_prem_config: self.on_prem_config,
                mount_options: self.mount_options,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationNfsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationNfsOutput`](crate::output::DescribeLocationNfsOutput)
    pub fn builder() -> crate::output::describe_location_nfs_output::Builder {
        crate::output::describe_location_nfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationHdfsOutput {
    /// <p>The ARN of the HDFS cluster location.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URI of the HDFS cluster location.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The NameNode that manage the HDFS namespace. </p>
    pub name_nodes: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
    /// <p>The size of the data blocks to write into the HDFS cluster. </p>
    pub block_size: std::option::Option<i32>,
    /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
    pub replication_factor: std::option::Option<i32>,
    /// <p> The URI of the HDFS cluster's Key Management Server (KMS). </p>
    pub kms_key_provider_uri: std::option::Option<std::string::String>,
    /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
    pub qop_configuration: std::option::Option<crate::model::QopConfiguration>,
    /// <p>The type of authentication used to determine the identity of the user. </p>
    pub authentication_type: std::option::Option<crate::model::HdfsAuthenticationType>,
    /// <p>The user name used to identify the client on the host operating system. This parameter is used if the <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.</p>
    pub simple_user: std::option::Option<std::string::String>,
    /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.</p>
    pub kerberos_principal: std::option::Option<std::string::String>,
    /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
    pub agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the HDFS location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationHdfsOutput {
    /// <p>The ARN of the HDFS cluster location.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URI of the HDFS cluster location.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The NameNode that manage the HDFS namespace. </p>
    pub fn name_nodes(&self) -> std::option::Option<&[crate::model::HdfsNameNode]> {
        self.name_nodes.as_deref()
    }
    /// <p>The size of the data blocks to write into the HDFS cluster. </p>
    pub fn block_size(&self) -> std::option::Option<i32> {
        self.block_size
    }
    /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
    pub fn replication_factor(&self) -> std::option::Option<i32> {
        self.replication_factor
    }
    /// <p> The URI of the HDFS cluster's Key Management Server (KMS). </p>
    pub fn kms_key_provider_uri(&self) -> std::option::Option<&str> {
        self.kms_key_provider_uri.as_deref()
    }
    /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
    pub fn qop_configuration(&self) -> std::option::Option<&crate::model::QopConfiguration> {
        self.qop_configuration.as_ref()
    }
    /// <p>The type of authentication used to determine the identity of the user. </p>
    pub fn authentication_type(
        &self,
    ) -> std::option::Option<&crate::model::HdfsAuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The user name used to identify the client on the host operating system. This parameter is used if the <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.</p>
    pub fn simple_user(&self) -> std::option::Option<&str> {
        self.simple_user.as_deref()
    }
    /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.</p>
    pub fn kerberos_principal(&self) -> std::option::Option<&str> {
        self.kerberos_principal.as_deref()
    }
    /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
    pub fn agent_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.agent_arns.as_deref()
    }
    /// <p>The time that the HDFS location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationHdfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationHdfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("name_nodes", &self.name_nodes);
        formatter.field("block_size", &self.block_size);
        formatter.field("replication_factor", &self.replication_factor);
        formatter.field("kms_key_provider_uri", &self.kms_key_provider_uri);
        formatter.field("qop_configuration", &self.qop_configuration);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("simple_user", &self.simple_user);
        formatter.field("kerberos_principal", &self.kerberos_principal);
        formatter.field("agent_arns", &self.agent_arns);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationHdfsOutput`](crate::output::DescribeLocationHdfsOutput)
pub mod describe_location_hdfs_output {
    /// A builder for [`DescribeLocationHdfsOutput`](crate::output::DescribeLocationHdfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) name_nodes: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
        pub(crate) block_size: std::option::Option<i32>,
        pub(crate) replication_factor: std::option::Option<i32>,
        pub(crate) kms_key_provider_uri: std::option::Option<std::string::String>,
        pub(crate) qop_configuration: std::option::Option<crate::model::QopConfiguration>,
        pub(crate) authentication_type: std::option::Option<crate::model::HdfsAuthenticationType>,
        pub(crate) simple_user: std::option::Option<std::string::String>,
        pub(crate) kerberos_principal: std::option::Option<std::string::String>,
        pub(crate) agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the HDFS cluster location.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HDFS cluster location.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URI of the HDFS cluster location.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URI of the HDFS cluster location.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Appends an item to `name_nodes`.
        ///
        /// To override the contents of this collection use [`set_name_nodes`](Self::set_name_nodes).
        ///
        /// <p>The NameNode that manage the HDFS namespace. </p>
        pub fn name_nodes(mut self, input: crate::model::HdfsNameNode) -> Self {
            let mut v = self.name_nodes.unwrap_or_default();
            v.push(input);
            self.name_nodes = Some(v);
            self
        }
        /// <p>The NameNode that manage the HDFS namespace. </p>
        pub fn set_name_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HdfsNameNode>>,
        ) -> Self {
            self.name_nodes = input;
            self
        }
        /// <p>The size of the data blocks to write into the HDFS cluster. </p>
        pub fn block_size(mut self, input: i32) -> Self {
            self.block_size = Some(input);
            self
        }
        /// <p>The size of the data blocks to write into the HDFS cluster. </p>
        pub fn set_block_size(mut self, input: std::option::Option<i32>) -> Self {
            self.block_size = input;
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
        pub fn replication_factor(mut self, input: i32) -> Self {
            self.replication_factor = Some(input);
            self
        }
        /// <p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>
        pub fn set_replication_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.replication_factor = input;
            self
        }
        /// <p> The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn kms_key_provider_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_provider_uri = Some(input.into());
            self
        }
        /// <p> The URI of the HDFS cluster's Key Management Server (KMS). </p>
        pub fn set_kms_key_provider_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_key_provider_uri = input;
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
        pub fn qop_configuration(mut self, input: crate::model::QopConfiguration) -> Self {
            self.qop_configuration = Some(input);
            self
        }
        /// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>
        pub fn set_qop_configuration(
            mut self,
            input: std::option::Option<crate::model::QopConfiguration>,
        ) -> Self {
            self.qop_configuration = input;
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn authentication_type(mut self, input: crate::model::HdfsAuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The type of authentication used to determine the identity of the user. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::HdfsAuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The user name used to identify the client on the host operating system. This parameter is used if the <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.</p>
        pub fn simple_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.simple_user = Some(input.into());
            self
        }
        /// <p>The user name used to identify the client on the host operating system. This parameter is used if the <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.</p>
        pub fn set_simple_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.simple_user = input;
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.</p>
        pub fn kerberos_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.kerberos_principal = Some(input.into());
            self
        }
        /// <p>The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.</p>
        pub fn set_kerberos_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kerberos_principal = input;
            self
        }
        /// Appends an item to `agent_arns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.agent_arns.unwrap_or_default();
            v.push(input.into());
            self.agent_arns = Some(v);
            self
        }
        /// <p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.agent_arns = input;
            self
        }
        /// <p>The time that the HDFS location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the HDFS location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationHdfsOutput`](crate::output::DescribeLocationHdfsOutput)
        pub fn build(self) -> crate::output::DescribeLocationHdfsOutput {
            crate::output::DescribeLocationHdfsOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                name_nodes: self.name_nodes,
                block_size: self.block_size,
                replication_factor: self.replication_factor,
                kms_key_provider_uri: self.kms_key_provider_uri,
                qop_configuration: self.qop_configuration,
                authentication_type: self.authentication_type,
                simple_user: self.simple_user,
                kerberos_principal: self.kerberos_principal,
                agent_arns: self.agent_arns,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationHdfsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationHdfsOutput`](crate::output::DescribeLocationHdfsOutput)
    pub fn builder() -> crate::output::describe_location_hdfs_output::Builder {
        crate::output::describe_location_hdfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationFsxWindowsOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location that was described.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the FSx for Windows File Server location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows File Server file system.</p>
    pub security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the FSx for Windows File Server location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
    pub user: std::option::Option<std::string::String>,
    /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl DescribeLocationFsxWindowsOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location that was described.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URL of the FSx for Windows File Server location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows File Server file system.</p>
    pub fn security_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_arns.as_deref()
    }
    /// <p>The time that the FSx for Windows File Server location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
    pub fn user(&self) -> std::option::Option<&str> {
        self.user.as_deref()
    }
    /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl std::fmt::Debug for DescribeLocationFsxWindowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationFsxWindowsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("security_group_arns", &self.security_group_arns);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("user", &self.user);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DescribeLocationFsxWindowsOutput`](crate::output::DescribeLocationFsxWindowsOutput)
pub mod describe_location_fsx_windows_output {
    /// A builder for [`DescribeLocationFsxWindowsOutput`](crate::output::DescribeLocationFsxWindowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) user: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URL of the FSx for Windows File Server location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URL of the FSx for Windows File Server location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Appends an item to `security_group_arns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows File Server file system.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_arns.unwrap_or_default();
            v.push(input.into());
            self.security_group_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Windows File Server file system.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_arns = input;
            self
        }
        /// <p>The time that the FSx for Windows File Server location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the FSx for Windows File Server location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.user = Some(input.into());
            self
        }
        /// <p>The user who has the permissions to access files and folders in the FSx for Windows File Server file system.</p>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user = input;
            self
        }
        /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the Windows domain that the FSx for Windows File Server belongs to.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationFsxWindowsOutput`](crate::output::DescribeLocationFsxWindowsOutput)
        pub fn build(self) -> crate::output::DescribeLocationFsxWindowsOutput {
            crate::output::DescribeLocationFsxWindowsOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                security_group_arns: self.security_group_arns,
                creation_time: self.creation_time,
                user: self.user,
                domain: self.domain,
            }
        }
    }
}
impl DescribeLocationFsxWindowsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationFsxWindowsOutput`](crate::output::DescribeLocationFsxWindowsOutput)
    pub fn builder() -> crate::output::describe_location_fsx_windows_output::Builder {
        crate::output::describe_location_fsx_windows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationFsxOpenZfsOutput {
    /// <p>The ARN of the FSx for OpenZFS location that was described.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The uniform resource identifier (URI) of the FSx for OpenZFS location that was described.</p>
    /// <p>Example: <code>fsxz://us-west-2.fs-1234567890abcdef02/fsx/folderA/folder</code> </p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The ARNs of the security groups that are configured for the FSx for OpenZFS file system.</p>
    pub security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of protocol that DataSync uses to access your file system.</p>
    pub protocol: std::option::Option<crate::model::FsxProtocol>,
    /// <p>The time that the FSx for OpenZFS location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationFsxOpenZfsOutput {
    /// <p>The ARN of the FSx for OpenZFS location that was described.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The uniform resource identifier (URI) of the FSx for OpenZFS location that was described.</p>
    /// <p>Example: <code>fsxz://us-west-2.fs-1234567890abcdef02/fsx/folderA/folder</code> </p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The ARNs of the security groups that are configured for the FSx for OpenZFS file system.</p>
    pub fn security_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_arns.as_deref()
    }
    /// <p>The type of protocol that DataSync uses to access your file system.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::FsxProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The time that the FSx for OpenZFS location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationFsxOpenZfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationFsxOpenZfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("security_group_arns", &self.security_group_arns);
        formatter.field("protocol", &self.protocol);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationFsxOpenZfsOutput`](crate::output::DescribeLocationFsxOpenZfsOutput)
pub mod describe_location_fsx_open_zfs_output {
    /// A builder for [`DescribeLocationFsxOpenZfsOutput`](crate::output::DescribeLocationFsxOpenZfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) protocol: std::option::Option<crate::model::FsxProtocol>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the FSx for OpenZFS location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the FSx for OpenZFS location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The uniform resource identifier (URI) of the FSx for OpenZFS location that was described.</p>
        /// <p>Example: <code>fsxz://us-west-2.fs-1234567890abcdef02/fsx/folderA/folder</code> </p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The uniform resource identifier (URI) of the FSx for OpenZFS location that was described.</p>
        /// <p>Example: <code>fsxz://us-west-2.fs-1234567890abcdef02/fsx/folderA/folder</code> </p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Appends an item to `security_group_arns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The ARNs of the security groups that are configured for the FSx for OpenZFS file system.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_arns.unwrap_or_default();
            v.push(input.into());
            self.security_group_arns = Some(v);
            self
        }
        /// <p>The ARNs of the security groups that are configured for the FSx for OpenZFS file system.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_arns = input;
            self
        }
        /// <p>The type of protocol that DataSync uses to access your file system.</p>
        pub fn protocol(mut self, input: crate::model::FsxProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The type of protocol that DataSync uses to access your file system.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::FsxProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The time that the FSx for OpenZFS location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the FSx for OpenZFS location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationFsxOpenZfsOutput`](crate::output::DescribeLocationFsxOpenZfsOutput)
        pub fn build(self) -> crate::output::DescribeLocationFsxOpenZfsOutput {
            crate::output::DescribeLocationFsxOpenZfsOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                security_group_arns: self.security_group_arns,
                protocol: self.protocol,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationFsxOpenZfsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationFsxOpenZfsOutput`](crate::output::DescribeLocationFsxOpenZfsOutput)
    pub fn builder() -> crate::output::describe_location_fsx_open_zfs_output::Builder {
        crate::output::describe_location_fsx_open_zfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationFsxLustreOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URI of the FSx for Lustre location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Lustre file system.</p>
    pub security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the FSx for Lustre location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationFsxLustreOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URI of the FSx for Lustre location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Lustre file system.</p>
    pub fn security_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_arns.as_deref()
    }
    /// <p>The time that the FSx for Lustre location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationFsxLustreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationFsxLustreOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("security_group_arns", &self.security_group_arns);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationFsxLustreOutput`](crate::output::DescribeLocationFsxLustreOutput)
pub mod describe_location_fsx_lustre_output {
    /// A builder for [`DescribeLocationFsxLustreOutput`](crate::output::DescribeLocationFsxLustreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URI of the FSx for Lustre location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URI of the FSx for Lustre location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Appends an item to `security_group_arns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Lustre file system.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_arns.unwrap_or_default();
            v.push(input.into());
            self.security_group_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Lustre file system.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_arns = input;
            self
        }
        /// <p>The time that the FSx for Lustre location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the FSx for Lustre location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationFsxLustreOutput`](crate::output::DescribeLocationFsxLustreOutput)
        pub fn build(self) -> crate::output::DescribeLocationFsxLustreOutput {
            crate::output::DescribeLocationFsxLustreOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                security_group_arns: self.security_group_arns,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationFsxLustreOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationFsxLustreOutput`](crate::output::DescribeLocationFsxLustreOutput)
    pub fn builder() -> crate::output::describe_location_fsx_lustre_output::Builder {
        crate::output::describe_location_fsx_lustre_output::Builder::default()
    }
}

/// <p>DescribeLocationEfsResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLocationEfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the EFS location that was described.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the EFS location that was described.</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>The subnet that DataSync uses to access target EFS file system. The subnet must have at least one mount target for that file system. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. </p>
    pub ec2_config: std::option::Option<crate::model::Ec2Config>,
    /// <p>The time that the EFS location was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeLocationEfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the EFS location that was described.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>The URL of the EFS location that was described.</p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
    /// <p>The subnet that DataSync uses to access target EFS file system. The subnet must have at least one mount target for that file system. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. </p>
    pub fn ec2_config(&self) -> std::option::Option<&crate::model::Ec2Config> {
        self.ec2_config.as_ref()
    }
    /// <p>The time that the EFS location was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeLocationEfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLocationEfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("ec2_config", &self.ec2_config);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeLocationEfsOutput`](crate::output::DescribeLocationEfsOutput)
pub mod describe_location_efs_output {
    /// A builder for [`DescribeLocationEfsOutput`](crate::output::DescribeLocationEfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) ec2_config: std::option::Option<crate::model::Ec2Config>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the EFS location that was described.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the EFS location that was described.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>The URL of the EFS location that was described.</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The URL of the EFS location that was described.</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// <p>The subnet that DataSync uses to access target EFS file system. The subnet must have at least one mount target for that file system. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. </p>
        pub fn ec2_config(mut self, input: crate::model::Ec2Config) -> Self {
            self.ec2_config = Some(input);
            self
        }
        /// <p>The subnet that DataSync uses to access target EFS file system. The subnet must have at least one mount target for that file system. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. </p>
        pub fn set_ec2_config(
            mut self,
            input: std::option::Option<crate::model::Ec2Config>,
        ) -> Self {
            self.ec2_config = input;
            self
        }
        /// <p>The time that the EFS location was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the EFS location was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLocationEfsOutput`](crate::output::DescribeLocationEfsOutput)
        pub fn build(self) -> crate::output::DescribeLocationEfsOutput {
            crate::output::DescribeLocationEfsOutput {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
                ec2_config: self.ec2_config,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeLocationEfsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLocationEfsOutput`](crate::output::DescribeLocationEfsOutput)
    pub fn builder() -> crate::output::describe_location_efs_output::Builder {
        crate::output::describe_location_efs_output::Builder::default()
    }
}

/// <p>DescribeAgentResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAgentOutput {
    /// <p>The Amazon Resource Name (ARN) of the agent.</p>
    pub agent_arn: std::option::Option<std::string::String>,
    /// <p>The name of the agent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent returns to ONLINE status.</p>
    pub status: std::option::Option<crate::model::AgentStatus>,
    /// <p>The time that the agent last connected to DataSync.</p>
    pub last_connection_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the agent was activated (that is, created in your account).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not accessible over the public internet. </p>
    pub endpoint_type: std::option::Option<crate::model::EndpointType>,
    /// <p>The subnet and the security group that DataSync used to access a VPC endpoint.</p>
    pub private_link_config: std::option::Option<crate::model::PrivateLinkConfig>,
}
impl DescribeAgentOutput {
    /// <p>The Amazon Resource Name (ARN) of the agent.</p>
    pub fn agent_arn(&self) -> std::option::Option<&str> {
        self.agent_arn.as_deref()
    }
    /// <p>The name of the agent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent returns to ONLINE status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AgentStatus> {
        self.status.as_ref()
    }
    /// <p>The time that the agent last connected to DataSync.</p>
    pub fn last_connection_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_connection_time.as_ref()
    }
    /// <p>The time that the agent was activated (that is, created in your account).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not accessible over the public internet. </p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::EndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The subnet and the security group that DataSync used to access a VPC endpoint.</p>
    pub fn private_link_config(&self) -> std::option::Option<&crate::model::PrivateLinkConfig> {
        self.private_link_config.as_ref()
    }
}
impl std::fmt::Debug for DescribeAgentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAgentOutput");
        formatter.field("agent_arn", &self.agent_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("last_connection_time", &self.last_connection_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("private_link_config", &self.private_link_config);
        formatter.finish()
    }
}
/// See [`DescribeAgentOutput`](crate::output::DescribeAgentOutput)
pub mod describe_agent_output {
    /// A builder for [`DescribeAgentOutput`](crate::output::DescribeAgentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AgentStatus>,
        pub(crate) last_connection_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) endpoint_type: std::option::Option<crate::model::EndpointType>,
        pub(crate) private_link_config: std::option::Option<crate::model::PrivateLinkConfig>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the agent.</p>
        pub fn agent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_arn = input;
            self
        }
        /// <p>The name of the agent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the agent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent returns to ONLINE status.</p>
        pub fn status(mut self, input: crate::model::AgentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the agent. If the status is ONLINE, then the agent is configured properly and is available to use. The Running status is the normal running status for an agent. If the status is OFFLINE, the agent's VM is turned off or the agent is in an unhealthy state. When the issue that caused the unhealthy state is resolved, the agent returns to ONLINE status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AgentStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time that the agent last connected to DataSync.</p>
        pub fn last_connection_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_connection_time = Some(input);
            self
        }
        /// <p>The time that the agent last connected to DataSync.</p>
        pub fn set_last_connection_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_connection_time = input;
            self
        }
        /// <p>The time that the agent was activated (that is, created in your account).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the agent was activated (that is, created in your account).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not accessible over the public internet. </p>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint that your agent is connected to. If the endpoint is a VPC endpoint, the agent is not accessible over the public internet. </p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The subnet and the security group that DataSync used to access a VPC endpoint.</p>
        pub fn private_link_config(mut self, input: crate::model::PrivateLinkConfig) -> Self {
            self.private_link_config = Some(input);
            self
        }
        /// <p>The subnet and the security group that DataSync used to access a VPC endpoint.</p>
        pub fn set_private_link_config(
            mut self,
            input: std::option::Option<crate::model::PrivateLinkConfig>,
        ) -> Self {
            self.private_link_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAgentOutput`](crate::output::DescribeAgentOutput)
        pub fn build(self) -> crate::output::DescribeAgentOutput {
            crate::output::DescribeAgentOutput {
                agent_arn: self.agent_arn,
                name: self.name,
                status: self.status,
                last_connection_time: self.last_connection_time,
                creation_time: self.creation_time,
                endpoint_type: self.endpoint_type,
                private_link_config: self.private_link_config,
            }
        }
    }
}
impl DescribeAgentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAgentOutput`](crate::output::DescribeAgentOutput)
    pub fn builder() -> crate::output::describe_agent_output::Builder {
        crate::output::describe_agent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTaskOutput {}
impl std::fmt::Debug for DeleteTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTaskOutput");
        formatter.finish()
    }
}
/// See [`DeleteTaskOutput`](crate::output::DeleteTaskOutput)
pub mod delete_task_output {
    /// A builder for [`DeleteTaskOutput`](crate::output::DeleteTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTaskOutput`](crate::output::DeleteTaskOutput)
        pub fn build(self) -> crate::output::DeleteTaskOutput {
            crate::output::DeleteTaskOutput {}
        }
    }
}
impl DeleteTaskOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTaskOutput`](crate::output::DeleteTaskOutput)
    pub fn builder() -> crate::output::delete_task_output::Builder {
        crate::output::delete_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLocationOutput {}
impl std::fmt::Debug for DeleteLocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLocationOutput");
        formatter.finish()
    }
}
/// See [`DeleteLocationOutput`](crate::output::DeleteLocationOutput)
pub mod delete_location_output {
    /// A builder for [`DeleteLocationOutput`](crate::output::DeleteLocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLocationOutput`](crate::output::DeleteLocationOutput)
        pub fn build(self) -> crate::output::DeleteLocationOutput {
            crate::output::DeleteLocationOutput {}
        }
    }
}
impl DeleteLocationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLocationOutput`](crate::output::DeleteLocationOutput)
    pub fn builder() -> crate::output::delete_location_output::Builder {
        crate::output::delete_location_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAgentOutput {}
impl std::fmt::Debug for DeleteAgentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAgentOutput");
        formatter.finish()
    }
}
/// See [`DeleteAgentOutput`](crate::output::DeleteAgentOutput)
pub mod delete_agent_output {
    /// A builder for [`DeleteAgentOutput`](crate::output::DeleteAgentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAgentOutput`](crate::output::DeleteAgentOutput)
        pub fn build(self) -> crate::output::DeleteAgentOutput {
            crate::output::DeleteAgentOutput {}
        }
    }
}
impl DeleteAgentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAgentOutput`](crate::output::DeleteAgentOutput)
    pub fn builder() -> crate::output::delete_agent_output::Builder {
        crate::output::delete_agent_output::Builder::default()
    }
}

/// <p>CreateTaskResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTaskOutput {
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
}
impl CreateTaskOutput {
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTaskOutput");
        formatter.field("task_arn", &self.task_arn);
        formatter.finish()
    }
}
/// See [`CreateTaskOutput`](crate::output::CreateTaskOutput)
pub mod create_task_output {
    /// A builder for [`CreateTaskOutput`](crate::output::CreateTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTaskOutput`](crate::output::CreateTaskOutput)
        pub fn build(self) -> crate::output::CreateTaskOutput {
            crate::output::CreateTaskOutput {
                task_arn: self.task_arn,
            }
        }
    }
}
impl CreateTaskOutput {
    /// Creates a new builder-style object to manufacture [`CreateTaskOutput`](crate::output::CreateTaskOutput)
    pub fn builder() -> crate::output::create_task_output::Builder {
        crate::output::create_task_output::Builder::default()
    }
}

/// <p>CreateLocationSmbResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationSmbOutput {
    /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationSmbOutput {
    /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationSmbOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationSmbOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationSmbOutput`](crate::output::CreateLocationSmbOutput)
pub mod create_location_smb_output {
    /// A builder for [`CreateLocationSmbOutput`](crate::output::CreateLocationSmbOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source SMB file system location that is created.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationSmbOutput`](crate::output::CreateLocationSmbOutput)
        pub fn build(self) -> crate::output::CreateLocationSmbOutput {
            crate::output::CreateLocationSmbOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationSmbOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationSmbOutput`](crate::output::CreateLocationSmbOutput)
    pub fn builder() -> crate::output::create_location_smb_output::Builder {
        crate::output::create_location_smb_output::Builder::default()
    }
}

/// <p>CreateLocationS3Response</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationS3Output {
    /// <p>The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that is created.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationS3Output {
    /// <p>The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that is created.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationS3Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationS3Output");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationS3Output`](crate::output::CreateLocationS3Output)
pub mod create_location_s3_output {
    /// A builder for [`CreateLocationS3Output`](crate::output::CreateLocationS3Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that is created.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that is created.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationS3Output`](crate::output::CreateLocationS3Output)
        pub fn build(self) -> crate::output::CreateLocationS3Output {
            crate::output::CreateLocationS3Output {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationS3Output {
    /// Creates a new builder-style object to manufacture [`CreateLocationS3Output`](crate::output::CreateLocationS3Output)
    pub fn builder() -> crate::output::create_location_s3_output::Builder {
        crate::output::create_location_s3_output::Builder::default()
    }
}

/// <p>CreateLocationObjectStorageResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationObjectStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationObjectStorageOutput {
    /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationObjectStorageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationObjectStorageOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationObjectStorageOutput`](crate::output::CreateLocationObjectStorageOutput)
pub mod create_location_object_storage_output {
    /// A builder for [`CreateLocationObjectStorageOutput`](crate::output::CreateLocationObjectStorageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agents associated with the self-managed object storage server location.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationObjectStorageOutput`](crate::output::CreateLocationObjectStorageOutput)
        pub fn build(self) -> crate::output::CreateLocationObjectStorageOutput {
            crate::output::CreateLocationObjectStorageOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationObjectStorageOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationObjectStorageOutput`](crate::output::CreateLocationObjectStorageOutput)
    pub fn builder() -> crate::output::create_location_object_storage_output::Builder {
        crate::output::create_location_object_storage_output::Builder::default()
    }
}

/// <p>CreateLocationNfsResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationNfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the source NFS file system location that is created.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationNfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the source NFS file system location that is created.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationNfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationNfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationNfsOutput`](crate::output::CreateLocationNfsOutput)
pub mod create_location_nfs_output {
    /// A builder for [`CreateLocationNfsOutput`](crate::output::CreateLocationNfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the source NFS file system location that is created.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source NFS file system location that is created.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationNfsOutput`](crate::output::CreateLocationNfsOutput)
        pub fn build(self) -> crate::output::CreateLocationNfsOutput {
            crate::output::CreateLocationNfsOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationNfsOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationNfsOutput`](crate::output::CreateLocationNfsOutput)
    pub fn builder() -> crate::output::create_location_nfs_output::Builder {
        crate::output::create_location_nfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationHdfsOutput {
    /// <p>The ARN of the source HDFS cluster location that's created. </p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationHdfsOutput {
    /// <p>The ARN of the source HDFS cluster location that's created. </p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationHdfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationHdfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationHdfsOutput`](crate::output::CreateLocationHdfsOutput)
pub mod create_location_hdfs_output {
    /// A builder for [`CreateLocationHdfsOutput`](crate::output::CreateLocationHdfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the source HDFS cluster location that's created. </p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the source HDFS cluster location that's created. </p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationHdfsOutput`](crate::output::CreateLocationHdfsOutput)
        pub fn build(self) -> crate::output::CreateLocationHdfsOutput {
            crate::output::CreateLocationHdfsOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationHdfsOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationHdfsOutput`](crate::output::CreateLocationHdfsOutput)
    pub fn builder() -> crate::output::create_location_hdfs_output::Builder {
        crate::output::create_location_hdfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationFsxWindowsOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server file system location you created.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationFsxWindowsOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server file system location you created.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationFsxWindowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationFsxWindowsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationFsxWindowsOutput`](crate::output::CreateLocationFsxWindowsOutput)
pub mod create_location_fsx_windows_output {
    /// A builder for [`CreateLocationFsxWindowsOutput`](crate::output::CreateLocationFsxWindowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server file system location you created.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Windows File Server file system location you created.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationFsxWindowsOutput`](crate::output::CreateLocationFsxWindowsOutput)
        pub fn build(self) -> crate::output::CreateLocationFsxWindowsOutput {
            crate::output::CreateLocationFsxWindowsOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationFsxWindowsOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationFsxWindowsOutput`](crate::output::CreateLocationFsxWindowsOutput)
    pub fn builder() -> crate::output::create_location_fsx_windows_output::Builder {
        crate::output::create_location_fsx_windows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationFsxOpenZfsOutput {
    /// <p>The ARN of the FSx for OpenZFS file system location that you created.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationFsxOpenZfsOutput {
    /// <p>The ARN of the FSx for OpenZFS file system location that you created.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationFsxOpenZfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationFsxOpenZfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationFsxOpenZfsOutput`](crate::output::CreateLocationFsxOpenZfsOutput)
pub mod create_location_fsx_open_zfs_output {
    /// A builder for [`CreateLocationFsxOpenZfsOutput`](crate::output::CreateLocationFsxOpenZfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the FSx for OpenZFS file system location that you created.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the FSx for OpenZFS file system location that you created.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationFsxOpenZfsOutput`](crate::output::CreateLocationFsxOpenZfsOutput)
        pub fn build(self) -> crate::output::CreateLocationFsxOpenZfsOutput {
            crate::output::CreateLocationFsxOpenZfsOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationFsxOpenZfsOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationFsxOpenZfsOutput`](crate::output::CreateLocationFsxOpenZfsOutput)
    pub fn builder() -> crate::output::create_location_fsx_open_zfs_output::Builder {
        crate::output::create_location_fsx_open_zfs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationFsxLustreOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre file system location that's created. </p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationFsxLustreOutput {
    /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre file system location that's created. </p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationFsxLustreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationFsxLustreOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationFsxLustreOutput`](crate::output::CreateLocationFsxLustreOutput)
pub mod create_location_fsx_lustre_output {
    /// A builder for [`CreateLocationFsxLustreOutput`](crate::output::CreateLocationFsxLustreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre file system location that's created. </p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the FSx for Lustre file system location that's created. </p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationFsxLustreOutput`](crate::output::CreateLocationFsxLustreOutput)
        pub fn build(self) -> crate::output::CreateLocationFsxLustreOutput {
            crate::output::CreateLocationFsxLustreOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationFsxLustreOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationFsxLustreOutput`](crate::output::CreateLocationFsxLustreOutput)
    pub fn builder() -> crate::output::create_location_fsx_lustre_output::Builder {
        crate::output::create_location_fsx_lustre_output::Builder::default()
    }
}

/// <p>CreateLocationEfs</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLocationEfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that is created.</p>
    pub location_arn: std::option::Option<std::string::String>,
}
impl CreateLocationEfsOutput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that is created.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLocationEfsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLocationEfsOutput");
        formatter.field("location_arn", &self.location_arn);
        formatter.finish()
    }
}
/// See [`CreateLocationEfsOutput`](crate::output::CreateLocationEfsOutput)
pub mod create_location_efs_output {
    /// A builder for [`CreateLocationEfsOutput`](crate::output::CreateLocationEfsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that is created.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that is created.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocationEfsOutput`](crate::output::CreateLocationEfsOutput)
        pub fn build(self) -> crate::output::CreateLocationEfsOutput {
            crate::output::CreateLocationEfsOutput {
                location_arn: self.location_arn,
            }
        }
    }
}
impl CreateLocationEfsOutput {
    /// Creates a new builder-style object to manufacture [`CreateLocationEfsOutput`](crate::output::CreateLocationEfsOutput)
    pub fn builder() -> crate::output::create_location_efs_output::Builder {
        crate::output::create_location_efs_output::Builder::default()
    }
}

/// <p>CreateAgentResponse</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAgentOutput {
    /// <p>The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
    pub agent_arn: std::option::Option<std::string::String>,
}
impl CreateAgentOutput {
    /// <p>The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
    pub fn agent_arn(&self) -> std::option::Option<&str> {
        self.agent_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAgentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAgentOutput");
        formatter.field("agent_arn", &self.agent_arn);
        formatter.finish()
    }
}
/// See [`CreateAgentOutput`](crate::output::CreateAgentOutput)
pub mod create_agent_output {
    /// A builder for [`CreateAgentOutput`](crate::output::CreateAgentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
        pub fn agent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAgentOutput`](crate::output::CreateAgentOutput)
        pub fn build(self) -> crate::output::CreateAgentOutput {
            crate::output::CreateAgentOutput {
                agent_arn: self.agent_arn,
            }
        }
    }
}
impl CreateAgentOutput {
    /// Creates a new builder-style object to manufacture [`CreateAgentOutput`](crate::output::CreateAgentOutput)
    pub fn builder() -> crate::output::create_agent_output::Builder {
        crate::output::create_agent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelTaskExecutionOutput {}
impl std::fmt::Debug for CancelTaskExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelTaskExecutionOutput");
        formatter.finish()
    }
}
/// See [`CancelTaskExecutionOutput`](crate::output::CancelTaskExecutionOutput)
pub mod cancel_task_execution_output {
    /// A builder for [`CancelTaskExecutionOutput`](crate::output::CancelTaskExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelTaskExecutionOutput`](crate::output::CancelTaskExecutionOutput)
        pub fn build(self) -> crate::output::CancelTaskExecutionOutput {
            crate::output::CancelTaskExecutionOutput {}
        }
    }
}
impl CancelTaskExecutionOutput {
    /// Creates a new builder-style object to manufacture [`CancelTaskExecutionOutput`](crate::output::CancelTaskExecutionOutput)
    pub fn builder() -> crate::output::cancel_task_execution_output::Builder {
        crate::output::cancel_task_execution_output::Builder::default()
    }
}
