// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelTaskExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_task_execution`](crate::client::Client::cancel_task_execution).
///
/// See [`crate::client::fluent_builders::CancelTaskExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelTaskExecution {
    _private: (),
}
impl CancelTaskExecution {
    /// Creates a new builder-style object to manufacture [`CancelTaskExecutionInput`](crate::input::CancelTaskExecutionInput)
    pub fn builder() -> crate::input::cancel_task_execution_input::Builder {
        crate::input::cancel_task_execution_input::Builder::default()
    }
    /// Creates a new `CancelTaskExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelTaskExecution {
    type Output = std::result::Result<
        crate::output::CancelTaskExecutionOutput,
        crate::error::CancelTaskExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_task_execution_error(response)
        } else {
            crate::operation_deser::parse_cancel_task_execution_response(response)
        }
    }
}

/// Operation shape for `CreateAgent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_agent`](crate::client::Client::create_agent).
///
/// See [`crate::client::fluent_builders::CreateAgent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAgent {
    _private: (),
}
impl CreateAgent {
    /// Creates a new builder-style object to manufacture [`CreateAgentInput`](crate::input::CreateAgentInput)
    pub fn builder() -> crate::input::create_agent_input::Builder {
        crate::input::create_agent_input::Builder::default()
    }
    /// Creates a new `CreateAgent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAgent {
    type Output =
        std::result::Result<crate::output::CreateAgentOutput, crate::error::CreateAgentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_agent_error(response)
        } else {
            crate::operation_deser::parse_create_agent_response(response)
        }
    }
}

/// Operation shape for `CreateLocationEfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_efs`](crate::client::Client::create_location_efs).
///
/// See [`crate::client::fluent_builders::CreateLocationEfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationEfs {
    _private: (),
}
impl CreateLocationEfs {
    /// Creates a new builder-style object to manufacture [`CreateLocationEfsInput`](crate::input::CreateLocationEfsInput)
    pub fn builder() -> crate::input::create_location_efs_input::Builder {
        crate::input::create_location_efs_input::Builder::default()
    }
    /// Creates a new `CreateLocationEfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationEfs {
    type Output = std::result::Result<
        crate::output::CreateLocationEfsOutput,
        crate::error::CreateLocationEfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_efs_error(response)
        } else {
            crate::operation_deser::parse_create_location_efs_response(response)
        }
    }
}

/// Operation shape for `CreateLocationFsxLustre`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_fsx_lustre`](crate::client::Client::create_location_fsx_lustre).
///
/// See [`crate::client::fluent_builders::CreateLocationFsxLustre`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationFsxLustre {
    _private: (),
}
impl CreateLocationFsxLustre {
    /// Creates a new builder-style object to manufacture [`CreateLocationFsxLustreInput`](crate::input::CreateLocationFsxLustreInput)
    pub fn builder() -> crate::input::create_location_fsx_lustre_input::Builder {
        crate::input::create_location_fsx_lustre_input::Builder::default()
    }
    /// Creates a new `CreateLocationFsxLustre` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationFsxLustre {
    type Output = std::result::Result<
        crate::output::CreateLocationFsxLustreOutput,
        crate::error::CreateLocationFsxLustreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_fsx_lustre_error(response)
        } else {
            crate::operation_deser::parse_create_location_fsx_lustre_response(response)
        }
    }
}

/// Operation shape for `CreateLocationFsxOpenZfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_fsx_open_zfs`](crate::client::Client::create_location_fsx_open_zfs).
///
/// See [`crate::client::fluent_builders::CreateLocationFsxOpenZfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationFsxOpenZfs {
    _private: (),
}
impl CreateLocationFsxOpenZfs {
    /// Creates a new builder-style object to manufacture [`CreateLocationFsxOpenZfsInput`](crate::input::CreateLocationFsxOpenZfsInput)
    pub fn builder() -> crate::input::create_location_fsx_open_zfs_input::Builder {
        crate::input::create_location_fsx_open_zfs_input::Builder::default()
    }
    /// Creates a new `CreateLocationFsxOpenZfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationFsxOpenZfs {
    type Output = std::result::Result<
        crate::output::CreateLocationFsxOpenZfsOutput,
        crate::error::CreateLocationFsxOpenZfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_fsx_open_zfs_error(response)
        } else {
            crate::operation_deser::parse_create_location_fsx_open_zfs_response(response)
        }
    }
}

/// Operation shape for `CreateLocationFsxWindows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_fsx_windows`](crate::client::Client::create_location_fsx_windows).
///
/// See [`crate::client::fluent_builders::CreateLocationFsxWindows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationFsxWindows {
    _private: (),
}
impl CreateLocationFsxWindows {
    /// Creates a new builder-style object to manufacture [`CreateLocationFsxWindowsInput`](crate::input::CreateLocationFsxWindowsInput)
    pub fn builder() -> crate::input::create_location_fsx_windows_input::Builder {
        crate::input::create_location_fsx_windows_input::Builder::default()
    }
    /// Creates a new `CreateLocationFsxWindows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationFsxWindows {
    type Output = std::result::Result<
        crate::output::CreateLocationFsxWindowsOutput,
        crate::error::CreateLocationFsxWindowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_fsx_windows_error(response)
        } else {
            crate::operation_deser::parse_create_location_fsx_windows_response(response)
        }
    }
}

/// Operation shape for `CreateLocationHdfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_hdfs`](crate::client::Client::create_location_hdfs).
///
/// See [`crate::client::fluent_builders::CreateLocationHdfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationHdfs {
    _private: (),
}
impl CreateLocationHdfs {
    /// Creates a new builder-style object to manufacture [`CreateLocationHdfsInput`](crate::input::CreateLocationHdfsInput)
    pub fn builder() -> crate::input::create_location_hdfs_input::Builder {
        crate::input::create_location_hdfs_input::Builder::default()
    }
    /// Creates a new `CreateLocationHdfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationHdfs {
    type Output = std::result::Result<
        crate::output::CreateLocationHdfsOutput,
        crate::error::CreateLocationHdfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_hdfs_error(response)
        } else {
            crate::operation_deser::parse_create_location_hdfs_response(response)
        }
    }
}

/// Operation shape for `CreateLocationNfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_nfs`](crate::client::Client::create_location_nfs).
///
/// See [`crate::client::fluent_builders::CreateLocationNfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationNfs {
    _private: (),
}
impl CreateLocationNfs {
    /// Creates a new builder-style object to manufacture [`CreateLocationNfsInput`](crate::input::CreateLocationNfsInput)
    pub fn builder() -> crate::input::create_location_nfs_input::Builder {
        crate::input::create_location_nfs_input::Builder::default()
    }
    /// Creates a new `CreateLocationNfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationNfs {
    type Output = std::result::Result<
        crate::output::CreateLocationNfsOutput,
        crate::error::CreateLocationNfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_nfs_error(response)
        } else {
            crate::operation_deser::parse_create_location_nfs_response(response)
        }
    }
}

/// Operation shape for `CreateLocationObjectStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_object_storage`](crate::client::Client::create_location_object_storage).
///
/// See [`crate::client::fluent_builders::CreateLocationObjectStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationObjectStorage {
    _private: (),
}
impl CreateLocationObjectStorage {
    /// Creates a new builder-style object to manufacture [`CreateLocationObjectStorageInput`](crate::input::CreateLocationObjectStorageInput)
    pub fn builder() -> crate::input::create_location_object_storage_input::Builder {
        crate::input::create_location_object_storage_input::Builder::default()
    }
    /// Creates a new `CreateLocationObjectStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationObjectStorage {
    type Output = std::result::Result<
        crate::output::CreateLocationObjectStorageOutput,
        crate::error::CreateLocationObjectStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_object_storage_error(response)
        } else {
            crate::operation_deser::parse_create_location_object_storage_response(response)
        }
    }
}

/// Operation shape for `CreateLocationS3`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_s3`](crate::client::Client::create_location_s3).
///
/// See [`crate::client::fluent_builders::CreateLocationS3`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationS3 {
    _private: (),
}
impl CreateLocationS3 {
    /// Creates a new builder-style object to manufacture [`CreateLocationS3Input`](crate::input::CreateLocationS3Input)
    pub fn builder() -> crate::input::create_location_s3_input::Builder {
        crate::input::create_location_s3_input::Builder::default()
    }
    /// Creates a new `CreateLocationS3` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationS3 {
    type Output = std::result::Result<
        crate::output::CreateLocationS3Output,
        crate::error::CreateLocationS3Error,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_s3_error(response)
        } else {
            crate::operation_deser::parse_create_location_s3_response(response)
        }
    }
}

/// Operation shape for `CreateLocationSmb`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_location_smb`](crate::client::Client::create_location_smb).
///
/// See [`crate::client::fluent_builders::CreateLocationSmb`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocationSmb {
    _private: (),
}
impl CreateLocationSmb {
    /// Creates a new builder-style object to manufacture [`CreateLocationSmbInput`](crate::input::CreateLocationSmbInput)
    pub fn builder() -> crate::input::create_location_smb_input::Builder {
        crate::input::create_location_smb_input::Builder::default()
    }
    /// Creates a new `CreateLocationSmb` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocationSmb {
    type Output = std::result::Result<
        crate::output::CreateLocationSmbOutput,
        crate::error::CreateLocationSmbError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_location_smb_error(response)
        } else {
            crate::operation_deser::parse_create_location_smb_response(response)
        }
    }
}

/// Operation shape for `CreateTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_task`](crate::client::Client::create_task).
///
/// See [`crate::client::fluent_builders::CreateTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTask {
    _private: (),
}
impl CreateTask {
    /// Creates a new builder-style object to manufacture [`CreateTaskInput`](crate::input::CreateTaskInput)
    pub fn builder() -> crate::input::create_task_input::Builder {
        crate::input::create_task_input::Builder::default()
    }
    /// Creates a new `CreateTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTask {
    type Output =
        std::result::Result<crate::output::CreateTaskOutput, crate::error::CreateTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_task_error(response)
        } else {
            crate::operation_deser::parse_create_task_response(response)
        }
    }
}

/// Operation shape for `DeleteAgent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_agent`](crate::client::Client::delete_agent).
///
/// See [`crate::client::fluent_builders::DeleteAgent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAgent {
    _private: (),
}
impl DeleteAgent {
    /// Creates a new builder-style object to manufacture [`DeleteAgentInput`](crate::input::DeleteAgentInput)
    pub fn builder() -> crate::input::delete_agent_input::Builder {
        crate::input::delete_agent_input::Builder::default()
    }
    /// Creates a new `DeleteAgent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAgent {
    type Output =
        std::result::Result<crate::output::DeleteAgentOutput, crate::error::DeleteAgentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_agent_error(response)
        } else {
            crate::operation_deser::parse_delete_agent_response(response)
        }
    }
}

/// Operation shape for `DeleteLocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_location`](crate::client::Client::delete_location).
///
/// See [`crate::client::fluent_builders::DeleteLocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLocation {
    _private: (),
}
impl DeleteLocation {
    /// Creates a new builder-style object to manufacture [`DeleteLocationInput`](crate::input::DeleteLocationInput)
    pub fn builder() -> crate::input::delete_location_input::Builder {
        crate::input::delete_location_input::Builder::default()
    }
    /// Creates a new `DeleteLocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLocation {
    type Output =
        std::result::Result<crate::output::DeleteLocationOutput, crate::error::DeleteLocationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_location_error(response)
        } else {
            crate::operation_deser::parse_delete_location_response(response)
        }
    }
}

/// Operation shape for `DeleteTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_task`](crate::client::Client::delete_task).
///
/// See [`crate::client::fluent_builders::DeleteTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTask {
    _private: (),
}
impl DeleteTask {
    /// Creates a new builder-style object to manufacture [`DeleteTaskInput`](crate::input::DeleteTaskInput)
    pub fn builder() -> crate::input::delete_task_input::Builder {
        crate::input::delete_task_input::Builder::default()
    }
    /// Creates a new `DeleteTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTask {
    type Output =
        std::result::Result<crate::output::DeleteTaskOutput, crate::error::DeleteTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_task_error(response)
        } else {
            crate::operation_deser::parse_delete_task_response(response)
        }
    }
}

/// Operation shape for `DescribeAgent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_agent`](crate::client::Client::describe_agent).
///
/// See [`crate::client::fluent_builders::DescribeAgent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAgent {
    _private: (),
}
impl DescribeAgent {
    /// Creates a new builder-style object to manufacture [`DescribeAgentInput`](crate::input::DescribeAgentInput)
    pub fn builder() -> crate::input::describe_agent_input::Builder {
        crate::input::describe_agent_input::Builder::default()
    }
    /// Creates a new `DescribeAgent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAgent {
    type Output =
        std::result::Result<crate::output::DescribeAgentOutput, crate::error::DescribeAgentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_agent_error(response)
        } else {
            crate::operation_deser::parse_describe_agent_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationEfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_efs`](crate::client::Client::describe_location_efs).
///
/// See [`crate::client::fluent_builders::DescribeLocationEfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationEfs {
    _private: (),
}
impl DescribeLocationEfs {
    /// Creates a new builder-style object to manufacture [`DescribeLocationEfsInput`](crate::input::DescribeLocationEfsInput)
    pub fn builder() -> crate::input::describe_location_efs_input::Builder {
        crate::input::describe_location_efs_input::Builder::default()
    }
    /// Creates a new `DescribeLocationEfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationEfs {
    type Output = std::result::Result<
        crate::output::DescribeLocationEfsOutput,
        crate::error::DescribeLocationEfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_efs_error(response)
        } else {
            crate::operation_deser::parse_describe_location_efs_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationFsxLustre`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_fsx_lustre`](crate::client::Client::describe_location_fsx_lustre).
///
/// See [`crate::client::fluent_builders::DescribeLocationFsxLustre`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationFsxLustre {
    _private: (),
}
impl DescribeLocationFsxLustre {
    /// Creates a new builder-style object to manufacture [`DescribeLocationFsxLustreInput`](crate::input::DescribeLocationFsxLustreInput)
    pub fn builder() -> crate::input::describe_location_fsx_lustre_input::Builder {
        crate::input::describe_location_fsx_lustre_input::Builder::default()
    }
    /// Creates a new `DescribeLocationFsxLustre` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationFsxLustre {
    type Output = std::result::Result<
        crate::output::DescribeLocationFsxLustreOutput,
        crate::error::DescribeLocationFsxLustreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_fsx_lustre_error(response)
        } else {
            crate::operation_deser::parse_describe_location_fsx_lustre_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationFsxOpenZfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_fsx_open_zfs`](crate::client::Client::describe_location_fsx_open_zfs).
///
/// See [`crate::client::fluent_builders::DescribeLocationFsxOpenZfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationFsxOpenZfs {
    _private: (),
}
impl DescribeLocationFsxOpenZfs {
    /// Creates a new builder-style object to manufacture [`DescribeLocationFsxOpenZfsInput`](crate::input::DescribeLocationFsxOpenZfsInput)
    pub fn builder() -> crate::input::describe_location_fsx_open_zfs_input::Builder {
        crate::input::describe_location_fsx_open_zfs_input::Builder::default()
    }
    /// Creates a new `DescribeLocationFsxOpenZfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationFsxOpenZfs {
    type Output = std::result::Result<
        crate::output::DescribeLocationFsxOpenZfsOutput,
        crate::error::DescribeLocationFsxOpenZfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_fsx_open_zfs_error(response)
        } else {
            crate::operation_deser::parse_describe_location_fsx_open_zfs_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationFsxWindows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_fsx_windows`](crate::client::Client::describe_location_fsx_windows).
///
/// See [`crate::client::fluent_builders::DescribeLocationFsxWindows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationFsxWindows {
    _private: (),
}
impl DescribeLocationFsxWindows {
    /// Creates a new builder-style object to manufacture [`DescribeLocationFsxWindowsInput`](crate::input::DescribeLocationFsxWindowsInput)
    pub fn builder() -> crate::input::describe_location_fsx_windows_input::Builder {
        crate::input::describe_location_fsx_windows_input::Builder::default()
    }
    /// Creates a new `DescribeLocationFsxWindows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationFsxWindows {
    type Output = std::result::Result<
        crate::output::DescribeLocationFsxWindowsOutput,
        crate::error::DescribeLocationFsxWindowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_fsx_windows_error(response)
        } else {
            crate::operation_deser::parse_describe_location_fsx_windows_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationHdfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_hdfs`](crate::client::Client::describe_location_hdfs).
///
/// See [`crate::client::fluent_builders::DescribeLocationHdfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationHdfs {
    _private: (),
}
impl DescribeLocationHdfs {
    /// Creates a new builder-style object to manufacture [`DescribeLocationHdfsInput`](crate::input::DescribeLocationHdfsInput)
    pub fn builder() -> crate::input::describe_location_hdfs_input::Builder {
        crate::input::describe_location_hdfs_input::Builder::default()
    }
    /// Creates a new `DescribeLocationHdfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationHdfs {
    type Output = std::result::Result<
        crate::output::DescribeLocationHdfsOutput,
        crate::error::DescribeLocationHdfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_hdfs_error(response)
        } else {
            crate::operation_deser::parse_describe_location_hdfs_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationNfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_nfs`](crate::client::Client::describe_location_nfs).
///
/// See [`crate::client::fluent_builders::DescribeLocationNfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationNfs {
    _private: (),
}
impl DescribeLocationNfs {
    /// Creates a new builder-style object to manufacture [`DescribeLocationNfsInput`](crate::input::DescribeLocationNfsInput)
    pub fn builder() -> crate::input::describe_location_nfs_input::Builder {
        crate::input::describe_location_nfs_input::Builder::default()
    }
    /// Creates a new `DescribeLocationNfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationNfs {
    type Output = std::result::Result<
        crate::output::DescribeLocationNfsOutput,
        crate::error::DescribeLocationNfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_nfs_error(response)
        } else {
            crate::operation_deser::parse_describe_location_nfs_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationObjectStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_object_storage`](crate::client::Client::describe_location_object_storage).
///
/// See [`crate::client::fluent_builders::DescribeLocationObjectStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationObjectStorage {
    _private: (),
}
impl DescribeLocationObjectStorage {
    /// Creates a new builder-style object to manufacture [`DescribeLocationObjectStorageInput`](crate::input::DescribeLocationObjectStorageInput)
    pub fn builder() -> crate::input::describe_location_object_storage_input::Builder {
        crate::input::describe_location_object_storage_input::Builder::default()
    }
    /// Creates a new `DescribeLocationObjectStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationObjectStorage {
    type Output = std::result::Result<
        crate::output::DescribeLocationObjectStorageOutput,
        crate::error::DescribeLocationObjectStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_object_storage_error(response)
        } else {
            crate::operation_deser::parse_describe_location_object_storage_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationS3`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_s3`](crate::client::Client::describe_location_s3).
///
/// See [`crate::client::fluent_builders::DescribeLocationS3`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationS3 {
    _private: (),
}
impl DescribeLocationS3 {
    /// Creates a new builder-style object to manufacture [`DescribeLocationS3Input`](crate::input::DescribeLocationS3Input)
    pub fn builder() -> crate::input::describe_location_s3_input::Builder {
        crate::input::describe_location_s3_input::Builder::default()
    }
    /// Creates a new `DescribeLocationS3` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationS3 {
    type Output = std::result::Result<
        crate::output::DescribeLocationS3Output,
        crate::error::DescribeLocationS3Error,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_s3_error(response)
        } else {
            crate::operation_deser::parse_describe_location_s3_response(response)
        }
    }
}

/// Operation shape for `DescribeLocationSmb`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_location_smb`](crate::client::Client::describe_location_smb).
///
/// See [`crate::client::fluent_builders::DescribeLocationSmb`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocationSmb {
    _private: (),
}
impl DescribeLocationSmb {
    /// Creates a new builder-style object to manufacture [`DescribeLocationSmbInput`](crate::input::DescribeLocationSmbInput)
    pub fn builder() -> crate::input::describe_location_smb_input::Builder {
        crate::input::describe_location_smb_input::Builder::default()
    }
    /// Creates a new `DescribeLocationSmb` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocationSmb {
    type Output = std::result::Result<
        crate::output::DescribeLocationSmbOutput,
        crate::error::DescribeLocationSmbError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_location_smb_error(response)
        } else {
            crate::operation_deser::parse_describe_location_smb_response(response)
        }
    }
}

/// Operation shape for `DescribeTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_task`](crate::client::Client::describe_task).
///
/// See [`crate::client::fluent_builders::DescribeTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTask {
    _private: (),
}
impl DescribeTask {
    /// Creates a new builder-style object to manufacture [`DescribeTaskInput`](crate::input::DescribeTaskInput)
    pub fn builder() -> crate::input::describe_task_input::Builder {
        crate::input::describe_task_input::Builder::default()
    }
    /// Creates a new `DescribeTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTask {
    type Output =
        std::result::Result<crate::output::DescribeTaskOutput, crate::error::DescribeTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_task_error(response)
        } else {
            crate::operation_deser::parse_describe_task_response(response)
        }
    }
}

/// Operation shape for `DescribeTaskExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_task_execution`](crate::client::Client::describe_task_execution).
///
/// See [`crate::client::fluent_builders::DescribeTaskExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTaskExecution {
    _private: (),
}
impl DescribeTaskExecution {
    /// Creates a new builder-style object to manufacture [`DescribeTaskExecutionInput`](crate::input::DescribeTaskExecutionInput)
    pub fn builder() -> crate::input::describe_task_execution_input::Builder {
        crate::input::describe_task_execution_input::Builder::default()
    }
    /// Creates a new `DescribeTaskExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTaskExecution {
    type Output = std::result::Result<
        crate::output::DescribeTaskExecutionOutput,
        crate::error::DescribeTaskExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_task_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_task_execution_response(response)
        }
    }
}

/// Operation shape for `ListAgents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_agents`](crate::client::Client::list_agents).
///
/// See [`crate::client::fluent_builders::ListAgents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAgents {
    _private: (),
}
impl ListAgents {
    /// Creates a new builder-style object to manufacture [`ListAgentsInput`](crate::input::ListAgentsInput)
    pub fn builder() -> crate::input::list_agents_input::Builder {
        crate::input::list_agents_input::Builder::default()
    }
    /// Creates a new `ListAgents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAgents {
    type Output =
        std::result::Result<crate::output::ListAgentsOutput, crate::error::ListAgentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_agents_error(response)
        } else {
            crate::operation_deser::parse_list_agents_response(response)
        }
    }
}

/// Operation shape for `ListLocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_locations`](crate::client::Client::list_locations).
///
/// See [`crate::client::fluent_builders::ListLocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLocations {
    _private: (),
}
impl ListLocations {
    /// Creates a new builder-style object to manufacture [`ListLocationsInput`](crate::input::ListLocationsInput)
    pub fn builder() -> crate::input::list_locations_input::Builder {
        crate::input::list_locations_input::Builder::default()
    }
    /// Creates a new `ListLocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLocations {
    type Output =
        std::result::Result<crate::output::ListLocationsOutput, crate::error::ListLocationsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_locations_error(response)
        } else {
            crate::operation_deser::parse_list_locations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTaskExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_task_executions`](crate::client::Client::list_task_executions).
///
/// See [`crate::client::fluent_builders::ListTaskExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTaskExecutions {
    _private: (),
}
impl ListTaskExecutions {
    /// Creates a new builder-style object to manufacture [`ListTaskExecutionsInput`](crate::input::ListTaskExecutionsInput)
    pub fn builder() -> crate::input::list_task_executions_input::Builder {
        crate::input::list_task_executions_input::Builder::default()
    }
    /// Creates a new `ListTaskExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTaskExecutions {
    type Output = std::result::Result<
        crate::output::ListTaskExecutionsOutput,
        crate::error::ListTaskExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_task_executions_error(response)
        } else {
            crate::operation_deser::parse_list_task_executions_response(response)
        }
    }
}

/// Operation shape for `ListTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tasks`](crate::client::Client::list_tasks).
///
/// See [`crate::client::fluent_builders::ListTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTasks {
    _private: (),
}
impl ListTasks {
    /// Creates a new builder-style object to manufacture [`ListTasksInput`](crate::input::ListTasksInput)
    pub fn builder() -> crate::input::list_tasks_input::Builder {
        crate::input::list_tasks_input::Builder::default()
    }
    /// Creates a new `ListTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTasks {
    type Output = std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_tasks_response(response)
        }
    }
}

/// Operation shape for `StartTaskExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_task_execution`](crate::client::Client::start_task_execution).
///
/// See [`crate::client::fluent_builders::StartTaskExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTaskExecution {
    _private: (),
}
impl StartTaskExecution {
    /// Creates a new builder-style object to manufacture [`StartTaskExecutionInput`](crate::input::StartTaskExecutionInput)
    pub fn builder() -> crate::input::start_task_execution_input::Builder {
        crate::input::start_task_execution_input::Builder::default()
    }
    /// Creates a new `StartTaskExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTaskExecution {
    type Output = std::result::Result<
        crate::output::StartTaskExecutionOutput,
        crate::error::StartTaskExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_task_execution_error(response)
        } else {
            crate::operation_deser::parse_start_task_execution_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAgent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_agent`](crate::client::Client::update_agent).
///
/// See [`crate::client::fluent_builders::UpdateAgent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAgent {
    _private: (),
}
impl UpdateAgent {
    /// Creates a new builder-style object to manufacture [`UpdateAgentInput`](crate::input::UpdateAgentInput)
    pub fn builder() -> crate::input::update_agent_input::Builder {
        crate::input::update_agent_input::Builder::default()
    }
    /// Creates a new `UpdateAgent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAgent {
    type Output =
        std::result::Result<crate::output::UpdateAgentOutput, crate::error::UpdateAgentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_agent_error(response)
        } else {
            crate::operation_deser::parse_update_agent_response(response)
        }
    }
}

/// Operation shape for `UpdateLocationHdfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_location_hdfs`](crate::client::Client::update_location_hdfs).
///
/// See [`crate::client::fluent_builders::UpdateLocationHdfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLocationHdfs {
    _private: (),
}
impl UpdateLocationHdfs {
    /// Creates a new builder-style object to manufacture [`UpdateLocationHdfsInput`](crate::input::UpdateLocationHdfsInput)
    pub fn builder() -> crate::input::update_location_hdfs_input::Builder {
        crate::input::update_location_hdfs_input::Builder::default()
    }
    /// Creates a new `UpdateLocationHdfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLocationHdfs {
    type Output = std::result::Result<
        crate::output::UpdateLocationHdfsOutput,
        crate::error::UpdateLocationHdfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_location_hdfs_error(response)
        } else {
            crate::operation_deser::parse_update_location_hdfs_response(response)
        }
    }
}

/// Operation shape for `UpdateLocationNfs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_location_nfs`](crate::client::Client::update_location_nfs).
///
/// See [`crate::client::fluent_builders::UpdateLocationNfs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLocationNfs {
    _private: (),
}
impl UpdateLocationNfs {
    /// Creates a new builder-style object to manufacture [`UpdateLocationNfsInput`](crate::input::UpdateLocationNfsInput)
    pub fn builder() -> crate::input::update_location_nfs_input::Builder {
        crate::input::update_location_nfs_input::Builder::default()
    }
    /// Creates a new `UpdateLocationNfs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLocationNfs {
    type Output = std::result::Result<
        crate::output::UpdateLocationNfsOutput,
        crate::error::UpdateLocationNfsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_location_nfs_error(response)
        } else {
            crate::operation_deser::parse_update_location_nfs_response(response)
        }
    }
}

/// Operation shape for `UpdateLocationObjectStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_location_object_storage`](crate::client::Client::update_location_object_storage).
///
/// See [`crate::client::fluent_builders::UpdateLocationObjectStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLocationObjectStorage {
    _private: (),
}
impl UpdateLocationObjectStorage {
    /// Creates a new builder-style object to manufacture [`UpdateLocationObjectStorageInput`](crate::input::UpdateLocationObjectStorageInput)
    pub fn builder() -> crate::input::update_location_object_storage_input::Builder {
        crate::input::update_location_object_storage_input::Builder::default()
    }
    /// Creates a new `UpdateLocationObjectStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLocationObjectStorage {
    type Output = std::result::Result<
        crate::output::UpdateLocationObjectStorageOutput,
        crate::error::UpdateLocationObjectStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_location_object_storage_error(response)
        } else {
            crate::operation_deser::parse_update_location_object_storage_response(response)
        }
    }
}

/// Operation shape for `UpdateLocationSmb`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_location_smb`](crate::client::Client::update_location_smb).
///
/// See [`crate::client::fluent_builders::UpdateLocationSmb`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLocationSmb {
    _private: (),
}
impl UpdateLocationSmb {
    /// Creates a new builder-style object to manufacture [`UpdateLocationSmbInput`](crate::input::UpdateLocationSmbInput)
    pub fn builder() -> crate::input::update_location_smb_input::Builder {
        crate::input::update_location_smb_input::Builder::default()
    }
    /// Creates a new `UpdateLocationSmb` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLocationSmb {
    type Output = std::result::Result<
        crate::output::UpdateLocationSmbOutput,
        crate::error::UpdateLocationSmbError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_location_smb_error(response)
        } else {
            crate::operation_deser::parse_update_location_smb_response(response)
        }
    }
}

/// Operation shape for `UpdateTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_task`](crate::client::Client::update_task).
///
/// See [`crate::client::fluent_builders::UpdateTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTask {
    _private: (),
}
impl UpdateTask {
    /// Creates a new builder-style object to manufacture [`UpdateTaskInput`](crate::input::UpdateTaskInput)
    pub fn builder() -> crate::input::update_task_input::Builder {
        crate::input::update_task_input::Builder::default()
    }
    /// Creates a new `UpdateTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTask {
    type Output =
        std::result::Result<crate::output::UpdateTaskOutput, crate::error::UpdateTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_task_error(response)
        } else {
            crate::operation_deser::parse_update_task_response(response)
        }
    }
}

/// Operation shape for `UpdateTaskExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_task_execution`](crate::client::Client::update_task_execution).
///
/// See [`crate::client::fluent_builders::UpdateTaskExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTaskExecution {
    _private: (),
}
impl UpdateTaskExecution {
    /// Creates a new builder-style object to manufacture [`UpdateTaskExecutionInput`](crate::input::UpdateTaskExecutionInput)
    pub fn builder() -> crate::input::update_task_execution_input::Builder {
        crate::input::update_task_execution_input::Builder::default()
    }
    /// Creates a new `UpdateTaskExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTaskExecution {
    type Output = std::result::Result<
        crate::output::UpdateTaskExecutionOutput,
        crate::error::UpdateTaskExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_task_execution_error(response)
        } else {
            crate::operation_deser::parse_update_task_execution_response(response)
        }
    }
}
