// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. Behavior includes preserving metadata such as user ID (UID), group ID (GID), and file permissions, and also overwriting files in the destination, data integrity verification, and so on.</p>
/// <p>A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>, the default value is used. You can override the defaults options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Options {
    /// <p>A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a>. </p>
    /// <p>Default value: POINT_IN_TIME_CONSISTENT.</p>
    /// <p>ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files that were transferred. </p>
    /// <p>POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at the end of the transfer to verify that source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p>
    /// <p>NONE: No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.</p>
    pub verify_mode: std::option::Option<crate::model::VerifyMode>,
    /// <p>A value that determines whether files at the destination should be overwritten or preserved when copying files. If set to <code>NEVER</code> a destination file will not be replaced by a source file, even if the destination file differs from the source file. If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes. </p>
    /// <p>Some storage classes have specific behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
    pub overwrite_mode: std::option::Option<crate::model::OverwriteMode>,
    /// <p>A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to). If you set <code>Atime</code> to BEST_EFFORT, DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code>'s behavior is not fully standard across platforms, so DataSync can only do this on a best-effort basis. </p>
    /// <p>Default value: BEST_EFFORT.</p>
    /// <p>BEST_EFFORT: Attempt to preserve the per-file <code>Atime</code> value (recommended).</p>
    /// <p>NONE: Ignore <code>Atime</code>.</p> <note>
    /// <p>If <code>Atime</code> is set to BEST_EFFORT, <code>Mtime</code> must be set to PRESERVE. </p>
    /// <p>If <code>Atime</code> is set to NONE, <code>Mtime</code> must also be NONE. </p>
    /// </note>
    pub atime: std::option::Option<crate::model::Atime>,
    /// <p>A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase. This option is required for cases when you need to run the same task more than one time. </p>
    /// <p>Default Value: <code>PRESERVE</code> </p>
    /// <p>PRESERVE: Preserve original <code>Mtime</code> (recommended)</p>
    /// <p> NONE: Ignore <code>Mtime</code>. </p> <note>
    /// <p>If <code>Mtime</code> is set to PRESERVE, <code>Atime</code> must be set to BEST_EFFORT.</p>
    /// <p>If <code>Mtime</code> is set to NONE, <code>Atime</code> must also be set to NONE. </p>
    /// </note>
    pub mtime: std::option::Option<crate::model::Mtime>,
    /// <p>The POSIX user ID (UID) of the file's owner. This option should only be set for NFS, EFS, and S3 locations. To learn more about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>.</p>
    /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
    /// <p>INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).</p>
    /// <p>NONE: Ignore UID and GID. </p>
    pub uid: std::option::Option<crate::model::Uid>,
    /// <p>The POSIX group ID (GID) of the file's owners. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
    /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
    /// <p>INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).</p>
    /// <p>NONE: Ignore UID and GID. </p>
    pub gid: std::option::Option<crate::model::Gid>,
    /// <p>A value that specifies whether files in the destination that don't exist in the source file system should be preserved. This option can affect your storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
    /// <p>Default value: PRESERVE.</p>
    /// <p>PRESERVE: Ignore such destination files (recommended). </p>
    /// <p>REMOVE: Delete destination files that aren’t present in the source.</p>
    pub preserve_deleted_files: std::option::Option<crate::model::PreserveDeletedFiles>,
    /// <p>A value that determines whether DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination. DataSync does not copy the contents of such devices, only the name and metadata. </p> <note>
    /// <p>DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.</p>
    /// </note>
    /// <p>Default value: NONE.</p>
    /// <p>NONE: Ignore special devices (recommended). </p>
    /// <p>PRESERVE: Preserve character and block device metadata. This option isn't currently supported for Amazon EFS. </p>
    pub preserve_devices: std::option::Option<crate::model::PreserveDevices>,
    /// <p>A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
    /// <p>Default value: PRESERVE.</p>
    /// <p>PRESERVE: Preserve POSIX-style permissions (recommended).</p>
    /// <p>NONE: Ignore permissions. </p> <note>
    /// <p>DataSync can preserve extant permissions of a source location.</p>
    /// </note>
    pub posix_permissions: std::option::Option<crate::model::PosixPermissions>,
    /// <p>A value that limits the bandwidth used by DataSync. For example, if you want DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (<code>=1024*1024</code>).</p>
    pub bytes_per_second: std::option::Option<i64>,
    /// <p>A value that determines whether tasks should be queued before executing the tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is <code>ENABLED</code>.</p>
    /// <p>If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing task executions</a>.</p>
    pub task_queueing: std::option::Option<crate::model::TaskQueueing>,
    /// <p>A value that determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. For more information about providing a log group for DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>. If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes logs on errors for individual files transferred, and <code>TRANSFER</code> publishes logs for every file or object that is transferred and integrity checked.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// <p>A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. </p>
    /// <p>CHANGED: DataSync copies only data or metadata that is new or different content from the source location to the destination location.</p>
    /// <p>ALL: DataSync copies all source location content to the destination, without comparing to existing content on the destination.</p>
    pub transfer_mode: std::option::Option<crate::model::TransferMode>,
    /// <p>A value that determines which components of the SMB security descriptor are copied from source to destination objects. </p>
    /// <p>This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a>. </p>
    /// <p>Default value: OWNER_DACL.</p>
    /// <p> <b>OWNER_DACL</b>: For each copied object, DataSync copies the following metadata:</p>
    /// <ul>
    /// <li> <p>Object owner.</p> </li>
    /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
    /// </ul>
    /// <p>When choosing this option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p>
    /// <p> <b>OWNER_DACL_SACL</b>: For each copied object, DataSync copies the following metadata:</p>
    /// <ul>
    /// <li> <p>Object owner.</p> </li>
    /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
    /// <li> <p>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p> </li>
    /// </ul>
    /// <p>Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
    /// <p> <b>NONE</b>: None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration. </p>
    pub security_descriptor_copy_flags:
        std::option::Option<crate::model::SmbSecurityDescriptorCopyFlags>,
    /// <p>Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.</p>
    /// <p>Default Value: <code>PRESERVE</code> </p>
    pub object_tags: std::option::Option<crate::model::ObjectTags>,
}
impl Options {
    /// <p>A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a>. </p>
    /// <p>Default value: POINT_IN_TIME_CONSISTENT.</p>
    /// <p>ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files that were transferred. </p>
    /// <p>POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at the end of the transfer to verify that source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p>
    /// <p>NONE: No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.</p>
    pub fn verify_mode(&self) -> std::option::Option<&crate::model::VerifyMode> {
        self.verify_mode.as_ref()
    }
    /// <p>A value that determines whether files at the destination should be overwritten or preserved when copying files. If set to <code>NEVER</code> a destination file will not be replaced by a source file, even if the destination file differs from the source file. If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes. </p>
    /// <p>Some storage classes have specific behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
    pub fn overwrite_mode(&self) -> std::option::Option<&crate::model::OverwriteMode> {
        self.overwrite_mode.as_ref()
    }
    /// <p>A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to). If you set <code>Atime</code> to BEST_EFFORT, DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code>'s behavior is not fully standard across platforms, so DataSync can only do this on a best-effort basis. </p>
    /// <p>Default value: BEST_EFFORT.</p>
    /// <p>BEST_EFFORT: Attempt to preserve the per-file <code>Atime</code> value (recommended).</p>
    /// <p>NONE: Ignore <code>Atime</code>.</p> <note>
    /// <p>If <code>Atime</code> is set to BEST_EFFORT, <code>Mtime</code> must be set to PRESERVE. </p>
    /// <p>If <code>Atime</code> is set to NONE, <code>Mtime</code> must also be NONE. </p>
    /// </note>
    pub fn atime(&self) -> std::option::Option<&crate::model::Atime> {
        self.atime.as_ref()
    }
    /// <p>A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase. This option is required for cases when you need to run the same task more than one time. </p>
    /// <p>Default Value: <code>PRESERVE</code> </p>
    /// <p>PRESERVE: Preserve original <code>Mtime</code> (recommended)</p>
    /// <p> NONE: Ignore <code>Mtime</code>. </p> <note>
    /// <p>If <code>Mtime</code> is set to PRESERVE, <code>Atime</code> must be set to BEST_EFFORT.</p>
    /// <p>If <code>Mtime</code> is set to NONE, <code>Atime</code> must also be set to NONE. </p>
    /// </note>
    pub fn mtime(&self) -> std::option::Option<&crate::model::Mtime> {
        self.mtime.as_ref()
    }
    /// <p>The POSIX user ID (UID) of the file's owner. This option should only be set for NFS, EFS, and S3 locations. To learn more about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>.</p>
    /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
    /// <p>INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).</p>
    /// <p>NONE: Ignore UID and GID. </p>
    pub fn uid(&self) -> std::option::Option<&crate::model::Uid> {
        self.uid.as_ref()
    }
    /// <p>The POSIX group ID (GID) of the file's owners. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
    /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
    /// <p>INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).</p>
    /// <p>NONE: Ignore UID and GID. </p>
    pub fn gid(&self) -> std::option::Option<&crate::model::Gid> {
        self.gid.as_ref()
    }
    /// <p>A value that specifies whether files in the destination that don't exist in the source file system should be preserved. This option can affect your storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
    /// <p>Default value: PRESERVE.</p>
    /// <p>PRESERVE: Ignore such destination files (recommended). </p>
    /// <p>REMOVE: Delete destination files that aren’t present in the source.</p>
    pub fn preserve_deleted_files(
        &self,
    ) -> std::option::Option<&crate::model::PreserveDeletedFiles> {
        self.preserve_deleted_files.as_ref()
    }
    /// <p>A value that determines whether DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination. DataSync does not copy the contents of such devices, only the name and metadata. </p> <note>
    /// <p>DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.</p>
    /// </note>
    /// <p>Default value: NONE.</p>
    /// <p>NONE: Ignore special devices (recommended). </p>
    /// <p>PRESERVE: Preserve character and block device metadata. This option isn't currently supported for Amazon EFS. </p>
    pub fn preserve_devices(&self) -> std::option::Option<&crate::model::PreserveDevices> {
        self.preserve_devices.as_ref()
    }
    /// <p>A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
    /// <p>Default value: PRESERVE.</p>
    /// <p>PRESERVE: Preserve POSIX-style permissions (recommended).</p>
    /// <p>NONE: Ignore permissions. </p> <note>
    /// <p>DataSync can preserve extant permissions of a source location.</p>
    /// </note>
    pub fn posix_permissions(&self) -> std::option::Option<&crate::model::PosixPermissions> {
        self.posix_permissions.as_ref()
    }
    /// <p>A value that limits the bandwidth used by DataSync. For example, if you want DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (<code>=1024*1024</code>).</p>
    pub fn bytes_per_second(&self) -> std::option::Option<i64> {
        self.bytes_per_second
    }
    /// <p>A value that determines whether tasks should be queued before executing the tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is <code>ENABLED</code>.</p>
    /// <p>If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing task executions</a>.</p>
    pub fn task_queueing(&self) -> std::option::Option<&crate::model::TaskQueueing> {
        self.task_queueing.as_ref()
    }
    /// <p>A value that determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. For more information about providing a log group for DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>. If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes logs on errors for individual files transferred, and <code>TRANSFER</code> publishes logs for every file or object that is transferred and integrity checked.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// <p>A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. </p>
    /// <p>CHANGED: DataSync copies only data or metadata that is new or different content from the source location to the destination location.</p>
    /// <p>ALL: DataSync copies all source location content to the destination, without comparing to existing content on the destination.</p>
    pub fn transfer_mode(&self) -> std::option::Option<&crate::model::TransferMode> {
        self.transfer_mode.as_ref()
    }
    /// <p>A value that determines which components of the SMB security descriptor are copied from source to destination objects. </p>
    /// <p>This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a>. </p>
    /// <p>Default value: OWNER_DACL.</p>
    /// <p> <b>OWNER_DACL</b>: For each copied object, DataSync copies the following metadata:</p>
    /// <ul>
    /// <li> <p>Object owner.</p> </li>
    /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
    /// </ul>
    /// <p>When choosing this option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p>
    /// <p> <b>OWNER_DACL_SACL</b>: For each copied object, DataSync copies the following metadata:</p>
    /// <ul>
    /// <li> <p>Object owner.</p> </li>
    /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
    /// <li> <p>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p> </li>
    /// </ul>
    /// <p>Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
    /// <p> <b>NONE</b>: None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration. </p>
    pub fn security_descriptor_copy_flags(
        &self,
    ) -> std::option::Option<&crate::model::SmbSecurityDescriptorCopyFlags> {
        self.security_descriptor_copy_flags.as_ref()
    }
    /// <p>Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.</p>
    /// <p>Default Value: <code>PRESERVE</code> </p>
    pub fn object_tags(&self) -> std::option::Option<&crate::model::ObjectTags> {
        self.object_tags.as_ref()
    }
}
impl std::fmt::Debug for Options {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Options");
        formatter.field("verify_mode", &self.verify_mode);
        formatter.field("overwrite_mode", &self.overwrite_mode);
        formatter.field("atime", &self.atime);
        formatter.field("mtime", &self.mtime);
        formatter.field("uid", &self.uid);
        formatter.field("gid", &self.gid);
        formatter.field("preserve_deleted_files", &self.preserve_deleted_files);
        formatter.field("preserve_devices", &self.preserve_devices);
        formatter.field("posix_permissions", &self.posix_permissions);
        formatter.field("bytes_per_second", &self.bytes_per_second);
        formatter.field("task_queueing", &self.task_queueing);
        formatter.field("log_level", &self.log_level);
        formatter.field("transfer_mode", &self.transfer_mode);
        formatter.field(
            "security_descriptor_copy_flags",
            &self.security_descriptor_copy_flags,
        );
        formatter.field("object_tags", &self.object_tags);
        formatter.finish()
    }
}
/// See [`Options`](crate::model::Options)
pub mod options {
    /// A builder for [`Options`](crate::model::Options)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) verify_mode: std::option::Option<crate::model::VerifyMode>,
        pub(crate) overwrite_mode: std::option::Option<crate::model::OverwriteMode>,
        pub(crate) atime: std::option::Option<crate::model::Atime>,
        pub(crate) mtime: std::option::Option<crate::model::Mtime>,
        pub(crate) uid: std::option::Option<crate::model::Uid>,
        pub(crate) gid: std::option::Option<crate::model::Gid>,
        pub(crate) preserve_deleted_files: std::option::Option<crate::model::PreserveDeletedFiles>,
        pub(crate) preserve_devices: std::option::Option<crate::model::PreserveDevices>,
        pub(crate) posix_permissions: std::option::Option<crate::model::PosixPermissions>,
        pub(crate) bytes_per_second: std::option::Option<i64>,
        pub(crate) task_queueing: std::option::Option<crate::model::TaskQueueing>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) transfer_mode: std::option::Option<crate::model::TransferMode>,
        pub(crate) security_descriptor_copy_flags:
            std::option::Option<crate::model::SmbSecurityDescriptorCopyFlags>,
        pub(crate) object_tags: std::option::Option<crate::model::ObjectTags>,
    }
    impl Builder {
        /// <p>A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a>. </p>
        /// <p>Default value: POINT_IN_TIME_CONSISTENT.</p>
        /// <p>ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files that were transferred. </p>
        /// <p>POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at the end of the transfer to verify that source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p>
        /// <p>NONE: No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.</p>
        pub fn verify_mode(mut self, input: crate::model::VerifyMode) -> Self {
            self.verify_mode = Some(input);
            self
        }
        /// <p>A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a>. </p>
        /// <p>Default value: POINT_IN_TIME_CONSISTENT.</p>
        /// <p>ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files that were transferred. </p>
        /// <p>POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at the end of the transfer to verify that source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p>
        /// <p>NONE: No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.</p>
        pub fn set_verify_mode(
            mut self,
            input: std::option::Option<crate::model::VerifyMode>,
        ) -> Self {
            self.verify_mode = input;
            self
        }
        /// <p>A value that determines whether files at the destination should be overwritten or preserved when copying files. If set to <code>NEVER</code> a destination file will not be replaced by a source file, even if the destination file differs from the source file. If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes. </p>
        /// <p>Some storage classes have specific behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
        pub fn overwrite_mode(mut self, input: crate::model::OverwriteMode) -> Self {
            self.overwrite_mode = Some(input);
            self
        }
        /// <p>A value that determines whether files at the destination should be overwritten or preserved when copying files. If set to <code>NEVER</code> a destination file will not be replaced by a source file, even if the destination file differs from the source file. If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes. </p>
        /// <p>Some storage classes have specific behaviors that can affect your S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
        pub fn set_overwrite_mode(
            mut self,
            input: std::option::Option<crate::model::OverwriteMode>,
        ) -> Self {
            self.overwrite_mode = input;
            self
        }
        /// <p>A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to). If you set <code>Atime</code> to BEST_EFFORT, DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code>'s behavior is not fully standard across platforms, so DataSync can only do this on a best-effort basis. </p>
        /// <p>Default value: BEST_EFFORT.</p>
        /// <p>BEST_EFFORT: Attempt to preserve the per-file <code>Atime</code> value (recommended).</p>
        /// <p>NONE: Ignore <code>Atime</code>.</p> <note>
        /// <p>If <code>Atime</code> is set to BEST_EFFORT, <code>Mtime</code> must be set to PRESERVE. </p>
        /// <p>If <code>Atime</code> is set to NONE, <code>Mtime</code> must also be NONE. </p>
        /// </note>
        pub fn atime(mut self, input: crate::model::Atime) -> Self {
            self.atime = Some(input);
            self
        }
        /// <p>A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to). If you set <code>Atime</code> to BEST_EFFORT, DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code>'s behavior is not fully standard across platforms, so DataSync can only do this on a best-effort basis. </p>
        /// <p>Default value: BEST_EFFORT.</p>
        /// <p>BEST_EFFORT: Attempt to preserve the per-file <code>Atime</code> value (recommended).</p>
        /// <p>NONE: Ignore <code>Atime</code>.</p> <note>
        /// <p>If <code>Atime</code> is set to BEST_EFFORT, <code>Mtime</code> must be set to PRESERVE. </p>
        /// <p>If <code>Atime</code> is set to NONE, <code>Mtime</code> must also be NONE. </p>
        /// </note>
        pub fn set_atime(mut self, input: std::option::Option<crate::model::Atime>) -> Self {
            self.atime = input;
            self
        }
        /// <p>A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase. This option is required for cases when you need to run the same task more than one time. </p>
        /// <p>Default Value: <code>PRESERVE</code> </p>
        /// <p>PRESERVE: Preserve original <code>Mtime</code> (recommended)</p>
        /// <p> NONE: Ignore <code>Mtime</code>. </p> <note>
        /// <p>If <code>Mtime</code> is set to PRESERVE, <code>Atime</code> must be set to BEST_EFFORT.</p>
        /// <p>If <code>Mtime</code> is set to NONE, <code>Atime</code> must also be set to NONE. </p>
        /// </note>
        pub fn mtime(mut self, input: crate::model::Mtime) -> Self {
            self.mtime = Some(input);
            self
        }
        /// <p>A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase. This option is required for cases when you need to run the same task more than one time. </p>
        /// <p>Default Value: <code>PRESERVE</code> </p>
        /// <p>PRESERVE: Preserve original <code>Mtime</code> (recommended)</p>
        /// <p> NONE: Ignore <code>Mtime</code>. </p> <note>
        /// <p>If <code>Mtime</code> is set to PRESERVE, <code>Atime</code> must be set to BEST_EFFORT.</p>
        /// <p>If <code>Mtime</code> is set to NONE, <code>Atime</code> must also be set to NONE. </p>
        /// </note>
        pub fn set_mtime(mut self, input: std::option::Option<crate::model::Mtime>) -> Self {
            self.mtime = input;
            self
        }
        /// <p>The POSIX user ID (UID) of the file's owner. This option should only be set for NFS, EFS, and S3 locations. To learn more about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>.</p>
        /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
        /// <p>INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).</p>
        /// <p>NONE: Ignore UID and GID. </p>
        pub fn uid(mut self, input: crate::model::Uid) -> Self {
            self.uid = Some(input);
            self
        }
        /// <p>The POSIX user ID (UID) of the file's owner. This option should only be set for NFS, EFS, and S3 locations. To learn more about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>.</p>
        /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
        /// <p>INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).</p>
        /// <p>NONE: Ignore UID and GID. </p>
        pub fn set_uid(mut self, input: std::option::Option<crate::model::Uid>) -> Self {
            self.uid = input;
            self
        }
        /// <p>The POSIX group ID (GID) of the file's owners. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
        /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
        /// <p>INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).</p>
        /// <p>NONE: Ignore UID and GID. </p>
        pub fn gid(mut self, input: crate::model::Gid) -> Self {
            self.gid = Some(input);
            self
        }
        /// <p>The POSIX group ID (GID) of the file's owners. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
        /// <p>Default value: INT_VALUE. This preserves the integer value of the ID.</p>
        /// <p>INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).</p>
        /// <p>NONE: Ignore UID and GID. </p>
        pub fn set_gid(mut self, input: std::option::Option<crate::model::Gid>) -> Self {
            self.gid = input;
            self
        }
        /// <p>A value that specifies whether files in the destination that don't exist in the source file system should be preserved. This option can affect your storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
        /// <p>Default value: PRESERVE.</p>
        /// <p>PRESERVE: Ignore such destination files (recommended). </p>
        /// <p>REMOVE: Delete destination files that aren’t present in the source.</p>
        pub fn preserve_deleted_files(mut self, input: crate::model::PreserveDeletedFiles) -> Self {
            self.preserve_deleted_files = Some(input);
            self
        }
        /// <p>A value that specifies whether files in the destination that don't exist in the source file system should be preserved. This option can affect your storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync User Guide</i>.</p>
        /// <p>Default value: PRESERVE.</p>
        /// <p>PRESERVE: Ignore such destination files (recommended). </p>
        /// <p>REMOVE: Delete destination files that aren’t present in the source.</p>
        pub fn set_preserve_deleted_files(
            mut self,
            input: std::option::Option<crate::model::PreserveDeletedFiles>,
        ) -> Self {
            self.preserve_deleted_files = input;
            self
        }
        /// <p>A value that determines whether DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination. DataSync does not copy the contents of such devices, only the name and metadata. </p> <note>
        /// <p>DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.</p>
        /// </note>
        /// <p>Default value: NONE.</p>
        /// <p>NONE: Ignore special devices (recommended). </p>
        /// <p>PRESERVE: Preserve character and block device metadata. This option isn't currently supported for Amazon EFS. </p>
        pub fn preserve_devices(mut self, input: crate::model::PreserveDevices) -> Self {
            self.preserve_devices = Some(input);
            self
        }
        /// <p>A value that determines whether DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination. DataSync does not copy the contents of such devices, only the name and metadata. </p> <note>
        /// <p>DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.</p>
        /// </note>
        /// <p>Default value: NONE.</p>
        /// <p>NONE: Ignore special devices (recommended). </p>
        /// <p>PRESERVE: Preserve character and block device metadata. This option isn't currently supported for Amazon EFS. </p>
        pub fn set_preserve_devices(
            mut self,
            input: std::option::Option<crate::model::PreserveDevices>,
        ) -> Self {
            self.preserve_devices = input;
            self
        }
        /// <p>A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
        /// <p>Default value: PRESERVE.</p>
        /// <p>PRESERVE: Preserve POSIX-style permissions (recommended).</p>
        /// <p>NONE: Ignore permissions. </p> <note>
        /// <p>DataSync can preserve extant permissions of a source location.</p>
        /// </note>
        pub fn posix_permissions(mut self, input: crate::model::PosixPermissions) -> Self {
            self.posix_permissions = Some(input);
            self
        }
        /// <p>A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. This option should only be set for NFS, EFS, and S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a>. </p>
        /// <p>Default value: PRESERVE.</p>
        /// <p>PRESERVE: Preserve POSIX-style permissions (recommended).</p>
        /// <p>NONE: Ignore permissions. </p> <note>
        /// <p>DataSync can preserve extant permissions of a source location.</p>
        /// </note>
        pub fn set_posix_permissions(
            mut self,
            input: std::option::Option<crate::model::PosixPermissions>,
        ) -> Self {
            self.posix_permissions = input;
            self
        }
        /// <p>A value that limits the bandwidth used by DataSync. For example, if you want DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (<code>=1024*1024</code>).</p>
        pub fn bytes_per_second(mut self, input: i64) -> Self {
            self.bytes_per_second = Some(input);
            self
        }
        /// <p>A value that limits the bandwidth used by DataSync. For example, if you want DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (<code>=1024*1024</code>).</p>
        pub fn set_bytes_per_second(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_per_second = input;
            self
        }
        /// <p>A value that determines whether tasks should be queued before executing the tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is <code>ENABLED</code>.</p>
        /// <p>If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing task executions</a>.</p>
        pub fn task_queueing(mut self, input: crate::model::TaskQueueing) -> Self {
            self.task_queueing = Some(input);
            self
        }
        /// <p>A value that determines whether tasks should be queued before executing the tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is <code>ENABLED</code>.</p>
        /// <p>If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing task executions</a>.</p>
        pub fn set_task_queueing(
            mut self,
            input: std::option::Option<crate::model::TaskQueueing>,
        ) -> Self {
            self.task_queueing = input;
            self
        }
        /// <p>A value that determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. For more information about providing a log group for DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>. If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes logs on errors for individual files transferred, and <code>TRANSFER</code> publishes logs for every file or object that is transferred and integrity checked.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>A value that determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. For more information about providing a log group for DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>. If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes logs on errors for individual files transferred, and <code>TRANSFER</code> publishes logs for every file or object that is transferred and integrity checked.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// <p>A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. </p>
        /// <p>CHANGED: DataSync copies only data or metadata that is new or different content from the source location to the destination location.</p>
        /// <p>ALL: DataSync copies all source location content to the destination, without comparing to existing content on the destination.</p>
        pub fn transfer_mode(mut self, input: crate::model::TransferMode) -> Self {
            self.transfer_mode = Some(input);
            self
        }
        /// <p>A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. </p>
        /// <p>CHANGED: DataSync copies only data or metadata that is new or different content from the source location to the destination location.</p>
        /// <p>ALL: DataSync copies all source location content to the destination, without comparing to existing content on the destination.</p>
        pub fn set_transfer_mode(
            mut self,
            input: std::option::Option<crate::model::TransferMode>,
        ) -> Self {
            self.transfer_mode = input;
            self
        }
        /// <p>A value that determines which components of the SMB security descriptor are copied from source to destination objects. </p>
        /// <p>This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a>. </p>
        /// <p>Default value: OWNER_DACL.</p>
        /// <p> <b>OWNER_DACL</b>: For each copied object, DataSync copies the following metadata:</p>
        /// <ul>
        /// <li> <p>Object owner.</p> </li>
        /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
        /// </ul>
        /// <p>When choosing this option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p>
        /// <p> <b>OWNER_DACL_SACL</b>: For each copied object, DataSync copies the following metadata:</p>
        /// <ul>
        /// <li> <p>Object owner.</p> </li>
        /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
        /// <li> <p>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p> </li>
        /// </ul>
        /// <p>Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
        /// <p> <b>NONE</b>: None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration. </p>
        pub fn security_descriptor_copy_flags(
            mut self,
            input: crate::model::SmbSecurityDescriptorCopyFlags,
        ) -> Self {
            self.security_descriptor_copy_flags = Some(input);
            self
        }
        /// <p>A value that determines which components of the SMB security descriptor are copied from source to destination objects. </p>
        /// <p>This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a>. </p>
        /// <p>Default value: OWNER_DACL.</p>
        /// <p> <b>OWNER_DACL</b>: For each copied object, DataSync copies the following metadata:</p>
        /// <ul>
        /// <li> <p>Object owner.</p> </li>
        /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
        /// </ul>
        /// <p>When choosing this option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p>
        /// <p> <b>OWNER_DACL_SACL</b>: For each copied object, DataSync copies the following metadata:</p>
        /// <ul>
        /// <li> <p>Object owner.</p> </li>
        /// <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li>
        /// <li> <p>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</p> </li>
        /// </ul>
        /// <p>Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="create-smb-location.html#SMBuser">user</a>.</p>
        /// <p> <b>NONE</b>: None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration. </p>
        pub fn set_security_descriptor_copy_flags(
            mut self,
            input: std::option::Option<crate::model::SmbSecurityDescriptorCopyFlags>,
        ) -> Self {
            self.security_descriptor_copy_flags = input;
            self
        }
        /// <p>Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.</p>
        /// <p>Default Value: <code>PRESERVE</code> </p>
        pub fn object_tags(mut self, input: crate::model::ObjectTags) -> Self {
            self.object_tags = Some(input);
            self
        }
        /// <p>Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.</p>
        /// <p>Default Value: <code>PRESERVE</code> </p>
        pub fn set_object_tags(
            mut self,
            input: std::option::Option<crate::model::ObjectTags>,
        ) -> Self {
            self.object_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Options`](crate::model::Options)
        pub fn build(self) -> crate::model::Options {
            crate::model::Options {
                verify_mode: self.verify_mode,
                overwrite_mode: self.overwrite_mode,
                atime: self.atime,
                mtime: self.mtime,
                uid: self.uid,
                gid: self.gid,
                preserve_deleted_files: self.preserve_deleted_files,
                preserve_devices: self.preserve_devices,
                posix_permissions: self.posix_permissions,
                bytes_per_second: self.bytes_per_second,
                task_queueing: self.task_queueing,
                log_level: self.log_level,
                transfer_mode: self.transfer_mode,
                security_descriptor_copy_flags: self.security_descriptor_copy_flags,
                object_tags: self.object_tags,
            }
        }
    }
}
impl Options {
    /// Creates a new builder-style object to manufacture [`Options`](crate::model::Options)
    pub fn builder() -> crate::model::options::Builder {
        crate::model::options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectTags {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Preserve,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectTags {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ObjectTags::None,
            "PRESERVE" => ObjectTags::Preserve,
            other => ObjectTags::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectTags {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectTags::from(s))
    }
}
impl ObjectTags {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectTags::None => "NONE",
            ObjectTags::Preserve => "PRESERVE",
            ObjectTags::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PRESERVE"]
    }
}
impl AsRef<str> for ObjectTags {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmbSecurityDescriptorCopyFlags {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    OwnerDacl,
    #[allow(missing_docs)] // documentation missing in model
    OwnerDaclSacl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmbSecurityDescriptorCopyFlags {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => SmbSecurityDescriptorCopyFlags::None,
            "OWNER_DACL" => SmbSecurityDescriptorCopyFlags::OwnerDacl,
            "OWNER_DACL_SACL" => SmbSecurityDescriptorCopyFlags::OwnerDaclSacl,
            other => SmbSecurityDescriptorCopyFlags::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmbSecurityDescriptorCopyFlags {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmbSecurityDescriptorCopyFlags::from(s))
    }
}
impl SmbSecurityDescriptorCopyFlags {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmbSecurityDescriptorCopyFlags::None => "NONE",
            SmbSecurityDescriptorCopyFlags::OwnerDacl => "OWNER_DACL",
            SmbSecurityDescriptorCopyFlags::OwnerDaclSacl => "OWNER_DACL_SACL",
            SmbSecurityDescriptorCopyFlags::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "OWNER_DACL", "OWNER_DACL_SACL"]
    }
}
impl AsRef<str> for SmbSecurityDescriptorCopyFlags {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransferMode {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Changed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransferMode {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => TransferMode::All,
            "CHANGED" => TransferMode::Changed,
            other => TransferMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransferMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransferMode::from(s))
    }
}
impl TransferMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransferMode::All => "ALL",
            TransferMode::Changed => "CHANGED",
            TransferMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CHANGED"]
    }
}
impl AsRef<str> for TransferMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogLevel {
    #[allow(missing_docs)] // documentation missing in model
    Basic,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    Transfer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogLevel {
    fn from(s: &str) -> Self {
        match s {
            "BASIC" => LogLevel::Basic,
            "OFF" => LogLevel::Off,
            "TRANSFER" => LogLevel::Transfer,
            other => LogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogLevel::from(s))
    }
}
impl LogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogLevel::Basic => "BASIC",
            LogLevel::Off => "OFF",
            LogLevel::Transfer => "TRANSFER",
            LogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BASIC", "OFF", "TRANSFER"]
    }
}
impl AsRef<str> for LogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskQueueing {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskQueueing {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => TaskQueueing::Disabled,
            "ENABLED" => TaskQueueing::Enabled,
            other => TaskQueueing::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskQueueing {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskQueueing::from(s))
    }
}
impl TaskQueueing {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskQueueing::Disabled => "DISABLED",
            TaskQueueing::Enabled => "ENABLED",
            TaskQueueing::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for TaskQueueing {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PosixPermissions {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Preserve,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PosixPermissions {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => PosixPermissions::None,
            "PRESERVE" => PosixPermissions::Preserve,
            other => PosixPermissions::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PosixPermissions {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PosixPermissions::from(s))
    }
}
impl PosixPermissions {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PosixPermissions::None => "NONE",
            PosixPermissions::Preserve => "PRESERVE",
            PosixPermissions::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PRESERVE"]
    }
}
impl AsRef<str> for PosixPermissions {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PreserveDevices {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Preserve,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PreserveDevices {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => PreserveDevices::None,
            "PRESERVE" => PreserveDevices::Preserve,
            other => PreserveDevices::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PreserveDevices {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PreserveDevices::from(s))
    }
}
impl PreserveDevices {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PreserveDevices::None => "NONE",
            PreserveDevices::Preserve => "PRESERVE",
            PreserveDevices::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PRESERVE"]
    }
}
impl AsRef<str> for PreserveDevices {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PreserveDeletedFiles {
    #[allow(missing_docs)] // documentation missing in model
    Preserve,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PreserveDeletedFiles {
    fn from(s: &str) -> Self {
        match s {
            "PRESERVE" => PreserveDeletedFiles::Preserve,
            "REMOVE" => PreserveDeletedFiles::Remove,
            other => PreserveDeletedFiles::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PreserveDeletedFiles {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PreserveDeletedFiles::from(s))
    }
}
impl PreserveDeletedFiles {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PreserveDeletedFiles::Preserve => "PRESERVE",
            PreserveDeletedFiles::Remove => "REMOVE",
            PreserveDeletedFiles::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRESERVE", "REMOVE"]
    }
}
impl AsRef<str> for PreserveDeletedFiles {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Gid {
    #[allow(missing_docs)] // documentation missing in model
    Both,
    #[allow(missing_docs)] // documentation missing in model
    IntValue,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Gid {
    fn from(s: &str) -> Self {
        match s {
            "BOTH" => Gid::Both,
            "INT_VALUE" => Gid::IntValue,
            "NAME" => Gid::Name,
            "NONE" => Gid::None,
            other => Gid::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Gid {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Gid::from(s))
    }
}
impl Gid {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Gid::Both => "BOTH",
            Gid::IntValue => "INT_VALUE",
            Gid::Name => "NAME",
            Gid::None => "NONE",
            Gid::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOTH", "INT_VALUE", "NAME", "NONE"]
    }
}
impl AsRef<str> for Gid {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Uid {
    #[allow(missing_docs)] // documentation missing in model
    Both,
    #[allow(missing_docs)] // documentation missing in model
    IntValue,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Uid {
    fn from(s: &str) -> Self {
        match s {
            "BOTH" => Uid::Both,
            "INT_VALUE" => Uid::IntValue,
            "NAME" => Uid::Name,
            "NONE" => Uid::None,
            other => Uid::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Uid {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Uid::from(s))
    }
}
impl Uid {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Uid::Both => "BOTH",
            Uid::IntValue => "INT_VALUE",
            Uid::Name => "NAME",
            Uid::None => "NONE",
            Uid::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOTH", "INT_VALUE", "NAME", "NONE"]
    }
}
impl AsRef<str> for Uid {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mtime {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Preserve,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mtime {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => Mtime::None,
            "PRESERVE" => Mtime::Preserve,
            other => Mtime::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mtime {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mtime::from(s))
    }
}
impl Mtime {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mtime::None => "NONE",
            Mtime::Preserve => "PRESERVE",
            Mtime::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PRESERVE"]
    }
}
impl AsRef<str> for Mtime {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Atime {
    #[allow(missing_docs)] // documentation missing in model
    BestEffort,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Atime {
    fn from(s: &str) -> Self {
        match s {
            "BEST_EFFORT" => Atime::BestEffort,
            "NONE" => Atime::None,
            other => Atime::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Atime {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Atime::from(s))
    }
}
impl Atime {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Atime::BestEffort => "BEST_EFFORT",
            Atime::None => "NONE",
            Atime::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BEST_EFFORT", "NONE"]
    }
}
impl AsRef<str> for Atime {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OverwriteMode {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OverwriteMode {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => OverwriteMode::Always,
            "NEVER" => OverwriteMode::Never,
            other => OverwriteMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OverwriteMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OverwriteMode::from(s))
    }
}
impl OverwriteMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OverwriteMode::Always => "ALWAYS",
            OverwriteMode::Never => "NEVER",
            OverwriteMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "NEVER"]
    }
}
impl AsRef<str> for OverwriteMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VerifyMode {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    OnlyFilesTransferred,
    #[allow(missing_docs)] // documentation missing in model
    PointInTimeConsistent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VerifyMode {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => VerifyMode::None,
            "ONLY_FILES_TRANSFERRED" => VerifyMode::OnlyFilesTransferred,
            "POINT_IN_TIME_CONSISTENT" => VerifyMode::PointInTimeConsistent,
            other => VerifyMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VerifyMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VerifyMode::from(s))
    }
}
impl VerifyMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VerifyMode::None => "NONE",
            VerifyMode::OnlyFilesTransferred => "ONLY_FILES_TRANSFERRED",
            VerifyMode::PointInTimeConsistent => "POINT_IN_TIME_CONSISTENT",
            VerifyMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "ONLY_FILES_TRANSFERRED", "POINT_IN_TIME_CONSISTENT"]
    }
}
impl AsRef<str> for VerifyMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies which files, folders, and objects to include or exclude when transferring files from source to destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterRule {
    /// <p>The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN rule type.</p>
    pub filter_type: std::option::Option<crate::model::FilterType>,
    /// <p>A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p>
    /// <p> </p>
    pub value: std::option::Option<std::string::String>,
}
impl FilterRule {
    /// <p>The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN rule type.</p>
    pub fn filter_type(&self) -> std::option::Option<&crate::model::FilterType> {
        self.filter_type.as_ref()
    }
    /// <p>A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p>
    /// <p> </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for FilterRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterRule");
        formatter.field("filter_type", &self.filter_type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`FilterRule`](crate::model::FilterRule)
pub mod filter_rule {
    /// A builder for [`FilterRule`](crate::model::FilterRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_type: std::option::Option<crate::model::FilterType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN rule type.</p>
        pub fn filter_type(mut self, input: crate::model::FilterType) -> Self {
            self.filter_type = Some(input);
            self
        }
        /// <p>The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN rule type.</p>
        pub fn set_filter_type(
            mut self,
            input: std::option::Option<crate::model::FilterType>,
        ) -> Self {
            self.filter_type = input;
            self
        }
        /// <p>A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p>
        /// <p> </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p>
        /// <p> </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterRule`](crate::model::FilterRule)
        pub fn build(self) -> crate::model::FilterRule {
            crate::model::FilterRule {
                filter_type: self.filter_type,
                value: self.value,
            }
        }
    }
}
impl FilterRule {
    /// Creates a new builder-style object to manufacture [`FilterRule`](crate::model::FilterRule)
    pub fn builder() -> crate::model::filter_rule::Builder {
        crate::model::filter_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterType {
    #[allow(missing_docs)] // documentation missing in model
    SimplePattern,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterType {
    fn from(s: &str) -> Self {
        match s {
            "SIMPLE_PATTERN" => FilterType::SimplePattern,
            other => FilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterType::from(s))
    }
}
impl FilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterType::SimplePattern => "SIMPLE_PATTERN",
            FilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SIMPLE_PATTERN"]
    }
}
impl AsRef<str> for FilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the schedule you want your task to use for repeated executions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSchedule {
    /// <p>A cron expression that specifies when DataSync initiates a scheduled transfer from a source to a destination location. </p>
    pub schedule_expression: std::option::Option<std::string::String>,
}
impl TaskSchedule {
    /// <p>A cron expression that specifies when DataSync initiates a scheduled transfer from a source to a destination location. </p>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
}
impl std::fmt::Debug for TaskSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSchedule");
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.finish()
    }
}
/// See [`TaskSchedule`](crate::model::TaskSchedule)
pub mod task_schedule {
    /// A builder for [`TaskSchedule`](crate::model::TaskSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cron expression that specifies when DataSync initiates a scheduled transfer from a source to a destination location. </p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A cron expression that specifies when DataSync initiates a scheduled transfer from a source to a destination location. </p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSchedule`](crate::model::TaskSchedule)
        pub fn build(self) -> crate::model::TaskSchedule {
            crate::model::TaskSchedule {
                schedule_expression: self.schedule_expression,
            }
        }
    }
}
impl TaskSchedule {
    /// Creates a new builder-style object to manufacture [`TaskSchedule`](crate::model::TaskSchedule)
    pub fn builder() -> crate::model::task_schedule::Builder {
        crate::model::task_schedule::Builder::default()
    }
}

/// <p>Represents the mount options that are available for DataSync to access an SMB location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmbMountOptions {
    /// <p>The specific SMB version that you want DataSync to use to mount your SMB share. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the SMB server.</p>
    pub version: std::option::Option<crate::model::SmbVersion>,
}
impl SmbMountOptions {
    /// <p>The specific SMB version that you want DataSync to use to mount your SMB share. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the SMB server.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::SmbVersion> {
        self.version.as_ref()
    }
}
impl std::fmt::Debug for SmbMountOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmbMountOptions");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SmbMountOptions`](crate::model::SmbMountOptions)
pub mod smb_mount_options {
    /// A builder for [`SmbMountOptions`](crate::model::SmbMountOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<crate::model::SmbVersion>,
    }
    impl Builder {
        /// <p>The specific SMB version that you want DataSync to use to mount your SMB share. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the SMB server.</p>
        pub fn version(mut self, input: crate::model::SmbVersion) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The specific SMB version that you want DataSync to use to mount your SMB share. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the SMB server.</p>
        pub fn set_version(mut self, input: std::option::Option<crate::model::SmbVersion>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SmbMountOptions`](crate::model::SmbMountOptions)
        pub fn build(self) -> crate::model::SmbMountOptions {
            crate::model::SmbMountOptions {
                version: self.version,
            }
        }
    }
}
impl SmbMountOptions {
    /// Creates a new builder-style object to manufacture [`SmbMountOptions`](crate::model::SmbMountOptions)
    pub fn builder() -> crate::model::smb_mount_options::Builder {
        crate::model::smb_mount_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmbVersion {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    Smb2,
    #[allow(missing_docs)] // documentation missing in model
    Smb3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmbVersion {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => SmbVersion::Automatic,
            "SMB2" => SmbVersion::Smb2,
            "SMB3" => SmbVersion::Smb3,
            other => SmbVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmbVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmbVersion::from(s))
    }
}
impl SmbVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmbVersion::Automatic => "AUTOMATIC",
            SmbVersion::Smb2 => "SMB2",
            SmbVersion::Smb3 => "SMB3",
            SmbVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "SMB2", "SMB3"]
    }
}
impl AsRef<str> for SmbVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectStorageServerProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Https,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectStorageServerProtocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => ObjectStorageServerProtocol::Http,
            "HTTPS" => ObjectStorageServerProtocol::Https,
            other => ObjectStorageServerProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectStorageServerProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectStorageServerProtocol::from(s))
    }
}
impl ObjectStorageServerProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectStorageServerProtocol::Http => "HTTP",
            ObjectStorageServerProtocol::Https => "HTTPS",
            ObjectStorageServerProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "HTTPS"]
    }
}
impl AsRef<str> for ObjectStorageServerProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NfsMountOptions {
    /// <p>The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS server.</p>
    /// <p>You can specify the following NFS versions:</p>
    /// <ul>
    /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for asynchronous writes on the server.</p> </li>
    /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.</p> </li>
    /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available in version 4.0.</p> </li>
    /// </ul>
    pub version: std::option::Option<crate::model::NfsVersion>,
}
impl NfsMountOptions {
    /// <p>The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS server.</p>
    /// <p>You can specify the following NFS versions:</p>
    /// <ul>
    /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for asynchronous writes on the server.</p> </li>
    /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.</p> </li>
    /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available in version 4.0.</p> </li>
    /// </ul>
    pub fn version(&self) -> std::option::Option<&crate::model::NfsVersion> {
        self.version.as_ref()
    }
}
impl std::fmt::Debug for NfsMountOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NfsMountOptions");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`NfsMountOptions`](crate::model::NfsMountOptions)
pub mod nfs_mount_options {
    /// A builder for [`NfsMountOptions`](crate::model::NfsMountOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<crate::model::NfsVersion>,
    }
    impl Builder {
        /// <p>The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS server.</p>
        /// <p>You can specify the following NFS versions:</p>
        /// <ul>
        /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for asynchronous writes on the server.</p> </li>
        /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.</p> </li>
        /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available in version 4.0.</p> </li>
        /// </ul>
        pub fn version(mut self, input: crate::model::NfsVersion) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS server.</p>
        /// <p>You can specify the following NFS versions:</p>
        /// <ul>
        /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for asynchronous writes on the server.</p> </li>
        /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.</p> </li>
        /// <li> <p> <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available in version 4.0.</p> </li>
        /// </ul>
        pub fn set_version(mut self, input: std::option::Option<crate::model::NfsVersion>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`NfsMountOptions`](crate::model::NfsMountOptions)
        pub fn build(self) -> crate::model::NfsMountOptions {
            crate::model::NfsMountOptions {
                version: self.version,
            }
        }
    }
}
impl NfsMountOptions {
    /// Creates a new builder-style object to manufacture [`NfsMountOptions`](crate::model::NfsMountOptions)
    pub fn builder() -> crate::model::nfs_mount_options::Builder {
        crate::model::nfs_mount_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NfsVersion {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    Nfs3,
    #[allow(missing_docs)] // documentation missing in model
    Nfs40,
    #[allow(missing_docs)] // documentation missing in model
    Nfs41,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NfsVersion {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => NfsVersion::Automatic,
            "NFS3" => NfsVersion::Nfs3,
            "NFS4_0" => NfsVersion::Nfs40,
            "NFS4_1" => NfsVersion::Nfs41,
            other => NfsVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NfsVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NfsVersion::from(s))
    }
}
impl NfsVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NfsVersion::Automatic => "AUTOMATIC",
            NfsVersion::Nfs3 => "NFS3",
            NfsVersion::Nfs40 => "NFS4_0",
            NfsVersion::Nfs41 => "NFS4_1",
            NfsVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "NFS3", "NFS4_0", "NFS4_1"]
    }
}
impl AsRef<str> for NfsVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of Amazon Resource Names (ARNs) of agents to use for a Network File System (NFS) location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnPremConfig {
    /// <p>ARNs of the agents to use for an NFS location.</p>
    pub agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl OnPremConfig {
    /// <p>ARNs of the agents to use for an NFS location.</p>
    pub fn agent_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.agent_arns.as_deref()
    }
}
impl std::fmt::Debug for OnPremConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnPremConfig");
        formatter.field("agent_arns", &self.agent_arns);
        formatter.finish()
    }
}
/// See [`OnPremConfig`](crate::model::OnPremConfig)
pub mod on_prem_config {
    /// A builder for [`OnPremConfig`](crate::model::OnPremConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `agent_arns`.
        ///
        /// To override the contents of this collection use [`set_agent_arns`](Self::set_agent_arns).
        ///
        /// <p>ARNs of the agents to use for an NFS location.</p>
        pub fn agent_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.agent_arns.unwrap_or_default();
            v.push(input.into());
            self.agent_arns = Some(v);
            self
        }
        /// <p>ARNs of the agents to use for an NFS location.</p>
        pub fn set_agent_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.agent_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`OnPremConfig`](crate::model::OnPremConfig)
        pub fn build(self) -> crate::model::OnPremConfig {
            crate::model::OnPremConfig {
                agent_arns: self.agent_arns,
            }
        }
    }
}
impl OnPremConfig {
    /// Creates a new builder-style object to manufacture [`OnPremConfig`](crate::model::OnPremConfig)
    pub fn builder() -> crate::model::on_prem_config::Builder {
        crate::model::on_prem_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HdfsAuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    Kerberos,
    #[allow(missing_docs)] // documentation missing in model
    Simple,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HdfsAuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "KERBEROS" => HdfsAuthenticationType::Kerberos,
            "SIMPLE" => HdfsAuthenticationType::Simple,
            other => HdfsAuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HdfsAuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HdfsAuthenticationType::from(s))
    }
}
impl HdfsAuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HdfsAuthenticationType::Kerberos => "KERBEROS",
            HdfsAuthenticationType::Simple => "SIMPLE",
            HdfsAuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KERBEROS", "SIMPLE"]
    }
}
impl AsRef<str> for HdfsAuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QopConfiguration {
    /// <p>The RPC protection setting configured on the HDFS cluster. This setting corresponds to your <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.</p>
    pub rpc_protection: std::option::Option<crate::model::HdfsRpcProtection>,
    /// <p>The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.</p>
    pub data_transfer_protection: std::option::Option<crate::model::HdfsDataTransferProtection>,
}
impl QopConfiguration {
    /// <p>The RPC protection setting configured on the HDFS cluster. This setting corresponds to your <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.</p>
    pub fn rpc_protection(&self) -> std::option::Option<&crate::model::HdfsRpcProtection> {
        self.rpc_protection.as_ref()
    }
    /// <p>The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.</p>
    pub fn data_transfer_protection(
        &self,
    ) -> std::option::Option<&crate::model::HdfsDataTransferProtection> {
        self.data_transfer_protection.as_ref()
    }
}
impl std::fmt::Debug for QopConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QopConfiguration");
        formatter.field("rpc_protection", &self.rpc_protection);
        formatter.field("data_transfer_protection", &self.data_transfer_protection);
        formatter.finish()
    }
}
/// See [`QopConfiguration`](crate::model::QopConfiguration)
pub mod qop_configuration {
    /// A builder for [`QopConfiguration`](crate::model::QopConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rpc_protection: std::option::Option<crate::model::HdfsRpcProtection>,
        pub(crate) data_transfer_protection:
            std::option::Option<crate::model::HdfsDataTransferProtection>,
    }
    impl Builder {
        /// <p>The RPC protection setting configured on the HDFS cluster. This setting corresponds to your <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.</p>
        pub fn rpc_protection(mut self, input: crate::model::HdfsRpcProtection) -> Self {
            self.rpc_protection = Some(input);
            self
        }
        /// <p>The RPC protection setting configured on the HDFS cluster. This setting corresponds to your <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.</p>
        pub fn set_rpc_protection(
            mut self,
            input: std::option::Option<crate::model::HdfsRpcProtection>,
        ) -> Self {
            self.rpc_protection = input;
            self
        }
        /// <p>The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.</p>
        pub fn data_transfer_protection(
            mut self,
            input: crate::model::HdfsDataTransferProtection,
        ) -> Self {
            self.data_transfer_protection = Some(input);
            self
        }
        /// <p>The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.</p>
        pub fn set_data_transfer_protection(
            mut self,
            input: std::option::Option<crate::model::HdfsDataTransferProtection>,
        ) -> Self {
            self.data_transfer_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`QopConfiguration`](crate::model::QopConfiguration)
        pub fn build(self) -> crate::model::QopConfiguration {
            crate::model::QopConfiguration {
                rpc_protection: self.rpc_protection,
                data_transfer_protection: self.data_transfer_protection,
            }
        }
    }
}
impl QopConfiguration {
    /// Creates a new builder-style object to manufacture [`QopConfiguration`](crate::model::QopConfiguration)
    pub fn builder() -> crate::model::qop_configuration::Builder {
        crate::model::qop_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HdfsDataTransferProtection {
    #[allow(missing_docs)] // documentation missing in model
    Authentication,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Integrity,
    #[allow(missing_docs)] // documentation missing in model
    Privacy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HdfsDataTransferProtection {
    fn from(s: &str) -> Self {
        match s {
            "AUTHENTICATION" => HdfsDataTransferProtection::Authentication,
            "DISABLED" => HdfsDataTransferProtection::Disabled,
            "INTEGRITY" => HdfsDataTransferProtection::Integrity,
            "PRIVACY" => HdfsDataTransferProtection::Privacy,
            other => HdfsDataTransferProtection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HdfsDataTransferProtection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HdfsDataTransferProtection::from(s))
    }
}
impl HdfsDataTransferProtection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HdfsDataTransferProtection::Authentication => "AUTHENTICATION",
            HdfsDataTransferProtection::Disabled => "DISABLED",
            HdfsDataTransferProtection::Integrity => "INTEGRITY",
            HdfsDataTransferProtection::Privacy => "PRIVACY",
            HdfsDataTransferProtection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTHENTICATION", "DISABLED", "INTEGRITY", "PRIVACY"]
    }
}
impl AsRef<str> for HdfsDataTransferProtection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HdfsRpcProtection {
    #[allow(missing_docs)] // documentation missing in model
    Authentication,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Integrity,
    #[allow(missing_docs)] // documentation missing in model
    Privacy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HdfsRpcProtection {
    fn from(s: &str) -> Self {
        match s {
            "AUTHENTICATION" => HdfsRpcProtection::Authentication,
            "DISABLED" => HdfsRpcProtection::Disabled,
            "INTEGRITY" => HdfsRpcProtection::Integrity,
            "PRIVACY" => HdfsRpcProtection::Privacy,
            other => HdfsRpcProtection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HdfsRpcProtection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HdfsRpcProtection::from(s))
    }
}
impl HdfsRpcProtection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HdfsRpcProtection::Authentication => "AUTHENTICATION",
            HdfsRpcProtection::Disabled => "DISABLED",
            HdfsRpcProtection::Integrity => "INTEGRITY",
            HdfsRpcProtection::Privacy => "PRIVACY",
            HdfsRpcProtection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTHENTICATION", "DISABLED", "INTEGRITY", "PRIVACY"]
    }
}
impl AsRef<str> for HdfsRpcProtection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages the file system's namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HdfsNameNode {
    /// <p>The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The port that the NameNode uses to listen to client requests.</p>
    pub port: std::option::Option<i32>,
}
impl HdfsNameNode {
    /// <p>The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The port that the NameNode uses to listen to client requests.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
}
impl std::fmt::Debug for HdfsNameNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HdfsNameNode");
        formatter.field("hostname", &self.hostname);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`HdfsNameNode`](crate::model::HdfsNameNode)
pub mod hdfs_name_node {
    /// A builder for [`HdfsNameNode`](crate::model::HdfsNameNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The port that the NameNode uses to listen to client requests.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port that the NameNode uses to listen to client requests.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`HdfsNameNode`](crate::model::HdfsNameNode)
        pub fn build(self) -> crate::model::HdfsNameNode {
            crate::model::HdfsNameNode {
                hostname: self.hostname,
                port: self.port,
            }
        }
    }
}
impl HdfsNameNode {
    /// Creates a new builder-style object to manufacture [`HdfsNameNode`](crate::model::HdfsNameNode)
    pub fn builder() -> crate::model::hdfs_name_node::Builder {
        crate::model::hdfs_name_node::Builder::default()
    }
}

/// <p>Represents a single entry in a list of Amazon Web Services resource tags. <code>TagListEntry</code> returns an array that contains a list of tasks when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTagsForResource.html">ListTagsForResource</a> operation is called.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagListEntry {
    /// <p>The key for an Amazon Web Services resource tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for an Amazon Web Services resource tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl TagListEntry {
    /// <p>The key for an Amazon Web Services resource tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value for an Amazon Web Services resource tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for TagListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagListEntry");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TagListEntry`](crate::model::TagListEntry)
pub mod tag_list_entry {
    /// A builder for [`TagListEntry`](crate::model::TagListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for an Amazon Web Services resource tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for an Amazon Web Services resource tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for an Amazon Web Services resource tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for an Amazon Web Services resource tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TagListEntry`](crate::model::TagListEntry)
        pub fn build(self) -> crate::model::TagListEntry {
            crate::model::TagListEntry {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl TagListEntry {
    /// Creates a new builder-style object to manufacture [`TagListEntry`](crate::model::TagListEntry)
    pub fn builder() -> crate::model::tag_list_entry::Builder {
        crate::model::tag_list_entry::Builder::default()
    }
}

/// <p>Represents a single entry in a list of tasks. <code>TaskListEntry</code> returns an array that contains a list of tasks when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTasks.html">ListTasks</a> operation is called. A task includes the source and destination file systems to sync and the options to use for the tasks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskListEntry {
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The status of the task.</p>
    pub status: std::option::Option<crate::model::TaskStatus>,
    /// <p>The name of the task.</p>
    pub name: std::option::Option<std::string::String>,
}
impl TaskListEntry {
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
    /// <p>The status of the task.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TaskStatus> {
        self.status.as_ref()
    }
    /// <p>The name of the task.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for TaskListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskListEntry");
        formatter.field("task_arn", &self.task_arn);
        formatter.field("status", &self.status);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`TaskListEntry`](crate::model::TaskListEntry)
pub mod task_list_entry {
    /// A builder for [`TaskListEntry`](crate::model::TaskListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The status of the task.</p>
        pub fn status(mut self, input: crate::model::TaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the task.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TaskStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskListEntry`](crate::model::TaskListEntry)
        pub fn build(self) -> crate::model::TaskListEntry {
            crate::model::TaskListEntry {
                task_arn: self.task_arn,
                status: self.status,
                name: self.name,
            }
        }
    }
}
impl TaskListEntry {
    /// Creates a new builder-style object to manufacture [`TaskListEntry`](crate::model::TaskListEntry)
    pub fn builder() -> crate::model::task_list_entry::Builder {
        crate::model::task_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => TaskStatus::Available,
            "CREATING" => TaskStatus::Creating,
            "QUEUED" => TaskStatus::Queued,
            "RUNNING" => TaskStatus::Running,
            "UNAVAILABLE" => TaskStatus::Unavailable,
            other => TaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskStatus::from(s))
    }
}
impl TaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskStatus::Available => "AVAILABLE",
            TaskStatus::Creating => "CREATING",
            TaskStatus::Queued => "QUEUED",
            TaskStatus::Running => "RUNNING",
            TaskStatus::Unavailable => "UNAVAILABLE",
            TaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "CREATING", "QUEUED", "RUNNING", "UNAVAILABLE"]
    }
}
impl AsRef<str> for TaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>. For example, to retrieve all tasks on a source location, you can use <code>ListTasks</code> with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskFilter {
    /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it. For example, <code>LocationId</code> for <code>ListTasks</code>.</p>
    pub name: std::option::Option<crate::model::TaskFilterName>,
    /// <p>The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
    pub operator: std::option::Option<crate::model::Operator>,
}
impl TaskFilter {
    /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it. For example, <code>LocationId</code> for <code>ListTasks</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::TaskFilterName> {
        self.name.as_ref()
    }
    /// <p>The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::Operator> {
        self.operator.as_ref()
    }
}
impl std::fmt::Debug for TaskFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`TaskFilter`](crate::model::TaskFilter)
pub mod task_filter {
    /// A builder for [`TaskFilter`](crate::model::TaskFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::TaskFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::Operator>,
    }
    impl Builder {
        /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it. For example, <code>LocationId</code> for <code>ListTasks</code>.</p>
        pub fn name(mut self, input: crate::model::TaskFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it. For example, <code>LocationId</code> for <code>ListTasks</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::TaskFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
        pub fn operator(mut self, input: crate::model::Operator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
        pub fn set_operator(mut self, input: std::option::Option<crate::model::Operator>) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskFilter`](crate::model::TaskFilter)
        pub fn build(self) -> crate::model::TaskFilter {
            crate::model::TaskFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl TaskFilter {
    /// Creates a new builder-style object to manufacture [`TaskFilter`](crate::model::TaskFilter)
    pub fn builder() -> crate::model::task_filter::Builder {
        crate::model::task_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operator {
    #[allow(missing_docs)] // documentation missing in model
    BeginsWith,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Le,
    #[allow(missing_docs)] // documentation missing in model
    NotContains,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operator {
    fn from(s: &str) -> Self {
        match s {
            "BeginsWith" => Operator::BeginsWith,
            "Contains" => Operator::Contains,
            "Equals" => Operator::Eq,
            "GreaterThan" => Operator::Gt,
            "GreaterThanOrEqual" => Operator::Ge,
            "In" => Operator::In,
            "LessThan" => Operator::Lt,
            "LessThanOrEqual" => Operator::Le,
            "NotContains" => Operator::NotContains,
            "NotEquals" => Operator::Ne,
            other => Operator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operator::from(s))
    }
}
impl Operator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operator::BeginsWith => "BeginsWith",
            Operator::Contains => "Contains",
            Operator::Eq => "Equals",
            Operator::Gt => "GreaterThan",
            Operator::Ge => "GreaterThanOrEqual",
            Operator::In => "In",
            Operator::Lt => "LessThan",
            Operator::Le => "LessThanOrEqual",
            Operator::NotContains => "NotContains",
            Operator::Ne => "NotEquals",
            Operator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BeginsWith",
            "Contains",
            "Equals",
            "GreaterThan",
            "GreaterThanOrEqual",
            "In",
            "LessThan",
            "LessThanOrEqual",
            "NotContains",
            "NotEquals",
        ]
    }
}
impl AsRef<str> for Operator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskFilterName {
    #[allow(missing_docs)] // documentation missing in model
    CreationTime,
    #[allow(missing_docs)] // documentation missing in model
    LocationId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskFilterName {
    fn from(s: &str) -> Self {
        match s {
            "CreationTime" => TaskFilterName::CreationTime,
            "LocationId" => TaskFilterName::LocationId,
            other => TaskFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskFilterName::from(s))
    }
}
impl TaskFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskFilterName::CreationTime => "CreationTime",
            TaskFilterName::LocationId => "LocationId",
            TaskFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CreationTime", "LocationId"]
    }
}
impl AsRef<str> for TaskFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a single entry in a list of task executions. <code>TaskExecutionListEntry</code> returns an array that contains a list of specific invocations of a task when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTaskExecutions.html">ListTaskExecutions</a> operation is called.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskExecutionListEntry {
    /// <p>The Amazon Resource Name (ARN) of the task that was executed.</p>
    pub task_execution_arn: std::option::Option<std::string::String>,
    /// <p>The status of a task execution.</p>
    pub status: std::option::Option<crate::model::TaskExecutionStatus>,
}
impl TaskExecutionListEntry {
    /// <p>The Amazon Resource Name (ARN) of the task that was executed.</p>
    pub fn task_execution_arn(&self) -> std::option::Option<&str> {
        self.task_execution_arn.as_deref()
    }
    /// <p>The status of a task execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TaskExecutionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for TaskExecutionListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskExecutionListEntry");
        formatter.field("task_execution_arn", &self.task_execution_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`TaskExecutionListEntry`](crate::model::TaskExecutionListEntry)
pub mod task_execution_list_entry {
    /// A builder for [`TaskExecutionListEntry`](crate::model::TaskExecutionListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_execution_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskExecutionStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the task that was executed.</p>
        pub fn task_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that was executed.</p>
        pub fn set_task_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_execution_arn = input;
            self
        }
        /// <p>The status of a task execution.</p>
        pub fn status(mut self, input: crate::model::TaskExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a task execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskExecutionListEntry`](crate::model::TaskExecutionListEntry)
        pub fn build(self) -> crate::model::TaskExecutionListEntry {
            crate::model::TaskExecutionListEntry {
                task_execution_arn: self.task_execution_arn,
                status: self.status,
            }
        }
    }
}
impl TaskExecutionListEntry {
    /// Creates a new builder-style object to manufacture [`TaskExecutionListEntry`](crate::model::TaskExecutionListEntry)
    pub fn builder() -> crate::model::task_execution_list_entry::Builder {
        crate::model::task_execution_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Launching,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    Transferring,
    #[allow(missing_docs)] // documentation missing in model
    Verifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => TaskExecutionStatus::Error,
            "LAUNCHING" => TaskExecutionStatus::Launching,
            "PREPARING" => TaskExecutionStatus::Preparing,
            "QUEUED" => TaskExecutionStatus::Queued,
            "SUCCESS" => TaskExecutionStatus::Success,
            "TRANSFERRING" => TaskExecutionStatus::Transferring,
            "VERIFYING" => TaskExecutionStatus::Verifying,
            other => TaskExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskExecutionStatus::from(s))
    }
}
impl TaskExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskExecutionStatus::Error => "ERROR",
            TaskExecutionStatus::Launching => "LAUNCHING",
            TaskExecutionStatus::Preparing => "PREPARING",
            TaskExecutionStatus::Queued => "QUEUED",
            TaskExecutionStatus::Success => "SUCCESS",
            TaskExecutionStatus::Transferring => "TRANSFERRING",
            TaskExecutionStatus::Verifying => "VERIFYING",
            TaskExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ERROR",
            "LAUNCHING",
            "PREPARING",
            "QUEUED",
            "SUCCESS",
            "TRANSFERRING",
            "VERIFYING",
        ]
    }
}
impl AsRef<str> for TaskExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a single entry in a list of locations. <code>LocationListEntry</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocationListEntry {
    /// <p>The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.</p>
    pub location_arn: std::option::Option<std::string::String>,
    /// <p>Represents a list of URIs of a location. <code>LocationUri</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p>
    /// <p>Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.</p>
    /// <p>TYPE designates the type of location (for example, <code>nfs</code> or <code>s3</code>).</p>
    /// <p>GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as <code>myBucket</code>. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).</p>
    /// <p>SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat as the root of the location.</p>
    /// <p></p>
    pub location_uri: std::option::Option<std::string::String>,
}
impl LocationListEntry {
    /// <p>The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.</p>
    pub fn location_arn(&self) -> std::option::Option<&str> {
        self.location_arn.as_deref()
    }
    /// <p>Represents a list of URIs of a location. <code>LocationUri</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p>
    /// <p>Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.</p>
    /// <p>TYPE designates the type of location (for example, <code>nfs</code> or <code>s3</code>).</p>
    /// <p>GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as <code>myBucket</code>. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).</p>
    /// <p>SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat as the root of the location.</p>
    /// <p></p>
    pub fn location_uri(&self) -> std::option::Option<&str> {
        self.location_uri.as_deref()
    }
}
impl std::fmt::Debug for LocationListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocationListEntry");
        formatter.field("location_arn", &self.location_arn);
        formatter.field("location_uri", &self.location_uri);
        formatter.finish()
    }
}
/// See [`LocationListEntry`](crate::model::LocationListEntry)
pub mod location_list_entry {
    /// A builder for [`LocationListEntry`](crate::model::LocationListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_arn: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.</p>
        pub fn location_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.</p>
        pub fn set_location_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_arn = input;
            self
        }
        /// <p>Represents a list of URIs of a location. <code>LocationUri</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p>
        /// <p>Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.</p>
        /// <p>TYPE designates the type of location (for example, <code>nfs</code> or <code>s3</code>).</p>
        /// <p>GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as <code>myBucket</code>. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).</p>
        /// <p>SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat as the root of the location.</p>
        /// <p></p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>Represents a list of URIs of a location. <code>LocationUri</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p>
        /// <p>Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.</p>
        /// <p>TYPE designates the type of location (for example, <code>nfs</code> or <code>s3</code>).</p>
        /// <p>GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as <code>myBucket</code>. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).</p>
        /// <p>SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it's the export path to mount the location. For Amazon S3, it's the prefix path that you mount to and treat as the root of the location.</p>
        /// <p></p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`LocationListEntry`](crate::model::LocationListEntry)
        pub fn build(self) -> crate::model::LocationListEntry {
            crate::model::LocationListEntry {
                location_arn: self.location_arn,
                location_uri: self.location_uri,
            }
        }
    }
}
impl LocationListEntry {
    /// Creates a new builder-style object to manufacture [`LocationListEntry`](crate::model::LocationListEntry)
    pub fn builder() -> crate::model::location_list_entry::Builder {
        crate::model::location_list_entry::Builder::default()
    }
}

/// <p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For example, to retrieve all your Amazon S3 locations, you can use <code>ListLocations</code> with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocationFilter {
    /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it (for example, <code>LocationType</code> for <code>ListLocations</code>).</p>
    pub name: std::option::Option<crate::model::LocationFilterName>,
    /// <p>The values that you want to filter for. For example, you might want to display only Amazon S3 locations.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
    pub operator: std::option::Option<crate::model::Operator>,
}
impl LocationFilter {
    /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it (for example, <code>LocationType</code> for <code>ListLocations</code>).</p>
    pub fn name(&self) -> std::option::Option<&crate::model::LocationFilterName> {
        self.name.as_ref()
    }
    /// <p>The values that you want to filter for. For example, you might want to display only Amazon S3 locations.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::Operator> {
        self.operator.as_ref()
    }
}
impl std::fmt::Debug for LocationFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocationFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`LocationFilter`](crate::model::LocationFilter)
pub mod location_filter {
    /// A builder for [`LocationFilter`](crate::model::LocationFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::LocationFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::Operator>,
    }
    impl Builder {
        /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it (for example, <code>LocationType</code> for <code>ListLocations</code>).</p>
        pub fn name(mut self, input: crate::model::LocationFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the filter being used. Each API call supports a list of filters that are available for it (for example, <code>LocationType</code> for <code>ListLocations</code>).</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::LocationFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values that you want to filter for. For example, you might want to display only Amazon S3 locations.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values that you want to filter for. For example, you might want to display only Amazon S3 locations.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
        pub fn operator(mut self, input: crate::model::Operator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>). For more about API filtering operators, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">API filters for ListTasks and ListLocations</a>.</p>
        pub fn set_operator(mut self, input: std::option::Option<crate::model::Operator>) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`LocationFilter`](crate::model::LocationFilter)
        pub fn build(self) -> crate::model::LocationFilter {
            crate::model::LocationFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl LocationFilter {
    /// Creates a new builder-style object to manufacture [`LocationFilter`](crate::model::LocationFilter)
    pub fn builder() -> crate::model::location_filter::Builder {
        crate::model::location_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocationFilterName {
    #[allow(missing_docs)] // documentation missing in model
    CreationTime,
    #[allow(missing_docs)] // documentation missing in model
    LocationType,
    #[allow(missing_docs)] // documentation missing in model
    LocationUri,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocationFilterName {
    fn from(s: &str) -> Self {
        match s {
            "CreationTime" => LocationFilterName::CreationTime,
            "LocationType" => LocationFilterName::LocationType,
            "LocationUri" => LocationFilterName::LocationUri,
            other => LocationFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocationFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocationFilterName::from(s))
    }
}
impl LocationFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocationFilterName::CreationTime => "CreationTime",
            LocationFilterName::LocationType => "LocationType",
            LocationFilterName::LocationUri => "LocationUri",
            LocationFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CreationTime", "LocationType", "LocationUri"]
    }
}
impl AsRef<str> for LocationFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a single entry in a list of agents. <code>AgentListEntry</code> returns an array that contains a list of agents when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html">ListAgents</a> operation is called.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentListEntry {
    /// <p>The Amazon Resource Name (ARN) of the agent.</p>
    pub agent_arn: std::option::Option<std::string::String>,
    /// <p>The name of the agent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the agent.</p>
    pub status: std::option::Option<crate::model::AgentStatus>,
}
impl AgentListEntry {
    /// <p>The Amazon Resource Name (ARN) of the agent.</p>
    pub fn agent_arn(&self) -> std::option::Option<&str> {
        self.agent_arn.as_deref()
    }
    /// <p>The name of the agent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the agent.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AgentStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AgentListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentListEntry");
        formatter.field("agent_arn", &self.agent_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AgentListEntry`](crate::model::AgentListEntry)
pub mod agent_list_entry {
    /// A builder for [`AgentListEntry`](crate::model::AgentListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AgentStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the agent.</p>
        pub fn agent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the agent.</p>
        pub fn set_agent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_arn = input;
            self
        }
        /// <p>The name of the agent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the agent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the agent.</p>
        pub fn status(mut self, input: crate::model::AgentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the agent.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AgentStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentListEntry`](crate::model::AgentListEntry)
        pub fn build(self) -> crate::model::AgentListEntry {
            crate::model::AgentListEntry {
                agent_arn: self.agent_arn,
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl AgentListEntry {
    /// Creates a new builder-style object to manufacture [`AgentListEntry`](crate::model::AgentListEntry)
    pub fn builder() -> crate::model::agent_list_entry::Builder {
        crate::model::agent_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Offline,
    #[allow(missing_docs)] // documentation missing in model
    Online,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentStatus {
    fn from(s: &str) -> Self {
        match s {
            "OFFLINE" => AgentStatus::Offline,
            "ONLINE" => AgentStatus::Online,
            other => AgentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentStatus::from(s))
    }
}
impl AgentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentStatus::Offline => "OFFLINE",
            AgentStatus::Online => "ONLINE",
            AgentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFFLINE", "ONLINE"]
    }
}
impl AsRef<str> for AgentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the detailed result of a <code>TaskExecution</code> operation. This result includes the time in milliseconds spent in each phase, the status of the task execution, and the errors encountered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskExecutionResultDetail {
    /// <p>The total time in milliseconds that DataSync spent in the PREPARING phase. </p>
    pub prepare_duration: std::option::Option<i64>,
    /// <p>The status of the PREPARING phase.</p>
    pub prepare_status: std::option::Option<crate::model::PhaseStatus>,
    /// <p>The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.</p>
    pub total_duration: std::option::Option<i64>,
    /// <p>The total time in milliseconds that DataSync spent in the TRANSFERRING phase.</p>
    pub transfer_duration: std::option::Option<i64>,
    /// <p>The status of the TRANSFERRING phase.</p>
    pub transfer_status: std::option::Option<crate::model::PhaseStatus>,
    /// <p>The total time in milliseconds that DataSync spent in the VERIFYING phase.</p>
    pub verify_duration: std::option::Option<i64>,
    /// <p>The status of the VERIFYING phase.</p>
    pub verify_status: std::option::Option<crate::model::PhaseStatus>,
    /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
    pub error_detail: std::option::Option<std::string::String>,
}
impl TaskExecutionResultDetail {
    /// <p>The total time in milliseconds that DataSync spent in the PREPARING phase. </p>
    pub fn prepare_duration(&self) -> std::option::Option<i64> {
        self.prepare_duration
    }
    /// <p>The status of the PREPARING phase.</p>
    pub fn prepare_status(&self) -> std::option::Option<&crate::model::PhaseStatus> {
        self.prepare_status.as_ref()
    }
    /// <p>The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.</p>
    pub fn total_duration(&self) -> std::option::Option<i64> {
        self.total_duration
    }
    /// <p>The total time in milliseconds that DataSync spent in the TRANSFERRING phase.</p>
    pub fn transfer_duration(&self) -> std::option::Option<i64> {
        self.transfer_duration
    }
    /// <p>The status of the TRANSFERRING phase.</p>
    pub fn transfer_status(&self) -> std::option::Option<&crate::model::PhaseStatus> {
        self.transfer_status.as_ref()
    }
    /// <p>The total time in milliseconds that DataSync spent in the VERIFYING phase.</p>
    pub fn verify_duration(&self) -> std::option::Option<i64> {
        self.verify_duration
    }
    /// <p>The status of the VERIFYING phase.</p>
    pub fn verify_status(&self) -> std::option::Option<&crate::model::PhaseStatus> {
        self.verify_status.as_ref()
    }
    /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
    pub fn error_detail(&self) -> std::option::Option<&str> {
        self.error_detail.as_deref()
    }
}
impl std::fmt::Debug for TaskExecutionResultDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskExecutionResultDetail");
        formatter.field("prepare_duration", &self.prepare_duration);
        formatter.field("prepare_status", &self.prepare_status);
        formatter.field("total_duration", &self.total_duration);
        formatter.field("transfer_duration", &self.transfer_duration);
        formatter.field("transfer_status", &self.transfer_status);
        formatter.field("verify_duration", &self.verify_duration);
        formatter.field("verify_status", &self.verify_status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_detail", &self.error_detail);
        formatter.finish()
    }
}
/// See [`TaskExecutionResultDetail`](crate::model::TaskExecutionResultDetail)
pub mod task_execution_result_detail {
    /// A builder for [`TaskExecutionResultDetail`](crate::model::TaskExecutionResultDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prepare_duration: std::option::Option<i64>,
        pub(crate) prepare_status: std::option::Option<crate::model::PhaseStatus>,
        pub(crate) total_duration: std::option::Option<i64>,
        pub(crate) transfer_duration: std::option::Option<i64>,
        pub(crate) transfer_status: std::option::Option<crate::model::PhaseStatus>,
        pub(crate) verify_duration: std::option::Option<i64>,
        pub(crate) verify_status: std::option::Option<crate::model::PhaseStatus>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total time in milliseconds that DataSync spent in the PREPARING phase. </p>
        pub fn prepare_duration(mut self, input: i64) -> Self {
            self.prepare_duration = Some(input);
            self
        }
        /// <p>The total time in milliseconds that DataSync spent in the PREPARING phase. </p>
        pub fn set_prepare_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.prepare_duration = input;
            self
        }
        /// <p>The status of the PREPARING phase.</p>
        pub fn prepare_status(mut self, input: crate::model::PhaseStatus) -> Self {
            self.prepare_status = Some(input);
            self
        }
        /// <p>The status of the PREPARING phase.</p>
        pub fn set_prepare_status(
            mut self,
            input: std::option::Option<crate::model::PhaseStatus>,
        ) -> Self {
            self.prepare_status = input;
            self
        }
        /// <p>The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.</p>
        pub fn total_duration(mut self, input: i64) -> Self {
            self.total_duration = Some(input);
            self
        }
        /// <p>The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.</p>
        pub fn set_total_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.total_duration = input;
            self
        }
        /// <p>The total time in milliseconds that DataSync spent in the TRANSFERRING phase.</p>
        pub fn transfer_duration(mut self, input: i64) -> Self {
            self.transfer_duration = Some(input);
            self
        }
        /// <p>The total time in milliseconds that DataSync spent in the TRANSFERRING phase.</p>
        pub fn set_transfer_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.transfer_duration = input;
            self
        }
        /// <p>The status of the TRANSFERRING phase.</p>
        pub fn transfer_status(mut self, input: crate::model::PhaseStatus) -> Self {
            self.transfer_status = Some(input);
            self
        }
        /// <p>The status of the TRANSFERRING phase.</p>
        pub fn set_transfer_status(
            mut self,
            input: std::option::Option<crate::model::PhaseStatus>,
        ) -> Self {
            self.transfer_status = input;
            self
        }
        /// <p>The total time in milliseconds that DataSync spent in the VERIFYING phase.</p>
        pub fn verify_duration(mut self, input: i64) -> Self {
            self.verify_duration = Some(input);
            self
        }
        /// <p>The total time in milliseconds that DataSync spent in the VERIFYING phase.</p>
        pub fn set_verify_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.verify_duration = input;
            self
        }
        /// <p>The status of the VERIFYING phase.</p>
        pub fn verify_status(mut self, input: crate::model::PhaseStatus) -> Self {
            self.verify_status = Some(input);
            self
        }
        /// <p>The status of the VERIFYING phase.</p>
        pub fn set_verify_status(
            mut self,
            input: std::option::Option<crate::model::PhaseStatus>,
        ) -> Self {
            self.verify_status = input;
            self
        }
        /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
        pub fn error_detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_detail = Some(input.into());
            self
        }
        /// <p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>
        pub fn set_error_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskExecutionResultDetail`](crate::model::TaskExecutionResultDetail)
        pub fn build(self) -> crate::model::TaskExecutionResultDetail {
            crate::model::TaskExecutionResultDetail {
                prepare_duration: self.prepare_duration,
                prepare_status: self.prepare_status,
                total_duration: self.total_duration,
                transfer_duration: self.transfer_duration,
                transfer_status: self.transfer_status,
                verify_duration: self.verify_duration,
                verify_status: self.verify_status,
                error_code: self.error_code,
                error_detail: self.error_detail,
            }
        }
    }
}
impl TaskExecutionResultDetail {
    /// Creates a new builder-style object to manufacture [`TaskExecutionResultDetail`](crate::model::TaskExecutionResultDetail)
    pub fn builder() -> crate::model::task_execution_result_detail::Builder {
        crate::model::task_execution_result_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhaseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhaseStatus {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => PhaseStatus::Error,
            "PENDING" => PhaseStatus::Pending,
            "SUCCESS" => PhaseStatus::Success,
            other => PhaseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhaseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhaseStatus::from(s))
    }
}
impl PhaseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhaseStatus::Error => "ERROR",
            PhaseStatus::Pending => "PENDING",
            PhaseStatus::Success => "SUCCESS",
            PhaseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "PENDING", "SUCCESS"]
    }
}
impl AsRef<str> for PhaseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.</p>
/// <p>For detailed information about using such a role, see Creating a Location for Amazon S3 in the <i>DataSync User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Config {
    /// <p>The ARN of the IAM role for accessing the S3 bucket. </p>
    pub bucket_access_role_arn: std::option::Option<std::string::String>,
}
impl S3Config {
    /// <p>The ARN of the IAM role for accessing the S3 bucket. </p>
    pub fn bucket_access_role_arn(&self) -> std::option::Option<&str> {
        self.bucket_access_role_arn.as_deref()
    }
}
impl std::fmt::Debug for S3Config {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Config");
        formatter.field("bucket_access_role_arn", &self.bucket_access_role_arn);
        formatter.finish()
    }
}
/// See [`S3Config`](crate::model::S3Config)
pub mod s3_config {
    /// A builder for [`S3Config`](crate::model::S3Config)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role for accessing the S3 bucket. </p>
        pub fn bucket_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_access_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role for accessing the S3 bucket. </p>
        pub fn set_bucket_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Config`](crate::model::S3Config)
        pub fn build(self) -> crate::model::S3Config {
            crate::model::S3Config {
                bucket_access_role_arn: self.bucket_access_role_arn,
            }
        }
    }
}
impl S3Config {
    /// Creates a new builder-style object to manufacture [`S3Config`](crate::model::S3Config)
    pub fn builder() -> crate::model::s3_config::Builder {
        crate::model::s3_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3StorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    Outposts,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3StorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => S3StorageClass::DeepArchive,
            "GLACIER" => S3StorageClass::Glacier,
            "INTELLIGENT_TIERING" => S3StorageClass::IntelligentTiering,
            "ONEZONE_IA" => S3StorageClass::OnezoneIa,
            "OUTPOSTS" => S3StorageClass::Outposts,
            "STANDARD" => S3StorageClass::Standard,
            "STANDARD_IA" => S3StorageClass::StandardIa,
            other => S3StorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3StorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3StorageClass::from(s))
    }
}
impl S3StorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3StorageClass::DeepArchive => "DEEP_ARCHIVE",
            S3StorageClass::Glacier => "GLACIER",
            S3StorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            S3StorageClass::OnezoneIa => "ONEZONE_IA",
            S3StorageClass::Outposts => "OUTPOSTS",
            S3StorageClass::Standard => "STANDARD",
            S3StorageClass::StandardIa => "STANDARD_IA",
            S3StorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "OUTPOSTS",
            "STANDARD",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for S3StorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the protocol that DataSync uses to access your Amazon FSx for OpenZFS file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FsxProtocol {
    /// <p>Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system.</p>
    pub nfs: std::option::Option<crate::model::FsxProtocolNfs>,
}
impl FsxProtocol {
    /// <p>Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system.</p>
    pub fn nfs(&self) -> std::option::Option<&crate::model::FsxProtocolNfs> {
        self.nfs.as_ref()
    }
}
impl std::fmt::Debug for FsxProtocol {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FsxProtocol");
        formatter.field("nfs", &self.nfs);
        formatter.finish()
    }
}
/// See [`FsxProtocol`](crate::model::FsxProtocol)
pub mod fsx_protocol {
    /// A builder for [`FsxProtocol`](crate::model::FsxProtocol)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nfs: std::option::Option<crate::model::FsxProtocolNfs>,
    }
    impl Builder {
        /// <p>Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system.</p>
        pub fn nfs(mut self, input: crate::model::FsxProtocolNfs) -> Self {
            self.nfs = Some(input);
            self
        }
        /// <p>Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system.</p>
        pub fn set_nfs(mut self, input: std::option::Option<crate::model::FsxProtocolNfs>) -> Self {
            self.nfs = input;
            self
        }
        /// Consumes the builder and constructs a [`FsxProtocol`](crate::model::FsxProtocol)
        pub fn build(self) -> crate::model::FsxProtocol {
            crate::model::FsxProtocol { nfs: self.nfs }
        }
    }
}
impl FsxProtocol {
    /// Creates a new builder-style object to manufacture [`FsxProtocol`](crate::model::FsxProtocol)
    pub fn builder() -> crate::model::fsx_protocol::Builder {
        crate::model::fsx_protocol::Builder::default()
    }
}

/// <p>Represents the Network File System (NFS) protocol that DataSync uses to access your Amazon FSx for OpenZFS file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FsxProtocolNfs {
    /// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
    pub mount_options: std::option::Option<crate::model::NfsMountOptions>,
}
impl FsxProtocolNfs {
    /// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
    pub fn mount_options(&self) -> std::option::Option<&crate::model::NfsMountOptions> {
        self.mount_options.as_ref()
    }
}
impl std::fmt::Debug for FsxProtocolNfs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FsxProtocolNfs");
        formatter.field("mount_options", &self.mount_options);
        formatter.finish()
    }
}
/// See [`FsxProtocolNfs`](crate::model::FsxProtocolNfs)
pub mod fsx_protocol_nfs {
    /// A builder for [`FsxProtocolNfs`](crate::model::FsxProtocolNfs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mount_options: std::option::Option<crate::model::NfsMountOptions>,
    }
    impl Builder {
        /// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
        pub fn mount_options(mut self, input: crate::model::NfsMountOptions) -> Self {
            self.mount_options = Some(input);
            self
        }
        /// <p>Represents the mount options that are available for DataSync to access an NFS location.</p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<crate::model::NfsMountOptions>,
        ) -> Self {
            self.mount_options = input;
            self
        }
        /// Consumes the builder and constructs a [`FsxProtocolNfs`](crate::model::FsxProtocolNfs)
        pub fn build(self) -> crate::model::FsxProtocolNfs {
            crate::model::FsxProtocolNfs {
                mount_options: self.mount_options,
            }
        }
    }
}
impl FsxProtocolNfs {
    /// Creates a new builder-style object to manufacture [`FsxProtocolNfs`](crate::model::FsxProtocolNfs)
    pub fn builder() -> crate::model::fsx_protocol_nfs::Builder {
        crate::model::fsx_protocol_nfs::Builder::default()
    }
}

/// <p>The subnet that DataSync uses to access target EFS file system. The subnet must have at least one mount target for that file system. The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2Config {
    /// <p>The ARN of the subnet that DataSync uses to access the target EFS file system.</p>
    pub subnet_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.</p>
    pub security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Ec2Config {
    /// <p>The ARN of the subnet that DataSync uses to access the target EFS file system.</p>
    pub fn subnet_arn(&self) -> std::option::Option<&str> {
        self.subnet_arn.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.</p>
    pub fn security_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_arns.as_deref()
    }
}
impl std::fmt::Debug for Ec2Config {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2Config");
        formatter.field("subnet_arn", &self.subnet_arn);
        formatter.field("security_group_arns", &self.security_group_arns);
        formatter.finish()
    }
}
/// See [`Ec2Config`](crate::model::Ec2Config)
pub mod ec2_config {
    /// A builder for [`Ec2Config`](crate::model::Ec2Config)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_arn: std::option::Option<std::string::String>,
        pub(crate) security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the subnet that DataSync uses to access the target EFS file system.</p>
        pub fn subnet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the subnet that DataSync uses to access the target EFS file system.</p>
        pub fn set_subnet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_arn = input;
            self
        }
        /// Appends an item to `security_group_arns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_arns.unwrap_or_default();
            v.push(input.into());
            self.security_group_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2Config`](crate::model::Ec2Config)
        pub fn build(self) -> crate::model::Ec2Config {
            crate::model::Ec2Config {
                subnet_arn: self.subnet_arn,
                security_group_arns: self.security_group_arns,
            }
        }
    }
}
impl Ec2Config {
    /// Creates a new builder-style object to manufacture [`Ec2Config`](crate::model::Ec2Config)
    pub fn builder() -> crate::model::ec2_config::Builder {
        crate::model::ec2_config::Builder::default()
    }
}

/// <p>The VPC endpoint, subnet, and security group that an agent uses to access IP addresses in a VPC (Virtual Private Cloud).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateLinkConfig {
    /// <p>The ID of the VPC endpoint that is configured for an agent. An agent that is configured with a VPC endpoint will not be accessible over the public internet.</p>
    pub vpc_endpoint_id: std::option::Option<std::string::String>,
    /// <p>The private endpoint that is configured for an agent that has access to IP addresses in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">PrivateLink</a>. An agent that is configured with this endpoint will not be accessible over the public internet.</p>
    pub private_link_endpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the subnets that are configured for an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
    pub subnet_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the EC2 resource that hosts an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
    pub security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PrivateLinkConfig {
    /// <p>The ID of the VPC endpoint that is configured for an agent. An agent that is configured with a VPC endpoint will not be accessible over the public internet.</p>
    pub fn vpc_endpoint_id(&self) -> std::option::Option<&str> {
        self.vpc_endpoint_id.as_deref()
    }
    /// <p>The private endpoint that is configured for an agent that has access to IP addresses in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">PrivateLink</a>. An agent that is configured with this endpoint will not be accessible over the public internet.</p>
    pub fn private_link_endpoint(&self) -> std::option::Option<&str> {
        self.private_link_endpoint.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the subnets that are configured for an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
    pub fn subnet_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_arns.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the EC2 resource that hosts an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
    pub fn security_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_arns.as_deref()
    }
}
impl std::fmt::Debug for PrivateLinkConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateLinkConfig");
        formatter.field("vpc_endpoint_id", &self.vpc_endpoint_id);
        formatter.field("private_link_endpoint", &self.private_link_endpoint);
        formatter.field("subnet_arns", &self.subnet_arns);
        formatter.field("security_group_arns", &self.security_group_arns);
        formatter.finish()
    }
}
/// See [`PrivateLinkConfig`](crate::model::PrivateLinkConfig)
pub mod private_link_config {
    /// A builder for [`PrivateLinkConfig`](crate::model::PrivateLinkConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) private_link_endpoint: std::option::Option<std::string::String>,
        pub(crate) subnet_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the VPC endpoint that is configured for an agent. An agent that is configured with a VPC endpoint will not be accessible over the public internet.</p>
        pub fn vpc_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC endpoint that is configured for an agent. An agent that is configured with a VPC endpoint will not be accessible over the public internet.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_id = input;
            self
        }
        /// <p>The private endpoint that is configured for an agent that has access to IP addresses in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">PrivateLink</a>. An agent that is configured with this endpoint will not be accessible over the public internet.</p>
        pub fn private_link_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_link_endpoint = Some(input.into());
            self
        }
        /// <p>The private endpoint that is configured for an agent that has access to IP addresses in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">PrivateLink</a>. An agent that is configured with this endpoint will not be accessible over the public internet.</p>
        pub fn set_private_link_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_link_endpoint = input;
            self
        }
        /// Appends an item to `subnet_arns`.
        ///
        /// To override the contents of this collection use [`set_subnet_arns`](Self::set_subnet_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the subnets that are configured for an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
        pub fn subnet_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_arns.unwrap_or_default();
            v.push(input.into());
            self.subnet_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the subnets that are configured for an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
        pub fn set_subnet_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_arns = input;
            self
        }
        /// Appends an item to `security_group_arns`.
        ///
        /// To override the contents of this collection use [`set_security_group_arns`](Self::set_security_group_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the EC2 resource that hosts an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
        pub fn security_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_arns.unwrap_or_default();
            v.push(input.into());
            self.security_group_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the security groups that are configured for the EC2 resource that hosts an agent activated in a VPC or an agent that has access to a VPC endpoint.</p>
        pub fn set_security_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateLinkConfig`](crate::model::PrivateLinkConfig)
        pub fn build(self) -> crate::model::PrivateLinkConfig {
            crate::model::PrivateLinkConfig {
                vpc_endpoint_id: self.vpc_endpoint_id,
                private_link_endpoint: self.private_link_endpoint,
                subnet_arns: self.subnet_arns,
                security_group_arns: self.security_group_arns,
            }
        }
    }
}
impl PrivateLinkConfig {
    /// Creates a new builder-style object to manufacture [`PrivateLinkConfig`](crate::model::PrivateLinkConfig)
    pub fn builder() -> crate::model::private_link_config::Builder {
        crate::model::private_link_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Fips,
    #[allow(missing_docs)] // documentation missing in model
    PrivateLink,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointType {
    fn from(s: &str) -> Self {
        match s {
            "FIPS" => EndpointType::Fips,
            "PRIVATE_LINK" => EndpointType::PrivateLink,
            "PUBLIC" => EndpointType::Public,
            other => EndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointType::from(s))
    }
}
impl EndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointType::Fips => "FIPS",
            EndpointType::PrivateLink => "PRIVATE_LINK",
            EndpointType::Public => "PUBLIC",
            EndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FIPS", "PRIVATE_LINK", "PUBLIC"]
    }
}
impl AsRef<str> for EndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
