// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelTaskExecutionError {
    /// Kind of error that occurred.
    pub kind: CancelTaskExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelTaskExecutionErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelTaskExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelTaskExecutionErrorKind::InternalException(_inner) => _inner.fmt(f),
            CancelTaskExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelTaskExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelTaskExecutionError {
    fn code(&self) -> Option<&str> {
        CancelTaskExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelTaskExecutionError {
    /// Creates a new `CancelTaskExecutionError`.
    pub fn new(kind: CancelTaskExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelTaskExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelTaskExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelTaskExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelTaskExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelTaskExecutionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelTaskExecutionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelTaskExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelTaskExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CancelTaskExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelTaskExecutionErrorKind::InternalException(_inner) => Some(_inner),
            CancelTaskExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelTaskExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAgentError {
    /// Kind of error that occurred.
    pub kind: CreateAgentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAgentErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAgentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAgentErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateAgentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAgentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAgentError {
    fn code(&self) -> Option<&str> {
        CreateAgentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAgentError {
    /// Creates a new `CreateAgentError`.
    pub fn new(kind: CreateAgentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAgentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAgentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAgentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAgentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAgentErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateAgentErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateAgentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAgentErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for CreateAgentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAgentErrorKind::InternalException(_inner) => Some(_inner),
            CreateAgentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAgentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationEfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationEfsError {
    /// Kind of error that occurred.
    pub kind: CreateLocationEfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationEfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationEfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationEfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationEfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationEfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationEfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationEfsError {
    fn code(&self) -> Option<&str> {
        CreateLocationEfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationEfsError {
    /// Creates a new `CreateLocationEfsError`.
    pub fn new(kind: CreateLocationEfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationEfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationEfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationEfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationEfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationEfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateLocationEfsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateLocationEfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationEfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationEfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationEfsErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationEfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationEfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationFsxLustre` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationFsxLustreError {
    /// Kind of error that occurred.
    pub kind: CreateLocationFsxLustreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationFsxLustre` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationFsxLustreErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationFsxLustreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationFsxLustreErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationFsxLustreErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationFsxLustreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationFsxLustreError {
    fn code(&self) -> Option<&str> {
        CreateLocationFsxLustreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationFsxLustreError {
    /// Creates a new `CreateLocationFsxLustreError`.
    pub fn new(kind: CreateLocationFsxLustreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationFsxLustreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationFsxLustreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationFsxLustreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationFsxLustreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationFsxLustreErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationFsxLustreErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLocationFsxLustreErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationFsxLustreErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationFsxLustreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationFsxLustreErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationFsxLustreErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationFsxLustreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationFsxOpenZfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationFsxOpenZfsError {
    /// Kind of error that occurred.
    pub kind: CreateLocationFsxOpenZfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationFsxOpenZfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationFsxOpenZfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationFsxOpenZfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationFsxOpenZfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationFsxOpenZfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationFsxOpenZfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationFsxOpenZfsError {
    fn code(&self) -> Option<&str> {
        CreateLocationFsxOpenZfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationFsxOpenZfsError {
    /// Creates a new `CreateLocationFsxOpenZfsError`.
    pub fn new(kind: CreateLocationFsxOpenZfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationFsxOpenZfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationFsxOpenZfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationFsxOpenZfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationFsxOpenZfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationFsxOpenZfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationFsxOpenZfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLocationFsxOpenZfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationFsxOpenZfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationFsxOpenZfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationFsxOpenZfsErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationFsxOpenZfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationFsxOpenZfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationFsxWindows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationFsxWindowsError {
    /// Kind of error that occurred.
    pub kind: CreateLocationFsxWindowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationFsxWindows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationFsxWindowsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationFsxWindowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationFsxWindowsErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationFsxWindowsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationFsxWindowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationFsxWindowsError {
    fn code(&self) -> Option<&str> {
        CreateLocationFsxWindowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationFsxWindowsError {
    /// Creates a new `CreateLocationFsxWindowsError`.
    pub fn new(kind: CreateLocationFsxWindowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationFsxWindowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationFsxWindowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationFsxWindowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationFsxWindowsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationFsxWindowsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationFsxWindowsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLocationFsxWindowsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationFsxWindowsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationFsxWindowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationFsxWindowsErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationFsxWindowsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationFsxWindowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationHdfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationHdfsError {
    /// Kind of error that occurred.
    pub kind: CreateLocationHdfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationHdfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationHdfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationHdfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationHdfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationHdfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationHdfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationHdfsError {
    fn code(&self) -> Option<&str> {
        CreateLocationHdfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationHdfsError {
    /// Creates a new `CreateLocationHdfsError`.
    pub fn new(kind: CreateLocationHdfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationHdfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationHdfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationHdfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationHdfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationHdfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationHdfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLocationHdfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationHdfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationHdfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationHdfsErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationHdfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationHdfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationNfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationNfsError {
    /// Kind of error that occurred.
    pub kind: CreateLocationNfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationNfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationNfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationNfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationNfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationNfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationNfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationNfsError {
    fn code(&self) -> Option<&str> {
        CreateLocationNfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationNfsError {
    /// Creates a new `CreateLocationNfsError`.
    pub fn new(kind: CreateLocationNfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationNfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationNfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationNfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationNfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationNfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateLocationNfsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateLocationNfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationNfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationNfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationNfsErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationNfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationNfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationObjectStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationObjectStorageError {
    /// Kind of error that occurred.
    pub kind: CreateLocationObjectStorageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationObjectStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationObjectStorageErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationObjectStorageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationObjectStorageErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationObjectStorageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationObjectStorageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationObjectStorageError {
    fn code(&self) -> Option<&str> {
        CreateLocationObjectStorageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationObjectStorageError {
    /// Creates a new `CreateLocationObjectStorageError`.
    pub fn new(kind: CreateLocationObjectStorageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationObjectStorageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationObjectStorageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationObjectStorageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationObjectStorageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationObjectStorageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationObjectStorageErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLocationObjectStorageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationObjectStorageErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationObjectStorageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationObjectStorageErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationObjectStorageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationObjectStorageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationS3Error {
    /// Kind of error that occurred.
    pub kind: CreateLocationS3ErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationS3ErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationS3Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationS3ErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationS3ErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationS3ErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationS3Error {
    fn code(&self) -> Option<&str> {
        CreateLocationS3Error::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationS3Error {
    /// Creates a new `CreateLocationS3Error`.
    pub fn new(kind: CreateLocationS3ErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationS3Error::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationS3ErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationS3Error::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationS3ErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationS3ErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateLocationS3ErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateLocationS3ErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationS3ErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationS3Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationS3ErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationS3ErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationS3ErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLocationSmb` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLocationSmbError {
    /// Kind of error that occurred.
    pub kind: CreateLocationSmbErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLocationSmb` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLocationSmbErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLocationSmbError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLocationSmbErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateLocationSmbErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLocationSmbErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLocationSmbError {
    fn code(&self) -> Option<&str> {
        CreateLocationSmbError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLocationSmbError {
    /// Creates a new `CreateLocationSmbError`.
    pub fn new(kind: CreateLocationSmbErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLocationSmbError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLocationSmbErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLocationSmbError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLocationSmbErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLocationSmbErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateLocationSmbErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateLocationSmbErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLocationSmbErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLocationSmbError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLocationSmbErrorKind::InternalException(_inner) => Some(_inner),
            CreateLocationSmbErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLocationSmbErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTaskError {
    /// Kind of error that occurred.
    pub kind: CreateTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTaskErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTaskErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateTaskErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTaskError {
    fn code(&self) -> Option<&str> {
        CreateTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTaskError {
    /// Creates a new `CreateTaskError`.
    pub fn new(kind: CreateTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTaskErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateTaskErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateTaskErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for CreateTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTaskErrorKind::InternalException(_inner) => Some(_inner),
            CreateTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAgentError {
    /// Kind of error that occurred.
    pub kind: DeleteAgentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAgentErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAgentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAgentErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteAgentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAgentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAgentError {
    fn code(&self) -> Option<&str> {
        DeleteAgentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAgentError {
    /// Creates a new `DeleteAgentError`.
    pub fn new(kind: DeleteAgentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAgentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAgentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAgentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAgentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAgentErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteAgentErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteAgentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAgentErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for DeleteAgentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAgentErrorKind::InternalException(_inner) => Some(_inner),
            DeleteAgentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAgentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLocationError {
    /// Kind of error that occurred.
    pub kind: DeleteLocationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLocationErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLocationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLocationErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteLocationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteLocationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLocationError {
    fn code(&self) -> Option<&str> {
        DeleteLocationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLocationError {
    /// Creates a new `DeleteLocationError`.
    pub fn new(kind: DeleteLocationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLocationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLocationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLocationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLocationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLocationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteLocationErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteLocationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLocationErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteLocationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLocationErrorKind::InternalException(_inner) => Some(_inner),
            DeleteLocationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteLocationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTaskError {
    /// Kind of error that occurred.
    pub kind: DeleteTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTaskErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTaskErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteTaskErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTaskError {
    fn code(&self) -> Option<&str> {
        DeleteTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTaskError {
    /// Creates a new `DeleteTaskError`.
    pub fn new(kind: DeleteTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTaskErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteTaskErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteTaskErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for DeleteTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTaskErrorKind::InternalException(_inner) => Some(_inner),
            DeleteTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAgentError {
    /// Kind of error that occurred.
    pub kind: DescribeAgentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAgentErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAgentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAgentErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeAgentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAgentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAgentError {
    fn code(&self) -> Option<&str> {
        DescribeAgentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAgentError {
    /// Creates a new `DescribeAgentError`.
    pub fn new(kind: DescribeAgentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAgentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAgentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAgentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAgentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAgentErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeAgentErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeAgentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAgentErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeAgentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAgentErrorKind::InternalException(_inner) => Some(_inner),
            DescribeAgentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAgentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationEfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationEfsError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationEfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationEfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationEfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationEfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationEfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationEfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationEfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationEfsError {
    fn code(&self) -> Option<&str> {
        DescribeLocationEfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationEfsError {
    /// Creates a new `DescribeLocationEfsError`.
    pub fn new(kind: DescribeLocationEfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationEfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationEfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationEfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationEfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationEfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationEfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationEfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationEfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationEfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationEfsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationEfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationEfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationFsxLustre` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationFsxLustreError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationFsxLustreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationFsxLustre` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationFsxLustreErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationFsxLustreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationFsxLustreErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationFsxLustreErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationFsxLustreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationFsxLustreError {
    fn code(&self) -> Option<&str> {
        DescribeLocationFsxLustreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationFsxLustreError {
    /// Creates a new `DescribeLocationFsxLustreError`.
    pub fn new(kind: DescribeLocationFsxLustreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationFsxLustreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationFsxLustreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationFsxLustreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationFsxLustreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationFsxLustreErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationFsxLustreErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationFsxLustreErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationFsxLustreErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationFsxLustreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationFsxLustreErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationFsxLustreErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationFsxLustreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationFsxOpenZfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationFsxOpenZfsError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationFsxOpenZfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationFsxOpenZfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationFsxOpenZfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationFsxOpenZfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationFsxOpenZfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationFsxOpenZfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationFsxOpenZfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationFsxOpenZfsError {
    fn code(&self) -> Option<&str> {
        DescribeLocationFsxOpenZfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationFsxOpenZfsError {
    /// Creates a new `DescribeLocationFsxOpenZfsError`.
    pub fn new(kind: DescribeLocationFsxOpenZfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationFsxOpenZfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationFsxOpenZfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationFsxOpenZfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationFsxOpenZfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationFsxOpenZfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationFsxOpenZfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationFsxOpenZfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationFsxOpenZfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationFsxOpenZfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationFsxOpenZfsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationFsxOpenZfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationFsxOpenZfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationFsxWindows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationFsxWindowsError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationFsxWindowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationFsxWindows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationFsxWindowsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationFsxWindowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationFsxWindowsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationFsxWindowsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationFsxWindowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationFsxWindowsError {
    fn code(&self) -> Option<&str> {
        DescribeLocationFsxWindowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationFsxWindowsError {
    /// Creates a new `DescribeLocationFsxWindowsError`.
    pub fn new(kind: DescribeLocationFsxWindowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationFsxWindowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationFsxWindowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationFsxWindowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationFsxWindowsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationFsxWindowsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationFsxWindowsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationFsxWindowsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationFsxWindowsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationFsxWindowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationFsxWindowsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationFsxWindowsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationFsxWindowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationHdfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationHdfsError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationHdfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationHdfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationHdfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationHdfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationHdfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationHdfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationHdfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationHdfsError {
    fn code(&self) -> Option<&str> {
        DescribeLocationHdfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationHdfsError {
    /// Creates a new `DescribeLocationHdfsError`.
    pub fn new(kind: DescribeLocationHdfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationHdfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationHdfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationHdfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationHdfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationHdfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationHdfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationHdfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationHdfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationHdfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationHdfsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationHdfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationHdfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationNfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationNfsError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationNfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationNfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationNfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationNfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationNfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationNfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationNfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationNfsError {
    fn code(&self) -> Option<&str> {
        DescribeLocationNfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationNfsError {
    /// Creates a new `DescribeLocationNfsError`.
    pub fn new(kind: DescribeLocationNfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationNfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationNfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationNfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationNfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationNfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationNfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationNfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationNfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationNfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationNfsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationNfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationNfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationObjectStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationObjectStorageError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationObjectStorageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationObjectStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationObjectStorageErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationObjectStorageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationObjectStorageErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationObjectStorageErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeLocationObjectStorageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationObjectStorageError {
    fn code(&self) -> Option<&str> {
        DescribeLocationObjectStorageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationObjectStorageError {
    /// Creates a new `DescribeLocationObjectStorageError`.
    pub fn new(
        kind: DescribeLocationObjectStorageErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationObjectStorageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationObjectStorageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationObjectStorageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationObjectStorageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationObjectStorageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationObjectStorageErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationObjectStorageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationObjectStorageErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationObjectStorageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationObjectStorageErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationObjectStorageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationObjectStorageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationS3Error {
    /// Kind of error that occurred.
    pub kind: DescribeLocationS3ErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationS3ErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationS3Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationS3ErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationS3ErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationS3ErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationS3Error {
    fn code(&self) -> Option<&str> {
        DescribeLocationS3Error::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationS3Error {
    /// Creates a new `DescribeLocationS3Error`.
    pub fn new(kind: DescribeLocationS3ErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationS3Error::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationS3ErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationS3Error::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationS3ErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationS3ErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationS3ErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationS3ErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationS3ErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationS3Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationS3ErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationS3ErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationS3ErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLocationSmb` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLocationSmbError {
    /// Kind of error that occurred.
    pub kind: DescribeLocationSmbErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLocationSmb` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLocationSmbErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLocationSmbError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLocationSmbErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeLocationSmbErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLocationSmbErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLocationSmbError {
    fn code(&self) -> Option<&str> {
        DescribeLocationSmbError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLocationSmbError {
    /// Creates a new `DescribeLocationSmbError`.
    pub fn new(kind: DescribeLocationSmbErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLocationSmbError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLocationSmbErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLocationSmbError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLocationSmbErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLocationSmbErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationSmbErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLocationSmbErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLocationSmbErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLocationSmbError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLocationSmbErrorKind::InternalException(_inner) => Some(_inner),
            DescribeLocationSmbErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLocationSmbErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTaskError {
    /// Kind of error that occurred.
    pub kind: DescribeTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTaskErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTaskErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeTaskErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTaskError {
    fn code(&self) -> Option<&str> {
        DescribeTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTaskError {
    /// Creates a new `DescribeTaskError`.
    pub fn new(kind: DescribeTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTaskErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeTaskErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTaskErrorKind::InternalException(_inner) => Some(_inner),
            DescribeTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTaskExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeTaskExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTaskExecutionErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTaskExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTaskExecutionErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeTaskExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeTaskExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTaskExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeTaskExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTaskExecutionError {
    /// Creates a new `DescribeTaskExecutionError`.
    pub fn new(kind: DescribeTaskExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTaskExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTaskExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTaskExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTaskExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTaskExecutionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskExecutionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeTaskExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTaskExecutionErrorKind::InternalException(_inner) => Some(_inner),
            DescribeTaskExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeTaskExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAgents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAgentsError {
    /// Kind of error that occurred.
    pub kind: ListAgentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAgents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAgentsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAgentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAgentsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListAgentsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAgentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAgentsError {
    fn code(&self) -> Option<&str> {
        ListAgentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAgentsError {
    /// Creates a new `ListAgentsError`.
    pub fn new(kind: ListAgentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAgentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAgentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAgentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAgentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAgentsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListAgentsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListAgentsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListAgentsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ListAgentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAgentsErrorKind::InternalException(_inner) => Some(_inner),
            ListAgentsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAgentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLocationsError {
    /// Kind of error that occurred.
    pub kind: ListLocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLocationsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLocationsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListLocationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListLocationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLocationsError {
    fn code(&self) -> Option<&str> {
        ListLocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLocationsError {
    /// Creates a new `ListLocationsError`.
    pub fn new(kind: ListLocationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLocationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLocationsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListLocationsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListLocationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLocationsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListLocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLocationsErrorKind::InternalException(_inner) => Some(_inner),
            ListLocationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListLocationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTaskExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTaskExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListTaskExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTaskExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTaskExecutionsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTaskExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTaskExecutionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTaskExecutionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTaskExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTaskExecutionsError {
    fn code(&self) -> Option<&str> {
        ListTaskExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTaskExecutionsError {
    /// Creates a new `ListTaskExecutionsError`.
    pub fn new(kind: ListTaskExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTaskExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTaskExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTaskExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTaskExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTaskExecutionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTaskExecutionsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTaskExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTaskExecutionsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListTaskExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTaskExecutionsErrorKind::InternalException(_inner) => Some(_inner),
            ListTaskExecutionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTaskExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTasksError {
    /// Kind of error that occurred.
    pub kind: ListTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTasksErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTasksErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTasksError {
    fn code(&self) -> Option<&str> {
        ListTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTasksError {
    /// Creates a new `ListTasksError`.
    pub fn new(kind: ListTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ListTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTasksErrorKind::InternalException(_inner) => Some(_inner),
            ListTasksErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTaskExecutionError {
    /// Kind of error that occurred.
    pub kind: StartTaskExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTaskExecutionErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTaskExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTaskExecutionErrorKind::InternalException(_inner) => _inner.fmt(f),
            StartTaskExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartTaskExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTaskExecutionError {
    fn code(&self) -> Option<&str> {
        StartTaskExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTaskExecutionError {
    /// Creates a new `StartTaskExecutionError`.
    pub fn new(kind: StartTaskExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTaskExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTaskExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTaskExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTaskExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTaskExecutionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskExecutionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTaskExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for StartTaskExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTaskExecutionErrorKind::InternalException(_inner) => Some(_inner),
            StartTaskExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartTaskExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAgentError {
    /// Kind of error that occurred.
    pub kind: UpdateAgentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAgentErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAgentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAgentErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateAgentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAgentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAgentError {
    fn code(&self) -> Option<&str> {
        UpdateAgentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAgentError {
    /// Creates a new `UpdateAgentError`.
    pub fn new(kind: UpdateAgentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAgentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAgentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAgentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAgentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAgentErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateAgentErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateAgentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateAgentErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for UpdateAgentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAgentErrorKind::InternalException(_inner) => Some(_inner),
            UpdateAgentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAgentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLocationHdfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLocationHdfsError {
    /// Kind of error that occurred.
    pub kind: UpdateLocationHdfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLocationHdfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLocationHdfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLocationHdfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLocationHdfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateLocationHdfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateLocationHdfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLocationHdfsError {
    fn code(&self) -> Option<&str> {
        UpdateLocationHdfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLocationHdfsError {
    /// Creates a new `UpdateLocationHdfsError`.
    pub fn new(kind: UpdateLocationHdfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLocationHdfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLocationHdfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLocationHdfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLocationHdfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLocationHdfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLocationHdfsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLocationHdfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLocationHdfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateLocationHdfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLocationHdfsErrorKind::InternalException(_inner) => Some(_inner),
            UpdateLocationHdfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateLocationHdfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLocationNfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLocationNfsError {
    /// Kind of error that occurred.
    pub kind: UpdateLocationNfsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLocationNfs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLocationNfsErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLocationNfsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLocationNfsErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateLocationNfsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateLocationNfsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLocationNfsError {
    fn code(&self) -> Option<&str> {
        UpdateLocationNfsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLocationNfsError {
    /// Creates a new `UpdateLocationNfsError`.
    pub fn new(kind: UpdateLocationNfsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLocationNfsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLocationNfsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLocationNfsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLocationNfsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLocationNfsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateLocationNfsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateLocationNfsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLocationNfsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateLocationNfsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLocationNfsErrorKind::InternalException(_inner) => Some(_inner),
            UpdateLocationNfsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateLocationNfsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLocationObjectStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLocationObjectStorageError {
    /// Kind of error that occurred.
    pub kind: UpdateLocationObjectStorageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLocationObjectStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLocationObjectStorageErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLocationObjectStorageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLocationObjectStorageErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateLocationObjectStorageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateLocationObjectStorageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLocationObjectStorageError {
    fn code(&self) -> Option<&str> {
        UpdateLocationObjectStorageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLocationObjectStorageError {
    /// Creates a new `UpdateLocationObjectStorageError`.
    pub fn new(kind: UpdateLocationObjectStorageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLocationObjectStorageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLocationObjectStorageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLocationObjectStorageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLocationObjectStorageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLocationObjectStorageErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLocationObjectStorageErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLocationObjectStorageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLocationObjectStorageErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateLocationObjectStorageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLocationObjectStorageErrorKind::InternalException(_inner) => Some(_inner),
            UpdateLocationObjectStorageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateLocationObjectStorageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLocationSmb` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLocationSmbError {
    /// Kind of error that occurred.
    pub kind: UpdateLocationSmbErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLocationSmb` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLocationSmbErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLocationSmbError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLocationSmbErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateLocationSmbErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateLocationSmbErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLocationSmbError {
    fn code(&self) -> Option<&str> {
        UpdateLocationSmbError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLocationSmbError {
    /// Creates a new `UpdateLocationSmbError`.
    pub fn new(kind: UpdateLocationSmbErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLocationSmbError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLocationSmbErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLocationSmbError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLocationSmbErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLocationSmbErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateLocationSmbErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateLocationSmbErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLocationSmbErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateLocationSmbError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLocationSmbErrorKind::InternalException(_inner) => Some(_inner),
            UpdateLocationSmbErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateLocationSmbErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTaskError {
    /// Kind of error that occurred.
    pub kind: UpdateTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTaskErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTaskErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateTaskErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTaskError {
    fn code(&self) -> Option<&str> {
        UpdateTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTaskError {
    /// Creates a new `UpdateTaskError`.
    pub fn new(kind: UpdateTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTaskErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateTaskErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateTaskErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for UpdateTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTaskErrorKind::InternalException(_inner) => Some(_inner),
            UpdateTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTaskExecutionError {
    /// Kind of error that occurred.
    pub kind: UpdateTaskExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTaskExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTaskExecutionErrorKind {
    /// <p>This exception is thrown when an error occurs in the DataSync service.</p>
    InternalException(crate::error::InternalException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTaskExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTaskExecutionErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateTaskExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateTaskExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTaskExecutionError {
    fn code(&self) -> Option<&str> {
        UpdateTaskExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTaskExecutionError {
    /// Creates a new `UpdateTaskExecutionError`.
    pub fn new(kind: UpdateTaskExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTaskExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTaskExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTaskExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTaskExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTaskExecutionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskExecutionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTaskExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateTaskExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTaskExecutionErrorKind::InternalException(_inner) => Some(_inner),
            UpdateTaskExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateTaskExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>This exception is thrown when the client submits a malformed request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub datasync_error_code: std::option::Option<std::string::String>,
}
impl InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn datasync_error_code(&self) -> std::option::Option<&str> {
        self.datasync_error_code.as_deref()
    }
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.field("datasync_error_code", &self.datasync_error_code);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) datasync_error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn datasync_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.datasync_error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_datasync_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datasync_error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
                error_code: self.error_code,
                datasync_error_code: self.datasync_error_code,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>This exception is thrown when an error occurs in the DataSync service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_code: std::option::Option<std::string::String>,
}
impl InternalException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.finish()
    }
}
impl InternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalException {}
/// See [`InternalException`](crate::error::InternalException)
pub mod internal_exception {
    /// A builder for [`InternalException`](crate::error::InternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalException`](crate::error::InternalException)
        pub fn build(self) -> crate::error::InternalException {
            crate::error::InternalException {
                message: self.message,
                error_code: self.error_code,
            }
        }
    }
}
impl InternalException {
    /// Creates a new builder-style object to manufacture [`InternalException`](crate::error::InternalException)
    pub fn builder() -> crate::error::internal_exception::Builder {
        crate::error::internal_exception::Builder::default()
    }
}
