// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Data Pipeline
///
/// Client for invoking operations on AWS Data Pipeline. Each operation on AWS Data Pipeline is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_datapipeline::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_datapipeline::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_datapipeline::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`ActivatePipeline`](crate::client::fluent_builders::ActivatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::ActivatePipeline::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::ActivatePipeline::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`parameter_values(Vec<ParameterValue>)`](crate::client::fluent_builders::ActivatePipeline::parameter_values) / [`set_parameter_values(Option<Vec<ParameterValue>>)`](crate::client::fluent_builders::ActivatePipeline::set_parameter_values): <p>A list of parameter values to pass to the pipeline at activation.</p>
    ///   - [`start_timestamp(DateTime)`](crate::client::fluent_builders::ActivatePipeline::start_timestamp) / [`set_start_timestamp(Option<DateTime>)`](crate::client::fluent_builders::ActivatePipeline::set_start_timestamp): <p>The date and time to resume the pipeline. By default, the pipeline resumes from the last completed execution.</p>
    /// - On success, responds with [`ActivatePipelineOutput`](crate::output::ActivatePipelineOutput)

    /// - On failure, responds with [`SdkError<ActivatePipelineError>`](crate::error::ActivatePipelineError)
    pub fn activate_pipeline(&self) -> fluent_builders::ActivatePipeline<C, M, R> {
        fluent_builders::ActivatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTags`](crate::client::fluent_builders::AddTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::AddTags::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::AddTags::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTags::set_tags): <p>The tags to add, as key/value pairs.</p>
    /// - On success, responds with [`AddTagsOutput`](crate::output::AddTagsOutput)

    /// - On failure, responds with [`SdkError<AddTagsError>`](crate::error::AddTagsError)
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePipeline`](crate::client::fluent_builders::CreatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_name): <p>The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS account, because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.</p>
    ///   - [`unique_id(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::unique_id) / [`set_unique_id(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_unique_id): <p>A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier. You use this parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For example, if the first call to <code>CreatePipeline</code> does not succeed, you can pass in the same unique identifier and pipeline name combination on a subsequent call to <code>CreatePipeline</code>. <code>CreatePipeline</code> ensures that if a pipeline already exists with the same name and unique identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the previous attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS account or IAM user credentials.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_description): <p>The description for the pipeline.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePipeline::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePipeline::set_tags): <p>A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    /// - On success, responds with [`CreatePipelineOutput`](crate::output::CreatePipelineOutput) with field(s):
    ///   - [`pipeline_id(Option<String>)`](crate::output::CreatePipelineOutput::pipeline_id): <p>The ID that AWS Data Pipeline assigns the newly created pipeline. For example, <code>df-06372391ZG65EXAMPLE</code>.</p>
    /// - On failure, responds with [`SdkError<CreatePipelineError>`](crate::error::CreatePipelineError)
    pub fn create_pipeline(&self) -> fluent_builders::CreatePipeline<C, M, R> {
        fluent_builders::CreatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeactivatePipeline`](crate::client::fluent_builders::DeactivatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::DeactivatePipeline::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::DeactivatePipeline::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`cancel_active(bool)`](crate::client::fluent_builders::DeactivatePipeline::cancel_active) / [`set_cancel_active(Option<bool>)`](crate::client::fluent_builders::DeactivatePipeline::set_cancel_active): <p>Indicates whether to cancel any running objects. The default is true, which sets the state of any running objects to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after all running objects finish.</p>
    /// - On success, responds with [`DeactivatePipelineOutput`](crate::output::DeactivatePipelineOutput)

    /// - On failure, responds with [`SdkError<DeactivatePipelineError>`](crate::error::DeactivatePipelineError)
    pub fn deactivate_pipeline(&self) -> fluent_builders::DeactivatePipeline<C, M, R> {
        fluent_builders::DeactivatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePipeline`](crate::client::fluent_builders::DeletePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::DeletePipeline::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::DeletePipeline::set_pipeline_id): <p>The ID of the pipeline.</p>
    /// - On success, responds with [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)

    /// - On failure, responds with [`SdkError<DeletePipelineError>`](crate::error::DeletePipelineError)
    pub fn delete_pipeline(&self) -> fluent_builders::DeletePipeline<C, M, R> {
        fluent_builders::DeletePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeObjects`](crate::client::fluent_builders::DescribeObjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeObjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::DescribeObjects::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::DescribeObjects::set_pipeline_id): <p>The ID of the pipeline that contains the object definitions.</p>
    ///   - [`object_ids(Vec<String>)`](crate::client::fluent_builders::DescribeObjects::object_ids) / [`set_object_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeObjects::set_object_ids): <p>The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25 identifiers in a single call to <code>DescribeObjects</code>.</p>
    ///   - [`evaluate_expressions(bool)`](crate::client::fluent_builders::DescribeObjects::evaluate_expressions) / [`set_evaluate_expressions(bool)`](crate::client::fluent_builders::DescribeObjects::set_evaluate_expressions): <p>Indicates whether any expressions in the object should be evaluated when the object descriptions are returned.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeObjects::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeObjects::set_marker): <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>DescribeObjects</code> with the marker value from the previous call to retrieve the next set of results.</p>
    /// - On success, responds with [`DescribeObjectsOutput`](crate::output::DescribeObjectsOutput) with field(s):
    ///   - [`pipeline_objects(Option<Vec<PipelineObject>>)`](crate::output::DescribeObjectsOutput::pipeline_objects): <p>An array of object definitions.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeObjectsOutput::marker): <p>The starting point for the next page of results. To view the next page of results, call <code>DescribeObjects</code> again with this marker value. If the value is null, there are no more results.</p>
    ///   - [`has_more_results(bool)`](crate::output::DescribeObjectsOutput::has_more_results): <p>Indicates whether there are more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeObjectsError>`](crate::error::DescribeObjectsError)
    pub fn describe_objects(&self) -> fluent_builders::DescribeObjects<C, M, R> {
        fluent_builders::DescribeObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePipelines`](crate::client::fluent_builders::DescribePipelines) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_ids(Vec<String>)`](crate::client::fluent_builders::DescribePipelines::pipeline_ids) / [`set_pipeline_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePipelines::set_pipeline_ids): <p>The IDs of the pipelines to describe. You can pass as many as 25 identifiers in a single call. To obtain pipeline IDs, call <code>ListPipelines</code>.</p>
    /// - On success, responds with [`DescribePipelinesOutput`](crate::output::DescribePipelinesOutput) with field(s):
    ///   - [`pipeline_description_list(Option<Vec<PipelineDescription>>)`](crate::output::DescribePipelinesOutput::pipeline_description_list): <p>An array of descriptions for the specified pipelines.</p>
    /// - On failure, responds with [`SdkError<DescribePipelinesError>`](crate::error::DescribePipelinesError)
    pub fn describe_pipelines(&self) -> fluent_builders::DescribePipelines<C, M, R> {
        fluent_builders::DescribePipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EvaluateExpression`](crate::client::fluent_builders::EvaluateExpression) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::EvaluateExpression::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::EvaluateExpression::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`object_id(impl Into<String>)`](crate::client::fluent_builders::EvaluateExpression::object_id) / [`set_object_id(Option<String>)`](crate::client::fluent_builders::EvaluateExpression::set_object_id): <p>The ID of the object.</p>
    ///   - [`expression(impl Into<String>)`](crate::client::fluent_builders::EvaluateExpression::expression) / [`set_expression(Option<String>)`](crate::client::fluent_builders::EvaluateExpression::set_expression): <p>The expression to evaluate.</p>
    /// - On success, responds with [`EvaluateExpressionOutput`](crate::output::EvaluateExpressionOutput) with field(s):
    ///   - [`evaluated_expression(Option<String>)`](crate::output::EvaluateExpressionOutput::evaluated_expression): <p>The evaluated expression.</p>
    /// - On failure, responds with [`SdkError<EvaluateExpressionError>`](crate::error::EvaluateExpressionError)
    pub fn evaluate_expression(&self) -> fluent_builders::EvaluateExpression<C, M, R> {
        fluent_builders::EvaluateExpression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPipelineDefinition`](crate::client::fluent_builders::GetPipelineDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::GetPipelineDefinition::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::GetPipelineDefinition::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetPipelineDefinition::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetPipelineDefinition::set_version): <p>The version of the pipeline definition to retrieve. Set this parameter to <code>latest</code> (default) to use the last definition saved to the pipeline or <code>active</code> to use the last definition that was activated.</p>
    /// - On success, responds with [`GetPipelineDefinitionOutput`](crate::output::GetPipelineDefinitionOutput) with field(s):
    ///   - [`pipeline_objects(Option<Vec<PipelineObject>>)`](crate::output::GetPipelineDefinitionOutput::pipeline_objects): <p>The objects defined in the pipeline.</p>
    ///   - [`parameter_objects(Option<Vec<ParameterObject>>)`](crate::output::GetPipelineDefinitionOutput::parameter_objects): <p>The parameter objects used in the pipeline definition.</p>
    ///   - [`parameter_values(Option<Vec<ParameterValue>>)`](crate::output::GetPipelineDefinitionOutput::parameter_values): <p>The parameter values used in the pipeline definition.</p>
    /// - On failure, responds with [`SdkError<GetPipelineDefinitionError>`](crate::error::GetPipelineDefinitionError)
    pub fn get_pipeline_definition(&self) -> fluent_builders::GetPipelineDefinition<C, M, R> {
        fluent_builders::GetPipelineDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPipelines`](crate::client::fluent_builders::ListPipelines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPipelines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListPipelines::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListPipelines::set_marker): <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>ListPipelines</code> with the marker value from the previous call to retrieve the next set of results.</p>
    /// - On success, responds with [`ListPipelinesOutput`](crate::output::ListPipelinesOutput) with field(s):
    ///   - [`pipeline_id_list(Option<Vec<PipelineIdName>>)`](crate::output::ListPipelinesOutput::pipeline_id_list): <p>The pipeline identifiers. If you require additional information about the pipelines, you can use these identifiers to call <code>DescribePipelines</code> and <code>GetPipelineDefinition</code>.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListPipelinesOutput::marker): <p>The starting point for the next page of results. To view the next page of results, call <code>ListPipelinesOutput</code> again with this marker value. If the value is null, there are no more results.</p>
    ///   - [`has_more_results(bool)`](crate::output::ListPipelinesOutput::has_more_results): <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
    /// - On failure, responds with [`SdkError<ListPipelinesError>`](crate::error::ListPipelinesError)
    pub fn list_pipelines(&self) -> fluent_builders::ListPipelines<C, M, R> {
        fluent_builders::ListPipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PollForTask`](crate::client::fluent_builders::PollForTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`worker_group(impl Into<String>)`](crate::client::fluent_builders::PollForTask::worker_group) / [`set_worker_group(Option<String>)`](crate::client::fluent_builders::PollForTask::set_worker_group): <p>The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code> in the call to <code>PollForTask</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.</p>
    ///   - [`hostname(impl Into<String>)`](crate::client::fluent_builders::PollForTask::hostname) / [`set_hostname(Option<String>)`](crate::client::fluent_builders::PollForTask::set_hostname): <p>The public DNS name of the calling task runner.</p>
    ///   - [`instance_identity(InstanceIdentity)`](crate::client::fluent_builders::PollForTask::instance_identity) / [`set_instance_identity(Option<InstanceIdentity>)`](crate::client::fluent_builders::PollForTask::set_instance_identity): <p>Identity information for the EC2 instance that is hosting the task runner. You can get this value from the instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.</p>
    /// - On success, responds with [`PollForTaskOutput`](crate::output::PollForTaskOutput) with field(s):
    ///   - [`task_object(Option<TaskObject>)`](crate::output::PollForTaskOutput::task_object): <p>The information needed to complete the task that is being assigned to the task runner. One of the fields returned in this object is <code>taskId</code>, which contains an identifier for the task being assigned. The calling task runner uses <code>taskId</code> in subsequent calls to <code>ReportTaskProgress</code> and <code>SetTaskStatus</code>.</p>
    /// - On failure, responds with [`SdkError<PollForTaskError>`](crate::error::PollForTaskError)
    pub fn poll_for_task(&self) -> fluent_builders::PollForTask<C, M, R> {
        fluent_builders::PollForTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPipelineDefinition`](crate::client::fluent_builders::PutPipelineDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::PutPipelineDefinition::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::PutPipelineDefinition::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`pipeline_objects(Vec<PipelineObject>)`](crate::client::fluent_builders::PutPipelineDefinition::pipeline_objects) / [`set_pipeline_objects(Option<Vec<PipelineObject>>)`](crate::client::fluent_builders::PutPipelineDefinition::set_pipeline_objects): <p>The objects that define the pipeline. These objects overwrite the existing pipeline definition.</p>
    ///   - [`parameter_objects(Vec<ParameterObject>)`](crate::client::fluent_builders::PutPipelineDefinition::parameter_objects) / [`set_parameter_objects(Option<Vec<ParameterObject>>)`](crate::client::fluent_builders::PutPipelineDefinition::set_parameter_objects): <p>The parameter objects used with the pipeline.</p>
    ///   - [`parameter_values(Vec<ParameterValue>)`](crate::client::fluent_builders::PutPipelineDefinition::parameter_values) / [`set_parameter_values(Option<Vec<ParameterValue>>)`](crate::client::fluent_builders::PutPipelineDefinition::set_parameter_values): <p>The parameter values used with the pipeline.</p>
    /// - On success, responds with [`PutPipelineDefinitionOutput`](crate::output::PutPipelineDefinitionOutput) with field(s):
    ///   - [`validation_errors(Option<Vec<ValidationError>>)`](crate::output::PutPipelineDefinitionOutput::validation_errors): <p>The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.</p>
    ///   - [`validation_warnings(Option<Vec<ValidationWarning>>)`](crate::output::PutPipelineDefinitionOutput::validation_warnings): <p>The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.</p>
    ///   - [`errored(bool)`](crate::output::PutPipelineDefinitionOutput::errored): <p>Indicates whether there were validation errors, and the pipeline definition is stored but cannot be activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.</p>
    /// - On failure, responds with [`SdkError<PutPipelineDefinitionError>`](crate::error::PutPipelineDefinitionError)
    pub fn put_pipeline_definition(&self) -> fluent_builders::PutPipelineDefinition<C, M, R> {
        fluent_builders::PutPipelineDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`QueryObjects`](crate::client::fluent_builders::QueryObjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::QueryObjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::QueryObjects::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::QueryObjects::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`query(Query)`](crate::client::fluent_builders::QueryObjects::query) / [`set_query(Option<Query>)`](crate::client::fluent_builders::QueryObjects::set_query): <p>The query that defines the objects to be returned. The <code>Query</code> object can contain a maximum of ten selectors. The conditions in the query are limited to top-level String fields in the object. These filters can be applied to components, instances, and attempts.</p>
    ///   - [`sphere(impl Into<String>)`](crate::client::fluent_builders::QueryObjects::sphere) / [`set_sphere(Option<String>)`](crate::client::fluent_builders::QueryObjects::set_sphere): <p>Indicates whether the query applies to components or instances. The possible values are: <code>COMPONENT</code>, <code>INSTANCE</code>, and <code>ATTEMPT</code>.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::QueryObjects::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::QueryObjects::set_marker): <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>QueryObjects</code> with the marker value from the previous call to retrieve the next set of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::QueryObjects::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::QueryObjects::set_limit): <p>The maximum number of object names that <code>QueryObjects</code> will return in a single call. The default value is 100. </p>
    /// - On success, responds with [`QueryObjectsOutput`](crate::output::QueryObjectsOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::QueryObjectsOutput::ids): <p>The identifiers that match the query selectors.</p>
    ///   - [`marker(Option<String>)`](crate::output::QueryObjectsOutput::marker): <p>The starting point for the next page of results. To view the next page of results, call <code>QueryObjects</code> again with this marker value. If the value is null, there are no more results.</p>
    ///   - [`has_more_results(bool)`](crate::output::QueryObjectsOutput::has_more_results): <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
    /// - On failure, responds with [`SdkError<QueryObjectsError>`](crate::error::QueryObjectsError)
    pub fn query_objects(&self) -> fluent_builders::QueryObjects<C, M, R> {
        fluent_builders::QueryObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTags`](crate::client::fluent_builders::RemoveTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::RemoveTags::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::RemoveTags::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTags::set_tag_keys): <p>The keys of the tags to remove.</p>
    /// - On success, responds with [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsError>`](crate::error::RemoveTagsError)
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags<C, M, R> {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReportTaskProgress`](crate::client::fluent_builders::ReportTaskProgress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::ReportTaskProgress::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::ReportTaskProgress::set_task_id): <p>The ID of the task assigned to the task runner. This value is provided in the response for <code>PollForTask</code>.</p>
    ///   - [`fields(Vec<Field>)`](crate::client::fluent_builders::ReportTaskProgress::fields) / [`set_fields(Option<Vec<Field>>)`](crate::client::fluent_builders::ReportTaskProgress::set_fields): <p>Key-value pairs that define the properties of the ReportTaskProgressInput object.</p>
    /// - On success, responds with [`ReportTaskProgressOutput`](crate::output::ReportTaskProgressOutput) with field(s):
    ///   - [`canceled(bool)`](crate::output::ReportTaskProgressOutput::canceled): <p>If true, the calling task runner should cancel processing of the task. The task runner does not need to call <code>SetTaskStatus</code> for canceled tasks.</p>
    /// - On failure, responds with [`SdkError<ReportTaskProgressError>`](crate::error::ReportTaskProgressError)
    pub fn report_task_progress(&self) -> fluent_builders::ReportTaskProgress<C, M, R> {
        fluent_builders::ReportTaskProgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReportTaskRunnerHeartbeat`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`taskrunner_id(impl Into<String>)`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat::taskrunner_id) / [`set_taskrunner_id(Option<String>)`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat::set_taskrunner_id): <p>The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier when it launches the application. If you have written a custom task runner, you should assign a unique identifier for the task runner.</p>
    ///   - [`worker_group(impl Into<String>)`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat::worker_group) / [`set_worker_group(Option<String>)`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat::set_worker_group): <p>The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.</p>
    ///   - [`hostname(impl Into<String>)`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat::hostname) / [`set_hostname(Option<String>)`](crate::client::fluent_builders::ReportTaskRunnerHeartbeat::set_hostname): <p>The public DNS name of the task runner.</p>
    /// - On success, responds with [`ReportTaskRunnerHeartbeatOutput`](crate::output::ReportTaskRunnerHeartbeatOutput) with field(s):
    ///   - [`terminate(bool)`](crate::output::ReportTaskRunnerHeartbeatOutput::terminate): <p>Indicates whether the calling task runner should terminate.</p>
    /// - On failure, responds with [`SdkError<ReportTaskRunnerHeartbeatError>`](crate::error::ReportTaskRunnerHeartbeatError)
    pub fn report_task_runner_heartbeat(
        &self,
    ) -> fluent_builders::ReportTaskRunnerHeartbeat<C, M, R> {
        fluent_builders::ReportTaskRunnerHeartbeat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetStatus`](crate::client::fluent_builders::SetStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::SetStatus::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::SetStatus::set_pipeline_id): <p>The ID of the pipeline that contains the objects.</p>
    ///   - [`object_ids(Vec<String>)`](crate::client::fluent_builders::SetStatus::object_ids) / [`set_object_ids(Option<Vec<String>>)`](crate::client::fluent_builders::SetStatus::set_object_ids): <p>The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both types.</p>
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::SetStatus::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::SetStatus::set_status): <p>The status to be set on all the objects specified in <code>objectIds</code>. For components, use <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>, <code>RERUN</code>, or <code>MARK_FINISHED</code>.</p>
    /// - On success, responds with [`SetStatusOutput`](crate::output::SetStatusOutput)

    /// - On failure, responds with [`SdkError<SetStatusError>`](crate::error::SetStatusError)
    pub fn set_status(&self) -> fluent_builders::SetStatus<C, M, R> {
        fluent_builders::SetStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetTaskStatus`](crate::client::fluent_builders::SetTaskStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::SetTaskStatus::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::SetTaskStatus::set_task_id): <p>The ID of the task assigned to the task runner. This value is provided in the response for <code>PollForTask</code>.</p>
    ///   - [`task_status(TaskStatus)`](crate::client::fluent_builders::SetTaskStatus::task_status) / [`set_task_status(Option<TaskStatus>)`](crate::client::fluent_builders::SetTaskStatus::set_task_status): <p>If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended unsuccessfully. Preconditions use false.</p>
    ///   - [`error_id(impl Into<String>)`](crate::client::fluent_builders::SetTaskStatus::error_id) / [`set_error_id(Option<String>)`](crate::client::fluent_builders::SetTaskStatus::set_error_id): <p>If an error occurred during the task, this value specifies the error code. This value is set on the physical attempt object. It is used to display error information to the user. It should not start with string "Service_" which is reserved by the system.</p>
    ///   - [`error_message(impl Into<String>)`](crate::client::fluent_builders::SetTaskStatus::error_message) / [`set_error_message(Option<String>)`](crate::client::fluent_builders::SetTaskStatus::set_error_message): <p>If an error occurred during the task, this value specifies a text description of the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value.</p>
    ///   - [`error_stack_trace(impl Into<String>)`](crate::client::fluent_builders::SetTaskStatus::error_stack_trace) / [`set_error_stack_trace(Option<String>)`](crate::client::fluent_builders::SetTaskStatus::set_error_stack_trace): <p>If an error occurred during the task, this value specifies the stack trace associated with the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value.</p>
    /// - On success, responds with [`SetTaskStatusOutput`](crate::output::SetTaskStatusOutput)

    /// - On failure, responds with [`SdkError<SetTaskStatusError>`](crate::error::SetTaskStatusError)
    pub fn set_task_status(&self) -> fluent_builders::SetTaskStatus<C, M, R> {
        fluent_builders::SetTaskStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidatePipelineDefinition`](crate::client::fluent_builders::ValidatePipelineDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_id(impl Into<String>)`](crate::client::fluent_builders::ValidatePipelineDefinition::pipeline_id) / [`set_pipeline_id(Option<String>)`](crate::client::fluent_builders::ValidatePipelineDefinition::set_pipeline_id): <p>The ID of the pipeline.</p>
    ///   - [`pipeline_objects(Vec<PipelineObject>)`](crate::client::fluent_builders::ValidatePipelineDefinition::pipeline_objects) / [`set_pipeline_objects(Option<Vec<PipelineObject>>)`](crate::client::fluent_builders::ValidatePipelineDefinition::set_pipeline_objects): <p>The objects that define the pipeline changes to validate against the pipeline.</p>
    ///   - [`parameter_objects(Vec<ParameterObject>)`](crate::client::fluent_builders::ValidatePipelineDefinition::parameter_objects) / [`set_parameter_objects(Option<Vec<ParameterObject>>)`](crate::client::fluent_builders::ValidatePipelineDefinition::set_parameter_objects): <p>The parameter objects used with the pipeline.</p>
    ///   - [`parameter_values(Vec<ParameterValue>)`](crate::client::fluent_builders::ValidatePipelineDefinition::parameter_values) / [`set_parameter_values(Option<Vec<ParameterValue>>)`](crate::client::fluent_builders::ValidatePipelineDefinition::set_parameter_values): <p>The parameter values used with the pipeline.</p>
    /// - On success, responds with [`ValidatePipelineDefinitionOutput`](crate::output::ValidatePipelineDefinitionOutput) with field(s):
    ///   - [`validation_errors(Option<Vec<ValidationError>>)`](crate::output::ValidatePipelineDefinitionOutput::validation_errors): <p>Any validation errors that were found.</p>
    ///   - [`validation_warnings(Option<Vec<ValidationWarning>>)`](crate::output::ValidatePipelineDefinitionOutput::validation_warnings): <p>Any validation warnings that were found.</p>
    ///   - [`errored(bool)`](crate::output::ValidatePipelineDefinitionOutput::errored): <p>Indicates whether there were validation errors.</p>
    /// - On failure, responds with [`SdkError<ValidatePipelineDefinitionError>`](crate::error::ValidatePipelineDefinitionError)
    pub fn validate_pipeline_definition(
        &self,
    ) -> fluent_builders::ValidatePipelineDefinition<C, M, R> {
        fluent_builders::ValidatePipelineDefinition::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivatePipeline`.
    ///
    /// <p>Validates the specified pipeline and starts processing pipeline tasks. If the pipeline does not pass validation, activation fails.</p>
    /// <p>If you need to pause the pipeline to investigate an issue with a component, such as a data source or script, call <code>DeactivatePipeline</code>.</p>
    /// <p>To activate a finished pipeline, modify the end date for the pipeline and then activate it.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.ActivatePipeline Content-Length: 39 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE"}
    /// </request>
    /// <response>
    /// HTTP/1.1 200 x-amzn-RequestId: ee19d5bf-074e-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 2 Date: Mon, 12 Nov 2012 17:50:53 GMT {}
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_pipeline_input::Builder,
    }
    impl<C, M, R> ActivatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivatePipelineInputOperationOutputAlias,
                crate::output::ActivatePipelineOutput,
                crate::error::ActivatePipelineError,
                crate::input::ActivatePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `parameterValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_values`](Self::set_parameter_values).
        ///
        /// <p>A list of parameter values to pass to the pipeline at activation.</p>
        pub fn parameter_values(mut self, input: crate::model::ParameterValue) -> Self {
            self.inner = self.inner.parameter_values(input);
            self
        }
        /// <p>A list of parameter values to pass to the pipeline at activation.</p>
        pub fn set_parameter_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_values(input);
            self
        }
        /// <p>The date and time to resume the pipeline. By default, the pipeline resumes from the last completed execution.</p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_timestamp(input);
            self
        }
        /// <p>The date and time to resume the pipeline. By default, the pipeline resumes from the last completed execution.</p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds or modifies tags for the specified pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add, as key/value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add, as key/value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePipeline`.
    ///
    /// <p>Creates a new, empty pipeline. Use <code>PutPipelineDefinition</code> to populate the pipeline.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.CreatePipeline Content-Length: 91 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"name": "myPipeline", "uniqueId": "123456789", "description": "This is my first pipeline"}
    /// </request>
    /// <response>
    /// HTTP/1.1 200 x-amzn-RequestId: b16911ce-0774-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 40 Date: Mon, 12 Nov 2012 17:50:53 GMT {"pipelineId": "df-06372391ZG65EXAMPLE"}
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pipeline_input::Builder,
    }
    impl<C, M, R> CreatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePipelineInputOperationOutputAlias,
                crate::output::CreatePipelineOutput,
                crate::error::CreatePipelineError,
                crate::input::CreatePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS account, because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS account, because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier. You use this parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For example, if the first call to <code>CreatePipeline</code> does not succeed, you can pass in the same unique identifier and pipeline name combination on a subsequent call to <code>CreatePipeline</code>. <code>CreatePipeline</code> ensures that if a pipeline already exists with the same name and unique identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the previous attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS account or IAM user credentials.</p>
        pub fn unique_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unique_id(input.into());
            self
        }
        /// <p>A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier. You use this parameter to ensure idempotency during repeated calls to <code>CreatePipeline</code>. For example, if the first call to <code>CreatePipeline</code> does not succeed, you can pass in the same unique identifier and pipeline name combination on a subsequent call to <code>CreatePipeline</code>. <code>CreatePipeline</code> ensures that if a pipeline already exists with the same name and unique identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the previous attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS account or IAM user credentials.</p>
        pub fn set_unique_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_unique_id(input);
            self
        }
        /// <p>The description for the pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivatePipeline`.
    ///
    /// <p>Deactivates the specified running pipeline. The pipeline is set to the <code>DEACTIVATING</code> state until the deactivation process completes.</p>
    /// <p>To resume a deactivated pipeline, use <code>ActivatePipeline</code>. By default, the pipeline resumes from the last completed execution. Optionally, you can specify the date and time to resume the pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_pipeline_input::Builder,
    }
    impl<C, M, R> DeactivatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivatePipelineInputOperationOutputAlias,
                crate::output::DeactivatePipelineOutput,
                crate::error::DeactivatePipelineError,
                crate::input::DeactivatePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// <p>Indicates whether to cancel any running objects. The default is true, which sets the state of any running objects to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after all running objects finish.</p>
        pub fn cancel_active(mut self, input: bool) -> Self {
            self.inner = self.inner.cancel_active(input);
            self
        }
        /// <p>Indicates whether to cancel any running objects. The default is true, which sets the state of any running objects to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after all running objects finish.</p>
        pub fn set_cancel_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cancel_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePipeline`.
    ///
    /// <p>Deletes a pipeline, its pipeline definition, and its run history. AWS Data Pipeline attempts to cancel instances associated with the pipeline that are currently being processed by task runners.</p>
    /// <p>Deleting a pipeline cannot be undone. You cannot query or restore a deleted pipeline. To temporarily pause a pipeline instead of deleting it, call <code>SetStatus</code> with the status set to <code>PAUSE</code> on individual components. Components that are paused by <code>SetStatus</code> can be resumed.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.DeletePipeline Content-Length: 50 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE"}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: b7a88c81-0754-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 0 Date: Mon, 12 Nov 2012 17:50:53 GMT Unexpected response: 200, OK, undefined
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pipeline_input::Builder,
    }
    impl<C, M, R> DeletePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePipelineInputOperationOutputAlias,
                crate::output::DeletePipelineOutput,
                crate::error::DeletePipelineError,
                crate::input::DeletePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeObjects`.
    ///
    /// <p>Gets the object definitions for a set of objects associated with the pipeline. Object definitions are composed of a set of fields that define the properties of the object.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.DescribeObjects Content-Length: 98 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE", "objectIds": ["Schedule"], "evaluateExpressions": true}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 4c18ea5d-0777-11e2-8a14-21bb8a1f50ef Content-Type: application/x-amz-json-1.1 Content-Length: 1488 Date: Mon, 12 Nov 2012 17:50:53 GMT {"hasMoreResults": false, "pipelineObjects": [ {"fields": [ {"key": "startDateTime", "stringValue": "2012-12-12T00:00:00"}, {"key": "parent", "refValue": "Default"}, {"key": "@sphere", "stringValue": "COMPONENT"}, {"key": "type", "stringValue": "Schedule"}, {"key": "period", "stringValue": "1 hour"}, {"key": "endDateTime", "stringValue": "2012-12-21T18:00:00"}, {"key": "@version", "stringValue": "1"}, {"key": "@status", "stringValue": "PENDING"}, {"key": "@pipelineId", "stringValue": "df-06372391ZG65EXAMPLE"} ], "id": "Schedule", "name": "Schedule"} ] }
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeObjects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_objects_input::Builder,
    }
    impl<C, M, R> DescribeObjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeObjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeObjectsInputOperationOutputAlias,
                crate::output::DescribeObjectsOutput,
                crate::error::DescribeObjectsError,
                crate::input::DescribeObjectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeObjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeObjectsPaginator<C, M, R> {
            crate::paginator::DescribeObjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the pipeline that contains the object definitions.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline that contains the object definitions.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `objectIds`.
        ///
        /// To override the contents of this collection use [`set_object_ids`](Self::set_object_ids).
        ///
        /// <p>The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25 identifiers in a single call to <code>DescribeObjects</code>.</p>
        pub fn object_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_ids(input.into());
            self
        }
        /// <p>The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25 identifiers in a single call to <code>DescribeObjects</code>.</p>
        pub fn set_object_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_object_ids(input);
            self
        }
        /// <p>Indicates whether any expressions in the object should be evaluated when the object descriptions are returned.</p>
        pub fn evaluate_expressions(mut self, input: bool) -> Self {
            self.inner = self.inner.evaluate_expressions(input);
            self
        }
        /// <p>Indicates whether any expressions in the object should be evaluated when the object descriptions are returned.</p>
        pub fn set_evaluate_expressions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_evaluate_expressions(input);
            self
        }
        /// <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>DescribeObjects</code> with the marker value from the previous call to retrieve the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>DescribeObjects</code> with the marker value from the previous call to retrieve the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePipelines`.
    ///
    /// <p>Retrieves metadata about one or more pipelines. The information retrieved includes the name of the pipeline, the pipeline identifier, its current state, and the user account that owns the pipeline. Using account credentials, you can retrieve metadata about pipelines that you or your IAM users have created. If you are using an IAM user account, you can retrieve metadata about only those pipelines for which you have read permissions.</p>
    /// <p>To retrieve the full pipeline definition instead of metadata about the pipeline, call <code>GetPipelineDefinition</code>.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.DescribePipelines Content-Length: 70 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineIds": ["df-08785951KAKJEXAMPLE"] }
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 02870eb7-0736-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 767 Date: Mon, 12 Nov 2012 17:50:53 GMT {"pipelineDescriptionList": [ {"description": "This is my first pipeline", "fields": [ {"key": "@pipelineState", "stringValue": "SCHEDULED"}, {"key": "description", "stringValue": "This is my first pipeline"}, {"key": "name", "stringValue": "myPipeline"}, {"key": "@creationTime", "stringValue": "2012-12-13T01:24:06"}, {"key": "@id", "stringValue": "df-0937003356ZJEXAMPLE"}, {"key": "@sphere", "stringValue": "PIPELINE"}, {"key": "@version", "stringValue": "1"}, {"key": "@userId", "stringValue": "924374875933"}, {"key": "@accountId", "stringValue": "924374875933"}, {"key": "uniqueId", "stringValue": "1234567890"} ], "name": "myPipeline", "pipelineId": "df-0937003356ZJEXAMPLE"} ] }
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pipelines_input::Builder,
    }
    impl<C, M, R> DescribePipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePipelinesInputOperationOutputAlias,
                crate::output::DescribePipelinesOutput,
                crate::error::DescribePipelinesError,
                crate::input::DescribePipelinesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `pipelineIds`.
        ///
        /// To override the contents of this collection use [`set_pipeline_ids`](Self::set_pipeline_ids).
        ///
        /// <p>The IDs of the pipelines to describe. You can pass as many as 25 identifiers in a single call. To obtain pipeline IDs, call <code>ListPipelines</code>.</p>
        pub fn pipeline_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_ids(input.into());
            self
        }
        /// <p>The IDs of the pipelines to describe. You can pass as many as 25 identifiers in a single call. To obtain pipeline IDs, call <code>ListPipelines</code>.</p>
        pub fn set_pipeline_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluateExpression`.
    ///
    /// <p>Task runners call <code>EvaluateExpression</code> to evaluate a string in the context of the specified object. For example, a task runner can evaluate SQL queries stored in Amazon S3.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.DescribePipelines Content-Length: 164 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-08785951KAKJEXAMPLE", "objectId": "Schedule", "expression": "Transform started at #{startDateTime} and finished at #{endDateTime}"}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 02870eb7-0736-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 103 Date: Mon, 12 Nov 2012 17:50:53 GMT {"evaluatedExpression": "Transform started at 2012-12-12T00:00:00 and finished at 2012-12-21T18:00:00"}
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EvaluateExpression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::evaluate_expression_input::Builder,
    }
    impl<C, M, R> EvaluateExpression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EvaluateExpression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluateExpressionOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluateExpressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EvaluateExpressionInputOperationOutputAlias,
                crate::output::EvaluateExpressionOutput,
                crate::error::EvaluateExpressionError,
                crate::input::EvaluateExpressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// <p>The ID of the object.</p>
        pub fn object_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_id(input.into());
            self
        }
        /// <p>The ID of the object.</p>
        pub fn set_object_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_object_id(input);
            self
        }
        /// <p>The expression to evaluate.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The expression to evaluate.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPipelineDefinition`.
    ///
    /// <p>Gets the definition of the specified pipeline. You can call <code>GetPipelineDefinition</code> to retrieve the pipeline definition that you provided using <code>PutPipelineDefinition</code>.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.GetPipelineDefinition Content-Length: 40 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE"}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: e28309e5-0776-11e2-8a14-21bb8a1f50ef Content-Type: application/x-amz-json-1.1 Content-Length: 890 Date: Mon, 12 Nov 2012 17:50:53 GMT {"pipelineObjects": [ {"fields": [ {"key": "workerGroup", "stringValue": "workerGroup"} ], "id": "Default", "name": "Default"}, {"fields": [ {"key": "startDateTime", "stringValue": "2012-09-25T17:00:00"}, {"key": "type", "stringValue": "Schedule"}, {"key": "period", "stringValue": "1 hour"}, {"key": "endDateTime", "stringValue": "2012-09-25T18:00:00"} ], "id": "Schedule", "name": "Schedule"}, {"fields": [ {"key": "schedule", "refValue": "Schedule"}, {"key": "command", "stringValue": "echo hello"}, {"key": "parent", "refValue": "Default"}, {"key": "type", "stringValue": "ShellCommandActivity"} ], "id": "SayHello", "name": "SayHello"} ] }
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPipelineDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pipeline_definition_input::Builder,
    }
    impl<C, M, R> GetPipelineDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPipelineDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPipelineDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPipelineDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPipelineDefinitionInputOperationOutputAlias,
                crate::output::GetPipelineDefinitionOutput,
                crate::error::GetPipelineDefinitionError,
                crate::input::GetPipelineDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// <p>The version of the pipeline definition to retrieve. Set this parameter to <code>latest</code> (default) to use the last definition saved to the pipeline or <code>active</code> to use the last definition that was activated.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the pipeline definition to retrieve. Set this parameter to <code>latest</code> (default) to use the last definition saved to the pipeline or <code>active</code> to use the last definition that was activated.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPipelines`.
    ///
    /// <p>Lists the pipeline identifiers for all active pipelines that you have permission to access.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.ListPipelines Content-Length: 14 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {}
    /// </request>
    /// <response>
    /// Status: x-amzn-RequestId: b3104dc5-0734-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 39 Date: Mon, 12 Nov 2012 17:50:53 GMT {"PipelineIdList": [ {"id": "df-08785951KAKJEXAMPLE", "name": "MyPipeline"}, {"id": "df-08662578ISYEXAMPLE", "name": "MySecondPipeline"} ] }
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pipelines_input::Builder,
    }
    impl<C, M, R> ListPipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPipelinesInputOperationOutputAlias,
                crate::output::ListPipelinesOutput,
                crate::error::ListPipelinesError,
                crate::input::ListPipelinesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPipelinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPipelinesPaginator<C, M, R> {
            crate::paginator::ListPipelinesPaginator::new(self.handle, self.inner)
        }
        /// <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>ListPipelines</code> with the marker value from the previous call to retrieve the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>ListPipelines</code> with the marker value from the previous call to retrieve the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PollForTask`.
    ///
    /// <p>Task runners call <code>PollForTask</code> to receive a task to perform from AWS Data Pipeline. The task runner specifies which tasks it can perform by setting a value for the <code>workerGroup</code> parameter. The task returned can come from any of the pipelines that match the <code>workerGroup</code> value passed in by the task runner and that was launched using the IAM user credentials specified by the task runner.</p>
    /// <p>If tasks are ready in the work queue, <code>PollForTask</code> returns a response immediately. If no tasks are available in the queue, <code>PollForTask</code> uses long-polling and holds on to a poll connection for up to a 90 seconds, during which time the first newly scheduled task is handed to the task runner. To accomodate this, set the socket timeout in your task runner to 90 seconds. The task runner should not call <code>PollForTask</code> again on the same <code>workerGroup</code> until it receives a response, and this can take up to 90 seconds. </p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.PollForTask Content-Length: 59 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"workerGroup": "MyworkerGroup", "hostname": "example.com"}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 41c713d2-0775-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 39 Date: Mon, 12 Nov 2012 17:50:53 GMT {"taskObject": {"attemptId": "@SayHello_2012-12-12T00:00:00_Attempt=1", "objects": {"@SayHello_2012-12-12T00:00:00_Attempt=1": {"fields": [ {"key": "@componentParent", "refValue": "SayHello"}, {"key": "@scheduledStartTime", "stringValue": "2012-12-12T00:00:00"}, {"key": "parent", "refValue": "SayHello"}, {"key": "@sphere", "stringValue": "ATTEMPT"}, {"key": "workerGroup", "stringValue": "workerGroup"}, {"key": "@instanceParent", "refValue": "@SayHello_2012-12-12T00:00:00"}, {"key": "type", "stringValue": "ShellCommandActivity"}, {"key": "@status", "stringValue": "WAITING_FOR_RUNNER"}, {"key": "@version", "stringValue": "1"}, {"key": "schedule", "refValue": "Schedule"}, {"key": "@actualStartTime", "stringValue": "2012-12-13T01:40:50"}, {"key": "command", "stringValue": "echo hello"}, {"key": "@scheduledEndTime", "stringValue": "2012-12-12T01:00:00"}, {"key": "@activeInstances", "refValue": "@SayHello_2012-12-12T00:00:00"}, {"key": "@pipelineId", "stringValue": "df-0937003356ZJEXAMPLE"} ], "id": "@SayHello_2012-12-12T00:00:00_Attempt=1", "name": "@SayHello_2012-12-12T00:00:00_Attempt=1"} }, "pipelineId": "df-0937003356ZJEXAMPLE", "taskId": "2xaM4wRs5zOsIH+g9U3oVHfAgAlbSqU6XduncB0HhZ3xMnmvfePZPn4dIbYXHyWyRK+cU15MqDHwdrvftx/4wv+sNS4w34vJfv7QA9aOoOazW28l1GYSb2ZRR0N0paiQp+d1MhSKo10hOTWOsVK5S5Lnx9Qm6omFgXHyIvZRIvTlrQMpr1xuUrflyGOfbFOGpOLpvPE172MYdqpZKnbSS4TcuqgQKSWV2833fEubI57DPOP7ghWa2TcYeSIv4pdLYG53fTuwfbnbdc98g2LNUQzSVhSnt7BoqyNwht2aQ6b/UHg9A80+KVpuXuqmz3m1MXwHFgxjdmuesXNOrrlGpeLCcRWD+aGo0RN1NqhQRzNAig8V4GlaPTQzMsRCljKqvrIyAoP3Tt2XEGsHkkQo12rEX8Z90957XX2qKRwhruwYzqGkSLWjINoLdAxUJdpRXRc5DJTrBd3D5mdzn7kY1l7NEh4kFHJDt3Cx4Z3Mk8MYCACyCk/CEyy9DwuPi66cLz0NBcgbCM5LKjTBOwo1m+am+pvM1kSposE9FPP1+RFGb8k6jQBTJx3TRz1yKilnGXQTZ5xvdOFpJrklIT0OXP1MG3+auM9FlJA+1dX90QoNJE5z7axmK//MOGXUdkqFe2kiDkorqjxwDvc0Js9pVKfKvAmW8YqUbmI9l0ERpWCXXnLVHNmPWz3jaPY+OBAmuJWDmxB/Z8p94aEDg4BVXQ7LvsKQ3DLYhaB7yJ390CJT+i0mm+EBqY60V6YikPSWDFrYQ/NPi2b1DgE19mX8zHqw8qprIl4yh1Ckx2Iige4En/N5ktOoIxnASxAw/TzcE2skxdw5KlHDF+UTj71m16CR/dIaKlXijlfNlNzUBo/bNSadCQn3G5NoO501wPKI:XO50TgDNyo8EXAMPLE/g==:1"} }
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PollForTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::poll_for_task_input::Builder,
    }
    impl<C, M, R> PollForTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PollForTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PollForTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::PollForTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PollForTaskInputOperationOutputAlias,
                crate::output::PollForTaskOutput,
                crate::error::PollForTaskError,
                crate::input::PollForTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code> in the call to <code>PollForTask</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.</p>
        pub fn worker_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_group(input.into());
            self
        }
        /// <p>The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code> in the call to <code>PollForTask</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.</p>
        pub fn set_worker_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_group(input);
            self
        }
        /// <p>The public DNS name of the calling task runner.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(input.into());
            self
        }
        /// <p>The public DNS name of the calling task runner.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
        /// <p>Identity information for the EC2 instance that is hosting the task runner. You can get this value from the instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.</p>
        pub fn instance_identity(mut self, input: crate::model::InstanceIdentity) -> Self {
            self.inner = self.inner.instance_identity(input);
            self
        }
        /// <p>Identity information for the EC2 instance that is hosting the task runner. You can get this value from the instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.</p>
        pub fn set_instance_identity(
            mut self,
            input: std::option::Option<crate::model::InstanceIdentity>,
        ) -> Self {
            self.inner = self.inner.set_instance_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPipelineDefinition`.
    ///
    /// <p>Adds tasks, schedules, and preconditions to the specified pipeline. You can use <code>PutPipelineDefinition</code> to populate a new pipeline.</p>
    /// <p> <code>PutPipelineDefinition</code> also validates the configuration as it adds it to the pipeline. Changes to the pipeline are saved unless one of the following three validation errors exists in the pipeline. </p>
    /// <ol>
    /// <li>An object is missing a name or identifier field.</li>
    /// <li>A string or reference field is empty.</li>
    /// <li>The number of objects in the pipeline exceeds the maximum allowed objects.</li>
    /// <li>The pipeline is in a FINISHED state.</li>
    /// </ol>
    /// <p> Pipeline object definitions are passed to the <code>PutPipelineDefinition</code> action and returned by the <code>GetPipelineDefinition</code> action. </p> <examples>
    /// <example>
    /// <name>
    /// Example 1
    /// </name>
    /// <description>
    /// This example sets an valid pipeline configuration and returns success.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.PutPipelineDefinition Content-Length: 914 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-0937003356ZJEXAMPLE", "pipelineObjects": [ {"id": "Default", "name": "Default", "fields": [ {"key": "workerGroup", "stringValue": "workerGroup"} ] }, {"id": "Schedule", "name": "Schedule", "fields": [ {"key": "startDateTime", "stringValue": "2012-12-12T00:00:00"}, {"key": "type", "stringValue": "Schedule"}, {"key": "period", "stringValue": "1 hour"}, {"key": "endDateTime", "stringValue": "2012-12-21T18:00:00"} ] }, {"id": "SayHello", "name": "SayHello", "fields": [ {"key": "type", "stringValue": "ShellCommandActivity"}, {"key": "command", "stringValue": "echo hello"}, {"key": "parent", "refValue": "Default"}, {"key": "schedule", "refValue": "Schedule"} ] } ] }
    /// </request>
    /// <response>
    /// HTTP/1.1 200 x-amzn-RequestId: f74afc14-0754-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 18 Date: Mon, 12 Nov 2012 17:50:53 GMT {"errored": false}
    /// </response>
    /// </example>
    /// <example>
    /// <name>
    /// Example 2
    /// </name>
    /// <description>
    /// This example sets an invalid pipeline configuration (the value for
    /// <code>workerGroup</code> is an empty string) and returns an error message.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.PutPipelineDefinition Content-Length: 903 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE", "pipelineObjects": [ {"id": "Default", "name": "Default", "fields": [ {"key": "workerGroup", "stringValue": ""} ] }, {"id": "Schedule", "name": "Schedule", "fields": [ {"key": "startDateTime", "stringValue": "2012-09-25T17:00:00"}, {"key": "type", "stringValue": "Schedule"}, {"key": "period", "stringValue": "1 hour"}, {"key": "endDateTime", "stringValue": "2012-09-25T18:00:00"} ] }, {"id": "SayHello", "name": "SayHello", "fields": [ {"key": "type", "stringValue": "ShellCommandActivity"}, {"key": "command", "stringValue": "echo hello"}, {"key": "parent", "refValue": "Default"}, {"key": "schedule", "refValue": "Schedule"} ] } ] }
    /// </request>
    /// <response>
    /// HTTP/1.1 200 x-amzn-RequestId: f74afc14-0754-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 18 Date: Mon, 12 Nov 2012 17:50:53 GMT {"__type": "com.amazon.setl.webservice#InvalidRequestException", "message": "Pipeline definition has errors: Could not save the pipeline definition due to FATAL errors: [com.amazon.setl.webservice.ValidationError@108d7ea9] Please call Validate to validate your pipeline"}
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPipelineDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_pipeline_definition_input::Builder,
    }
    impl<C, M, R> PutPipelineDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPipelineDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPipelineDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPipelineDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPipelineDefinitionInputOperationOutputAlias,
                crate::output::PutPipelineDefinitionOutput,
                crate::error::PutPipelineDefinitionError,
                crate::input::PutPipelineDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `pipelineObjects`.
        ///
        /// To override the contents of this collection use [`set_pipeline_objects`](Self::set_pipeline_objects).
        ///
        /// <p>The objects that define the pipeline. These objects overwrite the existing pipeline definition.</p>
        pub fn pipeline_objects(mut self, input: crate::model::PipelineObject) -> Self {
            self.inner = self.inner.pipeline_objects(input);
            self
        }
        /// <p>The objects that define the pipeline. These objects overwrite the existing pipeline definition.</p>
        pub fn set_pipeline_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_objects(input);
            self
        }
        /// Appends an item to `parameterObjects`.
        ///
        /// To override the contents of this collection use [`set_parameter_objects`](Self::set_parameter_objects).
        ///
        /// <p>The parameter objects used with the pipeline.</p>
        pub fn parameter_objects(mut self, input: crate::model::ParameterObject) -> Self {
            self.inner = self.inner.parameter_objects(input);
            self
        }
        /// <p>The parameter objects used with the pipeline.</p>
        pub fn set_parameter_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterObject>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_objects(input);
            self
        }
        /// Appends an item to `parameterValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_values`](Self::set_parameter_values).
        ///
        /// <p>The parameter values used with the pipeline.</p>
        pub fn parameter_values(mut self, input: crate::model::ParameterValue) -> Self {
            self.inner = self.inner.parameter_values(input);
            self
        }
        /// <p>The parameter values used with the pipeline.</p>
        pub fn set_parameter_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `QueryObjects`.
    ///
    /// <p>Queries the specified pipeline for the names of objects that match the specified set of conditions.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.QueryObjects Content-Length: 123 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE", "query": {"selectors": [ ] }, "sphere": "INSTANCE", "marker": "", "limit": 10}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 14d704c1-0775-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 72 Date: Mon, 12 Nov 2012 17:50:53 GMT {"hasMoreResults": false, "ids": ["@SayHello_1_2012-09-25T17:00:00"] }
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct QueryObjects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::query_objects_input::Builder,
    }
    impl<C, M, R> QueryObjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `QueryObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QueryObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::QueryObjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::QueryObjectsInputOperationOutputAlias,
                crate::output::QueryObjectsOutput,
                crate::error::QueryObjectsError,
                crate::input::QueryObjectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::QueryObjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::QueryObjectsPaginator<C, M, R> {
            crate::paginator::QueryObjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// <p>The query that defines the objects to be returned. The <code>Query</code> object can contain a maximum of ten selectors. The conditions in the query are limited to top-level String fields in the object. These filters can be applied to components, instances, and attempts.</p>
        pub fn query(mut self, input: crate::model::Query) -> Self {
            self.inner = self.inner.query(input);
            self
        }
        /// <p>The query that defines the objects to be returned. The <code>Query</code> object can contain a maximum of ten selectors. The conditions in the query are limited to top-level String fields in the object. These filters can be applied to components, instances, and attempts.</p>
        pub fn set_query(mut self, input: std::option::Option<crate::model::Query>) -> Self {
            self.inner = self.inner.set_query(input);
            self
        }
        /// <p>Indicates whether the query applies to components or instances. The possible values are: <code>COMPONENT</code>, <code>INSTANCE</code>, and <code>ATTEMPT</code>.</p>
        pub fn sphere(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sphere(input.into());
            self
        }
        /// <p>Indicates whether the query applies to components or instances. The possible values are: <code>COMPONENT</code>, <code>INSTANCE</code>, and <code>ATTEMPT</code>.</p>
        pub fn set_sphere(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sphere(input);
            self
        }
        /// <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>QueryObjects</code> with the marker value from the previous call to retrieve the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call <code>QueryObjects</code> with the marker value from the previous call to retrieve the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of object names that <code>QueryObjects</code> will return in a single call. The default value is 100. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of object names that <code>QueryObjects</code> will return in a single call. The default value is 100. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes existing tags from the specified pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl<C, M, R> RemoveTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsInputOperationOutputAlias,
                crate::output::RemoveTagsOutput,
                crate::error::RemoveTagsError,
                crate::input::RemoveTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReportTaskProgress`.
    ///
    /// <p>Task runners call <code>ReportTaskProgress</code> when assigned a task to acknowledge that it has the task. If the web service does not receive this acknowledgement within 2 minutes, it assigns the task in a subsequent <code>PollForTask</code> call. After this initial acknowledgement, the task runner only needs to report progress every 15 minutes to maintain its ownership of the task. You can change this reporting time from 15 minutes by specifying a <code>reportProgressTimeout</code> field in your pipeline.</p>
    /// <p>If a task runner does not report its status after 5 minutes, AWS Data Pipeline assumes that the task runner is unable to process the task and reassigns the task in a subsequent response to <code>PollForTask</code>. Task runners should call <code>ReportTaskProgress</code> every 60 seconds.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.ReportTaskProgress Content-Length: 832 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"taskId": "aaGgHT4LuH0T0Y0oLrJRjas5qH0d8cDPADxqq3tn+zCWGELkCdV2JprLreXm1oxeP5EFZHFLJ69kjSsLYE0iYHYBYVGBrB+E/pYq7ANEEeGJFnSBMRiXZVA+8UJ3OzcInvXeinqBmBaKwii7hnnKb/AXjXiNTXyxgydX1KAyg1AxkwBYG4cfPYMZbuEbQJFJvv5C/2+GVXz1w94nKYTeUeepwUOFOuRLS6JVtZoYwpF56E+Yfk1IcGpFOvCZ01B4Bkuu7x3J+MD/j6kJgZLAgbCJQtI3eiW3kdGmX0p0I2BdY1ZsX6b4UiSvM3OMj6NEHJCJL4E0ZfitnhCoe24Kvjo6C2hFbZq+ei/HPgSXBQMSagkr4vS9c0ChzxH2+LNYvec6bY4kymkaZI1dvOzmpa0FcnGf5AjSK4GpsViZ/ujz6zxFv81qBXzjF0/4M1775rjV1VUdyKaixiA/sJiACNezqZqETidp8d24BDPRhGsj6pBCrnelqGFrk/gXEXUsJ+xwMifRC8UVwiKekpAvHUywVk7Ku4jH/n3i2VoLRP6FXwpUbelu34iiZ9czpXyLtyPKwxa87dlrnRVURwkcVjOt2Mcrcaqe+cbWHvNRhyrPkkdfSF3ac8/wfgVbXvLEB2k9mKc67aD9rvdc1PKX09Tk8BKklsMTpZ3TRCd4NzQlJKigMe8Jat9+1tKj4Ole5ZzW6uyTu2s2iFjEV8KXu4MaiRJyNKCdKeGhhZWY37Qk4NBK4Ppgu+C6Y41dpfOh288SLDEVx0/UySlqOEdhba7c6BiPp5r3hKj3mk9lFy5OYp1aoGLeeFmjXveTnPdf2gkWqXXg7AUbJ7jEs1F0lKZQg4szep2gcKyAJXgvXLfJJHcha8Lfb/Ee7wYmyOcAaRpDBoFNSbtoVXar46teIrpho+ZDvynUXvU0grHWGOk=:wn3SgymHZM99bEXAMPLE", "fields": [ {"key": "percentComplete", "stringValue": "50"} ] }
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 640bd023-0775-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 18 Date: Mon, 12 Nov 2012 17:50:53 GMT {"canceled": false}
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReportTaskProgress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::report_task_progress_input::Builder,
    }
    impl<C, M, R> ReportTaskProgress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReportTaskProgress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReportTaskProgressOutput,
            aws_smithy_http::result::SdkError<crate::error::ReportTaskProgressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReportTaskProgressInputOperationOutputAlias,
                crate::output::ReportTaskProgressOutput,
                crate::error::ReportTaskProgressError,
                crate::input::ReportTaskProgressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the task assigned to the task runner. This value is provided in the response for <code>PollForTask</code>.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the task assigned to the task runner. This value is provided in the response for <code>PollForTask</code>.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>Key-value pairs that define the properties of the ReportTaskProgressInput object.</p>
        pub fn fields(mut self, input: crate::model::Field) -> Self {
            self.inner = self.inner.fields(input);
            self
        }
        /// <p>Key-value pairs that define the properties of the ReportTaskProgressInput object.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReportTaskRunnerHeartbeat`.
    ///
    /// <p>Task runners call <code>ReportTaskRunnerHeartbeat</code> every 15 minutes to indicate that they are operational. If the AWS Data Pipeline Task Runner is launched on a resource managed by AWS Data Pipeline, the web service can use this call to detect when the task runner application has failed and restart a new instance.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.ReportTaskRunnerHeartbeat Content-Length: 84 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"taskrunnerId": "1234567890", "workerGroup": "wg-12345", "hostname": "example.com"}
    /// </request>
    /// <response>
    /// Status: x-amzn-RequestId: b3104dc5-0734-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 20 Date: Mon, 12 Nov 2012 17:50:53 GMT {"terminate": false}
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReportTaskRunnerHeartbeat<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::report_task_runner_heartbeat_input::Builder,
    }
    impl<C, M, R> ReportTaskRunnerHeartbeat<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReportTaskRunnerHeartbeat`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReportTaskRunnerHeartbeatOutput,
            aws_smithy_http::result::SdkError<crate::error::ReportTaskRunnerHeartbeatError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReportTaskRunnerHeartbeatInputOperationOutputAlias,
                crate::output::ReportTaskRunnerHeartbeatOutput,
                crate::error::ReportTaskRunnerHeartbeatError,
                crate::input::ReportTaskRunnerHeartbeatInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier when it launches the application. If you have written a custom task runner, you should assign a unique identifier for the task runner.</p>
        pub fn taskrunner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.taskrunner_id(input.into());
            self
        }
        /// <p>The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier when it launches the application. If you have written a custom task runner, you should assign a unique identifier for the task runner.</p>
        pub fn set_taskrunner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_taskrunner_id(input);
            self
        }
        /// <p>The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.</p>
        pub fn worker_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_group(input.into());
            self
        }
        /// <p>The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.</p>
        pub fn set_worker_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_group(input);
            self
        }
        /// <p>The public DNS name of the task runner.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hostname(input.into());
            self
        }
        /// <p>The public DNS name of the task runner.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hostname(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetStatus`.
    ///
    /// <p>Requests that the status of the specified physical or logical pipeline objects be updated in the specified pipeline. This update might not occur immediately, but is eventually consistent. The status that can be set depends on the type of object (for example, DataNode or Activity). You cannot perform this operation on <code>FINISHED</code> pipelines and attempting to do so returns <code>InvalidRequestException</code>.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.SetStatus Content-Length: 100 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-0634701J7KEXAMPLE", "objectIds": ["o-08600941GHJWMBR9E2"], "status": "pause"}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: e83b8ab7-076a-11e2-af6f-6bc7a6be60d9 Content-Type: application/x-amz-json-1.1 Content-Length: 0 Date: Mon, 12 Nov 2012 17:50:53 GMT Unexpected response: 200, OK, undefined
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_status_input::Builder,
    }
    impl<C, M, R> SetStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::SetStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetStatusInputOperationOutputAlias,
                crate::output::SetStatusOutput,
                crate::error::SetStatusError,
                crate::input::SetStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline that contains the objects.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline that contains the objects.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `objectIds`.
        ///
        /// To override the contents of this collection use [`set_object_ids`](Self::set_object_ids).
        ///
        /// <p>The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both types.</p>
        pub fn object_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_ids(input.into());
            self
        }
        /// <p>The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both types.</p>
        pub fn set_object_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_object_ids(input);
            self
        }
        /// <p>The status to be set on all the objects specified in <code>objectIds</code>. For components, use <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>, <code>RERUN</code>, or <code>MARK_FINISHED</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>The status to be set on all the objects specified in <code>objectIds</code>. For components, use <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>, <code>RERUN</code>, or <code>MARK_FINISHED</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTaskStatus`.
    ///
    /// <p>Task runners call <code>SetTaskStatus</code> to notify AWS Data Pipeline that a task is completed and provide information about the final status. A task runner makes this call regardless of whether the task was sucessful. A task runner does not need to call <code>SetTaskStatus</code> for tasks that are canceled by the web service during a call to <code>ReportTaskProgress</code>.</p> <examples>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.SetTaskStatus Content-Length: 847 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"taskId": "aaGgHT4LuH0T0Y0oLrJRjas5qH0d8cDPADxqq3tn+zCWGELkCdV2JprLreXm1oxeP5EFZHFLJ69kjSsLYE0iYHYBYVGBrB+E/pYq7ANEEeGJFnSBMRiXZVA+8UJ3OzcInvXeinqBmBaKwii7hnnKb/AXjXiNTXyxgydX1KAyg1AxkwBYG4cfPYMZbuEbQJFJvv5C/2+GVXz1w94nKYTeUeepwUOFOuRLS6JVtZoYwpF56E+Yfk1IcGpFOvCZ01B4Bkuu7x3J+MD/j6kJgZLAgbCJQtI3eiW3kdGmX0p0I2BdY1ZsX6b4UiSvM3OMj6NEHJCJL4E0ZfitnhCoe24Kvjo6C2hFbZq+ei/HPgSXBQMSagkr4vS9c0ChzxH2+LNYvec6bY4kymkaZI1dvOzmpa0FcnGf5AjSK4GpsViZ/ujz6zxFv81qBXzjF0/4M1775rjV1VUdyKaixiA/sJiACNezqZqETidp8d24BDPRhGsj6pBCrnelqGFrk/gXEXUsJ+xwMifRC8UVwiKekpAvHUywVk7Ku4jH/n3i2VoLRP6FXwpUbelu34iiZ9czpXyLtyPKwxa87dlrnRVURwkcVjOt2Mcrcaqe+cbWHvNRhyrPkkdfSF3ac8/wfgVbXvLEB2k9mKc67aD9rvdc1PKX09Tk8BKklsMTpZ3TRCd4NzQlJKigMe8Jat9+1tKj4Ole5ZzW6uyTu2s2iFjEV8KXu4MaiRJyNKCdKeGhhZWY37Qk4NBK4Ppgu+C6Y41dpfOh288SLDEVx0/UySlqOEdhba7c6BiPp5r3hKj3mk9lFy5OYp1aoGLeeFmjXveTnPdf2gkWqXXg7AUbJ7jEs1F0lKZQg4szep2gcKyAJXgvXLfJJHcha8Lfb/Ee7wYmyOcAaRpDBoFNSbtoVXar46teIrpho+ZDvynUXvU0grHWGOk=:wn3SgymHZM99bEXAMPLE", "taskStatus": "FINISHED"}
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 8c8deb53-0788-11e2-af9c-6bc7a6be6qr8 Content-Type: application/x-amz-json-1.1 Content-Length: 0 Date: Mon, 12 Nov 2012 17:50:53 GMT {}
    /// </response>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetTaskStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_task_status_input::Builder,
    }
    impl<C, M, R> SetTaskStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetTaskStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTaskStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTaskStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetTaskStatusInputOperationOutputAlias,
                crate::output::SetTaskStatusOutput,
                crate::error::SetTaskStatusError,
                crate::input::SetTaskStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the task assigned to the task runner. This value is provided in the response for <code>PollForTask</code>.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the task assigned to the task runner. This value is provided in the response for <code>PollForTask</code>.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended unsuccessfully. Preconditions use false.</p>
        pub fn task_status(mut self, input: crate::model::TaskStatus) -> Self {
            self.inner = self.inner.task_status(input);
            self
        }
        /// <p>If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended unsuccessfully. Preconditions use false.</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::TaskStatus>,
        ) -> Self {
            self.inner = self.inner.set_task_status(input);
            self
        }
        /// <p>If an error occurred during the task, this value specifies the error code. This value is set on the physical attempt object. It is used to display error information to the user. It should not start with string "Service_" which is reserved by the system.</p>
        pub fn error_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error_id(input.into());
            self
        }
        /// <p>If an error occurred during the task, this value specifies the error code. This value is set on the physical attempt object. It is used to display error information to the user. It should not start with string "Service_" which is reserved by the system.</p>
        pub fn set_error_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_error_id(input);
            self
        }
        /// <p>If an error occurred during the task, this value specifies a text description of the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error_message(input.into());
            self
        }
        /// <p>If an error occurred during the task, this value specifies a text description of the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_error_message(input);
            self
        }
        /// <p>If an error occurred during the task, this value specifies the stack trace associated with the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value.</p>
        pub fn error_stack_trace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error_stack_trace(input.into());
            self
        }
        /// <p>If an error occurred during the task, this value specifies the stack trace associated with the error. This value is set on the physical attempt object. It is used to display error information to the user. The web service does not parse this value.</p>
        pub fn set_error_stack_trace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_error_stack_trace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidatePipelineDefinition`.
    ///
    /// <p>Validates the specified pipeline definition to ensure that it is well formed and can be run without error.</p> <examples>
    /// <example>
    /// <name>
    /// Example 1
    /// </name>
    /// <description>
    /// This example sets an valid pipeline configuration and returns success.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.ValidatePipelineDefinition Content-Length: 936 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE", "pipelineObjects": [ {"id": "Default", "name": "Default", "fields": [ {"key": "workerGroup", "stringValue": "MyworkerGroup"} ] }, {"id": "Schedule", "name": "Schedule", "fields": [ {"key": "startDateTime", "stringValue": "2012-09-25T17:00:00"}, {"key": "type", "stringValue": "Schedule"}, {"key": "period", "stringValue": "1 hour"}, {"key": "endDateTime", "stringValue": "2012-09-25T18:00:00"} ] }, {"id": "SayHello", "name": "SayHello", "fields": [ {"key": "type", "stringValue": "ShellCommandActivity"}, {"key": "command", "stringValue": "echo hello"}, {"key": "parent", "refValue": "Default"}, {"key": "schedule", "refValue": "Schedule"} ] } ] }
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 92c9f347-0776-11e2-8a14-21bb8a1f50ef Content-Type: application/x-amz-json-1.1 Content-Length: 18 Date: Mon, 12 Nov 2012 17:50:53 GMT {"errored": false}
    /// </response>
    /// </example>
    /// <example>
    /// <name>
    /// Example 2
    /// </name>
    /// <description>
    /// This example sets an invalid pipeline configuration and returns the associated set of validation errors.
    /// </description>
    /// <request>
    /// POST / HTTP/1.1 Content-Type: application/x-amz-json-1.1 X-Amz-Target: DataPipeline.ValidatePipelineDefinition Content-Length: 903 Host: datapipeline.us-east-1.amazonaws.com X-Amz-Date: Mon, 12 Nov 2012 17:49:52 GMT Authorization: AuthParams {"pipelineId": "df-06372391ZG65EXAMPLE", "pipelineObjects": [ {"id": "Default", "name": "Default", "fields": [ {"key": "workerGroup", "stringValue": "MyworkerGroup"} ] }, {"id": "Schedule", "name": "Schedule", "fields": [ {"key": "startDateTime", "stringValue": "bad-time"}, {"key": "type", "stringValue": "Schedule"}, {"key": "period", "stringValue": "1 hour"}, {"key": "endDateTime", "stringValue": "2012-09-25T18:00:00"} ] }, {"id": "SayHello", "name": "SayHello", "fields": [ {"key": "type", "stringValue": "ShellCommandActivity"}, {"key": "command", "stringValue": "echo hello"}, {"key": "parent", "refValue": "Default"}, {"key": "schedule", "refValue": "Schedule"} ] } ] }
    /// </request>
    /// <response>
    /// x-amzn-RequestId: 496a1f5a-0e6a-11e2-a61c-bd6312c92ddd Content-Type: application/x-amz-json-1.1 Content-Length: 278 Date: Mon, 12 Nov 2012 17:50:53 GMT {"errored": true, "validationErrors": [ {"errors": ["INVALID_FIELD_VALUE: 'startDateTime' value must be a literal datetime value."], "id": "Schedule"} ] }
    /// </response>
    /// </example>
    /// </examples>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidatePipelineDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::validate_pipeline_definition_input::Builder,
    }
    impl<C, M, R> ValidatePipelineDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ValidatePipelineDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidatePipelineDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidatePipelineDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ValidatePipelineDefinitionInputOperationOutputAlias,
                crate::output::ValidatePipelineDefinitionOutput,
                crate::error::ValidatePipelineDefinitionError,
                crate::input::ValidatePipelineDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pipeline.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_id(input.into());
            self
        }
        /// <p>The ID of the pipeline.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pipeline_id(input);
            self
        }
        /// Appends an item to `pipelineObjects`.
        ///
        /// To override the contents of this collection use [`set_pipeline_objects`](Self::set_pipeline_objects).
        ///
        /// <p>The objects that define the pipeline changes to validate against the pipeline.</p>
        pub fn pipeline_objects(mut self, input: crate::model::PipelineObject) -> Self {
            self.inner = self.inner.pipeline_objects(input);
            self
        }
        /// <p>The objects that define the pipeline changes to validate against the pipeline.</p>
        pub fn set_pipeline_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_objects(input);
            self
        }
        /// Appends an item to `parameterObjects`.
        ///
        /// To override the contents of this collection use [`set_parameter_objects`](Self::set_parameter_objects).
        ///
        /// <p>The parameter objects used with the pipeline.</p>
        pub fn parameter_objects(mut self, input: crate::model::ParameterObject) -> Self {
            self.inner = self.inner.parameter_objects(input);
            self
        }
        /// <p>The parameter objects used with the pipeline.</p>
        pub fn set_parameter_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterObject>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_objects(input);
            self
        }
        /// Appends an item to `parameterValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_values`](Self::set_parameter_values).
        ///
        /// <p>The parameter values used with the pipeline.</p>
        pub fn parameter_values(mut self, input: crate::model::ParameterValue) -> Self {
            self.inner = self.inner.parameter_values(input);
            self
        }
        /// <p>The parameter values used with the pipeline.</p>
        pub fn set_parameter_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_values(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
