// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Defines a validation warning. Validation warnings do not prevent pipeline activation. The set of validation warnings that can be returned are defined by AWS Data Pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationWarning {
    /// <p>The identifier of the object that contains the validation warning.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A description of the validation warning.</p>
    pub warnings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ValidationWarning {
    /// <p>The identifier of the object that contains the validation warning.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A description of the validation warning.</p>
    pub fn warnings(&self) -> std::option::Option<&[std::string::String]> {
        self.warnings.as_deref()
    }
}
impl std::fmt::Debug for ValidationWarning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationWarning");
        formatter.field("id", &self.id);
        formatter.field("warnings", &self.warnings);
        formatter.finish()
    }
}
/// See [`ValidationWarning`](crate::model::ValidationWarning)
pub mod validation_warning {
    /// A builder for [`ValidationWarning`](crate::model::ValidationWarning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the object that contains the validation warning.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the object that contains the validation warning.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `warnings`.
        ///
        /// To override the contents of this collection use [`set_warnings`](Self::set_warnings).
        ///
        /// <p>A description of the validation warning.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.warnings.unwrap_or_default();
            v.push(input.into());
            self.warnings = Some(v);
            self
        }
        /// <p>A description of the validation warning.</p>
        pub fn set_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.warnings = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationWarning`](crate::model::ValidationWarning)
        pub fn build(self) -> crate::model::ValidationWarning {
            crate::model::ValidationWarning {
                id: self.id,
                warnings: self.warnings,
            }
        }
    }
}
impl ValidationWarning {
    /// Creates a new builder-style object to manufacture [`ValidationWarning`](crate::model::ValidationWarning)
    pub fn builder() -> crate::model::validation_warning::Builder {
        crate::model::validation_warning::Builder::default()
    }
}

/// <p>Defines a validation error. Validation errors prevent pipeline activation. The set of validation errors that can be returned are defined by AWS Data Pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationError {
    /// <p>The identifier of the object that contains the validation error.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A description of the validation error.</p>
    pub errors: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ValidationError {
    /// <p>The identifier of the object that contains the validation error.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A description of the validation error.</p>
    pub fn errors(&self) -> std::option::Option<&[std::string::String]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for ValidationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationError");
        formatter.field("id", &self.id);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`ValidationError`](crate::model::ValidationError)
pub mod validation_error {
    /// A builder for [`ValidationError`](crate::model::ValidationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) errors: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the object that contains the validation error.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the object that contains the validation error.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A description of the validation error.</p>
        pub fn errors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A description of the validation error.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationError`](crate::model::ValidationError)
        pub fn build(self) -> crate::model::ValidationError {
            crate::model::ValidationError {
                id: self.id,
                errors: self.errors,
            }
        }
    }
}
impl ValidationError {
    /// Creates a new builder-style object to manufacture [`ValidationError`](crate::model::ValidationError)
    pub fn builder() -> crate::model::validation_error::Builder {
        crate::model::validation_error::Builder::default()
    }
}

/// <p>A value or list of parameter values. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterValue {
    /// <p>The ID of the parameter value.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The field value, expressed as a String.</p>
    pub string_value: std::option::Option<std::string::String>,
}
impl ParameterValue {
    /// <p>The ID of the parameter value.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The field value, expressed as a String.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
}
impl std::fmt::Debug for ParameterValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterValue");
        formatter.field("id", &self.id);
        formatter.field("string_value", &self.string_value);
        formatter.finish()
    }
}
/// See [`ParameterValue`](crate::model::ParameterValue)
pub mod parameter_value {
    /// A builder for [`ParameterValue`](crate::model::ParameterValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) string_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the parameter value.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the parameter value.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The field value, expressed as a String.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>The field value, expressed as a String.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterValue`](crate::model::ParameterValue)
        pub fn build(self) -> crate::model::ParameterValue {
            crate::model::ParameterValue {
                id: self.id,
                string_value: self.string_value,
            }
        }
    }
}
impl ParameterValue {
    /// Creates a new builder-style object to manufacture [`ParameterValue`](crate::model::ParameterValue)
    pub fn builder() -> crate::model::parameter_value::Builder {
        crate::model::parameter_value::Builder::default()
    }
}

/// <p>Contains information about a parameter object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterObject {
    /// <p>The ID of the parameter object. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The attributes of the parameter object.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::ParameterAttribute>>,
}
impl ParameterObject {
    /// <p>The ID of the parameter object. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The attributes of the parameter object.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::ParameterAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for ParameterObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterObject");
        formatter.field("id", &self.id);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`ParameterObject`](crate::model::ParameterObject)
pub mod parameter_object {
    /// A builder for [`ParameterObject`](crate::model::ParameterObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::ParameterAttribute>>,
    }
    impl Builder {
        /// <p>The ID of the parameter object. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the parameter object. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes of the parameter object.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::ParameterAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes of the parameter object.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterObject`](crate::model::ParameterObject)
        pub fn build(self) -> crate::model::ParameterObject {
            crate::model::ParameterObject {
                id: self.id,
                attributes: self.attributes,
            }
        }
    }
}
impl ParameterObject {
    /// Creates a new builder-style object to manufacture [`ParameterObject`](crate::model::ParameterObject)
    pub fn builder() -> crate::model::parameter_object::Builder {
        crate::model::parameter_object::Builder::default()
    }
}

/// <p>The attributes allowed or specified with a parameter object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterAttribute {
    /// <p>The field identifier.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The field value, expressed as a String.</p>
    pub string_value: std::option::Option<std::string::String>,
}
impl ParameterAttribute {
    /// <p>The field identifier.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The field value, expressed as a String.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
}
impl std::fmt::Debug for ParameterAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterAttribute");
        formatter.field("key", &self.key);
        formatter.field("string_value", &self.string_value);
        formatter.finish()
    }
}
/// See [`ParameterAttribute`](crate::model::ParameterAttribute)
pub mod parameter_attribute {
    /// A builder for [`ParameterAttribute`](crate::model::ParameterAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) string_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field identifier.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The field identifier.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The field value, expressed as a String.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>The field value, expressed as a String.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterAttribute`](crate::model::ParameterAttribute)
        pub fn build(self) -> crate::model::ParameterAttribute {
            crate::model::ParameterAttribute {
                key: self.key,
                string_value: self.string_value,
            }
        }
    }
}
impl ParameterAttribute {
    /// Creates a new builder-style object to manufacture [`ParameterAttribute`](crate::model::ParameterAttribute)
    pub fn builder() -> crate::model::parameter_attribute::Builder {
        crate::model::parameter_attribute::Builder::default()
    }
}

/// <p>Contains information about a pipeline object. This can be a logical, physical, or physical attempt pipeline object. The complete set of components of a pipeline defines the pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineObject {
    /// <p>The ID of the object.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the object.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Key-value pairs that define the properties of the object.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
}
impl PipelineObject {
    /// <p>The ID of the object.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the object.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Key-value pairs that define the properties of the object.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for PipelineObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineObject");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
/// See [`PipelineObject`](crate::model::PipelineObject)
pub mod pipeline_object {
    /// A builder for [`PipelineObject`](crate::model::PipelineObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    }
    impl Builder {
        /// <p>The ID of the object.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the object.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the object.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>Key-value pairs that define the properties of the object.</p>
        pub fn fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>Key-value pairs that define the properties of the object.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineObject`](crate::model::PipelineObject)
        pub fn build(self) -> crate::model::PipelineObject {
            crate::model::PipelineObject {
                id: self.id,
                name: self.name,
                fields: self.fields,
            }
        }
    }
}
impl PipelineObject {
    /// Creates a new builder-style object to manufacture [`PipelineObject`](crate::model::PipelineObject)
    pub fn builder() -> crate::model::pipeline_object::Builder {
        crate::model::pipeline_object::Builder::default()
    }
}

/// <p>A key-value pair that describes a property of a pipeline object. The value is specified as either a string value (<code>StringValue</code>) or a reference to another object (<code>RefValue</code>) but not as both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Field {
    /// <p>The field identifier.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The field value, expressed as a String.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>The field value, expressed as the identifier of another object.</p>
    pub ref_value: std::option::Option<std::string::String>,
}
impl Field {
    /// <p>The field identifier.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The field value, expressed as a String.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>The field value, expressed as the identifier of another object.</p>
    pub fn ref_value(&self) -> std::option::Option<&str> {
        self.ref_value.as_deref()
    }
}
impl std::fmt::Debug for Field {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Field");
        formatter.field("key", &self.key);
        formatter.field("string_value", &self.string_value);
        formatter.field("ref_value", &self.ref_value);
        formatter.finish()
    }
}
/// See [`Field`](crate::model::Field)
pub mod field {
    /// A builder for [`Field`](crate::model::Field)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) ref_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field identifier.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The field identifier.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The field value, expressed as a String.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>The field value, expressed as a String.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>The field value, expressed as the identifier of another object.</p>
        pub fn ref_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.ref_value = Some(input.into());
            self
        }
        /// <p>The field value, expressed as the identifier of another object.</p>
        pub fn set_ref_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ref_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Field`](crate::model::Field)
        pub fn build(self) -> crate::model::Field {
            crate::model::Field {
                key: self.key,
                string_value: self.string_value,
                ref_value: self.ref_value,
            }
        }
    }
}
impl Field {
    /// Creates a new builder-style object to manufacture [`Field`](crate::model::Field)
    pub fn builder() -> crate::model::field::Builder {
        crate::model::field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => TaskStatus::Failed,
            "FALSE" => TaskStatus::False,
            "FINISHED" => TaskStatus::Finished,
            other => TaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskStatus::from(s))
    }
}
impl TaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskStatus::Failed => "FAILED",
            TaskStatus::False => "FALSE",
            TaskStatus::Finished => "FINISHED",
            TaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "FALSE", "FINISHED"]
    }
}
impl AsRef<str> for TaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the query to run against an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Query {
    /// <p>List of selectors that define the query. An object must satisfy all of the selectors to match the query.</p>
    pub selectors: std::option::Option<std::vec::Vec<crate::model::Selector>>,
}
impl Query {
    /// <p>List of selectors that define the query. An object must satisfy all of the selectors to match the query.</p>
    pub fn selectors(&self) -> std::option::Option<&[crate::model::Selector]> {
        self.selectors.as_deref()
    }
}
impl std::fmt::Debug for Query {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Query");
        formatter.field("selectors", &self.selectors);
        formatter.finish()
    }
}
/// See [`Query`](crate::model::Query)
pub mod query {
    /// A builder for [`Query`](crate::model::Query)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selectors: std::option::Option<std::vec::Vec<crate::model::Selector>>,
    }
    impl Builder {
        /// Appends an item to `selectors`.
        ///
        /// To override the contents of this collection use [`set_selectors`](Self::set_selectors).
        ///
        /// <p>List of selectors that define the query. An object must satisfy all of the selectors to match the query.</p>
        pub fn selectors(mut self, input: impl Into<crate::model::Selector>) -> Self {
            let mut v = self.selectors.unwrap_or_default();
            v.push(input.into());
            self.selectors = Some(v);
            self
        }
        /// <p>List of selectors that define the query. An object must satisfy all of the selectors to match the query.</p>
        pub fn set_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Selector>>,
        ) -> Self {
            self.selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`Query`](crate::model::Query)
        pub fn build(self) -> crate::model::Query {
            crate::model::Query {
                selectors: self.selectors,
            }
        }
    }
}
impl Query {
    /// Creates a new builder-style object to manufacture [`Query`](crate::model::Query)
    pub fn builder() -> crate::model::query::Builder {
        crate::model::query::Builder::default()
    }
}

/// <p>A comparision that is used to determine whether a query should return this object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Selector {
    /// <p>The name of the field that the operator will be applied to. The field name is the "key" portion of the field definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the field is not set on the object, the condition fails.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>Contains a logical operation for comparing the value of a field with a specified value.</p>
    pub operator: std::option::Option<crate::model::Operator>,
}
impl Selector {
    /// <p>The name of the field that the operator will be applied to. The field name is the "key" portion of the field definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the field is not set on the object, the condition fails.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
    /// <p>Contains a logical operation for comparing the value of a field with a specified value.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::Operator> {
        self.operator.as_ref()
    }
}
impl std::fmt::Debug for Selector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Selector");
        formatter.field("field_name", &self.field_name);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`Selector`](crate::model::Selector)
pub mod selector {
    /// A builder for [`Selector`](crate::model::Selector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<crate::model::Operator>,
    }
    impl Builder {
        /// <p>The name of the field that the operator will be applied to. The field name is the "key" portion of the field definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the field is not set on the object, the condition fails.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The name of the field that the operator will be applied to. The field name is the "key" portion of the field definition in the pipeline definition syntax that is used by the AWS Data Pipeline API. If the field is not set on the object, the condition fails.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>Contains a logical operation for comparing the value of a field with a specified value.</p>
        pub fn operator(mut self, input: crate::model::Operator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>Contains a logical operation for comparing the value of a field with a specified value.</p>
        pub fn set_operator(mut self, input: std::option::Option<crate::model::Operator>) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`Selector`](crate::model::Selector)
        pub fn build(self) -> crate::model::Selector {
            crate::model::Selector {
                field_name: self.field_name,
                operator: self.operator,
            }
        }
    }
}
impl Selector {
    /// Creates a new builder-style object to manufacture [`Selector`](crate::model::Selector)
    pub fn builder() -> crate::model::selector::Builder {
        crate::model::selector::Builder::default()
    }
}

/// <p>Contains a logical operation for comparing the value of a field with a specified value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Operator {
    /// <p>
    /// The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can be used only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.  
    /// </p>
    /// <p>
    /// The comparison operators EQ and REF_EQ act on the following fields:
    /// </p>
    /// <ul>
    /// <li>name</li>
    /// <li>@sphere</li>
    /// <li>parent</li>
    /// <li>@componentParent</li>
    /// <li>@instanceParent</li>
    /// <li>@status</li>
    /// <li>@scheduledStartTime</li>
    /// <li>@scheduledEndTime</li>
    /// <li>@actualStartTime</li>
    /// <li>@actualEndTime</li>
    /// </ul>
    ///
    /// <p>
    /// The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following fields:
    /// </p>
    /// <ul>
    /// <li>@scheduledStartTime</li>
    /// <li>@scheduledEndTime</li>
    /// <li>@actualStartTime</li>
    /// <li>@actualEndTime</li>
    /// </ul>
    /// <p>Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".</p>
    pub r#type: std::option::Option<crate::model::OperatorType>,
    /// <p>The value that the actual field value will be compared with.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Operator {
    /// <p>
    /// The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can be used only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.  
    /// </p>
    /// <p>
    /// The comparison operators EQ and REF_EQ act on the following fields:
    /// </p>
    /// <ul>
    /// <li>name</li>
    /// <li>@sphere</li>
    /// <li>parent</li>
    /// <li>@componentParent</li>
    /// <li>@instanceParent</li>
    /// <li>@status</li>
    /// <li>@scheduledStartTime</li>
    /// <li>@scheduledEndTime</li>
    /// <li>@actualStartTime</li>
    /// <li>@actualEndTime</li>
    /// </ul>
    ///
    /// <p>
    /// The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following fields:
    /// </p>
    /// <ul>
    /// <li>@scheduledStartTime</li>
    /// <li>@scheduledEndTime</li>
    /// <li>@actualStartTime</li>
    /// <li>@actualEndTime</li>
    /// </ul>
    /// <p>Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OperatorType> {
        self.r#type.as_ref()
    }
    /// <p>The value that the actual field value will be compared with.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Operator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Operator");
        formatter.field("r#type", &self.r#type);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Operator`](crate::model::Operator)
pub mod operator {
    /// A builder for [`Operator`](crate::model::Operator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::OperatorType>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can be used only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.  
        /// </p>
        /// <p>
        /// The comparison operators EQ and REF_EQ act on the following fields:
        /// </p>
        /// <ul>
        /// <li>name</li>
        /// <li>@sphere</li>
        /// <li>parent</li>
        /// <li>@componentParent</li>
        /// <li>@instanceParent</li>
        /// <li>@status</li>
        /// <li>@scheduledStartTime</li>
        /// <li>@scheduledEndTime</li>
        /// <li>@actualStartTime</li>
        /// <li>@actualEndTime</li>
        /// </ul>
        ///
        /// <p>
        /// The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following fields:
        /// </p>
        /// <ul>
        /// <li>@scheduledStartTime</li>
        /// <li>@scheduledEndTime</li>
        /// <li>@actualStartTime</li>
        /// <li>@actualEndTime</li>
        /// </ul>
        /// <p>Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".</p>
        pub fn r#type(mut self, input: crate::model::OperatorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>
        /// The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can be used only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.  
        /// </p>
        /// <p>
        /// The comparison operators EQ and REF_EQ act on the following fields:
        /// </p>
        /// <ul>
        /// <li>name</li>
        /// <li>@sphere</li>
        /// <li>parent</li>
        /// <li>@componentParent</li>
        /// <li>@instanceParent</li>
        /// <li>@status</li>
        /// <li>@scheduledStartTime</li>
        /// <li>@scheduledEndTime</li>
        /// <li>@actualStartTime</li>
        /// <li>@actualEndTime</li>
        /// </ul>
        ///
        /// <p>
        /// The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following fields:
        /// </p>
        /// <ul>
        /// <li>@scheduledStartTime</li>
        /// <li>@scheduledEndTime</li>
        /// <li>@actualStartTime</li>
        /// <li>@actualEndTime</li>
        /// </ul>
        /// <p>Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OperatorType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value that the actual field value will be compared with.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value that the actual field value will be compared with.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Operator`](crate::model::Operator)
        pub fn build(self) -> crate::model::Operator {
            crate::model::Operator {
                r#type: self.r#type,
                values: self.values,
            }
        }
    }
}
impl Operator {
    /// Creates a new builder-style object to manufacture [`Operator`](crate::model::Operator)
    pub fn builder() -> crate::model::operator::Builder {
        crate::model::operator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatorType {
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    ReferenceEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatorType {
    fn from(s: &str) -> Self {
        match s {
            "BETWEEN" => OperatorType::Between,
            "EQ" => OperatorType::Equal,
            "GE" => OperatorType::GreaterThanOrEqual,
            "LE" => OperatorType::LessThanOrEqual,
            "REF_EQ" => OperatorType::ReferenceEqual,
            other => OperatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatorType::from(s))
    }
}
impl OperatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatorType::Between => "BETWEEN",
            OperatorType::Equal => "EQ",
            OperatorType::GreaterThanOrEqual => "GE",
            OperatorType::LessThanOrEqual => "LE",
            OperatorType::ReferenceEqual => "REF_EQ",
            OperatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BETWEEN", "EQ", "GE", "LE", "REF_EQ"]
    }
}
impl AsRef<str> for OperatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a pipeline task that is assigned to a task runner.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskObject {
    /// <p>An internal identifier for the task. This ID is passed to the <a>SetTaskStatus</a> and <a>ReportTaskProgress</a> actions.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The ID of the pipeline that provided the task.</p>
    pub pipeline_id: std::option::Option<std::string::String>,
    /// <p>The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.</p>
    pub attempt_id: std::option::Option<std::string::String>,
    /// <p>Connection information for the location where the task runner will publish the output of the task.</p>
    pub objects: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PipelineObject>,
    >,
}
impl TaskObject {
    /// <p>An internal identifier for the task. This ID is passed to the <a>SetTaskStatus</a> and <a>ReportTaskProgress</a> actions.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The ID of the pipeline that provided the task.</p>
    pub fn pipeline_id(&self) -> std::option::Option<&str> {
        self.pipeline_id.as_deref()
    }
    /// <p>The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.</p>
    pub fn attempt_id(&self) -> std::option::Option<&str> {
        self.attempt_id.as_deref()
    }
    /// <p>Connection information for the location where the task runner will publish the output of the task.</p>
    pub fn objects(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PipelineObject>,
    > {
        self.objects.as_ref()
    }
}
impl std::fmt::Debug for TaskObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskObject");
        formatter.field("task_id", &self.task_id);
        formatter.field("pipeline_id", &self.pipeline_id);
        formatter.field("attempt_id", &self.attempt_id);
        formatter.field("objects", &self.objects);
        formatter.finish()
    }
}
/// See [`TaskObject`](crate::model::TaskObject)
pub mod task_object {
    /// A builder for [`TaskObject`](crate::model::TaskObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) pipeline_id: std::option::Option<std::string::String>,
        pub(crate) attempt_id: std::option::Option<std::string::String>,
        pub(crate) objects: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PipelineObject>,
        >,
    }
    impl Builder {
        /// <p>An internal identifier for the task. This ID is passed to the <a>SetTaskStatus</a> and <a>ReportTaskProgress</a> actions.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>An internal identifier for the task. This ID is passed to the <a>SetTaskStatus</a> and <a>ReportTaskProgress</a> actions.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The ID of the pipeline that provided the task.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline that provided the task.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_id = input;
            self
        }
        /// <p>The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.</p>
        pub fn attempt_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attempt_id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline task attempt object. AWS Data Pipeline uses this value to track how many times a task is attempted.</p>
        pub fn set_attempt_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attempt_id = input;
            self
        }
        /// Adds a key-value pair to `objects`.
        ///
        /// To override the contents of this collection use [`set_objects`](Self::set_objects).
        ///
        /// <p>Connection information for the location where the task runner will publish the output of the task.</p>
        pub fn objects(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PipelineObject>,
        ) -> Self {
            let mut hash_map = self.objects.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.objects = Some(hash_map);
            self
        }
        /// <p>Connection information for the location where the task runner will publish the output of the task.</p>
        pub fn set_objects(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PipelineObject>,
            >,
        ) -> Self {
            self.objects = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskObject`](crate::model::TaskObject)
        pub fn build(self) -> crate::model::TaskObject {
            crate::model::TaskObject {
                task_id: self.task_id,
                pipeline_id: self.pipeline_id,
                attempt_id: self.attempt_id,
                objects: self.objects,
            }
        }
    }
}
impl TaskObject {
    /// Creates a new builder-style object to manufacture [`TaskObject`](crate::model::TaskObject)
    pub fn builder() -> crate::model::task_object::Builder {
        crate::model::task_object::Builder::default()
    }
}

/// <p><p>Identity information for the EC2 instance that is hosting the task runner. You can get this value by calling a metadata URI from the EC2 instance.
/// For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
/// Passing in this value proves that your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your pipeline.</p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceIdentity {
    /// <p>A description of an EC2 instance that is generated when the instance is launched and exposed to the instance via the instance metadata service in the form of a JSON representation of an object.</p>
    pub document: std::option::Option<std::string::String>,
    /// <p>A signature which can be used to verify the accuracy and authenticity of the information provided in the instance identity document.</p>
    pub signature: std::option::Option<std::string::String>,
}
impl InstanceIdentity {
    /// <p>A description of an EC2 instance that is generated when the instance is launched and exposed to the instance via the instance metadata service in the form of a JSON representation of an object.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
    /// <p>A signature which can be used to verify the accuracy and authenticity of the information provided in the instance identity document.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
}
impl std::fmt::Debug for InstanceIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceIdentity");
        formatter.field("document", &self.document);
        formatter.field("signature", &self.signature);
        formatter.finish()
    }
}
/// See [`InstanceIdentity`](crate::model::InstanceIdentity)
pub mod instance_identity {
    /// A builder for [`InstanceIdentity`](crate::model::InstanceIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) signature: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of an EC2 instance that is generated when the instance is launched and exposed to the instance via the instance metadata service in the form of a JSON representation of an object.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>A description of an EC2 instance that is generated when the instance is launched and exposed to the instance via the instance metadata service in the form of a JSON representation of an object.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>A signature which can be used to verify the accuracy and authenticity of the information provided in the instance identity document.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>A signature which can be used to verify the accuracy and authenticity of the information provided in the instance identity document.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceIdentity`](crate::model::InstanceIdentity)
        pub fn build(self) -> crate::model::InstanceIdentity {
            crate::model::InstanceIdentity {
                document: self.document,
                signature: self.signature,
            }
        }
    }
}
impl InstanceIdentity {
    /// Creates a new builder-style object to manufacture [`InstanceIdentity`](crate::model::InstanceIdentity)
    pub fn builder() -> crate::model::instance_identity::Builder {
        crate::model::instance_identity::Builder::default()
    }
}

/// <p>Contains the name and identifier of a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineIdName {
    /// <p>The ID of the pipeline that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the pipeline.</p>
    pub name: std::option::Option<std::string::String>,
}
impl PipelineIdName {
    /// <p>The ID of the pipeline that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for PipelineIdName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineIdName");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PipelineIdName`](crate::model::PipelineIdName)
pub mod pipeline_id_name {
    /// A builder for [`PipelineIdName`](crate::model::PipelineIdName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the pipeline that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the pipeline that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineIdName`](crate::model::PipelineIdName)
        pub fn build(self) -> crate::model::PipelineIdName {
            crate::model::PipelineIdName {
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl PipelineIdName {
    /// Creates a new builder-style object to manufacture [`PipelineIdName`](crate::model::PipelineIdName)
    pub fn builder() -> crate::model::pipeline_id_name::Builder {
        crate::model::pipeline_id_name::Builder::default()
    }
}

/// <p>Contains pipeline metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineDescription {
    /// <p>The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
    pub pipeline_id: std::option::Option<std::string::String>,
    /// <p>The name of the pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    /// <p>Description of the pipeline.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of tags to associated with a pipeline. Tags let you control access to pipelines.
    /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PipelineDescription {
    /// <p>The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
    pub fn pipeline_id(&self) -> std::option::Option<&str> {
        self.pipeline_id.as_deref()
    }
    /// <p>The name of the pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.fields.as_deref()
    }
    /// <p>Description of the pipeline.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of tags to associated with a pipeline. Tags let you control access to pipelines.
    /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PipelineDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineDescription");
        formatter.field("pipeline_id", &self.pipeline_id);
        formatter.field("name", &self.name);
        formatter.field("fields", &self.fields);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PipelineDescription`](crate::model::PipelineDescription)
pub mod pipeline_description {
    /// A builder for [`PipelineDescription`](crate::model::PipelineDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_id = Some(input.into());
            self
        }
        /// <p>The pipeline identifier that was assigned by AWS Data Pipeline. This is a string of the form <code>df-297EG78HU43EEXAMPLE</code>.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_id = input;
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.</p>
        pub fn fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>A list of read-only fields that contain metadata about the pipeline: @userId, @accountId, and @pipelineState.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// <p>Description of the pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associated with a pipeline. Tags let you control access to pipelines.
        /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associated with a pipeline. Tags let you control access to pipelines.
        /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineDescription`](crate::model::PipelineDescription)
        pub fn build(self) -> crate::model::PipelineDescription {
            crate::model::PipelineDescription {
                pipeline_id: self.pipeline_id,
                name: self.name,
                fields: self.fields,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl PipelineDescription {
    /// Creates a new builder-style object to manufacture [`PipelineDescription`](crate::model::PipelineDescription)
    pub fn builder() -> crate::model::pipeline_description::Builder {
        crate::model::pipeline_description::Builder::default()
    }
}

/// <p>Tags are key/value pairs defined by a user and associated with a pipeline to control access. AWS Data Pipeline allows you to associate ten tags per pipeline.  
/// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key name of a tag defined by a user.  
    /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional value portion of a tag defined by a user.    
    /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key name of a tag defined by a user.  
    /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional value portion of a tag defined by a user.    
    /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key name of a tag defined by a user.  
        /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name of a tag defined by a user.  
        /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional value portion of a tag defined by a user.    
        /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional value portion of a tag defined by a user.    
        /// For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling User Access to Pipelines</a> in the <i>AWS Data Pipeline Developer Guide</i>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}
