// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the output of ValidatePipelineDefinition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidatePipelineDefinitionOutput {
    /// <p>Any validation errors that were found.</p>
    pub validation_errors: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
    /// <p>Any validation warnings that were found.</p>
    pub validation_warnings: std::option::Option<std::vec::Vec<crate::model::ValidationWarning>>,
    /// <p>Indicates whether there were validation errors.</p>
    pub errored: bool,
}
impl ValidatePipelineDefinitionOutput {
    /// <p>Any validation errors that were found.</p>
    pub fn validation_errors(&self) -> std::option::Option<&[crate::model::ValidationError]> {
        self.validation_errors.as_deref()
    }
    /// <p>Any validation warnings that were found.</p>
    pub fn validation_warnings(&self) -> std::option::Option<&[crate::model::ValidationWarning]> {
        self.validation_warnings.as_deref()
    }
    /// <p>Indicates whether there were validation errors.</p>
    pub fn errored(&self) -> bool {
        self.errored
    }
}
impl std::fmt::Debug for ValidatePipelineDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidatePipelineDefinitionOutput");
        formatter.field("validation_errors", &self.validation_errors);
        formatter.field("validation_warnings", &self.validation_warnings);
        formatter.field("errored", &self.errored);
        formatter.finish()
    }
}
/// See [`ValidatePipelineDefinitionOutput`](crate::output::ValidatePipelineDefinitionOutput)
pub mod validate_pipeline_definition_output {
    /// A builder for [`ValidatePipelineDefinitionOutput`](crate::output::ValidatePipelineDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_errors:
            std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
        pub(crate) validation_warnings:
            std::option::Option<std::vec::Vec<crate::model::ValidationWarning>>,
        pub(crate) errored: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `validation_errors`.
        ///
        /// To override the contents of this collection use [`set_validation_errors`](Self::set_validation_errors).
        ///
        /// <p>Any validation errors that were found.</p>
        pub fn validation_errors(
            mut self,
            input: impl Into<crate::model::ValidationError>,
        ) -> Self {
            let mut v = self.validation_errors.unwrap_or_default();
            v.push(input.into());
            self.validation_errors = Some(v);
            self
        }
        /// <p>Any validation errors that were found.</p>
        pub fn set_validation_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
        ) -> Self {
            self.validation_errors = input;
            self
        }
        /// Appends an item to `validation_warnings`.
        ///
        /// To override the contents of this collection use [`set_validation_warnings`](Self::set_validation_warnings).
        ///
        /// <p>Any validation warnings that were found.</p>
        pub fn validation_warnings(
            mut self,
            input: impl Into<crate::model::ValidationWarning>,
        ) -> Self {
            let mut v = self.validation_warnings.unwrap_or_default();
            v.push(input.into());
            self.validation_warnings = Some(v);
            self
        }
        /// <p>Any validation warnings that were found.</p>
        pub fn set_validation_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationWarning>>,
        ) -> Self {
            self.validation_warnings = input;
            self
        }
        /// <p>Indicates whether there were validation errors.</p>
        pub fn errored(mut self, input: bool) -> Self {
            self.errored = Some(input);
            self
        }
        /// <p>Indicates whether there were validation errors.</p>
        pub fn set_errored(mut self, input: std::option::Option<bool>) -> Self {
            self.errored = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidatePipelineDefinitionOutput`](crate::output::ValidatePipelineDefinitionOutput)
        pub fn build(self) -> crate::output::ValidatePipelineDefinitionOutput {
            crate::output::ValidatePipelineDefinitionOutput {
                validation_errors: self.validation_errors,
                validation_warnings: self.validation_warnings,
                errored: self.errored.unwrap_or_default(),
            }
        }
    }
}
impl ValidatePipelineDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`ValidatePipelineDefinitionOutput`](crate::output::ValidatePipelineDefinitionOutput)
    pub fn builder() -> crate::output::validate_pipeline_definition_output::Builder {
        crate::output::validate_pipeline_definition_output::Builder::default()
    }
}

/// <p>Contains the output of SetTaskStatus.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTaskStatusOutput {}
impl std::fmt::Debug for SetTaskStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTaskStatusOutput");
        formatter.finish()
    }
}
/// See [`SetTaskStatusOutput`](crate::output::SetTaskStatusOutput)
pub mod set_task_status_output {
    /// A builder for [`SetTaskStatusOutput`](crate::output::SetTaskStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetTaskStatusOutput`](crate::output::SetTaskStatusOutput)
        pub fn build(self) -> crate::output::SetTaskStatusOutput {
            crate::output::SetTaskStatusOutput {}
        }
    }
}
impl SetTaskStatusOutput {
    /// Creates a new builder-style object to manufacture [`SetTaskStatusOutput`](crate::output::SetTaskStatusOutput)
    pub fn builder() -> crate::output::set_task_status_output::Builder {
        crate::output::set_task_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetStatusOutput {}
impl std::fmt::Debug for SetStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetStatusOutput");
        formatter.finish()
    }
}
/// See [`SetStatusOutput`](crate::output::SetStatusOutput)
pub mod set_status_output {
    /// A builder for [`SetStatusOutput`](crate::output::SetStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetStatusOutput`](crate::output::SetStatusOutput)
        pub fn build(self) -> crate::output::SetStatusOutput {
            crate::output::SetStatusOutput {}
        }
    }
}
impl SetStatusOutput {
    /// Creates a new builder-style object to manufacture [`SetStatusOutput`](crate::output::SetStatusOutput)
    pub fn builder() -> crate::output::set_status_output::Builder {
        crate::output::set_status_output::Builder::default()
    }
}

/// <p>Contains the output of ReportTaskRunnerHeartbeat.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportTaskRunnerHeartbeatOutput {
    /// <p>Indicates whether the calling task runner should terminate.</p>
    pub terminate: bool,
}
impl ReportTaskRunnerHeartbeatOutput {
    /// <p>Indicates whether the calling task runner should terminate.</p>
    pub fn terminate(&self) -> bool {
        self.terminate
    }
}
impl std::fmt::Debug for ReportTaskRunnerHeartbeatOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportTaskRunnerHeartbeatOutput");
        formatter.field("terminate", &self.terminate);
        formatter.finish()
    }
}
/// See [`ReportTaskRunnerHeartbeatOutput`](crate::output::ReportTaskRunnerHeartbeatOutput)
pub mod report_task_runner_heartbeat_output {
    /// A builder for [`ReportTaskRunnerHeartbeatOutput`](crate::output::ReportTaskRunnerHeartbeatOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terminate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the calling task runner should terminate.</p>
        pub fn terminate(mut self, input: bool) -> Self {
            self.terminate = Some(input);
            self
        }
        /// <p>Indicates whether the calling task runner should terminate.</p>
        pub fn set_terminate(mut self, input: std::option::Option<bool>) -> Self {
            self.terminate = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportTaskRunnerHeartbeatOutput`](crate::output::ReportTaskRunnerHeartbeatOutput)
        pub fn build(self) -> crate::output::ReportTaskRunnerHeartbeatOutput {
            crate::output::ReportTaskRunnerHeartbeatOutput {
                terminate: self.terminate.unwrap_or_default(),
            }
        }
    }
}
impl ReportTaskRunnerHeartbeatOutput {
    /// Creates a new builder-style object to manufacture [`ReportTaskRunnerHeartbeatOutput`](crate::output::ReportTaskRunnerHeartbeatOutput)
    pub fn builder() -> crate::output::report_task_runner_heartbeat_output::Builder {
        crate::output::report_task_runner_heartbeat_output::Builder::default()
    }
}

/// <p>Contains the output of ReportTaskProgress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportTaskProgressOutput {
    /// <p>If true, the calling task runner should cancel processing of the task. The task runner does not need to call <a>SetTaskStatus</a> for canceled tasks.</p>
    pub canceled: bool,
}
impl ReportTaskProgressOutput {
    /// <p>If true, the calling task runner should cancel processing of the task. The task runner does not need to call <a>SetTaskStatus</a> for canceled tasks.</p>
    pub fn canceled(&self) -> bool {
        self.canceled
    }
}
impl std::fmt::Debug for ReportTaskProgressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportTaskProgressOutput");
        formatter.field("canceled", &self.canceled);
        formatter.finish()
    }
}
/// See [`ReportTaskProgressOutput`](crate::output::ReportTaskProgressOutput)
pub mod report_task_progress_output {
    /// A builder for [`ReportTaskProgressOutput`](crate::output::ReportTaskProgressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) canceled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If true, the calling task runner should cancel processing of the task. The task runner does not need to call <a>SetTaskStatus</a> for canceled tasks.</p>
        pub fn canceled(mut self, input: bool) -> Self {
            self.canceled = Some(input);
            self
        }
        /// <p>If true, the calling task runner should cancel processing of the task. The task runner does not need to call <a>SetTaskStatus</a> for canceled tasks.</p>
        pub fn set_canceled(mut self, input: std::option::Option<bool>) -> Self {
            self.canceled = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportTaskProgressOutput`](crate::output::ReportTaskProgressOutput)
        pub fn build(self) -> crate::output::ReportTaskProgressOutput {
            crate::output::ReportTaskProgressOutput {
                canceled: self.canceled.unwrap_or_default(),
            }
        }
    }
}
impl ReportTaskProgressOutput {
    /// Creates a new builder-style object to manufacture [`ReportTaskProgressOutput`](crate::output::ReportTaskProgressOutput)
    pub fn builder() -> crate::output::report_task_progress_output::Builder {
        crate::output::report_task_progress_output::Builder::default()
    }
}

/// <p>Contains the output of RemoveTags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsOutput {}
impl std::fmt::Debug for RemoveTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
pub mod remove_tags_output {
    /// A builder for [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
        pub fn build(self) -> crate::output::RemoveTagsOutput {
            crate::output::RemoveTagsOutput {}
        }
    }
}
impl RemoveTagsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    pub fn builder() -> crate::output::remove_tags_output::Builder {
        crate::output::remove_tags_output::Builder::default()
    }
}

/// <p>Contains the output of QueryObjects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryObjectsOutput {
    /// <p>The identifiers that match the query selectors.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The starting point for the next page of results. To view the next page of results, call <code>QueryObjects</code>
    /// again with this marker value. If the value is null, there are no more results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
    pub has_more_results: bool,
}
impl QueryObjectsOutput {
    /// <p>The identifiers that match the query selectors.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
    /// <p>The starting point for the next page of results. To view the next page of results, call <code>QueryObjects</code>
    /// again with this marker value. If the value is null, there are no more results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
    pub fn has_more_results(&self) -> bool {
        self.has_more_results
    }
}
impl std::fmt::Debug for QueryObjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryObjectsOutput");
        formatter.field("ids", &self.ids);
        formatter.field("marker", &self.marker);
        formatter.field("has_more_results", &self.has_more_results);
        formatter.finish()
    }
}
/// See [`QueryObjectsOutput`](crate::output::QueryObjectsOutput)
pub mod query_objects_output {
    /// A builder for [`QueryObjectsOutput`](crate::output::QueryObjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) has_more_results: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The identifiers that match the query selectors.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>The identifiers that match the query selectors.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>The starting point for the next page of results. To view the next page of results, call <code>QueryObjects</code>
        /// again with this marker value. If the value is null, there are no more results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The starting point for the next page of results. To view the next page of results, call <code>QueryObjects</code>
        /// again with this marker value. If the value is null, there are no more results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
        pub fn has_more_results(mut self, input: bool) -> Self {
            self.has_more_results = Some(input);
            self
        }
        /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
        pub fn set_has_more_results(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_results = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryObjectsOutput`](crate::output::QueryObjectsOutput)
        pub fn build(self) -> crate::output::QueryObjectsOutput {
            crate::output::QueryObjectsOutput {
                ids: self.ids,
                marker: self.marker,
                has_more_results: self.has_more_results.unwrap_or_default(),
            }
        }
    }
}
impl QueryObjectsOutput {
    /// Creates a new builder-style object to manufacture [`QueryObjectsOutput`](crate::output::QueryObjectsOutput)
    pub fn builder() -> crate::output::query_objects_output::Builder {
        crate::output::query_objects_output::Builder::default()
    }
}

/// <p>Contains the output of PutPipelineDefinition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPipelineDefinitionOutput {
    /// <p>The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.</p>
    pub validation_errors: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
    /// <p>The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.</p>
    pub validation_warnings: std::option::Option<std::vec::Vec<crate::model::ValidationWarning>>,
    /// <p>Indicates whether there were validation errors, and the pipeline definition is stored but cannot be
    /// activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.</p>
    pub errored: bool,
}
impl PutPipelineDefinitionOutput {
    /// <p>The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.</p>
    pub fn validation_errors(&self) -> std::option::Option<&[crate::model::ValidationError]> {
        self.validation_errors.as_deref()
    }
    /// <p>The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.</p>
    pub fn validation_warnings(&self) -> std::option::Option<&[crate::model::ValidationWarning]> {
        self.validation_warnings.as_deref()
    }
    /// <p>Indicates whether there were validation errors, and the pipeline definition is stored but cannot be
    /// activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.</p>
    pub fn errored(&self) -> bool {
        self.errored
    }
}
impl std::fmt::Debug for PutPipelineDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPipelineDefinitionOutput");
        formatter.field("validation_errors", &self.validation_errors);
        formatter.field("validation_warnings", &self.validation_warnings);
        formatter.field("errored", &self.errored);
        formatter.finish()
    }
}
/// See [`PutPipelineDefinitionOutput`](crate::output::PutPipelineDefinitionOutput)
pub mod put_pipeline_definition_output {
    /// A builder for [`PutPipelineDefinitionOutput`](crate::output::PutPipelineDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_errors:
            std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
        pub(crate) validation_warnings:
            std::option::Option<std::vec::Vec<crate::model::ValidationWarning>>,
        pub(crate) errored: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `validation_errors`.
        ///
        /// To override the contents of this collection use [`set_validation_errors`](Self::set_validation_errors).
        ///
        /// <p>The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.</p>
        pub fn validation_errors(
            mut self,
            input: impl Into<crate::model::ValidationError>,
        ) -> Self {
            let mut v = self.validation_errors.unwrap_or_default();
            v.push(input.into());
            self.validation_errors = Some(v);
            self
        }
        /// <p>The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.</p>
        pub fn set_validation_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
        ) -> Self {
            self.validation_errors = input;
            self
        }
        /// Appends an item to `validation_warnings`.
        ///
        /// To override the contents of this collection use [`set_validation_warnings`](Self::set_validation_warnings).
        ///
        /// <p>The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.</p>
        pub fn validation_warnings(
            mut self,
            input: impl Into<crate::model::ValidationWarning>,
        ) -> Self {
            let mut v = self.validation_warnings.unwrap_or_default();
            v.push(input.into());
            self.validation_warnings = Some(v);
            self
        }
        /// <p>The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.</p>
        pub fn set_validation_warnings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationWarning>>,
        ) -> Self {
            self.validation_warnings = input;
            self
        }
        /// <p>Indicates whether there were validation errors, and the pipeline definition is stored but cannot be
        /// activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.</p>
        pub fn errored(mut self, input: bool) -> Self {
            self.errored = Some(input);
            self
        }
        /// <p>Indicates whether there were validation errors, and the pipeline definition is stored but cannot be
        /// activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.</p>
        pub fn set_errored(mut self, input: std::option::Option<bool>) -> Self {
            self.errored = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPipelineDefinitionOutput`](crate::output::PutPipelineDefinitionOutput)
        pub fn build(self) -> crate::output::PutPipelineDefinitionOutput {
            crate::output::PutPipelineDefinitionOutput {
                validation_errors: self.validation_errors,
                validation_warnings: self.validation_warnings,
                errored: self.errored.unwrap_or_default(),
            }
        }
    }
}
impl PutPipelineDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`PutPipelineDefinitionOutput`](crate::output::PutPipelineDefinitionOutput)
    pub fn builder() -> crate::output::put_pipeline_definition_output::Builder {
        crate::output::put_pipeline_definition_output::Builder::default()
    }
}

/// <p>Contains the output of PollForTask.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PollForTaskOutput {
    /// <p>The information needed to complete the task that is being assigned to the task runner. One of the fields returned in this object is <code>taskId</code>,
    /// which contains an identifier for the task being assigned. The calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a>
    /// and <a>SetTaskStatus</a>.</p>
    pub task_object: std::option::Option<crate::model::TaskObject>,
}
impl PollForTaskOutput {
    /// <p>The information needed to complete the task that is being assigned to the task runner. One of the fields returned in this object is <code>taskId</code>,
    /// which contains an identifier for the task being assigned. The calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a>
    /// and <a>SetTaskStatus</a>.</p>
    pub fn task_object(&self) -> std::option::Option<&crate::model::TaskObject> {
        self.task_object.as_ref()
    }
}
impl std::fmt::Debug for PollForTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PollForTaskOutput");
        formatter.field("task_object", &self.task_object);
        formatter.finish()
    }
}
/// See [`PollForTaskOutput`](crate::output::PollForTaskOutput)
pub mod poll_for_task_output {
    /// A builder for [`PollForTaskOutput`](crate::output::PollForTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_object: std::option::Option<crate::model::TaskObject>,
    }
    impl Builder {
        /// <p>The information needed to complete the task that is being assigned to the task runner. One of the fields returned in this object is <code>taskId</code>,
        /// which contains an identifier for the task being assigned. The calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a>
        /// and <a>SetTaskStatus</a>.</p>
        pub fn task_object(mut self, input: crate::model::TaskObject) -> Self {
            self.task_object = Some(input);
            self
        }
        /// <p>The information needed to complete the task that is being assigned to the task runner. One of the fields returned in this object is <code>taskId</code>,
        /// which contains an identifier for the task being assigned. The calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a>
        /// and <a>SetTaskStatus</a>.</p>
        pub fn set_task_object(
            mut self,
            input: std::option::Option<crate::model::TaskObject>,
        ) -> Self {
            self.task_object = input;
            self
        }
        /// Consumes the builder and constructs a [`PollForTaskOutput`](crate::output::PollForTaskOutput)
        pub fn build(self) -> crate::output::PollForTaskOutput {
            crate::output::PollForTaskOutput {
                task_object: self.task_object,
            }
        }
    }
}
impl PollForTaskOutput {
    /// Creates a new builder-style object to manufacture [`PollForTaskOutput`](crate::output::PollForTaskOutput)
    pub fn builder() -> crate::output::poll_for_task_output::Builder {
        crate::output::poll_for_task_output::Builder::default()
    }
}

/// <p>Contains the output of ListPipelines.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelinesOutput {
    /// <p>The pipeline identifiers. If you require additional information about the pipelines, you can use these identifiers to call
    /// <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.</p>
    pub pipeline_id_list: std::option::Option<std::vec::Vec<crate::model::PipelineIdName>>,
    /// <p>The starting point for the next page of results. To view the next page of results, call <code>ListPipelinesOutput</code>
    /// again with this marker value. If the value is null, there are no more results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
    pub has_more_results: bool,
}
impl ListPipelinesOutput {
    /// <p>The pipeline identifiers. If you require additional information about the pipelines, you can use these identifiers to call
    /// <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.</p>
    pub fn pipeline_id_list(&self) -> std::option::Option<&[crate::model::PipelineIdName]> {
        self.pipeline_id_list.as_deref()
    }
    /// <p>The starting point for the next page of results. To view the next page of results, call <code>ListPipelinesOutput</code>
    /// again with this marker value. If the value is null, there are no more results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
    pub fn has_more_results(&self) -> bool {
        self.has_more_results
    }
}
impl std::fmt::Debug for ListPipelinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelinesOutput");
        formatter.field("pipeline_id_list", &self.pipeline_id_list);
        formatter.field("marker", &self.marker);
        formatter.field("has_more_results", &self.has_more_results);
        formatter.finish()
    }
}
/// See [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
pub mod list_pipelines_output {
    /// A builder for [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_id_list:
            std::option::Option<std::vec::Vec<crate::model::PipelineIdName>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) has_more_results: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `pipeline_id_list`.
        ///
        /// To override the contents of this collection use [`set_pipeline_id_list`](Self::set_pipeline_id_list).
        ///
        /// <p>The pipeline identifiers. If you require additional information about the pipelines, you can use these identifiers to call
        /// <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.</p>
        pub fn pipeline_id_list(mut self, input: impl Into<crate::model::PipelineIdName>) -> Self {
            let mut v = self.pipeline_id_list.unwrap_or_default();
            v.push(input.into());
            self.pipeline_id_list = Some(v);
            self
        }
        /// <p>The pipeline identifiers. If you require additional information about the pipelines, you can use these identifiers to call
        /// <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.</p>
        pub fn set_pipeline_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineIdName>>,
        ) -> Self {
            self.pipeline_id_list = input;
            self
        }
        /// <p>The starting point for the next page of results. To view the next page of results, call <code>ListPipelinesOutput</code>
        /// again with this marker value. If the value is null, there are no more results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The starting point for the next page of results. To view the next page of results, call <code>ListPipelinesOutput</code>
        /// again with this marker value. If the value is null, there are no more results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
        pub fn has_more_results(mut self, input: bool) -> Self {
            self.has_more_results = Some(input);
            self
        }
        /// <p>Indicates whether there are more results that can be obtained by a subsequent call.</p>
        pub fn set_has_more_results(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
        pub fn build(self) -> crate::output::ListPipelinesOutput {
            crate::output::ListPipelinesOutput {
                pipeline_id_list: self.pipeline_id_list,
                marker: self.marker,
                has_more_results: self.has_more_results.unwrap_or_default(),
            }
        }
    }
}
impl ListPipelinesOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    pub fn builder() -> crate::output::list_pipelines_output::Builder {
        crate::output::list_pipelines_output::Builder::default()
    }
}

/// <p>Contains the output of GetPipelineDefinition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPipelineDefinitionOutput {
    /// <p>The objects defined in the pipeline.</p>
    pub pipeline_objects: std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
    /// <p>The parameter objects used in the pipeline definition.</p>
    pub parameter_objects: std::option::Option<std::vec::Vec<crate::model::ParameterObject>>,
    /// <p>The parameter values used in the pipeline definition.</p>
    pub parameter_values: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
}
impl GetPipelineDefinitionOutput {
    /// <p>The objects defined in the pipeline.</p>
    pub fn pipeline_objects(&self) -> std::option::Option<&[crate::model::PipelineObject]> {
        self.pipeline_objects.as_deref()
    }
    /// <p>The parameter objects used in the pipeline definition.</p>
    pub fn parameter_objects(&self) -> std::option::Option<&[crate::model::ParameterObject]> {
        self.parameter_objects.as_deref()
    }
    /// <p>The parameter values used in the pipeline definition.</p>
    pub fn parameter_values(&self) -> std::option::Option<&[crate::model::ParameterValue]> {
        self.parameter_values.as_deref()
    }
}
impl std::fmt::Debug for GetPipelineDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPipelineDefinitionOutput");
        formatter.field("pipeline_objects", &self.pipeline_objects);
        formatter.field("parameter_objects", &self.parameter_objects);
        formatter.field("parameter_values", &self.parameter_values);
        formatter.finish()
    }
}
/// See [`GetPipelineDefinitionOutput`](crate::output::GetPipelineDefinitionOutput)
pub mod get_pipeline_definition_output {
    /// A builder for [`GetPipelineDefinitionOutput`](crate::output::GetPipelineDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_objects:
            std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
        pub(crate) parameter_objects:
            std::option::Option<std::vec::Vec<crate::model::ParameterObject>>,
        pub(crate) parameter_values:
            std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
    }
    impl Builder {
        /// Appends an item to `pipeline_objects`.
        ///
        /// To override the contents of this collection use [`set_pipeline_objects`](Self::set_pipeline_objects).
        ///
        /// <p>The objects defined in the pipeline.</p>
        pub fn pipeline_objects(mut self, input: impl Into<crate::model::PipelineObject>) -> Self {
            let mut v = self.pipeline_objects.unwrap_or_default();
            v.push(input.into());
            self.pipeline_objects = Some(v);
            self
        }
        /// <p>The objects defined in the pipeline.</p>
        pub fn set_pipeline_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
        ) -> Self {
            self.pipeline_objects = input;
            self
        }
        /// Appends an item to `parameter_objects`.
        ///
        /// To override the contents of this collection use [`set_parameter_objects`](Self::set_parameter_objects).
        ///
        /// <p>The parameter objects used in the pipeline definition.</p>
        pub fn parameter_objects(
            mut self,
            input: impl Into<crate::model::ParameterObject>,
        ) -> Self {
            let mut v = self.parameter_objects.unwrap_or_default();
            v.push(input.into());
            self.parameter_objects = Some(v);
            self
        }
        /// <p>The parameter objects used in the pipeline definition.</p>
        pub fn set_parameter_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterObject>>,
        ) -> Self {
            self.parameter_objects = input;
            self
        }
        /// Appends an item to `parameter_values`.
        ///
        /// To override the contents of this collection use [`set_parameter_values`](Self::set_parameter_values).
        ///
        /// <p>The parameter values used in the pipeline definition.</p>
        pub fn parameter_values(mut self, input: impl Into<crate::model::ParameterValue>) -> Self {
            let mut v = self.parameter_values.unwrap_or_default();
            v.push(input.into());
            self.parameter_values = Some(v);
            self
        }
        /// <p>The parameter values used in the pipeline definition.</p>
        pub fn set_parameter_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterValue>>,
        ) -> Self {
            self.parameter_values = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPipelineDefinitionOutput`](crate::output::GetPipelineDefinitionOutput)
        pub fn build(self) -> crate::output::GetPipelineDefinitionOutput {
            crate::output::GetPipelineDefinitionOutput {
                pipeline_objects: self.pipeline_objects,
                parameter_objects: self.parameter_objects,
                parameter_values: self.parameter_values,
            }
        }
    }
}
impl GetPipelineDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`GetPipelineDefinitionOutput`](crate::output::GetPipelineDefinitionOutput)
    pub fn builder() -> crate::output::get_pipeline_definition_output::Builder {
        crate::output::get_pipeline_definition_output::Builder::default()
    }
}

/// <p>Contains the output of EvaluateExpression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluateExpressionOutput {
    /// <p>The evaluated expression.</p>
    pub evaluated_expression: std::option::Option<std::string::String>,
}
impl EvaluateExpressionOutput {
    /// <p>The evaluated expression.</p>
    pub fn evaluated_expression(&self) -> std::option::Option<&str> {
        self.evaluated_expression.as_deref()
    }
}
impl std::fmt::Debug for EvaluateExpressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluateExpressionOutput");
        formatter.field("evaluated_expression", &self.evaluated_expression);
        formatter.finish()
    }
}
/// See [`EvaluateExpressionOutput`](crate::output::EvaluateExpressionOutput)
pub mod evaluate_expression_output {
    /// A builder for [`EvaluateExpressionOutput`](crate::output::EvaluateExpressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluated_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The evaluated expression.</p>
        pub fn evaluated_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluated_expression = Some(input.into());
            self
        }
        /// <p>The evaluated expression.</p>
        pub fn set_evaluated_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluated_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluateExpressionOutput`](crate::output::EvaluateExpressionOutput)
        pub fn build(self) -> crate::output::EvaluateExpressionOutput {
            crate::output::EvaluateExpressionOutput {
                evaluated_expression: self.evaluated_expression,
            }
        }
    }
}
impl EvaluateExpressionOutput {
    /// Creates a new builder-style object to manufacture [`EvaluateExpressionOutput`](crate::output::EvaluateExpressionOutput)
    pub fn builder() -> crate::output::evaluate_expression_output::Builder {
        crate::output::evaluate_expression_output::Builder::default()
    }
}

/// <p>Contains the output of DescribePipelines.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePipelinesOutput {
    /// <p>An array of descriptions for the specified pipelines.</p>
    pub pipeline_description_list:
        std::option::Option<std::vec::Vec<crate::model::PipelineDescription>>,
}
impl DescribePipelinesOutput {
    /// <p>An array of descriptions for the specified pipelines.</p>
    pub fn pipeline_description_list(
        &self,
    ) -> std::option::Option<&[crate::model::PipelineDescription]> {
        self.pipeline_description_list.as_deref()
    }
}
impl std::fmt::Debug for DescribePipelinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePipelinesOutput");
        formatter.field("pipeline_description_list", &self.pipeline_description_list);
        formatter.finish()
    }
}
/// See [`DescribePipelinesOutput`](crate::output::DescribePipelinesOutput)
pub mod describe_pipelines_output {
    /// A builder for [`DescribePipelinesOutput`](crate::output::DescribePipelinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_description_list:
            std::option::Option<std::vec::Vec<crate::model::PipelineDescription>>,
    }
    impl Builder {
        /// Appends an item to `pipeline_description_list`.
        ///
        /// To override the contents of this collection use [`set_pipeline_description_list`](Self::set_pipeline_description_list).
        ///
        /// <p>An array of descriptions for the specified pipelines.</p>
        pub fn pipeline_description_list(
            mut self,
            input: impl Into<crate::model::PipelineDescription>,
        ) -> Self {
            let mut v = self.pipeline_description_list.unwrap_or_default();
            v.push(input.into());
            self.pipeline_description_list = Some(v);
            self
        }
        /// <p>An array of descriptions for the specified pipelines.</p>
        pub fn set_pipeline_description_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineDescription>>,
        ) -> Self {
            self.pipeline_description_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePipelinesOutput`](crate::output::DescribePipelinesOutput)
        pub fn build(self) -> crate::output::DescribePipelinesOutput {
            crate::output::DescribePipelinesOutput {
                pipeline_description_list: self.pipeline_description_list,
            }
        }
    }
}
impl DescribePipelinesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePipelinesOutput`](crate::output::DescribePipelinesOutput)
    pub fn builder() -> crate::output::describe_pipelines_output::Builder {
        crate::output::describe_pipelines_output::Builder::default()
    }
}

/// <p>Contains the output of DescribeObjects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeObjectsOutput {
    /// <p>An array of object definitions.</p>
    pub pipeline_objects: std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
    /// <p>The starting point for the next page of results. To view the next page of results, call <code>DescribeObjects</code>
    /// again with this marker value. If the value is null, there are no more results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Indicates whether there are more results to return.</p>
    pub has_more_results: bool,
}
impl DescribeObjectsOutput {
    /// <p>An array of object definitions.</p>
    pub fn pipeline_objects(&self) -> std::option::Option<&[crate::model::PipelineObject]> {
        self.pipeline_objects.as_deref()
    }
    /// <p>The starting point for the next page of results. To view the next page of results, call <code>DescribeObjects</code>
    /// again with this marker value. If the value is null, there are no more results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Indicates whether there are more results to return.</p>
    pub fn has_more_results(&self) -> bool {
        self.has_more_results
    }
}
impl std::fmt::Debug for DescribeObjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeObjectsOutput");
        formatter.field("pipeline_objects", &self.pipeline_objects);
        formatter.field("marker", &self.marker);
        formatter.field("has_more_results", &self.has_more_results);
        formatter.finish()
    }
}
/// See [`DescribeObjectsOutput`](crate::output::DescribeObjectsOutput)
pub mod describe_objects_output {
    /// A builder for [`DescribeObjectsOutput`](crate::output::DescribeObjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_objects:
            std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) has_more_results: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `pipeline_objects`.
        ///
        /// To override the contents of this collection use [`set_pipeline_objects`](Self::set_pipeline_objects).
        ///
        /// <p>An array of object definitions.</p>
        pub fn pipeline_objects(mut self, input: impl Into<crate::model::PipelineObject>) -> Self {
            let mut v = self.pipeline_objects.unwrap_or_default();
            v.push(input.into());
            self.pipeline_objects = Some(v);
            self
        }
        /// <p>An array of object definitions.</p>
        pub fn set_pipeline_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineObject>>,
        ) -> Self {
            self.pipeline_objects = input;
            self
        }
        /// <p>The starting point for the next page of results. To view the next page of results, call <code>DescribeObjects</code>
        /// again with this marker value. If the value is null, there are no more results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The starting point for the next page of results. To view the next page of results, call <code>DescribeObjects</code>
        /// again with this marker value. If the value is null, there are no more results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Indicates whether there are more results to return.</p>
        pub fn has_more_results(mut self, input: bool) -> Self {
            self.has_more_results = Some(input);
            self
        }
        /// <p>Indicates whether there are more results to return.</p>
        pub fn set_has_more_results(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeObjectsOutput`](crate::output::DescribeObjectsOutput)
        pub fn build(self) -> crate::output::DescribeObjectsOutput {
            crate::output::DescribeObjectsOutput {
                pipeline_objects: self.pipeline_objects,
                marker: self.marker,
                has_more_results: self.has_more_results.unwrap_or_default(),
            }
        }
    }
}
impl DescribeObjectsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeObjectsOutput`](crate::output::DescribeObjectsOutput)
    pub fn builder() -> crate::output::describe_objects_output::Builder {
        crate::output::describe_objects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePipelineOutput {}
impl std::fmt::Debug for DeletePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePipelineOutput");
        formatter.finish()
    }
}
/// See [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
pub mod delete_pipeline_output {
    /// A builder for [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
        pub fn build(self) -> crate::output::DeletePipelineOutput {
            crate::output::DeletePipelineOutput {}
        }
    }
}
impl DeletePipelineOutput {
    /// Creates a new builder-style object to manufacture [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)
    pub fn builder() -> crate::output::delete_pipeline_output::Builder {
        crate::output::delete_pipeline_output::Builder::default()
    }
}

/// <p>Contains the output of DeactivatePipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivatePipelineOutput {}
impl std::fmt::Debug for DeactivatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivatePipelineOutput");
        formatter.finish()
    }
}
/// See [`DeactivatePipelineOutput`](crate::output::DeactivatePipelineOutput)
pub mod deactivate_pipeline_output {
    /// A builder for [`DeactivatePipelineOutput`](crate::output::DeactivatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeactivatePipelineOutput`](crate::output::DeactivatePipelineOutput)
        pub fn build(self) -> crate::output::DeactivatePipelineOutput {
            crate::output::DeactivatePipelineOutput {}
        }
    }
}
impl DeactivatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`DeactivatePipelineOutput`](crate::output::DeactivatePipelineOutput)
    pub fn builder() -> crate::output::deactivate_pipeline_output::Builder {
        crate::output::deactivate_pipeline_output::Builder::default()
    }
}

/// <p>Contains the output of CreatePipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePipelineOutput {
    /// <p>The ID that AWS Data Pipeline assigns the newly created pipeline. For example, <code>df-06372391ZG65EXAMPLE</code>.</p>
    pub pipeline_id: std::option::Option<std::string::String>,
}
impl CreatePipelineOutput {
    /// <p>The ID that AWS Data Pipeline assigns the newly created pipeline. For example, <code>df-06372391ZG65EXAMPLE</code>.</p>
    pub fn pipeline_id(&self) -> std::option::Option<&str> {
        self.pipeline_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePipelineOutput");
        formatter.field("pipeline_id", &self.pipeline_id);
        formatter.finish()
    }
}
/// See [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
pub mod create_pipeline_output {
    /// A builder for [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that AWS Data Pipeline assigns the newly created pipeline. For example, <code>df-06372391ZG65EXAMPLE</code>.</p>
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_id = Some(input.into());
            self
        }
        /// <p>The ID that AWS Data Pipeline assigns the newly created pipeline. For example, <code>df-06372391ZG65EXAMPLE</code>.</p>
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
        pub fn build(self) -> crate::output::CreatePipelineOutput {
            crate::output::CreatePipelineOutput {
                pipeline_id: self.pipeline_id,
            }
        }
    }
}
impl CreatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`CreatePipelineOutput`](crate::output::CreatePipelineOutput)
    pub fn builder() -> crate::output::create_pipeline_output::Builder {
        crate::output::create_pipeline_output::Builder::default()
    }
}

/// <p>Contains the output of AddTags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {}
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}

/// <p>Contains the output of ActivatePipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivatePipelineOutput {}
impl std::fmt::Debug for ActivatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivatePipelineOutput");
        formatter.finish()
    }
}
/// See [`ActivatePipelineOutput`](crate::output::ActivatePipelineOutput)
pub mod activate_pipeline_output {
    /// A builder for [`ActivatePipelineOutput`](crate::output::ActivatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ActivatePipelineOutput`](crate::output::ActivatePipelineOutput)
        pub fn build(self) -> crate::output::ActivatePipelineOutput {
            crate::output::ActivatePipelineOutput {}
        }
    }
}
impl ActivatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`ActivatePipelineOutput`](crate::output::ActivatePipelineOutput)
    pub fn builder() -> crate::output::activate_pipeline_output::Builder {
        crate::output::activate_pipeline_output::Builder::default()
    }
}
