// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_activate_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ActivatePipelineOutput, crate::error::ActivatePipelineError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ActivatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ActivatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ActivatePipelineError {
            meta: generic,
            kind: crate::error::ActivatePipelineErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ActivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ActivatePipelineError {
            meta: generic,
            kind: crate::error::ActivatePipelineErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ActivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::ActivatePipelineError {
            meta: generic,
            kind: crate::error::ActivatePipelineErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ActivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::ActivatePipelineError {
            meta: generic,
            kind: crate::error::ActivatePipelineErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ActivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ActivatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_activate_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ActivatePipelineOutput, crate::error::ActivatePipelineError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::activate_pipeline_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::CreatePipelineError {
            meta: generic,
            kind: crate::error::CreatePipelineErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_pipeline_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_pipeline(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePipelineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deactivate_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeactivatePipelineOutput,
    crate::error::DeactivatePipelineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeactivatePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeactivatePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DeactivatePipelineError {
            meta: generic,
            kind: crate::error::DeactivatePipelineErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeactivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeactivatePipelineError {
            meta: generic,
            kind: crate::error::DeactivatePipelineErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeactivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::DeactivatePipelineError {
            meta: generic,
            kind: crate::error::DeactivatePipelineErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeactivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::DeactivatePipelineError {
            meta: generic,
            kind: crate::error::DeactivatePipelineErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeactivatePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeactivatePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deactivate_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeactivatePipelineOutput,
    crate::error::DeactivatePipelineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deactivate_pipeline_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pipeline_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePipelineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePipelineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DeletePipelineError {
            meta: generic,
            kind: crate::error::DeletePipelineErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DeletePipelineError {
            meta: generic,
            kind: crate::error::DeletePipelineErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::DeletePipelineError {
            meta: generic,
            kind: crate::error::DeletePipelineErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePipelineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePipelineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pipeline_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_pipeline_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_objects_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeObjectsOutput, crate::error::DescribeObjectsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeObjectsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeObjectsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DescribeObjectsError {
            meta: generic,
            kind: crate::error::DescribeObjectsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribeObjectsError {
            meta: generic,
            kind: crate::error::DescribeObjectsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::DescribeObjectsError {
            meta: generic,
            kind: crate::error::DescribeObjectsErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::DescribeObjectsError {
            meta: generic,
            kind: crate::error::DescribeObjectsErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeObjectsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_objects_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeObjectsOutput, crate::error::DescribeObjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_objects_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_objects(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeObjectsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipelines_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePipelinesOutput, crate::error::DescribePipelinesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePipelinesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePipelinesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DescribePipelinesError {
            meta: generic,
            kind: crate::error::DescribePipelinesErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::DescribePipelinesError {
            meta: generic,
            kind: crate::error::DescribePipelinesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::DescribePipelinesError {
            meta: generic,
            kind: crate::error::DescribePipelinesErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::DescribePipelinesError {
            meta: generic,
            kind: crate::error::DescribePipelinesErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePipelinesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pipelines_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePipelinesOutput, crate::error::DescribePipelinesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_pipelines_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_pipelines(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePipelinesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_evaluate_expression_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EvaluateExpressionOutput,
    crate::error::EvaluateExpressionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EvaluateExpressionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EvaluateExpressionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::EvaluateExpressionError {
            meta: generic,
            kind: crate::error::EvaluateExpressionErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::EvaluateExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::EvaluateExpressionError {
            meta: generic,
            kind: crate::error::EvaluateExpressionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EvaluateExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::EvaluateExpressionError {
            meta: generic,
            kind: crate::error::EvaluateExpressionErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EvaluateExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::EvaluateExpressionError {
            meta: generic,
            kind: crate::error::EvaluateExpressionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EvaluateExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskNotFoundException" => crate::error::EvaluateExpressionError {
            meta: generic,
            kind: crate::error::EvaluateExpressionErrorKind::TaskNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EvaluateExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EvaluateExpressionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_evaluate_expression_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EvaluateExpressionOutput,
    crate::error::EvaluateExpressionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::evaluate_expression_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_evaluate_expression(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EvaluateExpressionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPipelineDefinitionOutput,
    crate::error::GetPipelineDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPipelineDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPipelineDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::GetPipelineDefinitionError {
            meta: generic,
            kind: crate::error::GetPipelineDefinitionErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::GetPipelineDefinitionError {
            meta: generic,
            kind: crate::error::GetPipelineDefinitionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::GetPipelineDefinitionError {
            meta: generic,
            kind: crate::error::GetPipelineDefinitionErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::GetPipelineDefinitionError {
            meta: generic,
            kind: crate::error::GetPipelineDefinitionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPipelineDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_pipeline_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPipelineDefinitionOutput,
    crate::error::GetPipelineDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_pipeline_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_pipeline_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPipelineDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipelines_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPipelinesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPipelinesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListPipelinesError {
            meta: generic,
            kind: crate::error::ListPipelinesErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListPipelinesError {
            meta: generic,
            kind: crate::error::ListPipelinesErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPipelinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPipelinesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_pipelines_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_pipelines_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_pipelines(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPipelinesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_poll_for_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PollForTaskOutput, crate::error::PollForTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PollForTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PollForTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::PollForTaskError {
            meta: generic,
            kind: crate::error::PollForTaskErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::PollForTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::PollForTaskError {
            meta: generic,
            kind: crate::error::PollForTaskErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PollForTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskNotFoundException" => crate::error::PollForTaskError {
            meta: generic,
            kind: crate::error::PollForTaskErrorKind::TaskNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PollForTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PollForTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_poll_for_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PollForTaskOutput, crate::error::PollForTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::poll_for_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_poll_for_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PollForTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_pipeline_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPipelineDefinitionOutput,
    crate::error::PutPipelineDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutPipelineDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutPipelineDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::PutPipelineDefinitionError {
            meta: generic,
            kind: crate::error::PutPipelineDefinitionErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::PutPipelineDefinitionError {
            meta: generic,
            kind: crate::error::PutPipelineDefinitionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::PutPipelineDefinitionError {
            meta: generic,
            kind: crate::error::PutPipelineDefinitionErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::PutPipelineDefinitionError {
            meta: generic,
            kind: crate::error::PutPipelineDefinitionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutPipelineDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_pipeline_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPipelineDefinitionOutput,
    crate::error::PutPipelineDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_pipeline_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_pipeline_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutPipelineDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_query_objects_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::QueryObjectsOutput, crate::error::QueryObjectsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::QueryObjectsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::QueryObjectsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::QueryObjectsError {
            meta: generic,
            kind: crate::error::QueryObjectsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::QueryObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::QueryObjectsError {
            meta: generic,
            kind: crate::error::QueryObjectsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::QueryObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::QueryObjectsError {
            meta: generic,
            kind: crate::error::QueryObjectsErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::QueryObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::QueryObjectsError {
            meta: generic,
            kind: crate::error::QueryObjectsErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::QueryObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::QueryObjectsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_query_objects_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::QueryObjectsOutput, crate::error::QueryObjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::query_objects_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_query_objects(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::QueryObjectsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_report_task_progress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReportTaskProgressOutput,
    crate::error::ReportTaskProgressError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReportTaskProgressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReportTaskProgressError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ReportTaskProgressError {
            meta: generic,
            kind: crate::error::ReportTaskProgressErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ReportTaskProgressError {
            meta: generic,
            kind: crate::error::ReportTaskProgressErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::ReportTaskProgressError {
            meta: generic,
            kind: crate::error::ReportTaskProgressErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::ReportTaskProgressError {
            meta: generic,
            kind: crate::error::ReportTaskProgressErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskNotFoundException" => crate::error::ReportTaskProgressError {
            meta: generic,
            kind: crate::error::ReportTaskProgressErrorKind::TaskNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskProgressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReportTaskProgressError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_report_task_progress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReportTaskProgressOutput,
    crate::error::ReportTaskProgressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::report_task_progress_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_report_task_progress(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReportTaskProgressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_report_task_runner_heartbeat_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReportTaskRunnerHeartbeatOutput,
    crate::error::ReportTaskRunnerHeartbeatError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReportTaskRunnerHeartbeatError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ReportTaskRunnerHeartbeatError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ReportTaskRunnerHeartbeatError {
            meta: generic,
            kind: crate::error::ReportTaskRunnerHeartbeatErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskRunnerHeartbeatError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ReportTaskRunnerHeartbeatError {
            meta: generic,
            kind: crate::error::ReportTaskRunnerHeartbeatErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReportTaskRunnerHeartbeatError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReportTaskRunnerHeartbeatError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_report_task_runner_heartbeat_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReportTaskRunnerHeartbeatOutput,
    crate::error::ReportTaskRunnerHeartbeatError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::report_task_runner_heartbeat_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_report_task_runner_heartbeat(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReportTaskRunnerHeartbeatError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetStatusOutput, crate::error::SetStatusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::SetStatusError {
            meta: generic,
            kind: crate::error::SetStatusErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::SetStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::SetStatusError {
            meta: generic,
            kind: crate::error::SetStatusErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::SetStatusError {
            meta: generic,
            kind: crate::error::SetStatusErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::SetStatusError {
            meta: generic,
            kind: crate::error::SetStatusErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetStatusOutput, crate::error::SetStatusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_status_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_task_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetTaskStatusOutput, crate::error::SetTaskStatusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetTaskStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetTaskStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::SetTaskStatusError {
            meta: generic,
            kind: crate::error::SetTaskStatusErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::SetTaskStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::SetTaskStatusError {
            meta: generic,
            kind: crate::error::SetTaskStatusErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetTaskStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::SetTaskStatusError {
            meta: generic,
            kind: crate::error::SetTaskStatusErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetTaskStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::SetTaskStatusError {
            meta: generic,
            kind: crate::error::SetTaskStatusErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetTaskStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskNotFoundException" => crate::error::SetTaskStatusError {
            meta: generic,
            kind: crate::error::SetTaskStatusErrorKind::TaskNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetTaskStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetTaskStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_task_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetTaskStatusOutput, crate::error::SetTaskStatusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_task_status_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_pipeline_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ValidatePipelineDefinitionOutput,
    crate::error::ValidatePipelineDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ValidatePipelineDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ValidatePipelineDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ValidatePipelineDefinitionError {
            meta: generic,
            kind: crate::error::ValidatePipelineDefinitionErrorKind::InternalServiceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_json_err(response.body().as_ref(), output).map_err(crate::error::ValidatePipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ValidatePipelineDefinitionError {
            meta: generic,
            kind: crate::error::ValidatePipelineDefinitionErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidatePipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineDeletedException" => crate::error::ValidatePipelineDefinitionError {
            meta: generic,
            kind: crate::error::ValidatePipelineDefinitionErrorKind::PipelineDeletedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_deleted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_deleted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidatePipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PipelineNotFoundException" => crate::error::ValidatePipelineDefinitionError {
            meta: generic,
            kind: crate::error::ValidatePipelineDefinitionErrorKind::PipelineNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::pipeline_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pipeline_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ValidatePipelineDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ValidatePipelineDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_validate_pipeline_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ValidatePipelineDefinitionOutput,
    crate::error::ValidatePipelineDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::validate_pipeline_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_validate_pipeline_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ValidatePipelineDefinitionError::unhandled)?;
        output.build()
    })
}
