// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Data Exchange
///
/// Client for invoking operations on AWS Data Exchange. Each operation on AWS Data Exchange is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_dataexchange::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_dataexchange::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_dataexchange::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelJob`](crate::client::fluent_builders::CancelJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelJob::set_job_id): <p>The unique identifier for a job.</p>
    /// - On success, responds with [`CancelJobOutput`](crate::output::CancelJobOutput)

    /// - On failure, responds with [`SdkError<CancelJobError>`](crate::error::CancelJobError)
    pub fn cancel_job(&self) -> fluent_builders::CancelJob {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSet`](crate::client::fluent_builders::CreateDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_type(AssetType)`](crate::client::fluent_builders::CreateDataSet::asset_type) / [`set_asset_type(Option<AssetType>)`](crate::client::fluent_builders::CreateDataSet::set_asset_type): <p>The type of asset that is added to a data set.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDataSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDataSet::set_description): <p>A description for the data set. This value can be up to 16,348 characters long.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDataSet::set_name): <p>The name of the data set.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDataSet::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDataSet::set_tags): <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
    /// - On success, responds with [`CreateDataSetOutput`](crate::output::CreateDataSetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDataSetOutput::arn): <p>The ARN for the data set.</p>
    ///   - [`asset_type(Option<AssetType>)`](crate::output::CreateDataSetOutput::asset_type): <p>The type of asset that is added to a data set.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreateDataSetOutput::created_at): <p>The date and time that the data set was created, in ISO 8601 format.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateDataSetOutput::description): <p>The description for the data set.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateDataSetOutput::id): <p>The unique identifier for the data set.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateDataSetOutput::name): <p>The name of the data set.</p>
    ///   - [`origin(Option<Origin>)`](crate::output::CreateDataSetOutput::origin): <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    ///   - [`origin_details(Option<OriginDetails>)`](crate::output::CreateDataSetOutput::origin_details): <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    ///   - [`source_id(Option<String>)`](crate::output::CreateDataSetOutput::source_id): <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateDataSetOutput::tags): <p>The tags for the data set.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::CreateDataSetOutput::updated_at): <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<CreateDataSetError>`](crate::error::CreateDataSetError)
    pub fn create_data_set(&self) -> fluent_builders::CreateDataSet {
        fluent_builders::CreateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventAction`](crate::client::fluent_builders::CreateEventAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(Action)`](crate::client::fluent_builders::CreateEventAction::action) / [`set_action(Option<Action>)`](crate::client::fluent_builders::CreateEventAction::set_action): <p>What occurs after a certain event.</p>
    ///   - [`event(Event)`](crate::client::fluent_builders::CreateEventAction::event) / [`set_event(Option<Event>)`](crate::client::fluent_builders::CreateEventAction::set_event): <p>What occurs to start an action.</p>
    /// - On success, responds with [`CreateEventActionOutput`](crate::output::CreateEventActionOutput) with field(s):
    ///   - [`action(Option<Action>)`](crate::output::CreateEventActionOutput::action): <p>What occurs after a certain event.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateEventActionOutput::arn): <p>The ARN for the event action.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreateEventActionOutput::created_at): <p>The date and time that the event action was created, in ISO 8601 format.</p>
    ///   - [`event(Option<Event>)`](crate::output::CreateEventActionOutput::event): <p>What occurs to start an action.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateEventActionOutput::id): <p>The unique identifier for the event action.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::CreateEventActionOutput::updated_at): <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<CreateEventActionError>`](crate::error::CreateEventActionError)
    pub fn create_event_action(&self) -> fluent_builders::CreateEventAction {
        fluent_builders::CreateEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJob`](crate::client::fluent_builders::CreateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`details(RequestDetails)`](crate::client::fluent_builders::CreateJob::details) / [`set_details(Option<RequestDetails>)`](crate::client::fluent_builders::CreateJob::set_details): <p>The details for the CreateJob request.</p>
    ///   - [`r#type(Type)`](crate::client::fluent_builders::CreateJob::type) / [`set_type(Option<Type>)`](crate::client::fluent_builders::CreateJob::set_type): <p>The type of job to be created.</p>
    /// - On success, responds with [`CreateJobOutput`](crate::output::CreateJobOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateJobOutput::arn): <p>The ARN for the job.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreateJobOutput::created_at): <p>The date and time that the job was created, in ISO 8601 format.</p>
    ///   - [`details(Option<ResponseDetails>)`](crate::output::CreateJobOutput::details): <p>Details about the job.</p>
    ///   - [`errors(Option<Vec<JobError>>)`](crate::output::CreateJobOutput::errors): <p>The errors associated with jobs.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateJobOutput::id): <p>The unique identifier for the job.</p>
    ///   - [`state(Option<State>)`](crate::output::CreateJobOutput::state): <p>The state of the job.</p>
    ///   - [`r#type(Option<Type>)`](crate::output::CreateJobOutput::type): <p>The job type.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::CreateJobOutput::updated_at): <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<CreateJobError>`](crate::error::CreateJobError)
    pub fn create_job(&self) -> fluent_builders::CreateJob {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRevision`](crate::client::fluent_builders::CreateRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::CreateRevision::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::CreateRevision::set_comment): <p>An optional comment about the revision.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::CreateRevision::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::CreateRevision::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRevision::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRevision::set_tags): <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
    /// - On success, responds with [`CreateRevisionOutput`](crate::output::CreateRevisionOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateRevisionOutput::arn): <p>The ARN for the revision.</p>
    ///   - [`comment(Option<String>)`](crate::output::CreateRevisionOutput::comment): <p>An optional comment about the revision.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreateRevisionOutput::created_at): <p>The date and time that the revision was created, in ISO 8601 format.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::CreateRevisionOutput::data_set_id): <p>The unique identifier for the data set associated with this revision.</p>
    ///   - [`finalized(bool)`](crate::output::CreateRevisionOutput::finalized): <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>  <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateRevisionOutput::id): <p>The unique identifier for the revision.</p>
    ///   - [`source_id(Option<String>)`](crate::output::CreateRevisionOutput::source_id): <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRevisionOutput::tags): <p>The tags for the revision.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::CreateRevisionOutput::updated_at): <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<CreateRevisionError>`](crate::error::CreateRevisionError)
    pub fn create_revision(&self) -> fluent_builders::CreateRevision {
        fluent_builders::CreateRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAsset`](crate::client::fluent_builders::DeleteAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DeleteAsset::set_asset_id): <p>The unique identifier for an asset.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAsset::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DeleteAsset::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAsset::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::DeleteAsset::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)

    /// - On failure, responds with [`SdkError<DeleteAssetError>`](crate::error::DeleteAssetError)
    pub fn delete_asset(&self) -> fluent_builders::DeleteAsset {
        fluent_builders::DeleteAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataSet`](crate::client::fluent_builders::DeleteDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSet::set_data_set_id): <p>The unique identifier for a data set.</p>
    /// - On success, responds with [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)

    /// - On failure, responds with [`SdkError<DeleteDataSetError>`](crate::error::DeleteDataSetError)
    pub fn delete_data_set(&self) -> fluent_builders::DeleteDataSet {
        fluent_builders::DeleteDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventAction`](crate::client::fluent_builders::DeleteEventAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_action_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEventAction::event_action_id) / [`set_event_action_id(Option<String>)`](crate::client::fluent_builders::DeleteEventAction::set_event_action_id): <p>The unique identifier for the event action.</p>
    /// - On success, responds with [`DeleteEventActionOutput`](crate::output::DeleteEventActionOutput)

    /// - On failure, responds with [`SdkError<DeleteEventActionError>`](crate::error::DeleteEventActionError)
    pub fn delete_event_action(&self) -> fluent_builders::DeleteEventAction {
        fluent_builders::DeleteEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRevision`](crate::client::fluent_builders::DeleteRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRevision::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DeleteRevision::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRevision::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::DeleteRevision::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`DeleteRevisionOutput`](crate::output::DeleteRevisionOutput)

    /// - On failure, responds with [`SdkError<DeleteRevisionError>`](crate::error::DeleteRevisionError)
    pub fn delete_revision(&self) -> fluent_builders::DeleteRevision {
        fluent_builders::DeleteRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAsset`](crate::client::fluent_builders::GetAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::GetAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::GetAsset::set_asset_id): <p>The unique identifier for an asset.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::GetAsset::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::GetAsset::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::GetAsset::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::GetAsset::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`GetAssetOutput`](crate::output::GetAssetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetAssetOutput::arn): <p>The ARN for the asset.</p>
    ///   - [`asset_details(Option<AssetDetails>)`](crate::output::GetAssetOutput::asset_details): <p>Information about the asset.</p>
    ///   - [`asset_type(Option<AssetType>)`](crate::output::GetAssetOutput::asset_type): <p>The type of asset that is added to a data set.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetAssetOutput::created_at): <p>The date and time that the asset was created, in ISO 8601 format.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::GetAssetOutput::data_set_id): <p>The unique identifier for the data set associated with this asset.</p>
    ///   - [`id(Option<String>)`](crate::output::GetAssetOutput::id): <p>The unique identifier for the asset.</p>
    ///   - [`name(Option<String>)`](crate::output::GetAssetOutput::name): <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::GetAssetOutput::revision_id): <p>The unique identifier for the revision associated with this asset.</p>
    ///   - [`source_id(Option<String>)`](crate::output::GetAssetOutput::source_id): <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetAssetOutput::updated_at): <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetAssetError>`](crate::error::GetAssetError)
    pub fn get_asset(&self) -> fluent_builders::GetAsset {
        fluent_builders::GetAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataSet`](crate::client::fluent_builders::GetDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::GetDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::GetDataSet::set_data_set_id): <p>The unique identifier for a data set.</p>
    /// - On success, responds with [`GetDataSetOutput`](crate::output::GetDataSetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetDataSetOutput::arn): <p>The ARN for the data set.</p>
    ///   - [`asset_type(Option<AssetType>)`](crate::output::GetDataSetOutput::asset_type): <p>The type of asset that is added to a data set.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetDataSetOutput::created_at): <p>The date and time that the data set was created, in ISO 8601 format.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDataSetOutput::description): <p>The description for the data set.</p>
    ///   - [`id(Option<String>)`](crate::output::GetDataSetOutput::id): <p>The unique identifier for the data set.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDataSetOutput::name): <p>The name of the data set.</p>
    ///   - [`origin(Option<Origin>)`](crate::output::GetDataSetOutput::origin): <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    ///   - [`origin_details(Option<OriginDetails>)`](crate::output::GetDataSetOutput::origin_details): <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    ///   - [`source_id(Option<String>)`](crate::output::GetDataSetOutput::source_id): <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDataSetOutput::tags): <p>The tags for the data set.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetDataSetOutput::updated_at): <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetDataSetError>`](crate::error::GetDataSetError)
    pub fn get_data_set(&self) -> fluent_builders::GetDataSet {
        fluent_builders::GetDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventAction`](crate::client::fluent_builders::GetEventAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_action_id(impl Into<String>)`](crate::client::fluent_builders::GetEventAction::event_action_id) / [`set_event_action_id(Option<String>)`](crate::client::fluent_builders::GetEventAction::set_event_action_id): <p>The unique identifier for the event action.</p>
    /// - On success, responds with [`GetEventActionOutput`](crate::output::GetEventActionOutput) with field(s):
    ///   - [`action(Option<Action>)`](crate::output::GetEventActionOutput::action): <p>What occurs after a certain event.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetEventActionOutput::arn): <p>The ARN for the event action.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetEventActionOutput::created_at): <p>The date and time that the event action was created, in ISO 8601 format.</p>
    ///   - [`event(Option<Event>)`](crate::output::GetEventActionOutput::event): <p>What occurs to start an action.</p>
    ///   - [`id(Option<String>)`](crate::output::GetEventActionOutput::id): <p>The unique identifier for the event action.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetEventActionOutput::updated_at): <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetEventActionError>`](crate::error::GetEventActionError)
    pub fn get_event_action(&self) -> fluent_builders::GetEventAction {
        fluent_builders::GetEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJob`](crate::client::fluent_builders::GetJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetJob::set_job_id): <p>The unique identifier for a job.</p>
    /// - On success, responds with [`GetJobOutput`](crate::output::GetJobOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetJobOutput::arn): <p>The ARN for the job.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetJobOutput::created_at): <p>The date and time that the job was created, in ISO 8601 format.</p>
    ///   - [`details(Option<ResponseDetails>)`](crate::output::GetJobOutput::details): <p>Details about the job.</p>
    ///   - [`errors(Option<Vec<JobError>>)`](crate::output::GetJobOutput::errors): <p>The errors associated with jobs.</p>
    ///   - [`id(Option<String>)`](crate::output::GetJobOutput::id): <p>The unique identifier for the job.</p>
    ///   - [`state(Option<State>)`](crate::output::GetJobOutput::state): <p>The state of the job.</p>
    ///   - [`r#type(Option<Type>)`](crate::output::GetJobOutput::type): <p>The job type.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetJobOutput::updated_at): <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetJobError>`](crate::error::GetJobError)
    pub fn get_job(&self) -> fluent_builders::GetJob {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRevision`](crate::client::fluent_builders::GetRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::GetRevision::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::GetRevision::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::GetRevision::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::GetRevision::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`GetRevisionOutput`](crate::output::GetRevisionOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetRevisionOutput::arn): <p>The ARN for the revision.</p>
    ///   - [`comment(Option<String>)`](crate::output::GetRevisionOutput::comment): <p>An optional comment about the revision.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetRevisionOutput::created_at): <p>The date and time that the revision was created, in ISO 8601 format.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::GetRevisionOutput::data_set_id): <p>The unique identifier for the data set associated with this revision.</p>
    ///   - [`finalized(bool)`](crate::output::GetRevisionOutput::finalized): <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>  <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    ///   - [`id(Option<String>)`](crate::output::GetRevisionOutput::id): <p>The unique identifier for the revision.</p>
    ///   - [`source_id(Option<String>)`](crate::output::GetRevisionOutput::source_id): <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetRevisionOutput::tags): <p>The tags for the revision.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetRevisionOutput::updated_at): <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<GetRevisionError>`](crate::error::GetRevisionError)
    pub fn get_revision(&self) -> fluent_builders::GetRevision {
        fluent_builders::GetRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataSetRevisions`](crate::client::fluent_builders::ListDataSetRevisions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDataSetRevisions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::ListDataSetRevisions::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::ListDataSetRevisions::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataSetRevisions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDataSetRevisions::set_max_results): <p>The maximum number of results returned by a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataSetRevisions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataSetRevisions::set_next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    /// - On success, responds with [`ListDataSetRevisionsOutput`](crate::output::ListDataSetRevisionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListDataSetRevisionsOutput::next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    ///   - [`revisions(Option<Vec<RevisionEntry>>)`](crate::output::ListDataSetRevisionsOutput::revisions): <p>The asset objects listed by the request.</p>
    /// - On failure, responds with [`SdkError<ListDataSetRevisionsError>`](crate::error::ListDataSetRevisionsError)
    pub fn list_data_set_revisions(&self) -> fluent_builders::ListDataSetRevisions {
        fluent_builders::ListDataSetRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataSets`](crate::client::fluent_builders::ListDataSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDataSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataSets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDataSets::set_max_results): <p>The maximum number of results returned by a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataSets::set_next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    ///   - [`origin(impl Into<String>)`](crate::client::fluent_builders::ListDataSets::origin) / [`set_origin(Option<String>)`](crate::client::fluent_builders::ListDataSets::set_origin): <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    /// - On success, responds with [`ListDataSetsOutput`](crate::output::ListDataSetsOutput) with field(s):
    ///   - [`data_sets(Option<Vec<DataSetEntry>>)`](crate::output::ListDataSetsOutput::data_sets): <p>The data set objects listed by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataSetsOutput::next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListDataSetsError>`](crate::error::ListDataSetsError)
    pub fn list_data_sets(&self) -> fluent_builders::ListDataSets {
        fluent_builders::ListDataSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventActions`](crate::client::fluent_builders::ListEventActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEventActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_source_id(impl Into<String>)`](crate::client::fluent_builders::ListEventActions::event_source_id) / [`set_event_source_id(Option<String>)`](crate::client::fluent_builders::ListEventActions::set_event_source_id): <p>The unique identifier for the event source.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventActions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListEventActions::set_max_results): <p>The maximum number of results returned by a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventActions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventActions::set_next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    /// - On success, responds with [`ListEventActionsOutput`](crate::output::ListEventActionsOutput) with field(s):
    ///   - [`event_actions(Option<Vec<EventActionEntry>>)`](crate::output::ListEventActionsOutput::event_actions): <p>The event action objects listed by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventActionsOutput::next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListEventActionsError>`](crate::error::ListEventActionsError)
    pub fn list_event_actions(&self) -> fluent_builders::ListEventActions {
        fluent_builders::ListEventActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobs`](crate::client::fluent_builders::ListJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::ListJobs::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::ListJobs::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListJobs::set_max_results): <p>The maximum number of results returned by a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobs::set_next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::ListJobs::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::ListJobs::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`ListJobsOutput`](crate::output::ListJobsOutput) with field(s):
    ///   - [`jobs(Option<Vec<JobEntry>>)`](crate::output::ListJobsOutput::jobs): <p>The jobs listed by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobsOutput::next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListJobsError>`](crate::error::ListJobsError)
    pub fn list_jobs(&self) -> fluent_builders::ListJobs {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRevisionAssets`](crate::client::fluent_builders::ListRevisionAssets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRevisionAssets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::ListRevisionAssets::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::ListRevisionAssets::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRevisionAssets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRevisionAssets::set_max_results): <p>The maximum number of results returned by a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRevisionAssets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRevisionAssets::set_next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::ListRevisionAssets::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::ListRevisionAssets::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`ListRevisionAssetsOutput`](crate::output::ListRevisionAssetsOutput) with field(s):
    ///   - [`assets(Option<Vec<AssetEntry>>)`](crate::output::ListRevisionAssetsOutput::assets): <p>The asset objects listed by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRevisionAssetsOutput::next_token): <p>The token value retrieved from a previous call to access the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListRevisionAssetsError>`](crate::error::ListRevisionAssetsError)
    pub fn list_revision_assets(&self) -> fluent_builders::ListRevisionAssets {
        fluent_builders::ListRevisionAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): A label that consists of a customer-defined key and an optional value.
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendApiAsset`](crate::client::fluent_builders::SendApiAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`body(impl Into<String>)`](crate::client::fluent_builders::SendApiAsset::body) / [`set_body(Option<String>)`](crate::client::fluent_builders::SendApiAsset::set_body): <p>The request body.</p>
    ///   - [`query_string_parameters(HashMap<String, String>)`](crate::client::fluent_builders::SendApiAsset::query_string_parameters) / [`set_query_string_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SendApiAsset::set_query_string_parameters): <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::SendApiAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::SendApiAsset::set_asset_id): <p>Asset ID value for the API request.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::SendApiAsset::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::SendApiAsset::set_data_set_id): <p>Data set ID value for the API request.</p>
    ///   - [`request_headers(HashMap<String, String>)`](crate::client::fluent_builders::SendApiAsset::request_headers) / [`set_request_headers(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SendApiAsset::set_request_headers): <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
    ///   - [`method(impl Into<String>)`](crate::client::fluent_builders::SendApiAsset::method) / [`set_method(Option<String>)`](crate::client::fluent_builders::SendApiAsset::set_method): <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
    ///   - [`path(impl Into<String>)`](crate::client::fluent_builders::SendApiAsset::path) / [`set_path(Option<String>)`](crate::client::fluent_builders::SendApiAsset::set_path): <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::SendApiAsset::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::SendApiAsset::set_revision_id): <p>Revision ID value for the API request.</p>
    /// - On success, responds with [`SendApiAssetOutput`](crate::output::SendApiAssetOutput) with field(s):
    ///   - [`body(Option<String>)`](crate::output::SendApiAssetOutput::body): <p>The response body from the underlying API tracked by the API asset.</p>
    ///   - [`response_headers(Option<HashMap<String, String>>)`](crate::output::SendApiAssetOutput::response_headers): <p>The response headers from the underlying API tracked by the API asset.</p>
    /// - On failure, responds with [`SdkError<SendApiAssetError>`](crate::error::SendApiAssetError)
    pub fn send_api_asset(&self) -> fluent_builders::SendApiAsset {
        fluent_builders::SendApiAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartJob`](crate::client::fluent_builders::StartJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StartJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StartJob::set_job_id): <p>The unique identifier for a job.</p>
    /// - On success, responds with [`StartJobOutput`](crate::output::StartJobOutput)

    /// - On failure, responds with [`SdkError<StartJobError>`](crate::error::StartJobError)
    pub fn start_job(&self) -> fluent_builders::StartJob {
        fluent_builders::StartJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): A label that consists of a customer-defined key and an optional value.
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): The key tags.
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAsset`](crate::client::fluent_builders::UpdateAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_asset_id): <p>The unique identifier for an asset.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_name): <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`UpdateAssetOutput`](crate::output::UpdateAssetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateAssetOutput::arn): <p>The ARN for the asset.</p>
    ///   - [`asset_details(Option<AssetDetails>)`](crate::output::UpdateAssetOutput::asset_details): <p>Information about the asset.</p>
    ///   - [`asset_type(Option<AssetType>)`](crate::output::UpdateAssetOutput::asset_type): <p>The type of asset that is added to a data set.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::UpdateAssetOutput::created_at): <p>The date and time that the asset was created, in ISO 8601 format.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::UpdateAssetOutput::data_set_id): <p>The unique identifier for the data set associated with this asset.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateAssetOutput::id): <p>The unique identifier for the asset.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateAssetOutput::name): <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::UpdateAssetOutput::revision_id): <p>The unique identifier for the revision associated with this asset.</p>
    ///   - [`source_id(Option<String>)`](crate::output::UpdateAssetOutput::source_id): <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::UpdateAssetOutput::updated_at): <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<UpdateAssetError>`](crate::error::UpdateAssetError)
    pub fn update_asset(&self) -> fluent_builders::UpdateAsset {
        fluent_builders::UpdateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSet`](crate::client::fluent_builders::UpdateDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSet::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDataSet::set_description): <p>The description for the data set.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDataSet::set_name): <p>The name of the data set.</p>
    /// - On success, responds with [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateDataSetOutput::arn): <p>The ARN for the data set.</p>
    ///   - [`asset_type(Option<AssetType>)`](crate::output::UpdateDataSetOutput::asset_type): <p>The type of asset that is added to a data set.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::UpdateDataSetOutput::created_at): <p>The date and time that the data set was created, in ISO 8601 format.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateDataSetOutput::description): <p>The description for the data set.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateDataSetOutput::id): <p>The unique identifier for the data set.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateDataSetOutput::name): <p>The name of the data set.</p>
    ///   - [`origin(Option<Origin>)`](crate::output::UpdateDataSetOutput::origin): <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    ///   - [`origin_details(Option<OriginDetails>)`](crate::output::UpdateDataSetOutput::origin_details): <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    ///   - [`source_id(Option<String>)`](crate::output::UpdateDataSetOutput::source_id): <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::UpdateDataSetOutput::updated_at): <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSetError>`](crate::error::UpdateDataSetError)
    pub fn update_data_set(&self) -> fluent_builders::UpdateDataSet {
        fluent_builders::UpdateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventAction`](crate::client::fluent_builders::UpdateEventAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(Action)`](crate::client::fluent_builders::UpdateEventAction::action) / [`set_action(Option<Action>)`](crate::client::fluent_builders::UpdateEventAction::set_action): <p>What occurs after a certain event.</p>
    ///   - [`event_action_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEventAction::event_action_id) / [`set_event_action_id(Option<String>)`](crate::client::fluent_builders::UpdateEventAction::set_event_action_id): <p>The unique identifier for the event action.</p>
    /// - On success, responds with [`UpdateEventActionOutput`](crate::output::UpdateEventActionOutput) with field(s):
    ///   - [`action(Option<Action>)`](crate::output::UpdateEventActionOutput::action): <p>What occurs after a certain event.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateEventActionOutput::arn): <p>The ARN for the event action.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::UpdateEventActionOutput::created_at): <p>The date and time that the event action was created, in ISO 8601 format.</p>
    ///   - [`event(Option<Event>)`](crate::output::UpdateEventActionOutput::event): <p>What occurs to start an action.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateEventActionOutput::id): <p>The unique identifier for the event action.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::UpdateEventActionOutput::updated_at): <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<UpdateEventActionError>`](crate::error::UpdateEventActionError)
    pub fn update_event_action(&self) -> fluent_builders::UpdateEventAction {
        fluent_builders::UpdateEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRevision`](crate::client::fluent_builders::UpdateRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::UpdateRevision::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::UpdateRevision::set_comment): <p>An optional comment about the revision.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRevision::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::UpdateRevision::set_data_set_id): <p>The unique identifier for a data set.</p>
    ///   - [`finalized(bool)`](crate::client::fluent_builders::UpdateRevision::finalized) / [`set_finalized(bool)`](crate::client::fluent_builders::UpdateRevision::set_finalized): <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRevision::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateRevision::set_revision_id): <p>The unique identifier for a revision.</p>
    /// - On success, responds with [`UpdateRevisionOutput`](crate::output::UpdateRevisionOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateRevisionOutput::arn): <p>The ARN for the revision.</p>
    ///   - [`comment(Option<String>)`](crate::output::UpdateRevisionOutput::comment): <p>An optional comment about the revision.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::UpdateRevisionOutput::created_at): <p>The date and time that the revision was created, in ISO 8601 format.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::UpdateRevisionOutput::data_set_id): <p>The unique identifier for the data set associated with this revision.</p>
    ///   - [`finalized(bool)`](crate::output::UpdateRevisionOutput::finalized): <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>  <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateRevisionOutput::id): <p>The unique identifier for the revision.</p>
    ///   - [`source_id(Option<String>)`](crate::output::UpdateRevisionOutput::source_id): <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::UpdateRevisionOutput::updated_at): <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    /// - On failure, responds with [`SdkError<UpdateRevisionError>`](crate::error::UpdateRevisionError)
    pub fn update_revision(&self) -> fluent_builders::UpdateRevision {
        fluent_builders::UpdateRevision::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl CancelJob {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSet`.
    ///
    /// <p>This operation creates a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_set_input::Builder,
    }
    impl CreateDataSet {
        /// Creates a new `CreateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.inner = self.inner.asset_type(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.inner = self.inner.set_asset_type(input);
            self
        }
        /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventAction`.
    ///
    /// <p>This operation creates an event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_action_input::Builder,
    }
    impl CreateEventAction {
        /// Creates a new `CreateEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.inner = self.inner.event(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>This operation creates a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_job_input::Builder,
    }
    impl CreateJob {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details for the CreateJob request.</p>
        pub fn details(mut self, input: crate::model::RequestDetails) -> Self {
            self.inner = self.inner.details(input);
            self
        }
        /// <p>The details for the CreateJob request.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::RequestDetails>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
        /// <p>The type of job to be created.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of job to be created.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRevision`.
    ///
    /// <p>This operation creates a revision for a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_revision_input::Builder,
    }
    impl CreateRevision {
        /// Creates a new `CreateRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAsset`.
    ///
    /// <p>This operation deletes an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_asset_input::Builder,
    }
    impl DeleteAsset {
        /// Creates a new `DeleteAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSet`.
    ///
    /// <p>This operation deletes a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_data_set_input::Builder,
    }
    impl DeleteDataSet {
        /// Creates a new `DeleteDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventAction`.
    ///
    /// <p>This operation deletes the event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_action_input::Builder,
    }
    impl DeleteEventAction {
        /// Creates a new `DeleteEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_action_id(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRevision`.
    ///
    /// <p>This operation deletes a revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_revision_input::Builder,
    }
    impl DeleteRevision {
        /// Creates a new `DeleteRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAsset`.
    ///
    /// <p>This operation returns information about an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_asset_input::Builder,
    }
    impl GetAsset {
        /// Creates a new `GetAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataSet`.
    ///
    /// <p>This operation returns information about a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_data_set_input::Builder,
    }
    impl GetDataSet {
        /// Creates a new `GetDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventAction`.
    ///
    /// <p>This operation retrieves information about an event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_action_input::Builder,
    }
    impl GetEventAction {
        /// Creates a new `GetEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_action_id(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p>This operation returns information about a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_job_input::Builder,
    }
    impl GetJob {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRevision`.
    ///
    /// <p>This operation returns information about a revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_revision_input::Builder,
    }
    impl GetRevision {
        /// Creates a new `GetRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSetRevisions`.
    ///
    /// <p>This operation lists a data set's revisions sorted by CreatedAt in descending order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSetRevisions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_data_set_revisions_input::Builder,
    }
    impl ListDataSetRevisions {
        /// Creates a new `ListDataSetRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSetRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSetRevisionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataSetRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataSetRevisionsPaginator {
            crate::paginator::ListDataSetRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSets`.
    ///
    /// <p>This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_data_sets_input::Builder,
    }
    impl ListDataSets {
        /// Creates a new `ListDataSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataSetsPaginator {
            crate::paginator::ListDataSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin(input.into());
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventActions`.
    ///
    /// <p>This operation lists your event actions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_actions_input::Builder,
    }
    impl ListEventActions {
        /// Creates a new `ListEventActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventActionsPaginator {
            crate::paginator::ListEventActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for the event source.</p>
        pub fn event_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_id(input.into());
            self
        }
        /// <p>The unique identifier for the event source.</p>
        pub fn set_event_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>This operation lists your jobs sorted by CreatedAt in descending order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl ListJobs {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsPaginator {
            crate::paginator::ListJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRevisionAssets`.
    ///
    /// <p>This operation lists a revision's assets sorted alphabetically in descending order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRevisionAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_revision_assets_input::Builder,
    }
    impl ListRevisionAssets {
        /// Creates a new `ListRevisionAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRevisionAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRevisionAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRevisionAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRevisionAssetsPaginator {
            crate::paginator::ListRevisionAssetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>This operation lists the tags on the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendApiAsset`.
    ///
    /// <p>This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendApiAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_api_asset_input::Builder,
    }
    impl SendApiAsset {
        /// Creates a new `SendApiAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendApiAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::SendApiAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request body.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The request body.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// Adds a key-value pair to `QueryStringParameters`.
        ///
        /// To override the contents of this collection use [`set_query_string_parameters`](Self::set_query_string_parameters).
        ///
        /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
        pub fn query_string_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.query_string_parameters(k.into(), v.into());
            self
        }
        /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
        pub fn set_query_string_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_query_string_parameters(input);
            self
        }
        /// <p>Asset ID value for the API request.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>Asset ID value for the API request.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>Data set ID value for the API request.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>Data set ID value for the API request.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// Adds a key-value pair to `RequestHeaders`.
        ///
        /// To override the contents of this collection use [`set_request_headers`](Self::set_request_headers).
        ///
        /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
        pub fn request_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_headers(k.into(), v.into());
            self
        }
        /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
        pub fn set_request_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_headers(input);
            self
        }
        /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
        pub fn method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.method(input.into());
            self
        }
        /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
        pub fn set_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_method(input);
            self
        }
        /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(input.into());
            self
        }
        /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>Revision ID value for the API request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Revision ID value for the API request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJob`.
    ///
    /// <p>This operation starts a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_job_input::Builder,
    }
    impl StartJob {
        /// Creates a new `StartJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>This operation tags a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A label that consists of a customer-defined key and an optional value.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A label that consists of a customer-defined key and an optional value.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>This operation removes one or more tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The key tags.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// The key tags.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAsset`.
    ///
    /// <p>This operation updates an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_asset_input::Builder,
    }
    impl UpdateAsset {
        /// Creates a new `UpdateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSet`.
    ///
    /// <p>This operation updates a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_data_set_input::Builder,
    }
    impl UpdateDataSet {
        /// Creates a new `UpdateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventAction`.
    ///
    /// <p>This operation updates the event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_event_action_input::Builder,
    }
    impl UpdateEventAction {
        /// Creates a new `UpdateEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_action_id(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRevision`.
    ///
    /// <p>This operation updates a revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_revision_input::Builder,
    }
    impl UpdateRevision {
        /// Creates a new `UpdateRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.inner = self.inner.finalized(input);
            self
        }
        /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_finalized(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
