// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelJobInput`](crate::input::CancelJobInput)
pub mod cancel_job_input {
    /// A builder for [`CancelJobInput`](crate::input::CancelJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJobInput`](crate::input::CancelJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CancelJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CancelJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelJobInputOperationOutputAlias = crate::operation::CancelJob;
#[doc(hidden)]
pub type CancelJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelJob`](crate::operation::CancelJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.job_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_1, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/jobs/{JobId}", JobId = job_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CancelJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CancelJob",
                    "dataexchange",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelJobInput`](crate::input::CancelJobInput)
    pub fn builder() -> crate::input::cancel_job_input::Builder {
        crate::input::cancel_job_input::Builder::default()
    }
}

/// See [`CreateDataSetInput`](crate::input::CreateDataSetInput)
pub mod create_data_set_input {
    /// A builder for [`CreateDataSetInput`](crate::input::CreateDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSetInput`](crate::input::CreateDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSetInput {
                asset_type: self.asset_type,
                description: self.description,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSetInputOperationOutputAlias = crate::operation::CreateDataSet;
#[doc(hidden)]
pub type CreateDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSet`](crate::operation::CreateDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/data-sets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSet",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSetInput`](crate::input::CreateDataSetInput)
    pub fn builder() -> crate::input::create_data_set_input::Builder {
        crate::input::create_data_set_input::Builder::default()
    }
}

/// See [`CreateEventActionInput`](crate::input::CreateEventActionInput)
pub mod create_event_action_input {
    /// A builder for [`CreateEventActionInput`](crate::input::CreateEventActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) event: std::option::Option<crate::model::Event>,
    }
    impl Builder {
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventActionInput`](crate::input::CreateEventActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventActionInput {
                action: self.action,
                event: self.event,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventActionInputOperationOutputAlias = crate::operation::CreateEventAction;
#[doc(hidden)]
pub type CreateEventActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEventActionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventAction`](crate::operation::CreateEventAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/event-actions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventAction",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventActionInput`](crate::input::CreateEventActionInput)
    pub fn builder() -> crate::input::create_event_action_input::Builder {
        crate::input::create_event_action_input::Builder::default()
    }
}

/// See [`CreateJobInput`](crate::input::CreateJobInput)
pub mod create_job_input {
    /// A builder for [`CreateJobInput`](crate::input::CreateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) details: std::option::Option<crate::model::RequestDetails>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// <p>The details for the CreateJob request.</p>
        pub fn details(mut self, input: crate::model::RequestDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>The details for the CreateJob request.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::RequestDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// <p>The type of job to be created.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of job to be created.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobInput`](crate::input::CreateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateJobInput {
                details: self.details,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJobInputOperationOutputAlias = crate::operation::CreateJob;
#[doc(hidden)]
pub type CreateJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateJob`](crate::operation::CreateJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateJob",
                    "dataexchange",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
}

/// See [`CreateRevisionInput`](crate::input::CreateRevisionInput)
pub mod create_revision_input {
    /// A builder for [`CreateRevisionInput`](crate::input::CreateRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRevisionInput`](crate::input::CreateRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRevisionInput {
                comment: self.comment,
                data_set_id: self.data_set_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRevisionInputOperationOutputAlias = crate::operation::CreateRevision;
#[doc(hidden)]
pub type CreateRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRevisionInput {
    /// Consumes the builder and constructs an Operation<[`CreateRevision`](crate::operation::CreateRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.data_set_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_2, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions",
                DataSetId = data_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_revision(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRevision",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRevisionInput`](crate::input::CreateRevisionInput)
    pub fn builder() -> crate::input::create_revision_input::Builder {
        crate::input::create_revision_input::Builder::default()
    }
}

/// See [`DeleteAssetInput`](crate::input::DeleteAssetInput)
pub mod delete_asset_input {
    /// A builder for [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssetInput`](crate::input::DeleteAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssetInput {
                asset_id: self.asset_id,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssetInputOperationOutputAlias = crate::operation::DeleteAsset;
#[doc(hidden)]
pub type DeleteAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAssetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAsset`](crate::operation::DeleteAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.data_set_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_3, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.revision_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_4, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.asset_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_5, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}",
                DataSetId = data_set_id,
                RevisionId = revision_id,
                AssetId = asset_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAsset",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    pub fn builder() -> crate::input::delete_asset_input::Builder {
        crate::input::delete_asset_input::Builder::default()
    }
}

/// See [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
pub mod delete_data_set_input {
    /// A builder for [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataSetInput {
                data_set_id: self.data_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataSetInputOperationOutputAlias = crate::operation::DeleteDataSet;
#[doc(hidden)]
pub type DeleteDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDataSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataSet`](crate::operation::DeleteDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.data_set_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_6, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/data-sets/{DataSetId}", DataSetId = data_set_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataSet",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
    pub fn builder() -> crate::input::delete_data_set_input::Builder {
        crate::input::delete_data_set_input::Builder::default()
    }
}

/// See [`DeleteEventActionInput`](crate::input::DeleteEventActionInput)
pub mod delete_event_action_input {
    /// A builder for [`DeleteEventActionInput`](crate::input::DeleteEventActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_action_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventActionInput`](crate::input::DeleteEventActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventActionInput {
                event_action_id: self.event_action_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventActionInputOperationOutputAlias = crate::operation::DeleteEventAction;
#[doc(hidden)]
pub type DeleteEventActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventAction`](crate::operation::DeleteEventAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.event_action_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_action_id",
                        details: "cannot be empty or unset",
                    })?;
            let event_action_id = aws_smithy_http::label::fmt_string(input_7, false);
            if event_action_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "event_action_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/event-actions/{EventActionId}",
                EventActionId = event_action_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventAction",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventActionInput`](crate::input::DeleteEventActionInput)
    pub fn builder() -> crate::input::delete_event_action_input::Builder {
        crate::input::delete_event_action_input::Builder::default()
    }
}

/// See [`DeleteRevisionInput`](crate::input::DeleteRevisionInput)
pub mod delete_revision_input {
    /// A builder for [`DeleteRevisionInput`](crate::input::DeleteRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRevisionInput`](crate::input::DeleteRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRevisionInput {
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRevisionInputOperationOutputAlias = crate::operation::DeleteRevision;
#[doc(hidden)]
pub type DeleteRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRevisionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRevision`](crate::operation::DeleteRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.data_set_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_8, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.revision_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_9, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
                DataSetId = data_set_id,
                RevisionId = revision_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRevision",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRevisionInput`](crate::input::DeleteRevisionInput)
    pub fn builder() -> crate::input::delete_revision_input::Builder {
        crate::input::delete_revision_input::Builder::default()
    }
}

/// See [`GetAssetInput`](crate::input::GetAssetInput)
pub mod get_asset_input {
    /// A builder for [`GetAssetInput`](crate::input::GetAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetInput`](crate::input::GetAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAssetInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAssetInput {
                asset_id: self.asset_id,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssetInputOperationOutputAlias = crate::operation::GetAsset;
#[doc(hidden)]
pub type GetAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAssetInput {
    /// Consumes the builder and constructs an Operation<[`GetAsset`](crate::operation::GetAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.data_set_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_10, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.revision_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_11, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.asset_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_12, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}",
                DataSetId = data_set_id,
                RevisionId = revision_id,
                AssetId = asset_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetAsset::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetAsset",
                    "dataexchange",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssetInput`](crate::input::GetAssetInput)
    pub fn builder() -> crate::input::get_asset_input::Builder {
        crate::input::get_asset_input::Builder::default()
    }
}

/// See [`GetDataSetInput`](crate::input::GetDataSetInput)
pub mod get_data_set_input {
    /// A builder for [`GetDataSetInput`](crate::input::GetDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataSetInput`](crate::input::GetDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataSetInput {
                data_set_id: self.data_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataSetInputOperationOutputAlias = crate::operation::GetDataSet;
#[doc(hidden)]
pub type GetDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDataSetInput {
    /// Consumes the builder and constructs an Operation<[`GetDataSet`](crate::operation::GetDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.data_set_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_13, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/data-sets/{DataSetId}", DataSetId = data_set_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataSet",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataSetInput`](crate::input::GetDataSetInput)
    pub fn builder() -> crate::input::get_data_set_input::Builder {
        crate::input::get_data_set_input::Builder::default()
    }
}

/// See [`GetEventActionInput`](crate::input::GetEventActionInput)
pub mod get_event_action_input {
    /// A builder for [`GetEventActionInput`](crate::input::GetEventActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_action_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventActionInput`](crate::input::GetEventActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventActionInput {
                event_action_id: self.event_action_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventActionInputOperationOutputAlias = crate::operation::GetEventAction;
#[doc(hidden)]
pub type GetEventActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEventActionInput {
    /// Consumes the builder and constructs an Operation<[`GetEventAction`](crate::operation::GetEventAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEventActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.event_action_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_action_id",
                        details: "cannot be empty or unset",
                    })?;
            let event_action_id = aws_smithy_http::label::fmt_string(input_14, false);
            if event_action_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "event_action_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/event-actions/{EventActionId}",
                EventActionId = event_action_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEventActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEventActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventAction",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEventActionInput`](crate::input::GetEventActionInput)
    pub fn builder() -> crate::input::get_event_action_input::Builder {
        crate::input::get_event_action_input::Builder::default()
    }
}

/// See [`GetJobInput`](crate::input::GetJobInput)
pub mod get_job_input {
    /// A builder for [`GetJobInput`](crate::input::GetJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobInput`](crate::input::GetJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobInputOperationOutputAlias = crate::operation::GetJob;
#[doc(hidden)]
pub type GetJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobInput {
    /// Consumes the builder and constructs an Operation<[`GetJob`](crate::operation::GetJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.job_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_15, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/jobs/{JobId}", JobId = job_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetJob",
                    "dataexchange",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
}

/// See [`GetRevisionInput`](crate::input::GetRevisionInput)
pub mod get_revision_input {
    /// A builder for [`GetRevisionInput`](crate::input::GetRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRevisionInput`](crate::input::GetRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRevisionInput {
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRevisionInputOperationOutputAlias = crate::operation::GetRevision;
#[doc(hidden)]
pub type GetRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRevisionInput {
    /// Consumes the builder and constructs an Operation<[`GetRevision`](crate::operation::GetRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.data_set_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_16, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.revision_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_17, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
                DataSetId = data_set_id,
                RevisionId = revision_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRevision",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRevisionInput`](crate::input::GetRevisionInput)
    pub fn builder() -> crate::input::get_revision_input::Builder {
        crate::input::get_revision_input::Builder::default()
    }
}

/// See [`ListDataSetRevisionsInput`](crate::input::ListDataSetRevisionsInput)
pub mod list_data_set_revisions_input {
    /// A builder for [`ListDataSetRevisionsInput`](crate::input::ListDataSetRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSetRevisionsInput`](crate::input::ListDataSetRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSetRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSetRevisionsInput {
                data_set_id: self.data_set_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSetRevisionsInputOperationOutputAlias = crate::operation::ListDataSetRevisions;
#[doc(hidden)]
pub type ListDataSetRevisionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSetRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSetRevisions`](crate::operation::ListDataSetRevisions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSetRevisions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataSetRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.data_set_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_18, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions",
                DataSetId = data_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDataSetRevisionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_19) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataSetRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataSetRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSetRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSetRevisions",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataSetRevisionsInput`](crate::input::ListDataSetRevisionsInput)
    pub fn builder() -> crate::input::list_data_set_revisions_input::Builder {
        crate::input::list_data_set_revisions_input::Builder::default()
    }
}

/// See [`ListDataSetsInput`](crate::input::ListDataSetsInput)
pub mod list_data_sets_input {
    /// A builder for [`ListDataSetsInput`](crate::input::ListDataSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin = Some(input.into());
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.origin = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSetsInput`](crate::input::ListDataSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSetsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                origin: self.origin,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSetsInputOperationOutputAlias = crate::operation::ListDataSets;
#[doc(hidden)]
pub type ListDataSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSets`](crate::operation::ListDataSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/data-sets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDataSetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_20) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_20));
            }
            if let Some(inner_21) = &_input.origin {
                query.push_kv("origin", &aws_smithy_http::query::fmt_string(&inner_21));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSets",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataSetsInput`](crate::input::ListDataSetsInput)
    pub fn builder() -> crate::input::list_data_sets_input::Builder {
        crate::input::list_data_sets_input::Builder::default()
    }
}

/// See [`ListEventActionsInput`](crate::input::ListEventActionsInput)
pub mod list_event_actions_input {
    /// A builder for [`ListEventActionsInput`](crate::input::ListEventActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_source_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the event source.</p>
        pub fn event_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event source.</p>
        pub fn set_event_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_id = input;
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventActionsInput`](crate::input::ListEventActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventActionsInput {
                event_source_id: self.event_source_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventActionsInputOperationOutputAlias = crate::operation::ListEventActions;
#[doc(hidden)]
pub type ListEventActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEventActionsInput {
    /// Consumes the builder and constructs an Operation<[`ListEventActions`](crate::operation::ListEventActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/event-actions").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEventActionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_22) = &_input.event_source_id {
                query.push_kv(
                    "eventSourceId",
                    &aws_smithy_http::query::fmt_string(&inner_22),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventActions",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventActionsInput`](crate::input::ListEventActionsInput)
    pub fn builder() -> crate::input::list_event_actions_input::Builder {
        crate::input::list_event_actions_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                data_set_id: self.data_set_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.data_set_id {
                query.push_kv("dataSetId", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if let Some(inner_26) = &_input.revision_id {
                query.push_kv("revisionId", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs",
                    "dataexchange",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListRevisionAssetsInput`](crate::input::ListRevisionAssetsInput)
pub mod list_revision_assets_input {
    /// A builder for [`ListRevisionAssetsInput`](crate::input::ListRevisionAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRevisionAssetsInput`](crate::input::ListRevisionAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRevisionAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRevisionAssetsInput {
                data_set_id: self.data_set_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRevisionAssetsInputOperationOutputAlias = crate::operation::ListRevisionAssets;
#[doc(hidden)]
pub type ListRevisionAssetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRevisionAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListRevisionAssets`](crate::operation::ListRevisionAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRevisionAssets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRevisionAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.data_set_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_27, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.revision_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_28, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets",
                DataSetId = data_set_id,
                RevisionId = revision_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRevisionAssetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_29) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_29));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRevisionAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRevisionAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRevisionAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRevisionAssets",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRevisionAssetsInput`](crate::input::ListRevisionAssetsInput)
    pub fn builder() -> crate::input::list_revision_assets_input::Builder {
        crate::input::list_revision_assets_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.resource_arn;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_30, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`SendApiAssetInput`](crate::input::SendApiAssetInput)
pub mod send_api_asset_input {
    /// A builder for [`SendApiAssetInput`](crate::input::SendApiAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) query_string_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) request_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) method: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request body.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The request body.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Adds a key-value pair to `query_string_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_string_parameters`](Self::set_query_string_parameters).
        ///
        /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
        pub fn query_string_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.query_string_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.query_string_parameters = Some(hash_map);
            self
        }
        /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
        pub fn set_query_string_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.query_string_parameters = input;
            self
        }
        /// <p>Asset ID value for the API request.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>Asset ID value for the API request.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>Data set ID value for the API request.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>Data set ID value for the API request.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Adds a key-value pair to `request_headers`.
        ///
        /// To override the contents of this collection use [`set_request_headers`](Self::set_request_headers).
        ///
        /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
        pub fn request_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_headers = Some(hash_map);
            self
        }
        /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
        pub fn set_request_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_headers = input;
            self
        }
        /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
        pub fn method(mut self, input: impl Into<std::string::String>) -> Self {
            self.method = Some(input.into());
            self
        }
        /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
        pub fn set_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.method = input;
            self
        }
        /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Revision ID value for the API request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Revision ID value for the API request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendApiAssetInput`](crate::input::SendApiAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendApiAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendApiAssetInput {
                body: self.body,
                query_string_parameters: self.query_string_parameters,
                asset_id: self.asset_id,
                data_set_id: self.data_set_id,
                request_headers: self.request_headers,
                method: self.method,
                path: self.path,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SendApiAssetInputOperationOutputAlias = crate::operation::SendApiAsset;
#[doc(hidden)]
pub type SendApiAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendApiAssetInput {
    /// Consumes the builder and constructs an Operation<[`SendApiAsset`](crate::operation::SendApiAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendApiAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendApiAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::SendApiAssetInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_31) = &_input.asset_id {
                let formatted_32 = AsRef::<str>::as_ref(inner_31);
                if !formatted_32.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_32;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "asset_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-dataexchange-asset-id", header_value);
                }
            }
            if let Some(inner_33) = &_input.data_set_id {
                let formatted_34 = AsRef::<str>::as_ref(inner_33);
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "data_set_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-dataexchange-data-set-id", header_value);
                }
            }
            if let Some(inner_35) = &_input.method {
                let formatted_36 = AsRef::<str>::as_ref(inner_35);
                if !formatted_36.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_36;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "method",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-dataexchange-http-method", header_value);
                }
            }
            if let Some(inner_37) = &_input.path {
                let formatted_38 = AsRef::<str>::as_ref(inner_37);
                if !formatted_38.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_38;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "path",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-dataexchange-path", header_value);
                }
            }
            if let Some(inner_39) = &_input.revision_id {
                let formatted_40 = AsRef::<str>::as_ref(inner_39);
                if !formatted_40.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_40;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "revision_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-dataexchange-revision-id", header_value);
                }
            }
            if let Some(inner_41) = &_input.request_headers {
                for (k, v) in inner_41 {
                    use std::str::FromStr;
                    let header_name = http::header::HeaderName::from_str(&format!(
                        "{}{}",
                        "x-amzn-dataexchange-header-", &k
                    ))
                    .map_err(|err| {
                        aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_headers",
                            details: format!("`{}` cannot be used as a header name: {}", k, err),
                        }
                    })?;
                    use std::convert::TryFrom;
                    let header_value = AsRef::<str>::as_ref(v);
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_headers",
                            details: format!("`{}` cannot be used as a header value: {}", v, err),
                        })?;
                    builder = builder.header(header_name, header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendApiAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendApiAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "text/plain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_send_api_asset_input(&self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api-fulfill.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendApiAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendApiAsset",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendApiAssetInput`](crate::input::SendApiAssetInput)
    pub fn builder() -> crate::input::send_api_asset_input::Builder {
        crate::input::send_api_asset_input::Builder::default()
    }
}

/// See [`StartJobInput`](crate::input::StartJobInput)
pub mod start_job_input {
    /// A builder for [`StartJobInput`](crate::input::StartJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobInput`](crate::input::StartJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StartJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StartJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartJobInputOperationOutputAlias = crate::operation::StartJob;
#[doc(hidden)]
pub type StartJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartJobInput {
    /// Consumes the builder and constructs an Operation<[`StartJob`](crate::operation::StartJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.job_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_42, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/jobs/{JobId}", JobId = job_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StartJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StartJob",
                    "dataexchange",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartJobInput`](crate::input::StartJobInput)
    pub fn builder() -> crate::input::start_job_input::Builder {
        crate::input::start_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A label that consists of a customer-defined key and an optional value.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A label that consists of a customer-defined key and an optional value.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.resource_arn;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_43, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The key tags.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// The key tags.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.resource_arn;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_44, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_45) = &_input.tag_keys {
                for inner_46 in inner_45 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_46));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAssetInput`](crate::input::UpdateAssetInput)
pub mod update_asset_input {
    /// A builder for [`UpdateAssetInput`](crate::input::UpdateAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetInput`](crate::input::UpdateAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssetInput {
                asset_id: self.asset_id,
                data_set_id: self.data_set_id,
                name: self.name,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssetInputOperationOutputAlias = crate::operation::UpdateAsset;
#[doc(hidden)]
pub type UpdateAssetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAssetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAsset`](crate::operation::UpdateAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAsset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.data_set_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_47, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_48 = &_input.revision_id;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_48, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_49 = &_input.asset_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_49, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets/{AssetId}",
                DataSetId = data_set_id,
                RevisionId = revision_id,
                AssetId = asset_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_asset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAsset",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssetInput`](crate::input::UpdateAssetInput)
    pub fn builder() -> crate::input::update_asset_input::Builder {
        crate::input::update_asset_input::Builder::default()
    }
}

/// See [`UpdateDataSetInput`](crate::input::UpdateDataSetInput)
pub mod update_data_set_input {
    /// A builder for [`UpdateDataSetInput`](crate::input::UpdateDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSetInput`](crate::input::UpdateDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDataSetInput {
                data_set_id: self.data_set_id,
                description: self.description,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDataSetInputOperationOutputAlias = crate::operation::UpdateDataSet;
#[doc(hidden)]
pub type UpdateDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDataSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataSet`](crate::operation::UpdateDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.data_set_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_50, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/data-sets/{DataSetId}", DataSetId = data_set_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_data_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataSet",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDataSetInput`](crate::input::UpdateDataSetInput)
    pub fn builder() -> crate::input::update_data_set_input::Builder {
        crate::input::update_data_set_input::Builder::default()
    }
}

/// See [`UpdateEventActionInput`](crate::input::UpdateEventActionInput)
pub mod update_event_action_input {
    /// A builder for [`UpdateEventActionInput`](crate::input::UpdateEventActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) event_action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_action_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventActionInput`](crate::input::UpdateEventActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEventActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEventActionInput {
                action: self.action,
                event_action_id: self.event_action_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEventActionInputOperationOutputAlias = crate::operation::UpdateEventAction;
#[doc(hidden)]
pub type UpdateEventActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEventActionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEventAction`](crate::operation::UpdateEventAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEventAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEventActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.event_action_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_action_id",
                        details: "cannot be empty or unset",
                    })?;
            let event_action_id = aws_smithy_http::label::fmt_string(input_51, false);
            if event_action_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "event_action_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/event-actions/{EventActionId}",
                EventActionId = event_action_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEventActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEventActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_event_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEventAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEventAction",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEventActionInput`](crate::input::UpdateEventActionInput)
    pub fn builder() -> crate::input::update_event_action_input::Builder {
        crate::input::update_event_action_input::Builder::default()
    }
}

/// See [`UpdateRevisionInput`](crate::input::UpdateRevisionInput)
pub mod update_revision_input {
    /// A builder for [`UpdateRevisionInput`](crate::input::UpdateRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) finalized: std::option::Option<bool>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.finalized = input;
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRevisionInput`](crate::input::UpdateRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRevisionInput {
                comment: self.comment,
                data_set_id: self.data_set_id,
                finalized: self.finalized.unwrap_or_default(),
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRevisionInputOperationOutputAlias = crate::operation::UpdateRevision;
#[doc(hidden)]
pub type UpdateRevisionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRevisionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRevision`](crate::operation::UpdateRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRevision,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.data_set_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_52, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_53 = &_input.revision_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "revision_id",
                        details: "cannot be empty or unset",
                    })?;
            let revision_id = aws_smithy_http::label::fmt_string(input_53, false);
            if revision_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "revision_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
                DataSetId = data_set_id,
                RevisionId = revision_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_revision(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRevision",
            "dataexchange",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRevisionInput`](crate::input::UpdateRevisionInput)
    pub fn builder() -> crate::input::update_revision_input::Builder {
        crate::input::update_revision_input::Builder::default()
    }
}

/// <p>The request body for UpdateRevision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRevisionInput {
    /// <p>An optional comment about the revision.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    pub finalized: bool,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl UpdateRevisionInput {
    /// <p>An optional comment about the revision.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    pub fn finalized(&self) -> bool {
        self.finalized
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRevisionInput");
        formatter.field("comment", &self.comment);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("finalized", &self.finalized);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

/// <p>The request body for UpdateEventAction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventActionInput {
    /// <p>What occurs after a certain event.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The unique identifier for the event action.</p>
    pub event_action_id: std::option::Option<std::string::String>,
}
impl UpdateEventActionInput {
    /// <p>What occurs after a certain event.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The unique identifier for the event action.</p>
    pub fn event_action_id(&self) -> std::option::Option<&str> {
        self.event_action_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateEventActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventActionInput");
        formatter.field("action", &self.action);
        formatter.field("event_action_id", &self.event_action_id);
        formatter.finish()
    }
}

/// <p>The request body for UpdateDataSet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSetInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The description for the data set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the data set.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateDataSetInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The description for the data set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the data set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateDataSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSetInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>The request body for UpdateAsset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetInput {
    /// <p>The unique identifier for an asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl UpdateAssetInput {
    /// <p>The unique identifier for an asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// The key tags.
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// The key tags.
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>The request body for TagResource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// A label that consists of a customer-defined key and an optional value.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// A label that consists of a customer-defined key and an optional value.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobInput {
    /// <p>The unique identifier for a job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl StartJobInput {
    /// <p>The unique identifier for a job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for StartJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p>The request body for SendApiAsset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendApiAssetInput {
    /// <p>The request body.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
    pub query_string_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Asset ID value for the API request.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>Data set ID value for the API request.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
    pub request_headers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
    pub method: std::option::Option<std::string::String>,
    /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Revision ID value for the API request.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl SendApiAssetInput {
    /// <p>The request body.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
    pub fn query_string_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.query_string_parameters.as_ref()
    }
    /// <p>Asset ID value for the API request.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>Data set ID value for the API request.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
    pub fn request_headers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.request_headers.as_ref()
    }
    /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
    pub fn method(&self) -> std::option::Option<&str> {
        self.method.as_deref()
    }
    /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Revision ID value for the API request.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for SendApiAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendApiAssetInput");
        formatter.field("body", &self.body);
        formatter.field("query_string_parameters", &self.query_string_parameters);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("request_headers", &self.request_headers);
        formatter.field("method", &self.method);
        formatter.field("path", &self.path);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRevisionAssetsInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by a single call.</p>
    pub max_results: i32,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ListRevisionAssetsInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The maximum number of results returned by a single call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ListRevisionAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRevisionAssetsInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by a single call.</p>
    pub max_results: i32,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ListJobsInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The maximum number of results returned by a single call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventActionsInput {
    /// <p>The unique identifier for the event source.</p>
    pub event_source_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by a single call.</p>
    pub max_results: i32,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventActionsInput {
    /// <p>The unique identifier for the event source.</p>
    pub fn event_source_id(&self) -> std::option::Option<&str> {
        self.event_source_id.as_deref()
    }
    /// <p>The maximum number of results returned by a single call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventActionsInput");
        formatter.field("event_source_id", &self.event_source_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSetsInput {
    /// <p>The maximum number of results returned by a single call.</p>
    pub max_results: i32,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub origin: std::option::Option<std::string::String>,
}
impl ListDataSetsInput {
    /// <p>The maximum number of results returned by a single call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub fn origin(&self) -> std::option::Option<&str> {
        self.origin.as_deref()
    }
}
impl std::fmt::Debug for ListDataSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSetsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("origin", &self.origin);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSetRevisionsInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by a single call.</p>
    pub max_results: i32,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDataSetRevisionsInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The maximum number of results returned by a single call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDataSetRevisionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSetRevisionsInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRevisionInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetRevisionInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRevisionInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobInput {
    /// <p>The unique identifier for a job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetJobInput {
    /// <p>The unique identifier for a job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventActionInput {
    /// <p>The unique identifier for the event action.</p>
    pub event_action_id: std::option::Option<std::string::String>,
}
impl GetEventActionInput {
    /// <p>The unique identifier for the event action.</p>
    pub fn event_action_id(&self) -> std::option::Option<&str> {
        self.event_action_id.as_deref()
    }
}
impl std::fmt::Debug for GetEventActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventActionInput");
        formatter.field("event_action_id", &self.event_action_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataSetInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
}
impl GetDataSetInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
}
impl std::fmt::Debug for GetDataSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataSetInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetInput {
    /// <p>The unique identifier for an asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetAssetInput {
    /// <p>The unique identifier for an asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRevisionInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl DeleteRevisionInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRevisionInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventActionInput {
    /// <p>The unique identifier for the event action.</p>
    pub event_action_id: std::option::Option<std::string::String>,
}
impl DeleteEventActionInput {
    /// <p>The unique identifier for the event action.</p>
    pub fn event_action_id(&self) -> std::option::Option<&str> {
        self.event_action_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventActionInput");
        formatter.field("event_action_id", &self.event_action_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSetInput {
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
}
impl DeleteDataSetInput {
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSetInput");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetInput {
    /// <p>The unique identifier for an asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl DeleteAssetInput {
    /// <p>The unique identifier for an asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for a revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

/// <p>The request body for CreateRevision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRevisionInput {
    /// <p>An optional comment about the revision.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a data set.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRevisionInput {
    /// <p>An optional comment about the revision.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The unique identifier for a data set.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRevisionInput");
        formatter.field("comment", &self.comment);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The request body for CreateJob.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobInput {
    /// <p>The details for the CreateJob request.</p>
    pub details: std::option::Option<crate::model::RequestDetails>,
    /// <p>The type of job to be created.</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl CreateJobInput {
    /// <p>The details for the CreateJob request.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::RequestDetails> {
        self.details.as_ref()
    }
    /// <p>The type of job to be created.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CreateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobInput");
        formatter.field("details", &self.details);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

/// <p>The request body for CreateEventAction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventActionInput {
    /// <p>What occurs after a certain event.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>What occurs to start an action.</p>
    pub event: std::option::Option<crate::model::Event>,
}
impl CreateEventActionInput {
    /// <p>What occurs after a certain event.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>What occurs to start an action.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
}
impl std::fmt::Debug for CreateEventActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventActionInput");
        formatter.field("action", &self.action);
        formatter.field("event", &self.event);
        formatter.finish()
    }
}

/// <p>The request body for CreateDataSet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSetInput {
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the data set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDataSetInput {
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the data set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDataSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSetInput");
        formatter.field("asset_type", &self.asset_type);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobInput {
    /// <p>The unique identifier for a job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl CancelJobInput {
    /// <p>The unique identifier for a job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for CancelJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
