// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRevisionOutput {
    /// <p>The ARN for the revision.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An optional comment about the revision.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub finalized: bool,
    /// <p>The unique identifier for the revision.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateRevisionOutput {
    /// <p>The ARN for the revision.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An optional comment about the revision.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub fn finalized(&self) -> bool {
        self.finalized
    }
    /// <p>The unique identifier for the revision.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRevisionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("comment", &self.comment);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("finalized", &self.finalized);
        formatter.field("id", &self.id);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`UpdateRevisionOutput`](crate::output::UpdateRevisionOutput)
pub mod update_revision_output {
    /// A builder for [`UpdateRevisionOutput`](crate::output::UpdateRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) finalized: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the revision.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the revision.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.finalized = input;
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRevisionOutput`](crate::output::UpdateRevisionOutput)
        pub fn build(self) -> crate::output::UpdateRevisionOutput {
            crate::output::UpdateRevisionOutput {
                arn: self.arn,
                comment: self.comment,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                finalized: self.finalized.unwrap_or_default(),
                id: self.id,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl UpdateRevisionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRevisionOutput`](crate::output::UpdateRevisionOutput)
    pub fn builder() -> crate::output::update_revision_output::Builder {
        crate::output::update_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventActionOutput {
    /// <p>What occurs after a certain event.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The ARN for the event action.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>What occurs to start an action.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>The unique identifier for the event action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateEventActionOutput {
    /// <p>What occurs after a certain event.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The ARN for the event action.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>What occurs to start an action.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>The unique identifier for the event action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateEventActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventActionOutput");
        formatter.field("action", &self.action);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("event", &self.event);
        formatter.field("id", &self.id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`UpdateEventActionOutput`](crate::output::UpdateEventActionOutput)
pub mod update_event_action_output {
    /// A builder for [`UpdateEventActionOutput`](crate::output::UpdateEventActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The ARN for the event action.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the event action.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventActionOutput`](crate::output::UpdateEventActionOutput)
        pub fn build(self) -> crate::output::UpdateEventActionOutput {
            crate::output::UpdateEventActionOutput {
                action: self.action,
                arn: self.arn,
                created_at: self.created_at,
                event: self.event,
                id: self.id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl UpdateEventActionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEventActionOutput`](crate::output::UpdateEventActionOutput)
    pub fn builder() -> crate::output::update_event_action_output::Builder {
        crate::output::update_event_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSetOutput {
    /// <p>The ARN for the data set.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description for the data set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the data set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub origin: std::option::Option<crate::model::Origin>,
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub origin_details: std::option::Option<crate::model::OriginDetails>,
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateDataSetOutput {
    /// <p>The ARN for the data set.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The description for the data set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the data set.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the data set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub fn origin(&self) -> std::option::Option<&crate::model::Origin> {
        self.origin.as_ref()
    }
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub fn origin_details(&self) -> std::option::Option<&crate::model::OriginDetails> {
        self.origin_details.as_ref()
    }
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("origin", &self.origin);
        formatter.field("origin_details", &self.origin_details);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
pub mod update_data_set_output {
    /// A builder for [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<crate::model::Origin>,
        pub(crate) origin_details: std::option::Option<crate::model::OriginDetails>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the data set.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the data set.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: crate::model::Origin) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::Origin>) -> Self {
            self.origin = input;
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn origin_details(mut self, input: crate::model::OriginDetails) -> Self {
            self.origin_details = Some(input);
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn set_origin_details(
            mut self,
            input: std::option::Option<crate::model::OriginDetails>,
        ) -> Self {
            self.origin_details = input;
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
        pub fn build(self) -> crate::output::UpdateDataSetOutput {
            crate::output::UpdateDataSetOutput {
                arn: self.arn,
                asset_type: self.asset_type,
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                name: self.name,
                origin: self.origin,
                origin_details: self.origin_details,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl UpdateDataSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
    pub fn builder() -> crate::output::update_data_set_output::Builder {
        crate::output::update_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetOutput {
    /// <p>The ARN for the asset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the asset.</p>
    pub asset_details: std::option::Option<crate::model::AssetDetails>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The unique identifier for the data set associated with this asset.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the asset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this asset.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateAssetOutput {
    /// <p>The ARN for the asset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the asset.</p>
    pub fn asset_details(&self) -> std::option::Option<&crate::model::AssetDetails> {
        self.asset_details.as_ref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this asset.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the asset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this asset.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("asset_details", &self.asset_details);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
pub mod update_asset_output {
    /// A builder for [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_details: std::option::Option<crate::model::AssetDetails>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the asset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the asset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Information about the asset.</p>
        pub fn asset_details(mut self, input: crate::model::AssetDetails) -> Self {
            self.asset_details = Some(input);
            self
        }
        /// <p>Information about the asset.</p>
        pub fn set_asset_details(
            mut self,
            input: std::option::Option<crate::model::AssetDetails>,
        ) -> Self {
            self.asset_details = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this asset.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this asset.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this asset.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this asset.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
        pub fn build(self) -> crate::output::UpdateAssetOutput {
            crate::output::UpdateAssetOutput {
                arn: self.arn,
                asset_details: self.asset_details,
                asset_type: self.asset_type,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                id: self.id,
                name: self.name,
                revision_id: self.revision_id,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl UpdateAssetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
    pub fn builder() -> crate::output::update_asset_output::Builder {
        crate::output::update_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobOutput {}
impl std::fmt::Debug for StartJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobOutput");
        formatter.finish()
    }
}
/// See [`StartJobOutput`](crate::output::StartJobOutput)
pub mod start_job_output {
    /// A builder for [`StartJobOutput`](crate::output::StartJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartJobOutput`](crate::output::StartJobOutput)
        pub fn build(self) -> crate::output::StartJobOutput {
            crate::output::StartJobOutput {}
        }
    }
}
impl StartJobOutput {
    /// Creates a new builder-style object to manufacture [`StartJobOutput`](crate::output::StartJobOutput)
    pub fn builder() -> crate::output::start_job_output::Builder {
        crate::output::start_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendApiAssetOutput {
    /// <p>The response body from the underlying API tracked by the API asset.</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>The response headers from the underlying API tracked by the API asset.</p>
    pub response_headers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SendApiAssetOutput {
    /// <p>The response body from the underlying API tracked by the API asset.</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>The response headers from the underlying API tracked by the API asset.</p>
    pub fn response_headers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.response_headers.as_ref()
    }
}
impl std::fmt::Debug for SendApiAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendApiAssetOutput");
        formatter.field("body", &self.body);
        formatter.field("response_headers", &self.response_headers);
        formatter.finish()
    }
}
/// See [`SendApiAssetOutput`](crate::output::SendApiAssetOutput)
pub mod send_api_asset_output {
    /// A builder for [`SendApiAssetOutput`](crate::output::SendApiAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) response_headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The response body from the underlying API tracked by the API asset.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The response body from the underlying API tracked by the API asset.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Adds a key-value pair to `response_headers`.
        ///
        /// To override the contents of this collection use [`set_response_headers`](Self::set_response_headers).
        ///
        /// <p>The response headers from the underlying API tracked by the API asset.</p>
        pub fn response_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.response_headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.response_headers = Some(hash_map);
            self
        }
        /// <p>The response headers from the underlying API tracked by the API asset.</p>
        pub fn set_response_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.response_headers = input;
            self
        }
        /// Consumes the builder and constructs a [`SendApiAssetOutput`](crate::output::SendApiAssetOutput)
        pub fn build(self) -> crate::output::SendApiAssetOutput {
            crate::output::SendApiAssetOutput {
                body: self.body,
                response_headers: self.response_headers,
            }
        }
    }
}
impl SendApiAssetOutput {
    /// Creates a new builder-style object to manufacture [`SendApiAssetOutput`](crate::output::SendApiAssetOutput)
    pub fn builder() -> crate::output::send_api_asset_output::Builder {
        crate::output::send_api_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// A label that consists of a customer-defined key and an optional value.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// A label that consists of a customer-defined key and an optional value.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A label that consists of a customer-defined key and an optional value.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A label that consists of a customer-defined key and an optional value.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRevisionAssetsOutput {
    /// <p>The asset objects listed by the request.</p>
    pub assets: std::option::Option<std::vec::Vec<crate::model::AssetEntry>>,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRevisionAssetsOutput {
    /// <p>The asset objects listed by the request.</p>
    pub fn assets(&self) -> std::option::Option<&[crate::model::AssetEntry]> {
        self.assets.as_deref()
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRevisionAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRevisionAssetsOutput");
        formatter.field("assets", &self.assets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRevisionAssetsOutput`](crate::output::ListRevisionAssetsOutput)
pub mod list_revision_assets_output {
    /// A builder for [`ListRevisionAssetsOutput`](crate::output::ListRevisionAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assets: std::option::Option<std::vec::Vec<crate::model::AssetEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assets`.
        ///
        /// To override the contents of this collection use [`set_assets`](Self::set_assets).
        ///
        /// <p>The asset objects listed by the request.</p>
        pub fn assets(mut self, input: crate::model::AssetEntry) -> Self {
            let mut v = self.assets.unwrap_or_default();
            v.push(input);
            self.assets = Some(v);
            self
        }
        /// <p>The asset objects listed by the request.</p>
        pub fn set_assets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetEntry>>,
        ) -> Self {
            self.assets = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRevisionAssetsOutput`](crate::output::ListRevisionAssetsOutput)
        pub fn build(self) -> crate::output::ListRevisionAssetsOutput {
            crate::output::ListRevisionAssetsOutput {
                assets: self.assets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRevisionAssetsOutput {
    /// Creates a new builder-style object to manufacture [`ListRevisionAssetsOutput`](crate::output::ListRevisionAssetsOutput)
    pub fn builder() -> crate::output::list_revision_assets_output::Builder {
        crate::output::list_revision_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>The jobs listed by the request.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::JobEntry>>,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// <p>The jobs listed by the request.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::JobEntry]> {
        self.jobs.as_deref()
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::JobEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>The jobs listed by the request.</p>
        pub fn jobs(mut self, input: crate::model::JobEntry) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input);
            self.jobs = Some(v);
            self
        }
        /// <p>The jobs listed by the request.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobEntry>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventActionsOutput {
    /// <p>The event action objects listed by the request.</p>
    pub event_actions: std::option::Option<std::vec::Vec<crate::model::EventActionEntry>>,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventActionsOutput {
    /// <p>The event action objects listed by the request.</p>
    pub fn event_actions(&self) -> std::option::Option<&[crate::model::EventActionEntry]> {
        self.event_actions.as_deref()
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventActionsOutput");
        formatter.field("event_actions", &self.event_actions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEventActionsOutput`](crate::output::ListEventActionsOutput)
pub mod list_event_actions_output {
    /// A builder for [`ListEventActionsOutput`](crate::output::ListEventActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_actions:
            std::option::Option<std::vec::Vec<crate::model::EventActionEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_actions`.
        ///
        /// To override the contents of this collection use [`set_event_actions`](Self::set_event_actions).
        ///
        /// <p>The event action objects listed by the request.</p>
        pub fn event_actions(mut self, input: crate::model::EventActionEntry) -> Self {
            let mut v = self.event_actions.unwrap_or_default();
            v.push(input);
            self.event_actions = Some(v);
            self
        }
        /// <p>The event action objects listed by the request.</p>
        pub fn set_event_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventActionEntry>>,
        ) -> Self {
            self.event_actions = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventActionsOutput`](crate::output::ListEventActionsOutput)
        pub fn build(self) -> crate::output::ListEventActionsOutput {
            crate::output::ListEventActionsOutput {
                event_actions: self.event_actions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEventActionsOutput {
    /// Creates a new builder-style object to manufacture [`ListEventActionsOutput`](crate::output::ListEventActionsOutput)
    pub fn builder() -> crate::output::list_event_actions_output::Builder {
        crate::output::list_event_actions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSetsOutput {
    /// <p>The data set objects listed by the request.</p>
    pub data_sets: std::option::Option<std::vec::Vec<crate::model::DataSetEntry>>,
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDataSetsOutput {
    /// <p>The data set objects listed by the request.</p>
    pub fn data_sets(&self) -> std::option::Option<&[crate::model::DataSetEntry]> {
        self.data_sets.as_deref()
    }
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDataSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSetsOutput");
        formatter.field("data_sets", &self.data_sets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
pub mod list_data_sets_output {
    /// A builder for [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_sets: std::option::Option<std::vec::Vec<crate::model::DataSetEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_sets`.
        ///
        /// To override the contents of this collection use [`set_data_sets`](Self::set_data_sets).
        ///
        /// <p>The data set objects listed by the request.</p>
        pub fn data_sets(mut self, input: crate::model::DataSetEntry) -> Self {
            let mut v = self.data_sets.unwrap_or_default();
            v.push(input);
            self.data_sets = Some(v);
            self
        }
        /// <p>The data set objects listed by the request.</p>
        pub fn set_data_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSetEntry>>,
        ) -> Self {
            self.data_sets = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
        pub fn build(self) -> crate::output::ListDataSetsOutput {
            crate::output::ListDataSetsOutput {
                data_sets: self.data_sets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDataSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
    pub fn builder() -> crate::output::list_data_sets_output::Builder {
        crate::output::list_data_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSetRevisionsOutput {
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The asset objects listed by the request.</p>
    pub revisions: std::option::Option<std::vec::Vec<crate::model::RevisionEntry>>,
}
impl ListDataSetRevisionsOutput {
    /// <p>The token value retrieved from a previous call to access the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The asset objects listed by the request.</p>
    pub fn revisions(&self) -> std::option::Option<&[crate::model::RevisionEntry]> {
        self.revisions.as_deref()
    }
}
impl std::fmt::Debug for ListDataSetRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSetRevisionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("revisions", &self.revisions);
        formatter.finish()
    }
}
/// See [`ListDataSetRevisionsOutput`](crate::output::ListDataSetRevisionsOutput)
pub mod list_data_set_revisions_output {
    /// A builder for [`ListDataSetRevisionsOutput`](crate::output::ListDataSetRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) revisions: std::option::Option<std::vec::Vec<crate::model::RevisionEntry>>,
    }
    impl Builder {
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `revisions`.
        ///
        /// To override the contents of this collection use [`set_revisions`](Self::set_revisions).
        ///
        /// <p>The asset objects listed by the request.</p>
        pub fn revisions(mut self, input: crate::model::RevisionEntry) -> Self {
            let mut v = self.revisions.unwrap_or_default();
            v.push(input);
            self.revisions = Some(v);
            self
        }
        /// <p>The asset objects listed by the request.</p>
        pub fn set_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionEntry>>,
        ) -> Self {
            self.revisions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSetRevisionsOutput`](crate::output::ListDataSetRevisionsOutput)
        pub fn build(self) -> crate::output::ListDataSetRevisionsOutput {
            crate::output::ListDataSetRevisionsOutput {
                next_token: self.next_token,
                revisions: self.revisions,
            }
        }
    }
}
impl ListDataSetRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDataSetRevisionsOutput`](crate::output::ListDataSetRevisionsOutput)
    pub fn builder() -> crate::output::list_data_set_revisions_output::Builder {
        crate::output::list_data_set_revisions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRevisionOutput {
    /// <p>The ARN for the revision.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An optional comment about the revision.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub finalized: bool,
    /// <p>The unique identifier for the revision.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The tags for the revision.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetRevisionOutput {
    /// <p>The ARN for the revision.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An optional comment about the revision.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub fn finalized(&self) -> bool {
        self.finalized
    }
    /// <p>The unique identifier for the revision.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The tags for the revision.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for GetRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRevisionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("comment", &self.comment);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("finalized", &self.finalized);
        formatter.field("id", &self.id);
        formatter.field("source_id", &self.source_id);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`GetRevisionOutput`](crate::output::GetRevisionOutput)
pub mod get_revision_output {
    /// A builder for [`GetRevisionOutput`](crate::output::GetRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) finalized: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the revision.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the revision.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.finalized = input;
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the revision.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the revision.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRevisionOutput`](crate::output::GetRevisionOutput)
        pub fn build(self) -> crate::output::GetRevisionOutput {
            crate::output::GetRevisionOutput {
                arn: self.arn,
                comment: self.comment,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                finalized: self.finalized.unwrap_or_default(),
                id: self.id,
                source_id: self.source_id,
                tags: self.tags,
                updated_at: self.updated_at,
            }
        }
    }
}
impl GetRevisionOutput {
    /// Creates a new builder-style object to manufacture [`GetRevisionOutput`](crate::output::GetRevisionOutput)
    pub fn builder() -> crate::output::get_revision_output::Builder {
        crate::output::get_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobOutput {
    /// <p>The ARN for the job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the job was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Details about the job.</p>
    pub details: std::option::Option<crate::model::ResponseDetails>,
    /// <p>The errors associated with jobs.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::JobError>>,
    /// <p>The unique identifier for the job.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The state of the job.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The job type.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetJobOutput {
    /// <p>The ARN for the job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the job was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Details about the job.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::ResponseDetails> {
        self.details.as_ref()
    }
    /// <p>The errors associated with jobs.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::JobError]> {
        self.errors.as_deref()
    }
    /// <p>The unique identifier for the job.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The state of the job.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The job type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for GetJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("details", &self.details);
        formatter.field("errors", &self.errors);
        formatter.field("id", &self.id);
        formatter.field("state", &self.state);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`GetJobOutput`](crate::output::GetJobOutput)
pub mod get_job_output {
    /// A builder for [`GetJobOutput`](crate::output::GetJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) details: std::option::Option<crate::model::ResponseDetails>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::JobError>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the job was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the job was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Details about the job.</p>
        pub fn details(mut self, input: crate::model::ResponseDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>Details about the job.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::ResponseDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The errors associated with jobs.</p>
        pub fn errors(mut self, input: crate::model::JobError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>The errors associated with jobs.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The state of the job.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the job.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The job type.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The job type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutput`](crate::output::GetJobOutput)
        pub fn build(self) -> crate::output::GetJobOutput {
            crate::output::GetJobOutput {
                arn: self.arn,
                created_at: self.created_at,
                details: self.details,
                errors: self.errors,
                id: self.id,
                state: self.state,
                r#type: self.r#type,
                updated_at: self.updated_at,
            }
        }
    }
}
impl GetJobOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutput`](crate::output::GetJobOutput)
    pub fn builder() -> crate::output::get_job_output::Builder {
        crate::output::get_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventActionOutput {
    /// <p>What occurs after a certain event.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The ARN for the event action.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>What occurs to start an action.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>The unique identifier for the event action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetEventActionOutput {
    /// <p>What occurs after a certain event.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The ARN for the event action.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>What occurs to start an action.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>The unique identifier for the event action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for GetEventActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventActionOutput");
        formatter.field("action", &self.action);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("event", &self.event);
        formatter.field("id", &self.id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`GetEventActionOutput`](crate::output::GetEventActionOutput)
pub mod get_event_action_output {
    /// A builder for [`GetEventActionOutput`](crate::output::GetEventActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The ARN for the event action.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the event action.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventActionOutput`](crate::output::GetEventActionOutput)
        pub fn build(self) -> crate::output::GetEventActionOutput {
            crate::output::GetEventActionOutput {
                action: self.action,
                arn: self.arn,
                created_at: self.created_at,
                event: self.event,
                id: self.id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl GetEventActionOutput {
    /// Creates a new builder-style object to manufacture [`GetEventActionOutput`](crate::output::GetEventActionOutput)
    pub fn builder() -> crate::output::get_event_action_output::Builder {
        crate::output::get_event_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataSetOutput {
    /// <p>The ARN for the data set.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description for the data set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the data set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub origin: std::option::Option<crate::model::Origin>,
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub origin_details: std::option::Option<crate::model::OriginDetails>,
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The tags for the data set.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetDataSetOutput {
    /// <p>The ARN for the data set.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The description for the data set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the data set.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the data set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub fn origin(&self) -> std::option::Option<&crate::model::Origin> {
        self.origin.as_ref()
    }
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub fn origin_details(&self) -> std::option::Option<&crate::model::OriginDetails> {
        self.origin_details.as_ref()
    }
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The tags for the data set.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for GetDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataSetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("origin", &self.origin);
        formatter.field("origin_details", &self.origin_details);
        formatter.field("source_id", &self.source_id);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`GetDataSetOutput`](crate::output::GetDataSetOutput)
pub mod get_data_set_output {
    /// A builder for [`GetDataSetOutput`](crate::output::GetDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<crate::model::Origin>,
        pub(crate) origin_details: std::option::Option<crate::model::OriginDetails>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the data set.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the data set.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: crate::model::Origin) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::Origin>) -> Self {
            self.origin = input;
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn origin_details(mut self, input: crate::model::OriginDetails) -> Self {
            self.origin_details = Some(input);
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn set_origin_details(
            mut self,
            input: std::option::Option<crate::model::OriginDetails>,
        ) -> Self {
            self.origin_details = input;
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the data set.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the data set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataSetOutput`](crate::output::GetDataSetOutput)
        pub fn build(self) -> crate::output::GetDataSetOutput {
            crate::output::GetDataSetOutput {
                arn: self.arn,
                asset_type: self.asset_type,
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                name: self.name,
                origin: self.origin,
                origin_details: self.origin_details,
                source_id: self.source_id,
                tags: self.tags,
                updated_at: self.updated_at,
            }
        }
    }
}
impl GetDataSetOutput {
    /// Creates a new builder-style object to manufacture [`GetDataSetOutput`](crate::output::GetDataSetOutput)
    pub fn builder() -> crate::output::get_data_set_output::Builder {
        crate::output::get_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetOutput {
    /// <p>The ARN for the asset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the asset.</p>
    pub asset_details: std::option::Option<crate::model::AssetDetails>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The unique identifier for the data set associated with this asset.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the asset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this asset.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetAssetOutput {
    /// <p>The ARN for the asset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the asset.</p>
    pub fn asset_details(&self) -> std::option::Option<&crate::model::AssetDetails> {
        self.asset_details.as_ref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this asset.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the asset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this asset.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for GetAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("asset_details", &self.asset_details);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`GetAssetOutput`](crate::output::GetAssetOutput)
pub mod get_asset_output {
    /// A builder for [`GetAssetOutput`](crate::output::GetAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_details: std::option::Option<crate::model::AssetDetails>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the asset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the asset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Information about the asset.</p>
        pub fn asset_details(mut self, input: crate::model::AssetDetails) -> Self {
            self.asset_details = Some(input);
            self
        }
        /// <p>Information about the asset.</p>
        pub fn set_asset_details(
            mut self,
            input: std::option::Option<crate::model::AssetDetails>,
        ) -> Self {
            self.asset_details = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this asset.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this asset.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this asset.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this asset.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetOutput`](crate::output::GetAssetOutput)
        pub fn build(self) -> crate::output::GetAssetOutput {
            crate::output::GetAssetOutput {
                arn: self.arn,
                asset_details: self.asset_details,
                asset_type: self.asset_type,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                id: self.id,
                name: self.name,
                revision_id: self.revision_id,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl GetAssetOutput {
    /// Creates a new builder-style object to manufacture [`GetAssetOutput`](crate::output::GetAssetOutput)
    pub fn builder() -> crate::output::get_asset_output::Builder {
        crate::output::get_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRevisionOutput {}
impl std::fmt::Debug for DeleteRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRevisionOutput");
        formatter.finish()
    }
}
/// See [`DeleteRevisionOutput`](crate::output::DeleteRevisionOutput)
pub mod delete_revision_output {
    /// A builder for [`DeleteRevisionOutput`](crate::output::DeleteRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRevisionOutput`](crate::output::DeleteRevisionOutput)
        pub fn build(self) -> crate::output::DeleteRevisionOutput {
            crate::output::DeleteRevisionOutput {}
        }
    }
}
impl DeleteRevisionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRevisionOutput`](crate::output::DeleteRevisionOutput)
    pub fn builder() -> crate::output::delete_revision_output::Builder {
        crate::output::delete_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventActionOutput {}
impl std::fmt::Debug for DeleteEventActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventActionOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventActionOutput`](crate::output::DeleteEventActionOutput)
pub mod delete_event_action_output {
    /// A builder for [`DeleteEventActionOutput`](crate::output::DeleteEventActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventActionOutput`](crate::output::DeleteEventActionOutput)
        pub fn build(self) -> crate::output::DeleteEventActionOutput {
            crate::output::DeleteEventActionOutput {}
        }
    }
}
impl DeleteEventActionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventActionOutput`](crate::output::DeleteEventActionOutput)
    pub fn builder() -> crate::output::delete_event_action_output::Builder {
        crate::output::delete_event_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSetOutput {}
impl std::fmt::Debug for DeleteDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSetOutput");
        formatter.finish()
    }
}
/// See [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
pub mod delete_data_set_output {
    /// A builder for [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
        pub fn build(self) -> crate::output::DeleteDataSetOutput {
            crate::output::DeleteDataSetOutput {}
        }
    }
}
impl DeleteDataSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
    pub fn builder() -> crate::output::delete_data_set_output::Builder {
        crate::output::delete_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetOutput {}
impl std::fmt::Debug for DeleteAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
pub mod delete_asset_output {
    /// A builder for [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
        pub fn build(self) -> crate::output::DeleteAssetOutput {
            crate::output::DeleteAssetOutput {}
        }
    }
}
impl DeleteAssetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
    pub fn builder() -> crate::output::delete_asset_output::Builder {
        crate::output::delete_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRevisionOutput {
    /// <p>The ARN for the revision.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An optional comment about the revision.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub finalized: bool,
    /// <p>The unique identifier for the revision.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The tags for the revision.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateRevisionOutput {
    /// <p>The ARN for the revision.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An optional comment about the revision.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
    /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub fn finalized(&self) -> bool {
        self.finalized
    }
    /// <p>The unique identifier for the revision.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The tags for the revision.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for CreateRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRevisionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("comment", &self.comment);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("finalized", &self.finalized);
        formatter.field("id", &self.id);
        formatter.field("source_id", &self.source_id);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`CreateRevisionOutput`](crate::output::CreateRevisionOutput)
pub mod create_revision_output {
    /// A builder for [`CreateRevisionOutput`](crate::output::CreateRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) finalized: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the revision.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the revision.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        /// <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.finalized = input;
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the revision.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the revision.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRevisionOutput`](crate::output::CreateRevisionOutput)
        pub fn build(self) -> crate::output::CreateRevisionOutput {
            crate::output::CreateRevisionOutput {
                arn: self.arn,
                comment: self.comment,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                finalized: self.finalized.unwrap_or_default(),
                id: self.id,
                source_id: self.source_id,
                tags: self.tags,
                updated_at: self.updated_at,
            }
        }
    }
}
impl CreateRevisionOutput {
    /// Creates a new builder-style object to manufacture [`CreateRevisionOutput`](crate::output::CreateRevisionOutput)
    pub fn builder() -> crate::output::create_revision_output::Builder {
        crate::output::create_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// <p>The ARN for the job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the job was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Details about the job.</p>
    pub details: std::option::Option<crate::model::ResponseDetails>,
    /// <p>The errors associated with jobs.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::JobError>>,
    /// <p>The unique identifier for the job.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The state of the job.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The job type.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateJobOutput {
    /// <p>The ARN for the job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the job was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Details about the job.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::ResponseDetails> {
        self.details.as_ref()
    }
    /// <p>The errors associated with jobs.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::JobError]> {
        self.errors.as_deref()
    }
    /// <p>The unique identifier for the job.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The state of the job.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The job type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("details", &self.details);
        formatter.field("errors", &self.errors);
        formatter.field("id", &self.id);
        formatter.field("state", &self.state);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::output::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::output::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) details: std::option::Option<crate::model::ResponseDetails>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::JobError>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the job was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the job was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Details about the job.</p>
        pub fn details(mut self, input: crate::model::ResponseDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>Details about the job.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::ResponseDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The errors associated with jobs.</p>
        pub fn errors(mut self, input: crate::model::JobError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>The errors associated with jobs.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The state of the job.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the job.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The job type.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The job type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::output::CreateJobOutput)
        pub fn build(self) -> crate::output::CreateJobOutput {
            crate::output::CreateJobOutput {
                arn: self.arn,
                created_at: self.created_at,
                details: self.details,
                errors: self.errors,
                id: self.id,
                state: self.state,
                r#type: self.r#type,
                updated_at: self.updated_at,
            }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::output::CreateJobOutput)
    pub fn builder() -> crate::output::create_job_output::Builder {
        crate::output::create_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventActionOutput {
    /// <p>What occurs after a certain event.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The ARN for the event action.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>What occurs to start an action.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>The unique identifier for the event action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateEventActionOutput {
    /// <p>What occurs after a certain event.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The ARN for the event action.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>What occurs to start an action.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>The unique identifier for the event action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for CreateEventActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventActionOutput");
        formatter.field("action", &self.action);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("event", &self.event);
        formatter.field("id", &self.id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`CreateEventActionOutput`](crate::output::CreateEventActionOutput)
pub mod create_event_action_output {
    /// A builder for [`CreateEventActionOutput`](crate::output::CreateEventActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The ARN for the event action.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the event action.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventActionOutput`](crate::output::CreateEventActionOutput)
        pub fn build(self) -> crate::output::CreateEventActionOutput {
            crate::output::CreateEventActionOutput {
                action: self.action,
                arn: self.arn,
                created_at: self.created_at,
                event: self.event,
                id: self.id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl CreateEventActionOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventActionOutput`](crate::output::CreateEventActionOutput)
    pub fn builder() -> crate::output::create_event_action_output::Builder {
        crate::output::create_event_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSetOutput {
    /// <p>The ARN for the data set.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description for the data set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the data set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub origin: std::option::Option<crate::model::Origin>,
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub origin_details: std::option::Option<crate::model::OriginDetails>,
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The tags for the data set.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateDataSetOutput {
    /// <p>The ARN for the data set.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The description for the data set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the data set.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the data set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub fn origin(&self) -> std::option::Option<&crate::model::Origin> {
        self.origin.as_ref()
    }
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub fn origin_details(&self) -> std::option::Option<&crate::model::OriginDetails> {
        self.origin_details.as_ref()
    }
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The tags for the data set.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for CreateDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("origin", &self.origin);
        formatter.field("origin_details", &self.origin_details);
        formatter.field("source_id", &self.source_id);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
pub mod create_data_set_output {
    /// A builder for [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<crate::model::Origin>,
        pub(crate) origin_details: std::option::Option<crate::model::OriginDetails>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN for the data set.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the data set.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: crate::model::Origin) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::Origin>) -> Self {
            self.origin = input;
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn origin_details(mut self, input: crate::model::OriginDetails) -> Self {
            self.origin_details = Some(input);
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn set_origin_details(
            mut self,
            input: std::option::Option<crate::model::OriginDetails>,
        ) -> Self {
            self.origin_details = input;
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the data set.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the data set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
        pub fn build(self) -> crate::output::CreateDataSetOutput {
            crate::output::CreateDataSetOutput {
                arn: self.arn,
                asset_type: self.asset_type,
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                name: self.name,
                origin: self.origin,
                origin_details: self.origin_details,
                source_id: self.source_id,
                tags: self.tags,
                updated_at: self.updated_at,
            }
        }
    }
}
impl CreateDataSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
    pub fn builder() -> crate::output::create_data_set_output::Builder {
        crate::output::create_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobOutput {}
impl std::fmt::Debug for CancelJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobOutput");
        formatter.finish()
    }
}
/// See [`CancelJobOutput`](crate::output::CancelJobOutput)
pub mod cancel_job_output {
    /// A builder for [`CancelJobOutput`](crate::output::CancelJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelJobOutput`](crate::output::CancelJobOutput)
        pub fn build(self) -> crate::output::CancelJobOutput {
            crate::output::CancelJobOutput {}
        }
    }
}
impl CancelJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelJobOutput`](crate::output::CancelJobOutput)
    pub fn builder() -> crate::output::cancel_job_output::Builder {
        crate::output::cancel_job_output::Builder::default()
    }
}
