// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Data Exchange
///
/// Client for invoking operations on AWS Data Exchange. Each operation on AWS Data Exchange is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_dataexchange::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_dataexchange::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_dataexchange::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelJob` operation.
    ///
    /// See [`CancelJob`](crate::client::fluent_builders::CancelJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_job(&self) -> fluent_builders::CancelJob<C, M, R> {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSet` operation.
    ///
    /// See [`CreateDataSet`](crate::client::fluent_builders::CreateDataSet) for more information about the
    /// operation and its arguments.
    pub fn create_data_set(&self) -> fluent_builders::CreateDataSet<C, M, R> {
        fluent_builders::CreateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventAction` operation.
    ///
    /// See [`CreateEventAction`](crate::client::fluent_builders::CreateEventAction) for more information about the
    /// operation and its arguments.
    pub fn create_event_action(&self) -> fluent_builders::CreateEventAction<C, M, R> {
        fluent_builders::CreateEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJob` operation.
    ///
    /// See [`CreateJob`](crate::client::fluent_builders::CreateJob) for more information about the
    /// operation and its arguments.
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRevision` operation.
    ///
    /// See [`CreateRevision`](crate::client::fluent_builders::CreateRevision) for more information about the
    /// operation and its arguments.
    pub fn create_revision(&self) -> fluent_builders::CreateRevision<C, M, R> {
        fluent_builders::CreateRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAsset` operation.
    ///
    /// See [`DeleteAsset`](crate::client::fluent_builders::DeleteAsset) for more information about the
    /// operation and its arguments.
    pub fn delete_asset(&self) -> fluent_builders::DeleteAsset<C, M, R> {
        fluent_builders::DeleteAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataSet` operation.
    ///
    /// See [`DeleteDataSet`](crate::client::fluent_builders::DeleteDataSet) for more information about the
    /// operation and its arguments.
    pub fn delete_data_set(&self) -> fluent_builders::DeleteDataSet<C, M, R> {
        fluent_builders::DeleteDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventAction` operation.
    ///
    /// See [`DeleteEventAction`](crate::client::fluent_builders::DeleteEventAction) for more information about the
    /// operation and its arguments.
    pub fn delete_event_action(&self) -> fluent_builders::DeleteEventAction<C, M, R> {
        fluent_builders::DeleteEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRevision` operation.
    ///
    /// See [`DeleteRevision`](crate::client::fluent_builders::DeleteRevision) for more information about the
    /// operation and its arguments.
    pub fn delete_revision(&self) -> fluent_builders::DeleteRevision<C, M, R> {
        fluent_builders::DeleteRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAsset` operation.
    ///
    /// See [`GetAsset`](crate::client::fluent_builders::GetAsset) for more information about the
    /// operation and its arguments.
    pub fn get_asset(&self) -> fluent_builders::GetAsset<C, M, R> {
        fluent_builders::GetAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataSet` operation.
    ///
    /// See [`GetDataSet`](crate::client::fluent_builders::GetDataSet) for more information about the
    /// operation and its arguments.
    pub fn get_data_set(&self) -> fluent_builders::GetDataSet<C, M, R> {
        fluent_builders::GetDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventAction` operation.
    ///
    /// See [`GetEventAction`](crate::client::fluent_builders::GetEventAction) for more information about the
    /// operation and its arguments.
    pub fn get_event_action(&self) -> fluent_builders::GetEventAction<C, M, R> {
        fluent_builders::GetEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJob` operation.
    ///
    /// See [`GetJob`](crate::client::fluent_builders::GetJob) for more information about the
    /// operation and its arguments.
    pub fn get_job(&self) -> fluent_builders::GetJob<C, M, R> {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRevision` operation.
    ///
    /// See [`GetRevision`](crate::client::fluent_builders::GetRevision) for more information about the
    /// operation and its arguments.
    pub fn get_revision(&self) -> fluent_builders::GetRevision<C, M, R> {
        fluent_builders::GetRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSetRevisions` operation.
    ///
    /// See [`ListDataSetRevisions`](crate::client::fluent_builders::ListDataSetRevisions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDataSetRevisions::into_paginator).
    pub fn list_data_set_revisions(&self) -> fluent_builders::ListDataSetRevisions<C, M, R> {
        fluent_builders::ListDataSetRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSets` operation.
    ///
    /// See [`ListDataSets`](crate::client::fluent_builders::ListDataSets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDataSets::into_paginator).
    pub fn list_data_sets(&self) -> fluent_builders::ListDataSets<C, M, R> {
        fluent_builders::ListDataSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventActions` operation.
    ///
    /// See [`ListEventActions`](crate::client::fluent_builders::ListEventActions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListEventActions::into_paginator).
    pub fn list_event_actions(&self) -> fluent_builders::ListEventActions<C, M, R> {
        fluent_builders::ListEventActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRevisionAssets` operation.
    ///
    /// See [`ListRevisionAssets`](crate::client::fluent_builders::ListRevisionAssets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRevisionAssets::into_paginator).
    pub fn list_revision_assets(&self) -> fluent_builders::ListRevisionAssets<C, M, R> {
        fluent_builders::ListRevisionAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendApiAsset` operation.
    ///
    /// See [`SendApiAsset`](crate::client::fluent_builders::SendApiAsset) for more information about the
    /// operation and its arguments.
    pub fn send_api_asset(&self) -> fluent_builders::SendApiAsset<C, M, R> {
        fluent_builders::SendApiAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartJob` operation.
    ///
    /// See [`StartJob`](crate::client::fluent_builders::StartJob) for more information about the
    /// operation and its arguments.
    pub fn start_job(&self) -> fluent_builders::StartJob<C, M, R> {
        fluent_builders::StartJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAsset` operation.
    ///
    /// See [`UpdateAsset`](crate::client::fluent_builders::UpdateAsset) for more information about the
    /// operation and its arguments.
    pub fn update_asset(&self) -> fluent_builders::UpdateAsset<C, M, R> {
        fluent_builders::UpdateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSet` operation.
    ///
    /// See [`UpdateDataSet`](crate::client::fluent_builders::UpdateDataSet) for more information about the
    /// operation and its arguments.
    pub fn update_data_set(&self) -> fluent_builders::UpdateDataSet<C, M, R> {
        fluent_builders::UpdateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEventAction` operation.
    ///
    /// See [`UpdateEventAction`](crate::client::fluent_builders::UpdateEventAction) for more information about the
    /// operation and its arguments.
    pub fn update_event_action(&self) -> fluent_builders::UpdateEventAction<C, M, R> {
        fluent_builders::UpdateEventAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRevision` operation.
    ///
    /// See [`UpdateRevision`](crate::client::fluent_builders::UpdateRevision) for more information about the
    /// operation and its arguments.
    pub fn update_revision(&self) -> fluent_builders::UpdateRevision<C, M, R> {
        fluent_builders::UpdateRevision::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl<C, M, R> CancelJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobInputOperationOutputAlias,
                crate::output::CancelJobOutput,
                crate::error::CancelJobError,
                crate::input::CancelJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSet`.
    ///
    /// <p>This operation creates a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_set_input::Builder,
    }
    impl<C, M, R> CreateDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSetInputOperationOutputAlias,
                crate::output::CreateDataSetOutput,
                crate::error::CreateDataSetError,
                crate::input::CreateDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.inner = self.inner.asset_type(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.inner = self.inner.set_asset_type(input);
            self
        }
        /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the data set. This value can be up to 16,348 characters long.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventAction`.
    ///
    /// <p>This operation creates an event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_action_input::Builder,
    }
    impl<C, M, R> CreateEventAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventActionInputOperationOutputAlias,
                crate::output::CreateEventActionOutput,
                crate::error::CreateEventActionError,
                crate::input::CreateEventActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.inner = self.inner.event(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>This operation creates a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details for the CreateJob request.</p>
        pub fn details(mut self, input: crate::model::RequestDetails) -> Self {
            self.inner = self.inner.details(input);
            self
        }
        /// <p>The details for the CreateJob request.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::RequestDetails>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
        /// <p>The type of job to be created.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of job to be created.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRevision`.
    ///
    /// <p>This operation creates a revision for a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_revision_input::Builder,
    }
    impl<C, M, R> CreateRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRevisionInputOperationOutputAlias,
                crate::output::CreateRevisionOutput,
                crate::error::CreateRevisionError,
                crate::input::CreateRevisionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAsset`.
    ///
    /// <p>This operation deletes an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_asset_input::Builder,
    }
    impl<C, M, R> DeleteAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssetInputOperationOutputAlias,
                crate::output::DeleteAssetOutput,
                crate::error::DeleteAssetError,
                crate::input::DeleteAssetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSet`.
    ///
    /// <p>This operation deletes a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_set_input::Builder,
    }
    impl<C, M, R> DeleteDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSetInputOperationOutputAlias,
                crate::output::DeleteDataSetOutput,
                crate::error::DeleteDataSetError,
                crate::input::DeleteDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventAction`.
    ///
    /// <p>This operation deletes the event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_action_input::Builder,
    }
    impl<C, M, R> DeleteEventAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventActionInputOperationOutputAlias,
                crate::output::DeleteEventActionOutput,
                crate::error::DeleteEventActionError,
                crate::input::DeleteEventActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_action_id(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRevision`.
    ///
    /// <p>This operation deletes a revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_revision_input::Builder,
    }
    impl<C, M, R> DeleteRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRevisionInputOperationOutputAlias,
                crate::output::DeleteRevisionOutput,
                crate::error::DeleteRevisionError,
                crate::input::DeleteRevisionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAsset`.
    ///
    /// <p>This operation returns information about an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_asset_input::Builder,
    }
    impl<C, M, R> GetAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssetInputOperationOutputAlias,
                crate::output::GetAssetOutput,
                crate::error::GetAssetError,
                crate::input::GetAssetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataSet`.
    ///
    /// <p>This operation returns information about a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_set_input::Builder,
    }
    impl<C, M, R> GetDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataSetInputOperationOutputAlias,
                crate::output::GetDataSetOutput,
                crate::error::GetDataSetError,
                crate::input::GetDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventAction`.
    ///
    /// <p>This operation retrieves information about an event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_action_input::Builder,
    }
    impl<C, M, R> GetEventAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventActionInputOperationOutputAlias,
                crate::output::GetEventActionOutput,
                crate::error::GetEventActionError,
                crate::input::GetEventActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_action_id(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p>This operation returns information about a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_input::Builder,
    }
    impl<C, M, R> GetJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobInputOperationOutputAlias,
                crate::output::GetJobOutput,
                crate::error::GetJobError,
                crate::input::GetJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRevision`.
    ///
    /// <p>This operation returns information about a revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_revision_input::Builder,
    }
    impl<C, M, R> GetRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRevisionInputOperationOutputAlias,
                crate::output::GetRevisionOutput,
                crate::error::GetRevisionError,
                crate::input::GetRevisionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSetRevisions`.
    ///
    /// <p>This operation lists a data set's revisions sorted by CreatedAt in descending order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSetRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_set_revisions_input::Builder,
    }
    impl<C, M, R> ListDataSetRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSetRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSetRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSetRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSetRevisionsInputOperationOutputAlias,
                crate::output::ListDataSetRevisionsOutput,
                crate::error::ListDataSetRevisionsError,
                crate::input::ListDataSetRevisionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataSetRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataSetRevisionsPaginator<C, M, R> {
            crate::paginator::ListDataSetRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSets`.
    ///
    /// <p>This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sets_input::Builder,
    }
    impl<C, M, R> ListDataSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSetsInputOperationOutputAlias,
                crate::output::ListDataSetsOutput,
                crate::error::ListDataSetsError,
                crate::input::ListDataSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataSetsPaginator<C, M, R> {
            crate::paginator::ListDataSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin(input.into());
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventActions`.
    ///
    /// <p>This operation lists your event actions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventActions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_actions_input::Builder,
    }
    impl<C, M, R> ListEventActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventActionsInputOperationOutputAlias,
                crate::output::ListEventActionsOutput,
                crate::error::ListEventActionsError,
                crate::input::ListEventActionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventActionsPaginator<C, M, R> {
            crate::paginator::ListEventActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for the event source.</p>
        pub fn event_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_id(input.into());
            self
        }
        /// <p>The unique identifier for the event source.</p>
        pub fn set_event_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>This operation lists your jobs sorted by CreatedAt in descending order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsPaginator<C, M, R> {
            crate::paginator::ListJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRevisionAssets`.
    ///
    /// <p>This operation lists a revision's assets sorted alphabetically in descending order.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRevisionAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_revision_assets_input::Builder,
    }
    impl<C, M, R> ListRevisionAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRevisionAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRevisionAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRevisionAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRevisionAssetsInputOperationOutputAlias,
                crate::output::ListRevisionAssetsOutput,
                crate::error::ListRevisionAssetsError,
                crate::input::ListRevisionAssetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRevisionAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRevisionAssetsPaginator<C, M, R> {
            crate::paginator::ListRevisionAssetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results returned by a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>This operation lists the tags on the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendApiAsset`.
    ///
    /// <p>This operation invokes an API Gateway API asset. The request is proxied to the provider’s API Gateway API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendApiAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_api_asset_input::Builder,
    }
    impl<C, M, R> SendApiAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendApiAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendApiAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::SendApiAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendApiAssetInputOperationOutputAlias,
                crate::output::SendApiAssetOutput,
                crate::error::SendApiAssetError,
                crate::input::SendApiAssetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request body.</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.body(input.into());
            self
        }
        /// <p>The request body.</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// Adds a key-value pair to `QueryStringParameters`.
        ///
        /// To override the contents of this collection use [`set_query_string_parameters`](Self::set_query_string_parameters).
        ///
        /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
        pub fn query_string_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.query_string_parameters(k.into(), v.into());
            self
        }
        /// <p>Attach query string parameters to the end of the URI (for example, /v1/examplePath?exampleParam=exampleValue).</p>
        pub fn set_query_string_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_query_string_parameters(input);
            self
        }
        /// <p>Asset ID value for the API request.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>Asset ID value for the API request.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>Data set ID value for the API request.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>Data set ID value for the API request.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// Adds a key-value pair to `RequestHeaders`.
        ///
        /// To override the contents of this collection use [`set_request_headers`](Self::set_request_headers).
        ///
        /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
        pub fn request_headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_headers(k.into(), v.into());
            self
        }
        /// <p>Any header value prefixed with x-amzn-dataexchange-header- will have that stripped before sending the Asset API request. Use this when you want to override a header that AWS Data Exchange uses. Alternatively, you can use the header without a prefix to the HTTP request.</p>
        pub fn set_request_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_headers(input);
            self
        }
        /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
        pub fn method(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.method(input.into());
            self
        }
        /// <p>HTTP method value for the API request. Alternatively, you can use the appropriate verb in your request.</p>
        pub fn set_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_method(input);
            self
        }
        /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(input.into());
            self
        }
        /// <p>URI path value for the API request. Alternatively, you can set the URI path directly by invoking /v1/{pathValue}</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>Revision ID value for the API request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Revision ID value for the API request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJob`.
    ///
    /// <p>This operation starts a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_job_input::Builder,
    }
    impl<C, M, R> StartJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartJobInputOperationOutputAlias,
                crate::output::StartJobOutput,
                crate::error::StartJobError,
                crate::input::StartJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for a job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>This operation tags a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A label that consists of a customer-defined key and an optional value.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A label that consists of a customer-defined key and an optional value.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>This operation removes one or more tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The key tags.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// The key tags.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAsset`.
    ///
    /// <p>This operation updates an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_asset_input::Builder,
    }
    impl<C, M, R> UpdateAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssetInputOperationOutputAlias,
                crate::output::UpdateAssetOutput,
                crate::error::UpdateAssetError,
                crate::input::UpdateAssetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The unique identifier for an asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key. When importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name is used as the asset name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSet`.
    ///
    /// <p>This operation updates a data set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_set_input::Builder,
    }
    impl<C, M, R> UpdateDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSetInputOperationOutputAlias,
                crate::output::UpdateDataSetOutput,
                crate::error::UpdateDataSetError,
                crate::input::UpdateDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventAction`.
    ///
    /// <p>This operation updates the event action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_event_action_input::Builder,
    }
    impl<C, M, R> UpdateEventAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEventAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventActionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEventActionInputOperationOutputAlias,
                crate::output::UpdateEventActionOutput,
                crate::error::UpdateEventActionError,
                crate::input::UpdateEventActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn event_action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_action_id(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_event_action_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_action_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRevision`.
    ///
    /// <p>This operation updates a revision.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_revision_input::Builder,
    }
    impl<C, M, R> UpdateRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRevisionInputOperationOutputAlias,
                crate::output::UpdateRevisionOutput,
                crate::error::UpdateRevisionError,
                crate::input::UpdateRevisionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The unique identifier for a data set.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.inner = self.inner.finalized(input);
            self
        }
        /// <p>Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_finalized(input);
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The unique identifier for a revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
