// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobError {
    /// Kind of error that occurred.
    pub kind: CancelJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobErrorKind {
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobError {
    fn code(&self) -> Option<&str> {
        CancelJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobError {
    /// Creates a new `CancelJobError`.
    pub fn new(kind: CancelJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CancelJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobErrorKind::ConflictException(_inner) => Some(_inner),
            CancelJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelJobErrorKind::ValidationException(_inner) => Some(_inner),
            CancelJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSetError {
    /// Kind of error that occurred.
    pub kind: CreateDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSetErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request has exceeded the quotas imposed by the service.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSetError {
    fn code(&self) -> Option<&str> {
        CreateDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSetError {
    /// Creates a new `CreateDataSetError`.
    pub fn new(kind: CreateDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDataSetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventActionError {
    /// Kind of error that occurred.
    pub kind: CreateEventActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventActionErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request has exceeded the quotas imposed by the service.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEventActionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEventActionErrorKind::ServiceLimitExceededException(_inner) => _inner.fmt(f),
            CreateEventActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEventActionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEventActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventActionError {
    fn code(&self) -> Option<&str> {
        CreateEventActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventActionError {
    /// Creates a new `CreateEventActionError`.
    pub fn new(kind: CreateEventActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventActionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventActionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventActionErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventActionErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventActionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventActionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventActionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEventActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEventActionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEventActionErrorKind::ServiceLimitExceededException(_inner) => Some(_inner),
            CreateEventActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEventActionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEventActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobError {
    /// Kind of error that occurred.
    pub kind: CreateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobError {
    fn code(&self) -> Option<&str> {
        CreateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobError {
    /// Creates a new `CreateJobError`.
    pub fn new(kind: CreateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRevisionError {
    /// Kind of error that occurred.
    pub kind: CreateRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRevisionErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRevisionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRevisionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRevisionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRevisionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRevisionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRevisionError {
    fn code(&self) -> Option<&str> {
        CreateRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRevisionError {
    /// Creates a new `CreateRevisionError`.
    pub fn new(kind: CreateRevisionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRevisionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRevisionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRevisionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRevisionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRevisionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRevisionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRevisionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRevisionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateRevisionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateRevisionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateRevisionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRevisionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRevisionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRevisionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRevisionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRevisionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssetError {
    /// Kind of error that occurred.
    pub kind: DeleteAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssetErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssetError {
    fn code(&self) -> Option<&str> {
        DeleteAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssetError {
    /// Creates a new `DeleteAssetError`.
    pub fn new(kind: DeleteAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteAssetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAssetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataSetError {
    /// Kind of error that occurred.
    pub kind: DeleteDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataSetErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataSetError {
    fn code(&self) -> Option<&str> {
        DeleteDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataSetError {
    /// Creates a new `DeleteDataSetError`.
    pub fn new(kind: DeleteDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventActionError {
    /// Kind of error that occurred.
    pub kind: DeleteEventActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventActionErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventActionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEventActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEventActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEventActionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEventActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventActionError {
    fn code(&self) -> Option<&str> {
        DeleteEventActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventActionError {
    /// Creates a new `DeleteEventActionError`.
    pub fn new(kind: DeleteEventActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventActionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventActionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventActionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventActionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventActionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventActionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEventActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventActionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEventActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEventActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEventActionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEventActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRevisionError {
    /// Kind of error that occurred.
    pub kind: DeleteRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRevisionErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRevisionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRevisionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRevisionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRevisionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRevisionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRevisionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRevisionError {
    fn code(&self) -> Option<&str> {
        DeleteRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRevisionError {
    /// Creates a new `DeleteRevisionError`.
    pub fn new(kind: DeleteRevisionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRevisionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRevisionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRevisionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRevisionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRevisionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteRevisionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRevisionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRevisionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRevisionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRevisionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteRevisionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteRevisionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteRevisionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRevisionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRevisionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRevisionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRevisionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRevisionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRevisionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssetError {
    /// Kind of error that occurred.
    pub kind: GetAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssetErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAssetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssetError {
    fn code(&self) -> Option<&str> {
        GetAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssetError {
    /// Creates a new `GetAssetError`.
    pub fn new(kind: GetAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetAssetErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAssetErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetAssetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetAssetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetAssetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAssetErrorKind::ValidationException(_inner) => Some(_inner),
            GetAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataSetError {
    /// Kind of error that occurred.
    pub kind: GetDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataSetErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDataSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataSetError {
    fn code(&self) -> Option<&str> {
        GetDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataSetError {
    /// Creates a new `GetDataSetError`.
    pub fn new(kind: GetDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetDataSetErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDataSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetDataSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDataSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataSetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDataSetErrorKind::ValidationException(_inner) => Some(_inner),
            GetDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventActionError {
    /// Kind of error that occurred.
    pub kind: GetEventActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventActionErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventActionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEventActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEventActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEventActionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEventActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventActionError {
    fn code(&self) -> Option<&str> {
        GetEventActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventActionError {
    /// Creates a new `GetEventActionError`.
    pub fn new(kind: GetEventActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventActionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventActionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventActionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEventActionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetEventActionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEventActionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEventActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventActionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEventActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEventActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEventActionErrorKind::ValidationException(_inner) => Some(_inner),
            GetEventActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobError {
    /// Kind of error that occurred.
    pub kind: GetJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobError {
    fn code(&self) -> Option<&str> {
        GetJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobError {
    /// Creates a new `GetJobError`.
    pub fn new(kind: GetJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobErrorKind::InternalServerException(_inner) => Some(_inner),
            GetJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetJobErrorKind::ValidationException(_inner) => Some(_inner),
            GetJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRevisionError {
    /// Kind of error that occurred.
    pub kind: GetRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRevisionErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRevisionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRevisionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRevisionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRevisionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRevisionError {
    fn code(&self) -> Option<&str> {
        GetRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRevisionError {
    /// Creates a new `GetRevisionError`.
    pub fn new(kind: GetRevisionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRevisionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRevisionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetRevisionErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetRevisionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRevisionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRevisionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetRevisionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetRevisionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetRevisionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRevisionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRevisionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRevisionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRevisionErrorKind::ValidationException(_inner) => Some(_inner),
            GetRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSetRevisions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSetRevisionsError {
    /// Kind of error that occurred.
    pub kind: ListDataSetRevisionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSetRevisions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSetRevisionsErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSetRevisionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSetRevisionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDataSetRevisionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDataSetRevisionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataSetRevisionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDataSetRevisionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSetRevisionsError {
    fn code(&self) -> Option<&str> {
        ListDataSetRevisionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSetRevisionsError {
    /// Creates a new `ListDataSetRevisionsError`.
    pub fn new(kind: ListDataSetRevisionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSetRevisionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSetRevisionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSetRevisionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSetRevisionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataSetRevisionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetRevisionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetRevisionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetRevisionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetRevisionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetRevisionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetRevisionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetRevisionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDataSetRevisionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSetRevisionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDataSetRevisionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDataSetRevisionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataSetRevisionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDataSetRevisionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSetsError {
    /// Kind of error that occurred.
    pub kind: ListDataSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSetsErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSetsError {
    fn code(&self) -> Option<&str> {
        ListDataSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSetsError {
    /// Creates a new `ListDataSetsError`.
    pub fn new(kind: ListDataSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDataSetsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDataSetsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDataSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDataSetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDataSetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataSetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDataSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventActionsError {
    /// Kind of error that occurred.
    pub kind: ListEventActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventActionsErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventActionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEventActionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEventActionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEventActionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEventActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventActionsError {
    fn code(&self) -> Option<&str> {
        ListEventActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventActionsError {
    /// Creates a new `ListEventActionsError`.
    pub fn new(kind: ListEventActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventActionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventActionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventActionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventActionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventActionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventActionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventActionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventActionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEventActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventActionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEventActionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEventActionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEventActionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEventActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRevisionAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRevisionAssetsError {
    /// Kind of error that occurred.
    pub kind: ListRevisionAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRevisionAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRevisionAssetsErrorKind {
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRevisionAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRevisionAssetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRevisionAssetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRevisionAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRevisionAssetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRevisionAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRevisionAssetsError {
    fn code(&self) -> Option<&str> {
        ListRevisionAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRevisionAssetsError {
    /// Creates a new `ListRevisionAssetsError`.
    pub fn new(kind: ListRevisionAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRevisionAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRevisionAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRevisionAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRevisionAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRevisionAssetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRevisionAssetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRevisionAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRevisionAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRevisionAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRevisionAssetsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRevisionAssetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRevisionAssetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRevisionAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRevisionAssetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRevisionAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRevisionAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRevisionAssetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRevisionAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartJobError {
    /// Kind of error that occurred.
    pub kind: StartJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartJobErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartJobError {
    fn code(&self) -> Option<&str> {
        StartJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartJobError {
    /// Creates a new `StartJobError`.
    pub fn new(kind: StartJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartJobErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartJobErrorKind::ConflictException(_inner) => Some(_inner),
            StartJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssetError {
    /// Kind of error that occurred.
    pub kind: UpdateAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssetErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssetError {
    fn code(&self) -> Option<&str> {
        UpdateAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssetError {
    /// Creates a new `UpdateAssetError`.
    pub fn new(kind: UpdateAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateAssetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateAssetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateAssetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAssetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSetError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSetErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSetError {
    fn code(&self) -> Option<&str> {
        UpdateDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSetError {
    /// Creates a new `UpdateDataSetError`.
    pub fn new(kind: UpdateDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventActionError {
    /// Kind of error that occurred.
    pub kind: UpdateEventActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventActionErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventActionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEventActionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEventActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEventActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEventActionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEventActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventActionError {
    fn code(&self) -> Option<&str> {
        UpdateEventActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEventActionError {
    /// Creates a new `UpdateEventActionError`.
    pub fn new(kind: UpdateEventActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEventActionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventActionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventActionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventActionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventActionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventActionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventActionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventActionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEventActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventActionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEventActionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEventActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEventActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEventActionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEventActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRevisionError {
    /// Kind of error that occurred.
    pub kind: UpdateRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRevisionErrorKind {
    /// <p>Access to the resource is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    ConflictException(crate::error::ConflictException),
    /// An exception occurred with the service.
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource couldn't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRevisionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRevisionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRevisionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRevisionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRevisionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRevisionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRevisionError {
    fn code(&self) -> Option<&str> {
        UpdateRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRevisionError {
    /// Creates a new `UpdateRevisionError`.
    pub fn new(kind: UpdateRevisionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRevisionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRevisionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRevisionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRevisionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateRevisionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateRevisionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRevisionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRevisionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRevisionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRevisionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateRevisionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateRevisionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateRevisionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRevisionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRevisionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRevisionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRevisionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRevisionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRevisionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>The message that informs you about what was invalid about the request.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The message that informs you about what the exception was.</p>
    pub exception_cause: std::option::Option<crate::model::ExceptionCause>,
}
impl ValidationException {
    /// <p>The message that informs you about what the exception was.</p>
    pub fn exception_cause(&self) -> std::option::Option<&crate::model::ExceptionCause> {
        self.exception_cause.as_ref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("exception_cause", &self.exception_cause);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) exception_cause: std::option::Option<crate::model::ExceptionCause>,
    }
    impl Builder {
        /// <p>The message that informs you about what was invalid about the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that informs you about what was invalid about the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The message that informs you about what the exception was.</p>
        pub fn exception_cause(mut self, input: crate::model::ExceptionCause) -> Self {
            self.exception_cause = Some(input);
            self
        }
        /// <p>The message that informs you about what the exception was.</p>
        pub fn set_exception_cause(
            mut self,
            input: std::option::Option<crate::model::ExceptionCause>,
        ) -> Self {
            self.exception_cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                exception_cause: self.exception_cause,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The limit on the number of requests per second was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>The limit on the number of requests per second was exceeded.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The limit on the number of requests per second was exceeded.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The limit on the number of requests per second was exceeded.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource couldn't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The resource couldn't be found.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the resource that couldn't be found.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource that couldn't be found.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ResourceNotFoundException {
    /// <p>The unique identifier for the resource that couldn't be found.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource that couldn't be found.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        /// <p>The resource couldn't be found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The resource couldn't be found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the resource that couldn't be found.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the resource that couldn't be found.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource that couldn't be found.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource that couldn't be found.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// An exception occurred with the service.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// The message identifying the service exception that occurred.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The message identifying the service exception that occurred.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The message identifying the service exception that occurred.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the resource with the conflict.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource with the conflict.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ConflictException {
    /// <p>The unique identifier for the resource with the conflict.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource with the conflict.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The request couldn't be completed because it conflicted with the current state of the resource.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The unique identifier for the resource with the conflict.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the resource with the conflict.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource with the conflict.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource with the conflict.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Access to the resource is denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>Access to the resource is denied.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Access to the resource is denied.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Access to the resource is denied.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request has exceeded the quotas imposed by the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLimitExceededException {
    /// <p>The name of the quota that was exceeded.</p>
    pub limit_name: std::option::Option<crate::model::LimitName>,
    /// <p>The maximum value for the service-specific limit.</p>
    pub limit_value: f64,
    /// <p>The request has exceeded the quotas imposed by the service.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ServiceLimitExceededException {
    /// <p>The name of the quota that was exceeded.</p>
    pub fn limit_name(&self) -> std::option::Option<&crate::model::LimitName> {
        self.limit_name.as_ref()
    }
    /// <p>The maximum value for the service-specific limit.</p>
    pub fn limit_value(&self) -> f64 {
        self.limit_value
    }
}
impl std::fmt::Debug for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLimitExceededException");
        formatter.field("limit_name", &self.limit_name);
        formatter.field("limit_value", &self.limit_value);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLimitExceededException {}
/// See [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
pub mod service_limit_exceeded_exception {
    /// A builder for [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit_name: std::option::Option<crate::model::LimitName>,
        pub(crate) limit_value: std::option::Option<f64>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the quota that was exceeded.</p>
        pub fn limit_name(mut self, input: crate::model::LimitName) -> Self {
            self.limit_name = Some(input);
            self
        }
        /// <p>The name of the quota that was exceeded.</p>
        pub fn set_limit_name(
            mut self,
            input: std::option::Option<crate::model::LimitName>,
        ) -> Self {
            self.limit_name = input;
            self
        }
        /// <p>The maximum value for the service-specific limit.</p>
        pub fn limit_value(mut self, input: f64) -> Self {
            self.limit_value = Some(input);
            self
        }
        /// <p>The maximum value for the service-specific limit.</p>
        pub fn set_limit_value(mut self, input: std::option::Option<f64>) -> Self {
            self.limit_value = input;
            self
        }
        /// <p>The request has exceeded the quotas imposed by the service.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The request has exceeded the quotas imposed by the service.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
        pub fn build(self) -> crate::error::ServiceLimitExceededException {
            crate::error::ServiceLimitExceededException {
                limit_name: self.limit_name,
                limit_value: self.limit_value.unwrap_or_default(),
                message: self.message,
            }
        }
    }
}
impl ServiceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    pub fn builder() -> crate::error::service_limit_exceeded_exception::Builder {
        crate::error::service_limit_exceeded_exception::Builder::default()
    }
}
