// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExceptionCause {
    #[allow(missing_docs)] // documentation missing in model
    InsufficientS3BucketPolicy,
    #[allow(missing_docs)] // documentation missing in model
    S3AccessDenied,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExceptionCause {
    fn from(s: &str) -> Self {
        match s {
            "InsufficientS3BucketPolicy" => ExceptionCause::InsufficientS3BucketPolicy,
            "S3AccessDenied" => ExceptionCause::S3AccessDenied,
            other => ExceptionCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExceptionCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExceptionCause::from(s))
    }
}
impl ExceptionCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExceptionCause::InsufficientS3BucketPolicy => "InsufficientS3BucketPolicy",
            ExceptionCause::S3AccessDenied => "S3AccessDenied",
            ExceptionCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InsufficientS3BucketPolicy", "S3AccessDenied"]
    }
}
impl AsRef<str> for ExceptionCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Asset,
    #[allow(missing_docs)] // documentation missing in model
    DataSet,
    #[allow(missing_docs)] // documentation missing in model
    EventAction,
    #[allow(missing_docs)] // documentation missing in model
    Job,
    #[allow(missing_docs)] // documentation missing in model
    Revision,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "ASSET" => ResourceType::Asset,
            "DATA_SET" => ResourceType::DataSet,
            "EVENT_ACTION" => ResourceType::EventAction,
            "JOB" => ResourceType::Job,
            "REVISION" => ResourceType::Revision,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Asset => "ASSET",
            ResourceType::DataSet => "DATA_SET",
            ResourceType::EventAction => "EVENT_ACTION",
            ResourceType::Job => "JOB",
            ResourceType::Revision => "REVISION",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSET", "DATA_SET", "EVENT_ACTION", "JOB", "REVISION"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>What occurs to start an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>What occurs to start the revision publish action.</p>
    pub revision_published: std::option::Option<crate::model::RevisionPublished>,
}
impl Event {
    /// <p>What occurs to start the revision publish action.</p>
    pub fn revision_published(&self) -> std::option::Option<&crate::model::RevisionPublished> {
        self.revision_published.as_ref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("revision_published", &self.revision_published);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_published: std::option::Option<crate::model::RevisionPublished>,
    }
    impl Builder {
        /// <p>What occurs to start the revision publish action.</p>
        pub fn revision_published(mut self, input: crate::model::RevisionPublished) -> Self {
            self.revision_published = Some(input);
            self
        }
        /// <p>What occurs to start the revision publish action.</p>
        pub fn set_revision_published(
            mut self,
            input: std::option::Option<crate::model::RevisionPublished>,
        ) -> Self {
            self.revision_published = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                revision_published: self.revision_published,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p>Information about the published revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevisionPublished {
    /// <p>The data set ID of the published revision.</p>
    pub data_set_id: std::option::Option<std::string::String>,
}
impl RevisionPublished {
    /// <p>The data set ID of the published revision.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
}
impl std::fmt::Debug for RevisionPublished {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevisionPublished");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.finish()
    }
}
/// See [`RevisionPublished`](crate::model::RevisionPublished)
pub mod revision_published {
    /// A builder for [`RevisionPublished`](crate::model::RevisionPublished)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The data set ID of the published revision.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The data set ID of the published revision.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RevisionPublished`](crate::model::RevisionPublished)
        pub fn build(self) -> crate::model::RevisionPublished {
            crate::model::RevisionPublished {
                data_set_id: self.data_set_id,
            }
        }
    }
}
impl RevisionPublished {
    /// Creates a new builder-style object to manufacture [`RevisionPublished`](crate::model::RevisionPublished)
    pub fn builder() -> crate::model::revision_published::Builder {
        crate::model::revision_published::Builder::default()
    }
}

/// <p>What occurs after a certain event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>Details for the export revision to Amazon S3 action.</p>
    pub export_revision_to_s3:
        std::option::Option<crate::model::AutoExportRevisionToS3RequestDetails>,
}
impl Action {
    /// <p>Details for the export revision to Amazon S3 action.</p>
    pub fn export_revision_to_s3(
        &self,
    ) -> std::option::Option<&crate::model::AutoExportRevisionToS3RequestDetails> {
        self.export_revision_to_s3.as_ref()
    }
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("export_revision_to_s3", &self.export_revision_to_s3);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_revision_to_s3:
            std::option::Option<crate::model::AutoExportRevisionToS3RequestDetails>,
    }
    impl Builder {
        /// <p>Details for the export revision to Amazon S3 action.</p>
        pub fn export_revision_to_s3(
            mut self,
            input: crate::model::AutoExportRevisionToS3RequestDetails,
        ) -> Self {
            self.export_revision_to_s3 = Some(input);
            self
        }
        /// <p>Details for the export revision to Amazon S3 action.</p>
        pub fn set_export_revision_to_s3(
            mut self,
            input: std::option::Option<crate::model::AutoExportRevisionToS3RequestDetails>,
        ) -> Self {
            self.export_revision_to_s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                export_revision_to_s3: self.export_revision_to_s3,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Details of the operation to be performed by the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoExportRevisionToS3RequestDetails {
    /// <p>Encryption configuration for the auto export job.</p>
    pub encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
    /// <p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>
    pub revision_destination: std::option::Option<crate::model::AutoExportRevisionDestinationEntry>,
}
impl AutoExportRevisionToS3RequestDetails {
    /// <p>Encryption configuration for the auto export job.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::ExportServerSideEncryption> {
        self.encryption.as_ref()
    }
    /// <p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>
    pub fn revision_destination(
        &self,
    ) -> std::option::Option<&crate::model::AutoExportRevisionDestinationEntry> {
        self.revision_destination.as_ref()
    }
}
impl std::fmt::Debug for AutoExportRevisionToS3RequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoExportRevisionToS3RequestDetails");
        formatter.field("encryption", &self.encryption);
        formatter.field("revision_destination", &self.revision_destination);
        formatter.finish()
    }
}
/// See [`AutoExportRevisionToS3RequestDetails`](crate::model::AutoExportRevisionToS3RequestDetails)
pub mod auto_export_revision_to_s3_request_details {
    /// A builder for [`AutoExportRevisionToS3RequestDetails`](crate::model::AutoExportRevisionToS3RequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
        pub(crate) revision_destination:
            std::option::Option<crate::model::AutoExportRevisionDestinationEntry>,
    }
    impl Builder {
        /// <p>Encryption configuration for the auto export job.</p>
        pub fn encryption(mut self, input: crate::model::ExportServerSideEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Encryption configuration for the auto export job.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::ExportServerSideEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>
        pub fn revision_destination(
            mut self,
            input: crate::model::AutoExportRevisionDestinationEntry,
        ) -> Self {
            self.revision_destination = Some(input);
            self
        }
        /// <p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>
        pub fn set_revision_destination(
            mut self,
            input: std::option::Option<crate::model::AutoExportRevisionDestinationEntry>,
        ) -> Self {
            self.revision_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoExportRevisionToS3RequestDetails`](crate::model::AutoExportRevisionToS3RequestDetails)
        pub fn build(self) -> crate::model::AutoExportRevisionToS3RequestDetails {
            crate::model::AutoExportRevisionToS3RequestDetails {
                encryption: self.encryption,
                revision_destination: self.revision_destination,
            }
        }
    }
}
impl AutoExportRevisionToS3RequestDetails {
    /// Creates a new builder-style object to manufacture [`AutoExportRevisionToS3RequestDetails`](crate::model::AutoExportRevisionToS3RequestDetails)
    pub fn builder() -> crate::model::auto_export_revision_to_s3_request_details::Builder {
        crate::model::auto_export_revision_to_s3_request_details::Builder::default()
    }
}

/// <p>A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoExportRevisionDestinationEntry {
    /// <p>The S3 bucket that is the destination for the event action.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
    pub key_pattern: std::option::Option<std::string::String>,
}
impl AutoExportRevisionDestinationEntry {
    /// <p>The S3 bucket that is the destination for the event action.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
    pub fn key_pattern(&self) -> std::option::Option<&str> {
        self.key_pattern.as_deref()
    }
}
impl std::fmt::Debug for AutoExportRevisionDestinationEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoExportRevisionDestinationEntry");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_pattern", &self.key_pattern);
        formatter.finish()
    }
}
/// See [`AutoExportRevisionDestinationEntry`](crate::model::AutoExportRevisionDestinationEntry)
pub mod auto_export_revision_destination_entry {
    /// A builder for [`AutoExportRevisionDestinationEntry`](crate::model::AutoExportRevisionDestinationEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_pattern: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket that is the destination for the event action.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket that is the destination for the event action.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
        pub fn key_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pattern = Some(input.into());
            self
        }
        /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
        pub fn set_key_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoExportRevisionDestinationEntry`](crate::model::AutoExportRevisionDestinationEntry)
        pub fn build(self) -> crate::model::AutoExportRevisionDestinationEntry {
            crate::model::AutoExportRevisionDestinationEntry {
                bucket: self.bucket,
                key_pattern: self.key_pattern,
            }
        }
    }
}
impl AutoExportRevisionDestinationEntry {
    /// Creates a new builder-style object to manufacture [`AutoExportRevisionDestinationEntry`](crate::model::AutoExportRevisionDestinationEntry)
    pub fn builder() -> crate::model::auto_export_revision_destination_entry::Builder {
        crate::model::auto_export_revision_destination_entry::Builder::default()
    }
}

/// <p>Encryption configuration of the export job. Includes the encryption type in addition to the AWS KMS key. The KMS key is only necessary if you chose the KMS encryption. type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportServerSideEncryption {
    /// <p>The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The type of server side encryption used for encrypting the objects in Amazon S3.</p>
    pub r#type: std::option::Option<crate::model::ServerSideEncryptionTypes>,
}
impl ExportServerSideEncryption {
    /// <p>The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The type of server side encryption used for encrypting the objects in Amazon S3.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ServerSideEncryptionTypes> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ExportServerSideEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportServerSideEncryption");
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ExportServerSideEncryption`](crate::model::ExportServerSideEncryption)
pub mod export_server_side_encryption {
    /// A builder for [`ExportServerSideEncryption`](crate::model::ExportServerSideEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ServerSideEncryptionTypes>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS KMS key you want to use to encrypt the Amazon S3 objects. This parameter is required if you choose aws:kms as an encryption type.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The type of server side encryption used for encrypting the objects in Amazon S3.</p>
        pub fn r#type(mut self, input: crate::model::ServerSideEncryptionTypes) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of server side encryption used for encrypting the objects in Amazon S3.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionTypes>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportServerSideEncryption`](crate::model::ExportServerSideEncryption)
        pub fn build(self) -> crate::model::ExportServerSideEncryption {
            crate::model::ExportServerSideEncryption {
                kms_key_arn: self.kms_key_arn,
                r#type: self.r#type,
            }
        }
    }
}
impl ExportServerSideEncryption {
    /// Creates a new builder-style object to manufacture [`ExportServerSideEncryption`](crate::model::ExportServerSideEncryption)
    pub fn builder() -> crate::model::export_server_side_encryption::Builder {
        crate::model::export_server_side_encryption::Builder::default()
    }
}

/// <p>The types of encryption supported in export jobs to Amazon S3.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerSideEncryptionTypes {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    AwsKms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerSideEncryptionTypes {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => ServerSideEncryptionTypes::Aes256,
            "aws:kms" => ServerSideEncryptionTypes::AwsKms,
            other => ServerSideEncryptionTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerSideEncryptionTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerSideEncryptionTypes::from(s))
    }
}
impl ServerSideEncryptionTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerSideEncryptionTypes::Aes256 => "AES256",
            ServerSideEncryptionTypes::AwsKms => "aws:kms",
            ServerSideEncryptionTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "aws:kms"]
    }
}
impl AsRef<str> for ServerSideEncryptionTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the origin of the data set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginDetails {
    /// <p>The product ID of the origin of the data set.</p>
    pub product_id: std::option::Option<std::string::String>,
}
impl OriginDetails {
    /// <p>The product ID of the origin of the data set.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
}
impl std::fmt::Debug for OriginDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginDetails");
        formatter.field("product_id", &self.product_id);
        formatter.finish()
    }
}
/// See [`OriginDetails`](crate::model::OriginDetails)
pub mod origin_details {
    /// A builder for [`OriginDetails`](crate::model::OriginDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The product ID of the origin of the data set.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The product ID of the origin of the data set.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginDetails`](crate::model::OriginDetails)
        pub fn build(self) -> crate::model::OriginDetails {
            crate::model::OriginDetails {
                product_id: self.product_id,
            }
        }
    }
}
impl OriginDetails {
    /// Creates a new builder-style object to manufacture [`OriginDetails`](crate::model::OriginDetails)
    pub fn builder() -> crate::model::origin_details::Builder {
        crate::model::origin_details::Builder::default()
    }
}

/// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers). When an owned data set is published in a product, AWS Data Exchange creates a copy of the data set. Subscribers can access that copy of the data set as an entitled data set.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Origin {
    #[allow(missing_docs)] // documentation missing in model
    Entitled,
    #[allow(missing_docs)] // documentation missing in model
    Owned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Origin {
    fn from(s: &str) -> Self {
        match s {
            "ENTITLED" => Origin::Entitled,
            "OWNED" => Origin::Owned,
            other => Origin::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Origin {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Origin::from(s))
    }
}
impl Origin {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Origin::Entitled => "ENTITLED",
            Origin::Owned => "OWNED",
            Origin::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENTITLED", "OWNED"]
    }
}
impl AsRef<str> for Origin {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The type of asset that is added to a data set.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssetType {
    #[allow(missing_docs)] // documentation missing in model
    RedshiftDataShare,
    #[allow(missing_docs)] // documentation missing in model
    S3Snapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssetType {
    fn from(s: &str) -> Self {
        match s {
            "REDSHIFT_DATA_SHARE" => AssetType::RedshiftDataShare,
            "S3_SNAPSHOT" => AssetType::S3Snapshot,
            other => AssetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssetType::from(s))
    }
}
impl AssetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssetType::RedshiftDataShare => "REDSHIFT_DATA_SHARE",
            AssetType::S3Snapshot => "S3_SNAPSHOT",
            AssetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REDSHIFT_DATA_SHARE", "S3_SNAPSHOT"]
    }
}
impl AsRef<str> for AssetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetDetails {
    /// <p>The S3 object that is the asset.</p>
    pub s3_snapshot_asset: std::option::Option<crate::model::S3SnapshotAsset>,
    /// <p>The Amazon Redshift datashare that is the asset.</p>
    pub redshift_data_share_asset: std::option::Option<crate::model::RedshiftDataShareAsset>,
}
impl AssetDetails {
    /// <p>The S3 object that is the asset.</p>
    pub fn s3_snapshot_asset(&self) -> std::option::Option<&crate::model::S3SnapshotAsset> {
        self.s3_snapshot_asset.as_ref()
    }
    /// <p>The Amazon Redshift datashare that is the asset.</p>
    pub fn redshift_data_share_asset(
        &self,
    ) -> std::option::Option<&crate::model::RedshiftDataShareAsset> {
        self.redshift_data_share_asset.as_ref()
    }
}
impl std::fmt::Debug for AssetDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetDetails");
        formatter.field("s3_snapshot_asset", &self.s3_snapshot_asset);
        formatter.field("redshift_data_share_asset", &self.redshift_data_share_asset);
        formatter.finish()
    }
}
/// See [`AssetDetails`](crate::model::AssetDetails)
pub mod asset_details {
    /// A builder for [`AssetDetails`](crate::model::AssetDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_snapshot_asset: std::option::Option<crate::model::S3SnapshotAsset>,
        pub(crate) redshift_data_share_asset:
            std::option::Option<crate::model::RedshiftDataShareAsset>,
    }
    impl Builder {
        /// <p>The S3 object that is the asset.</p>
        pub fn s3_snapshot_asset(mut self, input: crate::model::S3SnapshotAsset) -> Self {
            self.s3_snapshot_asset = Some(input);
            self
        }
        /// <p>The S3 object that is the asset.</p>
        pub fn set_s3_snapshot_asset(
            mut self,
            input: std::option::Option<crate::model::S3SnapshotAsset>,
        ) -> Self {
            self.s3_snapshot_asset = input;
            self
        }
        /// <p>The Amazon Redshift datashare that is the asset.</p>
        pub fn redshift_data_share_asset(
            mut self,
            input: crate::model::RedshiftDataShareAsset,
        ) -> Self {
            self.redshift_data_share_asset = Some(input);
            self
        }
        /// <p>The Amazon Redshift datashare that is the asset.</p>
        pub fn set_redshift_data_share_asset(
            mut self,
            input: std::option::Option<crate::model::RedshiftDataShareAsset>,
        ) -> Self {
            self.redshift_data_share_asset = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetDetails`](crate::model::AssetDetails)
        pub fn build(self) -> crate::model::AssetDetails {
            crate::model::AssetDetails {
                s3_snapshot_asset: self.s3_snapshot_asset,
                redshift_data_share_asset: self.redshift_data_share_asset,
            }
        }
    }
}
impl AssetDetails {
    /// Creates a new builder-style object to manufacture [`AssetDetails`](crate::model::AssetDetails)
    pub fn builder() -> crate::model::asset_details::Builder {
        crate::model::asset_details::Builder::default()
    }
}

/// The Amazon Redshift datashare asset.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDataShareAsset {
    /// The Amazon Resource Name (ARN) of the datashare asset.
    pub arn: std::option::Option<std::string::String>,
}
impl RedshiftDataShareAsset {
    /// The Amazon Resource Name (ARN) of the datashare asset.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for RedshiftDataShareAsset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDataShareAsset");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`RedshiftDataShareAsset`](crate::model::RedshiftDataShareAsset)
pub mod redshift_data_share_asset {
    /// A builder for [`RedshiftDataShareAsset`](crate::model::RedshiftDataShareAsset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the datashare asset.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the datashare asset.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDataShareAsset`](crate::model::RedshiftDataShareAsset)
        pub fn build(self) -> crate::model::RedshiftDataShareAsset {
            crate::model::RedshiftDataShareAsset { arn: self.arn }
        }
    }
}
impl RedshiftDataShareAsset {
    /// Creates a new builder-style object to manufacture [`RedshiftDataShareAsset`](crate::model::RedshiftDataShareAsset)
    pub fn builder() -> crate::model::redshift_data_share_asset::Builder {
        crate::model::redshift_data_share_asset::Builder::default()
    }
}

/// <p>The S3 object that is the asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SnapshotAsset {
    /// <p>The size of the S3 object that is the object.</p>
    pub size: f64,
}
impl S3SnapshotAsset {
    /// <p>The size of the S3 object that is the object.</p>
    pub fn size(&self) -> f64 {
        self.size
    }
}
impl std::fmt::Debug for S3SnapshotAsset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SnapshotAsset");
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`S3SnapshotAsset`](crate::model::S3SnapshotAsset)
pub mod s3_snapshot_asset {
    /// A builder for [`S3SnapshotAsset`](crate::model::S3SnapshotAsset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The size of the S3 object that is the object.</p>
        pub fn size(mut self, input: f64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the S3 object that is the object.</p>
        pub fn set_size(mut self, input: std::option::Option<f64>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SnapshotAsset`](crate::model::S3SnapshotAsset)
        pub fn build(self) -> crate::model::S3SnapshotAsset {
            crate::model::S3SnapshotAsset {
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl S3SnapshotAsset {
    /// Creates a new builder-style object to manufacture [`S3SnapshotAsset`](crate::model::S3SnapshotAsset)
    pub fn builder() -> crate::model::s3_snapshot_asset::Builder {
        crate::model::s3_snapshot_asset::Builder::default()
    }
}

/// <p>An asset in AWS Data Exchange is a piece of data. The asset can be a structured data file, an image file, or some other data file that can be stored as an S3 object, or an Amazon Redshift datashare (Preview). When you create an import job for your files, you create an asset in AWS Data Exchange for each of those files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetEntry {
    /// <p>The ARN for the asset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the asset.</p>
    pub asset_details: std::option::Option<crate::model::AssetDetails>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The unique identifier for the data set associated with this asset.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the asset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this asset.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl AssetEntry {
    /// <p>The ARN for the asset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the asset.</p>
    pub fn asset_details(&self) -> std::option::Option<&crate::model::AssetDetails> {
        self.asset_details.as_ref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this asset.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the asset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this asset.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for AssetEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetEntry");
        formatter.field("arn", &self.arn);
        formatter.field("asset_details", &self.asset_details);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`AssetEntry`](crate::model::AssetEntry)
pub mod asset_entry {
    /// A builder for [`AssetEntry`](crate::model::AssetEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_details: std::option::Option<crate::model::AssetDetails>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN for the asset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the asset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Information about the asset.</p>
        pub fn asset_details(mut self, input: crate::model::AssetDetails) -> Self {
            self.asset_details = Some(input);
            self
        }
        /// <p>Information about the asset.</p>
        pub fn set_asset_details(
            mut self,
            input: std::option::Option<crate::model::AssetDetails>,
        ) -> Self {
            self.asset_details = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the asset was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this asset.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this asset.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this asset.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this asset.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The asset ID of the owned asset corresponding to the entitled asset being viewed. This parameter is returned when an asset owner is viewing the entitled copy of its owned asset.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the asset was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetEntry`](crate::model::AssetEntry)
        pub fn build(self) -> crate::model::AssetEntry {
            crate::model::AssetEntry {
                arn: self.arn,
                asset_details: self.asset_details,
                asset_type: self.asset_type,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                id: self.id,
                name: self.name,
                revision_id: self.revision_id,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl AssetEntry {
    /// Creates a new builder-style object to manufacture [`AssetEntry`](crate::model::AssetEntry)
    pub fn builder() -> crate::model::asset_entry::Builder {
        crate::model::asset_entry::Builder::default()
    }
}

/// AWS Data Exchange Jobs are asynchronous import or export operations used to create or copy assets. A data set owner can both import and export as they see fit. Someone with an entitlement to a data set can only export. Jobs are deleted 90 days after they are created.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobEntry {
    /// <p>The ARN for the job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the job was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Details of the operation to be performed by the job, such as export destination details or import source details.</p>
    pub details: std::option::Option<crate::model::ResponseDetails>,
    /// <p>Errors for jobs.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::JobError>>,
    /// <p>The unique identifier for the job.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The state of the job.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The job type.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl JobEntry {
    /// <p>The ARN for the job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the job was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>Details of the operation to be performed by the job, such as export destination details or import source details.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::ResponseDetails> {
        self.details.as_ref()
    }
    /// <p>Errors for jobs.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::JobError]> {
        self.errors.as_deref()
    }
    /// <p>The unique identifier for the job.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The state of the job.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The job type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for JobEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobEntry");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("details", &self.details);
        formatter.field("errors", &self.errors);
        formatter.field("id", &self.id);
        formatter.field("state", &self.state);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`JobEntry`](crate::model::JobEntry)
pub mod job_entry {
    /// A builder for [`JobEntry`](crate::model::JobEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) details: std::option::Option<crate::model::ResponseDetails>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::JobError>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN for the job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the job was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the job was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Details of the operation to be performed by the job, such as export destination details or import source details.</p>
        pub fn details(mut self, input: crate::model::ResponseDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>Details of the operation to be performed by the job, such as export destination details or import source details.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::ResponseDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Errors for jobs.</p>
        pub fn errors(mut self, input: impl Into<crate::model::JobError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Errors for jobs.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The state of the job.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the job.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The job type.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The job type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the job was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`JobEntry`](crate::model::JobEntry)
        pub fn build(self) -> crate::model::JobEntry {
            crate::model::JobEntry {
                arn: self.arn,
                created_at: self.created_at,
                details: self.details,
                errors: self.errors,
                id: self.id,
                state: self.state,
                r#type: self.r#type,
                updated_at: self.updated_at,
            }
        }
    }
}
impl JobEntry {
    /// Creates a new builder-style object to manufacture [`JobEntry`](crate::model::JobEntry)
    pub fn builder() -> crate::model::job_entry::Builder {
        crate::model::job_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    ExportAssetsToS3,
    #[allow(missing_docs)] // documentation missing in model
    ExportAssetToSignedUrl,
    #[allow(missing_docs)] // documentation missing in model
    ExportRevisionsToS3,
    #[allow(missing_docs)] // documentation missing in model
    ImportAssetsFromRedshiftDataShares,
    #[allow(missing_docs)] // documentation missing in model
    ImportAssetsFromS3,
    #[allow(missing_docs)] // documentation missing in model
    ImportAssetFromSignedUrl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "EXPORT_ASSETS_TO_S3" => Type::ExportAssetsToS3,
            "EXPORT_ASSET_TO_SIGNED_URL" => Type::ExportAssetToSignedUrl,
            "EXPORT_REVISIONS_TO_S3" => Type::ExportRevisionsToS3,
            "IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES" => Type::ImportAssetsFromRedshiftDataShares,
            "IMPORT_ASSETS_FROM_S3" => Type::ImportAssetsFromS3,
            "IMPORT_ASSET_FROM_SIGNED_URL" => Type::ImportAssetFromSignedUrl,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::ExportAssetsToS3 => "EXPORT_ASSETS_TO_S3",
            Type::ExportAssetToSignedUrl => "EXPORT_ASSET_TO_SIGNED_URL",
            Type::ExportRevisionsToS3 => "EXPORT_REVISIONS_TO_S3",
            Type::ImportAssetsFromRedshiftDataShares => "IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES",
            Type::ImportAssetsFromS3 => "IMPORT_ASSETS_FROM_S3",
            Type::ImportAssetFromSignedUrl => "IMPORT_ASSET_FROM_SIGNED_URL",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXPORT_ASSETS_TO_S3",
            "EXPORT_ASSET_TO_SIGNED_URL",
            "EXPORT_REVISIONS_TO_S3",
            "IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES",
            "IMPORT_ASSETS_FROM_S3",
            "IMPORT_ASSET_FROM_SIGNED_URL",
        ]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    #[allow(missing_docs)] // documentation missing in model
    Waiting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => State::Cancelled,
            "COMPLETED" => State::Completed,
            "ERROR" => State::Error,
            "IN_PROGRESS" => State::InProgress,
            "TIMED_OUT" => State::TimedOut,
            "WAITING" => State::Waiting,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Cancelled => "CANCELLED",
            State::Completed => "COMPLETED",
            State::Error => "ERROR",
            State::InProgress => "IN_PROGRESS",
            State::TimedOut => "TIMED_OUT",
            State::Waiting => "WAITING",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETED",
            "ERROR",
            "IN_PROGRESS",
            "TIMED_OUT",
            "WAITING",
        ]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An error that occurred with the job request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobError {
    /// The code for the job error.
    pub code: std::option::Option<crate::model::Code>,
    /// <p>The details about the job error.</p>
    pub details: std::option::Option<crate::model::Details>,
    /// <p>The name of the limit that was reached.</p>
    pub limit_name: std::option::Option<crate::model::JobErrorLimitName>,
    /// The value of the exceeded limit.
    pub limit_value: f64,
    /// The message related to the job error.
    pub message: std::option::Option<std::string::String>,
    /// The unique identifier for the resource related to the error.
    pub resource_id: std::option::Option<std::string::String>,
    /// The type of resource related to the error.
    pub resource_type: std::option::Option<crate::model::JobErrorResourceTypes>,
}
impl JobError {
    /// The code for the job error.
    pub fn code(&self) -> std::option::Option<&crate::model::Code> {
        self.code.as_ref()
    }
    /// <p>The details about the job error.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::Details> {
        self.details.as_ref()
    }
    /// <p>The name of the limit that was reached.</p>
    pub fn limit_name(&self) -> std::option::Option<&crate::model::JobErrorLimitName> {
        self.limit_name.as_ref()
    }
    /// The value of the exceeded limit.
    pub fn limit_value(&self) -> f64 {
        self.limit_value
    }
    /// The message related to the job error.
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// The unique identifier for the resource related to the error.
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// The type of resource related to the error.
    pub fn resource_type(&self) -> std::option::Option<&crate::model::JobErrorResourceTypes> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for JobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobError");
        formatter.field("code", &self.code);
        formatter.field("details", &self.details);
        formatter.field("limit_name", &self.limit_name);
        formatter.field("limit_value", &self.limit_value);
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`JobError`](crate::model::JobError)
pub mod job_error {
    /// A builder for [`JobError`](crate::model::JobError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::Code>,
        pub(crate) details: std::option::Option<crate::model::Details>,
        pub(crate) limit_name: std::option::Option<crate::model::JobErrorLimitName>,
        pub(crate) limit_value: std::option::Option<f64>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::JobErrorResourceTypes>,
    }
    impl Builder {
        /// The code for the job error.
        pub fn code(mut self, input: crate::model::Code) -> Self {
            self.code = Some(input);
            self
        }
        /// The code for the job error.
        pub fn set_code(mut self, input: std::option::Option<crate::model::Code>) -> Self {
            self.code = input;
            self
        }
        /// <p>The details about the job error.</p>
        pub fn details(mut self, input: crate::model::Details) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>The details about the job error.</p>
        pub fn set_details(mut self, input: std::option::Option<crate::model::Details>) -> Self {
            self.details = input;
            self
        }
        /// <p>The name of the limit that was reached.</p>
        pub fn limit_name(mut self, input: crate::model::JobErrorLimitName) -> Self {
            self.limit_name = Some(input);
            self
        }
        /// <p>The name of the limit that was reached.</p>
        pub fn set_limit_name(
            mut self,
            input: std::option::Option<crate::model::JobErrorLimitName>,
        ) -> Self {
            self.limit_name = input;
            self
        }
        /// The value of the exceeded limit.
        pub fn limit_value(mut self, input: f64) -> Self {
            self.limit_value = Some(input);
            self
        }
        /// The value of the exceeded limit.
        pub fn set_limit_value(mut self, input: std::option::Option<f64>) -> Self {
            self.limit_value = input;
            self
        }
        /// The message related to the job error.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The message related to the job error.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// The unique identifier for the resource related to the error.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The unique identifier for the resource related to the error.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// The type of resource related to the error.
        pub fn resource_type(mut self, input: crate::model::JobErrorResourceTypes) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// The type of resource related to the error.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::JobErrorResourceTypes>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`JobError`](crate::model::JobError)
        pub fn build(self) -> crate::model::JobError {
            crate::model::JobError {
                code: self.code,
                details: self.details,
                limit_name: self.limit_name,
                limit_value: self.limit_value.unwrap_or_default(),
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl JobError {
    /// Creates a new builder-style object to manufacture [`JobError`](crate::model::JobError)
    pub fn builder() -> crate::model::job_error::Builder {
        crate::model::job_error::Builder::default()
    }
}

/// The types of resource which the job error can apply to.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobErrorResourceTypes {
    #[allow(missing_docs)] // documentation missing in model
    Asset,
    #[allow(missing_docs)] // documentation missing in model
    DataSet,
    #[allow(missing_docs)] // documentation missing in model
    Revision,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobErrorResourceTypes {
    fn from(s: &str) -> Self {
        match s {
            "ASSET" => JobErrorResourceTypes::Asset,
            "DATA_SET" => JobErrorResourceTypes::DataSet,
            "REVISION" => JobErrorResourceTypes::Revision,
            other => JobErrorResourceTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobErrorResourceTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobErrorResourceTypes::from(s))
    }
}
impl JobErrorResourceTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobErrorResourceTypes::Asset => "ASSET",
            JobErrorResourceTypes::DataSet => "DATA_SET",
            JobErrorResourceTypes::Revision => "REVISION",
            JobErrorResourceTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSET", "DATA_SET", "REVISION"]
    }
}
impl AsRef<str> for JobErrorResourceTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The name of the limit that was reached.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobErrorLimitName {
    #[allow(missing_docs)] // documentation missing in model
    AmazonRedshiftDatashareAssetsPerRevision,
    #[allow(missing_docs)] // documentation missing in model
    AssetSizeInGb,
    #[allow(missing_docs)] // documentation missing in model
    AssetsPerRevision,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobErrorLimitName {
    fn from(s: &str) -> Self {
        match s {
            "Amazon Redshift datashare assets per revision" => {
                JobErrorLimitName::AmazonRedshiftDatashareAssetsPerRevision
            }
            "Asset size in GB" => JobErrorLimitName::AssetSizeInGb,
            "Assets per revision" => JobErrorLimitName::AssetsPerRevision,
            other => JobErrorLimitName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobErrorLimitName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobErrorLimitName::from(s))
    }
}
impl JobErrorLimitName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobErrorLimitName::AmazonRedshiftDatashareAssetsPerRevision => {
                "Amazon Redshift datashare assets per revision"
            }
            JobErrorLimitName::AssetSizeInGb => "Asset size in GB",
            JobErrorLimitName::AssetsPerRevision => "Assets per revision",
            JobErrorLimitName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Amazon Redshift datashare assets per revision",
            "Asset size in GB",
            "Assets per revision",
        ]
    }
}
impl AsRef<str> for JobErrorLimitName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the job error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Details {
    /// <p>Information about the job error.</p>
    pub import_asset_from_signed_url_job_error_details:
        std::option::Option<crate::model::ImportAssetFromSignedUrlJobErrorDetails>,
    /// <p>Information about the job error.</p>
    pub import_assets_from_s3_job_error_details:
        std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
}
impl Details {
    /// <p>Information about the job error.</p>
    pub fn import_asset_from_signed_url_job_error_details(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetFromSignedUrlJobErrorDetails> {
        self.import_asset_from_signed_url_job_error_details.as_ref()
    }
    /// <p>Information about the job error.</p>
    pub fn import_assets_from_s3_job_error_details(
        &self,
    ) -> std::option::Option<&[crate::model::AssetSourceEntry]> {
        self.import_assets_from_s3_job_error_details.as_deref()
    }
}
impl std::fmt::Debug for Details {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Details");
        formatter.field(
            "import_asset_from_signed_url_job_error_details",
            &self.import_asset_from_signed_url_job_error_details,
        );
        formatter.field(
            "import_assets_from_s3_job_error_details",
            &self.import_assets_from_s3_job_error_details,
        );
        formatter.finish()
    }
}
/// See [`Details`](crate::model::Details)
pub mod details {
    /// A builder for [`Details`](crate::model::Details)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_asset_from_signed_url_job_error_details:
            std::option::Option<crate::model::ImportAssetFromSignedUrlJobErrorDetails>,
        pub(crate) import_assets_from_s3_job_error_details:
            std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
    }
    impl Builder {
        /// <p>Information about the job error.</p>
        pub fn import_asset_from_signed_url_job_error_details(
            mut self,
            input: crate::model::ImportAssetFromSignedUrlJobErrorDetails,
        ) -> Self {
            self.import_asset_from_signed_url_job_error_details = Some(input);
            self
        }
        /// <p>Information about the job error.</p>
        pub fn set_import_asset_from_signed_url_job_error_details(
            mut self,
            input: std::option::Option<crate::model::ImportAssetFromSignedUrlJobErrorDetails>,
        ) -> Self {
            self.import_asset_from_signed_url_job_error_details = input;
            self
        }
        /// Appends an item to `import_assets_from_s3_job_error_details`.
        ///
        /// To override the contents of this collection use [`set_import_assets_from_s3_job_error_details`](Self::set_import_assets_from_s3_job_error_details).
        ///
        /// <p>Information about the job error.</p>
        pub fn import_assets_from_s3_job_error_details(
            mut self,
            input: impl Into<crate::model::AssetSourceEntry>,
        ) -> Self {
            let mut v = self
                .import_assets_from_s3_job_error_details
                .unwrap_or_default();
            v.push(input.into());
            self.import_assets_from_s3_job_error_details = Some(v);
            self
        }
        /// <p>Information about the job error.</p>
        pub fn set_import_assets_from_s3_job_error_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
        ) -> Self {
            self.import_assets_from_s3_job_error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Details`](crate::model::Details)
        pub fn build(self) -> crate::model::Details {
            crate::model::Details {
                import_asset_from_signed_url_job_error_details: self
                    .import_asset_from_signed_url_job_error_details,
                import_assets_from_s3_job_error_details: self
                    .import_assets_from_s3_job_error_details,
            }
        }
    }
}
impl Details {
    /// Creates a new builder-style object to manufacture [`Details`](crate::model::Details)
    pub fn builder() -> crate::model::details::Builder {
        crate::model::details::Builder::default()
    }
}

/// <p>The source of the assets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetSourceEntry {
    /// <p>The S3 bucket that's part of the source of the asset.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name of the object in Amazon S3 for the asset.</p>
    pub key: std::option::Option<std::string::String>,
}
impl AssetSourceEntry {
    /// <p>The S3 bucket that's part of the source of the asset.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name of the object in Amazon S3 for the asset.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for AssetSourceEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetSourceEntry");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`AssetSourceEntry`](crate::model::AssetSourceEntry)
pub mod asset_source_entry {
    /// A builder for [`AssetSourceEntry`](crate::model::AssetSourceEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket that's part of the source of the asset.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket that's part of the source of the asset.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the object in Amazon S3 for the asset.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the object in Amazon S3 for the asset.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetSourceEntry`](crate::model::AssetSourceEntry)
        pub fn build(self) -> crate::model::AssetSourceEntry {
            crate::model::AssetSourceEntry {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl AssetSourceEntry {
    /// Creates a new builder-style object to manufacture [`AssetSourceEntry`](crate::model::AssetSourceEntry)
    pub fn builder() -> crate::model::asset_source_entry::Builder {
        crate::model::asset_source_entry::Builder::default()
    }
}

/// <p>Information about the job error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetFromSignedUrlJobErrorDetails {
    /// <p>Information about the job error.</p>
    pub asset_name: std::option::Option<std::string::String>,
}
impl ImportAssetFromSignedUrlJobErrorDetails {
    /// <p>Information about the job error.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
}
impl std::fmt::Debug for ImportAssetFromSignedUrlJobErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetFromSignedUrlJobErrorDetails");
        formatter.field("asset_name", &self.asset_name);
        formatter.finish()
    }
}
/// See [`ImportAssetFromSignedUrlJobErrorDetails`](crate::model::ImportAssetFromSignedUrlJobErrorDetails)
pub mod import_asset_from_signed_url_job_error_details {
    /// A builder for [`ImportAssetFromSignedUrlJobErrorDetails`](crate::model::ImportAssetFromSignedUrlJobErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the job error.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>Information about the job error.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetFromSignedUrlJobErrorDetails`](crate::model::ImportAssetFromSignedUrlJobErrorDetails)
        pub fn build(self) -> crate::model::ImportAssetFromSignedUrlJobErrorDetails {
            crate::model::ImportAssetFromSignedUrlJobErrorDetails {
                asset_name: self.asset_name,
            }
        }
    }
}
impl ImportAssetFromSignedUrlJobErrorDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetFromSignedUrlJobErrorDetails`](crate::model::ImportAssetFromSignedUrlJobErrorDetails)
    pub fn builder() -> crate::model::import_asset_from_signed_url_job_error_details::Builder {
        crate::model::import_asset_from_signed_url_job_error_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Code {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException,
    #[allow(missing_docs)] // documentation missing in model
    InternalServerException,
    #[allow(missing_docs)] // documentation missing in model
    MalwareDetected,
    #[allow(missing_docs)] // documentation missing in model
    MalwareScanEncryptedFile,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException,
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededException,
    #[allow(missing_docs)] // documentation missing in model
    ValidationException,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Code {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED_EXCEPTION" => Code::AccessDeniedException,
            "INTERNAL_SERVER_EXCEPTION" => Code::InternalServerException,
            "MALWARE_DETECTED" => Code::MalwareDetected,
            "MALWARE_SCAN_ENCRYPTED_FILE" => Code::MalwareScanEncryptedFile,
            "RESOURCE_NOT_FOUND_EXCEPTION" => Code::ResourceNotFoundException,
            "SERVICE_QUOTA_EXCEEDED_EXCEPTION" => Code::ServiceQuotaExceededException,
            "VALIDATION_EXCEPTION" => Code::ValidationException,
            other => Code::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Code {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Code::from(s))
    }
}
impl Code {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Code::AccessDeniedException => "ACCESS_DENIED_EXCEPTION",
            Code::InternalServerException => "INTERNAL_SERVER_EXCEPTION",
            Code::MalwareDetected => "MALWARE_DETECTED",
            Code::MalwareScanEncryptedFile => "MALWARE_SCAN_ENCRYPTED_FILE",
            Code::ResourceNotFoundException => "RESOURCE_NOT_FOUND_EXCEPTION",
            Code::ServiceQuotaExceededException => "SERVICE_QUOTA_EXCEEDED_EXCEPTION",
            Code::ValidationException => "VALIDATION_EXCEPTION",
            Code::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED_EXCEPTION",
            "INTERNAL_SERVER_EXCEPTION",
            "MALWARE_DETECTED",
            "MALWARE_SCAN_ENCRYPTED_FILE",
            "RESOURCE_NOT_FOUND_EXCEPTION",
            "SERVICE_QUOTA_EXCEEDED_EXCEPTION",
            "VALIDATION_EXCEPTION",
        ]
    }
}
impl AsRef<str> for Code {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details for the response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseDetails {
    /// <p>Details for the export to signed URL response.</p>
    pub export_asset_to_signed_url:
        std::option::Option<crate::model::ExportAssetToSignedUrlResponseDetails>,
    /// <p>Details for the export to Amazon S3 response.</p>
    pub export_assets_to_s3: std::option::Option<crate::model::ExportAssetsToS3ResponseDetails>,
    /// <p>Details for the export revisions to Amazon S3 response.</p>
    pub export_revisions_to_s3:
        std::option::Option<crate::model::ExportRevisionsToS3ResponseDetails>,
    /// <p>Details for the import from signed URL response.</p>
    pub import_asset_from_signed_url:
        std::option::Option<crate::model::ImportAssetFromSignedUrlResponseDetails>,
    /// <p>Details for the import from Amazon S3 response.</p>
    pub import_assets_from_s3: std::option::Option<crate::model::ImportAssetsFromS3ResponseDetails>,
    /// <p>Details from an import from Amazon Redshift datashare response.</p>
    pub import_assets_from_redshift_data_shares:
        std::option::Option<crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails>,
}
impl ResponseDetails {
    /// <p>Details for the export to signed URL response.</p>
    pub fn export_asset_to_signed_url(
        &self,
    ) -> std::option::Option<&crate::model::ExportAssetToSignedUrlResponseDetails> {
        self.export_asset_to_signed_url.as_ref()
    }
    /// <p>Details for the export to Amazon S3 response.</p>
    pub fn export_assets_to_s3(
        &self,
    ) -> std::option::Option<&crate::model::ExportAssetsToS3ResponseDetails> {
        self.export_assets_to_s3.as_ref()
    }
    /// <p>Details for the export revisions to Amazon S3 response.</p>
    pub fn export_revisions_to_s3(
        &self,
    ) -> std::option::Option<&crate::model::ExportRevisionsToS3ResponseDetails> {
        self.export_revisions_to_s3.as_ref()
    }
    /// <p>Details for the import from signed URL response.</p>
    pub fn import_asset_from_signed_url(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetFromSignedUrlResponseDetails> {
        self.import_asset_from_signed_url.as_ref()
    }
    /// <p>Details for the import from Amazon S3 response.</p>
    pub fn import_assets_from_s3(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetsFromS3ResponseDetails> {
        self.import_assets_from_s3.as_ref()
    }
    /// <p>Details from an import from Amazon Redshift datashare response.</p>
    pub fn import_assets_from_redshift_data_shares(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails> {
        self.import_assets_from_redshift_data_shares.as_ref()
    }
}
impl std::fmt::Debug for ResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseDetails");
        formatter.field(
            "export_asset_to_signed_url",
            &self.export_asset_to_signed_url,
        );
        formatter.field("export_assets_to_s3", &self.export_assets_to_s3);
        formatter.field("export_revisions_to_s3", &self.export_revisions_to_s3);
        formatter.field(
            "import_asset_from_signed_url",
            &self.import_asset_from_signed_url,
        );
        formatter.field("import_assets_from_s3", &self.import_assets_from_s3);
        formatter.field(
            "import_assets_from_redshift_data_shares",
            &self.import_assets_from_redshift_data_shares,
        );
        formatter.finish()
    }
}
/// See [`ResponseDetails`](crate::model::ResponseDetails)
pub mod response_details {
    /// A builder for [`ResponseDetails`](crate::model::ResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_asset_to_signed_url:
            std::option::Option<crate::model::ExportAssetToSignedUrlResponseDetails>,
        pub(crate) export_assets_to_s3:
            std::option::Option<crate::model::ExportAssetsToS3ResponseDetails>,
        pub(crate) export_revisions_to_s3:
            std::option::Option<crate::model::ExportRevisionsToS3ResponseDetails>,
        pub(crate) import_asset_from_signed_url:
            std::option::Option<crate::model::ImportAssetFromSignedUrlResponseDetails>,
        pub(crate) import_assets_from_s3:
            std::option::Option<crate::model::ImportAssetsFromS3ResponseDetails>,
        pub(crate) import_assets_from_redshift_data_shares:
            std::option::Option<crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails>,
    }
    impl Builder {
        /// <p>Details for the export to signed URL response.</p>
        pub fn export_asset_to_signed_url(
            mut self,
            input: crate::model::ExportAssetToSignedUrlResponseDetails,
        ) -> Self {
            self.export_asset_to_signed_url = Some(input);
            self
        }
        /// <p>Details for the export to signed URL response.</p>
        pub fn set_export_asset_to_signed_url(
            mut self,
            input: std::option::Option<crate::model::ExportAssetToSignedUrlResponseDetails>,
        ) -> Self {
            self.export_asset_to_signed_url = input;
            self
        }
        /// <p>Details for the export to Amazon S3 response.</p>
        pub fn export_assets_to_s3(
            mut self,
            input: crate::model::ExportAssetsToS3ResponseDetails,
        ) -> Self {
            self.export_assets_to_s3 = Some(input);
            self
        }
        /// <p>Details for the export to Amazon S3 response.</p>
        pub fn set_export_assets_to_s3(
            mut self,
            input: std::option::Option<crate::model::ExportAssetsToS3ResponseDetails>,
        ) -> Self {
            self.export_assets_to_s3 = input;
            self
        }
        /// <p>Details for the export revisions to Amazon S3 response.</p>
        pub fn export_revisions_to_s3(
            mut self,
            input: crate::model::ExportRevisionsToS3ResponseDetails,
        ) -> Self {
            self.export_revisions_to_s3 = Some(input);
            self
        }
        /// <p>Details for the export revisions to Amazon S3 response.</p>
        pub fn set_export_revisions_to_s3(
            mut self,
            input: std::option::Option<crate::model::ExportRevisionsToS3ResponseDetails>,
        ) -> Self {
            self.export_revisions_to_s3 = input;
            self
        }
        /// <p>Details for the import from signed URL response.</p>
        pub fn import_asset_from_signed_url(
            mut self,
            input: crate::model::ImportAssetFromSignedUrlResponseDetails,
        ) -> Self {
            self.import_asset_from_signed_url = Some(input);
            self
        }
        /// <p>Details for the import from signed URL response.</p>
        pub fn set_import_asset_from_signed_url(
            mut self,
            input: std::option::Option<crate::model::ImportAssetFromSignedUrlResponseDetails>,
        ) -> Self {
            self.import_asset_from_signed_url = input;
            self
        }
        /// <p>Details for the import from Amazon S3 response.</p>
        pub fn import_assets_from_s3(
            mut self,
            input: crate::model::ImportAssetsFromS3ResponseDetails,
        ) -> Self {
            self.import_assets_from_s3 = Some(input);
            self
        }
        /// <p>Details for the import from Amazon S3 response.</p>
        pub fn set_import_assets_from_s3(
            mut self,
            input: std::option::Option<crate::model::ImportAssetsFromS3ResponseDetails>,
        ) -> Self {
            self.import_assets_from_s3 = input;
            self
        }
        /// <p>Details from an import from Amazon Redshift datashare response.</p>
        pub fn import_assets_from_redshift_data_shares(
            mut self,
            input: crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails,
        ) -> Self {
            self.import_assets_from_redshift_data_shares = Some(input);
            self
        }
        /// <p>Details from an import from Amazon Redshift datashare response.</p>
        pub fn set_import_assets_from_redshift_data_shares(
            mut self,
            input: std::option::Option<
                crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails,
            >,
        ) -> Self {
            self.import_assets_from_redshift_data_shares = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseDetails`](crate::model::ResponseDetails)
        pub fn build(self) -> crate::model::ResponseDetails {
            crate::model::ResponseDetails {
                export_asset_to_signed_url: self.export_asset_to_signed_url,
                export_assets_to_s3: self.export_assets_to_s3,
                export_revisions_to_s3: self.export_revisions_to_s3,
                import_asset_from_signed_url: self.import_asset_from_signed_url,
                import_assets_from_s3: self.import_assets_from_s3,
                import_assets_from_redshift_data_shares: self
                    .import_assets_from_redshift_data_shares,
            }
        }
    }
}
impl ResponseDetails {
    /// Creates a new builder-style object to manufacture [`ResponseDetails`](crate::model::ResponseDetails)
    pub fn builder() -> crate::model::response_details::Builder {
        crate::model::response_details::Builder::default()
    }
}

/// Details from an import from Amazon Redshift datashare response.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetsFromRedshiftDataSharesResponseDetails {
    /// A list of Amazon Redshift datashare asset sources.
    pub asset_sources:
        std::option::Option<std::vec::Vec<crate::model::RedshiftDataShareAssetSourceEntry>>,
    /// The unique identifier for the data set associated with this import job.
    pub data_set_id: std::option::Option<std::string::String>,
    /// The unique identifier for the revision associated with this import job.
    pub revision_id: std::option::Option<std::string::String>,
}
impl ImportAssetsFromRedshiftDataSharesResponseDetails {
    /// A list of Amazon Redshift datashare asset sources.
    pub fn asset_sources(
        &self,
    ) -> std::option::Option<&[crate::model::RedshiftDataShareAssetSourceEntry]> {
        self.asset_sources.as_deref()
    }
    /// The unique identifier for the data set associated with this import job.
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// The unique identifier for the revision associated with this import job.
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ImportAssetsFromRedshiftDataSharesResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetsFromRedshiftDataSharesResponseDetails");
        formatter.field("asset_sources", &self.asset_sources);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ImportAssetsFromRedshiftDataSharesResponseDetails`](crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails)
pub mod import_assets_from_redshift_data_shares_response_details {
    /// A builder for [`ImportAssetsFromRedshiftDataSharesResponseDetails`](crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_sources:
            std::option::Option<std::vec::Vec<crate::model::RedshiftDataShareAssetSourceEntry>>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_sources`.
        ///
        /// To override the contents of this collection use [`set_asset_sources`](Self::set_asset_sources).
        ///
        /// A list of Amazon Redshift datashare asset sources.
        pub fn asset_sources(
            mut self,
            input: impl Into<crate::model::RedshiftDataShareAssetSourceEntry>,
        ) -> Self {
            let mut v = self.asset_sources.unwrap_or_default();
            v.push(input.into());
            self.asset_sources = Some(v);
            self
        }
        /// A list of Amazon Redshift datashare asset sources.
        pub fn set_asset_sources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RedshiftDataShareAssetSourceEntry>,
            >,
        ) -> Self {
            self.asset_sources = input;
            self
        }
        /// The unique identifier for the data set associated with this import job.
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// The unique identifier for the data set associated with this import job.
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// The unique identifier for the revision associated with this import job.
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// The unique identifier for the revision associated with this import job.
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetsFromRedshiftDataSharesResponseDetails`](crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails)
        pub fn build(self) -> crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails {
            crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails {
                asset_sources: self.asset_sources,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ImportAssetsFromRedshiftDataSharesResponseDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetsFromRedshiftDataSharesResponseDetails`](crate::model::ImportAssetsFromRedshiftDataSharesResponseDetails)
    pub fn builder(
    ) -> crate::model::import_assets_from_redshift_data_shares_response_details::Builder {
        crate::model::import_assets_from_redshift_data_shares_response_details::Builder::default()
    }
}

/// <p>The source of the Amazon Redshift datashare asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDataShareAssetSourceEntry {
    /// The Amazon Resource Name (ARN) of the datashare asset.
    pub data_share_arn: std::option::Option<std::string::String>,
}
impl RedshiftDataShareAssetSourceEntry {
    /// The Amazon Resource Name (ARN) of the datashare asset.
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
}
impl std::fmt::Debug for RedshiftDataShareAssetSourceEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDataShareAssetSourceEntry");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.finish()
    }
}
/// See [`RedshiftDataShareAssetSourceEntry`](crate::model::RedshiftDataShareAssetSourceEntry)
pub mod redshift_data_share_asset_source_entry {
    /// A builder for [`RedshiftDataShareAssetSourceEntry`](crate::model::RedshiftDataShareAssetSourceEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the datashare asset.
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the datashare asset.
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDataShareAssetSourceEntry`](crate::model::RedshiftDataShareAssetSourceEntry)
        pub fn build(self) -> crate::model::RedshiftDataShareAssetSourceEntry {
            crate::model::RedshiftDataShareAssetSourceEntry {
                data_share_arn: self.data_share_arn,
            }
        }
    }
}
impl RedshiftDataShareAssetSourceEntry {
    /// Creates a new builder-style object to manufacture [`RedshiftDataShareAssetSourceEntry`](crate::model::RedshiftDataShareAssetSourceEntry)
    pub fn builder() -> crate::model::redshift_data_share_asset_source_entry::Builder {
        crate::model::redshift_data_share_asset_source_entry::Builder::default()
    }
}

/// <p>Details from an import from Amazon S3 response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetsFromS3ResponseDetails {
    /// <p>Is a list of Amazon S3 bucket and object key pairs.</p>
    pub asset_sources: std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this import response.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ImportAssetsFromS3ResponseDetails {
    /// <p>Is a list of Amazon S3 bucket and object key pairs.</p>
    pub fn asset_sources(&self) -> std::option::Option<&[crate::model::AssetSourceEntry]> {
        self.asset_sources.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this import response.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ImportAssetsFromS3ResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetsFromS3ResponseDetails");
        formatter.field("asset_sources", &self.asset_sources);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ImportAssetsFromS3ResponseDetails`](crate::model::ImportAssetsFromS3ResponseDetails)
pub mod import_assets_from_s3_response_details {
    /// A builder for [`ImportAssetsFromS3ResponseDetails`](crate::model::ImportAssetsFromS3ResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_sources:
            std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_sources`.
        ///
        /// To override the contents of this collection use [`set_asset_sources`](Self::set_asset_sources).
        ///
        /// <p>Is a list of Amazon S3 bucket and object key pairs.</p>
        pub fn asset_sources(mut self, input: impl Into<crate::model::AssetSourceEntry>) -> Self {
            let mut v = self.asset_sources.unwrap_or_default();
            v.push(input.into());
            self.asset_sources = Some(v);
            self
        }
        /// <p>Is a list of Amazon S3 bucket and object key pairs.</p>
        pub fn set_asset_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
        ) -> Self {
            self.asset_sources = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this import response.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this import response.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetsFromS3ResponseDetails`](crate::model::ImportAssetsFromS3ResponseDetails)
        pub fn build(self) -> crate::model::ImportAssetsFromS3ResponseDetails {
            crate::model::ImportAssetsFromS3ResponseDetails {
                asset_sources: self.asset_sources,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ImportAssetsFromS3ResponseDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetsFromS3ResponseDetails`](crate::model::ImportAssetsFromS3ResponseDetails)
    pub fn builder() -> crate::model::import_assets_from_s3_response_details::Builder {
        crate::model::import_assets_from_s3_response_details::Builder::default()
    }
}

/// <p>The details in the response for an import request, including the signed URL and other information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetFromSignedUrlResponseDetails {
    /// <p>The name for the asset associated with this import job.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
    pub md5_hash: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this import response.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The signed URL.</p>
    pub signed_url: std::option::Option<std::string::String>,
    /// <p>The time and date at which the signed URL expires, in ISO 8601 format.</p>
    pub signed_url_expires_at: std::option::Option<aws_smithy_types::Instant>,
}
impl ImportAssetFromSignedUrlResponseDetails {
    /// <p>The name for the asset associated with this import job.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
    pub fn md5_hash(&self) -> std::option::Option<&str> {
        self.md5_hash.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this import response.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The signed URL.</p>
    pub fn signed_url(&self) -> std::option::Option<&str> {
        self.signed_url.as_deref()
    }
    /// <p>The time and date at which the signed URL expires, in ISO 8601 format.</p>
    pub fn signed_url_expires_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.signed_url_expires_at.as_ref()
    }
}
impl std::fmt::Debug for ImportAssetFromSignedUrlResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetFromSignedUrlResponseDetails");
        formatter.field("asset_name", &self.asset_name);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("md5_hash", &self.md5_hash);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("signed_url", &self.signed_url);
        formatter.field("signed_url_expires_at", &self.signed_url_expires_at);
        formatter.finish()
    }
}
/// See [`ImportAssetFromSignedUrlResponseDetails`](crate::model::ImportAssetFromSignedUrlResponseDetails)
pub mod import_asset_from_signed_url_response_details {
    /// A builder for [`ImportAssetFromSignedUrlResponseDetails`](crate::model::ImportAssetFromSignedUrlResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) md5_hash: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) signed_url: std::option::Option<std::string::String>,
        pub(crate) signed_url_expires_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name for the asset associated with this import job.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>The name for the asset associated with this import job.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
        pub fn md5_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_hash = Some(input.into());
            self
        }
        /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
        pub fn set_md5_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.md5_hash = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this import response.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this import response.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The signed URL.</p>
        pub fn signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.signed_url = Some(input.into());
            self
        }
        /// <p>The signed URL.</p>
        pub fn set_signed_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signed_url = input;
            self
        }
        /// <p>The time and date at which the signed URL expires, in ISO 8601 format.</p>
        pub fn signed_url_expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.signed_url_expires_at = Some(input);
            self
        }
        /// <p>The time and date at which the signed URL expires, in ISO 8601 format.</p>
        pub fn set_signed_url_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.signed_url_expires_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetFromSignedUrlResponseDetails`](crate::model::ImportAssetFromSignedUrlResponseDetails)
        pub fn build(self) -> crate::model::ImportAssetFromSignedUrlResponseDetails {
            crate::model::ImportAssetFromSignedUrlResponseDetails {
                asset_name: self.asset_name,
                data_set_id: self.data_set_id,
                md5_hash: self.md5_hash,
                revision_id: self.revision_id,
                signed_url: self.signed_url,
                signed_url_expires_at: self.signed_url_expires_at,
            }
        }
    }
}
impl ImportAssetFromSignedUrlResponseDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetFromSignedUrlResponseDetails`](crate::model::ImportAssetFromSignedUrlResponseDetails)
    pub fn builder() -> crate::model::import_asset_from_signed_url_response_details::Builder {
        crate::model::import_asset_from_signed_url_response_details::Builder::default()
    }
}

/// <p>Details about the export revisions to Amazon S3 response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportRevisionsToS3ResponseDetails {
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>Encryption configuration of the export job.</p>
    pub encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
    /// <p>The destination in Amazon S3 where the revision is exported.</p>
    pub revision_destinations:
        std::option::Option<std::vec::Vec<crate::model::RevisionDestinationEntry>>,
    /// <p>The Amazon Resource Name (ARN) of the event action.</p>
    pub event_action_arn: std::option::Option<std::string::String>,
}
impl ExportRevisionsToS3ResponseDetails {
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>Encryption configuration of the export job.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::ExportServerSideEncryption> {
        self.encryption.as_ref()
    }
    /// <p>The destination in Amazon S3 where the revision is exported.</p>
    pub fn revision_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::RevisionDestinationEntry]> {
        self.revision_destinations.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the event action.</p>
    pub fn event_action_arn(&self) -> std::option::Option<&str> {
        self.event_action_arn.as_deref()
    }
}
impl std::fmt::Debug for ExportRevisionsToS3ResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportRevisionsToS3ResponseDetails");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("encryption", &self.encryption);
        formatter.field("revision_destinations", &self.revision_destinations);
        formatter.field("event_action_arn", &self.event_action_arn);
        formatter.finish()
    }
}
/// See [`ExportRevisionsToS3ResponseDetails`](crate::model::ExportRevisionsToS3ResponseDetails)
pub mod export_revisions_to_s3_response_details {
    /// A builder for [`ExportRevisionsToS3ResponseDetails`](crate::model::ExportRevisionsToS3ResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
        pub(crate) revision_destinations:
            std::option::Option<std::vec::Vec<crate::model::RevisionDestinationEntry>>,
        pub(crate) event_action_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>Encryption configuration of the export job.</p>
        pub fn encryption(mut self, input: crate::model::ExportServerSideEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Encryption configuration of the export job.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::ExportServerSideEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `revision_destinations`.
        ///
        /// To override the contents of this collection use [`set_revision_destinations`](Self::set_revision_destinations).
        ///
        /// <p>The destination in Amazon S3 where the revision is exported.</p>
        pub fn revision_destinations(
            mut self,
            input: impl Into<crate::model::RevisionDestinationEntry>,
        ) -> Self {
            let mut v = self.revision_destinations.unwrap_or_default();
            v.push(input.into());
            self.revision_destinations = Some(v);
            self
        }
        /// <p>The destination in Amazon S3 where the revision is exported.</p>
        pub fn set_revision_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionDestinationEntry>>,
        ) -> Self {
            self.revision_destinations = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event action.</p>
        pub fn event_action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_action_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event action.</p>
        pub fn set_event_action_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_action_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportRevisionsToS3ResponseDetails`](crate::model::ExportRevisionsToS3ResponseDetails)
        pub fn build(self) -> crate::model::ExportRevisionsToS3ResponseDetails {
            crate::model::ExportRevisionsToS3ResponseDetails {
                data_set_id: self.data_set_id,
                encryption: self.encryption,
                revision_destinations: self.revision_destinations,
                event_action_arn: self.event_action_arn,
            }
        }
    }
}
impl ExportRevisionsToS3ResponseDetails {
    /// Creates a new builder-style object to manufacture [`ExportRevisionsToS3ResponseDetails`](crate::model::ExportRevisionsToS3ResponseDetails)
    pub fn builder() -> crate::model::export_revisions_to_s3_response_details::Builder {
        crate::model::export_revisions_to_s3_response_details::Builder::default()
    }
}

/// <p>The destination where the assets in the revision will be exported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevisionDestinationEntry {
    /// <p>The S3 bucket that is the destination for the assets in the revision.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
    pub key_pattern: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl RevisionDestinationEntry {
    /// <p>The S3 bucket that is the destination for the assets in the revision.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
    pub fn key_pattern(&self) -> std::option::Option<&str> {
        self.key_pattern.as_deref()
    }
    /// <p>The unique identifier for the revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for RevisionDestinationEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevisionDestinationEntry");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_pattern", &self.key_pattern);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`RevisionDestinationEntry`](crate::model::RevisionDestinationEntry)
pub mod revision_destination_entry {
    /// A builder for [`RevisionDestinationEntry`](crate::model::RevisionDestinationEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_pattern: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket that is the destination for the assets in the revision.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket that is the destination for the assets in the revision.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
        pub fn key_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pattern = Some(input.into());
            self
        }
        /// <p>A string representing the pattern for generated names of the individual assets in the revision. For more information about key patterns, see <a href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key patterns when exporting revisions</a>.</p>
        pub fn set_key_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pattern = input;
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RevisionDestinationEntry`](crate::model::RevisionDestinationEntry)
        pub fn build(self) -> crate::model::RevisionDestinationEntry {
            crate::model::RevisionDestinationEntry {
                bucket: self.bucket,
                key_pattern: self.key_pattern,
                revision_id: self.revision_id,
            }
        }
    }
}
impl RevisionDestinationEntry {
    /// Creates a new builder-style object to manufacture [`RevisionDestinationEntry`](crate::model::RevisionDestinationEntry)
    pub fn builder() -> crate::model::revision_destination_entry::Builder {
        crate::model::revision_destination_entry::Builder::default()
    }
}

/// <p>Details about the export to Amazon S3 response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportAssetsToS3ResponseDetails {
    /// <p>The destination in Amazon S3 where the asset is exported.</p>
    pub asset_destinations: std::option::Option<std::vec::Vec<crate::model::AssetDestinationEntry>>,
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>Encryption configuration of the export job.</p>
    pub encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
    /// <p>The unique identifier for the revision associated with this export response.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ExportAssetsToS3ResponseDetails {
    /// <p>The destination in Amazon S3 where the asset is exported.</p>
    pub fn asset_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::AssetDestinationEntry]> {
        self.asset_destinations.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>Encryption configuration of the export job.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::ExportServerSideEncryption> {
        self.encryption.as_ref()
    }
    /// <p>The unique identifier for the revision associated with this export response.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ExportAssetsToS3ResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportAssetsToS3ResponseDetails");
        formatter.field("asset_destinations", &self.asset_destinations);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("encryption", &self.encryption);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ExportAssetsToS3ResponseDetails`](crate::model::ExportAssetsToS3ResponseDetails)
pub mod export_assets_to_s3_response_details {
    /// A builder for [`ExportAssetsToS3ResponseDetails`](crate::model::ExportAssetsToS3ResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_destinations:
            std::option::Option<std::vec::Vec<crate::model::AssetDestinationEntry>>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_destinations`.
        ///
        /// To override the contents of this collection use [`set_asset_destinations`](Self::set_asset_destinations).
        ///
        /// <p>The destination in Amazon S3 where the asset is exported.</p>
        pub fn asset_destinations(
            mut self,
            input: impl Into<crate::model::AssetDestinationEntry>,
        ) -> Self {
            let mut v = self.asset_destinations.unwrap_or_default();
            v.push(input.into());
            self.asset_destinations = Some(v);
            self
        }
        /// <p>The destination in Amazon S3 where the asset is exported.</p>
        pub fn set_asset_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetDestinationEntry>>,
        ) -> Self {
            self.asset_destinations = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>Encryption configuration of the export job.</p>
        pub fn encryption(mut self, input: crate::model::ExportServerSideEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Encryption configuration of the export job.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::ExportServerSideEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this export response.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this export response.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportAssetsToS3ResponseDetails`](crate::model::ExportAssetsToS3ResponseDetails)
        pub fn build(self) -> crate::model::ExportAssetsToS3ResponseDetails {
            crate::model::ExportAssetsToS3ResponseDetails {
                asset_destinations: self.asset_destinations,
                data_set_id: self.data_set_id,
                encryption: self.encryption,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ExportAssetsToS3ResponseDetails {
    /// Creates a new builder-style object to manufacture [`ExportAssetsToS3ResponseDetails`](crate::model::ExportAssetsToS3ResponseDetails)
    pub fn builder() -> crate::model::export_assets_to_s3_response_details::Builder {
        crate::model::export_assets_to_s3_response_details::Builder::default()
    }
}

/// <p>The destination for the asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetDestinationEntry {
    /// <p>The unique identifier for the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The S3 bucket that is the destination for the asset.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name of the object in Amazon S3 for the asset.</p>
    pub key: std::option::Option<std::string::String>,
}
impl AssetDestinationEntry {
    /// <p>The unique identifier for the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The S3 bucket that is the destination for the asset.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name of the object in Amazon S3 for the asset.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for AssetDestinationEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetDestinationEntry");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`AssetDestinationEntry`](crate::model::AssetDestinationEntry)
pub mod asset_destination_entry {
    /// A builder for [`AssetDestinationEntry`](crate::model::AssetDestinationEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The S3 bucket that is the destination for the asset.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket that is the destination for the asset.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the object in Amazon S3 for the asset.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the object in Amazon S3 for the asset.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetDestinationEntry`](crate::model::AssetDestinationEntry)
        pub fn build(self) -> crate::model::AssetDestinationEntry {
            crate::model::AssetDestinationEntry {
                asset_id: self.asset_id,
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl AssetDestinationEntry {
    /// Creates a new builder-style object to manufacture [`AssetDestinationEntry`](crate::model::AssetDestinationEntry)
    pub fn builder() -> crate::model::asset_destination_entry::Builder {
        crate::model::asset_destination_entry::Builder::default()
    }
}

/// <p>The details of the export to signed URL response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportAssetToSignedUrlResponseDetails {
    /// <p>The unique identifier for the asset associated with this export job.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this export response.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The signed URL for the export request.</p>
    pub signed_url: std::option::Option<std::string::String>,
    /// <p>The date and time that the signed URL expires, in ISO 8601 format.</p>
    pub signed_url_expires_at: std::option::Option<aws_smithy_types::Instant>,
}
impl ExportAssetToSignedUrlResponseDetails {
    /// <p>The unique identifier for the asset associated with this export job.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this export response.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The signed URL for the export request.</p>
    pub fn signed_url(&self) -> std::option::Option<&str> {
        self.signed_url.as_deref()
    }
    /// <p>The date and time that the signed URL expires, in ISO 8601 format.</p>
    pub fn signed_url_expires_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.signed_url_expires_at.as_ref()
    }
}
impl std::fmt::Debug for ExportAssetToSignedUrlResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportAssetToSignedUrlResponseDetails");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("signed_url", &self.signed_url);
        formatter.field("signed_url_expires_at", &self.signed_url_expires_at);
        formatter.finish()
    }
}
/// See [`ExportAssetToSignedUrlResponseDetails`](crate::model::ExportAssetToSignedUrlResponseDetails)
pub mod export_asset_to_signed_url_response_details {
    /// A builder for [`ExportAssetToSignedUrlResponseDetails`](crate::model::ExportAssetToSignedUrlResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) signed_url: std::option::Option<std::string::String>,
        pub(crate) signed_url_expires_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier for the asset associated with this export job.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the asset associated with this export job.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this export response.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this export response.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The signed URL for the export request.</p>
        pub fn signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.signed_url = Some(input.into());
            self
        }
        /// <p>The signed URL for the export request.</p>
        pub fn set_signed_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signed_url = input;
            self
        }
        /// <p>The date and time that the signed URL expires, in ISO 8601 format.</p>
        pub fn signed_url_expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.signed_url_expires_at = Some(input);
            self
        }
        /// <p>The date and time that the signed URL expires, in ISO 8601 format.</p>
        pub fn set_signed_url_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.signed_url_expires_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportAssetToSignedUrlResponseDetails`](crate::model::ExportAssetToSignedUrlResponseDetails)
        pub fn build(self) -> crate::model::ExportAssetToSignedUrlResponseDetails {
            crate::model::ExportAssetToSignedUrlResponseDetails {
                asset_id: self.asset_id,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
                signed_url: self.signed_url,
                signed_url_expires_at: self.signed_url_expires_at,
            }
        }
    }
}
impl ExportAssetToSignedUrlResponseDetails {
    /// Creates a new builder-style object to manufacture [`ExportAssetToSignedUrlResponseDetails`](crate::model::ExportAssetToSignedUrlResponseDetails)
    pub fn builder() -> crate::model::export_asset_to_signed_url_response_details::Builder {
        crate::model::export_asset_to_signed_url_response_details::Builder::default()
    }
}

/// <p>An event action is an object that defines the relationship between a specific event and an automated action that will be taken on behalf of the customer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventActionEntry {
    /// <p>What occurs after a certain event.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The Amazon Resource Name (ARN) for the event action.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>What occurs to start an action.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>The unique identifier for the event action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl EventActionEntry {
    /// <p>What occurs after a certain event.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the event action.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>What occurs to start an action.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>The unique identifier for the event action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for EventActionEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventActionEntry");
        formatter.field("action", &self.action);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("event", &self.event);
        formatter.field("id", &self.id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`EventActionEntry`](crate::model::EventActionEntry)
pub mod event_action_entry {
    /// A builder for [`EventActionEntry`](crate::model::EventActionEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>What occurs after a certain event.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>What occurs after a certain event.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event action.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event action.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>What occurs to start an action.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the event action was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`EventActionEntry`](crate::model::EventActionEntry)
        pub fn build(self) -> crate::model::EventActionEntry {
            crate::model::EventActionEntry {
                action: self.action,
                arn: self.arn,
                created_at: self.created_at,
                event: self.event,
                id: self.id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl EventActionEntry {
    /// Creates a new builder-style object to manufacture [`EventActionEntry`](crate::model::EventActionEntry)
    pub fn builder() -> crate::model::event_action_entry::Builder {
        crate::model::event_action_entry::Builder::default()
    }
}

/// <p>A data set is an AWS resource with one or more revisions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSetEntry {
    /// <p>The ARN for the data set.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of asset that is added to a data set.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description for the data set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the data set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub origin: std::option::Option<crate::model::Origin>,
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub origin_details: std::option::Option<crate::model::OriginDetails>,
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl DataSetEntry {
    /// <p>The ARN for the data set.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of asset that is added to a data set.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The description for the data set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the data set.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the data set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
    pub fn origin(&self) -> std::option::Option<&crate::model::Origin> {
        self.origin.as_ref()
    }
    /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
    pub fn origin_details(&self) -> std::option::Option<&crate::model::OriginDetails> {
        self.origin_details.as_ref()
    }
    /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for DataSetEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSetEntry");
        formatter.field("arn", &self.arn);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("origin", &self.origin);
        formatter.field("origin_details", &self.origin_details);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`DataSetEntry`](crate::model::DataSetEntry)
pub mod data_set_entry {
    /// A builder for [`DataSetEntry`](crate::model::DataSetEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<crate::model::Origin>,
        pub(crate) origin_details: std::option::Option<crate::model::OriginDetails>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN for the data set.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the data set.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of asset that is added to a data set.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The description for the data set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the data set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the data set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn origin(mut self, input: crate::model::Origin) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers).</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::Origin>) -> Self {
            self.origin = input;
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn origin_details(mut self, input: crate::model::OriginDetails) -> Self {
            self.origin_details = Some(input);
            self
        }
        /// <p>If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.</p>
        pub fn set_origin_details(
            mut self,
            input: std::option::Option<crate::model::OriginDetails>,
        ) -> Self {
            self.origin_details = input;
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is returned when a data set owner is viewing the entitled copy of its owned data set.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the data set was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSetEntry`](crate::model::DataSetEntry)
        pub fn build(self) -> crate::model::DataSetEntry {
            crate::model::DataSetEntry {
                arn: self.arn,
                asset_type: self.asset_type,
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                name: self.name,
                origin: self.origin,
                origin_details: self.origin_details,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl DataSetEntry {
    /// Creates a new builder-style object to manufacture [`DataSetEntry`](crate::model::DataSetEntry)
    pub fn builder() -> crate::model::data_set_entry::Builder {
        crate::model::data_set_entry::Builder::default()
    }
}

/// <p>A revision is a container for one or more assets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevisionEntry {
    /// <p>The ARN for the revision.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An optional comment about the revision.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p> <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub finalized: bool,
    /// <p>The unique identifier for the revision.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl RevisionEntry {
    /// <p>The ARN for the revision.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An optional comment about the revision.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the data set associated with this revision.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p> <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
    pub fn finalized(&self) -> bool {
        self.finalized
    }
    /// <p>The unique identifier for the revision.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
    pub fn source_id(&self) -> std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for RevisionEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevisionEntry");
        formatter.field("arn", &self.arn);
        formatter.field("comment", &self.comment);
        formatter.field("created_at", &self.created_at);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("finalized", &self.finalized);
        formatter.field("id", &self.id);
        formatter.field("source_id", &self.source_id);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`RevisionEntry`](crate::model::RevisionEntry)
pub mod revision_entry {
    /// A builder for [`RevisionEntry`](crate::model::RevisionEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) finalized: std::option::Option<bool>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN for the revision.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the revision.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the revision.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was created, in ISO 8601 format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this revision.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p> <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn finalized(mut self, input: bool) -> Self {
            self.finalized = Some(input);
            self
        }
        /// <p>To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products.</p> <p>Finalized revisions can be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified by their ARN.</p>
        pub fn set_finalized(mut self, input: std::option::Option<bool>) -> Self {
            self.finalized = input;
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is returned when a revision owner is viewing the entitled copy of its owned revision.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time that the revision was last updated, in ISO 8601 format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`RevisionEntry`](crate::model::RevisionEntry)
        pub fn build(self) -> crate::model::RevisionEntry {
            crate::model::RevisionEntry {
                arn: self.arn,
                comment: self.comment,
                created_at: self.created_at,
                data_set_id: self.data_set_id,
                finalized: self.finalized.unwrap_or_default(),
                id: self.id,
                source_id: self.source_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl RevisionEntry {
    /// Creates a new builder-style object to manufacture [`RevisionEntry`](crate::model::RevisionEntry)
    pub fn builder() -> crate::model::revision_entry::Builder {
        crate::model::revision_entry::Builder::default()
    }
}

/// <p>The details for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestDetails {
    /// <p>Details about the export to signed URL request.</p>
    pub export_asset_to_signed_url:
        std::option::Option<crate::model::ExportAssetToSignedUrlRequestDetails>,
    /// <p>Details about the export to Amazon S3 request.</p>
    pub export_assets_to_s3: std::option::Option<crate::model::ExportAssetsToS3RequestDetails>,
    /// <p>Details about the export to Amazon S3 request.</p>
    pub export_revisions_to_s3:
        std::option::Option<crate::model::ExportRevisionsToS3RequestDetails>,
    /// <p>Details about the import from signed URL request.</p>
    pub import_asset_from_signed_url:
        std::option::Option<crate::model::ImportAssetFromSignedUrlRequestDetails>,
    /// <p>Details about the import from Amazon S3 request.</p>
    pub import_assets_from_s3: std::option::Option<crate::model::ImportAssetsFromS3RequestDetails>,
    /// <p>Details from an import from Amazon Redshift datashare request.</p>
    pub import_assets_from_redshift_data_shares:
        std::option::Option<crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails>,
}
impl RequestDetails {
    /// <p>Details about the export to signed URL request.</p>
    pub fn export_asset_to_signed_url(
        &self,
    ) -> std::option::Option<&crate::model::ExportAssetToSignedUrlRequestDetails> {
        self.export_asset_to_signed_url.as_ref()
    }
    /// <p>Details about the export to Amazon S3 request.</p>
    pub fn export_assets_to_s3(
        &self,
    ) -> std::option::Option<&crate::model::ExportAssetsToS3RequestDetails> {
        self.export_assets_to_s3.as_ref()
    }
    /// <p>Details about the export to Amazon S3 request.</p>
    pub fn export_revisions_to_s3(
        &self,
    ) -> std::option::Option<&crate::model::ExportRevisionsToS3RequestDetails> {
        self.export_revisions_to_s3.as_ref()
    }
    /// <p>Details about the import from signed URL request.</p>
    pub fn import_asset_from_signed_url(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetFromSignedUrlRequestDetails> {
        self.import_asset_from_signed_url.as_ref()
    }
    /// <p>Details about the import from Amazon S3 request.</p>
    pub fn import_assets_from_s3(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetsFromS3RequestDetails> {
        self.import_assets_from_s3.as_ref()
    }
    /// <p>Details from an import from Amazon Redshift datashare request.</p>
    pub fn import_assets_from_redshift_data_shares(
        &self,
    ) -> std::option::Option<&crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails> {
        self.import_assets_from_redshift_data_shares.as_ref()
    }
}
impl std::fmt::Debug for RequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestDetails");
        formatter.field(
            "export_asset_to_signed_url",
            &self.export_asset_to_signed_url,
        );
        formatter.field("export_assets_to_s3", &self.export_assets_to_s3);
        formatter.field("export_revisions_to_s3", &self.export_revisions_to_s3);
        formatter.field(
            "import_asset_from_signed_url",
            &self.import_asset_from_signed_url,
        );
        formatter.field("import_assets_from_s3", &self.import_assets_from_s3);
        formatter.field(
            "import_assets_from_redshift_data_shares",
            &self.import_assets_from_redshift_data_shares,
        );
        formatter.finish()
    }
}
/// See [`RequestDetails`](crate::model::RequestDetails)
pub mod request_details {
    /// A builder for [`RequestDetails`](crate::model::RequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_asset_to_signed_url:
            std::option::Option<crate::model::ExportAssetToSignedUrlRequestDetails>,
        pub(crate) export_assets_to_s3:
            std::option::Option<crate::model::ExportAssetsToS3RequestDetails>,
        pub(crate) export_revisions_to_s3:
            std::option::Option<crate::model::ExportRevisionsToS3RequestDetails>,
        pub(crate) import_asset_from_signed_url:
            std::option::Option<crate::model::ImportAssetFromSignedUrlRequestDetails>,
        pub(crate) import_assets_from_s3:
            std::option::Option<crate::model::ImportAssetsFromS3RequestDetails>,
        pub(crate) import_assets_from_redshift_data_shares:
            std::option::Option<crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails>,
    }
    impl Builder {
        /// <p>Details about the export to signed URL request.</p>
        pub fn export_asset_to_signed_url(
            mut self,
            input: crate::model::ExportAssetToSignedUrlRequestDetails,
        ) -> Self {
            self.export_asset_to_signed_url = Some(input);
            self
        }
        /// <p>Details about the export to signed URL request.</p>
        pub fn set_export_asset_to_signed_url(
            mut self,
            input: std::option::Option<crate::model::ExportAssetToSignedUrlRequestDetails>,
        ) -> Self {
            self.export_asset_to_signed_url = input;
            self
        }
        /// <p>Details about the export to Amazon S3 request.</p>
        pub fn export_assets_to_s3(
            mut self,
            input: crate::model::ExportAssetsToS3RequestDetails,
        ) -> Self {
            self.export_assets_to_s3 = Some(input);
            self
        }
        /// <p>Details about the export to Amazon S3 request.</p>
        pub fn set_export_assets_to_s3(
            mut self,
            input: std::option::Option<crate::model::ExportAssetsToS3RequestDetails>,
        ) -> Self {
            self.export_assets_to_s3 = input;
            self
        }
        /// <p>Details about the export to Amazon S3 request.</p>
        pub fn export_revisions_to_s3(
            mut self,
            input: crate::model::ExportRevisionsToS3RequestDetails,
        ) -> Self {
            self.export_revisions_to_s3 = Some(input);
            self
        }
        /// <p>Details about the export to Amazon S3 request.</p>
        pub fn set_export_revisions_to_s3(
            mut self,
            input: std::option::Option<crate::model::ExportRevisionsToS3RequestDetails>,
        ) -> Self {
            self.export_revisions_to_s3 = input;
            self
        }
        /// <p>Details about the import from signed URL request.</p>
        pub fn import_asset_from_signed_url(
            mut self,
            input: crate::model::ImportAssetFromSignedUrlRequestDetails,
        ) -> Self {
            self.import_asset_from_signed_url = Some(input);
            self
        }
        /// <p>Details about the import from signed URL request.</p>
        pub fn set_import_asset_from_signed_url(
            mut self,
            input: std::option::Option<crate::model::ImportAssetFromSignedUrlRequestDetails>,
        ) -> Self {
            self.import_asset_from_signed_url = input;
            self
        }
        /// <p>Details about the import from Amazon S3 request.</p>
        pub fn import_assets_from_s3(
            mut self,
            input: crate::model::ImportAssetsFromS3RequestDetails,
        ) -> Self {
            self.import_assets_from_s3 = Some(input);
            self
        }
        /// <p>Details about the import from Amazon S3 request.</p>
        pub fn set_import_assets_from_s3(
            mut self,
            input: std::option::Option<crate::model::ImportAssetsFromS3RequestDetails>,
        ) -> Self {
            self.import_assets_from_s3 = input;
            self
        }
        /// <p>Details from an import from Amazon Redshift datashare request.</p>
        pub fn import_assets_from_redshift_data_shares(
            mut self,
            input: crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails,
        ) -> Self {
            self.import_assets_from_redshift_data_shares = Some(input);
            self
        }
        /// <p>Details from an import from Amazon Redshift datashare request.</p>
        pub fn set_import_assets_from_redshift_data_shares(
            mut self,
            input: std::option::Option<
                crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails,
            >,
        ) -> Self {
            self.import_assets_from_redshift_data_shares = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestDetails`](crate::model::RequestDetails)
        pub fn build(self) -> crate::model::RequestDetails {
            crate::model::RequestDetails {
                export_asset_to_signed_url: self.export_asset_to_signed_url,
                export_assets_to_s3: self.export_assets_to_s3,
                export_revisions_to_s3: self.export_revisions_to_s3,
                import_asset_from_signed_url: self.import_asset_from_signed_url,
                import_assets_from_s3: self.import_assets_from_s3,
                import_assets_from_redshift_data_shares: self
                    .import_assets_from_redshift_data_shares,
            }
        }
    }
}
impl RequestDetails {
    /// Creates a new builder-style object to manufacture [`RequestDetails`](crate::model::RequestDetails)
    pub fn builder() -> crate::model::request_details::Builder {
        crate::model::request_details::Builder::default()
    }
}

/// Details from an import from Amazon Redshift datashare request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetsFromRedshiftDataSharesRequestDetails {
    /// A list of Amazon Redshift datashare assets.
    pub asset_sources:
        std::option::Option<std::vec::Vec<crate::model::RedshiftDataShareAssetSourceEntry>>,
    /// The unique identifier for the data set associated with this import job.
    pub data_set_id: std::option::Option<std::string::String>,
    /// The unique identifier for the revision associated with this import job.
    pub revision_id: std::option::Option<std::string::String>,
}
impl ImportAssetsFromRedshiftDataSharesRequestDetails {
    /// A list of Amazon Redshift datashare assets.
    pub fn asset_sources(
        &self,
    ) -> std::option::Option<&[crate::model::RedshiftDataShareAssetSourceEntry]> {
        self.asset_sources.as_deref()
    }
    /// The unique identifier for the data set associated with this import job.
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// The unique identifier for the revision associated with this import job.
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ImportAssetsFromRedshiftDataSharesRequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetsFromRedshiftDataSharesRequestDetails");
        formatter.field("asset_sources", &self.asset_sources);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ImportAssetsFromRedshiftDataSharesRequestDetails`](crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails)
pub mod import_assets_from_redshift_data_shares_request_details {
    /// A builder for [`ImportAssetsFromRedshiftDataSharesRequestDetails`](crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_sources:
            std::option::Option<std::vec::Vec<crate::model::RedshiftDataShareAssetSourceEntry>>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_sources`.
        ///
        /// To override the contents of this collection use [`set_asset_sources`](Self::set_asset_sources).
        ///
        /// A list of Amazon Redshift datashare assets.
        pub fn asset_sources(
            mut self,
            input: impl Into<crate::model::RedshiftDataShareAssetSourceEntry>,
        ) -> Self {
            let mut v = self.asset_sources.unwrap_or_default();
            v.push(input.into());
            self.asset_sources = Some(v);
            self
        }
        /// A list of Amazon Redshift datashare assets.
        pub fn set_asset_sources(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RedshiftDataShareAssetSourceEntry>,
            >,
        ) -> Self {
            self.asset_sources = input;
            self
        }
        /// The unique identifier for the data set associated with this import job.
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// The unique identifier for the data set associated with this import job.
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// The unique identifier for the revision associated with this import job.
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// The unique identifier for the revision associated with this import job.
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetsFromRedshiftDataSharesRequestDetails`](crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails)
        pub fn build(self) -> crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails {
            crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails {
                asset_sources: self.asset_sources,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ImportAssetsFromRedshiftDataSharesRequestDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetsFromRedshiftDataSharesRequestDetails`](crate::model::ImportAssetsFromRedshiftDataSharesRequestDetails)
    pub fn builder(
    ) -> crate::model::import_assets_from_redshift_data_shares_request_details::Builder {
        crate::model::import_assets_from_redshift_data_shares_request_details::Builder::default()
    }
}

/// <p>Details of the operation to be performed by the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetsFromS3RequestDetails {
    /// <p>Is a list of S3 bucket and object key pairs.</p>
    pub asset_sources: std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this import request.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ImportAssetsFromS3RequestDetails {
    /// <p>Is a list of S3 bucket and object key pairs.</p>
    pub fn asset_sources(&self) -> std::option::Option<&[crate::model::AssetSourceEntry]> {
        self.asset_sources.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this import request.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ImportAssetsFromS3RequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetsFromS3RequestDetails");
        formatter.field("asset_sources", &self.asset_sources);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ImportAssetsFromS3RequestDetails`](crate::model::ImportAssetsFromS3RequestDetails)
pub mod import_assets_from_s3_request_details {
    /// A builder for [`ImportAssetsFromS3RequestDetails`](crate::model::ImportAssetsFromS3RequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_sources:
            std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_sources`.
        ///
        /// To override the contents of this collection use [`set_asset_sources`](Self::set_asset_sources).
        ///
        /// <p>Is a list of S3 bucket and object key pairs.</p>
        pub fn asset_sources(mut self, input: impl Into<crate::model::AssetSourceEntry>) -> Self {
            let mut v = self.asset_sources.unwrap_or_default();
            v.push(input.into());
            self.asset_sources = Some(v);
            self
        }
        /// <p>Is a list of S3 bucket and object key pairs.</p>
        pub fn set_asset_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetSourceEntry>>,
        ) -> Self {
            self.asset_sources = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this import request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this import request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetsFromS3RequestDetails`](crate::model::ImportAssetsFromS3RequestDetails)
        pub fn build(self) -> crate::model::ImportAssetsFromS3RequestDetails {
            crate::model::ImportAssetsFromS3RequestDetails {
                asset_sources: self.asset_sources,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ImportAssetsFromS3RequestDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetsFromS3RequestDetails`](crate::model::ImportAssetsFromS3RequestDetails)
    pub fn builder() -> crate::model::import_assets_from_s3_request_details::Builder {
        crate::model::import_assets_from_s3_request_details::Builder::default()
    }
}

/// <p>Details of the operation to be performed by the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAssetFromSignedUrlRequestDetails {
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
    pub md5_hash: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this import request.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ImportAssetFromSignedUrlRequestDetails {
    /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this import job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
    pub fn md5_hash(&self) -> std::option::Option<&str> {
        self.md5_hash.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this import request.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ImportAssetFromSignedUrlRequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAssetFromSignedUrlRequestDetails");
        formatter.field("asset_name", &self.asset_name);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("md5_hash", &self.md5_hash);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ImportAssetFromSignedUrlRequestDetails`](crate::model::ImportAssetFromSignedUrlRequestDetails)
pub mod import_asset_from_signed_url_request_details {
    /// A builder for [`ImportAssetFromSignedUrlRequestDetails`](crate::model::ImportAssetFromSignedUrlRequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) md5_hash: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this import job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
        pub fn md5_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_hash = Some(input.into());
            self
        }
        /// <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.</p>
        pub fn set_md5_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.md5_hash = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this import request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this import request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAssetFromSignedUrlRequestDetails`](crate::model::ImportAssetFromSignedUrlRequestDetails)
        pub fn build(self) -> crate::model::ImportAssetFromSignedUrlRequestDetails {
            crate::model::ImportAssetFromSignedUrlRequestDetails {
                asset_name: self.asset_name,
                data_set_id: self.data_set_id,
                md5_hash: self.md5_hash,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ImportAssetFromSignedUrlRequestDetails {
    /// Creates a new builder-style object to manufacture [`ImportAssetFromSignedUrlRequestDetails`](crate::model::ImportAssetFromSignedUrlRequestDetails)
    pub fn builder() -> crate::model::import_asset_from_signed_url_request_details::Builder {
        crate::model::import_asset_from_signed_url_request_details::Builder::default()
    }
}

/// <p>Details of the operation to be performed by the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportRevisionsToS3RequestDetails {
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>Encryption configuration for the export job.</p>
    pub encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
    /// <p>The destination for the revision.</p>
    pub revision_destinations:
        std::option::Option<std::vec::Vec<crate::model::RevisionDestinationEntry>>,
}
impl ExportRevisionsToS3RequestDetails {
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>Encryption configuration for the export job.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::ExportServerSideEncryption> {
        self.encryption.as_ref()
    }
    /// <p>The destination for the revision.</p>
    pub fn revision_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::RevisionDestinationEntry]> {
        self.revision_destinations.as_deref()
    }
}
impl std::fmt::Debug for ExportRevisionsToS3RequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportRevisionsToS3RequestDetails");
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("encryption", &self.encryption);
        formatter.field("revision_destinations", &self.revision_destinations);
        formatter.finish()
    }
}
/// See [`ExportRevisionsToS3RequestDetails`](crate::model::ExportRevisionsToS3RequestDetails)
pub mod export_revisions_to_s3_request_details {
    /// A builder for [`ExportRevisionsToS3RequestDetails`](crate::model::ExportRevisionsToS3RequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
        pub(crate) revision_destinations:
            std::option::Option<std::vec::Vec<crate::model::RevisionDestinationEntry>>,
    }
    impl Builder {
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>Encryption configuration for the export job.</p>
        pub fn encryption(mut self, input: crate::model::ExportServerSideEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Encryption configuration for the export job.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::ExportServerSideEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Appends an item to `revision_destinations`.
        ///
        /// To override the contents of this collection use [`set_revision_destinations`](Self::set_revision_destinations).
        ///
        /// <p>The destination for the revision.</p>
        pub fn revision_destinations(
            mut self,
            input: impl Into<crate::model::RevisionDestinationEntry>,
        ) -> Self {
            let mut v = self.revision_destinations.unwrap_or_default();
            v.push(input.into());
            self.revision_destinations = Some(v);
            self
        }
        /// <p>The destination for the revision.</p>
        pub fn set_revision_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionDestinationEntry>>,
        ) -> Self {
            self.revision_destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportRevisionsToS3RequestDetails`](crate::model::ExportRevisionsToS3RequestDetails)
        pub fn build(self) -> crate::model::ExportRevisionsToS3RequestDetails {
            crate::model::ExportRevisionsToS3RequestDetails {
                data_set_id: self.data_set_id,
                encryption: self.encryption,
                revision_destinations: self.revision_destinations,
            }
        }
    }
}
impl ExportRevisionsToS3RequestDetails {
    /// Creates a new builder-style object to manufacture [`ExportRevisionsToS3RequestDetails`](crate::model::ExportRevisionsToS3RequestDetails)
    pub fn builder() -> crate::model::export_revisions_to_s3_request_details::Builder {
        crate::model::export_revisions_to_s3_request_details::Builder::default()
    }
}

/// <p>Details of the operation to be performed by the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportAssetsToS3RequestDetails {
    /// <p>The destination for the asset.</p>
    pub asset_destinations: std::option::Option<std::vec::Vec<crate::model::AssetDestinationEntry>>,
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>Encryption configuration for the export job.</p>
    pub encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
    /// <p>The unique identifier for the revision associated with this export request.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ExportAssetsToS3RequestDetails {
    /// <p>The destination for the asset.</p>
    pub fn asset_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::AssetDestinationEntry]> {
        self.asset_destinations.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>Encryption configuration for the export job.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::ExportServerSideEncryption> {
        self.encryption.as_ref()
    }
    /// <p>The unique identifier for the revision associated with this export request.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ExportAssetsToS3RequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportAssetsToS3RequestDetails");
        formatter.field("asset_destinations", &self.asset_destinations);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("encryption", &self.encryption);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ExportAssetsToS3RequestDetails`](crate::model::ExportAssetsToS3RequestDetails)
pub mod export_assets_to_s3_request_details {
    /// A builder for [`ExportAssetsToS3RequestDetails`](crate::model::ExportAssetsToS3RequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_destinations:
            std::option::Option<std::vec::Vec<crate::model::AssetDestinationEntry>>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::ExportServerSideEncryption>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_destinations`.
        ///
        /// To override the contents of this collection use [`set_asset_destinations`](Self::set_asset_destinations).
        ///
        /// <p>The destination for the asset.</p>
        pub fn asset_destinations(
            mut self,
            input: impl Into<crate::model::AssetDestinationEntry>,
        ) -> Self {
            let mut v = self.asset_destinations.unwrap_or_default();
            v.push(input.into());
            self.asset_destinations = Some(v);
            self
        }
        /// <p>The destination for the asset.</p>
        pub fn set_asset_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetDestinationEntry>>,
        ) -> Self {
            self.asset_destinations = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>Encryption configuration for the export job.</p>
        pub fn encryption(mut self, input: crate::model::ExportServerSideEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Encryption configuration for the export job.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::ExportServerSideEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this export request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this export request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportAssetsToS3RequestDetails`](crate::model::ExportAssetsToS3RequestDetails)
        pub fn build(self) -> crate::model::ExportAssetsToS3RequestDetails {
            crate::model::ExportAssetsToS3RequestDetails {
                asset_destinations: self.asset_destinations,
                data_set_id: self.data_set_id,
                encryption: self.encryption,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ExportAssetsToS3RequestDetails {
    /// Creates a new builder-style object to manufacture [`ExportAssetsToS3RequestDetails`](crate::model::ExportAssetsToS3RequestDetails)
    pub fn builder() -> crate::model::export_assets_to_s3_request_details::Builder {
        crate::model::export_assets_to_s3_request_details::Builder::default()
    }
}

/// <p>Details of the operation to be performed by the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportAssetToSignedUrlRequestDetails {
    /// <p>The unique identifier for the asset that is exported to a signed URL.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the revision associated with this export request.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl ExportAssetToSignedUrlRequestDetails {
    /// <p>The unique identifier for the asset that is exported to a signed URL.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The unique identifier for the data set associated with this export job.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The unique identifier for the revision associated with this export request.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for ExportAssetToSignedUrlRequestDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportAssetToSignedUrlRequestDetails");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`ExportAssetToSignedUrlRequestDetails`](crate::model::ExportAssetToSignedUrlRequestDetails)
pub mod export_asset_to_signed_url_request_details {
    /// A builder for [`ExportAssetToSignedUrlRequestDetails`](crate::model::ExportAssetToSignedUrlRequestDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the asset that is exported to a signed URL.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the asset that is exported to a signed URL.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data set associated with this export job.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The unique identifier for the revision associated with this export request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the revision associated with this export request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportAssetToSignedUrlRequestDetails`](crate::model::ExportAssetToSignedUrlRequestDetails)
        pub fn build(self) -> crate::model::ExportAssetToSignedUrlRequestDetails {
            crate::model::ExportAssetToSignedUrlRequestDetails {
                asset_id: self.asset_id,
                data_set_id: self.data_set_id,
                revision_id: self.revision_id,
            }
        }
    }
}
impl ExportAssetToSignedUrlRequestDetails {
    /// Creates a new builder-style object to manufacture [`ExportAssetToSignedUrlRequestDetails`](crate::model::ExportAssetToSignedUrlRequestDetails)
    pub fn builder() -> crate::model::export_asset_to_signed_url_request_details::Builder {
        crate::model::export_asset_to_signed_url_request_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LimitName {
    #[allow(missing_docs)] // documentation missing in model
    AmazonRedshiftDatashareAssetsPerImportJobFromRedshift,
    #[allow(missing_docs)] // documentation missing in model
    AmazonRedshiftDatashareAssetsPerRevision,
    #[allow(missing_docs)] // documentation missing in model
    AssetPerExportJobFromAmazonS3,
    #[allow(missing_docs)] // documentation missing in model
    AssetSizeInGb,
    #[allow(missing_docs)] // documentation missing in model
    AssetsPerImportJobFromAmazonS3,
    #[allow(missing_docs)] // documentation missing in model
    AssetsPerRevision,
    #[allow(missing_docs)] // documentation missing in model
    AutoExportEventActionsPerDataSet,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInProgressJobsToExportAssetsToAmazonS3,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInProgressJobsToExportAssetsToASignedUrl,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInProgressJobsToExportRevisionsToAmazonS3,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInProgressJobsToImportAssetsFromAmazonRedshiftDatashares,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInProgressJobsToImportAssetsFromAmazonS3,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInProgressJobsToImportAssetsFromASignedUrl,
    #[allow(missing_docs)] // documentation missing in model
    DataSetsPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    DataSetsPerProduct,
    #[allow(missing_docs)] // documentation missing in model
    EventActionsPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    ProductsPerAccount,
    #[allow(missing_docs)] // documentation missing in model
    RevisionsPerAmazonRedshiftDatashareDataSet,
    #[allow(missing_docs)] // documentation missing in model
    RevisionsPerDataSet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LimitName {
    fn from(s: &str) -> Self {
        match s {
            "Amazon Redshift datashare assets per import job from Redshift" => {
                LimitName::AmazonRedshiftDatashareAssetsPerImportJobFromRedshift
            }
            "Amazon Redshift datashare assets per revision" => {
                LimitName::AmazonRedshiftDatashareAssetsPerRevision
            }
            "Asset per export job from Amazon S3" => LimitName::AssetPerExportJobFromAmazonS3,
            "Asset size in GB" => LimitName::AssetSizeInGb,
            "Assets per import job from Amazon S3" => LimitName::AssetsPerImportJobFromAmazonS3,
            "Assets per revision" => LimitName::AssetsPerRevision,
            "Auto export event actions per data set" => LimitName::AutoExportEventActionsPerDataSet,
            "Concurrent in progress jobs to export assets to Amazon S3" => {
                LimitName::ConcurrentInProgressJobsToExportAssetsToAmazonS3
            }
            "Concurrent in progress jobs to export assets to a signed URL" => {
                LimitName::ConcurrentInProgressJobsToExportAssetsToASignedUrl
            }
            "Concurrent in progress jobs to export revisions to Amazon S3" => {
                LimitName::ConcurrentInProgressJobsToExportRevisionsToAmazonS3
            }
            "Concurrent in progress jobs to import assets from Amazon Redshift datashares" => {
                LimitName::ConcurrentInProgressJobsToImportAssetsFromAmazonRedshiftDatashares
            }
            "Concurrent in progress jobs to import assets from Amazon S3" => {
                LimitName::ConcurrentInProgressJobsToImportAssetsFromAmazonS3
            }
            "Concurrent in progress jobs to import assets from a signed URL" => {
                LimitName::ConcurrentInProgressJobsToImportAssetsFromASignedUrl
            }
            "Data sets per account" => LimitName::DataSetsPerAccount,
            "Data sets per product" => LimitName::DataSetsPerProduct,
            "Event actions per account" => LimitName::EventActionsPerAccount,
            "Products per account" => LimitName::ProductsPerAccount,
            "Revisions per Amazon Redshift datashare data set" => {
                LimitName::RevisionsPerAmazonRedshiftDatashareDataSet
            }
            "Revisions per data set" => LimitName::RevisionsPerDataSet,
            other => LimitName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LimitName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LimitName::from(s))
    }
}
impl LimitName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LimitName::AmazonRedshiftDatashareAssetsPerImportJobFromRedshift => {
                "Amazon Redshift datashare assets per import job from Redshift"
            }
            LimitName::AmazonRedshiftDatashareAssetsPerRevision => {
                "Amazon Redshift datashare assets per revision"
            }
            LimitName::AssetPerExportJobFromAmazonS3 => "Asset per export job from Amazon S3",
            LimitName::AssetSizeInGb => "Asset size in GB",
            LimitName::AssetsPerImportJobFromAmazonS3 => "Assets per import job from Amazon S3",
            LimitName::AssetsPerRevision => "Assets per revision",
            LimitName::AutoExportEventActionsPerDataSet => "Auto export event actions per data set",
            LimitName::ConcurrentInProgressJobsToExportAssetsToAmazonS3 => {
                "Concurrent in progress jobs to export assets to Amazon S3"
            }
            LimitName::ConcurrentInProgressJobsToExportAssetsToASignedUrl => {
                "Concurrent in progress jobs to export assets to a signed URL"
            }
            LimitName::ConcurrentInProgressJobsToExportRevisionsToAmazonS3 => {
                "Concurrent in progress jobs to export revisions to Amazon S3"
            }
            LimitName::ConcurrentInProgressJobsToImportAssetsFromAmazonRedshiftDatashares => {
                "Concurrent in progress jobs to import assets from Amazon Redshift datashares"
            }
            LimitName::ConcurrentInProgressJobsToImportAssetsFromAmazonS3 => {
                "Concurrent in progress jobs to import assets from Amazon S3"
            }
            LimitName::ConcurrentInProgressJobsToImportAssetsFromASignedUrl => {
                "Concurrent in progress jobs to import assets from a signed URL"
            }
            LimitName::DataSetsPerAccount => "Data sets per account",
            LimitName::DataSetsPerProduct => "Data sets per product",
            LimitName::EventActionsPerAccount => "Event actions per account",
            LimitName::ProductsPerAccount => "Products per account",
            LimitName::RevisionsPerAmazonRedshiftDatashareDataSet => {
                "Revisions per Amazon Redshift datashare data set"
            }
            LimitName::RevisionsPerDataSet => "Revisions per data set",
            LimitName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Amazon Redshift datashare assets per import job from Redshift",
            "Amazon Redshift datashare assets per revision",
            "Asset per export job from Amazon S3",
            "Asset size in GB",
            "Assets per import job from Amazon S3",
            "Assets per revision",
            "Auto export event actions per data set",
            "Concurrent in progress jobs to export assets to Amazon S3",
            "Concurrent in progress jobs to export assets to a signed URL",
            "Concurrent in progress jobs to export revisions to Amazon S3",
            "Concurrent in progress jobs to import assets from Amazon Redshift datashares",
            "Concurrent in progress jobs to import assets from Amazon S3",
            "Concurrent in progress jobs to import assets from a signed URL",
            "Data sets per account",
            "Data sets per product",
            "Event actions per account",
            "Products per account",
            "Revisions per Amazon Redshift datashare data set",
            "Revisions per data set",
        ]
    }
}
impl AsRef<str> for LimitName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
