// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchDeleteRecipeVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_recipe_version`](crate::client::Client::batch_delete_recipe_version).
///
/// See [`crate::client::fluent_builders::BatchDeleteRecipeVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteRecipeVersion {
    _private: (),
}
impl BatchDeleteRecipeVersion {
    /// Creates a new builder-style object to manufacture [`BatchDeleteRecipeVersionInput`](crate::input::BatchDeleteRecipeVersionInput)
    pub fn builder() -> crate::input::batch_delete_recipe_version_input::Builder {
        crate::input::batch_delete_recipe_version_input::Builder::default()
    }
    /// Creates a new `BatchDeleteRecipeVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteRecipeVersion {
    type Output = std::result::Result<
        crate::output::BatchDeleteRecipeVersionOutput,
        crate::error::BatchDeleteRecipeVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_recipe_version_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_recipe_version_response(response)
        }
    }
}

/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateProfileJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_profile_job`](crate::client::Client::create_profile_job).
///
/// See [`crate::client::fluent_builders::CreateProfileJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProfileJob {
    _private: (),
}
impl CreateProfileJob {
    /// Creates a new builder-style object to manufacture [`CreateProfileJobInput`](crate::input::CreateProfileJobInput)
    pub fn builder() -> crate::input::create_profile_job_input::Builder {
        crate::input::create_profile_job_input::Builder::default()
    }
    /// Creates a new `CreateProfileJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProfileJob {
    type Output = std::result::Result<
        crate::output::CreateProfileJobOutput,
        crate::error::CreateProfileJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_profile_job_error(response)
        } else {
            crate::operation_deser::parse_create_profile_job_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `CreateRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_recipe`](crate::client::Client::create_recipe).
///
/// See [`crate::client::fluent_builders::CreateRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRecipe {
    _private: (),
}
impl CreateRecipe {
    /// Creates a new builder-style object to manufacture [`CreateRecipeInput`](crate::input::CreateRecipeInput)
    pub fn builder() -> crate::input::create_recipe_input::Builder {
        crate::input::create_recipe_input::Builder::default()
    }
    /// Creates a new `CreateRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRecipe {
    type Output =
        std::result::Result<crate::output::CreateRecipeOutput, crate::error::CreateRecipeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_recipe_error(response)
        } else {
            crate::operation_deser::parse_create_recipe_response(response)
        }
    }
}

/// Operation shape for `CreateRecipeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_recipe_job`](crate::client::Client::create_recipe_job).
///
/// See [`crate::client::fluent_builders::CreateRecipeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRecipeJob {
    _private: (),
}
impl CreateRecipeJob {
    /// Creates a new builder-style object to manufacture [`CreateRecipeJobInput`](crate::input::CreateRecipeJobInput)
    pub fn builder() -> crate::input::create_recipe_job_input::Builder {
        crate::input::create_recipe_job_input::Builder::default()
    }
    /// Creates a new `CreateRecipeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRecipeJob {
    type Output = std::result::Result<
        crate::output::CreateRecipeJobOutput,
        crate::error::CreateRecipeJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_recipe_job_error(response)
        } else {
            crate::operation_deser::parse_create_recipe_job_response(response)
        }
    }
}

/// Operation shape for `CreateRuleset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ruleset`](crate::client::Client::create_ruleset).
///
/// See [`crate::client::fluent_builders::CreateRuleset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRuleset {
    _private: (),
}
impl CreateRuleset {
    /// Creates a new builder-style object to manufacture [`CreateRulesetInput`](crate::input::CreateRulesetInput)
    pub fn builder() -> crate::input::create_ruleset_input::Builder {
        crate::input::create_ruleset_input::Builder::default()
    }
    /// Creates a new `CreateRuleset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRuleset {
    type Output =
        std::result::Result<crate::output::CreateRulesetOutput, crate::error::CreateRulesetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ruleset_error(response)
        } else {
            crate::operation_deser::parse_create_ruleset_response(response)
        }
    }
}

/// Operation shape for `CreateSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_schedule`](crate::client::Client::create_schedule).
///
/// See [`crate::client::fluent_builders::CreateSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSchedule {
    _private: (),
}
impl CreateSchedule {
    /// Creates a new builder-style object to manufacture [`CreateScheduleInput`](crate::input::CreateScheduleInput)
    pub fn builder() -> crate::input::create_schedule_input::Builder {
        crate::input::create_schedule_input::Builder::default()
    }
    /// Creates a new `CreateSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSchedule {
    type Output =
        std::result::Result<crate::output::CreateScheduleOutput, crate::error::CreateScheduleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_schedule_error(response)
        } else {
            crate::operation_deser::parse_create_schedule_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeleteJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job`](crate::client::Client::delete_job).
///
/// See [`crate::client::fluent_builders::DeleteJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJob {
    _private: (),
}
impl DeleteJob {
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
    /// Creates a new `DeleteJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJob {
    type Output = std::result::Result<crate::output::DeleteJobOutput, crate::error::DeleteJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_error(response)
        } else {
            crate::operation_deser::parse_delete_job_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DeleteRecipeVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recipe_version`](crate::client::Client::delete_recipe_version).
///
/// See [`crate::client::fluent_builders::DeleteRecipeVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecipeVersion {
    _private: (),
}
impl DeleteRecipeVersion {
    /// Creates a new builder-style object to manufacture [`DeleteRecipeVersionInput`](crate::input::DeleteRecipeVersionInput)
    pub fn builder() -> crate::input::delete_recipe_version_input::Builder {
        crate::input::delete_recipe_version_input::Builder::default()
    }
    /// Creates a new `DeleteRecipeVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecipeVersion {
    type Output = std::result::Result<
        crate::output::DeleteRecipeVersionOutput,
        crate::error::DeleteRecipeVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_recipe_version_error(response)
        } else {
            crate::operation_deser::parse_delete_recipe_version_response(response)
        }
    }
}

/// Operation shape for `DeleteRuleset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ruleset`](crate::client::Client::delete_ruleset).
///
/// See [`crate::client::fluent_builders::DeleteRuleset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRuleset {
    _private: (),
}
impl DeleteRuleset {
    /// Creates a new builder-style object to manufacture [`DeleteRulesetInput`](crate::input::DeleteRulesetInput)
    pub fn builder() -> crate::input::delete_ruleset_input::Builder {
        crate::input::delete_ruleset_input::Builder::default()
    }
    /// Creates a new `DeleteRuleset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRuleset {
    type Output =
        std::result::Result<crate::output::DeleteRulesetOutput, crate::error::DeleteRulesetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ruleset_error(response)
        } else {
            crate::operation_deser::parse_delete_ruleset_response(response)
        }
    }
}

/// Operation shape for `DeleteSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schedule`](crate::client::Client::delete_schedule).
///
/// See [`crate::client::fluent_builders::DeleteSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchedule {
    _private: (),
}
impl DeleteSchedule {
    /// Creates a new builder-style object to manufacture [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
    pub fn builder() -> crate::input::delete_schedule_input::Builder {
        crate::input::delete_schedule_input::Builder::default()
    }
    /// Creates a new `DeleteSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchedule {
    type Output =
        std::result::Result<crate::output::DeleteScheduleOutput, crate::error::DeleteScheduleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_schedule_error(response)
        } else {
            crate::operation_deser::parse_delete_schedule_response(response)
        }
    }
}

/// Operation shape for `DescribeDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset`](crate::client::Client::describe_dataset).
///
/// See [`crate::client::fluent_builders::DescribeDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataset {
    _private: (),
}
impl DescribeDataset {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
    /// Creates a new `DescribeDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataset {
    type Output = std::result::Result<
        crate::output::DescribeDatasetOutput,
        crate::error::DescribeDatasetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_response(response)
        }
    }
}

/// Operation shape for `DescribeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job`](crate::client::Client::describe_job).
///
/// See [`crate::client::fluent_builders::DescribeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJob {
    _private: (),
}
impl DescribeJob {
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
    /// Creates a new `DescribeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJob {
    type Output =
        std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_error(response)
        } else {
            crate::operation_deser::parse_describe_job_response(response)
        }
    }
}

/// Operation shape for `DescribeJobRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job_run`](crate::client::Client::describe_job_run).
///
/// See [`crate::client::fluent_builders::DescribeJobRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJobRun {
    _private: (),
}
impl DescribeJobRun {
    /// Creates a new builder-style object to manufacture [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
    pub fn builder() -> crate::input::describe_job_run_input::Builder {
        crate::input::describe_job_run_input::Builder::default()
    }
    /// Creates a new `DescribeJobRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJobRun {
    type Output =
        std::result::Result<crate::output::DescribeJobRunOutput, crate::error::DescribeJobRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_run_error(response)
        } else {
            crate::operation_deser::parse_describe_job_run_response(response)
        }
    }
}

/// Operation shape for `DescribeProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_project`](crate::client::Client::describe_project).
///
/// See [`crate::client::fluent_builders::DescribeProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProject {
    _private: (),
}
impl DescribeProject {
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
    /// Creates a new `DescribeProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProject {
    type Output = std::result::Result<
        crate::output::DescribeProjectOutput,
        crate::error::DescribeProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_project_error(response)
        } else {
            crate::operation_deser::parse_describe_project_response(response)
        }
    }
}

/// Operation shape for `DescribeRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_recipe`](crate::client::Client::describe_recipe).
///
/// See [`crate::client::fluent_builders::DescribeRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRecipe {
    _private: (),
}
impl DescribeRecipe {
    /// Creates a new builder-style object to manufacture [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
    pub fn builder() -> crate::input::describe_recipe_input::Builder {
        crate::input::describe_recipe_input::Builder::default()
    }
    /// Creates a new `DescribeRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRecipe {
    type Output =
        std::result::Result<crate::output::DescribeRecipeOutput, crate::error::DescribeRecipeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_recipe_error(response)
        } else {
            crate::operation_deser::parse_describe_recipe_response(response)
        }
    }
}

/// Operation shape for `DescribeRuleset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ruleset`](crate::client::Client::describe_ruleset).
///
/// See [`crate::client::fluent_builders::DescribeRuleset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRuleset {
    _private: (),
}
impl DescribeRuleset {
    /// Creates a new builder-style object to manufacture [`DescribeRulesetInput`](crate::input::DescribeRulesetInput)
    pub fn builder() -> crate::input::describe_ruleset_input::Builder {
        crate::input::describe_ruleset_input::Builder::default()
    }
    /// Creates a new `DescribeRuleset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRuleset {
    type Output = std::result::Result<
        crate::output::DescribeRulesetOutput,
        crate::error::DescribeRulesetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ruleset_error(response)
        } else {
            crate::operation_deser::parse_describe_ruleset_response(response)
        }
    }
}

/// Operation shape for `DescribeSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_schedule`](crate::client::Client::describe_schedule).
///
/// See [`crate::client::fluent_builders::DescribeSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSchedule {
    _private: (),
}
impl DescribeSchedule {
    /// Creates a new builder-style object to manufacture [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
    pub fn builder() -> crate::input::describe_schedule_input::Builder {
        crate::input::describe_schedule_input::Builder::default()
    }
    /// Creates a new `DescribeSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSchedule {
    type Output = std::result::Result<
        crate::output::DescribeScheduleOutput,
        crate::error::DescribeScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_schedule_error(response)
        } else {
            crate::operation_deser::parse_describe_schedule_response(response)
        }
    }
}

/// Operation shape for `ListDatasets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_datasets`](crate::client::Client::list_datasets).
///
/// See [`crate::client::fluent_builders::ListDatasets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasets {
    _private: (),
}
impl ListDatasets {
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
    /// Creates a new `ListDatasets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasets {
    type Output =
        std::result::Result<crate::output::ListDatasetsOutput, crate::error::ListDatasetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_datasets_error(response)
        } else {
            crate::operation_deser::parse_list_datasets_response(response)
        }
    }
}

/// Operation shape for `ListJobRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_job_runs`](crate::client::Client::list_job_runs).
///
/// See [`crate::client::fluent_builders::ListJobRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobRuns {
    _private: (),
}
impl ListJobRuns {
    /// Creates a new builder-style object to manufacture [`ListJobRunsInput`](crate::input::ListJobRunsInput)
    pub fn builder() -> crate::input::list_job_runs_input::Builder {
        crate::input::list_job_runs_input::Builder::default()
    }
    /// Creates a new `ListJobRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobRuns {
    type Output =
        std::result::Result<crate::output::ListJobRunsOutput, crate::error::ListJobRunsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_job_runs_error(response)
        } else {
            crate::operation_deser::parse_list_job_runs_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListRecipes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recipes`](crate::client::Client::list_recipes).
///
/// See [`crate::client::fluent_builders::ListRecipes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecipes {
    _private: (),
}
impl ListRecipes {
    /// Creates a new builder-style object to manufacture [`ListRecipesInput`](crate::input::ListRecipesInput)
    pub fn builder() -> crate::input::list_recipes_input::Builder {
        crate::input::list_recipes_input::Builder::default()
    }
    /// Creates a new `ListRecipes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecipes {
    type Output =
        std::result::Result<crate::output::ListRecipesOutput, crate::error::ListRecipesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recipes_error(response)
        } else {
            crate::operation_deser::parse_list_recipes_response(response)
        }
    }
}

/// Operation shape for `ListRecipeVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recipe_versions`](crate::client::Client::list_recipe_versions).
///
/// See [`crate::client::fluent_builders::ListRecipeVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecipeVersions {
    _private: (),
}
impl ListRecipeVersions {
    /// Creates a new builder-style object to manufacture [`ListRecipeVersionsInput`](crate::input::ListRecipeVersionsInput)
    pub fn builder() -> crate::input::list_recipe_versions_input::Builder {
        crate::input::list_recipe_versions_input::Builder::default()
    }
    /// Creates a new `ListRecipeVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecipeVersions {
    type Output = std::result::Result<
        crate::output::ListRecipeVersionsOutput,
        crate::error::ListRecipeVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recipe_versions_error(response)
        } else {
            crate::operation_deser::parse_list_recipe_versions_response(response)
        }
    }
}

/// Operation shape for `ListRulesets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rulesets`](crate::client::Client::list_rulesets).
///
/// See [`crate::client::fluent_builders::ListRulesets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRulesets {
    _private: (),
}
impl ListRulesets {
    /// Creates a new builder-style object to manufacture [`ListRulesetsInput`](crate::input::ListRulesetsInput)
    pub fn builder() -> crate::input::list_rulesets_input::Builder {
        crate::input::list_rulesets_input::Builder::default()
    }
    /// Creates a new `ListRulesets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRulesets {
    type Output =
        std::result::Result<crate::output::ListRulesetsOutput, crate::error::ListRulesetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rulesets_error(response)
        } else {
            crate::operation_deser::parse_list_rulesets_response(response)
        }
    }
}

/// Operation shape for `ListSchedules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schedules`](crate::client::Client::list_schedules).
///
/// See [`crate::client::fluent_builders::ListSchedules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchedules {
    _private: (),
}
impl ListSchedules {
    /// Creates a new builder-style object to manufacture [`ListSchedulesInput`](crate::input::ListSchedulesInput)
    pub fn builder() -> crate::input::list_schedules_input::Builder {
        crate::input::list_schedules_input::Builder::default()
    }
    /// Creates a new `ListSchedules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchedules {
    type Output =
        std::result::Result<crate::output::ListSchedulesOutput, crate::error::ListSchedulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schedules_error(response)
        } else {
            crate::operation_deser::parse_list_schedules_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PublishRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_recipe`](crate::client::Client::publish_recipe).
///
/// See [`crate::client::fluent_builders::PublishRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishRecipe {
    _private: (),
}
impl PublishRecipe {
    /// Creates a new builder-style object to manufacture [`PublishRecipeInput`](crate::input::PublishRecipeInput)
    pub fn builder() -> crate::input::publish_recipe_input::Builder {
        crate::input::publish_recipe_input::Builder::default()
    }
    /// Creates a new `PublishRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishRecipe {
    type Output =
        std::result::Result<crate::output::PublishRecipeOutput, crate::error::PublishRecipeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_recipe_error(response)
        } else {
            crate::operation_deser::parse_publish_recipe_response(response)
        }
    }
}

/// Operation shape for `SendProjectSessionAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_project_session_action`](crate::client::Client::send_project_session_action).
///
/// See [`crate::client::fluent_builders::SendProjectSessionAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendProjectSessionAction {
    _private: (),
}
impl SendProjectSessionAction {
    /// Creates a new builder-style object to manufacture [`SendProjectSessionActionInput`](crate::input::SendProjectSessionActionInput)
    pub fn builder() -> crate::input::send_project_session_action_input::Builder {
        crate::input::send_project_session_action_input::Builder::default()
    }
    /// Creates a new `SendProjectSessionAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendProjectSessionAction {
    type Output = std::result::Result<
        crate::output::SendProjectSessionActionOutput,
        crate::error::SendProjectSessionActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_project_session_action_error(response)
        } else {
            crate::operation_deser::parse_send_project_session_action_response(response)
        }
    }
}

/// Operation shape for `StartJobRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_job_run`](crate::client::Client::start_job_run).
///
/// See [`crate::client::fluent_builders::StartJobRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartJobRun {
    _private: (),
}
impl StartJobRun {
    /// Creates a new builder-style object to manufacture [`StartJobRunInput`](crate::input::StartJobRunInput)
    pub fn builder() -> crate::input::start_job_run_input::Builder {
        crate::input::start_job_run_input::Builder::default()
    }
    /// Creates a new `StartJobRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartJobRun {
    type Output =
        std::result::Result<crate::output::StartJobRunOutput, crate::error::StartJobRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_job_run_error(response)
        } else {
            crate::operation_deser::parse_start_job_run_response(response)
        }
    }
}

/// Operation shape for `StartProjectSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_project_session`](crate::client::Client::start_project_session).
///
/// See [`crate::client::fluent_builders::StartProjectSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartProjectSession {
    _private: (),
}
impl StartProjectSession {
    /// Creates a new builder-style object to manufacture [`StartProjectSessionInput`](crate::input::StartProjectSessionInput)
    pub fn builder() -> crate::input::start_project_session_input::Builder {
        crate::input::start_project_session_input::Builder::default()
    }
    /// Creates a new `StartProjectSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartProjectSession {
    type Output = std::result::Result<
        crate::output::StartProjectSessionOutput,
        crate::error::StartProjectSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_project_session_error(response)
        } else {
            crate::operation_deser::parse_start_project_session_response(response)
        }
    }
}

/// Operation shape for `StopJobRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_job_run`](crate::client::Client::stop_job_run).
///
/// See [`crate::client::fluent_builders::StopJobRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopJobRun {
    _private: (),
}
impl StopJobRun {
    /// Creates a new builder-style object to manufacture [`StopJobRunInput`](crate::input::StopJobRunInput)
    pub fn builder() -> crate::input::stop_job_run_input::Builder {
        crate::input::stop_job_run_input::Builder::default()
    }
    /// Creates a new `StopJobRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopJobRun {
    type Output =
        std::result::Result<crate::output::StopJobRunOutput, crate::error::StopJobRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_job_run_error(response)
        } else {
            crate::operation_deser::parse_stop_job_run_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dataset`](crate::client::Client::update_dataset).
///
/// See [`crate::client::fluent_builders::UpdateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataset {
    _private: (),
}
impl UpdateDataset {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    pub fn builder() -> crate::input::update_dataset_input::Builder {
        crate::input::update_dataset_input::Builder::default()
    }
    /// Creates a new `UpdateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataset {
    type Output =
        std::result::Result<crate::output::UpdateDatasetOutput, crate::error::UpdateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dataset_error(response)
        } else {
            crate::operation_deser::parse_update_dataset_response(response)
        }
    }
}

/// Operation shape for `UpdateProfileJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_profile_job`](crate::client::Client::update_profile_job).
///
/// See [`crate::client::fluent_builders::UpdateProfileJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProfileJob {
    _private: (),
}
impl UpdateProfileJob {
    /// Creates a new builder-style object to manufacture [`UpdateProfileJobInput`](crate::input::UpdateProfileJobInput)
    pub fn builder() -> crate::input::update_profile_job_input::Builder {
        crate::input::update_profile_job_input::Builder::default()
    }
    /// Creates a new `UpdateProfileJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProfileJob {
    type Output = std::result::Result<
        crate::output::UpdateProfileJobOutput,
        crate::error::UpdateProfileJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_profile_job_error(response)
        } else {
            crate::operation_deser::parse_update_profile_job_response(response)
        }
    }
}

/// Operation shape for `UpdateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project`](crate::client::Client::update_project).
///
/// See [`crate::client::fluent_builders::UpdateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProject {
    _private: (),
}
impl UpdateProject {
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
    /// Creates a new `UpdateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProject {
    type Output =
        std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_error(response)
        } else {
            crate::operation_deser::parse_update_project_response(response)
        }
    }
}

/// Operation shape for `UpdateRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_recipe`](crate::client::Client::update_recipe).
///
/// See [`crate::client::fluent_builders::UpdateRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRecipe {
    _private: (),
}
impl UpdateRecipe {
    /// Creates a new builder-style object to manufacture [`UpdateRecipeInput`](crate::input::UpdateRecipeInput)
    pub fn builder() -> crate::input::update_recipe_input::Builder {
        crate::input::update_recipe_input::Builder::default()
    }
    /// Creates a new `UpdateRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRecipe {
    type Output =
        std::result::Result<crate::output::UpdateRecipeOutput, crate::error::UpdateRecipeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_recipe_error(response)
        } else {
            crate::operation_deser::parse_update_recipe_response(response)
        }
    }
}

/// Operation shape for `UpdateRecipeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_recipe_job`](crate::client::Client::update_recipe_job).
///
/// See [`crate::client::fluent_builders::UpdateRecipeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRecipeJob {
    _private: (),
}
impl UpdateRecipeJob {
    /// Creates a new builder-style object to manufacture [`UpdateRecipeJobInput`](crate::input::UpdateRecipeJobInput)
    pub fn builder() -> crate::input::update_recipe_job_input::Builder {
        crate::input::update_recipe_job_input::Builder::default()
    }
    /// Creates a new `UpdateRecipeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRecipeJob {
    type Output = std::result::Result<
        crate::output::UpdateRecipeJobOutput,
        crate::error::UpdateRecipeJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_recipe_job_error(response)
        } else {
            crate::operation_deser::parse_update_recipe_job_response(response)
        }
    }
}

/// Operation shape for `UpdateRuleset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ruleset`](crate::client::Client::update_ruleset).
///
/// See [`crate::client::fluent_builders::UpdateRuleset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuleset {
    _private: (),
}
impl UpdateRuleset {
    /// Creates a new builder-style object to manufacture [`UpdateRulesetInput`](crate::input::UpdateRulesetInput)
    pub fn builder() -> crate::input::update_ruleset_input::Builder {
        crate::input::update_ruleset_input::Builder::default()
    }
    /// Creates a new `UpdateRuleset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuleset {
    type Output =
        std::result::Result<crate::output::UpdateRulesetOutput, crate::error::UpdateRulesetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ruleset_error(response)
        } else {
            crate::operation_deser::parse_update_ruleset_response(response)
        }
    }
}

/// Operation shape for `UpdateSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_schedule`](crate::client::Client::update_schedule).
///
/// See [`crate::client::fluent_builders::UpdateSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSchedule {
    _private: (),
}
impl UpdateSchedule {
    /// Creates a new builder-style object to manufacture [`UpdateScheduleInput`](crate::input::UpdateScheduleInput)
    pub fn builder() -> crate::input::update_schedule_input::Builder {
        crate::input::update_schedule_input::Builder::default()
    }
    /// Creates a new `UpdateSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSchedule {
    type Output =
        std::result::Result<crate::output::UpdateScheduleOutput, crate::error::UpdateScheduleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_schedule_error(response)
        } else {
            crate::operation_deser::parse_update_schedule_response(response)
        }
    }
}
