// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScheduleOutput {
    /// <p>The name of the schedule that was updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateScheduleOutput {
    /// <p>The name of the schedule that was updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScheduleOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateScheduleOutput`](crate::output::UpdateScheduleOutput)
pub mod update_schedule_output {
    /// A builder for [`UpdateScheduleOutput`](crate::output::UpdateScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the schedule that was updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule that was updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScheduleOutput`](crate::output::UpdateScheduleOutput)
        pub fn build(self) -> crate::output::UpdateScheduleOutput {
            crate::output::UpdateScheduleOutput { name: self.name }
        }
    }
}
impl UpdateScheduleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateScheduleOutput`](crate::output::UpdateScheduleOutput)
    pub fn builder() -> crate::output::update_schedule_output::Builder {
        crate::output::update_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRulesetOutput {
    /// <p>The name of the updated ruleset.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateRulesetOutput {
    /// <p>The name of the updated ruleset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateRulesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRulesetOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateRulesetOutput`](crate::output::UpdateRulesetOutput)
pub mod update_ruleset_output {
    /// A builder for [`UpdateRulesetOutput`](crate::output::UpdateRulesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the updated ruleset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the updated ruleset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRulesetOutput`](crate::output::UpdateRulesetOutput)
        pub fn build(self) -> crate::output::UpdateRulesetOutput {
            crate::output::UpdateRulesetOutput { name: self.name }
        }
    }
}
impl UpdateRulesetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRulesetOutput`](crate::output::UpdateRulesetOutput)
    pub fn builder() -> crate::output::update_ruleset_output::Builder {
        crate::output::update_ruleset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecipeJobOutput {
    /// <p>The name of the job that you updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateRecipeJobOutput {
    /// <p>The name of the job that you updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateRecipeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecipeJobOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateRecipeJobOutput`](crate::output::UpdateRecipeJobOutput)
pub mod update_recipe_job_output {
    /// A builder for [`UpdateRecipeJobOutput`](crate::output::UpdateRecipeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job that you updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job that you updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecipeJobOutput`](crate::output::UpdateRecipeJobOutput)
        pub fn build(self) -> crate::output::UpdateRecipeJobOutput {
            crate::output::UpdateRecipeJobOutput { name: self.name }
        }
    }
}
impl UpdateRecipeJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRecipeJobOutput`](crate::output::UpdateRecipeJobOutput)
    pub fn builder() -> crate::output::update_recipe_job_output::Builder {
        crate::output::update_recipe_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecipeOutput {
    /// <p>The name of the recipe that was updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateRecipeOutput {
    /// <p>The name of the recipe that was updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecipeOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateRecipeOutput`](crate::output::UpdateRecipeOutput)
pub mod update_recipe_output {
    /// A builder for [`UpdateRecipeOutput`](crate::output::UpdateRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe that was updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe that was updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecipeOutput`](crate::output::UpdateRecipeOutput)
        pub fn build(self) -> crate::output::UpdateRecipeOutput {
            crate::output::UpdateRecipeOutput { name: self.name }
        }
    }
}
impl UpdateRecipeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRecipeOutput`](crate::output::UpdateRecipeOutput)
    pub fn builder() -> crate::output::update_recipe_output::Builder {
        crate::output::update_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {
    /// <p>The date and time that the project was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the project that you updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateProjectOutput {
    /// <p>The date and time that the project was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The name of the project that you updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time that the project was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time that the project was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The name of the project that you updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project that you updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {
                last_modified_date: self.last_modified_date,
                name: self.name,
            }
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfileJobOutput {
    /// <p>The name of the job that was updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateProfileJobOutput {
    /// <p>The name of the job that was updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateProfileJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfileJobOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateProfileJobOutput`](crate::output::UpdateProfileJobOutput)
pub mod update_profile_job_output {
    /// A builder for [`UpdateProfileJobOutput`](crate::output::UpdateProfileJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job that was updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job that was updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfileJobOutput`](crate::output::UpdateProfileJobOutput)
        pub fn build(self) -> crate::output::UpdateProfileJobOutput {
            crate::output::UpdateProfileJobOutput { name: self.name }
        }
    }
}
impl UpdateProfileJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProfileJobOutput`](crate::output::UpdateProfileJobOutput)
    pub fn builder() -> crate::output::update_profile_job_output::Builder {
        crate::output::update_profile_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetOutput {
    /// <p>The name of the dataset that you updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateDatasetOutput {
    /// <p>The name of the dataset that you updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
pub mod update_dataset_output {
    /// A builder for [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset that you updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset that you updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
        pub fn build(self) -> crate::output::UpdateDatasetOutput {
            crate::output::UpdateDatasetOutput { name: self.name }
        }
    }
}
impl UpdateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)
    pub fn builder() -> crate::output::update_dataset_output::Builder {
        crate::output::update_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopJobRunOutput {
    /// <p>The ID of the job run that you stopped.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl StopJobRunOutput {
    /// <p>The ID of the job run that you stopped.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
}
impl std::fmt::Debug for StopJobRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopJobRunOutput");
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`StopJobRunOutput`](crate::output::StopJobRunOutput)
pub mod stop_job_run_output {
    /// A builder for [`StopJobRunOutput`](crate::output::StopJobRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the job run that you stopped.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The ID of the job run that you stopped.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopJobRunOutput`](crate::output::StopJobRunOutput)
        pub fn build(self) -> crate::output::StopJobRunOutput {
            crate::output::StopJobRunOutput {
                run_id: self.run_id,
            }
        }
    }
}
impl StopJobRunOutput {
    /// Creates a new builder-style object to manufacture [`StopJobRunOutput`](crate::output::StopJobRunOutput)
    pub fn builder() -> crate::output::stop_job_run_output::Builder {
        crate::output::stop_job_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartProjectSessionOutput {
    /// <p>The name of the project to be acted upon.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A system-generated identifier for the session.</p>
    pub client_session_id: std::option::Option<std::string::String>,
}
impl StartProjectSessionOutput {
    /// <p>The name of the project to be acted upon.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A system-generated identifier for the session.</p>
    pub fn client_session_id(&self) -> std::option::Option<&str> {
        self.client_session_id.as_deref()
    }
}
impl std::fmt::Debug for StartProjectSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartProjectSessionOutput");
        formatter.field("name", &self.name);
        formatter.field("client_session_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`StartProjectSessionOutput`](crate::output::StartProjectSessionOutput)
pub mod start_project_session_output {
    /// A builder for [`StartProjectSessionOutput`](crate::output::StartProjectSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) client_session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project to be acted upon.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project to be acted upon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A system-generated identifier for the session.</p>
        pub fn client_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_session_id = Some(input.into());
            self
        }
        /// <p>A system-generated identifier for the session.</p>
        pub fn set_client_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartProjectSessionOutput`](crate::output::StartProjectSessionOutput)
        pub fn build(self) -> crate::output::StartProjectSessionOutput {
            crate::output::StartProjectSessionOutput {
                name: self.name,
                client_session_id: self.client_session_id,
            }
        }
    }
}
impl StartProjectSessionOutput {
    /// Creates a new builder-style object to manufacture [`StartProjectSessionOutput`](crate::output::StartProjectSessionOutput)
    pub fn builder() -> crate::output::start_project_session_output::Builder {
        crate::output::start_project_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobRunOutput {
    /// <p>A system-generated identifier for this particular job run.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl StartJobRunOutput {
    /// <p>A system-generated identifier for this particular job run.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
}
impl std::fmt::Debug for StartJobRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobRunOutput");
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`StartJobRunOutput`](crate::output::StartJobRunOutput)
pub mod start_job_run_output {
    /// A builder for [`StartJobRunOutput`](crate::output::StartJobRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-generated identifier for this particular job run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>A system-generated identifier for this particular job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobRunOutput`](crate::output::StartJobRunOutput)
        pub fn build(self) -> crate::output::StartJobRunOutput {
            crate::output::StartJobRunOutput {
                run_id: self.run_id,
            }
        }
    }
}
impl StartJobRunOutput {
    /// Creates a new builder-style object to manufacture [`StartJobRunOutput`](crate::output::StartJobRunOutput)
    pub fn builder() -> crate::output::start_job_run_output::Builder {
        crate::output::start_job_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendProjectSessionActionOutput {
    /// <p>A message indicating the result of performing the action.</p>
    pub result: std::option::Option<std::string::String>,
    /// <p>The name of the project that was affected by the action.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the action that was performed.</p>
    pub action_id: std::option::Option<i32>,
}
impl SendProjectSessionActionOutput {
    /// <p>A message indicating the result of performing the action.</p>
    pub fn result(&self) -> std::option::Option<&str> {
        self.result.as_deref()
    }
    /// <p>The name of the project that was affected by the action.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A unique identifier for the action that was performed.</p>
    pub fn action_id(&self) -> std::option::Option<i32> {
        self.action_id
    }
}
impl std::fmt::Debug for SendProjectSessionActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendProjectSessionActionOutput");
        formatter.field("result", &self.result);
        formatter.field("name", &self.name);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}
/// See [`SendProjectSessionActionOutput`](crate::output::SendProjectSessionActionOutput)
pub mod send_project_session_action_output {
    /// A builder for [`SendProjectSessionActionOutput`](crate::output::SendProjectSessionActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A message indicating the result of performing the action.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>A message indicating the result of performing the action.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// <p>The name of the project that was affected by the action.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project that was affected by the action.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the action that was performed.</p>
        pub fn action_id(mut self, input: i32) -> Self {
            self.action_id = Some(input);
            self
        }
        /// <p>A unique identifier for the action that was performed.</p>
        pub fn set_action_id(mut self, input: std::option::Option<i32>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendProjectSessionActionOutput`](crate::output::SendProjectSessionActionOutput)
        pub fn build(self) -> crate::output::SendProjectSessionActionOutput {
            crate::output::SendProjectSessionActionOutput {
                result: self.result,
                name: self.name,
                action_id: self.action_id,
            }
        }
    }
}
impl SendProjectSessionActionOutput {
    /// Creates a new builder-style object to manufacture [`SendProjectSessionActionOutput`](crate::output::SendProjectSessionActionOutput)
    pub fn builder() -> crate::output::send_project_session_action_output::Builder {
        crate::output::send_project_session_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishRecipeOutput {
    /// <p>The name of the recipe that you published.</p>
    pub name: std::option::Option<std::string::String>,
}
impl PublishRecipeOutput {
    /// <p>The name of the recipe that you published.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for PublishRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishRecipeOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PublishRecipeOutput`](crate::output::PublishRecipeOutput)
pub mod publish_recipe_output {
    /// A builder for [`PublishRecipeOutput`](crate::output::PublishRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe that you published.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe that you published.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishRecipeOutput`](crate::output::PublishRecipeOutput)
        pub fn build(self) -> crate::output::PublishRecipeOutput {
            crate::output::PublishRecipeOutput { name: self.name }
        }
    }
}
impl PublishRecipeOutput {
    /// Creates a new builder-style object to manufacture [`PublishRecipeOutput`](crate::output::PublishRecipeOutput)
    pub fn builder() -> crate::output::publish_recipe_output::Builder {
        crate::output::publish_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags associated with the DataBrew resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tags associated with the DataBrew resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the DataBrew resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the DataBrew resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchedulesOutput {
    /// <p>A list of schedules that are defined.</p>
    pub schedules: std::option::Option<std::vec::Vec<crate::model::Schedule>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSchedulesOutput {
    /// <p>A list of schedules that are defined.</p>
    pub fn schedules(&self) -> std::option::Option<&[crate::model::Schedule]> {
        self.schedules.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSchedulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchedulesOutput");
        formatter.field("schedules", &self.schedules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSchedulesOutput`](crate::output::ListSchedulesOutput)
pub mod list_schedules_output {
    /// A builder for [`ListSchedulesOutput`](crate::output::ListSchedulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedules: std::option::Option<std::vec::Vec<crate::model::Schedule>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schedules`.
        ///
        /// To override the contents of this collection use [`set_schedules`](Self::set_schedules).
        ///
        /// <p>A list of schedules that are defined.</p>
        pub fn schedules(mut self, input: impl Into<crate::model::Schedule>) -> Self {
            let mut v = self.schedules.unwrap_or_default();
            v.push(input.into());
            self.schedules = Some(v);
            self
        }
        /// <p>A list of schedules that are defined.</p>
        pub fn set_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Schedule>>,
        ) -> Self {
            self.schedules = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchedulesOutput`](crate::output::ListSchedulesOutput)
        pub fn build(self) -> crate::output::ListSchedulesOutput {
            crate::output::ListSchedulesOutput {
                schedules: self.schedules,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSchedulesOutput {
    /// Creates a new builder-style object to manufacture [`ListSchedulesOutput`](crate::output::ListSchedulesOutput)
    pub fn builder() -> crate::output::list_schedules_output::Builder {
        crate::output::list_schedules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesetsOutput {
    /// <p>A list of RulesetItem. RulesetItem contains meta data of a ruleset.</p>
    pub rulesets: std::option::Option<std::vec::Vec<crate::model::RulesetItem>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRulesetsOutput {
    /// <p>A list of RulesetItem. RulesetItem contains meta data of a ruleset.</p>
    pub fn rulesets(&self) -> std::option::Option<&[crate::model::RulesetItem]> {
        self.rulesets.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRulesetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesetsOutput");
        formatter.field("rulesets", &self.rulesets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRulesetsOutput`](crate::output::ListRulesetsOutput)
pub mod list_rulesets_output {
    /// A builder for [`ListRulesetsOutput`](crate::output::ListRulesetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rulesets: std::option::Option<std::vec::Vec<crate::model::RulesetItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rulesets`.
        ///
        /// To override the contents of this collection use [`set_rulesets`](Self::set_rulesets).
        ///
        /// <p>A list of RulesetItem. RulesetItem contains meta data of a ruleset.</p>
        pub fn rulesets(mut self, input: impl Into<crate::model::RulesetItem>) -> Self {
            let mut v = self.rulesets.unwrap_or_default();
            v.push(input.into());
            self.rulesets = Some(v);
            self
        }
        /// <p>A list of RulesetItem. RulesetItem contains meta data of a ruleset.</p>
        pub fn set_rulesets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RulesetItem>>,
        ) -> Self {
            self.rulesets = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesetsOutput`](crate::output::ListRulesetsOutput)
        pub fn build(self) -> crate::output::ListRulesetsOutput {
            crate::output::ListRulesetsOutput {
                rulesets: self.rulesets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRulesetsOutput {
    /// Creates a new builder-style object to manufacture [`ListRulesetsOutput`](crate::output::ListRulesetsOutput)
    pub fn builder() -> crate::output::list_rulesets_output::Builder {
        crate::output::list_rulesets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecipeVersionsOutput {
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of versions for the specified recipe.</p>
    pub recipes: std::option::Option<std::vec::Vec<crate::model::Recipe>>,
}
impl ListRecipeVersionsOutput {
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of versions for the specified recipe.</p>
    pub fn recipes(&self) -> std::option::Option<&[crate::model::Recipe]> {
        self.recipes.as_deref()
    }
}
impl std::fmt::Debug for ListRecipeVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecipeVersionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("recipes", &self.recipes);
        formatter.finish()
    }
}
/// See [`ListRecipeVersionsOutput`](crate::output::ListRecipeVersionsOutput)
pub mod list_recipe_versions_output {
    /// A builder for [`ListRecipeVersionsOutput`](crate::output::ListRecipeVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recipes: std::option::Option<std::vec::Vec<crate::model::Recipe>>,
    }
    impl Builder {
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recipes`.
        ///
        /// To override the contents of this collection use [`set_recipes`](Self::set_recipes).
        ///
        /// <p>A list of versions for the specified recipe.</p>
        pub fn recipes(mut self, input: impl Into<crate::model::Recipe>) -> Self {
            let mut v = self.recipes.unwrap_or_default();
            v.push(input.into());
            self.recipes = Some(v);
            self
        }
        /// <p>A list of versions for the specified recipe.</p>
        pub fn set_recipes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Recipe>>,
        ) -> Self {
            self.recipes = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecipeVersionsOutput`](crate::output::ListRecipeVersionsOutput)
        pub fn build(self) -> crate::output::ListRecipeVersionsOutput {
            crate::output::ListRecipeVersionsOutput {
                next_token: self.next_token,
                recipes: self.recipes,
            }
        }
    }
}
impl ListRecipeVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListRecipeVersionsOutput`](crate::output::ListRecipeVersionsOutput)
    pub fn builder() -> crate::output::list_recipe_versions_output::Builder {
        crate::output::list_recipe_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecipesOutput {
    /// <p>A list of recipes that are defined.</p>
    pub recipes: std::option::Option<std::vec::Vec<crate::model::Recipe>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRecipesOutput {
    /// <p>A list of recipes that are defined.</p>
    pub fn recipes(&self) -> std::option::Option<&[crate::model::Recipe]> {
        self.recipes.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecipesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecipesOutput");
        formatter.field("recipes", &self.recipes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRecipesOutput`](crate::output::ListRecipesOutput)
pub mod list_recipes_output {
    /// A builder for [`ListRecipesOutput`](crate::output::ListRecipesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipes: std::option::Option<std::vec::Vec<crate::model::Recipe>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `recipes`.
        ///
        /// To override the contents of this collection use [`set_recipes`](Self::set_recipes).
        ///
        /// <p>A list of recipes that are defined.</p>
        pub fn recipes(mut self, input: impl Into<crate::model::Recipe>) -> Self {
            let mut v = self.recipes.unwrap_or_default();
            v.push(input.into());
            self.recipes = Some(v);
            self
        }
        /// <p>A list of recipes that are defined.</p>
        pub fn set_recipes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Recipe>>,
        ) -> Self {
            self.recipes = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecipesOutput`](crate::output::ListRecipesOutput)
        pub fn build(self) -> crate::output::ListRecipesOutput {
            crate::output::ListRecipesOutput {
                recipes: self.recipes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRecipesOutput {
    /// Creates a new builder-style object to manufacture [`ListRecipesOutput`](crate::output::ListRecipesOutput)
    pub fn builder() -> crate::output::list_recipes_output::Builder {
        crate::output::list_recipes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>A list of projects that are defined .</p>
    pub projects: std::option::Option<std::vec::Vec<crate::model::Project>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>A list of projects that are defined .</p>
    pub fn projects(&self) -> std::option::Option<&[crate::model::Project]> {
        self.projects.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("projects", &self.projects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projects: std::option::Option<std::vec::Vec<crate::model::Project>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>A list of projects that are defined .</p>
        pub fn projects(mut self, input: impl Into<crate::model::Project>) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input.into());
            self.projects = Some(v);
            self
        }
        /// <p>A list of projects that are defined .</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Project>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                projects: self.projects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>A list of jobs that are defined.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// <p>A list of jobs that are defined.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of jobs that are defined.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>A list of jobs that are defined.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobRunsOutput {
    /// <p>A list of job runs that have occurred for the specified job.</p>
    pub job_runs: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobRunsOutput {
    /// <p>A list of job runs that have occurred for the specified job.</p>
    pub fn job_runs(&self) -> std::option::Option<&[crate::model::JobRun]> {
        self.job_runs.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobRunsOutput");
        formatter.field("job_runs", &self.job_runs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobRunsOutput`](crate::output::ListJobRunsOutput)
pub mod list_job_runs_output {
    /// A builder for [`ListJobRunsOutput`](crate::output::ListJobRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_runs: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_runs`.
        ///
        /// To override the contents of this collection use [`set_job_runs`](Self::set_job_runs).
        ///
        /// <p>A list of job runs that have occurred for the specified job.</p>
        pub fn job_runs(mut self, input: impl Into<crate::model::JobRun>) -> Self {
            let mut v = self.job_runs.unwrap_or_default();
            v.push(input.into());
            self.job_runs = Some(v);
            self
        }
        /// <p>A list of job runs that have occurred for the specified job.</p>
        pub fn set_job_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
        ) -> Self {
            self.job_runs = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobRunsOutput`](crate::output::ListJobRunsOutput)
        pub fn build(self) -> crate::output::ListJobRunsOutput {
            crate::output::ListJobRunsOutput {
                job_runs: self.job_runs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobRunsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobRunsOutput`](crate::output::ListJobRunsOutput)
    pub fn builder() -> crate::output::list_job_runs_output::Builder {
        crate::output::list_job_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsOutput {
    /// <p>A list of datasets that are defined.</p>
    pub datasets: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetsOutput {
    /// <p>A list of datasets that are defined.</p>
    pub fn datasets(&self) -> std::option::Option<&[crate::model::Dataset]> {
        self.datasets.as_deref()
    }
    /// <p>A token that you can use in a subsequent call to retrieve the next set of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsOutput");
        formatter.field("datasets", &self.datasets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
pub mod list_datasets_output {
    /// A builder for [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datasets: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p>A list of datasets that are defined.</p>
        pub fn datasets(mut self, input: impl Into<crate::model::Dataset>) -> Self {
            let mut v = self.datasets.unwrap_or_default();
            v.push(input.into());
            self.datasets = Some(v);
            self
        }
        /// <p>A list of datasets that are defined.</p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dataset>>,
        ) -> Self {
            self.datasets = input;
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent call to retrieve the next set of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
        pub fn build(self) -> crate::output::ListDatasetsOutput {
            crate::output::ListDatasetsOutput {
                datasets: self.datasets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetsOutput`](crate::output::ListDatasetsOutput)
    pub fn builder() -> crate::output::list_datasets_output::Builder {
        crate::output::list_datasets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduleOutput {
    /// <p>The date and time that the schedule was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier (user name) of the user who created the schedule. </p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The name or names of one or more jobs to be run by using the schedule.</p>
    pub job_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifier (user name) of the user who last modified the schedule.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the schedule was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The date or dates and time or times when the jobs are to be run for the schedule. For
    /// more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
    /// <i>Glue DataBrew Developer Guide</i>.</p>
    pub cron_expression: std::option::Option<std::string::String>,
    /// <p>Metadata tags associated with this schedule.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the schedule.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeScheduleOutput {
    /// <p>The date and time that the schedule was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The identifier (user name) of the user who created the schedule. </p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The name or names of one or more jobs to be run by using the schedule.</p>
    pub fn job_names(&self) -> std::option::Option<&[std::string::String]> {
        self.job_names.as_deref()
    }
    /// <p>The identifier (user name) of the user who last modified the schedule.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time that the schedule was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The date or dates and time or times when the jobs are to be run for the schedule. For
    /// more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
    /// <i>Glue DataBrew Developer Guide</i>.</p>
    pub fn cron_expression(&self) -> std::option::Option<&str> {
        self.cron_expression.as_deref()
    }
    /// <p>Metadata tags associated with this schedule.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The name of the schedule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduleOutput");
        formatter.field("create_date", &self.create_date);
        formatter.field("created_by", &self.created_by);
        formatter.field("job_names", &self.job_names);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("cron_expression", &self.cron_expression);
        formatter.field("tags", &self.tags);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
pub mod describe_schedule_output {
    /// A builder for [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) job_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) cron_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time that the schedule was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the schedule was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The identifier (user name) of the user who created the schedule. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who created the schedule. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Appends an item to `job_names`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run by using the schedule.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_names.unwrap_or_default();
            v.push(input.into());
            self.job_names = Some(v);
            self
        }
        /// <p>The name or names of one or more jobs to be run by using the schedule.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_names = input;
            self
        }
        /// <p>The identifier (user name) of the user who last modified the schedule.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who last modified the schedule.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time that the schedule was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time that the schedule was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run for the schedule. For
        /// more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
        /// <i>Glue DataBrew Developer Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.cron_expression = Some(input.into());
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run for the schedule. For
        /// more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
        /// <i>Glue DataBrew Developer Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags associated with this schedule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags associated with this schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the schedule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
        pub fn build(self) -> crate::output::DescribeScheduleOutput {
            crate::output::DescribeScheduleOutput {
                create_date: self.create_date,
                created_by: self.created_by,
                job_names: self.job_names,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                resource_arn: self.resource_arn,
                cron_expression: self.cron_expression,
                tags: self.tags,
                name: self.name,
            }
        }
    }
}
impl DescribeScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput)
    pub fn builder() -> crate::output::describe_schedule_output::Builder {
        crate::output::describe_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRulesetOutput {
    /// <p>The name of the ruleset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the ruleset.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
    /// associated with.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>A list of rules that are defined with the ruleset. A rule includes one
    /// or more checks to be validated on a DataBrew dataset.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The date and time that the ruleset was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the user who created the ruleset.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the ruleset.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The modification date and time of the ruleset.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) for the ruleset.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Metadata tags that have been applied to the ruleset.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeRulesetOutput {
    /// <p>The name of the ruleset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the ruleset.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
    /// associated with.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>A list of rules that are defined with the ruleset. A rule includes one
    /// or more checks to be validated on a DataBrew dataset.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>The date and time that the ruleset was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user who created the ruleset.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the ruleset.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The modification date and time of the ruleset.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the ruleset.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Metadata tags that have been applied to the ruleset.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeRulesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRulesetOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("rules", &self.rules);
        formatter.field("create_date", &self.create_date);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeRulesetOutput`](crate::output::DescribeRulesetOutput)
pub mod describe_ruleset_output {
    /// A builder for [`DescribeRulesetOutput`](crate::output::DescribeRulesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the ruleset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ruleset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
        /// associated with.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
        /// associated with.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes one
        /// or more checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes one
        /// or more checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The date and time that the ruleset was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the ruleset was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the ruleset.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the ruleset.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the ruleset.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the ruleset.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The modification date and time of the ruleset.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The modification date and time of the ruleset.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the ruleset.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the ruleset.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags that have been applied to the ruleset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags that have been applied to the ruleset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRulesetOutput`](crate::output::DescribeRulesetOutput)
        pub fn build(self) -> crate::output::DescribeRulesetOutput {
            crate::output::DescribeRulesetOutput {
                name: self.name,
                description: self.description,
                target_arn: self.target_arn,
                rules: self.rules,
                create_date: self.create_date,
                created_by: self.created_by,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                resource_arn: self.resource_arn,
                tags: self.tags,
            }
        }
    }
}
impl DescribeRulesetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRulesetOutput`](crate::output::DescribeRulesetOutput)
    pub fn builder() -> crate::output::describe_ruleset_output::Builder {
        crate::output::describe_ruleset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecipeOutput {
    /// <p>The identifier (user name) of the user who created the recipe.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the recipe was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier (user name) of the user who last modified the recipe.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the recipe was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the project associated with this recipe.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The identifier (user name) of the user who last published the recipe.</p>
    pub published_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the recipe was last published.</p>
    pub published_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
    /// the conditions under which the action should succeed.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
    /// <p>Metadata tags associated with this project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ARN of the recipe.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The recipe version identifier.</p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl DescribeRecipeOutput {
    /// <p>The identifier (user name) of the user who created the recipe.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The date and time that the recipe was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The identifier (user name) of the user who last modified the recipe.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time that the recipe was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The name of the project associated with this recipe.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The identifier (user name) of the user who last published the recipe.</p>
    pub fn published_by(&self) -> std::option::Option<&str> {
        self.published_by.as_deref()
    }
    /// <p>The date and time when the recipe was last published.</p>
    pub fn published_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.published_date.as_ref()
    }
    /// <p>The description of the recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the recipe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
    /// the conditions under which the action should succeed.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::RecipeStep]> {
        self.steps.as_deref()
    }
    /// <p>Metadata tags associated with this project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ARN of the recipe.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The recipe version identifier.</p>
    pub fn recipe_version(&self) -> std::option::Option<&str> {
        self.recipe_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecipeOutput");
        formatter.field("created_by", &self.created_by);
        formatter.field("create_date", &self.create_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("project_name", &self.project_name);
        formatter.field("published_by", &self.published_by);
        formatter.field("published_date", &self.published_date);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("steps", &self.steps);
        formatter.field("tags", &self.tags);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}
/// See [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
pub mod describe_recipe_output {
    /// A builder for [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) published_by: std::option::Option<std::string::String>,
        pub(crate) published_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier (user name) of the user who created the recipe.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who created the recipe.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the recipe was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the recipe was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The identifier (user name) of the user who last modified the recipe.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who last modified the recipe.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time that the recipe was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time that the recipe was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The name of the project associated with this recipe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project associated with this recipe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The identifier (user name) of the user who last published the recipe.</p>
        pub fn published_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.published_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who last published the recipe.</p>
        pub fn set_published_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.published_by = input;
            self
        }
        /// <p>The date and time when the recipe was last published.</p>
        pub fn published_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.published_date = Some(input);
            self
        }
        /// <p>The date and time when the recipe was last published.</p>
        pub fn set_published_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.published_date = input;
            self
        }
        /// <p>The description of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
        /// the conditions under which the action should succeed.</p>
        pub fn steps(mut self, input: impl Into<crate::model::RecipeStep>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
        /// the conditions under which the action should succeed.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags associated with this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags associated with this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ARN of the recipe.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the recipe.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The recipe version identifier.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The recipe version identifier.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
        pub fn build(self) -> crate::output::DescribeRecipeOutput {
            crate::output::DescribeRecipeOutput {
                created_by: self.created_by,
                create_date: self.create_date,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                project_name: self.project_name,
                published_by: self.published_by,
                published_date: self.published_date,
                description: self.description,
                name: self.name,
                steps: self.steps,
                tags: self.tags,
                resource_arn: self.resource_arn,
                recipe_version: self.recipe_version,
            }
        }
    }
}
impl DescribeRecipeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput)
    pub fn builder() -> crate::output::describe_recipe_output::Builder {
        crate::output::describe_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectOutput {
    /// <p>The date and time that the project was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier (user name) of the user who created the project.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The dataset associated with the project.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The date and time that the project was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier (user name) of the user who last modified the project.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The recipe associated with this job.</p>
    pub recipe_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
    /// analysis.</p>
    pub sample: std::option::Option<crate::model::Sample>,
    /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
    /// DataBrew runs the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Metadata tags associated with this project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Describes the current state of the session:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONING</code> - allocating resources for the session.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INITIALIZING</code> - getting the session ready for first use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ASSIGNED</code> - the session is ready for use.</p>
    /// </li>
    /// </ul>
    pub session_status: std::option::Option<crate::model::SessionStatus>,
    /// <p>The identifier (user name) of the user that opened the project for use. </p>
    pub opened_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the project was opened. </p>
    pub open_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeProjectOutput {
    /// <p>The date and time that the project was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The identifier (user name) of the user who created the project.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The dataset associated with the project.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The date and time that the project was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The identifier (user name) of the user who last modified the project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The recipe associated with this job.</p>
    pub fn recipe_name(&self) -> std::option::Option<&str> {
        self.recipe_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
    /// analysis.</p>
    pub fn sample(&self) -> std::option::Option<&crate::model::Sample> {
        self.sample.as_ref()
    }
    /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
    /// DataBrew runs the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Metadata tags associated with this project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Describes the current state of the session:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONING</code> - allocating resources for the session.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INITIALIZING</code> - getting the session ready for first use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ASSIGNED</code> - the session is ready for use.</p>
    /// </li>
    /// </ul>
    pub fn session_status(&self) -> std::option::Option<&crate::model::SessionStatus> {
        self.session_status.as_ref()
    }
    /// <p>The identifier (user name) of the user that opened the project for use. </p>
    pub fn opened_by(&self) -> std::option::Option<&str> {
        self.opened_by.as_deref()
    }
    /// <p>The date and time when the project was opened. </p>
    pub fn open_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.open_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectOutput");
        formatter.field("create_date", &self.create_date);
        formatter.field("created_by", &self.created_by);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("name", &self.name);
        formatter.field("recipe_name", &self.recipe_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("sample", &self.sample);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("session_status", &self.session_status);
        formatter.field("opened_by", &self.opened_by);
        formatter.field("open_date", &self.open_date);
        formatter.finish()
    }
}
/// See [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
pub mod describe_project_output {
    /// A builder for [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) sample: std::option::Option<crate::model::Sample>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) session_status: std::option::Option<crate::model::SessionStatus>,
        pub(crate) opened_by: std::option::Option<std::string::String>,
        pub(crate) open_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time that the project was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the project was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The identifier (user name) of the user who created the project.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who created the project.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The dataset associated with the project.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The dataset associated with the project.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The date and time that the project was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time that the project was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The identifier (user name) of the user who last modified the project.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who last modified the project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The recipe associated with this job.</p>
        pub fn recipe_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_name = Some(input.into());
            self
        }
        /// <p>The recipe associated with this job.</p>
        pub fn set_recipe_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn sample(mut self, input: crate::model::Sample) -> Self {
            self.sample = Some(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.sample = input;
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
        /// DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
        /// DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags associated with this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags associated with this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Describes the current state of the session:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONING</code> - allocating resources for the session.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INITIALIZING</code> - getting the session ready for first use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ASSIGNED</code> - the session is ready for use.</p>
        /// </li>
        /// </ul>
        pub fn session_status(mut self, input: crate::model::SessionStatus) -> Self {
            self.session_status = Some(input);
            self
        }
        /// <p>Describes the current state of the session:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONING</code> - allocating resources for the session.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INITIALIZING</code> - getting the session ready for first use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ASSIGNED</code> - the session is ready for use.</p>
        /// </li>
        /// </ul>
        pub fn set_session_status(
            mut self,
            input: std::option::Option<crate::model::SessionStatus>,
        ) -> Self {
            self.session_status = input;
            self
        }
        /// <p>The identifier (user name) of the user that opened the project for use. </p>
        pub fn opened_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.opened_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user that opened the project for use. </p>
        pub fn set_opened_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opened_by = input;
            self
        }
        /// <p>The date and time when the project was opened. </p>
        pub fn open_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.open_date = Some(input);
            self
        }
        /// <p>The date and time when the project was opened. </p>
        pub fn set_open_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.open_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
        pub fn build(self) -> crate::output::DescribeProjectOutput {
            crate::output::DescribeProjectOutput {
                create_date: self.create_date,
                created_by: self.created_by,
                dataset_name: self.dataset_name,
                last_modified_date: self.last_modified_date,
                last_modified_by: self.last_modified_by,
                name: self.name,
                recipe_name: self.recipe_name,
                resource_arn: self.resource_arn,
                sample: self.sample,
                role_arn: self.role_arn,
                tags: self.tags,
                session_status: self.session_status,
                opened_by: self.opened_by,
                open_date: self.open_date,
            }
        }
    }
}
impl DescribeProjectOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    pub fn builder() -> crate::output::describe_project_output::Builder {
        crate::output::describe_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobRunOutput {
    /// <p>The number of times that DataBrew has attempted to run the job.</p>
    pub attempt: i32,
    /// <p>The date and time when the job completed processing.</p>
    pub completed_on: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the dataset for the job to process.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, during which the job run consumed resources.</p>
    pub execution_time: i32,
    /// <p>The name of the job being processed during this run.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub profile_configuration: std::option::Option<crate::model::ProfileConfiguration>,
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
    /// <p>The unique identifier of the job run.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The current state of the job run entity itself.</p>
    pub state: std::option::Option<crate::model::JobRunState>,
    /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
    /// when it runs.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>One or more output artifacts from a job run.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub data_catalog_outputs: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
    /// <p>Represents a list of JDBC database output objects which defines the output
    /// destination for a DataBrew recipe job to write into.</p>
    pub database_outputs: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
    /// <p>Represents the name and version of a DataBrew recipe.</p>
    pub recipe_reference: std::option::Option<crate::model::RecipeReference>,
    /// <p>The Amazon Resource Name (ARN) of the user who started the job run.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the job run began.</p>
    pub started_on: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
    /// profile job will be executed. If a JobSample value is not provided, the default value
    /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
    /// size parameter.</p>
    pub job_sample: std::option::Option<crate::model::JobSample>,
}
impl DescribeJobRunOutput {
    /// <p>The number of times that DataBrew has attempted to run the job.</p>
    pub fn attempt(&self) -> i32 {
        self.attempt
    }
    /// <p>The date and time when the job completed processing.</p>
    pub fn completed_on(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completed_on.as_ref()
    }
    /// <p>The name of the dataset for the job to process.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The amount of time, in seconds, during which the job run consumed resources.</p>
    pub fn execution_time(&self) -> i32 {
        self.execution_time
    }
    /// <p>The name of the job being processed during this run.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub fn profile_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProfileConfiguration> {
        self.profile_configuration.as_ref()
    }
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub fn validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ValidationConfiguration]> {
        self.validation_configurations.as_deref()
    }
    /// <p>The unique identifier of the job run.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
    /// <p>The current state of the job run entity itself.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::JobRunState> {
        self.state.as_ref()
    }
    /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
    pub fn log_subscription(&self) -> std::option::Option<&crate::model::LogSubscription> {
        self.log_subscription.as_ref()
    }
    /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
    /// when it runs.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>One or more output artifacts from a job run.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub fn data_catalog_outputs(&self) -> std::option::Option<&[crate::model::DataCatalogOutput]> {
        self.data_catalog_outputs.as_deref()
    }
    /// <p>Represents a list of JDBC database output objects which defines the output
    /// destination for a DataBrew recipe job to write into.</p>
    pub fn database_outputs(&self) -> std::option::Option<&[crate::model::DatabaseOutput]> {
        self.database_outputs.as_deref()
    }
    /// <p>Represents the name and version of a DataBrew recipe.</p>
    pub fn recipe_reference(&self) -> std::option::Option<&crate::model::RecipeReference> {
        self.recipe_reference.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user who started the job run.</p>
    pub fn started_by(&self) -> std::option::Option<&str> {
        self.started_by.as_deref()
    }
    /// <p>The date and time when the job run began.</p>
    pub fn started_on(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_on.as_ref()
    }
    /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
    /// profile job will be executed. If a JobSample value is not provided, the default value
    /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
    /// size parameter.</p>
    pub fn job_sample(&self) -> std::option::Option<&crate::model::JobSample> {
        self.job_sample.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobRunOutput");
        formatter.field("attempt", &self.attempt);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("error_message", &self.error_message);
        formatter.field("execution_time", &self.execution_time);
        formatter.field("job_name", &self.job_name);
        formatter.field("profile_configuration", &self.profile_configuration);
        formatter.field("validation_configurations", &self.validation_configurations);
        formatter.field("run_id", &self.run_id);
        formatter.field("state", &self.state);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("outputs", &self.outputs);
        formatter.field("data_catalog_outputs", &self.data_catalog_outputs);
        formatter.field("database_outputs", &self.database_outputs);
        formatter.field("recipe_reference", &self.recipe_reference);
        formatter.field("started_by", &self.started_by);
        formatter.field("started_on", &self.started_on);
        formatter.field("job_sample", &self.job_sample);
        formatter.finish()
    }
}
/// See [`DescribeJobRunOutput`](crate::output::DescribeJobRunOutput)
pub mod describe_job_run_output {
    /// A builder for [`DescribeJobRunOutput`](crate::output::DescribeJobRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attempt: std::option::Option<i32>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) execution_time: std::option::Option<i32>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) profile_configuration: std::option::Option<crate::model::ProfileConfiguration>,
        pub(crate) validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::JobRunState>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) data_catalog_outputs:
            std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        pub(crate) database_outputs:
            std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        pub(crate) recipe_reference: std::option::Option<crate::model::RecipeReference>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_sample: std::option::Option<crate::model::JobSample>,
    }
    impl Builder {
        /// <p>The number of times that DataBrew has attempted to run the job.</p>
        pub fn attempt(mut self, input: i32) -> Self {
            self.attempt = Some(input);
            self
        }
        /// <p>The number of times that DataBrew has attempted to run the job.</p>
        pub fn set_attempt(mut self, input: std::option::Option<i32>) -> Self {
            self.attempt = input;
            self
        }
        /// <p>The date and time when the job completed processing.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time when the job completed processing.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The name of the dataset for the job to process.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset for the job to process.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The amount of time, in seconds, during which the job run consumed resources.</p>
        pub fn execution_time(mut self, input: i32) -> Self {
            self.execution_time = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, during which the job run consumed resources.</p>
        pub fn set_execution_time(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_time = input;
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn profile_configuration(mut self, input: crate::model::ProfileConfiguration) -> Self {
            self.profile_configuration = Some(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn set_profile_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.profile_configuration = input;
            self
        }
        /// Appends an item to `validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            input: impl Into<crate::model::ValidationConfiguration>,
        ) -> Self {
            let mut v = self.validation_configurations.unwrap_or_default();
            v.push(input.into());
            self.validation_configurations = Some(v);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.validation_configurations = input;
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The current state of the job run entity itself.</p>
        pub fn state(mut self, input: crate::model::JobRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the job run entity itself.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::JobRunState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
        /// when it runs.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
        /// when it runs.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more output artifacts from a job run.</p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>One or more output artifacts from a job run.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `data_catalog_outputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            input: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            let mut v = self.data_catalog_outputs.unwrap_or_default();
            v.push(input.into());
            self.data_catalog_outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.data_catalog_outputs = input;
            self
        }
        /// Appends an item to `database_outputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, input: impl Into<crate::model::DatabaseOutput>) -> Self {
            let mut v = self.database_outputs.unwrap_or_default();
            v.push(input.into());
            self.database_outputs = Some(v);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.database_outputs = input;
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn recipe_reference(mut self, input: crate::model::RecipeReference) -> Self {
            self.recipe_reference = Some(input);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.recipe_reference = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who started the job run.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who started the job run.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// <p>The date and time when the job run began.</p>
        pub fn started_on(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time when the job run began.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed. If a JobSample value is not provided, the default value
        /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
        /// size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.job_sample = Some(input);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed. If a JobSample value is not provided, the default value
        /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
        /// size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.job_sample = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobRunOutput`](crate::output::DescribeJobRunOutput)
        pub fn build(self) -> crate::output::DescribeJobRunOutput {
            crate::output::DescribeJobRunOutput {
                attempt: self.attempt.unwrap_or_default(),
                completed_on: self.completed_on,
                dataset_name: self.dataset_name,
                error_message: self.error_message,
                execution_time: self.execution_time.unwrap_or_default(),
                job_name: self.job_name,
                profile_configuration: self.profile_configuration,
                validation_configurations: self.validation_configurations,
                run_id: self.run_id,
                state: self.state,
                log_subscription: self.log_subscription,
                log_group_name: self.log_group_name,
                outputs: self.outputs,
                data_catalog_outputs: self.data_catalog_outputs,
                database_outputs: self.database_outputs,
                recipe_reference: self.recipe_reference,
                started_by: self.started_by,
                started_on: self.started_on,
                job_sample: self.job_sample,
            }
        }
    }
}
impl DescribeJobRunOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobRunOutput`](crate::output::DescribeJobRunOutput)
    pub fn builder() -> crate::output::describe_job_run_output::Builder {
        crate::output::describe_job_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobOutput {
    /// <p>The date and time that the job was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier (user name) of the user associated with the creation of the job.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The dataset that the job acts upon.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
    /// S3.</p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>The name of the job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The job type, which must be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROFILE</code> - The job analyzes the dataset to determine its size,
    /// data types, data distribution, and more.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RECIPE</code> - The job applies one or more transformations to a
    /// dataset.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::JobType>,
    /// <p>The identifier (user name) of the user who last modified the job.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the job was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether Amazon CloudWatch logging is enabled for this job.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The maximum number of compute nodes that DataBrew can consume when the job processes
    /// data.</p>
    pub max_capacity: i32,
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub max_retries: i32,
    /// <p>One or more artifacts that represent the output from running the job.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub data_catalog_outputs: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
    /// <p>Represents a list of JDBC database output objects which defines the output
    /// destination for a DataBrew recipe job to write into.</p>
    pub database_outputs: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
    /// <p>The DataBrew project associated with this job.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub profile_configuration: std::option::Option<crate::model::ProfileConfiguration>,
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
    /// <p>Represents the name and version of a DataBrew recipe.</p>
    pub recipe_reference: std::option::Option<crate::model::RecipeReference>,
    /// <p>The Amazon Resource Name (ARN) of the job.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
    /// DataBrew runs the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Metadata tags associated with this job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub timeout: i32,
    /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
    /// profile job will be executed.</p>
    pub job_sample: std::option::Option<crate::model::JobSample>,
}
impl DescribeJobOutput {
    /// <p>The date and time that the job was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The identifier (user name) of the user associated with the creation of the job.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The dataset that the job acts upon.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
    /// S3.</p>
    /// </li>
    /// </ul>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionMode> {
        self.encryption_mode.as_ref()
    }
    /// <p>The name of the job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The job type, which must be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROFILE</code> - The job analyzes the dataset to determine its size,
    /// data types, data distribution, and more.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RECIPE</code> - The job applies one or more transformations to a
    /// dataset.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::JobType> {
        self.r#type.as_ref()
    }
    /// <p>The identifier (user name) of the user who last modified the job.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The date and time that the job was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>Indicates whether Amazon CloudWatch logging is enabled for this job.</p>
    pub fn log_subscription(&self) -> std::option::Option<&crate::model::LogSubscription> {
        self.log_subscription.as_ref()
    }
    /// <p>The maximum number of compute nodes that DataBrew can consume when the job processes
    /// data.</p>
    pub fn max_capacity(&self) -> i32 {
        self.max_capacity
    }
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub fn max_retries(&self) -> i32 {
        self.max_retries
    }
    /// <p>One or more artifacts that represent the output from running the job.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub fn data_catalog_outputs(&self) -> std::option::Option<&[crate::model::DataCatalogOutput]> {
        self.data_catalog_outputs.as_deref()
    }
    /// <p>Represents a list of JDBC database output objects which defines the output
    /// destination for a DataBrew recipe job to write into.</p>
    pub fn database_outputs(&self) -> std::option::Option<&[crate::model::DatabaseOutput]> {
        self.database_outputs.as_deref()
    }
    /// <p>The DataBrew project associated with this job.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub fn profile_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProfileConfiguration> {
        self.profile_configuration.as_ref()
    }
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub fn validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ValidationConfiguration]> {
        self.validation_configurations.as_deref()
    }
    /// <p>Represents the name and version of a DataBrew recipe.</p>
    pub fn recipe_reference(&self) -> std::option::Option<&crate::model::RecipeReference> {
        self.recipe_reference.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the job.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
    /// DataBrew runs the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Metadata tags associated with this job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
    /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
    /// profile job will be executed.</p>
    pub fn job_sample(&self) -> std::option::Option<&crate::model::JobSample> {
        self.job_sample.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobOutput");
        formatter.field("create_date", &self.create_date);
        formatter.field("created_by", &self.created_by);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("outputs", &self.outputs);
        formatter.field("data_catalog_outputs", &self.data_catalog_outputs);
        formatter.field("database_outputs", &self.database_outputs);
        formatter.field("project_name", &self.project_name);
        formatter.field("profile_configuration", &self.profile_configuration);
        formatter.field("validation_configurations", &self.validation_configurations);
        formatter.field("recipe_reference", &self.recipe_reference);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("timeout", &self.timeout);
        formatter.field("job_sample", &self.job_sample);
        formatter.finish()
    }
}
/// See [`DescribeJobOutput`](crate::output::DescribeJobOutput)
pub mod describe_job_output {
    /// A builder for [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::JobType>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) data_catalog_outputs:
            std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        pub(crate) database_outputs:
            std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) profile_configuration: std::option::Option<crate::model::ProfileConfiguration>,
        pub(crate) validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        pub(crate) recipe_reference: std::option::Option<crate::model::RecipeReference>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) job_sample: std::option::Option<crate::model::JobSample>,
    }
    impl Builder {
        /// <p>The date and time that the job was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the job was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The identifier (user name) of the user associated with the creation of the job.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user associated with the creation of the job.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The dataset that the job acts upon.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The dataset that the job acts upon.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
        /// S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
        /// S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>The name of the job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The job type, which must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROFILE</code> - The job analyzes the dataset to determine its size,
        /// data types, data distribution, and more.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RECIPE</code> - The job applies one or more transformations to a
        /// dataset.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::JobType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The job type, which must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROFILE</code> - The job analyzes the dataset to determine its size,
        /// data types, data distribution, and more.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RECIPE</code> - The job applies one or more transformations to a
        /// dataset.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier (user name) of the user who last modified the job.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who last modified the job.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time that the job was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time that the job was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>Indicates whether Amazon CloudWatch logging is enabled for this job.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>Indicates whether Amazon CloudWatch logging is enabled for this job.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `data_catalog_outputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            input: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            let mut v = self.data_catalog_outputs.unwrap_or_default();
            v.push(input.into());
            self.data_catalog_outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.data_catalog_outputs = input;
            self
        }
        /// Appends an item to `database_outputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, input: impl Into<crate::model::DatabaseOutput>) -> Self {
            let mut v = self.database_outputs.unwrap_or_default();
            v.push(input.into());
            self.database_outputs = Some(v);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.database_outputs = input;
            self
        }
        /// <p>The DataBrew project associated with this job.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The DataBrew project associated with this job.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn profile_configuration(mut self, input: crate::model::ProfileConfiguration) -> Self {
            self.profile_configuration = Some(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn set_profile_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.profile_configuration = input;
            self
        }
        /// Appends an item to `validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            input: impl Into<crate::model::ValidationConfiguration>,
        ) -> Self {
            let mut v = self.validation_configurations.unwrap_or_default();
            v.push(input.into());
            self.validation_configurations = Some(v);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.validation_configurations = input;
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn recipe_reference(mut self, input: crate::model::RecipeReference) -> Self {
            self.recipe_reference = Some(input);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.recipe_reference = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the job.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the job.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
        /// DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) role to be assumed when
        /// DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags associated with this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags associated with this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.job_sample = Some(input);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.job_sample = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobOutput`](crate::output::DescribeJobOutput)
        pub fn build(self) -> crate::output::DescribeJobOutput {
            crate::output::DescribeJobOutput {
                create_date: self.create_date,
                created_by: self.created_by,
                dataset_name: self.dataset_name,
                encryption_key_arn: self.encryption_key_arn,
                encryption_mode: self.encryption_mode,
                name: self.name,
                r#type: self.r#type,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                log_subscription: self.log_subscription,
                max_capacity: self.max_capacity.unwrap_or_default(),
                max_retries: self.max_retries.unwrap_or_default(),
                outputs: self.outputs,
                data_catalog_outputs: self.data_catalog_outputs,
                database_outputs: self.database_outputs,
                project_name: self.project_name,
                profile_configuration: self.profile_configuration,
                validation_configurations: self.validation_configurations,
                recipe_reference: self.recipe_reference,
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
                tags: self.tags,
                timeout: self.timeout.unwrap_or_default(),
                job_sample: self.job_sample,
            }
        }
    }
}
impl DescribeJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    pub fn builder() -> crate::output::describe_job_output::Builder {
        crate::output::describe_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetOutput {
    /// <p>The identifier (user name) of the user who created the dataset.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the dataset was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The file format of a dataset that is created from an Amazon S3 file
    /// or folder.</p>
    pub format: std::option::Option<crate::model::InputFormat>,
    /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
    /// Excel, or JSON input.</p>
    pub format_options: std::option::Option<crate::model::FormatOptions>,
    /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
    /// Amazon S3.</p>
    pub input: std::option::Option<crate::model::Input>,
    /// <p>The date and time that the dataset was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier (user name) of the user who last modified the dataset.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The location of the data for this dataset, Amazon S3 or the
    /// Glue Data Catalog.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3
    /// path of the dataset.</p>
    pub path_options: std::option::Option<crate::model::PathOptions>,
    /// <p>Metadata tags associated with this dataset.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DescribeDatasetOutput {
    /// <p>The identifier (user name) of the user who created the dataset.</p>
    pub fn created_by(&self) -> std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>The date and time that the dataset was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The name of the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The file format of a dataset that is created from an Amazon S3 file
    /// or folder.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::InputFormat> {
        self.format.as_ref()
    }
    /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
    /// Excel, or JSON input.</p>
    pub fn format_options(&self) -> std::option::Option<&crate::model::FormatOptions> {
        self.format_options.as_ref()
    }
    /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
    /// Amazon S3.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
    /// <p>The date and time that the dataset was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The identifier (user name) of the user who last modified the dataset.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&str> {
        self.last_modified_by.as_deref()
    }
    /// <p>The location of the data for this dataset, Amazon S3 or the
    /// Glue Data Catalog.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::Source> {
        self.source.as_ref()
    }
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3
    /// path of the dataset.</p>
    pub fn path_options(&self) -> std::option::Option<&crate::model::PathOptions> {
        self.path_options.as_ref()
    }
    /// <p>Metadata tags associated with this dataset.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetOutput");
        formatter.field("created_by", &self.created_by);
        formatter.field("create_date", &self.create_date);
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("format_options", &self.format_options);
        formatter.field("input", &self.input);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("source", &self.source);
        formatter.field("path_options", &self.path_options);
        formatter.field("tags", &self.tags);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
pub mod describe_dataset_output {
    /// A builder for [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::InputFormat>,
        pub(crate) format_options: std::option::Option<crate::model::FormatOptions>,
        pub(crate) input: std::option::Option<crate::model::Input>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) path_options: std::option::Option<crate::model::PathOptions>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier (user name) of the user who created the dataset.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who created the dataset.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the dataset was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the dataset was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file
        /// or folder.</p>
        pub fn format(mut self, input: crate::model::InputFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file
        /// or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.format = input;
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn format_options(mut self, input: crate::model::FormatOptions) -> Self {
            self.format_options = Some(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.format_options = input;
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// <p>The date and time that the dataset was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time that the dataset was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The identifier (user name) of the user who last modified the dataset.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The identifier (user name) of the user who last modified the dataset.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The location of the data for this dataset, Amazon S3 or the
        /// Glue Data Catalog.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The location of the data for this dataset, Amazon S3 or the
        /// Glue Data Catalog.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3
        /// path of the dataset.</p>
        pub fn path_options(mut self, input: crate::model::PathOptions) -> Self {
            self.path_options = Some(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3
        /// path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.path_options = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags associated with this dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags associated with this dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
        pub fn build(self) -> crate::output::DescribeDatasetOutput {
            crate::output::DescribeDatasetOutput {
                created_by: self.created_by,
                create_date: self.create_date,
                name: self.name,
                format: self.format,
                format_options: self.format_options,
                input: self.input,
                last_modified_date: self.last_modified_date,
                last_modified_by: self.last_modified_by,
                source: self.source,
                path_options: self.path_options,
                tags: self.tags,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl DescribeDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    pub fn builder() -> crate::output::describe_dataset_output::Builder {
        crate::output::describe_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduleOutput {
    /// <p>The name of the schedule that was deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteScheduleOutput {
    /// <p>The name of the schedule that was deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduleOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
pub mod delete_schedule_output {
    /// A builder for [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the schedule that was deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule that was deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
        pub fn build(self) -> crate::output::DeleteScheduleOutput {
            crate::output::DeleteScheduleOutput { name: self.name }
        }
    }
}
impl DeleteScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput)
    pub fn builder() -> crate::output::delete_schedule_output::Builder {
        crate::output::delete_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRulesetOutput {
    /// <p>The name of the deleted ruleset.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteRulesetOutput {
    /// <p>The name of the deleted ruleset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRulesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRulesetOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteRulesetOutput`](crate::output::DeleteRulesetOutput)
pub mod delete_ruleset_output {
    /// A builder for [`DeleteRulesetOutput`](crate::output::DeleteRulesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the deleted ruleset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the deleted ruleset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRulesetOutput`](crate::output::DeleteRulesetOutput)
        pub fn build(self) -> crate::output::DeleteRulesetOutput {
            crate::output::DeleteRulesetOutput { name: self.name }
        }
    }
}
impl DeleteRulesetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRulesetOutput`](crate::output::DeleteRulesetOutput)
    pub fn builder() -> crate::output::delete_ruleset_output::Builder {
        crate::output::delete_ruleset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecipeVersionOutput {
    /// <p>The name of the recipe that was deleted.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the recipe that was deleted.</p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl DeleteRecipeVersionOutput {
    /// <p>The name of the recipe that was deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the recipe that was deleted.</p>
    pub fn recipe_version(&self) -> std::option::Option<&str> {
        self.recipe_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteRecipeVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecipeVersionOutput");
        formatter.field("name", &self.name);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}
/// See [`DeleteRecipeVersionOutput`](crate::output::DeleteRecipeVersionOutput)
pub mod delete_recipe_version_output {
    /// A builder for [`DeleteRecipeVersionOutput`](crate::output::DeleteRecipeVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe that was deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe that was deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the recipe that was deleted.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The version of the recipe that was deleted.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecipeVersionOutput`](crate::output::DeleteRecipeVersionOutput)
        pub fn build(self) -> crate::output::DeleteRecipeVersionOutput {
            crate::output::DeleteRecipeVersionOutput {
                name: self.name,
                recipe_version: self.recipe_version,
            }
        }
    }
}
impl DeleteRecipeVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecipeVersionOutput`](crate::output::DeleteRecipeVersionOutput)
    pub fn builder() -> crate::output::delete_recipe_version_output::Builder {
        crate::output::delete_recipe_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {
    /// <p>The name of the project that you deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteProjectOutput {
    /// <p>The name of the project that you deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that you deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project that you deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput { name: self.name }
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobOutput {
    /// <p>The name of the job that you deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteJobOutput {
    /// <p>The name of the job that you deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteJobOutput`](crate::output::DeleteJobOutput)
pub mod delete_job_output {
    /// A builder for [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job that you deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job that you deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobOutput`](crate::output::DeleteJobOutput)
        pub fn build(self) -> crate::output::DeleteJobOutput {
            crate::output::DeleteJobOutput { name: self.name }
        }
    }
}
impl DeleteJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    pub fn builder() -> crate::output::delete_job_output::Builder {
        crate::output::delete_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetOutput {
    /// <p>The name of the dataset that you deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteDatasetOutput {
    /// <p>The name of the dataset that you deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
pub mod delete_dataset_output {
    /// A builder for [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset that you deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset that you deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
        pub fn build(self) -> crate::output::DeleteDatasetOutput {
            crate::output::DeleteDatasetOutput { name: self.name }
        }
    }
}
impl DeleteDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    pub fn builder() -> crate::output::delete_dataset_output::Builder {
        crate::output::delete_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScheduleOutput {
    /// <p>The name of the schedule that was created.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateScheduleOutput {
    /// <p>The name of the schedule that was created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScheduleOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateScheduleOutput`](crate::output::CreateScheduleOutput)
pub mod create_schedule_output {
    /// A builder for [`CreateScheduleOutput`](crate::output::CreateScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the schedule that was created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule that was created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScheduleOutput`](crate::output::CreateScheduleOutput)
        pub fn build(self) -> crate::output::CreateScheduleOutput {
            crate::output::CreateScheduleOutput { name: self.name }
        }
    }
}
impl CreateScheduleOutput {
    /// Creates a new builder-style object to manufacture [`CreateScheduleOutput`](crate::output::CreateScheduleOutput)
    pub fn builder() -> crate::output::create_schedule_output::Builder {
        crate::output::create_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRulesetOutput {
    /// <p>The unique name of the created ruleset.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateRulesetOutput {
    /// <p>The unique name of the created ruleset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateRulesetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRulesetOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateRulesetOutput`](crate::output::CreateRulesetOutput)
pub mod create_ruleset_output {
    /// A builder for [`CreateRulesetOutput`](crate::output::CreateRulesetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the created ruleset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the created ruleset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRulesetOutput`](crate::output::CreateRulesetOutput)
        pub fn build(self) -> crate::output::CreateRulesetOutput {
            crate::output::CreateRulesetOutput { name: self.name }
        }
    }
}
impl CreateRulesetOutput {
    /// Creates a new builder-style object to manufacture [`CreateRulesetOutput`](crate::output::CreateRulesetOutput)
    pub fn builder() -> crate::output::create_ruleset_output::Builder {
        crate::output::create_ruleset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecipeJobOutput {
    /// <p>The name of the job that you created.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateRecipeJobOutput {
    /// <p>The name of the job that you created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateRecipeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecipeJobOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateRecipeJobOutput`](crate::output::CreateRecipeJobOutput)
pub mod create_recipe_job_output {
    /// A builder for [`CreateRecipeJobOutput`](crate::output::CreateRecipeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job that you created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job that you created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecipeJobOutput`](crate::output::CreateRecipeJobOutput)
        pub fn build(self) -> crate::output::CreateRecipeJobOutput {
            crate::output::CreateRecipeJobOutput { name: self.name }
        }
    }
}
impl CreateRecipeJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateRecipeJobOutput`](crate::output::CreateRecipeJobOutput)
    pub fn builder() -> crate::output::create_recipe_job_output::Builder {
        crate::output::create_recipe_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecipeOutput {
    /// <p>The name of the recipe that you created.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateRecipeOutput {
    /// <p>The name of the recipe that you created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecipeOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateRecipeOutput`](crate::output::CreateRecipeOutput)
pub mod create_recipe_output {
    /// A builder for [`CreateRecipeOutput`](crate::output::CreateRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe that you created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe that you created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecipeOutput`](crate::output::CreateRecipeOutput)
        pub fn build(self) -> crate::output::CreateRecipeOutput {
            crate::output::CreateRecipeOutput { name: self.name }
        }
    }
}
impl CreateRecipeOutput {
    /// Creates a new builder-style object to manufacture [`CreateRecipeOutput`](crate::output::CreateRecipeOutput)
    pub fn builder() -> crate::output::create_recipe_output::Builder {
        crate::output::create_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>The name of the project that you created.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateProjectOutput {
    /// <p>The name of the project that you created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that you created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project that you created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput { name: self.name }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfileJobOutput {
    /// <p>The name of the job that was created.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateProfileJobOutput {
    /// <p>The name of the job that was created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateProfileJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfileJobOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateProfileJobOutput`](crate::output::CreateProfileJobOutput)
pub mod create_profile_job_output {
    /// A builder for [`CreateProfileJobOutput`](crate::output::CreateProfileJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job that was created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job that was created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfileJobOutput`](crate::output::CreateProfileJobOutput)
        pub fn build(self) -> crate::output::CreateProfileJobOutput {
            crate::output::CreateProfileJobOutput { name: self.name }
        }
    }
}
impl CreateProfileJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateProfileJobOutput`](crate::output::CreateProfileJobOutput)
    pub fn builder() -> crate::output::create_profile_job_output::Builder {
        crate::output::create_profile_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetOutput {
    /// <p>The name of the dataset that you created.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateDatasetOutput {
    /// <p>The name of the dataset that you created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
pub mod create_dataset_output {
    /// A builder for [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset that you created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset that you created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
        pub fn build(self) -> crate::output::CreateDatasetOutput {
            crate::output::CreateDatasetOutput { name: self.name }
        }
    }
}
impl CreateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    pub fn builder() -> crate::output::create_dataset_output::Builder {
        crate::output::create_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteRecipeVersionOutput {
    /// <p>The name of the recipe that was modified.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Errors, if any, that occurred while attempting to delete the recipe versions.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::RecipeVersionErrorDetail>>,
}
impl BatchDeleteRecipeVersionOutput {
    /// <p>The name of the recipe that was modified.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Errors, if any, that occurred while attempting to delete the recipe versions.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::RecipeVersionErrorDetail]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteRecipeVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteRecipeVersionOutput");
        formatter.field("name", &self.name);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteRecipeVersionOutput`](crate::output::BatchDeleteRecipeVersionOutput)
pub mod batch_delete_recipe_version_output {
    /// A builder for [`BatchDeleteRecipeVersionOutput`](crate::output::BatchDeleteRecipeVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::RecipeVersionErrorDetail>>,
    }
    impl Builder {
        /// <p>The name of the recipe that was modified.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe that was modified.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Errors, if any, that occurred while attempting to delete the recipe versions.</p>
        pub fn errors(mut self, input: impl Into<crate::model::RecipeVersionErrorDetail>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Errors, if any, that occurred while attempting to delete the recipe versions.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeVersionErrorDetail>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteRecipeVersionOutput`](crate::output::BatchDeleteRecipeVersionOutput)
        pub fn build(self) -> crate::output::BatchDeleteRecipeVersionOutput {
            crate::output::BatchDeleteRecipeVersionOutput {
                name: self.name,
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteRecipeVersionOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteRecipeVersionOutput`](crate::output::BatchDeleteRecipeVersionOutput)
    pub fn builder() -> crate::output::batch_delete_recipe_version_output::Builder {
        crate::output::batch_delete_recipe_version_output::Builder::default()
    }
}
