// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Glue DataBrew
///
/// Client for invoking operations on AWS Glue DataBrew. Each operation on AWS Glue DataBrew is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_databrew::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_databrew::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_databrew::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchDeleteRecipeVersion`](crate::client::fluent_builders::BatchDeleteRecipeVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::BatchDeleteRecipeVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::BatchDeleteRecipeVersion::set_name): <p>The name of the recipe whose versions are to be deleted.</p>
    ///   - [`recipe_versions(Vec<String>)`](crate::client::fluent_builders::BatchDeleteRecipeVersion::recipe_versions) / [`set_recipe_versions(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeleteRecipeVersion::set_recipe_versions): <p>An array of version identifiers, for the recipe versions to be deleted. You can specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is not supported.</p>
    /// - On success, responds with [`BatchDeleteRecipeVersionOutput`](crate::output::BatchDeleteRecipeVersionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::BatchDeleteRecipeVersionOutput::name): <p>The name of the recipe that was modified.</p>
    ///   - [`errors(Option<Vec<RecipeVersionErrorDetail>>)`](crate::output::BatchDeleteRecipeVersionOutput::errors): <p>Errors, if any, that occurred while attempting to delete the recipe versions.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteRecipeVersionError>`](crate::error::BatchDeleteRecipeVersionError)
    pub fn batch_delete_recipe_version(&self) -> fluent_builders::BatchDeleteRecipeVersion {
        fluent_builders::BatchDeleteRecipeVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataset`](crate::client::fluent_builders::CreateDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDataset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDataset::set_name): <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    ///   - [`format(InputFormat)`](crate::client::fluent_builders::CreateDataset::format) / [`set_format(Option<InputFormat>)`](crate::client::fluent_builders::CreateDataset::set_format): <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    ///   - [`format_options(FormatOptions)`](crate::client::fluent_builders::CreateDataset::format_options) / [`set_format_options(Option<FormatOptions>)`](crate::client::fluent_builders::CreateDataset::set_format_options): <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
    ///   - [`input(Input)`](crate::client::fluent_builders::CreateDataset::input) / [`set_input(Option<Input>)`](crate::client::fluent_builders::CreateDataset::set_input): <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
    ///   - [`path_options(PathOptions)`](crate::client::fluent_builders::CreateDataset::path_options) / [`set_path_options(Option<PathOptions>)`](crate::client::fluent_builders::CreateDataset::set_path_options): <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDataset::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDataset::set_tags): <p>Metadata tags to apply to this dataset.</p>
    /// - On success, responds with [`CreateDatasetOutput`](crate::output::CreateDatasetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateDatasetOutput::name): <p>The name of the dataset that you created.</p>
    /// - On failure, responds with [`SdkError<CreateDatasetError>`](crate::error::CreateDatasetError)
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProfileJob`](crate::client::fluent_builders::CreateProfileJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::CreateProfileJob::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::CreateProfileJob::set_dataset_name): <p>The name of the dataset that this job is to act upon.</p>
    ///   - [`encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateProfileJob::encryption_key_arn) / [`set_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::CreateProfileJob::set_encryption_key_arn): <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
    ///   - [`encryption_mode(EncryptionMode)`](crate::client::fluent_builders::CreateProfileJob::encryption_mode) / [`set_encryption_mode(Option<EncryptionMode>)`](crate::client::fluent_builders::CreateProfileJob::set_encryption_mode): <p>The encryption mode for the job, which can be one of the following:</p>  <ul>   <li> <p> <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.</p> </li>   <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProfileJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProfileJob::set_name): <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    ///   - [`log_subscription(LogSubscription)`](crate::client::fluent_builders::CreateProfileJob::log_subscription) / [`set_log_subscription(Option<LogSubscription>)`](crate::client::fluent_builders::CreateProfileJob::set_log_subscription): <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
    ///   - [`max_capacity(i32)`](crate::client::fluent_builders::CreateProfileJob::max_capacity) / [`set_max_capacity(i32)`](crate::client::fluent_builders::CreateProfileJob::set_max_capacity): <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
    ///   - [`max_retries(i32)`](crate::client::fluent_builders::CreateProfileJob::max_retries) / [`set_max_retries(i32)`](crate::client::fluent_builders::CreateProfileJob::set_max_retries): <p>The maximum number of times to retry the job after a job run fails.</p>
    ///   - [`output_location(S3Location)`](crate::client::fluent_builders::CreateProfileJob::output_location) / [`set_output_location(Option<S3Location>)`](crate::client::fluent_builders::CreateProfileJob::set_output_location): <p>Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.</p>
    ///   - [`configuration(ProfileConfiguration)`](crate::client::fluent_builders::CreateProfileJob::configuration) / [`set_configuration(Option<ProfileConfiguration>)`](crate::client::fluent_builders::CreateProfileJob::set_configuration): <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
    ///   - [`validation_configurations(Vec<ValidationConfiguration>)`](crate::client::fluent_builders::CreateProfileJob::validation_configurations) / [`set_validation_configurations(Option<Vec<ValidationConfiguration>>)`](crate::client::fluent_builders::CreateProfileJob::set_validation_configurations): <p>List of validation configurations that are applied to the profile job.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateProfileJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateProfileJob::set_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProfileJob::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProfileJob::set_tags): <p>Metadata tags to apply to this job.</p>
    ///   - [`timeout(i32)`](crate::client::fluent_builders::CreateProfileJob::timeout) / [`set_timeout(i32)`](crate::client::fluent_builders::CreateProfileJob::set_timeout): <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
    ///   - [`job_sample(JobSample)`](crate::client::fluent_builders::CreateProfileJob::job_sample) / [`set_job_sample(Option<JobSample>)`](crate::client::fluent_builders::CreateProfileJob::set_job_sample): <p>Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
    /// - On success, responds with [`CreateProfileJobOutput`](crate::output::CreateProfileJobOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateProfileJobOutput::name): <p>The name of the job that was created.</p>
    /// - On failure, responds with [`SdkError<CreateProfileJobError>`](crate::error::CreateProfileJobError)
    pub fn create_profile_job(&self) -> fluent_builders::CreateProfileJob {
        fluent_builders::CreateProfileJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_dataset_name): <p>The name of an existing dataset to associate this project with.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_name): <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    ///   - [`recipe_name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::recipe_name) / [`set_recipe_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_recipe_name): <p>The name of an existing recipe to associate with the project.</p>
    ///   - [`sample(Sample)`](crate::client::fluent_builders::CreateProject::sample) / [`set_sample(Option<Sample>)`](crate::client::fluent_builders::CreateProject::set_sample): <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateProject::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateProject::set_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed for this request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProject::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProject::set_tags): <p>Metadata tags to apply to this project.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateProjectOutput::name): <p>The name of the project that you created.</p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecipe`](crate::client::fluent_builders::CreateRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRecipe::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRecipe::set_description): <p>A description for the recipe.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRecipe::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRecipe::set_name): <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    ///   - [`steps(Vec<RecipeStep>)`](crate::client::fluent_builders::CreateRecipe::steps) / [`set_steps(Option<Vec<RecipeStep>>)`](crate::client::fluent_builders::CreateRecipe::set_steps): <p>An array containing the steps to be performed by the recipe. Each recipe step consists of one recipe action and (optionally) an array of condition expressions.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRecipe::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRecipe::set_tags): <p>Metadata tags to apply to this recipe.</p>
    /// - On success, responds with [`CreateRecipeOutput`](crate::output::CreateRecipeOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateRecipeOutput::name): <p>The name of the recipe that you created.</p>
    /// - On failure, responds with [`SdkError<CreateRecipeError>`](crate::error::CreateRecipeError)
    pub fn create_recipe(&self) -> fluent_builders::CreateRecipe {
        fluent_builders::CreateRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecipeJob`](crate::client::fluent_builders::CreateRecipeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::CreateRecipeJob::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::CreateRecipeJob::set_dataset_name): <p>The name of the dataset that this job processes.</p>
    ///   - [`encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRecipeJob::encryption_key_arn) / [`set_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::CreateRecipeJob::set_encryption_key_arn): <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
    ///   - [`encryption_mode(EncryptionMode)`](crate::client::fluent_builders::CreateRecipeJob::encryption_mode) / [`set_encryption_mode(Option<EncryptionMode>)`](crate::client::fluent_builders::CreateRecipeJob::set_encryption_mode): <p>The encryption mode for the job, which can be one of the following:</p>  <ul>   <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>   <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRecipeJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRecipeJob::set_name): <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    ///   - [`log_subscription(LogSubscription)`](crate::client::fluent_builders::CreateRecipeJob::log_subscription) / [`set_log_subscription(Option<LogSubscription>)`](crate::client::fluent_builders::CreateRecipeJob::set_log_subscription): <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
    ///   - [`max_capacity(i32)`](crate::client::fluent_builders::CreateRecipeJob::max_capacity) / [`set_max_capacity(i32)`](crate::client::fluent_builders::CreateRecipeJob::set_max_capacity): <p>The maximum number of nodes that DataBrew can consume when the job processes data.</p>
    ///   - [`max_retries(i32)`](crate::client::fluent_builders::CreateRecipeJob::max_retries) / [`set_max_retries(i32)`](crate::client::fluent_builders::CreateRecipeJob::set_max_retries): <p>The maximum number of times to retry the job after a job run fails.</p>
    ///   - [`outputs(Vec<Output>)`](crate::client::fluent_builders::CreateRecipeJob::outputs) / [`set_outputs(Option<Vec<Output>>)`](crate::client::fluent_builders::CreateRecipeJob::set_outputs): <p>One or more artifacts that represent the output from running the job.</p>
    ///   - [`data_catalog_outputs(Vec<DataCatalogOutput>)`](crate::client::fluent_builders::CreateRecipeJob::data_catalog_outputs) / [`set_data_catalog_outputs(Option<Vec<DataCatalogOutput>>)`](crate::client::fluent_builders::CreateRecipeJob::set_data_catalog_outputs): <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    ///   - [`database_outputs(Vec<DatabaseOutput>)`](crate::client::fluent_builders::CreateRecipeJob::database_outputs) / [`set_database_outputs(Option<Vec<DatabaseOutput>>)`](crate::client::fluent_builders::CreateRecipeJob::set_database_outputs): <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write to. </p>
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateRecipeJob::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateRecipeJob::set_project_name): <p>Either the name of an existing project, or a combination of a recipe and a dataset to associate with the recipe.</p>
    ///   - [`recipe_reference(RecipeReference)`](crate::client::fluent_builders::CreateRecipeJob::recipe_reference) / [`set_recipe_reference(Option<RecipeReference>)`](crate::client::fluent_builders::CreateRecipeJob::set_recipe_reference): <p>Represents the name and version of a DataBrew recipe.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRecipeJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateRecipeJob::set_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRecipeJob::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRecipeJob::set_tags): <p>Metadata tags to apply to this job.</p>
    ///   - [`timeout(i32)`](crate::client::fluent_builders::CreateRecipeJob::timeout) / [`set_timeout(i32)`](crate::client::fluent_builders::CreateRecipeJob::set_timeout): <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
    /// - On success, responds with [`CreateRecipeJobOutput`](crate::output::CreateRecipeJobOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateRecipeJobOutput::name): <p>The name of the job that you created.</p>
    /// - On failure, responds with [`SdkError<CreateRecipeJobError>`](crate::error::CreateRecipeJobError)
    pub fn create_recipe_job(&self) -> fluent_builders::CreateRecipeJob {
        fluent_builders::CreateRecipeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRuleset`](crate::client::fluent_builders::CreateRuleset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRuleset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRuleset::set_name): <p>The name of the ruleset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRuleset::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRuleset::set_description): <p>The description of the ruleset.</p>
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRuleset::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::CreateRuleset::set_target_arn): <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is associated with.</p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::CreateRuleset::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::CreateRuleset::set_rules): <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRuleset::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRuleset::set_tags): <p>Metadata tags to apply to the ruleset.</p>
    /// - On success, responds with [`CreateRulesetOutput`](crate::output::CreateRulesetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateRulesetOutput::name): <p>The unique name of the created ruleset.</p>
    /// - On failure, responds with [`SdkError<CreateRulesetError>`](crate::error::CreateRulesetError)
    pub fn create_ruleset(&self) -> fluent_builders::CreateRuleset {
        fluent_builders::CreateRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSchedule`](crate::client::fluent_builders::CreateSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_names(Vec<String>)`](crate::client::fluent_builders::CreateSchedule::job_names) / [`set_job_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSchedule::set_job_names): <p>The name or names of one or more jobs to be run.</p>
    ///   - [`cron_expression(impl Into<String>)`](crate::client::fluent_builders::CreateSchedule::cron_expression) / [`set_cron_expression(Option<String>)`](crate::client::fluent_builders::CreateSchedule::set_cron_expression): <p>The date or dates and time or times when the jobs are to be run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateSchedule::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSchedule::set_tags): <p>Metadata tags to apply to this schedule.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSchedule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSchedule::set_name): <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    /// - On success, responds with [`CreateScheduleOutput`](crate::output::CreateScheduleOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateScheduleOutput::name): <p>The name of the schedule that was created.</p>
    /// - On failure, responds with [`SdkError<CreateScheduleError>`](crate::error::CreateScheduleError)
    pub fn create_schedule(&self) -> fluent_builders::CreateSchedule {
        fluent_builders::CreateSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_name): <p>The name of the dataset to be deleted.</p>
    /// - On success, responds with [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteDatasetOutput::name): <p>The name of the dataset that you deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteDatasetError>`](crate::error::DeleteDatasetError)
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJob`](crate::client::fluent_builders::DeleteJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_name): <p>The name of the job to be deleted.</p>
    /// - On success, responds with [`DeleteJobOutput`](crate::output::DeleteJobOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteJobOutput::name): <p>The name of the job that you deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteJobError>`](crate::error::DeleteJobError)
    pub fn delete_job(&self) -> fluent_builders::DeleteJob {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_name): <p>The name of the project to be deleted.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteProjectOutput::name): <p>The name of the project that you deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecipeVersion`](crate::client::fluent_builders::DeleteRecipeVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRecipeVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRecipeVersion::set_name): <p>The name of the recipe.</p>
    ///   - [`recipe_version(impl Into<String>)`](crate::client::fluent_builders::DeleteRecipeVersion::recipe_version) / [`set_recipe_version(Option<String>)`](crate::client::fluent_builders::DeleteRecipeVersion::set_recipe_version): <p>The version of the recipe to be deleted. You can specify a numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is not supported.</p>
    /// - On success, responds with [`DeleteRecipeVersionOutput`](crate::output::DeleteRecipeVersionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteRecipeVersionOutput::name): <p>The name of the recipe that was deleted.</p>
    ///   - [`recipe_version(Option<String>)`](crate::output::DeleteRecipeVersionOutput::recipe_version): <p>The version of the recipe that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteRecipeVersionError>`](crate::error::DeleteRecipeVersionError)
    pub fn delete_recipe_version(&self) -> fluent_builders::DeleteRecipeVersion {
        fluent_builders::DeleteRecipeVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRuleset`](crate::client::fluent_builders::DeleteRuleset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRuleset::set_name): <p>The name of the ruleset to be deleted.</p>
    /// - On success, responds with [`DeleteRulesetOutput`](crate::output::DeleteRulesetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteRulesetOutput::name): <p>The name of the deleted ruleset.</p>
    /// - On failure, responds with [`SdkError<DeleteRulesetError>`](crate::error::DeleteRulesetError)
    pub fn delete_ruleset(&self) -> fluent_builders::DeleteRuleset {
        fluent_builders::DeleteRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSchedule`](crate::client::fluent_builders::DeleteSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteSchedule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteSchedule::set_name): <p>The name of the schedule to be deleted.</p>
    /// - On success, responds with [`DeleteScheduleOutput`](crate::output::DeleteScheduleOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteScheduleOutput::name): <p>The name of the schedule that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteScheduleError>`](crate::error::DeleteScheduleError)
    pub fn delete_schedule(&self) -> fluent_builders::DeleteSchedule {
        fluent_builders::DeleteSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_name): <p>The name of the dataset to be described.</p>
    /// - On success, responds with [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput) with field(s):
    ///   - [`created_by(Option<String>)`](crate::output::DescribeDatasetOutput::created_by): <p>The identifier (user name) of the user who created the dataset.</p>
    ///   - [`create_date(Option<DateTime>)`](crate::output::DescribeDatasetOutput::create_date): <p>The date and time that the dataset was created.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeDatasetOutput::name): <p>The name of the dataset.</p>
    ///   - [`format(Option<InputFormat>)`](crate::output::DescribeDatasetOutput::format): <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    ///   - [`format_options(Option<FormatOptions>)`](crate::output::DescribeDatasetOutput::format_options): <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
    ///   - [`input(Option<Input>)`](crate::output::DescribeDatasetOutput::input): <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeDatasetOutput::last_modified_date): <p>The date and time that the dataset was last modified.</p>
    ///   - [`last_modified_by(Option<String>)`](crate::output::DescribeDatasetOutput::last_modified_by): <p>The identifier (user name) of the user who last modified the dataset.</p>
    ///   - [`source(Option<Source>)`](crate::output::DescribeDatasetOutput::source): <p>The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.</p>
    ///   - [`path_options(Option<PathOptions>)`](crate::output::DescribeDatasetOutput::path_options): <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeDatasetOutput::tags): <p>Metadata tags associated with this dataset.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeDatasetOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the dataset.</p>
    /// - On failure, responds with [`SdkError<DescribeDatasetError>`](crate::error::DescribeDatasetError)
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJob`](crate::client::fluent_builders::DescribeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeJob::set_name): <p>The name of the job to be described.</p>
    /// - On success, responds with [`DescribeJobOutput`](crate::output::DescribeJobOutput) with field(s):
    ///   - [`create_date(Option<DateTime>)`](crate::output::DescribeJobOutput::create_date): <p>The date and time that the job was created.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeJobOutput::created_by): <p>The identifier (user name) of the user associated with the creation of the job.</p>
    ///   - [`dataset_name(Option<String>)`](crate::output::DescribeJobOutput::dataset_name): <p>The dataset that the job acts upon.</p>
    ///   - [`encryption_key_arn(Option<String>)`](crate::output::DescribeJobOutput::encryption_key_arn): <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
    ///   - [`encryption_mode(Option<EncryptionMode>)`](crate::output::DescribeJobOutput::encryption_mode): <p>The encryption mode for the job, which can be one of the following:</p>  <ul>   <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>   <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>  </ul>
    ///   - [`name(Option<String>)`](crate::output::DescribeJobOutput::name): <p>The name of the job.</p>
    ///   - [`r#type(Option<JobType>)`](crate::output::DescribeJobOutput::type): <p>The job type, which must be one of the following:</p>  <ul>   <li> <p> <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution, and more.</p> </li>   <li> <p> <code>RECIPE</code> - The job applies one or more transformations to a dataset.</p> </li>  </ul>
    ///   - [`last_modified_by(Option<String>)`](crate::output::DescribeJobOutput::last_modified_by): <p>The identifier (user name) of the user who last modified the job.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeJobOutput::last_modified_date): <p>The date and time that the job was last modified.</p>
    ///   - [`log_subscription(Option<LogSubscription>)`](crate::output::DescribeJobOutput::log_subscription): <p>Indicates whether Amazon CloudWatch logging is enabled for this job.</p>
    ///   - [`max_capacity(i32)`](crate::output::DescribeJobOutput::max_capacity): <p>The maximum number of compute nodes that DataBrew can consume when the job processes data.</p>
    ///   - [`max_retries(i32)`](crate::output::DescribeJobOutput::max_retries): <p>The maximum number of times to retry the job after a job run fails.</p>
    ///   - [`outputs(Option<Vec<Output>>)`](crate::output::DescribeJobOutput::outputs): <p>One or more artifacts that represent the output from running the job.</p>
    ///   - [`data_catalog_outputs(Option<Vec<DataCatalogOutput>>)`](crate::output::DescribeJobOutput::data_catalog_outputs): <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    ///   - [`database_outputs(Option<Vec<DatabaseOutput>>)`](crate::output::DescribeJobOutput::database_outputs): <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.</p>
    ///   - [`project_name(Option<String>)`](crate::output::DescribeJobOutput::project_name): <p>The DataBrew project associated with this job.</p>
    ///   - [`profile_configuration(Option<ProfileConfiguration>)`](crate::output::DescribeJobOutput::profile_configuration): <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
    ///   - [`validation_configurations(Option<Vec<ValidationConfiguration>>)`](crate::output::DescribeJobOutput::validation_configurations): <p>List of validation configurations that are applied to the profile job.</p>
    ///   - [`recipe_reference(Option<RecipeReference>)`](crate::output::DescribeJobOutput::recipe_reference): <p>Represents the name and version of a DataBrew recipe.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeJobOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the job.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeJobOutput::role_arn): <p>The ARN of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeJobOutput::tags): <p>Metadata tags associated with this job.</p>
    ///   - [`timeout(i32)`](crate::output::DescribeJobOutput::timeout): <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
    ///   - [`job_sample(Option<JobSample>)`](crate::output::DescribeJobOutput::job_sample): <p>Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be executed.</p>
    /// - On failure, responds with [`SdkError<DescribeJobError>`](crate::error::DescribeJobError)
    pub fn describe_job(&self) -> fluent_builders::DescribeJob {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobRun`](crate::client::fluent_builders::DescribeJobRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeJobRun::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeJobRun::set_name): <p>The name of the job being processed during this run.</p>
    ///   - [`run_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobRun::run_id) / [`set_run_id(Option<String>)`](crate::client::fluent_builders::DescribeJobRun::set_run_id): <p>The unique identifier of the job run.</p>
    /// - On success, responds with [`DescribeJobRunOutput`](crate::output::DescribeJobRunOutput) with field(s):
    ///   - [`attempt(i32)`](crate::output::DescribeJobRunOutput::attempt): <p>The number of times that DataBrew has attempted to run the job.</p>
    ///   - [`completed_on(Option<DateTime>)`](crate::output::DescribeJobRunOutput::completed_on): <p>The date and time when the job completed processing.</p>
    ///   - [`dataset_name(Option<String>)`](crate::output::DescribeJobRunOutput::dataset_name): <p>The name of the dataset for the job to process.</p>
    ///   - [`error_message(Option<String>)`](crate::output::DescribeJobRunOutput::error_message): <p>A message indicating an error (if any) that was encountered when the job ran.</p>
    ///   - [`execution_time(i32)`](crate::output::DescribeJobRunOutput::execution_time): <p>The amount of time, in seconds, during which the job run consumed resources.</p>
    ///   - [`job_name(Option<String>)`](crate::output::DescribeJobRunOutput::job_name): <p>The name of the job being processed during this run.</p>
    ///   - [`profile_configuration(Option<ProfileConfiguration>)`](crate::output::DescribeJobRunOutput::profile_configuration): <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
    ///   - [`validation_configurations(Option<Vec<ValidationConfiguration>>)`](crate::output::DescribeJobRunOutput::validation_configurations): <p>List of validation configurations that are applied to the profile job.</p>
    ///   - [`run_id(Option<String>)`](crate::output::DescribeJobRunOutput::run_id): <p>The unique identifier of the job run.</p>
    ///   - [`state(Option<JobRunState>)`](crate::output::DescribeJobRunOutput::state): <p>The current state of the job run entity itself.</p>
    ///   - [`log_subscription(Option<LogSubscription>)`](crate::output::DescribeJobRunOutput::log_subscription): <p>The current status of Amazon CloudWatch logging for the job run.</p>
    ///   - [`log_group_name(Option<String>)`](crate::output::DescribeJobRunOutput::log_group_name): <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages when it runs.</p>
    ///   - [`outputs(Option<Vec<Output>>)`](crate::output::DescribeJobRunOutput::outputs): <p>One or more output artifacts from a job run.</p>
    ///   - [`data_catalog_outputs(Option<Vec<DataCatalogOutput>>)`](crate::output::DescribeJobRunOutput::data_catalog_outputs): <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    ///   - [`database_outputs(Option<Vec<DatabaseOutput>>)`](crate::output::DescribeJobRunOutput::database_outputs): <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.</p>
    ///   - [`recipe_reference(Option<RecipeReference>)`](crate::output::DescribeJobRunOutput::recipe_reference): <p>Represents the name and version of a DataBrew recipe.</p>
    ///   - [`started_by(Option<String>)`](crate::output::DescribeJobRunOutput::started_by): <p>The Amazon Resource Name (ARN) of the user who started the job run.</p>
    ///   - [`started_on(Option<DateTime>)`](crate::output::DescribeJobRunOutput::started_on): <p>The date and time when the job run began.</p>
    ///   - [`job_sample(Option<JobSample>)`](crate::output::DescribeJobRunOutput::job_sample): <p>Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
    /// - On failure, responds with [`SdkError<DescribeJobRunError>`](crate::error::DescribeJobRunError)
    pub fn describe_job_run(&self) -> fluent_builders::DescribeJobRun {
        fluent_builders::DescribeJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProject`](crate::client::fluent_builders::DescribeProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeProject::set_name): <p>The name of the project to be described.</p>
    /// - On success, responds with [`DescribeProjectOutput`](crate::output::DescribeProjectOutput) with field(s):
    ///   - [`create_date(Option<DateTime>)`](crate::output::DescribeProjectOutput::create_date): <p>The date and time that the project was created.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeProjectOutput::created_by): <p>The identifier (user name) of the user who created the project.</p>
    ///   - [`dataset_name(Option<String>)`](crate::output::DescribeProjectOutput::dataset_name): <p>The dataset associated with the project.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeProjectOutput::last_modified_date): <p>The date and time that the project was last modified.</p>
    ///   - [`last_modified_by(Option<String>)`](crate::output::DescribeProjectOutput::last_modified_by): <p>The identifier (user name) of the user who last modified the project.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeProjectOutput::name): <p>The name of the project.</p>
    ///   - [`recipe_name(Option<String>)`](crate::output::DescribeProjectOutput::recipe_name): <p>The recipe associated with this job.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeProjectOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the project.</p>
    ///   - [`sample(Option<Sample>)`](crate::output::DescribeProjectOutput::sample): <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeProjectOutput::role_arn): <p>The ARN of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeProjectOutput::tags): <p>Metadata tags associated with this project.</p>
    ///   - [`session_status(Option<SessionStatus>)`](crate::output::DescribeProjectOutput::session_status): <p>Describes the current state of the session:</p>  <ul>   <li> <p> <code>PROVISIONING</code> - allocating resources for the session.</p> </li>   <li> <p> <code>INITIALIZING</code> - getting the session ready for first use.</p> </li>   <li> <p> <code>ASSIGNED</code> - the session is ready for use.</p> </li>  </ul>
    ///   - [`opened_by(Option<String>)`](crate::output::DescribeProjectOutput::opened_by): <p>The identifier (user name) of the user that opened the project for use. </p>
    ///   - [`open_date(Option<DateTime>)`](crate::output::DescribeProjectOutput::open_date): <p>The date and time when the project was opened. </p>
    /// - On failure, responds with [`SdkError<DescribeProjectError>`](crate::error::DescribeProjectError)
    pub fn describe_project(&self) -> fluent_builders::DescribeProject {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRecipe`](crate::client::fluent_builders::DescribeRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeRecipe::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeRecipe::set_name): <p>The name of the recipe to be described.</p>
    ///   - [`recipe_version(impl Into<String>)`](crate::client::fluent_builders::DescribeRecipe::recipe_version) / [`set_recipe_version(Option<String>)`](crate::client::fluent_builders::DescribeRecipe::set_recipe_version): <p>The recipe version identifier. If this parameter isn't specified, then the latest published version is returned.</p>
    /// - On success, responds with [`DescribeRecipeOutput`](crate::output::DescribeRecipeOutput) with field(s):
    ///   - [`created_by(Option<String>)`](crate::output::DescribeRecipeOutput::created_by): <p>The identifier (user name) of the user who created the recipe.</p>
    ///   - [`create_date(Option<DateTime>)`](crate::output::DescribeRecipeOutput::create_date): <p>The date and time that the recipe was created.</p>
    ///   - [`last_modified_by(Option<String>)`](crate::output::DescribeRecipeOutput::last_modified_by): <p>The identifier (user name) of the user who last modified the recipe.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeRecipeOutput::last_modified_date): <p>The date and time that the recipe was last modified.</p>
    ///   - [`project_name(Option<String>)`](crate::output::DescribeRecipeOutput::project_name): <p>The name of the project associated with this recipe.</p>
    ///   - [`published_by(Option<String>)`](crate::output::DescribeRecipeOutput::published_by): <p>The identifier (user name) of the user who last published the recipe.</p>
    ///   - [`published_date(Option<DateTime>)`](crate::output::DescribeRecipeOutput::published_date): <p>The date and time when the recipe was last published.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeRecipeOutput::description): <p>The description of the recipe.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeRecipeOutput::name): <p>The name of the recipe.</p>
    ///   - [`steps(Option<Vec<RecipeStep>>)`](crate::output::DescribeRecipeOutput::steps): <p>One or more steps to be performed by the recipe. Each step consists of an action, and the conditions under which the action should succeed.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeRecipeOutput::tags): <p>Metadata tags associated with this project.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeRecipeOutput::resource_arn): <p>The ARN of the recipe.</p>
    ///   - [`recipe_version(Option<String>)`](crate::output::DescribeRecipeOutput::recipe_version): <p>The recipe version identifier.</p>
    /// - On failure, responds with [`SdkError<DescribeRecipeError>`](crate::error::DescribeRecipeError)
    pub fn describe_recipe(&self) -> fluent_builders::DescribeRecipe {
        fluent_builders::DescribeRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRuleset`](crate::client::fluent_builders::DescribeRuleset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeRuleset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeRuleset::set_name): <p>The name of the ruleset to be described.</p>
    /// - On success, responds with [`DescribeRulesetOutput`](crate::output::DescribeRulesetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeRulesetOutput::name): <p>The name of the ruleset.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeRulesetOutput::description): <p>The description of the ruleset.</p>
    ///   - [`target_arn(Option<String>)`](crate::output::DescribeRulesetOutput::target_arn): <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is associated with.</p>
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::DescribeRulesetOutput::rules): <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
    ///   - [`create_date(Option<DateTime>)`](crate::output::DescribeRulesetOutput::create_date): <p>The date and time that the ruleset was created.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeRulesetOutput::created_by): <p>The Amazon Resource Name (ARN) of the user who created the ruleset.</p>
    ///   - [`last_modified_by(Option<String>)`](crate::output::DescribeRulesetOutput::last_modified_by): <p>The Amazon Resource Name (ARN) of the user who last modified the ruleset.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeRulesetOutput::last_modified_date): <p>The modification date and time of the ruleset.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeRulesetOutput::resource_arn): <p>The Amazon Resource Name (ARN) for the ruleset.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeRulesetOutput::tags): <p>Metadata tags that have been applied to the ruleset.</p>
    /// - On failure, responds with [`SdkError<DescribeRulesetError>`](crate::error::DescribeRulesetError)
    pub fn describe_ruleset(&self) -> fluent_builders::DescribeRuleset {
        fluent_builders::DescribeRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSchedule`](crate::client::fluent_builders::DescribeSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeSchedule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeSchedule::set_name): <p>The name of the schedule to be described.</p>
    /// - On success, responds with [`DescribeScheduleOutput`](crate::output::DescribeScheduleOutput) with field(s):
    ///   - [`create_date(Option<DateTime>)`](crate::output::DescribeScheduleOutput::create_date): <p>The date and time that the schedule was created.</p>
    ///   - [`created_by(Option<String>)`](crate::output::DescribeScheduleOutput::created_by): <p>The identifier (user name) of the user who created the schedule. </p>
    ///   - [`job_names(Option<Vec<String>>)`](crate::output::DescribeScheduleOutput::job_names): <p>The name or names of one or more jobs to be run by using the schedule.</p>
    ///   - [`last_modified_by(Option<String>)`](crate::output::DescribeScheduleOutput::last_modified_by): <p>The identifier (user name) of the user who last modified the schedule.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeScheduleOutput::last_modified_date): <p>The date and time that the schedule was last modified.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeScheduleOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the schedule.</p>
    ///   - [`cron_expression(Option<String>)`](crate::output::DescribeScheduleOutput::cron_expression): <p>The date or dates and time or times when the jobs are to be run for the schedule. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeScheduleOutput::tags): <p>Metadata tags associated with this schedule.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeScheduleOutput::name): <p>The name of the schedule.</p>
    /// - On failure, responds with [`SdkError<DescribeScheduleError>`](crate::error::DescribeScheduleError)
    pub fn describe_schedule(&self) -> fluent_builders::DescribeSchedule {
        fluent_builders::DescribeSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasets`](crate::client::fluent_builders::ListDatasets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatasets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatasets::set_max_results): <p>The maximum number of results to return in this request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasets::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    /// - On success, responds with [`ListDatasetsOutput`](crate::output::ListDatasetsOutput) with field(s):
    ///   - [`datasets(Option<Vec<Dataset>>)`](crate::output::ListDatasetsOutput::datasets): <p>A list of datasets that are defined.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetsOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDatasetsError>`](crate::error::ListDatasetsError)
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobRuns`](crate::client::fluent_builders::ListJobRuns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobRuns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListJobRuns::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListJobRuns::set_name): <p>The name of the job.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobRuns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobRuns::set_max_results): <p>The maximum number of results to return in this request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobRuns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobRuns::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    /// - On success, responds with [`ListJobRunsOutput`](crate::output::ListJobRunsOutput) with field(s):
    ///   - [`job_runs(Option<Vec<JobRun>>)`](crate::output::ListJobRunsOutput::job_runs): <p>A list of job runs that have occurred for the specified job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobRunsOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListJobRunsError>`](crate::error::ListJobRunsError)
    pub fn list_job_runs(&self) -> fluent_builders::ListJobRuns {
        fluent_builders::ListJobRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobs`](crate::client::fluent_builders::ListJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::ListJobs::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::ListJobs::set_dataset_name): <p>The name of a dataset. Using this parameter indicates to return only those jobs that act on the specified dataset.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobs::set_max_results): <p>The maximum number of results to return in this request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobs::set_next_token): <p>A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call. </p>
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::ListJobs::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::ListJobs::set_project_name): <p>The name of a project. Using this parameter indicates to return only those jobs that are associated with the specified project.</p>
    /// - On success, responds with [`ListJobsOutput`](crate::output::ListJobsOutput) with field(s):
    ///   - [`jobs(Option<Vec<Job>>)`](crate::output::ListJobsOutput::jobs): <p>A list of jobs that are defined.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobsOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListJobsError>`](crate::error::ListJobsError)
    pub fn list_jobs(&self) -> fluent_builders::ListJobs {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjects`](crate::client::fluent_builders::ListProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjects::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProjects::set_max_results): <p>The maximum number of results to return in this request. </p>
    /// - On success, responds with [`ListProjectsOutput`](crate::output::ListProjectsOutput) with field(s):
    ///   - [`projects(Option<Vec<Project>>)`](crate::output::ListProjectsOutput::projects): <p>A list of projects that are defined .</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectsOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListProjectsError>`](crate::error::ListProjectsError)
    pub fn list_projects(&self) -> fluent_builders::ListProjects {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecipes`](crate::client::fluent_builders::ListRecipes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecipes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecipes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRecipes::set_max_results): <p>The maximum number of results to return in this request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecipes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecipes::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`recipe_version(impl Into<String>)`](crate::client::fluent_builders::ListRecipes::recipe_version) / [`set_recipe_version(Option<String>)`](crate::client::fluent_builders::ListRecipes::set_recipe_version): <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe versions.</p>  <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code> </p>
    /// - On success, responds with [`ListRecipesOutput`](crate::output::ListRecipesOutput) with field(s):
    ///   - [`recipes(Option<Vec<Recipe>>)`](crate::output::ListRecipesOutput::recipes): <p>A list of recipes that are defined.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRecipesOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListRecipesError>`](crate::error::ListRecipesError)
    pub fn list_recipes(&self) -> fluent_builders::ListRecipes {
        fluent_builders::ListRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecipeVersions`](crate::client::fluent_builders::ListRecipeVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecipeVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecipeVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRecipeVersions::set_max_results): <p>The maximum number of results to return in this request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecipeVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecipeVersions::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListRecipeVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListRecipeVersions::set_name): <p>The name of the recipe for which to return version information.</p>
    /// - On success, responds with [`ListRecipeVersionsOutput`](crate::output::ListRecipeVersionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRecipeVersionsOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    ///   - [`recipes(Option<Vec<Recipe>>)`](crate::output::ListRecipeVersionsOutput::recipes): <p>A list of versions for the specified recipe.</p>
    /// - On failure, responds with [`SdkError<ListRecipeVersionsError>`](crate::error::ListRecipeVersionsError)
    pub fn list_recipe_versions(&self) -> fluent_builders::ListRecipeVersions {
        fluent_builders::ListRecipeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRulesets`](crate::client::fluent_builders::ListRulesets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRulesets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::ListRulesets::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::ListRulesets::set_target_arn): <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those rulesets that are associated with the specified resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRulesets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRulesets::set_max_results): <p>The maximum number of results to return in this request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRulesets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRulesets::set_next_token): <p>A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call.</p>
    /// - On success, responds with [`ListRulesetsOutput`](crate::output::ListRulesetsOutput) with field(s):
    ///   - [`rulesets(Option<Vec<RulesetItem>>)`](crate::output::ListRulesetsOutput::rulesets): <p>A list of RulesetItem. RulesetItem contains meta data of a ruleset.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRulesetsOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListRulesetsError>`](crate::error::ListRulesetsError)
    pub fn list_rulesets(&self) -> fluent_builders::ListRulesets {
        fluent_builders::ListRulesets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSchedules`](crate::client::fluent_builders::ListSchedules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSchedules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::ListSchedules::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::ListSchedules::set_job_name): <p>The name of the job that these schedules apply to.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSchedules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSchedules::set_max_results): <p>The maximum number of results to return in this request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSchedules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSchedules::set_next_token): <p>The token returned by a previous call to retrieve the next set of results.</p>
    /// - On success, responds with [`ListSchedulesOutput`](crate::output::ListSchedulesOutput) with field(s):
    ///   - [`schedules(Option<Vec<Schedule>>)`](crate::output::ListSchedulesOutput::schedules): <p>A list of schedules that are defined.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSchedulesOutput::next_token): <p>A token that you can use in a subsequent call to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListSchedulesError>`](crate::error::ListSchedulesError)
    pub fn list_schedules(&self) -> fluent_builders::ListSchedules {
        fluent_builders::ListSchedules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tags associated with the DataBrew resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishRecipe`](crate::client::fluent_builders::PublishRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PublishRecipe::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PublishRecipe::set_description): <p>A description of the recipe to be published, for this version of the recipe.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PublishRecipe::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PublishRecipe::set_name): <p>The name of the recipe to be published.</p>
    /// - On success, responds with [`PublishRecipeOutput`](crate::output::PublishRecipeOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::PublishRecipeOutput::name): <p>The name of the recipe that you published.</p>
    /// - On failure, responds with [`SdkError<PublishRecipeError>`](crate::error::PublishRecipeError)
    pub fn publish_recipe(&self) -> fluent_builders::PublishRecipe {
        fluent_builders::PublishRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendProjectSessionAction`](crate::client::fluent_builders::SendProjectSessionAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`preview(bool)`](crate::client::fluent_builders::SendProjectSessionAction::preview) / [`set_preview(bool)`](crate::client::fluent_builders::SendProjectSessionAction::set_preview): <p>If true, the result of the recipe step will be returned, but not applied.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::SendProjectSessionAction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::SendProjectSessionAction::set_name): <p>The name of the project to apply the action to.</p>
    ///   - [`recipe_step(RecipeStep)`](crate::client::fluent_builders::SendProjectSessionAction::recipe_step) / [`set_recipe_step(Option<RecipeStep>)`](crate::client::fluent_builders::SendProjectSessionAction::set_recipe_step): <p>Represents a single step from a DataBrew recipe to be performed.</p>
    ///   - [`step_index(i32)`](crate::client::fluent_builders::SendProjectSessionAction::step_index) / [`set_step_index(Option<i32>)`](crate::client::fluent_builders::SendProjectSessionAction::set_step_index): <p>The index from which to preview a step. This index is used to preview the result of steps that have already been applied, so that the resulting view frame is from earlier in the view frame stack.</p>
    ///   - [`client_session_id(impl Into<String>)`](crate::client::fluent_builders::SendProjectSessionAction::client_session_id) / [`set_client_session_id(Option<String>)`](crate::client::fluent_builders::SendProjectSessionAction::set_client_session_id): <p>A unique identifier for an interactive session that's currently open and ready for work. The action will be performed on this session.</p>
    ///   - [`view_frame(ViewFrame)`](crate::client::fluent_builders::SendProjectSessionAction::view_frame) / [`set_view_frame(Option<ViewFrame>)`](crate::client::fluent_builders::SendProjectSessionAction::set_view_frame): <p>Represents the data being transformed during an action.</p>
    /// - On success, responds with [`SendProjectSessionActionOutput`](crate::output::SendProjectSessionActionOutput) with field(s):
    ///   - [`result(Option<String>)`](crate::output::SendProjectSessionActionOutput::result): <p>A message indicating the result of performing the action.</p>
    ///   - [`name(Option<String>)`](crate::output::SendProjectSessionActionOutput::name): <p>The name of the project that was affected by the action.</p>
    ///   - [`action_id(Option<i32>)`](crate::output::SendProjectSessionActionOutput::action_id): <p>A unique identifier for the action that was performed.</p>
    /// - On failure, responds with [`SdkError<SendProjectSessionActionError>`](crate::error::SendProjectSessionActionError)
    pub fn send_project_session_action(&self) -> fluent_builders::SendProjectSessionAction {
        fluent_builders::SendProjectSessionAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartJobRun`](crate::client::fluent_builders::StartJobRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartJobRun::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartJobRun::set_name): <p>The name of the job to be run.</p>
    /// - On success, responds with [`StartJobRunOutput`](crate::output::StartJobRunOutput) with field(s):
    ///   - [`run_id(Option<String>)`](crate::output::StartJobRunOutput::run_id): <p>A system-generated identifier for this particular job run.</p>
    /// - On failure, responds with [`SdkError<StartJobRunError>`](crate::error::StartJobRunError)
    pub fn start_job_run(&self) -> fluent_builders::StartJobRun {
        fluent_builders::StartJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartProjectSession`](crate::client::fluent_builders::StartProjectSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartProjectSession::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartProjectSession::set_name): <p>The name of the project to act upon.</p>
    ///   - [`assume_control(bool)`](crate::client::fluent_builders::StartProjectSession::assume_control) / [`set_assume_control(bool)`](crate::client::fluent_builders::StartProjectSession::set_assume_control): <p>A value that, if true, enables you to take control of a session, even if a different client is currently accessing the project.</p>
    /// - On success, responds with [`StartProjectSessionOutput`](crate::output::StartProjectSessionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::StartProjectSessionOutput::name): <p>The name of the project to be acted upon.</p>
    ///   - [`client_session_id(Option<String>)`](crate::output::StartProjectSessionOutput::client_session_id): <p>A system-generated identifier for the session.</p>
    /// - On failure, responds with [`SdkError<StartProjectSessionError>`](crate::error::StartProjectSessionError)
    pub fn start_project_session(&self) -> fluent_builders::StartProjectSession {
        fluent_builders::StartProjectSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopJobRun`](crate::client::fluent_builders::StopJobRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StopJobRun::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StopJobRun::set_name): <p>The name of the job to be stopped.</p>
    ///   - [`run_id(impl Into<String>)`](crate::client::fluent_builders::StopJobRun::run_id) / [`set_run_id(Option<String>)`](crate::client::fluent_builders::StopJobRun::set_run_id): <p>The ID of the job run to be stopped.</p>
    /// - On success, responds with [`StopJobRunOutput`](crate::output::StopJobRunOutput) with field(s):
    ///   - [`run_id(Option<String>)`](crate::output::StopJobRunOutput::run_id): <p>The ID of the job run that you stopped.</p>
    /// - On failure, responds with [`SdkError<StopJobRunError>`](crate::error::StopJobRunError)
    pub fn stop_job_run(&self) -> fluent_builders::StopJobRun {
        fluent_builders::StopJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The DataBrew resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or a recipe.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags to be assigned to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>A DataBrew resource from which you want to remove a tag or tags. The value for this parameter is an Amazon Resource Name (ARN). </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys (names) of one or more tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataset`](crate::client::fluent_builders::UpdateDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDataset::set_name): <p>The name of the dataset to be updated.</p>
    ///   - [`format(InputFormat)`](crate::client::fluent_builders::UpdateDataset::format) / [`set_format(Option<InputFormat>)`](crate::client::fluent_builders::UpdateDataset::set_format): <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    ///   - [`format_options(FormatOptions)`](crate::client::fluent_builders::UpdateDataset::format_options) / [`set_format_options(Option<FormatOptions>)`](crate::client::fluent_builders::UpdateDataset::set_format_options): <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
    ///   - [`input(Input)`](crate::client::fluent_builders::UpdateDataset::input) / [`set_input(Option<Input>)`](crate::client::fluent_builders::UpdateDataset::set_input): <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
    ///   - [`path_options(PathOptions)`](crate::client::fluent_builders::UpdateDataset::path_options) / [`set_path_options(Option<PathOptions>)`](crate::client::fluent_builders::UpdateDataset::set_path_options): <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    /// - On success, responds with [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateDatasetOutput::name): <p>The name of the dataset that you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateDatasetError>`](crate::error::UpdateDatasetError)
    pub fn update_dataset(&self) -> fluent_builders::UpdateDataset {
        fluent_builders::UpdateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProfileJob`](crate::client::fluent_builders::UpdateProfileJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration(ProfileConfiguration)`](crate::client::fluent_builders::UpdateProfileJob::configuration) / [`set_configuration(Option<ProfileConfiguration>)`](crate::client::fluent_builders::UpdateProfileJob::set_configuration): <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
    ///   - [`encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateProfileJob::encryption_key_arn) / [`set_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateProfileJob::set_encryption_key_arn): <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
    ///   - [`encryption_mode(EncryptionMode)`](crate::client::fluent_builders::UpdateProfileJob::encryption_mode) / [`set_encryption_mode(Option<EncryptionMode>)`](crate::client::fluent_builders::UpdateProfileJob::set_encryption_mode): <p>The encryption mode for the job, which can be one of the following:</p>  <ul>   <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>   <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateProfileJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateProfileJob::set_name): <p>The name of the job to be updated.</p>
    ///   - [`log_subscription(LogSubscription)`](crate::client::fluent_builders::UpdateProfileJob::log_subscription) / [`set_log_subscription(Option<LogSubscription>)`](crate::client::fluent_builders::UpdateProfileJob::set_log_subscription): <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
    ///   - [`max_capacity(i32)`](crate::client::fluent_builders::UpdateProfileJob::max_capacity) / [`set_max_capacity(i32)`](crate::client::fluent_builders::UpdateProfileJob::set_max_capacity): <p>The maximum number of compute nodes that DataBrew can use when the job processes data.</p>
    ///   - [`max_retries(i32)`](crate::client::fluent_builders::UpdateProfileJob::max_retries) / [`set_max_retries(i32)`](crate::client::fluent_builders::UpdateProfileJob::set_max_retries): <p>The maximum number of times to retry the job after a job run fails.</p>
    ///   - [`output_location(S3Location)`](crate::client::fluent_builders::UpdateProfileJob::output_location) / [`set_output_location(Option<S3Location>)`](crate::client::fluent_builders::UpdateProfileJob::set_output_location): <p>Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.</p>
    ///   - [`validation_configurations(Vec<ValidationConfiguration>)`](crate::client::fluent_builders::UpdateProfileJob::validation_configurations) / [`set_validation_configurations(Option<Vec<ValidationConfiguration>>)`](crate::client::fluent_builders::UpdateProfileJob::set_validation_configurations): <p>List of validation configurations that are applied to the profile job.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateProfileJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateProfileJob::set_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
    ///   - [`timeout(i32)`](crate::client::fluent_builders::UpdateProfileJob::timeout) / [`set_timeout(i32)`](crate::client::fluent_builders::UpdateProfileJob::set_timeout): <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
    ///   - [`job_sample(JobSample)`](crate::client::fluent_builders::UpdateProfileJob::job_sample) / [`set_job_sample(Option<JobSample>)`](crate::client::fluent_builders::UpdateProfileJob::set_job_sample): <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the Profile job will be executed. If a JobSample value is not provided for profile jobs, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
    /// - On success, responds with [`UpdateProfileJobOutput`](crate::output::UpdateProfileJobOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateProfileJobOutput::name): <p>The name of the job that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateProfileJobError>`](crate::error::UpdateProfileJobError)
    pub fn update_profile_job(&self) -> fluent_builders::UpdateProfileJob {
        fluent_builders::UpdateProfileJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProject`](crate::client::fluent_builders::UpdateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sample(Sample)`](crate::client::fluent_builders::UpdateProject::sample) / [`set_sample(Option<Sample>)`](crate::client::fluent_builders::UpdateProject::set_sample): <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_name): <p>The name of the project to be updated.</p>
    /// - On success, responds with [`UpdateProjectOutput`](crate::output::UpdateProjectOutput) with field(s):
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::UpdateProjectOutput::last_modified_date): <p>The date and time that the project was last modified.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateProjectOutput::name): <p>The name of the project that you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateProjectError>`](crate::error::UpdateProjectError)
    pub fn update_project(&self) -> fluent_builders::UpdateProject {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRecipe`](crate::client::fluent_builders::UpdateRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRecipe::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRecipe::set_description): <p>A description of the recipe.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRecipe::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRecipe::set_name): <p>The name of the recipe to be updated.</p>
    ///   - [`steps(Vec<RecipeStep>)`](crate::client::fluent_builders::UpdateRecipe::steps) / [`set_steps(Option<Vec<RecipeStep>>)`](crate::client::fluent_builders::UpdateRecipe::set_steps): <p>One or more steps to be performed by the recipe. Each step consists of an action, and the conditions under which the action should succeed.</p>
    /// - On success, responds with [`UpdateRecipeOutput`](crate::output::UpdateRecipeOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateRecipeOutput::name): <p>The name of the recipe that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateRecipeError>`](crate::error::UpdateRecipeError)
    pub fn update_recipe(&self) -> fluent_builders::UpdateRecipe {
        fluent_builders::UpdateRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRecipeJob`](crate::client::fluent_builders::UpdateRecipeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateRecipeJob::encryption_key_arn) / [`set_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateRecipeJob::set_encryption_key_arn): <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
    ///   - [`encryption_mode(EncryptionMode)`](crate::client::fluent_builders::UpdateRecipeJob::encryption_mode) / [`set_encryption_mode(Option<EncryptionMode>)`](crate::client::fluent_builders::UpdateRecipeJob::set_encryption_mode): <p>The encryption mode for the job, which can be one of the following:</p>  <ul>   <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>   <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRecipeJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRecipeJob::set_name): <p>The name of the job to update.</p>
    ///   - [`log_subscription(LogSubscription)`](crate::client::fluent_builders::UpdateRecipeJob::log_subscription) / [`set_log_subscription(Option<LogSubscription>)`](crate::client::fluent_builders::UpdateRecipeJob::set_log_subscription): <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
    ///   - [`max_capacity(i32)`](crate::client::fluent_builders::UpdateRecipeJob::max_capacity) / [`set_max_capacity(i32)`](crate::client::fluent_builders::UpdateRecipeJob::set_max_capacity): <p>The maximum number of nodes that DataBrew can consume when the job processes data.</p>
    ///   - [`max_retries(i32)`](crate::client::fluent_builders::UpdateRecipeJob::max_retries) / [`set_max_retries(i32)`](crate::client::fluent_builders::UpdateRecipeJob::set_max_retries): <p>The maximum number of times to retry the job after a job run fails.</p>
    ///   - [`outputs(Vec<Output>)`](crate::client::fluent_builders::UpdateRecipeJob::outputs) / [`set_outputs(Option<Vec<Output>>)`](crate::client::fluent_builders::UpdateRecipeJob::set_outputs): <p>One or more artifacts that represent the output from running the job. </p>
    ///   - [`data_catalog_outputs(Vec<DataCatalogOutput>)`](crate::client::fluent_builders::UpdateRecipeJob::data_catalog_outputs) / [`set_data_catalog_outputs(Option<Vec<DataCatalogOutput>>)`](crate::client::fluent_builders::UpdateRecipeJob::set_data_catalog_outputs): <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    ///   - [`database_outputs(Vec<DatabaseOutput>)`](crate::client::fluent_builders::UpdateRecipeJob::database_outputs) / [`set_database_outputs(Option<Vec<DatabaseOutput>>)`](crate::client::fluent_builders::UpdateRecipeJob::set_database_outputs): <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateRecipeJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateRecipeJob::set_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
    ///   - [`timeout(i32)`](crate::client::fluent_builders::UpdateRecipeJob::timeout) / [`set_timeout(i32)`](crate::client::fluent_builders::UpdateRecipeJob::set_timeout): <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
    /// - On success, responds with [`UpdateRecipeJobOutput`](crate::output::UpdateRecipeJobOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateRecipeJobOutput::name): <p>The name of the job that you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateRecipeJobError>`](crate::error::UpdateRecipeJobError)
    pub fn update_recipe_job(&self) -> fluent_builders::UpdateRecipeJob {
        fluent_builders::UpdateRecipeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRuleset`](crate::client::fluent_builders::UpdateRuleset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleset::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRuleset::set_name): <p>The name of the ruleset to be updated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleset::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRuleset::set_description): <p>The description of the ruleset.</p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::UpdateRuleset::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::UpdateRuleset::set_rules): <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
    /// - On success, responds with [`UpdateRulesetOutput`](crate::output::UpdateRulesetOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateRulesetOutput::name): <p>The name of the updated ruleset.</p>
    /// - On failure, responds with [`SdkError<UpdateRulesetError>`](crate::error::UpdateRulesetError)
    pub fn update_ruleset(&self) -> fluent_builders::UpdateRuleset {
        fluent_builders::UpdateRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSchedule`](crate::client::fluent_builders::UpdateSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_names(Vec<String>)`](crate::client::fluent_builders::UpdateSchedule::job_names) / [`set_job_names(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSchedule::set_job_names): <p>The name or names of one or more jobs to be run for this schedule.</p>
    ///   - [`cron_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateSchedule::cron_expression) / [`set_cron_expression(Option<String>)`](crate::client::fluent_builders::UpdateSchedule::set_cron_expression): <p>The date or dates and time or times when the jobs are to be run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateSchedule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateSchedule::set_name): <p>The name of the schedule to update.</p>
    /// - On success, responds with [`UpdateScheduleOutput`](crate::output::UpdateScheduleOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateScheduleOutput::name): <p>The name of the schedule that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateScheduleError>`](crate::error::UpdateScheduleError)
    pub fn update_schedule(&self) -> fluent_builders::UpdateSchedule {
        fluent_builders::UpdateSchedule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDeleteRecipeVersion`.
    ///
    /// <p>Deletes one or more versions of a recipe at a time.</p>
    /// <p>The entire request will be rejected if:</p>
    /// <ul>
    /// <li> <p>The recipe does not exist.</p> </li>
    /// <li> <p>There is an invalid version identifier in the list of versions.</p> </li>
    /// <li> <p>The version list is empty.</p> </li>
    /// <li> <p>The version list size exceeds 50.</p> </li>
    /// <li> <p>The version list contains duplicate entries.</p> </li>
    /// </ul>
    /// <p>The request will complete successfully, but with partial failures, if:</p>
    /// <ul>
    /// <li> <p>A version does not exist.</p> </li>
    /// <li> <p>A version is being used by a job.</p> </li>
    /// <li> <p>You specify <code>LATEST_WORKING</code>, but it's being used by a project.</p> </li>
    /// <li> <p>The version fails to be deleted.</p> </li>
    /// </ul>
    /// <p>The <code>LATEST_WORKING</code> version will only be deleted if the recipe has no other versions. If you try to delete <code>LATEST_WORKING</code> while other versions exist (or if they can't be deleted), then <code>LATEST_WORKING</code> will be listed as partial failure in the response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteRecipeVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_recipe_version_input::Builder,
    }
    impl BatchDeleteRecipeVersion {
        /// Creates a new `BatchDeleteRecipeVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteRecipeVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteRecipeVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recipe whose versions are to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the recipe whose versions are to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `RecipeVersions`.
        ///
        /// To override the contents of this collection use [`set_recipe_versions`](Self::set_recipe_versions).
        ///
        /// <p>An array of version identifiers, for the recipe versions to be deleted. You can specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn recipe_versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_versions(input.into());
            self
        }
        /// <p>An array of version identifiers, for the recipe versions to be deleted. You can specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn set_recipe_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recipe_versions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates a new DataBrew dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl CreateDataset {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, input: crate::model::InputFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
        pub fn format_options(mut self, input: crate::model::FormatOptions) -> Self {
            self.inner = self.inner.format_options(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.inner = self.inner.set_format_options(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.inner = self.inner.input(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, input: crate::model::PathOptions) -> Self {
            self.inner = self.inner.path_options(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.inner = self.inner.set_path_options(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to this dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProfileJob`.
    ///
    /// <p>Creates a new job to analyze a dataset and create its data profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProfileJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_profile_job_input::Builder,
    }
    impl CreateProfileJob {
        /// Creates a new `CreateProfileJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProfileJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProfileJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset that this job is to act upon.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset that this job is to act upon.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.max_capacity(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.inner = self.inner.max_retries(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.</p>
        pub fn output_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.output_location(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
        pub fn configuration(mut self, input: crate::model::ProfileConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// Appends an item to `ValidationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            input: crate::model::ValidationConfiguration,
        ) -> Self {
            self.inner = self.inner.validation_configurations(input);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_validation_configurations(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.inner = self.inner.job_sample(input);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.inner = self.inner.set_job_sample(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a new DataBrew project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_input::Builder,
    }
    impl CreateProject {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an existing dataset to associate this project with.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of an existing dataset to associate this project with.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of an existing recipe to associate with the project.</p>
        pub fn recipe_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_name(input.into());
            self
        }
        /// <p>The name of an existing recipe to associate with the project.</p>
        pub fn set_recipe_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_name(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
        pub fn sample(mut self, input: crate::model::Sample) -> Self {
            self.inner = self.inner.sample(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.inner = self.inner.set_sample(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed for this request.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed for this request.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecipe`.
    ///
    /// <p>Creates a new DataBrew recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_recipe_input::Builder,
    }
    impl CreateRecipe {
        /// Creates a new `CreateRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists of one recipe action and (optionally) an array of condition expressions.</p>
        pub fn steps(mut self, input: crate::model::RecipeStep) -> Self {
            self.inner = self.inner.steps(input);
            self
        }
        /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists of one recipe action and (optionally) an array of condition expressions.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to this recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecipeJob`.
    ///
    /// <p>Creates a new job to transform input data, using steps defined in an existing Glue DataBrew recipe</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecipeJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_recipe_job_input::Builder,
    }
    impl CreateRecipeJob {
        /// Creates a new `CreateRecipeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecipeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecipeJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset that this job processes.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset that this job processes.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.max_capacity(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.inner = self.inner.max_retries(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn outputs(mut self, input: crate::model::Output) -> Self {
            self.inner = self.inner.outputs(input);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// Appends an item to `DataCatalogOutputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(mut self, input: crate::model::DataCatalogOutput) -> Self {
            self.inner = self.inner.data_catalog_outputs(input);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.inner = self.inner.set_data_catalog_outputs(input);
            self
        }
        /// Appends an item to `DatabaseOutputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write to. </p>
        pub fn database_outputs(mut self, input: crate::model::DatabaseOutput) -> Self {
            self.inner = self.inner.database_outputs(input);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write to. </p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.inner = self.inner.set_database_outputs(input);
            self
        }
        /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to associate with the recipe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to associate with the recipe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn recipe_reference(mut self, input: crate::model::RecipeReference) -> Self {
            self.inner = self.inner.recipe_reference(input);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.inner = self.inner.set_recipe_reference(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleset`.
    ///
    /// <p>Creates a new ruleset that can be used in a profile job to validate the data quality of a dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRuleset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ruleset_input::Builder,
    }
    impl CreateRuleset {
        /// Creates a new `CreateRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRulesetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ruleset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is associated with.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is associated with.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to the ruleset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to the ruleset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSchedule`.
    ///
    /// <p>Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date and time, or at regular intervals.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_schedule_input::Builder,
    }
    impl CreateSchedule {
        /// Creates a new `CreateSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobNames`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_names(input.into());
            self
        }
        /// <p>The name or names of one or more jobs to be run.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_names(input);
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cron_expression(input.into());
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cron_expression(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this schedule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata tags to apply to this schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes a dataset from DataBrew.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl DeleteDataset {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the dataset to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes the specified DataBrew job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl DeleteJob {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an existing DataBrew project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl DeleteProject {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the project to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecipeVersion`.
    ///
    /// <p>Deletes a single version of a DataBrew recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecipeVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_recipe_version_input::Builder,
    }
    impl DeleteRecipeVersion {
        /// Creates a new `DeleteRecipeVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecipeVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecipeVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the recipe to be deleted. You can specify a numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_version(input.into());
            self
        }
        /// <p>The version of the recipe to be deleted. You can specify a numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recipe_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleset`.
    ///
    /// <p>Deletes a ruleset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRuleset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ruleset_input::Builder,
    }
    impl DeleteRuleset {
        /// Creates a new `DeleteRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRulesetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ruleset to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchedule`.
    ///
    /// <p>Deletes the specified DataBrew schedule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_schedule_input::Builder,
    }
    impl DeleteSchedule {
        /// Creates a new `DeleteSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the schedule to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the schedule to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Returns the definition of a specific DataBrew dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl DescribeDataset {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the dataset to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Returns the definition of a specific DataBrew job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl DescribeJob {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobRun`.
    ///
    /// <p>Represents one run of a DataBrew job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_run_input::Builder,
    }
    impl DescribeJobRun {
        /// Creates a new `DescribeJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(input.into());
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Returns the definition of a specific DataBrew project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl DescribeProject {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the project to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecipe`.
    ///
    /// <p>Returns the definition of a specific DataBrew recipe corresponding to a particular version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_recipe_input::Builder,
    }
    impl DescribeRecipe {
        /// Creates a new `DescribeRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recipe to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the recipe to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The recipe version identifier. If this parameter isn't specified, then the latest published version is returned.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_version(input.into());
            self
        }
        /// <p>The recipe version identifier. If this parameter isn't specified, then the latest published version is returned.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recipe_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleset`.
    ///
    /// <p>Retrieves detailed information about the ruleset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRuleset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_ruleset_input::Builder,
    }
    impl DescribeRuleset {
        /// Creates a new `DescribeRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRulesetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ruleset to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSchedule`.
    ///
    /// <p>Returns the definition of a specific DataBrew schedule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_schedule_input::Builder,
    }
    impl DescribeSchedule {
        /// Creates a new `DescribeSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the schedule to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the schedule to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Lists all of the DataBrew datasets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl ListDatasets {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatasetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatasetsPaginator {
            crate::paginator::ListDatasetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobRuns`.
    ///
    /// <p>Lists all of the previous runs of a particular DataBrew job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobRuns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_job_runs_input::Builder,
    }
    impl ListJobRuns {
        /// Creates a new `ListJobRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobRunsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobRunsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobRunsPaginator {
            crate::paginator::ListJobRunsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Lists all of the DataBrew jobs that are defined.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl ListJobs {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsPaginator {
            crate::paginator::ListJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that act on the specified dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that act on the specified dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of a project. Using this parameter indicates to return only those jobs that are associated with the specified project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of a project. Using this parameter indicates to return only those jobs that are associated with the specified project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Lists all of the DataBrew projects that are defined.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl ListProjects {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectsPaginator {
            crate::paginator::ListProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecipes`.
    ///
    /// <p>Lists all of the DataBrew recipes that are defined.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecipes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_recipes_input::Builder,
    }
    impl ListRecipes {
        /// Creates a new `ListRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecipesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecipesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecipesPaginator {
            crate::paginator::ListRecipesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe versions.</p>
        /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code> </p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_version(input.into());
            self
        }
        /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted, <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe versions.</p>
        /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code> </p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recipe_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecipeVersions`.
    ///
    /// <p>Lists the versions of a particular DataBrew recipe, except for <code>LATEST_WORKING</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecipeVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_recipe_versions_input::Builder,
    }
    impl ListRecipeVersions {
        /// Creates a new `ListRecipeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecipeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecipeVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecipeVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecipeVersionsPaginator {
            crate::paginator::ListRecipeVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of the recipe for which to return version information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the recipe for which to return version information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRulesets`.
    ///
    /// <p>List all rulesets available in the current account or rulesets associated with a specific resource (dataset).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRulesets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rulesets_input::Builder,
    }
    impl ListRulesets {
        /// Creates a new `ListRulesets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRulesetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRulesetsPaginator {
            crate::paginator::ListRulesetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those rulesets that are associated with the specified resource.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those rulesets that are associated with the specified resource.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchedules`.
    ///
    /// <p>Lists the DataBrew schedules that are defined.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSchedules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_schedules_input::Builder,
    }
    impl ListSchedules {
        /// Creates a new `ListSchedules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchedulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchedulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSchedulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSchedulesPaginator {
            crate::paginator::ListSchedulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the job that these schedules apply to.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The name of the job that these schedules apply to.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all the tags for a DataBrew resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishRecipe`.
    ///
    /// <p>Publishes a new version of a DataBrew recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_recipe_input::Builder,
    }
    impl PublishRecipe {
        /// Creates a new `PublishRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description of the recipe to be published, for this version of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the recipe to be published, for this version of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the recipe to be published.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the recipe to be published.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendProjectSessionAction`.
    ///
    /// <p>Performs a recipe step within an interactive DataBrew session that's currently open.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendProjectSessionAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_project_session_action_input::Builder,
    }
    impl SendProjectSessionAction {
        /// Creates a new `SendProjectSessionAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendProjectSessionActionOutput,
            aws_smithy_http::result::SdkError<crate::error::SendProjectSessionActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
        pub fn preview(mut self, input: bool) -> Self {
            self.inner = self.inner.preview(input);
            self
        }
        /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
        pub fn set_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_preview(input);
            self
        }
        /// <p>The name of the project to apply the action to.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the project to apply the action to.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
        pub fn recipe_step(mut self, input: crate::model::RecipeStep) -> Self {
            self.inner = self.inner.recipe_step(input);
            self
        }
        /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
        pub fn set_recipe_step(
            mut self,
            input: std::option::Option<crate::model::RecipeStep>,
        ) -> Self {
            self.inner = self.inner.set_recipe_step(input);
            self
        }
        /// <p>The index from which to preview a step. This index is used to preview the result of steps that have already been applied, so that the resulting view frame is from earlier in the view frame stack.</p>
        pub fn step_index(mut self, input: i32) -> Self {
            self.inner = self.inner.step_index(input);
            self
        }
        /// <p>The index from which to preview a step. This index is used to preview the result of steps that have already been applied, so that the resulting view frame is from earlier in the view frame stack.</p>
        pub fn set_step_index(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_step_index(input);
            self
        }
        /// <p>A unique identifier for an interactive session that's currently open and ready for work. The action will be performed on this session.</p>
        pub fn client_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_session_id(input.into());
            self
        }
        /// <p>A unique identifier for an interactive session that's currently open and ready for work. The action will be performed on this session.</p>
        pub fn set_client_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_session_id(input);
            self
        }
        /// <p>Represents the data being transformed during an action.</p>
        pub fn view_frame(mut self, input: crate::model::ViewFrame) -> Self {
            self.inner = self.inner.view_frame(input);
            self
        }
        /// <p>Represents the data being transformed during an action.</p>
        pub fn set_view_frame(
            mut self,
            input: std::option::Option<crate::model::ViewFrame>,
        ) -> Self {
            self.inner = self.inner.set_view_frame(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJobRun`.
    ///
    /// <p>Runs a DataBrew job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartJobRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_job_run_input::Builder,
    }
    impl StartJobRun {
        /// Creates a new `StartJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to be run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartProjectSession`.
    ///
    /// <p>Creates an interactive session, enabling you to manipulate data in a DataBrew project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartProjectSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_project_session_input::Builder,
    }
    impl StartProjectSession {
        /// Creates a new `StartProjectSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartProjectSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartProjectSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to act upon.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the project to act upon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A value that, if true, enables you to take control of a session, even if a different client is currently accessing the project.</p>
        pub fn assume_control(mut self, input: bool) -> Self {
            self.inner = self.inner.assume_control(input);
            self
        }
        /// <p>A value that, if true, enables you to take control of a session, even if a different client is currently accessing the project.</p>
        pub fn set_assume_control(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_assume_control(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopJobRun`.
    ///
    /// <p>Stops a particular run of a job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopJobRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_job_run_input::Builder,
    }
    impl StopJobRun {
        /// Creates a new `StopJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopJobRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be stopped.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to be stopped.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the job run to be stopped.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(input.into());
            self
        }
        /// <p>The ID of the job run to be stopped.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe, job, or schedule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DataBrew resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or a recipe.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The DataBrew resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or a recipe.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes metadata tags from a DataBrew resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this parameter is an Amazon Resource Name (ARN). </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this parameter is an Amazon Resource Name (ARN). </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys (names) of one or more tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys (names) of one or more tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataset`.
    ///
    /// <p>Modifies the definition of an existing DataBrew dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_dataset_input::Builder,
    }
    impl UpdateDataset {
        /// Creates a new `UpdateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the dataset to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, input: crate::model::InputFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
        pub fn format_options(mut self, input: crate::model::FormatOptions) -> Self {
            self.inner = self.inner.format_options(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.inner = self.inner.set_format_options(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.inner = self.inner.input(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, input: crate::model::PathOptions) -> Self {
            self.inner = self.inner.path_options(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.inner = self.inner.set_path_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProfileJob`.
    ///
    /// <p>Modifies the definition of an existing profile job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProfileJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_profile_job_input::Builder,
    }
    impl UpdateProfileJob {
        /// Creates a new `UpdateProfileJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProfileJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProfileJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
        pub fn configuration(mut self, input: crate::model::ProfileConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>The name of the job to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can use when the job processes data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.max_capacity(input);
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can use when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.inner = self.inner.max_retries(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.</p>
        pub fn output_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.output_location(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// Appends an item to `ValidationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            input: crate::model::ValidationConfiguration,
        ) -> Self {
            self.inner = self.inner.validation_configurations(input);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_validation_configurations(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the Profile job will be executed. If a JobSample value is not provided for profile jobs, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.inner = self.inner.job_sample(input);
            self
        }
        /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the Profile job will be executed. If a JobSample value is not provided for profile jobs, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.inner = self.inner.set_job_sample(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Modifies the definition of an existing DataBrew project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_project_input::Builder,
    }
    impl UpdateProject {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
        pub fn sample(mut self, input: crate::model::Sample) -> Self {
            self.inner = self.inner.sample(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.inner = self.inner.set_sample(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecipe`.
    ///
    /// <p>Modifies the definition of the <code>LATEST_WORKING</code> version of a DataBrew recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_recipe_input::Builder,
    }
    impl UpdateRecipe {
        /// Creates a new `UpdateRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the recipe to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the recipe to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and the conditions under which the action should succeed.</p>
        pub fn steps(mut self, input: crate::model::RecipeStep) -> Self {
            self.inner = self.inner.steps(input);
            self
        }
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and the conditions under which the action should succeed.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecipeJob`.
    ///
    /// <p>Modifies the definition of an existing DataBrew recipe job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRecipeJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_recipe_job_input::Builder,
    }
    impl UpdateRecipeJob {
        /// Creates a new `UpdateRecipeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecipeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecipeJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p> </li>
        /// <li> <p> <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p> </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>The name of the job to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the job to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.max_capacity(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.inner = self.inner.max_retries(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job. </p>
        pub fn outputs(mut self, input: crate::model::Output) -> Self {
            self.inner = self.inner.outputs(input);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job. </p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// Appends an item to `DataCatalogOutputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(mut self, input: crate::model::DataCatalogOutput) -> Self {
            self.inner = self.inner.data_catalog_outputs(input);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.inner = self.inner.set_data_catalog_outputs(input);
            self
        }
        /// Appends an item to `DatabaseOutputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, input: crate::model::DatabaseOutput) -> Self {
            self.inner = self.inner.database_outputs(input);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.inner = self.inner.set_database_outputs(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleset`.
    ///
    /// <p>Updates specified ruleset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_ruleset_input::Builder,
    }
    impl UpdateRuleset {
        /// Creates a new `UpdateRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRulesetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ruleset to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSchedule`.
    ///
    /// <p>Modifies the definition of an existing DataBrew schedule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_schedule_input::Builder,
    }
    impl UpdateSchedule {
        /// Creates a new `UpdateSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobNames`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run for this schedule.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_names(input.into());
            self
        }
        /// <p>The name or names of one or more jobs to be run for this schedule.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_names(input);
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cron_expression(input.into());
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew Developer Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cron_expression(input);
            self
        }
        /// <p>The name of the schedule to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the schedule to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
