// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchDeleteRecipeVersionInput`](crate::input::BatchDeleteRecipeVersionInput)
pub mod batch_delete_recipe_version_input {
    /// A builder for [`BatchDeleteRecipeVersionInput`](crate::input::BatchDeleteRecipeVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the recipe whose versions are to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe whose versions are to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `recipe_versions`.
        ///
        /// To override the contents of this collection use [`set_recipe_versions`](Self::set_recipe_versions).
        ///
        /// <p>An array of version identifiers, for the recipe versions to be deleted. You can
        /// specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>.
        /// <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn recipe_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recipe_versions.unwrap_or_default();
            v.push(input.into());
            self.recipe_versions = Some(v);
            self
        }
        /// <p>An array of version identifiers, for the recipe versions to be deleted. You can
        /// specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>.
        /// <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn set_recipe_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recipe_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteRecipeVersionInput`](crate::input::BatchDeleteRecipeVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteRecipeVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteRecipeVersionInput {
                name: self.name,
                recipe_versions: self.recipe_versions,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteRecipeVersionInputOperationOutputAlias =
    crate::operation::BatchDeleteRecipeVersion;
#[doc(hidden)]
pub type BatchDeleteRecipeVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDeleteRecipeVersionInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteRecipeVersion`](crate::operation::BatchDeleteRecipeVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteRecipeVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteRecipeVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_1, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recipes/{Name}/batchDeleteRecipeVersion",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteRecipeVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteRecipeVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_recipe_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteRecipeVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteRecipeVersion",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteRecipeVersionInput`](crate::input::BatchDeleteRecipeVersionInput)
    pub fn builder() -> crate::input::batch_delete_recipe_version_input::Builder {
        crate::input::batch_delete_recipe_version_input::Builder::default()
    }
}

/// See [`CreateDatasetInput`](crate::input::CreateDatasetInput)
pub mod create_dataset_input {
    /// A builder for [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::InputFormat>,
        pub(crate) format_options: std::option::Option<crate::model::FormatOptions>,
        pub(crate) input: std::option::Option<crate::model::Input>,
        pub(crate) path_options: std::option::Option<crate::model::PathOptions>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z,
        /// 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z,
        /// 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, input: crate::model::InputFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.format = input;
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn format_options(mut self, input: crate::model::FormatOptions) -> Self {
            self.format_options = Some(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.format_options = input;
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, input: crate::model::PathOptions) -> Self {
            self.path_options = Some(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.path_options = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to this dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetInput`](crate::input::CreateDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetInput {
                name: self.name,
                format: self.format,
                format_options: self.format_options,
                input: self.input,
                path_options: self.path_options,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetInputOperationOutputAlias = crate::operation::CreateDataset;
#[doc(hidden)]
pub type CreateDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDatasetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataset`](crate::operation::CreateDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/datasets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_dataset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
}

/// See [`CreateProfileJobInput`](crate::input::CreateProfileJobInput)
pub mod create_profile_job_input {
    /// A builder for [`CreateProfileJobInput`](crate::input::CreateProfileJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) output_location: std::option::Option<crate::model::S3Location>,
        pub(crate) configuration: std::option::Option<crate::model::ProfileConfiguration>,
        pub(crate) validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) job_sample: std::option::Option<crate::model::JobSample>,
    }
    impl Builder {
        /// <p>The name of the dataset that this job is to act upon.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset that this job is to act upon.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with
        /// KMS-managed keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with
        /// KMS-managed keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn output_location(mut self, input: crate::model::S3Location) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn configuration(mut self, input: crate::model::ProfileConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            input: impl Into<crate::model::ValidationConfiguration>,
        ) -> Self {
            let mut v = self.validation_configurations.unwrap_or_default();
            v.push(input.into());
            self.validation_configurations = Some(v);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.validation_configurations = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed. If a JobSample value is not provided, the default value
        /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
        /// size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.job_sample = Some(input);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed. If a JobSample value is not provided, the default value
        /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
        /// size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.job_sample = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfileJobInput`](crate::input::CreateProfileJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProfileJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProfileJobInput {
                dataset_name: self.dataset_name,
                encryption_key_arn: self.encryption_key_arn,
                encryption_mode: self.encryption_mode,
                name: self.name,
                log_subscription: self.log_subscription,
                max_capacity: self.max_capacity.unwrap_or_default(),
                max_retries: self.max_retries.unwrap_or_default(),
                output_location: self.output_location,
                configuration: self.configuration,
                validation_configurations: self.validation_configurations,
                role_arn: self.role_arn,
                tags: self.tags,
                timeout: self.timeout.unwrap_or_default(),
                job_sample: self.job_sample,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProfileJobInputOperationOutputAlias = crate::operation::CreateProfileJob;
#[doc(hidden)]
pub type CreateProfileJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProfileJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateProfileJob`](crate::operation::CreateProfileJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProfileJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProfileJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/profileJobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProfileJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProfileJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_profile_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProfileJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProfileJob",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProfileJobInput`](crate::input::CreateProfileJobInput)
    pub fn builder() -> crate::input::create_profile_job_input::Builder {
        crate::input::create_profile_job_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_name: std::option::Option<std::string::String>,
        pub(crate) sample: std::option::Option<crate::model::Sample>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of an existing dataset to associate this project with.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of an existing dataset to associate this project with.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of an existing recipe to associate with the project.</p>
        pub fn recipe_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_name = Some(input.into());
            self
        }
        /// <p>The name of an existing recipe to associate with the project.</p>
        pub fn set_recipe_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_name = input;
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn sample(mut self, input: crate::model::Sample) -> Self {
            self.sample = Some(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.sample = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed for this request.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed for this request.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                dataset_name: self.dataset_name,
                name: self.name,
                recipe_name: self.recipe_name,
                sample: self.sample,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`CreateRecipeInput`](crate::input::CreateRecipeInput)
pub mod create_recipe_input {
    /// A builder for [`CreateRecipeInput`](crate::input::CreateRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A description for the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists
        /// of one recipe action and (optionally) an array of condition expressions.</p>
        pub fn steps(mut self, input: impl Into<crate::model::RecipeStep>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists
        /// of one recipe action and (optionally) an array of condition expressions.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to this recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecipeInput`](crate::input::CreateRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRecipeInput {
                description: self.description,
                name: self.name,
                steps: self.steps,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRecipeInputOperationOutputAlias = crate::operation::CreateRecipe;
#[doc(hidden)]
pub type CreateRecipeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRecipeInput {
    /// Consumes the builder and constructs an Operation<[`CreateRecipe`](crate::operation::CreateRecipe)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRecipe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRecipeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/recipes").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRecipeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRecipeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_recipe(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRecipe",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRecipeInput`](crate::input::CreateRecipeInput)
    pub fn builder() -> crate::input::create_recipe_input::Builder {
        crate::input::create_recipe_input::Builder::default()
    }
}

/// See [`CreateRecipeJobInput`](crate::input::CreateRecipeJobInput)
pub mod create_recipe_job_input {
    /// A builder for [`CreateRecipeJobInput`](crate::input::CreateRecipeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) data_catalog_outputs:
            std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        pub(crate) database_outputs:
            std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) recipe_reference: std::option::Option<crate::model::RecipeReference>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the dataset that this job processes.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset that this job processes.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen
        /// (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen
        /// (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `data_catalog_outputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            input: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            let mut v = self.data_catalog_outputs.unwrap_or_default();
            v.push(input.into());
            self.data_catalog_outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.data_catalog_outputs = input;
            self
        }
        /// Appends an item to `database_outputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output destination for
        /// a DataBrew recipe job to write to. </p>
        pub fn database_outputs(mut self, input: impl Into<crate::model::DatabaseOutput>) -> Self {
            let mut v = self.database_outputs.unwrap_or_default();
            v.push(input.into());
            self.database_outputs = Some(v);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output destination for
        /// a DataBrew recipe job to write to. </p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.database_outputs = input;
            self
        }
        /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to
        /// associate with the recipe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to
        /// associate with the recipe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn recipe_reference(mut self, input: crate::model::RecipeReference) -> Self {
            self.recipe_reference = Some(input);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.recipe_reference = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecipeJobInput`](crate::input::CreateRecipeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRecipeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRecipeJobInput {
                dataset_name: self.dataset_name,
                encryption_key_arn: self.encryption_key_arn,
                encryption_mode: self.encryption_mode,
                name: self.name,
                log_subscription: self.log_subscription,
                max_capacity: self.max_capacity.unwrap_or_default(),
                max_retries: self.max_retries.unwrap_or_default(),
                outputs: self.outputs,
                data_catalog_outputs: self.data_catalog_outputs,
                database_outputs: self.database_outputs,
                project_name: self.project_name,
                recipe_reference: self.recipe_reference,
                role_arn: self.role_arn,
                tags: self.tags,
                timeout: self.timeout.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRecipeJobInputOperationOutputAlias = crate::operation::CreateRecipeJob;
#[doc(hidden)]
pub type CreateRecipeJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRecipeJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateRecipeJob`](crate::operation::CreateRecipeJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRecipeJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRecipeJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/recipeJobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRecipeJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRecipeJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_recipe_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRecipeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRecipeJob",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRecipeJobInput`](crate::input::CreateRecipeJobInput)
    pub fn builder() -> crate::input::create_recipe_job_input::Builder {
        crate::input::create_recipe_job_input::Builder::default()
    }
}

/// See [`CreateRulesetInput`](crate::input::CreateRulesetInput)
pub mod create_ruleset_input {
    /// A builder for [`CreateRulesetInput`](crate::input::CreateRulesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the ruleset to be created. Valid characters are alphanumeric
        /// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ruleset to be created. Valid characters are alphanumeric
        /// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the
        /// ruleset is associated with.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the
        /// ruleset is associated with.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes
        /// one or more checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes
        /// one or more checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to the ruleset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to the ruleset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRulesetInput`](crate::input::CreateRulesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRulesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRulesetInput {
                name: self.name,
                description: self.description,
                target_arn: self.target_arn,
                rules: self.rules,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRulesetInputOperationOutputAlias = crate::operation::CreateRuleset;
#[doc(hidden)]
pub type CreateRulesetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRulesetInput {
    /// Consumes the builder and constructs an Operation<[`CreateRuleset`](crate::operation::CreateRuleset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRuleset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRulesetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/rulesets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRulesetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRulesetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_ruleset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRuleset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRuleset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRulesetInput`](crate::input::CreateRulesetInput)
    pub fn builder() -> crate::input::create_ruleset_input::Builder {
        crate::input::create_ruleset_input::Builder::default()
    }
}

/// See [`CreateScheduleInput`](crate::input::CreateScheduleInput)
pub mod create_schedule_input {
    /// A builder for [`CreateScheduleInput`](crate::input::CreateScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cron_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_names`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_names.unwrap_or_default();
            v.push(input.into());
            self.job_names = Some(v);
            self
        }
        /// <p>The name or names of one or more jobs to be run.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_names = input;
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.cron_expression = Some(input.into());
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this schedule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags to apply to this schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScheduleInput`](crate::input::CreateScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateScheduleInput {
                job_names: self.job_names,
                cron_expression: self.cron_expression,
                tags: self.tags,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateScheduleInputOperationOutputAlias = crate::operation::CreateSchedule;
#[doc(hidden)]
pub type CreateScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateScheduleInput {
    /// Consumes the builder and constructs an Operation<[`CreateSchedule`](crate::operation::CreateSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/schedules").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_schedule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSchedule",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateScheduleInput`](crate::input::CreateScheduleInput)
    pub fn builder() -> crate::input::create_schedule_input::Builder {
        crate::input::create_schedule_input::Builder::default()
    }
}

/// See [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
pub mod delete_dataset_input {
    /// A builder for [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDatasetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteDatasetInputOperationOutputAlias = crate::operation::DeleteDataset;
#[doc(hidden)]
pub type DeleteDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataset`](crate::operation::DeleteDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_2, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/datasets/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
}

/// See [`DeleteJobInput`](crate::input::DeleteJobInput)
pub mod delete_job_input {
    /// A builder for [`DeleteJobInput`](crate::input::DeleteJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobInput`](crate::input::DeleteJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteJobInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobInputOperationOutputAlias = crate::operation::DeleteJob;
#[doc(hidden)]
pub type DeleteJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJob`](crate::operation::DeleteJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_3, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteJob",
                    "databrew",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_4, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DeleteRecipeVersionInput`](crate::input::DeleteRecipeVersionInput)
pub mod delete_recipe_version_input {
    /// A builder for [`DeleteRecipeVersionInput`](crate::input::DeleteRecipeVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the recipe to be deleted. You can specify a numeric versions
        /// (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is
        /// not supported.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The version of the recipe to be deleted. You can specify a numeric versions
        /// (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is
        /// not supported.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecipeVersionInput`](crate::input::DeleteRecipeVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRecipeVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRecipeVersionInput {
                name: self.name,
                recipe_version: self.recipe_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRecipeVersionInputOperationOutputAlias = crate::operation::DeleteRecipeVersion;
#[doc(hidden)]
pub type DeleteRecipeVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRecipeVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRecipeVersion`](crate::operation::DeleteRecipeVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRecipeVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRecipeVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_5, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.recipe_version;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recipe_version",
                        details: "cannot be empty or unset",
                    })?;
            let recipe_version = aws_smithy_http::label::fmt_string(input_6, false);
            if recipe_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recipe_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recipes/{Name}/recipeVersion/{RecipeVersion}",
                Name = name,
                RecipeVersion = recipe_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRecipeVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRecipeVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRecipeVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRecipeVersion",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRecipeVersionInput`](crate::input::DeleteRecipeVersionInput)
    pub fn builder() -> crate::input::delete_recipe_version_input::Builder {
        crate::input::delete_recipe_version_input::Builder::default()
    }
}

/// See [`DeleteRulesetInput`](crate::input::DeleteRulesetInput)
pub mod delete_ruleset_input {
    /// A builder for [`DeleteRulesetInput`](crate::input::DeleteRulesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ruleset to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ruleset to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRulesetInput`](crate::input::DeleteRulesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRulesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRulesetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteRulesetInputOperationOutputAlias = crate::operation::DeleteRuleset;
#[doc(hidden)]
pub type DeleteRulesetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRulesetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRuleset`](crate::operation::DeleteRuleset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRuleset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRulesetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_7, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/rulesets/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRulesetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRulesetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRuleset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRuleset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRulesetInput`](crate::input::DeleteRulesetInput)
    pub fn builder() -> crate::input::delete_ruleset_input::Builder {
        crate::input::delete_ruleset_input::Builder::default()
    }
}

/// See [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
pub mod delete_schedule_input {
    /// A builder for [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the schedule to be deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScheduleInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteScheduleInputOperationOutputAlias = crate::operation::DeleteSchedule;
#[doc(hidden)]
pub type DeleteScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSchedule`](crate::operation::DeleteSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_8, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/schedules/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSchedule",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
    pub fn builder() -> crate::input::delete_schedule_input::Builder {
        crate::input::delete_schedule_input::Builder::default()
    }
}

/// See [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
pub mod describe_dataset_input {
    /// A builder for [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetInputOperationOutputAlias = crate::operation::DescribeDataset;
#[doc(hidden)]
pub type DescribeDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataset`](crate::operation::DescribeDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_9, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/datasets/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
}

/// See [`DescribeJobInput`](crate::input::DescribeJobInput)
pub mod describe_job_input {
    /// A builder for [`DescribeJobInput`](crate::input::DescribeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobInput`](crate::input::DescribeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobInputOperationOutputAlias = crate::operation::DescribeJob;
#[doc(hidden)]
pub type DescribeJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJob`](crate::operation::DescribeJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_10, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJob",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
}

/// See [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
pub mod describe_job_run_input {
    /// A builder for [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job being processed during this run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobRunInput {
                name: self.name,
                run_id: self.run_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobRunInputOperationOutputAlias = crate::operation::DescribeJobRun;
#[doc(hidden)]
pub type DescribeJobRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJobRunInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobRun`](crate::operation::DescribeJobRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_11, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.run_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "run_id",
                        details: "cannot be empty or unset",
                    })?;
            let run_id = aws_smithy_http::label::fmt_string(input_12, false);
            if run_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "run_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/jobs/{Name}/jobRun/{RunId}",
                Name = name,
                RunId = run_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobRun",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobRunInput`](crate::input::DescribeJobRunInput)
    pub fn builder() -> crate::input::describe_job_run_input::Builder {
        crate::input::describe_job_run_input::Builder::default()
    }
}

/// See [`DescribeProjectInput`](crate::input::DescribeProjectInput)
pub mod describe_project_input {
    /// A builder for [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectInput`](crate::input::DescribeProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProjectInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeProjectInputOperationOutputAlias = crate::operation::DescribeProject;
#[doc(hidden)]
pub type DescribeProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProjectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProject`](crate::operation::DescribeProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_13, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProject",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
}

/// See [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
pub mod describe_recipe_input {
    /// A builder for [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The recipe version identifier. If this parameter isn't specified, then the latest
        /// published version is returned.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The recipe version identifier. If this parameter isn't specified, then the latest
        /// published version is returned.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRecipeInput {
                name: self.name,
                recipe_version: self.recipe_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRecipeInputOperationOutputAlias = crate::operation::DescribeRecipe;
#[doc(hidden)]
pub type DescribeRecipeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRecipeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRecipe`](crate::operation::DescribeRecipe)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRecipe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRecipeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.name;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_14, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/recipes/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeRecipeInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_15) = &_input.recipe_version {
                query.push_kv(
                    "recipeVersion",
                    &aws_smithy_http::query::fmt_string(&inner_15),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRecipeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRecipeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRecipe",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRecipeInput`](crate::input::DescribeRecipeInput)
    pub fn builder() -> crate::input::describe_recipe_input::Builder {
        crate::input::describe_recipe_input::Builder::default()
    }
}

/// See [`DescribeRulesetInput`](crate::input::DescribeRulesetInput)
pub mod describe_ruleset_input {
    /// A builder for [`DescribeRulesetInput`](crate::input::DescribeRulesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ruleset to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ruleset to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRulesetInput`](crate::input::DescribeRulesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRulesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRulesetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeRulesetInputOperationOutputAlias = crate::operation::DescribeRuleset;
#[doc(hidden)]
pub type DescribeRulesetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRulesetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRuleset`](crate::operation::DescribeRuleset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRuleset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRulesetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.name;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_16, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/rulesets/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRulesetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRulesetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRuleset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRuleset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRulesetInput`](crate::input::DescribeRulesetInput)
    pub fn builder() -> crate::input::describe_ruleset_input::Builder {
        crate::input::describe_ruleset_input::Builder::default()
    }
}

/// See [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
pub mod describe_schedule_input {
    /// A builder for [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the schedule to be described.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScheduleInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeScheduleInputOperationOutputAlias = crate::operation::DescribeSchedule;
#[doc(hidden)]
pub type DescribeScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSchedule`](crate::operation::DescribeSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.name;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_17, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/schedules/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSchedule",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
    pub fn builder() -> crate::input::describe_schedule_input::Builder {
        crate::input::describe_schedule_input::Builder::default()
    }
}

/// See [`ListDatasetsInput`](crate::input::ListDatasetsInput)
pub mod list_datasets_input {
    /// A builder for [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetsInput`](crate::input::ListDatasetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetsInputOperationOutputAlias = crate::operation::ListDatasets;
#[doc(hidden)]
pub type ListDatasetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatasetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasets`](crate::operation::ListDatasets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatasetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/datasets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDatasetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_18).encode(),
                );
            }
            if let Some(inner_19) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatasetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatasetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasets",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
}

/// See [`ListJobRunsInput`](crate::input::ListJobRunsInput)
pub mod list_job_runs_input {
    /// A builder for [`ListJobRunsInput`](crate::input::ListJobRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobRunsInput`](crate::input::ListJobRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListJobRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListJobRunsInput {
                name: self.name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobRunsInputOperationOutputAlias = crate::operation::ListJobRuns;
#[doc(hidden)]
pub type ListJobRunsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJobRunsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobRuns`](crate::operation::ListJobRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.name;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_20, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{Name}/jobRuns", Name = name).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJobRunsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListJobRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListJobRuns",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobRunsInput`](crate::input::ListJobRunsInput)
    pub fn builder() -> crate::input::list_job_runs_input::Builder {
        crate::input::list_job_runs_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that
        /// act on the specified dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that
        /// act on the specified dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a
        /// previous request was truncated. To get the next set of pages, pass in the NextToken
        /// value from the response object of the previous page call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a
        /// previous request was truncated. To get the next set of pages, pass in the NextToken
        /// value from the response object of the previous page call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The name of a project. Using this parameter indicates to return only those jobs that
        /// are associated with the specified project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of a project. Using this parameter indicates to return only those jobs that
        /// are associated with the specified project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                dataset_name: self.dataset_name,
                max_results: self.max_results,
                next_token: self.next_token,
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_23) = &_input.dataset_name {
                query.push_kv(
                    "datasetName",
                    &aws_smithy_http::query::fmt_string(&inner_23),
                );
            }
            if let Some(inner_24) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_24).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if let Some(inner_26) = &_input.project_name {
                query.push_kv(
                    "projectName",
                    &aws_smithy_http::query::fmt_string(&inner_26),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs", "databrew",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListProjectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_27));
            }
            if let Some(inner_28) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`ListRecipesInput`](crate::input::ListRecipesInput)
pub mod list_recipes_input {
    /// A builder for [`ListRecipesInput`](crate::input::ListRecipesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
        /// <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted,
        /// <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe
        /// versions.</p>
        /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
        /// </p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
        /// <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted,
        /// <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe
        /// versions.</p>
        /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
        /// </p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecipesInput`](crate::input::ListRecipesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecipesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecipesInput {
                max_results: self.max_results,
                next_token: self.next_token,
                recipe_version: self.recipe_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecipesInputOperationOutputAlias = crate::operation::ListRecipes;
#[doc(hidden)]
pub type ListRecipesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecipesInput {
    /// Consumes the builder and constructs an Operation<[`ListRecipes`](crate::operation::ListRecipes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecipes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecipesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/recipes").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecipesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_29) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_29).encode(),
                );
            }
            if let Some(inner_30) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_30));
            }
            if let Some(inner_31) = &_input.recipe_version {
                query.push_kv(
                    "recipeVersion",
                    &aws_smithy_http::query::fmt_string(&inner_31),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecipesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecipesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecipes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecipes",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecipesInput`](crate::input::ListRecipesInput)
    pub fn builder() -> crate::input::list_recipes_input::Builder {
        crate::input::list_recipes_input::Builder::default()
    }
}

/// See [`ListRecipeVersionsInput`](crate::input::ListRecipeVersionsInput)
pub mod list_recipe_versions_input {
    /// A builder for [`ListRecipeVersionsInput`](crate::input::ListRecipeVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The name of the recipe for which to return version information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe for which to return version information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecipeVersionsInput`](crate::input::ListRecipeVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecipeVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecipeVersionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecipeVersionsInputOperationOutputAlias = crate::operation::ListRecipeVersions;
#[doc(hidden)]
pub type ListRecipeVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecipeVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListRecipeVersions`](crate::operation::ListRecipeVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecipeVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecipeVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/recipeVersions").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecipeVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_32) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_32).encode(),
                );
            }
            if let Some(inner_33) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            if let Some(inner_34) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_34));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecipeVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecipeVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecipeVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecipeVersions",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecipeVersionsInput`](crate::input::ListRecipeVersionsInput)
    pub fn builder() -> crate::input::list_recipe_versions_input::Builder {
        crate::input::list_recipe_versions_input::Builder::default()
    }
}

/// See [`ListRulesetsInput`](crate::input::ListRulesetsInput)
pub mod list_rulesets_input {
    /// A builder for [`ListRulesetsInput`](crate::input::ListRulesetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
        /// indicates to return only those rulesets that are associated with the specified resource.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
        /// indicates to return only those rulesets that are associated with the specified resource.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination
        /// if a previous request was truncated. To get the next set of pages, pass in
        /// the NextToken value from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination
        /// if a previous request was truncated. To get the next set of pages, pass in
        /// the NextToken value from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesetsInput`](crate::input::ListRulesetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRulesetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRulesetsInput {
                target_arn: self.target_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRulesetsInputOperationOutputAlias = crate::operation::ListRulesets;
#[doc(hidden)]
pub type ListRulesetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRulesetsInput {
    /// Consumes the builder and constructs an Operation<[`ListRulesets`](crate::operation::ListRulesets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRulesets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRulesetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/rulesets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRulesetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_35) = &_input.target_arn {
                query.push_kv("targetArn", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            if let Some(inner_36) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_36).encode(),
                );
            }
            if let Some(inner_37) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRulesetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRulesetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRulesets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRulesets",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRulesetsInput`](crate::input::ListRulesetsInput)
    pub fn builder() -> crate::input::list_rulesets_input::Builder {
        crate::input::list_rulesets_input::Builder::default()
    }
}

/// See [`ListSchedulesInput`](crate::input::ListSchedulesInput)
pub mod list_schedules_input {
    /// A builder for [`ListSchedulesInput`](crate::input::ListSchedulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job that these schedules apply to.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job that these schedules apply to.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchedulesInput`](crate::input::ListSchedulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSchedulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSchedulesInput {
                job_name: self.job_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSchedulesInputOperationOutputAlias = crate::operation::ListSchedules;
#[doc(hidden)]
pub type ListSchedulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSchedulesInput {
    /// Consumes the builder and constructs an Operation<[`ListSchedules`](crate::operation::ListSchedules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSchedules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSchedulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/schedules").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSchedulesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_38) = &_input.job_name {
                query.push_kv("jobName", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            if let Some(inner_39) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_39).encode(),
                );
            }
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSchedulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSchedulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSchedules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSchedules",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSchedulesInput`](crate::input::ListSchedulesInput)
    pub fn builder() -> crate::input::list_schedules_input::Builder {
        crate::input::list_schedules_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource.
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.resource_arn;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_41, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PublishRecipeInput`](crate::input::PublishRecipeInput)
pub mod publish_recipe_input {
    /// A builder for [`PublishRecipeInput`](crate::input::PublishRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the recipe to be published, for this version of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the recipe to be published, for this version of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the recipe to be published.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe to be published.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishRecipeInput`](crate::input::PublishRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishRecipeInput {
                description: self.description,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishRecipeInputOperationOutputAlias = crate::operation::PublishRecipe;
#[doc(hidden)]
pub type PublishRecipeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PublishRecipeInput {
    /// Consumes the builder and constructs an Operation<[`PublishRecipe`](crate::operation::PublishRecipe)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishRecipe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PublishRecipeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.name;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_42, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/recipes/{Name}/publishRecipe", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PublishRecipeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PublishRecipeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_publish_recipe(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishRecipe",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PublishRecipeInput`](crate::input::PublishRecipeInput)
    pub fn builder() -> crate::input::publish_recipe_input::Builder {
        crate::input::publish_recipe_input::Builder::default()
    }
}

/// See [`SendProjectSessionActionInput`](crate::input::SendProjectSessionActionInput)
pub mod send_project_session_action_input {
    /// A builder for [`SendProjectSessionActionInput`](crate::input::SendProjectSessionActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preview: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_step: std::option::Option<crate::model::RecipeStep>,
        pub(crate) step_index: std::option::Option<i32>,
        pub(crate) client_session_id: std::option::Option<std::string::String>,
        pub(crate) view_frame: std::option::Option<crate::model::ViewFrame>,
    }
    impl Builder {
        /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
        pub fn preview(mut self, input: bool) -> Self {
            self.preview = Some(input);
            self
        }
        /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
        pub fn set_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.preview = input;
            self
        }
        /// <p>The name of the project to apply the action to.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project to apply the action to.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
        pub fn recipe_step(mut self, input: crate::model::RecipeStep) -> Self {
            self.recipe_step = Some(input);
            self
        }
        /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
        pub fn set_recipe_step(
            mut self,
            input: std::option::Option<crate::model::RecipeStep>,
        ) -> Self {
            self.recipe_step = input;
            self
        }
        /// <p>The index from which to preview a step. This index is used to preview the result of
        /// steps that have already been applied, so that the resulting view frame is from earlier
        /// in the view frame stack.</p>
        pub fn step_index(mut self, input: i32) -> Self {
            self.step_index = Some(input);
            self
        }
        /// <p>The index from which to preview a step. This index is used to preview the result of
        /// steps that have already been applied, so that the resulting view frame is from earlier
        /// in the view frame stack.</p>
        pub fn set_step_index(mut self, input: std::option::Option<i32>) -> Self {
            self.step_index = input;
            self
        }
        /// <p>A unique identifier for an interactive session that's currently open and ready for
        /// work. The action will be performed on this session.</p>
        pub fn client_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for an interactive session that's currently open and ready for
        /// work. The action will be performed on this session.</p>
        pub fn set_client_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_session_id = input;
            self
        }
        /// <p>Represents the data being transformed during an action.</p>
        pub fn view_frame(mut self, input: crate::model::ViewFrame) -> Self {
            self.view_frame = Some(input);
            self
        }
        /// <p>Represents the data being transformed during an action.</p>
        pub fn set_view_frame(
            mut self,
            input: std::option::Option<crate::model::ViewFrame>,
        ) -> Self {
            self.view_frame = input;
            self
        }
        /// Consumes the builder and constructs a [`SendProjectSessionActionInput`](crate::input::SendProjectSessionActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendProjectSessionActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendProjectSessionActionInput {
                preview: self.preview.unwrap_or_default(),
                name: self.name,
                recipe_step: self.recipe_step,
                step_index: self.step_index,
                client_session_id: self.client_session_id,
                view_frame: self.view_frame,
            })
        }
    }
}
#[doc(hidden)]
pub type SendProjectSessionActionInputOperationOutputAlias =
    crate::operation::SendProjectSessionAction;
#[doc(hidden)]
pub type SendProjectSessionActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendProjectSessionActionInput {
    /// Consumes the builder and constructs an Operation<[`SendProjectSessionAction`](crate::operation::SendProjectSessionAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendProjectSessionAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendProjectSessionActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.name;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_43, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{Name}/sendProjectSessionAction",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendProjectSessionActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendProjectSessionActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_project_session_action(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendProjectSessionAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendProjectSessionAction",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendProjectSessionActionInput`](crate::input::SendProjectSessionActionInput)
    pub fn builder() -> crate::input::send_project_session_action_input::Builder {
        crate::input::send_project_session_action_input::Builder::default()
    }
}

/// See [`StartJobRunInput`](crate::input::StartJobRunInput)
pub mod start_job_run_input {
    /// A builder for [`StartJobRunInput`](crate::input::StartJobRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job to be run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to be run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobRunInput`](crate::input::StartJobRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartJobRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartJobRunInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StartJobRunInputOperationOutputAlias = crate::operation::StartJobRun;
#[doc(hidden)]
pub type StartJobRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartJobRunInput {
    /// Consumes the builder and constructs an Operation<[`StartJobRun`](crate::operation::StartJobRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartJobRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartJobRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.name;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_44, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{Name}/startJobRun", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartJobRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartJobRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartJobRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartJobRun",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartJobRunInput`](crate::input::StartJobRunInput)
    pub fn builder() -> crate::input::start_job_run_input::Builder {
        crate::input::start_job_run_input::Builder::default()
    }
}

/// See [`StartProjectSessionInput`](crate::input::StartProjectSessionInput)
pub mod start_project_session_input {
    /// A builder for [`StartProjectSessionInput`](crate::input::StartProjectSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) assume_control: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the project to act upon.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project to act upon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A value that, if true, enables you to take control of a session, even if a different
        /// client is currently accessing the project.</p>
        pub fn assume_control(mut self, input: bool) -> Self {
            self.assume_control = Some(input);
            self
        }
        /// <p>A value that, if true, enables you to take control of a session, even if a different
        /// client is currently accessing the project.</p>
        pub fn set_assume_control(mut self, input: std::option::Option<bool>) -> Self {
            self.assume_control = input;
            self
        }
        /// Consumes the builder and constructs a [`StartProjectSessionInput`](crate::input::StartProjectSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartProjectSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartProjectSessionInput {
                name: self.name,
                assume_control: self.assume_control.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type StartProjectSessionInputOperationOutputAlias = crate::operation::StartProjectSession;
#[doc(hidden)]
pub type StartProjectSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartProjectSessionInput {
    /// Consumes the builder and constructs an Operation<[`StartProjectSession`](crate::operation::StartProjectSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartProjectSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartProjectSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.name;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_45, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{Name}/startProjectSession", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartProjectSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartProjectSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_project_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartProjectSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartProjectSession",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartProjectSessionInput`](crate::input::StartProjectSessionInput)
    pub fn builder() -> crate::input::start_project_session_input::Builder {
        crate::input::start_project_session_input::Builder::default()
    }
}

/// See [`StopJobRunInput`](crate::input::StopJobRunInput)
pub mod stop_job_run_input {
    /// A builder for [`StopJobRunInput`](crate::input::StopJobRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job to be stopped.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to be stopped.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the job run to be stopped.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The ID of the job run to be stopped.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopJobRunInput`](crate::input::StopJobRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopJobRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopJobRunInput {
                name: self.name,
                run_id: self.run_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopJobRunInputOperationOutputAlias = crate::operation::StopJobRun;
#[doc(hidden)]
pub type StopJobRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopJobRunInput {
    /// Consumes the builder and constructs an Operation<[`StopJobRun`](crate::operation::StopJobRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopJobRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopJobRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.name;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_46, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_47 = &_input.run_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "run_id",
                        details: "cannot be empty or unset",
                    })?;
            let run_id = aws_smithy_http::label::fmt_string(input_47, false);
            if run_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "run_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/jobs/{Name}/jobRun/{RunId}/stopJobRun",
                Name = name,
                RunId = run_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopJobRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopJobRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopJobRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopJobRun",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopJobRunInput`](crate::input::StopJobRunInput)
    pub fn builder() -> crate::input::stop_job_run_input::Builder {
        crate::input::stop_job_run_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The DataBrew resource to which tags should be added. The value for this parameter is
        /// an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or
        /// a recipe.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The DataBrew resource to which tags should be added. The value for this parameter is
        /// an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or
        /// a recipe.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.resource_arn;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_48, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this
        /// parameter is an Amazon Resource Name (ARN). </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this
        /// parameter is an Amazon Resource Name (ARN). </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys (names) of one or more tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys (names) of one or more tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.resource_arn;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_49, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_50) = &_input.tag_keys {
                for inner_51 in inner_50 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_51));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
pub mod update_dataset_input {
    /// A builder for [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::InputFormat>,
        pub(crate) format_options: std::option::Option<crate::model::FormatOptions>,
        pub(crate) input: std::option::Option<crate::model::Input>,
        pub(crate) path_options: std::option::Option<crate::model::PathOptions>,
    }
    impl Builder {
        /// <p>The name of the dataset to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, input: crate::model::InputFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.format = input;
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn format_options(mut self, input: crate::model::FormatOptions) -> Self {
            self.format_options = Some(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.format_options = input;
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, input: crate::model::PathOptions) -> Self {
            self.path_options = Some(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.path_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDatasetInput {
                name: self.name,
                format: self.format,
                format_options: self.format_options,
                input: self.input,
                path_options: self.path_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDatasetInputOperationOutputAlias = crate::operation::UpdateDataset;
#[doc(hidden)]
pub type UpdateDatasetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDatasetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataset`](crate::operation::UpdateDataset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDatasetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.name;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_52, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/datasets/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDatasetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDatasetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_dataset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    pub fn builder() -> crate::input::update_dataset_input::Builder {
        crate::input::update_dataset_input::Builder::default()
    }
}

/// See [`UpdateProfileJobInput`](crate::input::UpdateProfileJobInput)
pub mod update_profile_job_input {
    /// A builder for [`UpdateProfileJobInput`](crate::input::UpdateProfileJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::ProfileConfiguration>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) output_location: std::option::Option<crate::model::S3Location>,
        pub(crate) validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) job_sample: std::option::Option<crate::model::JobSample>,
    }
    impl Builder {
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn configuration(mut self, input: crate::model::ProfileConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
        /// S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
        /// S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>The name of the job to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can use when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can use when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn output_location(mut self, input: crate::model::S3Location) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// Appends an item to `validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            input: impl Into<crate::model::ValidationConfiguration>,
        ) -> Self {
            let mut v = self.validation_configurations.unwrap_or_default();
            v.push(input.into());
            self.validation_configurations = Some(v);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.validation_configurations = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the
        /// Profile job will be executed. If a JobSample value is not provided for profile jobs, the
        /// default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
        /// 20000 for the size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.job_sample = Some(input);
            self
        }
        /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the
        /// Profile job will be executed. If a JobSample value is not provided for profile jobs, the
        /// default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
        /// 20000 for the size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.job_sample = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfileJobInput`](crate::input::UpdateProfileJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProfileJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProfileJobInput {
                configuration: self.configuration,
                encryption_key_arn: self.encryption_key_arn,
                encryption_mode: self.encryption_mode,
                name: self.name,
                log_subscription: self.log_subscription,
                max_capacity: self.max_capacity.unwrap_or_default(),
                max_retries: self.max_retries.unwrap_or_default(),
                output_location: self.output_location,
                validation_configurations: self.validation_configurations,
                role_arn: self.role_arn,
                timeout: self.timeout.unwrap_or_default(),
                job_sample: self.job_sample,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProfileJobInputOperationOutputAlias = crate::operation::UpdateProfileJob;
#[doc(hidden)]
pub type UpdateProfileJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateProfileJobInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProfileJob`](crate::operation::UpdateProfileJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProfileJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProfileJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.name;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_53, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/profileJobs/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProfileJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProfileJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_profile_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProfileJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProfileJob",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProfileJobInput`](crate::input::UpdateProfileJobInput)
    pub fn builder() -> crate::input::update_profile_job_input::Builder {
        crate::input::update_profile_job_input::Builder::default()
    }
}

/// See [`UpdateProjectInput`](crate::input::UpdateProjectInput)
pub mod update_project_input {
    /// A builder for [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sample: std::option::Option<crate::model::Sample>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn sample(mut self, input: crate::model::Sample) -> Self {
            self.sample = Some(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.sample = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectInput`](crate::input::UpdateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectInput {
                sample: self.sample,
                role_arn: self.role_arn,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectInputOperationOutputAlias = crate::operation::UpdateProject;
#[doc(hidden)]
pub type UpdateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProject`](crate::operation::UpdateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.name;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_54, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_project(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProject",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
}

/// See [`UpdateRecipeInput`](crate::input::UpdateRecipeInput)
pub mod update_recipe_input {
    /// A builder for [`UpdateRecipeInput`](crate::input::UpdateRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
    }
    impl Builder {
        /// <p>A description of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the recipe to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
        /// the conditions under which the action should succeed.</p>
        pub fn steps(mut self, input: impl Into<crate::model::RecipeStep>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
        /// the conditions under which the action should succeed.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecipeInput`](crate::input::UpdateRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRecipeInput {
                description: self.description,
                name: self.name,
                steps: self.steps,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRecipeInputOperationOutputAlias = crate::operation::UpdateRecipe;
#[doc(hidden)]
pub type UpdateRecipeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRecipeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRecipe`](crate::operation::UpdateRecipe)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRecipe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRecipeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.name;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_55, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/recipes/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRecipeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRecipeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_recipe(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRecipe",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRecipeInput`](crate::input::UpdateRecipeInput)
    pub fn builder() -> crate::input::update_recipe_input::Builder {
        crate::input::update_recipe_input::Builder::default()
    }
}

/// See [`UpdateRecipeJobInput`](crate::input::UpdateRecipeJobInput)
pub mod update_recipe_job_input {
    /// A builder for [`UpdateRecipeJobInput`](crate::input::UpdateRecipeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) data_catalog_outputs:
            std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        pub(crate) database_outputs:
            std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>The name of the job to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job. </p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job. </p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `data_catalog_outputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            input: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            let mut v = self.data_catalog_outputs.unwrap_or_default();
            v.push(input.into());
            self.data_catalog_outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.data_catalog_outputs = input;
            self
        }
        /// Appends an item to `database_outputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a
        /// DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, input: impl Into<crate::model::DatabaseOutput>) -> Self {
            let mut v = self.database_outputs.unwrap_or_default();
            v.push(input.into());
            self.database_outputs = Some(v);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a
        /// DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.database_outputs = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecipeJobInput`](crate::input::UpdateRecipeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRecipeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRecipeJobInput {
                encryption_key_arn: self.encryption_key_arn,
                encryption_mode: self.encryption_mode,
                name: self.name,
                log_subscription: self.log_subscription,
                max_capacity: self.max_capacity.unwrap_or_default(),
                max_retries: self.max_retries.unwrap_or_default(),
                outputs: self.outputs,
                data_catalog_outputs: self.data_catalog_outputs,
                database_outputs: self.database_outputs,
                role_arn: self.role_arn,
                timeout: self.timeout.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRecipeJobInputOperationOutputAlias = crate::operation::UpdateRecipeJob;
#[doc(hidden)]
pub type UpdateRecipeJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRecipeJobInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRecipeJob`](crate::operation::UpdateRecipeJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRecipeJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRecipeJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.name;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_56, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/recipeJobs/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRecipeJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRecipeJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_recipe_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRecipeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRecipeJob",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRecipeJobInput`](crate::input::UpdateRecipeJobInput)
    pub fn builder() -> crate::input::update_recipe_job_input::Builder {
        crate::input::update_recipe_job_input::Builder::default()
    }
}

/// See [`UpdateRulesetInput`](crate::input::UpdateRulesetInput)
pub mod update_ruleset_input {
    /// A builder for [`UpdateRulesetInput`](crate::input::UpdateRulesetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    }
    impl Builder {
        /// <p>The name of the ruleset to be updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ruleset to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more
        /// checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more
        /// checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRulesetInput`](crate::input::UpdateRulesetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRulesetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRulesetInput {
                name: self.name,
                description: self.description,
                rules: self.rules,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRulesetInputOperationOutputAlias = crate::operation::UpdateRuleset;
#[doc(hidden)]
pub type UpdateRulesetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRulesetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRuleset`](crate::operation::UpdateRuleset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRuleset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRulesetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.name;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_57, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/rulesets/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRulesetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRulesetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_ruleset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRuleset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRuleset",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRulesetInput`](crate::input::UpdateRulesetInput)
    pub fn builder() -> crate::input::update_ruleset_input::Builder {
        crate::input::update_ruleset_input::Builder::default()
    }
}

/// See [`UpdateScheduleInput`](crate::input::UpdateScheduleInput)
pub mod update_schedule_input {
    /// A builder for [`UpdateScheduleInput`](crate::input::UpdateScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cron_expression: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_names`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run for this schedule.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_names.unwrap_or_default();
            v.push(input.into());
            self.job_names = Some(v);
            self
        }
        /// <p>The name or names of one or more jobs to be run for this schedule.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_names = input;
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.cron_expression = Some(input.into());
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression = input;
            self
        }
        /// <p>The name of the schedule to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScheduleInput`](crate::input::UpdateScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateScheduleInput {
                job_names: self.job_names,
                cron_expression: self.cron_expression,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateScheduleInputOperationOutputAlias = crate::operation::UpdateSchedule;
#[doc(hidden)]
pub type UpdateScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateScheduleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSchedule`](crate::operation::UpdateSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.name;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_58, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/schedules/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_schedule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSchedule",
            "databrew",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateScheduleInput`](crate::input::UpdateScheduleInput)
    pub fn builder() -> crate::input::update_schedule_input::Builder {
        crate::input::update_schedule_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScheduleInput {
    /// <p>The name or names of one or more jobs to be run for this schedule.</p>
    pub job_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date or dates and time or times when the jobs are to be run. For more information,
    /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
    /// expressions</a> in the <i>Glue DataBrew Developer
    /// Guide</i>.</p>
    pub cron_expression: std::option::Option<std::string::String>,
    /// <p>The name of the schedule to update.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateScheduleInput {
    /// <p>The name or names of one or more jobs to be run for this schedule.</p>
    pub fn job_names(&self) -> std::option::Option<&[std::string::String]> {
        self.job_names.as_deref()
    }
    /// <p>The date or dates and time or times when the jobs are to be run. For more information,
    /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
    /// expressions</a> in the <i>Glue DataBrew Developer
    /// Guide</i>.</p>
    pub fn cron_expression(&self) -> std::option::Option<&str> {
        self.cron_expression.as_deref()
    }
    /// <p>The name of the schedule to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScheduleInput");
        formatter.field("job_names", &self.job_names);
        formatter.field("cron_expression", &self.cron_expression);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRulesetInput {
    /// <p>The name of the ruleset to be updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the ruleset.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of rules that are defined with the ruleset. A rule includes one or more
    /// checks to be validated on a DataBrew dataset.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
}
impl UpdateRulesetInput {
    /// <p>The name of the ruleset to be updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the ruleset.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of rules that are defined with the ruleset. A rule includes one or more
    /// checks to be validated on a DataBrew dataset.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for UpdateRulesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRulesetInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecipeJobInput {
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>The name of the job to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The maximum number of nodes that DataBrew can consume when the job processes
    /// data.</p>
    pub max_capacity: i32,
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub max_retries: i32,
    /// <p>One or more artifacts that represent the output from running the job. </p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub data_catalog_outputs: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
    /// <p>Represents a list of JDBC database output objects which defines the output destination for a
    /// DataBrew recipe job to write into.</p>
    pub database_outputs: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub timeout: i32,
}
impl UpdateRecipeJobInput {
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionMode> {
        self.encryption_mode.as_ref()
    }
    /// <p>The name of the job to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub fn log_subscription(&self) -> std::option::Option<&crate::model::LogSubscription> {
        self.log_subscription.as_ref()
    }
    /// <p>The maximum number of nodes that DataBrew can consume when the job processes
    /// data.</p>
    pub fn max_capacity(&self) -> i32 {
        self.max_capacity
    }
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub fn max_retries(&self) -> i32 {
        self.max_retries
    }
    /// <p>One or more artifacts that represent the output from running the job. </p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub fn data_catalog_outputs(&self) -> std::option::Option<&[crate::model::DataCatalogOutput]> {
        self.data_catalog_outputs.as_deref()
    }
    /// <p>Represents a list of JDBC database output objects which defines the output destination for a
    /// DataBrew recipe job to write into.</p>
    pub fn database_outputs(&self) -> std::option::Option<&[crate::model::DatabaseOutput]> {
        self.database_outputs.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
}
impl std::fmt::Debug for UpdateRecipeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecipeJobInput");
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("name", &self.name);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("outputs", &self.outputs);
        formatter.field("data_catalog_outputs", &self.data_catalog_outputs);
        formatter.field("database_outputs", &self.database_outputs);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecipeInput {
    /// <p>A description of the recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the recipe to be updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
    /// the conditions under which the action should succeed.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
}
impl UpdateRecipeInput {
    /// <p>A description of the recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the recipe to be updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
    /// the conditions under which the action should succeed.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::RecipeStep]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for UpdateRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecipeInput");
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectInput {
    /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
    /// analysis.</p>
    pub sample: std::option::Option<crate::model::Sample>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the project to be updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateProjectInput {
    /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
    /// analysis.</p>
    pub fn sample(&self) -> std::option::Option<&crate::model::Sample> {
        self.sample.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of the project to be updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectInput");
        formatter.field("sample", &self.sample);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfileJobInput {
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub configuration: std::option::Option<crate::model::ProfileConfiguration>,
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
    /// S3.</p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>The name of the job to be updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The maximum number of compute nodes that DataBrew can use when the job processes
    /// data.</p>
    pub max_capacity: i32,
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub max_retries: i32,
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
    /// input data, or write output from a job.</p>
    pub output_location: std::option::Option<crate::model::S3Location>,
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub timeout: i32,
    /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the
    /// Profile job will be executed. If a JobSample value is not provided for profile jobs, the
    /// default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
    /// 20000 for the size parameter.</p>
    pub job_sample: std::option::Option<crate::model::JobSample>,
}
impl UpdateProfileJobInput {
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ProfileConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
    /// S3.</p>
    /// </li>
    /// </ul>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionMode> {
        self.encryption_mode.as_ref()
    }
    /// <p>The name of the job to be updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub fn log_subscription(&self) -> std::option::Option<&crate::model::LogSubscription> {
        self.log_subscription.as_ref()
    }
    /// <p>The maximum number of compute nodes that DataBrew can use when the job processes
    /// data.</p>
    pub fn max_capacity(&self) -> i32 {
        self.max_capacity
    }
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub fn max_retries(&self) -> i32 {
        self.max_retries
    }
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
    /// input data, or write output from a job.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.output_location.as_ref()
    }
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub fn validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ValidationConfiguration]> {
        self.validation_configurations.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
    /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the
    /// Profile job will be executed. If a JobSample value is not provided for profile jobs, the
    /// default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
    /// 20000 for the size parameter.</p>
    pub fn job_sample(&self) -> std::option::Option<&crate::model::JobSample> {
        self.job_sample.as_ref()
    }
}
impl std::fmt::Debug for UpdateProfileJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfileJobInput");
        formatter.field("configuration", &self.configuration);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("name", &self.name);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("output_location", &self.output_location);
        formatter.field("validation_configurations", &self.validation_configurations);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("timeout", &self.timeout);
        formatter.field("job_sample", &self.job_sample);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetInput {
    /// <p>The name of the dataset to be updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    pub format: std::option::Option<crate::model::InputFormat>,
    /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
    /// Excel, or JSON input.</p>
    pub format_options: std::option::Option<crate::model::FormatOptions>,
    /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
    /// Amazon S3.</p>
    pub input: std::option::Option<crate::model::Input>,
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    pub path_options: std::option::Option<crate::model::PathOptions>,
}
impl UpdateDatasetInput {
    /// <p>The name of the dataset to be updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::InputFormat> {
        self.format.as_ref()
    }
    /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
    /// Excel, or JSON input.</p>
    pub fn format_options(&self) -> std::option::Option<&crate::model::FormatOptions> {
        self.format_options.as_ref()
    }
    /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
    /// Amazon S3.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    pub fn path_options(&self) -> std::option::Option<&crate::model::PathOptions> {
        self.path_options.as_ref()
    }
}
impl std::fmt::Debug for UpdateDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetInput");
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("format_options", &self.format_options);
        formatter.field("input", &self.input);
        formatter.field("path_options", &self.path_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this
    /// parameter is an Amazon Resource Name (ARN). </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys (names) of one or more tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this
    /// parameter is an Amazon Resource Name (ARN). </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys (names) of one or more tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The DataBrew resource to which tags should be added. The value for this parameter is
    /// an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or
    /// a recipe.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags to be assigned to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The DataBrew resource to which tags should be added. The value for this parameter is
    /// an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or
    /// a recipe.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>One or more tags to be assigned to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopJobRunInput {
    /// <p>The name of the job to be stopped.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the job run to be stopped.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl StopJobRunInput {
    /// <p>The name of the job to be stopped.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the job run to be stopped.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
}
impl std::fmt::Debug for StopJobRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopJobRunInput");
        formatter.field("name", &self.name);
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartProjectSessionInput {
    /// <p>The name of the project to act upon.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A value that, if true, enables you to take control of a session, even if a different
    /// client is currently accessing the project.</p>
    pub assume_control: bool,
}
impl StartProjectSessionInput {
    /// <p>The name of the project to act upon.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A value that, if true, enables you to take control of a session, even if a different
    /// client is currently accessing the project.</p>
    pub fn assume_control(&self) -> bool {
        self.assume_control
    }
}
impl std::fmt::Debug for StartProjectSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartProjectSessionInput");
        formatter.field("name", &self.name);
        formatter.field("assume_control", &self.assume_control);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobRunInput {
    /// <p>The name of the job to be run.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StartJobRunInput {
    /// <p>The name of the job to be run.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StartJobRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobRunInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendProjectSessionActionInput {
    /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
    pub preview: bool,
    /// <p>The name of the project to apply the action to.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
    pub recipe_step: std::option::Option<crate::model::RecipeStep>,
    /// <p>The index from which to preview a step. This index is used to preview the result of
    /// steps that have already been applied, so that the resulting view frame is from earlier
    /// in the view frame stack.</p>
    pub step_index: std::option::Option<i32>,
    /// <p>A unique identifier for an interactive session that's currently open and ready for
    /// work. The action will be performed on this session.</p>
    pub client_session_id: std::option::Option<std::string::String>,
    /// <p>Represents the data being transformed during an action.</p>
    pub view_frame: std::option::Option<crate::model::ViewFrame>,
}
impl SendProjectSessionActionInput {
    /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
    pub fn preview(&self) -> bool {
        self.preview
    }
    /// <p>The name of the project to apply the action to.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
    pub fn recipe_step(&self) -> std::option::Option<&crate::model::RecipeStep> {
        self.recipe_step.as_ref()
    }
    /// <p>The index from which to preview a step. This index is used to preview the result of
    /// steps that have already been applied, so that the resulting view frame is from earlier
    /// in the view frame stack.</p>
    pub fn step_index(&self) -> std::option::Option<i32> {
        self.step_index
    }
    /// <p>A unique identifier for an interactive session that's currently open and ready for
    /// work. The action will be performed on this session.</p>
    pub fn client_session_id(&self) -> std::option::Option<&str> {
        self.client_session_id.as_deref()
    }
    /// <p>Represents the data being transformed during an action.</p>
    pub fn view_frame(&self) -> std::option::Option<&crate::model::ViewFrame> {
        self.view_frame.as_ref()
    }
}
impl std::fmt::Debug for SendProjectSessionActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendProjectSessionActionInput");
        formatter.field("preview", &self.preview);
        formatter.field("name", &self.name);
        formatter.field("recipe_step", &self.recipe_step);
        formatter.field("step_index", &self.step_index);
        formatter.field("client_session_id", &"*** Sensitive Data Redacted ***");
        formatter.field("view_frame", &self.view_frame);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishRecipeInput {
    /// <p>A description of the recipe to be published, for this version of the recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the recipe to be published.</p>
    pub name: std::option::Option<std::string::String>,
}
impl PublishRecipeInput {
    /// <p>A description of the recipe to be published, for this version of the recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the recipe to be published.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for PublishRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishRecipeInput");
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource.
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource.
    /// </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchedulesInput {
    /// <p>The name of the job that these schedules apply to.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSchedulesInput {
    /// <p>The name of the job that these schedules apply to.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSchedulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchedulesInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesetsInput {
    /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
    /// indicates to return only those rulesets that are associated with the specified resource.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token generated by DataBrew that specifies where to continue pagination
    /// if a previous request was truncated. To get the next set of pages, pass in
    /// the NextToken value from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRulesetsInput {
    /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
    /// indicates to return only those rulesets that are associated with the specified resource.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The maximum number of results to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token generated by DataBrew that specifies where to continue pagination
    /// if a previous request was truncated. To get the next set of pages, pass in
    /// the NextToken value from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRulesetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesetsInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecipeVersionsInput {
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The name of the recipe for which to return version information.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ListRecipeVersionsInput {
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The name of the recipe for which to return version information.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ListRecipeVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecipeVersionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecipesInput {
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
    /// <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted,
    /// <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe
    /// versions.</p>
    /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
    /// </p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl ListRecipesInput {
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
    /// <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted,
    /// <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe
    /// versions.</p>
    /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
    /// </p>
    pub fn recipe_version(&self) -> std::option::Option<&str> {
        self.recipe_version.as_deref()
    }
}
impl std::fmt::Debug for ListRecipesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecipesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListProjectsInput {
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that
    /// act on the specified dataset.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token generated by DataBrew that specifies where to continue pagination if a
    /// previous request was truncated. To get the next set of pages, pass in the NextToken
    /// value from the response object of the previous page call. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The name of a project. Using this parameter indicates to return only those jobs that
    /// are associated with the specified project.</p>
    pub project_name: std::option::Option<std::string::String>,
}
impl ListJobsInput {
    /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that
    /// act on the specified dataset.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token generated by DataBrew that specifies where to continue pagination if a
    /// previous request was truncated. To get the next set of pages, pass in the NextToken
    /// value from the response object of the previous page call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The name of a project. Using this parameter indicates to return only those jobs that
    /// are associated with the specified project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("project_name", &self.project_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobRunsInput {
    /// <p>The name of the job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobRunsInput {
    /// <p>The name of the job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobRunsInput");
        formatter.field("name", &self.name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetsInput {
    /// <p>The maximum number of results to return in this request. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetsInput {
    /// <p>The maximum number of results to return in this request. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token returned by a previous call to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduleInput {
    /// <p>The name of the schedule to be described.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeScheduleInput {
    /// <p>The name of the schedule to be described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduleInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRulesetInput {
    /// <p>The name of the ruleset to be described.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeRulesetInput {
    /// <p>The name of the ruleset to be described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeRulesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRulesetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRecipeInput {
    /// <p>The name of the recipe to be described.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The recipe version identifier. If this parameter isn't specified, then the latest
    /// published version is returned.</p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl DescribeRecipeInput {
    /// <p>The name of the recipe to be described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The recipe version identifier. If this parameter isn't specified, then the latest
    /// published version is returned.</p>
    pub fn recipe_version(&self) -> std::option::Option<&str> {
        self.recipe_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRecipeInput");
        formatter.field("name", &self.name);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectInput {
    /// <p>The name of the project to be described.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeProjectInput {
    /// <p>The name of the project to be described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobRunInput {
    /// <p>The name of the job being processed during this run.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the job run.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl DescribeJobRunInput {
    /// <p>The name of the job being processed during this run.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier of the job run.</p>
    pub fn run_id(&self) -> std::option::Option<&str> {
        self.run_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobRunInput");
        formatter.field("name", &self.name);
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobInput {
    /// <p>The name of the job to be described.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeJobInput {
    /// <p>The name of the job to be described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetInput {
    /// <p>The name of the dataset to be described.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DescribeDatasetInput {
    /// <p>The name of the dataset to be described.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduleInput {
    /// <p>The name of the schedule to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteScheduleInput {
    /// <p>The name of the schedule to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduleInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRulesetInput {
    /// <p>The name of the ruleset to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteRulesetInput {
    /// <p>The name of the ruleset to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRulesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRulesetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecipeVersionInput {
    /// <p>The name of the recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the recipe to be deleted. You can specify a numeric versions
    /// (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is
    /// not supported.</p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl DeleteRecipeVersionInput {
    /// <p>The name of the recipe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the recipe to be deleted. You can specify a numeric versions
    /// (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is
    /// not supported.</p>
    pub fn recipe_version(&self) -> std::option::Option<&str> {
        self.recipe_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteRecipeVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecipeVersionInput");
        formatter.field("name", &self.name);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>The name of the project to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>The name of the project to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobInput {
    /// <p>The name of the job to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteJobInput {
    /// <p>The name of the job to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetInput {
    /// <p>The name of the dataset to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteDatasetInput {
    /// <p>The name of the dataset to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScheduleInput {
    /// <p>The name or names of one or more jobs to be run.</p>
    pub job_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date or dates and time or times when the jobs are to be run. For more information,
    /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
    /// expressions</a> in the <i>Glue DataBrew Developer
    /// Guide</i>.</p>
    pub cron_expression: std::option::Option<std::string::String>,
    /// <p>Metadata tags to apply to this schedule.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateScheduleInput {
    /// <p>The name or names of one or more jobs to be run.</p>
    pub fn job_names(&self) -> std::option::Option<&[std::string::String]> {
        self.job_names.as_deref()
    }
    /// <p>The date or dates and time or times when the jobs are to be run. For more information,
    /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
    /// expressions</a> in the <i>Glue DataBrew Developer
    /// Guide</i>.</p>
    pub fn cron_expression(&self) -> std::option::Option<&str> {
        self.cron_expression.as_deref()
    }
    /// <p>Metadata tags to apply to this schedule.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateScheduleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScheduleInput");
        formatter.field("job_names", &self.job_names);
        formatter.field("cron_expression", &self.cron_expression);
        formatter.field("tags", &self.tags);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRulesetInput {
    /// <p>The name of the ruleset to be created. Valid characters are alphanumeric
    /// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the ruleset.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the
    /// ruleset is associated with.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>A list of rules that are defined with the ruleset. A rule includes
    /// one or more checks to be validated on a DataBrew dataset.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>Metadata tags to apply to the ruleset.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRulesetInput {
    /// <p>The name of the ruleset to be created. Valid characters are alphanumeric
    /// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the ruleset.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the
    /// ruleset is associated with.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>A list of rules that are defined with the ruleset. A rule includes
    /// one or more checks to be validated on a DataBrew dataset.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>Metadata tags to apply to the ruleset.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRulesetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRulesetInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("rules", &self.rules);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecipeJobInput {
    /// <p>The name of the dataset that this job processes.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen
    /// (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The maximum number of nodes that DataBrew can consume when the job processes
    /// data.</p>
    pub max_capacity: i32,
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub max_retries: i32,
    /// <p>One or more artifacts that represent the output from running the job.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub data_catalog_outputs: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
    /// <p>Represents a list of JDBC database output objects which defines the output destination for
    /// a DataBrew recipe job to write to. </p>
    pub database_outputs: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
    /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to
    /// associate with the recipe.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>Represents the name and version of a DataBrew recipe.</p>
    pub recipe_reference: std::option::Option<crate::model::RecipeReference>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Metadata tags to apply to this job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub timeout: i32,
}
impl CreateRecipeJobInput {
    /// <p>The name of the dataset that this job processes.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionMode> {
        self.encryption_mode.as_ref()
    }
    /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen
    /// (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub fn log_subscription(&self) -> std::option::Option<&crate::model::LogSubscription> {
        self.log_subscription.as_ref()
    }
    /// <p>The maximum number of nodes that DataBrew can consume when the job processes
    /// data.</p>
    pub fn max_capacity(&self) -> i32 {
        self.max_capacity
    }
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub fn max_retries(&self) -> i32 {
        self.max_retries
    }
    /// <p>One or more artifacts that represent the output from running the job.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
    /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
    pub fn data_catalog_outputs(&self) -> std::option::Option<&[crate::model::DataCatalogOutput]> {
        self.data_catalog_outputs.as_deref()
    }
    /// <p>Represents a list of JDBC database output objects which defines the output destination for
    /// a DataBrew recipe job to write to. </p>
    pub fn database_outputs(&self) -> std::option::Option<&[crate::model::DatabaseOutput]> {
        self.database_outputs.as_deref()
    }
    /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to
    /// associate with the recipe.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>Represents the name and version of a DataBrew recipe.</p>
    pub fn recipe_reference(&self) -> std::option::Option<&crate::model::RecipeReference> {
        self.recipe_reference.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Metadata tags to apply to this job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
}
impl std::fmt::Debug for CreateRecipeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecipeJobInput");
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("name", &self.name);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("outputs", &self.outputs);
        formatter.field("data_catalog_outputs", &self.data_catalog_outputs);
        formatter.field("database_outputs", &self.database_outputs);
        formatter.field("project_name", &self.project_name);
        formatter.field("recipe_reference", &self.recipe_reference);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecipeInput {
    /// <p>A description for the recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists
    /// of one recipe action and (optionally) an array of condition expressions.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
    /// <p>Metadata tags to apply to this recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRecipeInput {
    /// <p>A description for the recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists
    /// of one recipe action and (optionally) an array of condition expressions.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::RecipeStep]> {
        self.steps.as_deref()
    }
    /// <p>Metadata tags to apply to this recipe.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecipeInput");
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("steps", &self.steps);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>The name of an existing dataset to associate this project with.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of an existing recipe to associate with the project.</p>
    pub recipe_name: std::option::Option<std::string::String>,
    /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
    /// analysis.</p>
    pub sample: std::option::Option<crate::model::Sample>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed for this request.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Metadata tags to apply to this project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateProjectInput {
    /// <p>The name of an existing dataset to associate this project with.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of an existing recipe to associate with the project.</p>
    pub fn recipe_name(&self) -> std::option::Option<&str> {
        self.recipe_name.as_deref()
    }
    /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
    /// analysis.</p>
    pub fn sample(&self) -> std::option::Option<&crate::model::Sample> {
        self.sample.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed for this request.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Metadata tags to apply to this project.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("name", &self.name);
        formatter.field("recipe_name", &self.recipe_name);
        formatter.field("sample", &self.sample);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfileJobInput {
    /// <p>The name of the dataset that this job is to act upon.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with
    /// KMS-managed keys.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
    pub max_capacity: i32,
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub max_retries: i32,
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
    /// input data, or write output from a job.</p>
    pub output_location: std::option::Option<crate::model::S3Location>,
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub configuration: std::option::Option<crate::model::ProfileConfiguration>,
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Metadata tags to apply to this job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub timeout: i32,
    /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
    /// profile job will be executed. If a JobSample value is not provided, the default value
    /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
    /// size parameter.</p>
    pub job_sample: std::option::Option<crate::model::JobSample>,
}
impl CreateProfileJobInput {
    /// <p>The name of the dataset that this job is to act upon.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
    /// job.</p>
    pub fn encryption_key_arn(&self) -> std::option::Option<&str> {
        self.encryption_key_arn.as_deref()
    }
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with
    /// KMS-managed keys.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionMode> {
        self.encryption_mode.as_ref()
    }
    /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9),
    /// hyphen (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
    /// CloudWatch writes one log stream for each job run.</p>
    pub fn log_subscription(&self) -> std::option::Option<&crate::model::LogSubscription> {
        self.log_subscription.as_ref()
    }
    /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
    pub fn max_capacity(&self) -> i32 {
        self.max_capacity
    }
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub fn max_retries(&self) -> i32 {
        self.max_retries
    }
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
    /// input data, or write output from a job.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.output_location.as_ref()
    }
    /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
    /// and override default parameters of evaluations. When configuration is null, the
    /// profile job will run with default settings.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ProfileConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>List of validation configurations that are applied to the profile job.</p>
    pub fn validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ValidationConfiguration]> {
        self.validation_configurations.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
    /// be assumed when DataBrew runs the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Metadata tags to apply to this job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
    /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
    /// profile job will be executed. If a JobSample value is not provided, the default value
    /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
    /// size parameter.</p>
    pub fn job_sample(&self) -> std::option::Option<&crate::model::JobSample> {
        self.job_sample.as_ref()
    }
}
impl std::fmt::Debug for CreateProfileJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfileJobInput");
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("name", &self.name);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("output_location", &self.output_location);
        formatter.field("configuration", &self.configuration);
        formatter.field("validation_configurations", &self.validation_configurations);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("timeout", &self.timeout);
        formatter.field("job_sample", &self.job_sample);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetInput {
    /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z,
    /// 0-9), hyphen (-), period (.), and space.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    pub format: std::option::Option<crate::model::InputFormat>,
    /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
    /// Excel, or JSON input.</p>
    pub format_options: std::option::Option<crate::model::FormatOptions>,
    /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
    /// Amazon S3.</p>
    pub input: std::option::Option<crate::model::Input>,
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    pub path_options: std::option::Option<crate::model::PathOptions>,
    /// <p>Metadata tags to apply to this dataset.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDatasetInput {
    /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z,
    /// 0-9), hyphen (-), period (.), and space.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::InputFormat> {
        self.format.as_ref()
    }
    /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
    /// Excel, or JSON input.</p>
    pub fn format_options(&self) -> std::option::Option<&crate::model::FormatOptions> {
        self.format_options.as_ref()
    }
    /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
    /// Amazon S3.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    pub fn path_options(&self) -> std::option::Option<&crate::model::PathOptions> {
        self.path_options.as_ref()
    }
    /// <p>Metadata tags to apply to this dataset.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetInput");
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("format_options", &self.format_options);
        formatter.field("input", &self.input);
        formatter.field("path_options", &self.path_options);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteRecipeVersionInput {
    /// <p>The name of the recipe whose versions are to be deleted.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An array of version identifiers, for the recipe versions to be deleted. You can
    /// specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>.
    /// <code>LATEST_PUBLISHED</code> is not supported.</p>
    pub recipe_versions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteRecipeVersionInput {
    /// <p>The name of the recipe whose versions are to be deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An array of version identifiers, for the recipe versions to be deleted. You can
    /// specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>.
    /// <code>LATEST_PUBLISHED</code> is not supported.</p>
    pub fn recipe_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.recipe_versions.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteRecipeVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteRecipeVersionInput");
        formatter.field("name", &self.name);
        formatter.field("recipe_versions", &self.recipe_versions);
        formatter.finish()
    }
}
