// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSGlueDataBrew`.
///
/// This client allows ergonomic access to a `AWSGlueDataBrew`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchDeleteRecipeVersion` operation.
    ///
    /// See [`BatchDeleteRecipeVersion`](crate::client::fluent_builders::BatchDeleteRecipeVersion) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_recipe_version(
        &self,
    ) -> fluent_builders::BatchDeleteRecipeVersion<C, M, R> {
        fluent_builders::BatchDeleteRecipeVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataset` operation.
    ///
    /// See [`CreateDataset`](crate::client::fluent_builders::CreateDataset) for more information about the
    /// operation and its arguments.
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset<C, M, R> {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProfileJob` operation.
    ///
    /// See [`CreateProfileJob`](crate::client::fluent_builders::CreateProfileJob) for more information about the
    /// operation and its arguments.
    pub fn create_profile_job(&self) -> fluent_builders::CreateProfileJob<C, M, R> {
        fluent_builders::CreateProfileJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecipe` operation.
    ///
    /// See [`CreateRecipe`](crate::client::fluent_builders::CreateRecipe) for more information about the
    /// operation and its arguments.
    pub fn create_recipe(&self) -> fluent_builders::CreateRecipe<C, M, R> {
        fluent_builders::CreateRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecipeJob` operation.
    ///
    /// See [`CreateRecipeJob`](crate::client::fluent_builders::CreateRecipeJob) for more information about the
    /// operation and its arguments.
    pub fn create_recipe_job(&self) -> fluent_builders::CreateRecipeJob<C, M, R> {
        fluent_builders::CreateRecipeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRuleset` operation.
    ///
    /// See [`CreateRuleset`](crate::client::fluent_builders::CreateRuleset) for more information about the
    /// operation and its arguments.
    pub fn create_ruleset(&self) -> fluent_builders::CreateRuleset<C, M, R> {
        fluent_builders::CreateRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSchedule` operation.
    ///
    /// See [`CreateSchedule`](crate::client::fluent_builders::CreateSchedule) for more information about the
    /// operation and its arguments.
    pub fn create_schedule(&self) -> fluent_builders::CreateSchedule<C, M, R> {
        fluent_builders::CreateSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJob` operation.
    ///
    /// See [`DeleteJob`](crate::client::fluent_builders::DeleteJob) for more information about the
    /// operation and its arguments.
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecipeVersion` operation.
    ///
    /// See [`DeleteRecipeVersion`](crate::client::fluent_builders::DeleteRecipeVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_recipe_version(&self) -> fluent_builders::DeleteRecipeVersion<C, M, R> {
        fluent_builders::DeleteRecipeVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRuleset` operation.
    ///
    /// See [`DeleteRuleset`](crate::client::fluent_builders::DeleteRuleset) for more information about the
    /// operation and its arguments.
    pub fn delete_ruleset(&self) -> fluent_builders::DeleteRuleset<C, M, R> {
        fluent_builders::DeleteRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSchedule` operation.
    ///
    /// See [`DeleteSchedule`](crate::client::fluent_builders::DeleteSchedule) for more information about the
    /// operation and its arguments.
    pub fn delete_schedule(&self) -> fluent_builders::DeleteSchedule<C, M, R> {
        fluent_builders::DeleteSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJob` operation.
    ///
    /// See [`DescribeJob`](crate::client::fluent_builders::DescribeJob) for more information about the
    /// operation and its arguments.
    pub fn describe_job(&self) -> fluent_builders::DescribeJob<C, M, R> {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobRun` operation.
    ///
    /// See [`DescribeJobRun`](crate::client::fluent_builders::DescribeJobRun) for more information about the
    /// operation and its arguments.
    pub fn describe_job_run(&self) -> fluent_builders::DescribeJobRun<C, M, R> {
        fluent_builders::DescribeJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProject` operation.
    ///
    /// See [`DescribeProject`](crate::client::fluent_builders::DescribeProject) for more information about the
    /// operation and its arguments.
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRecipe` operation.
    ///
    /// See [`DescribeRecipe`](crate::client::fluent_builders::DescribeRecipe) for more information about the
    /// operation and its arguments.
    pub fn describe_recipe(&self) -> fluent_builders::DescribeRecipe<C, M, R> {
        fluent_builders::DescribeRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRuleset` operation.
    ///
    /// See [`DescribeRuleset`](crate::client::fluent_builders::DescribeRuleset) for more information about the
    /// operation and its arguments.
    pub fn describe_ruleset(&self) -> fluent_builders::DescribeRuleset<C, M, R> {
        fluent_builders::DescribeRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSchedule` operation.
    ///
    /// See [`DescribeSchedule`](crate::client::fluent_builders::DescribeSchedule) for more information about the
    /// operation and its arguments.
    pub fn describe_schedule(&self) -> fluent_builders::DescribeSchedule<C, M, R> {
        fluent_builders::DescribeSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasets` operation.
    ///
    /// See [`ListDatasets`](crate::client::fluent_builders::ListDatasets) for more information about the
    /// operation and its arguments.
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets<C, M, R> {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobRuns` operation.
    ///
    /// See [`ListJobRuns`](crate::client::fluent_builders::ListJobRuns) for more information about the
    /// operation and its arguments.
    pub fn list_job_runs(&self) -> fluent_builders::ListJobRuns<C, M, R> {
        fluent_builders::ListJobRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecipes` operation.
    ///
    /// See [`ListRecipes`](crate::client::fluent_builders::ListRecipes) for more information about the
    /// operation and its arguments.
    pub fn list_recipes(&self) -> fluent_builders::ListRecipes<C, M, R> {
        fluent_builders::ListRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecipeVersions` operation.
    ///
    /// See [`ListRecipeVersions`](crate::client::fluent_builders::ListRecipeVersions) for more information about the
    /// operation and its arguments.
    pub fn list_recipe_versions(&self) -> fluent_builders::ListRecipeVersions<C, M, R> {
        fluent_builders::ListRecipeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRulesets` operation.
    ///
    /// See [`ListRulesets`](crate::client::fluent_builders::ListRulesets) for more information about the
    /// operation and its arguments.
    pub fn list_rulesets(&self) -> fluent_builders::ListRulesets<C, M, R> {
        fluent_builders::ListRulesets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSchedules` operation.
    ///
    /// See [`ListSchedules`](crate::client::fluent_builders::ListSchedules) for more information about the
    /// operation and its arguments.
    pub fn list_schedules(&self) -> fluent_builders::ListSchedules<C, M, R> {
        fluent_builders::ListSchedules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishRecipe` operation.
    ///
    /// See [`PublishRecipe`](crate::client::fluent_builders::PublishRecipe) for more information about the
    /// operation and its arguments.
    pub fn publish_recipe(&self) -> fluent_builders::PublishRecipe<C, M, R> {
        fluent_builders::PublishRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendProjectSessionAction` operation.
    ///
    /// See [`SendProjectSessionAction`](crate::client::fluent_builders::SendProjectSessionAction) for more information about the
    /// operation and its arguments.
    pub fn send_project_session_action(
        &self,
    ) -> fluent_builders::SendProjectSessionAction<C, M, R> {
        fluent_builders::SendProjectSessionAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartJobRun` operation.
    ///
    /// See [`StartJobRun`](crate::client::fluent_builders::StartJobRun) for more information about the
    /// operation and its arguments.
    pub fn start_job_run(&self) -> fluent_builders::StartJobRun<C, M, R> {
        fluent_builders::StartJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartProjectSession` operation.
    ///
    /// See [`StartProjectSession`](crate::client::fluent_builders::StartProjectSession) for more information about the
    /// operation and its arguments.
    pub fn start_project_session(&self) -> fluent_builders::StartProjectSession<C, M, R> {
        fluent_builders::StartProjectSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopJobRun` operation.
    ///
    /// See [`StopJobRun`](crate::client::fluent_builders::StopJobRun) for more information about the
    /// operation and its arguments.
    pub fn stop_job_run(&self) -> fluent_builders::StopJobRun<C, M, R> {
        fluent_builders::StopJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataset` operation.
    ///
    /// See [`UpdateDataset`](crate::client::fluent_builders::UpdateDataset) for more information about the
    /// operation and its arguments.
    pub fn update_dataset(&self) -> fluent_builders::UpdateDataset<C, M, R> {
        fluent_builders::UpdateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProfileJob` operation.
    ///
    /// See [`UpdateProfileJob`](crate::client::fluent_builders::UpdateProfileJob) for more information about the
    /// operation and its arguments.
    pub fn update_profile_job(&self) -> fluent_builders::UpdateProfileJob<C, M, R> {
        fluent_builders::UpdateProfileJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecipe` operation.
    ///
    /// See [`UpdateRecipe`](crate::client::fluent_builders::UpdateRecipe) for more information about the
    /// operation and its arguments.
    pub fn update_recipe(&self) -> fluent_builders::UpdateRecipe<C, M, R> {
        fluent_builders::UpdateRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecipeJob` operation.
    ///
    /// See [`UpdateRecipeJob`](crate::client::fluent_builders::UpdateRecipeJob) for more information about the
    /// operation and its arguments.
    pub fn update_recipe_job(&self) -> fluent_builders::UpdateRecipeJob<C, M, R> {
        fluent_builders::UpdateRecipeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRuleset` operation.
    ///
    /// See [`UpdateRuleset`](crate::client::fluent_builders::UpdateRuleset) for more information about the
    /// operation and its arguments.
    pub fn update_ruleset(&self) -> fluent_builders::UpdateRuleset<C, M, R> {
        fluent_builders::UpdateRuleset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSchedule` operation.
    ///
    /// See [`UpdateSchedule`](crate::client::fluent_builders::UpdateSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_schedule(&self) -> fluent_builders::UpdateSchedule<C, M, R> {
        fluent_builders::UpdateSchedule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDeleteRecipeVersion`.
    ///
    /// <p>Deletes one or more versions of a recipe at a time.</p>
    ///
    /// <p>The entire request will be rejected if:</p>
    /// <ul>
    /// <li>
    /// <p>The recipe does not exist.</p>
    /// </li>
    /// <li>
    /// <p>There is an invalid version identifier in the list of versions.</p>
    /// </li>
    /// <li>
    /// <p>The version list is empty.</p>
    /// </li>
    /// <li>
    /// <p>The version list size exceeds 50.</p>
    /// </li>
    /// <li>
    /// <p>The version list contains duplicate entries.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>The request will complete successfully, but with partial failures, if:</p>
    /// <ul>
    /// <li>
    /// <p>A version does not exist.</p>
    /// </li>
    /// <li>
    /// <p>A version is being used by a job.</p>
    /// </li>
    /// <li>
    /// <p>You specify <code>LATEST_WORKING</code>, but it's being used by a
    /// project.</p>
    /// </li>
    /// <li>
    /// <p>The version fails to be deleted.</p>
    /// </li>
    /// </ul>
    /// <p>The <code>LATEST_WORKING</code> version will only be deleted if the recipe has no
    /// other versions. If you try to delete <code>LATEST_WORKING</code> while other versions
    /// exist (or if they can't be deleted), then <code>LATEST_WORKING</code> will be listed as
    /// partial failure in the response.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteRecipeVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_recipe_version_input::Builder,
    }
    impl<C, M, R> BatchDeleteRecipeVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteRecipeVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteRecipeVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteRecipeVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteRecipeVersionInputOperationOutputAlias,
                crate::output::BatchDeleteRecipeVersionOutput,
                crate::error::BatchDeleteRecipeVersionError,
                crate::input::BatchDeleteRecipeVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recipe whose versions are to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recipe whose versions are to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `RecipeVersions`.
        ///
        /// To override the contents of this collection use [`set_recipe_versions`](Self::set_recipe_versions).
        ///
        /// <p>An array of version identifiers, for the recipe versions to be deleted. You can
        /// specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>.
        /// <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn recipe_versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_versions(inp);
            self
        }
        /// <p>An array of version identifiers, for the recipe versions to be deleted. You can
        /// specify numeric versions (<code>X.Y</code>) or <code>LATEST_WORKING</code>.
        /// <code>LATEST_PUBLISHED</code> is not supported.</p>
        pub fn set_recipe_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recipe_versions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates a new DataBrew dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl<C, M, R> CreateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetInputOperationOutputAlias,
                crate::output::CreateDatasetOutput,
                crate::error::CreateDatasetError,
                crate::input::CreateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z,
        /// 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z,
        /// 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, inp: crate::model::InputFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn format_options(mut self, inp: crate::model::FormatOptions) -> Self {
            self.inner = self.inner.format_options(inp);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.inner = self.inner.set_format_options(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn input(mut self, inp: crate::model::Input) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, inp: crate::model::PathOptions) -> Self {
            self.inner = self.inner.path_options(inp);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.inner = self.inner.set_path_options(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to this dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProfileJob`.
    ///
    /// <p>Creates a new job to analyze a dataset and create its data profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProfileJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_profile_job_input::Builder,
    }
    impl<C, M, R> CreateProfileJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProfileJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProfileJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProfileJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProfileJobInputOperationOutputAlias,
                crate::output::CreateProfileJobOutput,
                crate::error::CreateProfileJobError,
                crate::input::CreateProfileJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset that this job is to act upon.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset that this job is to act upon.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with
        /// KMS-managed keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, inp: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(inp);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with
        /// KMS-managed keys.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, inp: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(inp);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
        pub fn max_capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can use when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn output_location(mut self, inp: crate::model::S3Location) -> Self {
            self.inner = self.inner.output_location(inp);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn configuration(mut self, inp: crate::model::ProfileConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// Appends an item to `ValidationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            inp: impl Into<crate::model::ValidationConfiguration>,
        ) -> Self {
            self.inner = self.inner.validation_configurations(inp);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_validation_configurations(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed. If a JobSample value is not provided, the default value
        /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
        /// size parameter.</p>
        pub fn job_sample(mut self, inp: crate::model::JobSample) -> Self {
            self.inner = self.inner.job_sample(inp);
            self
        }
        /// <p>Sample configuration for profile jobs only. Determines the number of rows on which the
        /// profile job will be executed. If a JobSample value is not provided, the default value
        /// will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the
        /// size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.inner = self.inner.set_job_sample(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a new DataBrew project.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an existing dataset to associate this project with.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of an existing dataset to associate this project with.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the new project. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of an existing recipe to associate with the project.</p>
        pub fn recipe_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_name(inp);
            self
        }
        /// <p>The name of an existing recipe to associate with the project.</p>
        pub fn set_recipe_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_name(input);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn sample(mut self, inp: crate::model::Sample) -> Self {
            self.inner = self.inner.sample(inp);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.inner = self.inner.set_sample(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed for this request.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed for this request.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to this project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecipe`.
    ///
    /// <p>Creates a new DataBrew recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recipe_input::Builder,
    }
    impl<C, M, R> CreateRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecipeInputOperationOutputAlias,
                crate::output::CreateRecipeOutput,
                crate::error::CreateRecipeError,
                crate::input::CreateRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the recipe.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists
        /// of one recipe action and (optionally) an array of condition expressions.</p>
        pub fn steps(mut self, inp: impl Into<crate::model::RecipeStep>) -> Self {
            self.inner = self.inner.steps(inp);
            self
        }
        /// <p>An array containing the steps to be performed by the recipe. Each recipe step consists
        /// of one recipe action and (optionally) an array of condition expressions.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to this recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecipeJob`.
    ///
    /// <p>Creates a new job to transform input data, using steps defined in an existing Glue DataBrew recipe</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRecipeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recipe_job_input::Builder,
    }
    impl<C, M, R> CreateRecipeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecipeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecipeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecipeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecipeJobInputOperationOutputAlias,
                crate::output::CreateRecipeJobOutput,
                crate::error::CreateRecipeJobError,
                crate::input::CreateRecipeJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset that this job processes.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset that this job processes.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, inp: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(inp);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen
        /// (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen
        /// (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, inp: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(inp);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn outputs(mut self, inp: impl Into<crate::model::Output>) -> Self {
            self.inner = self.inner.outputs(inp);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// Appends an item to `DataCatalogOutputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            inp: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            self.inner = self.inner.data_catalog_outputs(inp);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.inner = self.inner.set_data_catalog_outputs(input);
            self
        }
        /// Appends an item to `DatabaseOutputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output destination for
        /// a DataBrew recipe job to write to. </p>
        pub fn database_outputs(mut self, inp: impl Into<crate::model::DatabaseOutput>) -> Self {
            self.inner = self.inner.database_outputs(inp);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output destination for
        /// a DataBrew recipe job to write to. </p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.inner = self.inner.set_database_outputs(input);
            self
        }
        /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to
        /// associate with the recipe.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>Either the name of an existing project, or a combination of a recipe and a dataset to
        /// associate with the recipe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn recipe_reference(mut self, inp: crate::model::RecipeReference) -> Self {
            self.inner = self.inner.recipe_reference(inp);
            self
        }
        /// <p>Represents the name and version of a DataBrew recipe.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.inner = self.inner.set_recipe_reference(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to this job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleset`.
    ///
    /// <p>Creates a new ruleset that can be used in a profile job to validate
    /// the data quality of a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRuleset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ruleset_input::Builder,
    }
    impl<C, M, R> CreateRuleset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRulesetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRulesetInputOperationOutputAlias,
                crate::output::CreateRulesetOutput,
                crate::error::CreateRulesetError,
                crate::input::CreateRulesetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be created. Valid characters are alphanumeric
        /// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ruleset to be created. Valid characters are alphanumeric
        /// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the
        /// ruleset is associated with.</p>
        pub fn target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset) that the
        /// ruleset is associated with.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes
        /// one or more checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::Rule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes
        /// one or more checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to the ruleset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to the ruleset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSchedule`.
    ///
    /// <p>Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific
    /// date and time, or at regular intervals.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_schedule_input::Builder,
    }
    impl<C, M, R> CreateSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateScheduleInputOperationOutputAlias,
                crate::output::CreateScheduleOutput,
                crate::error::CreateScheduleError,
                crate::input::CreateScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobNames`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run.</p>
        pub fn job_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_names(inp);
            self
        }
        /// <p>The name or names of one or more jobs to be run.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_names(input);
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn cron_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cron_expression(inp);
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cron_expression(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags to apply to this schedule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Metadata tags to apply to this schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9),
        /// hyphen (-), period (.), and space.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes a dataset from DataBrew.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the dataset to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes the specified DataBrew job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an existing DataBrew project.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the project to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecipeVersion`.
    ///
    /// <p>Deletes a single version of a DataBrew recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRecipeVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recipe_version_input::Builder,
    }
    impl<C, M, R> DeleteRecipeVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecipeVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecipeVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecipeVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecipeVersionInputOperationOutputAlias,
                crate::output::DeleteRecipeVersionOutput,
                crate::error::DeleteRecipeVersionError,
                crate::input::DeleteRecipeVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the recipe to be deleted. You can specify a numeric versions
        /// (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is
        /// not supported.</p>
        pub fn recipe_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_version(inp);
            self
        }
        /// <p>The version of the recipe to be deleted. You can specify a numeric versions
        /// (<code>X.Y</code>) or <code>LATEST_WORKING</code>. <code>LATEST_PUBLISHED</code> is
        /// not supported.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recipe_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleset`.
    ///
    /// <p>Deletes a ruleset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRuleset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ruleset_input::Builder,
    }
    impl<C, M, R> DeleteRuleset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRulesetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRulesetInputOperationOutputAlias,
                crate::output::DeleteRulesetOutput,
                crate::error::DeleteRulesetError,
                crate::input::DeleteRulesetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ruleset to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchedule`.
    ///
    /// <p>Deletes the specified DataBrew schedule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_schedule_input::Builder,
    }
    impl<C, M, R> DeleteSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteScheduleInputOperationOutputAlias,
                crate::output::DeleteScheduleOutput,
                crate::error::DeleteScheduleError,
                crate::input::DeleteScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the schedule to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the schedule to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Returns the definition of a specific DataBrew dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be described.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the dataset to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Returns the definition of a specific DataBrew job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl<C, M, R> DescribeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobInputOperationOutputAlias,
                crate::output::DescribeJobOutput,
                crate::error::DescribeJobError,
                crate::input::DescribeJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be described.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobRun`.
    ///
    /// <p>Represents one run of a DataBrew job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJobRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_run_input::Builder,
    }
    impl<C, M, R> DescribeJobRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobRunInputOperationOutputAlias,
                crate::output::DescribeJobRunOutput,
                crate::error::DescribeJobRunError,
                crate::input::DescribeJobRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Returns the definition of a specific DataBrew project.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to be described.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the project to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRecipe`.
    ///
    /// <p>Returns the definition of a specific DataBrew recipe corresponding to a particular
    /// version.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_recipe_input::Builder,
    }
    impl<C, M, R> DescribeRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRecipeInputOperationOutputAlias,
                crate::output::DescribeRecipeOutput,
                crate::error::DescribeRecipeError,
                crate::input::DescribeRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the recipe to be described.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recipe to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The recipe version identifier. If this parameter isn't specified, then the latest
        /// published version is returned.</p>
        pub fn recipe_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_version(inp);
            self
        }
        /// <p>The recipe version identifier. If this parameter isn't specified, then the latest
        /// published version is returned.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recipe_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRuleset`.
    ///
    /// <p>Retrieves detailed information about the ruleset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRuleset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ruleset_input::Builder,
    }
    impl<C, M, R> DescribeRuleset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRulesetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRulesetInputOperationOutputAlias,
                crate::output::DescribeRulesetOutput,
                crate::error::DescribeRulesetError,
                crate::input::DescribeRulesetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be described.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ruleset to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSchedule`.
    ///
    /// <p>Returns the definition of a specific DataBrew schedule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_schedule_input::Builder,
    }
    impl<C, M, R> DescribeSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScheduleInputOperationOutputAlias,
                crate::output::DescribeScheduleOutput,
                crate::error::DescribeScheduleError,
                crate::input::DescribeScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the schedule to be described.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the schedule to be described.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Lists all of the DataBrew datasets.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl<C, M, R> ListDatasets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetsInputOperationOutputAlias,
                crate::output::ListDatasetsOutput,
                crate::error::ListDatasetsError,
                crate::input::ListDatasetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobRuns`.
    ///
    /// <p>Lists all of the previous runs of a particular DataBrew job.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJobRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_job_runs_input::Builder,
    }
    impl<C, M, R> ListJobRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobRunsInputOperationOutputAlias,
                crate::output::ListJobRunsOutput,
                crate::error::ListJobRunsError,
                crate::input::ListJobRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Lists all of the DataBrew jobs that are defined.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that
        /// act on the specified dataset.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of a dataset. Using this parameter indicates to return only those jobs that
        /// act on the specified dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a
        /// previous request was truncated. To get the next set of pages, pass in the NextToken
        /// value from the response object of the previous page call. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination if a
        /// previous request was truncated. To get the next set of pages, pass in the NextToken
        /// value from the response object of the previous page call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of a project. Using this parameter indicates to return only those jobs that
        /// are associated with the specified project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of a project. Using this parameter indicates to return only those jobs that
        /// are associated with the specified project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Lists all of the DataBrew projects that are defined.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecipes`.
    ///
    /// <p>Lists all of the DataBrew recipes that are defined.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecipes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recipes_input::Builder,
    }
    impl<C, M, R> ListRecipes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecipesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecipesInputOperationOutputAlias,
                crate::output::ListRecipesOutput,
                crate::error::ListRecipesError,
                crate::input::ListRecipesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
        /// <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted,
        /// <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe
        /// versions.</p>
        /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
        /// </p>
        pub fn recipe_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_version(inp);
            self
        }
        /// <p>Return only those recipes with a version identifier of <code>LATEST_WORKING</code> or
        /// <code>LATEST_PUBLISHED</code>. If <code>RecipeVersion</code> is omitted,
        /// <code>ListRecipes</code> returns all of the <code>LATEST_PUBLISHED</code> recipe
        /// versions.</p>
        /// <p>Valid values: <code>LATEST_WORKING</code> | <code>LATEST_PUBLISHED</code>
        /// </p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recipe_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecipeVersions`.
    ///
    /// <p>Lists the versions of a particular DataBrew recipe, except for
    /// <code>LATEST_WORKING</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecipeVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recipe_versions_input::Builder,
    }
    impl<C, M, R> ListRecipeVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecipeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecipeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecipeVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecipeVersionsInputOperationOutputAlias,
                crate::output::ListRecipeVersionsOutput,
                crate::error::ListRecipeVersionsError,
                crate::input::ListRecipeVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of the recipe for which to return version information.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recipe for which to return version information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRulesets`.
    ///
    /// <p>List all rulesets available in the current account or rulesets associated
    /// with a specific resource (dataset).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRulesets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rulesets_input::Builder,
    }
    impl<C, M, R> ListRulesets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRulesets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRulesetsInputOperationOutputAlias,
                crate::output::ListRulesetsOutput,
                crate::error::ListRulesetsError,
                crate::input::ListRulesetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
        /// indicates to return only those rulesets that are associated with the specified resource.</p>
        pub fn target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
        /// indicates to return only those rulesets that are associated with the specified resource.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination
        /// if a previous request was truncated. To get the next set of pages, pass in
        /// the NextToken value from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by DataBrew that specifies where to continue pagination
        /// if a previous request was truncated. To get the next set of pages, pass in
        /// the NextToken value from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchedules`.
    ///
    /// <p>Lists the DataBrew schedules that are defined.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSchedules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schedules_input::Builder,
    }
    impl<C, M, R> ListSchedules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchedules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchedulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchedulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchedulesInputOperationOutputAlias,
                crate::output::ListSchedulesOutput,
                crate::error::ListSchedulesError,
                crate::input::ListSchedulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job that these schedules apply to.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job that these schedules apply to.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all the tags for a DataBrew resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew resource.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishRecipe`.
    ///
    /// <p>Publishes a new version of a DataBrew recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct PublishRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_recipe_input::Builder,
    }
    impl<C, M, R> PublishRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishRecipeInputOperationOutputAlias,
                crate::output::PublishRecipeOutput,
                crate::error::PublishRecipeError,
                crate::input::PublishRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description of the recipe to be published, for this version of the recipe.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the recipe to be published, for this version of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the recipe to be published.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recipe to be published.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendProjectSessionAction`.
    ///
    /// <p>Performs a recipe step within an interactive DataBrew session that's currently
    /// open.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendProjectSessionAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_project_session_action_input::Builder,
    }
    impl<C, M, R> SendProjectSessionAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendProjectSessionAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendProjectSessionActionOutput,
            aws_smithy_http::result::SdkError<crate::error::SendProjectSessionActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendProjectSessionActionInputOperationOutputAlias,
                crate::output::SendProjectSessionActionOutput,
                crate::error::SendProjectSessionActionError,
                crate::input::SendProjectSessionActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
        pub fn preview(mut self, inp: bool) -> Self {
            self.inner = self.inner.preview(inp);
            self
        }
        /// <p>If true, the result of the recipe step will be returned, but not applied.</p>
        pub fn set_preview(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_preview(input);
            self
        }
        /// <p>The name of the project to apply the action to.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the project to apply the action to.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
        pub fn recipe_step(mut self, inp: crate::model::RecipeStep) -> Self {
            self.inner = self.inner.recipe_step(inp);
            self
        }
        /// <p>Represents a single step from a DataBrew recipe to be performed.</p>
        pub fn set_recipe_step(
            mut self,
            input: std::option::Option<crate::model::RecipeStep>,
        ) -> Self {
            self.inner = self.inner.set_recipe_step(input);
            self
        }
        /// <p>The index from which to preview a step. This index is used to preview the result of
        /// steps that have already been applied, so that the resulting view frame is from earlier
        /// in the view frame stack.</p>
        pub fn step_index(mut self, inp: i32) -> Self {
            self.inner = self.inner.step_index(inp);
            self
        }
        /// <p>The index from which to preview a step. This index is used to preview the result of
        /// steps that have already been applied, so that the resulting view frame is from earlier
        /// in the view frame stack.</p>
        pub fn set_step_index(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_step_index(input);
            self
        }
        /// <p>A unique identifier for an interactive session that's currently open and ready for
        /// work. The action will be performed on this session.</p>
        pub fn client_session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_session_id(inp);
            self
        }
        /// <p>A unique identifier for an interactive session that's currently open and ready for
        /// work. The action will be performed on this session.</p>
        pub fn set_client_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_session_id(input);
            self
        }
        /// <p>Represents the data being transformed during an action.</p>
        pub fn view_frame(mut self, inp: crate::model::ViewFrame) -> Self {
            self.inner = self.inner.view_frame(inp);
            self
        }
        /// <p>Represents the data being transformed during an action.</p>
        pub fn set_view_frame(
            mut self,
            input: std::option::Option<crate::model::ViewFrame>,
        ) -> Self {
            self.inner = self.inner.set_view_frame(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJobRun`.
    ///
    /// <p>Runs a DataBrew job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartJobRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_job_run_input::Builder,
    }
    impl<C, M, R> StartJobRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartJobRunInputOperationOutputAlias,
                crate::output::StartJobRunOutput,
                crate::error::StartJobRunError,
                crate::input::StartJobRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be run.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to be run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartProjectSession`.
    ///
    /// <p>Creates an interactive session, enabling you to manipulate data in a DataBrew
    /// project.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartProjectSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_project_session_input::Builder,
    }
    impl<C, M, R> StartProjectSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartProjectSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartProjectSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartProjectSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartProjectSessionInputOperationOutputAlias,
                crate::output::StartProjectSessionOutput,
                crate::error::StartProjectSessionError,
                crate::input::StartProjectSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to act upon.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the project to act upon.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A value that, if true, enables you to take control of a session, even if a different
        /// client is currently accessing the project.</p>
        pub fn assume_control(mut self, inp: bool) -> Self {
            self.inner = self.inner.assume_control(inp);
            self
        }
        /// <p>A value that, if true, enables you to take control of a session, even if a different
        /// client is currently accessing the project.</p>
        pub fn set_assume_control(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_assume_control(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopJobRun`.
    ///
    /// <p>Stops a particular run of a job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopJobRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_job_run_input::Builder,
    }
    impl<C, M, R> StopJobRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopJobRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopJobRunInputOperationOutputAlias,
                crate::output::StopJobRunOutput,
                crate::error::StopJobRunError,
                crate::input::StopJobRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job to be stopped.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to be stopped.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the job run to be stopped.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the job run to be stopped.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe, job, or
    /// schedule.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DataBrew resource to which tags should be added. The value for this parameter is
        /// an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or
        /// a recipe.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The DataBrew resource to which tags should be added. The value for this parameter is
        /// an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a job, a project, or
        /// a recipe.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes metadata tags from a DataBrew resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this
        /// parameter is an Amazon Resource Name (ARN). </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>A DataBrew resource from which you want to remove a tag or tags. The value for this
        /// parameter is an Amazon Resource Name (ARN). </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys (names) of one or more tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys (names) of one or more tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataset`.
    ///
    /// <p>Modifies the definition of an existing DataBrew dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dataset_input::Builder,
    }
    impl<C, M, R> UpdateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatasetInputOperationOutputAlias,
                crate::output::UpdateDatasetOutput,
                crate::error::UpdateDatasetError,
                crate::input::UpdateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the dataset to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, inp: crate::model::InputFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn format_options(mut self, inp: crate::model::FormatOptions) -> Self {
            self.inner = self.inner.format_options(inp);
            self
        }
        /// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
        /// Excel, or JSON input.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.inner = self.inner.set_format_options(input);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn input(mut self, inp: crate::model::Input) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
        /// Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, inp: crate::model::PathOptions) -> Self {
            self.inner = self.inner.path_options(inp);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.inner = self.inner.set_path_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProfileJob`.
    ///
    /// <p>Modifies the definition of an existing profile job.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProfileJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_profile_job_input::Builder,
    }
    impl<C, M, R> UpdateProfileJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProfileJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProfileJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProfileJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProfileJobInputOperationOutputAlias,
                crate::output::UpdateProfileJobOutput,
                crate::error::UpdateProfileJobError,
                crate::input::UpdateProfileJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn configuration(mut self, inp: crate::model::ProfileConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Configuration for profile jobs. Used to select columns, do evaluations,
        /// and override default parameters of evaluations. When configuration is null, the
        /// profile job will run with default settings.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ProfileConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
        /// S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, inp: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(inp);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon
        /// S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>The name of the job to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, inp: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(inp);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can use when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The maximum number of compute nodes that DataBrew can use when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn output_location(mut self, inp: crate::model::S3Location) -> Self {
            self.inner = self.inner.output_location(inp);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// Appends an item to `ValidationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_validation_configurations`](Self::set_validation_configurations).
        ///
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn validation_configurations(
            mut self,
            inp: impl Into<crate::model::ValidationConfiguration>,
        ) -> Self {
            self.inner = self.inner.validation_configurations(inp);
            self
        }
        /// <p>List of validation configurations that are applied to the profile job.</p>
        pub fn set_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_validation_configurations(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the
        /// Profile job will be executed. If a JobSample value is not provided for profile jobs, the
        /// default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
        /// 20000 for the size parameter.</p>
        pub fn job_sample(mut self, inp: crate::model::JobSample) -> Self {
            self.inner = self.inner.job_sample(inp);
            self
        }
        /// <p>Sample configuration for Profile Jobs only. Determines the number of rows on which the
        /// Profile job will be executed. If a JobSample value is not provided for profile jobs, the
        /// default value will be used. The default value is CUSTOM_ROWS for the mode parameter and
        /// 20000 for the size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.inner = self.inner.set_job_sample(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Modifies the definition of an existing DataBrew project.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn sample(mut self, inp: crate::model::Sample) -> Self {
            self.inner = self.inner.sample(inp);
            self
        }
        /// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
        /// analysis.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.inner = self.inner.set_sample(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecipe`.
    ///
    /// <p>Modifies the definition of the <code>LATEST_WORKING</code> version of a DataBrew
    /// recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recipe_input::Builder,
    }
    impl<C, M, R> UpdateRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecipeInputOperationOutputAlias,
                crate::output::UpdateRecipeOutput,
                crate::error::UpdateRecipeError,
                crate::input::UpdateRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description of the recipe.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the recipe to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the recipe to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
        /// the conditions under which the action should succeed.</p>
        pub fn steps(mut self, inp: impl Into<crate::model::RecipeStep>) -> Self {
            self.inner = self.inner.steps(inp);
            self
        }
        /// <p>One or more steps to be performed by the recipe. Each step consists of an action, and
        /// the conditions under which the action should succeed.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecipeJob`.
    ///
    /// <p>Modifies the definition of an existing DataBrew recipe job.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecipeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recipe_job_input::Builder,
    }
    impl<C, M, R> UpdateRecipeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecipeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecipeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecipeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecipeJobInputOperationOutputAlias,
                crate::output::UpdateRecipeJobOutput,
                crate::error::UpdateRecipeJobError,
                crate::input::UpdateRecipeJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the
        /// job.</p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_arn(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, inp: crate::model::EncryptionMode) -> Self {
            self.inner = self.inner.encryption_mode(inp);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.inner = self.inner.set_encryption_mode(input);
            self
        }
        /// <p>The name of the job to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the job to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn log_subscription(mut self, inp: crate::model::LogSubscription) -> Self {
            self.inner = self.inner.log_subscription(inp);
            self
        }
        /// <p>Enables or disables Amazon CloudWatch logging for the job. If logging is enabled,
        /// CloudWatch writes one log stream for each job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.inner = self.inner.set_log_subscription(input);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn max_capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The maximum number of nodes that DataBrew can consume when the job processes
        /// data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent the output from running the job. </p>
        pub fn outputs(mut self, inp: impl Into<crate::model::Output>) -> Self {
            self.inner = self.inner.outputs(inp);
            self
        }
        /// <p>One or more artifacts that represent the output from running the job. </p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// Appends an item to `DataCatalogOutputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            inp: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            self.inner = self.inner.data_catalog_outputs(inp);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.inner = self.inner.set_data_catalog_outputs(input);
            self
        }
        /// Appends an item to `DatabaseOutputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a
        /// DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, inp: impl Into<crate::model::DatabaseOutput>) -> Self {
            self.inner = self.inner.database_outputs(inp);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output destination for a
        /// DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.inner = self.inner.set_database_outputs(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to
        /// be assumed when DataBrew runs the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleset`.
    ///
    /// <p>Updates specified ruleset.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRuleset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ruleset_input::Builder,
    }
    impl<C, M, R> UpdateRuleset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRuleset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRulesetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRulesetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRulesetInputOperationOutputAlias,
                crate::output::UpdateRulesetOutput,
                crate::error::UpdateRulesetError,
                crate::input::UpdateRulesetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ruleset to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ruleset to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the ruleset.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more
        /// checks to be validated on a DataBrew dataset.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::Rule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>A list of rules that are defined with the ruleset. A rule includes one or more
        /// checks to be validated on a DataBrew dataset.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSchedule`.
    ///
    /// <p>Modifies the definition of an existing DataBrew schedule.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_schedule_input::Builder,
    }
    impl<C, M, R> UpdateSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateScheduleInputOperationOutputAlias,
                crate::output::UpdateScheduleOutput,
                crate::error::UpdateScheduleError,
                crate::input::UpdateScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobNames`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The name or names of one or more jobs to be run for this schedule.</p>
        pub fn job_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_names(inp);
            self
        }
        /// <p>The name or names of one or more jobs to be run for this schedule.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_names(input);
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn cron_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cron_expression(inp);
            self
        }
        /// <p>The date or dates and time or times when the jobs are to be run. For more information,
        /// see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cron_expression(input);
            self
        }
        /// <p>The name of the schedule to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the schedule to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
