// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a JDBC database output object which defines the output destination for
/// a DataBrew recipe job to write into.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseOutput {
    /// <p>The Glue connection that stores the connection information for the
    /// target database.</p>
    pub glue_connection_name: std::option::Option<std::string::String>,
    /// <p>Represents options that specify how and where DataBrew writes the database output
    /// generated by recipe jobs.</p>
    pub database_options: std::option::Option<crate::model::DatabaseTableOutputOptions>,
    /// <p>The output mode to write into the database. Currently supported option: NEW_TABLE.</p>
    pub database_output_mode: std::option::Option<crate::model::DatabaseOutputMode>,
}
impl std::fmt::Debug for DatabaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseOutput");
        formatter.field("glue_connection_name", &self.glue_connection_name);
        formatter.field("database_options", &self.database_options);
        formatter.field("database_output_mode", &self.database_output_mode);
        formatter.finish()
    }
}
/// See [`DatabaseOutput`](crate::model::DatabaseOutput)
pub mod database_output {
    /// A builder for [`DatabaseOutput`](crate::model::DatabaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) glue_connection_name: std::option::Option<std::string::String>,
        pub(crate) database_options: std::option::Option<crate::model::DatabaseTableOutputOptions>,
        pub(crate) database_output_mode: std::option::Option<crate::model::DatabaseOutputMode>,
    }
    impl Builder {
        /// <p>The Glue connection that stores the connection information for the
        /// target database.</p>
        pub fn glue_connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_connection_name = Some(input.into());
            self
        }
        /// <p>The Glue connection that stores the connection information for the
        /// target database.</p>
        pub fn set_glue_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.glue_connection_name = input;
            self
        }
        /// <p>Represents options that specify how and where DataBrew writes the database output
        /// generated by recipe jobs.</p>
        pub fn database_options(mut self, input: crate::model::DatabaseTableOutputOptions) -> Self {
            self.database_options = Some(input);
            self
        }
        /// <p>Represents options that specify how and where DataBrew writes the database output
        /// generated by recipe jobs.</p>
        pub fn set_database_options(
            mut self,
            input: std::option::Option<crate::model::DatabaseTableOutputOptions>,
        ) -> Self {
            self.database_options = input;
            self
        }
        /// <p>The output mode to write into the database. Currently supported option: NEW_TABLE.</p>
        pub fn database_output_mode(mut self, input: crate::model::DatabaseOutputMode) -> Self {
            self.database_output_mode = Some(input);
            self
        }
        /// <p>The output mode to write into the database. Currently supported option: NEW_TABLE.</p>
        pub fn set_database_output_mode(
            mut self,
            input: std::option::Option<crate::model::DatabaseOutputMode>,
        ) -> Self {
            self.database_output_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseOutput`](crate::model::DatabaseOutput)
        pub fn build(self) -> crate::model::DatabaseOutput {
            crate::model::DatabaseOutput {
                glue_connection_name: self.glue_connection_name,
                database_options: self.database_options,
                database_output_mode: self.database_output_mode,
            }
        }
    }
}
impl DatabaseOutput {
    /// Creates a new builder-style object to manufacture [`DatabaseOutput`](crate::model::DatabaseOutput)
    pub fn builder() -> crate::model::database_output::Builder {
        crate::model::database_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatabaseOutputMode {
    #[allow(missing_docs)] // documentation missing in model
    NewTable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatabaseOutputMode {
    fn from(s: &str) -> Self {
        match s {
            "NEW_TABLE" => DatabaseOutputMode::NewTable,
            other => DatabaseOutputMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatabaseOutputMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatabaseOutputMode::from(s))
    }
}
impl DatabaseOutputMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatabaseOutputMode::NewTable => "NEW_TABLE",
            DatabaseOutputMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NEW_TABLE"]
    }
}
impl AsRef<str> for DatabaseOutputMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents options that specify how and where DataBrew writes the database output generated by recipe
/// jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseTableOutputOptions {
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can store
    /// intermediate results.</p>
    pub temp_directory: std::option::Option<crate::model::S3Location>,
    /// <p>A prefix for the name of a table DataBrew will create in the database.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DatabaseTableOutputOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseTableOutputOptions");
        formatter.field("temp_directory", &self.temp_directory);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}
/// See [`DatabaseTableOutputOptions`](crate::model::DatabaseTableOutputOptions)
pub mod database_table_output_options {
    /// A builder for [`DatabaseTableOutputOptions`](crate::model::DatabaseTableOutputOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) temp_directory: std::option::Option<crate::model::S3Location>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can store
        /// intermediate results.</p>
        pub fn temp_directory(mut self, input: crate::model::S3Location) -> Self {
            self.temp_directory = Some(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can store
        /// intermediate results.</p>
        pub fn set_temp_directory(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.temp_directory = input;
            self
        }
        /// <p>A prefix for the name of a table DataBrew will create in the database.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>A prefix for the name of a table DataBrew will create in the database.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseTableOutputOptions`](crate::model::DatabaseTableOutputOptions)
        pub fn build(self) -> crate::model::DatabaseTableOutputOptions {
            crate::model::DatabaseTableOutputOptions {
                temp_directory: self.temp_directory,
                table_name: self.table_name,
            }
        }
    }
}
impl DatabaseTableOutputOptions {
    /// Creates a new builder-style object to manufacture [`DatabaseTableOutputOptions`](crate::model::DatabaseTableOutputOptions)
    pub fn builder() -> crate::model::database_table_output_options::Builder {
        crate::model::database_table_output_options::Builder::default()
    }
}

/// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
/// input data, or write output from a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The Amazon S3 bucket name.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The unique name of the object in the bucket.</p>
    pub key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The unique name of the object in the bucket.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The unique name of the object in the bucket.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>Represents options that specify how and where in the Glue Data Catalog DataBrew
/// writes the output generated by recipe jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCatalogOutput {
    /// <p>The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of a database in the Data Catalog.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of a table in the Data Catalog.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Represents options that specify how and where DataBrew writes the Amazon S3 output generated
    /// by recipe jobs.</p>
    pub s3_options: std::option::Option<crate::model::S3TableOutputOptions>,
    /// <p>Represents options that specify how and where DataBrew writes the database output
    /// generated by recipe jobs.</p>
    pub database_options: std::option::Option<crate::model::DatabaseTableOutputOptions>,
    /// <p>A value that, if true, means that any data in the location specified for output
    /// is overwritten with new output. Not supported with DatabaseOptions.</p>
    pub overwrite: bool,
}
impl std::fmt::Debug for DataCatalogOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCatalogOutput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("s3_options", &self.s3_options);
        formatter.field("database_options", &self.database_options);
        formatter.field("overwrite", &self.overwrite);
        formatter.finish()
    }
}
/// See [`DataCatalogOutput`](crate::model::DataCatalogOutput)
pub mod data_catalog_output {
    /// A builder for [`DataCatalogOutput`](crate::model::DataCatalogOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) s3_options: std::option::Option<crate::model::S3TableOutputOptions>,
        pub(crate) database_options: std::option::Option<crate::model::DatabaseTableOutputOptions>,
        pub(crate) overwrite: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of a database in the Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of a database in the Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of a table in the Data Catalog.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of a table in the Data Catalog.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Represents options that specify how and where DataBrew writes the Amazon S3 output generated
        /// by recipe jobs.</p>
        pub fn s3_options(mut self, input: crate::model::S3TableOutputOptions) -> Self {
            self.s3_options = Some(input);
            self
        }
        /// <p>Represents options that specify how and where DataBrew writes the Amazon S3 output generated
        /// by recipe jobs.</p>
        pub fn set_s3_options(
            mut self,
            input: std::option::Option<crate::model::S3TableOutputOptions>,
        ) -> Self {
            self.s3_options = input;
            self
        }
        /// <p>Represents options that specify how and where DataBrew writes the database output
        /// generated by recipe jobs.</p>
        pub fn database_options(mut self, input: crate::model::DatabaseTableOutputOptions) -> Self {
            self.database_options = Some(input);
            self
        }
        /// <p>Represents options that specify how and where DataBrew writes the database output
        /// generated by recipe jobs.</p>
        pub fn set_database_options(
            mut self,
            input: std::option::Option<crate::model::DatabaseTableOutputOptions>,
        ) -> Self {
            self.database_options = input;
            self
        }
        /// <p>A value that, if true, means that any data in the location specified for output
        /// is overwritten with new output. Not supported with DatabaseOptions.</p>
        pub fn overwrite(mut self, input: bool) -> Self {
            self.overwrite = Some(input);
            self
        }
        /// <p>A value that, if true, means that any data in the location specified for output
        /// is overwritten with new output. Not supported with DatabaseOptions.</p>
        pub fn set_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.overwrite = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCatalogOutput`](crate::model::DataCatalogOutput)
        pub fn build(self) -> crate::model::DataCatalogOutput {
            crate::model::DataCatalogOutput {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                s3_options: self.s3_options,
                database_options: self.database_options,
                overwrite: self.overwrite.unwrap_or_default(),
            }
        }
    }
}
impl DataCatalogOutput {
    /// Creates a new builder-style object to manufacture [`DataCatalogOutput`](crate::model::DataCatalogOutput)
    pub fn builder() -> crate::model::data_catalog_output::Builder {
        crate::model::data_catalog_output::Builder::default()
    }
}

/// <p>Represents options that specify how and where DataBrew writes the Amazon S3 output generated by
/// recipe jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3TableOutputOptions {
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output
    /// from a job.</p>
    pub location: std::option::Option<crate::model::S3Location>,
}
impl std::fmt::Debug for S3TableOutputOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3TableOutputOptions");
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`S3TableOutputOptions`](crate::model::S3TableOutputOptions)
pub mod s3_table_output_options {
    /// A builder for [`S3TableOutputOptions`](crate::model::S3TableOutputOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output
        /// from a job.</p>
        pub fn location(mut self, input: crate::model::S3Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output
        /// from a job.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`S3TableOutputOptions`](crate::model::S3TableOutputOptions)
        pub fn build(self) -> crate::model::S3TableOutputOptions {
            crate::model::S3TableOutputOptions {
                location: self.location,
            }
        }
    }
}
impl S3TableOutputOptions {
    /// Creates a new builder-style object to manufacture [`S3TableOutputOptions`](crate::model::S3TableOutputOptions)
    pub fn builder() -> crate::model::s3_table_output_options::Builder {
        crate::model::s3_table_output_options::Builder::default()
    }
}

/// <p>Represents options that specify how and where in Amazon S3 DataBrew writes the output generated by
/// recipe jobs or profile jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Output {
    /// <p>The compression algorithm used to compress the output text of the job.</p>
    pub compression_format: std::option::Option<crate::model::CompressionFormat>,
    /// <p>The data format of the output of the job.</p>
    pub format: std::option::Option<crate::model::OutputFormat>,
    /// <p>The names of one or more partition columns for the output of the job.</p>
    pub partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The location in Amazon S3 where the job writes its output.</p>
    pub location: std::option::Option<crate::model::S3Location>,
    /// <p>A value that, if true, means that any data in the location specified for output is
    /// overwritten with new output.</p>
    pub overwrite: bool,
    /// <p>Represents options that define how DataBrew formats job output files.</p>
    pub format_options: std::option::Option<crate::model::OutputFormatOptions>,
}
impl std::fmt::Debug for Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Output");
        formatter.field("compression_format", &self.compression_format);
        formatter.field("format", &self.format);
        formatter.field("partition_columns", &self.partition_columns);
        formatter.field("location", &self.location);
        formatter.field("overwrite", &self.overwrite);
        formatter.field("format_options", &self.format_options);
        formatter.finish()
    }
}
/// See [`Output`](crate::model::Output)
pub mod output {
    /// A builder for [`Output`](crate::model::Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compression_format: std::option::Option<crate::model::CompressionFormat>,
        pub(crate) format: std::option::Option<crate::model::OutputFormat>,
        pub(crate) partition_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) location: std::option::Option<crate::model::S3Location>,
        pub(crate) overwrite: std::option::Option<bool>,
        pub(crate) format_options: std::option::Option<crate::model::OutputFormatOptions>,
    }
    impl Builder {
        /// <p>The compression algorithm used to compress the output text of the job.</p>
        pub fn compression_format(mut self, input: crate::model::CompressionFormat) -> Self {
            self.compression_format = Some(input);
            self
        }
        /// <p>The compression algorithm used to compress the output text of the job.</p>
        pub fn set_compression_format(
            mut self,
            input: std::option::Option<crate::model::CompressionFormat>,
        ) -> Self {
            self.compression_format = input;
            self
        }
        /// <p>The data format of the output of the job.</p>
        pub fn format(mut self, input: crate::model::OutputFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The data format of the output of the job.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Appends an item to `partition_columns`.
        ///
        /// To override the contents of this collection use [`set_partition_columns`](Self::set_partition_columns).
        ///
        /// <p>The names of one or more partition columns for the output of the job.</p>
        pub fn partition_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_columns.unwrap_or_default();
            v.push(input.into());
            self.partition_columns = Some(v);
            self
        }
        /// <p>The names of one or more partition columns for the output of the job.</p>
        pub fn set_partition_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_columns = input;
            self
        }
        /// <p>The location in Amazon S3 where the job writes its output.</p>
        pub fn location(mut self, input: crate::model::S3Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location in Amazon S3 where the job writes its output.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>A value that, if true, means that any data in the location specified for output is
        /// overwritten with new output.</p>
        pub fn overwrite(mut self, input: bool) -> Self {
            self.overwrite = Some(input);
            self
        }
        /// <p>A value that, if true, means that any data in the location specified for output is
        /// overwritten with new output.</p>
        pub fn set_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.overwrite = input;
            self
        }
        /// <p>Represents options that define how DataBrew formats job output files.</p>
        pub fn format_options(mut self, input: crate::model::OutputFormatOptions) -> Self {
            self.format_options = Some(input);
            self
        }
        /// <p>Represents options that define how DataBrew formats job output files.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::OutputFormatOptions>,
        ) -> Self {
            self.format_options = input;
            self
        }
        /// Consumes the builder and constructs a [`Output`](crate::model::Output)
        pub fn build(self) -> crate::model::Output {
            crate::model::Output {
                compression_format: self.compression_format,
                format: self.format,
                partition_columns: self.partition_columns,
                location: self.location,
                overwrite: self.overwrite.unwrap_or_default(),
                format_options: self.format_options,
            }
        }
    }
}
impl Output {
    /// Creates a new builder-style object to manufacture [`Output`](crate::model::Output)
    pub fn builder() -> crate::model::output::Builder {
        crate::model::output::Builder::default()
    }
}

/// <p>Represents a set of options that define the structure of comma-separated (CSV) job output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputFormatOptions {
    /// <p>Represents a set of options that define the structure of comma-separated value (CSV)
    /// job output.</p>
    pub csv: std::option::Option<crate::model::CsvOutputOptions>,
}
impl std::fmt::Debug for OutputFormatOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputFormatOptions");
        formatter.field("csv", &self.csv);
        formatter.finish()
    }
}
/// See [`OutputFormatOptions`](crate::model::OutputFormatOptions)
pub mod output_format_options {
    /// A builder for [`OutputFormatOptions`](crate::model::OutputFormatOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) csv: std::option::Option<crate::model::CsvOutputOptions>,
    }
    impl Builder {
        /// <p>Represents a set of options that define the structure of comma-separated value (CSV)
        /// job output.</p>
        pub fn csv(mut self, input: crate::model::CsvOutputOptions) -> Self {
            self.csv = Some(input);
            self
        }
        /// <p>Represents a set of options that define the structure of comma-separated value (CSV)
        /// job output.</p>
        pub fn set_csv(
            mut self,
            input: std::option::Option<crate::model::CsvOutputOptions>,
        ) -> Self {
            self.csv = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputFormatOptions`](crate::model::OutputFormatOptions)
        pub fn build(self) -> crate::model::OutputFormatOptions {
            crate::model::OutputFormatOptions { csv: self.csv }
        }
    }
}
impl OutputFormatOptions {
    /// Creates a new builder-style object to manufacture [`OutputFormatOptions`](crate::model::OutputFormatOptions)
    pub fn builder() -> crate::model::output_format_options::Builder {
        crate::model::output_format_options::Builder::default()
    }
}

/// <p>Represents a set of options that define how DataBrew will write a
/// comma-separated value (CSV) file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvOutputOptions {
    /// <p>A single character that specifies the delimiter used to create CSV job output.</p>
    pub delimiter: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CsvOutputOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvOutputOptions");
        formatter.field("delimiter", &self.delimiter);
        formatter.finish()
    }
}
/// See [`CsvOutputOptions`](crate::model::CsvOutputOptions)
pub mod csv_output_options {
    /// A builder for [`CsvOutputOptions`](crate::model::CsvOutputOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delimiter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A single character that specifies the delimiter used to create CSV job output.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A single character that specifies the delimiter used to create CSV job output.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvOutputOptions`](crate::model::CsvOutputOptions)
        pub fn build(self) -> crate::model::CsvOutputOptions {
            crate::model::CsvOutputOptions {
                delimiter: self.delimiter,
            }
        }
    }
}
impl CsvOutputOptions {
    /// Creates a new builder-style object to manufacture [`CsvOutputOptions`](crate::model::CsvOutputOptions)
    pub fn builder() -> crate::model::csv_output_options::Builder {
        crate::model::csv_output_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutputFormat {
    #[allow(missing_docs)] // documentation missing in model
    Avro,
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Glueparquet,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Orc,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    #[allow(missing_docs)] // documentation missing in model
    Tableauhyper,
    #[allow(missing_docs)] // documentation missing in model
    Xml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutputFormat {
    fn from(s: &str) -> Self {
        match s {
            "AVRO" => OutputFormat::Avro,
            "CSV" => OutputFormat::Csv,
            "GLUEPARQUET" => OutputFormat::Glueparquet,
            "JSON" => OutputFormat::Json,
            "ORC" => OutputFormat::Orc,
            "PARQUET" => OutputFormat::Parquet,
            "TABLEAUHYPER" => OutputFormat::Tableauhyper,
            "XML" => OutputFormat::Xml,
            other => OutputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutputFormat::from(s))
    }
}
impl OutputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutputFormat::Avro => "AVRO",
            OutputFormat::Csv => "CSV",
            OutputFormat::Glueparquet => "GLUEPARQUET",
            OutputFormat::Json => "JSON",
            OutputFormat::Orc => "ORC",
            OutputFormat::Parquet => "PARQUET",
            OutputFormat::Tableauhyper => "TABLEAUHYPER",
            OutputFormat::Xml => "XML",
            OutputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVRO",
            "CSV",
            "GLUEPARQUET",
            "JSON",
            "ORC",
            "PARQUET",
            "TABLEAUHYPER",
            "XML",
        ]
    }
}
impl AsRef<str> for OutputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompressionFormat {
    #[allow(missing_docs)] // documentation missing in model
    Brotli,
    #[allow(missing_docs)] // documentation missing in model
    Bzip2,
    #[allow(missing_docs)] // documentation missing in model
    Deflate,
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    Lz4,
    #[allow(missing_docs)] // documentation missing in model
    Lzo,
    #[allow(missing_docs)] // documentation missing in model
    Snappy,
    #[allow(missing_docs)] // documentation missing in model
    Zlib,
    #[allow(missing_docs)] // documentation missing in model
    Zstd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompressionFormat {
    fn from(s: &str) -> Self {
        match s {
            "BROTLI" => CompressionFormat::Brotli,
            "BZIP2" => CompressionFormat::Bzip2,
            "DEFLATE" => CompressionFormat::Deflate,
            "GZIP" => CompressionFormat::Gzip,
            "LZ4" => CompressionFormat::Lz4,
            "LZO" => CompressionFormat::Lzo,
            "SNAPPY" => CompressionFormat::Snappy,
            "ZLIB" => CompressionFormat::Zlib,
            "ZSTD" => CompressionFormat::Zstd,
            other => CompressionFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompressionFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompressionFormat::from(s))
    }
}
impl CompressionFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompressionFormat::Brotli => "BROTLI",
            CompressionFormat::Bzip2 => "BZIP2",
            CompressionFormat::Deflate => "DEFLATE",
            CompressionFormat::Gzip => "GZIP",
            CompressionFormat::Lz4 => "LZ4",
            CompressionFormat::Lzo => "LZO",
            CompressionFormat::Snappy => "SNAPPY",
            CompressionFormat::Zlib => "ZLIB",
            CompressionFormat::Zstd => "ZSTD",
            CompressionFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BROTLI", "BZIP2", "DEFLATE", "GZIP", "LZ4", "LZO", "SNAPPY", "ZLIB", "ZSTD",
        ]
    }
}
impl AsRef<str> for CompressionFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogSubscription {
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    Enable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogSubscription {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE" => LogSubscription::Disable,
            "ENABLE" => LogSubscription::Enable,
            other => LogSubscription::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogSubscription {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogSubscription::from(s))
    }
}
impl LogSubscription {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogSubscription::Disable => "DISABLE",
            LogSubscription::Enable => "ENABLE",
            LogSubscription::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE", "ENABLE"]
    }
}
impl AsRef<str> for LogSubscription {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionMode {
    #[allow(missing_docs)] // documentation missing in model
    Ssekms,
    #[allow(missing_docs)] // documentation missing in model
    Sses3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionMode {
    fn from(s: &str) -> Self {
        match s {
            "SSE-KMS" => EncryptionMode::Ssekms,
            "SSE-S3" => EncryptionMode::Sses3,
            other => EncryptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionMode::from(s))
    }
}
impl EncryptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionMode::Ssekms => "SSE-KMS",
            EncryptionMode::Sses3 => "SSE-S3",
            EncryptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSE-KMS", "SSE-S3"]
    }
}
impl AsRef<str> for EncryptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a single step from a DataBrew recipe to be performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipeStep {
    /// <p>The particular action to be performed in the recipe step.</p>
    pub action: std::option::Option<crate::model::RecipeAction>,
    /// <p>One or more conditions that must be met for the recipe step to succeed.</p>
    /// <note>
    /// <p>All of the conditions in the array must be met. In other words, all of the
    /// conditions must be combined using a logical AND operation.</p>
    /// </note>
    pub condition_expressions:
        std::option::Option<std::vec::Vec<crate::model::ConditionExpression>>,
}
impl std::fmt::Debug for RecipeStep {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipeStep");
        formatter.field("action", &self.action);
        formatter.field("condition_expressions", &self.condition_expressions);
        formatter.finish()
    }
}
/// See [`RecipeStep`](crate::model::RecipeStep)
pub mod recipe_step {
    /// A builder for [`RecipeStep`](crate::model::RecipeStep)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::RecipeAction>,
        pub(crate) condition_expressions:
            std::option::Option<std::vec::Vec<crate::model::ConditionExpression>>,
    }
    impl Builder {
        /// <p>The particular action to be performed in the recipe step.</p>
        pub fn action(mut self, input: crate::model::RecipeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The particular action to be performed in the recipe step.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::RecipeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Appends an item to `condition_expressions`.
        ///
        /// To override the contents of this collection use [`set_condition_expressions`](Self::set_condition_expressions).
        ///
        /// <p>One or more conditions that must be met for the recipe step to succeed.</p>
        /// <note>
        /// <p>All of the conditions in the array must be met. In other words, all of the
        /// conditions must be combined using a logical AND operation.</p>
        /// </note>
        pub fn condition_expressions(
            mut self,
            input: impl Into<crate::model::ConditionExpression>,
        ) -> Self {
            let mut v = self.condition_expressions.unwrap_or_default();
            v.push(input.into());
            self.condition_expressions = Some(v);
            self
        }
        /// <p>One or more conditions that must be met for the recipe step to succeed.</p>
        /// <note>
        /// <p>All of the conditions in the array must be met. In other words, all of the
        /// conditions must be combined using a logical AND operation.</p>
        /// </note>
        pub fn set_condition_expressions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConditionExpression>>,
        ) -> Self {
            self.condition_expressions = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipeStep`](crate::model::RecipeStep)
        pub fn build(self) -> crate::model::RecipeStep {
            crate::model::RecipeStep {
                action: self.action,
                condition_expressions: self.condition_expressions,
            }
        }
    }
}
impl RecipeStep {
    /// Creates a new builder-style object to manufacture [`RecipeStep`](crate::model::RecipeStep)
    pub fn builder() -> crate::model::recipe_step::Builder {
        crate::model::recipe_step::Builder::default()
    }
}

/// <p>Represents an individual condition that evaluates to true or false.</p>
/// <p>Conditions are used with recipe actions. The action is only performed for column values where the
/// condition evaluates to true.</p>
/// <p>If a recipe requires more than one condition, then the recipe must specify multiple
/// <code>ConditionExpression</code> elements. Each condition is applied to the rows in a dataset first, before
/// the recipe action is performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionExpression {
    /// <p>A specific condition to apply to a recipe action. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/recipes.html#recipes.structure">Recipe
    /// structure</a> in the <i>Glue DataBrew Developer
    /// Guide</i>.</p>
    pub condition: std::option::Option<std::string::String>,
    /// <p>A value that the condition must evaluate to for the condition to succeed.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>A column to apply this condition to.</p>
    pub target_column: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConditionExpression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionExpression");
        formatter.field("condition", &self.condition);
        formatter.field("value", &self.value);
        formatter.field("target_column", &self.target_column);
        formatter.finish()
    }
}
/// See [`ConditionExpression`](crate::model::ConditionExpression)
pub mod condition_expression {
    /// A builder for [`ConditionExpression`](crate::model::ConditionExpression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) target_column: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A specific condition to apply to a recipe action. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/recipes.html#recipes.structure">Recipe
        /// structure</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn condition(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition = Some(input.into());
            self
        }
        /// <p>A specific condition to apply to a recipe action. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/recipes.html#recipes.structure">Recipe
        /// structure</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn set_condition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.condition = input;
            self
        }
        /// <p>A value that the condition must evaluate to for the condition to succeed.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value that the condition must evaluate to for the condition to succeed.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>A column to apply this condition to.</p>
        pub fn target_column(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_column = Some(input.into());
            self
        }
        /// <p>A column to apply this condition to.</p>
        pub fn set_target_column(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_column = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionExpression`](crate::model::ConditionExpression)
        pub fn build(self) -> crate::model::ConditionExpression {
            crate::model::ConditionExpression {
                condition: self.condition,
                value: self.value,
                target_column: self.target_column,
            }
        }
    }
}
impl ConditionExpression {
    /// Creates a new builder-style object to manufacture [`ConditionExpression`](crate::model::ConditionExpression)
    pub fn builder() -> crate::model::condition_expression::Builder {
        crate::model::condition_expression::Builder::default()
    }
}

/// <p>Represents a transformation and associated parameters that are used to apply a change
/// to a DataBrew dataset. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/recipe-actions-reference.html">Recipe
/// actions reference</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipeAction {
    /// <p>The name of a valid DataBrew transformation to be performed on the data.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>Contextual parameters for the transformation.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RecipeAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipeAction");
        formatter.field("operation", &self.operation);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`RecipeAction`](crate::model::RecipeAction)
pub mod recipe_action {
    /// A builder for [`RecipeAction`](crate::model::RecipeAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of a valid DataBrew transformation to be performed on the data.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The name of a valid DataBrew transformation to be performed on the data.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Contextual parameters for the transformation.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>Contextual parameters for the transformation.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipeAction`](crate::model::RecipeAction)
        pub fn build(self) -> crate::model::RecipeAction {
            crate::model::RecipeAction {
                operation: self.operation,
                parameters: self.parameters,
            }
        }
    }
}
impl RecipeAction {
    /// Creates a new builder-style object to manufacture [`RecipeAction`](crate::model::RecipeAction)
    pub fn builder() -> crate::model::recipe_action::Builder {
        crate::model::recipe_action::Builder::default()
    }
}

/// <p>Represents the sample size and sampling type for DataBrew to use for interactive data
/// analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sample {
    /// <p>The number of rows in the sample.</p>
    pub size: std::option::Option<i32>,
    /// <p>The way in which DataBrew obtains rows from a dataset.</p>
    pub r#type: std::option::Option<crate::model::SampleType>,
}
impl std::fmt::Debug for Sample {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sample");
        formatter.field("size", &self.size);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Sample`](crate::model::Sample)
pub mod sample {
    /// A builder for [`Sample`](crate::model::Sample)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::SampleType>,
    }
    impl Builder {
        /// <p>The number of rows in the sample.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The number of rows in the sample.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// <p>The way in which DataBrew obtains rows from a dataset.</p>
        pub fn r#type(mut self, input: crate::model::SampleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The way in which DataBrew obtains rows from a dataset.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SampleType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Sample`](crate::model::Sample)
        pub fn build(self) -> crate::model::Sample {
            crate::model::Sample {
                size: self.size,
                r#type: self.r#type,
            }
        }
    }
}
impl Sample {
    /// Creates a new builder-style object to manufacture [`Sample`](crate::model::Sample)
    pub fn builder() -> crate::model::sample::Builder {
        crate::model::sample::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SampleType {
    #[allow(missing_docs)] // documentation missing in model
    FirstN,
    #[allow(missing_docs)] // documentation missing in model
    LastN,
    #[allow(missing_docs)] // documentation missing in model
    Random,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SampleType {
    fn from(s: &str) -> Self {
        match s {
            "FIRST_N" => SampleType::FirstN,
            "LAST_N" => SampleType::LastN,
            "RANDOM" => SampleType::Random,
            other => SampleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SampleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SampleType::from(s))
    }
}
impl SampleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SampleType::FirstN => "FIRST_N",
            SampleType::LastN => "LAST_N",
            SampleType::Random => "RANDOM",
            SampleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FIRST_N", "LAST_N", "RANDOM"]
    }
}
impl AsRef<str> for SampleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
/// profile job is run. If a <code>JobSample</code> value isn't provided, the
/// default is used. The default value is CUSTOM_ROWS for the mode parameter and
/// 20,000 for the size parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobSample {
    /// <p>A value that determines whether the profile job is run on the entire dataset or a
    /// specified number of rows. This value must be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>FULL_DATASET - The profile job is run on the entire dataset.</p>
    /// </li>
    /// <li>
    /// <p>CUSTOM_ROWS - The profile job is run on the number of rows specified in the
    /// <code>Size</code> parameter.</p>
    /// </li>
    /// </ul>
    pub mode: std::option::Option<crate::model::SampleMode>,
    /// <p>The <code>Size</code> parameter is only required when the mode is CUSTOM_ROWS. The
    /// profile job is run on the specified number of rows. The maximum value for size is
    /// Long.MAX_VALUE.</p>
    /// <p>Long.MAX_VALUE = 9223372036854775807</p>
    pub size: std::option::Option<i64>,
}
impl std::fmt::Debug for JobSample {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobSample");
        formatter.field("mode", &self.mode);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`JobSample`](crate::model::JobSample)
pub mod job_sample {
    /// A builder for [`JobSample`](crate::model::JobSample)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::SampleMode>,
        pub(crate) size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>A value that determines whether the profile job is run on the entire dataset or a
        /// specified number of rows. This value must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>FULL_DATASET - The profile job is run on the entire dataset.</p>
        /// </li>
        /// <li>
        /// <p>CUSTOM_ROWS - The profile job is run on the number of rows specified in the
        /// <code>Size</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn mode(mut self, input: crate::model::SampleMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>A value that determines whether the profile job is run on the entire dataset or a
        /// specified number of rows. This value must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>FULL_DATASET - The profile job is run on the entire dataset.</p>
        /// </li>
        /// <li>
        /// <p>CUSTOM_ROWS - The profile job is run on the number of rows specified in the
        /// <code>Size</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::SampleMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The <code>Size</code> parameter is only required when the mode is CUSTOM_ROWS. The
        /// profile job is run on the specified number of rows. The maximum value for size is
        /// Long.MAX_VALUE.</p>
        /// <p>Long.MAX_VALUE = 9223372036854775807</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The <code>Size</code> parameter is only required when the mode is CUSTOM_ROWS. The
        /// profile job is run on the specified number of rows. The maximum value for size is
        /// Long.MAX_VALUE.</p>
        /// <p>Long.MAX_VALUE = 9223372036854775807</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`JobSample`](crate::model::JobSample)
        pub fn build(self) -> crate::model::JobSample {
            crate::model::JobSample {
                mode: self.mode,
                size: self.size,
            }
        }
    }
}
impl JobSample {
    /// Creates a new builder-style object to manufacture [`JobSample`](crate::model::JobSample)
    pub fn builder() -> crate::model::job_sample::Builder {
        crate::model::job_sample::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SampleMode {
    #[allow(missing_docs)] // documentation missing in model
    CustomRows,
    #[allow(missing_docs)] // documentation missing in model
    FullDataset,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SampleMode {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM_ROWS" => SampleMode::CustomRows,
            "FULL_DATASET" => SampleMode::FullDataset,
            other => SampleMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SampleMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SampleMode::from(s))
    }
}
impl SampleMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SampleMode::CustomRows => "CUSTOM_ROWS",
            SampleMode::FullDataset => "FULL_DATASET",
            SampleMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM_ROWS", "FULL_DATASET"]
    }
}
impl AsRef<str> for SampleMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration for profile jobs. Configuration can be used to select columns, do evaluations, and override default
/// parameters of evaluations. When configuration is undefined, the profile job will apply default settings to all
/// supported columns.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfileConfiguration {
    /// <p>Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
    /// parameters of evaluations. When configuration is undefined, the profile job will run all supported
    /// inter-column evaluations.
    /// </p>
    pub dataset_statistics_configuration:
        std::option::Option<crate::model::StatisticsConfiguration>,
    /// <p>List of column selectors. ProfileColumns can be used to select columns from the dataset. When
    /// ProfileColumns is undefined, the profile job will profile all supported columns.
    /// </p>
    pub profile_columns: std::option::Option<std::vec::Vec<crate::model::ColumnSelector>>,
    /// <p>List of configurations for column evaluations. ColumnStatisticsConfigurations are used to
    /// select evaluations and override parameters of evaluations for particular columns. When
    /// ColumnStatisticsConfigurations is undefined,  the profile job will profile all supported columns
    /// and run all supported  evaluations.
    /// </p>
    pub column_statistics_configurations:
        std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsConfiguration>>,
}
impl std::fmt::Debug for ProfileConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfileConfiguration");
        formatter.field(
            "dataset_statistics_configuration",
            &self.dataset_statistics_configuration,
        );
        formatter.field("profile_columns", &self.profile_columns);
        formatter.field(
            "column_statistics_configurations",
            &self.column_statistics_configurations,
        );
        formatter.finish()
    }
}
/// See [`ProfileConfiguration`](crate::model::ProfileConfiguration)
pub mod profile_configuration {
    /// A builder for [`ProfileConfiguration`](crate::model::ProfileConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_statistics_configuration:
            std::option::Option<crate::model::StatisticsConfiguration>,
        pub(crate) profile_columns:
            std::option::Option<std::vec::Vec<crate::model::ColumnSelector>>,
        pub(crate) column_statistics_configurations:
            std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsConfiguration>>,
    }
    impl Builder {
        /// <p>Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
        /// parameters of evaluations. When configuration is undefined, the profile job will run all supported
        /// inter-column evaluations.
        /// </p>
        pub fn dataset_statistics_configuration(
            mut self,
            input: crate::model::StatisticsConfiguration,
        ) -> Self {
            self.dataset_statistics_configuration = Some(input);
            self
        }
        /// <p>Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
        /// parameters of evaluations. When configuration is undefined, the profile job will run all supported
        /// inter-column evaluations.
        /// </p>
        pub fn set_dataset_statistics_configuration(
            mut self,
            input: std::option::Option<crate::model::StatisticsConfiguration>,
        ) -> Self {
            self.dataset_statistics_configuration = input;
            self
        }
        /// Appends an item to `profile_columns`.
        ///
        /// To override the contents of this collection use [`set_profile_columns`](Self::set_profile_columns).
        ///
        /// <p>List of column selectors. ProfileColumns can be used to select columns from the dataset. When
        /// ProfileColumns is undefined, the profile job will profile all supported columns.
        /// </p>
        pub fn profile_columns(mut self, input: impl Into<crate::model::ColumnSelector>) -> Self {
            let mut v = self.profile_columns.unwrap_or_default();
            v.push(input.into());
            self.profile_columns = Some(v);
            self
        }
        /// <p>List of column selectors. ProfileColumns can be used to select columns from the dataset. When
        /// ProfileColumns is undefined, the profile job will profile all supported columns.
        /// </p>
        pub fn set_profile_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnSelector>>,
        ) -> Self {
            self.profile_columns = input;
            self
        }
        /// Appends an item to `column_statistics_configurations`.
        ///
        /// To override the contents of this collection use [`set_column_statistics_configurations`](Self::set_column_statistics_configurations).
        ///
        /// <p>List of configurations for column evaluations. ColumnStatisticsConfigurations are used to
        /// select evaluations and override parameters of evaluations for particular columns. When
        /// ColumnStatisticsConfigurations is undefined,  the profile job will profile all supported columns
        /// and run all supported  evaluations.
        /// </p>
        pub fn column_statistics_configurations(
            mut self,
            input: impl Into<crate::model::ColumnStatisticsConfiguration>,
        ) -> Self {
            let mut v = self.column_statistics_configurations.unwrap_or_default();
            v.push(input.into());
            self.column_statistics_configurations = Some(v);
            self
        }
        /// <p>List of configurations for column evaluations. ColumnStatisticsConfigurations are used to
        /// select evaluations and override parameters of evaluations for particular columns. When
        /// ColumnStatisticsConfigurations is undefined,  the profile job will profile all supported columns
        /// and run all supported  evaluations.
        /// </p>
        pub fn set_column_statistics_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsConfiguration>>,
        ) -> Self {
            self.column_statistics_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfileConfiguration`](crate::model::ProfileConfiguration)
        pub fn build(self) -> crate::model::ProfileConfiguration {
            crate::model::ProfileConfiguration {
                dataset_statistics_configuration: self.dataset_statistics_configuration,
                profile_columns: self.profile_columns,
                column_statistics_configurations: self.column_statistics_configurations,
            }
        }
    }
}
impl ProfileConfiguration {
    /// Creates a new builder-style object to manufacture [`ProfileConfiguration`](crate::model::ProfileConfiguration)
    pub fn builder() -> crate::model::profile_configuration::Builder {
        crate::model::profile_configuration::Builder::default()
    }
}

/// <p>Configuration for column evaluations for a profile job. ColumnStatisticsConfiguration can be used to select
/// evaluations and override parameters of evaluations for particular columns.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnStatisticsConfiguration {
    /// <p>List of column selectors. Selectors can be used to select columns from the dataset.
    /// When selectors are undefined, configuration will be applied to all supported columns.
    /// </p>
    pub selectors: std::option::Option<std::vec::Vec<crate::model::ColumnSelector>>,
    /// <p>Configuration for evaluations. Statistics can be used to select evaluations and override
    /// parameters of evaluations.
    /// </p>
    pub statistics: std::option::Option<crate::model::StatisticsConfiguration>,
}
impl std::fmt::Debug for ColumnStatisticsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnStatisticsConfiguration");
        formatter.field("selectors", &self.selectors);
        formatter.field("statistics", &self.statistics);
        formatter.finish()
    }
}
/// See [`ColumnStatisticsConfiguration`](crate::model::ColumnStatisticsConfiguration)
pub mod column_statistics_configuration {
    /// A builder for [`ColumnStatisticsConfiguration`](crate::model::ColumnStatisticsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selectors: std::option::Option<std::vec::Vec<crate::model::ColumnSelector>>,
        pub(crate) statistics: std::option::Option<crate::model::StatisticsConfiguration>,
    }
    impl Builder {
        /// Appends an item to `selectors`.
        ///
        /// To override the contents of this collection use [`set_selectors`](Self::set_selectors).
        ///
        /// <p>List of column selectors. Selectors can be used to select columns from the dataset.
        /// When selectors are undefined, configuration will be applied to all supported columns.
        /// </p>
        pub fn selectors(mut self, input: impl Into<crate::model::ColumnSelector>) -> Self {
            let mut v = self.selectors.unwrap_or_default();
            v.push(input.into());
            self.selectors = Some(v);
            self
        }
        /// <p>List of column selectors. Selectors can be used to select columns from the dataset.
        /// When selectors are undefined, configuration will be applied to all supported columns.
        /// </p>
        pub fn set_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnSelector>>,
        ) -> Self {
            self.selectors = input;
            self
        }
        /// <p>Configuration for evaluations. Statistics can be used to select evaluations and override
        /// parameters of evaluations.
        /// </p>
        pub fn statistics(mut self, input: crate::model::StatisticsConfiguration) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p>Configuration for evaluations. Statistics can be used to select evaluations and override
        /// parameters of evaluations.
        /// </p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::StatisticsConfiguration>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnStatisticsConfiguration`](crate::model::ColumnStatisticsConfiguration)
        pub fn build(self) -> crate::model::ColumnStatisticsConfiguration {
            crate::model::ColumnStatisticsConfiguration {
                selectors: self.selectors,
                statistics: self.statistics,
            }
        }
    }
}
impl ColumnStatisticsConfiguration {
    /// Creates a new builder-style object to manufacture [`ColumnStatisticsConfiguration`](crate::model::ColumnStatisticsConfiguration)
    pub fn builder() -> crate::model::column_statistics_configuration::Builder {
        crate::model::column_statistics_configuration::Builder::default()
    }
}

/// <p>Configuration of evaluations for a profile job. This configuration can be used to select
/// evaluations and override the parameters of selected evaluations.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatisticsConfiguration {
    /// <p>List of included evaluations. When the list is undefined, all supported
    /// evaluations will be included.</p>
    pub included_statistics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of overrides for evaluations.</p>
    pub overrides: std::option::Option<std::vec::Vec<crate::model::StatisticOverride>>,
}
impl std::fmt::Debug for StatisticsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatisticsConfiguration");
        formatter.field("included_statistics", &self.included_statistics);
        formatter.field("overrides", &self.overrides);
        formatter.finish()
    }
}
/// See [`StatisticsConfiguration`](crate::model::StatisticsConfiguration)
pub mod statistics_configuration {
    /// A builder for [`StatisticsConfiguration`](crate::model::StatisticsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) included_statistics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) overrides: std::option::Option<std::vec::Vec<crate::model::StatisticOverride>>,
    }
    impl Builder {
        /// Appends an item to `included_statistics`.
        ///
        /// To override the contents of this collection use [`set_included_statistics`](Self::set_included_statistics).
        ///
        /// <p>List of included evaluations. When the list is undefined, all supported
        /// evaluations will be included.</p>
        pub fn included_statistics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.included_statistics.unwrap_or_default();
            v.push(input.into());
            self.included_statistics = Some(v);
            self
        }
        /// <p>List of included evaluations. When the list is undefined, all supported
        /// evaluations will be included.</p>
        pub fn set_included_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.included_statistics = input;
            self
        }
        /// Appends an item to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>List of overrides for evaluations.</p>
        pub fn overrides(mut self, input: impl Into<crate::model::StatisticOverride>) -> Self {
            let mut v = self.overrides.unwrap_or_default();
            v.push(input.into());
            self.overrides = Some(v);
            self
        }
        /// <p>List of overrides for evaluations.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatisticOverride>>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`StatisticsConfiguration`](crate::model::StatisticsConfiguration)
        pub fn build(self) -> crate::model::StatisticsConfiguration {
            crate::model::StatisticsConfiguration {
                included_statistics: self.included_statistics,
                overrides: self.overrides,
            }
        }
    }
}
impl StatisticsConfiguration {
    /// Creates a new builder-style object to manufacture [`StatisticsConfiguration`](crate::model::StatisticsConfiguration)
    pub fn builder() -> crate::model::statistics_configuration::Builder {
        crate::model::statistics_configuration::Builder::default()
    }
}

/// <p>Override of a particular evaluation for a profile job. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatisticOverride {
    /// <p>The name of an evaluation</p>
    pub statistic: std::option::Option<std::string::String>,
    /// <p>A map that includes overrides of an evaluation’s parameters.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for StatisticOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatisticOverride");
        formatter.field("statistic", &self.statistic);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`StatisticOverride`](crate::model::StatisticOverride)
pub mod statistic_override {
    /// A builder for [`StatisticOverride`](crate::model::StatisticOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistic: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of an evaluation</p>
        pub fn statistic(mut self, input: impl Into<std::string::String>) -> Self {
            self.statistic = Some(input.into());
            self
        }
        /// <p>The name of an evaluation</p>
        pub fn set_statistic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statistic = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A map that includes overrides of an evaluation’s parameters.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A map that includes overrides of an evaluation’s parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`StatisticOverride`](crate::model::StatisticOverride)
        pub fn build(self) -> crate::model::StatisticOverride {
            crate::model::StatisticOverride {
                statistic: self.statistic,
                parameters: self.parameters,
            }
        }
    }
}
impl StatisticOverride {
    /// Creates a new builder-style object to manufacture [`StatisticOverride`](crate::model::StatisticOverride)
    pub fn builder() -> crate::model::statistic_override::Builder {
        crate::model::statistic_override::Builder::default()
    }
}

/// <p>Selector of a column from a dataset for profile job configuration. One selector includes either a column name or a regular
/// expression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnSelector {
    /// <p>A regular expression for selecting a column from a dataset.</p>
    pub regex: std::option::Option<std::string::String>,
    /// <p>The name of a column from a dataset.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ColumnSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnSelector");
        formatter.field("regex", &self.regex);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ColumnSelector`](crate::model::ColumnSelector)
pub mod column_selector {
    /// A builder for [`ColumnSelector`](crate::model::ColumnSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A regular expression for selecting a column from a dataset.</p>
        pub fn regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex = Some(input.into());
            self
        }
        /// <p>A regular expression for selecting a column from a dataset.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.regex = input;
            self
        }
        /// <p>The name of a column from a dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a column from a dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnSelector`](crate::model::ColumnSelector)
        pub fn build(self) -> crate::model::ColumnSelector {
            crate::model::ColumnSelector {
                regex: self.regex,
                name: self.name,
            }
        }
    }
}
impl ColumnSelector {
    /// Creates a new builder-style object to manufacture [`ColumnSelector`](crate::model::ColumnSelector)
    pub fn builder() -> crate::model::column_selector::Builder {
        crate::model::column_selector::Builder::default()
    }
}

/// <p>Represents a set of options that define how DataBrew selects files for a given Amazon S3
/// path in a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PathOptions {
    /// <p>If provided, this structure defines a date range for matching Amazon S3 objects based on their
    /// LastModifiedDate attribute in Amazon S3.</p>
    pub last_modified_date_condition: std::option::Option<crate::model::FilterExpression>,
    /// <p>If provided, this structure imposes a limit on a number of files that should be selected.</p>
    pub files_limit: std::option::Option<crate::model::FilesLimit>,
    /// <p>A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::DatasetParameter>,
    >,
}
impl std::fmt::Debug for PathOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PathOptions");
        formatter.field(
            "last_modified_date_condition",
            &self.last_modified_date_condition,
        );
        formatter.field("files_limit", &self.files_limit);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`PathOptions`](crate::model::PathOptions)
pub mod path_options {
    /// A builder for [`PathOptions`](crate::model::PathOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified_date_condition:
            std::option::Option<crate::model::FilterExpression>,
        pub(crate) files_limit: std::option::Option<crate::model::FilesLimit>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::DatasetParameter>,
        >,
    }
    impl Builder {
        /// <p>If provided, this structure defines a date range for matching Amazon S3 objects based on their
        /// LastModifiedDate attribute in Amazon S3.</p>
        pub fn last_modified_date_condition(
            mut self,
            input: crate::model::FilterExpression,
        ) -> Self {
            self.last_modified_date_condition = Some(input);
            self
        }
        /// <p>If provided, this structure defines a date range for matching Amazon S3 objects based on their
        /// LastModifiedDate attribute in Amazon S3.</p>
        pub fn set_last_modified_date_condition(
            mut self,
            input: std::option::Option<crate::model::FilterExpression>,
        ) -> Self {
            self.last_modified_date_condition = input;
            self
        }
        /// <p>If provided, this structure imposes a limit on a number of files that should be selected.</p>
        pub fn files_limit(mut self, input: crate::model::FilesLimit) -> Self {
            self.files_limit = Some(input);
            self
        }
        /// <p>If provided, this structure imposes a limit on a number of files that should be selected.</p>
        pub fn set_files_limit(
            mut self,
            input: std::option::Option<crate::model::FilesLimit>,
        ) -> Self {
            self.files_limit = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::DatasetParameter>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::DatasetParameter>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`PathOptions`](crate::model::PathOptions)
        pub fn build(self) -> crate::model::PathOptions {
            crate::model::PathOptions {
                last_modified_date_condition: self.last_modified_date_condition,
                files_limit: self.files_limit,
                parameters: self.parameters,
            }
        }
    }
}
impl PathOptions {
    /// Creates a new builder-style object to manufacture [`PathOptions`](crate::model::PathOptions)
    pub fn builder() -> crate::model::path_options::Builder {
        crate::model::path_options::Builder::default()
    }
}

/// <p>Represents a dataset paramater that defines type and conditions for a parameter in the Amazon S3
/// path of the dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetParameter {
    /// <p>The name of the parameter that is used in the dataset's Amazon S3 path.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the dataset parameter, can be one of a 'String', 'Number' or 'Datetime'.</p>
    pub r#type: std::option::Option<crate::model::ParameterType>,
    /// <p>Additional parameter options such as a format and a timezone. Required for datetime parameters.</p>
    pub datetime_options: std::option::Option<crate::model::DatetimeOptions>,
    /// <p>Optional boolean value that defines whether the captured value of this parameter
    /// should be used to create a new column in a dataset.</p>
    pub create_column: bool,
    /// <p>The optional filter expression structure to apply additional matching criteria to the parameter.</p>
    pub filter: std::option::Option<crate::model::FilterExpression>,
}
impl std::fmt::Debug for DatasetParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetParameter");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("datetime_options", &self.datetime_options);
        formatter.field("create_column", &self.create_column);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`DatasetParameter`](crate::model::DatasetParameter)
pub mod dataset_parameter {
    /// A builder for [`DatasetParameter`](crate::model::DatasetParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ParameterType>,
        pub(crate) datetime_options: std::option::Option<crate::model::DatetimeOptions>,
        pub(crate) create_column: std::option::Option<bool>,
        pub(crate) filter: std::option::Option<crate::model::FilterExpression>,
    }
    impl Builder {
        /// <p>The name of the parameter that is used in the dataset's Amazon S3 path.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter that is used in the dataset's Amazon S3 path.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the dataset parameter, can be one of a 'String', 'Number' or 'Datetime'.</p>
        pub fn r#type(mut self, input: crate::model::ParameterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the dataset parameter, can be one of a 'String', 'Number' or 'Datetime'.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParameterType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Additional parameter options such as a format and a timezone. Required for datetime parameters.</p>
        pub fn datetime_options(mut self, input: crate::model::DatetimeOptions) -> Self {
            self.datetime_options = Some(input);
            self
        }
        /// <p>Additional parameter options such as a format and a timezone. Required for datetime parameters.</p>
        pub fn set_datetime_options(
            mut self,
            input: std::option::Option<crate::model::DatetimeOptions>,
        ) -> Self {
            self.datetime_options = input;
            self
        }
        /// <p>Optional boolean value that defines whether the captured value of this parameter
        /// should be used to create a new column in a dataset.</p>
        pub fn create_column(mut self, input: bool) -> Self {
            self.create_column = Some(input);
            self
        }
        /// <p>Optional boolean value that defines whether the captured value of this parameter
        /// should be used to create a new column in a dataset.</p>
        pub fn set_create_column(mut self, input: std::option::Option<bool>) -> Self {
            self.create_column = input;
            self
        }
        /// <p>The optional filter expression structure to apply additional matching criteria to the parameter.</p>
        pub fn filter(mut self, input: crate::model::FilterExpression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The optional filter expression structure to apply additional matching criteria to the parameter.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::FilterExpression>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetParameter`](crate::model::DatasetParameter)
        pub fn build(self) -> crate::model::DatasetParameter {
            crate::model::DatasetParameter {
                name: self.name,
                r#type: self.r#type,
                datetime_options: self.datetime_options,
                create_column: self.create_column.unwrap_or_default(),
                filter: self.filter,
            }
        }
    }
}
impl DatasetParameter {
    /// Creates a new builder-style object to manufacture [`DatasetParameter`](crate::model::DatasetParameter)
    pub fn builder() -> crate::model::dataset_parameter::Builder {
        crate::model::dataset_parameter::Builder::default()
    }
}

/// <p>Represents a structure for defining parameter conditions. Supported conditions are described
/// here: <a href="https://docs-aws.amazon.com/databrew/latest/dg/datasets.multiple-files.html#conditions.for.dynamic.datasets">Supported
/// conditions for dynamic datasets</a> in the
/// <i>Glue DataBrew Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterExpression {
    /// <p>The expression which includes condition names followed by substitution variables, possibly grouped
    /// and combined with other conditions. For example, "(starts_with :prefix1 or starts_with :prefix2) and
    /// (ends_with :suffix1 or ends_with :suffix2)". Substitution variables should start with ':' symbol.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The map of substitution variable names to their values used in this filter expression.</p>
    pub values_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for FilterExpression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterExpression");
        formatter.field("expression", &self.expression);
        formatter.field("values_map", &self.values_map);
        formatter.finish()
    }
}
/// See [`FilterExpression`](crate::model::FilterExpression)
pub mod filter_expression {
    /// A builder for [`FilterExpression`](crate::model::FilterExpression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) values_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The expression which includes condition names followed by substitution variables, possibly grouped
        /// and combined with other conditions. For example, "(starts_with :prefix1 or starts_with :prefix2) and
        /// (ends_with :suffix1 or ends_with :suffix2)". Substitution variables should start with ':' symbol.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The expression which includes condition names followed by substitution variables, possibly grouped
        /// and combined with other conditions. For example, "(starts_with :prefix1 or starts_with :prefix2) and
        /// (ends_with :suffix1 or ends_with :suffix2)". Substitution variables should start with ':' symbol.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Adds a key-value pair to `values_map`.
        ///
        /// To override the contents of this collection use [`set_values_map`](Self::set_values_map).
        ///
        /// <p>The map of substitution variable names to their values used in this filter expression.</p>
        pub fn values_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.values_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.values_map = Some(hash_map);
            self
        }
        /// <p>The map of substitution variable names to their values used in this filter expression.</p>
        pub fn set_values_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.values_map = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterExpression`](crate::model::FilterExpression)
        pub fn build(self) -> crate::model::FilterExpression {
            crate::model::FilterExpression {
                expression: self.expression,
                values_map: self.values_map,
            }
        }
    }
}
impl FilterExpression {
    /// Creates a new builder-style object to manufacture [`FilterExpression`](crate::model::FilterExpression)
    pub fn builder() -> crate::model::filter_expression::Builder {
        crate::model::filter_expression::Builder::default()
    }
}

/// <p>Represents additional options for correct interpretation of datetime parameters used in
/// the Amazon S3 path of a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatetimeOptions {
    /// <p>Required option, that defines the datetime format used for a date parameter in the
    /// Amazon S3 path. Should use only supported datetime specifiers and separation characters, all
    /// literal a-z or A-Z characters should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>Optional value for a timezone offset of the datetime parameter value in the Amazon S3
    /// path. Shouldn't be used if Format for this parameter includes timezone fields.
    /// If no offset specified, UTC is assumed.</p>
    pub timezone_offset: std::option::Option<std::string::String>,
    /// <p>Optional value for a non-US locale code, needed for correct interpretation of some date formats.</p>
    pub locale_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DatetimeOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatetimeOptions");
        formatter.field("format", &self.format);
        formatter.field("timezone_offset", &self.timezone_offset);
        formatter.field("locale_code", &self.locale_code);
        formatter.finish()
    }
}
/// See [`DatetimeOptions`](crate::model::DatetimeOptions)
pub mod datetime_options {
    /// A builder for [`DatetimeOptions`](crate::model::DatetimeOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) timezone_offset: std::option::Option<std::string::String>,
        pub(crate) locale_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required option, that defines the datetime format used for a date parameter in the
        /// Amazon S3 path. Should use only supported datetime specifiers and separation characters, all
        /// literal a-z or A-Z characters should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>Required option, that defines the datetime format used for a date parameter in the
        /// Amazon S3 path. Should use only supported datetime specifiers and separation characters, all
        /// literal a-z or A-Z characters should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>Optional value for a timezone offset of the datetime parameter value in the Amazon S3
        /// path. Shouldn't be used if Format for this parameter includes timezone fields.
        /// If no offset specified, UTC is assumed.</p>
        pub fn timezone_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone_offset = Some(input.into());
            self
        }
        /// <p>Optional value for a timezone offset of the datetime parameter value in the Amazon S3
        /// path. Shouldn't be used if Format for this parameter includes timezone fields.
        /// If no offset specified, UTC is assumed.</p>
        pub fn set_timezone_offset(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timezone_offset = input;
            self
        }
        /// <p>Optional value for a non-US locale code, needed for correct interpretation of some date formats.</p>
        pub fn locale_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_code = Some(input.into());
            self
        }
        /// <p>Optional value for a non-US locale code, needed for correct interpretation of some date formats.</p>
        pub fn set_locale_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DatetimeOptions`](crate::model::DatetimeOptions)
        pub fn build(self) -> crate::model::DatetimeOptions {
            crate::model::DatetimeOptions {
                format: self.format,
                timezone_offset: self.timezone_offset,
                locale_code: self.locale_code,
            }
        }
    }
}
impl DatetimeOptions {
    /// Creates a new builder-style object to manufacture [`DatetimeOptions`](crate::model::DatetimeOptions)
    pub fn builder() -> crate::model::datetime_options::Builder {
        crate::model::datetime_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterType {
    #[allow(missing_docs)] // documentation missing in model
    Datetime,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterType {
    fn from(s: &str) -> Self {
        match s {
            "Datetime" => ParameterType::Datetime,
            "Number" => ParameterType::Number,
            "String" => ParameterType::String,
            other => ParameterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterType::from(s))
    }
}
impl ParameterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterType::Datetime => "Datetime",
            ParameterType::Number => "Number",
            ParameterType::String => "String",
            ParameterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Datetime", "Number", "String"]
    }
}
impl AsRef<str> for ParameterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a limit imposed on number of Amazon S3 files that should be selected for a dataset from a connected
/// Amazon S3 path.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilesLimit {
    /// <p>The number of Amazon S3 files to select.</p>
    pub max_files: i32,
    /// <p>A criteria to use for Amazon S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as
    /// a sorting criteria. Currently it's the only allowed value.</p>
    pub ordered_by: std::option::Option<crate::model::OrderedBy>,
    /// <p>A criteria to use for Amazon S3 files sorting before their selection. By default uses DESCENDING order,
    /// i.e. most recent files are selected first. Anotherpossible value is ASCENDING.</p>
    pub order: std::option::Option<crate::model::Order>,
}
impl std::fmt::Debug for FilesLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilesLimit");
        formatter.field("max_files", &self.max_files);
        formatter.field("ordered_by", &self.ordered_by);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`FilesLimit`](crate::model::FilesLimit)
pub mod files_limit {
    /// A builder for [`FilesLimit`](crate::model::FilesLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_files: std::option::Option<i32>,
        pub(crate) ordered_by: std::option::Option<crate::model::OrderedBy>,
        pub(crate) order: std::option::Option<crate::model::Order>,
    }
    impl Builder {
        /// <p>The number of Amazon S3 files to select.</p>
        pub fn max_files(mut self, input: i32) -> Self {
            self.max_files = Some(input);
            self
        }
        /// <p>The number of Amazon S3 files to select.</p>
        pub fn set_max_files(mut self, input: std::option::Option<i32>) -> Self {
            self.max_files = input;
            self
        }
        /// <p>A criteria to use for Amazon S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as
        /// a sorting criteria. Currently it's the only allowed value.</p>
        pub fn ordered_by(mut self, input: crate::model::OrderedBy) -> Self {
            self.ordered_by = Some(input);
            self
        }
        /// <p>A criteria to use for Amazon S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as
        /// a sorting criteria. Currently it's the only allowed value.</p>
        pub fn set_ordered_by(
            mut self,
            input: std::option::Option<crate::model::OrderedBy>,
        ) -> Self {
            self.ordered_by = input;
            self
        }
        /// <p>A criteria to use for Amazon S3 files sorting before their selection. By default uses DESCENDING order,
        /// i.e. most recent files are selected first. Anotherpossible value is ASCENDING.</p>
        pub fn order(mut self, input: crate::model::Order) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>A criteria to use for Amazon S3 files sorting before their selection. By default uses DESCENDING order,
        /// i.e. most recent files are selected first. Anotherpossible value is ASCENDING.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::Order>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`FilesLimit`](crate::model::FilesLimit)
        pub fn build(self) -> crate::model::FilesLimit {
            crate::model::FilesLimit {
                max_files: self.max_files.unwrap_or_default(),
                ordered_by: self.ordered_by,
                order: self.order,
            }
        }
    }
}
impl FilesLimit {
    /// Creates a new builder-style object to manufacture [`FilesLimit`](crate::model::FilesLimit)
    pub fn builder() -> crate::model::files_limit::Builder {
        crate::model::files_limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Order {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Order {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => Order::Ascending,
            "DESCENDING" => Order::Descending,
            other => Order::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Order {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Order::from(s))
    }
}
impl Order {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Order::Ascending => "ASCENDING",
            Order::Descending => "DESCENDING",
            Order::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for Order {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderedBy {
    #[allow(missing_docs)] // documentation missing in model
    LastModifiedDate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderedBy {
    fn from(s: &str) -> Self {
        match s {
            "LAST_MODIFIED_DATE" => OrderedBy::LastModifiedDate,
            other => OrderedBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderedBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderedBy::from(s))
    }
}
impl OrderedBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderedBy::LastModifiedDate => "LAST_MODIFIED_DATE",
            OrderedBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAST_MODIFIED_DATE"]
    }
}
impl AsRef<str> for OrderedBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents information on how DataBrew can find data, in either the Glue Data Catalog or
/// Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Input {
    /// <p>The Amazon S3 location where the data is stored.</p>
    pub s3_input_definition: std::option::Option<crate::model::S3Location>,
    /// <p>The Glue Data Catalog parameters for the data.</p>
    pub data_catalog_input_definition:
        std::option::Option<crate::model::DataCatalogInputDefinition>,
    /// <p>Connection information for dataset input files stored in a database.</p>
    pub database_input_definition: std::option::Option<crate::model::DatabaseInputDefinition>,
}
impl std::fmt::Debug for Input {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Input");
        formatter.field("s3_input_definition", &self.s3_input_definition);
        formatter.field(
            "data_catalog_input_definition",
            &self.data_catalog_input_definition,
        );
        formatter.field("database_input_definition", &self.database_input_definition);
        formatter.finish()
    }
}
/// See [`Input`](crate::model::Input)
pub mod input {
    /// A builder for [`Input`](crate::model::Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_input_definition: std::option::Option<crate::model::S3Location>,
        pub(crate) data_catalog_input_definition:
            std::option::Option<crate::model::DataCatalogInputDefinition>,
        pub(crate) database_input_definition:
            std::option::Option<crate::model::DatabaseInputDefinition>,
    }
    impl Builder {
        /// <p>The Amazon S3 location where the data is stored.</p>
        pub fn s3_input_definition(mut self, input: crate::model::S3Location) -> Self {
            self.s3_input_definition = Some(input);
            self
        }
        /// <p>The Amazon S3 location where the data is stored.</p>
        pub fn set_s3_input_definition(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_input_definition = input;
            self
        }
        /// <p>The Glue Data Catalog parameters for the data.</p>
        pub fn data_catalog_input_definition(
            mut self,
            input: crate::model::DataCatalogInputDefinition,
        ) -> Self {
            self.data_catalog_input_definition = Some(input);
            self
        }
        /// <p>The Glue Data Catalog parameters for the data.</p>
        pub fn set_data_catalog_input_definition(
            mut self,
            input: std::option::Option<crate::model::DataCatalogInputDefinition>,
        ) -> Self {
            self.data_catalog_input_definition = input;
            self
        }
        /// <p>Connection information for dataset input files stored in a database.</p>
        pub fn database_input_definition(
            mut self,
            input: crate::model::DatabaseInputDefinition,
        ) -> Self {
            self.database_input_definition = Some(input);
            self
        }
        /// <p>Connection information for dataset input files stored in a database.</p>
        pub fn set_database_input_definition(
            mut self,
            input: std::option::Option<crate::model::DatabaseInputDefinition>,
        ) -> Self {
            self.database_input_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`Input`](crate::model::Input)
        pub fn build(self) -> crate::model::Input {
            crate::model::Input {
                s3_input_definition: self.s3_input_definition,
                data_catalog_input_definition: self.data_catalog_input_definition,
                database_input_definition: self.database_input_definition,
            }
        }
    }
}
impl Input {
    /// Creates a new builder-style object to manufacture [`Input`](crate::model::Input)
    pub fn builder() -> crate::model::input::Builder {
        crate::model::input::Builder::default()
    }
}

/// <p>Connection information for dataset input files stored in a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseInputDefinition {
    /// <p>The Glue Connection that stores the connection information for the target
    /// database.</p>
    pub glue_connection_name: std::option::Option<std::string::String>,
    /// <p>The table within the target database.</p>
    pub database_table_name: std::option::Option<std::string::String>,
    /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
    /// input data, or write output from a job.</p>
    pub temp_directory: std::option::Option<crate::model::S3Location>,
}
impl std::fmt::Debug for DatabaseInputDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseInputDefinition");
        formatter.field("glue_connection_name", &self.glue_connection_name);
        formatter.field("database_table_name", &self.database_table_name);
        formatter.field("temp_directory", &self.temp_directory);
        formatter.finish()
    }
}
/// See [`DatabaseInputDefinition`](crate::model::DatabaseInputDefinition)
pub mod database_input_definition {
    /// A builder for [`DatabaseInputDefinition`](crate::model::DatabaseInputDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) glue_connection_name: std::option::Option<std::string::String>,
        pub(crate) database_table_name: std::option::Option<std::string::String>,
        pub(crate) temp_directory: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The Glue Connection that stores the connection information for the target
        /// database.</p>
        pub fn glue_connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_connection_name = Some(input.into());
            self
        }
        /// <p>The Glue Connection that stores the connection information for the target
        /// database.</p>
        pub fn set_glue_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.glue_connection_name = input;
            self
        }
        /// <p>The table within the target database.</p>
        pub fn database_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_table_name = Some(input.into());
            self
        }
        /// <p>The table within the target database.</p>
        pub fn set_database_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_table_name = input;
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn temp_directory(mut self, input: crate::model::S3Location) -> Self {
            self.temp_directory = Some(input);
            self
        }
        /// <p>Represents an Amazon S3 location (bucket name and object key) where DataBrew can read
        /// input data, or write output from a job.</p>
        pub fn set_temp_directory(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.temp_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseInputDefinition`](crate::model::DatabaseInputDefinition)
        pub fn build(self) -> crate::model::DatabaseInputDefinition {
            crate::model::DatabaseInputDefinition {
                glue_connection_name: self.glue_connection_name,
                database_table_name: self.database_table_name,
                temp_directory: self.temp_directory,
            }
        }
    }
}
impl DatabaseInputDefinition {
    /// Creates a new builder-style object to manufacture [`DatabaseInputDefinition`](crate::model::DatabaseInputDefinition)
    pub fn builder() -> crate::model::database_input_definition::Builder {
        crate::model::database_input_definition::Builder::default()
    }
}

/// <p>Represents how metadata stored in the Glue Data Catalog is defined in a DataBrew
/// dataset. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCatalogInputDefinition {
    /// <p>The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the
    /// data.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of a database in the Data Catalog.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of a database table in the Data Catalog. This table corresponds to a DataBrew
    /// dataset.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Represents an Amazon location where DataBrew can store intermediate results.</p>
    pub temp_directory: std::option::Option<crate::model::S3Location>,
}
impl std::fmt::Debug for DataCatalogInputDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCatalogInputDefinition");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("temp_directory", &self.temp_directory);
        formatter.finish()
    }
}
/// See [`DataCatalogInputDefinition`](crate::model::DataCatalogInputDefinition)
pub mod data_catalog_input_definition {
    /// A builder for [`DataCatalogInputDefinition`](crate::model::DataCatalogInputDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) temp_directory: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the
        /// data.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the
        /// data.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of a database in the Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of a database in the Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of a database table in the Data Catalog. This table corresponds to a DataBrew
        /// dataset.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of a database table in the Data Catalog. This table corresponds to a DataBrew
        /// dataset.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Represents an Amazon location where DataBrew can store intermediate results.</p>
        pub fn temp_directory(mut self, input: crate::model::S3Location) -> Self {
            self.temp_directory = Some(input);
            self
        }
        /// <p>Represents an Amazon location where DataBrew can store intermediate results.</p>
        pub fn set_temp_directory(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.temp_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCatalogInputDefinition`](crate::model::DataCatalogInputDefinition)
        pub fn build(self) -> crate::model::DataCatalogInputDefinition {
            crate::model::DataCatalogInputDefinition {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                temp_directory: self.temp_directory,
            }
        }
    }
}
impl DataCatalogInputDefinition {
    /// Creates a new builder-style object to manufacture [`DataCatalogInputDefinition`](crate::model::DataCatalogInputDefinition)
    pub fn builder() -> crate::model::data_catalog_input_definition::Builder {
        crate::model::data_catalog_input_definition::Builder::default()
    }
}

/// <p>Represents a set of options that define the structure of either comma-separated value (CSV),
/// Excel, or JSON input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FormatOptions {
    /// <p>Options that define how JSON input is to be interpreted by DataBrew.</p>
    pub json: std::option::Option<crate::model::JsonOptions>,
    /// <p>Options that define how Excel input is to be interpreted by DataBrew.</p>
    pub excel: std::option::Option<crate::model::ExcelOptions>,
    /// <p>Options that define how CSV input is to be interpreted by DataBrew.</p>
    pub csv: std::option::Option<crate::model::CsvOptions>,
}
impl std::fmt::Debug for FormatOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FormatOptions");
        formatter.field("json", &self.json);
        formatter.field("excel", &self.excel);
        formatter.field("csv", &self.csv);
        formatter.finish()
    }
}
/// See [`FormatOptions`](crate::model::FormatOptions)
pub mod format_options {
    /// A builder for [`FormatOptions`](crate::model::FormatOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) json: std::option::Option<crate::model::JsonOptions>,
        pub(crate) excel: std::option::Option<crate::model::ExcelOptions>,
        pub(crate) csv: std::option::Option<crate::model::CsvOptions>,
    }
    impl Builder {
        /// <p>Options that define how JSON input is to be interpreted by DataBrew.</p>
        pub fn json(mut self, input: crate::model::JsonOptions) -> Self {
            self.json = Some(input);
            self
        }
        /// <p>Options that define how JSON input is to be interpreted by DataBrew.</p>
        pub fn set_json(mut self, input: std::option::Option<crate::model::JsonOptions>) -> Self {
            self.json = input;
            self
        }
        /// <p>Options that define how Excel input is to be interpreted by DataBrew.</p>
        pub fn excel(mut self, input: crate::model::ExcelOptions) -> Self {
            self.excel = Some(input);
            self
        }
        /// <p>Options that define how Excel input is to be interpreted by DataBrew.</p>
        pub fn set_excel(mut self, input: std::option::Option<crate::model::ExcelOptions>) -> Self {
            self.excel = input;
            self
        }
        /// <p>Options that define how CSV input is to be interpreted by DataBrew.</p>
        pub fn csv(mut self, input: crate::model::CsvOptions) -> Self {
            self.csv = Some(input);
            self
        }
        /// <p>Options that define how CSV input is to be interpreted by DataBrew.</p>
        pub fn set_csv(mut self, input: std::option::Option<crate::model::CsvOptions>) -> Self {
            self.csv = input;
            self
        }
        /// Consumes the builder and constructs a [`FormatOptions`](crate::model::FormatOptions)
        pub fn build(self) -> crate::model::FormatOptions {
            crate::model::FormatOptions {
                json: self.json,
                excel: self.excel,
                csv: self.csv,
            }
        }
    }
}
impl FormatOptions {
    /// Creates a new builder-style object to manufacture [`FormatOptions`](crate::model::FormatOptions)
    pub fn builder() -> crate::model::format_options::Builder {
        crate::model::format_options::Builder::default()
    }
}

/// <p>Represents a set of options that define how DataBrew will read a
/// comma-separated value (CSV) file when creating a dataset from that file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvOptions {
    /// <p>A single character that specifies the delimiter being used in the CSV file.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>A variable that specifies whether the first row in the file is parsed as the
    /// header. If this value is false, column names are auto-generated.</p>
    pub header_row: std::option::Option<bool>,
}
impl std::fmt::Debug for CsvOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvOptions");
        formatter.field("delimiter", &self.delimiter);
        formatter.field("header_row", &self.header_row);
        formatter.finish()
    }
}
/// See [`CsvOptions`](crate::model::CsvOptions)
pub mod csv_options {
    /// A builder for [`CsvOptions`](crate::model::CsvOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) header_row: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A single character that specifies the delimiter being used in the CSV file.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A single character that specifies the delimiter being used in the CSV file.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>A variable that specifies whether the first row in the file is parsed as the
        /// header. If this value is false, column names are auto-generated.</p>
        pub fn header_row(mut self, input: bool) -> Self {
            self.header_row = Some(input);
            self
        }
        /// <p>A variable that specifies whether the first row in the file is parsed as the
        /// header. If this value is false, column names are auto-generated.</p>
        pub fn set_header_row(mut self, input: std::option::Option<bool>) -> Self {
            self.header_row = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvOptions`](crate::model::CsvOptions)
        pub fn build(self) -> crate::model::CsvOptions {
            crate::model::CsvOptions {
                delimiter: self.delimiter,
                header_row: self.header_row,
            }
        }
    }
}
impl CsvOptions {
    /// Creates a new builder-style object to manufacture [`CsvOptions`](crate::model::CsvOptions)
    pub fn builder() -> crate::model::csv_options::Builder {
        crate::model::csv_options::Builder::default()
    }
}

/// <p>Represents a set of options that define how DataBrew will interpret a Microsoft Excel file when
/// creating a dataset from that file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExcelOptions {
    /// <p>One or more named sheets in the Excel file that will be included in the dataset.</p>
    pub sheet_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more sheet numbers in the Excel file that will be included in the
    /// dataset.</p>
    pub sheet_indexes: std::option::Option<std::vec::Vec<i32>>,
    /// <p>A variable that specifies whether the first row in the file is parsed as the
    /// header. If this value is false, column names are auto-generated.</p>
    pub header_row: std::option::Option<bool>,
}
impl std::fmt::Debug for ExcelOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExcelOptions");
        formatter.field("sheet_names", &self.sheet_names);
        formatter.field("sheet_indexes", &self.sheet_indexes);
        formatter.field("header_row", &self.header_row);
        formatter.finish()
    }
}
/// See [`ExcelOptions`](crate::model::ExcelOptions)
pub mod excel_options {
    /// A builder for [`ExcelOptions`](crate::model::ExcelOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sheet_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sheet_indexes: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) header_row: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `sheet_names`.
        ///
        /// To override the contents of this collection use [`set_sheet_names`](Self::set_sheet_names).
        ///
        /// <p>One or more named sheets in the Excel file that will be included in the dataset.</p>
        pub fn sheet_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sheet_names.unwrap_or_default();
            v.push(input.into());
            self.sheet_names = Some(v);
            self
        }
        /// <p>One or more named sheets in the Excel file that will be included in the dataset.</p>
        pub fn set_sheet_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sheet_names = input;
            self
        }
        /// Appends an item to `sheet_indexes`.
        ///
        /// To override the contents of this collection use [`set_sheet_indexes`](Self::set_sheet_indexes).
        ///
        /// <p>One or more sheet numbers in the Excel file that will be included in the
        /// dataset.</p>
        pub fn sheet_indexes(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.sheet_indexes.unwrap_or_default();
            v.push(input.into());
            self.sheet_indexes = Some(v);
            self
        }
        /// <p>One or more sheet numbers in the Excel file that will be included in the
        /// dataset.</p>
        pub fn set_sheet_indexes(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.sheet_indexes = input;
            self
        }
        /// <p>A variable that specifies whether the first row in the file is parsed as the
        /// header. If this value is false, column names are auto-generated.</p>
        pub fn header_row(mut self, input: bool) -> Self {
            self.header_row = Some(input);
            self
        }
        /// <p>A variable that specifies whether the first row in the file is parsed as the
        /// header. If this value is false, column names are auto-generated.</p>
        pub fn set_header_row(mut self, input: std::option::Option<bool>) -> Self {
            self.header_row = input;
            self
        }
        /// Consumes the builder and constructs a [`ExcelOptions`](crate::model::ExcelOptions)
        pub fn build(self) -> crate::model::ExcelOptions {
            crate::model::ExcelOptions {
                sheet_names: self.sheet_names,
                sheet_indexes: self.sheet_indexes,
                header_row: self.header_row,
            }
        }
    }
}
impl ExcelOptions {
    /// Creates a new builder-style object to manufacture [`ExcelOptions`](crate::model::ExcelOptions)
    pub fn builder() -> crate::model::excel_options::Builder {
        crate::model::excel_options::Builder::default()
    }
}

/// <p>Represents the JSON-specific options that define how input is to be interpreted by Glue DataBrew.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonOptions {
    /// <p>A value that specifies whether JSON input contains embedded new line
    /// characters.</p>
    pub multi_line: bool,
}
impl std::fmt::Debug for JsonOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonOptions");
        formatter.field("multi_line", &self.multi_line);
        formatter.finish()
    }
}
/// See [`JsonOptions`](crate::model::JsonOptions)
pub mod json_options {
    /// A builder for [`JsonOptions`](crate::model::JsonOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multi_line: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that specifies whether JSON input contains embedded new line
        /// characters.</p>
        pub fn multi_line(mut self, input: bool) -> Self {
            self.multi_line = Some(input);
            self
        }
        /// <p>A value that specifies whether JSON input contains embedded new line
        /// characters.</p>
        pub fn set_multi_line(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_line = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonOptions`](crate::model::JsonOptions)
        pub fn build(self) -> crate::model::JsonOptions {
            crate::model::JsonOptions {
                multi_line: self.multi_line.unwrap_or_default(),
            }
        }
    }
}
impl JsonOptions {
    /// Creates a new builder-style object to manufacture [`JsonOptions`](crate::model::JsonOptions)
    pub fn builder() -> crate::model::json_options::Builder {
        crate::model::json_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Excel,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => InputFormat::Csv,
            "EXCEL" => InputFormat::Excel,
            "JSON" => InputFormat::Json,
            "PARQUET" => InputFormat::Parquet,
            other => InputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputFormat::from(s))
    }
}
impl InputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputFormat::Csv => "CSV",
            InputFormat::Excel => "EXCEL",
            InputFormat::Json => "JSON",
            InputFormat::Parquet => "PARQUET",
            InputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "EXCEL", "JSON", "PARQUET"]
    }
}
impl AsRef<str> for InputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the data being transformed during an action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViewFrame {
    /// <p>The starting index for the range of columns to return in the view frame.</p>
    pub start_column_index: std::option::Option<i32>,
    /// <p>The number of columns to include in the view frame, beginning with the
    /// <code>StartColumnIndex</code> value and ignoring any columns in the
    /// <code>HiddenColumns</code> list.</p>
    pub column_range: std::option::Option<i32>,
    /// <p>A list of columns to hide in the view frame.</p>
    pub hidden_columns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ViewFrame {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViewFrame");
        formatter.field("start_column_index", &self.start_column_index);
        formatter.field("column_range", &self.column_range);
        formatter.field("hidden_columns", &self.hidden_columns);
        formatter.finish()
    }
}
/// See [`ViewFrame`](crate::model::ViewFrame)
pub mod view_frame {
    /// A builder for [`ViewFrame`](crate::model::ViewFrame)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_column_index: std::option::Option<i32>,
        pub(crate) column_range: std::option::Option<i32>,
        pub(crate) hidden_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The starting index for the range of columns to return in the view frame.</p>
        pub fn start_column_index(mut self, input: i32) -> Self {
            self.start_column_index = Some(input);
            self
        }
        /// <p>The starting index for the range of columns to return in the view frame.</p>
        pub fn set_start_column_index(mut self, input: std::option::Option<i32>) -> Self {
            self.start_column_index = input;
            self
        }
        /// <p>The number of columns to include in the view frame, beginning with the
        /// <code>StartColumnIndex</code> value and ignoring any columns in the
        /// <code>HiddenColumns</code> list.</p>
        pub fn column_range(mut self, input: i32) -> Self {
            self.column_range = Some(input);
            self
        }
        /// <p>The number of columns to include in the view frame, beginning with the
        /// <code>StartColumnIndex</code> value and ignoring any columns in the
        /// <code>HiddenColumns</code> list.</p>
        pub fn set_column_range(mut self, input: std::option::Option<i32>) -> Self {
            self.column_range = input;
            self
        }
        /// Appends an item to `hidden_columns`.
        ///
        /// To override the contents of this collection use [`set_hidden_columns`](Self::set_hidden_columns).
        ///
        /// <p>A list of columns to hide in the view frame.</p>
        pub fn hidden_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hidden_columns.unwrap_or_default();
            v.push(input.into());
            self.hidden_columns = Some(v);
            self
        }
        /// <p>A list of columns to hide in the view frame.</p>
        pub fn set_hidden_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hidden_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`ViewFrame`](crate::model::ViewFrame)
        pub fn build(self) -> crate::model::ViewFrame {
            crate::model::ViewFrame {
                start_column_index: self.start_column_index,
                column_range: self.column_range,
                hidden_columns: self.hidden_columns,
            }
        }
    }
}
impl ViewFrame {
    /// Creates a new builder-style object to manufacture [`ViewFrame`](crate::model::ViewFrame)
    pub fn builder() -> crate::model::view_frame::Builder {
        crate::model::view_frame::Builder::default()
    }
}

/// <p>Represents one or more dates and times when a job is to run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schedule {
    /// <p>The ID of the Amazon Web Services account that owns the schedule.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user who created the schedule.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the schedule was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of jobs to be run, according to the schedule.</p>
    pub job_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the schedule.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the schedule was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The dates and times when the job is to run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
    /// expressions</a> in the <i>Glue DataBrew Developer
    /// Guide</i>.</p>
    pub cron_expression: std::option::Option<std::string::String>,
    /// <p>Metadata tags that have been applied to the schedule.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the schedule.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Schedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schedule");
        formatter.field("account_id", &self.account_id);
        formatter.field("created_by", &self.created_by);
        formatter.field("create_date", &self.create_date);
        formatter.field("job_names", &self.job_names);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("cron_expression", &self.cron_expression);
        formatter.field("tags", &self.tags);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Schedule`](crate::model::Schedule)
pub mod schedule {
    /// A builder for [`Schedule`](crate::model::Schedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) cron_expression: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that owns the schedule.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the schedule.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the schedule.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the schedule.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the schedule was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the schedule was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Appends an item to `job_names`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>A list of jobs to be run, according to the schedule.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_names.unwrap_or_default();
            v.push(input.into());
            self.job_names = Some(v);
            self
        }
        /// <p>A list of jobs to be run, according to the schedule.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_names = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the schedule.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the schedule.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time when the schedule was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time when the schedule was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schedule.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The dates and times when the job is to run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.cron_expression = Some(input.into());
            self
        }
        /// <p>The dates and times when the job is to run. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
        /// expressions</a> in the <i>Glue DataBrew Developer
        /// Guide</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags that have been applied to the schedule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags that have been applied to the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the schedule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the schedule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Schedule`](crate::model::Schedule)
        pub fn build(self) -> crate::model::Schedule {
            crate::model::Schedule {
                account_id: self.account_id,
                created_by: self.created_by,
                create_date: self.create_date,
                job_names: self.job_names,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                resource_arn: self.resource_arn,
                cron_expression: self.cron_expression,
                tags: self.tags,
                name: self.name,
            }
        }
    }
}
impl Schedule {
    /// Creates a new builder-style object to manufacture [`Schedule`](crate::model::Schedule)
    pub fn builder() -> crate::model::schedule::Builder {
        crate::model::schedule::Builder::default()
    }
}

/// <p>Represents one or more actions to be performed on a DataBrew dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recipe {
    /// <p>The Amazon Resource Name (ARN) of the user who created the recipe.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the recipe was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the recipe.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The last modification date and time of the recipe.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the project that the recipe is associated with.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user who published the recipe.</p>
    pub published_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the recipe was published.</p>
    pub published_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique name for the recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the recipe.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of steps that are defined by the recipe.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
    /// <p>Metadata tags that have been applied to the recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The identifier for the version for the recipe. Must be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand
    /// for major and minor version numbers. The maximum length of each is 6 digits, and
    /// neither can be negative values. Both <code>X</code> and <code>Y</code> are
    /// required, and "0.0" isn't a valid version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATEST_WORKING</code> - the most recent valid version being developed in
    /// a DataBrew project.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATEST_PUBLISHED</code> - the most recent published version.</p>
    /// </li>
    /// </ul>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Recipe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recipe");
        formatter.field("created_by", &self.created_by);
        formatter.field("create_date", &self.create_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("project_name", &self.project_name);
        formatter.field("published_by", &self.published_by);
        formatter.field("published_date", &self.published_date);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("steps", &self.steps);
        formatter.field("tags", &self.tags);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}
/// See [`Recipe`](crate::model::Recipe)
pub mod recipe {
    /// A builder for [`Recipe`](crate::model::Recipe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) published_by: std::option::Option<std::string::String>,
        pub(crate) published_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user who created the recipe.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the recipe.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the recipe was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the recipe was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the recipe.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the recipe.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The last modification date and time of the recipe.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The last modification date and time of the recipe.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The name of the project that the recipe is associated with.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that the recipe is associated with.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who published the recipe.</p>
        pub fn published_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.published_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who published the recipe.</p>
        pub fn set_published_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.published_by = input;
            self
        }
        /// <p>The date and time when the recipe was published.</p>
        pub fn published_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.published_date = Some(input);
            self
        }
        /// <p>The date and time when the recipe was published.</p>
        pub fn set_published_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.published_date = input;
            self
        }
        /// <p>The description of the recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique name for the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name for the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recipe.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recipe.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>A list of steps that are defined by the recipe.</p>
        pub fn steps(mut self, input: impl Into<crate::model::RecipeStep>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>A list of steps that are defined by the recipe.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipeStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags that have been applied to the recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags that have been applied to the recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The identifier for the version for the recipe. Must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand
        /// for major and minor version numbers. The maximum length of each is 6 digits, and
        /// neither can be negative values. Both <code>X</code> and <code>Y</code> are
        /// required, and "0.0" isn't a valid version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST_WORKING</code> - the most recent valid version being developed in
        /// a DataBrew project.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST_PUBLISHED</code> - the most recent published version.</p>
        /// </li>
        /// </ul>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The identifier for the version for the recipe. Must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand
        /// for major and minor version numbers. The maximum length of each is 6 digits, and
        /// neither can be negative values. Both <code>X</code> and <code>Y</code> are
        /// required, and "0.0" isn't a valid version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST_WORKING</code> - the most recent valid version being developed in
        /// a DataBrew project.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST_PUBLISHED</code> - the most recent published version.</p>
        /// </li>
        /// </ul>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Recipe`](crate::model::Recipe)
        pub fn build(self) -> crate::model::Recipe {
            crate::model::Recipe {
                created_by: self.created_by,
                create_date: self.create_date,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                project_name: self.project_name,
                published_by: self.published_by,
                published_date: self.published_date,
                description: self.description,
                name: self.name,
                resource_arn: self.resource_arn,
                steps: self.steps,
                tags: self.tags,
                recipe_version: self.recipe_version,
            }
        }
    }
}
impl Recipe {
    /// Creates a new builder-style object to manufacture [`Recipe`](crate::model::Recipe)
    pub fn builder() -> crate::model::recipe::Builder {
        crate::model::recipe::Builder::default()
    }
}

/// <p>Represents all of the attributes of a DataBrew project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Project {
    /// <p>The ID of the Amazon Web Services account that owns the project.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the project was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the user who crated the project.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The dataset that the project is to act upon.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The last modification date and time for the project.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the project.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The unique name of a project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of a recipe that will be developed during a project session.</p>
    pub recipe_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the project.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The sample size and sampling type to apply to the data. If this parameter isn't
    /// specified, then the sample consists of the first 500 rows from the dataset.</p>
    pub sample: std::option::Option<crate::model::Sample>,
    /// <p>Metadata tags that have been applied to the project.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the role that will be assumed for this
    /// project.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user that opened the project for use.</p>
    pub opened_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the project was opened.</p>
    pub open_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Project {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Project");
        formatter.field("account_id", &self.account_id);
        formatter.field("create_date", &self.create_date);
        formatter.field("created_by", &self.created_by);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("name", &self.name);
        formatter.field("recipe_name", &self.recipe_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("sample", &self.sample);
        formatter.field("tags", &self.tags);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("opened_by", &self.opened_by);
        formatter.field("open_date", &self.open_date);
        formatter.finish()
    }
}
/// See [`Project`](crate::model::Project)
pub mod project {
    /// A builder for [`Project`](crate::model::Project)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) sample: std::option::Option<crate::model::Sample>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) opened_by: std::option::Option<std::string::String>,
        pub(crate) open_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that owns the project.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the project.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The date and time that the project was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the project was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who crated the project.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who crated the project.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The dataset that the project is to act upon.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The dataset that the project is to act upon.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The last modification date and time for the project.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The last modification date and time for the project.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the project.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The unique name of a project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of a project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of a recipe that will be developed during a project session.</p>
        pub fn recipe_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_name = Some(input.into());
            self
        }
        /// <p>The name of a recipe that will be developed during a project session.</p>
        pub fn set_recipe_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the project.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the project.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The sample size and sampling type to apply to the data. If this parameter isn't
        /// specified, then the sample consists of the first 500 rows from the dataset.</p>
        pub fn sample(mut self, input: crate::model::Sample) -> Self {
            self.sample = Some(input);
            self
        }
        /// <p>The sample size and sampling type to apply to the data. If this parameter isn't
        /// specified, then the sample consists of the first 500 rows from the dataset.</p>
        pub fn set_sample(mut self, input: std::option::Option<crate::model::Sample>) -> Self {
            self.sample = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags that have been applied to the project.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags that have been applied to the project.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that will be assumed for this
        /// project.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that will be assumed for this
        /// project.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user that opened the project for use.</p>
        pub fn opened_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.opened_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user that opened the project for use.</p>
        pub fn set_opened_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opened_by = input;
            self
        }
        /// <p>The date and time when the project was opened.</p>
        pub fn open_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.open_date = Some(input);
            self
        }
        /// <p>The date and time when the project was opened.</p>
        pub fn set_open_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.open_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Project`](crate::model::Project)
        pub fn build(self) -> crate::model::Project {
            crate::model::Project {
                account_id: self.account_id,
                create_date: self.create_date,
                created_by: self.created_by,
                dataset_name: self.dataset_name,
                last_modified_date: self.last_modified_date,
                last_modified_by: self.last_modified_by,
                name: self.name,
                recipe_name: self.recipe_name,
                resource_arn: self.resource_arn,
                sample: self.sample,
                tags: self.tags,
                role_arn: self.role_arn,
                opened_by: self.opened_by,
                open_date: self.open_date,
            }
        }
    }
}
impl Project {
    /// Creates a new builder-style object to manufacture [`Project`](crate::model::Project)
    pub fn builder() -> crate::model::project::Builder {
        crate::model::project::Builder::default()
    }
}

/// <p>Represents all of the attributes of a DataBrew job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The ID of the Amazon Web Services account that owns the job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user who created the job.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the job was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A dataset that the job is to process.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job
    /// output. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/encryption-security-configuration.html">Encrypting data
    /// written by DataBrew jobs</a>
    /// </p>
    pub encryption_key_arn: std::option::Option<std::string::String>,
    /// <p>The encryption mode for the job, which can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionMode>,
    /// <p>The unique name of the job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The job type of the job, which must be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROFILE</code> - A job to analyze a dataset, to determine its size, data
    /// types, data distribution, and more.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RECIPE</code> - A job to apply one or more transformations to a
    /// dataset.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::JobType>,
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the job.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The modification date and time of the job.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of Amazon CloudWatch logging for the job.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The maximum number of nodes that can be consumed when the job processes data.</p>
    pub max_capacity: i32,
    /// <p>The maximum number of times to retry the job after a job run fails.</p>
    pub max_retries: i32,
    /// <p>One or more artifacts that represent output from running the job.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>One or more artifacts that represent the Glue Data Catalog output
    /// from running the job.</p>
    pub data_catalog_outputs: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
    /// <p>Represents a list of JDBC database output objects which defines the output
    /// destination for a DataBrew recipe job to write into.</p>
    pub database_outputs: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
    /// <p>The name of the project that the job is associated with.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>A set of steps that the job runs.</p>
    pub recipe_reference: std::option::Option<crate::model::RecipeReference>,
    /// <p>The unique Amazon Resource Name (ARN) for the job.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role to be assumed for this job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
    /// period ends with a status of <code>TIMEOUT</code>.</p>
    pub timeout: i32,
    /// <p>Metadata tags that have been applied to the job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
    /// profile job is run. If a <code>JobSample</code> value isn't provided, the default value
    /// is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the
    /// size parameter.</p>
    pub job_sample: std::option::Option<crate::model::JobSample>,
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("account_id", &self.account_id);
        formatter.field("created_by", &self.created_by);
        formatter.field("create_date", &self.create_date);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("encryption_key_arn", &self.encryption_key_arn);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("outputs", &self.outputs);
        formatter.field("data_catalog_outputs", &self.data_catalog_outputs);
        formatter.field("database_outputs", &self.database_outputs);
        formatter.field("project_name", &self.project_name);
        formatter.field("recipe_reference", &self.recipe_reference);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("timeout", &self.timeout);
        formatter.field("tags", &self.tags);
        formatter.field("job_sample", &self.job_sample);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) encryption_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionMode>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::JobType>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) data_catalog_outputs:
            std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        pub(crate) database_outputs:
            std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) recipe_reference: std::option::Option<crate::model::RecipeReference>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) job_sample: std::option::Option<crate::model::JobSample>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that owns the job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the job.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the job.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the job was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the job was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>A dataset that the job is to process.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>A dataset that the job is to process.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job
        /// output. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/encryption-security-configuration.html">Encrypting data
        /// written by DataBrew jobs</a>
        /// </p>
        pub fn encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an encryption key that is used to protect the job
        /// output. For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/encryption-security-configuration.html">Encrypting data
        /// written by DataBrew jobs</a>
        /// </p>
        pub fn set_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key_arn = input;
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionMode) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode for the job, which can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSE-KMS</code> - Server-side encryption with keys managed by KMS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionMode>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>The unique name of the job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The job type of the job, which must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROFILE</code> - A job to analyze a dataset, to determine its size, data
        /// types, data distribution, and more.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RECIPE</code> - A job to apply one or more transformations to a
        /// dataset.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::JobType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The job type of the job, which must be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROFILE</code> - A job to analyze a dataset, to determine its size, data
        /// types, data distribution, and more.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RECIPE</code> - A job to apply one or more transformations to a
        /// dataset.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the job.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the job.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The modification date and time of the job.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The modification date and time of the job.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The current status of Amazon CloudWatch logging for the job.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>The current status of Amazon CloudWatch logging for the job.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The maximum number of nodes that can be consumed when the job processes data.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum number of nodes that can be consumed when the job processes data.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry the job after a job run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more artifacts that represent output from running the job.</p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent output from running the job.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `data_catalog_outputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output
        /// from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            input: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            let mut v = self.data_catalog_outputs.unwrap_or_default();
            v.push(input.into());
            self.data_catalog_outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output
        /// from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.data_catalog_outputs = input;
            self
        }
        /// Appends an item to `database_outputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, input: impl Into<crate::model::DatabaseOutput>) -> Self {
            let mut v = self.database_outputs.unwrap_or_default();
            v.push(input.into());
            self.database_outputs = Some(v);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.database_outputs = input;
            self
        }
        /// <p>The name of the project that the job is associated with.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that the job is associated with.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>A set of steps that the job runs.</p>
        pub fn recipe_reference(mut self, input: crate::model::RecipeReference) -> Self {
            self.recipe_reference = Some(input);
            self
        }
        /// <p>A set of steps that the job runs.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.recipe_reference = input;
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) for the job.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) for the job.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed for this job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to be assumed for this job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job's timeout in minutes. A job that attempts to run longer than this timeout
        /// period ends with a status of <code>TIMEOUT</code>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags that have been applied to the job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags that have been applied to the job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
        /// profile job is run. If a <code>JobSample</code> value isn't provided, the default value
        /// is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the
        /// size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.job_sample = Some(input);
            self
        }
        /// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
        /// profile job is run. If a <code>JobSample</code> value isn't provided, the default value
        /// is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the
        /// size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.job_sample = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                account_id: self.account_id,
                created_by: self.created_by,
                create_date: self.create_date,
                dataset_name: self.dataset_name,
                encryption_key_arn: self.encryption_key_arn,
                encryption_mode: self.encryption_mode,
                name: self.name,
                r#type: self.r#type,
                last_modified_by: self.last_modified_by,
                last_modified_date: self.last_modified_date,
                log_subscription: self.log_subscription,
                max_capacity: self.max_capacity.unwrap_or_default(),
                max_retries: self.max_retries.unwrap_or_default(),
                outputs: self.outputs,
                data_catalog_outputs: self.data_catalog_outputs,
                database_outputs: self.database_outputs,
                project_name: self.project_name,
                recipe_reference: self.recipe_reference,
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
                timeout: self.timeout.unwrap_or_default(),
                tags: self.tags,
                job_sample: self.job_sample,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>Represents the name and version of a DataBrew recipe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipeReference {
    /// <p>The name of the recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier for the version for the recipe. </p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecipeReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipeReference");
        formatter.field("name", &self.name);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}
/// See [`RecipeReference`](crate::model::RecipeReference)
pub mod recipe_reference {
    /// A builder for [`RecipeReference`](crate::model::RecipeReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier for the version for the recipe. </p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The identifier for the version for the recipe. </p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipeReference`](crate::model::RecipeReference)
        pub fn build(self) -> crate::model::RecipeReference {
            crate::model::RecipeReference {
                name: self.name,
                recipe_version: self.recipe_version,
            }
        }
    }
}
impl RecipeReference {
    /// Creates a new builder-style object to manufacture [`RecipeReference`](crate::model::RecipeReference)
    pub fn builder() -> crate::model::recipe_reference::Builder {
        crate::model::recipe_reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    Profile,
    #[allow(missing_docs)] // documentation missing in model
    Recipe,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "PROFILE" => JobType::Profile,
            "RECIPE" => JobType::Recipe,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::Profile => "PROFILE",
            JobType::Recipe => "RECIPE",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROFILE", "RECIPE"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents one run of a DataBrew job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobRun {
    /// <p>The number of times that DataBrew has attempted to run the job.</p>
    pub attempt: i32,
    /// <p>The date and time when the job completed processing.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the dataset for the job to process.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, during which a job run consumed resources.</p>
    pub execution_time: i32,
    /// <p>The name of the job being processed during this run.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the job run.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The current state of the job run entity itself.</p>
    pub state: std::option::Option<crate::model::JobRunState>,
    /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
    pub log_subscription: std::option::Option<crate::model::LogSubscription>,
    /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
    /// when it runs.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>One or more output artifacts from a job run.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>One or more artifacts that represent the Glue Data Catalog output
    /// from running the job.</p>
    pub data_catalog_outputs: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
    /// <p>Represents a list of JDBC database output objects which defines the output
    /// destination for a DataBrew recipe job to write into.</p>
    pub database_outputs: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
    /// <p>The set of steps processed by the job.</p>
    pub recipe_reference: std::option::Option<crate::model::RecipeReference>,
    /// <p>The Amazon Resource Name (ARN) of the user who initiated the job run. </p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The date and time when the job run began. </p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
    /// profile job is run. If a <code>JobSample</code> value isn't provided, the default
    /// is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the
    /// size parameter.</p>
    pub job_sample: std::option::Option<crate::model::JobSample>,
}
impl std::fmt::Debug for JobRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobRun");
        formatter.field("attempt", &self.attempt);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("error_message", &self.error_message);
        formatter.field("execution_time", &self.execution_time);
        formatter.field("job_name", &self.job_name);
        formatter.field("run_id", &self.run_id);
        formatter.field("state", &self.state);
        formatter.field("log_subscription", &self.log_subscription);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("outputs", &self.outputs);
        formatter.field("data_catalog_outputs", &self.data_catalog_outputs);
        formatter.field("database_outputs", &self.database_outputs);
        formatter.field("recipe_reference", &self.recipe_reference);
        formatter.field("started_by", &self.started_by);
        formatter.field("started_on", &self.started_on);
        formatter.field("job_sample", &self.job_sample);
        formatter.finish()
    }
}
/// See [`JobRun`](crate::model::JobRun)
pub mod job_run {
    /// A builder for [`JobRun`](crate::model::JobRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attempt: std::option::Option<i32>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) execution_time: std::option::Option<i32>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::JobRunState>,
        pub(crate) log_subscription: std::option::Option<crate::model::LogSubscription>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) data_catalog_outputs:
            std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        pub(crate) database_outputs:
            std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        pub(crate) recipe_reference: std::option::Option<crate::model::RecipeReference>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_sample: std::option::Option<crate::model::JobSample>,
    }
    impl Builder {
        /// <p>The number of times that DataBrew has attempted to run the job.</p>
        pub fn attempt(mut self, input: i32) -> Self {
            self.attempt = Some(input);
            self
        }
        /// <p>The number of times that DataBrew has attempted to run the job.</p>
        pub fn set_attempt(mut self, input: std::option::Option<i32>) -> Self {
            self.attempt = input;
            self
        }
        /// <p>The date and time when the job completed processing.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time when the job completed processing.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The name of the dataset for the job to process.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset for the job to process.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message indicating an error (if any) that was encountered when the job ran.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The amount of time, in seconds, during which a job run consumed resources.</p>
        pub fn execution_time(mut self, input: i32) -> Self {
            self.execution_time = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, during which a job run consumed resources.</p>
        pub fn set_execution_time(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_time = input;
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job being processed during this run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The current state of the job run entity itself.</p>
        pub fn state(mut self, input: crate::model::JobRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the job run entity itself.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::JobRunState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
        pub fn log_subscription(mut self, input: crate::model::LogSubscription) -> Self {
            self.log_subscription = Some(input);
            self
        }
        /// <p>The current status of Amazon CloudWatch logging for the job run.</p>
        pub fn set_log_subscription(
            mut self,
            input: std::option::Option<crate::model::LogSubscription>,
        ) -> Self {
            self.log_subscription = input;
            self
        }
        /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
        /// when it runs.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon CloudWatch log group, where the job writes diagnostic messages
        /// when it runs.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>One or more output artifacts from a job run.</p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>One or more output artifacts from a job run.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `data_catalog_outputs`.
        ///
        /// To override the contents of this collection use [`set_data_catalog_outputs`](Self::set_data_catalog_outputs).
        ///
        /// <p>One or more artifacts that represent the Glue Data Catalog output
        /// from running the job.</p>
        pub fn data_catalog_outputs(
            mut self,
            input: impl Into<crate::model::DataCatalogOutput>,
        ) -> Self {
            let mut v = self.data_catalog_outputs.unwrap_or_default();
            v.push(input.into());
            self.data_catalog_outputs = Some(v);
            self
        }
        /// <p>One or more artifacts that represent the Glue Data Catalog output
        /// from running the job.</p>
        pub fn set_data_catalog_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataCatalogOutput>>,
        ) -> Self {
            self.data_catalog_outputs = input;
            self
        }
        /// Appends an item to `database_outputs`.
        ///
        /// To override the contents of this collection use [`set_database_outputs`](Self::set_database_outputs).
        ///
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn database_outputs(mut self, input: impl Into<crate::model::DatabaseOutput>) -> Self {
            let mut v = self.database_outputs.unwrap_or_default();
            v.push(input.into());
            self.database_outputs = Some(v);
            self
        }
        /// <p>Represents a list of JDBC database output objects which defines the output
        /// destination for a DataBrew recipe job to write into.</p>
        pub fn set_database_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatabaseOutput>>,
        ) -> Self {
            self.database_outputs = input;
            self
        }
        /// <p>The set of steps processed by the job.</p>
        pub fn recipe_reference(mut self, input: crate::model::RecipeReference) -> Self {
            self.recipe_reference = Some(input);
            self
        }
        /// <p>The set of steps processed by the job.</p>
        pub fn set_recipe_reference(
            mut self,
            input: std::option::Option<crate::model::RecipeReference>,
        ) -> Self {
            self.recipe_reference = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who initiated the job run. </p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who initiated the job run. </p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// <p>The date and time when the job run began. </p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time when the job run began. </p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
        /// profile job is run. If a <code>JobSample</code> value isn't provided, the default
        /// is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the
        /// size parameter.</p>
        pub fn job_sample(mut self, input: crate::model::JobSample) -> Self {
            self.job_sample = Some(input);
            self
        }
        /// <p>A sample configuration for profile jobs only, which determines the number of rows on which the
        /// profile job is run. If a <code>JobSample</code> value isn't provided, the default
        /// is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the
        /// size parameter.</p>
        pub fn set_job_sample(
            mut self,
            input: std::option::Option<crate::model::JobSample>,
        ) -> Self {
            self.job_sample = input;
            self
        }
        /// Consumes the builder and constructs a [`JobRun`](crate::model::JobRun)
        pub fn build(self) -> crate::model::JobRun {
            crate::model::JobRun {
                attempt: self.attempt.unwrap_or_default(),
                completed_on: self.completed_on,
                dataset_name: self.dataset_name,
                error_message: self.error_message,
                execution_time: self.execution_time.unwrap_or_default(),
                job_name: self.job_name,
                run_id: self.run_id,
                state: self.state,
                log_subscription: self.log_subscription,
                log_group_name: self.log_group_name,
                outputs: self.outputs,
                data_catalog_outputs: self.data_catalog_outputs,
                database_outputs: self.database_outputs,
                recipe_reference: self.recipe_reference,
                started_by: self.started_by,
                started_on: self.started_on,
                job_sample: self.job_sample,
            }
        }
    }
}
impl JobRun {
    /// Creates a new builder-style object to manufacture [`JobRun`](crate::model::JobRun)
    pub fn builder() -> crate::model::job_run::Builder {
        crate::model::job_run::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobRunState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobRunState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => JobRunState::Failed,
            "RUNNING" => JobRunState::Running,
            "STARTING" => JobRunState::Starting,
            "STOPPED" => JobRunState::Stopped,
            "STOPPING" => JobRunState::Stopping,
            "SUCCEEDED" => JobRunState::Succeeded,
            "TIMEOUT" => JobRunState::Timeout,
            other => JobRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobRunState::from(s))
    }
}
impl JobRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobRunState::Failed => "FAILED",
            JobRunState::Running => "RUNNING",
            JobRunState::Starting => "STARTING",
            JobRunState::Stopped => "STOPPED",
            JobRunState::Stopping => "STOPPING",
            JobRunState::Succeeded => "SUCCEEDED",
            JobRunState::Timeout => "TIMEOUT",
            JobRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "RUNNING",
            "STARTING",
            "STOPPED",
            "STOPPING",
            "SUCCEEDED",
            "TIMEOUT",
        ]
    }
}
impl AsRef<str> for JobRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a dataset that can be processed by DataBrew.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dataset {
    /// <p>The ID of the Amazon Web Services account that owns the dataset.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user who created the dataset.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time that the dataset was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The unique name of the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
    pub format: std::option::Option<crate::model::InputFormat>,
    /// <p>A set of options that define how DataBrew interprets the data in the dataset.</p>
    pub format_options: std::option::Option<crate::model::FormatOptions>,
    /// <p>Information on how DataBrew can find the dataset, in either the Glue Data Catalog
    /// or Amazon S3.</p>
    pub input: std::option::Option<crate::model::Input>,
    /// <p>The last modification date and time of the dataset.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the user who last modified the dataset.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The location of the data for the dataset, either Amazon S3 or the Glue Data Catalog.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
    pub path_options: std::option::Option<crate::model::PathOptions>,
    /// <p>Metadata tags that have been applied to the dataset.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The unique Amazon Resource Name (ARN) for the dataset.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Dataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dataset");
        formatter.field("account_id", &self.account_id);
        formatter.field("created_by", &self.created_by);
        formatter.field("create_date", &self.create_date);
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("format_options", &self.format_options);
        formatter.field("input", &self.input);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("source", &self.source);
        formatter.field("path_options", &self.path_options);
        formatter.field("tags", &self.tags);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`Dataset`](crate::model::Dataset)
pub mod dataset {
    /// A builder for [`Dataset`](crate::model::Dataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::InputFormat>,
        pub(crate) format_options: std::option::Option<crate::model::FormatOptions>,
        pub(crate) input: std::option::Option<crate::model::Input>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) path_options: std::option::Option<crate::model::PathOptions>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that owns the dataset.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the dataset.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the dataset.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the dataset.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time that the dataset was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the dataset was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The unique name of the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn format(mut self, input: crate::model::InputFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The file format of a dataset that is created from an Amazon S3 file or folder.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::InputFormat>) -> Self {
            self.format = input;
            self
        }
        /// <p>A set of options that define how DataBrew interprets the data in the dataset.</p>
        pub fn format_options(mut self, input: crate::model::FormatOptions) -> Self {
            self.format_options = Some(input);
            self
        }
        /// <p>A set of options that define how DataBrew interprets the data in the dataset.</p>
        pub fn set_format_options(
            mut self,
            input: std::option::Option<crate::model::FormatOptions>,
        ) -> Self {
            self.format_options = input;
            self
        }
        /// <p>Information on how DataBrew can find the dataset, in either the Glue Data Catalog
        /// or Amazon S3.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>Information on how DataBrew can find the dataset, in either the Glue Data Catalog
        /// or Amazon S3.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// <p>The last modification date and time of the dataset.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The last modification date and time of the dataset.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the dataset.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who last modified the dataset.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The location of the data for the dataset, either Amazon S3 or the Glue Data Catalog.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The location of the data for the dataset, either Amazon S3 or the Glue Data Catalog.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn path_options(mut self, input: crate::model::PathOptions) -> Self {
            self.path_options = Some(input);
            self
        }
        /// <p>A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset.</p>
        pub fn set_path_options(
            mut self,
            input: std::option::Option<crate::model::PathOptions>,
        ) -> Self {
            self.path_options = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata tags that have been applied to the dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata tags that have been applied to the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) for the dataset.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) for the dataset.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Dataset`](crate::model::Dataset)
        pub fn build(self) -> crate::model::Dataset {
            crate::model::Dataset {
                account_id: self.account_id,
                created_by: self.created_by,
                create_date: self.create_date,
                name: self.name,
                format: self.format,
                format_options: self.format_options,
                input: self.input,
                last_modified_date: self.last_modified_date,
                last_modified_by: self.last_modified_by,
                source: self.source,
                path_options: self.path_options,
                tags: self.tags,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl Dataset {
    /// Creates a new builder-style object to manufacture [`Dataset`](crate::model::Dataset)
    pub fn builder() -> crate::model::dataset::Builder {
        crate::model::dataset::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Source {
    #[allow(missing_docs)] // documentation missing in model
    Datacatalog,
    #[allow(missing_docs)] // documentation missing in model
    Database,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Source {
    fn from(s: &str) -> Self {
        match s {
            "DATA-CATALOG" => Source::Datacatalog,
            "DATABASE" => Source::Database,
            "S3" => Source::S3,
            other => Source::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Source {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Source::from(s))
    }
}
impl Source {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Source::Datacatalog => "DATA-CATALOG",
            Source::Database => "DATABASE",
            Source::S3 => "S3",
            Source::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATA-CATALOG", "DATABASE", "S3"]
    }
}
impl AsRef<str> for Source {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SessionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Assigned,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initializing,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Recycling,
    #[allow(missing_docs)] // documentation missing in model
    Rotating,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SessionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ASSIGNED" => SessionStatus::Assigned,
            "FAILED" => SessionStatus::Failed,
            "INITIALIZING" => SessionStatus::Initializing,
            "PROVISIONING" => SessionStatus::Provisioning,
            "READY" => SessionStatus::Ready,
            "RECYCLING" => SessionStatus::Recycling,
            "ROTATING" => SessionStatus::Rotating,
            "TERMINATED" => SessionStatus::Terminated,
            "TERMINATING" => SessionStatus::Terminating,
            "UPDATING" => SessionStatus::Updating,
            other => SessionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SessionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SessionStatus::from(s))
    }
}
impl SessionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SessionStatus::Assigned => "ASSIGNED",
            SessionStatus::Failed => "FAILED",
            SessionStatus::Initializing => "INITIALIZING",
            SessionStatus::Provisioning => "PROVISIONING",
            SessionStatus::Ready => "READY",
            SessionStatus::Recycling => "RECYCLING",
            SessionStatus::Rotating => "ROTATING",
            SessionStatus::Terminated => "TERMINATED",
            SessionStatus::Terminating => "TERMINATING",
            SessionStatus::Updating => "UPDATING",
            SessionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSIGNED",
            "FAILED",
            "INITIALIZING",
            "PROVISIONING",
            "READY",
            "RECYCLING",
            "ROTATING",
            "TERMINATED",
            "TERMINATING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for SessionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents any errors encountered when attempting to delete multiple recipe
/// versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipeVersionErrorDetail {
    /// <p>The HTTP status code for the error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The text of the error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The identifier for the recipe version associated with this error.</p>
    pub recipe_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecipeVersionErrorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipeVersionErrorDetail");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("recipe_version", &self.recipe_version);
        formatter.finish()
    }
}
/// See [`RecipeVersionErrorDetail`](crate::model::RecipeVersionErrorDetail)
pub mod recipe_version_error_detail {
    /// A builder for [`RecipeVersionErrorDetail`](crate::model::RecipeVersionErrorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) recipe_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status code for the error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code for the error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The text of the error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The text of the error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The identifier for the recipe version associated with this error.</p>
        pub fn recipe_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_version = Some(input.into());
            self
        }
        /// <p>The identifier for the recipe version associated with this error.</p>
        pub fn set_recipe_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipe_version = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipeVersionErrorDetail`](crate::model::RecipeVersionErrorDetail)
        pub fn build(self) -> crate::model::RecipeVersionErrorDetail {
            crate::model::RecipeVersionErrorDetail {
                error_code: self.error_code,
                error_message: self.error_message,
                recipe_version: self.recipe_version,
            }
        }
    }
}
impl RecipeVersionErrorDetail {
    /// Creates a new builder-style object to manufacture [`RecipeVersionErrorDetail`](crate::model::RecipeVersionErrorDetail)
    pub fn builder() -> crate::model::recipe_version_error_detail::Builder {
        crate::model::recipe_version_error_detail::Builder::default()
    }
}
