// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Database Migration Service
///
/// Client for invoking operations on AWS Database Migration Service. Each operation on AWS Database Migration Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_databasemigration::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_databasemigration::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_databasemigration::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_arn): <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>  <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>One or more tags to be assigned to the resource.</p>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)

    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action applies to.</p>
    ///   - [`apply_action(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::apply_action) / [`set_apply_action(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_apply_action): <p>The pending maintenance action to apply to this resource.</p>  <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code> </p>
    ///   - [`opt_in_type(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::opt_in_type) / [`set_opt_in_type(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_opt_in_type): <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an opt-in request of type <code>immediate</code>.</p>  <p>Valid values:</p>  <ul>   <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>   <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>   <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>  </ul>
    /// - On success, responds with [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput) with field(s):
    ///   - [`resource_pending_maintenance_actions(Option<ResourcePendingMaintenanceActions>)`](crate::output::ApplyPendingMaintenanceActionOutput::resource_pending_maintenance_actions): <p>The DMS resource that the pending maintenance action will be applied to.</p>
    /// - On failure, responds with [`SdkError<ApplyPendingMaintenanceActionError>`](crate::error::ApplyPendingMaintenanceActionError)
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelReplicationTaskAssessmentRun`](crate::client::fluent_builders::CancelReplicationTaskAssessmentRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::CancelReplicationTaskAssessmentRun::replication_task_assessment_run_arn) / [`set_replication_task_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::CancelReplicationTaskAssessmentRun::set_replication_task_assessment_run_arn): <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
    /// - On success, responds with [`CancelReplicationTaskAssessmentRunOutput`](crate::output::CancelReplicationTaskAssessmentRunOutput) with field(s):
    ///   - [`replication_task_assessment_run(Option<ReplicationTaskAssessmentRun>)`](crate::output::CancelReplicationTaskAssessmentRunOutput::replication_task_assessment_run): <p>The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.</p>
    /// - On failure, responds with [`SdkError<CancelReplicationTaskAssessmentRunError>`](crate::error::CancelReplicationTaskAssessmentRunError)
    pub fn cancel_replication_task_assessment_run(
        &self,
    ) -> fluent_builders::CancelReplicationTaskAssessmentRun {
        fluent_builders::CancelReplicationTaskAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEndpoint`](crate::client::fluent_builders::CreateEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::endpoint_identifier) / [`set_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_endpoint_identifier): <p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.</p>
    ///   - [`endpoint_type(ReplicationEndpointTypeValue)`](crate::client::fluent_builders::CreateEndpoint::endpoint_type) / [`set_endpoint_type(Option<ReplicationEndpointTypeValue>)`](crate::client::fluent_builders::CreateEndpoint::set_endpoint_type): <p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>
    ///   - [`engine_name(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::engine_name) / [`set_engine_name(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_engine_name): <p>The type of engine for the endpoint. Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_username): <p>The user name to be used to log in to the endpoint database.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_password): <p>The password to be used to log in to the endpoint database.</p>
    ///   - [`server_name(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::server_name) / [`set_server_name(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_server_name): <p>The name of the server where the endpoint database resides.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateEndpoint::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateEndpoint::set_port): <p>The port used by the endpoint database.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_database_name): <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
    ///   - [`extra_connection_attributes(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::extra_connection_attributes) / [`set_extra_connection_attributes(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_extra_connection_attributes): <p>Additional attributes associated with the connection. Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with DMS Endpoints</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_kms_key_id): <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>  <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p>  <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEndpoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEndpoint::set_tags): <p>One or more tags to be assigned to the endpoint.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_certificate_arn): <p>The Amazon Resource Name (ARN) for the certificate.</p>
    ///   - [`ssl_mode(DmsSslModeValue)`](crate::client::fluent_builders::CreateEndpoint::ssl_mode) / [`set_ssl_mode(Option<DmsSslModeValue>)`](crate::client::fluent_builders::CreateEndpoint::set_ssl_mode): <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> </p>
    ///   - [`service_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::service_access_role_arn) / [`set_service_access_role_arn(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_service_access_role_arn): <p> The Amazon Resource Name (ARN) for the service access role that you want to use to create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
    ///   - [`external_table_definition(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::external_table_definition) / [`set_external_table_definition(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_external_table_definition): <p>The external table definition. </p>
    ///   - [`dynamo_db_settings(DynamoDbSettings)`](crate::client::fluent_builders::CreateEndpoint::dynamo_db_settings) / [`set_dynamo_db_settings(Option<DynamoDbSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_dynamo_db_settings): <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`s3_settings(S3Settings)`](crate::client::fluent_builders::CreateEndpoint::s3_settings) / [`set_s3_settings(Option<S3Settings>)`](crate::client::fluent_builders::CreateEndpoint::set_s3_settings): <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`dms_transfer_settings(DmsTransferSettings)`](crate::client::fluent_builders::CreateEndpoint::dms_transfer_settings) / [`set_dms_transfer_settings(Option<DmsTransferSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_dms_transfer_settings): <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>  <p>Possible settings include the following:</p>  <ul>   <li> <p> <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p> </li>   <li> <p> <code>BucketName</code> - The name of the S3 bucket to use.</p> </li>  </ul>  <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string,BucketName=string</code> </p>  <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", } </code> </p>
    ///   - [`mongo_db_settings(MongoDbSettings)`](crate::client::fluent_builders::CreateEndpoint::mongo_db_settings) / [`set_mongo_db_settings(Option<MongoDbSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_mongo_db_settings): <p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`kinesis_settings(KinesisSettings)`](crate::client::fluent_builders::CreateEndpoint::kinesis_settings) / [`set_kinesis_settings(Option<KinesisSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_kinesis_settings): <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`kafka_settings(KafkaSettings)`](crate::client::fluent_builders::CreateEndpoint::kafka_settings) / [`set_kafka_settings(Option<KafkaSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_kafka_settings): <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`elasticsearch_settings(ElasticsearchSettings)`](crate::client::fluent_builders::CreateEndpoint::elasticsearch_settings) / [`set_elasticsearch_settings(Option<ElasticsearchSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_elasticsearch_settings): <p>Settings in JSON format for the target OpenSearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS</a> in the <i>Database Migration Service User Guide</i>.</p>
    ///   - [`neptune_settings(NeptuneSettings)`](crate::client::fluent_builders::CreateEndpoint::neptune_settings) / [`set_neptune_settings(Option<NeptuneSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_neptune_settings): <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`redshift_settings(RedshiftSettings)`](crate::client::fluent_builders::CreateEndpoint::redshift_settings) / [`set_redshift_settings(Option<RedshiftSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_redshift_settings): <p>Provides information that defines an Amazon Redshift endpoint.</p>
    ///   - [`postgre_sql_settings(PostgreSqlSettings)`](crate::client::fluent_builders::CreateEndpoint::postgre_sql_settings) / [`set_postgre_sql_settings(Option<PostgreSqlSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_postgre_sql_settings): <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`my_sql_settings(MySqlSettings)`](crate::client::fluent_builders::CreateEndpoint::my_sql_settings) / [`set_my_sql_settings(Option<MySqlSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_my_sql_settings): <p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`oracle_settings(OracleSettings)`](crate::client::fluent_builders::CreateEndpoint::oracle_settings) / [`set_oracle_settings(Option<OracleSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_oracle_settings): <p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`sybase_settings(SybaseSettings)`](crate::client::fluent_builders::CreateEndpoint::sybase_settings) / [`set_sybase_settings(Option<SybaseSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_sybase_settings): <p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`microsoft_sql_server_settings(MicrosoftSqlServerSettings)`](crate::client::fluent_builders::CreateEndpoint::microsoft_sql_server_settings) / [`set_microsoft_sql_server_settings(Option<MicrosoftSqlServerSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_microsoft_sql_server_settings): <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`ibm_db2_settings(IbmDb2Settings)`](crate::client::fluent_builders::CreateEndpoint::ibm_db2_settings) / [`set_ibm_db2_settings(Option<IbmDb2Settings>)`](crate::client::fluent_builders::CreateEndpoint::set_ibm_db2_settings): <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateEndpoint::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::CreateEndpoint::set_resource_identifier): <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
    ///   - [`doc_db_settings(DocDbSettings)`](crate::client::fluent_builders::CreateEndpoint::doc_db_settings) / [`set_doc_db_settings(Option<DocDbSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_doc_db_settings): <p>Provides information that defines a DocumentDB endpoint.</p>
    ///   - [`redis_settings(RedisSettings)`](crate::client::fluent_builders::CreateEndpoint::redis_settings) / [`set_redis_settings(Option<RedisSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_redis_settings): <p>Settings in JSON format for the target Redis endpoint.</p>
    ///   - [`gcp_my_sql_settings(GcpMySqlSettings)`](crate::client::fluent_builders::CreateEndpoint::gcp_my_sql_settings) / [`set_gcp_my_sql_settings(Option<GcpMySqlSettings>)`](crate::client::fluent_builders::CreateEndpoint::set_gcp_my_sql_settings): <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
    /// - On success, responds with [`CreateEndpointOutput`](crate::output::CreateEndpointOutput) with field(s):
    ///   - [`endpoint(Option<Endpoint>)`](crate::output::CreateEndpointOutput::endpoint): <p>The endpoint that was created.</p>
    /// - On failure, responds with [`SdkError<CreateEndpointError>`](crate::error::CreateEndpointError)
    pub fn create_endpoint(&self) -> fluent_builders::CreateEndpoint {
        fluent_builders::CreateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_subscription_name): <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_sns_topic_arn): <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_type): <p> The type of DMS resource that generates the events. For example, if you want to be notified of events generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this value isn't specified, all events are returned. </p>  <p>Valid values: <code>replication-instance</code> | <code>replication-task</code> </p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_event_categories): <p>A list of event categories for a source type that you want to subscribe to. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`source_ids(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_ids) / [`set_source_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_ids): <p>A list of identifiers for which DMS provides notification events.</p>  <p>If you don't specify a value, notifications are provided for all sources.</p>  <p>If you specify multiple values, they must be of the same type. For example, if you specify a database instance ID, then all of the other values must be database instance IDs.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateEventSubscription::set_enabled): <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to create the subscription but not activate it. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEventSubscription::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEventSubscription::set_tags): <p>One or more tags to be assigned to the event subscription.</p>
    /// - On success, responds with [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::CreateEventSubscriptionOutput::event_subscription): <p>The event subscription that was created.</p>
    /// - On failure, responds with [`SdkError<CreateEventSubscriptionError>`](crate::error::CreateEventSubscriptionError)
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplicationInstance`](crate::client::fluent_builders::CreateReplicationInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::replication_instance_identifier) / [`set_replication_instance_identifier(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_replication_instance_identifier): <p>The replication instance identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1-63 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>myrepinstance</code> </p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::CreateReplicationInstance::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::CreateReplicationInstance::set_allocated_storage): <p>The amount of storage (in gigabytes) to be initially allocated for the replication instance.</p>
    ///   - [`replication_instance_class(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::replication_instance_class) / [`set_replication_instance_class(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_replication_instance_class): <p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>  <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateReplicationInstance::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationInstance::set_vpc_security_group_ids): <p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_availability_zone): <p>The Availability Zone where the replication instance will be created. The default value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for example: <code>us-east-1d</code> </p>
    ///   - [`replication_subnet_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::replication_subnet_group_identifier) / [`set_replication_subnet_group_identifier(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_replication_subnet_group_identifier): <p>A subnet group to associate with the replication instance.</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_preferred_maintenance_window): <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region, occurring on a random day of the week.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::CreateReplicationInstance::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::CreateReplicationInstance::set_multi_az): <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_engine_version): <p>The engine version number of the replication instance.</p>  <p>If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateReplicationInstance::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateReplicationInstance::set_auto_minor_version_upgrade): <p>A value that indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window. This parameter defaults to <code>true</code>.</p>  <p>Default: <code>true</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateReplicationInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateReplicationInstance::set_tags): <p>One or more tags to be assigned to the replication instance.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_kms_key_id): <p>An KMS key identifier that is used to encrypt the data on the replication instance.</p>  <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p>  <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateReplicationInstance::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::CreateReplicationInstance::set_publicly_accessible): <p> Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an instance with a public IP address. A value of <code>false</code> represents an instance with a private IP address. The default value is <code>true</code>. </p>
    ///   - [`dns_name_servers(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::dns_name_servers) / [`set_dns_name_servers(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_dns_name_servers): <p>A list of custom DNS name servers supported for the replication instance to access your on-premise source or target database. This list overrides the default name servers supported by the replication instance. You can specify a comma-separated list of internet addresses for up to four on-premise DNS name servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code> </p>
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationInstance::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::CreateReplicationInstance::set_resource_identifier): <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
    /// - On success, responds with [`CreateReplicationInstanceOutput`](crate::output::CreateReplicationInstanceOutput) with field(s):
    ///   - [`replication_instance(Option<ReplicationInstance>)`](crate::output::CreateReplicationInstanceOutput::replication_instance): <p>The replication instance that was created.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationInstanceError>`](crate::error::CreateReplicationInstanceError)
    pub fn create_replication_instance(&self) -> fluent_builders::CreateReplicationInstance {
        fluent_builders::CreateReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplicationSubnetGroup`](crate::client::fluent_builders::CreateReplicationSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_subnet_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::replication_subnet_group_identifier) / [`set_replication_subnet_group_identifier(Option<String>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::set_replication_subnet_group_identifier): <p>The name for the replication subnet group. This value is stored as a lowercase string.</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens. Must not be "default".</p>  <p>Example: <code>mySubnetgroup</code> </p>
    ///   - [`replication_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::replication_subnet_group_description) / [`set_replication_subnet_group_description(Option<String>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::set_replication_subnet_group_description): <p>The description for the subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::set_subnet_ids): <p>One or more subnet IDs to be assigned to the subnet group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateReplicationSubnetGroup::set_tags): <p>One or more tags to be assigned to the subnet group.</p>
    /// - On success, responds with [`CreateReplicationSubnetGroupOutput`](crate::output::CreateReplicationSubnetGroupOutput) with field(s):
    ///   - [`replication_subnet_group(Option<ReplicationSubnetGroup>)`](crate::output::CreateReplicationSubnetGroupOutput::replication_subnet_group): <p>The replication subnet group that was created.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationSubnetGroupError>`](crate::error::CreateReplicationSubnetGroupError)
    pub fn create_replication_subnet_group(&self) -> fluent_builders::CreateReplicationSubnetGroup {
        fluent_builders::CreateReplicationSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplicationTask`](crate::client::fluent_builders::CreateReplicationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::replication_task_identifier) / [`set_replication_task_identifier(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_replication_task_identifier): <p>An identifier for the replication task.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`source_endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::source_endpoint_arn) / [`set_source_endpoint_arn(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_source_endpoint_arn): <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
    ///   - [`target_endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::target_endpoint_arn) / [`set_target_endpoint_arn(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_target_endpoint_arn): <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of a replication instance.</p>
    ///   - [`migration_type(MigrationTypeValue)`](crate::client::fluent_builders::CreateReplicationTask::migration_type) / [`set_migration_type(Option<MigrationTypeValue>)`](crate::client::fluent_builders::CreateReplicationTask::set_migration_type): <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>
    ///   - [`table_mappings(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::table_mappings) / [`set_table_mappings(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_table_mappings): <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`replication_task_settings(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::replication_task_settings) / [`set_replication_task_settings(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_replication_task_settings): <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`cdc_start_time(DateTime)`](crate::client::fluent_builders::CreateReplicationTask::cdc_start_time) / [`set_cdc_start_time(Option<DateTime>)`](crate::client::fluent_builders::CreateReplicationTask::set_cdc_start_time): <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>  <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
    ///   - [`cdc_start_position(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::cdc_start_position) / [`set_cdc_start_position(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_cdc_start_position): <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>  <p> The value can be in date, checkpoint, or LSN/SCN format.</p>  <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>  <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>  <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>   <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>  </note>
    ///   - [`cdc_stop_position(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::cdc_stop_position) / [`set_cdc_stop_position(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_cdc_stop_position): <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>  <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>  <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateReplicationTask::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateReplicationTask::set_tags): <p>One or more tags to be assigned to the replication task.</p>
    ///   - [`task_data(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::task_data) / [`set_task_data(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_task_data): <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationTask::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::CreateReplicationTask::set_resource_identifier): <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
    /// - On success, responds with [`CreateReplicationTaskOutput`](crate::output::CreateReplicationTaskOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::CreateReplicationTaskOutput::replication_task): <p>The replication task that was created.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationTaskError>`](crate::error::CreateReplicationTaskError)
    pub fn create_replication_task(&self) -> fluent_builders::CreateReplicationTask {
        fluent_builders::CreateReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCertificate`](crate::client::fluent_builders::DeleteCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCertificate::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::DeleteCertificate::set_certificate_arn): <p>The Amazon Resource Name (ARN) of the certificate.</p>
    /// - On success, responds with [`DeleteCertificateOutput`](crate::output::DeleteCertificateOutput) with field(s):
    ///   - [`certificate(Option<Certificate>)`](crate::output::DeleteCertificateOutput::certificate): <p>The Secure Sockets Layer (SSL) certificate.</p>
    /// - On failure, responds with [`SdkError<DeleteCertificateError>`](crate::error::DeleteCertificateError)
    pub fn delete_certificate(&self) -> fluent_builders::DeleteCertificate {
        fluent_builders::DeleteCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteConnection::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DeleteConnection::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteConnection::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteConnection::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    /// - On success, responds with [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput) with field(s):
    ///   - [`connection(Option<Connection>)`](crate::output::DeleteConnectionOutput::connection): <p>The connection that is being deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteConnectionError>`](crate::error::DeleteConnectionError)
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteEndpoint::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DeleteEndpoint::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    /// - On success, responds with [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput) with field(s):
    ///   - [`endpoint(Option<Endpoint>)`](crate::output::DeleteEndpointOutput::endpoint): <p>The endpoint that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteEndpointError>`](crate::error::DeleteEndpointError)
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DeleteEventSubscription::set_subscription_name): <p>The name of the DMS event notification subscription to be deleted.</p>
    /// - On success, responds with [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::DeleteEventSubscriptionOutput::event_subscription): <p>The event subscription that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteEventSubscriptionError>`](crate::error::DeleteEventSubscriptionError)
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationInstance`](crate::client::fluent_builders::DeleteReplicationInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationInstance::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::DeleteReplicationInstance::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
    /// - On success, responds with [`DeleteReplicationInstanceOutput`](crate::output::DeleteReplicationInstanceOutput) with field(s):
    ///   - [`replication_instance(Option<ReplicationInstance>)`](crate::output::DeleteReplicationInstanceOutput::replication_instance): <p>The replication instance that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteReplicationInstanceError>`](crate::error::DeleteReplicationInstanceError)
    pub fn delete_replication_instance(&self) -> fluent_builders::DeleteReplicationInstance {
        fluent_builders::DeleteReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationSubnetGroup`](crate::client::fluent_builders::DeleteReplicationSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_subnet_group_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationSubnetGroup::replication_subnet_group_identifier) / [`set_replication_subnet_group_identifier(Option<String>)`](crate::client::fluent_builders::DeleteReplicationSubnetGroup::set_replication_subnet_group_identifier): <p>The subnet group name of the replication instance.</p>
    /// - On success, responds with [`DeleteReplicationSubnetGroupOutput`](crate::output::DeleteReplicationSubnetGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteReplicationSubnetGroupError>`](crate::error::DeleteReplicationSubnetGroupError)
    pub fn delete_replication_subnet_group(&self) -> fluent_builders::DeleteReplicationSubnetGroup {
        fluent_builders::DeleteReplicationSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationTask`](crate::client::fluent_builders::DeleteReplicationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationTask::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::DeleteReplicationTask::set_replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
    /// - On success, responds with [`DeleteReplicationTaskOutput`](crate::output::DeleteReplicationTaskOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::DeleteReplicationTaskOutput::replication_task): <p>The deleted replication task.</p>
    /// - On failure, responds with [`SdkError<DeleteReplicationTaskError>`](crate::error::DeleteReplicationTaskError)
    pub fn delete_replication_task(&self) -> fluent_builders::DeleteReplicationTask {
        fluent_builders::DeleteReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationTaskAssessmentRun`](crate::client::fluent_builders::DeleteReplicationTaskAssessmentRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationTaskAssessmentRun::replication_task_assessment_run_arn) / [`set_replication_task_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::DeleteReplicationTaskAssessmentRun::set_replication_task_assessment_run_arn): <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
    /// - On success, responds with [`DeleteReplicationTaskAssessmentRunOutput`](crate::output::DeleteReplicationTaskAssessmentRunOutput) with field(s):
    ///   - [`replication_task_assessment_run(Option<ReplicationTaskAssessmentRun>)`](crate::output::DeleteReplicationTaskAssessmentRunOutput::replication_task_assessment_run): <p>The <code>ReplicationTaskAssessmentRun</code> object for the deleted assessment run.</p>
    /// - On failure, responds with [`SdkError<DeleteReplicationTaskAssessmentRunError>`](crate::error::DeleteReplicationTaskAssessmentRunError)
    pub fn delete_replication_task_assessment_run(
        &self,
    ) -> fluent_builders::DeleteReplicationTaskAssessmentRun {
        fluent_builders::DeleteReplicationTaskAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAccountAttributes::send) it.

    /// - On success, responds with [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput) with field(s):
    ///   - [`account_quotas(Option<Vec<AccountQuota>>)`](crate::output::DescribeAccountAttributesOutput::account_quotas): <p>Account quota information.</p>
    ///   - [`unique_account_identifier(Option<String>)`](crate::output::DescribeAccountAttributesOutput::unique_account_identifier): <p>A unique DMS identifier for an account in a particular Amazon Web Services Region. The value of this identifier has the following format: <code>c99999999999</code>. DMS uses this identifier to name artifacts. For example, DMS uses this identifier to name the default Amazon S3 bucket for storing task assessment reports in a given Amazon Web Services Region. The format of this S3 bucket name is the following: <code>dms-<i>AccountNumber</i>-<i>UniqueAccountIdentifier</i>.</code> Here is an example name for this default S3 bucket: <code>dms-111122223333-c44445555666</code>.</p> <note>   <p>DMS supports the <code>UniqueAccountIdentifier</code> parameter in versions 3.1.4 and later.</p>  </note>
    /// - On failure, responds with [`SdkError<DescribeAccountAttributesError>`](crate::error::DescribeAccountAttributesError)
    pub fn describe_account_attributes(&self) -> fluent_builders::DescribeAccountAttributes {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplicableIndividualAssessments`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_replication_task_arn): <p>Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual assessments.</p>
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_replication_instance_arn): <p>ARN of a replication instance on which you want to base the default list of individual assessments.</p>
    ///   - [`source_engine_name(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::source_engine_name) / [`set_source_engine_name(Option<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_source_engine_name): <p>Name of a database engine that the specified replication instance supports as a source.</p>
    ///   - [`target_engine_name(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::target_engine_name) / [`set_target_engine_name(Option<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_target_engine_name): <p>Name of a database engine that the specified replication instance supports as a target.</p>
    ///   - [`migration_type(MigrationTypeValue)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::migration_type) / [`set_migration_type(Option<MigrationTypeValue>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_migration_type): <p>Name of the migration type that each provided individual assessment must support.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_max_records): <p>Maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments::set_marker): <p>Optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeApplicableIndividualAssessmentsOutput`](crate::output::DescribeApplicableIndividualAssessmentsOutput) with field(s):
    ///   - [`individual_assessment_names(Option<Vec<String>>)`](crate::output::DescribeApplicableIndividualAssessmentsOutput::individual_assessment_names): <p>List of names for the individual assessments supported by the premigration assessment run that you start based on the specified request parameters. For more information on the available individual assessments, including compatibility with different migration task configurations, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeApplicableIndividualAssessmentsOutput::marker): <p>Pagination token returned for you to pass to a subsequent request. If you pass this token as the <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to the value specified in the request by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicableIndividualAssessmentsError>`](crate::error::DescribeApplicableIndividualAssessmentsError)
    pub fn describe_applicable_individual_assessments(
        &self,
    ) -> fluent_builders::DescribeApplicableIndividualAssessments {
        fluent_builders::DescribeApplicableIndividualAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCertificates`](crate::client::fluent_builders::DescribeCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCertificates::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCertificates::set_filters): <p>Filters applied to the certificates described in the form of key-value pairs. Valid values are <code>certificate-arn</code> and <code>certificate-id</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCertificates::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCertificates::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 10</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCertificates::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeCertificatesOutput`](crate::output::DescribeCertificatesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCertificatesOutput::marker): <p>The pagination token.</p>
    ///   - [`certificates(Option<Vec<Certificate>>)`](crate::output::DescribeCertificatesOutput::certificates): <p>The Secure Sockets Layer (SSL) certificates associated with the replication instance.</p>
    /// - On failure, responds with [`SdkError<DescribeCertificatesError>`](crate::error::DescribeCertificatesError)
    pub fn describe_certificates(&self) -> fluent_builders::DescribeCertificates {
        fluent_builders::DescribeCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConnections`](crate::client::fluent_builders::DescribeConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeConnections::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeConnections::set_filters): <p>The filters applied to the connection.</p>  <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeConnections::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeConnections::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeConnections::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeConnections::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeConnectionsOutput`](crate::output::DescribeConnectionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeConnectionsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::DescribeConnectionsOutput::connections): <p>A description of the connections.</p>
    /// - On failure, responds with [`SdkError<DescribeConnectionsError>`](crate::error::DescribeConnectionsError)
    pub fn describe_connections(&self) -> fluent_builders::DescribeConnections {
        fluent_builders::DescribeConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpoints`](crate::client::fluent_builders::DescribeEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEndpoints::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEndpoints::set_filters): <p>Filters applied to the endpoints.</p>  <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEndpoints::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEndpoints::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpoints::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEndpoints::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEndpointsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`endpoints(Option<Vec<Endpoint>>)`](crate::output::DescribeEndpointsOutput::endpoints): <p>Endpoint description.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointsError>`](crate::error::DescribeEndpointsError)
    pub fn describe_endpoints(&self) -> fluent_builders::DescribeEndpoints {
        fluent_builders::DescribeEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpointSettings`](crate::client::fluent_builders::DescribeEndpointSettings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEndpointSettings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointSettings::engine_name) / [`set_engine_name(Option<String>)`](crate::client::fluent_builders::DescribeEndpointSettings::set_engine_name): <p>The databse engine used for your source or target endpoint.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEndpointSettings::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEndpointSettings::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointSettings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEndpointSettings::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEndpointSettingsOutput`](crate::output::DescribeEndpointSettingsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEndpointSettingsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`endpoint_settings(Option<Vec<EndpointSetting>>)`](crate::output::DescribeEndpointSettingsOutput::endpoint_settings): <p>Descriptions of the endpoint settings available for your source or target database engine.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointSettingsError>`](crate::error::DescribeEndpointSettingsError)
    pub fn describe_endpoint_settings(&self) -> fluent_builders::DescribeEndpointSettings {
        fluent_builders::DescribeEndpointSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpointTypes`](crate::client::fluent_builders::DescribeEndpointTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEndpointTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEndpointTypes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEndpointTypes::set_filters): <p>Filters applied to the endpoint types.</p>  <p>Valid filter names: engine-name | endpoint-type</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEndpointTypes::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEndpointTypes::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointTypes::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEndpointTypes::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeEndpointTypesOutput`](crate::output::DescribeEndpointTypesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEndpointTypesOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`supported_endpoint_types(Option<Vec<SupportedEndpointType>>)`](crate::output::DescribeEndpointTypesOutput::supported_endpoint_types): <p>The types of endpoints that are supported.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointTypesError>`](crate::error::DescribeEndpointTypesError)
    pub fn describe_endpoint_types(&self) -> fluent_builders::DescribeEndpointTypes {
        fluent_builders::DescribeEndpointTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::DescribeEventCategories::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::DescribeEventCategories::set_source_type): <p> The type of DMS resource that generates events. </p>  <p>Valid values: replication-instance | replication-task</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEventCategories::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEventCategories::set_filters): <p>Filters applied to the event categories.</p>
    /// - On success, responds with [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput) with field(s):
    ///   - [`event_category_group_list(Option<Vec<EventCategoryGroup>>)`](crate::output::DescribeEventCategoriesOutput::event_category_group_list): <p>A list of event categories.</p>
    /// - On failure, responds with [`SdkError<DescribeEventCategoriesError>`](crate::error::DescribeEventCategoriesError)
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_source_identifier): <p> The identifier of an event source.</p>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::DescribeEvents::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::DescribeEvents::set_source_type): <p>The type of DMS resource that generates events.</p>  <p>Valid values: replication-instance | replication-task</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p>The start time for the events to be listed.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p>The end time for the events to be listed.</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::DescribeEvents::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_duration): <p>The duration of the events to be listed.</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::DescribeEvents::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEvents::set_event_categories): <p>A list of event categories for the source type that you've chosen.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEvents::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEvents::set_filters): <p>Filters applied to events. The only valid filter is <code>replication-instance-id</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEvents::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p>The events described.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventSubscriptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_subscription_name): <p>The name of the DMS event subscription to be described.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEventSubscriptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_filters): <p>Filters applied to event subscriptions.</p>  <p>Valid filter names: event-subscription-arn | event-subscription-id </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEventSubscriptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventSubscriptionsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`event_subscriptions_list(Option<Vec<EventSubscription>>)`](crate::output::DescribeEventSubscriptionsOutput::event_subscriptions_list): <p>A list of event subscriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeEventSubscriptionsError>`](crate::error::DescribeEventSubscriptionsError)
    pub fn describe_event_subscriptions(&self) -> fluent_builders::DescribeEventSubscriptions {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrderableReplicationInstances`](crate::client::fluent_builders::DescribeOrderableReplicationInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOrderableReplicationInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeOrderableReplicationInstances::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeOrderableReplicationInstances::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableReplicationInstances::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeOrderableReplicationInstances::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeOrderableReplicationInstancesOutput`](crate::output::DescribeOrderableReplicationInstancesOutput) with field(s):
    ///   - [`orderable_replication_instances(Option<Vec<OrderableReplicationInstance>>)`](crate::output::DescribeOrderableReplicationInstancesOutput::orderable_replication_instances): <p>The order-able replication instances available.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeOrderableReplicationInstancesOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeOrderableReplicationInstancesError>`](crate::error::DescribeOrderableReplicationInstancesError)
    pub fn describe_orderable_replication_instances(
        &self,
    ) -> fluent_builders::DescribeOrderableReplicationInstances {
        fluent_builders::DescribeOrderableReplicationInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePendingMaintenanceActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_filters): <p></p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput) with field(s):
    ///   - [`pending_maintenance_actions(Option<Vec<ResourcePendingMaintenanceActions>>)`](crate::output::DescribePendingMaintenanceActionsOutput::pending_maintenance_actions): <p>The pending maintenance action.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribePendingMaintenanceActionsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On failure, responds with [`SdkError<DescribePendingMaintenanceActionsError>`](crate::error::DescribePendingMaintenanceActionsError)
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRefreshSchemasStatus`](crate::client::fluent_builders::DescribeRefreshSchemasStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeRefreshSchemasStatus::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DescribeRefreshSchemasStatus::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    /// - On success, responds with [`DescribeRefreshSchemasStatusOutput`](crate::output::DescribeRefreshSchemasStatusOutput) with field(s):
    ///   - [`refresh_schemas_status(Option<RefreshSchemasStatus>)`](crate::output::DescribeRefreshSchemasStatusOutput::refresh_schemas_status): <p>The status of the schema.</p>
    /// - On failure, responds with [`SdkError<DescribeRefreshSchemasStatusError>`](crate::error::DescribeRefreshSchemasStatusError)
    pub fn describe_refresh_schemas_status(&self) -> fluent_builders::DescribeRefreshSchemasStatus {
        fluent_builders::DescribeRefreshSchemasStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationInstances`](crate::client::fluent_builders::DescribeReplicationInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReplicationInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReplicationInstances::set_filters): <p>Filters applied to replication instances.</p>  <p>Valid filter names: replication-instance-arn | replication-instance-id | replication-instance-class | engine-version</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationInstances::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationInstances::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationInstances::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationInstances::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeReplicationInstancesOutput`](crate::output::DescribeReplicationInstancesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationInstancesOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`replication_instances(Option<Vec<ReplicationInstance>>)`](crate::output::DescribeReplicationInstancesOutput::replication_instances): <p>The replication instances described.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationInstancesError>`](crate::error::DescribeReplicationInstancesError)
    pub fn describe_replication_instances(&self) -> fluent_builders::DescribeReplicationInstances {
        fluent_builders::DescribeReplicationInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationInstanceTaskLogs`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReplicationInstanceTaskLogsOutput`](crate::output::DescribeReplicationInstanceTaskLogsOutput) with field(s):
    ///   - [`replication_instance_arn(Option<String>)`](crate::output::DescribeReplicationInstanceTaskLogsOutput::replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    ///   - [`replication_instance_task_logs(Option<Vec<ReplicationInstanceTaskLog>>)`](crate::output::DescribeReplicationInstanceTaskLogsOutput::replication_instance_task_logs): <p>An array of replication task log metadata. Each member of the array contains the replication task name, ARN, and task log size (in bytes). </p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationInstanceTaskLogsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationInstanceTaskLogsError>`](crate::error::DescribeReplicationInstanceTaskLogsError)
    pub fn describe_replication_instance_task_logs(
        &self,
    ) -> fluent_builders::DescribeReplicationInstanceTaskLogs {
        fluent_builders::DescribeReplicationInstanceTaskLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationSubnetGroups`](crate::client::fluent_builders::DescribeReplicationSubnetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::set_filters): <p>Filters applied to replication subnet groups.</p>  <p>Valid filter names: replication-subnet-group-id</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationSubnetGroups::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeReplicationSubnetGroupsOutput`](crate::output::DescribeReplicationSubnetGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationSubnetGroupsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`replication_subnet_groups(Option<Vec<ReplicationSubnetGroup>>)`](crate::output::DescribeReplicationSubnetGroupsOutput::replication_subnet_groups): <p>A description of the replication subnet groups.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationSubnetGroupsError>`](crate::error::DescribeReplicationSubnetGroupsError)
    pub fn describe_replication_subnet_groups(
        &self,
    ) -> fluent_builders::DescribeReplicationSubnetGroups {
        fluent_builders::DescribeReplicationSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationTaskAssessmentResults`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::set_replication_task_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input parameter is specified, the API returns only one result and ignore the values of the <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeReplicationTaskAssessmentResultsOutput`](crate::output::DescribeReplicationTaskAssessmentResultsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationTaskAssessmentResultsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`bucket_name(Option<String>)`](crate::output::DescribeReplicationTaskAssessmentResultsOutput::bucket_name): <p>- The Amazon S3 bucket where the task assessment report is located. </p>
    ///   - [`replication_task_assessment_results(Option<Vec<ReplicationTaskAssessmentResult>>)`](crate::output::DescribeReplicationTaskAssessmentResultsOutput::replication_task_assessment_results): <p> The task assessment report. </p>
    /// - On failure, responds with [`SdkError<DescribeReplicationTaskAssessmentResultsError>`](crate::error::DescribeReplicationTaskAssessmentResultsError)
    pub fn describe_replication_task_assessment_results(
        &self,
    ) -> fluent_builders::DescribeReplicationTaskAssessmentResults {
        fluent_builders::DescribeReplicationTaskAssessmentResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationTaskAssessmentRuns`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::set_filters): <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>  <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>replication-instance-arn</code>, <code>status</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReplicationTaskAssessmentRunsOutput`](crate::output::DescribeReplicationTaskAssessmentRunsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationTaskAssessmentRunsOutput::marker): <p>A pagination token returned for you to pass to a subsequent request. If you pass this token as the <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to the value specified in the request by <code>MaxRecords</code>.</p>
    ///   - [`replication_task_assessment_runs(Option<Vec<ReplicationTaskAssessmentRun>>)`](crate::output::DescribeReplicationTaskAssessmentRunsOutput::replication_task_assessment_runs): <p>One or more premigration assessment runs as specified by <code>Filters</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationTaskAssessmentRunsError>`](crate::error::DescribeReplicationTaskAssessmentRunsError)
    pub fn describe_replication_task_assessment_runs(
        &self,
    ) -> fluent_builders::DescribeReplicationTaskAssessmentRuns {
        fluent_builders::DescribeReplicationTaskAssessmentRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationTaskIndividualAssessments`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::set_filters): <p>Filters applied to the individual assessments described in the form of key-value pairs.</p>  <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>status</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReplicationTaskIndividualAssessmentsOutput`](crate::output::DescribeReplicationTaskIndividualAssessmentsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationTaskIndividualAssessmentsOutput::marker): <p>A pagination token returned for you to pass to a subsequent request. If you pass this token as the <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to the value specified in the request by <code>MaxRecords</code>.</p>
    ///   - [`replication_task_individual_assessments(Option<Vec<ReplicationTaskIndividualAssessment>>)`](crate::output::DescribeReplicationTaskIndividualAssessmentsOutput::replication_task_individual_assessments): <p>One or more individual assessments as specified by <code>Filters</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationTaskIndividualAssessmentsError>`](crate::error::DescribeReplicationTaskIndividualAssessmentsError)
    pub fn describe_replication_task_individual_assessments(
        &self,
    ) -> fluent_builders::DescribeReplicationTaskIndividualAssessments {
        fluent_builders::DescribeReplicationTaskIndividualAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationTasks`](crate::client::fluent_builders::DescribeReplicationTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReplicationTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReplicationTasks::set_filters): <p>Filters applied to replication tasks.</p>  <p>Valid filter names: replication-task-arn | replication-task-id | migration-type | endpoint-arn | replication-instance-arn</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationTasks::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationTasks::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationTasks::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationTasks::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`without_settings(bool)`](crate::client::fluent_builders::DescribeReplicationTasks::without_settings) / [`set_without_settings(Option<bool>)`](crate::client::fluent_builders::DescribeReplicationTasks::set_without_settings): <p>An option to set to avoid returning information about settings. Use this to reduce overhead when setting information is too large. To use this option, choose <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
    /// - On success, responds with [`DescribeReplicationTasksOutput`](crate::output::DescribeReplicationTasksOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationTasksOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`replication_tasks(Option<Vec<ReplicationTask>>)`](crate::output::DescribeReplicationTasksOutput::replication_tasks): <p>A description of the replication tasks.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationTasksError>`](crate::error::DescribeReplicationTasksError)
    pub fn describe_replication_tasks(&self) -> fluent_builders::DescribeReplicationTasks {
        fluent_builders::DescribeReplicationTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSchemas`](crate::client::fluent_builders::DescribeSchemas) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSchemas::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeSchemas::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::DescribeSchemas::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeSchemas::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeSchemas::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeSchemas::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeSchemas::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On success, responds with [`DescribeSchemasOutput`](crate::output::DescribeSchemasOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeSchemasOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`schemas(Option<Vec<String>>)`](crate::output::DescribeSchemasOutput::schemas): <p>The described schema.</p>
    /// - On failure, responds with [`SdkError<DescribeSchemasError>`](crate::error::DescribeSchemasError)
    pub fn describe_schemas(&self) -> fluent_builders::DescribeSchemas {
        fluent_builders::DescribeSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTableStatistics`](crate::client::fluent_builders::DescribeTableStatistics) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTableStatistics::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTableStatistics::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::DescribeTableStatistics::set_replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeTableStatistics::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeTableStatistics::set_max_records): <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 500.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTableStatistics::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTableStatistics::set_marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTableStatistics::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTableStatistics::set_filters): <p>Filters applied to table statistics.</p>  <p>Valid filter names: schema-name | table-name | table-state</p>  <p>A combination of filters creates an AND condition where each record matches all specified filters.</p>
    /// - On success, responds with [`DescribeTableStatisticsOutput`](crate::output::DescribeTableStatisticsOutput) with field(s):
    ///   - [`replication_task_arn(Option<String>)`](crate::output::DescribeTableStatisticsOutput::replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task.</p>
    ///   - [`table_statistics(Option<Vec<TableStatistics>>)`](crate::output::DescribeTableStatisticsOutput::table_statistics): <p>The table statistics.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeTableStatisticsOutput::marker): <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeTableStatisticsError>`](crate::error::DescribeTableStatisticsError)
    pub fn describe_table_statistics(&self) -> fluent_builders::DescribeTableStatistics {
        fluent_builders::DescribeTableStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportCertificate`](crate::client::fluent_builders::ImportCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::ImportCertificate::certificate_identifier) / [`set_certificate_identifier(Option<String>)`](crate::client::fluent_builders::ImportCertificate::set_certificate_identifier): <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.</p>
    ///   - [`certificate_pem(impl Into<String>)`](crate::client::fluent_builders::ImportCertificate::certificate_pem) / [`set_certificate_pem(Option<String>)`](crate::client::fluent_builders::ImportCertificate::set_certificate_pem): <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
    ///   - [`certificate_wallet(Blob)`](crate::client::fluent_builders::ImportCertificate::certificate_wallet) / [`set_certificate_wallet(Option<Blob>)`](crate::client::fluent_builders::ImportCertificate::set_certificate_wallet): <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file using the <code>fileb://</code> prefix. You can't provide the certificate inline.</p>  <p>Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ImportCertificate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ImportCertificate::set_tags): <p>The tags associated with the certificate.</p>
    /// - On success, responds with [`ImportCertificateOutput`](crate::output::ImportCertificateOutput) with field(s):
    ///   - [`certificate(Option<Certificate>)`](crate::output::ImportCertificateOutput::certificate): <p>The certificate to be uploaded.</p>
    /// - On failure, responds with [`SdkError<ImportCertificateError>`](crate::error::ImportCertificateError)
    pub fn import_certificate(&self) -> fluent_builders::ImportCertificate {
        fluent_builders::ImportCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This returns a list of keys (names of tags) created for the resource and their associated tag values.</p>
    ///   - [`resource_arn_list(Vec<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn_list) / [`set_resource_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn_list): <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys (tag names) and their associated tag values. It also returns each tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>A list of tags for the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyEndpoint`](crate::client::fluent_builders::ModifyEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    ///   - [`endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::endpoint_identifier) / [`set_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_endpoint_identifier): <p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.</p>
    ///   - [`endpoint_type(ReplicationEndpointTypeValue)`](crate::client::fluent_builders::ModifyEndpoint::endpoint_type) / [`set_endpoint_type(Option<ReplicationEndpointTypeValue>)`](crate::client::fluent_builders::ModifyEndpoint::set_endpoint_type): <p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>
    ///   - [`engine_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::engine_name) / [`set_engine_name(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_engine_name): <p>The type of engine for the endpoint. Valid values, depending on the EndpointType, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_username): <p>The user name to be used to login to the endpoint database.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_password): <p>The password to be used to login to the endpoint database.</p>
    ///   - [`server_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::server_name) / [`set_server_name(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_server_name): <p>The name of the server where the endpoint database resides.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::ModifyEndpoint::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::ModifyEndpoint::set_port): <p>The port used by the endpoint database.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_database_name): <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
    ///   - [`extra_connection_attributes(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::extra_connection_attributes) / [`set_extra_connection_attributes(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_extra_connection_attributes): <p>Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as an argument.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_certificate_arn): <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
    ///   - [`ssl_mode(DmsSslModeValue)`](crate::client::fluent_builders::ModifyEndpoint::ssl_mode) / [`set_ssl_mode(Option<DmsSslModeValue>)`](crate::client::fluent_builders::ModifyEndpoint::set_ssl_mode): <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
    ///   - [`service_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::service_access_role_arn) / [`set_service_access_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_service_access_role_arn): <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
    ///   - [`external_table_definition(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpoint::external_table_definition) / [`set_external_table_definition(Option<String>)`](crate::client::fluent_builders::ModifyEndpoint::set_external_table_definition): <p>The external table definition.</p>
    ///   - [`dynamo_db_settings(DynamoDbSettings)`](crate::client::fluent_builders::ModifyEndpoint::dynamo_db_settings) / [`set_dynamo_db_settings(Option<DynamoDbSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_dynamo_db_settings): <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`s3_settings(S3Settings)`](crate::client::fluent_builders::ModifyEndpoint::s3_settings) / [`set_s3_settings(Option<S3Settings>)`](crate::client::fluent_builders::ModifyEndpoint::set_s3_settings): <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`dms_transfer_settings(DmsTransferSettings)`](crate::client::fluent_builders::ModifyEndpoint::dms_transfer_settings) / [`set_dms_transfer_settings(Option<DmsTransferSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_dms_transfer_settings): <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>  <p>Attributes include the following:</p>  <ul>   <li> <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p> </li>   <li> <p>BucketName - The name of the S3 bucket to use.</p> </li>  </ul>  <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string ,BucketName=string</code> </p>  <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string"} </code> </p>
    ///   - [`mongo_db_settings(MongoDbSettings)`](crate::client::fluent_builders::ModifyEndpoint::mongo_db_settings) / [`set_mongo_db_settings(Option<MongoDbSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_mongo_db_settings): <p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`kinesis_settings(KinesisSettings)`](crate::client::fluent_builders::ModifyEndpoint::kinesis_settings) / [`set_kinesis_settings(Option<KinesisSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_kinesis_settings): <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`kafka_settings(KafkaSettings)`](crate::client::fluent_builders::ModifyEndpoint::kafka_settings) / [`set_kafka_settings(Option<KafkaSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_kafka_settings): <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`elasticsearch_settings(ElasticsearchSettings)`](crate::client::fluent_builders::ModifyEndpoint::elasticsearch_settings) / [`set_elasticsearch_settings(Option<ElasticsearchSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_elasticsearch_settings): <p>Settings in JSON format for the target OpenSearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`neptune_settings(NeptuneSettings)`](crate::client::fluent_builders::ModifyEndpoint::neptune_settings) / [`set_neptune_settings(Option<NeptuneSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_neptune_settings): <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`redshift_settings(RedshiftSettings)`](crate::client::fluent_builders::ModifyEndpoint::redshift_settings) / [`set_redshift_settings(Option<RedshiftSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_redshift_settings): <p>Provides information that defines an Amazon Redshift endpoint.</p>
    ///   - [`postgre_sql_settings(PostgreSqlSettings)`](crate::client::fluent_builders::ModifyEndpoint::postgre_sql_settings) / [`set_postgre_sql_settings(Option<PostgreSqlSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_postgre_sql_settings): <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`my_sql_settings(MySqlSettings)`](crate::client::fluent_builders::ModifyEndpoint::my_sql_settings) / [`set_my_sql_settings(Option<MySqlSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_my_sql_settings): <p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`oracle_settings(OracleSettings)`](crate::client::fluent_builders::ModifyEndpoint::oracle_settings) / [`set_oracle_settings(Option<OracleSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_oracle_settings): <p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`sybase_settings(SybaseSettings)`](crate::client::fluent_builders::ModifyEndpoint::sybase_settings) / [`set_sybase_settings(Option<SybaseSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_sybase_settings): <p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`microsoft_sql_server_settings(MicrosoftSqlServerSettings)`](crate::client::fluent_builders::ModifyEndpoint::microsoft_sql_server_settings) / [`set_microsoft_sql_server_settings(Option<MicrosoftSqlServerSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_microsoft_sql_server_settings): <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`ibm_db2_settings(IbmDb2Settings)`](crate::client::fluent_builders::ModifyEndpoint::ibm_db2_settings) / [`set_ibm_db2_settings(Option<IbmDb2Settings>)`](crate::client::fluent_builders::ModifyEndpoint::set_ibm_db2_settings): <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`doc_db_settings(DocDbSettings)`](crate::client::fluent_builders::ModifyEndpoint::doc_db_settings) / [`set_doc_db_settings(Option<DocDbSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_doc_db_settings): <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service </a> in the <i>Database Migration Service User Guide.</i> </p>
    ///   - [`redis_settings(RedisSettings)`](crate::client::fluent_builders::ModifyEndpoint::redis_settings) / [`set_redis_settings(Option<RedisSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_redis_settings): <p>Settings in JSON format for the Redis target endpoint.</p>
    ///   - [`exact_settings(bool)`](crate::client::fluent_builders::ModifyEndpoint::exact_settings) / [`set_exact_settings(Option<bool>)`](crate::client::fluent_builders::ModifyEndpoint::set_exact_settings): <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all existing endpoint settings with the exact settings that you specify in this call. If this attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>  <ul>   <li> <p>It replaces any endpoint settings that already exist with new values, for settings with the same names.</p> </li>   <li> <p>It creates new endpoint settings that you specify in the call, for settings with different names. </p> </li>  </ul>  <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}' ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>  <p>However, suppose that you follow this with a call to <code>modify-endpoint ... --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again. Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings are replaced with the exact settings that you specify. </p>
    ///   - [`gcp_my_sql_settings(GcpMySqlSettings)`](crate::client::fluent_builders::ModifyEndpoint::gcp_my_sql_settings) / [`set_gcp_my_sql_settings(Option<GcpMySqlSettings>)`](crate::client::fluent_builders::ModifyEndpoint::set_gcp_my_sql_settings): <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
    /// - On success, responds with [`ModifyEndpointOutput`](crate::output::ModifyEndpointOutput) with field(s):
    ///   - [`endpoint(Option<Endpoint>)`](crate::output::ModifyEndpointOutput::endpoint): <p>The modified endpoint.</p>
    /// - On failure, responds with [`SdkError<ModifyEndpointError>`](crate::error::ModifyEndpointError)
    pub fn modify_endpoint(&self) -> fluent_builders::ModifyEndpoint {
        fluent_builders::ModifyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_subscription_name): <p>The name of the DMS event notification subscription to be modified.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_sns_topic_arn): <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_source_type): <p> The type of DMS resource that generates the events you want to subscribe to. </p>  <p>Valid values: replication-instance | replication-task</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::ModifyEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyEventSubscription::set_event_categories): <p> A list of event categories for a source type that you want to subscribe to. Use the <code>DescribeEventCategories</code> action to see a list of event categories. </p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::ModifyEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyEventSubscription::set_enabled): <p> A Boolean value; set to <b>true</b> to activate the subscription. </p>
    /// - On success, responds with [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::ModifyEventSubscriptionOutput::event_subscription): <p>The modified event subscription.</p>
    /// - On failure, responds with [`SdkError<ModifyEventSubscriptionError>`](crate::error::ModifyEventSubscriptionError)
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyReplicationInstance`](crate::client::fluent_builders::ModifyReplicationInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::ModifyReplicationInstance::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_allocated_storage): <p>The amount of storage (in gigabytes) to be allocated for the replication instance.</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyReplicationInstance::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyReplicationInstance::set_apply_immediately): <p>Indicates whether the changes should be applied immediately or during the next maintenance window.</p>
    ///   - [`replication_instance_class(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::replication_instance_class) / [`set_replication_instance_class(Option<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_replication_instance_class): <p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>  <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_vpc_security_group_ids): <p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_preferred_maintenance_window): <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter does not result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>  <p>Default: Uses existing setting</p>  <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>  <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>  <p>Constraints: Must be at least 30 minutes</p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::ModifyReplicationInstance::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_multi_az): <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_engine_version): <p>The engine version number of the replication instance.</p>  <p>When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
    ///   - [`allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyReplicationInstance::allow_major_version_upgrade) / [`set_allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyReplicationInstance::set_allow_major_version_upgrade): <p>Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the change is asynchronously applied as soon as possible.</p>  <p>This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the replication instance's current version.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::ModifyReplicationInstance::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_auto_minor_version_upgrade): <p>A value that indicates that minor version upgrades are applied automatically to the replication instance during the maintenance window. Changing this parameter doesn't result in an outage, except in the case described following. The change is asynchronously applied as soon as possible. </p>  <p>An outage does result if these factors apply: </p>  <ul>   <li> <p>This parameter is set to <code>true</code> during the maintenance window.</p> </li>   <li> <p>A newer minor version is available. </p> </li>   <li> <p>DMS has enabled automatic patching for the given engine version. </p> </li>  </ul>
    ///   - [`replication_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::replication_instance_identifier) / [`set_replication_instance_identifier(Option<String>)`](crate::client::fluent_builders::ModifyReplicationInstance::set_replication_instance_identifier): <p>The replication instance identifier. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`ModifyReplicationInstanceOutput`](crate::output::ModifyReplicationInstanceOutput) with field(s):
    ///   - [`replication_instance(Option<ReplicationInstance>)`](crate::output::ModifyReplicationInstanceOutput::replication_instance): <p>The modified replication instance.</p>
    /// - On failure, responds with [`SdkError<ModifyReplicationInstanceError>`](crate::error::ModifyReplicationInstanceError)
    pub fn modify_replication_instance(&self) -> fluent_builders::ModifyReplicationInstance {
        fluent_builders::ModifyReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyReplicationSubnetGroup`](crate::client::fluent_builders::ModifyReplicationSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_subnet_group_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationSubnetGroup::replication_subnet_group_identifier) / [`set_replication_subnet_group_identifier(Option<String>)`](crate::client::fluent_builders::ModifyReplicationSubnetGroup::set_replication_subnet_group_identifier): <p>The name of the replication instance subnet group.</p>
    ///   - [`replication_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationSubnetGroup::replication_subnet_group_description) / [`set_replication_subnet_group_description(Option<String>)`](crate::client::fluent_builders::ModifyReplicationSubnetGroup::set_replication_subnet_group_description): <p>A description for the replication instance subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationSubnetGroup::set_subnet_ids): <p>A list of subnet IDs.</p>
    /// - On success, responds with [`ModifyReplicationSubnetGroupOutput`](crate::output::ModifyReplicationSubnetGroupOutput) with field(s):
    ///   - [`replication_subnet_group(Option<ReplicationSubnetGroup>)`](crate::output::ModifyReplicationSubnetGroupOutput::replication_subnet_group): <p>The modified replication subnet group.</p>
    /// - On failure, responds with [`SdkError<ModifyReplicationSubnetGroupError>`](crate::error::ModifyReplicationSubnetGroupError)
    pub fn modify_replication_subnet_group(&self) -> fluent_builders::ModifyReplicationSubnetGroup {
        fluent_builders::ModifyReplicationSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyReplicationTask`](crate::client::fluent_builders::ModifyReplicationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task.</p>
    ///   - [`replication_task_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::replication_task_identifier) / [`set_replication_task_identifier(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_replication_task_identifier): <p>The replication task identifier.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`migration_type(MigrationTypeValue)`](crate::client::fluent_builders::ModifyReplicationTask::migration_type) / [`set_migration_type(Option<MigrationTypeValue>)`](crate::client::fluent_builders::ModifyReplicationTask::set_migration_type): <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>
    ///   - [`table_mappings(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::table_mappings) / [`set_table_mappings(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_table_mappings): <p>When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with <code>file://</code>. For example, <code>--table-mappings file://mappingfile.json</code>. When working with the DMS API, provide the JSON as the parameter value. </p>
    ///   - [`replication_task_settings(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::replication_task_settings) / [`set_replication_task_settings(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_replication_task_settings): <p>JSON file that contains settings for the task, such as task metadata settings.</p>
    ///   - [`cdc_start_time(DateTime)`](crate::client::fluent_builders::ModifyReplicationTask::cdc_start_time) / [`set_cdc_start_time(Option<DateTime>)`](crate::client::fluent_builders::ModifyReplicationTask::set_cdc_start_time): <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>  <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
    ///   - [`cdc_start_position(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::cdc_start_position) / [`set_cdc_start_position(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_cdc_start_position): <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>  <p> The value can be in date, checkpoint, or LSN/SCN format.</p>  <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>  <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>  <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>   <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>  </note>
    ///   - [`cdc_stop_position(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::cdc_stop_position) / [`set_cdc_stop_position(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_cdc_stop_position): <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>  <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>  <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    ///   - [`task_data(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationTask::task_data) / [`set_task_data(Option<String>)`](crate::client::fluent_builders::ModifyReplicationTask::set_task_data): <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
    /// - On success, responds with [`ModifyReplicationTaskOutput`](crate::output::ModifyReplicationTaskOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::ModifyReplicationTaskOutput::replication_task): <p>The replication task that was modified.</p>
    /// - On failure, responds with [`SdkError<ModifyReplicationTaskError>`](crate::error::ModifyReplicationTaskError)
    pub fn modify_replication_task(&self) -> fluent_builders::ModifyReplicationTask {
        fluent_builders::ModifyReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MoveReplicationTask`](crate::client::fluent_builders::MoveReplicationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::MoveReplicationTask::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::MoveReplicationTask::set_replication_task_arn): <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
    ///   - [`target_replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::MoveReplicationTask::target_replication_instance_arn) / [`set_target_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::MoveReplicationTask::set_target_replication_instance_arn): <p>The ARN of the replication instance where you want to move the task to.</p>
    /// - On success, responds with [`MoveReplicationTaskOutput`](crate::output::MoveReplicationTaskOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::MoveReplicationTaskOutput::replication_task): <p>The replication task that was moved.</p>
    /// - On failure, responds with [`SdkError<MoveReplicationTaskError>`](crate::error::MoveReplicationTaskError)
    pub fn move_replication_task(&self) -> fluent_builders::MoveReplicationTask {
        fluent_builders::MoveReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootReplicationInstance`](crate::client::fluent_builders::RebootReplicationInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::RebootReplicationInstance::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::RebootReplicationInstance::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    ///   - [`force_failover(bool)`](crate::client::fluent_builders::RebootReplicationInstance::force_failover) / [`set_force_failover(Option<bool>)`](crate::client::fluent_builders::RebootReplicationInstance::set_force_failover): <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. If the instance isn't configured for Multi-AZ, then you can't specify <code>true</code>. ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
    ///   - [`force_planned_failover(bool)`](crate::client::fluent_builders::RebootReplicationInstance::force_planned_failover) / [`set_force_planned_failover(Option<bool>)`](crate::client::fluent_builders::RebootReplicationInstance::set_force_planned_failover): <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover where resources are released and cleaned up prior to conducting the failover. If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>. ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
    /// - On success, responds with [`RebootReplicationInstanceOutput`](crate::output::RebootReplicationInstanceOutput) with field(s):
    ///   - [`replication_instance(Option<ReplicationInstance>)`](crate::output::RebootReplicationInstanceOutput::replication_instance): <p>The replication instance that is being rebooted. </p>
    /// - On failure, responds with [`SdkError<RebootReplicationInstanceError>`](crate::error::RebootReplicationInstanceError)
    pub fn reboot_replication_instance(&self) -> fluent_builders::RebootReplicationInstance {
        fluent_builders::RebootReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RefreshSchemas`](crate::client::fluent_builders::RefreshSchemas) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::RefreshSchemas::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::RefreshSchemas::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::RefreshSchemas::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::RefreshSchemas::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    /// - On success, responds with [`RefreshSchemasOutput`](crate::output::RefreshSchemasOutput) with field(s):
    ///   - [`refresh_schemas_status(Option<RefreshSchemasStatus>)`](crate::output::RefreshSchemasOutput::refresh_schemas_status): <p>The status of the refreshed schema.</p>
    /// - On failure, responds with [`SdkError<RefreshSchemasError>`](crate::error::RefreshSchemasError)
    pub fn refresh_schemas(&self) -> fluent_builders::RefreshSchemas {
        fluent_builders::RefreshSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReloadTables`](crate::client::fluent_builders::ReloadTables) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::ReloadTables::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::ReloadTables::set_replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task. </p>
    ///   - [`tables_to_reload(Vec<TableToReload>)`](crate::client::fluent_builders::ReloadTables::tables_to_reload) / [`set_tables_to_reload(Option<Vec<TableToReload>>)`](crate::client::fluent_builders::ReloadTables::set_tables_to_reload): <p>The name and schema of the table to be reloaded. </p>
    ///   - [`reload_option(ReloadOptionValue)`](crate::client::fluent_builders::ReloadTables::reload_option) / [`set_reload_option(Option<ReloadOptionValue>)`](crate::client::fluent_builders::ReloadTables::set_reload_option): <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is enabled for the task. </p>  <p>Valid values: data-reload, validate-only</p>  <p>Default value is data-reload.</p>
    /// - On success, responds with [`ReloadTablesOutput`](crate::output::ReloadTablesOutput) with field(s):
    ///   - [`replication_task_arn(Option<String>)`](crate::output::ReloadTablesOutput::replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task. </p>
    /// - On failure, responds with [`SdkError<ReloadTablesError>`](crate::error::ReloadTablesError)
    pub fn reload_tables(&self) -> fluent_builders::ReloadTables {
        fluent_builders::ReloadTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_arn): <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>The tag key (name) of the tag to be removed.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartReplicationTask`](crate::client::fluent_builders::StartReplicationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTask::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::StartReplicationTask::set_replication_task_arn): <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
    ///   - [`start_replication_task_type(StartReplicationTaskTypeValue)`](crate::client::fluent_builders::StartReplicationTask::start_replication_task_type) / [`set_start_replication_task_type(Option<StartReplicationTaskTypeValue>)`](crate::client::fluent_builders::StartReplicationTask::set_start_replication_task_type): <p>The type of replication task to start.</p>  <p>When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart the task and <code>resume-processing</code> to resume the task.</p>  <p>When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value for a task with migration type of <code>cdc</code>.</p>
    ///   - [`cdc_start_time(DateTime)`](crate::client::fluent_builders::StartReplicationTask::cdc_start_time) / [`set_cdc_start_time(Option<DateTime>)`](crate::client::fluent_builders::StartReplicationTask::set_cdc_start_time): <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>  <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
    ///   - [`cdc_start_position(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTask::cdc_start_position) / [`set_cdc_start_position(Option<String>)`](crate::client::fluent_builders::StartReplicationTask::set_cdc_start_position): <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>  <p> The value can be in date, checkpoint, or LSN/SCN format.</p>  <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>  <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>  <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>   <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>  </note>
    ///   - [`cdc_stop_position(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTask::cdc_stop_position) / [`set_cdc_stop_position(Option<String>)`](crate::client::fluent_builders::StartReplicationTask::set_cdc_stop_position): <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>  <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>  <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    /// - On success, responds with [`StartReplicationTaskOutput`](crate::output::StartReplicationTaskOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::StartReplicationTaskOutput::replication_task): <p>The replication task started.</p>
    /// - On failure, responds with [`SdkError<StartReplicationTaskError>`](crate::error::StartReplicationTaskError)
    pub fn start_replication_task(&self) -> fluent_builders::StartReplicationTask {
        fluent_builders::StartReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartReplicationTaskAssessment`](crate::client::fluent_builders::StartReplicationTaskAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessment::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessment::set_replication_task_arn): <p> The Amazon Resource Name (ARN) of the replication task. </p>
    /// - On success, responds with [`StartReplicationTaskAssessmentOutput`](crate::output::StartReplicationTaskAssessmentOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::StartReplicationTaskAssessmentOutput::replication_task): <p> The assessed replication task. </p>
    /// - On failure, responds with [`SdkError<StartReplicationTaskAssessmentError>`](crate::error::StartReplicationTaskAssessmentError)
    pub fn start_replication_task_assessment(
        &self,
    ) -> fluent_builders::StartReplicationTaskAssessment {
        fluent_builders::StartReplicationTaskAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartReplicationTaskAssessmentRun`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_replication_task_arn): <p>Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you want to start.</p>
    ///   - [`service_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::service_access_role_arn) / [`set_service_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_service_access_role_arn): <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
    ///   - [`result_location_bucket(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::result_location_bucket) / [`set_result_location_bucket(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_result_location_bucket): <p>Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>
    ///   - [`result_location_folder(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::result_location_folder) / [`set_result_location_folder(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_result_location_folder): <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>
    ///   - [`result_encryption_mode(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::result_encryption_mode) / [`set_result_encryption_mode(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_result_encryption_mode): <p>Encryption mode that you can specify to encrypt the results of this assessment run. If you don't specify this request parameter, DMS stores the assessment run results without encryption. You can specify one of the options following:</p>  <ul>   <li> <p> <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.</p> </li>   <li> <p> <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom KMS encryption key that you specify or the default KMS encryption key that DMS provides.</p> </li>  </ul>
    ///   - [`result_kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::result_kms_key_arn) / [`set_result_kms_key_arn(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_result_kms_key_arn): <p>ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
    ///   - [`assessment_run_name(impl Into<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::assessment_run_name) / [`set_assessment_run_name(Option<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_assessment_run_name): <p>Unique name to identify the assessment run.</p>
    ///   - [`include_only(Vec<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::include_only) / [`set_include_only(Option<Vec<String>>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_include_only): <p>Space-separated list of names for specific individual assessments that you want to include. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>   <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the API operation. </p>   <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p>  </note>
    ///   - [`exclude(Vec<String>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::exclude) / [`set_exclude(Option<Vec<String>>)`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun::set_exclude): <p>Space-separated list of names for specific individual assessments that you want to exclude. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>   <p>You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the API operation.</p>   <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p>  </note>
    /// - On success, responds with [`StartReplicationTaskAssessmentRunOutput`](crate::output::StartReplicationTaskAssessmentRunOutput) with field(s):
    ///   - [`replication_task_assessment_run(Option<ReplicationTaskAssessmentRun>)`](crate::output::StartReplicationTaskAssessmentRunOutput::replication_task_assessment_run): <p>The premigration assessment run that was started.</p>
    /// - On failure, responds with [`SdkError<StartReplicationTaskAssessmentRunError>`](crate::error::StartReplicationTaskAssessmentRunError)
    pub fn start_replication_task_assessment_run(
        &self,
    ) -> fluent_builders::StartReplicationTaskAssessmentRun {
        fluent_builders::StartReplicationTaskAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopReplicationTask`](crate::client::fluent_builders::StopReplicationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_task_arn(impl Into<String>)`](crate::client::fluent_builders::StopReplicationTask::replication_task_arn) / [`set_replication_task_arn(Option<String>)`](crate::client::fluent_builders::StopReplicationTask::set_replication_task_arn): <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
    /// - On success, responds with [`StopReplicationTaskOutput`](crate::output::StopReplicationTaskOutput) with field(s):
    ///   - [`replication_task(Option<ReplicationTask>)`](crate::output::StopReplicationTaskOutput::replication_task): <p>The replication task stopped.</p>
    /// - On failure, responds with [`SdkError<StopReplicationTaskError>`](crate::error::StopReplicationTaskError)
    pub fn stop_replication_task(&self) -> fluent_builders::StopReplicationTask {
        fluent_builders::StopReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestConnection`](crate::client::fluent_builders::TestConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_instance_arn(impl Into<String>)`](crate::client::fluent_builders::TestConnection::replication_instance_arn) / [`set_replication_instance_arn(Option<String>)`](crate::client::fluent_builders::TestConnection::set_replication_instance_arn): <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    ///   - [`endpoint_arn(impl Into<String>)`](crate::client::fluent_builders::TestConnection::endpoint_arn) / [`set_endpoint_arn(Option<String>)`](crate::client::fluent_builders::TestConnection::set_endpoint_arn): <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    /// - On success, responds with [`TestConnectionOutput`](crate::output::TestConnectionOutput) with field(s):
    ///   - [`connection(Option<Connection>)`](crate::output::TestConnectionOutput::connection): <p>The connection tested.</p>
    /// - On failure, responds with [`SdkError<TestConnectionError>`](crate::error::TestConnectionError)
    pub fn test_connection(&self) -> fluent_builders::TestConnection {
        fluent_builders::TestConnection::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an DMS resource, including replication instance, endpoint, security group, and migration task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or used in a Condition statement in an IAM policy for DMS. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type description.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
        /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
        /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example, to a replication instance).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl ApplyPendingMaintenanceAction {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action applies to.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action applies to.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code> </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code> </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an opt-in request of type <code>immediate</code>.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an opt-in request of type <code>immediate</code>.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelReplicationTaskAssessmentRun`.
    ///
    /// <p>Cancels a single premigration assessment run.</p>
    /// <p>This operation prevents any individual assessments from running if they haven't started running. It also attempts to cancel any individual assessments that are currently running.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelReplicationTaskAssessmentRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_replication_task_assessment_run_input::Builder,
    }
    impl CancelReplicationTaskAssessmentRun {
        /// Creates a new `CancelReplicationTaskAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelReplicationTaskAssessmentRunOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CancelReplicationTaskAssessmentRunError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_task_assessment_run_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpoint`.
    ///
    /// <p>Creates an endpoint using the provided settings.</p> <note>
    /// <p>For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code> request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_endpoint_input::Builder,
    }
    impl CreateEndpoint {
        /// Creates a new `CreateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_identifier(input.into());
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_identifier(input);
            self
        }
        /// <p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, input: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.inner = self.inner.endpoint_type(input);
            self
        }
        /// <p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(input.into());
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>The user name to be used to log in to the endpoint database.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name to be used to log in to the endpoint database.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password to be used to log in to the endpoint database.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password to be used to log in to the endpoint database.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_name(input.into());
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_name(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Additional attributes associated with the connection. Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with DMS Endpoints</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn extra_connection_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.extra_connection_attributes(input.into());
            self
        }
        /// <p>Additional attributes associated with the connection. Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with DMS Endpoints</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extra_connection_attributes(input);
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the endpoint.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags to be assigned to the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> </p>
        pub fn ssl_mode(mut self, input: crate::model::DmsSslModeValue) -> Self {
            self.inner = self.inner.ssl_mode(input);
            self
        }
        /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> </p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.inner = self.inner.set_ssl_mode(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_access_role_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_access_role_arn(input);
            self
        }
        /// <p>The external table definition. </p>
        pub fn external_table_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_table_definition(input.into());
            self
        }
        /// <p>The external table definition. </p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_table_definition(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn dynamo_db_settings(mut self, input: crate::model::DynamoDbSettings) -> Self {
            self.inner = self.inner.dynamo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_dynamo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn s3_settings(mut self, input: crate::model::S3Settings) -> Self {
            self.inner = self.inner.s3_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.inner = self.inner.set_s3_settings(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Possible settings include the following:</p>
        /// <ul>
        /// <li> <p> <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p> </li>
        /// <li> <p> <code>BucketName</code> - The name of the S3 bucket to use.</p> </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string,BucketName=string</code> </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", } </code> </p>
        pub fn dms_transfer_settings(mut self, input: crate::model::DmsTransferSettings) -> Self {
            self.inner = self.inner.dms_transfer_settings(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Possible settings include the following:</p>
        /// <ul>
        /// <li> <p> <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p> </li>
        /// <li> <p> <code>BucketName</code> - The name of the S3 bucket to use.</p> </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string,BucketName=string</code> </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", } </code> </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.inner = self.inner.set_dms_transfer_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn mongo_db_settings(mut self, input: crate::model::MongoDbSettings) -> Self {
            self.inner = self.inner.mongo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_mongo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn kinesis_settings(mut self, input: crate::model::KinesisSettings) -> Self {
            self.inner = self.inner.kinesis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn kafka_settings(mut self, input: crate::model::KafkaSettings) -> Self {
            self.inner = self.inner.kafka_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.inner = self.inner.set_kafka_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target OpenSearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS</a> in the <i>Database Migration Service User Guide</i>.</p>
        pub fn elasticsearch_settings(
            mut self,
            input: crate::model::ElasticsearchSettings,
        ) -> Self {
            self.inner = self.inner.elasticsearch_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target OpenSearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS</a> in the <i>Database Migration Service User Guide</i>.</p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn neptune_settings(mut self, input: crate::model::NeptuneSettings) -> Self {
            self.inner = self.inner.neptune_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.inner = self.inner.set_neptune_settings(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, input: crate::model::RedshiftSettings) -> Self {
            self.inner = self.inner.redshift_settings(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.inner = self.inner.set_redshift_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn postgre_sql_settings(mut self, input: crate::model::PostgreSqlSettings) -> Self {
            self.inner = self.inner.postgre_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_postgre_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn my_sql_settings(mut self, input: crate::model::MySqlSettings) -> Self {
            self.inner = self.inner.my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn oracle_settings(mut self, input: crate::model::OracleSettings) -> Self {
            self.inner = self.inner.oracle_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.inner = self.inner.set_oracle_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn sybase_settings(mut self, input: crate::model::SybaseSettings) -> Self {
            self.inner = self.inner.sybase_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.inner = self.inner.set_sybase_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn microsoft_sql_server_settings(
            mut self,
            input: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.inner = self.inner.microsoft_sql_server_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.inner = self.inner.set_microsoft_sql_server_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn ibm_db2_settings(mut self, input: crate::model::IbmDb2Settings) -> Self {
            self.inner = self.inner.ibm_db2_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.inner = self.inner.set_ibm_db2_settings(input);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn doc_db_settings(mut self, input: crate::model::DocDbSettings) -> Self {
            self.inner = self.inner.doc_db_settings(input);
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_doc_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Redis endpoint.</p>
        pub fn redis_settings(mut self, input: crate::model::RedisSettings) -> Self {
            self.inner = self.inner.redis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Redis endpoint.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.inner = self.inner.set_redis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
        pub fn gcp_my_sql_settings(mut self, input: crate::model::GcpMySqlSettings) -> Self {
            self.inner = self.inner.gcp_my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
        pub fn set_gcp_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::GcpMySqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_gcp_my_sql_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p> Creates an DMS event notification subscription. </p>
    /// <p>You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (<code>EventCategories</code>) for events you want to be notified of. If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>, you receive notice of the events for that source type for all your DMS sources. If you don't specify either <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS sources belonging to your customer account.</p>
    /// <p>For more information about DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl CreateEventSubscription {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p> The type of DMS resource that generates the events. For example, if you want to be notified of events generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this value isn't specified, all events are returned. </p>
        /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code> </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p> The type of DMS resource that generates the events. For example, if you want to be notified of events generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this value isn't specified, all events are returned. </p>
        /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code> </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for a source type that you want to subscribe to. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p>A list of event categories for a source type that you want to subscribe to. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of identifiers for which DMS provides notification events.</p>
        /// <p>If you don't specify a value, notifications are provided for all sources.</p>
        /// <p>If you specify multiple values, they must be of the same type. For example, if you specify a database instance ID, then all of the other values must be database instance IDs.</p>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(input.into());
            self
        }
        /// <p>A list of identifiers for which DMS provides notification events.</p>
        /// <p>If you don't specify a value, notifications are provided for all sources.</p>
        /// <p>If you specify multiple values, they must be of the same type. For example, if you specify a database instance ID, then all of the other values must be database instance IDs.</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to create the subscription but not activate it. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to create the subscription but not activate it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the event subscription.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags to be assigned to the event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationInstance`.
    ///
    /// <p>Creates the replication instance using the specified parameters.</p>
    /// <p>DMS requires that your account have certain roles with appropriate permissions before you can create a replication instance. For information on the required roles, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM Permissions Needed to Use DMS</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_instance_input::Builder,
    }
    impl CreateReplicationInstance {
        /// Creates a new `CreateReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1-63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code> </p>
        pub fn replication_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_instance_identifier(input.into());
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1-63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code> </p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_identifier(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication instance.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.inner = self.inner.allocated_storage(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_class(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_class(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The Availability Zone where the replication instance will be created. The default value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for example: <code>us-east-1d</code> </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone where the replication instance will be created. The default value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for example: <code>us-east-1d</code> </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>A subnet group to associate with the replication instance.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(input.into());
            self
        }
        /// <p>A subnet group to associate with the replication instance.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window. This parameter defaults to <code>true</code>.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window. This parameter defaults to <code>true</code>.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the replication instance.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags to be assigned to the replication instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an instance with a public IP address. A value of <code>false</code> represents an instance with a private IP address. The default value is <code>true</code>. </p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an instance with a public IP address. A value of <code>false</code> represents an instance with a private IP address. The default value is <code>true</code>. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>A list of custom DNS name servers supported for the replication instance to access your on-premise source or target database. This list overrides the default name servers supported by the replication instance. You can specify a comma-separated list of internet addresses for up to four on-premise DNS name servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code> </p>
        pub fn dns_name_servers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_name_servers(input.into());
            self
        }
        /// <p>A list of custom DNS name servers supported for the replication instance to access your on-premise source or target database. This list overrides the default name servers supported by the replication instance. You can specify a comma-separated list of internet addresses for up to four on-premise DNS name servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code> </p>
        pub fn set_dns_name_servers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dns_name_servers(input);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationSubnetGroup`.
    ///
    /// <p>Creates a replication subnet group given a list of the subnet IDs in a VPC.</p>
    /// <p>The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_subnet_group_input::Builder,
    }
    impl CreateReplicationSubnetGroup {
        /// Creates a new `CreateReplicationSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the replication subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens. Must not be "default".</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(input.into());
            self
        }
        /// <p>The name for the replication subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens. Must not be "default".</p>
        /// <p>Example: <code>mySubnetgroup</code> </p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_subnet_group_description(input.into());
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the subnet group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags to be assigned to the subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationTask`.
    ///
    /// <p>Creates a replication task using the specified parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_task_input::Builder,
    }
    impl CreateReplicationTask {
        /// Creates a new `CreateReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier for the replication task.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn replication_task_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_task_identifier(input.into());
            self
        }
        /// <p>An identifier for the replication task.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_identifier(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
        pub fn source_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_endpoint_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
        pub fn set_source_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_endpoint_arn(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
        pub fn target_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_endpoint_arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
        pub fn set_target_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_endpoint_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.inner = self.inner.migration_type(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_migration_type(input);
            self
        }
        /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn table_mappings(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_mappings(input.into());
            self
        }
        /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_mappings(input);
            self
        }
        /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn replication_task_settings(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_settings(input.into());
            self
        }
        /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_settings(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.cdc_start_time(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_time(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_start_position(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_position(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_stop_position(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_stop_position(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the replication task.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags to be assigned to the replication task.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn task_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_data(input.into());
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_data(input);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCertificate`.
    ///
    /// <p>Deletes the specified certificate. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_certificate_input::Builder,
    }
    impl DeleteCertificate {
        /// Creates a new `DeleteCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes the connection between a replication instance and an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl DeleteConnection {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes the specified endpoint.</p> <note>
    /// <p>All tasks associated with the endpoint must be deleted before you can delete the endpoint.</p>
    /// </note>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl DeleteEndpoint {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p> Deletes an DMS event subscription. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl DeleteEventSubscription {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event notification subscription to be deleted.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the DMS event notification subscription to be deleted.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationInstance`.
    ///
    /// <p>Deletes the specified replication instance.</p> <note>
    /// <p>You must delete any migration tasks that are associated with the replication instance before you can delete it.</p>
    /// </note>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_instance_input::Builder,
    }
    impl DeleteReplicationInstance {
        /// Creates a new `DeleteReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationSubnetGroup`.
    ///
    /// <p>Deletes a subnet group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_subnet_group_input::Builder,
    }
    impl DeleteReplicationSubnetGroup {
        /// Creates a new `DeleteReplicationSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The subnet group name of the replication instance.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(input.into());
            self
        }
        /// <p>The subnet group name of the replication instance.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationTask`.
    ///
    /// <p>Deletes the specified replication task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_task_input::Builder,
    }
    impl DeleteReplicationTask {
        /// Creates a new `DeleteReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationTaskAssessmentRun`.
    ///
    /// <p>Deletes the record of a single premigration assessment run.</p>
    /// <p>This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves untouched all information about this assessment run that is stored in your Amazon S3 bucket.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationTaskAssessmentRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_task_assessment_run_input::Builder,
    }
    impl DeleteReplicationTaskAssessmentRun {
        /// Creates a new `DeleteReplicationTaskAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationTaskAssessmentRunOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteReplicationTaskAssessmentRunError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_task_assessment_run_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by the account, such as the number of replication instances allowed. The description for each resource quota, includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique account identifier to name each artifact used by DMS in the given region.</p>
    /// <p>This command does not take any parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl DescribeAccountAttributes {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicableIndividualAssessments`.
    ///
    /// <p>Provides a list of individual assessments that you can specify for a new premigration assessment run, given one or more parameters.</p>
    /// <p>If you specify an existing migration task, this operation provides the default individual assessments you can specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which to base a premigration assessment run.</p>
    /// <p>To use these migration task modeling parameters, you must specify an existing replication instance, a source database engine, a target database engine, and a migration type. This combination of parameters potentially limits the default individual assessments available for an assessment run created for a corresponding migration task.</p>
    /// <p>If you specify no parameters, this operation provides a list of all possible individual assessments that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of them or the operation cannot provide a list of individual assessments. The only parameter that you can specify alone is for an existing migration task. The specified task definition then determines the default list of individual assessments that you can specify in an assessment run for the task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplicableIndividualAssessments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_applicable_individual_assessments_input::Builder,
    }
    impl DescribeApplicableIndividualAssessments {
        /// Creates a new `DescribeApplicableIndividualAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicableIndividualAssessmentsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeApplicableIndividualAssessmentsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeApplicableIndividualAssessmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeApplicableIndividualAssessmentsPaginator {
            crate::paginator::DescribeApplicableIndividualAssessmentsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual assessments.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual assessments.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>ARN of a replication instance on which you want to base the default list of individual assessments.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>ARN of a replication instance on which you want to base the default list of individual assessments.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
        pub fn source_engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_engine_name(input.into());
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
        pub fn set_source_engine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_engine_name(input);
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
        pub fn target_engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_engine_name(input.into());
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
        pub fn set_target_engine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_engine_name(input);
            self
        }
        /// <p>Name of the migration type that each provided individual assessment must support.</p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.inner = self.inner.migration_type(input);
            self
        }
        /// <p>Name of the migration type that each provided individual assessment must support.</p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_migration_type(input);
            self
        }
        /// <p>Maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>Maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>Optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificates`.
    ///
    /// <p>Provides a description of the certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCertificates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_certificates_input::Builder,
    }
    impl DescribeCertificates {
        /// Creates a new `DescribeCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCertificatesPaginator {
            crate::paginator::DescribeCertificatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the certificates described in the form of key-value pairs. Valid values are <code>certificate-arn</code> and <code>certificate-id</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to the certificates described in the form of key-value pairs. Valid values are <code>certificate-arn</code> and <code>certificate-id</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 10</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 10</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnections`.
    ///
    /// <p>Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_connections_input::Builder,
    }
    impl DescribeConnections {
        /// Creates a new `DescribeConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeConnectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeConnectionsPaginator {
            crate::paginator::DescribeConnectionsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters applied to the connection.</p>
        /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters applied to the connection.</p>
        /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoints`.
    ///
    /// <p>Returns information about the endpoints for your account in the current region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoints_input::Builder,
    }
    impl DescribeEndpoints {
        /// Creates a new `DescribeEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEndpointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEndpointsPaginator {
            crate::paginator::DescribeEndpointsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the endpoints.</p>
        /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to the endpoints.</p>
        /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointSettings`.
    ///
    /// <p>Returns information about the possible endpoint settings available when you create an endpoint for a specific database engine.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpointSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoint_settings_input::Builder,
    }
    impl DescribeEndpointSettings {
        /// Creates a new `DescribeEndpointSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEndpointSettingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEndpointSettingsPaginator {
            crate::paginator::DescribeEndpointSettingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The databse engine used for your source or target endpoint.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(input.into());
            self
        }
        /// <p>The databse engine used for your source or target endpoint.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointTypes`.
    ///
    /// <p>Returns information about the type of endpoints available.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpointTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoint_types_input::Builder,
    }
    impl DescribeEndpointTypes {
        /// Creates a new `DescribeEndpointTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEndpointTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEndpointTypesPaginator {
            crate::paginator::DescribeEndpointTypesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the endpoint types.</p>
        /// <p>Valid filter names: engine-name | endpoint-type</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to the endpoint types.</p>
        /// <p>Valid filter names: engine-name | endpoint-type</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventCategories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl DescribeEventCategories {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the event categories.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to the event categories.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p> Lists events for a given source identifier and source type. You can also specify a start and end time. For more information on DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsPaginator {
            crate::paginator::DescribeEventsPaginator::new(self.handle, self.inner)
        }
        /// <p> The identifier of an event source.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p> The identifier of an event source.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The type of DMS resource that generates events.</p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The type of DMS resource that generates events.</p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The start time for the events to be listed.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time for the events to be listed.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time for the events to be listed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time for the events to be listed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The duration of the events to be listed.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The duration of the events to be listed.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for the source type that you've chosen.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p>A list of event categories for the source type that you've chosen.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to events. The only valid filter is <code>replication-instance-id</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to events. The only valid filter is <code>replication-instance-id</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists all the event subscriptions for a customer account. The description of a subscription includes <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>. </p>
    /// <p>If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventSubscriptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl DescribeEventSubscriptions {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventSubscriptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventSubscriptionsPaginator {
            crate::paginator::DescribeEventSubscriptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the DMS event subscription to be described.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the DMS event subscription to be described.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to event subscriptions.</p>
        /// <p>Valid filter names: event-subscription-arn | event-subscription-id </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to event subscriptions.</p>
        /// <p>Valid filter names: event-subscription-arn | event-subscription-id </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableReplicationInstances`.
    ///
    /// <p>Returns information about the replication instance types that can be created in the specified region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrderableReplicationInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_orderable_replication_instances_input::Builder,
    }
    impl DescribeOrderableReplicationInstances {
        /// Creates a new `DescribeOrderableReplicationInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableReplicationInstancesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrderableReplicationInstancesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrderableReplicationInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeOrderableReplicationInstancesPaginator {
            crate::paginator::DescribeOrderableReplicationInstancesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingMaintenanceActions`.
    ///
    /// <p>For internal use only</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePendingMaintenanceActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pending_maintenance_actions_input::Builder,
    }
    impl DescribePendingMaintenanceActions {
        /// Creates a new `DescribePendingMaintenanceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingMaintenanceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePendingMaintenanceActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribePendingMaintenanceActionsPaginator {
            crate::paginator::DescribePendingMaintenanceActionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p></p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRefreshSchemasStatus`.
    ///
    /// <p>Returns the status of the RefreshSchemas operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRefreshSchemasStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_refresh_schemas_status_input::Builder,
    }
    impl DescribeRefreshSchemasStatus {
        /// Creates a new `DescribeRefreshSchemasStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRefreshSchemasStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRefreshSchemasStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationInstances`.
    ///
    /// <p>Returns information about replication instances for your account in the current region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_instances_input::Builder,
    }
    impl DescribeReplicationInstances {
        /// Creates a new `DescribeReplicationInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReplicationInstancesPaginator {
            crate::paginator::DescribeReplicationInstancesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication instances.</p>
        /// <p>Valid filter names: replication-instance-arn | replication-instance-id | replication-instance-class | engine-version</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to replication instances.</p>
        /// <p>Valid filter names: replication-instance-arn | replication-instance-id | replication-instance-class | engine-version</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationInstanceTaskLogs`.
    ///
    /// <p>Returns information about the task logs for the specified task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationInstanceTaskLogs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_instance_task_logs_input::Builder,
    }
    impl DescribeReplicationInstanceTaskLogs {
        /// Creates a new `DescribeReplicationInstanceTaskLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationInstanceTaskLogsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationInstanceTaskLogsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationInstanceTaskLogsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationInstanceTaskLogsPaginator {
            crate::paginator::DescribeReplicationInstanceTaskLogsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationSubnetGroups`.
    ///
    /// <p>Returns information about the replication subnet groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationSubnetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_subnet_groups_input::Builder,
    }
    impl DescribeReplicationSubnetGroups {
        /// Creates a new `DescribeReplicationSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationSubnetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationSubnetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReplicationSubnetGroupsPaginator {
            crate::paginator::DescribeReplicationSubnetGroupsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication subnet groups.</p>
        /// <p>Valid filter names: replication-subnet-group-id</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to replication subnet groups.</p>
        /// <p>Valid filter names: replication-subnet-group-id</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTaskAssessmentResults`.
    ///
    /// <p>Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services account. This action always returns the latest results.</p>
    /// <p>For more information about DMS task assessments, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report</a> in the <i>Database Migration Service User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationTaskAssessmentResults {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_task_assessment_results_input::Builder,
    }
    impl DescribeReplicationTaskAssessmentResults {
        /// Creates a new `DescribeReplicationTaskAssessmentResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTaskAssessmentResultsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationTaskAssessmentResultsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationTaskAssessmentResultsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationTaskAssessmentResultsPaginator {
            crate::paginator::DescribeReplicationTaskAssessmentResultsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input parameter is specified, the API returns only one result and ignore the values of the <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input parameter is specified, the API returns only one result and ignore the values of the <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTaskAssessmentRuns`.
    ///
    /// <p>Returns a paginated list of premigration assessment runs based on filter settings.</p>
    /// <p>These filter settings can specify a combination of premigration assessment runs, migration tasks, replication instances, and assessment run status values.</p> <note>
    /// <p>This operation doesn't return information about individual assessments. For this information, see the <code>DescribeReplicationTaskIndividualAssessments</code> operation. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationTaskAssessmentRuns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_task_assessment_runs_input::Builder,
    }
    impl DescribeReplicationTaskAssessmentRuns {
        /// Creates a new `DescribeReplicationTaskAssessmentRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTaskAssessmentRunsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationTaskAssessmentRunsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationTaskAssessmentRunsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationTaskAssessmentRunsPaginator {
            crate::paginator::DescribeReplicationTaskAssessmentRunsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>replication-instance-arn</code>, <code>status</code> </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>replication-instance-arn</code>, <code>status</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTaskIndividualAssessments`.
    ///
    /// <p>Returns a paginated list of individual assessments based on filter settings.</p>
    /// <p>These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment status values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationTaskIndividualAssessments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_task_individual_assessments_input::Builder,
    }
    impl DescribeReplicationTaskIndividualAssessments {
        /// Creates a new `DescribeReplicationTaskIndividualAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTaskIndividualAssessmentsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationTaskIndividualAssessmentsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationTaskIndividualAssessmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReplicationTaskIndividualAssessmentsPaginator {
            crate::paginator::DescribeReplicationTaskIndividualAssessmentsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the individual assessments described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>status</code> </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to the individual assessments described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>status</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTasks`.
    ///
    /// <p>Returns information about replication tasks for your account in the current region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_tasks_input::Builder,
    }
    impl DescribeReplicationTasks {
        /// Creates a new `DescribeReplicationTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReplicationTasksPaginator {
            crate::paginator::DescribeReplicationTasksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication tasks.</p>
        /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type | endpoint-arn | replication-instance-arn</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to replication tasks.</p>
        /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type | endpoint-arn | replication-instance-arn</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An option to set to avoid returning information about settings. Use this to reduce overhead when setting information is too large. To use this option, choose <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
        pub fn without_settings(mut self, input: bool) -> Self {
            self.inner = self.inner.without_settings(input);
            self
        }
        /// <p>An option to set to avoid returning information about settings. Use this to reduce overhead when setting information is too large. To use this option, choose <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
        pub fn set_without_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_without_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSchemas`.
    ///
    /// <p>Returns information about the schema for the specified endpoint.</p>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSchemas {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_schemas_input::Builder,
    }
    impl DescribeSchemas {
        /// Creates a new `DescribeSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSchemasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSchemasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSchemasPaginator {
            crate::paginator::DescribeSchemasPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTableStatistics`.
    ///
    /// <p>Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted.</p>
    /// <p>Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table statistics record for a table. It does not indicate the time of the last update to the table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTableStatistics {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_table_statistics_input::Builder,
    }
    impl DescribeTableStatistics {
        /// Creates a new `DescribeTableStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableStatisticsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTableStatisticsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTableStatisticsPaginator {
            crate::paginator::DescribeTableStatisticsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 500.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 500.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to table statistics.</p>
        /// <p>Valid filter names: schema-name | table-name | table-state</p>
        /// <p>A combination of filters creates an AND condition where each record matches all specified filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters applied to table statistics.</p>
        /// <p>Valid filter names: schema-name | table-name | table-state</p>
        /// <p>A combination of filters creates an AND condition where each record matches all specified filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportCertificate`.
    ///
    /// <p>Uploads the specified certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_certificate_input::Builder,
    }
    impl ImportCertificate {
        /// Creates a new `ImportCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_identifier(input.into());
            self
        }
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_identifier(input);
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_pem(input.into());
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_pem(input);
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file using the <code>fileb://</code> prefix. You can't provide the certificate inline.</p>
        /// <p>Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code> </p>
        pub fn certificate_wallet(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.certificate_wallet(input);
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file using the <code>fileb://</code> prefix. You can't provide the certificate inline.</p>
        /// <p>Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code> </p>
        pub fn set_certificate_wallet(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_certificate_wallet(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the certificate.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with the certificate.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, security group, and migration task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type description.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This returns a list of keys (names of tags) created for the resource and their associated tag values.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This returns a list of keys (names of tags) created for the resource and their associated tag values.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `ResourceArnList`.
        ///
        /// To override the contents of this collection use [`set_resource_arn_list`](Self::set_resource_arn_list).
        ///
        /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys (tag names) and their associated tag values. It also returns each tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created. </p>
        pub fn resource_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn_list(input.into());
            self
        }
        /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys (tag names) and their associated tag values. It also returns each tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created. </p>
        pub fn set_resource_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEndpoint`.
    ///
    /// <p>Modifies the specified endpoint.</p> <note>
    /// <p>For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code> request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_endpoint_input::Builder,
    }
    impl ModifyEndpoint {
        /// Creates a new `ModifyEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_identifier(input.into());
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_identifier(input);
            self
        }
        /// <p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, input: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.inner = self.inner.endpoint_type(input);
            self
        }
        /// <p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(input.into());
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>The user name to be used to login to the endpoint database.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name to be used to login to the endpoint database.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password to be used to login to the endpoint database.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password to be used to login to the endpoint database.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_name(input.into());
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_name(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as an argument.</p>
        pub fn extra_connection_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.extra_connection_attributes(input.into());
            self
        }
        /// <p>Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as an argument.</p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extra_connection_attributes(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
        pub fn ssl_mode(mut self, input: crate::model::DmsSslModeValue) -> Self {
            self.inner = self.inner.ssl_mode(input);
            self
        }
        /// <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.inner = self.inner.set_ssl_mode(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_access_role_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_access_role_arn(input);
            self
        }
        /// <p>The external table definition.</p>
        pub fn external_table_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_table_definition(input.into());
            self
        }
        /// <p>The external table definition.</p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_table_definition(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn dynamo_db_settings(mut self, input: crate::model::DynamoDbSettings) -> Self {
            self.inner = self.inner.dynamo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_dynamo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn s3_settings(mut self, input: crate::model::S3Settings) -> Self {
            self.inner = self.inner.s3_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.inner = self.inner.set_s3_settings(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Attributes include the following:</p>
        /// <ul>
        /// <li> <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p> </li>
        /// <li> <p>BucketName - The name of the S3 bucket to use.</p> </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string ,BucketName=string</code> </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string"} </code> </p>
        pub fn dms_transfer_settings(mut self, input: crate::model::DmsTransferSettings) -> Self {
            self.inner = self.inner.dms_transfer_settings(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Attributes include the following:</p>
        /// <ul>
        /// <li> <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p> </li>
        /// <li> <p>BucketName - The name of the S3 bucket to use.</p> </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string ,BucketName=string</code> </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string"} </code> </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.inner = self.inner.set_dms_transfer_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn mongo_db_settings(mut self, input: crate::model::MongoDbSettings) -> Self {
            self.inner = self.inner.mongo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_mongo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn kinesis_settings(mut self, input: crate::model::KinesisSettings) -> Self {
            self.inner = self.inner.kinesis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn kafka_settings(mut self, input: crate::model::KafkaSettings) -> Self {
            self.inner = self.inner.kafka_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.inner = self.inner.set_kafka_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target OpenSearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn elasticsearch_settings(
            mut self,
            input: crate::model::ElasticsearchSettings,
        ) -> Self {
            self.inner = self.inner.elasticsearch_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target OpenSearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn neptune_settings(mut self, input: crate::model::NeptuneSettings) -> Self {
            self.inner = self.inner.neptune_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.inner = self.inner.set_neptune_settings(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, input: crate::model::RedshiftSettings) -> Self {
            self.inner = self.inner.redshift_settings(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.inner = self.inner.set_redshift_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn postgre_sql_settings(mut self, input: crate::model::PostgreSqlSettings) -> Self {
            self.inner = self.inner.postgre_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_postgre_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn my_sql_settings(mut self, input: crate::model::MySqlSettings) -> Self {
            self.inner = self.inner.my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn oracle_settings(mut self, input: crate::model::OracleSettings) -> Self {
            self.inner = self.inner.oracle_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.inner = self.inner.set_oracle_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn sybase_settings(mut self, input: crate::model::SybaseSettings) -> Self {
            self.inner = self.inner.sybase_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.inner = self.inner.set_sybase_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn microsoft_sql_server_settings(
            mut self,
            input: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.inner = self.inner.microsoft_sql_server_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.inner = self.inner.set_microsoft_sql_server_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn ibm_db2_settings(mut self, input: crate::model::IbmDb2Settings) -> Self {
            self.inner = self.inner.ibm_db2_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.inner = self.inner.set_ibm_db2_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service </a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn doc_db_settings(mut self, input: crate::model::DocDbSettings) -> Self {
            self.inner = self.inner.doc_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service </a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_doc_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the Redis target endpoint.</p>
        pub fn redis_settings(mut self, input: crate::model::RedisSettings) -> Self {
            self.inner = self.inner.redis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the Redis target endpoint.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.inner = self.inner.set_redis_settings(input);
            self
        }
        /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all existing endpoint settings with the exact settings that you specify in this call. If this attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
        /// <ul>
        /// <li> <p>It replaces any endpoint settings that already exist with new values, for settings with the same names.</p> </li>
        /// <li> <p>It creates new endpoint settings that you specify in the call, for settings with different names. </p> </li>
        /// </ul>
        /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}' ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
        /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ... --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again. Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings are replaced with the exact settings that you specify. </p>
        pub fn exact_settings(mut self, input: bool) -> Self {
            self.inner = self.inner.exact_settings(input);
            self
        }
        /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all existing endpoint settings with the exact settings that you specify in this call. If this attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
        /// <ul>
        /// <li> <p>It replaces any endpoint settings that already exist with new values, for settings with the same names.</p> </li>
        /// <li> <p>It creates new endpoint settings that you specify in the call, for settings with different names. </p> </li>
        /// </ul>
        /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}' ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
        /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ... --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again. Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings are replaced with the exact settings that you specify. </p>
        pub fn set_exact_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exact_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
        pub fn gcp_my_sql_settings(mut self, input: crate::model::GcpMySqlSettings) -> Self {
            self.inner = self.inner.gcp_my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
        pub fn set_gcp_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::GcpMySqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_gcp_my_sql_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing DMS event notification subscription. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl ModifyEventSubscription {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event notification subscription to be modified.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the DMS event notification subscription to be modified.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a source type that you want to subscribe to. Use the <code>DescribeEventCategories</code> action to see a list of event categories. </p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p> A list of event categories for a source type that you want to subscribe to. Use the <code>DescribeEventCategories</code> action to see a list of event categories. </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the subscription. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the subscription. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationInstance`.
    ///
    /// <p>Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request.</p>
    /// <p>Some settings are applied during the maintenance window.</p>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyReplicationInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_replication_instance_input::Builder,
    }
    impl ModifyReplicationInstance {
        /// Creates a new `ModifyReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be allocated for the replication instance.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.inner = self.inner.allocated_storage(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be allocated for the replication instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>Indicates whether the changes should be applied immediately or during the next maintenance window.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>Indicates whether the changes should be applied immediately or during the next maintenance window.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_class(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_class(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter does not result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter does not result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the replication instance's current version.</p>
        pub fn allow_major_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_major_version_upgrade(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the replication instance's current version.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_major_version_upgrade(input);
            self
        }
        /// <p>A value that indicates that minor version upgrades are applied automatically to the replication instance during the maintenance window. Changing this parameter doesn't result in an outage, except in the case described following. The change is asynchronously applied as soon as possible. </p>
        /// <p>An outage does result if these factors apply: </p>
        /// <ul>
        /// <li> <p>This parameter is set to <code>true</code> during the maintenance window.</p> </li>
        /// <li> <p>A newer minor version is available. </p> </li>
        /// <li> <p>DMS has enabled automatic patching for the given engine version. </p> </li>
        /// </ul>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>A value that indicates that minor version upgrades are applied automatically to the replication instance during the maintenance window. Changing this parameter doesn't result in an outage, except in the case described following. The change is asynchronously applied as soon as possible. </p>
        /// <p>An outage does result if these factors apply: </p>
        /// <ul>
        /// <li> <p>This parameter is set to <code>true</code> during the maintenance window.</p> </li>
        /// <li> <p>A newer minor version is available. </p> </li>
        /// <li> <p>DMS has enabled automatic patching for the given engine version. </p> </li>
        /// </ul>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase string.</p>
        pub fn replication_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_instance_identifier(input.into());
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase string.</p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationSubnetGroup`.
    ///
    /// <p>Modifies the settings for the specified replication subnet group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyReplicationSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_replication_subnet_group_input::Builder,
    }
    impl ModifyReplicationSubnetGroup {
        /// Creates a new `ModifyReplicationSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replication instance subnet group.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(input.into());
            self
        }
        /// <p>The name of the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
        /// <p>A description for the replication instance subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .replication_subnet_group_description(input.into());
            self
        }
        /// <p>A description for the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of subnet IDs.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationTask`.
    ///
    /// <p>Modifies the specified replication task.</p>
    /// <p>You can't modify the task endpoints. The task must be stopped before you can modify it. </p>
    /// <p>For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the <i>Database Migration Service User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyReplicationTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_replication_task_input::Builder,
    }
    impl ModifyReplicationTask {
        /// Creates a new `ModifyReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>The replication task identifier.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn replication_task_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_task_identifier(input.into());
            self
        }
        /// <p>The replication task identifier.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_identifier(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.inner = self.inner.migration_type(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_migration_type(input);
            self
        }
        /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with <code>file://</code>. For example, <code>--table-mappings file://mappingfile.json</code>. When working with the DMS API, provide the JSON as the parameter value. </p>
        pub fn table_mappings(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_mappings(input.into());
            self
        }
        /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with <code>file://</code>. For example, <code>--table-mappings file://mappingfile.json</code>. When working with the DMS API, provide the JSON as the parameter value. </p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_mappings(input);
            self
        }
        /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
        pub fn replication_task_settings(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_settings(input.into());
            self
        }
        /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_settings(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.cdc_start_time(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_time(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_start_position(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_position(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_stop_position(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_stop_position(input);
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn task_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_data(input.into());
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MoveReplicationTask`.
    ///
    /// <p>Moves a replication task from its current replication instance to a different target replication instance using the specified parameters. The target replication instance must be created with the same or later DMS version as the current replication instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MoveReplicationTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::move_replication_task_input::Builder,
    }
    impl MoveReplicationTask {
        /// Creates a new `MoveReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MoveReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::MoveReplicationTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>The ARN of the replication instance where you want to move the task to.</p>
        pub fn target_replication_instance_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_replication_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the replication instance where you want to move the task to.</p>
        pub fn set_target_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootReplicationInstance`.
    ///
    /// <p>Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes available again.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootReplicationInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reboot_replication_instance_input::Builder,
    }
    impl RebootReplicationInstance {
        /// Creates a new `RebootReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootReplicationInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. If the instance isn't configured for Multi-AZ, then you can't specify <code>true</code>. ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn force_failover(mut self, input: bool) -> Self {
            self.inner = self.inner.force_failover(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. If the instance isn't configured for Multi-AZ, then you can't specify <code>true</code>. ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_failover(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover where resources are released and cleaned up prior to conducting the failover. If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>. ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn force_planned_failover(mut self, input: bool) -> Self {
            self.inner = self.inner.force_planned_failover(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover where resources are released and cleaned up prior to conducting the failover. If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>. ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn set_force_planned_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_planned_failover(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshSchemas`.
    ///
    /// <p>Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes. You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RefreshSchemas {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::refresh_schemas_input::Builder,
    }
    impl RefreshSchemas {
        /// Creates a new `RefreshSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshSchemasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReloadTables`.
    ///
    /// <p>Reloads the target database table with the source data. </p>
    /// <p>You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw an <code>InvalidResourceStateFault</code> exception.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReloadTables {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reload_tables_input::Builder,
    }
    impl ReloadTables {
        /// Creates a new `ReloadTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReloadTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ReloadTablesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// Appends an item to `TablesToReload`.
        ///
        /// To override the contents of this collection use [`set_tables_to_reload`](Self::set_tables_to_reload).
        ///
        /// <p>The name and schema of the table to be reloaded. </p>
        pub fn tables_to_reload(mut self, input: crate::model::TableToReload) -> Self {
            self.inner = self.inner.tables_to_reload(input);
            self
        }
        /// <p>The name and schema of the table to be reloaded. </p>
        pub fn set_tables_to_reload(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableToReload>>,
        ) -> Self {
            self.inner = self.inner.set_tables_to_reload(input);
            self
        }
        /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is enabled for the task. </p>
        /// <p>Valid values: data-reload, validate-only</p>
        /// <p>Default value is data-reload.</p>
        pub fn reload_option(mut self, input: crate::model::ReloadOptionValue) -> Self {
            self.inner = self.inner.reload_option(input);
            self
        }
        /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is enabled for the task. </p>
        /// <p>Valid values: data-reload, validate-only</p>
        /// <p>Default value is data-reload.</p>
        pub fn set_reload_option(
            mut self,
            input: std::option::Option<crate::model::ReloadOptionValue>,
        ) -> Self {
            self.inner = self.inner.set_reload_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes metadata tags from an DMS resource, including replication instance, endpoint, security group, and migration task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type description.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl RemoveTagsFromResource {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplicationTask`.
    ///
    /// <p>Starts the replication task.</p>
    /// <p>For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the <i>Database Migration Service User Guide.</i> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartReplicationTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_replication_task_input::Builder,
    }
    impl StartReplicationTask {
        /// Creates a new `StartReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>The type of replication task to start.</p>
        /// <p>When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart the task and <code>resume-processing</code> to resume the task.</p>
        /// <p>When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value for a task with migration type of <code>cdc</code>.</p>
        pub fn start_replication_task_type(
            mut self,
            input: crate::model::StartReplicationTaskTypeValue,
        ) -> Self {
            self.inner = self.inner.start_replication_task_type(input);
            self
        }
        /// <p>The type of replication task to start.</p>
        /// <p>When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart the task and <code>resume-processing</code> to resume the task.</p>
        /// <p>When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value for a task with migration type of <code>cdc</code>.</p>
        pub fn set_start_replication_task_type(
            mut self,
            input: std::option::Option<crate::model::StartReplicationTaskTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_start_replication_task_type(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.cdc_start_time(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_time(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_start_position(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_position(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_stop_position(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_stop_position(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplicationTaskAssessment`.
    ///
    /// <p> Starts the replication task assessment for unsupported data types in the source database. </p>
    /// <p>You can only use this operation for a task if the following conditions are true:</p>
    /// <ul>
    /// <li> <p>The task must be in the <code>stopped</code> state.</p> </li>
    /// <li> <p>The task must have successful connections to the source and target.</p> </li>
    /// </ul>
    /// <p>If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result. </p>
    /// <p>For information about DMS task assessments, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report</a> in the <i>Database Migration Service User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartReplicationTaskAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_replication_task_assessment_input::Builder,
    }
    impl StartReplicationTaskAssessment {
        /// Creates a new `StartReplicationTaskAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationTaskAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplicationTaskAssessmentRun`.
    ///
    /// <p>Starts a new premigration assessment run for one or more individual assessments of a migration task.</p>
    /// <p>The assessments that you can specify depend on the source and target database engine and the migration type defined for the given task. To run this operation, your migration task must already be created. After you run this operation, you can review the status of each individual assessment. You can also run the migration task manually after the assessment run and its individual assessments complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartReplicationTaskAssessmentRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_replication_task_assessment_run_input::Builder,
    }
    impl StartReplicationTaskAssessmentRun {
        /// Creates a new `StartReplicationTaskAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationTaskAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskAssessmentRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you want to start.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you want to start.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_access_role_arn(input.into());
            self
        }
        /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_access_role_arn(input);
            self
        }
        /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>
        pub fn result_location_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_location_bucket(input.into());
            self
        }
        /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>
        pub fn set_result_location_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_location_bucket(input);
            self
        }
        /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>
        pub fn result_location_folder(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_location_folder(input.into());
            self
        }
        /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>
        pub fn set_result_location_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_location_folder(input);
            self
        }
        /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If you don't specify this request parameter, DMS stores the assessment run results without encryption. You can specify one of the options following:</p>
        /// <ul>
        /// <li> <p> <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.</p> </li>
        /// <li> <p> <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom KMS encryption key that you specify or the default KMS encryption key that DMS provides.</p> </li>
        /// </ul>
        pub fn result_encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_encryption_mode(input.into());
            self
        }
        /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If you don't specify this request parameter, DMS stores the assessment run results without encryption. You can specify one of the options following:</p>
        /// <ul>
        /// <li> <p> <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.</p> </li>
        /// <li> <p> <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom KMS encryption key that you specify or the default KMS encryption key that DMS provides.</p> </li>
        /// </ul>
        pub fn set_result_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_encryption_mode(input);
            self
        }
        /// <p>ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
        pub fn result_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_kms_key_arn(input.into());
            self
        }
        /// <p>ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
        pub fn set_result_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_kms_key_arn(input);
            self
        }
        /// <p>Unique name to identify the assessment run.</p>
        pub fn assessment_run_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_name(input.into());
            self
        }
        /// <p>Unique name to identify the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_name(input);
            self
        }
        /// Appends an item to `IncludeOnly`.
        ///
        /// To override the contents of this collection use [`set_include_only`](Self::set_include_only).
        ///
        /// <p>Space-separated list of names for specific individual assessments that you want to include. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
        /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the API operation. </p>
        /// <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn include_only(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_only(input.into());
            self
        }
        /// <p>Space-separated list of names for specific individual assessments that you want to include. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
        /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the API operation. </p>
        /// <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn set_include_only(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_include_only(input);
            self
        }
        /// Appends an item to `Exclude`.
        ///
        /// To override the contents of this collection use [`set_exclude`](Self::set_exclude).
        ///
        /// <p>Space-separated list of names for specific individual assessments that you want to exclude. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
        /// <p>You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the API operation.</p>
        /// <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn exclude(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclude(input.into());
            self
        }
        /// <p>Space-separated list of names for specific individual assessments that you want to exclude. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note>
        /// <p>You can't set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the API operation.</p>
        /// <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn set_exclude(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exclude(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopReplicationTask`.
    ///
    /// <p>Stops the replication task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopReplicationTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_replication_task_input::Builder,
    }
    impl StopReplicationTask {
        /// Creates a new `StopReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StopReplicationTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestConnection`.
    ///
    /// <p>Tests the connection between the replication instance and the endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestConnection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_connection_input::Builder,
    }
    impl TestConnection {
        /// Creates a new `TestConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::TestConnectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
