// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `ApplyPendingMaintenanceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_pending_maintenance_action`](crate::client::Client::apply_pending_maintenance_action).
///
/// See [`crate::client::fluent_builders::ApplyPendingMaintenanceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplyPendingMaintenanceAction {
    _private: (),
}
impl ApplyPendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
    /// Creates a new `ApplyPendingMaintenanceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplyPendingMaintenanceAction {
    type Output = std::result::Result<
        crate::output::ApplyPendingMaintenanceActionOutput,
        crate::error::ApplyPendingMaintenanceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_pending_maintenance_action_error(response)
        } else {
            crate::operation_deser::parse_apply_pending_maintenance_action_response(response)
        }
    }
}

/// Operation shape for `CancelReplicationTaskAssessmentRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_replication_task_assessment_run`](crate::client::Client::cancel_replication_task_assessment_run).
///
/// See [`crate::client::fluent_builders::CancelReplicationTaskAssessmentRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelReplicationTaskAssessmentRun {
    _private: (),
}
impl CancelReplicationTaskAssessmentRun {
    /// Creates a new builder-style object to manufacture [`CancelReplicationTaskAssessmentRunInput`](crate::input::CancelReplicationTaskAssessmentRunInput)
    pub fn builder() -> crate::input::cancel_replication_task_assessment_run_input::Builder {
        crate::input::cancel_replication_task_assessment_run_input::Builder::default()
    }
    /// Creates a new `CancelReplicationTaskAssessmentRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelReplicationTaskAssessmentRun {
    type Output = std::result::Result<
        crate::output::CancelReplicationTaskAssessmentRunOutput,
        crate::error::CancelReplicationTaskAssessmentRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_replication_task_assessment_run_error(response)
        } else {
            crate::operation_deser::parse_cancel_replication_task_assessment_run_response(response)
        }
    }
}

/// Operation shape for `CreateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint`](crate::client::Client::create_endpoint).
///
/// See [`crate::client::fluent_builders::CreateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpoint {
    _private: (),
}
impl CreateEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpoint {
    type Output =
        std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_subscription`](crate::client::Client::create_event_subscription).
///
/// See [`crate::client::fluent_builders::CreateEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventSubscription {
    _private: (),
}
impl CreateEventSubscription {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
    /// Creates a new `CreateEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventSubscription {
    type Output = std::result::Result<
        crate::output::CreateEventSubscriptionOutput,
        crate::error::CreateEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_event_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateReplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_instance`](crate::client::Client::create_replication_instance).
///
/// See [`crate::client::fluent_builders::CreateReplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationInstance {
    _private: (),
}
impl CreateReplicationInstance {
    /// Creates a new builder-style object to manufacture [`CreateReplicationInstanceInput`](crate::input::CreateReplicationInstanceInput)
    pub fn builder() -> crate::input::create_replication_instance_input::Builder {
        crate::input::create_replication_instance_input::Builder::default()
    }
    /// Creates a new `CreateReplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationInstance {
    type Output = std::result::Result<
        crate::output::CreateReplicationInstanceOutput,
        crate::error::CreateReplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replication_instance_error(response)
        } else {
            crate::operation_deser::parse_create_replication_instance_response(response)
        }
    }
}

/// Operation shape for `CreateReplicationSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_subnet_group`](crate::client::Client::create_replication_subnet_group).
///
/// See [`crate::client::fluent_builders::CreateReplicationSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationSubnetGroup {
    _private: (),
}
impl CreateReplicationSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CreateReplicationSubnetGroupInput`](crate::input::CreateReplicationSubnetGroupInput)
    pub fn builder() -> crate::input::create_replication_subnet_group_input::Builder {
        crate::input::create_replication_subnet_group_input::Builder::default()
    }
    /// Creates a new `CreateReplicationSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationSubnetGroup {
    type Output = std::result::Result<
        crate::output::CreateReplicationSubnetGroupOutput,
        crate::error::CreateReplicationSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replication_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_create_replication_subnet_group_response(response)
        }
    }
}

/// Operation shape for `CreateReplicationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_task`](crate::client::Client::create_replication_task).
///
/// See [`crate::client::fluent_builders::CreateReplicationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationTask {
    _private: (),
}
impl CreateReplicationTask {
    /// Creates a new builder-style object to manufacture [`CreateReplicationTaskInput`](crate::input::CreateReplicationTaskInput)
    pub fn builder() -> crate::input::create_replication_task_input::Builder {
        crate::input::create_replication_task_input::Builder::default()
    }
    /// Creates a new `CreateReplicationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationTask {
    type Output = std::result::Result<
        crate::output::CreateReplicationTaskOutput,
        crate::error::CreateReplicationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replication_task_error(response)
        } else {
            crate::operation_deser::parse_create_replication_task_response(response)
        }
    }
}

/// Operation shape for `DeleteCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_certificate`](crate::client::Client::delete_certificate).
///
/// See [`crate::client::fluent_builders::DeleteCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCertificate {
    _private: (),
}
impl DeleteCertificate {
    /// Creates a new builder-style object to manufacture [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    pub fn builder() -> crate::input::delete_certificate_input::Builder {
        crate::input::delete_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCertificate {
    type Output = std::result::Result<
        crate::output::DeleteCertificateOutput,
        crate::error::DeleteCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint`](crate::client::Client::delete_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpoint {
    _private: (),
}
impl DeleteEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpoint {
    type Output =
        std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_subscription`](crate::client::Client::delete_event_subscription).
///
/// See [`crate::client::fluent_builders::DeleteEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventSubscription {
    _private: (),
}
impl DeleteEventSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventSubscription {
    type Output = std::result::Result<
        crate::output::DeleteEventSubscriptionOutput,
        crate::error::DeleteEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_event_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_instance`](crate::client::Client::delete_replication_instance).
///
/// See [`crate::client::fluent_builders::DeleteReplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationInstance {
    _private: (),
}
impl DeleteReplicationInstance {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationInstanceInput`](crate::input::DeleteReplicationInstanceInput)
    pub fn builder() -> crate::input::delete_replication_instance_input::Builder {
        crate::input::delete_replication_instance_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationInstance {
    type Output = std::result::Result<
        crate::output::DeleteReplicationInstanceOutput,
        crate::error::DeleteReplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_replication_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_subnet_group`](crate::client::Client::delete_replication_subnet_group).
///
/// See [`crate::client::fluent_builders::DeleteReplicationSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationSubnetGroup {
    _private: (),
}
impl DeleteReplicationSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationSubnetGroupInput`](crate::input::DeleteReplicationSubnetGroupInput)
    pub fn builder() -> crate::input::delete_replication_subnet_group_input::Builder {
        crate::input::delete_replication_subnet_group_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationSubnetGroup {
    type Output = std::result::Result<
        crate::output::DeleteReplicationSubnetGroupOutput,
        crate::error::DeleteReplicationSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_replication_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_subnet_group_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_task`](crate::client::Client::delete_replication_task).
///
/// See [`crate::client::fluent_builders::DeleteReplicationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationTask {
    _private: (),
}
impl DeleteReplicationTask {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationTaskInput`](crate::input::DeleteReplicationTaskInput)
    pub fn builder() -> crate::input::delete_replication_task_input::Builder {
        crate::input::delete_replication_task_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationTask {
    type Output = std::result::Result<
        crate::output::DeleteReplicationTaskOutput,
        crate::error::DeleteReplicationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_replication_task_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_task_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationTaskAssessmentRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_task_assessment_run`](crate::client::Client::delete_replication_task_assessment_run).
///
/// See [`crate::client::fluent_builders::DeleteReplicationTaskAssessmentRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationTaskAssessmentRun {
    _private: (),
}
impl DeleteReplicationTaskAssessmentRun {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationTaskAssessmentRunInput`](crate::input::DeleteReplicationTaskAssessmentRunInput)
    pub fn builder() -> crate::input::delete_replication_task_assessment_run_input::Builder {
        crate::input::delete_replication_task_assessment_run_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationTaskAssessmentRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationTaskAssessmentRun {
    type Output = std::result::Result<
        crate::output::DeleteReplicationTaskAssessmentRunOutput,
        crate::error::DeleteReplicationTaskAssessmentRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_replication_task_assessment_run_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_task_assessment_run_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_attributes`](crate::client::Client::describe_account_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAccountAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAttributes {
    _private: (),
}
impl DescribeAccountAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAccountAttributesOutput,
        crate::error::DescribeAccountAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_account_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeApplicableIndividualAssessments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_applicable_individual_assessments`](crate::client::Client::describe_applicable_individual_assessments).
///
/// See [`crate::client::fluent_builders::DescribeApplicableIndividualAssessments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApplicableIndividualAssessments {
    _private: (),
}
impl DescribeApplicableIndividualAssessments {
    /// Creates a new builder-style object to manufacture [`DescribeApplicableIndividualAssessmentsInput`](crate::input::DescribeApplicableIndividualAssessmentsInput)
    pub fn builder() -> crate::input::describe_applicable_individual_assessments_input::Builder {
        crate::input::describe_applicable_individual_assessments_input::Builder::default()
    }
    /// Creates a new `DescribeApplicableIndividualAssessments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApplicableIndividualAssessments {
    type Output = std::result::Result<
        crate::output::DescribeApplicableIndividualAssessmentsOutput,
        crate::error::DescribeApplicableIndividualAssessmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_applicable_individual_assessments_error(response)
        } else {
            crate::operation_deser::parse_describe_applicable_individual_assessments_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_certificates`](crate::client::Client::describe_certificates).
///
/// See [`crate::client::fluent_builders::DescribeCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCertificates {
    _private: (),
}
impl DescribeCertificates {
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    pub fn builder() -> crate::input::describe_certificates_input::Builder {
        crate::input::describe_certificates_input::Builder::default()
    }
    /// Creates a new `DescribeCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCertificates {
    type Output = std::result::Result<
        crate::output::DescribeCertificatesOutput,
        crate::error::DescribeCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_certificates_error(response)
        } else {
            crate::operation_deser::parse_describe_certificates_response(response)
        }
    }
}

/// Operation shape for `DescribeConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_connections`](crate::client::Client::describe_connections).
///
/// See [`crate::client::fluent_builders::DescribeConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConnections {
    _private: (),
}
impl DescribeConnections {
    /// Creates a new builder-style object to manufacture [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
    pub fn builder() -> crate::input::describe_connections_input::Builder {
        crate::input::describe_connections_input::Builder::default()
    }
    /// Creates a new `DescribeConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConnections {
    type Output = std::result::Result<
        crate::output::DescribeConnectionsOutput,
        crate::error::DescribeConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_connections_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoints`](crate::client::Client::describe_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoints {
    _private: (),
}
impl DescribeEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    pub fn builder() -> crate::input::describe_endpoints_input::Builder {
        crate::input::describe_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeEndpointsOutput,
        crate::error::DescribeEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoints_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpointSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint_settings`](crate::client::Client::describe_endpoint_settings).
///
/// See [`crate::client::fluent_builders::DescribeEndpointSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpointSettings {
    _private: (),
}
impl DescribeEndpointSettings {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointSettingsInput`](crate::input::DescribeEndpointSettingsInput)
    pub fn builder() -> crate::input::describe_endpoint_settings_input::Builder {
        crate::input::describe_endpoint_settings_input::Builder::default()
    }
    /// Creates a new `DescribeEndpointSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpointSettings {
    type Output = std::result::Result<
        crate::output::DescribeEndpointSettingsOutput,
        crate::error::DescribeEndpointSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpointTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint_types`](crate::client::Client::describe_endpoint_types).
///
/// See [`crate::client::fluent_builders::DescribeEndpointTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpointTypes {
    _private: (),
}
impl DescribeEndpointTypes {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointTypesInput`](crate::input::DescribeEndpointTypesInput)
    pub fn builder() -> crate::input::describe_endpoint_types_input::Builder {
        crate::input::describe_endpoint_types_input::Builder::default()
    }
    /// Creates a new `DescribeEndpointTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpointTypes {
    type Output = std::result::Result<
        crate::output::DescribeEndpointTypesOutput,
        crate::error::DescribeEndpointTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_types_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_types_response(response)
        }
    }
}

/// Operation shape for `DescribeEventCategories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_categories`](crate::client::Client::describe_event_categories).
///
/// See [`crate::client::fluent_builders::DescribeEventCategories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventCategories {
    _private: (),
}
impl DescribeEventCategories {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
    /// Creates a new `DescribeEventCategories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventCategories {
    type Output = std::result::Result<
        crate::output::DescribeEventCategoriesOutput,
        crate::error::DescribeEventCategoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_categories_error(response)
        } else {
            crate::operation_deser::parse_describe_event_categories_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeEventSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_subscriptions`](crate::client::Client::describe_event_subscriptions).
///
/// See [`crate::client::fluent_builders::DescribeEventSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventSubscriptions {
    _private: (),
}
impl DescribeEventSubscriptions {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
    /// Creates a new `DescribeEventSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventSubscriptions {
    type Output = std::result::Result<
        crate::output::DescribeEventSubscriptionsOutput,
        crate::error::DescribeEventSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_describe_event_subscriptions_response(response)
        }
    }
}

/// Operation shape for `DescribeOrderableReplicationInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_orderable_replication_instances`](crate::client::Client::describe_orderable_replication_instances).
///
/// See [`crate::client::fluent_builders::DescribeOrderableReplicationInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrderableReplicationInstances {
    _private: (),
}
impl DescribeOrderableReplicationInstances {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableReplicationInstancesInput`](crate::input::DescribeOrderableReplicationInstancesInput)
    pub fn builder() -> crate::input::describe_orderable_replication_instances_input::Builder {
        crate::input::describe_orderable_replication_instances_input::Builder::default()
    }
    /// Creates a new `DescribeOrderableReplicationInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrderableReplicationInstances {
    type Output = std::result::Result<
        crate::output::DescribeOrderableReplicationInstancesOutput,
        crate::error::DescribeOrderableReplicationInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_orderable_replication_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_orderable_replication_instances_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribePendingMaintenanceActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pending_maintenance_actions`](crate::client::Client::describe_pending_maintenance_actions).
///
/// See [`crate::client::fluent_builders::DescribePendingMaintenanceActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePendingMaintenanceActions {
    _private: (),
}
impl DescribePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    pub fn builder() -> crate::input::describe_pending_maintenance_actions_input::Builder {
        crate::input::describe_pending_maintenance_actions_input::Builder::default()
    }
    /// Creates a new `DescribePendingMaintenanceActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePendingMaintenanceActions {
    type Output = std::result::Result<
        crate::output::DescribePendingMaintenanceActionsOutput,
        crate::error::DescribePendingMaintenanceActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pending_maintenance_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_pending_maintenance_actions_response(response)
        }
    }
}

/// Operation shape for `DescribeRefreshSchemasStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_refresh_schemas_status`](crate::client::Client::describe_refresh_schemas_status).
///
/// See [`crate::client::fluent_builders::DescribeRefreshSchemasStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRefreshSchemasStatus {
    _private: (),
}
impl DescribeRefreshSchemasStatus {
    /// Creates a new builder-style object to manufacture [`DescribeRefreshSchemasStatusInput`](crate::input::DescribeRefreshSchemasStatusInput)
    pub fn builder() -> crate::input::describe_refresh_schemas_status_input::Builder {
        crate::input::describe_refresh_schemas_status_input::Builder::default()
    }
    /// Creates a new `DescribeRefreshSchemasStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRefreshSchemasStatus {
    type Output = std::result::Result<
        crate::output::DescribeRefreshSchemasStatusOutput,
        crate::error::DescribeRefreshSchemasStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_refresh_schemas_status_error(response)
        } else {
            crate::operation_deser::parse_describe_refresh_schemas_status_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_instances`](crate::client::Client::describe_replication_instances).
///
/// See [`crate::client::fluent_builders::DescribeReplicationInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationInstances {
    _private: (),
}
impl DescribeReplicationInstances {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationInstancesInput`](crate::input::DescribeReplicationInstancesInput)
    pub fn builder() -> crate::input::describe_replication_instances_input::Builder {
        crate::input::describe_replication_instances_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationInstances {
    type Output = std::result::Result<
        crate::output::DescribeReplicationInstancesOutput,
        crate::error::DescribeReplicationInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationInstanceTaskLogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_instance_task_logs`](crate::client::Client::describe_replication_instance_task_logs).
///
/// See [`crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationInstanceTaskLogs {
    _private: (),
}
impl DescribeReplicationInstanceTaskLogs {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationInstanceTaskLogsInput`](crate::input::DescribeReplicationInstanceTaskLogsInput)
    pub fn builder() -> crate::input::describe_replication_instance_task_logs_input::Builder {
        crate::input::describe_replication_instance_task_logs_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationInstanceTaskLogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationInstanceTaskLogs {
    type Output = std::result::Result<
        crate::output::DescribeReplicationInstanceTaskLogsOutput,
        crate::error::DescribeReplicationInstanceTaskLogsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_instance_task_logs_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_instance_task_logs_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationSubnetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_subnet_groups`](crate::client::Client::describe_replication_subnet_groups).
///
/// See [`crate::client::fluent_builders::DescribeReplicationSubnetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationSubnetGroups {
    _private: (),
}
impl DescribeReplicationSubnetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationSubnetGroupsInput`](crate::input::DescribeReplicationSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_replication_subnet_groups_input::Builder {
        crate::input::describe_replication_subnet_groups_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationSubnetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationSubnetGroups {
    type Output = std::result::Result<
        crate::output::DescribeReplicationSubnetGroupsOutput,
        crate::error::DescribeReplicationSubnetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_subnet_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_subnet_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationTaskAssessmentResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_task_assessment_results`](crate::client::Client::describe_replication_task_assessment_results).
///
/// See [`crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationTaskAssessmentResults {
    _private: (),
}
impl DescribeReplicationTaskAssessmentResults {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTaskAssessmentResultsInput`](crate::input::DescribeReplicationTaskAssessmentResultsInput)
    pub fn builder() -> crate::input::describe_replication_task_assessment_results_input::Builder {
        crate::input::describe_replication_task_assessment_results_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationTaskAssessmentResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationTaskAssessmentResults {
    type Output = std::result::Result<
        crate::output::DescribeReplicationTaskAssessmentResultsOutput,
        crate::error::DescribeReplicationTaskAssessmentResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_task_assessment_results_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_replication_task_assessment_results_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeReplicationTaskAssessmentRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_task_assessment_runs`](crate::client::Client::describe_replication_task_assessment_runs).
///
/// See [`crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationTaskAssessmentRuns {
    _private: (),
}
impl DescribeReplicationTaskAssessmentRuns {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTaskAssessmentRunsInput`](crate::input::DescribeReplicationTaskAssessmentRunsInput)
    pub fn builder() -> crate::input::describe_replication_task_assessment_runs_input::Builder {
        crate::input::describe_replication_task_assessment_runs_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationTaskAssessmentRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationTaskAssessmentRuns {
    type Output = std::result::Result<
        crate::output::DescribeReplicationTaskAssessmentRunsOutput,
        crate::error::DescribeReplicationTaskAssessmentRunsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_task_assessment_runs_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_task_assessment_runs_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeReplicationTaskIndividualAssessments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_task_individual_assessments`](crate::client::Client::describe_replication_task_individual_assessments).
///
/// See [`crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationTaskIndividualAssessments {
    _private: (),
}
impl DescribeReplicationTaskIndividualAssessments {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTaskIndividualAssessmentsInput`](crate::input::DescribeReplicationTaskIndividualAssessmentsInput)
    pub fn builder() -> crate::input::describe_replication_task_individual_assessments_input::Builder
    {
        crate::input::describe_replication_task_individual_assessments_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationTaskIndividualAssessments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeReplicationTaskIndividualAssessments
{
    type Output = std::result::Result<
        crate::output::DescribeReplicationTaskIndividualAssessmentsOutput,
        crate::error::DescribeReplicationTaskIndividualAssessmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_task_individual_assessments_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_replication_task_individual_assessments_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeReplicationTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_tasks`](crate::client::Client::describe_replication_tasks).
///
/// See [`crate::client::fluent_builders::DescribeReplicationTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationTasks {
    _private: (),
}
impl DescribeReplicationTasks {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTasksInput`](crate::input::DescribeReplicationTasksInput)
    pub fn builder() -> crate::input::describe_replication_tasks_input::Builder {
        crate::input::describe_replication_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationTasks {
    type Output = std::result::Result<
        crate::output::DescribeReplicationTasksOutput,
        crate::error::DescribeReplicationTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeSchemas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_schemas`](crate::client::Client::describe_schemas).
///
/// See [`crate::client::fluent_builders::DescribeSchemas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSchemas {
    _private: (),
}
impl DescribeSchemas {
    /// Creates a new builder-style object to manufacture [`DescribeSchemasInput`](crate::input::DescribeSchemasInput)
    pub fn builder() -> crate::input::describe_schemas_input::Builder {
        crate::input::describe_schemas_input::Builder::default()
    }
    /// Creates a new `DescribeSchemas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSchemas {
    type Output = std::result::Result<
        crate::output::DescribeSchemasOutput,
        crate::error::DescribeSchemasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_schemas_error(response)
        } else {
            crate::operation_deser::parse_describe_schemas_response(response)
        }
    }
}

/// Operation shape for `DescribeTableStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_table_statistics`](crate::client::Client::describe_table_statistics).
///
/// See [`crate::client::fluent_builders::DescribeTableStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTableStatistics {
    _private: (),
}
impl DescribeTableStatistics {
    /// Creates a new builder-style object to manufacture [`DescribeTableStatisticsInput`](crate::input::DescribeTableStatisticsInput)
    pub fn builder() -> crate::input::describe_table_statistics_input::Builder {
        crate::input::describe_table_statistics_input::Builder::default()
    }
    /// Creates a new `DescribeTableStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTableStatistics {
    type Output = std::result::Result<
        crate::output::DescribeTableStatisticsOutput,
        crate::error::DescribeTableStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_table_statistics_error(response)
        } else {
            crate::operation_deser::parse_describe_table_statistics_response(response)
        }
    }
}

/// Operation shape for `ImportCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_certificate`](crate::client::Client::import_certificate).
///
/// See [`crate::client::fluent_builders::ImportCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportCertificate {
    _private: (),
}
impl ImportCertificate {
    /// Creates a new builder-style object to manufacture [`ImportCertificateInput`](crate::input::ImportCertificateInput)
    pub fn builder() -> crate::input::import_certificate_input::Builder {
        crate::input::import_certificate_input::Builder::default()
    }
    /// Creates a new `ImportCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportCertificate {
    type Output = std::result::Result<
        crate::output::ImportCertificateOutput,
        crate::error::ImportCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_certificate_error(response)
        } else {
            crate::operation_deser::parse_import_certificate_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ModifyEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_endpoint`](crate::client::Client::modify_endpoint).
///
/// See [`crate::client::fluent_builders::ModifyEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEndpoint {
    _private: (),
}
impl ModifyEndpoint {
    /// Creates a new builder-style object to manufacture [`ModifyEndpointInput`](crate::input::ModifyEndpointInput)
    pub fn builder() -> crate::input::modify_endpoint_input::Builder {
        crate::input::modify_endpoint_input::Builder::default()
    }
    /// Creates a new `ModifyEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEndpoint {
    type Output =
        std::result::Result<crate::output::ModifyEndpointOutput, crate::error::ModifyEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_endpoint_error(response)
        } else {
            crate::operation_deser::parse_modify_endpoint_response(response)
        }
    }
}

/// Operation shape for `ModifyEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_event_subscription`](crate::client::Client::modify_event_subscription).
///
/// See [`crate::client::fluent_builders::ModifyEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEventSubscription {
    _private: (),
}
impl ModifyEventSubscription {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
    /// Creates a new `ModifyEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEventSubscription {
    type Output = std::result::Result<
        crate::output::ModifyEventSubscriptionOutput,
        crate::error::ModifyEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_modify_event_subscription_response(response)
        }
    }
}

/// Operation shape for `ModifyReplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_replication_instance`](crate::client::Client::modify_replication_instance).
///
/// See [`crate::client::fluent_builders::ModifyReplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyReplicationInstance {
    _private: (),
}
impl ModifyReplicationInstance {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationInstanceInput`](crate::input::ModifyReplicationInstanceInput)
    pub fn builder() -> crate::input::modify_replication_instance_input::Builder {
        crate::input::modify_replication_instance_input::Builder::default()
    }
    /// Creates a new `ModifyReplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyReplicationInstance {
    type Output = std::result::Result<
        crate::output::ModifyReplicationInstanceOutput,
        crate::error::ModifyReplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_replication_instance_error(response)
        } else {
            crate::operation_deser::parse_modify_replication_instance_response(response)
        }
    }
}

/// Operation shape for `ModifyReplicationSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_replication_subnet_group`](crate::client::Client::modify_replication_subnet_group).
///
/// See [`crate::client::fluent_builders::ModifyReplicationSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyReplicationSubnetGroup {
    _private: (),
}
impl ModifyReplicationSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationSubnetGroupInput`](crate::input::ModifyReplicationSubnetGroupInput)
    pub fn builder() -> crate::input::modify_replication_subnet_group_input::Builder {
        crate::input::modify_replication_subnet_group_input::Builder::default()
    }
    /// Creates a new `ModifyReplicationSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyReplicationSubnetGroup {
    type Output = std::result::Result<
        crate::output::ModifyReplicationSubnetGroupOutput,
        crate::error::ModifyReplicationSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_replication_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_modify_replication_subnet_group_response(response)
        }
    }
}

/// Operation shape for `ModifyReplicationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_replication_task`](crate::client::Client::modify_replication_task).
///
/// See [`crate::client::fluent_builders::ModifyReplicationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyReplicationTask {
    _private: (),
}
impl ModifyReplicationTask {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationTaskInput`](crate::input::ModifyReplicationTaskInput)
    pub fn builder() -> crate::input::modify_replication_task_input::Builder {
        crate::input::modify_replication_task_input::Builder::default()
    }
    /// Creates a new `ModifyReplicationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyReplicationTask {
    type Output = std::result::Result<
        crate::output::ModifyReplicationTaskOutput,
        crate::error::ModifyReplicationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_replication_task_error(response)
        } else {
            crate::operation_deser::parse_modify_replication_task_response(response)
        }
    }
}

/// Operation shape for `MoveReplicationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`move_replication_task`](crate::client::Client::move_replication_task).
///
/// See [`crate::client::fluent_builders::MoveReplicationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MoveReplicationTask {
    _private: (),
}
impl MoveReplicationTask {
    /// Creates a new builder-style object to manufacture [`MoveReplicationTaskInput`](crate::input::MoveReplicationTaskInput)
    pub fn builder() -> crate::input::move_replication_task_input::Builder {
        crate::input::move_replication_task_input::Builder::default()
    }
    /// Creates a new `MoveReplicationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MoveReplicationTask {
    type Output = std::result::Result<
        crate::output::MoveReplicationTaskOutput,
        crate::error::MoveReplicationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_move_replication_task_error(response)
        } else {
            crate::operation_deser::parse_move_replication_task_response(response)
        }
    }
}

/// Operation shape for `RebootReplicationInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_replication_instance`](crate::client::Client::reboot_replication_instance).
///
/// See [`crate::client::fluent_builders::RebootReplicationInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootReplicationInstance {
    _private: (),
}
impl RebootReplicationInstance {
    /// Creates a new builder-style object to manufacture [`RebootReplicationInstanceInput`](crate::input::RebootReplicationInstanceInput)
    pub fn builder() -> crate::input::reboot_replication_instance_input::Builder {
        crate::input::reboot_replication_instance_input::Builder::default()
    }
    /// Creates a new `RebootReplicationInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootReplicationInstance {
    type Output = std::result::Result<
        crate::output::RebootReplicationInstanceOutput,
        crate::error::RebootReplicationInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_replication_instance_error(response)
        } else {
            crate::operation_deser::parse_reboot_replication_instance_response(response)
        }
    }
}

/// Operation shape for `RefreshSchemas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`refresh_schemas`](crate::client::Client::refresh_schemas).
///
/// See [`crate::client::fluent_builders::RefreshSchemas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RefreshSchemas {
    _private: (),
}
impl RefreshSchemas {
    /// Creates a new builder-style object to manufacture [`RefreshSchemasInput`](crate::input::RefreshSchemasInput)
    pub fn builder() -> crate::input::refresh_schemas_input::Builder {
        crate::input::refresh_schemas_input::Builder::default()
    }
    /// Creates a new `RefreshSchemas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RefreshSchemas {
    type Output =
        std::result::Result<crate::output::RefreshSchemasOutput, crate::error::RefreshSchemasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_refresh_schemas_error(response)
        } else {
            crate::operation_deser::parse_refresh_schemas_response(response)
        }
    }
}

/// Operation shape for `ReloadTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reload_tables`](crate::client::Client::reload_tables).
///
/// See [`crate::client::fluent_builders::ReloadTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReloadTables {
    _private: (),
}
impl ReloadTables {
    /// Creates a new builder-style object to manufacture [`ReloadTablesInput`](crate::input::ReloadTablesInput)
    pub fn builder() -> crate::input::reload_tables_input::Builder {
        crate::input::reload_tables_input::Builder::default()
    }
    /// Creates a new `ReloadTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReloadTables {
    type Output =
        std::result::Result<crate::output::ReloadTablesOutput, crate::error::ReloadTablesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reload_tables_error(response)
        } else {
            crate::operation_deser::parse_reload_tables_response(response)
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `StartReplicationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_replication_task`](crate::client::Client::start_replication_task).
///
/// See [`crate::client::fluent_builders::StartReplicationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartReplicationTask {
    _private: (),
}
impl StartReplicationTask {
    /// Creates a new builder-style object to manufacture [`StartReplicationTaskInput`](crate::input::StartReplicationTaskInput)
    pub fn builder() -> crate::input::start_replication_task_input::Builder {
        crate::input::start_replication_task_input::Builder::default()
    }
    /// Creates a new `StartReplicationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartReplicationTask {
    type Output = std::result::Result<
        crate::output::StartReplicationTaskOutput,
        crate::error::StartReplicationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_replication_task_error(response)
        } else {
            crate::operation_deser::parse_start_replication_task_response(response)
        }
    }
}

/// Operation shape for `StartReplicationTaskAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_replication_task_assessment`](crate::client::Client::start_replication_task_assessment).
///
/// See [`crate::client::fluent_builders::StartReplicationTaskAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartReplicationTaskAssessment {
    _private: (),
}
impl StartReplicationTaskAssessment {
    /// Creates a new builder-style object to manufacture [`StartReplicationTaskAssessmentInput`](crate::input::StartReplicationTaskAssessmentInput)
    pub fn builder() -> crate::input::start_replication_task_assessment_input::Builder {
        crate::input::start_replication_task_assessment_input::Builder::default()
    }
    /// Creates a new `StartReplicationTaskAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartReplicationTaskAssessment {
    type Output = std::result::Result<
        crate::output::StartReplicationTaskAssessmentOutput,
        crate::error::StartReplicationTaskAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_replication_task_assessment_error(response)
        } else {
            crate::operation_deser::parse_start_replication_task_assessment_response(response)
        }
    }
}

/// Operation shape for `StartReplicationTaskAssessmentRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_replication_task_assessment_run`](crate::client::Client::start_replication_task_assessment_run).
///
/// See [`crate::client::fluent_builders::StartReplicationTaskAssessmentRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartReplicationTaskAssessmentRun {
    _private: (),
}
impl StartReplicationTaskAssessmentRun {
    /// Creates a new builder-style object to manufacture [`StartReplicationTaskAssessmentRunInput`](crate::input::StartReplicationTaskAssessmentRunInput)
    pub fn builder() -> crate::input::start_replication_task_assessment_run_input::Builder {
        crate::input::start_replication_task_assessment_run_input::Builder::default()
    }
    /// Creates a new `StartReplicationTaskAssessmentRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartReplicationTaskAssessmentRun {
    type Output = std::result::Result<
        crate::output::StartReplicationTaskAssessmentRunOutput,
        crate::error::StartReplicationTaskAssessmentRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_replication_task_assessment_run_error(response)
        } else {
            crate::operation_deser::parse_start_replication_task_assessment_run_response(response)
        }
    }
}

/// Operation shape for `StopReplicationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_replication_task`](crate::client::Client::stop_replication_task).
///
/// See [`crate::client::fluent_builders::StopReplicationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopReplicationTask {
    _private: (),
}
impl StopReplicationTask {
    /// Creates a new builder-style object to manufacture [`StopReplicationTaskInput`](crate::input::StopReplicationTaskInput)
    pub fn builder() -> crate::input::stop_replication_task_input::Builder {
        crate::input::stop_replication_task_input::Builder::default()
    }
    /// Creates a new `StopReplicationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopReplicationTask {
    type Output = std::result::Result<
        crate::output::StopReplicationTaskOutput,
        crate::error::StopReplicationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_replication_task_error(response)
        } else {
            crate::operation_deser::parse_stop_replication_task_response(response)
        }
    }
}

/// Operation shape for `TestConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_connection`](crate::client::Client::test_connection).
///
/// See [`crate::client::fluent_builders::TestConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestConnection {
    _private: (),
}
impl TestConnection {
    /// Creates a new builder-style object to manufacture [`TestConnectionInput`](crate::input::TestConnectionInput)
    pub fn builder() -> crate::input::test_connection_input::Builder {
        crate::input::test_connection_input::Builder::default()
    }
    /// Creates a new `TestConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestConnection {
    type Output =
        std::result::Result<crate::output::TestConnectionOutput, crate::error::TestConnectionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_connection_error(response)
        } else {
            crate::operation_deser::parse_test_connection_response(response)
        }
    }
}
