// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsToResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsToResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_to_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_pending_maintenance_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplyPendingMaintenanceActionOutput,
    crate::error::ApplyPendingMaintenanceActionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ApplyPendingMaintenanceActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::ApplyPendingMaintenanceActionError {
            meta: generic,
            kind: crate::error::ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ApplyPendingMaintenanceActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_pending_maintenance_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplyPendingMaintenanceActionOutput,
    crate::error::ApplyPendingMaintenanceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::apply_pending_maintenance_action_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_apply_pending_maintenance_action(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_replication_task_assessment_run_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelReplicationTaskAssessmentRunOutput,
    crate::error::CancelReplicationTaskAssessmentRunError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelReplicationTaskAssessmentRunError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CancelReplicationTaskAssessmentRunError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::CancelReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::CancelReplicationTaskAssessmentRunErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CancelReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::CancelReplicationTaskAssessmentRunError {
            meta: generic,
            kind:
                crate::error::CancelReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_resource_state_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CancelReplicationTaskAssessmentRunError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundFault" => crate::error::CancelReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::CancelReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CancelReplicationTaskAssessmentRunError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CancelReplicationTaskAssessmentRunError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_replication_task_assessment_run_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelReplicationTaskAssessmentRunOutput,
    crate::error::CancelReplicationTaskAssessmentRunError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::cancel_replication_task_assessment_run_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_replication_task_assessment_run(response.body().as_ref(), output).map_err(crate::error::CancelReplicationTaskAssessmentRunError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "S3AccessDeniedFault" => crate::error::CreateEndpointError {
            meta: generic,
            kind: crate::error::CreateEndpointErrorKind::S3AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::s3_access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_s3_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSubscriptionOutput,
    crate::error::CreateEventSubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "KMSAccessDeniedFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::KmsAccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSDisabledFault" => {
            crate::error::CreateEventSubscriptionError {
                meta: generic,
                kind: crate::error::CreateEventSubscriptionErrorKind::KmsDisabledFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::kms_disabled_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_kms_disabled_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "KMSInvalidStateFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::KmsInvalidStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSNotFoundFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::KmsNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSThrottlingFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::KmsThrottlingFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_throttling_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSInvalidTopicFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_invalid_topic_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_sns_invalid_topic_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSNoAuthorizationFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_no_authorization_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_sns_no_authorization_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSubscriptionOutput,
    crate::error::CreateEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationInstanceOutput,
    crate::error::CreateReplicationInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateReplicationInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::AccessDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientResourceCapacityFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::InsufficientResourceCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_resource_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_resource_capacity_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResourceStateFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::InvalidResourceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_subnet_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationSubnetGroupDoesNotCoverEnoughAZs" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replication_subnet_group_does_not_cover_enough_a_zs_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceAlreadyExistsFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::ResourceAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceQuotaExceededFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::ResourceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceededFault" => crate::error::CreateReplicationInstanceError { meta: generic, kind: crate::error::CreateReplicationInstanceErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_storage_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateReplicationInstanceError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationInstanceOutput,
    crate::error::CreateReplicationInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_replication_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_replication_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateReplicationInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationSubnetGroupOutput,
    crate::error::CreateReplicationSubnetGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateReplicationSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::CreateReplicationSubnetGroupError { meta: generic, kind: crate::error::CreateReplicationSubnetGroupErrorKind::AccessDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::CreateReplicationSubnetGroupError { meta: generic, kind: crate::error::CreateReplicationSubnetGroupErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_subnet_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationSubnetGroupDoesNotCoverEnoughAZs" => crate::error::CreateReplicationSubnetGroupError { meta: generic, kind: crate::error::CreateReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replication_subnet_group_does_not_cover_enough_a_zs_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceAlreadyExistsFault" => crate::error::CreateReplicationSubnetGroupError { meta: generic, kind: crate::error::CreateReplicationSubnetGroupErrorKind::ResourceAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundFault" => crate::error::CreateReplicationSubnetGroupError { meta: generic, kind: crate::error::CreateReplicationSubnetGroupErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceQuotaExceededFault" => crate::error::CreateReplicationSubnetGroupError { meta: generic, kind: crate::error::CreateReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateReplicationSubnetGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationSubnetGroupOutput,
    crate::error::CreateReplicationSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_replication_subnet_group_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_replication_subnet_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateReplicationSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationTaskOutput,
    crate::error::CreateReplicationTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReplicationTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateReplicationTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::CreateReplicationTaskError {
            meta: generic,
            kind: crate::error::CreateReplicationTaskErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::CreateReplicationTaskError {
            meta: generic,
            kind: crate::error::CreateReplicationTaskErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::CreateReplicationTaskError {
            meta: generic,
            kind: crate::error::CreateReplicationTaskErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::CreateReplicationTaskError {
            meta: generic,
            kind: crate::error::CreateReplicationTaskErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::CreateReplicationTaskError {
            meta: generic,
            kind: crate::error::CreateReplicationTaskErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::CreateReplicationTaskError {
            meta: generic,
            kind: crate::error::CreateReplicationTaskErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateReplicationTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationTaskOutput,
    crate::error::CreateReplicationTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_replication_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_replication_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateReplicationTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteCertificateOutput, crate::error::DeleteCertificateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DeleteCertificateError {
            meta: generic,
            kind: crate::error::DeleteCertificateErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteCertificateError {
            meta: generic,
            kind: crate::error::DeleteCertificateErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteCertificateOutput, crate::error::DeleteCertificateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteConnectionOutput, crate::error::DeleteConnectionError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteConnectionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::DeleteConnectionError {
            meta: generic,
            kind: crate::error::DeleteConnectionErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::DeleteConnectionError {
            meta: generic,
            kind: crate::error::DeleteConnectionErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteConnectionError {
            meta: generic,
            kind: crate::error::DeleteConnectionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteConnectionOutput, crate::error::DeleteConnectionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSubscriptionOutput,
    crate::error::DeleteEventSubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DeleteEventSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteEventSubscriptionErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteEventSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteEventSubscriptionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSubscriptionOutput,
    crate::error::DeleteEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationInstanceOutput,
    crate::error::DeleteReplicationInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReplicationInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteReplicationInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DeleteReplicationInstanceError {
            meta: generic,
            kind: crate::error::DeleteReplicationInstanceErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteReplicationInstanceError {
            meta: generic,
            kind: crate::error::DeleteReplicationInstanceErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReplicationInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationInstanceOutput,
    crate::error::DeleteReplicationInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_replication_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_replication_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteReplicationInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationSubnetGroupOutput,
    crate::error::DeleteReplicationSubnetGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReplicationSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteReplicationSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DeleteReplicationSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationSubnetGroupErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteReplicationSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteReplicationSubnetGroupErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReplicationSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationSubnetGroupOutput,
    crate::error::DeleteReplicationSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_replication_subnet_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationTaskOutput,
    crate::error::DeleteReplicationTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReplicationTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteReplicationTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DeleteReplicationTaskError {
            meta: generic,
            kind: crate::error::DeleteReplicationTaskErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DeleteReplicationTaskError {
            meta: generic,
            kind: crate::error::DeleteReplicationTaskErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReplicationTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationTaskOutput,
    crate::error::DeleteReplicationTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_replication_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_replication_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteReplicationTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_task_assessment_run_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationTaskAssessmentRunOutput,
    crate::error::DeleteReplicationTaskAssessmentRunError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReplicationTaskAssessmentRunError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteReplicationTaskAssessmentRunError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::DeleteReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::DeleteReplicationTaskAssessmentRunErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::DeleteReplicationTaskAssessmentRunError {
            meta: generic,
            kind:
                crate::error::DeleteReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_resource_state_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationTaskAssessmentRunError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundFault" => crate::error::DeleteReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::DeleteReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationTaskAssessmentRunError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteReplicationTaskAssessmentRunError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_task_assessment_run_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationTaskAssessmentRunOutput,
    crate::error::DeleteReplicationTaskAssessmentRunError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_replication_task_assessment_run_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_replication_task_assessment_run(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationTaskAssessmentRunError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
    Err(crate::error::DescribeAccountAttributesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_account_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_applicable_individual_assessments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeApplicableIndividualAssessmentsOutput,
    crate::error::DescribeApplicableIndividualAssessmentsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeApplicableIndividualAssessmentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeApplicableIndividualAssessmentsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::DescribeApplicableIndividualAssessmentsError { meta: generic, kind: crate::error::DescribeApplicableIndividualAssessmentsErrorKind::AccessDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeApplicableIndividualAssessmentsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResourceStateFault" => crate::error::DescribeApplicableIndividualAssessmentsError { meta: generic, kind: crate::error::DescribeApplicableIndividualAssessmentsErrorKind::InvalidResourceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeApplicableIndividualAssessmentsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundFault" => crate::error::DescribeApplicableIndividualAssessmentsError { meta: generic, kind: crate::error::DescribeApplicableIndividualAssessmentsErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeApplicableIndividualAssessmentsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeApplicableIndividualAssessmentsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_applicable_individual_assessments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeApplicableIndividualAssessmentsOutput,
    crate::error::DescribeApplicableIndividualAssessmentsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_applicable_individual_assessments_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_applicable_individual_assessments(response.body().as_ref(), output).map_err(crate::error::DescribeApplicableIndividualAssessmentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCertificatesOutput,
    crate::error::DescribeCertificatesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeCertificatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeCertificatesError {
            meta: generic,
            kind: crate::error::DescribeCertificatesErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCertificatesOutput,
    crate::error::DescribeCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_certificates_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_connections_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConnectionsOutput,
    crate::error::DescribeConnectionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConnectionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeConnectionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeConnectionsError {
            meta: generic,
            kind: crate::error::DescribeConnectionsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeConnectionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeConnectionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_connections_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConnectionsOutput,
    crate::error::DescribeConnectionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_connections_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_connections(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConnectionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointsOutput, crate::error::DescribeEndpointsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEndpointsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeEndpointsError {
            meta: generic,
            kind: crate::error::DescribeEndpointsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEndpointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointsOutput, crate::error::DescribeEndpointsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoints_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointSettingsOutput,
    crate::error::DescribeEndpointSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointSettingsError::unhandled)?;
    Err(crate::error::DescribeEndpointSettingsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointSettingsOutput,
    crate::error::DescribeEndpointSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoint_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_types_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointTypesOutput,
    crate::error::DescribeEndpointTypesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointTypesError::unhandled)?;
    Err(crate::error::DescribeEndpointTypesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_types_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointTypesOutput,
    crate::error::DescribeEndpointTypesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_types_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoint_types(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointTypesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_categories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventCategoriesOutput,
    crate::error::DescribeEventCategoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventCategoriesError::unhandled)?;
    Err(crate::error::DescribeEventCategoriesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_categories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventCategoriesOutput,
    crate::error::DescribeEventCategoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_categories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_event_categories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventCategoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventsError::unhandled)?;
    Err(crate::error::DescribeEventsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_events_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_subscriptions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventSubscriptionsOutput,
    crate::error::DescribeEventSubscriptionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEventSubscriptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeEventSubscriptionsError {
            meta: generic,
            kind: crate::error::DescribeEventSubscriptionsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEventSubscriptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_subscriptions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventSubscriptionsOutput,
    crate::error::DescribeEventSubscriptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_subscriptions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_event_subscriptions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_orderable_replication_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrderableReplicationInstancesOutput,
    crate::error::DescribeOrderableReplicationInstancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOrderableReplicationInstancesError::unhandled)?;
    Err(crate::error::DescribeOrderableReplicationInstancesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_orderable_replication_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrderableReplicationInstancesOutput,
    crate::error::DescribeOrderableReplicationInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_orderable_replication_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_orderable_replication_instances(response.body().as_ref(), output).map_err(crate::error::DescribeOrderableReplicationInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pending_maintenance_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePendingMaintenanceActionsOutput,
    crate::error::DescribePendingMaintenanceActionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePendingMaintenanceActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePendingMaintenanceActionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribePendingMaintenanceActionsError {
            meta: generic,
            kind: crate::error::DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePendingMaintenanceActionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribePendingMaintenanceActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pending_maintenance_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePendingMaintenanceActionsOutput,
    crate::error::DescribePendingMaintenanceActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_pending_maintenance_actions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_pending_maintenance_actions(response.body().as_ref(), output).map_err(crate::error::DescribePendingMaintenanceActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_refresh_schemas_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeRefreshSchemasStatusOutput,
    crate::error::DescribeRefreshSchemasStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRefreshSchemasStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeRefreshSchemasStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DescribeRefreshSchemasStatusError {
            meta: generic,
            kind: crate::error::DescribeRefreshSchemasStatusErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRefreshSchemasStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DescribeRefreshSchemasStatusError {
            meta: generic,
            kind: crate::error::DescribeRefreshSchemasStatusErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRefreshSchemasStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeRefreshSchemasStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_refresh_schemas_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeRefreshSchemasStatusOutput,
    crate::error::DescribeRefreshSchemasStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_refresh_schemas_status_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_refresh_schemas_status(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeRefreshSchemasStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationInstancesOutput,
    crate::error::DescribeReplicationInstancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReplicationInstancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeReplicationInstancesError {
            meta: generic,
            kind: crate::error::DescribeReplicationInstancesErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReplicationInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationInstancesOutput,
    crate::error::DescribeReplicationInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_replication_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_replication_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReplicationInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_instance_task_logs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationInstanceTaskLogsOutput,
    crate::error::DescribeReplicationInstanceTaskLogsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationInstanceTaskLogsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReplicationInstanceTaskLogsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DescribeReplicationInstanceTaskLogsError { meta: generic, kind: crate::error::DescribeReplicationInstanceTaskLogsErrorKind::InvalidResourceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationInstanceTaskLogsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundFault" => crate::error::DescribeReplicationInstanceTaskLogsError { meta: generic, kind: crate::error::DescribeReplicationInstanceTaskLogsErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationInstanceTaskLogsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReplicationInstanceTaskLogsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_instance_task_logs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationInstanceTaskLogsOutput,
    crate::error::DescribeReplicationInstanceTaskLogsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_replication_instance_task_logs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_replication_instance_task_logs(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationInstanceTaskLogsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_subnet_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationSubnetGroupsOutput,
    crate::error::DescribeReplicationSubnetGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationSubnetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeReplicationSubnetGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeReplicationSubnetGroupsError {
            meta: generic,
            kind: crate::error::DescribeReplicationSubnetGroupsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationSubnetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReplicationSubnetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_subnet_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationSubnetGroupsOutput,
    crate::error::DescribeReplicationSubnetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_replication_subnet_groups_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_replication_subnet_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeReplicationSubnetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_task_assessment_results_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTaskAssessmentResultsOutput,
    crate::error::DescribeReplicationTaskAssessmentResultsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationTaskAssessmentResultsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeReplicationTaskAssessmentResultsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeReplicationTaskAssessmentResultsError { meta: generic, kind: crate::error::DescribeReplicationTaskAssessmentResultsErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTaskAssessmentResultsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReplicationTaskAssessmentResultsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_task_assessment_results_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTaskAssessmentResultsOutput,
    crate::error::DescribeReplicationTaskAssessmentResultsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_replication_task_assessment_results_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_replication_task_assessment_results(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTaskAssessmentResultsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_task_assessment_runs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTaskAssessmentRunsOutput,
    crate::error::DescribeReplicationTaskAssessmentRunsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationTaskAssessmentRunsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeReplicationTaskAssessmentRunsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeReplicationTaskAssessmentRunsError {
            meta: generic,
            kind:
                crate::error::DescribeReplicationTaskAssessmentRunsErrorKind::ResourceNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTaskAssessmentRunsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeReplicationTaskAssessmentRunsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_task_assessment_runs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTaskAssessmentRunsOutput,
    crate::error::DescribeReplicationTaskAssessmentRunsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_replication_task_assessment_runs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_replication_task_assessment_runs(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTaskAssessmentRunsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_task_individual_assessments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTaskIndividualAssessmentsOutput,
    crate::error::DescribeReplicationTaskIndividualAssessmentsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationTaskIndividualAssessmentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeReplicationTaskIndividualAssessmentsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeReplicationTaskIndividualAssessmentsError { meta: generic, kind: crate::error::DescribeReplicationTaskIndividualAssessmentsErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTaskIndividualAssessmentsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReplicationTaskIndividualAssessmentsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_task_individual_assessments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTaskIndividualAssessmentsOutput,
    crate::error::DescribeReplicationTaskIndividualAssessmentsError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::describe_replication_task_individual_assessments_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_replication_task_individual_assessments(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTaskIndividualAssessmentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTasksOutput,
    crate::error::DescribeReplicationTasksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReplicationTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReplicationTasksError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribeReplicationTasksError {
            meta: generic,
            kind: crate::error::DescribeReplicationTasksErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReplicationTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReplicationTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_replication_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReplicationTasksOutput,
    crate::error::DescribeReplicationTasksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_replication_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_replication_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReplicationTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_schemas_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSchemasOutput, crate::error::DescribeSchemasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSchemasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSchemasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DescribeSchemasError {
            meta: generic,
            kind: crate::error::DescribeSchemasErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSchemasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DescribeSchemasError {
            meta: generic,
            kind: crate::error::DescribeSchemasErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeSchemasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSchemasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_schemas_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeSchemasOutput, crate::error::DescribeSchemasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_schemas_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_schemas(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSchemasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_statistics_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTableStatisticsOutput,
    crate::error::DescribeTableStatisticsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTableStatisticsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTableStatisticsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::DescribeTableStatisticsError {
            meta: generic,
            kind: crate::error::DescribeTableStatisticsErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableStatisticsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::DescribeTableStatisticsError {
            meta: generic,
            kind: crate::error::DescribeTableStatisticsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableStatisticsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTableStatisticsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_statistics_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTableStatisticsOutput,
    crate::error::DescribeTableStatisticsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_table_statistics_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_table_statistics(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTableStatisticsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportCertificateOutput, crate::error::ImportCertificateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidCertificateFault" => crate::error::ImportCertificateError {
            meta: generic,
            kind: crate::error::ImportCertificateErrorKind::InvalidCertificateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_certificate_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_certificate_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ImportCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::ImportCertificateError {
            meta: generic,
            kind: crate::error::ImportCertificateErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ImportCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::ImportCertificateError {
            meta: generic,
            kind: crate::error::ImportCertificateErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ImportCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportCertificateOutput, crate::error::ImportCertificateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_import_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyEndpointOutput, crate::error::ModifyEndpointError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::ModifyEndpointError {
            meta: generic,
            kind: crate::error::ModifyEndpointErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::ModifyEndpointError {
            meta: generic,
            kind: crate::error::ModifyEndpointErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::ModifyEndpointError {
            meta: generic,
            kind: crate::error::ModifyEndpointErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::ModifyEndpointError {
            meta: generic,
            kind: crate::error::ModifyEndpointErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::ModifyEndpointError {
            meta: generic,
            kind: crate::error::ModifyEndpointErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyEndpointOutput, crate::error::ModifyEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_modify_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEventSubscriptionOutput,
    crate::error::ModifyEventSubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "KMSAccessDeniedFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::KmsAccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSDisabledFault" => {
            crate::error::ModifyEventSubscriptionError {
                meta: generic,
                kind: crate::error::ModifyEventSubscriptionErrorKind::KmsDisabledFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::kms_disabled_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_kms_disabled_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "KMSInvalidStateFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::KmsInvalidStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSNotFoundFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::KmsNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSThrottlingFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::KmsThrottlingFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_throttling_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSInvalidTopicFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_invalid_topic_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_sns_invalid_topic_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSNoAuthorizationFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_no_authorization_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_sns_no_authorization_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEventSubscriptionOutput,
    crate::error::ModifyEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_modify_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationInstanceOutput,
    crate::error::ModifyReplicationInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyReplicationInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind: crate::error::ModifyReplicationInstanceErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientResourceCapacityFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind:
                crate::error::ModifyReplicationInstanceErrorKind::InsufficientResourceCapacityFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::insufficient_resource_capacity_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_insufficient_resource_capacity_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidResourceStateFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind: crate::error::ModifyReplicationInstanceErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind: crate::error::ModifyReplicationInstanceErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind: crate::error::ModifyReplicationInstanceErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageQuotaExceededFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind: crate::error::ModifyReplicationInstanceErrorKind::StorageQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_storage_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UpgradeDependencyFailureFault" => crate::error::ModifyReplicationInstanceError {
            meta: generic,
            kind: crate::error::ModifyReplicationInstanceErrorKind::UpgradeDependencyFailureFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::upgrade_dependency_failure_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_upgrade_dependency_failure_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ModifyReplicationInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationInstanceOutput,
    crate::error::ModifyReplicationInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_replication_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_modify_replication_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyReplicationInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationSubnetGroupOutput,
    crate::error::ModifyReplicationSubnetGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyReplicationSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::ModifyReplicationSubnetGroupError { meta: generic, kind: crate::error::ModifyReplicationSubnetGroupErrorKind::AccessDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::ModifyReplicationSubnetGroupError { meta: generic, kind: crate::error::ModifyReplicationSubnetGroupErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_subnet_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationSubnetGroupDoesNotCoverEnoughAZs" => crate::error::ModifyReplicationSubnetGroupError { meta: generic, kind: crate::error::ModifyReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replication_subnet_group_does_not_cover_enough_a_zs_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundFault" => crate::error::ModifyReplicationSubnetGroupError { meta: generic, kind: crate::error::ModifyReplicationSubnetGroupErrorKind::ResourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceQuotaExceededFault" => crate::error::ModifyReplicationSubnetGroupError { meta: generic, kind: crate::error::ModifyReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SubnetAlreadyInUse" => crate::error::ModifyReplicationSubnetGroupError { meta: generic, kind: crate::error::ModifyReplicationSubnetGroupErrorKind::SubnetAlreadyInUse({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::subnet_already_in_use::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_subnet_already_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyReplicationSubnetGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationSubnetGroupOutput,
    crate::error::ModifyReplicationSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_replication_subnet_group_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_modify_replication_subnet_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ModifyReplicationSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationTaskOutput,
    crate::error::ModifyReplicationTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyReplicationTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyReplicationTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::ModifyReplicationTaskError {
            meta: generic,
            kind: crate::error::ModifyReplicationTaskErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::ModifyReplicationTaskError {
            meta: generic,
            kind: crate::error::ModifyReplicationTaskErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::ModifyReplicationTaskError {
            meta: generic,
            kind: crate::error::ModifyReplicationTaskErrorKind::ResourceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::ModifyReplicationTaskError {
            meta: generic,
            kind: crate::error::ModifyReplicationTaskErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyReplicationTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_replication_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyReplicationTaskOutput,
    crate::error::ModifyReplicationTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_replication_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_modify_replication_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyReplicationTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_move_replication_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::MoveReplicationTaskOutput,
    crate::error::MoveReplicationTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::MoveReplicationTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::MoveReplicationTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::MoveReplicationTaskError {
            meta: generic,
            kind: crate::error::MoveReplicationTaskErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::MoveReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::MoveReplicationTaskError {
            meta: generic,
            kind: crate::error::MoveReplicationTaskErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::MoveReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::MoveReplicationTaskError {
            meta: generic,
            kind: crate::error::MoveReplicationTaskErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::MoveReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::MoveReplicationTaskError {
            meta: generic,
            kind: crate::error::MoveReplicationTaskErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::MoveReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::MoveReplicationTaskError {
            meta: generic,
            kind: crate::error::MoveReplicationTaskErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::MoveReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::MoveReplicationTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_move_replication_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::MoveReplicationTaskOutput,
    crate::error::MoveReplicationTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::move_replication_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_move_replication_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::MoveReplicationTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_replication_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebootReplicationInstanceOutput,
    crate::error::RebootReplicationInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootReplicationInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RebootReplicationInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::RebootReplicationInstanceError {
            meta: generic,
            kind: crate::error::RebootReplicationInstanceErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RebootReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::RebootReplicationInstanceError {
            meta: generic,
            kind: crate::error::RebootReplicationInstanceErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RebootReplicationInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootReplicationInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_replication_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebootReplicationInstanceOutput,
    crate::error::RebootReplicationInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_replication_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reboot_replication_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootReplicationInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_refresh_schemas_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RefreshSchemasOutput, crate::error::RefreshSchemasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RefreshSchemasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RefreshSchemasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::RefreshSchemasError {
            meta: generic,
            kind: crate::error::RefreshSchemasErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RefreshSchemasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::RefreshSchemasError {
            meta: generic,
            kind: crate::error::RefreshSchemasErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RefreshSchemasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::RefreshSchemasError {
            meta: generic,
            kind: crate::error::RefreshSchemasErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RefreshSchemasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::RefreshSchemasError {
            meta: generic,
            kind: crate::error::RefreshSchemasErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RefreshSchemasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RefreshSchemasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_refresh_schemas_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RefreshSchemasOutput, crate::error::RefreshSchemasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::refresh_schemas_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_refresh_schemas(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RefreshSchemasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reload_tables_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReloadTablesOutput, crate::error::ReloadTablesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReloadTablesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReloadTablesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::ReloadTablesError {
            meta: generic,
            kind: crate::error::ReloadTablesErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ReloadTablesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::ReloadTablesError {
            meta: generic,
            kind: crate::error::ReloadTablesErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::ReloadTablesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReloadTablesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reload_tables_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReloadTablesOutput, crate::error::ReloadTablesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reload_tables_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reload_tables(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReloadTablesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveTagsFromResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsFromResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_from_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_replication_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartReplicationTaskOutput,
    crate::error::StartReplicationTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartReplicationTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartReplicationTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::StartReplicationTaskError {
            meta: generic,
            kind: crate::error::StartReplicationTaskErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::StartReplicationTaskError {
            meta: generic,
            kind: crate::error::StartReplicationTaskErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::StartReplicationTaskError {
            meta: generic,
            kind: crate::error::StartReplicationTaskErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartReplicationTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_replication_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartReplicationTaskOutput,
    crate::error::StartReplicationTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_replication_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_replication_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartReplicationTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_replication_task_assessment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartReplicationTaskAssessmentOutput,
    crate::error::StartReplicationTaskAssessmentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartReplicationTaskAssessmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartReplicationTaskAssessmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::StartReplicationTaskAssessmentError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentErrorKind::InvalidResourceStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_resource_state_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundFault" => crate::error::StartReplicationTaskAssessmentError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartReplicationTaskAssessmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_replication_task_assessment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartReplicationTaskAssessmentOutput,
    crate::error::StartReplicationTaskAssessmentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_replication_task_assessment_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_replication_task_assessment(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartReplicationTaskAssessmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_replication_task_assessment_run_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartReplicationTaskAssessmentRunOutput,
    crate::error::StartReplicationTaskAssessmentRunError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartReplicationTaskAssessmentRunError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind:
                crate::error::StartReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_resource_state_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "KMSAccessDeniedFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsAccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSDisabledFault" => {
            crate::error::StartReplicationTaskAssessmentRunError {
                meta: generic,
                kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsDisabledFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::kms_disabled_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_kms_disabled_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "KMSFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_fault_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsInvalidStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind:
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsKeyNotAccessibleFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::kms_key_not_accessible_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "KMSNotFoundFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExistsFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind:
                crate::error::StartReplicationTaskAssessmentRunErrorKind::ResourceAlreadyExistsFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_already_exists_fault::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_already_exists_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "S3AccessDeniedFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::S3AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::s3_access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_s3_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "S3ResourceNotFoundFault" => crate::error::StartReplicationTaskAssessmentRunError {
            meta: generic,
            kind: crate::error::StartReplicationTaskAssessmentRunErrorKind::S3ResourceNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::s3_resource_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_s3_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::StartReplicationTaskAssessmentRunError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_replication_task_assessment_run_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartReplicationTaskAssessmentRunOutput,
    crate::error::StartReplicationTaskAssessmentRunError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_replication_task_assessment_run_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_replication_task_assessment_run(response.body().as_ref(), output).map_err(crate::error::StartReplicationTaskAssessmentRunError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_replication_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopReplicationTaskOutput,
    crate::error::StopReplicationTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopReplicationTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopReplicationTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceStateFault" => crate::error::StopReplicationTaskError {
            meta: generic,
            kind: crate::error::StopReplicationTaskErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StopReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::StopReplicationTaskError {
            meta: generic,
            kind: crate::error::StopReplicationTaskErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::StopReplicationTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopReplicationTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_replication_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopReplicationTaskOutput,
    crate::error::StopReplicationTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_replication_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_replication_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopReplicationTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestConnectionOutput, crate::error::TestConnectionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TestConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TestConnectionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedFault" => crate::error::TestConnectionError {
            meta: generic,
            kind: crate::error::TestConnectionErrorKind::AccessDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_fault_json_err(response.body().as_ref(), output).map_err(crate::error::TestConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceStateFault" => crate::error::TestConnectionError {
            meta: generic,
            kind: crate::error::TestConnectionErrorKind::InvalidResourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_state_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_state_fault_json_err(response.body().as_ref(), output).map_err(crate::error::TestConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::TestConnectionError {
            meta: generic,
            kind: crate::error::TestConnectionErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_accessible_fault_json_err(response.body().as_ref(), output).map_err(crate::error::TestConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::TestConnectionError {
            meta: generic,
            kind: crate::error::TestConnectionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_fault_json_err(response.body().as_ref(), output).map_err(crate::error::TestConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceQuotaExceededFault" => crate::error::TestConnectionError {
            meta: generic,
            kind: crate::error::TestConnectionErrorKind::ResourceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_quota_exceeded_fault_json_err(response.body().as_ref(), output).map_err(crate::error::TestConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TestConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestConnectionOutput, crate::error::TestConnectionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::test_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_test_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TestConnectionError::unhandled)?;
        output.build()
    })
}
